/* ------------------------------------------------------------------------

   unicodedatabase -- The Unicode 3.0 data base.

   Data was extracted from the Unicode 3.0 UnicodeData.txt file.

Written by Marc-Andre Lemburg (mal@lemburg.com).

Copyright (c) Corporation for National Research Initiatives.

   ------------------------------------------------------------------------ */

#include "unicodedatabase.h"

/* --- Unicode category names --------------------------------------------- */

const char *_PyUnicode_CategoryNames[32] = {

    "Cn", /*  Not assigned (also see below) */

    /* Normative Categories */

    "Lu", /* Letter, Uppercase */
    "Ll", /* Letter, Lowercase */
    "Lt", /* Letter, Titlecase */
    "Mn", /* Mark, Non-Spacing */
    "Mc", /* Mark, Spacing Combining */
    "Me", /* Mark, Enclosing */
    "Nd", /* Number, Decimal Digit */
    "Nl", /* Number, Letter */
    "No", /* Number, Other */
    "Zs", /* Separator, Space */
    "Zl", /* Separator, Line */
    "Zp", /* Separator, Paragraph */
    "Cc", /* Other, Control */
    "Cf", /* Other, Format */
    "Cs", /* Other, Surrogate */
    "Co", /* Other, Private Use */
    "Cn", /* Other, Not Assigned (no characters in the file
	     have this property) */

     /* Informative Categories */

    "Lm", /* Letter, Modifier */
    "Lo", /* Letter, Other */
    "Pc", /* Punctuation, Connector */
    "Pd", /* Punctuation, Dash */
    "Ps", /* Punctuation, Open */
    "Pe", /* Punctuation, Close */
    "Pi", /* Punctuation, Initial quote (may behave like Ps or Pe 
	     depending on usage) */
    "Pf", /* Punctuation, Final quote (may behave like Ps or Pe 
	     depending on usage) */
    "Po", /* Punctuation, Other */
    "Sm", /* Symbol, Math */
    "Sc", /* Symbol, Currency */
    "Sk", /* Symbol, Modifier */
    "So", /* Symbol, Other */

    0  /* Sentinel */
};

const char *_PyUnicode_BidirectionalNames[21] = {

    "",	 /*  Undefined (added so that the 0 index maps to undefined) */
    
    "L", /* Left-to-Right */
    "LRE", /* Left-to-Right Embedding */
    "LRO", /* Left-to-Right Override */
    "R", /* Right-to-Left */
    "AL", /* Right-to-Left Arabic */
    "RLE", /* Right-to-Left Embedding */
    "RLO", /* Right-to-Left Override */
    "PDF", /* Pop Directional Format */
    "EN", /* European Number */
    "ES", /* European Number Separator */
    "ET", /* European Number Terminator */
    "AN", /* Arabic Number */
    "CS", /* Common Number Separator */
    "NSM", /* Non-Spacing Mark */
    "BN", /* Boundary Neutral */
    "B", /* Paragraph Separator */
    "S", /* Segment Separator */
    "WS", /* Whitespace */
    "ON", /* Other Neutrals */
    
    0  /* Sentinel */
};

/* --- Unicode Database Pages --------------------------------------------- */

const _PyUnicode_DatabaseRecord _PyUnicode_Database_0[4096] = {
    
/* U+0000 */ { 13, 0, 15, 0, 0 },
/* U+0001 */ { 13, 0, 15, 0, 0 },
/* U+0002 */ { 13, 0, 15, 0, 0 },
/* U+0003 */ { 13, 0, 15, 0, 0 },
/* U+0004 */ { 13, 0, 15, 0, 0 },
/* U+0005 */ { 13, 0, 15, 0, 0 },
/* U+0006 */ { 13, 0, 15, 0, 0 },
/* U+0007 */ { 13, 0, 15, 0, 0 },
/* U+0008 */ { 13, 0, 15, 0, 0 },
/* U+0009 */ { 13, 0, 17, 0, 0 },
/* U+000a */ { 13, 0, 16, 0, 0 },
/* U+000b */ { 13, 0, 17, 0, 0 },
/* U+000c */ { 13, 0, 18, 0, 0 },
/* U+000d */ { 13, 0, 16, 0, 0 },
/* U+000e */ { 13, 0, 15, 0, 0 },
/* U+000f */ { 13, 0, 15, 0, 0 },
/* U+0010 */ { 13, 0, 15, 0, 0 },
/* U+0011 */ { 13, 0, 15, 0, 0 },
/* U+0012 */ { 13, 0, 15, 0, 0 },
/* U+0013 */ { 13, 0, 15, 0, 0 },
/* U+0014 */ { 13, 0, 15, 0, 0 },
/* U+0015 */ { 13, 0, 15, 0, 0 },
/* U+0016 */ { 13, 0, 15, 0, 0 },
/* U+0017 */ { 13, 0, 15, 0, 0 },
/* U+0018 */ { 13, 0, 15, 0, 0 },
/* U+0019 */ { 13, 0, 15, 0, 0 },
/* U+001a */ { 13, 0, 15, 0, 0 },
/* U+001b */ { 13, 0, 15, 0, 0 },
/* U+001c */ { 13, 0, 16, 0, 0 },
/* U+001d */ { 13, 0, 16, 0, 0 },
/* U+001e */ { 13, 0, 16, 0, 0 },
/* U+001f */ { 13, 0, 17, 0, 0 },
/* U+0020 */ { 10, 0, 18, 0, 0 },
/* U+0021 */ { 26, 0, 19, 0, 0 },
/* U+0022 */ { 26, 0, 19, 0, 0 },
/* U+0023 */ { 26, 0, 11, 0, 0 },
/* U+0024 */ { 28, 0, 11, 0, 0 },
/* U+0025 */ { 26, 0, 11, 0, 0 },
/* U+0026 */ { 26, 0, 19, 0, 0 },
/* U+0027 */ { 26, 0, 19, 0, 0 },
/* U+0028 */ { 22, 0, 19, 1, 0 },
/* U+0029 */ { 23, 0, 19, 1, 0 },
/* U+002a */ { 26, 0, 19, 0, 0 },
/* U+002b */ { 27, 0, 11, 0, 0 },
/* U+002c */ { 26, 0, 13, 0, 0 },
/* U+002d */ { 21, 0, 11, 0, 0 },
/* U+002e */ { 26, 0, 13, 0, 0 },
/* U+002f */ { 26, 0, 10, 0, 0 },
/* U+0030 */ { 7, 0, 9, 0, 0 },
/* U+0031 */ { 7, 0, 9, 0, 0 },
/* U+0032 */ { 7, 0, 9, 0, 0 },
/* U+0033 */ { 7, 0, 9, 0, 0 },
/* U+0034 */ { 7, 0, 9, 0, 0 },
/* U+0035 */ { 7, 0, 9, 0, 0 },
/* U+0036 */ { 7, 0, 9, 0, 0 },
/* U+0037 */ { 7, 0, 9, 0, 0 },
/* U+0038 */ { 7, 0, 9, 0, 0 },
/* U+0039 */ { 7, 0, 9, 0, 0 },
/* U+003a */ { 26, 0, 13, 0, 0 },
/* U+003b */ { 26, 0, 19, 0, 0 },
/* U+003c */ { 27, 0, 19, 1, 0 },
/* U+003d */ { 27, 0, 19, 0, 0 },
/* U+003e */ { 27, 0, 19, 1, 0 },
/* U+003f */ { 26, 0, 19, 0, 0 },
/* U+0040 */ { 26, 0, 19, 0, 0 },
/* U+0041 */ { 1, 0, 1, 0, 0 },
/* U+0042 */ { 1, 0, 1, 0, 0 },
/* U+0043 */ { 1, 0, 1, 0, 0 },
/* U+0044 */ { 1, 0, 1, 0, 0 },
/* U+0045 */ { 1, 0, 1, 0, 0 },
/* U+0046 */ { 1, 0, 1, 0, 0 },
/* U+0047 */ { 1, 0, 1, 0, 0 },
/* U+0048 */ { 1, 0, 1, 0, 0 },
/* U+0049 */ { 1, 0, 1, 0, 0 },
/* U+004a */ { 1, 0, 1, 0, 0 },
/* U+004b */ { 1, 0, 1, 0, 0 },
/* U+004c */ { 1, 0, 1, 0, 0 },
/* U+004d */ { 1, 0, 1, 0, 0 },
/* U+004e */ { 1, 0, 1, 0, 0 },
/* U+004f */ { 1, 0, 1, 0, 0 },
/* U+0050 */ { 1, 0, 1, 0, 0 },
/* U+0051 */ { 1, 0, 1, 0, 0 },
/* U+0052 */ { 1, 0, 1, 0, 0 },
/* U+0053 */ { 1, 0, 1, 0, 0 },
/* U+0054 */ { 1, 0, 1, 0, 0 },
/* U+0055 */ { 1, 0, 1, 0, 0 },
/* U+0056 */ { 1, 0, 1, 0, 0 },
/* U+0057 */ { 1, 0, 1, 0, 0 },
/* U+0058 */ { 1, 0, 1, 0, 0 },
/* U+0059 */ { 1, 0, 1, 0, 0 },
/* U+005a */ { 1, 0, 1, 0, 0 },
/* U+005b */ { 22, 0, 19, 1, 0 },
/* U+005c */ { 26, 0, 19, 0, 0 },
/* U+005d */ { 23, 0, 19, 1, 0 },
/* U+005e */ { 29, 0, 19, 0, 0 },
/* U+005f */ { 20, 0, 19, 0, 0 },
/* U+0060 */ { 29, 0, 19, 0, 0 },
/* U+0061 */ { 2, 0, 1, 0, 0 },
/* U+0062 */ { 2, 0, 1, 0, 0 },
/* U+0063 */ { 2, 0, 1, 0, 0 },
/* U+0064 */ { 2, 0, 1, 0, 0 },
/* U+0065 */ { 2, 0, 1, 0, 0 },
/* U+0066 */ { 2, 0, 1, 0, 0 },
/* U+0067 */ { 2, 0, 1, 0, 0 },
/* U+0068 */ { 2, 0, 1, 0, 0 },
/* U+0069 */ { 2, 0, 1, 0, 0 },
/* U+006a */ { 2, 0, 1, 0, 0 },
/* U+006b */ { 2, 0, 1, 0, 0 },
/* U+006c */ { 2, 0, 1, 0, 0 },
/* U+006d */ { 2, 0, 1, 0, 0 },
/* U+006e */ { 2, 0, 1, 0, 0 },
/* U+006f */ { 2, 0, 1, 0, 0 },
/* U+0070 */ { 2, 0, 1, 0, 0 },
/* U+0071 */ { 2, 0, 1, 0, 0 },
/* U+0072 */ { 2, 0, 1, 0, 0 },
/* U+0073 */ { 2, 0, 1, 0, 0 },
/* U+0074 */ { 2, 0, 1, 0, 0 },
/* U+0075 */ { 2, 0, 1, 0, 0 },
/* U+0076 */ { 2, 0, 1, 0, 0 },
/* U+0077 */ { 2, 0, 1, 0, 0 },
/* U+0078 */ { 2, 0, 1, 0, 0 },
/* U+0079 */ { 2, 0, 1, 0, 0 },
/* U+007a */ { 2, 0, 1, 0, 0 },
/* U+007b */ { 22, 0, 19, 1, 0 },
/* U+007c */ { 27, 0, 19, 0, 0 },
/* U+007d */ { 23, 0, 19, 1, 0 },
/* U+007e */ { 27, 0, 19, 0, 0 },
/* U+007f */ { 13, 0, 15, 0, 0 },
/* U+0080 */ { 13, 0, 15, 0, 0 },
/* U+0081 */ { 13, 0, 15, 0, 0 },
/* U+0082 */ { 13, 0, 15, 0, 0 },
/* U+0083 */ { 13, 0, 15, 0, 0 },
/* U+0084 */ { 13, 0, 15, 0, 0 },
/* U+0085 */ { 13, 0, 16, 0, 0 },
/* U+0086 */ { 13, 0, 15, 0, 0 },
/* U+0087 */ { 13, 0, 15, 0, 0 },
/* U+0088 */ { 13, 0, 15, 0, 0 },
/* U+0089 */ { 13, 0, 15, 0, 0 },
/* U+008a */ { 13, 0, 15, 0, 0 },
/* U+008b */ { 13, 0, 15, 0, 0 },
/* U+008c */ { 13, 0, 15, 0, 0 },
/* U+008d */ { 13, 0, 15, 0, 0 },
/* U+008e */ { 13, 0, 15, 0, 0 },
/* U+008f */ { 13, 0, 15, 0, 0 },
/* U+0090 */ { 13, 0, 15, 0, 0 },
/* U+0091 */ { 13, 0, 15, 0, 0 },
/* U+0092 */ { 13, 0, 15, 0, 0 },
/* U+0093 */ { 13, 0, 15, 0, 0 },
/* U+0094 */ { 13, 0, 15, 0, 0 },
/* U+0095 */ { 13, 0, 15, 0, 0 },
/* U+0096 */ { 13, 0, 15, 0, 0 },
/* U+0097 */ { 13, 0, 15, 0, 0 },
/* U+0098 */ { 13, 0, 15, 0, 0 },
/* U+0099 */ { 13, 0, 15, 0, 0 },
/* U+009a */ { 13, 0, 15, 0, 0 },
/* U+009b */ { 13, 0, 15, 0, 0 },
/* U+009c */ { 13, 0, 15, 0, 0 },
/* U+009d */ { 13, 0, 15, 0, 0 },
/* U+009e */ { 13, 0, 15, 0, 0 },
/* U+009f */ { 13, 0, 15, 0, 0 },
/* U+00a0 */ { 10, 0, 13, 0, "<noBreak> 0020" },
/* U+00a1 */ { 26, 0, 19, 0, 0 },
/* U+00a2 */ { 28, 0, 11, 0, 0 },
/* U+00a3 */ { 28, 0, 11, 0, 0 },
/* U+00a4 */ { 28, 0, 11, 0, 0 },
/* U+00a5 */ { 28, 0, 11, 0, 0 },
/* U+00a6 */ { 30, 0, 19, 0, 0 },
/* U+00a7 */ { 30, 0, 19, 0, 0 },
/* U+00a8 */ { 29, 0, 19, 0, "<compat> 0020 0308" },
/* U+00a9 */ { 30, 0, 19, 0, 0 },
/* U+00aa */ { 2, 0, 1, 0, "<super> 0061" },
/* U+00ab */ { 24, 0, 19, 1, 0 },
/* U+00ac */ { 27, 0, 19, 0, 0 },
/* U+00ad */ { 21, 0, 19, 0, 0 },
/* U+00ae */ { 30, 0, 19, 0, 0 },
/* U+00af */ { 29, 0, 19, 0, "<compat> 0020 0304" },
/* U+00b0 */ { 30, 0, 11, 0, 0 },
/* U+00b1 */ { 27, 0, 11, 0, 0 },
/* U+00b2 */ { 9, 0, 9, 0, "<super> 0032" },
/* U+00b3 */ { 9, 0, 9, 0, "<super> 0033" },
/* U+00b4 */ { 29, 0, 19, 0, "<compat> 0020 0301" },
/* U+00b5 */ { 2, 0, 1, 0, "<compat> 03BC" },
/* U+00b6 */ { 30, 0, 19, 0, 0 },
/* U+00b7 */ { 26, 0, 19, 0, 0 },
/* U+00b8 */ { 29, 0, 19, 0, "<compat> 0020 0327" },
/* U+00b9 */ { 9, 0, 9, 0, "<super> 0031" },
/* U+00ba */ { 2, 0, 1, 0, "<super> 006F" },
/* U+00bb */ { 25, 0, 19, 1, 0 },
/* U+00bc */ { 9, 0, 19, 0, "<fraction> 0031 2044 0034" },
/* U+00bd */ { 9, 0, 19, 0, "<fraction> 0031 2044 0032" },
/* U+00be */ { 9, 0, 19, 0, "<fraction> 0033 2044 0034" },
/* U+00bf */ { 26, 0, 19, 0, 0 },
/* U+00c0 */ { 1, 0, 1, 0, "0041 0300" },
/* U+00c1 */ { 1, 0, 1, 0, "0041 0301" },
/* U+00c2 */ { 1, 0, 1, 0, "0041 0302" },
/* U+00c3 */ { 1, 0, 1, 0, "0041 0303" },
/* U+00c4 */ { 1, 0, 1, 0, "0041 0308" },
/* U+00c5 */ { 1, 0, 1, 0, "0041 030A" },
/* U+00c6 */ { 1, 0, 1, 0, 0 },
/* U+00c7 */ { 1, 0, 1, 0, "0043 0327" },
/* U+00c8 */ { 1, 0, 1, 0, "0045 0300" },
/* U+00c9 */ { 1, 0, 1, 0, "0045 0301" },
/* U+00ca */ { 1, 0, 1, 0, "0045 0302" },
/* U+00cb */ { 1, 0, 1, 0, "0045 0308" },
/* U+00cc */ { 1, 0, 1, 0, "0049 0300" },
/* U+00cd */ { 1, 0, 1, 0, "0049 0301" },
/* U+00ce */ { 1, 0, 1, 0, "0049 0302" },
/* U+00cf */ { 1, 0, 1, 0, "0049 0308" },
/* U+00d0 */ { 1, 0, 1, 0, 0 },
/* U+00d1 */ { 1, 0, 1, 0, "004E 0303" },
/* U+00d2 */ { 1, 0, 1, 0, "004F 0300" },
/* U+00d3 */ { 1, 0, 1, 0, "004F 0301" },
/* U+00d4 */ { 1, 0, 1, 0, "004F 0302" },
/* U+00d5 */ { 1, 0, 1, 0, "004F 0303" },
/* U+00d6 */ { 1, 0, 1, 0, "004F 0308" },
/* U+00d7 */ { 27, 0, 19, 0, 0 },
/* U+00d8 */ { 1, 0, 1, 0, 0 },
/* U+00d9 */ { 1, 0, 1, 0, "0055 0300" },
/* U+00da */ { 1, 0, 1, 0, "0055 0301" },
/* U+00db */ { 1, 0, 1, 0, "0055 0302" },
/* U+00dc */ { 1, 0, 1, 0, "0055 0308" },
/* U+00dd */ { 1, 0, 1, 0, "0059 0301" },
/* U+00de */ { 1, 0, 1, 0, 0 },
/* U+00df */ { 2, 0, 1, 0, 0 },
/* U+00e0 */ { 2, 0, 1, 0, "0061 0300" },
/* U+00e1 */ { 2, 0, 1, 0, "0061 0301" },
/* U+00e2 */ { 2, 0, 1, 0, "0061 0302" },
/* U+00e3 */ { 2, 0, 1, 0, "0061 0303" },
/* U+00e4 */ { 2, 0, 1, 0, "0061 0308" },
/* U+00e5 */ { 2, 0, 1, 0, "0061 030A" },
/* U+00e6 */ { 2, 0, 1, 0, 0 },
/* U+00e7 */ { 2, 0, 1, 0, "0063 0327" },
/* U+00e8 */ { 2, 0, 1, 0, "0065 0300" },
/* U+00e9 */ { 2, 0, 1, 0, "0065 0301" },
/* U+00ea */ { 2, 0, 1, 0, "0065 0302" },
/* U+00eb */ { 2, 0, 1, 0, "0065 0308" },
/* U+00ec */ { 2, 0, 1, 0, "0069 0300" },
/* U+00ed */ { 2, 0, 1, 0, "0069 0301" },
/* U+00ee */ { 2, 0, 1, 0, "0069 0302" },
/* U+00ef */ { 2, 0, 1, 0, "0069 0308" },
/* U+00f0 */ { 2, 0, 1, 0, 0 },
/* U+00f1 */ { 2, 0, 1, 0, "006E 0303" },
/* U+00f2 */ { 2, 0, 1, 0, "006F 0300" },
/* U+00f3 */ { 2, 0, 1, 0, "006F 0301" },
/* U+00f4 */ { 2, 0, 1, 0, "006F 0302" },
/* U+00f5 */ { 2, 0, 1, 0, "006F 0303" },
/* U+00f6 */ { 2, 0, 1, 0, "006F 0308" },
/* U+00f7 */ { 27, 0, 19, 0, 0 },
/* U+00f8 */ { 2, 0, 1, 0, 0 },
/* U+00f9 */ { 2, 0, 1, 0, "0075 0300" },
/* U+00fa */ { 2, 0, 1, 0, "0075 0301" },
/* U+00fb */ { 2, 0, 1, 0, "0075 0302" },
/* U+00fc */ { 2, 0, 1, 0, "0075 0308" },
/* U+00fd */ { 2, 0, 1, 0, "0079 0301" },
/* U+00fe */ { 2, 0, 1, 0, 0 },
/* U+00ff */ { 2, 0, 1, 0, "0079 0308" },
/* U+0100 */ { 1, 0, 1, 0, "0041 0304" },
/* U+0101 */ { 2, 0, 1, 0, "0061 0304" },
/* U+0102 */ { 1, 0, 1, 0, "0041 0306" },
/* U+0103 */ { 2, 0, 1, 0, "0061 0306" },
/* U+0104 */ { 1, 0, 1, 0, "0041 0328" },
/* U+0105 */ { 2, 0, 1, 0, "0061 0328" },
/* U+0106 */ { 1, 0, 1, 0, "0043 0301" },
/* U+0107 */ { 2, 0, 1, 0, "0063 0301" },
/* U+0108 */ { 1, 0, 1, 0, "0043 0302" },
/* U+0109 */ { 2, 0, 1, 0, "0063 0302" },
/* U+010a */ { 1, 0, 1, 0, "0043 0307" },
/* U+010b */ { 2, 0, 1, 0, "0063 0307" },
/* U+010c */ { 1, 0, 1, 0, "0043 030C" },
/* U+010d */ { 2, 0, 1, 0, "0063 030C" },
/* U+010e */ { 1, 0, 1, 0, "0044 030C" },
/* U+010f */ { 2, 0, 1, 0, "0064 030C" },
/* U+0110 */ { 1, 0, 1, 0, 0 },
/* U+0111 */ { 2, 0, 1, 0, 0 },
/* U+0112 */ { 1, 0, 1, 0, "0045 0304" },
/* U+0113 */ { 2, 0, 1, 0, "0065 0304" },
/* U+0114 */ { 1, 0, 1, 0, "0045 0306" },
/* U+0115 */ { 2, 0, 1, 0, "0065 0306" },
/* U+0116 */ { 1, 0, 1, 0, "0045 0307" },
/* U+0117 */ { 2, 0, 1, 0, "0065 0307" },
/* U+0118 */ { 1, 0, 1, 0, "0045 0328" },
/* U+0119 */ { 2, 0, 1, 0, "0065 0328" },
/* U+011a */ { 1, 0, 1, 0, "0045 030C" },
/* U+011b */ { 2, 0, 1, 0, "0065 030C" },
/* U+011c */ { 1, 0, 1, 0, "0047 0302" },
/* U+011d */ { 2, 0, 1, 0, "0067 0302" },
/* U+011e */ { 1, 0, 1, 0, "0047 0306" },
/* U+011f */ { 2, 0, 1, 0, "0067 0306" },
/* U+0120 */ { 1, 0, 1, 0, "0047 0307" },
/* U+0121 */ { 2, 0, 1, 0, "0067 0307" },
/* U+0122 */ { 1, 0, 1, 0, "0047 0327" },
/* U+0123 */ { 2, 0, 1, 0, "0067 0327" },
/* U+0124 */ { 1, 0, 1, 0, "0048 0302" },
/* U+0125 */ { 2, 0, 1, 0, "0068 0302" },
/* U+0126 */ { 1, 0, 1, 0, 0 },
/* U+0127 */ { 2, 0, 1, 0, 0 },
/* U+0128 */ { 1, 0, 1, 0, "0049 0303" },
/* U+0129 */ { 2, 0, 1, 0, "0069 0303" },
/* U+012a */ { 1, 0, 1, 0, "0049 0304" },
/* U+012b */ { 2, 0, 1, 0, "0069 0304" },
/* U+012c */ { 1, 0, 1, 0, "0049 0306" },
/* U+012d */ { 2, 0, 1, 0, "0069 0306" },
/* U+012e */ { 1, 0, 1, 0, "0049 0328" },
/* U+012f */ { 2, 0, 1, 0, "0069 0328" },
/* U+0130 */ { 1, 0, 1, 0, "0049 0307" },
/* U+0131 */ { 2, 0, 1, 0, 0 },
/* U+0132 */ { 1, 0, 1, 0, "<compat> 0049 004A" },
/* U+0133 */ { 2, 0, 1, 0, "<compat> 0069 006A" },
/* U+0134 */ { 1, 0, 1, 0, "004A 0302" },
/* U+0135 */ { 2, 0, 1, 0, "006A 0302" },
/* U+0136 */ { 1, 0, 1, 0, "004B 0327" },
/* U+0137 */ { 2, 0, 1, 0, "006B 0327" },
/* U+0138 */ { 2, 0, 1, 0, 0 },
/* U+0139 */ { 1, 0, 1, 0, "004C 0301" },
/* U+013a */ { 2, 0, 1, 0, "006C 0301" },
/* U+013b */ { 1, 0, 1, 0, "004C 0327" },
/* U+013c */ { 2, 0, 1, 0, "006C 0327" },
/* U+013d */ { 1, 0, 1, 0, "004C 030C" },
/* U+013e */ { 2, 0, 1, 0, "006C 030C" },
/* U+013f */ { 1, 0, 1, 0, "<compat> 004C 00B7" },
/* U+0140 */ { 2, 0, 1, 0, "<compat> 006C 00B7" },
/* U+0141 */ { 1, 0, 1, 0, 0 },
/* U+0142 */ { 2, 0, 1, 0, 0 },
/* U+0143 */ { 1, 0, 1, 0, "004E 0301" },
/* U+0144 */ { 2, 0, 1, 0, "006E 0301" },
/* U+0145 */ { 1, 0, 1, 0, "004E 0327" },
/* U+0146 */ { 2, 0, 1, 0, "006E 0327" },
/* U+0147 */ { 1, 0, 1, 0, "004E 030C" },
/* U+0148 */ { 2, 0, 1, 0, "006E 030C" },
/* U+0149 */ { 2, 0, 1, 0, "<compat> 02BC 006E" },
/* U+014a */ { 1, 0, 1, 0, 0 },
/* U+014b */ { 2, 0, 1, 0, 0 },
/* U+014c */ { 1, 0, 1, 0, "004F 0304" },
/* U+014d */ { 2, 0, 1, 0, "006F 0304" },
/* U+014e */ { 1, 0, 1, 0, "004F 0306" },
/* U+014f */ { 2, 0, 1, 0, "006F 0306" },
/* U+0150 */ { 1, 0, 1, 0, "004F 030B" },
/* U+0151 */ { 2, 0, 1, 0, "006F 030B" },
/* U+0152 */ { 1, 0, 1, 0, 0 },
/* U+0153 */ { 2, 0, 1, 0, 0 },
/* U+0154 */ { 1, 0, 1, 0, "0052 0301" },
/* U+0155 */ { 2, 0, 1, 0, "0072 0301" },
/* U+0156 */ { 1, 0, 1, 0, "0052 0327" },
/* U+0157 */ { 2, 0, 1, 0, "0072 0327" },
/* U+0158 */ { 1, 0, 1, 0, "0052 030C" },
/* U+0159 */ { 2, 0, 1, 0, "0072 030C" },
/* U+015a */ { 1, 0, 1, 0, "0053 0301" },
/* U+015b */ { 2, 0, 1, 0, "0073 0301" },
/* U+015c */ { 1, 0, 1, 0, "0053 0302" },
/* U+015d */ { 2, 0, 1, 0, "0073 0302" },
/* U+015e */ { 1, 0, 1, 0, "0053 0327" },
/* U+015f */ { 2, 0, 1, 0, "0073 0327" },
/* U+0160 */ { 1, 0, 1, 0, "0053 030C" },
/* U+0161 */ { 2, 0, 1, 0, "0073 030C" },
/* U+0162 */ { 1, 0, 1, 0, "0054 0327" },
/* U+0163 */ { 2, 0, 1, 0, "0074 0327" },
/* U+0164 */ { 1, 0, 1, 0, "0054 030C" },
/* U+0165 */ { 2, 0, 1, 0, "0074 030C" },
/* U+0166 */ { 1, 0, 1, 0, 0 },
/* U+0167 */ { 2, 0, 1, 0, 0 },
/* U+0168 */ { 1, 0, 1, 0, "0055 0303" },
/* U+0169 */ { 2, 0, 1, 0, "0075 0303" },
/* U+016a */ { 1, 0, 1, 0, "0055 0304" },
/* U+016b */ { 2, 0, 1, 0, "0075 0304" },
/* U+016c */ { 1, 0, 1, 0, "0055 0306" },
/* U+016d */ { 2, 0, 1, 0, "0075 0306" },
/* U+016e */ { 1, 0, 1, 0, "0055 030A" },
/* U+016f */ { 2, 0, 1, 0, "0075 030A" },
/* U+0170 */ { 1, 0, 1, 0, "0055 030B" },
/* U+0171 */ { 2, 0, 1, 0, "0075 030B" },
/* U+0172 */ { 1, 0, 1, 0, "0055 0328" },
/* U+0173 */ { 2, 0, 1, 0, "0075 0328" },
/* U+0174 */ { 1, 0, 1, 0, "0057 0302" },
/* U+0175 */ { 2, 0, 1, 0, "0077 0302" },
/* U+0176 */ { 1, 0, 1, 0, "0059 0302" },
/* U+0177 */ { 2, 0, 1, 0, "0079 0302" },
/* U+0178 */ { 1, 0, 1, 0, "0059 0308" },
/* U+0179 */ { 1, 0, 1, 0, "005A 0301" },
/* U+017a */ { 2, 0, 1, 0, "007A 0301" },
/* U+017b */ { 1, 0, 1, 0, "005A 0307" },
/* U+017c */ { 2, 0, 1, 0, "007A 0307" },
/* U+017d */ { 1, 0, 1, 0, "005A 030C" },
/* U+017e */ { 2, 0, 1, 0, "007A 030C" },
/* U+017f */ { 2, 0, 1, 0, "<compat> 0073" },
/* U+0180 */ { 2, 0, 1, 0, 0 },
/* U+0181 */ { 1, 0, 1, 0, 0 },
/* U+0182 */ { 1, 0, 1, 0, 0 },
/* U+0183 */ { 2, 0, 1, 0, 0 },
/* U+0184 */ { 1, 0, 1, 0, 0 },
/* U+0185 */ { 2, 0, 1, 0, 0 },
/* U+0186 */ { 1, 0, 1, 0, 0 },
/* U+0187 */ { 1, 0, 1, 0, 0 },
/* U+0188 */ { 2, 0, 1, 0, 0 },
/* U+0189 */ { 1, 0, 1, 0, 0 },
/* U+018a */ { 1, 0, 1, 0, 0 },
/* U+018b */ { 1, 0, 1, 0, 0 },
/* U+018c */ { 2, 0, 1, 0, 0 },
/* U+018d */ { 2, 0, 1, 0, 0 },
/* U+018e */ { 1, 0, 1, 0, 0 },
/* U+018f */ { 1, 0, 1, 0, 0 },
/* U+0190 */ { 1, 0, 1, 0, 0 },
/* U+0191 */ { 1, 0, 1, 0, 0 },
/* U+0192 */ { 2, 0, 1, 0, 0 },
/* U+0193 */ { 1, 0, 1, 0, 0 },
/* U+0194 */ { 1, 0, 1, 0, 0 },
/* U+0195 */ { 2, 0, 1, 0, 0 },
/* U+0196 */ { 1, 0, 1, 0, 0 },
/* U+0197 */ { 1, 0, 1, 0, 0 },
/* U+0198 */ { 1, 0, 1, 0, 0 },
/* U+0199 */ { 2, 0, 1, 0, 0 },
/* U+019a */ { 2, 0, 1, 0, 0 },
/* U+019b */ { 2, 0, 1, 0, 0 },
/* U+019c */ { 1, 0, 1, 0, 0 },
/* U+019d */ { 1, 0, 1, 0, 0 },
/* U+019e */ { 2, 0, 1, 0, 0 },
/* U+019f */ { 1, 0, 1, 0, 0 },
/* U+01a0 */ { 1, 0, 1, 0, "004F 031B" },
/* U+01a1 */ { 2, 0, 1, 0, "006F 031B" },
/* U+01a2 */ { 1, 0, 1, 0, 0 },
/* U+01a3 */ { 2, 0, 1, 0, 0 },
/* U+01a4 */ { 1, 0, 1, 0, 0 },
/* U+01a5 */ { 2, 0, 1, 0, 0 },
/* U+01a6 */ { 1, 0, 1, 0, 0 },
/* U+01a7 */ { 1, 0, 1, 0, 0 },
/* U+01a8 */ { 2, 0, 1, 0, 0 },
/* U+01a9 */ { 1, 0, 1, 0, 0 },
/* U+01aa */ { 2, 0, 1, 0, 0 },
/* U+01ab */ { 2, 0, 1, 0, 0 },
/* U+01ac */ { 1, 0, 1, 0, 0 },
/* U+01ad */ { 2, 0, 1, 0, 0 },
/* U+01ae */ { 1, 0, 1, 0, 0 },
/* U+01af */ { 1, 0, 1, 0, "0055 031B" },
/* U+01b0 */ { 2, 0, 1, 0, "0075 031B" },
/* U+01b1 */ { 1, 0, 1, 0, 0 },
/* U+01b2 */ { 1, 0, 1, 0, 0 },
/* U+01b3 */ { 1, 0, 1, 0, 0 },
/* U+01b4 */ { 2, 0, 1, 0, 0 },
/* U+01b5 */ { 1, 0, 1, 0, 0 },
/* U+01b6 */ { 2, 0, 1, 0, 0 },
/* U+01b7 */ { 1, 0, 1, 0, 0 },
/* U+01b8 */ { 1, 0, 1, 0, 0 },
/* U+01b9 */ { 2, 0, 1, 0, 0 },
/* U+01ba */ { 2, 0, 1, 0, 0 },
/* U+01bb */ { 19, 0, 1, 0, 0 },
/* U+01bc */ { 1, 0, 1, 0, 0 },
/* U+01bd */ { 2, 0, 1, 0, 0 },
/* U+01be */ { 2, 0, 1, 0, 0 },
/* U+01bf */ { 2, 0, 1, 0, 0 },
/* U+01c0 */ { 19, 0, 1, 0, 0 },
/* U+01c1 */ { 19, 0, 1, 0, 0 },
/* U+01c2 */ { 19, 0, 1, 0, 0 },
/* U+01c3 */ { 19, 0, 1, 0, 0 },
/* U+01c4 */ { 1, 0, 1, 0, "<compat> 0044 017D" },
/* U+01c5 */ { 3, 0, 1, 0, "<compat> 0044 017E" },
/* U+01c6 */ { 2, 0, 1, 0, "<compat> 0064 017E" },
/* U+01c7 */ { 1, 0, 1, 0, "<compat> 004C 004A" },
/* U+01c8 */ { 3, 0, 1, 0, "<compat> 004C 006A" },
/* U+01c9 */ { 2, 0, 1, 0, "<compat> 006C 006A" },
/* U+01ca */ { 1, 0, 1, 0, "<compat> 004E 004A" },
/* U+01cb */ { 3, 0, 1, 0, "<compat> 004E 006A" },
/* U+01cc */ { 2, 0, 1, 0, "<compat> 006E 006A" },
/* U+01cd */ { 1, 0, 1, 0, "0041 030C" },
/* U+01ce */ { 2, 0, 1, 0, "0061 030C" },
/* U+01cf */ { 1, 0, 1, 0, "0049 030C" },
/* U+01d0 */ { 2, 0, 1, 0, "0069 030C" },
/* U+01d1 */ { 1, 0, 1, 0, "004F 030C" },
/* U+01d2 */ { 2, 0, 1, 0, "006F 030C" },
/* U+01d3 */ { 1, 0, 1, 0, "0055 030C" },
/* U+01d4 */ { 2, 0, 1, 0, "0075 030C" },
/* U+01d5 */ { 1, 0, 1, 0, "00DC 0304" },
/* U+01d6 */ { 2, 0, 1, 0, "00FC 0304" },
/* U+01d7 */ { 1, 0, 1, 0, "00DC 0301" },
/* U+01d8 */ { 2, 0, 1, 0, "00FC 0301" },
/* U+01d9 */ { 1, 0, 1, 0, "00DC 030C" },
/* U+01da */ { 2, 0, 1, 0, "00FC 030C" },
/* U+01db */ { 1, 0, 1, 0, "00DC 0300" },
/* U+01dc */ { 2, 0, 1, 0, "00FC 0300" },
/* U+01dd */ { 2, 0, 1, 0, 0 },
/* U+01de */ { 1, 0, 1, 0, "00C4 0304" },
/* U+01df */ { 2, 0, 1, 0, "00E4 0304" },
/* U+01e0 */ { 1, 0, 1, 0, "0226 0304" },
/* U+01e1 */ { 2, 0, 1, 0, "0227 0304" },
/* U+01e2 */ { 1, 0, 1, 0, "00C6 0304" },
/* U+01e3 */ { 2, 0, 1, 0, "00E6 0304" },
/* U+01e4 */ { 1, 0, 1, 0, 0 },
/* U+01e5 */ { 2, 0, 1, 0, 0 },
/* U+01e6 */ { 1, 0, 1, 0, "0047 030C" },
/* U+01e7 */ { 2, 0, 1, 0, "0067 030C" },
/* U+01e8 */ { 1, 0, 1, 0, "004B 030C" },
/* U+01e9 */ { 2, 0, 1, 0, "006B 030C" },
/* U+01ea */ { 1, 0, 1, 0, "004F 0328" },
/* U+01eb */ { 2, 0, 1, 0, "006F 0328" },
/* U+01ec */ { 1, 0, 1, 0, "01EA 0304" },
/* U+01ed */ { 2, 0, 1, 0, "01EB 0304" },
/* U+01ee */ { 1, 0, 1, 0, "01B7 030C" },
/* U+01ef */ { 2, 0, 1, 0, "0292 030C" },
/* U+01f0 */ { 2, 0, 1, 0, "006A 030C" },
/* U+01f1 */ { 1, 0, 1, 0, "<compat> 0044 005A" },
/* U+01f2 */ { 3, 0, 1, 0, "<compat> 0044 007A" },
/* U+01f3 */ { 2, 0, 1, 0, "<compat> 0064 007A" },
/* U+01f4 */ { 1, 0, 1, 0, "0047 0301" },
/* U+01f5 */ { 2, 0, 1, 0, "0067 0301" },
/* U+01f6 */ { 1, 0, 1, 0, 0 },
/* U+01f7 */ { 1, 0, 1, 0, 0 },
/* U+01f8 */ { 1, 0, 1, 0, "004E 0300" },
/* U+01f9 */ { 2, 0, 1, 0, "006E 0300" },
/* U+01fa */ { 1, 0, 1, 0, "00C5 0301" },
/* U+01fb */ { 2, 0, 1, 0, "00E5 0301" },
/* U+01fc */ { 1, 0, 1, 0, "00C6 0301" },
/* U+01fd */ { 2, 0, 1, 0, "00E6 0301" },
/* U+01fe */ { 1, 0, 1, 0, "00D8 0301" },
/* U+01ff */ { 2, 0, 1, 0, "00F8 0301" },
/* U+0200 */ { 1, 0, 1, 0, "0041 030F" },
/* U+0201 */ { 2, 0, 1, 0, "0061 030F" },
/* U+0202 */ { 1, 0, 1, 0, "0041 0311" },
/* U+0203 */ { 2, 0, 1, 0, "0061 0311" },
/* U+0204 */ { 1, 0, 1, 0, "0045 030F" },
/* U+0205 */ { 2, 0, 1, 0, "0065 030F" },
/* U+0206 */ { 1, 0, 1, 0, "0045 0311" },
/* U+0207 */ { 2, 0, 1, 0, "0065 0311" },
/* U+0208 */ { 1, 0, 1, 0, "0049 030F" },
/* U+0209 */ { 2, 0, 1, 0, "0069 030F" },
/* U+020a */ { 1, 0, 1, 0, "0049 0311" },
/* U+020b */ { 2, 0, 1, 0, "0069 0311" },
/* U+020c */ { 1, 0, 1, 0, "004F 030F" },
/* U+020d */ { 2, 0, 1, 0, "006F 030F" },
/* U+020e */ { 1, 0, 1, 0, "004F 0311" },
/* U+020f */ { 2, 0, 1, 0, "006F 0311" },
/* U+0210 */ { 1, 0, 1, 0, "0052 030F" },
/* U+0211 */ { 2, 0, 1, 0, "0072 030F" },
/* U+0212 */ { 1, 0, 1, 0, "0052 0311" },
/* U+0213 */ { 2, 0, 1, 0, "0072 0311" },
/* U+0214 */ { 1, 0, 1, 0, "0055 030F" },
/* U+0215 */ { 2, 0, 1, 0, "0075 030F" },
/* U+0216 */ { 1, 0, 1, 0, "0055 0311" },
/* U+0217 */ { 2, 0, 1, 0, "0075 0311" },
/* U+0218 */ { 1, 0, 1, 0, "0053 0326" },
/* U+0219 */ { 2, 0, 1, 0, "0073 0326" },
/* U+021a */ { 1, 0, 1, 0, "0054 0326" },
/* U+021b */ { 2, 0, 1, 0, "0074 0326" },
/* U+021c */ { 1, 0, 1, 0, 0 },
/* U+021d */ { 2, 0, 1, 0, 0 },
/* U+021e */ { 1, 0, 1, 0, "0048 030C" },
/* U+021f */ { 2, 0, 1, 0, "0068 030C" },
/* U+0220 */ { 0, 0, 0, 0, 0 },
/* U+0221 */ { 0, 0, 0, 0, 0 },
/* U+0222 */ { 1, 0, 1, 0, 0 },
/* U+0223 */ { 2, 0, 1, 0, 0 },
/* U+0224 */ { 1, 0, 1, 0, 0 },
/* U+0225 */ { 2, 0, 1, 0, 0 },
/* U+0226 */ { 1, 0, 1, 0, "0041 0307" },
/* U+0227 */ { 2, 0, 1, 0, "0061 0307" },
/* U+0228 */ { 1, 0, 1, 0, "0045 0327" },
/* U+0229 */ { 2, 0, 1, 0, "0065 0327" },
/* U+022a */ { 1, 0, 1, 0, "00D6 0304" },
/* U+022b */ { 2, 0, 1, 0, "00F6 0304" },
/* U+022c */ { 1, 0, 1, 0, "00D5 0304" },
/* U+022d */ { 2, 0, 1, 0, "00F5 0304" },
/* U+022e */ { 1, 0, 1, 0, "004F 0307" },
/* U+022f */ { 2, 0, 1, 0, "006F 0307" },
/* U+0230 */ { 1, 0, 1, 0, "022E 0304" },
/* U+0231 */ { 2, 0, 1, 0, "022F 0304" },
/* U+0232 */ { 1, 0, 1, 0, "0059 0304" },
/* U+0233 */ { 2, 0, 1, 0, "0079 0304" },
/* U+0234 */ { 0, 0, 0, 0, 0 },
/* U+0235 */ { 0, 0, 0, 0, 0 },
/* U+0236 */ { 0, 0, 0, 0, 0 },
/* U+0237 */ { 0, 0, 0, 0, 0 },
/* U+0238 */ { 0, 0, 0, 0, 0 },
/* U+0239 */ { 0, 0, 0, 0, 0 },
/* U+023a */ { 0, 0, 0, 0, 0 },
/* U+023b */ { 0, 0, 0, 0, 0 },
/* U+023c */ { 0, 0, 0, 0, 0 },
/* U+023d */ { 0, 0, 0, 0, 0 },
/* U+023e */ { 0, 0, 0, 0, 0 },
/* U+023f */ { 0, 0, 0, 0, 0 },
/* U+0240 */ { 0, 0, 0, 0, 0 },
/* U+0241 */ { 0, 0, 0, 0, 0 },
/* U+0242 */ { 0, 0, 0, 0, 0 },
/* U+0243 */ { 0, 0, 0, 0, 0 },
/* U+0244 */ { 0, 0, 0, 0, 0 },
/* U+0245 */ { 0, 0, 0, 0, 0 },
/* U+0246 */ { 0, 0, 0, 0, 0 },
/* U+0247 */ { 0, 0, 0, 0, 0 },
/* U+0248 */ { 0, 0, 0, 0, 0 },
/* U+0249 */ { 0, 0, 0, 0, 0 },
/* U+024a */ { 0, 0, 0, 0, 0 },
/* U+024b */ { 0, 0, 0, 0, 0 },
/* U+024c */ { 0, 0, 0, 0, 0 },
/* U+024d */ { 0, 0, 0, 0, 0 },
/* U+024e */ { 0, 0, 0, 0, 0 },
/* U+024f */ { 0, 0, 0, 0, 0 },
/* U+0250 */ { 2, 0, 1, 0, 0 },
/* U+0251 */ { 2, 0, 1, 0, 0 },
/* U+0252 */ { 2, 0, 1, 0, 0 },
/* U+0253 */ { 2, 0, 1, 0, 0 },
/* U+0254 */ { 2, 0, 1, 0, 0 },
/* U+0255 */ { 2, 0, 1, 0, 0 },
/* U+0256 */ { 2, 0, 1, 0, 0 },
/* U+0257 */ { 2, 0, 1, 0, 0 },
/* U+0258 */ { 2, 0, 1, 0, 0 },
/* U+0259 */ { 2, 0, 1, 0, 0 },
/* U+025a */ { 2, 0, 1, 0, 0 },
/* U+025b */ { 2, 0, 1, 0, 0 },
/* U+025c */ { 2, 0, 1, 0, 0 },
/* U+025d */ { 2, 0, 1, 0, 0 },
/* U+025e */ { 2, 0, 1, 0, 0 },
/* U+025f */ { 2, 0, 1, 0, 0 },
/* U+0260 */ { 2, 0, 1, 0, 0 },
/* U+0261 */ { 2, 0, 1, 0, 0 },
/* U+0262 */ { 2, 0, 1, 0, 0 },
/* U+0263 */ { 2, 0, 1, 0, 0 },
/* U+0264 */ { 2, 0, 1, 0, 0 },
/* U+0265 */ { 2, 0, 1, 0, 0 },
/* U+0266 */ { 2, 0, 1, 0, 0 },
/* U+0267 */ { 2, 0, 1, 0, 0 },
/* U+0268 */ { 2, 0, 1, 0, 0 },
/* U+0269 */ { 2, 0, 1, 0, 0 },
/* U+026a */ { 2, 0, 1, 0, 0 },
/* U+026b */ { 2, 0, 1, 0, 0 },
/* U+026c */ { 2, 0, 1, 0, 0 },
/* U+026d */ { 2, 0, 1, 0, 0 },
/* U+026e */ { 2, 0, 1, 0, 0 },
/* U+026f */ { 2, 0, 1, 0, 0 },
/* U+0270 */ { 2, 0, 1, 0, 0 },
/* U+0271 */ { 2, 0, 1, 0, 0 },
/* U+0272 */ { 2, 0, 1, 0, 0 },
/* U+0273 */ { 2, 0, 1, 0, 0 },
/* U+0274 */ { 2, 0, 1, 0, 0 },
/* U+0275 */ { 2, 0, 1, 0, 0 },
/* U+0276 */ { 2, 0, 1, 0, 0 },
/* U+0277 */ { 2, 0, 1, 0, 0 },
/* U+0278 */ { 2, 0, 1, 0, 0 },
/* U+0279 */ { 2, 0, 1, 0, 0 },
/* U+027a */ { 2, 0, 1, 0, 0 },
/* U+027b */ { 2, 0, 1, 0, 0 },
/* U+027c */ { 2, 0, 1, 0, 0 },
/* U+027d */ { 2, 0, 1, 0, 0 },
/* U+027e */ { 2, 0, 1, 0, 0 },
/* U+027f */ { 2, 0, 1, 0, 0 },
/* U+0280 */ { 2, 0, 1, 0, 0 },
/* U+0281 */ { 2, 0, 1, 0, 0 },
/* U+0282 */ { 2, 0, 1, 0, 0 },
/* U+0283 */ { 2, 0, 1, 0, 0 },
/* U+0284 */ { 2, 0, 1, 0, 0 },
/* U+0285 */ { 2, 0, 1, 0, 0 },
/* U+0286 */ { 2, 0, 1, 0, 0 },
/* U+0287 */ { 2, 0, 1, 0, 0 },
/* U+0288 */ { 2, 0, 1, 0, 0 },
/* U+0289 */ { 2, 0, 1, 0, 0 },
/* U+028a */ { 2, 0, 1, 0, 0 },
/* U+028b */ { 2, 0, 1, 0, 0 },
/* U+028c */ { 2, 0, 1, 0, 0 },
/* U+028d */ { 2, 0, 1, 0, 0 },
/* U+028e */ { 2, 0, 1, 0, 0 },
/* U+028f */ { 2, 0, 1, 0, 0 },
/* U+0290 */ { 2, 0, 1, 0, 0 },
/* U+0291 */ { 2, 0, 1, 0, 0 },
/* U+0292 */ { 2, 0, 1, 0, 0 },
/* U+0293 */ { 2, 0, 1, 0, 0 },
/* U+0294 */ { 2, 0, 1, 0, 0 },
/* U+0295 */ { 2, 0, 1, 0, 0 },
/* U+0296 */ { 2, 0, 1, 0, 0 },
/* U+0297 */ { 2, 0, 1, 0, 0 },
/* U+0298 */ { 2, 0, 1, 0, 0 },
/* U+0299 */ { 2, 0, 1, 0, 0 },
/* U+029a */ { 2, 0, 1, 0, 0 },
/* U+029b */ { 2, 0, 1, 0, 0 },
/* U+029c */ { 2, 0, 1, 0, 0 },
/* U+029d */ { 2, 0, 1, 0, 0 },
/* U+029e */ { 2, 0, 1, 0, 0 },
/* U+029f */ { 2, 0, 1, 0, 0 },
/* U+02a0 */ { 2, 0, 1, 0, 0 },
/* U+02a1 */ { 2, 0, 1, 0, 0 },
/* U+02a2 */ { 2, 0, 1, 0, 0 },
/* U+02a3 */ { 2, 0, 1, 0, 0 },
/* U+02a4 */ { 2, 0, 1, 0, 0 },
/* U+02a5 */ { 2, 0, 1, 0, 0 },
/* U+02a6 */ { 2, 0, 1, 0, 0 },
/* U+02a7 */ { 2, 0, 1, 0, 0 },
/* U+02a8 */ { 2, 0, 1, 0, 0 },
/* U+02a9 */ { 2, 0, 1, 0, 0 },
/* U+02aa */ { 2, 0, 1, 0, 0 },
/* U+02ab */ { 2, 0, 1, 0, 0 },
/* U+02ac */ { 2, 0, 1, 0, 0 },
/* U+02ad */ { 2, 0, 1, 0, 0 },
/* U+02ae */ { 0, 0, 0, 0, 0 },
/* U+02af */ { 0, 0, 0, 0, 0 },
/* U+02b0 */ { 18, 0, 1, 0, "<super> 0068" },
/* U+02b1 */ { 18, 0, 1, 0, "<super> 0266" },
/* U+02b2 */ { 18, 0, 1, 0, "<super> 006A" },
/* U+02b3 */ { 18, 0, 1, 0, "<super> 0072" },
/* U+02b4 */ { 18, 0, 1, 0, "<super> 0279" },
/* U+02b5 */ { 18, 0, 1, 0, "<super> 027B" },
/* U+02b6 */ { 18, 0, 1, 0, "<super> 0281" },
/* U+02b7 */ { 18, 0, 1, 0, "<super> 0077" },
/* U+02b8 */ { 18, 0, 1, 0, "<super> 0079" },
/* U+02b9 */ { 29, 0, 19, 0, 0 },
/* U+02ba */ { 29, 0, 19, 0, 0 },
/* U+02bb */ { 18, 0, 1, 0, 0 },
/* U+02bc */ { 18, 0, 1, 0, 0 },
/* U+02bd */ { 18, 0, 1, 0, 0 },
/* U+02be */ { 18, 0, 1, 0, 0 },
/* U+02bf */ { 18, 0, 1, 0, 0 },
/* U+02c0 */ { 18, 0, 1, 0, 0 },
/* U+02c1 */ { 18, 0, 1, 0, 0 },
/* U+02c2 */ { 29, 0, 19, 0, 0 },
/* U+02c3 */ { 29, 0, 19, 0, 0 },
/* U+02c4 */ { 29, 0, 19, 0, 0 },
/* U+02c5 */ { 29, 0, 19, 0, 0 },
/* U+02c6 */ { 29, 0, 19, 0, 0 },
/* U+02c7 */ { 29, 0, 19, 0, 0 },
/* U+02c8 */ { 29, 0, 19, 0, 0 },
/* U+02c9 */ { 29, 0, 19, 0, 0 },
/* U+02ca */ { 29, 0, 19, 0, 0 },
/* U+02cb */ { 29, 0, 19, 0, 0 },
/* U+02cc */ { 29, 0, 19, 0, 0 },
/* U+02cd */ { 29, 0, 19, 0, 0 },
/* U+02ce */ { 29, 0, 19, 0, 0 },
/* U+02cf */ { 29, 0, 19, 0, 0 },
/* U+02d0 */ { 18, 0, 1, 0, 0 },
/* U+02d1 */ { 18, 0, 1, 0, 0 },
/* U+02d2 */ { 29, 0, 19, 0, 0 },
/* U+02d3 */ { 29, 0, 19, 0, 0 },
/* U+02d4 */ { 29, 0, 19, 0, 0 },
/* U+02d5 */ { 29, 0, 19, 0, 0 },
/* U+02d6 */ { 29, 0, 19, 0, 0 },
/* U+02d7 */ { 29, 0, 19, 0, 0 },
/* U+02d8 */ { 29, 0, 19, 0, "<compat> 0020 0306" },
/* U+02d9 */ { 29, 0, 19, 0, "<compat> 0020 0307" },
/* U+02da */ { 29, 0, 19, 0, "<compat> 0020 030A" },
/* U+02db */ { 29, 0, 19, 0, "<compat> 0020 0328" },
/* U+02dc */ { 29, 0, 19, 0, "<compat> 0020 0303" },
/* U+02dd */ { 29, 0, 19, 0, "<compat> 0020 030B" },
/* U+02de */ { 29, 0, 19, 0, 0 },
/* U+02df */ { 29, 0, 19, 0, 0 },
/* U+02e0 */ { 18, 0, 1, 0, "<super> 0263" },
/* U+02e1 */ { 18, 0, 1, 0, "<super> 006C" },
/* U+02e2 */ { 18, 0, 1, 0, "<super> 0073" },
/* U+02e3 */ { 18, 0, 1, 0, "<super> 0078" },
/* U+02e4 */ { 18, 0, 1, 0, "<super> 0295" },
/* U+02e5 */ { 29, 0, 19, 0, 0 },
/* U+02e6 */ { 29, 0, 19, 0, 0 },
/* U+02e7 */ { 29, 0, 19, 0, 0 },
/* U+02e8 */ { 29, 0, 19, 0, 0 },
/* U+02e9 */ { 29, 0, 19, 0, 0 },
/* U+02ea */ { 29, 0, 19, 0, 0 },
/* U+02eb */ { 29, 0, 19, 0, 0 },
/* U+02ec */ { 29, 0, 19, 0, 0 },
/* U+02ed */ { 29, 0, 19, 0, 0 },
/* U+02ee */ { 18, 0, 1, 0, 0 },
/* U+02ef */ { 0, 0, 0, 0, 0 },
/* U+02f0 */ { 0, 0, 0, 0, 0 },
/* U+02f1 */ { 0, 0, 0, 0, 0 },
/* U+02f2 */ { 0, 0, 0, 0, 0 },
/* U+02f3 */ { 0, 0, 0, 0, 0 },
/* U+02f4 */ { 0, 0, 0, 0, 0 },
/* U+02f5 */ { 0, 0, 0, 0, 0 },
/* U+02f6 */ { 0, 0, 0, 0, 0 },
/* U+02f7 */ { 0, 0, 0, 0, 0 },
/* U+02f8 */ { 0, 0, 0, 0, 0 },
/* U+02f9 */ { 0, 0, 0, 0, 0 },
/* U+02fa */ { 0, 0, 0, 0, 0 },
/* U+02fb */ { 0, 0, 0, 0, 0 },
/* U+02fc */ { 0, 0, 0, 0, 0 },
/* U+02fd */ { 0, 0, 0, 0, 0 },
/* U+02fe */ { 0, 0, 0, 0, 0 },
/* U+02ff */ { 0, 0, 0, 0, 0 },
/* U+0300 */ { 4, 230, 14, 0, 0 },
/* U+0301 */ { 4, 230, 14, 0, 0 },
/* U+0302 */ { 4, 230, 14, 0, 0 },
/* U+0303 */ { 4, 230, 14, 0, 0 },
/* U+0304 */ { 4, 230, 14, 0, 0 },
/* U+0305 */ { 4, 230, 14, 0, 0 },
/* U+0306 */ { 4, 230, 14, 0, 0 },
/* U+0307 */ { 4, 230, 14, 0, 0 },
/* U+0308 */ { 4, 230, 14, 0, 0 },
/* U+0309 */ { 4, 230, 14, 0, 0 },
/* U+030a */ { 4, 230, 14, 0, 0 },
/* U+030b */ { 4, 230, 14, 0, 0 },
/* U+030c */ { 4, 230, 14, 0, 0 },
/* U+030d */ { 4, 230, 14, 0, 0 },
/* U+030e */ { 4, 230, 14, 0, 0 },
/* U+030f */ { 4, 230, 14, 0, 0 },
/* U+0310 */ { 4, 230, 14, 0, 0 },
/* U+0311 */ { 4, 230, 14, 0, 0 },
/* U+0312 */ { 4, 230, 14, 0, 0 },
/* U+0313 */ { 4, 230, 14, 0, 0 },
/* U+0314 */ { 4, 230, 14, 0, 0 },
/* U+0315 */ { 4, 232, 14, 0, 0 },
/* U+0316 */ { 4, 220, 14, 0, 0 },
/* U+0317 */ { 4, 220, 14, 0, 0 },
/* U+0318 */ { 4, 220, 14, 0, 0 },
/* U+0319 */ { 4, 220, 14, 0, 0 },
/* U+031a */ { 4, 232, 14, 0, 0 },
/* U+031b */ { 4, 216, 14, 0, 0 },
/* U+031c */ { 4, 220, 14, 0, 0 },
/* U+031d */ { 4, 220, 14, 0, 0 },
/* U+031e */ { 4, 220, 14, 0, 0 },
/* U+031f */ { 4, 220, 14, 0, 0 },
/* U+0320 */ { 4, 220, 14, 0, 0 },
/* U+0321 */ { 4, 202, 14, 0, 0 },
/* U+0322 */ { 4, 202, 14, 0, 0 },
/* U+0323 */ { 4, 220, 14, 0, 0 },
/* U+0324 */ { 4, 220, 14, 0, 0 },
/* U+0325 */ { 4, 220, 14, 0, 0 },
/* U+0326 */ { 4, 220, 14, 0, 0 },
/* U+0327 */ { 4, 202, 14, 0, 0 },
/* U+0328 */ { 4, 202, 14, 0, 0 },
/* U+0329 */ { 4, 220, 14, 0, 0 },
/* U+032a */ { 4, 220, 14, 0, 0 },
/* U+032b */ { 4, 220, 14, 0, 0 },
/* U+032c */ { 4, 220, 14, 0, 0 },
/* U+032d */ { 4, 220, 14, 0, 0 },
/* U+032e */ { 4, 220, 14, 0, 0 },
/* U+032f */ { 4, 220, 14, 0, 0 },
/* U+0330 */ { 4, 220, 14, 0, 0 },
/* U+0331 */ { 4, 220, 14, 0, 0 },
/* U+0332 */ { 4, 220, 14, 0, 0 },
/* U+0333 */ { 4, 220, 14, 0, 0 },
/* U+0334 */ { 4, 1, 14, 0, 0 },
/* U+0335 */ { 4, 1, 14, 0, 0 },
/* U+0336 */ { 4, 1, 14, 0, 0 },
/* U+0337 */ { 4, 1, 14, 0, 0 },
/* U+0338 */ { 4, 1, 14, 0, 0 },
/* U+0339 */ { 4, 220, 14, 0, 0 },
/* U+033a */ { 4, 220, 14, 0, 0 },
/* U+033b */ { 4, 220, 14, 0, 0 },
/* U+033c */ { 4, 220, 14, 0, 0 },
/* U+033d */ { 4, 230, 14, 0, 0 },
/* U+033e */ { 4, 230, 14, 0, 0 },
/* U+033f */ { 4, 230, 14, 0, 0 },
/* U+0340 */ { 4, 230, 14, 0, "0300" },
/* U+0341 */ { 4, 230, 14, 0, "0301" },
/* U+0342 */ { 4, 230, 14, 0, 0 },
/* U+0343 */ { 4, 230, 14, 0, "0313" },
/* U+0344 */ { 4, 230, 14, 0, "0308 0301" },
/* U+0345 */ { 4, 240, 14, 0, 0 },
/* U+0346 */ { 4, 230, 14, 0, 0 },
/* U+0347 */ { 4, 220, 14, 0, 0 },
/* U+0348 */ { 4, 220, 14, 0, 0 },
/* U+0349 */ { 4, 220, 14, 0, 0 },
/* U+034a */ { 4, 230, 14, 0, 0 },
/* U+034b */ { 4, 230, 14, 0, 0 },
/* U+034c */ { 4, 230, 14, 0, 0 },
/* U+034d */ { 4, 220, 14, 0, 0 },
/* U+034e */ { 4, 220, 14, 0, 0 },
/* U+034f */ { 0, 0, 0, 0, 0 },
/* U+0350 */ { 0, 0, 0, 0, 0 },
/* U+0351 */ { 0, 0, 0, 0, 0 },
/* U+0352 */ { 0, 0, 0, 0, 0 },
/* U+0353 */ { 0, 0, 0, 0, 0 },
/* U+0354 */ { 0, 0, 0, 0, 0 },
/* U+0355 */ { 0, 0, 0, 0, 0 },
/* U+0356 */ { 0, 0, 0, 0, 0 },
/* U+0357 */ { 0, 0, 0, 0, 0 },
/* U+0358 */ { 0, 0, 0, 0, 0 },
/* U+0359 */ { 0, 0, 0, 0, 0 },
/* U+035a */ { 0, 0, 0, 0, 0 },
/* U+035b */ { 0, 0, 0, 0, 0 },
/* U+035c */ { 0, 0, 0, 0, 0 },
/* U+035d */ { 0, 0, 0, 0, 0 },
/* U+035e */ { 0, 0, 0, 0, 0 },
/* U+035f */ { 0, 0, 0, 0, 0 },
/* U+0360 */ { 4, 234, 14, 0, 0 },
/* U+0361 */ { 4, 234, 14, 0, 0 },
/* U+0362 */ { 4, 233, 14, 0, 0 },
/* U+0363 */ { 0, 0, 0, 0, 0 },
/* U+0364 */ { 0, 0, 0, 0, 0 },
/* U+0365 */ { 0, 0, 0, 0, 0 },
/* U+0366 */ { 0, 0, 0, 0, 0 },
/* U+0367 */ { 0, 0, 0, 0, 0 },
/* U+0368 */ { 0, 0, 0, 0, 0 },
/* U+0369 */ { 0, 0, 0, 0, 0 },
/* U+036a */ { 0, 0, 0, 0, 0 },
/* U+036b */ { 0, 0, 0, 0, 0 },
/* U+036c */ { 0, 0, 0, 0, 0 },
/* U+036d */ { 0, 0, 0, 0, 0 },
/* U+036e */ { 0, 0, 0, 0, 0 },
/* U+036f */ { 0, 0, 0, 0, 0 },
/* U+0370 */ { 0, 0, 0, 0, 0 },
/* U+0371 */ { 0, 0, 0, 0, 0 },
/* U+0372 */ { 0, 0, 0, 0, 0 },
/* U+0373 */ { 0, 0, 0, 0, 0 },
/* U+0374 */ { 29, 0, 19, 0, "02B9" },
/* U+0375 */ { 29, 0, 19, 0, 0 },
/* U+0376 */ { 0, 0, 0, 0, 0 },
/* U+0377 */ { 0, 0, 0, 0, 0 },
/* U+0378 */ { 0, 0, 0, 0, 0 },
/* U+0379 */ { 0, 0, 0, 0, 0 },
/* U+037a */ { 18, 0, 1, 0, "<compat> 0020 0345" },
/* U+037b */ { 0, 0, 0, 0, 0 },
/* U+037c */ { 0, 0, 0, 0, 0 },
/* U+037d */ { 0, 0, 0, 0, 0 },
/* U+037e */ { 26, 0, 19, 0, "003B" },
/* U+037f */ { 0, 0, 0, 0, 0 },
/* U+0380 */ { 0, 0, 0, 0, 0 },
/* U+0381 */ { 0, 0, 0, 0, 0 },
/* U+0382 */ { 0, 0, 0, 0, 0 },
/* U+0383 */ { 0, 0, 0, 0, 0 },
/* U+0384 */ { 29, 0, 19, 0, "<compat> 0020 0301" },
/* U+0385 */ { 29, 0, 19, 0, "00A8 0301" },
/* U+0386 */ { 1, 0, 1, 0, "0391 0301" },
/* U+0387 */ { 26, 0, 19, 0, "00B7" },
/* U+0388 */ { 1, 0, 1, 0, "0395 0301" },
/* U+0389 */ { 1, 0, 1, 0, "0397 0301" },
/* U+038a */ { 1, 0, 1, 0, "0399 0301" },
/* U+038b */ { 0, 0, 0, 0, 0 },
/* U+038c */ { 1, 0, 1, 0, "039F 0301" },
/* U+038d */ { 0, 0, 0, 0, 0 },
/* U+038e */ { 1, 0, 1, 0, "03A5 0301" },
/* U+038f */ { 1, 0, 1, 0, "03A9 0301" },
/* U+0390 */ { 2, 0, 1, 0, "03CA 0301" },
/* U+0391 */ { 1, 0, 1, 0, 0 },
/* U+0392 */ { 1, 0, 1, 0, 0 },
/* U+0393 */ { 1, 0, 1, 0, 0 },
/* U+0394 */ { 1, 0, 1, 0, 0 },
/* U+0395 */ { 1, 0, 1, 0, 0 },
/* U+0396 */ { 1, 0, 1, 0, 0 },
/* U+0397 */ { 1, 0, 1, 0, 0 },
/* U+0398 */ { 1, 0, 1, 0, 0 },
/* U+0399 */ { 1, 0, 1, 0, 0 },
/* U+039a */ { 1, 0, 1, 0, 0 },
/* U+039b */ { 1, 0, 1, 0, 0 },
/* U+039c */ { 1, 0, 1, 0, 0 },
/* U+039d */ { 1, 0, 1, 0, 0 },
/* U+039e */ { 1, 0, 1, 0, 0 },
/* U+039f */ { 1, 0, 1, 0, 0 },
/* U+03a0 */ { 1, 0, 1, 0, 0 },
/* U+03a1 */ { 1, 0, 1, 0, 0 },
/* U+03a2 */ { 0, 0, 0, 0, 0 },
/* U+03a3 */ { 1, 0, 1, 0, 0 },
/* U+03a4 */ { 1, 0, 1, 0, 0 },
/* U+03a5 */ { 1, 0, 1, 0, 0 },
/* U+03a6 */ { 1, 0, 1, 0, 0 },
/* U+03a7 */ { 1, 0, 1, 0, 0 },
/* U+03a8 */ { 1, 0, 1, 0, 0 },
/* U+03a9 */ { 1, 0, 1, 0, 0 },
/* U+03aa */ { 1, 0, 1, 0, "0399 0308" },
/* U+03ab */ { 1, 0, 1, 0, "03A5 0308" },
/* U+03ac */ { 2, 0, 1, 0, "03B1 0301" },
/* U+03ad */ { 2, 0, 1, 0, "03B5 0301" },
/* U+03ae */ { 2, 0, 1, 0, "03B7 0301" },
/* U+03af */ { 2, 0, 1, 0, "03B9 0301" },
/* U+03b0 */ { 2, 0, 1, 0, "03CB 0301" },
/* U+03b1 */ { 2, 0, 1, 0, 0 },
/* U+03b2 */ { 2, 0, 1, 0, 0 },
/* U+03b3 */ { 2, 0, 1, 0, 0 },
/* U+03b4 */ { 2, 0, 1, 0, 0 },
/* U+03b5 */ { 2, 0, 1, 0, 0 },
/* U+03b6 */ { 2, 0, 1, 0, 0 },
/* U+03b7 */ { 2, 0, 1, 0, 0 },
/* U+03b8 */ { 2, 0, 1, 0, 0 },
/* U+03b9 */ { 2, 0, 1, 0, 0 },
/* U+03ba */ { 2, 0, 1, 0, 0 },
/* U+03bb */ { 2, 0, 1, 0, 0 },
/* U+03bc */ { 2, 0, 1, 0, 0 },
/* U+03bd */ { 2, 0, 1, 0, 0 },
/* U+03be */ { 2, 0, 1, 0, 0 },
/* U+03bf */ { 2, 0, 1, 0, 0 },
/* U+03c0 */ { 2, 0, 1, 0, 0 },
/* U+03c1 */ { 2, 0, 1, 0, 0 },
/* U+03c2 */ { 2, 0, 1, 0, 0 },
/* U+03c3 */ { 2, 0, 1, 0, 0 },
/* U+03c4 */ { 2, 0, 1, 0, 0 },
/* U+03c5 */ { 2, 0, 1, 0, 0 },
/* U+03c6 */ { 2, 0, 1, 0, 0 },
/* U+03c7 */ { 2, 0, 1, 0, 0 },
/* U+03c8 */ { 2, 0, 1, 0, 0 },
/* U+03c9 */ { 2, 0, 1, 0, 0 },
/* U+03ca */ { 2, 0, 1, 0, "03B9 0308" },
/* U+03cb */ { 2, 0, 1, 0, "03C5 0308" },
/* U+03cc */ { 2, 0, 1, 0, "03BF 0301" },
/* U+03cd */ { 2, 0, 1, 0, "03C5 0301" },
/* U+03ce */ { 2, 0, 1, 0, "03C9 0301" },
/* U+03cf */ { 0, 0, 0, 0, 0 },
/* U+03d0 */ { 2, 0, 1, 0, "<compat> 03B2" },
/* U+03d1 */ { 2, 0, 1, 0, "<compat> 03B8" },
/* U+03d2 */ { 1, 0, 1, 0, "<compat> 03A5" },
/* U+03d3 */ { 1, 0, 1, 0, "03D2 0301" },
/* U+03d4 */ { 1, 0, 1, 0, "03D2 0308" },
/* U+03d5 */ { 2, 0, 1, 0, "<compat> 03C6" },
/* U+03d6 */ { 2, 0, 1, 0, "<compat> 03C0" },
/* U+03d7 */ { 2, 0, 1, 0, 0 },
/* U+03d8 */ { 0, 0, 0, 0, 0 },
/* U+03d9 */ { 0, 0, 0, 0, 0 },
/* U+03da */ { 1, 0, 1, 0, 0 },
/* U+03db */ { 2, 0, 1, 0, 0 },
/* U+03dc */ { 1, 0, 1, 0, 0 },
/* U+03dd */ { 2, 0, 1, 0, 0 },
/* U+03de */ { 1, 0, 1, 0, 0 },
/* U+03df */ { 2, 0, 1, 0, 0 },
/* U+03e0 */ { 1, 0, 1, 0, 0 },
/* U+03e1 */ { 2, 0, 1, 0, 0 },
/* U+03e2 */ { 1, 0, 1, 0, 0 },
/* U+03e3 */ { 2, 0, 1, 0, 0 },
/* U+03e4 */ { 1, 0, 1, 0, 0 },
/* U+03e5 */ { 2, 0, 1, 0, 0 },
/* U+03e6 */ { 1, 0, 1, 0, 0 },
/* U+03e7 */ { 2, 0, 1, 0, 0 },
/* U+03e8 */ { 1, 0, 1, 0, 0 },
/* U+03e9 */ { 2, 0, 1, 0, 0 },
/* U+03ea */ { 1, 0, 1, 0, 0 },
/* U+03eb */ { 2, 0, 1, 0, 0 },
/* U+03ec */ { 1, 0, 1, 0, 0 },
/* U+03ed */ { 2, 0, 1, 0, 0 },
/* U+03ee */ { 1, 0, 1, 0, 0 },
/* U+03ef */ { 2, 0, 1, 0, 0 },
/* U+03f0 */ { 2, 0, 1, 0, "<compat> 03BA" },
/* U+03f1 */ { 2, 0, 1, 0, "<compat> 03C1" },
/* U+03f2 */ { 2, 0, 1, 0, "<compat> 03C2" },
/* U+03f3 */ { 2, 0, 1, 0, 0 },
/* U+03f4 */ { 0, 0, 0, 0, 0 },
/* U+03f5 */ { 0, 0, 0, 0, 0 },
/* U+03f6 */ { 0, 0, 0, 0, 0 },
/* U+03f7 */ { 0, 0, 0, 0, 0 },
/* U+03f8 */ { 0, 0, 0, 0, 0 },
/* U+03f9 */ { 0, 0, 0, 0, 0 },
/* U+03fa */ { 0, 0, 0, 0, 0 },
/* U+03fb */ { 0, 0, 0, 0, 0 },
/* U+03fc */ { 0, 0, 0, 0, 0 },
/* U+03fd */ { 0, 0, 0, 0, 0 },
/* U+03fe */ { 0, 0, 0, 0, 0 },
/* U+03ff */ { 0, 0, 0, 0, 0 },
/* U+0400 */ { 1, 0, 1, 0, "0415 0300" },
/* U+0401 */ { 1, 0, 1, 0, "0415 0308" },
/* U+0402 */ { 1, 0, 1, 0, 0 },
/* U+0403 */ { 1, 0, 1, 0, "0413 0301" },
/* U+0404 */ { 1, 0, 1, 0, 0 },
/* U+0405 */ { 1, 0, 1, 0, 0 },
/* U+0406 */ { 1, 0, 1, 0, 0 },
/* U+0407 */ { 1, 0, 1, 0, "0406 0308" },
/* U+0408 */ { 1, 0, 1, 0, 0 },
/* U+0409 */ { 1, 0, 1, 0, 0 },
/* U+040a */ { 1, 0, 1, 0, 0 },
/* U+040b */ { 1, 0, 1, 0, 0 },
/* U+040c */ { 1, 0, 1, 0, "041A 0301" },
/* U+040d */ { 1, 0, 1, 0, "0418 0300" },
/* U+040e */ { 1, 0, 1, 0, "0423 0306" },
/* U+040f */ { 1, 0, 1, 0, 0 },
/* U+0410 */ { 1, 0, 1, 0, 0 },
/* U+0411 */ { 1, 0, 1, 0, 0 },
/* U+0412 */ { 1, 0, 1, 0, 0 },
/* U+0413 */ { 1, 0, 1, 0, 0 },
/* U+0414 */ { 1, 0, 1, 0, 0 },
/* U+0415 */ { 1, 0, 1, 0, 0 },
/* U+0416 */ { 1, 0, 1, 0, 0 },
/* U+0417 */ { 1, 0, 1, 0, 0 },
/* U+0418 */ { 1, 0, 1, 0, 0 },
/* U+0419 */ { 1, 0, 1, 0, "0418 0306" },
/* U+041a */ { 1, 0, 1, 0, 0 },
/* U+041b */ { 1, 0, 1, 0, 0 },
/* U+041c */ { 1, 0, 1, 0, 0 },
/* U+041d */ { 1, 0, 1, 0, 0 },
/* U+041e */ { 1, 0, 1, 0, 0 },
/* U+041f */ { 1, 0, 1, 0, 0 },
/* U+0420 */ { 1, 0, 1, 0, 0 },
/* U+0421 */ { 1, 0, 1, 0, 0 },
/* U+0422 */ { 1, 0, 1, 0, 0 },
/* U+0423 */ { 1, 0, 1, 0, 0 },
/* U+0424 */ { 1, 0, 1, 0, 0 },
/* U+0425 */ { 1, 0, 1, 0, 0 },
/* U+0426 */ { 1, 0, 1, 0, 0 },
/* U+0427 */ { 1, 0, 1, 0, 0 },
/* U+0428 */ { 1, 0, 1, 0, 0 },
/* U+0429 */ { 1, 0, 1, 0, 0 },
/* U+042a */ { 1, 0, 1, 0, 0 },
/* U+042b */ { 1, 0, 1, 0, 0 },
/* U+042c */ { 1, 0, 1, 0, 0 },
/* U+042d */ { 1, 0, 1, 0, 0 },
/* U+042e */ { 1, 0, 1, 0, 0 },
/* U+042f */ { 1, 0, 1, 0, 0 },
/* U+0430 */ { 2, 0, 1, 0, 0 },
/* U+0431 */ { 2, 0, 1, 0, 0 },
/* U+0432 */ { 2, 0, 1, 0, 0 },
/* U+0433 */ { 2, 0, 1, 0, 0 },
/* U+0434 */ { 2, 0, 1, 0, 0 },
/* U+0435 */ { 2, 0, 1, 0, 0 },
/* U+0436 */ { 2, 0, 1, 0, 0 },
/* U+0437 */ { 2, 0, 1, 0, 0 },
/* U+0438 */ { 2, 0, 1, 0, 0 },
/* U+0439 */ { 2, 0, 1, 0, "0438 0306" },
/* U+043a */ { 2, 0, 1, 0, 0 },
/* U+043b */ { 2, 0, 1, 0, 0 },
/* U+043c */ { 2, 0, 1, 0, 0 },
/* U+043d */ { 2, 0, 1, 0, 0 },
/* U+043e */ { 2, 0, 1, 0, 0 },
/* U+043f */ { 2, 0, 1, 0, 0 },
/* U+0440 */ { 2, 0, 1, 0, 0 },
/* U+0441 */ { 2, 0, 1, 0, 0 },
/* U+0442 */ { 2, 0, 1, 0, 0 },
/* U+0443 */ { 2, 0, 1, 0, 0 },
/* U+0444 */ { 2, 0, 1, 0, 0 },
/* U+0445 */ { 2, 0, 1, 0, 0 },
/* U+0446 */ { 2, 0, 1, 0, 0 },
/* U+0447 */ { 2, 0, 1, 0, 0 },
/* U+0448 */ { 2, 0, 1, 0, 0 },
/* U+0449 */ { 2, 0, 1, 0, 0 },
/* U+044a */ { 2, 0, 1, 0, 0 },
/* U+044b */ { 2, 0, 1, 0, 0 },
/* U+044c */ { 2, 0, 1, 0, 0 },
/* U+044d */ { 2, 0, 1, 0, 0 },
/* U+044e */ { 2, 0, 1, 0, 0 },
/* U+044f */ { 2, 0, 1, 0, 0 },
/* U+0450 */ { 2, 0, 1, 0, "0435 0300" },
/* U+0451 */ { 2, 0, 1, 0, "0435 0308" },
/* U+0452 */ { 2, 0, 1, 0, 0 },
/* U+0453 */ { 2, 0, 1, 0, "0433 0301" },
/* U+0454 */ { 2, 0, 1, 0, 0 },
/* U+0455 */ { 2, 0, 1, 0, 0 },
/* U+0456 */ { 2, 0, 1, 0, 0 },
/* U+0457 */ { 2, 0, 1, 0, "0456 0308" },
/* U+0458 */ { 2, 0, 1, 0, 0 },
/* U+0459 */ { 2, 0, 1, 0, 0 },
/* U+045a */ { 2, 0, 1, 0, 0 },
/* U+045b */ { 2, 0, 1, 0, 0 },
/* U+045c */ { 2, 0, 1, 0, "043A 0301" },
/* U+045d */ { 2, 0, 1, 0, "0438 0300" },
/* U+045e */ { 2, 0, 1, 0, "0443 0306" },
/* U+045f */ { 2, 0, 1, 0, 0 },
/* U+0460 */ { 1, 0, 1, 0, 0 },
/* U+0461 */ { 2, 0, 1, 0, 0 },
/* U+0462 */ { 1, 0, 1, 0, 0 },
/* U+0463 */ { 2, 0, 1, 0, 0 },
/* U+0464 */ { 1, 0, 1, 0, 0 },
/* U+0465 */ { 2, 0, 1, 0, 0 },
/* U+0466 */ { 1, 0, 1, 0, 0 },
/* U+0467 */ { 2, 0, 1, 0, 0 },
/* U+0468 */ { 1, 0, 1, 0, 0 },
/* U+0469 */ { 2, 0, 1, 0, 0 },
/* U+046a */ { 1, 0, 1, 0, 0 },
/* U+046b */ { 2, 0, 1, 0, 0 },
/* U+046c */ { 1, 0, 1, 0, 0 },
/* U+046d */ { 2, 0, 1, 0, 0 },
/* U+046e */ { 1, 0, 1, 0, 0 },
/* U+046f */ { 2, 0, 1, 0, 0 },
/* U+0470 */ { 1, 0, 1, 0, 0 },
/* U+0471 */ { 2, 0, 1, 0, 0 },
/* U+0472 */ { 1, 0, 1, 0, 0 },
/* U+0473 */ { 2, 0, 1, 0, 0 },
/* U+0474 */ { 1, 0, 1, 0, 0 },
/* U+0475 */ { 2, 0, 1, 0, 0 },
/* U+0476 */ { 1, 0, 1, 0, "0474 030F" },
/* U+0477 */ { 2, 0, 1, 0, "0475 030F" },
/* U+0478 */ { 1, 0, 1, 0, 0 },
/* U+0479 */ { 2, 0, 1, 0, 0 },
/* U+047a */ { 1, 0, 1, 0, 0 },
/* U+047b */ { 2, 0, 1, 0, 0 },
/* U+047c */ { 1, 0, 1, 0, 0 },
/* U+047d */ { 2, 0, 1, 0, 0 },
/* U+047e */ { 1, 0, 1, 0, 0 },
/* U+047f */ { 2, 0, 1, 0, 0 },
/* U+0480 */ { 1, 0, 1, 0, 0 },
/* U+0481 */ { 2, 0, 1, 0, 0 },
/* U+0482 */ { 30, 0, 1, 0, 0 },
/* U+0483 */ { 4, 230, 14, 0, 0 },
/* U+0484 */ { 4, 230, 14, 0, 0 },
/* U+0485 */ { 4, 230, 14, 0, 0 },
/* U+0486 */ { 4, 230, 14, 0, 0 },
/* U+0487 */ { 0, 0, 0, 0, 0 },
/* U+0488 */ { 6, 0, 14, 0, 0 },
/* U+0489 */ { 6, 0, 14, 0, 0 },
/* U+048a */ { 0, 0, 0, 0, 0 },
/* U+048b */ { 0, 0, 0, 0, 0 },
/* U+048c */ { 1, 0, 1, 0, 0 },
/* U+048d */ { 2, 0, 1, 0, 0 },
/* U+048e */ { 1, 0, 1, 0, 0 },
/* U+048f */ { 2, 0, 1, 0, 0 },
/* U+0490 */ { 1, 0, 1, 0, 0 },
/* U+0491 */ { 2, 0, 1, 0, 0 },
/* U+0492 */ { 1, 0, 1, 0, 0 },
/* U+0493 */ { 2, 0, 1, 0, 0 },
/* U+0494 */ { 1, 0, 1, 0, 0 },
/* U+0495 */ { 2, 0, 1, 0, 0 },
/* U+0496 */ { 1, 0, 1, 0, 0 },
/* U+0497 */ { 2, 0, 1, 0, 0 },
/* U+0498 */ { 1, 0, 1, 0, 0 },
/* U+0499 */ { 2, 0, 1, 0, 0 },
/* U+049a */ { 1, 0, 1, 0, 0 },
/* U+049b */ { 2, 0, 1, 0, 0 },
/* U+049c */ { 1, 0, 1, 0, 0 },
/* U+049d */ { 2, 0, 1, 0, 0 },
/* U+049e */ { 1, 0, 1, 0, 0 },
/* U+049f */ { 2, 0, 1, 0, 0 },
/* U+04a0 */ { 1, 0, 1, 0, 0 },
/* U+04a1 */ { 2, 0, 1, 0, 0 },
/* U+04a2 */ { 1, 0, 1, 0, 0 },
/* U+04a3 */ { 2, 0, 1, 0, 0 },
/* U+04a4 */ { 1, 0, 1, 0, 0 },
/* U+04a5 */ { 2, 0, 1, 0, 0 },
/* U+04a6 */ { 1, 0, 1, 0, 0 },
/* U+04a7 */ { 2, 0, 1, 0, 0 },
/* U+04a8 */ { 1, 0, 1, 0, 0 },
/* U+04a9 */ { 2, 0, 1, 0, 0 },
/* U+04aa */ { 1, 0, 1, 0, 0 },
/* U+04ab */ { 2, 0, 1, 0, 0 },
/* U+04ac */ { 1, 0, 1, 0, 0 },
/* U+04ad */ { 2, 0, 1, 0, 0 },
/* U+04ae */ { 1, 0, 1, 0, 0 },
/* U+04af */ { 2, 0, 1, 0, 0 },
/* U+04b0 */ { 1, 0, 1, 0, 0 },
/* U+04b1 */ { 2, 0, 1, 0, 0 },
/* U+04b2 */ { 1, 0, 1, 0, 0 },
/* U+04b3 */ { 2, 0, 1, 0, 0 },
/* U+04b4 */ { 1, 0, 1, 0, 0 },
/* U+04b5 */ { 2, 0, 1, 0, 0 },
/* U+04b6 */ { 1, 0, 1, 0, 0 },
/* U+04b7 */ { 2, 0, 1, 0, 0 },
/* U+04b8 */ { 1, 0, 1, 0, 0 },
/* U+04b9 */ { 2, 0, 1, 0, 0 },
/* U+04ba */ { 1, 0, 1, 0, 0 },
/* U+04bb */ { 2, 0, 1, 0, 0 },
/* U+04bc */ { 1, 0, 1, 0, 0 },
/* U+04bd */ { 2, 0, 1, 0, 0 },
/* U+04be */ { 1, 0, 1, 0, 0 },
/* U+04bf */ { 2, 0, 1, 0, 0 },
/* U+04c0 */ { 1, 0, 1, 0, 0 },
/* U+04c1 */ { 1, 0, 1, 0, "0416 0306" },
/* U+04c2 */ { 2, 0, 1, 0, "0436 0306" },
/* U+04c3 */ { 1, 0, 1, 0, 0 },
/* U+04c4 */ { 2, 0, 1, 0, 0 },
/* U+04c5 */ { 0, 0, 0, 0, 0 },
/* U+04c6 */ { 0, 0, 0, 0, 0 },
/* U+04c7 */ { 1, 0, 1, 0, 0 },
/* U+04c8 */ { 2, 0, 1, 0, 0 },
/* U+04c9 */ { 0, 0, 0, 0, 0 },
/* U+04ca */ { 0, 0, 0, 0, 0 },
/* U+04cb */ { 1, 0, 1, 0, 0 },
/* U+04cc */ { 2, 0, 1, 0, 0 },
/* U+04cd */ { 0, 0, 0, 0, 0 },
/* U+04ce */ { 0, 0, 0, 0, 0 },
/* U+04cf */ { 0, 0, 0, 0, 0 },
/* U+04d0 */ { 1, 0, 1, 0, "0410 0306" },
/* U+04d1 */ { 2, 0, 1, 0, "0430 0306" },
/* U+04d2 */ { 1, 0, 1, 0, "0410 0308" },
/* U+04d3 */ { 2, 0, 1, 0, "0430 0308" },
/* U+04d4 */ { 1, 0, 1, 0, 0 },
/* U+04d5 */ { 2, 0, 1, 0, 0 },
/* U+04d6 */ { 1, 0, 1, 0, "0415 0306" },
/* U+04d7 */ { 2, 0, 1, 0, "0435 0306" },
/* U+04d8 */ { 1, 0, 1, 0, 0 },
/* U+04d9 */ { 2, 0, 1, 0, 0 },
/* U+04da */ { 1, 0, 1, 0, "04D8 0308" },
/* U+04db */ { 2, 0, 1, 0, "04D9 0308" },
/* U+04dc */ { 1, 0, 1, 0, "0416 0308" },
/* U+04dd */ { 2, 0, 1, 0, "0436 0308" },
/* U+04de */ { 1, 0, 1, 0, "0417 0308" },
/* U+04df */ { 2, 0, 1, 0, "0437 0308" },
/* U+04e0 */ { 1, 0, 1, 0, 0 },
/* U+04e1 */ { 2, 0, 1, 0, 0 },
/* U+04e2 */ { 1, 0, 1, 0, "0418 0304" },
/* U+04e3 */ { 2, 0, 1, 0, "0438 0304" },
/* U+04e4 */ { 1, 0, 1, 0, "0418 0308" },
/* U+04e5 */ { 2, 0, 1, 0, "0438 0308" },
/* U+04e6 */ { 1, 0, 1, 0, "041E 0308" },
/* U+04e7 */ { 2, 0, 1, 0, "043E 0308" },
/* U+04e8 */ { 1, 0, 1, 0, 0 },
/* U+04e9 */ { 2, 0, 1, 0, 0 },
/* U+04ea */ { 1, 0, 1, 0, "04E8 0308" },
/* U+04eb */ { 2, 0, 1, 0, "04E9 0308" },
/* U+04ec */ { 1, 0, 1, 0, "042D 0308" },
/* U+04ed */ { 2, 0, 1, 0, "044D 0308" },
/* U+04ee */ { 1, 0, 1, 0, "0423 0304" },
/* U+04ef */ { 2, 0, 1, 0, "0443 0304" },
/* U+04f0 */ { 1, 0, 1, 0, "0423 0308" },
/* U+04f1 */ { 2, 0, 1, 0, "0443 0308" },
/* U+04f2 */ { 1, 0, 1, 0, "0423 030B" },
/* U+04f3 */ { 2, 0, 1, 0, "0443 030B" },
/* U+04f4 */ { 1, 0, 1, 0, "0427 0308" },
/* U+04f5 */ { 2, 0, 1, 0, "0447 0308" },
/* U+04f6 */ { 0, 0, 0, 0, 0 },
/* U+04f7 */ { 0, 0, 0, 0, 0 },
/* U+04f8 */ { 1, 0, 1, 0, "042B 0308" },
/* U+04f9 */ { 2, 0, 1, 0, "044B 0308" },
/* U+04fa */ { 0, 0, 0, 0, 0 },
/* U+04fb */ { 0, 0, 0, 0, 0 },
/* U+04fc */ { 0, 0, 0, 0, 0 },
/* U+04fd */ { 0, 0, 0, 0, 0 },
/* U+04fe */ { 0, 0, 0, 0, 0 },
/* U+04ff */ { 0, 0, 0, 0, 0 },
/* U+0500 */ { 0, 0, 0, 0, 0 },
/* U+0501 */ { 0, 0, 0, 0, 0 },
/* U+0502 */ { 0, 0, 0, 0, 0 },
/* U+0503 */ { 0, 0, 0, 0, 0 },
/* U+0504 */ { 0, 0, 0, 0, 0 },
/* U+0505 */ { 0, 0, 0, 0, 0 },
/* U+0506 */ { 0, 0, 0, 0, 0 },
/* U+0507 */ { 0, 0, 0, 0, 0 },
/* U+0508 */ { 0, 0, 0, 0, 0 },
/* U+0509 */ { 0, 0, 0, 0, 0 },
/* U+050a */ { 0, 0, 0, 0, 0 },
/* U+050b */ { 0, 0, 0, 0, 0 },
/* U+050c */ { 0, 0, 0, 0, 0 },
/* U+050d */ { 0, 0, 0, 0, 0 },
/* U+050e */ { 0, 0, 0, 0, 0 },
/* U+050f */ { 0, 0, 0, 0, 0 },
/* U+0510 */ { 0, 0, 0, 0, 0 },
/* U+0511 */ { 0, 0, 0, 0, 0 },
/* U+0512 */ { 0, 0, 0, 0, 0 },
/* U+0513 */ { 0, 0, 0, 0, 0 },
/* U+0514 */ { 0, 0, 0, 0, 0 },
/* U+0515 */ { 0, 0, 0, 0, 0 },
/* U+0516 */ { 0, 0, 0, 0, 0 },
/* U+0517 */ { 0, 0, 0, 0, 0 },
/* U+0518 */ { 0, 0, 0, 0, 0 },
/* U+0519 */ { 0, 0, 0, 0, 0 },
/* U+051a */ { 0, 0, 0, 0, 0 },
/* U+051b */ { 0, 0, 0, 0, 0 },
/* U+051c */ { 0, 0, 0, 0, 0 },
/* U+051d */ { 0, 0, 0, 0, 0 },
/* U+051e */ { 0, 0, 0, 0, 0 },
/* U+051f */ { 0, 0, 0, 0, 0 },
/* U+0520 */ { 0, 0, 0, 0, 0 },
/* U+0521 */ { 0, 0, 0, 0, 0 },
/* U+0522 */ { 0, 0, 0, 0, 0 },
/* U+0523 */ { 0, 0, 0, 0, 0 },
/* U+0524 */ { 0, 0, 0, 0, 0 },
/* U+0525 */ { 0, 0, 0, 0, 0 },
/* U+0526 */ { 0, 0, 0, 0, 0 },
/* U+0527 */ { 0, 0, 0, 0, 0 },
/* U+0528 */ { 0, 0, 0, 0, 0 },
/* U+0529 */ { 0, 0, 0, 0, 0 },
/* U+052a */ { 0, 0, 0, 0, 0 },
/* U+052b */ { 0, 0, 0, 0, 0 },
/* U+052c */ { 0, 0, 0, 0, 0 },
/* U+052d */ { 0, 0, 0, 0, 0 },
/* U+052e */ { 0, 0, 0, 0, 0 },
/* U+052f */ { 0, 0, 0, 0, 0 },
/* U+0530 */ { 0, 0, 0, 0, 0 },
/* U+0531 */ { 1, 0, 1, 0, 0 },
/* U+0532 */ { 1, 0, 1, 0, 0 },
/* U+0533 */ { 1, 0, 1, 0, 0 },
/* U+0534 */ { 1, 0, 1, 0, 0 },
/* U+0535 */ { 1, 0, 1, 0, 0 },
/* U+0536 */ { 1, 0, 1, 0, 0 },
/* U+0537 */ { 1, 0, 1, 0, 0 },
/* U+0538 */ { 1, 0, 1, 0, 0 },
/* U+0539 */ { 1, 0, 1, 0, 0 },
/* U+053a */ { 1, 0, 1, 0, 0 },
/* U+053b */ { 1, 0, 1, 0, 0 },
/* U+053c */ { 1, 0, 1, 0, 0 },
/* U+053d */ { 1, 0, 1, 0, 0 },
/* U+053e */ { 1, 0, 1, 0, 0 },
/* U+053f */ { 1, 0, 1, 0, 0 },
/* U+0540 */ { 1, 0, 1, 0, 0 },
/* U+0541 */ { 1, 0, 1, 0, 0 },
/* U+0542 */ { 1, 0, 1, 0, 0 },
/* U+0543 */ { 1, 0, 1, 0, 0 },
/* U+0544 */ { 1, 0, 1, 0, 0 },
/* U+0545 */ { 1, 0, 1, 0, 0 },
/* U+0546 */ { 1, 0, 1, 0, 0 },
/* U+0547 */ { 1, 0, 1, 0, 0 },
/* U+0548 */ { 1, 0, 1, 0, 0 },
/* U+0549 */ { 1, 0, 1, 0, 0 },
/* U+054a */ { 1, 0, 1, 0, 0 },
/* U+054b */ { 1, 0, 1, 0, 0 },
/* U+054c */ { 1, 0, 1, 0, 0 },
/* U+054d */ { 1, 0, 1, 0, 0 },
/* U+054e */ { 1, 0, 1, 0, 0 },
/* U+054f */ { 1, 0, 1, 0, 0 },
/* U+0550 */ { 1, 0, 1, 0, 0 },
/* U+0551 */ { 1, 0, 1, 0, 0 },
/* U+0552 */ { 1, 0, 1, 0, 0 },
/* U+0553 */ { 1, 0, 1, 0, 0 },
/* U+0554 */ { 1, 0, 1, 0, 0 },
/* U+0555 */ { 1, 0, 1, 0, 0 },
/* U+0556 */ { 1, 0, 1, 0, 0 },
/* U+0557 */ { 0, 0, 0, 0, 0 },
/* U+0558 */ { 0, 0, 0, 0, 0 },
/* U+0559 */ { 18, 0, 1, 0, 0 },
/* U+055a */ { 26, 0, 1, 0, 0 },
/* U+055b */ { 26, 0, 1, 0, 0 },
/* U+055c */ { 26, 0, 1, 0, 0 },
/* U+055d */ { 26, 0, 1, 0, 0 },
/* U+055e */ { 26, 0, 1, 0, 0 },
/* U+055f */ { 26, 0, 1, 0, 0 },
/* U+0560 */ { 0, 0, 0, 0, 0 },
/* U+0561 */ { 2, 0, 1, 0, 0 },
/* U+0562 */ { 2, 0, 1, 0, 0 },
/* U+0563 */ { 2, 0, 1, 0, 0 },
/* U+0564 */ { 2, 0, 1, 0, 0 },
/* U+0565 */ { 2, 0, 1, 0, 0 },
/* U+0566 */ { 2, 0, 1, 0, 0 },
/* U+0567 */ { 2, 0, 1, 0, 0 },
/* U+0568 */ { 2, 0, 1, 0, 0 },
/* U+0569 */ { 2, 0, 1, 0, 0 },
/* U+056a */ { 2, 0, 1, 0, 0 },
/* U+056b */ { 2, 0, 1, 0, 0 },
/* U+056c */ { 2, 0, 1, 0, 0 },
/* U+056d */ { 2, 0, 1, 0, 0 },
/* U+056e */ { 2, 0, 1, 0, 0 },
/* U+056f */ { 2, 0, 1, 0, 0 },
/* U+0570 */ { 2, 0, 1, 0, 0 },
/* U+0571 */ { 2, 0, 1, 0, 0 },
/* U+0572 */ { 2, 0, 1, 0, 0 },
/* U+0573 */ { 2, 0, 1, 0, 0 },
/* U+0574 */ { 2, 0, 1, 0, 0 },
/* U+0575 */ { 2, 0, 1, 0, 0 },
/* U+0576 */ { 2, 0, 1, 0, 0 },
/* U+0577 */ { 2, 0, 1, 0, 0 },
/* U+0578 */ { 2, 0, 1, 0, 0 },
/* U+0579 */ { 2, 0, 1, 0, 0 },
/* U+057a */ { 2, 0, 1, 0, 0 },
/* U+057b */ { 2, 0, 1, 0, 0 },
/* U+057c */ { 2, 0, 1, 0, 0 },
/* U+057d */ { 2, 0, 1, 0, 0 },
/* U+057e */ { 2, 0, 1, 0, 0 },
/* U+057f */ { 2, 0, 1, 0, 0 },
/* U+0580 */ { 2, 0, 1, 0, 0 },
/* U+0581 */ { 2, 0, 1, 0, 0 },
/* U+0582 */ { 2, 0, 1, 0, 0 },
/* U+0583 */ { 2, 0, 1, 0, 0 },
/* U+0584 */ { 2, 0, 1, 0, 0 },
/* U+0585 */ { 2, 0, 1, 0, 0 },
/* U+0586 */ { 2, 0, 1, 0, 0 },
/* U+0587 */ { 2, 0, 1, 0, "<compat> 0565 0582" },
/* U+0588 */ { 0, 0, 0, 0, 0 },
/* U+0589 */ { 26, 0, 1, 0, 0 },
/* U+058a */ { 21, 0, 19, 0, 0 },
/* U+058b */ { 0, 0, 0, 0, 0 },
/* U+058c */ { 0, 0, 0, 0, 0 },
/* U+058d */ { 0, 0, 0, 0, 0 },
/* U+058e */ { 0, 0, 0, 0, 0 },
/* U+058f */ { 0, 0, 0, 0, 0 },
/* U+0590 */ { 0, 0, 0, 0, 0 },
/* U+0591 */ { 4, 220, 14, 0, 0 },
/* U+0592 */ { 4, 230, 14, 0, 0 },
/* U+0593 */ { 4, 230, 14, 0, 0 },
/* U+0594 */ { 4, 230, 14, 0, 0 },
/* U+0595 */ { 4, 230, 14, 0, 0 },
/* U+0596 */ { 4, 220, 14, 0, 0 },
/* U+0597 */ { 4, 230, 14, 0, 0 },
/* U+0598 */ { 4, 230, 14, 0, 0 },
/* U+0599 */ { 4, 230, 14, 0, 0 },
/* U+059a */ { 4, 222, 14, 0, 0 },
/* U+059b */ { 4, 220, 14, 0, 0 },
/* U+059c */ { 4, 230, 14, 0, 0 },
/* U+059d */ { 4, 230, 14, 0, 0 },
/* U+059e */ { 4, 230, 14, 0, 0 },
/* U+059f */ { 4, 230, 14, 0, 0 },
/* U+05a0 */ { 4, 230, 14, 0, 0 },
/* U+05a1 */ { 4, 230, 14, 0, 0 },
/* U+05a2 */ { 0, 0, 0, 0, 0 },
/* U+05a3 */ { 4, 220, 14, 0, 0 },
/* U+05a4 */ { 4, 220, 14, 0, 0 },
/* U+05a5 */ { 4, 220, 14, 0, 0 },
/* U+05a6 */ { 4, 220, 14, 0, 0 },
/* U+05a7 */ { 4, 220, 14, 0, 0 },
/* U+05a8 */ { 4, 230, 14, 0, 0 },
/* U+05a9 */ { 4, 230, 14, 0, 0 },
/* U+05aa */ { 4, 220, 14, 0, 0 },
/* U+05ab */ { 4, 230, 14, 0, 0 },
/* U+05ac */ { 4, 230, 14, 0, 0 },
/* U+05ad */ { 4, 222, 14, 0, 0 },
/* U+05ae */ { 4, 228, 14, 0, 0 },
/* U+05af */ { 4, 230, 14, 0, 0 },
/* U+05b0 */ { 4, 10, 14, 0, 0 },
/* U+05b1 */ { 4, 11, 14, 0, 0 },
/* U+05b2 */ { 4, 12, 14, 0, 0 },
/* U+05b3 */ { 4, 13, 14, 0, 0 },
/* U+05b4 */ { 4, 14, 14, 0, 0 },
/* U+05b5 */ { 4, 15, 14, 0, 0 },
/* U+05b6 */ { 4, 16, 14, 0, 0 },
/* U+05b7 */ { 4, 17, 14, 0, 0 },
/* U+05b8 */ { 4, 18, 14, 0, 0 },
/* U+05b9 */ { 4, 19, 14, 0, 0 },
/* U+05ba */ { 0, 0, 0, 0, 0 },
/* U+05bb */ { 4, 20, 14, 0, 0 },
/* U+05bc */ { 4, 21, 14, 0, 0 },
/* U+05bd */ { 4, 22, 14, 0, 0 },
/* U+05be */ { 26, 0, 4, 0, 0 },
/* U+05bf */ { 4, 23, 14, 0, 0 },
/* U+05c0 */ { 26, 0, 4, 0, 0 },
/* U+05c1 */ { 4, 24, 14, 0, 0 },
/* U+05c2 */ { 4, 25, 14, 0, 0 },
/* U+05c3 */ { 26, 0, 4, 0, 0 },
/* U+05c4 */ { 4, 230, 14, 0, 0 },
/* U+05c5 */ { 0, 0, 0, 0, 0 },
/* U+05c6 */ { 0, 0, 0, 0, 0 },
/* U+05c7 */ { 0, 0, 0, 0, 0 },
/* U+05c8 */ { 0, 0, 0, 0, 0 },
/* U+05c9 */ { 0, 0, 0, 0, 0 },
/* U+05ca */ { 0, 0, 0, 0, 0 },
/* U+05cb */ { 0, 0, 0, 0, 0 },
/* U+05cc */ { 0, 0, 0, 0, 0 },
/* U+05cd */ { 0, 0, 0, 0, 0 },
/* U+05ce */ { 0, 0, 0, 0, 0 },
/* U+05cf */ { 0, 0, 0, 0, 0 },
/* U+05d0 */ { 19, 0, 4, 0, 0 },
/* U+05d1 */ { 19, 0, 4, 0, 0 },
/* U+05d2 */ { 19, 0, 4, 0, 0 },
/* U+05d3 */ { 19, 0, 4, 0, 0 },
/* U+05d4 */ { 19, 0, 4, 0, 0 },
/* U+05d5 */ { 19, 0, 4, 0, 0 },
/* U+05d6 */ { 19, 0, 4, 0, 0 },
/* U+05d7 */ { 19, 0, 4, 0, 0 },
/* U+05d8 */ { 19, 0, 4, 0, 0 },
/* U+05d9 */ { 19, 0, 4, 0, 0 },
/* U+05da */ { 19, 0, 4, 0, 0 },
/* U+05db */ { 19, 0, 4, 0, 0 },
/* U+05dc */ { 19, 0, 4, 0, 0 },
/* U+05dd */ { 19, 0, 4, 0, 0 },
/* U+05de */ { 19, 0, 4, 0, 0 },
/* U+05df */ { 19, 0, 4, 0, 0 },
/* U+05e0 */ { 19, 0, 4, 0, 0 },
/* U+05e1 */ { 19, 0, 4, 0, 0 },
/* U+05e2 */ { 19, 0, 4, 0, 0 },
/* U+05e3 */ { 19, 0, 4, 0, 0 },
/* U+05e4 */ { 19, 0, 4, 0, 0 },
/* U+05e5 */ { 19, 0, 4, 0, 0 },
/* U+05e6 */ { 19, 0, 4, 0, 0 },
/* U+05e7 */ { 19, 0, 4, 0, 0 },
/* U+05e8 */ { 19, 0, 4, 0, 0 },
/* U+05e9 */ { 19, 0, 4, 0, 0 },
/* U+05ea */ { 19, 0, 4, 0, 0 },
/* U+05eb */ { 0, 0, 0, 0, 0 },
/* U+05ec */ { 0, 0, 0, 0, 0 },
/* U+05ed */ { 0, 0, 0, 0, 0 },
/* U+05ee */ { 0, 0, 0, 0, 0 },
/* U+05ef */ { 0, 0, 0, 0, 0 },
/* U+05f0 */ { 19, 0, 4, 0, 0 },
/* U+05f1 */ { 19, 0, 4, 0, 0 },
/* U+05f2 */ { 19, 0, 4, 0, 0 },
/* U+05f3 */ { 26, 0, 4, 0, 0 },
/* U+05f4 */ { 26, 0, 4, 0, 0 },
/* U+05f5 */ { 0, 0, 0, 0, 0 },
/* U+05f6 */ { 0, 0, 0, 0, 0 },
/* U+05f7 */ { 0, 0, 0, 0, 0 },
/* U+05f8 */ { 0, 0, 0, 0, 0 },
/* U+05f9 */ { 0, 0, 0, 0, 0 },
/* U+05fa */ { 0, 0, 0, 0, 0 },
/* U+05fb */ { 0, 0, 0, 0, 0 },
/* U+05fc */ { 0, 0, 0, 0, 0 },
/* U+05fd */ { 0, 0, 0, 0, 0 },
/* U+05fe */ { 0, 0, 0, 0, 0 },
/* U+05ff */ { 0, 0, 0, 0, 0 },
/* U+0600 */ { 0, 0, 0, 0, 0 },
/* U+0601 */ { 0, 0, 0, 0, 0 },
/* U+0602 */ { 0, 0, 0, 0, 0 },
/* U+0603 */ { 0, 0, 0, 0, 0 },
/* U+0604 */ { 0, 0, 0, 0, 0 },
/* U+0605 */ { 0, 0, 0, 0, 0 },
/* U+0606 */ { 0, 0, 0, 0, 0 },
/* U+0607 */ { 0, 0, 0, 0, 0 },
/* U+0608 */ { 0, 0, 0, 0, 0 },
/* U+0609 */ { 0, 0, 0, 0, 0 },
/* U+060a */ { 0, 0, 0, 0, 0 },
/* U+060b */ { 0, 0, 0, 0, 0 },
/* U+060c */ { 26, 0, 13, 0, 0 },
/* U+060d */ { 0, 0, 0, 0, 0 },
/* U+060e */ { 0, 0, 0, 0, 0 },
/* U+060f */ { 0, 0, 0, 0, 0 },
/* U+0610 */ { 0, 0, 0, 0, 0 },
/* U+0611 */ { 0, 0, 0, 0, 0 },
/* U+0612 */ { 0, 0, 0, 0, 0 },
/* U+0613 */ { 0, 0, 0, 0, 0 },
/* U+0614 */ { 0, 0, 0, 0, 0 },
/* U+0615 */ { 0, 0, 0, 0, 0 },
/* U+0616 */ { 0, 0, 0, 0, 0 },
/* U+0617 */ { 0, 0, 0, 0, 0 },
/* U+0618 */ { 0, 0, 0, 0, 0 },
/* U+0619 */ { 0, 0, 0, 0, 0 },
/* U+061a */ { 0, 0, 0, 0, 0 },
/* U+061b */ { 26, 0, 5, 0, 0 },
/* U+061c */ { 0, 0, 0, 0, 0 },
/* U+061d */ { 0, 0, 0, 0, 0 },
/* U+061e */ { 0, 0, 0, 0, 0 },
/* U+061f */ { 26, 0, 5, 0, 0 },
/* U+0620 */ { 0, 0, 0, 0, 0 },
/* U+0621 */ { 19, 0, 5, 0, 0 },
/* U+0622 */ { 19, 0, 5, 0, "0627 0653" },
/* U+0623 */ { 19, 0, 5, 0, "0627 0654" },
/* U+0624 */ { 19, 0, 5, 0, "0648 0654" },
/* U+0625 */ { 19, 0, 5, 0, "0627 0655" },
/* U+0626 */ { 19, 0, 5, 0, "064A 0654" },
/* U+0627 */ { 19, 0, 5, 0, 0 },
/* U+0628 */ { 19, 0, 5, 0, 0 },
/* U+0629 */ { 19, 0, 5, 0, 0 },
/* U+062a */ { 19, 0, 5, 0, 0 },
/* U+062b */ { 19, 0, 5, 0, 0 },
/* U+062c */ { 19, 0, 5, 0, 0 },
/* U+062d */ { 19, 0, 5, 0, 0 },
/* U+062e */ { 19, 0, 5, 0, 0 },
/* U+062f */ { 19, 0, 5, 0, 0 },
/* U+0630 */ { 19, 0, 5, 0, 0 },
/* U+0631 */ { 19, 0, 5, 0, 0 },
/* U+0632 */ { 19, 0, 5, 0, 0 },
/* U+0633 */ { 19, 0, 5, 0, 0 },
/* U+0634 */ { 19, 0, 5, 0, 0 },
/* U+0635 */ { 19, 0, 5, 0, 0 },
/* U+0636 */ { 19, 0, 5, 0, 0 },
/* U+0637 */ { 19, 0, 5, 0, 0 },
/* U+0638 */ { 19, 0, 5, 0, 0 },
/* U+0639 */ { 19, 0, 5, 0, 0 },
/* U+063a */ { 19, 0, 5, 0, 0 },
/* U+063b */ { 0, 0, 0, 0, 0 },
/* U+063c */ { 0, 0, 0, 0, 0 },
/* U+063d */ { 0, 0, 0, 0, 0 },
/* U+063e */ { 0, 0, 0, 0, 0 },
/* U+063f */ { 0, 0, 0, 0, 0 },
/* U+0640 */ { 18, 0, 5, 0, 0 },
/* U+0641 */ { 19, 0, 5, 0, 0 },
/* U+0642 */ { 19, 0, 5, 0, 0 },
/* U+0643 */ { 19, 0, 5, 0, 0 },
/* U+0644 */ { 19, 0, 5, 0, 0 },
/* U+0645 */ { 19, 0, 5, 0, 0 },
/* U+0646 */ { 19, 0, 5, 0, 0 },
/* U+0647 */ { 19, 0, 5, 0, 0 },
/* U+0648 */ { 19, 0, 5, 0, 0 },
/* U+0649 */ { 19, 0, 5, 0, 0 },
/* U+064a */ { 19, 0, 5, 0, 0 },
/* U+064b */ { 4, 27, 14, 0, 0 },
/* U+064c */ { 4, 28, 14, 0, 0 },
/* U+064d */ { 4, 29, 14, 0, 0 },
/* U+064e */ { 4, 30, 14, 0, 0 },
/* U+064f */ { 4, 31, 14, 0, 0 },
/* U+0650 */ { 4, 32, 14, 0, 0 },
/* U+0651 */ { 4, 33, 14, 0, 0 },
/* U+0652 */ { 4, 34, 14, 0, 0 },
/* U+0653 */ { 4, 230, 14, 0, 0 },
/* U+0654 */ { 4, 230, 14, 0, 0 },
/* U+0655 */ { 4, 220, 14, 0, 0 },
/* U+0656 */ { 0, 0, 0, 0, 0 },
/* U+0657 */ { 0, 0, 0, 0, 0 },
/* U+0658 */ { 0, 0, 0, 0, 0 },
/* U+0659 */ { 0, 0, 0, 0, 0 },
/* U+065a */ { 0, 0, 0, 0, 0 },
/* U+065b */ { 0, 0, 0, 0, 0 },
/* U+065c */ { 0, 0, 0, 0, 0 },
/* U+065d */ { 0, 0, 0, 0, 0 },
/* U+065e */ { 0, 0, 0, 0, 0 },
/* U+065f */ { 0, 0, 0, 0, 0 },
/* U+0660 */ { 7, 0, 12, 0, 0 },
/* U+0661 */ { 7, 0, 12, 0, 0 },
/* U+0662 */ { 7, 0, 12, 0, 0 },
/* U+0663 */ { 7, 0, 12, 0, 0 },
/* U+0664 */ { 7, 0, 12, 0, 0 },
/* U+0665 */ { 7, 0, 12, 0, 0 },
/* U+0666 */ { 7, 0, 12, 0, 0 },
/* U+0667 */ { 7, 0, 12, 0, 0 },
/* U+0668 */ { 7, 0, 12, 0, 0 },
/* U+0669 */ { 7, 0, 12, 0, 0 },
/* U+066a */ { 26, 0, 11, 0, 0 },
/* U+066b */ { 26, 0, 12, 0, 0 },
/* U+066c */ { 26, 0, 12, 0, 0 },
/* U+066d */ { 26, 0, 5, 0, 0 },
/* U+066e */ { 0, 0, 0, 0, 0 },
/* U+066f */ { 0, 0, 0, 0, 0 },
/* U+0670 */ { 4, 35, 14, 0, 0 },
/* U+0671 */ { 19, 0, 5, 0, 0 },
/* U+0672 */ { 19, 0, 5, 0, 0 },
/* U+0673 */ { 19, 0, 5, 0, 0 },
/* U+0674 */ { 19, 0, 5, 0, 0 },
/* U+0675 */ { 19, 0, 5, 0, "<compat> 0627 0674" },
/* U+0676 */ { 19, 0, 5, 0, "<compat> 0648 0674" },
/* U+0677 */ { 19, 0, 5, 0, "<compat> 06C7 0674" },
/* U+0678 */ { 19, 0, 5, 0, "<compat> 064A 0674" },
/* U+0679 */ { 19, 0, 5, 0, 0 },
/* U+067a */ { 19, 0, 5, 0, 0 },
/* U+067b */ { 19, 0, 5, 0, 0 },
/* U+067c */ { 19, 0, 5, 0, 0 },
/* U+067d */ { 19, 0, 5, 0, 0 },
/* U+067e */ { 19, 0, 5, 0, 0 },
/* U+067f */ { 19, 0, 5, 0, 0 },
/* U+0680 */ { 19, 0, 5, 0, 0 },
/* U+0681 */ { 19, 0, 5, 0, 0 },
/* U+0682 */ { 19, 0, 5, 0, 0 },
/* U+0683 */ { 19, 0, 5, 0, 0 },
/* U+0684 */ { 19, 0, 5, 0, 0 },
/* U+0685 */ { 19, 0, 5, 0, 0 },
/* U+0686 */ { 19, 0, 5, 0, 0 },
/* U+0687 */ { 19, 0, 5, 0, 0 },
/* U+0688 */ { 19, 0, 5, 0, 0 },
/* U+0689 */ { 19, 0, 5, 0, 0 },
/* U+068a */ { 19, 0, 5, 0, 0 },
/* U+068b */ { 19, 0, 5, 0, 0 },
/* U+068c */ { 19, 0, 5, 0, 0 },
/* U+068d */ { 19, 0, 5, 0, 0 },
/* U+068e */ { 19, 0, 5, 0, 0 },
/* U+068f */ { 19, 0, 5, 0, 0 },
/* U+0690 */ { 19, 0, 5, 0, 0 },
/* U+0691 */ { 19, 0, 5, 0, 0 },
/* U+0692 */ { 19, 0, 5, 0, 0 },
/* U+0693 */ { 19, 0, 5, 0, 0 },
/* U+0694 */ { 19, 0, 5, 0, 0 },
/* U+0695 */ { 19, 0, 5, 0, 0 },
/* U+0696 */ { 19, 0, 5, 0, 0 },
/* U+0697 */ { 19, 0, 5, 0, 0 },
/* U+0698 */ { 19, 0, 5, 0, 0 },
/* U+0699 */ { 19, 0, 5, 0, 0 },
/* U+069a */ { 19, 0, 5, 0, 0 },
/* U+069b */ { 19, 0, 5, 0, 0 },
/* U+069c */ { 19, 0, 5, 0, 0 },
/* U+069d */ { 19, 0, 5, 0, 0 },
/* U+069e */ { 19, 0, 5, 0, 0 },
/* U+069f */ { 19, 0, 5, 0, 0 },
/* U+06a0 */ { 19, 0, 5, 0, 0 },
/* U+06a1 */ { 19, 0, 5, 0, 0 },
/* U+06a2 */ { 19, 0, 5, 0, 0 },
/* U+06a3 */ { 19, 0, 5, 0, 0 },
/* U+06a4 */ { 19, 0, 5, 0, 0 },
/* U+06a5 */ { 19, 0, 5, 0, 0 },
/* U+06a6 */ { 19, 0, 5, 0, 0 },
/* U+06a7 */ { 19, 0, 5, 0, 0 },
/* U+06a8 */ { 19, 0, 5, 0, 0 },
/* U+06a9 */ { 19, 0, 5, 0, 0 },
/* U+06aa */ { 19, 0, 5, 0, 0 },
/* U+06ab */ { 19, 0, 5, 0, 0 },
/* U+06ac */ { 19, 0, 5, 0, 0 },
/* U+06ad */ { 19, 0, 5, 0, 0 },
/* U+06ae */ { 19, 0, 5, 0, 0 },
/* U+06af */ { 19, 0, 5, 0, 0 },
/* U+06b0 */ { 19, 0, 5, 0, 0 },
/* U+06b1 */ { 19, 0, 5, 0, 0 },
/* U+06b2 */ { 19, 0, 5, 0, 0 },
/* U+06b3 */ { 19, 0, 5, 0, 0 },
/* U+06b4 */ { 19, 0, 5, 0, 0 },
/* U+06b5 */ { 19, 0, 5, 0, 0 },
/* U+06b6 */ { 19, 0, 5, 0, 0 },
/* U+06b7 */ { 19, 0, 5, 0, 0 },
/* U+06b8 */ { 19, 0, 5, 0, 0 },
/* U+06b9 */ { 19, 0, 5, 0, 0 },
/* U+06ba */ { 19, 0, 5, 0, 0 },
/* U+06bb */ { 19, 0, 5, 0, 0 },
/* U+06bc */ { 19, 0, 5, 0, 0 },
/* U+06bd */ { 19, 0, 5, 0, 0 },
/* U+06be */ { 19, 0, 5, 0, 0 },
/* U+06bf */ { 19, 0, 5, 0, 0 },
/* U+06c0 */ { 19, 0, 5, 0, "06D5 0654" },
/* U+06c1 */ { 19, 0, 5, 0, 0 },
/* U+06c2 */ { 19, 0, 5, 0, "06C1 0654" },
/* U+06c3 */ { 19, 0, 5, 0, 0 },
/* U+06c4 */ { 19, 0, 5, 0, 0 },
/* U+06c5 */ { 19, 0, 5, 0, 0 },
/* U+06c6 */ { 19, 0, 5, 0, 0 },
/* U+06c7 */ { 19, 0, 5, 0, 0 },
/* U+06c8 */ { 19, 0, 5, 0, 0 },
/* U+06c9 */ { 19, 0, 5, 0, 0 },
/* U+06ca */ { 19, 0, 5, 0, 0 },
/* U+06cb */ { 19, 0, 5, 0, 0 },
/* U+06cc */ { 19, 0, 5, 0, 0 },
/* U+06cd */ { 19, 0, 5, 0, 0 },
/* U+06ce */ { 19, 0, 5, 0, 0 },
/* U+06cf */ { 19, 0, 5, 0, 0 },
/* U+06d0 */ { 19, 0, 5, 0, 0 },
/* U+06d1 */ { 19, 0, 5, 0, 0 },
/* U+06d2 */ { 19, 0, 5, 0, 0 },
/* U+06d3 */ { 19, 0, 5, 0, "06D2 0654" },
/* U+06d4 */ { 26, 0, 5, 0, 0 },
/* U+06d5 */ { 19, 0, 5, 0, 0 },
/* U+06d6 */ { 4, 230, 14, 0, 0 },
/* U+06d7 */ { 4, 230, 14, 0, 0 },
/* U+06d8 */ { 4, 230, 14, 0, 0 },
/* U+06d9 */ { 4, 230, 14, 0, 0 },
/* U+06da */ { 4, 230, 14, 0, 0 },
/* U+06db */ { 4, 230, 14, 0, 0 },
/* U+06dc */ { 4, 230, 14, 0, 0 },
/* U+06dd */ { 6, 0, 14, 0, 0 },
/* U+06de */ { 6, 0, 14, 0, 0 },
/* U+06df */ { 4, 230, 14, 0, 0 },
/* U+06e0 */ { 4, 230, 14, 0, 0 },
/* U+06e1 */ { 4, 230, 14, 0, 0 },
/* U+06e2 */ { 4, 230, 14, 0, 0 },
/* U+06e3 */ { 4, 220, 14, 0, 0 },
/* U+06e4 */ { 4, 230, 14, 0, 0 },
/* U+06e5 */ { 18, 0, 5, 0, 0 },
/* U+06e6 */ { 18, 0, 5, 0, 0 },
/* U+06e7 */ { 4, 230, 14, 0, 0 },
/* U+06e8 */ { 4, 230, 14, 0, 0 },
/* U+06e9 */ { 30, 0, 19, 0, 0 },
/* U+06ea */ { 4, 220, 14, 0, 0 },
/* U+06eb */ { 4, 230, 14, 0, 0 },
/* U+06ec */ { 4, 230, 14, 0, 0 },
/* U+06ed */ { 4, 220, 14, 0, 0 },
/* U+06ee */ { 0, 0, 0, 0, 0 },
/* U+06ef */ { 0, 0, 0, 0, 0 },
/* U+06f0 */ { 7, 0, 9, 0, 0 },
/* U+06f1 */ { 7, 0, 9, 0, 0 },
/* U+06f2 */ { 7, 0, 9, 0, 0 },
/* U+06f3 */ { 7, 0, 9, 0, 0 },
/* U+06f4 */ { 7, 0, 9, 0, 0 },
/* U+06f5 */ { 7, 0, 9, 0, 0 },
/* U+06f6 */ { 7, 0, 9, 0, 0 },
/* U+06f7 */ { 7, 0, 9, 0, 0 },
/* U+06f8 */ { 7, 0, 9, 0, 0 },
/* U+06f9 */ { 7, 0, 9, 0, 0 },
/* U+06fa */ { 19, 0, 5, 0, 0 },
/* U+06fb */ { 19, 0, 5, 0, 0 },
/* U+06fc */ { 19, 0, 5, 0, 0 },
/* U+06fd */ { 30, 0, 5, 0, 0 },
/* U+06fe */ { 30, 0, 5, 0, 0 },
/* U+06ff */ { 0, 0, 0, 0, 0 },
/* U+0700 */ { 26, 0, 5, 0, 0 },
/* U+0701 */ { 26, 0, 5, 0, 0 },
/* U+0702 */ { 26, 0, 5, 0, 0 },
/* U+0703 */ { 26, 0, 5, 0, 0 },
/* U+0704 */ { 26, 0, 5, 0, 0 },
/* U+0705 */ { 26, 0, 5, 0, 0 },
/* U+0706 */ { 26, 0, 5, 0, 0 },
/* U+0707 */ { 26, 0, 5, 0, 0 },
/* U+0708 */ { 26, 0, 5, 0, 0 },
/* U+0709 */ { 26, 0, 5, 0, 0 },
/* U+070a */ { 26, 0, 5, 0, 0 },
/* U+070b */ { 26, 0, 5, 0, 0 },
/* U+070c */ { 26, 0, 5, 0, 0 },
/* U+070d */ { 26, 0, 5, 0, 0 },
/* U+070e */ { 0, 0, 0, 0, 0 },
/* U+070f */ { 14, 0, 15, 0, 0 },
/* U+0710 */ { 19, 0, 5, 0, 0 },
/* U+0711 */ { 4, 36, 14, 0, 0 },
/* U+0712 */ { 19, 0, 5, 0, 0 },
/* U+0713 */ { 19, 0, 5, 0, 0 },
/* U+0714 */ { 19, 0, 5, 0, 0 },
/* U+0715 */ { 19, 0, 5, 0, 0 },
/* U+0716 */ { 19, 0, 5, 0, 0 },
/* U+0717 */ { 19, 0, 5, 0, 0 },
/* U+0718 */ { 19, 0, 5, 0, 0 },
/* U+0719 */ { 19, 0, 5, 0, 0 },
/* U+071a */ { 19, 0, 5, 0, 0 },
/* U+071b */ { 19, 0, 5, 0, 0 },
/* U+071c */ { 19, 0, 5, 0, 0 },
/* U+071d */ { 19, 0, 5, 0, 0 },
/* U+071e */ { 19, 0, 5, 0, 0 },
/* U+071f */ { 19, 0, 5, 0, 0 },
/* U+0720 */ { 19, 0, 5, 0, 0 },
/* U+0721 */ { 19, 0, 5, 0, 0 },
/* U+0722 */ { 19, 0, 5, 0, 0 },
/* U+0723 */ { 19, 0, 5, 0, 0 },
/* U+0724 */ { 19, 0, 5, 0, 0 },
/* U+0725 */ { 19, 0, 5, 0, 0 },
/* U+0726 */ { 19, 0, 5, 0, 0 },
/* U+0727 */ { 19, 0, 5, 0, 0 },
/* U+0728 */ { 19, 0, 5, 0, 0 },
/* U+0729 */ { 19, 0, 5, 0, 0 },
/* U+072a */ { 19, 0, 5, 0, 0 },
/* U+072b */ { 19, 0, 5, 0, 0 },
/* U+072c */ { 19, 0, 5, 0, 0 },
/* U+072d */ { 0, 0, 0, 0, 0 },
/* U+072e */ { 0, 0, 0, 0, 0 },
/* U+072f */ { 0, 0, 0, 0, 0 },
/* U+0730 */ { 4, 230, 14, 0, 0 },
/* U+0731 */ { 4, 220, 14, 0, 0 },
/* U+0732 */ { 4, 230, 14, 0, 0 },
/* U+0733 */ { 4, 230, 14, 0, 0 },
/* U+0734 */ { 4, 220, 14, 0, 0 },
/* U+0735 */ { 4, 230, 14, 0, 0 },
/* U+0736 */ { 4, 230, 14, 0, 0 },
/* U+0737 */ { 4, 220, 14, 0, 0 },
/* U+0738 */ { 4, 220, 14, 0, 0 },
/* U+0739 */ { 4, 220, 14, 0, 0 },
/* U+073a */ { 4, 230, 14, 0, 0 },
/* U+073b */ { 4, 220, 14, 0, 0 },
/* U+073c */ { 4, 220, 14, 0, 0 },
/* U+073d */ { 4, 230, 14, 0, 0 },
/* U+073e */ { 4, 220, 14, 0, 0 },
/* U+073f */ { 4, 230, 14, 0, 0 },
/* U+0740 */ { 4, 230, 14, 0, 0 },
/* U+0741 */ { 4, 230, 14, 0, 0 },
/* U+0742 */ { 4, 220, 14, 0, 0 },
/* U+0743 */ { 4, 230, 14, 0, 0 },
/* U+0744 */ { 4, 220, 14, 0, 0 },
/* U+0745 */ { 4, 230, 14, 0, 0 },
/* U+0746 */ { 4, 220, 14, 0, 0 },
/* U+0747 */ { 4, 230, 14, 0, 0 },
/* U+0748 */ { 4, 220, 14, 0, 0 },
/* U+0749 */ { 4, 230, 14, 0, 0 },
/* U+074a */ { 4, 230, 14, 0, 0 },
/* U+074b */ { 0, 0, 0, 0, 0 },
/* U+074c */ { 0, 0, 0, 0, 0 },
/* U+074d */ { 0, 0, 0, 0, 0 },
/* U+074e */ { 0, 0, 0, 0, 0 },
/* U+074f */ { 0, 0, 0, 0, 0 },
/* U+0750 */ { 0, 0, 0, 0, 0 },
/* U+0751 */ { 0, 0, 0, 0, 0 },
/* U+0752 */ { 0, 0, 0, 0, 0 },
/* U+0753 */ { 0, 0, 0, 0, 0 },
/* U+0754 */ { 0, 0, 0, 0, 0 },
/* U+0755 */ { 0, 0, 0, 0, 0 },
/* U+0756 */ { 0, 0, 0, 0, 0 },
/* U+0757 */ { 0, 0, 0, 0, 0 },
/* U+0758 */ { 0, 0, 0, 0, 0 },
/* U+0759 */ { 0, 0, 0, 0, 0 },
/* U+075a */ { 0, 0, 0, 0, 0 },
/* U+075b */ { 0, 0, 0, 0, 0 },
/* U+075c */ { 0, 0, 0, 0, 0 },
/* U+075d */ { 0, 0, 0, 0, 0 },
/* U+075e */ { 0, 0, 0, 0, 0 },
/* U+075f */ { 0, 0, 0, 0, 0 },
/* U+0760 */ { 0, 0, 0, 0, 0 },
/* U+0761 */ { 0, 0, 0, 0, 0 },
/* U+0762 */ { 0, 0, 0, 0, 0 },
/* U+0763 */ { 0, 0, 0, 0, 0 },
/* U+0764 */ { 0, 0, 0, 0, 0 },
/* U+0765 */ { 0, 0, 0, 0, 0 },
/* U+0766 */ { 0, 0, 0, 0, 0 },
/* U+0767 */ { 0, 0, 0, 0, 0 },
/* U+0768 */ { 0, 0, 0, 0, 0 },
/* U+0769 */ { 0, 0, 0, 0, 0 },
/* U+076a */ { 0, 0, 0, 0, 0 },
/* U+076b */ { 0, 0, 0, 0, 0 },
/* U+076c */ { 0, 0, 0, 0, 0 },
/* U+076d */ { 0, 0, 0, 0, 0 },
/* U+076e */ { 0, 0, 0, 0, 0 },
/* U+076f */ { 0, 0, 0, 0, 0 },
/* U+0770 */ { 0, 0, 0, 0, 0 },
/* U+0771 */ { 0, 0, 0, 0, 0 },
/* U+0772 */ { 0, 0, 0, 0, 0 },
/* U+0773 */ { 0, 0, 0, 0, 0 },
/* U+0774 */ { 0, 0, 0, 0, 0 },
/* U+0775 */ { 0, 0, 0, 0, 0 },
/* U+0776 */ { 0, 0, 0, 0, 0 },
/* U+0777 */ { 0, 0, 0, 0, 0 },
/* U+0778 */ { 0, 0, 0, 0, 0 },
/* U+0779 */ { 0, 0, 0, 0, 0 },
/* U+077a */ { 0, 0, 0, 0, 0 },
/* U+077b */ { 0, 0, 0, 0, 0 },
/* U+077c */ { 0, 0, 0, 0, 0 },
/* U+077d */ { 0, 0, 0, 0, 0 },
/* U+077e */ { 0, 0, 0, 0, 0 },
/* U+077f */ { 0, 0, 0, 0, 0 },
/* U+0780 */ { 19, 0, 5, 0, 0 },
/* U+0781 */ { 19, 0, 5, 0, 0 },
/* U+0782 */ { 19, 0, 5, 0, 0 },
/* U+0783 */ { 19, 0, 5, 0, 0 },
/* U+0784 */ { 19, 0, 5, 0, 0 },
/* U+0785 */ { 19, 0, 5, 0, 0 },
/* U+0786 */ { 19, 0, 5, 0, 0 },
/* U+0787 */ { 19, 0, 5, 0, 0 },
/* U+0788 */ { 19, 0, 5, 0, 0 },
/* U+0789 */ { 19, 0, 5, 0, 0 },
/* U+078a */ { 19, 0, 5, 0, 0 },
/* U+078b */ { 19, 0, 5, 0, 0 },
/* U+078c */ { 19, 0, 5, 0, 0 },
/* U+078d */ { 19, 0, 5, 0, 0 },
/* U+078e */ { 19, 0, 5, 0, 0 },
/* U+078f */ { 19, 0, 5, 0, 0 },
/* U+0790 */ { 19, 0, 5, 0, 0 },
/* U+0791 */ { 19, 0, 5, 0, 0 },
/* U+0792 */ { 19, 0, 5, 0, 0 },
/* U+0793 */ { 19, 0, 5, 0, 0 },
/* U+0794 */ { 19, 0, 5, 0, 0 },
/* U+0795 */ { 19, 0, 5, 0, 0 },
/* U+0796 */ { 19, 0, 5, 0, 0 },
/* U+0797 */ { 19, 0, 5, 0, 0 },
/* U+0798 */ { 19, 0, 5, 0, 0 },
/* U+0799 */ { 19, 0, 5, 0, 0 },
/* U+079a */ { 19, 0, 5, 0, 0 },
/* U+079b */ { 19, 0, 5, 0, 0 },
/* U+079c */ { 19, 0, 5, 0, 0 },
/* U+079d */ { 19, 0, 5, 0, 0 },
/* U+079e */ { 19, 0, 5, 0, 0 },
/* U+079f */ { 19, 0, 5, 0, 0 },
/* U+07a0 */ { 19, 0, 5, 0, 0 },
/* U+07a1 */ { 19, 0, 5, 0, 0 },
/* U+07a2 */ { 19, 0, 5, 0, 0 },
/* U+07a3 */ { 19, 0, 5, 0, 0 },
/* U+07a4 */ { 19, 0, 5, 0, 0 },
/* U+07a5 */ { 19, 0, 5, 0, 0 },
/* U+07a6 */ { 4, 0, 14, 0, 0 },
/* U+07a7 */ { 4, 0, 14, 0, 0 },
/* U+07a8 */ { 4, 0, 14, 0, 0 },
/* U+07a9 */ { 4, 0, 14, 0, 0 },
/* U+07aa */ { 4, 0, 14, 0, 0 },
/* U+07ab */ { 4, 0, 14, 0, 0 },
/* U+07ac */ { 4, 0, 14, 0, 0 },
/* U+07ad */ { 4, 0, 14, 0, 0 },
/* U+07ae */ { 4, 0, 14, 0, 0 },
/* U+07af */ { 4, 0, 14, 0, 0 },
/* U+07b0 */ { 4, 0, 14, 0, 0 },
/* U+07b1 */ { 0, 0, 0, 0, 0 },
/* U+07b2 */ { 0, 0, 0, 0, 0 },
/* U+07b3 */ { 0, 0, 0, 0, 0 },
/* U+07b4 */ { 0, 0, 0, 0, 0 },
/* U+07b5 */ { 0, 0, 0, 0, 0 },
/* U+07b6 */ { 0, 0, 0, 0, 0 },
/* U+07b7 */ { 0, 0, 0, 0, 0 },
/* U+07b8 */ { 0, 0, 0, 0, 0 },
/* U+07b9 */ { 0, 0, 0, 0, 0 },
/* U+07ba */ { 0, 0, 0, 0, 0 },
/* U+07bb */ { 0, 0, 0, 0, 0 },
/* U+07bc */ { 0, 0, 0, 0, 0 },
/* U+07bd */ { 0, 0, 0, 0, 0 },
/* U+07be */ { 0, 0, 0, 0, 0 },
/* U+07bf */ { 0, 0, 0, 0, 0 },
/* U+07c0 */ { 0, 0, 0, 0, 0 },
/* U+07c1 */ { 0, 0, 0, 0, 0 },
/* U+07c2 */ { 0, 0, 0, 0, 0 },
/* U+07c3 */ { 0, 0, 0, 0, 0 },
/* U+07c4 */ { 0, 0, 0, 0, 0 },
/* U+07c5 */ { 0, 0, 0, 0, 0 },
/* U+07c6 */ { 0, 0, 0, 0, 0 },
/* U+07c7 */ { 0, 0, 0, 0, 0 },
/* U+07c8 */ { 0, 0, 0, 0, 0 },
/* U+07c9 */ { 0, 0, 0, 0, 0 },
/* U+07ca */ { 0, 0, 0, 0, 0 },
/* U+07cb */ { 0, 0, 0, 0, 0 },
/* U+07cc */ { 0, 0, 0, 0, 0 },
/* U+07cd */ { 0, 0, 0, 0, 0 },
/* U+07ce */ { 0, 0, 0, 0, 0 },
/* U+07cf */ { 0, 0, 0, 0, 0 },
/* U+07d0 */ { 0, 0, 0, 0, 0 },
/* U+07d1 */ { 0, 0, 0, 0, 0 },
/* U+07d2 */ { 0, 0, 0, 0, 0 },
/* U+07d3 */ { 0, 0, 0, 0, 0 },
/* U+07d4 */ { 0, 0, 0, 0, 0 },
/* U+07d5 */ { 0, 0, 0, 0, 0 },
/* U+07d6 */ { 0, 0, 0, 0, 0 },
/* U+07d7 */ { 0, 0, 0, 0, 0 },
/* U+07d8 */ { 0, 0, 0, 0, 0 },
/* U+07d9 */ { 0, 0, 0, 0, 0 },
/* U+07da */ { 0, 0, 0, 0, 0 },
/* U+07db */ { 0, 0, 0, 0, 0 },
/* U+07dc */ { 0, 0, 0, 0, 0 },
/* U+07dd */ { 0, 0, 0, 0, 0 },
/* U+07de */ { 0, 0, 0, 0, 0 },
/* U+07df */ { 0, 0, 0, 0, 0 },
/* U+07e0 */ { 0, 0, 0, 0, 0 },
/* U+07e1 */ { 0, 0, 0, 0, 0 },
/* U+07e2 */ { 0, 0, 0, 0, 0 },
/* U+07e3 */ { 0, 0, 0, 0, 0 },
/* U+07e4 */ { 0, 0, 0, 0, 0 },
/* U+07e5 */ { 0, 0, 0, 0, 0 },
/* U+07e6 */ { 0, 0, 0, 0, 0 },
/* U+07e7 */ { 0, 0, 0, 0, 0 },
/* U+07e8 */ { 0, 0, 0, 0, 0 },
/* U+07e9 */ { 0, 0, 0, 0, 0 },
/* U+07ea */ { 0, 0, 0, 0, 0 },
/* U+07eb */ { 0, 0, 0, 0, 0 },
/* U+07ec */ { 0, 0, 0, 0, 0 },
/* U+07ed */ { 0, 0, 0, 0, 0 },
/* U+07ee */ { 0, 0, 0, 0, 0 },
/* U+07ef */ { 0, 0, 0, 0, 0 },
/* U+07f0 */ { 0, 0, 0, 0, 0 },
/* U+07f1 */ { 0, 0, 0, 0, 0 },
/* U+07f2 */ { 0, 0, 0, 0, 0 },
/* U+07f3 */ { 0, 0, 0, 0, 0 },
/* U+07f4 */ { 0, 0, 0, 0, 0 },
/* U+07f5 */ { 0, 0, 0, 0, 0 },
/* U+07f6 */ { 0, 0, 0, 0, 0 },
/* U+07f7 */ { 0, 0, 0, 0, 0 },
/* U+07f8 */ { 0, 0, 0, 0, 0 },
/* U+07f9 */ { 0, 0, 0, 0, 0 },
/* U+07fa */ { 0, 0, 0, 0, 0 },
/* U+07fb */ { 0, 0, 0, 0, 0 },
/* U+07fc */ { 0, 0, 0, 0, 0 },
/* U+07fd */ { 0, 0, 0, 0, 0 },
/* U+07fe */ { 0, 0, 0, 0, 0 },
/* U+07ff */ { 0, 0, 0, 0, 0 },
/* U+0800 */ { 0, 0, 0, 0, 0 },
/* U+0801 */ { 0, 0, 0, 0, 0 },
/* U+0802 */ { 0, 0, 0, 0, 0 },
/* U+0803 */ { 0, 0, 0, 0, 0 },
/* U+0804 */ { 0, 0, 0, 0, 0 },
/* U+0805 */ { 0, 0, 0, 0, 0 },
/* U+0806 */ { 0, 0, 0, 0, 0 },
/* U+0807 */ { 0, 0, 0, 0, 0 },
/* U+0808 */ { 0, 0, 0, 0, 0 },
/* U+0809 */ { 0, 0, 0, 0, 0 },
/* U+080a */ { 0, 0, 0, 0, 0 },
/* U+080b */ { 0, 0, 0, 0, 0 },
/* U+080c */ { 0, 0, 0, 0, 0 },
/* U+080d */ { 0, 0, 0, 0, 0 },
/* U+080e */ { 0, 0, 0, 0, 0 },
/* U+080f */ { 0, 0, 0, 0, 0 },
/* U+0810 */ { 0, 0, 0, 0, 0 },
/* U+0811 */ { 0, 0, 0, 0, 0 },
/* U+0812 */ { 0, 0, 0, 0, 0 },
/* U+0813 */ { 0, 0, 0, 0, 0 },
/* U+0814 */ { 0, 0, 0, 0, 0 },
/* U+0815 */ { 0, 0, 0, 0, 0 },
/* U+0816 */ { 0, 0, 0, 0, 0 },
/* U+0817 */ { 0, 0, 0, 0, 0 },
/* U+0818 */ { 0, 0, 0, 0, 0 },
/* U+0819 */ { 0, 0, 0, 0, 0 },
/* U+081a */ { 0, 0, 0, 0, 0 },
/* U+081b */ { 0, 0, 0, 0, 0 },
/* U+081c */ { 0, 0, 0, 0, 0 },
/* U+081d */ { 0, 0, 0, 0, 0 },
/* U+081e */ { 0, 0, 0, 0, 0 },
/* U+081f */ { 0, 0, 0, 0, 0 },
/* U+0820 */ { 0, 0, 0, 0, 0 },
/* U+0821 */ { 0, 0, 0, 0, 0 },
/* U+0822 */ { 0, 0, 0, 0, 0 },
/* U+0823 */ { 0, 0, 0, 0, 0 },
/* U+0824 */ { 0, 0, 0, 0, 0 },
/* U+0825 */ { 0, 0, 0, 0, 0 },
/* U+0826 */ { 0, 0, 0, 0, 0 },
/* U+0827 */ { 0, 0, 0, 0, 0 },
/* U+0828 */ { 0, 0, 0, 0, 0 },
/* U+0829 */ { 0, 0, 0, 0, 0 },
/* U+082a */ { 0, 0, 0, 0, 0 },
/* U+082b */ { 0, 0, 0, 0, 0 },
/* U+082c */ { 0, 0, 0, 0, 0 },
/* U+082d */ { 0, 0, 0, 0, 0 },
/* U+082e */ { 0, 0, 0, 0, 0 },
/* U+082f */ { 0, 0, 0, 0, 0 },
/* U+0830 */ { 0, 0, 0, 0, 0 },
/* U+0831 */ { 0, 0, 0, 0, 0 },
/* U+0832 */ { 0, 0, 0, 0, 0 },
/* U+0833 */ { 0, 0, 0, 0, 0 },
/* U+0834 */ { 0, 0, 0, 0, 0 },
/* U+0835 */ { 0, 0, 0, 0, 0 },
/* U+0836 */ { 0, 0, 0, 0, 0 },
/* U+0837 */ { 0, 0, 0, 0, 0 },
/* U+0838 */ { 0, 0, 0, 0, 0 },
/* U+0839 */ { 0, 0, 0, 0, 0 },
/* U+083a */ { 0, 0, 0, 0, 0 },
/* U+083b */ { 0, 0, 0, 0, 0 },
/* U+083c */ { 0, 0, 0, 0, 0 },
/* U+083d */ { 0, 0, 0, 0, 0 },
/* U+083e */ { 0, 0, 0, 0, 0 },
/* U+083f */ { 0, 0, 0, 0, 0 },
/* U+0840 */ { 0, 0, 0, 0, 0 },
/* U+0841 */ { 0, 0, 0, 0, 0 },
/* U+0842 */ { 0, 0, 0, 0, 0 },
/* U+0843 */ { 0, 0, 0, 0, 0 },
/* U+0844 */ { 0, 0, 0, 0, 0 },
/* U+0845 */ { 0, 0, 0, 0, 0 },
/* U+0846 */ { 0, 0, 0, 0, 0 },
/* U+0847 */ { 0, 0, 0, 0, 0 },
/* U+0848 */ { 0, 0, 0, 0, 0 },
/* U+0849 */ { 0, 0, 0, 0, 0 },
/* U+084a */ { 0, 0, 0, 0, 0 },
/* U+084b */ { 0, 0, 0, 0, 0 },
/* U+084c */ { 0, 0, 0, 0, 0 },
/* U+084d */ { 0, 0, 0, 0, 0 },
/* U+084e */ { 0, 0, 0, 0, 0 },
/* U+084f */ { 0, 0, 0, 0, 0 },
/* U+0850 */ { 0, 0, 0, 0, 0 },
/* U+0851 */ { 0, 0, 0, 0, 0 },
/* U+0852 */ { 0, 0, 0, 0, 0 },
/* U+0853 */ { 0, 0, 0, 0, 0 },
/* U+0854 */ { 0, 0, 0, 0, 0 },
/* U+0855 */ { 0, 0, 0, 0, 0 },
/* U+0856 */ { 0, 0, 0, 0, 0 },
/* U+0857 */ { 0, 0, 0, 0, 0 },
/* U+0858 */ { 0, 0, 0, 0, 0 },
/* U+0859 */ { 0, 0, 0, 0, 0 },
/* U+085a */ { 0, 0, 0, 0, 0 },
/* U+085b */ { 0, 0, 0, 0, 0 },
/* U+085c */ { 0, 0, 0, 0, 0 },
/* U+085d */ { 0, 0, 0, 0, 0 },
/* U+085e */ { 0, 0, 0, 0, 0 },
/* U+085f */ { 0, 0, 0, 0, 0 },
/* U+0860 */ { 0, 0, 0, 0, 0 },
/* U+0861 */ { 0, 0, 0, 0, 0 },
/* U+0862 */ { 0, 0, 0, 0, 0 },
/* U+0863 */ { 0, 0, 0, 0, 0 },
/* U+0864 */ { 0, 0, 0, 0, 0 },
/* U+0865 */ { 0, 0, 0, 0, 0 },
/* U+0866 */ { 0, 0, 0, 0, 0 },
/* U+0867 */ { 0, 0, 0, 0, 0 },
/* U+0868 */ { 0, 0, 0, 0, 0 },
/* U+0869 */ { 0, 0, 0, 0, 0 },
/* U+086a */ { 0, 0, 0, 0, 0 },
/* U+086b */ { 0, 0, 0, 0, 0 },
/* U+086c */ { 0, 0, 0, 0, 0 },
/* U+086d */ { 0, 0, 0, 0, 0 },
/* U+086e */ { 0, 0, 0, 0, 0 },
/* U+086f */ { 0, 0, 0, 0, 0 },
/* U+0870 */ { 0, 0, 0, 0, 0 },
/* U+0871 */ { 0, 0, 0, 0, 0 },
/* U+0872 */ { 0, 0, 0, 0, 0 },
/* U+0873 */ { 0, 0, 0, 0, 0 },
/* U+0874 */ { 0, 0, 0, 0, 0 },
/* U+0875 */ { 0, 0, 0, 0, 0 },
/* U+0876 */ { 0, 0, 0, 0, 0 },
/* U+0877 */ { 0, 0, 0, 0, 0 },
/* U+0878 */ { 0, 0, 0, 0, 0 },
/* U+0879 */ { 0, 0, 0, 0, 0 },
/* U+087a */ { 0, 0, 0, 0, 0 },
/* U+087b */ { 0, 0, 0, 0, 0 },
/* U+087c */ { 0, 0, 0, 0, 0 },
/* U+087d */ { 0, 0, 0, 0, 0 },
/* U+087e */ { 0, 0, 0, 0, 0 },
/* U+087f */ { 0, 0, 0, 0, 0 },
/* U+0880 */ { 0, 0, 0, 0, 0 },
/* U+0881 */ { 0, 0, 0, 0, 0 },
/* U+0882 */ { 0, 0, 0, 0, 0 },
/* U+0883 */ { 0, 0, 0, 0, 0 },
/* U+0884 */ { 0, 0, 0, 0, 0 },
/* U+0885 */ { 0, 0, 0, 0, 0 },
/* U+0886 */ { 0, 0, 0, 0, 0 },
/* U+0887 */ { 0, 0, 0, 0, 0 },
/* U+0888 */ { 0, 0, 0, 0, 0 },
/* U+0889 */ { 0, 0, 0, 0, 0 },
/* U+088a */ { 0, 0, 0, 0, 0 },
/* U+088b */ { 0, 0, 0, 0, 0 },
/* U+088c */ { 0, 0, 0, 0, 0 },
/* U+088d */ { 0, 0, 0, 0, 0 },
/* U+088e */ { 0, 0, 0, 0, 0 },
/* U+088f */ { 0, 0, 0, 0, 0 },
/* U+0890 */ { 0, 0, 0, 0, 0 },
/* U+0891 */ { 0, 0, 0, 0, 0 },
/* U+0892 */ { 0, 0, 0, 0, 0 },
/* U+0893 */ { 0, 0, 0, 0, 0 },
/* U+0894 */ { 0, 0, 0, 0, 0 },
/* U+0895 */ { 0, 0, 0, 0, 0 },
/* U+0896 */ { 0, 0, 0, 0, 0 },
/* U+0897 */ { 0, 0, 0, 0, 0 },
/* U+0898 */ { 0, 0, 0, 0, 0 },
/* U+0899 */ { 0, 0, 0, 0, 0 },
/* U+089a */ { 0, 0, 0, 0, 0 },
/* U+089b */ { 0, 0, 0, 0, 0 },
/* U+089c */ { 0, 0, 0, 0, 0 },
/* U+089d */ { 0, 0, 0, 0, 0 },
/* U+089e */ { 0, 0, 0, 0, 0 },
/* U+089f */ { 0, 0, 0, 0, 0 },
/* U+08a0 */ { 0, 0, 0, 0, 0 },
/* U+08a1 */ { 0, 0, 0, 0, 0 },
/* U+08a2 */ { 0, 0, 0, 0, 0 },
/* U+08a3 */ { 0, 0, 0, 0, 0 },
/* U+08a4 */ { 0, 0, 0, 0, 0 },
/* U+08a5 */ { 0, 0, 0, 0, 0 },
/* U+08a6 */ { 0, 0, 0, 0, 0 },
/* U+08a7 */ { 0, 0, 0, 0, 0 },
/* U+08a8 */ { 0, 0, 0, 0, 0 },
/* U+08a9 */ { 0, 0, 0, 0, 0 },
/* U+08aa */ { 0, 0, 0, 0, 0 },
/* U+08ab */ { 0, 0, 0, 0, 0 },
/* U+08ac */ { 0, 0, 0, 0, 0 },
/* U+08ad */ { 0, 0, 0, 0, 0 },
/* U+08ae */ { 0, 0, 0, 0, 0 },
/* U+08af */ { 0, 0, 0, 0, 0 },
/* U+08b0 */ { 0, 0, 0, 0, 0 },
/* U+08b1 */ { 0, 0, 0, 0, 0 },
/* U+08b2 */ { 0, 0, 0, 0, 0 },
/* U+08b3 */ { 0, 0, 0, 0, 0 },
/* U+08b4 */ { 0, 0, 0, 0, 0 },
/* U+08b5 */ { 0, 0, 0, 0, 0 },
/* U+08b6 */ { 0, 0, 0, 0, 0 },
/* U+08b7 */ { 0, 0, 0, 0, 0 },
/* U+08b8 */ { 0, 0, 0, 0, 0 },
/* U+08b9 */ { 0, 0, 0, 0, 0 },
/* U+08ba */ { 0, 0, 0, 0, 0 },
/* U+08bb */ { 0, 0, 0, 0, 0 },
/* U+08bc */ { 0, 0, 0, 0, 0 },
/* U+08bd */ { 0, 0, 0, 0, 0 },
/* U+08be */ { 0, 0, 0, 0, 0 },
/* U+08bf */ { 0, 0, 0, 0, 0 },
/* U+08c0 */ { 0, 0, 0, 0, 0 },
/* U+08c1 */ { 0, 0, 0, 0, 0 },
/* U+08c2 */ { 0, 0, 0, 0, 0 },
/* U+08c3 */ { 0, 0, 0, 0, 0 },
/* U+08c4 */ { 0, 0, 0, 0, 0 },
/* U+08c5 */ { 0, 0, 0, 0, 0 },
/* U+08c6 */ { 0, 0, 0, 0, 0 },
/* U+08c7 */ { 0, 0, 0, 0, 0 },
/* U+08c8 */ { 0, 0, 0, 0, 0 },
/* U+08c9 */ { 0, 0, 0, 0, 0 },
/* U+08ca */ { 0, 0, 0, 0, 0 },
/* U+08cb */ { 0, 0, 0, 0, 0 },
/* U+08cc */ { 0, 0, 0, 0, 0 },
/* U+08cd */ { 0, 0, 0, 0, 0 },
/* U+08ce */ { 0, 0, 0, 0, 0 },
/* U+08cf */ { 0, 0, 0, 0, 0 },
/* U+08d0 */ { 0, 0, 0, 0, 0 },
/* U+08d1 */ { 0, 0, 0, 0, 0 },
/* U+08d2 */ { 0, 0, 0, 0, 0 },
/* U+08d3 */ { 0, 0, 0, 0, 0 },
/* U+08d4 */ { 0, 0, 0, 0, 0 },
/* U+08d5 */ { 0, 0, 0, 0, 0 },
/* U+08d6 */ { 0, 0, 0, 0, 0 },
/* U+08d7 */ { 0, 0, 0, 0, 0 },
/* U+08d8 */ { 0, 0, 0, 0, 0 },
/* U+08d9 */ { 0, 0, 0, 0, 0 },
/* U+08da */ { 0, 0, 0, 0, 0 },
/* U+08db */ { 0, 0, 0, 0, 0 },
/* U+08dc */ { 0, 0, 0, 0, 0 },
/* U+08dd */ { 0, 0, 0, 0, 0 },
/* U+08de */ { 0, 0, 0, 0, 0 },
/* U+08df */ { 0, 0, 0, 0, 0 },
/* U+08e0 */ { 0, 0, 0, 0, 0 },
/* U+08e1 */ { 0, 0, 0, 0, 0 },
/* U+08e2 */ { 0, 0, 0, 0, 0 },
/* U+08e3 */ { 0, 0, 0, 0, 0 },
/* U+08e4 */ { 0, 0, 0, 0, 0 },
/* U+08e5 */ { 0, 0, 0, 0, 0 },
/* U+08e6 */ { 0, 0, 0, 0, 0 },
/* U+08e7 */ { 0, 0, 0, 0, 0 },
/* U+08e8 */ { 0, 0, 0, 0, 0 },
/* U+08e9 */ { 0, 0, 0, 0, 0 },
/* U+08ea */ { 0, 0, 0, 0, 0 },
/* U+08eb */ { 0, 0, 0, 0, 0 },
/* U+08ec */ { 0, 0, 0, 0, 0 },
/* U+08ed */ { 0, 0, 0, 0, 0 },
/* U+08ee */ { 0, 0, 0, 0, 0 },
/* U+08ef */ { 0, 0, 0, 0, 0 },
/* U+08f0 */ { 0, 0, 0, 0, 0 },
/* U+08f1 */ { 0, 0, 0, 0, 0 },
/* U+08f2 */ { 0, 0, 0, 0, 0 },
/* U+08f3 */ { 0, 0, 0, 0, 0 },
/* U+08f4 */ { 0, 0, 0, 0, 0 },
/* U+08f5 */ { 0, 0, 0, 0, 0 },
/* U+08f6 */ { 0, 0, 0, 0, 0 },
/* U+08f7 */ { 0, 0, 0, 0, 0 },
/* U+08f8 */ { 0, 0, 0, 0, 0 },
/* U+08f9 */ { 0, 0, 0, 0, 0 },
/* U+08fa */ { 0, 0, 0, 0, 0 },
/* U+08fb */ { 0, 0, 0, 0, 0 },
/* U+08fc */ { 0, 0, 0, 0, 0 },
/* U+08fd */ { 0, 0, 0, 0, 0 },
/* U+08fe */ { 0, 0, 0, 0, 0 },
/* U+08ff */ { 0, 0, 0, 0, 0 },
/* U+0900 */ { 0, 0, 0, 0, 0 },
/* U+0901 */ { 4, 0, 14, 0, 0 },
/* U+0902 */ { 4, 0, 14, 0, 0 },
/* U+0903 */ { 5, 0, 1, 0, 0 },
/* U+0904 */ { 0, 0, 0, 0, 0 },
/* U+0905 */ { 19, 0, 1, 0, 0 },
/* U+0906 */ { 19, 0, 1, 0, 0 },
/* U+0907 */ { 19, 0, 1, 0, 0 },
/* U+0908 */ { 19, 0, 1, 0, 0 },
/* U+0909 */ { 19, 0, 1, 0, 0 },
/* U+090a */ { 19, 0, 1, 0, 0 },
/* U+090b */ { 19, 0, 1, 0, 0 },
/* U+090c */ { 19, 0, 1, 0, 0 },
/* U+090d */ { 19, 0, 1, 0, 0 },
/* U+090e */ { 19, 0, 1, 0, 0 },
/* U+090f */ { 19, 0, 1, 0, 0 },
/* U+0910 */ { 19, 0, 1, 0, 0 },
/* U+0911 */ { 19, 0, 1, 0, 0 },
/* U+0912 */ { 19, 0, 1, 0, 0 },
/* U+0913 */ { 19, 0, 1, 0, 0 },
/* U+0914 */ { 19, 0, 1, 0, 0 },
/* U+0915 */ { 19, 0, 1, 0, 0 },
/* U+0916 */ { 19, 0, 1, 0, 0 },
/* U+0917 */ { 19, 0, 1, 0, 0 },
/* U+0918 */ { 19, 0, 1, 0, 0 },
/* U+0919 */ { 19, 0, 1, 0, 0 },
/* U+091a */ { 19, 0, 1, 0, 0 },
/* U+091b */ { 19, 0, 1, 0, 0 },
/* U+091c */ { 19, 0, 1, 0, 0 },
/* U+091d */ { 19, 0, 1, 0, 0 },
/* U+091e */ { 19, 0, 1, 0, 0 },
/* U+091f */ { 19, 0, 1, 0, 0 },
/* U+0920 */ { 19, 0, 1, 0, 0 },
/* U+0921 */ { 19, 0, 1, 0, 0 },
/* U+0922 */ { 19, 0, 1, 0, 0 },
/* U+0923 */ { 19, 0, 1, 0, 0 },
/* U+0924 */ { 19, 0, 1, 0, 0 },
/* U+0925 */ { 19, 0, 1, 0, 0 },
/* U+0926 */ { 19, 0, 1, 0, 0 },
/* U+0927 */ { 19, 0, 1, 0, 0 },
/* U+0928 */ { 19, 0, 1, 0, 0 },
/* U+0929 */ { 19, 0, 1, 0, "0928 093C" },
/* U+092a */ { 19, 0, 1, 0, 0 },
/* U+092b */ { 19, 0, 1, 0, 0 },
/* U+092c */ { 19, 0, 1, 0, 0 },
/* U+092d */ { 19, 0, 1, 0, 0 },
/* U+092e */ { 19, 0, 1, 0, 0 },
/* U+092f */ { 19, 0, 1, 0, 0 },
/* U+0930 */ { 19, 0, 1, 0, 0 },
/* U+0931 */ { 19, 0, 1, 0, "0930 093C" },
/* U+0932 */ { 19, 0, 1, 0, 0 },
/* U+0933 */ { 19, 0, 1, 0, 0 },
/* U+0934 */ { 19, 0, 1, 0, "0933 093C" },
/* U+0935 */ { 19, 0, 1, 0, 0 },
/* U+0936 */ { 19, 0, 1, 0, 0 },
/* U+0937 */ { 19, 0, 1, 0, 0 },
/* U+0938 */ { 19, 0, 1, 0, 0 },
/* U+0939 */ { 19, 0, 1, 0, 0 },
/* U+093a */ { 0, 0, 0, 0, 0 },
/* U+093b */ { 0, 0, 0, 0, 0 },
/* U+093c */ { 4, 7, 14, 0, 0 },
/* U+093d */ { 19, 0, 1, 0, 0 },
/* U+093e */ { 5, 0, 1, 0, 0 },
/* U+093f */ { 5, 0, 1, 0, 0 },
/* U+0940 */ { 5, 0, 1, 0, 0 },
/* U+0941 */ { 4, 0, 14, 0, 0 },
/* U+0942 */ { 4, 0, 14, 0, 0 },
/* U+0943 */ { 4, 0, 14, 0, 0 },
/* U+0944 */ { 4, 0, 14, 0, 0 },
/* U+0945 */ { 4, 0, 14, 0, 0 },
/* U+0946 */ { 4, 0, 14, 0, 0 },
/* U+0947 */ { 4, 0, 14, 0, 0 },
/* U+0948 */ { 4, 0, 14, 0, 0 },
/* U+0949 */ { 5, 0, 1, 0, 0 },
/* U+094a */ { 5, 0, 1, 0, 0 },
/* U+094b */ { 5, 0, 1, 0, 0 },
/* U+094c */ { 5, 0, 1, 0, 0 },
/* U+094d */ { 4, 9, 14, 0, 0 },
/* U+094e */ { 0, 0, 0, 0, 0 },
/* U+094f */ { 0, 0, 0, 0, 0 },
/* U+0950 */ { 19, 0, 1, 0, 0 },
/* U+0951 */ { 4, 230, 14, 0, 0 },
/* U+0952 */ { 4, 220, 14, 0, 0 },
/* U+0953 */ { 4, 230, 14, 0, 0 },
/* U+0954 */ { 4, 230, 14, 0, 0 },
/* U+0955 */ { 0, 0, 0, 0, 0 },
/* U+0956 */ { 0, 0, 0, 0, 0 },
/* U+0957 */ { 0, 0, 0, 0, 0 },
/* U+0958 */ { 19, 0, 1, 0, "0915 093C" },
/* U+0959 */ { 19, 0, 1, 0, "0916 093C" },
/* U+095a */ { 19, 0, 1, 0, "0917 093C" },
/* U+095b */ { 19, 0, 1, 0, "091C 093C" },
/* U+095c */ { 19, 0, 1, 0, "0921 093C" },
/* U+095d */ { 19, 0, 1, 0, "0922 093C" },
/* U+095e */ { 19, 0, 1, 0, "092B 093C" },
/* U+095f */ { 19, 0, 1, 0, "092F 093C" },
/* U+0960 */ { 19, 0, 1, 0, 0 },
/* U+0961 */ { 19, 0, 1, 0, 0 },
/* U+0962 */ { 4, 0, 14, 0, 0 },
/* U+0963 */ { 4, 0, 14, 0, 0 },
/* U+0964 */ { 26, 0, 1, 0, 0 },
/* U+0965 */ { 26, 0, 1, 0, 0 },
/* U+0966 */ { 7, 0, 1, 0, 0 },
/* U+0967 */ { 7, 0, 1, 0, 0 },
/* U+0968 */ { 7, 0, 1, 0, 0 },
/* U+0969 */ { 7, 0, 1, 0, 0 },
/* U+096a */ { 7, 0, 1, 0, 0 },
/* U+096b */ { 7, 0, 1, 0, 0 },
/* U+096c */ { 7, 0, 1, 0, 0 },
/* U+096d */ { 7, 0, 1, 0, 0 },
/* U+096e */ { 7, 0, 1, 0, 0 },
/* U+096f */ { 7, 0, 1, 0, 0 },
/* U+0970 */ { 26, 0, 1, 0, 0 },
/* U+0971 */ { 0, 0, 0, 0, 0 },
/* U+0972 */ { 0, 0, 0, 0, 0 },
/* U+0973 */ { 0, 0, 0, 0, 0 },
/* U+0974 */ { 0, 0, 0, 0, 0 },
/* U+0975 */ { 0, 0, 0, 0, 0 },
/* U+0976 */ { 0, 0, 0, 0, 0 },
/* U+0977 */ { 0, 0, 0, 0, 0 },
/* U+0978 */ { 0, 0, 0, 0, 0 },
/* U+0979 */ { 0, 0, 0, 0, 0 },
/* U+097a */ { 0, 0, 0, 0, 0 },
/* U+097b */ { 0, 0, 0, 0, 0 },
/* U+097c */ { 0, 0, 0, 0, 0 },
/* U+097d */ { 0, 0, 0, 0, 0 },
/* U+097e */ { 0, 0, 0, 0, 0 },
/* U+097f */ { 0, 0, 0, 0, 0 },
/* U+0980 */ { 0, 0, 0, 0, 0 },
/* U+0981 */ { 4, 0, 14, 0, 0 },
/* U+0982 */ { 5, 0, 1, 0, 0 },
/* U+0983 */ { 5, 0, 1, 0, 0 },
/* U+0984 */ { 0, 0, 0, 0, 0 },
/* U+0985 */ { 19, 0, 1, 0, 0 },
/* U+0986 */ { 19, 0, 1, 0, 0 },
/* U+0987 */ { 19, 0, 1, 0, 0 },
/* U+0988 */ { 19, 0, 1, 0, 0 },
/* U+0989 */ { 19, 0, 1, 0, 0 },
/* U+098a */ { 19, 0, 1, 0, 0 },
/* U+098b */ { 19, 0, 1, 0, 0 },
/* U+098c */ { 19, 0, 1, 0, 0 },
/* U+098d */ { 0, 0, 0, 0, 0 },
/* U+098e */ { 0, 0, 0, 0, 0 },
/* U+098f */ { 19, 0, 1, 0, 0 },
/* U+0990 */ { 19, 0, 1, 0, 0 },
/* U+0991 */ { 0, 0, 0, 0, 0 },
/* U+0992 */ { 0, 0, 0, 0, 0 },
/* U+0993 */ { 19, 0, 1, 0, 0 },
/* U+0994 */ { 19, 0, 1, 0, 0 },
/* U+0995 */ { 19, 0, 1, 0, 0 },
/* U+0996 */ { 19, 0, 1, 0, 0 },
/* U+0997 */ { 19, 0, 1, 0, 0 },
/* U+0998 */ { 19, 0, 1, 0, 0 },
/* U+0999 */ { 19, 0, 1, 0, 0 },
/* U+099a */ { 19, 0, 1, 0, 0 },
/* U+099b */ { 19, 0, 1, 0, 0 },
/* U+099c */ { 19, 0, 1, 0, 0 },
/* U+099d */ { 19, 0, 1, 0, 0 },
/* U+099e */ { 19, 0, 1, 0, 0 },
/* U+099f */ { 19, 0, 1, 0, 0 },
/* U+09a0 */ { 19, 0, 1, 0, 0 },
/* U+09a1 */ { 19, 0, 1, 0, 0 },
/* U+09a2 */ { 19, 0, 1, 0, 0 },
/* U+09a3 */ { 19, 0, 1, 0, 0 },
/* U+09a4 */ { 19, 0, 1, 0, 0 },
/* U+09a5 */ { 19, 0, 1, 0, 0 },
/* U+09a6 */ { 19, 0, 1, 0, 0 },
/* U+09a7 */ { 19, 0, 1, 0, 0 },
/* U+09a8 */ { 19, 0, 1, 0, 0 },
/* U+09a9 */ { 0, 0, 0, 0, 0 },
/* U+09aa */ { 19, 0, 1, 0, 0 },
/* U+09ab */ { 19, 0, 1, 0, 0 },
/* U+09ac */ { 19, 0, 1, 0, 0 },
/* U+09ad */ { 19, 0, 1, 0, 0 },
/* U+09ae */ { 19, 0, 1, 0, 0 },
/* U+09af */ { 19, 0, 1, 0, 0 },
/* U+09b0 */ { 19, 0, 1, 0, 0 },
/* U+09b1 */ { 0, 0, 0, 0, 0 },
/* U+09b2 */ { 19, 0, 1, 0, 0 },
/* U+09b3 */ { 0, 0, 0, 0, 0 },
/* U+09b4 */ { 0, 0, 0, 0, 0 },
/* U+09b5 */ { 0, 0, 0, 0, 0 },
/* U+09b6 */ { 19, 0, 1, 0, 0 },
/* U+09b7 */ { 19, 0, 1, 0, 0 },
/* U+09b8 */ { 19, 0, 1, 0, 0 },
/* U+09b9 */ { 19, 0, 1, 0, 0 },
/* U+09ba */ { 0, 0, 0, 0, 0 },
/* U+09bb */ { 0, 0, 0, 0, 0 },
/* U+09bc */ { 4, 7, 14, 0, 0 },
/* U+09bd */ { 0, 0, 0, 0, 0 },
/* U+09be */ { 5, 0, 1, 0, 0 },
/* U+09bf */ { 5, 0, 1, 0, 0 },
/* U+09c0 */ { 5, 0, 1, 0, 0 },
/* U+09c1 */ { 4, 0, 14, 0, 0 },
/* U+09c2 */ { 4, 0, 14, 0, 0 },
/* U+09c3 */ { 4, 0, 14, 0, 0 },
/* U+09c4 */ { 4, 0, 14, 0, 0 },
/* U+09c5 */ { 0, 0, 0, 0, 0 },
/* U+09c6 */ { 0, 0, 0, 0, 0 },
/* U+09c7 */ { 5, 0, 1, 0, 0 },
/* U+09c8 */ { 5, 0, 1, 0, 0 },
/* U+09c9 */ { 0, 0, 0, 0, 0 },
/* U+09ca */ { 0, 0, 0, 0, 0 },
/* U+09cb */ { 5, 0, 1, 0, "09C7 09BE" },
/* U+09cc */ { 5, 0, 1, 0, "09C7 09D7" },
/* U+09cd */ { 4, 9, 14, 0, 0 },
/* U+09ce */ { 0, 0, 0, 0, 0 },
/* U+09cf */ { 0, 0, 0, 0, 0 },
/* U+09d0 */ { 0, 0, 0, 0, 0 },
/* U+09d1 */ { 0, 0, 0, 0, 0 },
/* U+09d2 */ { 0, 0, 0, 0, 0 },
/* U+09d3 */ { 0, 0, 0, 0, 0 },
/* U+09d4 */ { 0, 0, 0, 0, 0 },
/* U+09d5 */ { 0, 0, 0, 0, 0 },
/* U+09d6 */ { 0, 0, 0, 0, 0 },
/* U+09d7 */ { 5, 0, 1, 0, 0 },
/* U+09d8 */ { 0, 0, 0, 0, 0 },
/* U+09d9 */ { 0, 0, 0, 0, 0 },
/* U+09da */ { 0, 0, 0, 0, 0 },
/* U+09db */ { 0, 0, 0, 0, 0 },
/* U+09dc */ { 19, 0, 1, 0, "09A1 09BC" },
/* U+09dd */ { 19, 0, 1, 0, "09A2 09BC" },
/* U+09de */ { 0, 0, 0, 0, 0 },
/* U+09df */ { 19, 0, 1, 0, "09AF 09BC" },
/* U+09e0 */ { 19, 0, 1, 0, 0 },
/* U+09e1 */ { 19, 0, 1, 0, 0 },
/* U+09e2 */ { 4, 0, 14, 0, 0 },
/* U+09e3 */ { 4, 0, 14, 0, 0 },
/* U+09e4 */ { 0, 0, 0, 0, 0 },
/* U+09e5 */ { 0, 0, 0, 0, 0 },
/* U+09e6 */ { 7, 0, 1, 0, 0 },
/* U+09e7 */ { 7, 0, 1, 0, 0 },
/* U+09e8 */ { 7, 0, 1, 0, 0 },
/* U+09e9 */ { 7, 0, 1, 0, 0 },
/* U+09ea */ { 7, 0, 1, 0, 0 },
/* U+09eb */ { 7, 0, 1, 0, 0 },
/* U+09ec */ { 7, 0, 1, 0, 0 },
/* U+09ed */ { 7, 0, 1, 0, 0 },
/* U+09ee */ { 7, 0, 1, 0, 0 },
/* U+09ef */ { 7, 0, 1, 0, 0 },
/* U+09f0 */ { 19, 0, 1, 0, 0 },
/* U+09f1 */ { 19, 0, 1, 0, 0 },
/* U+09f2 */ { 28, 0, 11, 0, 0 },
/* U+09f3 */ { 28, 0, 11, 0, 0 },
/* U+09f4 */ { 9, 0, 1, 0, 0 },
/* U+09f5 */ { 9, 0, 1, 0, 0 },
/* U+09f6 */ { 9, 0, 1, 0, 0 },
/* U+09f7 */ { 9, 0, 1, 0, 0 },
/* U+09f8 */ { 9, 0, 1, 0, 0 },
/* U+09f9 */ { 9, 0, 1, 0, 0 },
/* U+09fa */ { 30, 0, 1, 0, 0 },
/* U+09fb */ { 0, 0, 0, 0, 0 },
/* U+09fc */ { 0, 0, 0, 0, 0 },
/* U+09fd */ { 0, 0, 0, 0, 0 },
/* U+09fe */ { 0, 0, 0, 0, 0 },
/* U+09ff */ { 0, 0, 0, 0, 0 },
/* U+0a00 */ { 0, 0, 0, 0, 0 },
/* U+0a01 */ { 0, 0, 0, 0, 0 },
/* U+0a02 */ { 4, 0, 14, 0, 0 },
/* U+0a03 */ { 0, 0, 0, 0, 0 },
/* U+0a04 */ { 0, 0, 0, 0, 0 },
/* U+0a05 */ { 19, 0, 1, 0, 0 },
/* U+0a06 */ { 19, 0, 1, 0, 0 },
/* U+0a07 */ { 19, 0, 1, 0, 0 },
/* U+0a08 */ { 19, 0, 1, 0, 0 },
/* U+0a09 */ { 19, 0, 1, 0, 0 },
/* U+0a0a */ { 19, 0, 1, 0, 0 },
/* U+0a0b */ { 0, 0, 0, 0, 0 },
/* U+0a0c */ { 0, 0, 0, 0, 0 },
/* U+0a0d */ { 0, 0, 0, 0, 0 },
/* U+0a0e */ { 0, 0, 0, 0, 0 },
/* U+0a0f */ { 19, 0, 1, 0, 0 },
/* U+0a10 */ { 19, 0, 1, 0, 0 },
/* U+0a11 */ { 0, 0, 0, 0, 0 },
/* U+0a12 */ { 0, 0, 0, 0, 0 },
/* U+0a13 */ { 19, 0, 1, 0, 0 },
/* U+0a14 */ { 19, 0, 1, 0, 0 },
/* U+0a15 */ { 19, 0, 1, 0, 0 },
/* U+0a16 */ { 19, 0, 1, 0, 0 },
/* U+0a17 */ { 19, 0, 1, 0, 0 },
/* U+0a18 */ { 19, 0, 1, 0, 0 },
/* U+0a19 */ { 19, 0, 1, 0, 0 },
/* U+0a1a */ { 19, 0, 1, 0, 0 },
/* U+0a1b */ { 19, 0, 1, 0, 0 },
/* U+0a1c */ { 19, 0, 1, 0, 0 },
/* U+0a1d */ { 19, 0, 1, 0, 0 },
/* U+0a1e */ { 19, 0, 1, 0, 0 },
/* U+0a1f */ { 19, 0, 1, 0, 0 },
/* U+0a20 */ { 19, 0, 1, 0, 0 },
/* U+0a21 */ { 19, 0, 1, 0, 0 },
/* U+0a22 */ { 19, 0, 1, 0, 0 },
/* U+0a23 */ { 19, 0, 1, 0, 0 },
/* U+0a24 */ { 19, 0, 1, 0, 0 },
/* U+0a25 */ { 19, 0, 1, 0, 0 },
/* U+0a26 */ { 19, 0, 1, 0, 0 },
/* U+0a27 */ { 19, 0, 1, 0, 0 },
/* U+0a28 */ { 19, 0, 1, 0, 0 },
/* U+0a29 */ { 0, 0, 0, 0, 0 },
/* U+0a2a */ { 19, 0, 1, 0, 0 },
/* U+0a2b */ { 19, 0, 1, 0, 0 },
/* U+0a2c */ { 19, 0, 1, 0, 0 },
/* U+0a2d */ { 19, 0, 1, 0, 0 },
/* U+0a2e */ { 19, 0, 1, 0, 0 },
/* U+0a2f */ { 19, 0, 1, 0, 0 },
/* U+0a30 */ { 19, 0, 1, 0, 0 },
/* U+0a31 */ { 0, 0, 0, 0, 0 },
/* U+0a32 */ { 19, 0, 1, 0, 0 },
/* U+0a33 */ { 19, 0, 1, 0, "0A32 0A3C" },
/* U+0a34 */ { 0, 0, 0, 0, 0 },
/* U+0a35 */ { 19, 0, 1, 0, 0 },
/* U+0a36 */ { 19, 0, 1, 0, "0A38 0A3C" },
/* U+0a37 */ { 0, 0, 0, 0, 0 },
/* U+0a38 */ { 19, 0, 1, 0, 0 },
/* U+0a39 */ { 19, 0, 1, 0, 0 },
/* U+0a3a */ { 0, 0, 0, 0, 0 },
/* U+0a3b */ { 0, 0, 0, 0, 0 },
/* U+0a3c */ { 4, 7, 14, 0, 0 },
/* U+0a3d */ { 0, 0, 0, 0, 0 },
/* U+0a3e */ { 5, 0, 1, 0, 0 },
/* U+0a3f */ { 5, 0, 1, 0, 0 },
/* U+0a40 */ { 5, 0, 1, 0, 0 },
/* U+0a41 */ { 4, 0, 14, 0, 0 },
/* U+0a42 */ { 4, 0, 14, 0, 0 },
/* U+0a43 */ { 0, 0, 0, 0, 0 },
/* U+0a44 */ { 0, 0, 0, 0, 0 },
/* U+0a45 */ { 0, 0, 0, 0, 0 },
/* U+0a46 */ { 0, 0, 0, 0, 0 },
/* U+0a47 */ { 4, 0, 14, 0, 0 },
/* U+0a48 */ { 4, 0, 14, 0, 0 },
/* U+0a49 */ { 0, 0, 0, 0, 0 },
/* U+0a4a */ { 0, 0, 0, 0, 0 },
/* U+0a4b */ { 4, 0, 14, 0, 0 },
/* U+0a4c */ { 4, 0, 14, 0, 0 },
/* U+0a4d */ { 4, 9, 14, 0, 0 },
/* U+0a4e */ { 0, 0, 0, 0, 0 },
/* U+0a4f */ { 0, 0, 0, 0, 0 },
/* U+0a50 */ { 0, 0, 0, 0, 0 },
/* U+0a51 */ { 0, 0, 0, 0, 0 },
/* U+0a52 */ { 0, 0, 0, 0, 0 },
/* U+0a53 */ { 0, 0, 0, 0, 0 },
/* U+0a54 */ { 0, 0, 0, 0, 0 },
/* U+0a55 */ { 0, 0, 0, 0, 0 },
/* U+0a56 */ { 0, 0, 0, 0, 0 },
/* U+0a57 */ { 0, 0, 0, 0, 0 },
/* U+0a58 */ { 0, 0, 0, 0, 0 },
/* U+0a59 */ { 19, 0, 1, 0, "0A16 0A3C" },
/* U+0a5a */ { 19, 0, 1, 0, "0A17 0A3C" },
/* U+0a5b */ { 19, 0, 1, 0, "0A1C 0A3C" },
/* U+0a5c */ { 19, 0, 1, 0, 0 },
/* U+0a5d */ { 0, 0, 0, 0, 0 },
/* U+0a5e */ { 19, 0, 1, 0, "0A2B 0A3C" },
/* U+0a5f */ { 0, 0, 0, 0, 0 },
/* U+0a60 */ { 0, 0, 0, 0, 0 },
/* U+0a61 */ { 0, 0, 0, 0, 0 },
/* U+0a62 */ { 0, 0, 0, 0, 0 },
/* U+0a63 */ { 0, 0, 0, 0, 0 },
/* U+0a64 */ { 0, 0, 0, 0, 0 },
/* U+0a65 */ { 0, 0, 0, 0, 0 },
/* U+0a66 */ { 7, 0, 1, 0, 0 },
/* U+0a67 */ { 7, 0, 1, 0, 0 },
/* U+0a68 */ { 7, 0, 1, 0, 0 },
/* U+0a69 */ { 7, 0, 1, 0, 0 },
/* U+0a6a */ { 7, 0, 1, 0, 0 },
/* U+0a6b */ { 7, 0, 1, 0, 0 },
/* U+0a6c */ { 7, 0, 1, 0, 0 },
/* U+0a6d */ { 7, 0, 1, 0, 0 },
/* U+0a6e */ { 7, 0, 1, 0, 0 },
/* U+0a6f */ { 7, 0, 1, 0, 0 },
/* U+0a70 */ { 4, 0, 14, 0, 0 },
/* U+0a71 */ { 4, 0, 14, 0, 0 },
/* U+0a72 */ { 19, 0, 1, 0, 0 },
/* U+0a73 */ { 19, 0, 1, 0, 0 },
/* U+0a74 */ { 19, 0, 1, 0, 0 },
/* U+0a75 */ { 0, 0, 0, 0, 0 },
/* U+0a76 */ { 0, 0, 0, 0, 0 },
/* U+0a77 */ { 0, 0, 0, 0, 0 },
/* U+0a78 */ { 0, 0, 0, 0, 0 },
/* U+0a79 */ { 0, 0, 0, 0, 0 },
/* U+0a7a */ { 0, 0, 0, 0, 0 },
/* U+0a7b */ { 0, 0, 0, 0, 0 },
/* U+0a7c */ { 0, 0, 0, 0, 0 },
/* U+0a7d */ { 0, 0, 0, 0, 0 },
/* U+0a7e */ { 0, 0, 0, 0, 0 },
/* U+0a7f */ { 0, 0, 0, 0, 0 },
/* U+0a80 */ { 0, 0, 0, 0, 0 },
/* U+0a81 */ { 4, 0, 14, 0, 0 },
/* U+0a82 */ { 4, 0, 14, 0, 0 },
/* U+0a83 */ { 5, 0, 1, 0, 0 },
/* U+0a84 */ { 0, 0, 0, 0, 0 },
/* U+0a85 */ { 19, 0, 1, 0, 0 },
/* U+0a86 */ { 19, 0, 1, 0, 0 },
/* U+0a87 */ { 19, 0, 1, 0, 0 },
/* U+0a88 */ { 19, 0, 1, 0, 0 },
/* U+0a89 */ { 19, 0, 1, 0, 0 },
/* U+0a8a */ { 19, 0, 1, 0, 0 },
/* U+0a8b */ { 19, 0, 1, 0, 0 },
/* U+0a8c */ { 0, 0, 0, 0, 0 },
/* U+0a8d */ { 19, 0, 1, 0, 0 },
/* U+0a8e */ { 0, 0, 0, 0, 0 },
/* U+0a8f */ { 19, 0, 1, 0, 0 },
/* U+0a90 */ { 19, 0, 1, 0, 0 },
/* U+0a91 */ { 19, 0, 1, 0, 0 },
/* U+0a92 */ { 0, 0, 0, 0, 0 },
/* U+0a93 */ { 19, 0, 1, 0, 0 },
/* U+0a94 */ { 19, 0, 1, 0, 0 },
/* U+0a95 */ { 19, 0, 1, 0, 0 },
/* U+0a96 */ { 19, 0, 1, 0, 0 },
/* U+0a97 */ { 19, 0, 1, 0, 0 },
/* U+0a98 */ { 19, 0, 1, 0, 0 },
/* U+0a99 */ { 19, 0, 1, 0, 0 },
/* U+0a9a */ { 19, 0, 1, 0, 0 },
/* U+0a9b */ { 19, 0, 1, 0, 0 },
/* U+0a9c */ { 19, 0, 1, 0, 0 },
/* U+0a9d */ { 19, 0, 1, 0, 0 },
/* U+0a9e */ { 19, 0, 1, 0, 0 },
/* U+0a9f */ { 19, 0, 1, 0, 0 },
/* U+0aa0 */ { 19, 0, 1, 0, 0 },
/* U+0aa1 */ { 19, 0, 1, 0, 0 },
/* U+0aa2 */ { 19, 0, 1, 0, 0 },
/* U+0aa3 */ { 19, 0, 1, 0, 0 },
/* U+0aa4 */ { 19, 0, 1, 0, 0 },
/* U+0aa5 */ { 19, 0, 1, 0, 0 },
/* U+0aa6 */ { 19, 0, 1, 0, 0 },
/* U+0aa7 */ { 19, 0, 1, 0, 0 },
/* U+0aa8 */ { 19, 0, 1, 0, 0 },
/* U+0aa9 */ { 0, 0, 0, 0, 0 },
/* U+0aaa */ { 19, 0, 1, 0, 0 },
/* U+0aab */ { 19, 0, 1, 0, 0 },
/* U+0aac */ { 19, 0, 1, 0, 0 },
/* U+0aad */ { 19, 0, 1, 0, 0 },
/* U+0aae */ { 19, 0, 1, 0, 0 },
/* U+0aaf */ { 19, 0, 1, 0, 0 },
/* U+0ab0 */ { 19, 0, 1, 0, 0 },
/* U+0ab1 */ { 0, 0, 0, 0, 0 },
/* U+0ab2 */ { 19, 0, 1, 0, 0 },
/* U+0ab3 */ { 19, 0, 1, 0, 0 },
/* U+0ab4 */ { 0, 0, 0, 0, 0 },
/* U+0ab5 */ { 19, 0, 1, 0, 0 },
/* U+0ab6 */ { 19, 0, 1, 0, 0 },
/* U+0ab7 */ { 19, 0, 1, 0, 0 },
/* U+0ab8 */ { 19, 0, 1, 0, 0 },
/* U+0ab9 */ { 19, 0, 1, 0, 0 },
/* U+0aba */ { 0, 0, 0, 0, 0 },
/* U+0abb */ { 0, 0, 0, 0, 0 },
/* U+0abc */ { 4, 7, 14, 0, 0 },
/* U+0abd */ { 19, 0, 1, 0, 0 },
/* U+0abe */ { 5, 0, 1, 0, 0 },
/* U+0abf */ { 5, 0, 1, 0, 0 },
/* U+0ac0 */ { 5, 0, 1, 0, 0 },
/* U+0ac1 */ { 4, 0, 14, 0, 0 },
/* U+0ac2 */ { 4, 0, 14, 0, 0 },
/* U+0ac3 */ { 4, 0, 14, 0, 0 },
/* U+0ac4 */ { 4, 0, 14, 0, 0 },
/* U+0ac5 */ { 4, 0, 14, 0, 0 },
/* U+0ac6 */ { 0, 0, 0, 0, 0 },
/* U+0ac7 */ { 4, 0, 14, 0, 0 },
/* U+0ac8 */ { 4, 0, 14, 0, 0 },
/* U+0ac9 */ { 5, 0, 1, 0, 0 },
/* U+0aca */ { 0, 0, 0, 0, 0 },
/* U+0acb */ { 5, 0, 1, 0, 0 },
/* U+0acc */ { 5, 0, 1, 0, 0 },
/* U+0acd */ { 4, 9, 14, 0, 0 },
/* U+0ace */ { 0, 0, 0, 0, 0 },
/* U+0acf */ { 0, 0, 0, 0, 0 },
/* U+0ad0 */ { 19, 0, 1, 0, 0 },
/* U+0ad1 */ { 0, 0, 0, 0, 0 },
/* U+0ad2 */ { 0, 0, 0, 0, 0 },
/* U+0ad3 */ { 0, 0, 0, 0, 0 },
/* U+0ad4 */ { 0, 0, 0, 0, 0 },
/* U+0ad5 */ { 0, 0, 0, 0, 0 },
/* U+0ad6 */ { 0, 0, 0, 0, 0 },
/* U+0ad7 */ { 0, 0, 0, 0, 0 },
/* U+0ad8 */ { 0, 0, 0, 0, 0 },
/* U+0ad9 */ { 0, 0, 0, 0, 0 },
/* U+0ada */ { 0, 0, 0, 0, 0 },
/* U+0adb */ { 0, 0, 0, 0, 0 },
/* U+0adc */ { 0, 0, 0, 0, 0 },
/* U+0add */ { 0, 0, 0, 0, 0 },
/* U+0ade */ { 0, 0, 0, 0, 0 },
/* U+0adf */ { 0, 0, 0, 0, 0 },
/* U+0ae0 */ { 19, 0, 1, 0, 0 },
/* U+0ae1 */ { 0, 0, 0, 0, 0 },
/* U+0ae2 */ { 0, 0, 0, 0, 0 },
/* U+0ae3 */ { 0, 0, 0, 0, 0 },
/* U+0ae4 */ { 0, 0, 0, 0, 0 },
/* U+0ae5 */ { 0, 0, 0, 0, 0 },
/* U+0ae6 */ { 7, 0, 1, 0, 0 },
/* U+0ae7 */ { 7, 0, 1, 0, 0 },
/* U+0ae8 */ { 7, 0, 1, 0, 0 },
/* U+0ae9 */ { 7, 0, 1, 0, 0 },
/* U+0aea */ { 7, 0, 1, 0, 0 },
/* U+0aeb */ { 7, 0, 1, 0, 0 },
/* U+0aec */ { 7, 0, 1, 0, 0 },
/* U+0aed */ { 7, 0, 1, 0, 0 },
/* U+0aee */ { 7, 0, 1, 0, 0 },
/* U+0aef */ { 7, 0, 1, 0, 0 },
/* U+0af0 */ { 0, 0, 0, 0, 0 },
/* U+0af1 */ { 0, 0, 0, 0, 0 },
/* U+0af2 */ { 0, 0, 0, 0, 0 },
/* U+0af3 */ { 0, 0, 0, 0, 0 },
/* U+0af4 */ { 0, 0, 0, 0, 0 },
/* U+0af5 */ { 0, 0, 0, 0, 0 },
/* U+0af6 */ { 0, 0, 0, 0, 0 },
/* U+0af7 */ { 0, 0, 0, 0, 0 },
/* U+0af8 */ { 0, 0, 0, 0, 0 },
/* U+0af9 */ { 0, 0, 0, 0, 0 },
/* U+0afa */ { 0, 0, 0, 0, 0 },
/* U+0afb */ { 0, 0, 0, 0, 0 },
/* U+0afc */ { 0, 0, 0, 0, 0 },
/* U+0afd */ { 0, 0, 0, 0, 0 },
/* U+0afe */ { 0, 0, 0, 0, 0 },
/* U+0aff */ { 0, 0, 0, 0, 0 },
/* U+0b00 */ { 0, 0, 0, 0, 0 },
/* U+0b01 */ { 4, 0, 14, 0, 0 },
/* U+0b02 */ { 5, 0, 1, 0, 0 },
/* U+0b03 */ { 5, 0, 1, 0, 0 },
/* U+0b04 */ { 0, 0, 0, 0, 0 },
/* U+0b05 */ { 19, 0, 1, 0, 0 },
/* U+0b06 */ { 19, 0, 1, 0, 0 },
/* U+0b07 */ { 19, 0, 1, 0, 0 },
/* U+0b08 */ { 19, 0, 1, 0, 0 },
/* U+0b09 */ { 19, 0, 1, 0, 0 },
/* U+0b0a */ { 19, 0, 1, 0, 0 },
/* U+0b0b */ { 19, 0, 1, 0, 0 },
/* U+0b0c */ { 19, 0, 1, 0, 0 },
/* U+0b0d */ { 0, 0, 0, 0, 0 },
/* U+0b0e */ { 0, 0, 0, 0, 0 },
/* U+0b0f */ { 19, 0, 1, 0, 0 },
/* U+0b10 */ { 19, 0, 1, 0, 0 },
/* U+0b11 */ { 0, 0, 0, 0, 0 },
/* U+0b12 */ { 0, 0, 0, 0, 0 },
/* U+0b13 */ { 19, 0, 1, 0, 0 },
/* U+0b14 */ { 19, 0, 1, 0, 0 },
/* U+0b15 */ { 19, 0, 1, 0, 0 },
/* U+0b16 */ { 19, 0, 1, 0, 0 },
/* U+0b17 */ { 19, 0, 1, 0, 0 },
/* U+0b18 */ { 19, 0, 1, 0, 0 },
/* U+0b19 */ { 19, 0, 1, 0, 0 },
/* U+0b1a */ { 19, 0, 1, 0, 0 },
/* U+0b1b */ { 19, 0, 1, 0, 0 },
/* U+0b1c */ { 19, 0, 1, 0, 0 },
/* U+0b1d */ { 19, 0, 1, 0, 0 },
/* U+0b1e */ { 19, 0, 1, 0, 0 },
/* U+0b1f */ { 19, 0, 1, 0, 0 },
/* U+0b20 */ { 19, 0, 1, 0, 0 },
/* U+0b21 */ { 19, 0, 1, 0, 0 },
/* U+0b22 */ { 19, 0, 1, 0, 0 },
/* U+0b23 */ { 19, 0, 1, 0, 0 },
/* U+0b24 */ { 19, 0, 1, 0, 0 },
/* U+0b25 */ { 19, 0, 1, 0, 0 },
/* U+0b26 */ { 19, 0, 1, 0, 0 },
/* U+0b27 */ { 19, 0, 1, 0, 0 },
/* U+0b28 */ { 19, 0, 1, 0, 0 },
/* U+0b29 */ { 0, 0, 0, 0, 0 },
/* U+0b2a */ { 19, 0, 1, 0, 0 },
/* U+0b2b */ { 19, 0, 1, 0, 0 },
/* U+0b2c */ { 19, 0, 1, 0, 0 },
/* U+0b2d */ { 19, 0, 1, 0, 0 },
/* U+0b2e */ { 19, 0, 1, 0, 0 },
/* U+0b2f */ { 19, 0, 1, 0, 0 },
/* U+0b30 */ { 19, 0, 1, 0, 0 },
/* U+0b31 */ { 0, 0, 0, 0, 0 },
/* U+0b32 */ { 19, 0, 1, 0, 0 },
/* U+0b33 */ { 19, 0, 1, 0, 0 },
/* U+0b34 */ { 0, 0, 0, 0, 0 },
/* U+0b35 */ { 0, 0, 0, 0, 0 },
/* U+0b36 */ { 19, 0, 1, 0, 0 },
/* U+0b37 */ { 19, 0, 1, 0, 0 },
/* U+0b38 */ { 19, 0, 1, 0, 0 },
/* U+0b39 */ { 19, 0, 1, 0, 0 },
/* U+0b3a */ { 0, 0, 0, 0, 0 },
/* U+0b3b */ { 0, 0, 0, 0, 0 },
/* U+0b3c */ { 4, 7, 14, 0, 0 },
/* U+0b3d */ { 19, 0, 1, 0, 0 },
/* U+0b3e */ { 5, 0, 1, 0, 0 },
/* U+0b3f */ { 4, 0, 14, 0, 0 },
/* U+0b40 */ { 5, 0, 1, 0, 0 },
/* U+0b41 */ { 4, 0, 14, 0, 0 },
/* U+0b42 */ { 4, 0, 14, 0, 0 },
/* U+0b43 */ { 4, 0, 14, 0, 0 },
/* U+0b44 */ { 0, 0, 0, 0, 0 },
/* U+0b45 */ { 0, 0, 0, 0, 0 },
/* U+0b46 */ { 0, 0, 0, 0, 0 },
/* U+0b47 */ { 5, 0, 1, 0, 0 },
/* U+0b48 */ { 5, 0, 1, 0, "0B47 0B56" },
/* U+0b49 */ { 0, 0, 0, 0, 0 },
/* U+0b4a */ { 0, 0, 0, 0, 0 },
/* U+0b4b */ { 5, 0, 1, 0, "0B47 0B3E" },
/* U+0b4c */ { 5, 0, 1, 0, "0B47 0B57" },
/* U+0b4d */ { 4, 9, 14, 0, 0 },
/* U+0b4e */ { 0, 0, 0, 0, 0 },
/* U+0b4f */ { 0, 0, 0, 0, 0 },
/* U+0b50 */ { 0, 0, 0, 0, 0 },
/* U+0b51 */ { 0, 0, 0, 0, 0 },
/* U+0b52 */ { 0, 0, 0, 0, 0 },
/* U+0b53 */ { 0, 0, 0, 0, 0 },
/* U+0b54 */ { 0, 0, 0, 0, 0 },
/* U+0b55 */ { 0, 0, 0, 0, 0 },
/* U+0b56 */ { 4, 0, 14, 0, 0 },
/* U+0b57 */ { 5, 0, 1, 0, 0 },
/* U+0b58 */ { 0, 0, 0, 0, 0 },
/* U+0b59 */ { 0, 0, 0, 0, 0 },
/* U+0b5a */ { 0, 0, 0, 0, 0 },
/* U+0b5b */ { 0, 0, 0, 0, 0 },
/* U+0b5c */ { 19, 0, 1, 0, "0B21 0B3C" },
/* U+0b5d */ { 19, 0, 1, 0, "0B22 0B3C" },
/* U+0b5e */ { 0, 0, 0, 0, 0 },
/* U+0b5f */ { 19, 0, 1, 0, 0 },
/* U+0b60 */ { 19, 0, 1, 0, 0 },
/* U+0b61 */ { 19, 0, 1, 0, 0 },
/* U+0b62 */ { 0, 0, 0, 0, 0 },
/* U+0b63 */ { 0, 0, 0, 0, 0 },
/* U+0b64 */ { 0, 0, 0, 0, 0 },
/* U+0b65 */ { 0, 0, 0, 0, 0 },
/* U+0b66 */ { 7, 0, 1, 0, 0 },
/* U+0b67 */ { 7, 0, 1, 0, 0 },
/* U+0b68 */ { 7, 0, 1, 0, 0 },
/* U+0b69 */ { 7, 0, 1, 0, 0 },
/* U+0b6a */ { 7, 0, 1, 0, 0 },
/* U+0b6b */ { 7, 0, 1, 0, 0 },
/* U+0b6c */ { 7, 0, 1, 0, 0 },
/* U+0b6d */ { 7, 0, 1, 0, 0 },
/* U+0b6e */ { 7, 0, 1, 0, 0 },
/* U+0b6f */ { 7, 0, 1, 0, 0 },
/* U+0b70 */ { 30, 0, 1, 0, 0 },
/* U+0b71 */ { 0, 0, 0, 0, 0 },
/* U+0b72 */ { 0, 0, 0, 0, 0 },
/* U+0b73 */ { 0, 0, 0, 0, 0 },
/* U+0b74 */ { 0, 0, 0, 0, 0 },
/* U+0b75 */ { 0, 0, 0, 0, 0 },
/* U+0b76 */ { 0, 0, 0, 0, 0 },
/* U+0b77 */ { 0, 0, 0, 0, 0 },
/* U+0b78 */ { 0, 0, 0, 0, 0 },
/* U+0b79 */ { 0, 0, 0, 0, 0 },
/* U+0b7a */ { 0, 0, 0, 0, 0 },
/* U+0b7b */ { 0, 0, 0, 0, 0 },
/* U+0b7c */ { 0, 0, 0, 0, 0 },
/* U+0b7d */ { 0, 0, 0, 0, 0 },
/* U+0b7e */ { 0, 0, 0, 0, 0 },
/* U+0b7f */ { 0, 0, 0, 0, 0 },
/* U+0b80 */ { 0, 0, 0, 0, 0 },
/* U+0b81 */ { 0, 0, 0, 0, 0 },
/* U+0b82 */ { 4, 0, 14, 0, 0 },
/* U+0b83 */ { 5, 0, 1, 0, 0 },
/* U+0b84 */ { 0, 0, 0, 0, 0 },
/* U+0b85 */ { 19, 0, 1, 0, 0 },
/* U+0b86 */ { 19, 0, 1, 0, 0 },
/* U+0b87 */ { 19, 0, 1, 0, 0 },
/* U+0b88 */ { 19, 0, 1, 0, 0 },
/* U+0b89 */ { 19, 0, 1, 0, 0 },
/* U+0b8a */ { 19, 0, 1, 0, 0 },
/* U+0b8b */ { 0, 0, 0, 0, 0 },
/* U+0b8c */ { 0, 0, 0, 0, 0 },
/* U+0b8d */ { 0, 0, 0, 0, 0 },
/* U+0b8e */ { 19, 0, 1, 0, 0 },
/* U+0b8f */ { 19, 0, 1, 0, 0 },
/* U+0b90 */ { 19, 0, 1, 0, 0 },
/* U+0b91 */ { 0, 0, 0, 0, 0 },
/* U+0b92 */ { 19, 0, 1, 0, 0 },
/* U+0b93 */ { 19, 0, 1, 0, 0 },
/* U+0b94 */ { 19, 0, 1, 0, "0B92 0BD7" },
/* U+0b95 */ { 19, 0, 1, 0, 0 },
/* U+0b96 */ { 0, 0, 0, 0, 0 },
/* U+0b97 */ { 0, 0, 0, 0, 0 },
/* U+0b98 */ { 0, 0, 0, 0, 0 },
/* U+0b99 */ { 19, 0, 1, 0, 0 },
/* U+0b9a */ { 19, 0, 1, 0, 0 },
/* U+0b9b */ { 0, 0, 0, 0, 0 },
/* U+0b9c */ { 19, 0, 1, 0, 0 },
/* U+0b9d */ { 0, 0, 0, 0, 0 },
/* U+0b9e */ { 19, 0, 1, 0, 0 },
/* U+0b9f */ { 19, 0, 1, 0, 0 },
/* U+0ba0 */ { 0, 0, 0, 0, 0 },
/* U+0ba1 */ { 0, 0, 0, 0, 0 },
/* U+0ba2 */ { 0, 0, 0, 0, 0 },
/* U+0ba3 */ { 19, 0, 1, 0, 0 },
/* U+0ba4 */ { 19, 0, 1, 0, 0 },
/* U+0ba5 */ { 0, 0, 0, 0, 0 },
/* U+0ba6 */ { 0, 0, 0, 0, 0 },
/* U+0ba7 */ { 0, 0, 0, 0, 0 },
/* U+0ba8 */ { 19, 0, 1, 0, 0 },
/* U+0ba9 */ { 19, 0, 1, 0, 0 },
/* U+0baa */ { 19, 0, 1, 0, 0 },
/* U+0bab */ { 0, 0, 0, 0, 0 },
/* U+0bac */ { 0, 0, 0, 0, 0 },
/* U+0bad */ { 0, 0, 0, 0, 0 },
/* U+0bae */ { 19, 0, 1, 0, 0 },
/* U+0baf */ { 19, 0, 1, 0, 0 },
/* U+0bb0 */ { 19, 0, 1, 0, 0 },
/* U+0bb1 */ { 19, 0, 1, 0, 0 },
/* U+0bb2 */ { 19, 0, 1, 0, 0 },
/* U+0bb3 */ { 19, 0, 1, 0, 0 },
/* U+0bb4 */ { 19, 0, 1, 0, 0 },
/* U+0bb5 */ { 19, 0, 1, 0, 0 },
/* U+0bb6 */ { 0, 0, 0, 0, 0 },
/* U+0bb7 */ { 19, 0, 1, 0, 0 },
/* U+0bb8 */ { 19, 0, 1, 0, 0 },
/* U+0bb9 */ { 19, 0, 1, 0, 0 },
/* U+0bba */ { 0, 0, 0, 0, 0 },
/* U+0bbb */ { 0, 0, 0, 0, 0 },
/* U+0bbc */ { 0, 0, 0, 0, 0 },
/* U+0bbd */ { 0, 0, 0, 0, 0 },
/* U+0bbe */ { 5, 0, 1, 0, 0 },
/* U+0bbf */ { 5, 0, 1, 0, 0 },
/* U+0bc0 */ { 4, 0, 14, 0, 0 },
/* U+0bc1 */ { 5, 0, 1, 0, 0 },
/* U+0bc2 */ { 5, 0, 1, 0, 0 },
/* U+0bc3 */ { 0, 0, 0, 0, 0 },
/* U+0bc4 */ { 0, 0, 0, 0, 0 },
/* U+0bc5 */ { 0, 0, 0, 0, 0 },
/* U+0bc6 */ { 5, 0, 1, 0, 0 },
/* U+0bc7 */ { 5, 0, 1, 0, 0 },
/* U+0bc8 */ { 5, 0, 1, 0, 0 },
/* U+0bc9 */ { 0, 0, 0, 0, 0 },
/* U+0bca */ { 5, 0, 1, 0, "0BC6 0BBE" },
/* U+0bcb */ { 5, 0, 1, 0, "0BC7 0BBE" },
/* U+0bcc */ { 5, 0, 1, 0, "0BC6 0BD7" },
/* U+0bcd */ { 4, 9, 14, 0, 0 },
/* U+0bce */ { 0, 0, 0, 0, 0 },
/* U+0bcf */ { 0, 0, 0, 0, 0 },
/* U+0bd0 */ { 0, 0, 0, 0, 0 },
/* U+0bd1 */ { 0, 0, 0, 0, 0 },
/* U+0bd2 */ { 0, 0, 0, 0, 0 },
/* U+0bd3 */ { 0, 0, 0, 0, 0 },
/* U+0bd4 */ { 0, 0, 0, 0, 0 },
/* U+0bd5 */ { 0, 0, 0, 0, 0 },
/* U+0bd6 */ { 0, 0, 0, 0, 0 },
/* U+0bd7 */ { 5, 0, 1, 0, 0 },
/* U+0bd8 */ { 0, 0, 0, 0, 0 },
/* U+0bd9 */ { 0, 0, 0, 0, 0 },
/* U+0bda */ { 0, 0, 0, 0, 0 },
/* U+0bdb */ { 0, 0, 0, 0, 0 },
/* U+0bdc */ { 0, 0, 0, 0, 0 },
/* U+0bdd */ { 0, 0, 0, 0, 0 },
/* U+0bde */ { 0, 0, 0, 0, 0 },
/* U+0bdf */ { 0, 0, 0, 0, 0 },
/* U+0be0 */ { 0, 0, 0, 0, 0 },
/* U+0be1 */ { 0, 0, 0, 0, 0 },
/* U+0be2 */ { 0, 0, 0, 0, 0 },
/* U+0be3 */ { 0, 0, 0, 0, 0 },
/* U+0be4 */ { 0, 0, 0, 0, 0 },
/* U+0be5 */ { 0, 0, 0, 0, 0 },
/* U+0be6 */ { 0, 0, 0, 0, 0 },
/* U+0be7 */ { 7, 0, 1, 0, 0 },
/* U+0be8 */ { 7, 0, 1, 0, 0 },
/* U+0be9 */ { 7, 0, 1, 0, 0 },
/* U+0bea */ { 7, 0, 1, 0, 0 },
/* U+0beb */ { 7, 0, 1, 0, 0 },
/* U+0bec */ { 7, 0, 1, 0, 0 },
/* U+0bed */ { 7, 0, 1, 0, 0 },
/* U+0bee */ { 7, 0, 1, 0, 0 },
/* U+0bef */ { 7, 0, 1, 0, 0 },
/* U+0bf0 */ { 9, 0, 1, 0, 0 },
/* U+0bf1 */ { 9, 0, 1, 0, 0 },
/* U+0bf2 */ { 9, 0, 1, 0, 0 },
/* U+0bf3 */ { 0, 0, 0, 0, 0 },
/* U+0bf4 */ { 0, 0, 0, 0, 0 },
/* U+0bf5 */ { 0, 0, 0, 0, 0 },
/* U+0bf6 */ { 0, 0, 0, 0, 0 },
/* U+0bf7 */ { 0, 0, 0, 0, 0 },
/* U+0bf8 */ { 0, 0, 0, 0, 0 },
/* U+0bf9 */ { 0, 0, 0, 0, 0 },
/* U+0bfa */ { 0, 0, 0, 0, 0 },
/* U+0bfb */ { 0, 0, 0, 0, 0 },
/* U+0bfc */ { 0, 0, 0, 0, 0 },
/* U+0bfd */ { 0, 0, 0, 0, 0 },
/* U+0bfe */ { 0, 0, 0, 0, 0 },
/* U+0bff */ { 0, 0, 0, 0, 0 },
/* U+0c00 */ { 0, 0, 0, 0, 0 },
/* U+0c01 */ { 5, 0, 1, 0, 0 },
/* U+0c02 */ { 5, 0, 1, 0, 0 },
/* U+0c03 */ { 5, 0, 1, 0, 0 },
/* U+0c04 */ { 0, 0, 0, 0, 0 },
/* U+0c05 */ { 19, 0, 1, 0, 0 },
/* U+0c06 */ { 19, 0, 1, 0, 0 },
/* U+0c07 */ { 19, 0, 1, 0, 0 },
/* U+0c08 */ { 19, 0, 1, 0, 0 },
/* U+0c09 */ { 19, 0, 1, 0, 0 },
/* U+0c0a */ { 19, 0, 1, 0, 0 },
/* U+0c0b */ { 19, 0, 1, 0, 0 },
/* U+0c0c */ { 19, 0, 1, 0, 0 },
/* U+0c0d */ { 0, 0, 0, 0, 0 },
/* U+0c0e */ { 19, 0, 1, 0, 0 },
/* U+0c0f */ { 19, 0, 1, 0, 0 },
/* U+0c10 */ { 19, 0, 1, 0, 0 },
/* U+0c11 */ { 0, 0, 0, 0, 0 },
/* U+0c12 */ { 19, 0, 1, 0, 0 },
/* U+0c13 */ { 19, 0, 1, 0, 0 },
/* U+0c14 */ { 19, 0, 1, 0, 0 },
/* U+0c15 */ { 19, 0, 1, 0, 0 },
/* U+0c16 */ { 19, 0, 1, 0, 0 },
/* U+0c17 */ { 19, 0, 1, 0, 0 },
/* U+0c18 */ { 19, 0, 1, 0, 0 },
/* U+0c19 */ { 19, 0, 1, 0, 0 },
/* U+0c1a */ { 19, 0, 1, 0, 0 },
/* U+0c1b */ { 19, 0, 1, 0, 0 },
/* U+0c1c */ { 19, 0, 1, 0, 0 },
/* U+0c1d */ { 19, 0, 1, 0, 0 },
/* U+0c1e */ { 19, 0, 1, 0, 0 },
/* U+0c1f */ { 19, 0, 1, 0, 0 },
/* U+0c20 */ { 19, 0, 1, 0, 0 },
/* U+0c21 */ { 19, 0, 1, 0, 0 },
/* U+0c22 */ { 19, 0, 1, 0, 0 },
/* U+0c23 */ { 19, 0, 1, 0, 0 },
/* U+0c24 */ { 19, 0, 1, 0, 0 },
/* U+0c25 */ { 19, 0, 1, 0, 0 },
/* U+0c26 */ { 19, 0, 1, 0, 0 },
/* U+0c27 */ { 19, 0, 1, 0, 0 },
/* U+0c28 */ { 19, 0, 1, 0, 0 },
/* U+0c29 */ { 0, 0, 0, 0, 0 },
/* U+0c2a */ { 19, 0, 1, 0, 0 },
/* U+0c2b */ { 19, 0, 1, 0, 0 },
/* U+0c2c */ { 19, 0, 1, 0, 0 },
/* U+0c2d */ { 19, 0, 1, 0, 0 },
/* U+0c2e */ { 19, 0, 1, 0, 0 },
/* U+0c2f */ { 19, 0, 1, 0, 0 },
/* U+0c30 */ { 19, 0, 1, 0, 0 },
/* U+0c31 */ { 19, 0, 1, 0, 0 },
/* U+0c32 */ { 19, 0, 1, 0, 0 },
/* U+0c33 */ { 19, 0, 1, 0, 0 },
/* U+0c34 */ { 0, 0, 0, 0, 0 },
/* U+0c35 */ { 19, 0, 1, 0, 0 },
/* U+0c36 */ { 19, 0, 1, 0, 0 },
/* U+0c37 */ { 19, 0, 1, 0, 0 },
/* U+0c38 */ { 19, 0, 1, 0, 0 },
/* U+0c39 */ { 19, 0, 1, 0, 0 },
/* U+0c3a */ { 0, 0, 0, 0, 0 },
/* U+0c3b */ { 0, 0, 0, 0, 0 },
/* U+0c3c */ { 0, 0, 0, 0, 0 },
/* U+0c3d */ { 0, 0, 0, 0, 0 },
/* U+0c3e */ { 4, 0, 14, 0, 0 },
/* U+0c3f */ { 4, 0, 14, 0, 0 },
/* U+0c40 */ { 4, 0, 14, 0, 0 },
/* U+0c41 */ { 5, 0, 1, 0, 0 },
/* U+0c42 */ { 5, 0, 1, 0, 0 },
/* U+0c43 */ { 5, 0, 1, 0, 0 },
/* U+0c44 */ { 5, 0, 1, 0, 0 },
/* U+0c45 */ { 0, 0, 0, 0, 0 },
/* U+0c46 */ { 4, 0, 14, 0, 0 },
/* U+0c47 */ { 4, 0, 14, 0, 0 },
/* U+0c48 */ { 4, 0, 14, 0, "0C46 0C56" },
/* U+0c49 */ { 0, 0, 0, 0, 0 },
/* U+0c4a */ { 4, 0, 14, 0, 0 },
/* U+0c4b */ { 4, 0, 14, 0, 0 },
/* U+0c4c */ { 4, 0, 14, 0, 0 },
/* U+0c4d */ { 4, 9, 14, 0, 0 },
/* U+0c4e */ { 0, 0, 0, 0, 0 },
/* U+0c4f */ { 0, 0, 0, 0, 0 },
/* U+0c50 */ { 0, 0, 0, 0, 0 },
/* U+0c51 */ { 0, 0, 0, 0, 0 },
/* U+0c52 */ { 0, 0, 0, 0, 0 },
/* U+0c53 */ { 0, 0, 0, 0, 0 },
/* U+0c54 */ { 0, 0, 0, 0, 0 },
/* U+0c55 */ { 4, 84, 14, 0, 0 },
/* U+0c56 */ { 4, 91, 14, 0, 0 },
/* U+0c57 */ { 0, 0, 0, 0, 0 },
/* U+0c58 */ { 0, 0, 0, 0, 0 },
/* U+0c59 */ { 0, 0, 0, 0, 0 },
/* U+0c5a */ { 0, 0, 0, 0, 0 },
/* U+0c5b */ { 0, 0, 0, 0, 0 },
/* U+0c5c */ { 0, 0, 0, 0, 0 },
/* U+0c5d */ { 0, 0, 0, 0, 0 },
/* U+0c5e */ { 0, 0, 0, 0, 0 },
/* U+0c5f */ { 0, 0, 0, 0, 0 },
/* U+0c60 */ { 19, 0, 1, 0, 0 },
/* U+0c61 */ { 19, 0, 1, 0, 0 },
/* U+0c62 */ { 0, 0, 0, 0, 0 },
/* U+0c63 */ { 0, 0, 0, 0, 0 },
/* U+0c64 */ { 0, 0, 0, 0, 0 },
/* U+0c65 */ { 0, 0, 0, 0, 0 },
/* U+0c66 */ { 7, 0, 1, 0, 0 },
/* U+0c67 */ { 7, 0, 1, 0, 0 },
/* U+0c68 */ { 7, 0, 1, 0, 0 },
/* U+0c69 */ { 7, 0, 1, 0, 0 },
/* U+0c6a */ { 7, 0, 1, 0, 0 },
/* U+0c6b */ { 7, 0, 1, 0, 0 },
/* U+0c6c */ { 7, 0, 1, 0, 0 },
/* U+0c6d */ { 7, 0, 1, 0, 0 },
/* U+0c6e */ { 7, 0, 1, 0, 0 },
/* U+0c6f */ { 7, 0, 1, 0, 0 },
/* U+0c70 */ { 0, 0, 0, 0, 0 },
/* U+0c71 */ { 0, 0, 0, 0, 0 },
/* U+0c72 */ { 0, 0, 0, 0, 0 },
/* U+0c73 */ { 0, 0, 0, 0, 0 },
/* U+0c74 */ { 0, 0, 0, 0, 0 },
/* U+0c75 */ { 0, 0, 0, 0, 0 },
/* U+0c76 */ { 0, 0, 0, 0, 0 },
/* U+0c77 */ { 0, 0, 0, 0, 0 },
/* U+0c78 */ { 0, 0, 0, 0, 0 },
/* U+0c79 */ { 0, 0, 0, 0, 0 },
/* U+0c7a */ { 0, 0, 0, 0, 0 },
/* U+0c7b */ { 0, 0, 0, 0, 0 },
/* U+0c7c */ { 0, 0, 0, 0, 0 },
/* U+0c7d */ { 0, 0, 0, 0, 0 },
/* U+0c7e */ { 0, 0, 0, 0, 0 },
/* U+0c7f */ { 0, 0, 0, 0, 0 },
/* U+0c80 */ { 0, 0, 0, 0, 0 },
/* U+0c81 */ { 0, 0, 0, 0, 0 },
/* U+0c82 */ { 5, 0, 1, 0, 0 },
/* U+0c83 */ { 5, 0, 1, 0, 0 },
/* U+0c84 */ { 0, 0, 0, 0, 0 },
/* U+0c85 */ { 19, 0, 1, 0, 0 },
/* U+0c86 */ { 19, 0, 1, 0, 0 },
/* U+0c87 */ { 19, 0, 1, 0, 0 },
/* U+0c88 */ { 19, 0, 1, 0, 0 },
/* U+0c89 */ { 19, 0, 1, 0, 0 },
/* U+0c8a */ { 19, 0, 1, 0, 0 },
/* U+0c8b */ { 19, 0, 1, 0, 0 },
/* U+0c8c */ { 19, 0, 1, 0, 0 },
/* U+0c8d */ { 0, 0, 0, 0, 0 },
/* U+0c8e */ { 19, 0, 1, 0, 0 },
/* U+0c8f */ { 19, 0, 1, 0, 0 },
/* U+0c90 */ { 19, 0, 1, 0, 0 },
/* U+0c91 */ { 0, 0, 0, 0, 0 },
/* U+0c92 */ { 19, 0, 1, 0, 0 },
/* U+0c93 */ { 19, 0, 1, 0, 0 },
/* U+0c94 */ { 19, 0, 1, 0, 0 },
/* U+0c95 */ { 19, 0, 1, 0, 0 },
/* U+0c96 */ { 19, 0, 1, 0, 0 },
/* U+0c97 */ { 19, 0, 1, 0, 0 },
/* U+0c98 */ { 19, 0, 1, 0, 0 },
/* U+0c99 */ { 19, 0, 1, 0, 0 },
/* U+0c9a */ { 19, 0, 1, 0, 0 },
/* U+0c9b */ { 19, 0, 1, 0, 0 },
/* U+0c9c */ { 19, 0, 1, 0, 0 },
/* U+0c9d */ { 19, 0, 1, 0, 0 },
/* U+0c9e */ { 19, 0, 1, 0, 0 },
/* U+0c9f */ { 19, 0, 1, 0, 0 },
/* U+0ca0 */ { 19, 0, 1, 0, 0 },
/* U+0ca1 */ { 19, 0, 1, 0, 0 },
/* U+0ca2 */ { 19, 0, 1, 0, 0 },
/* U+0ca3 */ { 19, 0, 1, 0, 0 },
/* U+0ca4 */ { 19, 0, 1, 0, 0 },
/* U+0ca5 */ { 19, 0, 1, 0, 0 },
/* U+0ca6 */ { 19, 0, 1, 0, 0 },
/* U+0ca7 */ { 19, 0, 1, 0, 0 },
/* U+0ca8 */ { 19, 0, 1, 0, 0 },
/* U+0ca9 */ { 0, 0, 0, 0, 0 },
/* U+0caa */ { 19, 0, 1, 0, 0 },
/* U+0cab */ { 19, 0, 1, 0, 0 },
/* U+0cac */ { 19, 0, 1, 0, 0 },
/* U+0cad */ { 19, 0, 1, 0, 0 },
/* U+0cae */ { 19, 0, 1, 0, 0 },
/* U+0caf */ { 19, 0, 1, 0, 0 },
/* U+0cb0 */ { 19, 0, 1, 0, 0 },
/* U+0cb1 */ { 19, 0, 1, 0, 0 },
/* U+0cb2 */ { 19, 0, 1, 0, 0 },
/* U+0cb3 */ { 19, 0, 1, 0, 0 },
/* U+0cb4 */ { 0, 0, 0, 0, 0 },
/* U+0cb5 */ { 19, 0, 1, 0, 0 },
/* U+0cb6 */ { 19, 0, 1, 0, 0 },
/* U+0cb7 */ { 19, 0, 1, 0, 0 },
/* U+0cb8 */ { 19, 0, 1, 0, 0 },
/* U+0cb9 */ { 19, 0, 1, 0, 0 },
/* U+0cba */ { 0, 0, 0, 0, 0 },
/* U+0cbb */ { 0, 0, 0, 0, 0 },
/* U+0cbc */ { 0, 0, 0, 0, 0 },
/* U+0cbd */ { 0, 0, 0, 0, 0 },
/* U+0cbe */ { 5, 0, 1, 0, 0 },
/* U+0cbf */ { 4, 0, 14, 0, 0 },
/* U+0cc0 */ { 5, 0, 1, 0, "0CBF 0CD5" },
/* U+0cc1 */ { 5, 0, 1, 0, 0 },
/* U+0cc2 */ { 5, 0, 1, 0, 0 },
/* U+0cc3 */ { 5, 0, 1, 0, 0 },
/* U+0cc4 */ { 5, 0, 1, 0, 0 },
/* U+0cc5 */ { 0, 0, 0, 0, 0 },
/* U+0cc6 */ { 4, 0, 14, 0, 0 },
/* U+0cc7 */ { 5, 0, 1, 0, "0CC6 0CD5" },
/* U+0cc8 */ { 5, 0, 1, 0, "0CC6 0CD6" },
/* U+0cc9 */ { 0, 0, 0, 0, 0 },
/* U+0cca */ { 5, 0, 1, 0, "0CC6 0CC2" },
/* U+0ccb */ { 5, 0, 1, 0, "0CCA 0CD5" },
/* U+0ccc */ { 4, 0, 14, 0, 0 },
/* U+0ccd */ { 4, 9, 14, 0, 0 },
/* U+0cce */ { 0, 0, 0, 0, 0 },
/* U+0ccf */ { 0, 0, 0, 0, 0 },
/* U+0cd0 */ { 0, 0, 0, 0, 0 },
/* U+0cd1 */ { 0, 0, 0, 0, 0 },
/* U+0cd2 */ { 0, 0, 0, 0, 0 },
/* U+0cd3 */ { 0, 0, 0, 0, 0 },
/* U+0cd4 */ { 0, 0, 0, 0, 0 },
/* U+0cd5 */ { 5, 0, 1, 0, 0 },
/* U+0cd6 */ { 5, 0, 1, 0, 0 },
/* U+0cd7 */ { 0, 0, 0, 0, 0 },
/* U+0cd8 */ { 0, 0, 0, 0, 0 },
/* U+0cd9 */ { 0, 0, 0, 0, 0 },
/* U+0cda */ { 0, 0, 0, 0, 0 },
/* U+0cdb */ { 0, 0, 0, 0, 0 },
/* U+0cdc */ { 0, 0, 0, 0, 0 },
/* U+0cdd */ { 0, 0, 0, 0, 0 },
/* U+0cde */ { 19, 0, 1, 0, 0 },
/* U+0cdf */ { 0, 0, 0, 0, 0 },
/* U+0ce0 */ { 19, 0, 1, 0, 0 },
/* U+0ce1 */ { 19, 0, 1, 0, 0 },
/* U+0ce2 */ { 0, 0, 0, 0, 0 },
/* U+0ce3 */ { 0, 0, 0, 0, 0 },
/* U+0ce4 */ { 0, 0, 0, 0, 0 },
/* U+0ce5 */ { 0, 0, 0, 0, 0 },
/* U+0ce6 */ { 7, 0, 1, 0, 0 },
/* U+0ce7 */ { 7, 0, 1, 0, 0 },
/* U+0ce8 */ { 7, 0, 1, 0, 0 },
/* U+0ce9 */ { 7, 0, 1, 0, 0 },
/* U+0cea */ { 7, 0, 1, 0, 0 },
/* U+0ceb */ { 7, 0, 1, 0, 0 },
/* U+0cec */ { 7, 0, 1, 0, 0 },
/* U+0ced */ { 7, 0, 1, 0, 0 },
/* U+0cee */ { 7, 0, 1, 0, 0 },
/* U+0cef */ { 7, 0, 1, 0, 0 },
/* U+0cf0 */ { 0, 0, 0, 0, 0 },
/* U+0cf1 */ { 0, 0, 0, 0, 0 },
/* U+0cf2 */ { 0, 0, 0, 0, 0 },
/* U+0cf3 */ { 0, 0, 0, 0, 0 },
/* U+0cf4 */ { 0, 0, 0, 0, 0 },
/* U+0cf5 */ { 0, 0, 0, 0, 0 },
/* U+0cf6 */ { 0, 0, 0, 0, 0 },
/* U+0cf7 */ { 0, 0, 0, 0, 0 },
/* U+0cf8 */ { 0, 0, 0, 0, 0 },
/* U+0cf9 */ { 0, 0, 0, 0, 0 },
/* U+0cfa */ { 0, 0, 0, 0, 0 },
/* U+0cfb */ { 0, 0, 0, 0, 0 },
/* U+0cfc */ { 0, 0, 0, 0, 0 },
/* U+0cfd */ { 0, 0, 0, 0, 0 },
/* U+0cfe */ { 0, 0, 0, 0, 0 },
/* U+0cff */ { 0, 0, 0, 0, 0 },
/* U+0d00 */ { 0, 0, 0, 0, 0 },
/* U+0d01 */ { 0, 0, 0, 0, 0 },
/* U+0d02 */ { 5, 0, 1, 0, 0 },
/* U+0d03 */ { 5, 0, 1, 0, 0 },
/* U+0d04 */ { 0, 0, 0, 0, 0 },
/* U+0d05 */ { 19, 0, 1, 0, 0 },
/* U+0d06 */ { 19, 0, 1, 0, 0 },
/* U+0d07 */ { 19, 0, 1, 0, 0 },
/* U+0d08 */ { 19, 0, 1, 0, 0 },
/* U+0d09 */ { 19, 0, 1, 0, 0 },
/* U+0d0a */ { 19, 0, 1, 0, 0 },
/* U+0d0b */ { 19, 0, 1, 0, 0 },
/* U+0d0c */ { 19, 0, 1, 0, 0 },
/* U+0d0d */ { 0, 0, 0, 0, 0 },
/* U+0d0e */ { 19, 0, 1, 0, 0 },
/* U+0d0f */ { 19, 0, 1, 0, 0 },
/* U+0d10 */ { 19, 0, 1, 0, 0 },
/* U+0d11 */ { 0, 0, 0, 0, 0 },
/* U+0d12 */ { 19, 0, 1, 0, 0 },
/* U+0d13 */ { 19, 0, 1, 0, 0 },
/* U+0d14 */ { 19, 0, 1, 0, 0 },
/* U+0d15 */ { 19, 0, 1, 0, 0 },
/* U+0d16 */ { 19, 0, 1, 0, 0 },
/* U+0d17 */ { 19, 0, 1, 0, 0 },
/* U+0d18 */ { 19, 0, 1, 0, 0 },
/* U+0d19 */ { 19, 0, 1, 0, 0 },
/* U+0d1a */ { 19, 0, 1, 0, 0 },
/* U+0d1b */ { 19, 0, 1, 0, 0 },
/* U+0d1c */ { 19, 0, 1, 0, 0 },
/* U+0d1d */ { 19, 0, 1, 0, 0 },
/* U+0d1e */ { 19, 0, 1, 0, 0 },
/* U+0d1f */ { 19, 0, 1, 0, 0 },
/* U+0d20 */ { 19, 0, 1, 0, 0 },
/* U+0d21 */ { 19, 0, 1, 0, 0 },
/* U+0d22 */ { 19, 0, 1, 0, 0 },
/* U+0d23 */ { 19, 0, 1, 0, 0 },
/* U+0d24 */ { 19, 0, 1, 0, 0 },
/* U+0d25 */ { 19, 0, 1, 0, 0 },
/* U+0d26 */ { 19, 0, 1, 0, 0 },
/* U+0d27 */ { 19, 0, 1, 0, 0 },
/* U+0d28 */ { 19, 0, 1, 0, 0 },
/* U+0d29 */ { 0, 0, 0, 0, 0 },
/* U+0d2a */ { 19, 0, 1, 0, 0 },
/* U+0d2b */ { 19, 0, 1, 0, 0 },
/* U+0d2c */ { 19, 0, 1, 0, 0 },
/* U+0d2d */ { 19, 0, 1, 0, 0 },
/* U+0d2e */ { 19, 0, 1, 0, 0 },
/* U+0d2f */ { 19, 0, 1, 0, 0 },
/* U+0d30 */ { 19, 0, 1, 0, 0 },
/* U+0d31 */ { 19, 0, 1, 0, 0 },
/* U+0d32 */ { 19, 0, 1, 0, 0 },
/* U+0d33 */ { 19, 0, 1, 0, 0 },
/* U+0d34 */ { 19, 0, 1, 0, 0 },
/* U+0d35 */ { 19, 0, 1, 0, 0 },
/* U+0d36 */ { 19, 0, 1, 0, 0 },
/* U+0d37 */ { 19, 0, 1, 0, 0 },
/* U+0d38 */ { 19, 0, 1, 0, 0 },
/* U+0d39 */ { 19, 0, 1, 0, 0 },
/* U+0d3a */ { 0, 0, 0, 0, 0 },
/* U+0d3b */ { 0, 0, 0, 0, 0 },
/* U+0d3c */ { 0, 0, 0, 0, 0 },
/* U+0d3d */ { 0, 0, 0, 0, 0 },
/* U+0d3e */ { 5, 0, 1, 0, 0 },
/* U+0d3f */ { 5, 0, 1, 0, 0 },
/* U+0d40 */ { 5, 0, 1, 0, 0 },
/* U+0d41 */ { 4, 0, 14, 0, 0 },
/* U+0d42 */ { 4, 0, 14, 0, 0 },
/* U+0d43 */ { 4, 0, 14, 0, 0 },
/* U+0d44 */ { 0, 0, 0, 0, 0 },
/* U+0d45 */ { 0, 0, 0, 0, 0 },
/* U+0d46 */ { 5, 0, 1, 0, 0 },
/* U+0d47 */ { 5, 0, 1, 0, 0 },
/* U+0d48 */ { 5, 0, 1, 0, 0 },
/* U+0d49 */ { 0, 0, 0, 0, 0 },
/* U+0d4a */ { 5, 0, 1, 0, "0D46 0D3E" },
/* U+0d4b */ { 5, 0, 1, 0, "0D47 0D3E" },
/* U+0d4c */ { 5, 0, 1, 0, "0D46 0D57" },
/* U+0d4d */ { 4, 9, 14, 0, 0 },
/* U+0d4e */ { 0, 0, 0, 0, 0 },
/* U+0d4f */ { 0, 0, 0, 0, 0 },
/* U+0d50 */ { 0, 0, 0, 0, 0 },
/* U+0d51 */ { 0, 0, 0, 0, 0 },
/* U+0d52 */ { 0, 0, 0, 0, 0 },
/* U+0d53 */ { 0, 0, 0, 0, 0 },
/* U+0d54 */ { 0, 0, 0, 0, 0 },
/* U+0d55 */ { 0, 0, 0, 0, 0 },
/* U+0d56 */ { 0, 0, 0, 0, 0 },
/* U+0d57 */ { 5, 0, 1, 0, 0 },
/* U+0d58 */ { 0, 0, 0, 0, 0 },
/* U+0d59 */ { 0, 0, 0, 0, 0 },
/* U+0d5a */ { 0, 0, 0, 0, 0 },
/* U+0d5b */ { 0, 0, 0, 0, 0 },
/* U+0d5c */ { 0, 0, 0, 0, 0 },
/* U+0d5d */ { 0, 0, 0, 0, 0 },
/* U+0d5e */ { 0, 0, 0, 0, 0 },
/* U+0d5f */ { 0, 0, 0, 0, 0 },
/* U+0d60 */ { 19, 0, 1, 0, 0 },
/* U+0d61 */ { 19, 0, 1, 0, 0 },
/* U+0d62 */ { 0, 0, 0, 0, 0 },
/* U+0d63 */ { 0, 0, 0, 0, 0 },
/* U+0d64 */ { 0, 0, 0, 0, 0 },
/* U+0d65 */ { 0, 0, 0, 0, 0 },
/* U+0d66 */ { 7, 0, 1, 0, 0 },
/* U+0d67 */ { 7, 0, 1, 0, 0 },
/* U+0d68 */ { 7, 0, 1, 0, 0 },
/* U+0d69 */ { 7, 0, 1, 0, 0 },
/* U+0d6a */ { 7, 0, 1, 0, 0 },
/* U+0d6b */ { 7, 0, 1, 0, 0 },
/* U+0d6c */ { 7, 0, 1, 0, 0 },
/* U+0d6d */ { 7, 0, 1, 0, 0 },
/* U+0d6e */ { 7, 0, 1, 0, 0 },
/* U+0d6f */ { 7, 0, 1, 0, 0 },
/* U+0d70 */ { 0, 0, 0, 0, 0 },
/* U+0d71 */ { 0, 0, 0, 0, 0 },
/* U+0d72 */ { 0, 0, 0, 0, 0 },
/* U+0d73 */ { 0, 0, 0, 0, 0 },
/* U+0d74 */ { 0, 0, 0, 0, 0 },
/* U+0d75 */ { 0, 0, 0, 0, 0 },
/* U+0d76 */ { 0, 0, 0, 0, 0 },
/* U+0d77 */ { 0, 0, 0, 0, 0 },
/* U+0d78 */ { 0, 0, 0, 0, 0 },
/* U+0d79 */ { 0, 0, 0, 0, 0 },
/* U+0d7a */ { 0, 0, 0, 0, 0 },
/* U+0d7b */ { 0, 0, 0, 0, 0 },
/* U+0d7c */ { 0, 0, 0, 0, 0 },
/* U+0d7d */ { 0, 0, 0, 0, 0 },
/* U+0d7e */ { 0, 0, 0, 0, 0 },
/* U+0d7f */ { 0, 0, 0, 0, 0 },
/* U+0d80 */ { 0, 0, 0, 0, 0 },
/* U+0d81 */ { 0, 0, 0, 0, 0 },
/* U+0d82 */ { 5, 0, 1, 0, 0 },
/* U+0d83 */ { 5, 0, 1, 0, 0 },
/* U+0d84 */ { 0, 0, 0, 0, 0 },
/* U+0d85 */ { 19, 0, 1, 0, 0 },
/* U+0d86 */ { 19, 0, 1, 0, 0 },
/* U+0d87 */ { 19, 0, 1, 0, 0 },
/* U+0d88 */ { 19, 0, 1, 0, 0 },
/* U+0d89 */ { 19, 0, 1, 0, 0 },
/* U+0d8a */ { 19, 0, 1, 0, 0 },
/* U+0d8b */ { 19, 0, 1, 0, 0 },
/* U+0d8c */ { 19, 0, 1, 0, 0 },
/* U+0d8d */ { 19, 0, 1, 0, 0 },
/* U+0d8e */ { 19, 0, 1, 0, 0 },
/* U+0d8f */ { 19, 0, 1, 0, 0 },
/* U+0d90 */ { 19, 0, 1, 0, 0 },
/* U+0d91 */ { 19, 0, 1, 0, 0 },
/* U+0d92 */ { 19, 0, 1, 0, 0 },
/* U+0d93 */ { 19, 0, 1, 0, 0 },
/* U+0d94 */ { 19, 0, 1, 0, 0 },
/* U+0d95 */ { 19, 0, 1, 0, 0 },
/* U+0d96 */ { 19, 0, 1, 0, 0 },
/* U+0d97 */ { 0, 0, 0, 0, 0 },
/* U+0d98 */ { 0, 0, 0, 0, 0 },
/* U+0d99 */ { 0, 0, 0, 0, 0 },
/* U+0d9a */ { 19, 0, 1, 0, 0 },
/* U+0d9b */ { 19, 0, 1, 0, 0 },
/* U+0d9c */ { 19, 0, 1, 0, 0 },
/* U+0d9d */ { 19, 0, 1, 0, 0 },
/* U+0d9e */ { 19, 0, 1, 0, 0 },
/* U+0d9f */ { 19, 0, 1, 0, 0 },
/* U+0da0 */ { 19, 0, 1, 0, 0 },
/* U+0da1 */ { 19, 0, 1, 0, 0 },
/* U+0da2 */ { 19, 0, 1, 0, 0 },
/* U+0da3 */ { 19, 0, 1, 0, 0 },
/* U+0da4 */ { 19, 0, 1, 0, 0 },
/* U+0da5 */ { 19, 0, 1, 0, 0 },
/* U+0da6 */ { 19, 0, 1, 0, 0 },
/* U+0da7 */ { 19, 0, 1, 0, 0 },
/* U+0da8 */ { 19, 0, 1, 0, 0 },
/* U+0da9 */ { 19, 0, 1, 0, 0 },
/* U+0daa */ { 19, 0, 1, 0, 0 },
/* U+0dab */ { 19, 0, 1, 0, 0 },
/* U+0dac */ { 19, 0, 1, 0, 0 },
/* U+0dad */ { 19, 0, 1, 0, 0 },
/* U+0dae */ { 19, 0, 1, 0, 0 },
/* U+0daf */ { 19, 0, 1, 0, 0 },
/* U+0db0 */ { 19, 0, 1, 0, 0 },
/* U+0db1 */ { 19, 0, 1, 0, 0 },
/* U+0db2 */ { 0, 0, 0, 0, 0 },
/* U+0db3 */ { 19, 0, 1, 0, 0 },
/* U+0db4 */ { 19, 0, 1, 0, 0 },
/* U+0db5 */ { 19, 0, 1, 0, 0 },
/* U+0db6 */ { 19, 0, 1, 0, 0 },
/* U+0db7 */ { 19, 0, 1, 0, 0 },
/* U+0db8 */ { 19, 0, 1, 0, 0 },
/* U+0db9 */ { 19, 0, 1, 0, 0 },
/* U+0dba */ { 19, 0, 1, 0, 0 },
/* U+0dbb */ { 19, 0, 1, 0, 0 },
/* U+0dbc */ { 0, 0, 0, 0, 0 },
/* U+0dbd */ { 19, 0, 1, 0, 0 },
/* U+0dbe */ { 0, 0, 0, 0, 0 },
/* U+0dbf */ { 0, 0, 0, 0, 0 },
/* U+0dc0 */ { 19, 0, 1, 0, 0 },
/* U+0dc1 */ { 19, 0, 1, 0, 0 },
/* U+0dc2 */ { 19, 0, 1, 0, 0 },
/* U+0dc3 */ { 19, 0, 1, 0, 0 },
/* U+0dc4 */ { 19, 0, 1, 0, 0 },
/* U+0dc5 */ { 19, 0, 1, 0, 0 },
/* U+0dc6 */ { 19, 0, 1, 0, 0 },
/* U+0dc7 */ { 0, 0, 0, 0, 0 },
/* U+0dc8 */ { 0, 0, 0, 0, 0 },
/* U+0dc9 */ { 0, 0, 0, 0, 0 },
/* U+0dca */ { 4, 9, 14, 0, 0 },
/* U+0dcb */ { 0, 0, 0, 0, 0 },
/* U+0dcc */ { 0, 0, 0, 0, 0 },
/* U+0dcd */ { 0, 0, 0, 0, 0 },
/* U+0dce */ { 0, 0, 0, 0, 0 },
/* U+0dcf */ { 5, 0, 1, 0, 0 },
/* U+0dd0 */ { 5, 0, 1, 0, 0 },
/* U+0dd1 */ { 5, 0, 1, 0, 0 },
/* U+0dd2 */ { 4, 0, 14, 0, 0 },
/* U+0dd3 */ { 4, 0, 14, 0, 0 },
/* U+0dd4 */ { 4, 0, 14, 0, 0 },
/* U+0dd5 */ { 0, 0, 0, 0, 0 },
/* U+0dd6 */ { 4, 0, 14, 0, 0 },
/* U+0dd7 */ { 0, 0, 0, 0, 0 },
/* U+0dd8 */ { 5, 0, 1, 0, 0 },
/* U+0dd9 */ { 5, 0, 1, 0, 0 },
/* U+0dda */ { 5, 0, 1, 0, "0DD9 0DCA" },
/* U+0ddb */ { 5, 0, 1, 0, 0 },
/* U+0ddc */ { 5, 0, 1, 0, "0DD9 0DCF" },
/* U+0ddd */ { 5, 0, 1, 0, "0DDC 0DCA" },
/* U+0dde */ { 5, 0, 1, 0, "0DD9 0DDF" },
/* U+0ddf */ { 5, 0, 1, 0, 0 },
/* U+0de0 */ { 0, 0, 0, 0, 0 },
/* U+0de1 */ { 0, 0, 0, 0, 0 },
/* U+0de2 */ { 0, 0, 0, 0, 0 },
/* U+0de3 */ { 0, 0, 0, 0, 0 },
/* U+0de4 */ { 0, 0, 0, 0, 0 },
/* U+0de5 */ { 0, 0, 0, 0, 0 },
/* U+0de6 */ { 0, 0, 0, 0, 0 },
/* U+0de7 */ { 0, 0, 0, 0, 0 },
/* U+0de8 */ { 0, 0, 0, 0, 0 },
/* U+0de9 */ { 0, 0, 0, 0, 0 },
/* U+0dea */ { 0, 0, 0, 0, 0 },
/* U+0deb */ { 0, 0, 0, 0, 0 },
/* U+0dec */ { 0, 0, 0, 0, 0 },
/* U+0ded */ { 0, 0, 0, 0, 0 },
/* U+0dee */ { 0, 0, 0, 0, 0 },
/* U+0def */ { 0, 0, 0, 0, 0 },
/* U+0df0 */ { 0, 0, 0, 0, 0 },
/* U+0df1 */ { 0, 0, 0, 0, 0 },
/* U+0df2 */ { 5, 0, 1, 0, 0 },
/* U+0df3 */ { 5, 0, 1, 0, 0 },
/* U+0df4 */ { 26, 0, 1, 0, 0 },
/* U+0df5 */ { 0, 0, 0, 0, 0 },
/* U+0df6 */ { 0, 0, 0, 0, 0 },
/* U+0df7 */ { 0, 0, 0, 0, 0 },
/* U+0df8 */ { 0, 0, 0, 0, 0 },
/* U+0df9 */ { 0, 0, 0, 0, 0 },
/* U+0dfa */ { 0, 0, 0, 0, 0 },
/* U+0dfb */ { 0, 0, 0, 0, 0 },
/* U+0dfc */ { 0, 0, 0, 0, 0 },
/* U+0dfd */ { 0, 0, 0, 0, 0 },
/* U+0dfe */ { 0, 0, 0, 0, 0 },
/* U+0dff */ { 0, 0, 0, 0, 0 },
/* U+0e00 */ { 0, 0, 0, 0, 0 },
/* U+0e01 */ { 19, 0, 1, 0, 0 },
/* U+0e02 */ { 19, 0, 1, 0, 0 },
/* U+0e03 */ { 19, 0, 1, 0, 0 },
/* U+0e04 */ { 19, 0, 1, 0, 0 },
/* U+0e05 */ { 19, 0, 1, 0, 0 },
/* U+0e06 */ { 19, 0, 1, 0, 0 },
/* U+0e07 */ { 19, 0, 1, 0, 0 },
/* U+0e08 */ { 19, 0, 1, 0, 0 },
/* U+0e09 */ { 19, 0, 1, 0, 0 },
/* U+0e0a */ { 19, 0, 1, 0, 0 },
/* U+0e0b */ { 19, 0, 1, 0, 0 },
/* U+0e0c */ { 19, 0, 1, 0, 0 },
/* U+0e0d */ { 19, 0, 1, 0, 0 },
/* U+0e0e */ { 19, 0, 1, 0, 0 },
/* U+0e0f */ { 19, 0, 1, 0, 0 },
/* U+0e10 */ { 19, 0, 1, 0, 0 },
/* U+0e11 */ { 19, 0, 1, 0, 0 },
/* U+0e12 */ { 19, 0, 1, 0, 0 },
/* U+0e13 */ { 19, 0, 1, 0, 0 },
/* U+0e14 */ { 19, 0, 1, 0, 0 },
/* U+0e15 */ { 19, 0, 1, 0, 0 },
/* U+0e16 */ { 19, 0, 1, 0, 0 },
/* U+0e17 */ { 19, 0, 1, 0, 0 },
/* U+0e18 */ { 19, 0, 1, 0, 0 },
/* U+0e19 */ { 19, 0, 1, 0, 0 },
/* U+0e1a */ { 19, 0, 1, 0, 0 },
/* U+0e1b */ { 19, 0, 1, 0, 0 },
/* U+0e1c */ { 19, 0, 1, 0, 0 },
/* U+0e1d */ { 19, 0, 1, 0, 0 },
/* U+0e1e */ { 19, 0, 1, 0, 0 },
/* U+0e1f */ { 19, 0, 1, 0, 0 },
/* U+0e20 */ { 19, 0, 1, 0, 0 },
/* U+0e21 */ { 19, 0, 1, 0, 0 },
/* U+0e22 */ { 19, 0, 1, 0, 0 },
/* U+0e23 */ { 19, 0, 1, 0, 0 },
/* U+0e24 */ { 19, 0, 1, 0, 0 },
/* U+0e25 */ { 19, 0, 1, 0, 0 },
/* U+0e26 */ { 19, 0, 1, 0, 0 },
/* U+0e27 */ { 19, 0, 1, 0, 0 },
/* U+0e28 */ { 19, 0, 1, 0, 0 },
/* U+0e29 */ { 19, 0, 1, 0, 0 },
/* U+0e2a */ { 19, 0, 1, 0, 0 },
/* U+0e2b */ { 19, 0, 1, 0, 0 },
/* U+0e2c */ { 19, 0, 1, 0, 0 },
/* U+0e2d */ { 19, 0, 1, 0, 0 },
/* U+0e2e */ { 19, 0, 1, 0, 0 },
/* U+0e2f */ { 19, 0, 1, 0, 0 },
/* U+0e30 */ { 19, 0, 1, 0, 0 },
/* U+0e31 */ { 4, 0, 14, 0, 0 },
/* U+0e32 */ { 19, 0, 1, 0, 0 },
/* U+0e33 */ { 19, 0, 1, 0, "<compat> 0E4D 0E32" },
/* U+0e34 */ { 4, 0, 14, 0, 0 },
/* U+0e35 */ { 4, 0, 14, 0, 0 },
/* U+0e36 */ { 4, 0, 14, 0, 0 },
/* U+0e37 */ { 4, 0, 14, 0, 0 },
/* U+0e38 */ { 4, 103, 14, 0, 0 },
/* U+0e39 */ { 4, 103, 14, 0, 0 },
/* U+0e3a */ { 4, 9, 14, 0, 0 },
/* U+0e3b */ { 0, 0, 0, 0, 0 },
/* U+0e3c */ { 0, 0, 0, 0, 0 },
/* U+0e3d */ { 0, 0, 0, 0, 0 },
/* U+0e3e */ { 0, 0, 0, 0, 0 },
/* U+0e3f */ { 28, 0, 11, 0, 0 },
/* U+0e40 */ { 19, 0, 1, 0, 0 },
/* U+0e41 */ { 19, 0, 1, 0, 0 },
/* U+0e42 */ { 19, 0, 1, 0, 0 },
/* U+0e43 */ { 19, 0, 1, 0, 0 },
/* U+0e44 */ { 19, 0, 1, 0, 0 },
/* U+0e45 */ { 19, 0, 1, 0, 0 },
/* U+0e46 */ { 18, 0, 1, 0, 0 },
/* U+0e47 */ { 4, 0, 14, 0, 0 },
/* U+0e48 */ { 4, 107, 14, 0, 0 },
/* U+0e49 */ { 4, 107, 14, 0, 0 },
/* U+0e4a */ { 4, 107, 14, 0, 0 },
/* U+0e4b */ { 4, 107, 14, 0, 0 },
/* U+0e4c */ { 4, 0, 14, 0, 0 },
/* U+0e4d */ { 4, 0, 14, 0, 0 },
/* U+0e4e */ { 4, 0, 14, 0, 0 },
/* U+0e4f */ { 26, 0, 1, 0, 0 },
/* U+0e50 */ { 7, 0, 1, 0, 0 },
/* U+0e51 */ { 7, 0, 1, 0, 0 },
/* U+0e52 */ { 7, 0, 1, 0, 0 },
/* U+0e53 */ { 7, 0, 1, 0, 0 },
/* U+0e54 */ { 7, 0, 1, 0, 0 },
/* U+0e55 */ { 7, 0, 1, 0, 0 },
/* U+0e56 */ { 7, 0, 1, 0, 0 },
/* U+0e57 */ { 7, 0, 1, 0, 0 },
/* U+0e58 */ { 7, 0, 1, 0, 0 },
/* U+0e59 */ { 7, 0, 1, 0, 0 },
/* U+0e5a */ { 26, 0, 1, 0, 0 },
/* U+0e5b */ { 26, 0, 1, 0, 0 },
/* U+0e5c */ { 0, 0, 0, 0, 0 },
/* U+0e5d */ { 0, 0, 0, 0, 0 },
/* U+0e5e */ { 0, 0, 0, 0, 0 },
/* U+0e5f */ { 0, 0, 0, 0, 0 },
/* U+0e60 */ { 0, 0, 0, 0, 0 },
/* U+0e61 */ { 0, 0, 0, 0, 0 },
/* U+0e62 */ { 0, 0, 0, 0, 0 },
/* U+0e63 */ { 0, 0, 0, 0, 0 },
/* U+0e64 */ { 0, 0, 0, 0, 0 },
/* U+0e65 */ { 0, 0, 0, 0, 0 },
/* U+0e66 */ { 0, 0, 0, 0, 0 },
/* U+0e67 */ { 0, 0, 0, 0, 0 },
/* U+0e68 */ { 0, 0, 0, 0, 0 },
/* U+0e69 */ { 0, 0, 0, 0, 0 },
/* U+0e6a */ { 0, 0, 0, 0, 0 },
/* U+0e6b */ { 0, 0, 0, 0, 0 },
/* U+0e6c */ { 0, 0, 0, 0, 0 },
/* U+0e6d */ { 0, 0, 0, 0, 0 },
/* U+0e6e */ { 0, 0, 0, 0, 0 },
/* U+0e6f */ { 0, 0, 0, 0, 0 },
/* U+0e70 */ { 0, 0, 0, 0, 0 },
/* U+0e71 */ { 0, 0, 0, 0, 0 },
/* U+0e72 */ { 0, 0, 0, 0, 0 },
/* U+0e73 */ { 0, 0, 0, 0, 0 },
/* U+0e74 */ { 0, 0, 0, 0, 0 },
/* U+0e75 */ { 0, 0, 0, 0, 0 },
/* U+0e76 */ { 0, 0, 0, 0, 0 },
/* U+0e77 */ { 0, 0, 0, 0, 0 },
/* U+0e78 */ { 0, 0, 0, 0, 0 },
/* U+0e79 */ { 0, 0, 0, 0, 0 },
/* U+0e7a */ { 0, 0, 0, 0, 0 },
/* U+0e7b */ { 0, 0, 0, 0, 0 },
/* U+0e7c */ { 0, 0, 0, 0, 0 },
/* U+0e7d */ { 0, 0, 0, 0, 0 },
/* U+0e7e */ { 0, 0, 0, 0, 0 },
/* U+0e7f */ { 0, 0, 0, 0, 0 },
/* U+0e80 */ { 0, 0, 0, 0, 0 },
/* U+0e81 */ { 19, 0, 1, 0, 0 },
/* U+0e82 */ { 19, 0, 1, 0, 0 },
/* U+0e83 */ { 0, 0, 0, 0, 0 },
/* U+0e84 */ { 19, 0, 1, 0, 0 },
/* U+0e85 */ { 0, 0, 0, 0, 0 },
/* U+0e86 */ { 0, 0, 0, 0, 0 },
/* U+0e87 */ { 19, 0, 1, 0, 0 },
/* U+0e88 */ { 19, 0, 1, 0, 0 },
/* U+0e89 */ { 0, 0, 0, 0, 0 },
/* U+0e8a */ { 19, 0, 1, 0, 0 },
/* U+0e8b */ { 0, 0, 0, 0, 0 },
/* U+0e8c */ { 0, 0, 0, 0, 0 },
/* U+0e8d */ { 19, 0, 1, 0, 0 },
/* U+0e8e */ { 0, 0, 0, 0, 0 },
/* U+0e8f */ { 0, 0, 0, 0, 0 },
/* U+0e90 */ { 0, 0, 0, 0, 0 },
/* U+0e91 */ { 0, 0, 0, 0, 0 },
/* U+0e92 */ { 0, 0, 0, 0, 0 },
/* U+0e93 */ { 0, 0, 0, 0, 0 },
/* U+0e94 */ { 19, 0, 1, 0, 0 },
/* U+0e95 */ { 19, 0, 1, 0, 0 },
/* U+0e96 */ { 19, 0, 1, 0, 0 },
/* U+0e97 */ { 19, 0, 1, 0, 0 },
/* U+0e98 */ { 0, 0, 0, 0, 0 },
/* U+0e99 */ { 19, 0, 1, 0, 0 },
/* U+0e9a */ { 19, 0, 1, 0, 0 },
/* U+0e9b */ { 19, 0, 1, 0, 0 },
/* U+0e9c */ { 19, 0, 1, 0, 0 },
/* U+0e9d */ { 19, 0, 1, 0, 0 },
/* U+0e9e */ { 19, 0, 1, 0, 0 },
/* U+0e9f */ { 19, 0, 1, 0, 0 },
/* U+0ea0 */ { 0, 0, 0, 0, 0 },
/* U+0ea1 */ { 19, 0, 1, 0, 0 },
/* U+0ea2 */ { 19, 0, 1, 0, 0 },
/* U+0ea3 */ { 19, 0, 1, 0, 0 },
/* U+0ea4 */ { 0, 0, 0, 0, 0 },
/* U+0ea5 */ { 19, 0, 1, 0, 0 },
/* U+0ea6 */ { 0, 0, 0, 0, 0 },
/* U+0ea7 */ { 19, 0, 1, 0, 0 },
/* U+0ea8 */ { 0, 0, 0, 0, 0 },
/* U+0ea9 */ { 0, 0, 0, 0, 0 },
/* U+0eaa */ { 19, 0, 1, 0, 0 },
/* U+0eab */ { 19, 0, 1, 0, 0 },
/* U+0eac */ { 0, 0, 0, 0, 0 },
/* U+0ead */ { 19, 0, 1, 0, 0 },
/* U+0eae */ { 19, 0, 1, 0, 0 },
/* U+0eaf */ { 19, 0, 1, 0, 0 },
/* U+0eb0 */ { 19, 0, 1, 0, 0 },
/* U+0eb1 */ { 4, 0, 14, 0, 0 },
/* U+0eb2 */ { 19, 0, 1, 0, 0 },
/* U+0eb3 */ { 19, 0, 1, 0, "<compat> 0ECD 0EB2" },
/* U+0eb4 */ { 4, 0, 14, 0, 0 },
/* U+0eb5 */ { 4, 0, 14, 0, 0 },
/* U+0eb6 */ { 4, 0, 14, 0, 0 },
/* U+0eb7 */ { 4, 0, 14, 0, 0 },
/* U+0eb8 */ { 4, 118, 14, 0, 0 },
/* U+0eb9 */ { 4, 118, 14, 0, 0 },
/* U+0eba */ { 0, 0, 0, 0, 0 },
/* U+0ebb */ { 4, 0, 14, 0, 0 },
/* U+0ebc */ { 4, 0, 14, 0, 0 },
/* U+0ebd */ { 19, 0, 1, 0, 0 },
/* U+0ebe */ { 0, 0, 0, 0, 0 },
/* U+0ebf */ { 0, 0, 0, 0, 0 },
/* U+0ec0 */ { 19, 0, 1, 0, 0 },
/* U+0ec1 */ { 19, 0, 1, 0, 0 },
/* U+0ec2 */ { 19, 0, 1, 0, 0 },
/* U+0ec3 */ { 19, 0, 1, 0, 0 },
/* U+0ec4 */ { 19, 0, 1, 0, 0 },
/* U+0ec5 */ { 0, 0, 0, 0, 0 },
/* U+0ec6 */ { 18, 0, 1, 0, 0 },
/* U+0ec7 */ { 0, 0, 0, 0, 0 },
/* U+0ec8 */ { 4, 122, 14, 0, 0 },
/* U+0ec9 */ { 4, 122, 14, 0, 0 },
/* U+0eca */ { 4, 122, 14, 0, 0 },
/* U+0ecb */ { 4, 122, 14, 0, 0 },
/* U+0ecc */ { 4, 0, 14, 0, 0 },
/* U+0ecd */ { 4, 0, 14, 0, 0 },
/* U+0ece */ { 0, 0, 0, 0, 0 },
/* U+0ecf */ { 0, 0, 0, 0, 0 },
/* U+0ed0 */ { 7, 0, 1, 0, 0 },
/* U+0ed1 */ { 7, 0, 1, 0, 0 },
/* U+0ed2 */ { 7, 0, 1, 0, 0 },
/* U+0ed3 */ { 7, 0, 1, 0, 0 },
/* U+0ed4 */ { 7, 0, 1, 0, 0 },
/* U+0ed5 */ { 7, 0, 1, 0, 0 },
/* U+0ed6 */ { 7, 0, 1, 0, 0 },
/* U+0ed7 */ { 7, 0, 1, 0, 0 },
/* U+0ed8 */ { 7, 0, 1, 0, 0 },
/* U+0ed9 */ { 7, 0, 1, 0, 0 },
/* U+0eda */ { 0, 0, 0, 0, 0 },
/* U+0edb */ { 0, 0, 0, 0, 0 },
/* U+0edc */ { 19, 0, 1, 0, "<compat> 0EAB 0E99" },
/* U+0edd */ { 19, 0, 1, 0, "<compat> 0EAB 0EA1" },
/* U+0ede */ { 0, 0, 0, 0, 0 },
/* U+0edf */ { 0, 0, 0, 0, 0 },
/* U+0ee0 */ { 0, 0, 0, 0, 0 },
/* U+0ee1 */ { 0, 0, 0, 0, 0 },
/* U+0ee2 */ { 0, 0, 0, 0, 0 },
/* U+0ee3 */ { 0, 0, 0, 0, 0 },
/* U+0ee4 */ { 0, 0, 0, 0, 0 },
/* U+0ee5 */ { 0, 0, 0, 0, 0 },
/* U+0ee6 */ { 0, 0, 0, 0, 0 },
/* U+0ee7 */ { 0, 0, 0, 0, 0 },
/* U+0ee8 */ { 0, 0, 0, 0, 0 },
/* U+0ee9 */ { 0, 0, 0, 0, 0 },
/* U+0eea */ { 0, 0, 0, 0, 0 },
/* U+0eeb */ { 0, 0, 0, 0, 0 },
/* U+0eec */ { 0, 0, 0, 0, 0 },
/* U+0eed */ { 0, 0, 0, 0, 0 },
/* U+0eee */ { 0, 0, 0, 0, 0 },
/* U+0eef */ { 0, 0, 0, 0, 0 },
/* U+0ef0 */ { 0, 0, 0, 0, 0 },
/* U+0ef1 */ { 0, 0, 0, 0, 0 },
/* U+0ef2 */ { 0, 0, 0, 0, 0 },
/* U+0ef3 */ { 0, 0, 0, 0, 0 },
/* U+0ef4 */ { 0, 0, 0, 0, 0 },
/* U+0ef5 */ { 0, 0, 0, 0, 0 },
/* U+0ef6 */ { 0, 0, 0, 0, 0 },
/* U+0ef7 */ { 0, 0, 0, 0, 0 },
/* U+0ef8 */ { 0, 0, 0, 0, 0 },
/* U+0ef9 */ { 0, 0, 0, 0, 0 },
/* U+0efa */ { 0, 0, 0, 0, 0 },
/* U+0efb */ { 0, 0, 0, 0, 0 },
/* U+0efc */ { 0, 0, 0, 0, 0 },
/* U+0efd */ { 0, 0, 0, 0, 0 },
/* U+0efe */ { 0, 0, 0, 0, 0 },
/* U+0eff */ { 0, 0, 0, 0, 0 },
/* U+0f00 */ { 19, 0, 1, 0, 0 },
/* U+0f01 */ { 30, 0, 1, 0, 0 },
/* U+0f02 */ { 30, 0, 1, 0, 0 },
/* U+0f03 */ { 30, 0, 1, 0, 0 },
/* U+0f04 */ { 26, 0, 1, 0, 0 },
/* U+0f05 */ { 26, 0, 1, 0, 0 },
/* U+0f06 */ { 26, 0, 1, 0, 0 },
/* U+0f07 */ { 26, 0, 1, 0, 0 },
/* U+0f08 */ { 26, 0, 1, 0, 0 },
/* U+0f09 */ { 26, 0, 1, 0, 0 },
/* U+0f0a */ { 26, 0, 1, 0, 0 },
/* U+0f0b */ { 26, 0, 1, 0, 0 },
/* U+0f0c */ { 26, 0, 1, 0, "<noBreak> 0F0B" },
/* U+0f0d */ { 26, 0, 1, 0, 0 },
/* U+0f0e */ { 26, 0, 1, 0, 0 },
/* U+0f0f */ { 26, 0, 1, 0, 0 },
/* U+0f10 */ { 26, 0, 1, 0, 0 },
/* U+0f11 */ { 26, 0, 1, 0, 0 },
/* U+0f12 */ { 26, 0, 1, 0, 0 },
/* U+0f13 */ { 30, 0, 1, 0, 0 },
/* U+0f14 */ { 30, 0, 1, 0, 0 },
/* U+0f15 */ { 30, 0, 1, 0, 0 },
/* U+0f16 */ { 30, 0, 1, 0, 0 },
/* U+0f17 */ { 30, 0, 1, 0, 0 },
/* U+0f18 */ { 4, 220, 14, 0, 0 },
/* U+0f19 */ { 4, 220, 14, 0, 0 },
/* U+0f1a */ { 30, 0, 1, 0, 0 },
/* U+0f1b */ { 30, 0, 1, 0, 0 },
/* U+0f1c */ { 30, 0, 1, 0, 0 },
/* U+0f1d */ { 30, 0, 1, 0, 0 },
/* U+0f1e */ { 30, 0, 1, 0, 0 },
/* U+0f1f */ { 30, 0, 1, 0, 0 },
/* U+0f20 */ { 7, 0, 1, 0, 0 },
/* U+0f21 */ { 7, 0, 1, 0, 0 },
/* U+0f22 */ { 7, 0, 1, 0, 0 },
/* U+0f23 */ { 7, 0, 1, 0, 0 },
/* U+0f24 */ { 7, 0, 1, 0, 0 },
/* U+0f25 */ { 7, 0, 1, 0, 0 },
/* U+0f26 */ { 7, 0, 1, 0, 0 },
/* U+0f27 */ { 7, 0, 1, 0, 0 },
/* U+0f28 */ { 7, 0, 1, 0, 0 },
/* U+0f29 */ { 7, 0, 1, 0, 0 },
/* U+0f2a */ { 9, 0, 1, 0, 0 },
/* U+0f2b */ { 9, 0, 1, 0, 0 },
/* U+0f2c */ { 9, 0, 1, 0, 0 },
/* U+0f2d */ { 9, 0, 1, 0, 0 },
/* U+0f2e */ { 9, 0, 1, 0, 0 },
/* U+0f2f */ { 9, 0, 1, 0, 0 },
/* U+0f30 */ { 9, 0, 1, 0, 0 },
/* U+0f31 */ { 9, 0, 1, 0, 0 },
/* U+0f32 */ { 9, 0, 1, 0, 0 },
/* U+0f33 */ { 9, 0, 1, 0, 0 },
/* U+0f34 */ { 30, 0, 1, 0, 0 },
/* U+0f35 */ { 4, 220, 14, 0, 0 },
/* U+0f36 */ { 30, 0, 1, 0, 0 },
/* U+0f37 */ { 4, 220, 14, 0, 0 },
/* U+0f38 */ { 30, 0, 1, 0, 0 },
/* U+0f39 */ { 4, 216, 14, 0, 0 },
/* U+0f3a */ { 22, 0, 19, 0, 0 },
/* U+0f3b */ { 23, 0, 19, 0, 0 },
/* U+0f3c */ { 22, 0, 19, 0, 0 },
/* U+0f3d */ { 23, 0, 19, 0, 0 },
/* U+0f3e */ { 5, 0, 1, 0, 0 },
/* U+0f3f */ { 5, 0, 1, 0, 0 },
/* U+0f40 */ { 19, 0, 1, 0, 0 },
/* U+0f41 */ { 19, 0, 1, 0, 0 },
/* U+0f42 */ { 19, 0, 1, 0, 0 },
/* U+0f43 */ { 19, 0, 1, 0, "0F42 0FB7" },
/* U+0f44 */ { 19, 0, 1, 0, 0 },
/* U+0f45 */ { 19, 0, 1, 0, 0 },
/* U+0f46 */ { 19, 0, 1, 0, 0 },
/* U+0f47 */ { 19, 0, 1, 0, 0 },
/* U+0f48 */ { 0, 0, 0, 0, 0 },
/* U+0f49 */ { 19, 0, 1, 0, 0 },
/* U+0f4a */ { 19, 0, 1, 0, 0 },
/* U+0f4b */ { 19, 0, 1, 0, 0 },
/* U+0f4c */ { 19, 0, 1, 0, 0 },
/* U+0f4d */ { 19, 0, 1, 0, "0F4C 0FB7" },
/* U+0f4e */ { 19, 0, 1, 0, 0 },
/* U+0f4f */ { 19, 0, 1, 0, 0 },
/* U+0f50 */ { 19, 0, 1, 0, 0 },
/* U+0f51 */ { 19, 0, 1, 0, 0 },
/* U+0f52 */ { 19, 0, 1, 0, "0F51 0FB7" },
/* U+0f53 */ { 19, 0, 1, 0, 0 },
/* U+0f54 */ { 19, 0, 1, 0, 0 },
/* U+0f55 */ { 19, 0, 1, 0, 0 },
/* U+0f56 */ { 19, 0, 1, 0, 0 },
/* U+0f57 */ { 19, 0, 1, 0, "0F56 0FB7" },
/* U+0f58 */ { 19, 0, 1, 0, 0 },
/* U+0f59 */ { 19, 0, 1, 0, 0 },
/* U+0f5a */ { 19, 0, 1, 0, 0 },
/* U+0f5b */ { 19, 0, 1, 0, 0 },
/* U+0f5c */ { 19, 0, 1, 0, "0F5B 0FB7" },
/* U+0f5d */ { 19, 0, 1, 0, 0 },
/* U+0f5e */ { 19, 0, 1, 0, 0 },
/* U+0f5f */ { 19, 0, 1, 0, 0 },
/* U+0f60 */ { 19, 0, 1, 0, 0 },
/* U+0f61 */ { 19, 0, 1, 0, 0 },
/* U+0f62 */ { 19, 0, 1, 0, 0 },
/* U+0f63 */ { 19, 0, 1, 0, 0 },
/* U+0f64 */ { 19, 0, 1, 0, 0 },
/* U+0f65 */ { 19, 0, 1, 0, 0 },
/* U+0f66 */ { 19, 0, 1, 0, 0 },
/* U+0f67 */ { 19, 0, 1, 0, 0 },
/* U+0f68 */ { 19, 0, 1, 0, 0 },
/* U+0f69 */ { 19, 0, 1, 0, "0F40 0FB5" },
/* U+0f6a */ { 19, 0, 1, 0, 0 },
/* U+0f6b */ { 0, 0, 0, 0, 0 },
/* U+0f6c */ { 0, 0, 0, 0, 0 },
/* U+0f6d */ { 0, 0, 0, 0, 0 },
/* U+0f6e */ { 0, 0, 0, 0, 0 },
/* U+0f6f */ { 0, 0, 0, 0, 0 },
/* U+0f70 */ { 0, 0, 0, 0, 0 },
/* U+0f71 */ { 4, 129, 14, 0, 0 },
/* U+0f72 */ { 4, 130, 14, 0, 0 },
/* U+0f73 */ { 4, 0, 14, 0, "0F71 0F72" },
/* U+0f74 */ { 4, 132, 14, 0, 0 },
/* U+0f75 */ { 4, 0, 14, 0, "0F71 0F74" },
/* U+0f76 */ { 4, 0, 14, 0, "0FB2 0F80" },
/* U+0f77 */ { 4, 0, 14, 0, "<compat> 0FB2 0F81" },
/* U+0f78 */ { 4, 0, 14, 0, "0FB3 0F80" },
/* U+0f79 */ { 4, 0, 14, 0, "<compat> 0FB3 0F81" },
/* U+0f7a */ { 4, 130, 14, 0, 0 },
/* U+0f7b */ { 4, 130, 14, 0, 0 },
/* U+0f7c */ { 4, 130, 14, 0, 0 },
/* U+0f7d */ { 4, 130, 14, 0, 0 },
/* U+0f7e */ { 4, 0, 14, 0, 0 },
/* U+0f7f */ { 5, 0, 1, 0, 0 },
/* U+0f80 */ { 4, 130, 14, 0, 0 },
/* U+0f81 */ { 4, 0, 14, 0, "0F71 0F80" },
/* U+0f82 */ { 4, 230, 14, 0, 0 },
/* U+0f83 */ { 4, 230, 14, 0, 0 },
/* U+0f84 */ { 4, 9, 14, 0, 0 },
/* U+0f85 */ { 26, 0, 1, 0, 0 },
/* U+0f86 */ { 4, 230, 14, 0, 0 },
/* U+0f87 */ { 4, 230, 14, 0, 0 },
/* U+0f88 */ { 19, 0, 1, 0, 0 },
/* U+0f89 */ { 19, 0, 1, 0, 0 },
/* U+0f8a */ { 19, 0, 1, 0, 0 },
/* U+0f8b */ { 19, 0, 1, 0, 0 },
/* U+0f8c */ { 0, 0, 0, 0, 0 },
/* U+0f8d */ { 0, 0, 0, 0, 0 },
/* U+0f8e */ { 0, 0, 0, 0, 0 },
/* U+0f8f */ { 0, 0, 0, 0, 0 },
/* U+0f90 */ { 4, 0, 14, 0, 0 },
/* U+0f91 */ { 4, 0, 14, 0, 0 },
/* U+0f92 */ { 4, 0, 14, 0, 0 },
/* U+0f93 */ { 4, 0, 14, 0, "0F92 0FB7" },
/* U+0f94 */ { 4, 0, 14, 0, 0 },
/* U+0f95 */ { 4, 0, 14, 0, 0 },
/* U+0f96 */ { 4, 0, 14, 0, 0 },
/* U+0f97 */ { 4, 0, 14, 0, 0 },
/* U+0f98 */ { 0, 0, 0, 0, 0 },
/* U+0f99 */ { 4, 0, 14, 0, 0 },
/* U+0f9a */ { 4, 0, 14, 0, 0 },
/* U+0f9b */ { 4, 0, 14, 0, 0 },
/* U+0f9c */ { 4, 0, 14, 0, 0 },
/* U+0f9d */ { 4, 0, 14, 0, "0F9C 0FB7" },
/* U+0f9e */ { 4, 0, 14, 0, 0 },
/* U+0f9f */ { 4, 0, 14, 0, 0 },
/* U+0fa0 */ { 4, 0, 14, 0, 0 },
/* U+0fa1 */ { 4, 0, 14, 0, 0 },
/* U+0fa2 */ { 4, 0, 14, 0, "0FA1 0FB7" },
/* U+0fa3 */ { 4, 0, 14, 0, 0 },
/* U+0fa4 */ { 4, 0, 14, 0, 0 },
/* U+0fa5 */ { 4, 0, 14, 0, 0 },
/* U+0fa6 */ { 4, 0, 14, 0, 0 },
/* U+0fa7 */ { 4, 0, 14, 0, "0FA6 0FB7" },
/* U+0fa8 */ { 4, 0, 14, 0, 0 },
/* U+0fa9 */ { 4, 0, 14, 0, 0 },
/* U+0faa */ { 4, 0, 14, 0, 0 },
/* U+0fab */ { 4, 0, 14, 0, 0 },
/* U+0fac */ { 4, 0, 14, 0, "0FAB 0FB7" },
/* U+0fad */ { 4, 0, 14, 0, 0 },
/* U+0fae */ { 4, 0, 14, 0, 0 },
/* U+0faf */ { 4, 0, 14, 0, 0 },
/* U+0fb0 */ { 4, 0, 14, 0, 0 },
/* U+0fb1 */ { 4, 0, 14, 0, 0 },
/* U+0fb2 */ { 4, 0, 14, 0, 0 },
/* U+0fb3 */ { 4, 0, 14, 0, 0 },
/* U+0fb4 */ { 4, 0, 14, 0, 0 },
/* U+0fb5 */ { 4, 0, 14, 0, 0 },
/* U+0fb6 */ { 4, 0, 14, 0, 0 },
/* U+0fb7 */ { 4, 0, 14, 0, 0 },
/* U+0fb8 */ { 4, 0, 14, 0, 0 },
/* U+0fb9 */ { 4, 0, 14, 0, "0F90 0FB5" },
/* U+0fba */ { 4, 0, 14, 0, 0 },
/* U+0fbb */ { 4, 0, 14, 0, 0 },
/* U+0fbc */ { 4, 0, 14, 0, 0 },
/* U+0fbd */ { 0, 0, 0, 0, 0 },
/* U+0fbe */ { 30, 0, 1, 0, 0 },
/* U+0fbf */ { 30, 0, 1, 0, 0 },
/* U+0fc0 */ { 30, 0, 1, 0, 0 },
/* U+0fc1 */ { 30, 0, 1, 0, 0 },
/* U+0fc2 */ { 30, 0, 1, 0, 0 },
/* U+0fc3 */ { 30, 0, 1, 0, 0 },
/* U+0fc4 */ { 30, 0, 1, 0, 0 },
/* U+0fc5 */ { 30, 0, 1, 0, 0 },
/* U+0fc6 */ { 4, 220, 14, 0, 0 },
/* U+0fc7 */ { 30, 0, 1, 0, 0 },
/* U+0fc8 */ { 30, 0, 1, 0, 0 },
/* U+0fc9 */ { 30, 0, 1, 0, 0 },
/* U+0fca */ { 30, 0, 1, 0, 0 },
/* U+0fcb */ { 30, 0, 1, 0, 0 },
/* U+0fcc */ { 30, 0, 1, 0, 0 },
/* U+0fcd */ { 0, 0, 0, 0, 0 },
/* U+0fce */ { 0, 0, 0, 0, 0 },
/* U+0fcf */ { 30, 0, 1, 0, 0 },
/* U+0fd0 */ { 0, 0, 0, 0, 0 },
/* U+0fd1 */ { 0, 0, 0, 0, 0 },
/* U+0fd2 */ { 0, 0, 0, 0, 0 },
/* U+0fd3 */ { 0, 0, 0, 0, 0 },
/* U+0fd4 */ { 0, 0, 0, 0, 0 },
/* U+0fd5 */ { 0, 0, 0, 0, 0 },
/* U+0fd6 */ { 0, 0, 0, 0, 0 },
/* U+0fd7 */ { 0, 0, 0, 0, 0 },
/* U+0fd8 */ { 0, 0, 0, 0, 0 },
/* U+0fd9 */ { 0, 0, 0, 0, 0 },
/* U+0fda */ { 0, 0, 0, 0, 0 },
/* U+0fdb */ { 0, 0, 0, 0, 0 },
/* U+0fdc */ { 0, 0, 0, 0, 0 },
/* U+0fdd */ { 0, 0, 0, 0, 0 },
/* U+0fde */ { 0, 0, 0, 0, 0 },
/* U+0fdf */ { 0, 0, 0, 0, 0 },
/* U+0fe0 */ { 0, 0, 0, 0, 0 },
/* U+0fe1 */ { 0, 0, 0, 0, 0 },
/* U+0fe2 */ { 0, 0, 0, 0, 0 },
/* U+0fe3 */ { 0, 0, 0, 0, 0 },
/* U+0fe4 */ { 0, 0, 0, 0, 0 },
/* U+0fe5 */ { 0, 0, 0, 0, 0 },
/* U+0fe6 */ { 0, 0, 0, 0, 0 },
/* U+0fe7 */ { 0, 0, 0, 0, 0 },
/* U+0fe8 */ { 0, 0, 0, 0, 0 },
/* U+0fe9 */ { 0, 0, 0, 0, 0 },
/* U+0fea */ { 0, 0, 0, 0, 0 },
/* U+0feb */ { 0, 0, 0, 0, 0 },
/* U+0fec */ { 0, 0, 0, 0, 0 },
/* U+0fed */ { 0, 0, 0, 0, 0 },
/* U+0fee */ { 0, 0, 0, 0, 0 },
/* U+0fef */ { 0, 0, 0, 0, 0 },
/* U+0ff0 */ { 0, 0, 0, 0, 0 },
/* U+0ff1 */ { 0, 0, 0, 0, 0 },
/* U+0ff2 */ { 0, 0, 0, 0, 0 },
/* U+0ff3 */ { 0, 0, 0, 0, 0 },
/* U+0ff4 */ { 0, 0, 0, 0, 0 },
/* U+0ff5 */ { 0, 0, 0, 0, 0 },
/* U+0ff6 */ { 0, 0, 0, 0, 0 },
/* U+0ff7 */ { 0, 0, 0, 0, 0 },
/* U+0ff8 */ { 0, 0, 0, 0, 0 },
/* U+0ff9 */ { 0, 0, 0, 0, 0 },
/* U+0ffa */ { 0, 0, 0, 0, 0 },
/* U+0ffb */ { 0, 0, 0, 0, 0 },
/* U+0ffc */ { 0, 0, 0, 0, 0 },
/* U+0ffd */ { 0, 0, 0, 0, 0 },
/* U+0ffe */ { 0, 0, 0, 0, 0 },
/* U+0fff */ { 0, 0, 0, 0, 0 },

};

const _PyUnicode_DatabaseRecord _PyUnicode_Database_1[4096] = {
    
/* U+1000 */ { 19, 0, 1, 0, 0 },
/* U+1001 */ { 19, 0, 1, 0, 0 },
/* U+1002 */ { 19, 0, 1, 0, 0 },
/* U+1003 */ { 19, 0, 1, 0, 0 },
/* U+1004 */ { 19, 0, 1, 0, 0 },
/* U+1005 */ { 19, 0, 1, 0, 0 },
/* U+1006 */ { 19, 0, 1, 0, 0 },
/* U+1007 */ { 19, 0, 1, 0, 0 },
/* U+1008 */ { 19, 0, 1, 0, 0 },
/* U+1009 */ { 19, 0, 1, 0, 0 },
/* U+100a */ { 19, 0, 1, 0, 0 },
/* U+100b */ { 19, 0, 1, 0, 0 },
/* U+100c */ { 19, 0, 1, 0, 0 },
/* U+100d */ { 19, 0, 1, 0, 0 },
/* U+100e */ { 19, 0, 1, 0, 0 },
/* U+100f */ { 19, 0, 1, 0, 0 },
/* U+1010 */ { 19, 0, 1, 0, 0 },
/* U+1011 */ { 19, 0, 1, 0, 0 },
/* U+1012 */ { 19, 0, 1, 0, 0 },
/* U+1013 */ { 19, 0, 1, 0, 0 },
/* U+1014 */ { 19, 0, 1, 0, 0 },
/* U+1015 */ { 19, 0, 1, 0, 0 },
/* U+1016 */ { 19, 0, 1, 0, 0 },
/* U+1017 */ { 19, 0, 1, 0, 0 },
/* U+1018 */ { 19, 0, 1, 0, 0 },
/* U+1019 */ { 19, 0, 1, 0, 0 },
/* U+101a */ { 19, 0, 1, 0, 0 },
/* U+101b */ { 19, 0, 1, 0, 0 },
/* U+101c */ { 19, 0, 1, 0, 0 },
/* U+101d */ { 19, 0, 1, 0, 0 },
/* U+101e */ { 19, 0, 1, 0, 0 },
/* U+101f */ { 19, 0, 1, 0, 0 },
/* U+1020 */ { 19, 0, 1, 0, 0 },
/* U+1021 */ { 19, 0, 1, 0, 0 },
/* U+1022 */ { 0, 0, 0, 0, 0 },
/* U+1023 */ { 19, 0, 1, 0, 0 },
/* U+1024 */ { 19, 0, 1, 0, 0 },
/* U+1025 */ { 19, 0, 1, 0, 0 },
/* U+1026 */ { 19, 0, 1, 0, "1025 102E" },
/* U+1027 */ { 19, 0, 1, 0, 0 },
/* U+1028 */ { 0, 0, 0, 0, 0 },
/* U+1029 */ { 19, 0, 1, 0, 0 },
/* U+102a */ { 19, 0, 1, 0, 0 },
/* U+102b */ { 0, 0, 0, 0, 0 },
/* U+102c */ { 5, 0, 1, 0, 0 },
/* U+102d */ { 4, 0, 14, 0, 0 },
/* U+102e */ { 4, 0, 14, 0, 0 },
/* U+102f */ { 4, 0, 14, 0, 0 },
/* U+1030 */ { 4, 0, 14, 0, 0 },
/* U+1031 */ { 5, 0, 1, 0, 0 },
/* U+1032 */ { 4, 0, 14, 0, 0 },
/* U+1033 */ { 0, 0, 0, 0, 0 },
/* U+1034 */ { 0, 0, 0, 0, 0 },
/* U+1035 */ { 0, 0, 0, 0, 0 },
/* U+1036 */ { 4, 0, 14, 0, 0 },
/* U+1037 */ { 4, 7, 14, 0, 0 },
/* U+1038 */ { 5, 0, 1, 0, 0 },
/* U+1039 */ { 4, 9, 14, 0, 0 },
/* U+103a */ { 0, 0, 0, 0, 0 },
/* U+103b */ { 0, 0, 0, 0, 0 },
/* U+103c */ { 0, 0, 0, 0, 0 },
/* U+103d */ { 0, 0, 0, 0, 0 },
/* U+103e */ { 0, 0, 0, 0, 0 },
/* U+103f */ { 0, 0, 0, 0, 0 },
/* U+1040 */ { 7, 0, 1, 0, 0 },
/* U+1041 */ { 7, 0, 1, 0, 0 },
/* U+1042 */ { 7, 0, 1, 0, 0 },
/* U+1043 */ { 7, 0, 1, 0, 0 },
/* U+1044 */ { 7, 0, 1, 0, 0 },
/* U+1045 */ { 7, 0, 1, 0, 0 },
/* U+1046 */ { 7, 0, 1, 0, 0 },
/* U+1047 */ { 7, 0, 1, 0, 0 },
/* U+1048 */ { 7, 0, 1, 0, 0 },
/* U+1049 */ { 7, 0, 1, 0, 0 },
/* U+104a */ { 26, 0, 1, 0, 0 },
/* U+104b */ { 26, 0, 1, 0, 0 },
/* U+104c */ { 26, 0, 1, 0, 0 },
/* U+104d */ { 26, 0, 1, 0, 0 },
/* U+104e */ { 26, 0, 1, 0, 0 },
/* U+104f */ { 26, 0, 1, 0, 0 },
/* U+1050 */ { 19, 0, 1, 0, 0 },
/* U+1051 */ { 19, 0, 1, 0, 0 },
/* U+1052 */ { 19, 0, 1, 0, 0 },
/* U+1053 */ { 19, 0, 1, 0, 0 },
/* U+1054 */ { 19, 0, 1, 0, 0 },
/* U+1055 */ { 19, 0, 1, 0, 0 },
/* U+1056 */ { 5, 0, 1, 0, 0 },
/* U+1057 */ { 5, 0, 1, 0, 0 },
/* U+1058 */ { 4, 0, 14, 0, 0 },
/* U+1059 */ { 4, 0, 14, 0, 0 },
/* U+105a */ { 0, 0, 0, 0, 0 },
/* U+105b */ { 0, 0, 0, 0, 0 },
/* U+105c */ { 0, 0, 0, 0, 0 },
/* U+105d */ { 0, 0, 0, 0, 0 },
/* U+105e */ { 0, 0, 0, 0, 0 },
/* U+105f */ { 0, 0, 0, 0, 0 },
/* U+1060 */ { 0, 0, 0, 0, 0 },
/* U+1061 */ { 0, 0, 0, 0, 0 },
/* U+1062 */ { 0, 0, 0, 0, 0 },
/* U+1063 */ { 0, 0, 0, 0, 0 },
/* U+1064 */ { 0, 0, 0, 0, 0 },
/* U+1065 */ { 0, 0, 0, 0, 0 },
/* U+1066 */ { 0, 0, 0, 0, 0 },
/* U+1067 */ { 0, 0, 0, 0, 0 },
/* U+1068 */ { 0, 0, 0, 0, 0 },
/* U+1069 */ { 0, 0, 0, 0, 0 },
/* U+106a */ { 0, 0, 0, 0, 0 },
/* U+106b */ { 0, 0, 0, 0, 0 },
/* U+106c */ { 0, 0, 0, 0, 0 },
/* U+106d */ { 0, 0, 0, 0, 0 },
/* U+106e */ { 0, 0, 0, 0, 0 },
/* U+106f */ { 0, 0, 0, 0, 0 },
/* U+1070 */ { 0, 0, 0, 0, 0 },
/* U+1071 */ { 0, 0, 0, 0, 0 },
/* U+1072 */ { 0, 0, 0, 0, 0 },
/* U+1073 */ { 0, 0, 0, 0, 0 },
/* U+1074 */ { 0, 0, 0, 0, 0 },
/* U+1075 */ { 0, 0, 0, 0, 0 },
/* U+1076 */ { 0, 0, 0, 0, 0 },
/* U+1077 */ { 0, 0, 0, 0, 0 },
/* U+1078 */ { 0, 0, 0, 0, 0 },
/* U+1079 */ { 0, 0, 0, 0, 0 },
/* U+107a */ { 0, 0, 0, 0, 0 },
/* U+107b */ { 0, 0, 0, 0, 0 },
/* U+107c */ { 0, 0, 0, 0, 0 },
/* U+107d */ { 0, 0, 0, 0, 0 },
/* U+107e */ { 0, 0, 0, 0, 0 },
/* U+107f */ { 0, 0, 0, 0, 0 },
/* U+1080 */ { 0, 0, 0, 0, 0 },
/* U+1081 */ { 0, 0, 0, 0, 0 },
/* U+1082 */ { 0, 0, 0, 0, 0 },
/* U+1083 */ { 0, 0, 0, 0, 0 },
/* U+1084 */ { 0, 0, 0, 0, 0 },
/* U+1085 */ { 0, 0, 0, 0, 0 },
/* U+1086 */ { 0, 0, 0, 0, 0 },
/* U+1087 */ { 0, 0, 0, 0, 0 },
/* U+1088 */ { 0, 0, 0, 0, 0 },
/* U+1089 */ { 0, 0, 0, 0, 0 },
/* U+108a */ { 0, 0, 0, 0, 0 },
/* U+108b */ { 0, 0, 0, 0, 0 },
/* U+108c */ { 0, 0, 0, 0, 0 },
/* U+108d */ { 0, 0, 0, 0, 0 },
/* U+108e */ { 0, 0, 0, 0, 0 },
/* U+108f */ { 0, 0, 0, 0, 0 },
/* U+1090 */ { 0, 0, 0, 0, 0 },
/* U+1091 */ { 0, 0, 0, 0, 0 },
/* U+1092 */ { 0, 0, 0, 0, 0 },
/* U+1093 */ { 0, 0, 0, 0, 0 },
/* U+1094 */ { 0, 0, 0, 0, 0 },
/* U+1095 */ { 0, 0, 0, 0, 0 },
/* U+1096 */ { 0, 0, 0, 0, 0 },
/* U+1097 */ { 0, 0, 0, 0, 0 },
/* U+1098 */ { 0, 0, 0, 0, 0 },
/* U+1099 */ { 0, 0, 0, 0, 0 },
/* U+109a */ { 0, 0, 0, 0, 0 },
/* U+109b */ { 0, 0, 0, 0, 0 },
/* U+109c */ { 0, 0, 0, 0, 0 },
/* U+109d */ { 0, 0, 0, 0, 0 },
/* U+109e */ { 0, 0, 0, 0, 0 },
/* U+109f */ { 0, 0, 0, 0, 0 },
/* U+10a0 */ { 1, 0, 1, 0, 0 },
/* U+10a1 */ { 1, 0, 1, 0, 0 },
/* U+10a2 */ { 1, 0, 1, 0, 0 },
/* U+10a3 */ { 1, 0, 1, 0, 0 },
/* U+10a4 */ { 1, 0, 1, 0, 0 },
/* U+10a5 */ { 1, 0, 1, 0, 0 },
/* U+10a6 */ { 1, 0, 1, 0, 0 },
/* U+10a7 */ { 1, 0, 1, 0, 0 },
/* U+10a8 */ { 1, 0, 1, 0, 0 },
/* U+10a9 */ { 1, 0, 1, 0, 0 },
/* U+10aa */ { 1, 0, 1, 0, 0 },
/* U+10ab */ { 1, 0, 1, 0, 0 },
/* U+10ac */ { 1, 0, 1, 0, 0 },
/* U+10ad */ { 1, 0, 1, 0, 0 },
/* U+10ae */ { 1, 0, 1, 0, 0 },
/* U+10af */ { 1, 0, 1, 0, 0 },
/* U+10b0 */ { 1, 0, 1, 0, 0 },
/* U+10b1 */ { 1, 0, 1, 0, 0 },
/* U+10b2 */ { 1, 0, 1, 0, 0 },
/* U+10b3 */ { 1, 0, 1, 0, 0 },
/* U+10b4 */ { 1, 0, 1, 0, 0 },
/* U+10b5 */ { 1, 0, 1, 0, 0 },
/* U+10b6 */ { 1, 0, 1, 0, 0 },
/* U+10b7 */ { 1, 0, 1, 0, 0 },
/* U+10b8 */ { 1, 0, 1, 0, 0 },
/* U+10b9 */ { 1, 0, 1, 0, 0 },
/* U+10ba */ { 1, 0, 1, 0, 0 },
/* U+10bb */ { 1, 0, 1, 0, 0 },
/* U+10bc */ { 1, 0, 1, 0, 0 },
/* U+10bd */ { 1, 0, 1, 0, 0 },
/* U+10be */ { 1, 0, 1, 0, 0 },
/* U+10bf */ { 1, 0, 1, 0, 0 },
/* U+10c0 */ { 1, 0, 1, 0, 0 },
/* U+10c1 */ { 1, 0, 1, 0, 0 },
/* U+10c2 */ { 1, 0, 1, 0, 0 },
/* U+10c3 */ { 1, 0, 1, 0, 0 },
/* U+10c4 */ { 1, 0, 1, 0, 0 },
/* U+10c5 */ { 1, 0, 1, 0, 0 },
/* U+10c6 */ { 0, 0, 0, 0, 0 },
/* U+10c7 */ { 0, 0, 0, 0, 0 },
/* U+10c8 */ { 0, 0, 0, 0, 0 },
/* U+10c9 */ { 0, 0, 0, 0, 0 },
/* U+10ca */ { 0, 0, 0, 0, 0 },
/* U+10cb */ { 0, 0, 0, 0, 0 },
/* U+10cc */ { 0, 0, 0, 0, 0 },
/* U+10cd */ { 0, 0, 0, 0, 0 },
/* U+10ce */ { 0, 0, 0, 0, 0 },
/* U+10cf */ { 0, 0, 0, 0, 0 },
/* U+10d0 */ { 19, 0, 1, 0, 0 },
/* U+10d1 */ { 19, 0, 1, 0, 0 },
/* U+10d2 */ { 19, 0, 1, 0, 0 },
/* U+10d3 */ { 19, 0, 1, 0, 0 },
/* U+10d4 */ { 19, 0, 1, 0, 0 },
/* U+10d5 */ { 19, 0, 1, 0, 0 },
/* U+10d6 */ { 19, 0, 1, 0, 0 },
/* U+10d7 */ { 19, 0, 1, 0, 0 },
/* U+10d8 */ { 19, 0, 1, 0, 0 },
/* U+10d9 */ { 19, 0, 1, 0, 0 },
/* U+10da */ { 19, 0, 1, 0, 0 },
/* U+10db */ { 19, 0, 1, 0, 0 },
/* U+10dc */ { 19, 0, 1, 0, 0 },
/* U+10dd */ { 19, 0, 1, 0, 0 },
/* U+10de */ { 19, 0, 1, 0, 0 },
/* U+10df */ { 19, 0, 1, 0, 0 },
/* U+10e0 */ { 19, 0, 1, 0, 0 },
/* U+10e1 */ { 19, 0, 1, 0, 0 },
/* U+10e2 */ { 19, 0, 1, 0, 0 },
/* U+10e3 */ { 19, 0, 1, 0, 0 },
/* U+10e4 */ { 19, 0, 1, 0, 0 },
/* U+10e5 */ { 19, 0, 1, 0, 0 },
/* U+10e6 */ { 19, 0, 1, 0, 0 },
/* U+10e7 */ { 19, 0, 1, 0, 0 },
/* U+10e8 */ { 19, 0, 1, 0, 0 },
/* U+10e9 */ { 19, 0, 1, 0, 0 },
/* U+10ea */ { 19, 0, 1, 0, 0 },
/* U+10eb */ { 19, 0, 1, 0, 0 },
/* U+10ec */ { 19, 0, 1, 0, 0 },
/* U+10ed */ { 19, 0, 1, 0, 0 },
/* U+10ee */ { 19, 0, 1, 0, 0 },
/* U+10ef */ { 19, 0, 1, 0, 0 },
/* U+10f0 */ { 19, 0, 1, 0, 0 },
/* U+10f1 */ { 19, 0, 1, 0, 0 },
/* U+10f2 */ { 19, 0, 1, 0, 0 },
/* U+10f3 */ { 19, 0, 1, 0, 0 },
/* U+10f4 */ { 19, 0, 1, 0, 0 },
/* U+10f5 */ { 19, 0, 1, 0, 0 },
/* U+10f6 */ { 19, 0, 1, 0, 0 },
/* U+10f7 */ { 0, 0, 0, 0, 0 },
/* U+10f8 */ { 0, 0, 0, 0, 0 },
/* U+10f9 */ { 0, 0, 0, 0, 0 },
/* U+10fa */ { 0, 0, 0, 0, 0 },
/* U+10fb */ { 26, 0, 1, 0, 0 },
/* U+10fc */ { 0, 0, 0, 0, 0 },
/* U+10fd */ { 0, 0, 0, 0, 0 },
/* U+10fe */ { 0, 0, 0, 0, 0 },
/* U+10ff */ { 0, 0, 0, 0, 0 },
/* U+1100 */ { 19, 0, 1, 0, 0 },
/* U+1101 */ { 19, 0, 1, 0, 0 },
/* U+1102 */ { 19, 0, 1, 0, 0 },
/* U+1103 */ { 19, 0, 1, 0, 0 },
/* U+1104 */ { 19, 0, 1, 0, 0 },
/* U+1105 */ { 19, 0, 1, 0, 0 },
/* U+1106 */ { 19, 0, 1, 0, 0 },
/* U+1107 */ { 19, 0, 1, 0, 0 },
/* U+1108 */ { 19, 0, 1, 0, 0 },
/* U+1109 */ { 19, 0, 1, 0, 0 },
/* U+110a */ { 19, 0, 1, 0, 0 },
/* U+110b */ { 19, 0, 1, 0, 0 },
/* U+110c */ { 19, 0, 1, 0, 0 },
/* U+110d */ { 19, 0, 1, 0, 0 },
/* U+110e */ { 19, 0, 1, 0, 0 },
/* U+110f */ { 19, 0, 1, 0, 0 },
/* U+1110 */ { 19, 0, 1, 0, 0 },
/* U+1111 */ { 19, 0, 1, 0, 0 },
/* U+1112 */ { 19, 0, 1, 0, 0 },
/* U+1113 */ { 19, 0, 1, 0, 0 },
/* U+1114 */ { 19, 0, 1, 0, 0 },
/* U+1115 */ { 19, 0, 1, 0, 0 },
/* U+1116 */ { 19, 0, 1, 0, 0 },
/* U+1117 */ { 19, 0, 1, 0, 0 },
/* U+1118 */ { 19, 0, 1, 0, 0 },
/* U+1119 */ { 19, 0, 1, 0, 0 },
/* U+111a */ { 19, 0, 1, 0, 0 },
/* U+111b */ { 19, 0, 1, 0, 0 },
/* U+111c */ { 19, 0, 1, 0, 0 },
/* U+111d */ { 19, 0, 1, 0, 0 },
/* U+111e */ { 19, 0, 1, 0, 0 },
/* U+111f */ { 19, 0, 1, 0, 0 },
/* U+1120 */ { 19, 0, 1, 0, 0 },
/* U+1121 */ { 19, 0, 1, 0, 0 },
/* U+1122 */ { 19, 0, 1, 0, 0 },
/* U+1123 */ { 19, 0, 1, 0, 0 },
/* U+1124 */ { 19, 0, 1, 0, 0 },
/* U+1125 */ { 19, 0, 1, 0, 0 },
/* U+1126 */ { 19, 0, 1, 0, 0 },
/* U+1127 */ { 19, 0, 1, 0, 0 },
/* U+1128 */ { 19, 0, 1, 0, 0 },
/* U+1129 */ { 19, 0, 1, 0, 0 },
/* U+112a */ { 19, 0, 1, 0, 0 },
/* U+112b */ { 19, 0, 1, 0, 0 },
/* U+112c */ { 19, 0, 1, 0, 0 },
/* U+112d */ { 19, 0, 1, 0, 0 },
/* U+112e */ { 19, 0, 1, 0, 0 },
/* U+112f */ { 19, 0, 1, 0, 0 },
/* U+1130 */ { 19, 0, 1, 0, 0 },
/* U+1131 */ { 19, 0, 1, 0, 0 },
/* U+1132 */ { 19, 0, 1, 0, 0 },
/* U+1133 */ { 19, 0, 1, 0, 0 },
/* U+1134 */ { 19, 0, 1, 0, 0 },
/* U+1135 */ { 19, 0, 1, 0, 0 },
/* U+1136 */ { 19, 0, 1, 0, 0 },
/* U+1137 */ { 19, 0, 1, 0, 0 },
/* U+1138 */ { 19, 0, 1, 0, 0 },
/* U+1139 */ { 19, 0, 1, 0, 0 },
/* U+113a */ { 19, 0, 1, 0, 0 },
/* U+113b */ { 19, 0, 1, 0, 0 },
/* U+113c */ { 19, 0, 1, 0, 0 },
/* U+113d */ { 19, 0, 1, 0, 0 },
/* U+113e */ { 19, 0, 1, 0, 0 },
/* U+113f */ { 19, 0, 1, 0, 0 },
/* U+1140 */ { 19, 0, 1, 0, 0 },
/* U+1141 */ { 19, 0, 1, 0, 0 },
/* U+1142 */ { 19, 0, 1, 0, 0 },
/* U+1143 */ { 19, 0, 1, 0, 0 },
/* U+1144 */ { 19, 0, 1, 0, 0 },
/* U+1145 */ { 19, 0, 1, 0, 0 },
/* U+1146 */ { 19, 0, 1, 0, 0 },
/* U+1147 */ { 19, 0, 1, 0, 0 },
/* U+1148 */ { 19, 0, 1, 0, 0 },
/* U+1149 */ { 19, 0, 1, 0, 0 },
/* U+114a */ { 19, 0, 1, 0, 0 },
/* U+114b */ { 19, 0, 1, 0, 0 },
/* U+114c */ { 19, 0, 1, 0, 0 },
/* U+114d */ { 19, 0, 1, 0, 0 },
/* U+114e */ { 19, 0, 1, 0, 0 },
/* U+114f */ { 19, 0, 1, 0, 0 },
/* U+1150 */ { 19, 0, 1, 0, 0 },
/* U+1151 */ { 19, 0, 1, 0, 0 },
/* U+1152 */ { 19, 0, 1, 0, 0 },
/* U+1153 */ { 19, 0, 1, 0, 0 },
/* U+1154 */ { 19, 0, 1, 0, 0 },
/* U+1155 */ { 19, 0, 1, 0, 0 },
/* U+1156 */ { 19, 0, 1, 0, 0 },
/* U+1157 */ { 19, 0, 1, 0, 0 },
/* U+1158 */ { 19, 0, 1, 0, 0 },
/* U+1159 */ { 19, 0, 1, 0, 0 },
/* U+115a */ { 0, 0, 0, 0, 0 },
/* U+115b */ { 0, 0, 0, 0, 0 },
/* U+115c */ { 0, 0, 0, 0, 0 },
/* U+115d */ { 0, 0, 0, 0, 0 },
/* U+115e */ { 0, 0, 0, 0, 0 },
/* U+115f */ { 19, 0, 1, 0, 0 },
/* U+1160 */ { 19, 0, 1, 0, 0 },
/* U+1161 */ { 19, 0, 1, 0, 0 },
/* U+1162 */ { 19, 0, 1, 0, 0 },
/* U+1163 */ { 19, 0, 1, 0, 0 },
/* U+1164 */ { 19, 0, 1, 0, 0 },
/* U+1165 */ { 19, 0, 1, 0, 0 },
/* U+1166 */ { 19, 0, 1, 0, 0 },
/* U+1167 */ { 19, 0, 1, 0, 0 },
/* U+1168 */ { 19, 0, 1, 0, 0 },
/* U+1169 */ { 19, 0, 1, 0, 0 },
/* U+116a */ { 19, 0, 1, 0, 0 },
/* U+116b */ { 19, 0, 1, 0, 0 },
/* U+116c */ { 19, 0, 1, 0, 0 },
/* U+116d */ { 19, 0, 1, 0, 0 },
/* U+116e */ { 19, 0, 1, 0, 0 },
/* U+116f */ { 19, 0, 1, 0, 0 },
/* U+1170 */ { 19, 0, 1, 0, 0 },
/* U+1171 */ { 19, 0, 1, 0, 0 },
/* U+1172 */ { 19, 0, 1, 0, 0 },
/* U+1173 */ { 19, 0, 1, 0, 0 },
/* U+1174 */ { 19, 0, 1, 0, 0 },
/* U+1175 */ { 19, 0, 1, 0, 0 },
/* U+1176 */ { 19, 0, 1, 0, 0 },
/* U+1177 */ { 19, 0, 1, 0, 0 },
/* U+1178 */ { 19, 0, 1, 0, 0 },
/* U+1179 */ { 19, 0, 1, 0, 0 },
/* U+117a */ { 19, 0, 1, 0, 0 },
/* U+117b */ { 19, 0, 1, 0, 0 },
/* U+117c */ { 19, 0, 1, 0, 0 },
/* U+117d */ { 19, 0, 1, 0, 0 },
/* U+117e */ { 19, 0, 1, 0, 0 },
/* U+117f */ { 19, 0, 1, 0, 0 },
/* U+1180 */ { 19, 0, 1, 0, 0 },
/* U+1181 */ { 19, 0, 1, 0, 0 },
/* U+1182 */ { 19, 0, 1, 0, 0 },
/* U+1183 */ { 19, 0, 1, 0, 0 },
/* U+1184 */ { 19, 0, 1, 0, 0 },
/* U+1185 */ { 19, 0, 1, 0, 0 },
/* U+1186 */ { 19, 0, 1, 0, 0 },
/* U+1187 */ { 19, 0, 1, 0, 0 },
/* U+1188 */ { 19, 0, 1, 0, 0 },
/* U+1189 */ { 19, 0, 1, 0, 0 },
/* U+118a */ { 19, 0, 1, 0, 0 },
/* U+118b */ { 19, 0, 1, 0, 0 },
/* U+118c */ { 19, 0, 1, 0, 0 },
/* U+118d */ { 19, 0, 1, 0, 0 },
/* U+118e */ { 19, 0, 1, 0, 0 },
/* U+118f */ { 19, 0, 1, 0, 0 },
/* U+1190 */ { 19, 0, 1, 0, 0 },
/* U+1191 */ { 19, 0, 1, 0, 0 },
/* U+1192 */ { 19, 0, 1, 0, 0 },
/* U+1193 */ { 19, 0, 1, 0, 0 },
/* U+1194 */ { 19, 0, 1, 0, 0 },
/* U+1195 */ { 19, 0, 1, 0, 0 },
/* U+1196 */ { 19, 0, 1, 0, 0 },
/* U+1197 */ { 19, 0, 1, 0, 0 },
/* U+1198 */ { 19, 0, 1, 0, 0 },
/* U+1199 */ { 19, 0, 1, 0, 0 },
/* U+119a */ { 19, 0, 1, 0, 0 },
/* U+119b */ { 19, 0, 1, 0, 0 },
/* U+119c */ { 19, 0, 1, 0, 0 },
/* U+119d */ { 19, 0, 1, 0, 0 },
/* U+119e */ { 19, 0, 1, 0, 0 },
/* U+119f */ { 19, 0, 1, 0, 0 },
/* U+11a0 */ { 19, 0, 1, 0, 0 },
/* U+11a1 */ { 19, 0, 1, 0, 0 },
/* U+11a2 */ { 19, 0, 1, 0, 0 },
/* U+11a3 */ { 0, 0, 0, 0, 0 },
/* U+11a4 */ { 0, 0, 0, 0, 0 },
/* U+11a5 */ { 0, 0, 0, 0, 0 },
/* U+11a6 */ { 0, 0, 0, 0, 0 },
/* U+11a7 */ { 0, 0, 0, 0, 0 },
/* U+11a8 */ { 19, 0, 1, 0, 0 },
/* U+11a9 */ { 19, 0, 1, 0, 0 },
/* U+11aa */ { 19, 0, 1, 0, 0 },
/* U+11ab */ { 19, 0, 1, 0, 0 },
/* U+11ac */ { 19, 0, 1, 0, 0 },
/* U+11ad */ { 19, 0, 1, 0, 0 },
/* U+11ae */ { 19, 0, 1, 0, 0 },
/* U+11af */ { 19, 0, 1, 0, 0 },
/* U+11b0 */ { 19, 0, 1, 0, 0 },
/* U+11b1 */ { 19, 0, 1, 0, 0 },
/* U+11b2 */ { 19, 0, 1, 0, 0 },
/* U+11b3 */ { 19, 0, 1, 0, 0 },
/* U+11b4 */ { 19, 0, 1, 0, 0 },
/* U+11b5 */ { 19, 0, 1, 0, 0 },
/* U+11b6 */ { 19, 0, 1, 0, 0 },
/* U+11b7 */ { 19, 0, 1, 0, 0 },
/* U+11b8 */ { 19, 0, 1, 0, 0 },
/* U+11b9 */ { 19, 0, 1, 0, 0 },
/* U+11ba */ { 19, 0, 1, 0, 0 },
/* U+11bb */ { 19, 0, 1, 0, 0 },
/* U+11bc */ { 19, 0, 1, 0, 0 },
/* U+11bd */ { 19, 0, 1, 0, 0 },
/* U+11be */ { 19, 0, 1, 0, 0 },
/* U+11bf */ { 19, 0, 1, 0, 0 },
/* U+11c0 */ { 19, 0, 1, 0, 0 },
/* U+11c1 */ { 19, 0, 1, 0, 0 },
/* U+11c2 */ { 19, 0, 1, 0, 0 },
/* U+11c3 */ { 19, 0, 1, 0, 0 },
/* U+11c4 */ { 19, 0, 1, 0, 0 },
/* U+11c5 */ { 19, 0, 1, 0, 0 },
/* U+11c6 */ { 19, 0, 1, 0, 0 },
/* U+11c7 */ { 19, 0, 1, 0, 0 },
/* U+11c8 */ { 19, 0, 1, 0, 0 },
/* U+11c9 */ { 19, 0, 1, 0, 0 },
/* U+11ca */ { 19, 0, 1, 0, 0 },
/* U+11cb */ { 19, 0, 1, 0, 0 },
/* U+11cc */ { 19, 0, 1, 0, 0 },
/* U+11cd */ { 19, 0, 1, 0, 0 },
/* U+11ce */ { 19, 0, 1, 0, 0 },
/* U+11cf */ { 19, 0, 1, 0, 0 },
/* U+11d0 */ { 19, 0, 1, 0, 0 },
/* U+11d1 */ { 19, 0, 1, 0, 0 },
/* U+11d2 */ { 19, 0, 1, 0, 0 },
/* U+11d3 */ { 19, 0, 1, 0, 0 },
/* U+11d4 */ { 19, 0, 1, 0, 0 },
/* U+11d5 */ { 19, 0, 1, 0, 0 },
/* U+11d6 */ { 19, 0, 1, 0, 0 },
/* U+11d7 */ { 19, 0, 1, 0, 0 },
/* U+11d8 */ { 19, 0, 1, 0, 0 },
/* U+11d9 */ { 19, 0, 1, 0, 0 },
/* U+11da */ { 19, 0, 1, 0, 0 },
/* U+11db */ { 19, 0, 1, 0, 0 },
/* U+11dc */ { 19, 0, 1, 0, 0 },
/* U+11dd */ { 19, 0, 1, 0, 0 },
/* U+11de */ { 19, 0, 1, 0, 0 },
/* U+11df */ { 19, 0, 1, 0, 0 },
/* U+11e0 */ { 19, 0, 1, 0, 0 },
/* U+11e1 */ { 19, 0, 1, 0, 0 },
/* U+11e2 */ { 19, 0, 1, 0, 0 },
/* U+11e3 */ { 19, 0, 1, 0, 0 },
/* U+11e4 */ { 19, 0, 1, 0, 0 },
/* U+11e5 */ { 19, 0, 1, 0, 0 },
/* U+11e6 */ { 19, 0, 1, 0, 0 },
/* U+11e7 */ { 19, 0, 1, 0, 0 },
/* U+11e8 */ { 19, 0, 1, 0, 0 },
/* U+11e9 */ { 19, 0, 1, 0, 0 },
/* U+11ea */ { 19, 0, 1, 0, 0 },
/* U+11eb */ { 19, 0, 1, 0, 0 },
/* U+11ec */ { 19, 0, 1, 0, 0 },
/* U+11ed */ { 19, 0, 1, 0, 0 },
/* U+11ee */ { 19, 0, 1, 0, 0 },
/* U+11ef */ { 19, 0, 1, 0, 0 },
/* U+11f0 */ { 19, 0, 1, 0, 0 },
/* U+11f1 */ { 19, 0, 1, 0, 0 },
/* U+11f2 */ { 19, 0, 1, 0, 0 },
/* U+11f3 */ { 19, 0, 1, 0, 0 },
/* U+11f4 */ { 19, 0, 1, 0, 0 },
/* U+11f5 */ { 19, 0, 1, 0, 0 },
/* U+11f6 */ { 19, 0, 1, 0, 0 },
/* U+11f7 */ { 19, 0, 1, 0, 0 },
/* U+11f8 */ { 19, 0, 1, 0, 0 },
/* U+11f9 */ { 19, 0, 1, 0, 0 },
/* U+11fa */ { 0, 0, 0, 0, 0 },
/* U+11fb */ { 0, 0, 0, 0, 0 },
/* U+11fc */ { 0, 0, 0, 0, 0 },
/* U+11fd */ { 0, 0, 0, 0, 0 },
/* U+11fe */ { 0, 0, 0, 0, 0 },
/* U+11ff */ { 0, 0, 0, 0, 0 },
/* U+1200 */ { 19, 0, 1, 0, 0 },
/* U+1201 */ { 19, 0, 1, 0, 0 },
/* U+1202 */ { 19, 0, 1, 0, 0 },
/* U+1203 */ { 19, 0, 1, 0, 0 },
/* U+1204 */ { 19, 0, 1, 0, 0 },
/* U+1205 */ { 19, 0, 1, 0, 0 },
/* U+1206 */ { 19, 0, 1, 0, 0 },
/* U+1207 */ { 0, 0, 0, 0, 0 },
/* U+1208 */ { 19, 0, 1, 0, 0 },
/* U+1209 */ { 19, 0, 1, 0, 0 },
/* U+120a */ { 19, 0, 1, 0, 0 },
/* U+120b */ { 19, 0, 1, 0, 0 },
/* U+120c */ { 19, 0, 1, 0, 0 },
/* U+120d */ { 19, 0, 1, 0, 0 },
/* U+120e */ { 19, 0, 1, 0, 0 },
/* U+120f */ { 19, 0, 1, 0, 0 },
/* U+1210 */ { 19, 0, 1, 0, 0 },
/* U+1211 */ { 19, 0, 1, 0, 0 },
/* U+1212 */ { 19, 0, 1, 0, 0 },
/* U+1213 */ { 19, 0, 1, 0, 0 },
/* U+1214 */ { 19, 0, 1, 0, 0 },
/* U+1215 */ { 19, 0, 1, 0, 0 },
/* U+1216 */ { 19, 0, 1, 0, 0 },
/* U+1217 */ { 19, 0, 1, 0, 0 },
/* U+1218 */ { 19, 0, 1, 0, 0 },
/* U+1219 */ { 19, 0, 1, 0, 0 },
/* U+121a */ { 19, 0, 1, 0, 0 },
/* U+121b */ { 19, 0, 1, 0, 0 },
/* U+121c */ { 19, 0, 1, 0, 0 },
/* U+121d */ { 19, 0, 1, 0, 0 },
/* U+121e */ { 19, 0, 1, 0, 0 },
/* U+121f */ { 19, 0, 1, 0, 0 },
/* U+1220 */ { 19, 0, 1, 0, 0 },
/* U+1221 */ { 19, 0, 1, 0, 0 },
/* U+1222 */ { 19, 0, 1, 0, 0 },
/* U+1223 */ { 19, 0, 1, 0, 0 },
/* U+1224 */ { 19, 0, 1, 0, 0 },
/* U+1225 */ { 19, 0, 1, 0, 0 },
/* U+1226 */ { 19, 0, 1, 0, 0 },
/* U+1227 */ { 19, 0, 1, 0, 0 },
/* U+1228 */ { 19, 0, 1, 0, 0 },
/* U+1229 */ { 19, 0, 1, 0, 0 },
/* U+122a */ { 19, 0, 1, 0, 0 },
/* U+122b */ { 19, 0, 1, 0, 0 },
/* U+122c */ { 19, 0, 1, 0, 0 },
/* U+122d */ { 19, 0, 1, 0, 0 },
/* U+122e */ { 19, 0, 1, 0, 0 },
/* U+122f */ { 19, 0, 1, 0, 0 },
/* U+1230 */ { 19, 0, 1, 0, 0 },
/* U+1231 */ { 19, 0, 1, 0, 0 },
/* U+1232 */ { 19, 0, 1, 0, 0 },
/* U+1233 */ { 19, 0, 1, 0, 0 },
/* U+1234 */ { 19, 0, 1, 0, 0 },
/* U+1235 */ { 19, 0, 1, 0, 0 },
/* U+1236 */ { 19, 0, 1, 0, 0 },
/* U+1237 */ { 19, 0, 1, 0, 0 },
/* U+1238 */ { 19, 0, 1, 0, 0 },
/* U+1239 */ { 19, 0, 1, 0, 0 },
/* U+123a */ { 19, 0, 1, 0, 0 },
/* U+123b */ { 19, 0, 1, 0, 0 },
/* U+123c */ { 19, 0, 1, 0, 0 },
/* U+123d */ { 19, 0, 1, 0, 0 },
/* U+123e */ { 19, 0, 1, 0, 0 },
/* U+123f */ { 19, 0, 1, 0, 0 },
/* U+1240 */ { 19, 0, 1, 0, 0 },
/* U+1241 */ { 19, 0, 1, 0, 0 },
/* U+1242 */ { 19, 0, 1, 0, 0 },
/* U+1243 */ { 19, 0, 1, 0, 0 },
/* U+1244 */ { 19, 0, 1, 0, 0 },
/* U+1245 */ { 19, 0, 1, 0, 0 },
/* U+1246 */ { 19, 0, 1, 0, 0 },
/* U+1247 */ { 0, 0, 0, 0, 0 },
/* U+1248 */ { 19, 0, 1, 0, 0 },
/* U+1249 */ { 0, 0, 0, 0, 0 },
/* U+124a */ { 19, 0, 1, 0, 0 },
/* U+124b */ { 19, 0, 1, 0, 0 },
/* U+124c */ { 19, 0, 1, 0, 0 },
/* U+124d */ { 19, 0, 1, 0, 0 },
/* U+124e */ { 0, 0, 0, 0, 0 },
/* U+124f */ { 0, 0, 0, 0, 0 },
/* U+1250 */ { 19, 0, 1, 0, 0 },
/* U+1251 */ { 19, 0, 1, 0, 0 },
/* U+1252 */ { 19, 0, 1, 0, 0 },
/* U+1253 */ { 19, 0, 1, 0, 0 },
/* U+1254 */ { 19, 0, 1, 0, 0 },
/* U+1255 */ { 19, 0, 1, 0, 0 },
/* U+1256 */ { 19, 0, 1, 0, 0 },
/* U+1257 */ { 0, 0, 0, 0, 0 },
/* U+1258 */ { 19, 0, 1, 0, 0 },
/* U+1259 */ { 0, 0, 0, 0, 0 },
/* U+125a */ { 19, 0, 1, 0, 0 },
/* U+125b */ { 19, 0, 1, 0, 0 },
/* U+125c */ { 19, 0, 1, 0, 0 },
/* U+125d */ { 19, 0, 1, 0, 0 },
/* U+125e */ { 0, 0, 0, 0, 0 },
/* U+125f */ { 0, 0, 0, 0, 0 },
/* U+1260 */ { 19, 0, 1, 0, 0 },
/* U+1261 */ { 19, 0, 1, 0, 0 },
/* U+1262 */ { 19, 0, 1, 0, 0 },
/* U+1263 */ { 19, 0, 1, 0, 0 },
/* U+1264 */ { 19, 0, 1, 0, 0 },
/* U+1265 */ { 19, 0, 1, 0, 0 },
/* U+1266 */ { 19, 0, 1, 0, 0 },
/* U+1267 */ { 19, 0, 1, 0, 0 },
/* U+1268 */ { 19, 0, 1, 0, 0 },
/* U+1269 */ { 19, 0, 1, 0, 0 },
/* U+126a */ { 19, 0, 1, 0, 0 },
/* U+126b */ { 19, 0, 1, 0, 0 },
/* U+126c */ { 19, 0, 1, 0, 0 },
/* U+126d */ { 19, 0, 1, 0, 0 },
/* U+126e */ { 19, 0, 1, 0, 0 },
/* U+126f */ { 19, 0, 1, 0, 0 },
/* U+1270 */ { 19, 0, 1, 0, 0 },
/* U+1271 */ { 19, 0, 1, 0, 0 },
/* U+1272 */ { 19, 0, 1, 0, 0 },
/* U+1273 */ { 19, 0, 1, 0, 0 },
/* U+1274 */ { 19, 0, 1, 0, 0 },
/* U+1275 */ { 19, 0, 1, 0, 0 },
/* U+1276 */ { 19, 0, 1, 0, 0 },
/* U+1277 */ { 19, 0, 1, 0, 0 },
/* U+1278 */ { 19, 0, 1, 0, 0 },
/* U+1279 */ { 19, 0, 1, 0, 0 },
/* U+127a */ { 19, 0, 1, 0, 0 },
/* U+127b */ { 19, 0, 1, 0, 0 },
/* U+127c */ { 19, 0, 1, 0, 0 },
/* U+127d */ { 19, 0, 1, 0, 0 },
/* U+127e */ { 19, 0, 1, 0, 0 },
/* U+127f */ { 19, 0, 1, 0, 0 },
/* U+1280 */ { 19, 0, 1, 0, 0 },
/* U+1281 */ { 19, 0, 1, 0, 0 },
/* U+1282 */ { 19, 0, 1, 0, 0 },
/* U+1283 */ { 19, 0, 1, 0, 0 },
/* U+1284 */ { 19, 0, 1, 0, 0 },
/* U+1285 */ { 19, 0, 1, 0, 0 },
/* U+1286 */ { 19, 0, 1, 0, 0 },
/* U+1287 */ { 0, 0, 0, 0, 0 },
/* U+1288 */ { 19, 0, 1, 0, 0 },
/* U+1289 */ { 0, 0, 0, 0, 0 },
/* U+128a */ { 19, 0, 1, 0, 0 },
/* U+128b */ { 19, 0, 1, 0, 0 },
/* U+128c */ { 19, 0, 1, 0, 0 },
/* U+128d */ { 19, 0, 1, 0, 0 },
/* U+128e */ { 0, 0, 0, 0, 0 },
/* U+128f */ { 0, 0, 0, 0, 0 },
/* U+1290 */ { 19, 0, 1, 0, 0 },
/* U+1291 */ { 19, 0, 1, 0, 0 },
/* U+1292 */ { 19, 0, 1, 0, 0 },
/* U+1293 */ { 19, 0, 1, 0, 0 },
/* U+1294 */ { 19, 0, 1, 0, 0 },
/* U+1295 */ { 19, 0, 1, 0, 0 },
/* U+1296 */ { 19, 0, 1, 0, 0 },
/* U+1297 */ { 19, 0, 1, 0, 0 },
/* U+1298 */ { 19, 0, 1, 0, 0 },
/* U+1299 */ { 19, 0, 1, 0, 0 },
/* U+129a */ { 19, 0, 1, 0, 0 },
/* U+129b */ { 19, 0, 1, 0, 0 },
/* U+129c */ { 19, 0, 1, 0, 0 },
/* U+129d */ { 19, 0, 1, 0, 0 },
/* U+129e */ { 19, 0, 1, 0, 0 },
/* U+129f */ { 19, 0, 1, 0, 0 },
/* U+12a0 */ { 19, 0, 1, 0, 0 },
/* U+12a1 */ { 19, 0, 1, 0, 0 },
/* U+12a2 */ { 19, 0, 1, 0, 0 },
/* U+12a3 */ { 19, 0, 1, 0, 0 },
/* U+12a4 */ { 19, 0, 1, 0, 0 },
/* U+12a5 */ { 19, 0, 1, 0, 0 },
/* U+12a6 */ { 19, 0, 1, 0, 0 },
/* U+12a7 */ { 19, 0, 1, 0, 0 },
/* U+12a8 */ { 19, 0, 1, 0, 0 },
/* U+12a9 */ { 19, 0, 1, 0, 0 },
/* U+12aa */ { 19, 0, 1, 0, 0 },
/* U+12ab */ { 19, 0, 1, 0, 0 },
/* U+12ac */ { 19, 0, 1, 0, 0 },
/* U+12ad */ { 19, 0, 1, 0, 0 },
/* U+12ae */ { 19, 0, 1, 0, 0 },
/* U+12af */ { 0, 0, 0, 0, 0 },
/* U+12b0 */ { 19, 0, 1, 0, 0 },
/* U+12b1 */ { 0, 0, 0, 0, 0 },
/* U+12b2 */ { 19, 0, 1, 0, 0 },
/* U+12b3 */ { 19, 0, 1, 0, 0 },
/* U+12b4 */ { 19, 0, 1, 0, 0 },
/* U+12b5 */ { 19, 0, 1, 0, 0 },
/* U+12b6 */ { 0, 0, 0, 0, 0 },
/* U+12b7 */ { 0, 0, 0, 0, 0 },
/* U+12b8 */ { 19, 0, 1, 0, 0 },
/* U+12b9 */ { 19, 0, 1, 0, 0 },
/* U+12ba */ { 19, 0, 1, 0, 0 },
/* U+12bb */ { 19, 0, 1, 0, 0 },
/* U+12bc */ { 19, 0, 1, 0, 0 },
/* U+12bd */ { 19, 0, 1, 0, 0 },
/* U+12be */ { 19, 0, 1, 0, 0 },
/* U+12bf */ { 0, 0, 0, 0, 0 },
/* U+12c0 */ { 19, 0, 1, 0, 0 },
/* U+12c1 */ { 0, 0, 0, 0, 0 },
/* U+12c2 */ { 19, 0, 1, 0, 0 },
/* U+12c3 */ { 19, 0, 1, 0, 0 },
/* U+12c4 */ { 19, 0, 1, 0, 0 },
/* U+12c5 */ { 19, 0, 1, 0, 0 },
/* U+12c6 */ { 0, 0, 0, 0, 0 },
/* U+12c7 */ { 0, 0, 0, 0, 0 },
/* U+12c8 */ { 19, 0, 1, 0, 0 },
/* U+12c9 */ { 19, 0, 1, 0, 0 },
/* U+12ca */ { 19, 0, 1, 0, 0 },
/* U+12cb */ { 19, 0, 1, 0, 0 },
/* U+12cc */ { 19, 0, 1, 0, 0 },
/* U+12cd */ { 19, 0, 1, 0, 0 },
/* U+12ce */ { 19, 0, 1, 0, 0 },
/* U+12cf */ { 0, 0, 0, 0, 0 },
/* U+12d0 */ { 19, 0, 1, 0, 0 },
/* U+12d1 */ { 19, 0, 1, 0, 0 },
/* U+12d2 */ { 19, 0, 1, 0, 0 },
/* U+12d3 */ { 19, 0, 1, 0, 0 },
/* U+12d4 */ { 19, 0, 1, 0, 0 },
/* U+12d5 */ { 19, 0, 1, 0, 0 },
/* U+12d6 */ { 19, 0, 1, 0, 0 },
/* U+12d7 */ { 0, 0, 0, 0, 0 },
/* U+12d8 */ { 19, 0, 1, 0, 0 },
/* U+12d9 */ { 19, 0, 1, 0, 0 },
/* U+12da */ { 19, 0, 1, 0, 0 },
/* U+12db */ { 19, 0, 1, 0, 0 },
/* U+12dc */ { 19, 0, 1, 0, 0 },
/* U+12dd */ { 19, 0, 1, 0, 0 },
/* U+12de */ { 19, 0, 1, 0, 0 },
/* U+12df */ { 19, 0, 1, 0, 0 },
/* U+12e0 */ { 19, 0, 1, 0, 0 },
/* U+12e1 */ { 19, 0, 1, 0, 0 },
/* U+12e2 */ { 19, 0, 1, 0, 0 },
/* U+12e3 */ { 19, 0, 1, 0, 0 },
/* U+12e4 */ { 19, 0, 1, 0, 0 },
/* U+12e5 */ { 19, 0, 1, 0, 0 },
/* U+12e6 */ { 19, 0, 1, 0, 0 },
/* U+12e7 */ { 19, 0, 1, 0, 0 },
/* U+12e8 */ { 19, 0, 1, 0, 0 },
/* U+12e9 */ { 19, 0, 1, 0, 0 },
/* U+12ea */ { 19, 0, 1, 0, 0 },
/* U+12eb */ { 19, 0, 1, 0, 0 },
/* U+12ec */ { 19, 0, 1, 0, 0 },
/* U+12ed */ { 19, 0, 1, 0, 0 },
/* U+12ee */ { 19, 0, 1, 0, 0 },
/* U+12ef */ { 0, 0, 0, 0, 0 },
/* U+12f0 */ { 19, 0, 1, 0, 0 },
/* U+12f1 */ { 19, 0, 1, 0, 0 },
/* U+12f2 */ { 19, 0, 1, 0, 0 },
/* U+12f3 */ { 19, 0, 1, 0, 0 },
/* U+12f4 */ { 19, 0, 1, 0, 0 },
/* U+12f5 */ { 19, 0, 1, 0, 0 },
/* U+12f6 */ { 19, 0, 1, 0, 0 },
/* U+12f7 */ { 19, 0, 1, 0, 0 },
/* U+12f8 */ { 19, 0, 1, 0, 0 },
/* U+12f9 */ { 19, 0, 1, 0, 0 },
/* U+12fa */ { 19, 0, 1, 0, 0 },
/* U+12fb */ { 19, 0, 1, 0, 0 },
/* U+12fc */ { 19, 0, 1, 0, 0 },
/* U+12fd */ { 19, 0, 1, 0, 0 },
/* U+12fe */ { 19, 0, 1, 0, 0 },
/* U+12ff */ { 19, 0, 1, 0, 0 },
/* U+1300 */ { 19, 0, 1, 0, 0 },
/* U+1301 */ { 19, 0, 1, 0, 0 },
/* U+1302 */ { 19, 0, 1, 0, 0 },
/* U+1303 */ { 19, 0, 1, 0, 0 },
/* U+1304 */ { 19, 0, 1, 0, 0 },
/* U+1305 */ { 19, 0, 1, 0, 0 },
/* U+1306 */ { 19, 0, 1, 0, 0 },
/* U+1307 */ { 19, 0, 1, 0, 0 },
/* U+1308 */ { 19, 0, 1, 0, 0 },
/* U+1309 */ { 19, 0, 1, 0, 0 },
/* U+130a */ { 19, 0, 1, 0, 0 },
/* U+130b */ { 19, 0, 1, 0, 0 },
/* U+130c */ { 19, 0, 1, 0, 0 },
/* U+130d */ { 19, 0, 1, 0, 0 },
/* U+130e */ { 19, 0, 1, 0, 0 },
/* U+130f */ { 0, 0, 0, 0, 0 },
/* U+1310 */ { 19, 0, 1, 0, 0 },
/* U+1311 */ { 0, 0, 0, 0, 0 },
/* U+1312 */ { 19, 0, 1, 0, 0 },
/* U+1313 */ { 19, 0, 1, 0, 0 },
/* U+1314 */ { 19, 0, 1, 0, 0 },
/* U+1315 */ { 19, 0, 1, 0, 0 },
/* U+1316 */ { 0, 0, 0, 0, 0 },
/* U+1317 */ { 0, 0, 0, 0, 0 },
/* U+1318 */ { 19, 0, 1, 0, 0 },
/* U+1319 */ { 19, 0, 1, 0, 0 },
/* U+131a */ { 19, 0, 1, 0, 0 },
/* U+131b */ { 19, 0, 1, 0, 0 },
/* U+131c */ { 19, 0, 1, 0, 0 },
/* U+131d */ { 19, 0, 1, 0, 0 },
/* U+131e */ { 19, 0, 1, 0, 0 },
/* U+131f */ { 0, 0, 0, 0, 0 },
/* U+1320 */ { 19, 0, 1, 0, 0 },
/* U+1321 */ { 19, 0, 1, 0, 0 },
/* U+1322 */ { 19, 0, 1, 0, 0 },
/* U+1323 */ { 19, 0, 1, 0, 0 },
/* U+1324 */ { 19, 0, 1, 0, 0 },
/* U+1325 */ { 19, 0, 1, 0, 0 },
/* U+1326 */ { 19, 0, 1, 0, 0 },
/* U+1327 */ { 19, 0, 1, 0, 0 },
/* U+1328 */ { 19, 0, 1, 0, 0 },
/* U+1329 */ { 19, 0, 1, 0, 0 },
/* U+132a */ { 19, 0, 1, 0, 0 },
/* U+132b */ { 19, 0, 1, 0, 0 },
/* U+132c */ { 19, 0, 1, 0, 0 },
/* U+132d */ { 19, 0, 1, 0, 0 },
/* U+132e */ { 19, 0, 1, 0, 0 },
/* U+132f */ { 19, 0, 1, 0, 0 },
/* U+1330 */ { 19, 0, 1, 0, 0 },
/* U+1331 */ { 19, 0, 1, 0, 0 },
/* U+1332 */ { 19, 0, 1, 0, 0 },
/* U+1333 */ { 19, 0, 1, 0, 0 },
/* U+1334 */ { 19, 0, 1, 0, 0 },
/* U+1335 */ { 19, 0, 1, 0, 0 },
/* U+1336 */ { 19, 0, 1, 0, 0 },
/* U+1337 */ { 19, 0, 1, 0, 0 },
/* U+1338 */ { 19, 0, 1, 0, 0 },
/* U+1339 */ { 19, 0, 1, 0, 0 },
/* U+133a */ { 19, 0, 1, 0, 0 },
/* U+133b */ { 19, 0, 1, 0, 0 },
/* U+133c */ { 19, 0, 1, 0, 0 },
/* U+133d */ { 19, 0, 1, 0, 0 },
/* U+133e */ { 19, 0, 1, 0, 0 },
/* U+133f */ { 19, 0, 1, 0, 0 },
/* U+1340 */ { 19, 0, 1, 0, 0 },
/* U+1341 */ { 19, 0, 1, 0, 0 },
/* U+1342 */ { 19, 0, 1, 0, 0 },
/* U+1343 */ { 19, 0, 1, 0, 0 },
/* U+1344 */ { 19, 0, 1, 0, 0 },
/* U+1345 */ { 19, 0, 1, 0, 0 },
/* U+1346 */ { 19, 0, 1, 0, 0 },
/* U+1347 */ { 0, 0, 0, 0, 0 },
/* U+1348 */ { 19, 0, 1, 0, 0 },
/* U+1349 */ { 19, 0, 1, 0, 0 },
/* U+134a */ { 19, 0, 1, 0, 0 },
/* U+134b */ { 19, 0, 1, 0, 0 },
/* U+134c */ { 19, 0, 1, 0, 0 },
/* U+134d */ { 19, 0, 1, 0, 0 },
/* U+134e */ { 19, 0, 1, 0, 0 },
/* U+134f */ { 19, 0, 1, 0, 0 },
/* U+1350 */ { 19, 0, 1, 0, 0 },
/* U+1351 */ { 19, 0, 1, 0, 0 },
/* U+1352 */ { 19, 0, 1, 0, 0 },
/* U+1353 */ { 19, 0, 1, 0, 0 },
/* U+1354 */ { 19, 0, 1, 0, 0 },
/* U+1355 */ { 19, 0, 1, 0, 0 },
/* U+1356 */ { 19, 0, 1, 0, 0 },
/* U+1357 */ { 19, 0, 1, 0, 0 },
/* U+1358 */ { 19, 0, 1, 0, 0 },
/* U+1359 */ { 19, 0, 1, 0, 0 },
/* U+135a */ { 19, 0, 1, 0, 0 },
/* U+135b */ { 0, 0, 0, 0, 0 },
/* U+135c */ { 0, 0, 0, 0, 0 },
/* U+135d */ { 0, 0, 0, 0, 0 },
/* U+135e */ { 0, 0, 0, 0, 0 },
/* U+135f */ { 0, 0, 0, 0, 0 },
/* U+1360 */ { 0, 0, 0, 0, 0 },
/* U+1361 */ { 26, 0, 1, 0, 0 },
/* U+1362 */ { 26, 0, 1, 0, 0 },
/* U+1363 */ { 26, 0, 1, 0, 0 },
/* U+1364 */ { 26, 0, 1, 0, 0 },
/* U+1365 */ { 26, 0, 1, 0, 0 },
/* U+1366 */ { 26, 0, 1, 0, 0 },
/* U+1367 */ { 26, 0, 1, 0, 0 },
/* U+1368 */ { 26, 0, 1, 0, 0 },
/* U+1369 */ { 7, 0, 1, 0, 0 },
/* U+136a */ { 7, 0, 1, 0, 0 },
/* U+136b */ { 7, 0, 1, 0, 0 },
/* U+136c */ { 7, 0, 1, 0, 0 },
/* U+136d */ { 7, 0, 1, 0, 0 },
/* U+136e */ { 7, 0, 1, 0, 0 },
/* U+136f */ { 7, 0, 1, 0, 0 },
/* U+1370 */ { 7, 0, 1, 0, 0 },
/* U+1371 */ { 7, 0, 1, 0, 0 },
/* U+1372 */ { 9, 0, 1, 0, 0 },
/* U+1373 */ { 9, 0, 1, 0, 0 },
/* U+1374 */ { 9, 0, 1, 0, 0 },
/* U+1375 */ { 9, 0, 1, 0, 0 },
/* U+1376 */ { 9, 0, 1, 0, 0 },
/* U+1377 */ { 9, 0, 1, 0, 0 },
/* U+1378 */ { 9, 0, 1, 0, 0 },
/* U+1379 */ { 9, 0, 1, 0, 0 },
/* U+137a */ { 9, 0, 1, 0, 0 },
/* U+137b */ { 9, 0, 1, 0, 0 },
/* U+137c */ { 9, 0, 1, 0, 0 },
/* U+137d */ { 0, 0, 0, 0, 0 },
/* U+137e */ { 0, 0, 0, 0, 0 },
/* U+137f */ { 0, 0, 0, 0, 0 },
/* U+1380 */ { 0, 0, 0, 0, 0 },
/* U+1381 */ { 0, 0, 0, 0, 0 },
/* U+1382 */ { 0, 0, 0, 0, 0 },
/* U+1383 */ { 0, 0, 0, 0, 0 },
/* U+1384 */ { 0, 0, 0, 0, 0 },
/* U+1385 */ { 0, 0, 0, 0, 0 },
/* U+1386 */ { 0, 0, 0, 0, 0 },
/* U+1387 */ { 0, 0, 0, 0, 0 },
/* U+1388 */ { 0, 0, 0, 0, 0 },
/* U+1389 */ { 0, 0, 0, 0, 0 },
/* U+138a */ { 0, 0, 0, 0, 0 },
/* U+138b */ { 0, 0, 0, 0, 0 },
/* U+138c */ { 0, 0, 0, 0, 0 },
/* U+138d */ { 0, 0, 0, 0, 0 },
/* U+138e */ { 0, 0, 0, 0, 0 },
/* U+138f */ { 0, 0, 0, 0, 0 },
/* U+1390 */ { 0, 0, 0, 0, 0 },
/* U+1391 */ { 0, 0, 0, 0, 0 },
/* U+1392 */ { 0, 0, 0, 0, 0 },
/* U+1393 */ { 0, 0, 0, 0, 0 },
/* U+1394 */ { 0, 0, 0, 0, 0 },
/* U+1395 */ { 0, 0, 0, 0, 0 },
/* U+1396 */ { 0, 0, 0, 0, 0 },
/* U+1397 */ { 0, 0, 0, 0, 0 },
/* U+1398 */ { 0, 0, 0, 0, 0 },
/* U+1399 */ { 0, 0, 0, 0, 0 },
/* U+139a */ { 0, 0, 0, 0, 0 },
/* U+139b */ { 0, 0, 0, 0, 0 },
/* U+139c */ { 0, 0, 0, 0, 0 },
/* U+139d */ { 0, 0, 0, 0, 0 },
/* U+139e */ { 0, 0, 0, 0, 0 },
/* U+139f */ { 0, 0, 0, 0, 0 },
/* U+13a0 */ { 19, 0, 1, 0, 0 },
/* U+13a1 */ { 19, 0, 1, 0, 0 },
/* U+13a2 */ { 19, 0, 1, 0, 0 },
/* U+13a3 */ { 19, 0, 1, 0, 0 },
/* U+13a4 */ { 19, 0, 1, 0, 0 },
/* U+13a5 */ { 19, 0, 1, 0, 0 },
/* U+13a6 */ { 19, 0, 1, 0, 0 },
/* U+13a7 */ { 19, 0, 1, 0, 0 },
/* U+13a8 */ { 19, 0, 1, 0, 0 },
/* U+13a9 */ { 19, 0, 1, 0, 0 },
/* U+13aa */ { 19, 0, 1, 0, 0 },
/* U+13ab */ { 19, 0, 1, 0, 0 },
/* U+13ac */ { 19, 0, 1, 0, 0 },
/* U+13ad */ { 19, 0, 1, 0, 0 },
/* U+13ae */ { 19, 0, 1, 0, 0 },
/* U+13af */ { 19, 0, 1, 0, 0 },
/* U+13b0 */ { 19, 0, 1, 0, 0 },
/* U+13b1 */ { 19, 0, 1, 0, 0 },
/* U+13b2 */ { 19, 0, 1, 0, 0 },
/* U+13b3 */ { 19, 0, 1, 0, 0 },
/* U+13b4 */ { 19, 0, 1, 0, 0 },
/* U+13b5 */ { 19, 0, 1, 0, 0 },
/* U+13b6 */ { 19, 0, 1, 0, 0 },
/* U+13b7 */ { 19, 0, 1, 0, 0 },
/* U+13b8 */ { 19, 0, 1, 0, 0 },
/* U+13b9 */ { 19, 0, 1, 0, 0 },
/* U+13ba */ { 19, 0, 1, 0, 0 },
/* U+13bb */ { 19, 0, 1, 0, 0 },
/* U+13bc */ { 19, 0, 1, 0, 0 },
/* U+13bd */ { 19, 0, 1, 0, 0 },
/* U+13be */ { 19, 0, 1, 0, 0 },
/* U+13bf */ { 19, 0, 1, 0, 0 },
/* U+13c0 */ { 19, 0, 1, 0, 0 },
/* U+13c1 */ { 19, 0, 1, 0, 0 },
/* U+13c2 */ { 19, 0, 1, 0, 0 },
/* U+13c3 */ { 19, 0, 1, 0, 0 },
/* U+13c4 */ { 19, 0, 1, 0, 0 },
/* U+13c5 */ { 19, 0, 1, 0, 0 },
/* U+13c6 */ { 19, 0, 1, 0, 0 },
/* U+13c7 */ { 19, 0, 1, 0, 0 },
/* U+13c8 */ { 19, 0, 1, 0, 0 },
/* U+13c9 */ { 19, 0, 1, 0, 0 },
/* U+13ca */ { 19, 0, 1, 0, 0 },
/* U+13cb */ { 19, 0, 1, 0, 0 },
/* U+13cc */ { 19, 0, 1, 0, 0 },
/* U+13cd */ { 19, 0, 1, 0, 0 },
/* U+13ce */ { 19, 0, 1, 0, 0 },
/* U+13cf */ { 19, 0, 1, 0, 0 },
/* U+13d0 */ { 19, 0, 1, 0, 0 },
/* U+13d1 */ { 19, 0, 1, 0, 0 },
/* U+13d2 */ { 19, 0, 1, 0, 0 },
/* U+13d3 */ { 19, 0, 1, 0, 0 },
/* U+13d4 */ { 19, 0, 1, 0, 0 },
/* U+13d5 */ { 19, 0, 1, 0, 0 },
/* U+13d6 */ { 19, 0, 1, 0, 0 },
/* U+13d7 */ { 19, 0, 1, 0, 0 },
/* U+13d8 */ { 19, 0, 1, 0, 0 },
/* U+13d9 */ { 19, 0, 1, 0, 0 },
/* U+13da */ { 19, 0, 1, 0, 0 },
/* U+13db */ { 19, 0, 1, 0, 0 },
/* U+13dc */ { 19, 0, 1, 0, 0 },
/* U+13dd */ { 19, 0, 1, 0, 0 },
/* U+13de */ { 19, 0, 1, 0, 0 },
/* U+13df */ { 19, 0, 1, 0, 0 },
/* U+13e0 */ { 19, 0, 1, 0, 0 },
/* U+13e1 */ { 19, 0, 1, 0, 0 },
/* U+13e2 */ { 19, 0, 1, 0, 0 },
/* U+13e3 */ { 19, 0, 1, 0, 0 },
/* U+13e4 */ { 19, 0, 1, 0, 0 },
/* U+13e5 */ { 19, 0, 1, 0, 0 },
/* U+13e6 */ { 19, 0, 1, 0, 0 },
/* U+13e7 */ { 19, 0, 1, 0, 0 },
/* U+13e8 */ { 19, 0, 1, 0, 0 },
/* U+13e9 */ { 19, 0, 1, 0, 0 },
/* U+13ea */ { 19, 0, 1, 0, 0 },
/* U+13eb */ { 19, 0, 1, 0, 0 },
/* U+13ec */ { 19, 0, 1, 0, 0 },
/* U+13ed */ { 19, 0, 1, 0, 0 },
/* U+13ee */ { 19, 0, 1, 0, 0 },
/* U+13ef */ { 19, 0, 1, 0, 0 },
/* U+13f0 */ { 19, 0, 1, 0, 0 },
/* U+13f1 */ { 19, 0, 1, 0, 0 },
/* U+13f2 */ { 19, 0, 1, 0, 0 },
/* U+13f3 */ { 19, 0, 1, 0, 0 },
/* U+13f4 */ { 19, 0, 1, 0, 0 },
/* U+13f5 */ { 0, 0, 0, 0, 0 },
/* U+13f6 */ { 0, 0, 0, 0, 0 },
/* U+13f7 */ { 0, 0, 0, 0, 0 },
/* U+13f8 */ { 0, 0, 0, 0, 0 },
/* U+13f9 */ { 0, 0, 0, 0, 0 },
/* U+13fa */ { 0, 0, 0, 0, 0 },
/* U+13fb */ { 0, 0, 0, 0, 0 },
/* U+13fc */ { 0, 0, 0, 0, 0 },
/* U+13fd */ { 0, 0, 0, 0, 0 },
/* U+13fe */ { 0, 0, 0, 0, 0 },
/* U+13ff */ { 0, 0, 0, 0, 0 },
/* U+1400 */ { 0, 0, 0, 0, 0 },
/* U+1401 */ { 19, 0, 1, 0, 0 },
/* U+1402 */ { 19, 0, 1, 0, 0 },
/* U+1403 */ { 19, 0, 1, 0, 0 },
/* U+1404 */ { 19, 0, 1, 0, 0 },
/* U+1405 */ { 19, 0, 1, 0, 0 },
/* U+1406 */ { 19, 0, 1, 0, 0 },
/* U+1407 */ { 19, 0, 1, 0, 0 },
/* U+1408 */ { 19, 0, 1, 0, 0 },
/* U+1409 */ { 19, 0, 1, 0, 0 },
/* U+140a */ { 19, 0, 1, 0, 0 },
/* U+140b */ { 19, 0, 1, 0, 0 },
/* U+140c */ { 19, 0, 1, 0, 0 },
/* U+140d */ { 19, 0, 1, 0, 0 },
/* U+140e */ { 19, 0, 1, 0, 0 },
/* U+140f */ { 19, 0, 1, 0, 0 },
/* U+1410 */ { 19, 0, 1, 0, 0 },
/* U+1411 */ { 19, 0, 1, 0, 0 },
/* U+1412 */ { 19, 0, 1, 0, 0 },
/* U+1413 */ { 19, 0, 1, 0, 0 },
/* U+1414 */ { 19, 0, 1, 0, 0 },
/* U+1415 */ { 19, 0, 1, 0, 0 },
/* U+1416 */ { 19, 0, 1, 0, 0 },
/* U+1417 */ { 19, 0, 1, 0, 0 },
/* U+1418 */ { 19, 0, 1, 0, 0 },
/* U+1419 */ { 19, 0, 1, 0, 0 },
/* U+141a */ { 19, 0, 1, 0, 0 },
/* U+141b */ { 19, 0, 1, 0, 0 },
/* U+141c */ { 19, 0, 1, 0, 0 },
/* U+141d */ { 19, 0, 1, 0, 0 },
/* U+141e */ { 19, 0, 1, 0, 0 },
/* U+141f */ { 19, 0, 1, 0, 0 },
/* U+1420 */ { 19, 0, 1, 0, 0 },
/* U+1421 */ { 19, 0, 1, 0, 0 },
/* U+1422 */ { 19, 0, 1, 0, 0 },
/* U+1423 */ { 19, 0, 1, 0, 0 },
/* U+1424 */ { 19, 0, 1, 0, 0 },
/* U+1425 */ { 19, 0, 1, 0, 0 },
/* U+1426 */ { 19, 0, 1, 0, 0 },
/* U+1427 */ { 19, 0, 1, 0, 0 },
/* U+1428 */ { 19, 0, 1, 0, 0 },
/* U+1429 */ { 19, 0, 1, 0, 0 },
/* U+142a */ { 19, 0, 1, 0, 0 },
/* U+142b */ { 19, 0, 1, 0, 0 },
/* U+142c */ { 19, 0, 1, 0, 0 },
/* U+142d */ { 19, 0, 1, 0, 0 },
/* U+142e */ { 19, 0, 1, 0, 0 },
/* U+142f */ { 19, 0, 1, 0, 0 },
/* U+1430 */ { 19, 0, 1, 0, 0 },
/* U+1431 */ { 19, 0, 1, 0, 0 },
/* U+1432 */ { 19, 0, 1, 0, 0 },
/* U+1433 */ { 19, 0, 1, 0, 0 },
/* U+1434 */ { 19, 0, 1, 0, 0 },
/* U+1435 */ { 19, 0, 1, 0, 0 },
/* U+1436 */ { 19, 0, 1, 0, 0 },
/* U+1437 */ { 19, 0, 1, 0, 0 },
/* U+1438 */ { 19, 0, 1, 0, 0 },
/* U+1439 */ { 19, 0, 1, 0, 0 },
/* U+143a */ { 19, 0, 1, 0, 0 },
/* U+143b */ { 19, 0, 1, 0, 0 },
/* U+143c */ { 19, 0, 1, 0, 0 },
/* U+143d */ { 19, 0, 1, 0, 0 },
/* U+143e */ { 19, 0, 1, 0, 0 },
/* U+143f */ { 19, 0, 1, 0, 0 },
/* U+1440 */ { 19, 0, 1, 0, 0 },
/* U+1441 */ { 19, 0, 1, 0, 0 },
/* U+1442 */ { 19, 0, 1, 0, 0 },
/* U+1443 */ { 19, 0, 1, 0, 0 },
/* U+1444 */ { 19, 0, 1, 0, 0 },
/* U+1445 */ { 19, 0, 1, 0, 0 },
/* U+1446 */ { 19, 0, 1, 0, 0 },
/* U+1447 */ { 19, 0, 1, 0, 0 },
/* U+1448 */ { 19, 0, 1, 0, 0 },
/* U+1449 */ { 19, 0, 1, 0, 0 },
/* U+144a */ { 19, 0, 1, 0, 0 },
/* U+144b */ { 19, 0, 1, 0, 0 },
/* U+144c */ { 19, 0, 1, 0, 0 },
/* U+144d */ { 19, 0, 1, 0, 0 },
/* U+144e */ { 19, 0, 1, 0, 0 },
/* U+144f */ { 19, 0, 1, 0, 0 },
/* U+1450 */ { 19, 0, 1, 0, 0 },
/* U+1451 */ { 19, 0, 1, 0, 0 },
/* U+1452 */ { 19, 0, 1, 0, 0 },
/* U+1453 */ { 19, 0, 1, 0, 0 },
/* U+1454 */ { 19, 0, 1, 0, 0 },
/* U+1455 */ { 19, 0, 1, 0, 0 },
/* U+1456 */ { 19, 0, 1, 0, 0 },
/* U+1457 */ { 19, 0, 1, 0, 0 },
/* U+1458 */ { 19, 0, 1, 0, 0 },
/* U+1459 */ { 19, 0, 1, 0, 0 },
/* U+145a */ { 19, 0, 1, 0, 0 },
/* U+145b */ { 19, 0, 1, 0, 0 },
/* U+145c */ { 19, 0, 1, 0, 0 },
/* U+145d */ { 19, 0, 1, 0, 0 },
/* U+145e */ { 19, 0, 1, 0, 0 },
/* U+145f */ { 19, 0, 1, 0, 0 },
/* U+1460 */ { 19, 0, 1, 0, 0 },
/* U+1461 */ { 19, 0, 1, 0, 0 },
/* U+1462 */ { 19, 0, 1, 0, 0 },
/* U+1463 */ { 19, 0, 1, 0, 0 },
/* U+1464 */ { 19, 0, 1, 0, 0 },
/* U+1465 */ { 19, 0, 1, 0, 0 },
/* U+1466 */ { 19, 0, 1, 0, 0 },
/* U+1467 */ { 19, 0, 1, 0, 0 },
/* U+1468 */ { 19, 0, 1, 0, 0 },
/* U+1469 */ { 19, 0, 1, 0, 0 },
/* U+146a */ { 19, 0, 1, 0, 0 },
/* U+146b */ { 19, 0, 1, 0, 0 },
/* U+146c */ { 19, 0, 1, 0, 0 },
/* U+146d */ { 19, 0, 1, 0, 0 },
/* U+146e */ { 19, 0, 1, 0, 0 },
/* U+146f */ { 19, 0, 1, 0, 0 },
/* U+1470 */ { 19, 0, 1, 0, 0 },
/* U+1471 */ { 19, 0, 1, 0, 0 },
/* U+1472 */ { 19, 0, 1, 0, 0 },
/* U+1473 */ { 19, 0, 1, 0, 0 },
/* U+1474 */ { 19, 0, 1, 0, 0 },
/* U+1475 */ { 19, 0, 1, 0, 0 },
/* U+1476 */ { 19, 0, 1, 0, 0 },
/* U+1477 */ { 19, 0, 1, 0, 0 },
/* U+1478 */ { 19, 0, 1, 0, 0 },
/* U+1479 */ { 19, 0, 1, 0, 0 },
/* U+147a */ { 19, 0, 1, 0, 0 },
/* U+147b */ { 19, 0, 1, 0, 0 },
/* U+147c */ { 19, 0, 1, 0, 0 },
/* U+147d */ { 19, 0, 1, 0, 0 },
/* U+147e */ { 19, 0, 1, 0, 0 },
/* U+147f */ { 19, 0, 1, 0, 0 },
/* U+1480 */ { 19, 0, 1, 0, 0 },
/* U+1481 */ { 19, 0, 1, 0, 0 },
/* U+1482 */ { 19, 0, 1, 0, 0 },
/* U+1483 */ { 19, 0, 1, 0, 0 },
/* U+1484 */ { 19, 0, 1, 0, 0 },
/* U+1485 */ { 19, 0, 1, 0, 0 },
/* U+1486 */ { 19, 0, 1, 0, 0 },
/* U+1487 */ { 19, 0, 1, 0, 0 },
/* U+1488 */ { 19, 0, 1, 0, 0 },
/* U+1489 */ { 19, 0, 1, 0, 0 },
/* U+148a */ { 19, 0, 1, 0, 0 },
/* U+148b */ { 19, 0, 1, 0, 0 },
/* U+148c */ { 19, 0, 1, 0, 0 },
/* U+148d */ { 19, 0, 1, 0, 0 },
/* U+148e */ { 19, 0, 1, 0, 0 },
/* U+148f */ { 19, 0, 1, 0, 0 },
/* U+1490 */ { 19, 0, 1, 0, 0 },
/* U+1491 */ { 19, 0, 1, 0, 0 },
/* U+1492 */ { 19, 0, 1, 0, 0 },
/* U+1493 */ { 19, 0, 1, 0, 0 },
/* U+1494 */ { 19, 0, 1, 0, 0 },
/* U+1495 */ { 19, 0, 1, 0, 0 },
/* U+1496 */ { 19, 0, 1, 0, 0 },
/* U+1497 */ { 19, 0, 1, 0, 0 },
/* U+1498 */ { 19, 0, 1, 0, 0 },
/* U+1499 */ { 19, 0, 1, 0, 0 },
/* U+149a */ { 19, 0, 1, 0, 0 },
/* U+149b */ { 19, 0, 1, 0, 0 },
/* U+149c */ { 19, 0, 1, 0, 0 },
/* U+149d */ { 19, 0, 1, 0, 0 },
/* U+149e */ { 19, 0, 1, 0, 0 },
/* U+149f */ { 19, 0, 1, 0, 0 },
/* U+14a0 */ { 19, 0, 1, 0, 0 },
/* U+14a1 */ { 19, 0, 1, 0, 0 },
/* U+14a2 */ { 19, 0, 1, 0, 0 },
/* U+14a3 */ { 19, 0, 1, 0, 0 },
/* U+14a4 */ { 19, 0, 1, 0, 0 },
/* U+14a5 */ { 19, 0, 1, 0, 0 },
/* U+14a6 */ { 19, 0, 1, 0, 0 },
/* U+14a7 */ { 19, 0, 1, 0, 0 },
/* U+14a8 */ { 19, 0, 1, 0, 0 },
/* U+14a9 */ { 19, 0, 1, 0, 0 },
/* U+14aa */ { 19, 0, 1, 0, 0 },
/* U+14ab */ { 19, 0, 1, 0, 0 },
/* U+14ac */ { 19, 0, 1, 0, 0 },
/* U+14ad */ { 19, 0, 1, 0, 0 },
/* U+14ae */ { 19, 0, 1, 0, 0 },
/* U+14af */ { 19, 0, 1, 0, 0 },
/* U+14b0 */ { 19, 0, 1, 0, 0 },
/* U+14b1 */ { 19, 0, 1, 0, 0 },
/* U+14b2 */ { 19, 0, 1, 0, 0 },
/* U+14b3 */ { 19, 0, 1, 0, 0 },
/* U+14b4 */ { 19, 0, 1, 0, 0 },
/* U+14b5 */ { 19, 0, 1, 0, 0 },
/* U+14b6 */ { 19, 0, 1, 0, 0 },
/* U+14b7 */ { 19, 0, 1, 0, 0 },
/* U+14b8 */ { 19, 0, 1, 0, 0 },
/* U+14b9 */ { 19, 0, 1, 0, 0 },
/* U+14ba */ { 19, 0, 1, 0, 0 },
/* U+14bb */ { 19, 0, 1, 0, 0 },
/* U+14bc */ { 19, 0, 1, 0, 0 },
/* U+14bd */ { 19, 0, 1, 0, 0 },
/* U+14be */ { 19, 0, 1, 0, 0 },
/* U+14bf */ { 19, 0, 1, 0, 0 },
/* U+14c0 */ { 19, 0, 1, 0, 0 },
/* U+14c1 */ { 19, 0, 1, 0, 0 },
/* U+14c2 */ { 19, 0, 1, 0, 0 },
/* U+14c3 */ { 19, 0, 1, 0, 0 },
/* U+14c4 */ { 19, 0, 1, 0, 0 },
/* U+14c5 */ { 19, 0, 1, 0, 0 },
/* U+14c6 */ { 19, 0, 1, 0, 0 },
/* U+14c7 */ { 19, 0, 1, 0, 0 },
/* U+14c8 */ { 19, 0, 1, 0, 0 },
/* U+14c9 */ { 19, 0, 1, 0, 0 },
/* U+14ca */ { 19, 0, 1, 0, 0 },
/* U+14cb */ { 19, 0, 1, 0, 0 },
/* U+14cc */ { 19, 0, 1, 0, 0 },
/* U+14cd */ { 19, 0, 1, 0, 0 },
/* U+14ce */ { 19, 0, 1, 0, 0 },
/* U+14cf */ { 19, 0, 1, 0, 0 },
/* U+14d0 */ { 19, 0, 1, 0, 0 },
/* U+14d1 */ { 19, 0, 1, 0, 0 },
/* U+14d2 */ { 19, 0, 1, 0, 0 },
/* U+14d3 */ { 19, 0, 1, 0, 0 },
/* U+14d4 */ { 19, 0, 1, 0, 0 },
/* U+14d5 */ { 19, 0, 1, 0, 0 },
/* U+14d6 */ { 19, 0, 1, 0, 0 },
/* U+14d7 */ { 19, 0, 1, 0, 0 },
/* U+14d8 */ { 19, 0, 1, 0, 0 },
/* U+14d9 */ { 19, 0, 1, 0, 0 },
/* U+14da */ { 19, 0, 1, 0, 0 },
/* U+14db */ { 19, 0, 1, 0, 0 },
/* U+14dc */ { 19, 0, 1, 0, 0 },
/* U+14dd */ { 19, 0, 1, 0, 0 },
/* U+14de */ { 19, 0, 1, 0, 0 },
/* U+14df */ { 19, 0, 1, 0, 0 },
/* U+14e0 */ { 19, 0, 1, 0, 0 },
/* U+14e1 */ { 19, 0, 1, 0, 0 },
/* U+14e2 */ { 19, 0, 1, 0, 0 },
/* U+14e3 */ { 19, 0, 1, 0, 0 },
/* U+14e4 */ { 19, 0, 1, 0, 0 },
/* U+14e5 */ { 19, 0, 1, 0, 0 },
/* U+14e6 */ { 19, 0, 1, 0, 0 },
/* U+14e7 */ { 19, 0, 1, 0, 0 },
/* U+14e8 */ { 19, 0, 1, 0, 0 },
/* U+14e9 */ { 19, 0, 1, 0, 0 },
/* U+14ea */ { 19, 0, 1, 0, 0 },
/* U+14eb */ { 19, 0, 1, 0, 0 },
/* U+14ec */ { 19, 0, 1, 0, 0 },
/* U+14ed */ { 19, 0, 1, 0, 0 },
/* U+14ee */ { 19, 0, 1, 0, 0 },
/* U+14ef */ { 19, 0, 1, 0, 0 },
/* U+14f0 */ { 19, 0, 1, 0, 0 },
/* U+14f1 */ { 19, 0, 1, 0, 0 },
/* U+14f2 */ { 19, 0, 1, 0, 0 },
/* U+14f3 */ { 19, 0, 1, 0, 0 },
/* U+14f4 */ { 19, 0, 1, 0, 0 },
/* U+14f5 */ { 19, 0, 1, 0, 0 },
/* U+14f6 */ { 19, 0, 1, 0, 0 },
/* U+14f7 */ { 19, 0, 1, 0, 0 },
/* U+14f8 */ { 19, 0, 1, 0, 0 },
/* U+14f9 */ { 19, 0, 1, 0, 0 },
/* U+14fa */ { 19, 0, 1, 0, 0 },
/* U+14fb */ { 19, 0, 1, 0, 0 },
/* U+14fc */ { 19, 0, 1, 0, 0 },
/* U+14fd */ { 19, 0, 1, 0, 0 },
/* U+14fe */ { 19, 0, 1, 0, 0 },
/* U+14ff */ { 19, 0, 1, 0, 0 },
/* U+1500 */ { 19, 0, 1, 0, 0 },
/* U+1501 */ { 19, 0, 1, 0, 0 },
/* U+1502 */ { 19, 0, 1, 0, 0 },
/* U+1503 */ { 19, 0, 1, 0, 0 },
/* U+1504 */ { 19, 0, 1, 0, 0 },
/* U+1505 */ { 19, 0, 1, 0, 0 },
/* U+1506 */ { 19, 0, 1, 0, 0 },
/* U+1507 */ { 19, 0, 1, 0, 0 },
/* U+1508 */ { 19, 0, 1, 0, 0 },
/* U+1509 */ { 19, 0, 1, 0, 0 },
/* U+150a */ { 19, 0, 1, 0, 0 },
/* U+150b */ { 19, 0, 1, 0, 0 },
/* U+150c */ { 19, 0, 1, 0, 0 },
/* U+150d */ { 19, 0, 1, 0, 0 },
/* U+150e */ { 19, 0, 1, 0, 0 },
/* U+150f */ { 19, 0, 1, 0, 0 },
/* U+1510 */ { 19, 0, 1, 0, 0 },
/* U+1511 */ { 19, 0, 1, 0, 0 },
/* U+1512 */ { 19, 0, 1, 0, 0 },
/* U+1513 */ { 19, 0, 1, 0, 0 },
/* U+1514 */ { 19, 0, 1, 0, 0 },
/* U+1515 */ { 19, 0, 1, 0, 0 },
/* U+1516 */ { 19, 0, 1, 0, 0 },
/* U+1517 */ { 19, 0, 1, 0, 0 },
/* U+1518 */ { 19, 0, 1, 0, 0 },
/* U+1519 */ { 19, 0, 1, 0, 0 },
/* U+151a */ { 19, 0, 1, 0, 0 },
/* U+151b */ { 19, 0, 1, 0, 0 },
/* U+151c */ { 19, 0, 1, 0, 0 },
/* U+151d */ { 19, 0, 1, 0, 0 },
/* U+151e */ { 19, 0, 1, 0, 0 },
/* U+151f */ { 19, 0, 1, 0, 0 },
/* U+1520 */ { 19, 0, 1, 0, 0 },
/* U+1521 */ { 19, 0, 1, 0, 0 },
/* U+1522 */ { 19, 0, 1, 0, 0 },
/* U+1523 */ { 19, 0, 1, 0, 0 },
/* U+1524 */ { 19, 0, 1, 0, 0 },
/* U+1525 */ { 19, 0, 1, 0, 0 },
/* U+1526 */ { 19, 0, 1, 0, 0 },
/* U+1527 */ { 19, 0, 1, 0, 0 },
/* U+1528 */ { 19, 0, 1, 0, 0 },
/* U+1529 */ { 19, 0, 1, 0, 0 },
/* U+152a */ { 19, 0, 1, 0, 0 },
/* U+152b */ { 19, 0, 1, 0, 0 },
/* U+152c */ { 19, 0, 1, 0, 0 },
/* U+152d */ { 19, 0, 1, 0, 0 },
/* U+152e */ { 19, 0, 1, 0, 0 },
/* U+152f */ { 19, 0, 1, 0, 0 },
/* U+1530 */ { 19, 0, 1, 0, 0 },
/* U+1531 */ { 19, 0, 1, 0, 0 },
/* U+1532 */ { 19, 0, 1, 0, 0 },
/* U+1533 */ { 19, 0, 1, 0, 0 },
/* U+1534 */ { 19, 0, 1, 0, 0 },
/* U+1535 */ { 19, 0, 1, 0, 0 },
/* U+1536 */ { 19, 0, 1, 0, 0 },
/* U+1537 */ { 19, 0, 1, 0, 0 },
/* U+1538 */ { 19, 0, 1, 0, 0 },
/* U+1539 */ { 19, 0, 1, 0, 0 },
/* U+153a */ { 19, 0, 1, 0, 0 },
/* U+153b */ { 19, 0, 1, 0, 0 },
/* U+153c */ { 19, 0, 1, 0, 0 },
/* U+153d */ { 19, 0, 1, 0, 0 },
/* U+153e */ { 19, 0, 1, 0, 0 },
/* U+153f */ { 19, 0, 1, 0, 0 },
/* U+1540 */ { 19, 0, 1, 0, 0 },
/* U+1541 */ { 19, 0, 1, 0, 0 },
/* U+1542 */ { 19, 0, 1, 0, 0 },
/* U+1543 */ { 19, 0, 1, 0, 0 },
/* U+1544 */ { 19, 0, 1, 0, 0 },
/* U+1545 */ { 19, 0, 1, 0, 0 },
/* U+1546 */ { 19, 0, 1, 0, 0 },
/* U+1547 */ { 19, 0, 1, 0, 0 },
/* U+1548 */ { 19, 0, 1, 0, 0 },
/* U+1549 */ { 19, 0, 1, 0, 0 },
/* U+154a */ { 19, 0, 1, 0, 0 },
/* U+154b */ { 19, 0, 1, 0, 0 },
/* U+154c */ { 19, 0, 1, 0, 0 },
/* U+154d */ { 19, 0, 1, 0, 0 },
/* U+154e */ { 19, 0, 1, 0, 0 },
/* U+154f */ { 19, 0, 1, 0, 0 },
/* U+1550 */ { 19, 0, 1, 0, 0 },
/* U+1551 */ { 19, 0, 1, 0, 0 },
/* U+1552 */ { 19, 0, 1, 0, 0 },
/* U+1553 */ { 19, 0, 1, 0, 0 },
/* U+1554 */ { 19, 0, 1, 0, 0 },
/* U+1555 */ { 19, 0, 1, 0, 0 },
/* U+1556 */ { 19, 0, 1, 0, 0 },
/* U+1557 */ { 19, 0, 1, 0, 0 },
/* U+1558 */ { 19, 0, 1, 0, 0 },
/* U+1559 */ { 19, 0, 1, 0, 0 },
/* U+155a */ { 19, 0, 1, 0, 0 },
/* U+155b */ { 19, 0, 1, 0, 0 },
/* U+155c */ { 19, 0, 1, 0, 0 },
/* U+155d */ { 19, 0, 1, 0, 0 },
/* U+155e */ { 19, 0, 1, 0, 0 },
/* U+155f */ { 19, 0, 1, 0, 0 },
/* U+1560 */ { 19, 0, 1, 0, 0 },
/* U+1561 */ { 19, 0, 1, 0, 0 },
/* U+1562 */ { 19, 0, 1, 0, 0 },
/* U+1563 */ { 19, 0, 1, 0, 0 },
/* U+1564 */ { 19, 0, 1, 0, 0 },
/* U+1565 */ { 19, 0, 1, 0, 0 },
/* U+1566 */ { 19, 0, 1, 0, 0 },
/* U+1567 */ { 19, 0, 1, 0, 0 },
/* U+1568 */ { 19, 0, 1, 0, 0 },
/* U+1569 */ { 19, 0, 1, 0, 0 },
/* U+156a */ { 19, 0, 1, 0, 0 },
/* U+156b */ { 19, 0, 1, 0, 0 },
/* U+156c */ { 19, 0, 1, 0, 0 },
/* U+156d */ { 19, 0, 1, 0, 0 },
/* U+156e */ { 19, 0, 1, 0, 0 },
/* U+156f */ { 19, 0, 1, 0, 0 },
/* U+1570 */ { 19, 0, 1, 0, 0 },
/* U+1571 */ { 19, 0, 1, 0, 0 },
/* U+1572 */ { 19, 0, 1, 0, 0 },
/* U+1573 */ { 19, 0, 1, 0, 0 },
/* U+1574 */ { 19, 0, 1, 0, 0 },
/* U+1575 */ { 19, 0, 1, 0, 0 },
/* U+1576 */ { 19, 0, 1, 0, 0 },
/* U+1577 */ { 19, 0, 1, 0, 0 },
/* U+1578 */ { 19, 0, 1, 0, 0 },
/* U+1579 */ { 19, 0, 1, 0, 0 },
/* U+157a */ { 19, 0, 1, 0, 0 },
/* U+157b */ { 19, 0, 1, 0, 0 },
/* U+157c */ { 19, 0, 1, 0, 0 },
/* U+157d */ { 19, 0, 1, 0, 0 },
/* U+157e */ { 19, 0, 1, 0, 0 },
/* U+157f */ { 19, 0, 1, 0, 0 },
/* U+1580 */ { 19, 0, 1, 0, 0 },
/* U+1581 */ { 19, 0, 1, 0, 0 },
/* U+1582 */ { 19, 0, 1, 0, 0 },
/* U+1583 */ { 19, 0, 1, 0, 0 },
/* U+1584 */ { 19, 0, 1, 0, 0 },
/* U+1585 */ { 19, 0, 1, 0, 0 },
/* U+1586 */ { 19, 0, 1, 0, 0 },
/* U+1587 */ { 19, 0, 1, 0, 0 },
/* U+1588 */ { 19, 0, 1, 0, 0 },
/* U+1589 */ { 19, 0, 1, 0, 0 },
/* U+158a */ { 19, 0, 1, 0, 0 },
/* U+158b */ { 19, 0, 1, 0, 0 },
/* U+158c */ { 19, 0, 1, 0, 0 },
/* U+158d */ { 19, 0, 1, 0, 0 },
/* U+158e */ { 19, 0, 1, 0, 0 },
/* U+158f */ { 19, 0, 1, 0, 0 },
/* U+1590 */ { 19, 0, 1, 0, 0 },
/* U+1591 */ { 19, 0, 1, 0, 0 },
/* U+1592 */ { 19, 0, 1, 0, 0 },
/* U+1593 */ { 19, 0, 1, 0, 0 },
/* U+1594 */ { 19, 0, 1, 0, 0 },
/* U+1595 */ { 19, 0, 1, 0, 0 },
/* U+1596 */ { 19, 0, 1, 0, 0 },
/* U+1597 */ { 19, 0, 1, 0, 0 },
/* U+1598 */ { 19, 0, 1, 0, 0 },
/* U+1599 */ { 19, 0, 1, 0, 0 },
/* U+159a */ { 19, 0, 1, 0, 0 },
/* U+159b */ { 19, 0, 1, 0, 0 },
/* U+159c */ { 19, 0, 1, 0, 0 },
/* U+159d */ { 19, 0, 1, 0, 0 },
/* U+159e */ { 19, 0, 1, 0, 0 },
/* U+159f */ { 19, 0, 1, 0, 0 },
/* U+15a0 */ { 19, 0, 1, 0, 0 },
/* U+15a1 */ { 19, 0, 1, 0, 0 },
/* U+15a2 */ { 19, 0, 1, 0, 0 },
/* U+15a3 */ { 19, 0, 1, 0, 0 },
/* U+15a4 */ { 19, 0, 1, 0, 0 },
/* U+15a5 */ { 19, 0, 1, 0, 0 },
/* U+15a6 */ { 19, 0, 1, 0, 0 },
/* U+15a7 */ { 19, 0, 1, 0, 0 },
/* U+15a8 */ { 19, 0, 1, 0, 0 },
/* U+15a9 */ { 19, 0, 1, 0, 0 },
/* U+15aa */ { 19, 0, 1, 0, 0 },
/* U+15ab */ { 19, 0, 1, 0, 0 },
/* U+15ac */ { 19, 0, 1, 0, 0 },
/* U+15ad */ { 19, 0, 1, 0, 0 },
/* U+15ae */ { 19, 0, 1, 0, 0 },
/* U+15af */ { 19, 0, 1, 0, 0 },
/* U+15b0 */ { 19, 0, 1, 0, 0 },
/* U+15b1 */ { 19, 0, 1, 0, 0 },
/* U+15b2 */ { 19, 0, 1, 0, 0 },
/* U+15b3 */ { 19, 0, 1, 0, 0 },
/* U+15b4 */ { 19, 0, 1, 0, 0 },
/* U+15b5 */ { 19, 0, 1, 0, 0 },
/* U+15b6 */ { 19, 0, 1, 0, 0 },
/* U+15b7 */ { 19, 0, 1, 0, 0 },
/* U+15b8 */ { 19, 0, 1, 0, 0 },
/* U+15b9 */ { 19, 0, 1, 0, 0 },
/* U+15ba */ { 19, 0, 1, 0, 0 },
/* U+15bb */ { 19, 0, 1, 0, 0 },
/* U+15bc */ { 19, 0, 1, 0, 0 },
/* U+15bd */ { 19, 0, 1, 0, 0 },
/* U+15be */ { 19, 0, 1, 0, 0 },
/* U+15bf */ { 19, 0, 1, 0, 0 },
/* U+15c0 */ { 19, 0, 1, 0, 0 },
/* U+15c1 */ { 19, 0, 1, 0, 0 },
/* U+15c2 */ { 19, 0, 1, 0, 0 },
/* U+15c3 */ { 19, 0, 1, 0, 0 },
/* U+15c4 */ { 19, 0, 1, 0, 0 },
/* U+15c5 */ { 19, 0, 1, 0, 0 },
/* U+15c6 */ { 19, 0, 1, 0, 0 },
/* U+15c7 */ { 19, 0, 1, 0, 0 },
/* U+15c8 */ { 19, 0, 1, 0, 0 },
/* U+15c9 */ { 19, 0, 1, 0, 0 },
/* U+15ca */ { 19, 0, 1, 0, 0 },
/* U+15cb */ { 19, 0, 1, 0, 0 },
/* U+15cc */ { 19, 0, 1, 0, 0 },
/* U+15cd */ { 19, 0, 1, 0, 0 },
/* U+15ce */ { 19, 0, 1, 0, 0 },
/* U+15cf */ { 19, 0, 1, 0, 0 },
/* U+15d0 */ { 19, 0, 1, 0, 0 },
/* U+15d1 */ { 19, 0, 1, 0, 0 },
/* U+15d2 */ { 19, 0, 1, 0, 0 },
/* U+15d3 */ { 19, 0, 1, 0, 0 },
/* U+15d4 */ { 19, 0, 1, 0, 0 },
/* U+15d5 */ { 19, 0, 1, 0, 0 },
/* U+15d6 */ { 19, 0, 1, 0, 0 },
/* U+15d7 */ { 19, 0, 1, 0, 0 },
/* U+15d8 */ { 19, 0, 1, 0, 0 },
/* U+15d9 */ { 19, 0, 1, 0, 0 },
/* U+15da */ { 19, 0, 1, 0, 0 },
/* U+15db */ { 19, 0, 1, 0, 0 },
/* U+15dc */ { 19, 0, 1, 0, 0 },
/* U+15dd */ { 19, 0, 1, 0, 0 },
/* U+15de */ { 19, 0, 1, 0, 0 },
/* U+15df */ { 19, 0, 1, 0, 0 },
/* U+15e0 */ { 19, 0, 1, 0, 0 },
/* U+15e1 */ { 19, 0, 1, 0, 0 },
/* U+15e2 */ { 19, 0, 1, 0, 0 },
/* U+15e3 */ { 19, 0, 1, 0, 0 },
/* U+15e4 */ { 19, 0, 1, 0, 0 },
/* U+15e5 */ { 19, 0, 1, 0, 0 },
/* U+15e6 */ { 19, 0, 1, 0, 0 },
/* U+15e7 */ { 19, 0, 1, 0, 0 },
/* U+15e8 */ { 19, 0, 1, 0, 0 },
/* U+15e9 */ { 19, 0, 1, 0, 0 },
/* U+15ea */ { 19, 0, 1, 0, 0 },
/* U+15eb */ { 19, 0, 1, 0, 0 },
/* U+15ec */ { 19, 0, 1, 0, 0 },
/* U+15ed */ { 19, 0, 1, 0, 0 },
/* U+15ee */ { 19, 0, 1, 0, 0 },
/* U+15ef */ { 19, 0, 1, 0, 0 },
/* U+15f0 */ { 19, 0, 1, 0, 0 },
/* U+15f1 */ { 19, 0, 1, 0, 0 },
/* U+15f2 */ { 19, 0, 1, 0, 0 },
/* U+15f3 */ { 19, 0, 1, 0, 0 },
/* U+15f4 */ { 19, 0, 1, 0, 0 },
/* U+15f5 */ { 19, 0, 1, 0, 0 },
/* U+15f6 */ { 19, 0, 1, 0, 0 },
/* U+15f7 */ { 19, 0, 1, 0, 0 },
/* U+15f8 */ { 19, 0, 1, 0, 0 },
/* U+15f9 */ { 19, 0, 1, 0, 0 },
/* U+15fa */ { 19, 0, 1, 0, 0 },
/* U+15fb */ { 19, 0, 1, 0, 0 },
/* U+15fc */ { 19, 0, 1, 0, 0 },
/* U+15fd */ { 19, 0, 1, 0, 0 },
/* U+15fe */ { 19, 0, 1, 0, 0 },
/* U+15ff */ { 19, 0, 1, 0, 0 },
/* U+1600 */ { 19, 0, 1, 0, 0 },
/* U+1601 */ { 19, 0, 1, 0, 0 },
/* U+1602 */ { 19, 0, 1, 0, 0 },
/* U+1603 */ { 19, 0, 1, 0, 0 },
/* U+1604 */ { 19, 0, 1, 0, 0 },
/* U+1605 */ { 19, 0, 1, 0, 0 },
/* U+1606 */ { 19, 0, 1, 0, 0 },
/* U+1607 */ { 19, 0, 1, 0, 0 },
/* U+1608 */ { 19, 0, 1, 0, 0 },
/* U+1609 */ { 19, 0, 1, 0, 0 },
/* U+160a */ { 19, 0, 1, 0, 0 },
/* U+160b */ { 19, 0, 1, 0, 0 },
/* U+160c */ { 19, 0, 1, 0, 0 },
/* U+160d */ { 19, 0, 1, 0, 0 },
/* U+160e */ { 19, 0, 1, 0, 0 },
/* U+160f */ { 19, 0, 1, 0, 0 },
/* U+1610 */ { 19, 0, 1, 0, 0 },
/* U+1611 */ { 19, 0, 1, 0, 0 },
/* U+1612 */ { 19, 0, 1, 0, 0 },
/* U+1613 */ { 19, 0, 1, 0, 0 },
/* U+1614 */ { 19, 0, 1, 0, 0 },
/* U+1615 */ { 19, 0, 1, 0, 0 },
/* U+1616 */ { 19, 0, 1, 0, 0 },
/* U+1617 */ { 19, 0, 1, 0, 0 },
/* U+1618 */ { 19, 0, 1, 0, 0 },
/* U+1619 */ { 19, 0, 1, 0, 0 },
/* U+161a */ { 19, 0, 1, 0, 0 },
/* U+161b */ { 19, 0, 1, 0, 0 },
/* U+161c */ { 19, 0, 1, 0, 0 },
/* U+161d */ { 19, 0, 1, 0, 0 },
/* U+161e */ { 19, 0, 1, 0, 0 },
/* U+161f */ { 19, 0, 1, 0, 0 },
/* U+1620 */ { 19, 0, 1, 0, 0 },
/* U+1621 */ { 19, 0, 1, 0, 0 },
/* U+1622 */ { 19, 0, 1, 0, 0 },
/* U+1623 */ { 19, 0, 1, 0, 0 },
/* U+1624 */ { 19, 0, 1, 0, 0 },
/* U+1625 */ { 19, 0, 1, 0, 0 },
/* U+1626 */ { 19, 0, 1, 0, 0 },
/* U+1627 */ { 19, 0, 1, 0, 0 },
/* U+1628 */ { 19, 0, 1, 0, 0 },
/* U+1629 */ { 19, 0, 1, 0, 0 },
/* U+162a */ { 19, 0, 1, 0, 0 },
/* U+162b */ { 19, 0, 1, 0, 0 },
/* U+162c */ { 19, 0, 1, 0, 0 },
/* U+162d */ { 19, 0, 1, 0, 0 },
/* U+162e */ { 19, 0, 1, 0, 0 },
/* U+162f */ { 19, 0, 1, 0, 0 },
/* U+1630 */ { 19, 0, 1, 0, 0 },
/* U+1631 */ { 19, 0, 1, 0, 0 },
/* U+1632 */ { 19, 0, 1, 0, 0 },
/* U+1633 */ { 19, 0, 1, 0, 0 },
/* U+1634 */ { 19, 0, 1, 0, 0 },
/* U+1635 */ { 19, 0, 1, 0, 0 },
/* U+1636 */ { 19, 0, 1, 0, 0 },
/* U+1637 */ { 19, 0, 1, 0, 0 },
/* U+1638 */ { 19, 0, 1, 0, 0 },
/* U+1639 */ { 19, 0, 1, 0, 0 },
/* U+163a */ { 19, 0, 1, 0, 0 },
/* U+163b */ { 19, 0, 1, 0, 0 },
/* U+163c */ { 19, 0, 1, 0, 0 },
/* U+163d */ { 19, 0, 1, 0, 0 },
/* U+163e */ { 19, 0, 1, 0, 0 },
/* U+163f */ { 19, 0, 1, 0, 0 },
/* U+1640 */ { 19, 0, 1, 0, 0 },
/* U+1641 */ { 19, 0, 1, 0, 0 },
/* U+1642 */ { 19, 0, 1, 0, 0 },
/* U+1643 */ { 19, 0, 1, 0, 0 },
/* U+1644 */ { 19, 0, 1, 0, 0 },
/* U+1645 */ { 19, 0, 1, 0, 0 },
/* U+1646 */ { 19, 0, 1, 0, 0 },
/* U+1647 */ { 19, 0, 1, 0, 0 },
/* U+1648 */ { 19, 0, 1, 0, 0 },
/* U+1649 */ { 19, 0, 1, 0, 0 },
/* U+164a */ { 19, 0, 1, 0, 0 },
/* U+164b */ { 19, 0, 1, 0, 0 },
/* U+164c */ { 19, 0, 1, 0, 0 },
/* U+164d */ { 19, 0, 1, 0, 0 },
/* U+164e */ { 19, 0, 1, 0, 0 },
/* U+164f */ { 19, 0, 1, 0, 0 },
/* U+1650 */ { 19, 0, 1, 0, 0 },
/* U+1651 */ { 19, 0, 1, 0, 0 },
/* U+1652 */ { 19, 0, 1, 0, 0 },
/* U+1653 */ { 19, 0, 1, 0, 0 },
/* U+1654 */ { 19, 0, 1, 0, 0 },
/* U+1655 */ { 19, 0, 1, 0, 0 },
/* U+1656 */ { 19, 0, 1, 0, 0 },
/* U+1657 */ { 19, 0, 1, 0, 0 },
/* U+1658 */ { 19, 0, 1, 0, 0 },
/* U+1659 */ { 19, 0, 1, 0, 0 },
/* U+165a */ { 19, 0, 1, 0, 0 },
/* U+165b */ { 19, 0, 1, 0, 0 },
/* U+165c */ { 19, 0, 1, 0, 0 },
/* U+165d */ { 19, 0, 1, 0, 0 },
/* U+165e */ { 19, 0, 1, 0, 0 },
/* U+165f */ { 19, 0, 1, 0, 0 },
/* U+1660 */ { 19, 0, 1, 0, 0 },
/* U+1661 */ { 19, 0, 1, 0, 0 },
/* U+1662 */ { 19, 0, 1, 0, 0 },
/* U+1663 */ { 19, 0, 1, 0, 0 },
/* U+1664 */ { 19, 0, 1, 0, 0 },
/* U+1665 */ { 19, 0, 1, 0, 0 },
/* U+1666 */ { 19, 0, 1, 0, 0 },
/* U+1667 */ { 19, 0, 1, 0, 0 },
/* U+1668 */ { 19, 0, 1, 0, 0 },
/* U+1669 */ { 19, 0, 1, 0, 0 },
/* U+166a */ { 19, 0, 1, 0, 0 },
/* U+166b */ { 19, 0, 1, 0, 0 },
/* U+166c */ { 19, 0, 1, 0, 0 },
/* U+166d */ { 26, 0, 1, 0, 0 },
/* U+166e */ { 26, 0, 1, 0, 0 },
/* U+166f */ { 19, 0, 1, 0, 0 },
/* U+1670 */ { 19, 0, 1, 0, 0 },
/* U+1671 */ { 19, 0, 1, 0, 0 },
/* U+1672 */ { 19, 0, 1, 0, 0 },
/* U+1673 */ { 19, 0, 1, 0, 0 },
/* U+1674 */ { 19, 0, 1, 0, 0 },
/* U+1675 */ { 19, 0, 1, 0, 0 },
/* U+1676 */ { 19, 0, 1, 0, 0 },
/* U+1677 */ { 0, 0, 0, 0, 0 },
/* U+1678 */ { 0, 0, 0, 0, 0 },
/* U+1679 */ { 0, 0, 0, 0, 0 },
/* U+167a */ { 0, 0, 0, 0, 0 },
/* U+167b */ { 0, 0, 0, 0, 0 },
/* U+167c */ { 0, 0, 0, 0, 0 },
/* U+167d */ { 0, 0, 0, 0, 0 },
/* U+167e */ { 0, 0, 0, 0, 0 },
/* U+167f */ { 0, 0, 0, 0, 0 },
/* U+1680 */ { 10, 0, 18, 0, 0 },
/* U+1681 */ { 19, 0, 1, 0, 0 },
/* U+1682 */ { 19, 0, 1, 0, 0 },
/* U+1683 */ { 19, 0, 1, 0, 0 },
/* U+1684 */ { 19, 0, 1, 0, 0 },
/* U+1685 */ { 19, 0, 1, 0, 0 },
/* U+1686 */ { 19, 0, 1, 0, 0 },
/* U+1687 */ { 19, 0, 1, 0, 0 },
/* U+1688 */ { 19, 0, 1, 0, 0 },
/* U+1689 */ { 19, 0, 1, 0, 0 },
/* U+168a */ { 19, 0, 1, 0, 0 },
/* U+168b */ { 19, 0, 1, 0, 0 },
/* U+168c */ { 19, 0, 1, 0, 0 },
/* U+168d */ { 19, 0, 1, 0, 0 },
/* U+168e */ { 19, 0, 1, 0, 0 },
/* U+168f */ { 19, 0, 1, 0, 0 },
/* U+1690 */ { 19, 0, 1, 0, 0 },
/* U+1691 */ { 19, 0, 1, 0, 0 },
/* U+1692 */ { 19, 0, 1, 0, 0 },
/* U+1693 */ { 19, 0, 1, 0, 0 },
/* U+1694 */ { 19, 0, 1, 0, 0 },
/* U+1695 */ { 19, 0, 1, 0, 0 },
/* U+1696 */ { 19, 0, 1, 0, 0 },
/* U+1697 */ { 19, 0, 1, 0, 0 },
/* U+1698 */ { 19, 0, 1, 0, 0 },
/* U+1699 */ { 19, 0, 1, 0, 0 },
/* U+169a */ { 19, 0, 1, 0, 0 },
/* U+169b */ { 22, 0, 19, 0, 0 },
/* U+169c */ { 23, 0, 19, 0, 0 },
/* U+169d */ { 0, 0, 0, 0, 0 },
/* U+169e */ { 0, 0, 0, 0, 0 },
/* U+169f */ { 0, 0, 0, 0, 0 },
/* U+16a0 */ { 19, 0, 1, 0, 0 },
/* U+16a1 */ { 19, 0, 1, 0, 0 },
/* U+16a2 */ { 19, 0, 1, 0, 0 },
/* U+16a3 */ { 19, 0, 1, 0, 0 },
/* U+16a4 */ { 19, 0, 1, 0, 0 },
/* U+16a5 */ { 19, 0, 1, 0, 0 },
/* U+16a6 */ { 19, 0, 1, 0, 0 },
/* U+16a7 */ { 19, 0, 1, 0, 0 },
/* U+16a8 */ { 19, 0, 1, 0, 0 },
/* U+16a9 */ { 19, 0, 1, 0, 0 },
/* U+16aa */ { 19, 0, 1, 0, 0 },
/* U+16ab */ { 19, 0, 1, 0, 0 },
/* U+16ac */ { 19, 0, 1, 0, 0 },
/* U+16ad */ { 19, 0, 1, 0, 0 },
/* U+16ae */ { 19, 0, 1, 0, 0 },
/* U+16af */ { 19, 0, 1, 0, 0 },
/* U+16b0 */ { 19, 0, 1, 0, 0 },
/* U+16b1 */ { 19, 0, 1, 0, 0 },
/* U+16b2 */ { 19, 0, 1, 0, 0 },
/* U+16b3 */ { 19, 0, 1, 0, 0 },
/* U+16b4 */ { 19, 0, 1, 0, 0 },
/* U+16b5 */ { 19, 0, 1, 0, 0 },
/* U+16b6 */ { 19, 0, 1, 0, 0 },
/* U+16b7 */ { 19, 0, 1, 0, 0 },
/* U+16b8 */ { 19, 0, 1, 0, 0 },
/* U+16b9 */ { 19, 0, 1, 0, 0 },
/* U+16ba */ { 19, 0, 1, 0, 0 },
/* U+16bb */ { 19, 0, 1, 0, 0 },
/* U+16bc */ { 19, 0, 1, 0, 0 },
/* U+16bd */ { 19, 0, 1, 0, 0 },
/* U+16be */ { 19, 0, 1, 0, 0 },
/* U+16bf */ { 19, 0, 1, 0, 0 },
/* U+16c0 */ { 19, 0, 1, 0, 0 },
/* U+16c1 */ { 19, 0, 1, 0, 0 },
/* U+16c2 */ { 19, 0, 1, 0, 0 },
/* U+16c3 */ { 19, 0, 1, 0, 0 },
/* U+16c4 */ { 19, 0, 1, 0, 0 },
/* U+16c5 */ { 19, 0, 1, 0, 0 },
/* U+16c6 */ { 19, 0, 1, 0, 0 },
/* U+16c7 */ { 19, 0, 1, 0, 0 },
/* U+16c8 */ { 19, 0, 1, 0, 0 },
/* U+16c9 */ { 19, 0, 1, 0, 0 },
/* U+16ca */ { 19, 0, 1, 0, 0 },
/* U+16cb */ { 19, 0, 1, 0, 0 },
/* U+16cc */ { 19, 0, 1, 0, 0 },
/* U+16cd */ { 19, 0, 1, 0, 0 },
/* U+16ce */ { 19, 0, 1, 0, 0 },
/* U+16cf */ { 19, 0, 1, 0, 0 },
/* U+16d0 */ { 19, 0, 1, 0, 0 },
/* U+16d1 */ { 19, 0, 1, 0, 0 },
/* U+16d2 */ { 19, 0, 1, 0, 0 },
/* U+16d3 */ { 19, 0, 1, 0, 0 },
/* U+16d4 */ { 19, 0, 1, 0, 0 },
/* U+16d5 */ { 19, 0, 1, 0, 0 },
/* U+16d6 */ { 19, 0, 1, 0, 0 },
/* U+16d7 */ { 19, 0, 1, 0, 0 },
/* U+16d8 */ { 19, 0, 1, 0, 0 },
/* U+16d9 */ { 19, 0, 1, 0, 0 },
/* U+16da */ { 19, 0, 1, 0, 0 },
/* U+16db */ { 19, 0, 1, 0, 0 },
/* U+16dc */ { 19, 0, 1, 0, 0 },
/* U+16dd */ { 19, 0, 1, 0, 0 },
/* U+16de */ { 19, 0, 1, 0, 0 },
/* U+16df */ { 19, 0, 1, 0, 0 },
/* U+16e0 */ { 19, 0, 1, 0, 0 },
/* U+16e1 */ { 19, 0, 1, 0, 0 },
/* U+16e2 */ { 19, 0, 1, 0, 0 },
/* U+16e3 */ { 19, 0, 1, 0, 0 },
/* U+16e4 */ { 19, 0, 1, 0, 0 },
/* U+16e5 */ { 19, 0, 1, 0, 0 },
/* U+16e6 */ { 19, 0, 1, 0, 0 },
/* U+16e7 */ { 19, 0, 1, 0, 0 },
/* U+16e8 */ { 19, 0, 1, 0, 0 },
/* U+16e9 */ { 19, 0, 1, 0, 0 },
/* U+16ea */ { 19, 0, 1, 0, 0 },
/* U+16eb */ { 26, 0, 1, 0, 0 },
/* U+16ec */ { 26, 0, 1, 0, 0 },
/* U+16ed */ { 26, 0, 1, 0, 0 },
/* U+16ee */ { 9, 0, 1, 0, 0 },
/* U+16ef */ { 9, 0, 1, 0, 0 },
/* U+16f0 */ { 9, 0, 1, 0, 0 },
/* U+16f1 */ { 0, 0, 0, 0, 0 },
/* U+16f2 */ { 0, 0, 0, 0, 0 },
/* U+16f3 */ { 0, 0, 0, 0, 0 },
/* U+16f4 */ { 0, 0, 0, 0, 0 },
/* U+16f5 */ { 0, 0, 0, 0, 0 },
/* U+16f6 */ { 0, 0, 0, 0, 0 },
/* U+16f7 */ { 0, 0, 0, 0, 0 },
/* U+16f8 */ { 0, 0, 0, 0, 0 },
/* U+16f9 */ { 0, 0, 0, 0, 0 },
/* U+16fa */ { 0, 0, 0, 0, 0 },
/* U+16fb */ { 0, 0, 0, 0, 0 },
/* U+16fc */ { 0, 0, 0, 0, 0 },
/* U+16fd */ { 0, 0, 0, 0, 0 },
/* U+16fe */ { 0, 0, 0, 0, 0 },
/* U+16ff */ { 0, 0, 0, 0, 0 },
/* U+1700 */ { 0, 0, 0, 0, 0 },
/* U+1701 */ { 0, 0, 0, 0, 0 },
/* U+1702 */ { 0, 0, 0, 0, 0 },
/* U+1703 */ { 0, 0, 0, 0, 0 },
/* U+1704 */ { 0, 0, 0, 0, 0 },
/* U+1705 */ { 0, 0, 0, 0, 0 },
/* U+1706 */ { 0, 0, 0, 0, 0 },
/* U+1707 */ { 0, 0, 0, 0, 0 },
/* U+1708 */ { 0, 0, 0, 0, 0 },
/* U+1709 */ { 0, 0, 0, 0, 0 },
/* U+170a */ { 0, 0, 0, 0, 0 },
/* U+170b */ { 0, 0, 0, 0, 0 },
/* U+170c */ { 0, 0, 0, 0, 0 },
/* U+170d */ { 0, 0, 0, 0, 0 },
/* U+170e */ { 0, 0, 0, 0, 0 },
/* U+170f */ { 0, 0, 0, 0, 0 },
/* U+1710 */ { 0, 0, 0, 0, 0 },
/* U+1711 */ { 0, 0, 0, 0, 0 },
/* U+1712 */ { 0, 0, 0, 0, 0 },
/* U+1713 */ { 0, 0, 0, 0, 0 },
/* U+1714 */ { 0, 0, 0, 0, 0 },
/* U+1715 */ { 0, 0, 0, 0, 0 },
/* U+1716 */ { 0, 0, 0, 0, 0 },
/* U+1717 */ { 0, 0, 0, 0, 0 },
/* U+1718 */ { 0, 0, 0, 0, 0 },
/* U+1719 */ { 0, 0, 0, 0, 0 },
/* U+171a */ { 0, 0, 0, 0, 0 },
/* U+171b */ { 0, 0, 0, 0, 0 },
/* U+171c */ { 0, 0, 0, 0, 0 },
/* U+171d */ { 0, 0, 0, 0, 0 },
/* U+171e */ { 0, 0, 0, 0, 0 },
/* U+171f */ { 0, 0, 0, 0, 0 },
/* U+1720 */ { 0, 0, 0, 0, 0 },
/* U+1721 */ { 0, 0, 0, 0, 0 },
/* U+1722 */ { 0, 0, 0, 0, 0 },
/* U+1723 */ { 0, 0, 0, 0, 0 },
/* U+1724 */ { 0, 0, 0, 0, 0 },
/* U+1725 */ { 0, 0, 0, 0, 0 },
/* U+1726 */ { 0, 0, 0, 0, 0 },
/* U+1727 */ { 0, 0, 0, 0, 0 },
/* U+1728 */ { 0, 0, 0, 0, 0 },
/* U+1729 */ { 0, 0, 0, 0, 0 },
/* U+172a */ { 0, 0, 0, 0, 0 },
/* U+172b */ { 0, 0, 0, 0, 0 },
/* U+172c */ { 0, 0, 0, 0, 0 },
/* U+172d */ { 0, 0, 0, 0, 0 },
/* U+172e */ { 0, 0, 0, 0, 0 },
/* U+172f */ { 0, 0, 0, 0, 0 },
/* U+1730 */ { 0, 0, 0, 0, 0 },
/* U+1731 */ { 0, 0, 0, 0, 0 },
/* U+1732 */ { 0, 0, 0, 0, 0 },
/* U+1733 */ { 0, 0, 0, 0, 0 },
/* U+1734 */ { 0, 0, 0, 0, 0 },
/* U+1735 */ { 0, 0, 0, 0, 0 },
/* U+1736 */ { 0, 0, 0, 0, 0 },
/* U+1737 */ { 0, 0, 0, 0, 0 },
/* U+1738 */ { 0, 0, 0, 0, 0 },
/* U+1739 */ { 0, 0, 0, 0, 0 },
/* U+173a */ { 0, 0, 0, 0, 0 },
/* U+173b */ { 0, 0, 0, 0, 0 },
/* U+173c */ { 0, 0, 0, 0, 0 },
/* U+173d */ { 0, 0, 0, 0, 0 },
/* U+173e */ { 0, 0, 0, 0, 0 },
/* U+173f */ { 0, 0, 0, 0, 0 },
/* U+1740 */ { 0, 0, 0, 0, 0 },
/* U+1741 */ { 0, 0, 0, 0, 0 },
/* U+1742 */ { 0, 0, 0, 0, 0 },
/* U+1743 */ { 0, 0, 0, 0, 0 },
/* U+1744 */ { 0, 0, 0, 0, 0 },
/* U+1745 */ { 0, 0, 0, 0, 0 },
/* U+1746 */ { 0, 0, 0, 0, 0 },
/* U+1747 */ { 0, 0, 0, 0, 0 },
/* U+1748 */ { 0, 0, 0, 0, 0 },
/* U+1749 */ { 0, 0, 0, 0, 0 },
/* U+174a */ { 0, 0, 0, 0, 0 },
/* U+174b */ { 0, 0, 0, 0, 0 },
/* U+174c */ { 0, 0, 0, 0, 0 },
/* U+174d */ { 0, 0, 0, 0, 0 },
/* U+174e */ { 0, 0, 0, 0, 0 },
/* U+174f */ { 0, 0, 0, 0, 0 },
/* U+1750 */ { 0, 0, 0, 0, 0 },
/* U+1751 */ { 0, 0, 0, 0, 0 },
/* U+1752 */ { 0, 0, 0, 0, 0 },
/* U+1753 */ { 0, 0, 0, 0, 0 },
/* U+1754 */ { 0, 0, 0, 0, 0 },
/* U+1755 */ { 0, 0, 0, 0, 0 },
/* U+1756 */ { 0, 0, 0, 0, 0 },
/* U+1757 */ { 0, 0, 0, 0, 0 },
/* U+1758 */ { 0, 0, 0, 0, 0 },
/* U+1759 */ { 0, 0, 0, 0, 0 },
/* U+175a */ { 0, 0, 0, 0, 0 },
/* U+175b */ { 0, 0, 0, 0, 0 },
/* U+175c */ { 0, 0, 0, 0, 0 },
/* U+175d */ { 0, 0, 0, 0, 0 },
/* U+175e */ { 0, 0, 0, 0, 0 },
/* U+175f */ { 0, 0, 0, 0, 0 },
/* U+1760 */ { 0, 0, 0, 0, 0 },
/* U+1761 */ { 0, 0, 0, 0, 0 },
/* U+1762 */ { 0, 0, 0, 0, 0 },
/* U+1763 */ { 0, 0, 0, 0, 0 },
/* U+1764 */ { 0, 0, 0, 0, 0 },
/* U+1765 */ { 0, 0, 0, 0, 0 },
/* U+1766 */ { 0, 0, 0, 0, 0 },
/* U+1767 */ { 0, 0, 0, 0, 0 },
/* U+1768 */ { 0, 0, 0, 0, 0 },
/* U+1769 */ { 0, 0, 0, 0, 0 },
/* U+176a */ { 0, 0, 0, 0, 0 },
/* U+176b */ { 0, 0, 0, 0, 0 },
/* U+176c */ { 0, 0, 0, 0, 0 },
/* U+176d */ { 0, 0, 0, 0, 0 },
/* U+176e */ { 0, 0, 0, 0, 0 },
/* U+176f */ { 0, 0, 0, 0, 0 },
/* U+1770 */ { 0, 0, 0, 0, 0 },
/* U+1771 */ { 0, 0, 0, 0, 0 },
/* U+1772 */ { 0, 0, 0, 0, 0 },
/* U+1773 */ { 0, 0, 0, 0, 0 },
/* U+1774 */ { 0, 0, 0, 0, 0 },
/* U+1775 */ { 0, 0, 0, 0, 0 },
/* U+1776 */ { 0, 0, 0, 0, 0 },
/* U+1777 */ { 0, 0, 0, 0, 0 },
/* U+1778 */ { 0, 0, 0, 0, 0 },
/* U+1779 */ { 0, 0, 0, 0, 0 },
/* U+177a */ { 0, 0, 0, 0, 0 },
/* U+177b */ { 0, 0, 0, 0, 0 },
/* U+177c */ { 0, 0, 0, 0, 0 },
/* U+177d */ { 0, 0, 0, 0, 0 },
/* U+177e */ { 0, 0, 0, 0, 0 },
/* U+177f */ { 0, 0, 0, 0, 0 },
/* U+1780 */ { 19, 0, 1, 0, 0 },
/* U+1781 */ { 19, 0, 1, 0, 0 },
/* U+1782 */ { 19, 0, 1, 0, 0 },
/* U+1783 */ { 19, 0, 1, 0, 0 },
/* U+1784 */ { 19, 0, 1, 0, 0 },
/* U+1785 */ { 19, 0, 1, 0, 0 },
/* U+1786 */ { 19, 0, 1, 0, 0 },
/* U+1787 */ { 19, 0, 1, 0, 0 },
/* U+1788 */ { 19, 0, 1, 0, 0 },
/* U+1789 */ { 19, 0, 1, 0, 0 },
/* U+178a */ { 19, 0, 1, 0, 0 },
/* U+178b */ { 19, 0, 1, 0, 0 },
/* U+178c */ { 19, 0, 1, 0, 0 },
/* U+178d */ { 19, 0, 1, 0, 0 },
/* U+178e */ { 19, 0, 1, 0, 0 },
/* U+178f */ { 19, 0, 1, 0, 0 },
/* U+1790 */ { 19, 0, 1, 0, 0 },
/* U+1791 */ { 19, 0, 1, 0, 0 },
/* U+1792 */ { 19, 0, 1, 0, 0 },
/* U+1793 */ { 19, 0, 1, 0, 0 },
/* U+1794 */ { 19, 0, 1, 0, 0 },
/* U+1795 */ { 19, 0, 1, 0, 0 },
/* U+1796 */ { 19, 0, 1, 0, 0 },
/* U+1797 */ { 19, 0, 1, 0, 0 },
/* U+1798 */ { 19, 0, 1, 0, 0 },
/* U+1799 */ { 19, 0, 1, 0, 0 },
/* U+179a */ { 19, 0, 1, 0, 0 },
/* U+179b */ { 19, 0, 1, 0, 0 },
/* U+179c */ { 19, 0, 1, 0, 0 },
/* U+179d */ { 19, 0, 1, 0, 0 },
/* U+179e */ { 19, 0, 1, 0, 0 },
/* U+179f */ { 19, 0, 1, 0, 0 },
/* U+17a0 */ { 19, 0, 1, 0, 0 },
/* U+17a1 */ { 19, 0, 1, 0, 0 },
/* U+17a2 */ { 19, 0, 1, 0, 0 },
/* U+17a3 */ { 19, 0, 1, 0, 0 },
/* U+17a4 */ { 19, 0, 1, 0, 0 },
/* U+17a5 */ { 19, 0, 1, 0, 0 },
/* U+17a6 */ { 19, 0, 1, 0, 0 },
/* U+17a7 */ { 19, 0, 1, 0, 0 },
/* U+17a8 */ { 19, 0, 1, 0, 0 },
/* U+17a9 */ { 19, 0, 1, 0, 0 },
/* U+17aa */ { 19, 0, 1, 0, 0 },
/* U+17ab */ { 19, 0, 1, 0, 0 },
/* U+17ac */ { 19, 0, 1, 0, 0 },
/* U+17ad */ { 19, 0, 1, 0, 0 },
/* U+17ae */ { 19, 0, 1, 0, 0 },
/* U+17af */ { 19, 0, 1, 0, 0 },
/* U+17b0 */ { 19, 0, 1, 0, 0 },
/* U+17b1 */ { 19, 0, 1, 0, 0 },
/* U+17b2 */ { 19, 0, 1, 0, 0 },
/* U+17b3 */ { 19, 0, 1, 0, 0 },
/* U+17b4 */ { 5, 0, 1, 0, 0 },
/* U+17b5 */ { 5, 0, 1, 0, 0 },
/* U+17b6 */ { 5, 0, 1, 0, 0 },
/* U+17b7 */ { 4, 0, 14, 0, 0 },
/* U+17b8 */ { 4, 0, 14, 0, 0 },
/* U+17b9 */ { 4, 0, 14, 0, 0 },
/* U+17ba */ { 4, 0, 14, 0, 0 },
/* U+17bb */ { 4, 0, 14, 0, 0 },
/* U+17bc */ { 4, 0, 14, 0, 0 },
/* U+17bd */ { 4, 0, 14, 0, 0 },
/* U+17be */ { 5, 0, 1, 0, 0 },
/* U+17bf */ { 5, 0, 1, 0, 0 },
/* U+17c0 */ { 5, 0, 1, 0, 0 },
/* U+17c1 */ { 5, 0, 1, 0, 0 },
/* U+17c2 */ { 5, 0, 1, 0, 0 },
/* U+17c3 */ { 5, 0, 1, 0, 0 },
/* U+17c4 */ { 5, 0, 1, 0, 0 },
/* U+17c5 */ { 5, 0, 1, 0, 0 },
/* U+17c6 */ { 4, 0, 14, 0, 0 },
/* U+17c7 */ { 5, 0, 1, 0, 0 },
/* U+17c8 */ { 5, 0, 1, 0, 0 },
/* U+17c9 */ { 4, 0, 14, 0, 0 },
/* U+17ca */ { 4, 0, 14, 0, 0 },
/* U+17cb */ { 4, 0, 14, 0, 0 },
/* U+17cc */ { 4, 0, 14, 0, 0 },
/* U+17cd */ { 4, 0, 14, 0, 0 },
/* U+17ce */ { 4, 0, 14, 0, 0 },
/* U+17cf */ { 4, 0, 14, 0, 0 },
/* U+17d0 */ { 4, 0, 14, 0, 0 },
/* U+17d1 */ { 4, 0, 14, 0, 0 },
/* U+17d2 */ { 4, 9, 14, 0, 0 },
/* U+17d3 */ { 4, 0, 14, 0, 0 },
/* U+17d4 */ { 26, 0, 1, 0, 0 },
/* U+17d5 */ { 26, 0, 1, 0, 0 },
/* U+17d6 */ { 26, 0, 1, 0, 0 },
/* U+17d7 */ { 26, 0, 1, 0, 0 },
/* U+17d8 */ { 26, 0, 1, 0, 0 },
/* U+17d9 */ { 26, 0, 1, 0, 0 },
/* U+17da */ { 26, 0, 1, 0, 0 },
/* U+17db */ { 28, 0, 11, 0, 0 },
/* U+17dc */ { 26, 0, 1, 0, 0 },
/* U+17dd */ { 0, 0, 0, 0, 0 },
/* U+17de */ { 0, 0, 0, 0, 0 },
/* U+17df */ { 0, 0, 0, 0, 0 },
/* U+17e0 */ { 7, 0, 1, 0, 0 },
/* U+17e1 */ { 7, 0, 1, 0, 0 },
/* U+17e2 */ { 7, 0, 1, 0, 0 },
/* U+17e3 */ { 7, 0, 1, 0, 0 },
/* U+17e4 */ { 7, 0, 1, 0, 0 },
/* U+17e5 */ { 7, 0, 1, 0, 0 },
/* U+17e6 */ { 7, 0, 1, 0, 0 },
/* U+17e7 */ { 7, 0, 1, 0, 0 },
/* U+17e8 */ { 7, 0, 1, 0, 0 },
/* U+17e9 */ { 7, 0, 1, 0, 0 },
/* U+17ea */ { 0, 0, 0, 0, 0 },
/* U+17eb */ { 0, 0, 0, 0, 0 },
/* U+17ec */ { 0, 0, 0, 0, 0 },
/* U+17ed */ { 0, 0, 0, 0, 0 },
/* U+17ee */ { 0, 0, 0, 0, 0 },
/* U+17ef */ { 0, 0, 0, 0, 0 },
/* U+17f0 */ { 0, 0, 0, 0, 0 },
/* U+17f1 */ { 0, 0, 0, 0, 0 },
/* U+17f2 */ { 0, 0, 0, 0, 0 },
/* U+17f3 */ { 0, 0, 0, 0, 0 },
/* U+17f4 */ { 0, 0, 0, 0, 0 },
/* U+17f5 */ { 0, 0, 0, 0, 0 },
/* U+17f6 */ { 0, 0, 0, 0, 0 },
/* U+17f7 */ { 0, 0, 0, 0, 0 },
/* U+17f8 */ { 0, 0, 0, 0, 0 },
/* U+17f9 */ { 0, 0, 0, 0, 0 },
/* U+17fa */ { 0, 0, 0, 0, 0 },
/* U+17fb */ { 0, 0, 0, 0, 0 },
/* U+17fc */ { 0, 0, 0, 0, 0 },
/* U+17fd */ { 0, 0, 0, 0, 0 },
/* U+17fe */ { 0, 0, 0, 0, 0 },
/* U+17ff */ { 0, 0, 0, 0, 0 },
/* U+1800 */ { 26, 0, 19, 0, 0 },
/* U+1801 */ { 26, 0, 19, 0, 0 },
/* U+1802 */ { 26, 0, 19, 0, 0 },
/* U+1803 */ { 26, 0, 19, 0, 0 },
/* U+1804 */ { 26, 0, 19, 0, 0 },
/* U+1805 */ { 26, 0, 19, 0, 0 },
/* U+1806 */ { 21, 0, 19, 0, 0 },
/* U+1807 */ { 26, 0, 19, 0, 0 },
/* U+1808 */ { 26, 0, 19, 0, 0 },
/* U+1809 */ { 26, 0, 19, 0, 0 },
/* U+180a */ { 26, 0, 19, 0, 0 },
/* U+180b */ { 14, 0, 15, 0, 0 },
/* U+180c */ { 14, 0, 15, 0, 0 },
/* U+180d */ { 14, 0, 15, 0, 0 },
/* U+180e */ { 14, 0, 15, 0, 0 },
/* U+180f */ { 0, 0, 0, 0, 0 },
/* U+1810 */ { 7, 0, 1, 0, 0 },
/* U+1811 */ { 7, 0, 1, 0, 0 },
/* U+1812 */ { 7, 0, 1, 0, 0 },
/* U+1813 */ { 7, 0, 1, 0, 0 },
/* U+1814 */ { 7, 0, 1, 0, 0 },
/* U+1815 */ { 7, 0, 1, 0, 0 },
/* U+1816 */ { 7, 0, 1, 0, 0 },
/* U+1817 */ { 7, 0, 1, 0, 0 },
/* U+1818 */ { 7, 0, 1, 0, 0 },
/* U+1819 */ { 7, 0, 1, 0, 0 },
/* U+181a */ { 0, 0, 0, 0, 0 },
/* U+181b */ { 0, 0, 0, 0, 0 },
/* U+181c */ { 0, 0, 0, 0, 0 },
/* U+181d */ { 0, 0, 0, 0, 0 },
/* U+181e */ { 0, 0, 0, 0, 0 },
/* U+181f */ { 0, 0, 0, 0, 0 },
/* U+1820 */ { 19, 0, 1, 0, 0 },
/* U+1821 */ { 19, 0, 1, 0, 0 },
/* U+1822 */ { 19, 0, 1, 0, 0 },
/* U+1823 */ { 19, 0, 1, 0, 0 },
/* U+1824 */ { 19, 0, 1, 0, 0 },
/* U+1825 */ { 19, 0, 1, 0, 0 },
/* U+1826 */ { 19, 0, 1, 0, 0 },
/* U+1827 */ { 19, 0, 1, 0, 0 },
/* U+1828 */ { 19, 0, 1, 0, 0 },
/* U+1829 */ { 19, 0, 1, 0, 0 },
/* U+182a */ { 19, 0, 1, 0, 0 },
/* U+182b */ { 19, 0, 1, 0, 0 },
/* U+182c */ { 19, 0, 1, 0, 0 },
/* U+182d */ { 19, 0, 1, 0, 0 },
/* U+182e */ { 19, 0, 1, 0, 0 },
/* U+182f */ { 19, 0, 1, 0, 0 },
/* U+1830 */ { 19, 0, 1, 0, 0 },
/* U+1831 */ { 19, 0, 1, 0, 0 },
/* U+1832 */ { 19, 0, 1, 0, 0 },
/* U+1833 */ { 19, 0, 1, 0, 0 },
/* U+1834 */ { 19, 0, 1, 0, 0 },
/* U+1835 */ { 19, 0, 1, 0, 0 },
/* U+1836 */ { 19, 0, 1, 0, 0 },
/* U+1837 */ { 19, 0, 1, 0, 0 },
/* U+1838 */ { 19, 0, 1, 0, 0 },
/* U+1839 */ { 19, 0, 1, 0, 0 },
/* U+183a */ { 19, 0, 1, 0, 0 },
/* U+183b */ { 19, 0, 1, 0, 0 },
/* U+183c */ { 19, 0, 1, 0, 0 },
/* U+183d */ { 19, 0, 1, 0, 0 },
/* U+183e */ { 19, 0, 1, 0, 0 },
/* U+183f */ { 19, 0, 1, 0, 0 },
/* U+1840 */ { 19, 0, 1, 0, 0 },
/* U+1841 */ { 19, 0, 1, 0, 0 },
/* U+1842 */ { 19, 0, 1, 0, 0 },
/* U+1843 */ { 18, 0, 1, 0, 0 },
/* U+1844 */ { 19, 0, 1, 0, 0 },
/* U+1845 */ { 19, 0, 1, 0, 0 },
/* U+1846 */ { 19, 0, 1, 0, 0 },
/* U+1847 */ { 19, 0, 1, 0, 0 },
/* U+1848 */ { 19, 0, 1, 0, 0 },
/* U+1849 */ { 19, 0, 1, 0, 0 },
/* U+184a */ { 19, 0, 1, 0, 0 },
/* U+184b */ { 19, 0, 1, 0, 0 },
/* U+184c */ { 19, 0, 1, 0, 0 },
/* U+184d */ { 19, 0, 1, 0, 0 },
/* U+184e */ { 19, 0, 1, 0, 0 },
/* U+184f */ { 19, 0, 1, 0, 0 },
/* U+1850 */ { 19, 0, 1, 0, 0 },
/* U+1851 */ { 19, 0, 1, 0, 0 },
/* U+1852 */ { 19, 0, 1, 0, 0 },
/* U+1853 */ { 19, 0, 1, 0, 0 },
/* U+1854 */ { 19, 0, 1, 0, 0 },
/* U+1855 */ { 19, 0, 1, 0, 0 },
/* U+1856 */ { 19, 0, 1, 0, 0 },
/* U+1857 */ { 19, 0, 1, 0, 0 },
/* U+1858 */ { 19, 0, 1, 0, 0 },
/* U+1859 */ { 19, 0, 1, 0, 0 },
/* U+185a */ { 19, 0, 1, 0, 0 },
/* U+185b */ { 19, 0, 1, 0, 0 },
/* U+185c */ { 19, 0, 1, 0, 0 },
/* U+185d */ { 19, 0, 1, 0, 0 },
/* U+185e */ { 19, 0, 1, 0, 0 },
/* U+185f */ { 19, 0, 1, 0, 0 },
/* U+1860 */ { 19, 0, 1, 0, 0 },
/* U+1861 */ { 19, 0, 1, 0, 0 },
/* U+1862 */ { 19, 0, 1, 0, 0 },
/* U+1863 */ { 19, 0, 1, 0, 0 },
/* U+1864 */ { 19, 0, 1, 0, 0 },
/* U+1865 */ { 19, 0, 1, 0, 0 },
/* U+1866 */ { 19, 0, 1, 0, 0 },
/* U+1867 */ { 19, 0, 1, 0, 0 },
/* U+1868 */ { 19, 0, 1, 0, 0 },
/* U+1869 */ { 19, 0, 1, 0, 0 },
/* U+186a */ { 19, 0, 1, 0, 0 },
/* U+186b */ { 19, 0, 1, 0, 0 },
/* U+186c */ { 19, 0, 1, 0, 0 },
/* U+186d */ { 19, 0, 1, 0, 0 },
/* U+186e */ { 19, 0, 1, 0, 0 },
/* U+186f */ { 19, 0, 1, 0, 0 },
/* U+1870 */ { 19, 0, 1, 0, 0 },
/* U+1871 */ { 19, 0, 1, 0, 0 },
/* U+1872 */ { 19, 0, 1, 0, 0 },
/* U+1873 */ { 19, 0, 1, 0, 0 },
/* U+1874 */ { 19, 0, 1, 0, 0 },
/* U+1875 */ { 19, 0, 1, 0, 0 },
/* U+1876 */ { 19, 0, 1, 0, 0 },
/* U+1877 */ { 19, 0, 1, 0, 0 },
/* U+1878 */ { 0, 0, 0, 0, 0 },
/* U+1879 */ { 0, 0, 0, 0, 0 },
/* U+187a */ { 0, 0, 0, 0, 0 },
/* U+187b */ { 0, 0, 0, 0, 0 },
/* U+187c */ { 0, 0, 0, 0, 0 },
/* U+187d */ { 0, 0, 0, 0, 0 },
/* U+187e */ { 0, 0, 0, 0, 0 },
/* U+187f */ { 0, 0, 0, 0, 0 },
/* U+1880 */ { 19, 0, 1, 0, 0 },
/* U+1881 */ { 19, 0, 1, 0, 0 },
/* U+1882 */ { 19, 0, 1, 0, 0 },
/* U+1883 */ { 19, 0, 1, 0, 0 },
/* U+1884 */ { 19, 0, 1, 0, 0 },
/* U+1885 */ { 19, 0, 1, 0, 0 },
/* U+1886 */ { 19, 0, 1, 0, 0 },
/* U+1887 */ { 19, 0, 1, 0, 0 },
/* U+1888 */ { 19, 0, 1, 0, 0 },
/* U+1889 */ { 19, 0, 1, 0, 0 },
/* U+188a */ { 19, 0, 1, 0, 0 },
/* U+188b */ { 19, 0, 1, 0, 0 },
/* U+188c */ { 19, 0, 1, 0, 0 },
/* U+188d */ { 19, 0, 1, 0, 0 },
/* U+188e */ { 19, 0, 1, 0, 0 },
/* U+188f */ { 19, 0, 1, 0, 0 },
/* U+1890 */ { 19, 0, 1, 0, 0 },
/* U+1891 */ { 19, 0, 1, 0, 0 },
/* U+1892 */ { 19, 0, 1, 0, 0 },
/* U+1893 */ { 19, 0, 1, 0, 0 },
/* U+1894 */ { 19, 0, 1, 0, 0 },
/* U+1895 */ { 19, 0, 1, 0, 0 },
/* U+1896 */ { 19, 0, 1, 0, 0 },
/* U+1897 */ { 19, 0, 1, 0, 0 },
/* U+1898 */ { 19, 0, 1, 0, 0 },
/* U+1899 */ { 19, 0, 1, 0, 0 },
/* U+189a */ { 19, 0, 1, 0, 0 },
/* U+189b */ { 19, 0, 1, 0, 0 },
/* U+189c */ { 19, 0, 1, 0, 0 },
/* U+189d */ { 19, 0, 1, 0, 0 },
/* U+189e */ { 19, 0, 1, 0, 0 },
/* U+189f */ { 19, 0, 1, 0, 0 },
/* U+18a0 */ { 19, 0, 1, 0, 0 },
/* U+18a1 */ { 19, 0, 1, 0, 0 },
/* U+18a2 */ { 19, 0, 1, 0, 0 },
/* U+18a3 */ { 19, 0, 1, 0, 0 },
/* U+18a4 */ { 19, 0, 1, 0, 0 },
/* U+18a5 */ { 19, 0, 1, 0, 0 },
/* U+18a6 */ { 19, 0, 1, 0, 0 },
/* U+18a7 */ { 19, 0, 1, 0, 0 },
/* U+18a8 */ { 19, 0, 1, 0, 0 },
/* U+18a9 */ { 4, 228, 14, 0, 0 },
/* U+18aa */ { 0, 0, 0, 0, 0 },
/* U+18ab */ { 0, 0, 0, 0, 0 },
/* U+18ac */ { 0, 0, 0, 0, 0 },
/* U+18ad */ { 0, 0, 0, 0, 0 },
/* U+18ae */ { 0, 0, 0, 0, 0 },
/* U+18af */ { 0, 0, 0, 0, 0 },
/* U+18b0 */ { 0, 0, 0, 0, 0 },
/* U+18b1 */ { 0, 0, 0, 0, 0 },
/* U+18b2 */ { 0, 0, 0, 0, 0 },
/* U+18b3 */ { 0, 0, 0, 0, 0 },
/* U+18b4 */ { 0, 0, 0, 0, 0 },
/* U+18b5 */ { 0, 0, 0, 0, 0 },
/* U+18b6 */ { 0, 0, 0, 0, 0 },
/* U+18b7 */ { 0, 0, 0, 0, 0 },
/* U+18b8 */ { 0, 0, 0, 0, 0 },
/* U+18b9 */ { 0, 0, 0, 0, 0 },
/* U+18ba */ { 0, 0, 0, 0, 0 },
/* U+18bb */ { 0, 0, 0, 0, 0 },
/* U+18bc */ { 0, 0, 0, 0, 0 },
/* U+18bd */ { 0, 0, 0, 0, 0 },
/* U+18be */ { 0, 0, 0, 0, 0 },
/* U+18bf */ { 0, 0, 0, 0, 0 },
/* U+18c0 */ { 0, 0, 0, 0, 0 },
/* U+18c1 */ { 0, 0, 0, 0, 0 },
/* U+18c2 */ { 0, 0, 0, 0, 0 },
/* U+18c3 */ { 0, 0, 0, 0, 0 },
/* U+18c4 */ { 0, 0, 0, 0, 0 },
/* U+18c5 */ { 0, 0, 0, 0, 0 },
/* U+18c6 */ { 0, 0, 0, 0, 0 },
/* U+18c7 */ { 0, 0, 0, 0, 0 },
/* U+18c8 */ { 0, 0, 0, 0, 0 },
/* U+18c9 */ { 0, 0, 0, 0, 0 },
/* U+18ca */ { 0, 0, 0, 0, 0 },
/* U+18cb */ { 0, 0, 0, 0, 0 },
/* U+18cc */ { 0, 0, 0, 0, 0 },
/* U+18cd */ { 0, 0, 0, 0, 0 },
/* U+18ce */ { 0, 0, 0, 0, 0 },
/* U+18cf */ { 0, 0, 0, 0, 0 },
/* U+18d0 */ { 0, 0, 0, 0, 0 },
/* U+18d1 */ { 0, 0, 0, 0, 0 },
/* U+18d2 */ { 0, 0, 0, 0, 0 },
/* U+18d3 */ { 0, 0, 0, 0, 0 },
/* U+18d4 */ { 0, 0, 0, 0, 0 },
/* U+18d5 */ { 0, 0, 0, 0, 0 },
/* U+18d6 */ { 0, 0, 0, 0, 0 },
/* U+18d7 */ { 0, 0, 0, 0, 0 },
/* U+18d8 */ { 0, 0, 0, 0, 0 },
/* U+18d9 */ { 0, 0, 0, 0, 0 },
/* U+18da */ { 0, 0, 0, 0, 0 },
/* U+18db */ { 0, 0, 0, 0, 0 },
/* U+18dc */ { 0, 0, 0, 0, 0 },
/* U+18dd */ { 0, 0, 0, 0, 0 },
/* U+18de */ { 0, 0, 0, 0, 0 },
/* U+18df */ { 0, 0, 0, 0, 0 },
/* U+18e0 */ { 0, 0, 0, 0, 0 },
/* U+18e1 */ { 0, 0, 0, 0, 0 },
/* U+18e2 */ { 0, 0, 0, 0, 0 },
/* U+18e3 */ { 0, 0, 0, 0, 0 },
/* U+18e4 */ { 0, 0, 0, 0, 0 },
/* U+18e5 */ { 0, 0, 0, 0, 0 },
/* U+18e6 */ { 0, 0, 0, 0, 0 },
/* U+18e7 */ { 0, 0, 0, 0, 0 },
/* U+18e8 */ { 0, 0, 0, 0, 0 },
/* U+18e9 */ { 0, 0, 0, 0, 0 },
/* U+18ea */ { 0, 0, 0, 0, 0 },
/* U+18eb */ { 0, 0, 0, 0, 0 },
/* U+18ec */ { 0, 0, 0, 0, 0 },
/* U+18ed */ { 0, 0, 0, 0, 0 },
/* U+18ee */ { 0, 0, 0, 0, 0 },
/* U+18ef */ { 0, 0, 0, 0, 0 },
/* U+18f0 */ { 0, 0, 0, 0, 0 },
/* U+18f1 */ { 0, 0, 0, 0, 0 },
/* U+18f2 */ { 0, 0, 0, 0, 0 },
/* U+18f3 */ { 0, 0, 0, 0, 0 },
/* U+18f4 */ { 0, 0, 0, 0, 0 },
/* U+18f5 */ { 0, 0, 0, 0, 0 },
/* U+18f6 */ { 0, 0, 0, 0, 0 },
/* U+18f7 */ { 0, 0, 0, 0, 0 },
/* U+18f8 */ { 0, 0, 0, 0, 0 },
/* U+18f9 */ { 0, 0, 0, 0, 0 },
/* U+18fa */ { 0, 0, 0, 0, 0 },
/* U+18fb */ { 0, 0, 0, 0, 0 },
/* U+18fc */ { 0, 0, 0, 0, 0 },
/* U+18fd */ { 0, 0, 0, 0, 0 },
/* U+18fe */ { 0, 0, 0, 0, 0 },
/* U+18ff */ { 0, 0, 0, 0, 0 },
/* U+1900 */ { 0, 0, 0, 0, 0 },
/* U+1901 */ { 0, 0, 0, 0, 0 },
/* U+1902 */ { 0, 0, 0, 0, 0 },
/* U+1903 */ { 0, 0, 0, 0, 0 },
/* U+1904 */ { 0, 0, 0, 0, 0 },
/* U+1905 */ { 0, 0, 0, 0, 0 },
/* U+1906 */ { 0, 0, 0, 0, 0 },
/* U+1907 */ { 0, 0, 0, 0, 0 },
/* U+1908 */ { 0, 0, 0, 0, 0 },
/* U+1909 */ { 0, 0, 0, 0, 0 },
/* U+190a */ { 0, 0, 0, 0, 0 },
/* U+190b */ { 0, 0, 0, 0, 0 },
/* U+190c */ { 0, 0, 0, 0, 0 },
/* U+190d */ { 0, 0, 0, 0, 0 },
/* U+190e */ { 0, 0, 0, 0, 0 },
/* U+190f */ { 0, 0, 0, 0, 0 },
/* U+1910 */ { 0, 0, 0, 0, 0 },
/* U+1911 */ { 0, 0, 0, 0, 0 },
/* U+1912 */ { 0, 0, 0, 0, 0 },
/* U+1913 */ { 0, 0, 0, 0, 0 },
/* U+1914 */ { 0, 0, 0, 0, 0 },
/* U+1915 */ { 0, 0, 0, 0, 0 },
/* U+1916 */ { 0, 0, 0, 0, 0 },
/* U+1917 */ { 0, 0, 0, 0, 0 },
/* U+1918 */ { 0, 0, 0, 0, 0 },
/* U+1919 */ { 0, 0, 0, 0, 0 },
/* U+191a */ { 0, 0, 0, 0, 0 },
/* U+191b */ { 0, 0, 0, 0, 0 },
/* U+191c */ { 0, 0, 0, 0, 0 },
/* U+191d */ { 0, 0, 0, 0, 0 },
/* U+191e */ { 0, 0, 0, 0, 0 },
/* U+191f */ { 0, 0, 0, 0, 0 },
/* U+1920 */ { 0, 0, 0, 0, 0 },
/* U+1921 */ { 0, 0, 0, 0, 0 },
/* U+1922 */ { 0, 0, 0, 0, 0 },
/* U+1923 */ { 0, 0, 0, 0, 0 },
/* U+1924 */ { 0, 0, 0, 0, 0 },
/* U+1925 */ { 0, 0, 0, 0, 0 },
/* U+1926 */ { 0, 0, 0, 0, 0 },
/* U+1927 */ { 0, 0, 0, 0, 0 },
/* U+1928 */ { 0, 0, 0, 0, 0 },
/* U+1929 */ { 0, 0, 0, 0, 0 },
/* U+192a */ { 0, 0, 0, 0, 0 },
/* U+192b */ { 0, 0, 0, 0, 0 },
/* U+192c */ { 0, 0, 0, 0, 0 },
/* U+192d */ { 0, 0, 0, 0, 0 },
/* U+192e */ { 0, 0, 0, 0, 0 },
/* U+192f */ { 0, 0, 0, 0, 0 },
/* U+1930 */ { 0, 0, 0, 0, 0 },
/* U+1931 */ { 0, 0, 0, 0, 0 },
/* U+1932 */ { 0, 0, 0, 0, 0 },
/* U+1933 */ { 0, 0, 0, 0, 0 },
/* U+1934 */ { 0, 0, 0, 0, 0 },
/* U+1935 */ { 0, 0, 0, 0, 0 },
/* U+1936 */ { 0, 0, 0, 0, 0 },
/* U+1937 */ { 0, 0, 0, 0, 0 },
/* U+1938 */ { 0, 0, 0, 0, 0 },
/* U+1939 */ { 0, 0, 0, 0, 0 },
/* U+193a */ { 0, 0, 0, 0, 0 },
/* U+193b */ { 0, 0, 0, 0, 0 },
/* U+193c */ { 0, 0, 0, 0, 0 },
/* U+193d */ { 0, 0, 0, 0, 0 },
/* U+193e */ { 0, 0, 0, 0, 0 },
/* U+193f */ { 0, 0, 0, 0, 0 },
/* U+1940 */ { 0, 0, 0, 0, 0 },
/* U+1941 */ { 0, 0, 0, 0, 0 },
/* U+1942 */ { 0, 0, 0, 0, 0 },
/* U+1943 */ { 0, 0, 0, 0, 0 },
/* U+1944 */ { 0, 0, 0, 0, 0 },
/* U+1945 */ { 0, 0, 0, 0, 0 },
/* U+1946 */ { 0, 0, 0, 0, 0 },
/* U+1947 */ { 0, 0, 0, 0, 0 },
/* U+1948 */ { 0, 0, 0, 0, 0 },
/* U+1949 */ { 0, 0, 0, 0, 0 },
/* U+194a */ { 0, 0, 0, 0, 0 },
/* U+194b */ { 0, 0, 0, 0, 0 },
/* U+194c */ { 0, 0, 0, 0, 0 },
/* U+194d */ { 0, 0, 0, 0, 0 },
/* U+194e */ { 0, 0, 0, 0, 0 },
/* U+194f */ { 0, 0, 0, 0, 0 },
/* U+1950 */ { 0, 0, 0, 0, 0 },
/* U+1951 */ { 0, 0, 0, 0, 0 },
/* U+1952 */ { 0, 0, 0, 0, 0 },
/* U+1953 */ { 0, 0, 0, 0, 0 },
/* U+1954 */ { 0, 0, 0, 0, 0 },
/* U+1955 */ { 0, 0, 0, 0, 0 },
/* U+1956 */ { 0, 0, 0, 0, 0 },
/* U+1957 */ { 0, 0, 0, 0, 0 },
/* U+1958 */ { 0, 0, 0, 0, 0 },
/* U+1959 */ { 0, 0, 0, 0, 0 },
/* U+195a */ { 0, 0, 0, 0, 0 },
/* U+195b */ { 0, 0, 0, 0, 0 },
/* U+195c */ { 0, 0, 0, 0, 0 },
/* U+195d */ { 0, 0, 0, 0, 0 },
/* U+195e */ { 0, 0, 0, 0, 0 },
/* U+195f */ { 0, 0, 0, 0, 0 },
/* U+1960 */ { 0, 0, 0, 0, 0 },
/* U+1961 */ { 0, 0, 0, 0, 0 },
/* U+1962 */ { 0, 0, 0, 0, 0 },
/* U+1963 */ { 0, 0, 0, 0, 0 },
/* U+1964 */ { 0, 0, 0, 0, 0 },
/* U+1965 */ { 0, 0, 0, 0, 0 },
/* U+1966 */ { 0, 0, 0, 0, 0 },
/* U+1967 */ { 0, 0, 0, 0, 0 },
/* U+1968 */ { 0, 0, 0, 0, 0 },
/* U+1969 */ { 0, 0, 0, 0, 0 },
/* U+196a */ { 0, 0, 0, 0, 0 },
/* U+196b */ { 0, 0, 0, 0, 0 },
/* U+196c */ { 0, 0, 0, 0, 0 },
/* U+196d */ { 0, 0, 0, 0, 0 },
/* U+196e */ { 0, 0, 0, 0, 0 },
/* U+196f */ { 0, 0, 0, 0, 0 },
/* U+1970 */ { 0, 0, 0, 0, 0 },
/* U+1971 */ { 0, 0, 0, 0, 0 },
/* U+1972 */ { 0, 0, 0, 0, 0 },
/* U+1973 */ { 0, 0, 0, 0, 0 },
/* U+1974 */ { 0, 0, 0, 0, 0 },
/* U+1975 */ { 0, 0, 0, 0, 0 },
/* U+1976 */ { 0, 0, 0, 0, 0 },
/* U+1977 */ { 0, 0, 0, 0, 0 },
/* U+1978 */ { 0, 0, 0, 0, 0 },
/* U+1979 */ { 0, 0, 0, 0, 0 },
/* U+197a */ { 0, 0, 0, 0, 0 },
/* U+197b */ { 0, 0, 0, 0, 0 },
/* U+197c */ { 0, 0, 0, 0, 0 },
/* U+197d */ { 0, 0, 0, 0, 0 },
/* U+197e */ { 0, 0, 0, 0, 0 },
/* U+197f */ { 0, 0, 0, 0, 0 },
/* U+1980 */ { 0, 0, 0, 0, 0 },
/* U+1981 */ { 0, 0, 0, 0, 0 },
/* U+1982 */ { 0, 0, 0, 0, 0 },
/* U+1983 */ { 0, 0, 0, 0, 0 },
/* U+1984 */ { 0, 0, 0, 0, 0 },
/* U+1985 */ { 0, 0, 0, 0, 0 },
/* U+1986 */ { 0, 0, 0, 0, 0 },
/* U+1987 */ { 0, 0, 0, 0, 0 },
/* U+1988 */ { 0, 0, 0, 0, 0 },
/* U+1989 */ { 0, 0, 0, 0, 0 },
/* U+198a */ { 0, 0, 0, 0, 0 },
/* U+198b */ { 0, 0, 0, 0, 0 },
/* U+198c */ { 0, 0, 0, 0, 0 },
/* U+198d */ { 0, 0, 0, 0, 0 },
/* U+198e */ { 0, 0, 0, 0, 0 },
/* U+198f */ { 0, 0, 0, 0, 0 },
/* U+1990 */ { 0, 0, 0, 0, 0 },
/* U+1991 */ { 0, 0, 0, 0, 0 },
/* U+1992 */ { 0, 0, 0, 0, 0 },
/* U+1993 */ { 0, 0, 0, 0, 0 },
/* U+1994 */ { 0, 0, 0, 0, 0 },
/* U+1995 */ { 0, 0, 0, 0, 0 },
/* U+1996 */ { 0, 0, 0, 0, 0 },
/* U+1997 */ { 0, 0, 0, 0, 0 },
/* U+1998 */ { 0, 0, 0, 0, 0 },
/* U+1999 */ { 0, 0, 0, 0, 0 },
/* U+199a */ { 0, 0, 0, 0, 0 },
/* U+199b */ { 0, 0, 0, 0, 0 },
/* U+199c */ { 0, 0, 0, 0, 0 },
/* U+199d */ { 0, 0, 0, 0, 0 },
/* U+199e */ { 0, 0, 0, 0, 0 },
/* U+199f */ { 0, 0, 0, 0, 0 },
/* U+19a0 */ { 0, 0, 0, 0, 0 },
/* U+19a1 */ { 0, 0, 0, 0, 0 },
/* U+19a2 */ { 0, 0, 0, 0, 0 },
/* U+19a3 */ { 0, 0, 0, 0, 0 },
/* U+19a4 */ { 0, 0, 0, 0, 0 },
/* U+19a5 */ { 0, 0, 0, 0, 0 },
/* U+19a6 */ { 0, 0, 0, 0, 0 },
/* U+19a7 */ { 0, 0, 0, 0, 0 },
/* U+19a8 */ { 0, 0, 0, 0, 0 },
/* U+19a9 */ { 0, 0, 0, 0, 0 },
/* U+19aa */ { 0, 0, 0, 0, 0 },
/* U+19ab */ { 0, 0, 0, 0, 0 },
/* U+19ac */ { 0, 0, 0, 0, 0 },
/* U+19ad */ { 0, 0, 0, 0, 0 },
/* U+19ae */ { 0, 0, 0, 0, 0 },
/* U+19af */ { 0, 0, 0, 0, 0 },
/* U+19b0 */ { 0, 0, 0, 0, 0 },
/* U+19b1 */ { 0, 0, 0, 0, 0 },
/* U+19b2 */ { 0, 0, 0, 0, 0 },
/* U+19b3 */ { 0, 0, 0, 0, 0 },
/* U+19b4 */ { 0, 0, 0, 0, 0 },
/* U+19b5 */ { 0, 0, 0, 0, 0 },
/* U+19b6 */ { 0, 0, 0, 0, 0 },
/* U+19b7 */ { 0, 0, 0, 0, 0 },
/* U+19b8 */ { 0, 0, 0, 0, 0 },
/* U+19b9 */ { 0, 0, 0, 0, 0 },
/* U+19ba */ { 0, 0, 0, 0, 0 },
/* U+19bb */ { 0, 0, 0, 0, 0 },
/* U+19bc */ { 0, 0, 0, 0, 0 },
/* U+19bd */ { 0, 0, 0, 0, 0 },
/* U+19be */ { 0, 0, 0, 0, 0 },
/* U+19bf */ { 0, 0, 0, 0, 0 },
/* U+19c0 */ { 0, 0, 0, 0, 0 },
/* U+19c1 */ { 0, 0, 0, 0, 0 },
/* U+19c2 */ { 0, 0, 0, 0, 0 },
/* U+19c3 */ { 0, 0, 0, 0, 0 },
/* U+19c4 */ { 0, 0, 0, 0, 0 },
/* U+19c5 */ { 0, 0, 0, 0, 0 },
/* U+19c6 */ { 0, 0, 0, 0, 0 },
/* U+19c7 */ { 0, 0, 0, 0, 0 },
/* U+19c8 */ { 0, 0, 0, 0, 0 },
/* U+19c9 */ { 0, 0, 0, 0, 0 },
/* U+19ca */ { 0, 0, 0, 0, 0 },
/* U+19cb */ { 0, 0, 0, 0, 0 },
/* U+19cc */ { 0, 0, 0, 0, 0 },
/* U+19cd */ { 0, 0, 0, 0, 0 },
/* U+19ce */ { 0, 0, 0, 0, 0 },
/* U+19cf */ { 0, 0, 0, 0, 0 },
/* U+19d0 */ { 0, 0, 0, 0, 0 },
/* U+19d1 */ { 0, 0, 0, 0, 0 },
/* U+19d2 */ { 0, 0, 0, 0, 0 },
/* U+19d3 */ { 0, 0, 0, 0, 0 },
/* U+19d4 */ { 0, 0, 0, 0, 0 },
/* U+19d5 */ { 0, 0, 0, 0, 0 },
/* U+19d6 */ { 0, 0, 0, 0, 0 },
/* U+19d7 */ { 0, 0, 0, 0, 0 },
/* U+19d8 */ { 0, 0, 0, 0, 0 },
/* U+19d9 */ { 0, 0, 0, 0, 0 },
/* U+19da */ { 0, 0, 0, 0, 0 },
/* U+19db */ { 0, 0, 0, 0, 0 },
/* U+19dc */ { 0, 0, 0, 0, 0 },
/* U+19dd */ { 0, 0, 0, 0, 0 },
/* U+19de */ { 0, 0, 0, 0, 0 },
/* U+19df */ { 0, 0, 0, 0, 0 },
/* U+19e0 */ { 0, 0, 0, 0, 0 },
/* U+19e1 */ { 0, 0, 0, 0, 0 },
/* U+19e2 */ { 0, 0, 0, 0, 0 },
/* U+19e3 */ { 0, 0, 0, 0, 0 },
/* U+19e4 */ { 0, 0, 0, 0, 0 },
/* U+19e5 */ { 0, 0, 0, 0, 0 },
/* U+19e6 */ { 0, 0, 0, 0, 0 },
/* U+19e7 */ { 0, 0, 0, 0, 0 },
/* U+19e8 */ { 0, 0, 0, 0, 0 },
/* U+19e9 */ { 0, 0, 0, 0, 0 },
/* U+19ea */ { 0, 0, 0, 0, 0 },
/* U+19eb */ { 0, 0, 0, 0, 0 },
/* U+19ec */ { 0, 0, 0, 0, 0 },
/* U+19ed */ { 0, 0, 0, 0, 0 },
/* U+19ee */ { 0, 0, 0, 0, 0 },
/* U+19ef */ { 0, 0, 0, 0, 0 },
/* U+19f0 */ { 0, 0, 0, 0, 0 },
/* U+19f1 */ { 0, 0, 0, 0, 0 },
/* U+19f2 */ { 0, 0, 0, 0, 0 },
/* U+19f3 */ { 0, 0, 0, 0, 0 },
/* U+19f4 */ { 0, 0, 0, 0, 0 },
/* U+19f5 */ { 0, 0, 0, 0, 0 },
/* U+19f6 */ { 0, 0, 0, 0, 0 },
/* U+19f7 */ { 0, 0, 0, 0, 0 },
/* U+19f8 */ { 0, 0, 0, 0, 0 },
/* U+19f9 */ { 0, 0, 0, 0, 0 },
/* U+19fa */ { 0, 0, 0, 0, 0 },
/* U+19fb */ { 0, 0, 0, 0, 0 },
/* U+19fc */ { 0, 0, 0, 0, 0 },
/* U+19fd */ { 0, 0, 0, 0, 0 },
/* U+19fe */ { 0, 0, 0, 0, 0 },
/* U+19ff */ { 0, 0, 0, 0, 0 },
/* U+1a00 */ { 0, 0, 0, 0, 0 },
/* U+1a01 */ { 0, 0, 0, 0, 0 },
/* U+1a02 */ { 0, 0, 0, 0, 0 },
/* U+1a03 */ { 0, 0, 0, 0, 0 },
/* U+1a04 */ { 0, 0, 0, 0, 0 },
/* U+1a05 */ { 0, 0, 0, 0, 0 },
/* U+1a06 */ { 0, 0, 0, 0, 0 },
/* U+1a07 */ { 0, 0, 0, 0, 0 },
/* U+1a08 */ { 0, 0, 0, 0, 0 },
/* U+1a09 */ { 0, 0, 0, 0, 0 },
/* U+1a0a */ { 0, 0, 0, 0, 0 },
/* U+1a0b */ { 0, 0, 0, 0, 0 },
/* U+1a0c */ { 0, 0, 0, 0, 0 },
/* U+1a0d */ { 0, 0, 0, 0, 0 },
/* U+1a0e */ { 0, 0, 0, 0, 0 },
/* U+1a0f */ { 0, 0, 0, 0, 0 },
/* U+1a10 */ { 0, 0, 0, 0, 0 },
/* U+1a11 */ { 0, 0, 0, 0, 0 },
/* U+1a12 */ { 0, 0, 0, 0, 0 },
/* U+1a13 */ { 0, 0, 0, 0, 0 },
/* U+1a14 */ { 0, 0, 0, 0, 0 },
/* U+1a15 */ { 0, 0, 0, 0, 0 },
/* U+1a16 */ { 0, 0, 0, 0, 0 },
/* U+1a17 */ { 0, 0, 0, 0, 0 },
/* U+1a18 */ { 0, 0, 0, 0, 0 },
/* U+1a19 */ { 0, 0, 0, 0, 0 },
/* U+1a1a */ { 0, 0, 0, 0, 0 },
/* U+1a1b */ { 0, 0, 0, 0, 0 },
/* U+1a1c */ { 0, 0, 0, 0, 0 },
/* U+1a1d */ { 0, 0, 0, 0, 0 },
/* U+1a1e */ { 0, 0, 0, 0, 0 },
/* U+1a1f */ { 0, 0, 0, 0, 0 },
/* U+1a20 */ { 0, 0, 0, 0, 0 },
/* U+1a21 */ { 0, 0, 0, 0, 0 },
/* U+1a22 */ { 0, 0, 0, 0, 0 },
/* U+1a23 */ { 0, 0, 0, 0, 0 },
/* U+1a24 */ { 0, 0, 0, 0, 0 },
/* U+1a25 */ { 0, 0, 0, 0, 0 },
/* U+1a26 */ { 0, 0, 0, 0, 0 },
/* U+1a27 */ { 0, 0, 0, 0, 0 },
/* U+1a28 */ { 0, 0, 0, 0, 0 },
/* U+1a29 */ { 0, 0, 0, 0, 0 },
/* U+1a2a */ { 0, 0, 0, 0, 0 },
/* U+1a2b */ { 0, 0, 0, 0, 0 },
/* U+1a2c */ { 0, 0, 0, 0, 0 },
/* U+1a2d */ { 0, 0, 0, 0, 0 },
/* U+1a2e */ { 0, 0, 0, 0, 0 },
/* U+1a2f */ { 0, 0, 0, 0, 0 },
/* U+1a30 */ { 0, 0, 0, 0, 0 },
/* U+1a31 */ { 0, 0, 0, 0, 0 },
/* U+1a32 */ { 0, 0, 0, 0, 0 },
/* U+1a33 */ { 0, 0, 0, 0, 0 },
/* U+1a34 */ { 0, 0, 0, 0, 0 },
/* U+1a35 */ { 0, 0, 0, 0, 0 },
/* U+1a36 */ { 0, 0, 0, 0, 0 },
/* U+1a37 */ { 0, 0, 0, 0, 0 },
/* U+1a38 */ { 0, 0, 0, 0, 0 },
/* U+1a39 */ { 0, 0, 0, 0, 0 },
/* U+1a3a */ { 0, 0, 0, 0, 0 },
/* U+1a3b */ { 0, 0, 0, 0, 0 },
/* U+1a3c */ { 0, 0, 0, 0, 0 },
/* U+1a3d */ { 0, 0, 0, 0, 0 },
/* U+1a3e */ { 0, 0, 0, 0, 0 },
/* U+1a3f */ { 0, 0, 0, 0, 0 },
/* U+1a40 */ { 0, 0, 0, 0, 0 },
/* U+1a41 */ { 0, 0, 0, 0, 0 },
/* U+1a42 */ { 0, 0, 0, 0, 0 },
/* U+1a43 */ { 0, 0, 0, 0, 0 },
/* U+1a44 */ { 0, 0, 0, 0, 0 },
/* U+1a45 */ { 0, 0, 0, 0, 0 },
/* U+1a46 */ { 0, 0, 0, 0, 0 },
/* U+1a47 */ { 0, 0, 0, 0, 0 },
/* U+1a48 */ { 0, 0, 0, 0, 0 },
/* U+1a49 */ { 0, 0, 0, 0, 0 },
/* U+1a4a */ { 0, 0, 0, 0, 0 },
/* U+1a4b */ { 0, 0, 0, 0, 0 },
/* U+1a4c */ { 0, 0, 0, 0, 0 },
/* U+1a4d */ { 0, 0, 0, 0, 0 },
/* U+1a4e */ { 0, 0, 0, 0, 0 },
/* U+1a4f */ { 0, 0, 0, 0, 0 },
/* U+1a50 */ { 0, 0, 0, 0, 0 },
/* U+1a51 */ { 0, 0, 0, 0, 0 },
/* U+1a52 */ { 0, 0, 0, 0, 0 },
/* U+1a53 */ { 0, 0, 0, 0, 0 },
/* U+1a54 */ { 0, 0, 0, 0, 0 },
/* U+1a55 */ { 0, 0, 0, 0, 0 },
/* U+1a56 */ { 0, 0, 0, 0, 0 },
/* U+1a57 */ { 0, 0, 0, 0, 0 },
/* U+1a58 */ { 0, 0, 0, 0, 0 },
/* U+1a59 */ { 0, 0, 0, 0, 0 },
/* U+1a5a */ { 0, 0, 0, 0, 0 },
/* U+1a5b */ { 0, 0, 0, 0, 0 },
/* U+1a5c */ { 0, 0, 0, 0, 0 },
/* U+1a5d */ { 0, 0, 0, 0, 0 },
/* U+1a5e */ { 0, 0, 0, 0, 0 },
/* U+1a5f */ { 0, 0, 0, 0, 0 },
/* U+1a60 */ { 0, 0, 0, 0, 0 },
/* U+1a61 */ { 0, 0, 0, 0, 0 },
/* U+1a62 */ { 0, 0, 0, 0, 0 },
/* U+1a63 */ { 0, 0, 0, 0, 0 },
/* U+1a64 */ { 0, 0, 0, 0, 0 },
/* U+1a65 */ { 0, 0, 0, 0, 0 },
/* U+1a66 */ { 0, 0, 0, 0, 0 },
/* U+1a67 */ { 0, 0, 0, 0, 0 },
/* U+1a68 */ { 0, 0, 0, 0, 0 },
/* U+1a69 */ { 0, 0, 0, 0, 0 },
/* U+1a6a */ { 0, 0, 0, 0, 0 },
/* U+1a6b */ { 0, 0, 0, 0, 0 },
/* U+1a6c */ { 0, 0, 0, 0, 0 },
/* U+1a6d */ { 0, 0, 0, 0, 0 },
/* U+1a6e */ { 0, 0, 0, 0, 0 },
/* U+1a6f */ { 0, 0, 0, 0, 0 },
/* U+1a70 */ { 0, 0, 0, 0, 0 },
/* U+1a71 */ { 0, 0, 0, 0, 0 },
/* U+1a72 */ { 0, 0, 0, 0, 0 },
/* U+1a73 */ { 0, 0, 0, 0, 0 },
/* U+1a74 */ { 0, 0, 0, 0, 0 },
/* U+1a75 */ { 0, 0, 0, 0, 0 },
/* U+1a76 */ { 0, 0, 0, 0, 0 },
/* U+1a77 */ { 0, 0, 0, 0, 0 },
/* U+1a78 */ { 0, 0, 0, 0, 0 },
/* U+1a79 */ { 0, 0, 0, 0, 0 },
/* U+1a7a */ { 0, 0, 0, 0, 0 },
/* U+1a7b */ { 0, 0, 0, 0, 0 },
/* U+1a7c */ { 0, 0, 0, 0, 0 },
/* U+1a7d */ { 0, 0, 0, 0, 0 },
/* U+1a7e */ { 0, 0, 0, 0, 0 },
/* U+1a7f */ { 0, 0, 0, 0, 0 },
/* U+1a80 */ { 0, 0, 0, 0, 0 },
/* U+1a81 */ { 0, 0, 0, 0, 0 },
/* U+1a82 */ { 0, 0, 0, 0, 0 },
/* U+1a83 */ { 0, 0, 0, 0, 0 },
/* U+1a84 */ { 0, 0, 0, 0, 0 },
/* U+1a85 */ { 0, 0, 0, 0, 0 },
/* U+1a86 */ { 0, 0, 0, 0, 0 },
/* U+1a87 */ { 0, 0, 0, 0, 0 },
/* U+1a88 */ { 0, 0, 0, 0, 0 },
/* U+1a89 */ { 0, 0, 0, 0, 0 },
/* U+1a8a */ { 0, 0, 0, 0, 0 },
/* U+1a8b */ { 0, 0, 0, 0, 0 },
/* U+1a8c */ { 0, 0, 0, 0, 0 },
/* U+1a8d */ { 0, 0, 0, 0, 0 },
/* U+1a8e */ { 0, 0, 0, 0, 0 },
/* U+1a8f */ { 0, 0, 0, 0, 0 },
/* U+1a90 */ { 0, 0, 0, 0, 0 },
/* U+1a91 */ { 0, 0, 0, 0, 0 },
/* U+1a92 */ { 0, 0, 0, 0, 0 },
/* U+1a93 */ { 0, 0, 0, 0, 0 },
/* U+1a94 */ { 0, 0, 0, 0, 0 },
/* U+1a95 */ { 0, 0, 0, 0, 0 },
/* U+1a96 */ { 0, 0, 0, 0, 0 },
/* U+1a97 */ { 0, 0, 0, 0, 0 },
/* U+1a98 */ { 0, 0, 0, 0, 0 },
/* U+1a99 */ { 0, 0, 0, 0, 0 },
/* U+1a9a */ { 0, 0, 0, 0, 0 },
/* U+1a9b */ { 0, 0, 0, 0, 0 },
/* U+1a9c */ { 0, 0, 0, 0, 0 },
/* U+1a9d */ { 0, 0, 0, 0, 0 },
/* U+1a9e */ { 0, 0, 0, 0, 0 },
/* U+1a9f */ { 0, 0, 0, 0, 0 },
/* U+1aa0 */ { 0, 0, 0, 0, 0 },
/* U+1aa1 */ { 0, 0, 0, 0, 0 },
/* U+1aa2 */ { 0, 0, 0, 0, 0 },
/* U+1aa3 */ { 0, 0, 0, 0, 0 },
/* U+1aa4 */ { 0, 0, 0, 0, 0 },
/* U+1aa5 */ { 0, 0, 0, 0, 0 },
/* U+1aa6 */ { 0, 0, 0, 0, 0 },
/* U+1aa7 */ { 0, 0, 0, 0, 0 },
/* U+1aa8 */ { 0, 0, 0, 0, 0 },
/* U+1aa9 */ { 0, 0, 0, 0, 0 },
/* U+1aaa */ { 0, 0, 0, 0, 0 },
/* U+1aab */ { 0, 0, 0, 0, 0 },
/* U+1aac */ { 0, 0, 0, 0, 0 },
/* U+1aad */ { 0, 0, 0, 0, 0 },
/* U+1aae */ { 0, 0, 0, 0, 0 },
/* U+1aaf */ { 0, 0, 0, 0, 0 },
/* U+1ab0 */ { 0, 0, 0, 0, 0 },
/* U+1ab1 */ { 0, 0, 0, 0, 0 },
/* U+1ab2 */ { 0, 0, 0, 0, 0 },
/* U+1ab3 */ { 0, 0, 0, 0, 0 },
/* U+1ab4 */ { 0, 0, 0, 0, 0 },
/* U+1ab5 */ { 0, 0, 0, 0, 0 },
/* U+1ab6 */ { 0, 0, 0, 0, 0 },
/* U+1ab7 */ { 0, 0, 0, 0, 0 },
/* U+1ab8 */ { 0, 0, 0, 0, 0 },
/* U+1ab9 */ { 0, 0, 0, 0, 0 },
/* U+1aba */ { 0, 0, 0, 0, 0 },
/* U+1abb */ { 0, 0, 0, 0, 0 },
/* U+1abc */ { 0, 0, 0, 0, 0 },
/* U+1abd */ { 0, 0, 0, 0, 0 },
/* U+1abe */ { 0, 0, 0, 0, 0 },
/* U+1abf */ { 0, 0, 0, 0, 0 },
/* U+1ac0 */ { 0, 0, 0, 0, 0 },
/* U+1ac1 */ { 0, 0, 0, 0, 0 },
/* U+1ac2 */ { 0, 0, 0, 0, 0 },
/* U+1ac3 */ { 0, 0, 0, 0, 0 },
/* U+1ac4 */ { 0, 0, 0, 0, 0 },
/* U+1ac5 */ { 0, 0, 0, 0, 0 },
/* U+1ac6 */ { 0, 0, 0, 0, 0 },
/* U+1ac7 */ { 0, 0, 0, 0, 0 },
/* U+1ac8 */ { 0, 0, 0, 0, 0 },
/* U+1ac9 */ { 0, 0, 0, 0, 0 },
/* U+1aca */ { 0, 0, 0, 0, 0 },
/* U+1acb */ { 0, 0, 0, 0, 0 },
/* U+1acc */ { 0, 0, 0, 0, 0 },
/* U+1acd */ { 0, 0, 0, 0, 0 },
/* U+1ace */ { 0, 0, 0, 0, 0 },
/* U+1acf */ { 0, 0, 0, 0, 0 },
/* U+1ad0 */ { 0, 0, 0, 0, 0 },
/* U+1ad1 */ { 0, 0, 0, 0, 0 },
/* U+1ad2 */ { 0, 0, 0, 0, 0 },
/* U+1ad3 */ { 0, 0, 0, 0, 0 },
/* U+1ad4 */ { 0, 0, 0, 0, 0 },
/* U+1ad5 */ { 0, 0, 0, 0, 0 },
/* U+1ad6 */ { 0, 0, 0, 0, 0 },
/* U+1ad7 */ { 0, 0, 0, 0, 0 },
/* U+1ad8 */ { 0, 0, 0, 0, 0 },
/* U+1ad9 */ { 0, 0, 0, 0, 0 },
/* U+1ada */ { 0, 0, 0, 0, 0 },
/* U+1adb */ { 0, 0, 0, 0, 0 },
/* U+1adc */ { 0, 0, 0, 0, 0 },
/* U+1add */ { 0, 0, 0, 0, 0 },
/* U+1ade */ { 0, 0, 0, 0, 0 },
/* U+1adf */ { 0, 0, 0, 0, 0 },
/* U+1ae0 */ { 0, 0, 0, 0, 0 },
/* U+1ae1 */ { 0, 0, 0, 0, 0 },
/* U+1ae2 */ { 0, 0, 0, 0, 0 },
/* U+1ae3 */ { 0, 0, 0, 0, 0 },
/* U+1ae4 */ { 0, 0, 0, 0, 0 },
/* U+1ae5 */ { 0, 0, 0, 0, 0 },
/* U+1ae6 */ { 0, 0, 0, 0, 0 },
/* U+1ae7 */ { 0, 0, 0, 0, 0 },
/* U+1ae8 */ { 0, 0, 0, 0, 0 },
/* U+1ae9 */ { 0, 0, 0, 0, 0 },
/* U+1aea */ { 0, 0, 0, 0, 0 },
/* U+1aeb */ { 0, 0, 0, 0, 0 },
/* U+1aec */ { 0, 0, 0, 0, 0 },
/* U+1aed */ { 0, 0, 0, 0, 0 },
/* U+1aee */ { 0, 0, 0, 0, 0 },
/* U+1aef */ { 0, 0, 0, 0, 0 },
/* U+1af0 */ { 0, 0, 0, 0, 0 },
/* U+1af1 */ { 0, 0, 0, 0, 0 },
/* U+1af2 */ { 0, 0, 0, 0, 0 },
/* U+1af3 */ { 0, 0, 0, 0, 0 },
/* U+1af4 */ { 0, 0, 0, 0, 0 },
/* U+1af5 */ { 0, 0, 0, 0, 0 },
/* U+1af6 */ { 0, 0, 0, 0, 0 },
/* U+1af7 */ { 0, 0, 0, 0, 0 },
/* U+1af8 */ { 0, 0, 0, 0, 0 },
/* U+1af9 */ { 0, 0, 0, 0, 0 },
/* U+1afa */ { 0, 0, 0, 0, 0 },
/* U+1afb */ { 0, 0, 0, 0, 0 },
/* U+1afc */ { 0, 0, 0, 0, 0 },
/* U+1afd */ { 0, 0, 0, 0, 0 },
/* U+1afe */ { 0, 0, 0, 0, 0 },
/* U+1aff */ { 0, 0, 0, 0, 0 },
/* U+1b00 */ { 0, 0, 0, 0, 0 },
/* U+1b01 */ { 0, 0, 0, 0, 0 },
/* U+1b02 */ { 0, 0, 0, 0, 0 },
/* U+1b03 */ { 0, 0, 0, 0, 0 },
/* U+1b04 */ { 0, 0, 0, 0, 0 },
/* U+1b05 */ { 0, 0, 0, 0, 0 },
/* U+1b06 */ { 0, 0, 0, 0, 0 },
/* U+1b07 */ { 0, 0, 0, 0, 0 },
/* U+1b08 */ { 0, 0, 0, 0, 0 },
/* U+1b09 */ { 0, 0, 0, 0, 0 },
/* U+1b0a */ { 0, 0, 0, 0, 0 },
/* U+1b0b */ { 0, 0, 0, 0, 0 },
/* U+1b0c */ { 0, 0, 0, 0, 0 },
/* U+1b0d */ { 0, 0, 0, 0, 0 },
/* U+1b0e */ { 0, 0, 0, 0, 0 },
/* U+1b0f */ { 0, 0, 0, 0, 0 },
/* U+1b10 */ { 0, 0, 0, 0, 0 },
/* U+1b11 */ { 0, 0, 0, 0, 0 },
/* U+1b12 */ { 0, 0, 0, 0, 0 },
/* U+1b13 */ { 0, 0, 0, 0, 0 },
/* U+1b14 */ { 0, 0, 0, 0, 0 },
/* U+1b15 */ { 0, 0, 0, 0, 0 },
/* U+1b16 */ { 0, 0, 0, 0, 0 },
/* U+1b17 */ { 0, 0, 0, 0, 0 },
/* U+1b18 */ { 0, 0, 0, 0, 0 },
/* U+1b19 */ { 0, 0, 0, 0, 0 },
/* U+1b1a */ { 0, 0, 0, 0, 0 },
/* U+1b1b */ { 0, 0, 0, 0, 0 },
/* U+1b1c */ { 0, 0, 0, 0, 0 },
/* U+1b1d */ { 0, 0, 0, 0, 0 },
/* U+1b1e */ { 0, 0, 0, 0, 0 },
/* U+1b1f */ { 0, 0, 0, 0, 0 },
/* U+1b20 */ { 0, 0, 0, 0, 0 },
/* U+1b21 */ { 0, 0, 0, 0, 0 },
/* U+1b22 */ { 0, 0, 0, 0, 0 },
/* U+1b23 */ { 0, 0, 0, 0, 0 },
/* U+1b24 */ { 0, 0, 0, 0, 0 },
/* U+1b25 */ { 0, 0, 0, 0, 0 },
/* U+1b26 */ { 0, 0, 0, 0, 0 },
/* U+1b27 */ { 0, 0, 0, 0, 0 },
/* U+1b28 */ { 0, 0, 0, 0, 0 },
/* U+1b29 */ { 0, 0, 0, 0, 0 },
/* U+1b2a */ { 0, 0, 0, 0, 0 },
/* U+1b2b */ { 0, 0, 0, 0, 0 },
/* U+1b2c */ { 0, 0, 0, 0, 0 },
/* U+1b2d */ { 0, 0, 0, 0, 0 },
/* U+1b2e */ { 0, 0, 0, 0, 0 },
/* U+1b2f */ { 0, 0, 0, 0, 0 },
/* U+1b30 */ { 0, 0, 0, 0, 0 },
/* U+1b31 */ { 0, 0, 0, 0, 0 },
/* U+1b32 */ { 0, 0, 0, 0, 0 },
/* U+1b33 */ { 0, 0, 0, 0, 0 },
/* U+1b34 */ { 0, 0, 0, 0, 0 },
/* U+1b35 */ { 0, 0, 0, 0, 0 },
/* U+1b36 */ { 0, 0, 0, 0, 0 },
/* U+1b37 */ { 0, 0, 0, 0, 0 },
/* U+1b38 */ { 0, 0, 0, 0, 0 },
/* U+1b39 */ { 0, 0, 0, 0, 0 },
/* U+1b3a */ { 0, 0, 0, 0, 0 },
/* U+1b3b */ { 0, 0, 0, 0, 0 },
/* U+1b3c */ { 0, 0, 0, 0, 0 },
/* U+1b3d */ { 0, 0, 0, 0, 0 },
/* U+1b3e */ { 0, 0, 0, 0, 0 },
/* U+1b3f */ { 0, 0, 0, 0, 0 },
/* U+1b40 */ { 0, 0, 0, 0, 0 },
/* U+1b41 */ { 0, 0, 0, 0, 0 },
/* U+1b42 */ { 0, 0, 0, 0, 0 },
/* U+1b43 */ { 0, 0, 0, 0, 0 },
/* U+1b44 */ { 0, 0, 0, 0, 0 },
/* U+1b45 */ { 0, 0, 0, 0, 0 },
/* U+1b46 */ { 0, 0, 0, 0, 0 },
/* U+1b47 */ { 0, 0, 0, 0, 0 },
/* U+1b48 */ { 0, 0, 0, 0, 0 },
/* U+1b49 */ { 0, 0, 0, 0, 0 },
/* U+1b4a */ { 0, 0, 0, 0, 0 },
/* U+1b4b */ { 0, 0, 0, 0, 0 },
/* U+1b4c */ { 0, 0, 0, 0, 0 },
/* U+1b4d */ { 0, 0, 0, 0, 0 },
/* U+1b4e */ { 0, 0, 0, 0, 0 },
/* U+1b4f */ { 0, 0, 0, 0, 0 },
/* U+1b50 */ { 0, 0, 0, 0, 0 },
/* U+1b51 */ { 0, 0, 0, 0, 0 },
/* U+1b52 */ { 0, 0, 0, 0, 0 },
/* U+1b53 */ { 0, 0, 0, 0, 0 },
/* U+1b54 */ { 0, 0, 0, 0, 0 },
/* U+1b55 */ { 0, 0, 0, 0, 0 },
/* U+1b56 */ { 0, 0, 0, 0, 0 },
/* U+1b57 */ { 0, 0, 0, 0, 0 },
/* U+1b58 */ { 0, 0, 0, 0, 0 },
/* U+1b59 */ { 0, 0, 0, 0, 0 },
/* U+1b5a */ { 0, 0, 0, 0, 0 },
/* U+1b5b */ { 0, 0, 0, 0, 0 },
/* U+1b5c */ { 0, 0, 0, 0, 0 },
/* U+1b5d */ { 0, 0, 0, 0, 0 },
/* U+1b5e */ { 0, 0, 0, 0, 0 },
/* U+1b5f */ { 0, 0, 0, 0, 0 },
/* U+1b60 */ { 0, 0, 0, 0, 0 },
/* U+1b61 */ { 0, 0, 0, 0, 0 },
/* U+1b62 */ { 0, 0, 0, 0, 0 },
/* U+1b63 */ { 0, 0, 0, 0, 0 },
/* U+1b64 */ { 0, 0, 0, 0, 0 },
/* U+1b65 */ { 0, 0, 0, 0, 0 },
/* U+1b66 */ { 0, 0, 0, 0, 0 },
/* U+1b67 */ { 0, 0, 0, 0, 0 },
/* U+1b68 */ { 0, 0, 0, 0, 0 },
/* U+1b69 */ { 0, 0, 0, 0, 0 },
/* U+1b6a */ { 0, 0, 0, 0, 0 },
/* U+1b6b */ { 0, 0, 0, 0, 0 },
/* U+1b6c */ { 0, 0, 0, 0, 0 },
/* U+1b6d */ { 0, 0, 0, 0, 0 },
/* U+1b6e */ { 0, 0, 0, 0, 0 },
/* U+1b6f */ { 0, 0, 0, 0, 0 },
/* U+1b70 */ { 0, 0, 0, 0, 0 },
/* U+1b71 */ { 0, 0, 0, 0, 0 },
/* U+1b72 */ { 0, 0, 0, 0, 0 },
/* U+1b73 */ { 0, 0, 0, 0, 0 },
/* U+1b74 */ { 0, 0, 0, 0, 0 },
/* U+1b75 */ { 0, 0, 0, 0, 0 },
/* U+1b76 */ { 0, 0, 0, 0, 0 },
/* U+1b77 */ { 0, 0, 0, 0, 0 },
/* U+1b78 */ { 0, 0, 0, 0, 0 },
/* U+1b79 */ { 0, 0, 0, 0, 0 },
/* U+1b7a */ { 0, 0, 0, 0, 0 },
/* U+1b7b */ { 0, 0, 0, 0, 0 },
/* U+1b7c */ { 0, 0, 0, 0, 0 },
/* U+1b7d */ { 0, 0, 0, 0, 0 },
/* U+1b7e */ { 0, 0, 0, 0, 0 },
/* U+1b7f */ { 0, 0, 0, 0, 0 },
/* U+1b80 */ { 0, 0, 0, 0, 0 },
/* U+1b81 */ { 0, 0, 0, 0, 0 },
/* U+1b82 */ { 0, 0, 0, 0, 0 },
/* U+1b83 */ { 0, 0, 0, 0, 0 },
/* U+1b84 */ { 0, 0, 0, 0, 0 },
/* U+1b85 */ { 0, 0, 0, 0, 0 },
/* U+1b86 */ { 0, 0, 0, 0, 0 },
/* U+1b87 */ { 0, 0, 0, 0, 0 },
/* U+1b88 */ { 0, 0, 0, 0, 0 },
/* U+1b89 */ { 0, 0, 0, 0, 0 },
/* U+1b8a */ { 0, 0, 0, 0, 0 },
/* U+1b8b */ { 0, 0, 0, 0, 0 },
/* U+1b8c */ { 0, 0, 0, 0, 0 },
/* U+1b8d */ { 0, 0, 0, 0, 0 },
/* U+1b8e */ { 0, 0, 0, 0, 0 },
/* U+1b8f */ { 0, 0, 0, 0, 0 },
/* U+1b90 */ { 0, 0, 0, 0, 0 },
/* U+1b91 */ { 0, 0, 0, 0, 0 },
/* U+1b92 */ { 0, 0, 0, 0, 0 },
/* U+1b93 */ { 0, 0, 0, 0, 0 },
/* U+1b94 */ { 0, 0, 0, 0, 0 },
/* U+1b95 */ { 0, 0, 0, 0, 0 },
/* U+1b96 */ { 0, 0, 0, 0, 0 },
/* U+1b97 */ { 0, 0, 0, 0, 0 },
/* U+1b98 */ { 0, 0, 0, 0, 0 },
/* U+1b99 */ { 0, 0, 0, 0, 0 },
/* U+1b9a */ { 0, 0, 0, 0, 0 },
/* U+1b9b */ { 0, 0, 0, 0, 0 },
/* U+1b9c */ { 0, 0, 0, 0, 0 },
/* U+1b9d */ { 0, 0, 0, 0, 0 },
/* U+1b9e */ { 0, 0, 0, 0, 0 },
/* U+1b9f */ { 0, 0, 0, 0, 0 },
/* U+1ba0 */ { 0, 0, 0, 0, 0 },
/* U+1ba1 */ { 0, 0, 0, 0, 0 },
/* U+1ba2 */ { 0, 0, 0, 0, 0 },
/* U+1ba3 */ { 0, 0, 0, 0, 0 },
/* U+1ba4 */ { 0, 0, 0, 0, 0 },
/* U+1ba5 */ { 0, 0, 0, 0, 0 },
/* U+1ba6 */ { 0, 0, 0, 0, 0 },
/* U+1ba7 */ { 0, 0, 0, 0, 0 },
/* U+1ba8 */ { 0, 0, 0, 0, 0 },
/* U+1ba9 */ { 0, 0, 0, 0, 0 },
/* U+1baa */ { 0, 0, 0, 0, 0 },
/* U+1bab */ { 0, 0, 0, 0, 0 },
/* U+1bac */ { 0, 0, 0, 0, 0 },
/* U+1bad */ { 0, 0, 0, 0, 0 },
/* U+1bae */ { 0, 0, 0, 0, 0 },
/* U+1baf */ { 0, 0, 0, 0, 0 },
/* U+1bb0 */ { 0, 0, 0, 0, 0 },
/* U+1bb1 */ { 0, 0, 0, 0, 0 },
/* U+1bb2 */ { 0, 0, 0, 0, 0 },
/* U+1bb3 */ { 0, 0, 0, 0, 0 },
/* U+1bb4 */ { 0, 0, 0, 0, 0 },
/* U+1bb5 */ { 0, 0, 0, 0, 0 },
/* U+1bb6 */ { 0, 0, 0, 0, 0 },
/* U+1bb7 */ { 0, 0, 0, 0, 0 },
/* U+1bb8 */ { 0, 0, 0, 0, 0 },
/* U+1bb9 */ { 0, 0, 0, 0, 0 },
/* U+1bba */ { 0, 0, 0, 0, 0 },
/* U+1bbb */ { 0, 0, 0, 0, 0 },
/* U+1bbc */ { 0, 0, 0, 0, 0 },
/* U+1bbd */ { 0, 0, 0, 0, 0 },
/* U+1bbe */ { 0, 0, 0, 0, 0 },
/* U+1bbf */ { 0, 0, 0, 0, 0 },
/* U+1bc0 */ { 0, 0, 0, 0, 0 },
/* U+1bc1 */ { 0, 0, 0, 0, 0 },
/* U+1bc2 */ { 0, 0, 0, 0, 0 },
/* U+1bc3 */ { 0, 0, 0, 0, 0 },
/* U+1bc4 */ { 0, 0, 0, 0, 0 },
/* U+1bc5 */ { 0, 0, 0, 0, 0 },
/* U+1bc6 */ { 0, 0, 0, 0, 0 },
/* U+1bc7 */ { 0, 0, 0, 0, 0 },
/* U+1bc8 */ { 0, 0, 0, 0, 0 },
/* U+1bc9 */ { 0, 0, 0, 0, 0 },
/* U+1bca */ { 0, 0, 0, 0, 0 },
/* U+1bcb */ { 0, 0, 0, 0, 0 },
/* U+1bcc */ { 0, 0, 0, 0, 0 },
/* U+1bcd */ { 0, 0, 0, 0, 0 },
/* U+1bce */ { 0, 0, 0, 0, 0 },
/* U+1bcf */ { 0, 0, 0, 0, 0 },
/* U+1bd0 */ { 0, 0, 0, 0, 0 },
/* U+1bd1 */ { 0, 0, 0, 0, 0 },
/* U+1bd2 */ { 0, 0, 0, 0, 0 },
/* U+1bd3 */ { 0, 0, 0, 0, 0 },
/* U+1bd4 */ { 0, 0, 0, 0, 0 },
/* U+1bd5 */ { 0, 0, 0, 0, 0 },
/* U+1bd6 */ { 0, 0, 0, 0, 0 },
/* U+1bd7 */ { 0, 0, 0, 0, 0 },
/* U+1bd8 */ { 0, 0, 0, 0, 0 },
/* U+1bd9 */ { 0, 0, 0, 0, 0 },
/* U+1bda */ { 0, 0, 0, 0, 0 },
/* U+1bdb */ { 0, 0, 0, 0, 0 },
/* U+1bdc */ { 0, 0, 0, 0, 0 },
/* U+1bdd */ { 0, 0, 0, 0, 0 },
/* U+1bde */ { 0, 0, 0, 0, 0 },
/* U+1bdf */ { 0, 0, 0, 0, 0 },
/* U+1be0 */ { 0, 0, 0, 0, 0 },
/* U+1be1 */ { 0, 0, 0, 0, 0 },
/* U+1be2 */ { 0, 0, 0, 0, 0 },
/* U+1be3 */ { 0, 0, 0, 0, 0 },
/* U+1be4 */ { 0, 0, 0, 0, 0 },
/* U+1be5 */ { 0, 0, 0, 0, 0 },
/* U+1be6 */ { 0, 0, 0, 0, 0 },
/* U+1be7 */ { 0, 0, 0, 0, 0 },
/* U+1be8 */ { 0, 0, 0, 0, 0 },
/* U+1be9 */ { 0, 0, 0, 0, 0 },
/* U+1bea */ { 0, 0, 0, 0, 0 },
/* U+1beb */ { 0, 0, 0, 0, 0 },
/* U+1bec */ { 0, 0, 0, 0, 0 },
/* U+1bed */ { 0, 0, 0, 0, 0 },
/* U+1bee */ { 0, 0, 0, 0, 0 },
/* U+1bef */ { 0, 0, 0, 0, 0 },
/* U+1bf0 */ { 0, 0, 0, 0, 0 },
/* U+1bf1 */ { 0, 0, 0, 0, 0 },
/* U+1bf2 */ { 0, 0, 0, 0, 0 },
/* U+1bf3 */ { 0, 0, 0, 0, 0 },
/* U+1bf4 */ { 0, 0, 0, 0, 0 },
/* U+1bf5 */ { 0, 0, 0, 0, 0 },
/* U+1bf6 */ { 0, 0, 0, 0, 0 },
/* U+1bf7 */ { 0, 0, 0, 0, 0 },
/* U+1bf8 */ { 0, 0, 0, 0, 0 },
/* U+1bf9 */ { 0, 0, 0, 0, 0 },
/* U+1bfa */ { 0, 0, 0, 0, 0 },
/* U+1bfb */ { 0, 0, 0, 0, 0 },
/* U+1bfc */ { 0, 0, 0, 0, 0 },
/* U+1bfd */ { 0, 0, 0, 0, 0 },
/* U+1bfe */ { 0, 0, 0, 0, 0 },
/* U+1bff */ { 0, 0, 0, 0, 0 },
/* U+1c00 */ { 0, 0, 0, 0, 0 },
/* U+1c01 */ { 0, 0, 0, 0, 0 },
/* U+1c02 */ { 0, 0, 0, 0, 0 },
/* U+1c03 */ { 0, 0, 0, 0, 0 },
/* U+1c04 */ { 0, 0, 0, 0, 0 },
/* U+1c05 */ { 0, 0, 0, 0, 0 },
/* U+1c06 */ { 0, 0, 0, 0, 0 },
/* U+1c07 */ { 0, 0, 0, 0, 0 },
/* U+1c08 */ { 0, 0, 0, 0, 0 },
/* U+1c09 */ { 0, 0, 0, 0, 0 },
/* U+1c0a */ { 0, 0, 0, 0, 0 },
/* U+1c0b */ { 0, 0, 0, 0, 0 },
/* U+1c0c */ { 0, 0, 0, 0, 0 },
/* U+1c0d */ { 0, 0, 0, 0, 0 },
/* U+1c0e */ { 0, 0, 0, 0, 0 },
/* U+1c0f */ { 0, 0, 0, 0, 0 },
/* U+1c10 */ { 0, 0, 0, 0, 0 },
/* U+1c11 */ { 0, 0, 0, 0, 0 },
/* U+1c12 */ { 0, 0, 0, 0, 0 },
/* U+1c13 */ { 0, 0, 0, 0, 0 },
/* U+1c14 */ { 0, 0, 0, 0, 0 },
/* U+1c15 */ { 0, 0, 0, 0, 0 },
/* U+1c16 */ { 0, 0, 0, 0, 0 },
/* U+1c17 */ { 0, 0, 0, 0, 0 },
/* U+1c18 */ { 0, 0, 0, 0, 0 },
/* U+1c19 */ { 0, 0, 0, 0, 0 },
/* U+1c1a */ { 0, 0, 0, 0, 0 },
/* U+1c1b */ { 0, 0, 0, 0, 0 },
/* U+1c1c */ { 0, 0, 0, 0, 0 },
/* U+1c1d */ { 0, 0, 0, 0, 0 },
/* U+1c1e */ { 0, 0, 0, 0, 0 },
/* U+1c1f */ { 0, 0, 0, 0, 0 },
/* U+1c20 */ { 0, 0, 0, 0, 0 },
/* U+1c21 */ { 0, 0, 0, 0, 0 },
/* U+1c22 */ { 0, 0, 0, 0, 0 },
/* U+1c23 */ { 0, 0, 0, 0, 0 },
/* U+1c24 */ { 0, 0, 0, 0, 0 },
/* U+1c25 */ { 0, 0, 0, 0, 0 },
/* U+1c26 */ { 0, 0, 0, 0, 0 },
/* U+1c27 */ { 0, 0, 0, 0, 0 },
/* U+1c28 */ { 0, 0, 0, 0, 0 },
/* U+1c29 */ { 0, 0, 0, 0, 0 },
/* U+1c2a */ { 0, 0, 0, 0, 0 },
/* U+1c2b */ { 0, 0, 0, 0, 0 },
/* U+1c2c */ { 0, 0, 0, 0, 0 },
/* U+1c2d */ { 0, 0, 0, 0, 0 },
/* U+1c2e */ { 0, 0, 0, 0, 0 },
/* U+1c2f */ { 0, 0, 0, 0, 0 },
/* U+1c30 */ { 0, 0, 0, 0, 0 },
/* U+1c31 */ { 0, 0, 0, 0, 0 },
/* U+1c32 */ { 0, 0, 0, 0, 0 },
/* U+1c33 */ { 0, 0, 0, 0, 0 },
/* U+1c34 */ { 0, 0, 0, 0, 0 },
/* U+1c35 */ { 0, 0, 0, 0, 0 },
/* U+1c36 */ { 0, 0, 0, 0, 0 },
/* U+1c37 */ { 0, 0, 0, 0, 0 },
/* U+1c38 */ { 0, 0, 0, 0, 0 },
/* U+1c39 */ { 0, 0, 0, 0, 0 },
/* U+1c3a */ { 0, 0, 0, 0, 0 },
/* U+1c3b */ { 0, 0, 0, 0, 0 },
/* U+1c3c */ { 0, 0, 0, 0, 0 },
/* U+1c3d */ { 0, 0, 0, 0, 0 },
/* U+1c3e */ { 0, 0, 0, 0, 0 },
/* U+1c3f */ { 0, 0, 0, 0, 0 },
/* U+1c40 */ { 0, 0, 0, 0, 0 },
/* U+1c41 */ { 0, 0, 0, 0, 0 },
/* U+1c42 */ { 0, 0, 0, 0, 0 },
/* U+1c43 */ { 0, 0, 0, 0, 0 },
/* U+1c44 */ { 0, 0, 0, 0, 0 },
/* U+1c45 */ { 0, 0, 0, 0, 0 },
/* U+1c46 */ { 0, 0, 0, 0, 0 },
/* U+1c47 */ { 0, 0, 0, 0, 0 },
/* U+1c48 */ { 0, 0, 0, 0, 0 },
/* U+1c49 */ { 0, 0, 0, 0, 0 },
/* U+1c4a */ { 0, 0, 0, 0, 0 },
/* U+1c4b */ { 0, 0, 0, 0, 0 },
/* U+1c4c */ { 0, 0, 0, 0, 0 },
/* U+1c4d */ { 0, 0, 0, 0, 0 },
/* U+1c4e */ { 0, 0, 0, 0, 0 },
/* U+1c4f */ { 0, 0, 0, 0, 0 },
/* U+1c50 */ { 0, 0, 0, 0, 0 },
/* U+1c51 */ { 0, 0, 0, 0, 0 },
/* U+1c52 */ { 0, 0, 0, 0, 0 },
/* U+1c53 */ { 0, 0, 0, 0, 0 },
/* U+1c54 */ { 0, 0, 0, 0, 0 },
/* U+1c55 */ { 0, 0, 0, 0, 0 },
/* U+1c56 */ { 0, 0, 0, 0, 0 },
/* U+1c57 */ { 0, 0, 0, 0, 0 },
/* U+1c58 */ { 0, 0, 0, 0, 0 },
/* U+1c59 */ { 0, 0, 0, 0, 0 },
/* U+1c5a */ { 0, 0, 0, 0, 0 },
/* U+1c5b */ { 0, 0, 0, 0, 0 },
/* U+1c5c */ { 0, 0, 0, 0, 0 },
/* U+1c5d */ { 0, 0, 0, 0, 0 },
/* U+1c5e */ { 0, 0, 0, 0, 0 },
/* U+1c5f */ { 0, 0, 0, 0, 0 },
/* U+1c60 */ { 0, 0, 0, 0, 0 },
/* U+1c61 */ { 0, 0, 0, 0, 0 },
/* U+1c62 */ { 0, 0, 0, 0, 0 },
/* U+1c63 */ { 0, 0, 0, 0, 0 },
/* U+1c64 */ { 0, 0, 0, 0, 0 },
/* U+1c65 */ { 0, 0, 0, 0, 0 },
/* U+1c66 */ { 0, 0, 0, 0, 0 },
/* U+1c67 */ { 0, 0, 0, 0, 0 },
/* U+1c68 */ { 0, 0, 0, 0, 0 },
/* U+1c69 */ { 0, 0, 0, 0, 0 },
/* U+1c6a */ { 0, 0, 0, 0, 0 },
/* U+1c6b */ { 0, 0, 0, 0, 0 },
/* U+1c6c */ { 0, 0, 0, 0, 0 },
/* U+1c6d */ { 0, 0, 0, 0, 0 },
/* U+1c6e */ { 0, 0, 0, 0, 0 },
/* U+1c6f */ { 0, 0, 0, 0, 0 },
/* U+1c70 */ { 0, 0, 0, 0, 0 },
/* U+1c71 */ { 0, 0, 0, 0, 0 },
/* U+1c72 */ { 0, 0, 0, 0, 0 },
/* U+1c73 */ { 0, 0, 0, 0, 0 },
/* U+1c74 */ { 0, 0, 0, 0, 0 },
/* U+1c75 */ { 0, 0, 0, 0, 0 },
/* U+1c76 */ { 0, 0, 0, 0, 0 },
/* U+1c77 */ { 0, 0, 0, 0, 0 },
/* U+1c78 */ { 0, 0, 0, 0, 0 },
/* U+1c79 */ { 0, 0, 0, 0, 0 },
/* U+1c7a */ { 0, 0, 0, 0, 0 },
/* U+1c7b */ { 0, 0, 0, 0, 0 },
/* U+1c7c */ { 0, 0, 0, 0, 0 },
/* U+1c7d */ { 0, 0, 0, 0, 0 },
/* U+1c7e */ { 0, 0, 0, 0, 0 },
/* U+1c7f */ { 0, 0, 0, 0, 0 },
/* U+1c80 */ { 0, 0, 0, 0, 0 },
/* U+1c81 */ { 0, 0, 0, 0, 0 },
/* U+1c82 */ { 0, 0, 0, 0, 0 },
/* U+1c83 */ { 0, 0, 0, 0, 0 },
/* U+1c84 */ { 0, 0, 0, 0, 0 },
/* U+1c85 */ { 0, 0, 0, 0, 0 },
/* U+1c86 */ { 0, 0, 0, 0, 0 },
/* U+1c87 */ { 0, 0, 0, 0, 0 },
/* U+1c88 */ { 0, 0, 0, 0, 0 },
/* U+1c89 */ { 0, 0, 0, 0, 0 },
/* U+1c8a */ { 0, 0, 0, 0, 0 },
/* U+1c8b */ { 0, 0, 0, 0, 0 },
/* U+1c8c */ { 0, 0, 0, 0, 0 },
/* U+1c8d */ { 0, 0, 0, 0, 0 },
/* U+1c8e */ { 0, 0, 0, 0, 0 },
/* U+1c8f */ { 0, 0, 0, 0, 0 },
/* U+1c90 */ { 0, 0, 0, 0, 0 },
/* U+1c91 */ { 0, 0, 0, 0, 0 },
/* U+1c92 */ { 0, 0, 0, 0, 0 },
/* U+1c93 */ { 0, 0, 0, 0, 0 },
/* U+1c94 */ { 0, 0, 0, 0, 0 },
/* U+1c95 */ { 0, 0, 0, 0, 0 },
/* U+1c96 */ { 0, 0, 0, 0, 0 },
/* U+1c97 */ { 0, 0, 0, 0, 0 },
/* U+1c98 */ { 0, 0, 0, 0, 0 },
/* U+1c99 */ { 0, 0, 0, 0, 0 },
/* U+1c9a */ { 0, 0, 0, 0, 0 },
/* U+1c9b */ { 0, 0, 0, 0, 0 },
/* U+1c9c */ { 0, 0, 0, 0, 0 },
/* U+1c9d */ { 0, 0, 0, 0, 0 },
/* U+1c9e */ { 0, 0, 0, 0, 0 },
/* U+1c9f */ { 0, 0, 0, 0, 0 },
/* U+1ca0 */ { 0, 0, 0, 0, 0 },
/* U+1ca1 */ { 0, 0, 0, 0, 0 },
/* U+1ca2 */ { 0, 0, 0, 0, 0 },
/* U+1ca3 */ { 0, 0, 0, 0, 0 },
/* U+1ca4 */ { 0, 0, 0, 0, 0 },
/* U+1ca5 */ { 0, 0, 0, 0, 0 },
/* U+1ca6 */ { 0, 0, 0, 0, 0 },
/* U+1ca7 */ { 0, 0, 0, 0, 0 },
/* U+1ca8 */ { 0, 0, 0, 0, 0 },
/* U+1ca9 */ { 0, 0, 0, 0, 0 },
/* U+1caa */ { 0, 0, 0, 0, 0 },
/* U+1cab */ { 0, 0, 0, 0, 0 },
/* U+1cac */ { 0, 0, 0, 0, 0 },
/* U+1cad */ { 0, 0, 0, 0, 0 },
/* U+1cae */ { 0, 0, 0, 0, 0 },
/* U+1caf */ { 0, 0, 0, 0, 0 },
/* U+1cb0 */ { 0, 0, 0, 0, 0 },
/* U+1cb1 */ { 0, 0, 0, 0, 0 },
/* U+1cb2 */ { 0, 0, 0, 0, 0 },
/* U+1cb3 */ { 0, 0, 0, 0, 0 },
/* U+1cb4 */ { 0, 0, 0, 0, 0 },
/* U+1cb5 */ { 0, 0, 0, 0, 0 },
/* U+1cb6 */ { 0, 0, 0, 0, 0 },
/* U+1cb7 */ { 0, 0, 0, 0, 0 },
/* U+1cb8 */ { 0, 0, 0, 0, 0 },
/* U+1cb9 */ { 0, 0, 0, 0, 0 },
/* U+1cba */ { 0, 0, 0, 0, 0 },
/* U+1cbb */ { 0, 0, 0, 0, 0 },
/* U+1cbc */ { 0, 0, 0, 0, 0 },
/* U+1cbd */ { 0, 0, 0, 0, 0 },
/* U+1cbe */ { 0, 0, 0, 0, 0 },
/* U+1cbf */ { 0, 0, 0, 0, 0 },
/* U+1cc0 */ { 0, 0, 0, 0, 0 },
/* U+1cc1 */ { 0, 0, 0, 0, 0 },
/* U+1cc2 */ { 0, 0, 0, 0, 0 },
/* U+1cc3 */ { 0, 0, 0, 0, 0 },
/* U+1cc4 */ { 0, 0, 0, 0, 0 },
/* U+1cc5 */ { 0, 0, 0, 0, 0 },
/* U+1cc6 */ { 0, 0, 0, 0, 0 },
/* U+1cc7 */ { 0, 0, 0, 0, 0 },
/* U+1cc8 */ { 0, 0, 0, 0, 0 },
/* U+1cc9 */ { 0, 0, 0, 0, 0 },
/* U+1cca */ { 0, 0, 0, 0, 0 },
/* U+1ccb */ { 0, 0, 0, 0, 0 },
/* U+1ccc */ { 0, 0, 0, 0, 0 },
/* U+1ccd */ { 0, 0, 0, 0, 0 },
/* U+1cce */ { 0, 0, 0, 0, 0 },
/* U+1ccf */ { 0, 0, 0, 0, 0 },
/* U+1cd0 */ { 0, 0, 0, 0, 0 },
/* U+1cd1 */ { 0, 0, 0, 0, 0 },
/* U+1cd2 */ { 0, 0, 0, 0, 0 },
/* U+1cd3 */ { 0, 0, 0, 0, 0 },
/* U+1cd4 */ { 0, 0, 0, 0, 0 },
/* U+1cd5 */ { 0, 0, 0, 0, 0 },
/* U+1cd6 */ { 0, 0, 0, 0, 0 },
/* U+1cd7 */ { 0, 0, 0, 0, 0 },
/* U+1cd8 */ { 0, 0, 0, 0, 0 },
/* U+1cd9 */ { 0, 0, 0, 0, 0 },
/* U+1cda */ { 0, 0, 0, 0, 0 },
/* U+1cdb */ { 0, 0, 0, 0, 0 },
/* U+1cdc */ { 0, 0, 0, 0, 0 },
/* U+1cdd */ { 0, 0, 0, 0, 0 },
/* U+1cde */ { 0, 0, 0, 0, 0 },
/* U+1cdf */ { 0, 0, 0, 0, 0 },
/* U+1ce0 */ { 0, 0, 0, 0, 0 },
/* U+1ce1 */ { 0, 0, 0, 0, 0 },
/* U+1ce2 */ { 0, 0, 0, 0, 0 },
/* U+1ce3 */ { 0, 0, 0, 0, 0 },
/* U+1ce4 */ { 0, 0, 0, 0, 0 },
/* U+1ce5 */ { 0, 0, 0, 0, 0 },
/* U+1ce6 */ { 0, 0, 0, 0, 0 },
/* U+1ce7 */ { 0, 0, 0, 0, 0 },
/* U+1ce8 */ { 0, 0, 0, 0, 0 },
/* U+1ce9 */ { 0, 0, 0, 0, 0 },
/* U+1cea */ { 0, 0, 0, 0, 0 },
/* U+1ceb */ { 0, 0, 0, 0, 0 },
/* U+1cec */ { 0, 0, 0, 0, 0 },
/* U+1ced */ { 0, 0, 0, 0, 0 },
/* U+1cee */ { 0, 0, 0, 0, 0 },
/* U+1cef */ { 0, 0, 0, 0, 0 },
/* U+1cf0 */ { 0, 0, 0, 0, 0 },
/* U+1cf1 */ { 0, 0, 0, 0, 0 },
/* U+1cf2 */ { 0, 0, 0, 0, 0 },
/* U+1cf3 */ { 0, 0, 0, 0, 0 },
/* U+1cf4 */ { 0, 0, 0, 0, 0 },
/* U+1cf5 */ { 0, 0, 0, 0, 0 },
/* U+1cf6 */ { 0, 0, 0, 0, 0 },
/* U+1cf7 */ { 0, 0, 0, 0, 0 },
/* U+1cf8 */ { 0, 0, 0, 0, 0 },
/* U+1cf9 */ { 0, 0, 0, 0, 0 },
/* U+1cfa */ { 0, 0, 0, 0, 0 },
/* U+1cfb */ { 0, 0, 0, 0, 0 },
/* U+1cfc */ { 0, 0, 0, 0, 0 },
/* U+1cfd */ { 0, 0, 0, 0, 0 },
/* U+1cfe */ { 0, 0, 0, 0, 0 },
/* U+1cff */ { 0, 0, 0, 0, 0 },
/* U+1d00 */ { 0, 0, 0, 0, 0 },
/* U+1d01 */ { 0, 0, 0, 0, 0 },
/* U+1d02 */ { 0, 0, 0, 0, 0 },
/* U+1d03 */ { 0, 0, 0, 0, 0 },
/* U+1d04 */ { 0, 0, 0, 0, 0 },
/* U+1d05 */ { 0, 0, 0, 0, 0 },
/* U+1d06 */ { 0, 0, 0, 0, 0 },
/* U+1d07 */ { 0, 0, 0, 0, 0 },
/* U+1d08 */ { 0, 0, 0, 0, 0 },
/* U+1d09 */ { 0, 0, 0, 0, 0 },
/* U+1d0a */ { 0, 0, 0, 0, 0 },
/* U+1d0b */ { 0, 0, 0, 0, 0 },
/* U+1d0c */ { 0, 0, 0, 0, 0 },
/* U+1d0d */ { 0, 0, 0, 0, 0 },
/* U+1d0e */ { 0, 0, 0, 0, 0 },
/* U+1d0f */ { 0, 0, 0, 0, 0 },
/* U+1d10 */ { 0, 0, 0, 0, 0 },
/* U+1d11 */ { 0, 0, 0, 0, 0 },
/* U+1d12 */ { 0, 0, 0, 0, 0 },
/* U+1d13 */ { 0, 0, 0, 0, 0 },
/* U+1d14 */ { 0, 0, 0, 0, 0 },
/* U+1d15 */ { 0, 0, 0, 0, 0 },
/* U+1d16 */ { 0, 0, 0, 0, 0 },
/* U+1d17 */ { 0, 0, 0, 0, 0 },
/* U+1d18 */ { 0, 0, 0, 0, 0 },
/* U+1d19 */ { 0, 0, 0, 0, 0 },
/* U+1d1a */ { 0, 0, 0, 0, 0 },
/* U+1d1b */ { 0, 0, 0, 0, 0 },
/* U+1d1c */ { 0, 0, 0, 0, 0 },
/* U+1d1d */ { 0, 0, 0, 0, 0 },
/* U+1d1e */ { 0, 0, 0, 0, 0 },
/* U+1d1f */ { 0, 0, 0, 0, 0 },
/* U+1d20 */ { 0, 0, 0, 0, 0 },
/* U+1d21 */ { 0, 0, 0, 0, 0 },
/* U+1d22 */ { 0, 0, 0, 0, 0 },
/* U+1d23 */ { 0, 0, 0, 0, 0 },
/* U+1d24 */ { 0, 0, 0, 0, 0 },
/* U+1d25 */ { 0, 0, 0, 0, 0 },
/* U+1d26 */ { 0, 0, 0, 0, 0 },
/* U+1d27 */ { 0, 0, 0, 0, 0 },
/* U+1d28 */ { 0, 0, 0, 0, 0 },
/* U+1d29 */ { 0, 0, 0, 0, 0 },
/* U+1d2a */ { 0, 0, 0, 0, 0 },
/* U+1d2b */ { 0, 0, 0, 0, 0 },
/* U+1d2c */ { 0, 0, 0, 0, 0 },
/* U+1d2d */ { 0, 0, 0, 0, 0 },
/* U+1d2e */ { 0, 0, 0, 0, 0 },
/* U+1d2f */ { 0, 0, 0, 0, 0 },
/* U+1d30 */ { 0, 0, 0, 0, 0 },
/* U+1d31 */ { 0, 0, 0, 0, 0 },
/* U+1d32 */ { 0, 0, 0, 0, 0 },
/* U+1d33 */ { 0, 0, 0, 0, 0 },
/* U+1d34 */ { 0, 0, 0, 0, 0 },
/* U+1d35 */ { 0, 0, 0, 0, 0 },
/* U+1d36 */ { 0, 0, 0, 0, 0 },
/* U+1d37 */ { 0, 0, 0, 0, 0 },
/* U+1d38 */ { 0, 0, 0, 0, 0 },
/* U+1d39 */ { 0, 0, 0, 0, 0 },
/* U+1d3a */ { 0, 0, 0, 0, 0 },
/* U+1d3b */ { 0, 0, 0, 0, 0 },
/* U+1d3c */ { 0, 0, 0, 0, 0 },
/* U+1d3d */ { 0, 0, 0, 0, 0 },
/* U+1d3e */ { 0, 0, 0, 0, 0 },
/* U+1d3f */ { 0, 0, 0, 0, 0 },
/* U+1d40 */ { 0, 0, 0, 0, 0 },
/* U+1d41 */ { 0, 0, 0, 0, 0 },
/* U+1d42 */ { 0, 0, 0, 0, 0 },
/* U+1d43 */ { 0, 0, 0, 0, 0 },
/* U+1d44 */ { 0, 0, 0, 0, 0 },
/* U+1d45 */ { 0, 0, 0, 0, 0 },
/* U+1d46 */ { 0, 0, 0, 0, 0 },
/* U+1d47 */ { 0, 0, 0, 0, 0 },
/* U+1d48 */ { 0, 0, 0, 0, 0 },
/* U+1d49 */ { 0, 0, 0, 0, 0 },
/* U+1d4a */ { 0, 0, 0, 0, 0 },
/* U+1d4b */ { 0, 0, 0, 0, 0 },
/* U+1d4c */ { 0, 0, 0, 0, 0 },
/* U+1d4d */ { 0, 0, 0, 0, 0 },
/* U+1d4e */ { 0, 0, 0, 0, 0 },
/* U+1d4f */ { 0, 0, 0, 0, 0 },
/* U+1d50 */ { 0, 0, 0, 0, 0 },
/* U+1d51 */ { 0, 0, 0, 0, 0 },
/* U+1d52 */ { 0, 0, 0, 0, 0 },
/* U+1d53 */ { 0, 0, 0, 0, 0 },
/* U+1d54 */ { 0, 0, 0, 0, 0 },
/* U+1d55 */ { 0, 0, 0, 0, 0 },
/* U+1d56 */ { 0, 0, 0, 0, 0 },
/* U+1d57 */ { 0, 0, 0, 0, 0 },
/* U+1d58 */ { 0, 0, 0, 0, 0 },
/* U+1d59 */ { 0, 0, 0, 0, 0 },
/* U+1d5a */ { 0, 0, 0, 0, 0 },
/* U+1d5b */ { 0, 0, 0, 0, 0 },
/* U+1d5c */ { 0, 0, 0, 0, 0 },
/* U+1d5d */ { 0, 0, 0, 0, 0 },
/* U+1d5e */ { 0, 0, 0, 0, 0 },
/* U+1d5f */ { 0, 0, 0, 0, 0 },
/* U+1d60 */ { 0, 0, 0, 0, 0 },
/* U+1d61 */ { 0, 0, 0, 0, 0 },
/* U+1d62 */ { 0, 0, 0, 0, 0 },
/* U+1d63 */ { 0, 0, 0, 0, 0 },
/* U+1d64 */ { 0, 0, 0, 0, 0 },
/* U+1d65 */ { 0, 0, 0, 0, 0 },
/* U+1d66 */ { 0, 0, 0, 0, 0 },
/* U+1d67 */ { 0, 0, 0, 0, 0 },
/* U+1d68 */ { 0, 0, 0, 0, 0 },
/* U+1d69 */ { 0, 0, 0, 0, 0 },
/* U+1d6a */ { 0, 0, 0, 0, 0 },
/* U+1d6b */ { 0, 0, 0, 0, 0 },
/* U+1d6c */ { 0, 0, 0, 0, 0 },
/* U+1d6d */ { 0, 0, 0, 0, 0 },
/* U+1d6e */ { 0, 0, 0, 0, 0 },
/* U+1d6f */ { 0, 0, 0, 0, 0 },
/* U+1d70 */ { 0, 0, 0, 0, 0 },
/* U+1d71 */ { 0, 0, 0, 0, 0 },
/* U+1d72 */ { 0, 0, 0, 0, 0 },
/* U+1d73 */ { 0, 0, 0, 0, 0 },
/* U+1d74 */ { 0, 0, 0, 0, 0 },
/* U+1d75 */ { 0, 0, 0, 0, 0 },
/* U+1d76 */ { 0, 0, 0, 0, 0 },
/* U+1d77 */ { 0, 0, 0, 0, 0 },
/* U+1d78 */ { 0, 0, 0, 0, 0 },
/* U+1d79 */ { 0, 0, 0, 0, 0 },
/* U+1d7a */ { 0, 0, 0, 0, 0 },
/* U+1d7b */ { 0, 0, 0, 0, 0 },
/* U+1d7c */ { 0, 0, 0, 0, 0 },
/* U+1d7d */ { 0, 0, 0, 0, 0 },
/* U+1d7e */ { 0, 0, 0, 0, 0 },
/* U+1d7f */ { 0, 0, 0, 0, 0 },
/* U+1d80 */ { 0, 0, 0, 0, 0 },
/* U+1d81 */ { 0, 0, 0, 0, 0 },
/* U+1d82 */ { 0, 0, 0, 0, 0 },
/* U+1d83 */ { 0, 0, 0, 0, 0 },
/* U+1d84 */ { 0, 0, 0, 0, 0 },
/* U+1d85 */ { 0, 0, 0, 0, 0 },
/* U+1d86 */ { 0, 0, 0, 0, 0 },
/* U+1d87 */ { 0, 0, 0, 0, 0 },
/* U+1d88 */ { 0, 0, 0, 0, 0 },
/* U+1d89 */ { 0, 0, 0, 0, 0 },
/* U+1d8a */ { 0, 0, 0, 0, 0 },
/* U+1d8b */ { 0, 0, 0, 0, 0 },
/* U+1d8c */ { 0, 0, 0, 0, 0 },
/* U+1d8d */ { 0, 0, 0, 0, 0 },
/* U+1d8e */ { 0, 0, 0, 0, 0 },
/* U+1d8f */ { 0, 0, 0, 0, 0 },
/* U+1d90 */ { 0, 0, 0, 0, 0 },
/* U+1d91 */ { 0, 0, 0, 0, 0 },
/* U+1d92 */ { 0, 0, 0, 0, 0 },
/* U+1d93 */ { 0, 0, 0, 0, 0 },
/* U+1d94 */ { 0, 0, 0, 0, 0 },
/* U+1d95 */ { 0, 0, 0, 0, 0 },
/* U+1d96 */ { 0, 0, 0, 0, 0 },
/* U+1d97 */ { 0, 0, 0, 0, 0 },
/* U+1d98 */ { 0, 0, 0, 0, 0 },
/* U+1d99 */ { 0, 0, 0, 0, 0 },
/* U+1d9a */ { 0, 0, 0, 0, 0 },
/* U+1d9b */ { 0, 0, 0, 0, 0 },
/* U+1d9c */ { 0, 0, 0, 0, 0 },
/* U+1d9d */ { 0, 0, 0, 0, 0 },
/* U+1d9e */ { 0, 0, 0, 0, 0 },
/* U+1d9f */ { 0, 0, 0, 0, 0 },
/* U+1da0 */ { 0, 0, 0, 0, 0 },
/* U+1da1 */ { 0, 0, 0, 0, 0 },
/* U+1da2 */ { 0, 0, 0, 0, 0 },
/* U+1da3 */ { 0, 0, 0, 0, 0 },
/* U+1da4 */ { 0, 0, 0, 0, 0 },
/* U+1da5 */ { 0, 0, 0, 0, 0 },
/* U+1da6 */ { 0, 0, 0, 0, 0 },
/* U+1da7 */ { 0, 0, 0, 0, 0 },
/* U+1da8 */ { 0, 0, 0, 0, 0 },
/* U+1da9 */ { 0, 0, 0, 0, 0 },
/* U+1daa */ { 0, 0, 0, 0, 0 },
/* U+1dab */ { 0, 0, 0, 0, 0 },
/* U+1dac */ { 0, 0, 0, 0, 0 },
/* U+1dad */ { 0, 0, 0, 0, 0 },
/* U+1dae */ { 0, 0, 0, 0, 0 },
/* U+1daf */ { 0, 0, 0, 0, 0 },
/* U+1db0 */ { 0, 0, 0, 0, 0 },
/* U+1db1 */ { 0, 0, 0, 0, 0 },
/* U+1db2 */ { 0, 0, 0, 0, 0 },
/* U+1db3 */ { 0, 0, 0, 0, 0 },
/* U+1db4 */ { 0, 0, 0, 0, 0 },
/* U+1db5 */ { 0, 0, 0, 0, 0 },
/* U+1db6 */ { 0, 0, 0, 0, 0 },
/* U+1db7 */ { 0, 0, 0, 0, 0 },
/* U+1db8 */ { 0, 0, 0, 0, 0 },
/* U+1db9 */ { 0, 0, 0, 0, 0 },
/* U+1dba */ { 0, 0, 0, 0, 0 },
/* U+1dbb */ { 0, 0, 0, 0, 0 },
/* U+1dbc */ { 0, 0, 0, 0, 0 },
/* U+1dbd */ { 0, 0, 0, 0, 0 },
/* U+1dbe */ { 0, 0, 0, 0, 0 },
/* U+1dbf */ { 0, 0, 0, 0, 0 },
/* U+1dc0 */ { 0, 0, 0, 0, 0 },
/* U+1dc1 */ { 0, 0, 0, 0, 0 },
/* U+1dc2 */ { 0, 0, 0, 0, 0 },
/* U+1dc3 */ { 0, 0, 0, 0, 0 },
/* U+1dc4 */ { 0, 0, 0, 0, 0 },
/* U+1dc5 */ { 0, 0, 0, 0, 0 },
/* U+1dc6 */ { 0, 0, 0, 0, 0 },
/* U+1dc7 */ { 0, 0, 0, 0, 0 },
/* U+1dc8 */ { 0, 0, 0, 0, 0 },
/* U+1dc9 */ { 0, 0, 0, 0, 0 },
/* U+1dca */ { 0, 0, 0, 0, 0 },
/* U+1dcb */ { 0, 0, 0, 0, 0 },
/* U+1dcc */ { 0, 0, 0, 0, 0 },
/* U+1dcd */ { 0, 0, 0, 0, 0 },
/* U+1dce */ { 0, 0, 0, 0, 0 },
/* U+1dcf */ { 0, 0, 0, 0, 0 },
/* U+1dd0 */ { 0, 0, 0, 0, 0 },
/* U+1dd1 */ { 0, 0, 0, 0, 0 },
/* U+1dd2 */ { 0, 0, 0, 0, 0 },
/* U+1dd3 */ { 0, 0, 0, 0, 0 },
/* U+1dd4 */ { 0, 0, 0, 0, 0 },
/* U+1dd5 */ { 0, 0, 0, 0, 0 },
/* U+1dd6 */ { 0, 0, 0, 0, 0 },
/* U+1dd7 */ { 0, 0, 0, 0, 0 },
/* U+1dd8 */ { 0, 0, 0, 0, 0 },
/* U+1dd9 */ { 0, 0, 0, 0, 0 },
/* U+1dda */ { 0, 0, 0, 0, 0 },
/* U+1ddb */ { 0, 0, 0, 0, 0 },
/* U+1ddc */ { 0, 0, 0, 0, 0 },
/* U+1ddd */ { 0, 0, 0, 0, 0 },
/* U+1dde */ { 0, 0, 0, 0, 0 },
/* U+1ddf */ { 0, 0, 0, 0, 0 },
/* U+1de0 */ { 0, 0, 0, 0, 0 },
/* U+1de1 */ { 0, 0, 0, 0, 0 },
/* U+1de2 */ { 0, 0, 0, 0, 0 },
/* U+1de3 */ { 0, 0, 0, 0, 0 },
/* U+1de4 */ { 0, 0, 0, 0, 0 },
/* U+1de5 */ { 0, 0, 0, 0, 0 },
/* U+1de6 */ { 0, 0, 0, 0, 0 },
/* U+1de7 */ { 0, 0, 0, 0, 0 },
/* U+1de8 */ { 0, 0, 0, 0, 0 },
/* U+1de9 */ { 0, 0, 0, 0, 0 },
/* U+1dea */ { 0, 0, 0, 0, 0 },
/* U+1deb */ { 0, 0, 0, 0, 0 },
/* U+1dec */ { 0, 0, 0, 0, 0 },
/* U+1ded */ { 0, 0, 0, 0, 0 },
/* U+1dee */ { 0, 0, 0, 0, 0 },
/* U+1def */ { 0, 0, 0, 0, 0 },
/* U+1df0 */ { 0, 0, 0, 0, 0 },
/* U+1df1 */ { 0, 0, 0, 0, 0 },
/* U+1df2 */ { 0, 0, 0, 0, 0 },
/* U+1df3 */ { 0, 0, 0, 0, 0 },
/* U+1df4 */ { 0, 0, 0, 0, 0 },
/* U+1df5 */ { 0, 0, 0, 0, 0 },
/* U+1df6 */ { 0, 0, 0, 0, 0 },
/* U+1df7 */ { 0, 0, 0, 0, 0 },
/* U+1df8 */ { 0, 0, 0, 0, 0 },
/* U+1df9 */ { 0, 0, 0, 0, 0 },
/* U+1dfa */ { 0, 0, 0, 0, 0 },
/* U+1dfb */ { 0, 0, 0, 0, 0 },
/* U+1dfc */ { 0, 0, 0, 0, 0 },
/* U+1dfd */ { 0, 0, 0, 0, 0 },
/* U+1dfe */ { 0, 0, 0, 0, 0 },
/* U+1dff */ { 0, 0, 0, 0, 0 },
/* U+1e00 */ { 1, 0, 1, 0, "0041 0325" },
/* U+1e01 */ { 2, 0, 1, 0, "0061 0325" },
/* U+1e02 */ { 1, 0, 1, 0, "0042 0307" },
/* U+1e03 */ { 2, 0, 1, 0, "0062 0307" },
/* U+1e04 */ { 1, 0, 1, 0, "0042 0323" },
/* U+1e05 */ { 2, 0, 1, 0, "0062 0323" },
/* U+1e06 */ { 1, 0, 1, 0, "0042 0331" },
/* U+1e07 */ { 2, 0, 1, 0, "0062 0331" },
/* U+1e08 */ { 1, 0, 1, 0, "00C7 0301" },
/* U+1e09 */ { 2, 0, 1, 0, "00E7 0301" },
/* U+1e0a */ { 1, 0, 1, 0, "0044 0307" },
/* U+1e0b */ { 2, 0, 1, 0, "0064 0307" },
/* U+1e0c */ { 1, 0, 1, 0, "0044 0323" },
/* U+1e0d */ { 2, 0, 1, 0, "0064 0323" },
/* U+1e0e */ { 1, 0, 1, 0, "0044 0331" },
/* U+1e0f */ { 2, 0, 1, 0, "0064 0331" },
/* U+1e10 */ { 1, 0, 1, 0, "0044 0327" },
/* U+1e11 */ { 2, 0, 1, 0, "0064 0327" },
/* U+1e12 */ { 1, 0, 1, 0, "0044 032D" },
/* U+1e13 */ { 2, 0, 1, 0, "0064 032D" },
/* U+1e14 */ { 1, 0, 1, 0, "0112 0300" },
/* U+1e15 */ { 2, 0, 1, 0, "0113 0300" },
/* U+1e16 */ { 1, 0, 1, 0, "0112 0301" },
/* U+1e17 */ { 2, 0, 1, 0, "0113 0301" },
/* U+1e18 */ { 1, 0, 1, 0, "0045 032D" },
/* U+1e19 */ { 2, 0, 1, 0, "0065 032D" },
/* U+1e1a */ { 1, 0, 1, 0, "0045 0330" },
/* U+1e1b */ { 2, 0, 1, 0, "0065 0330" },
/* U+1e1c */ { 1, 0, 1, 0, "0228 0306" },
/* U+1e1d */ { 2, 0, 1, 0, "0229 0306" },
/* U+1e1e */ { 1, 0, 1, 0, "0046 0307" },
/* U+1e1f */ { 2, 0, 1, 0, "0066 0307" },
/* U+1e20 */ { 1, 0, 1, 0, "0047 0304" },
/* U+1e21 */ { 2, 0, 1, 0, "0067 0304" },
/* U+1e22 */ { 1, 0, 1, 0, "0048 0307" },
/* U+1e23 */ { 2, 0, 1, 0, "0068 0307" },
/* U+1e24 */ { 1, 0, 1, 0, "0048 0323" },
/* U+1e25 */ { 2, 0, 1, 0, "0068 0323" },
/* U+1e26 */ { 1, 0, 1, 0, "0048 0308" },
/* U+1e27 */ { 2, 0, 1, 0, "0068 0308" },
/* U+1e28 */ { 1, 0, 1, 0, "0048 0327" },
/* U+1e29 */ { 2, 0, 1, 0, "0068 0327" },
/* U+1e2a */ { 1, 0, 1, 0, "0048 032E" },
/* U+1e2b */ { 2, 0, 1, 0, "0068 032E" },
/* U+1e2c */ { 1, 0, 1, 0, "0049 0330" },
/* U+1e2d */ { 2, 0, 1, 0, "0069 0330" },
/* U+1e2e */ { 1, 0, 1, 0, "00CF 0301" },
/* U+1e2f */ { 2, 0, 1, 0, "00EF 0301" },
/* U+1e30 */ { 1, 0, 1, 0, "004B 0301" },
/* U+1e31 */ { 2, 0, 1, 0, "006B 0301" },
/* U+1e32 */ { 1, 0, 1, 0, "004B 0323" },
/* U+1e33 */ { 2, 0, 1, 0, "006B 0323" },
/* U+1e34 */ { 1, 0, 1, 0, "004B 0331" },
/* U+1e35 */ { 2, 0, 1, 0, "006B 0331" },
/* U+1e36 */ { 1, 0, 1, 0, "004C 0323" },
/* U+1e37 */ { 2, 0, 1, 0, "006C 0323" },
/* U+1e38 */ { 1, 0, 1, 0, "1E36 0304" },
/* U+1e39 */ { 2, 0, 1, 0, "1E37 0304" },
/* U+1e3a */ { 1, 0, 1, 0, "004C 0331" },
/* U+1e3b */ { 2, 0, 1, 0, "006C 0331" },
/* U+1e3c */ { 1, 0, 1, 0, "004C 032D" },
/* U+1e3d */ { 2, 0, 1, 0, "006C 032D" },
/* U+1e3e */ { 1, 0, 1, 0, "004D 0301" },
/* U+1e3f */ { 2, 0, 1, 0, "006D 0301" },
/* U+1e40 */ { 1, 0, 1, 0, "004D 0307" },
/* U+1e41 */ { 2, 0, 1, 0, "006D 0307" },
/* U+1e42 */ { 1, 0, 1, 0, "004D 0323" },
/* U+1e43 */ { 2, 0, 1, 0, "006D 0323" },
/* U+1e44 */ { 1, 0, 1, 0, "004E 0307" },
/* U+1e45 */ { 2, 0, 1, 0, "006E 0307" },
/* U+1e46 */ { 1, 0, 1, 0, "004E 0323" },
/* U+1e47 */ { 2, 0, 1, 0, "006E 0323" },
/* U+1e48 */ { 1, 0, 1, 0, "004E 0331" },
/* U+1e49 */ { 2, 0, 1, 0, "006E 0331" },
/* U+1e4a */ { 1, 0, 1, 0, "004E 032D" },
/* U+1e4b */ { 2, 0, 1, 0, "006E 032D" },
/* U+1e4c */ { 1, 0, 1, 0, "00D5 0301" },
/* U+1e4d */ { 2, 0, 1, 0, "00F5 0301" },
/* U+1e4e */ { 1, 0, 1, 0, "00D5 0308" },
/* U+1e4f */ { 2, 0, 1, 0, "00F5 0308" },
/* U+1e50 */ { 1, 0, 1, 0, "014C 0300" },
/* U+1e51 */ { 2, 0, 1, 0, "014D 0300" },
/* U+1e52 */ { 1, 0, 1, 0, "014C 0301" },
/* U+1e53 */ { 2, 0, 1, 0, "014D 0301" },
/* U+1e54 */ { 1, 0, 1, 0, "0050 0301" },
/* U+1e55 */ { 2, 0, 1, 0, "0070 0301" },
/* U+1e56 */ { 1, 0, 1, 0, "0050 0307" },
/* U+1e57 */ { 2, 0, 1, 0, "0070 0307" },
/* U+1e58 */ { 1, 0, 1, 0, "0052 0307" },
/* U+1e59 */ { 2, 0, 1, 0, "0072 0307" },
/* U+1e5a */ { 1, 0, 1, 0, "0052 0323" },
/* U+1e5b */ { 2, 0, 1, 0, "0072 0323" },
/* U+1e5c */ { 1, 0, 1, 0, "1E5A 0304" },
/* U+1e5d */ { 2, 0, 1, 0, "1E5B 0304" },
/* U+1e5e */ { 1, 0, 1, 0, "0052 0331" },
/* U+1e5f */ { 2, 0, 1, 0, "0072 0331" },
/* U+1e60 */ { 1, 0, 1, 0, "0053 0307" },
/* U+1e61 */ { 2, 0, 1, 0, "0073 0307" },
/* U+1e62 */ { 1, 0, 1, 0, "0053 0323" },
/* U+1e63 */ { 2, 0, 1, 0, "0073 0323" },
/* U+1e64 */ { 1, 0, 1, 0, "015A 0307" },
/* U+1e65 */ { 2, 0, 1, 0, "015B 0307" },
/* U+1e66 */ { 1, 0, 1, 0, "0160 0307" },
/* U+1e67 */ { 2, 0, 1, 0, "0161 0307" },
/* U+1e68 */ { 1, 0, 1, 0, "1E62 0307" },
/* U+1e69 */ { 2, 0, 1, 0, "1E63 0307" },
/* U+1e6a */ { 1, 0, 1, 0, "0054 0307" },
/* U+1e6b */ { 2, 0, 1, 0, "0074 0307" },
/* U+1e6c */ { 1, 0, 1, 0, "0054 0323" },
/* U+1e6d */ { 2, 0, 1, 0, "0074 0323" },
/* U+1e6e */ { 1, 0, 1, 0, "0054 0331" },
/* U+1e6f */ { 2, 0, 1, 0, "0074 0331" },
/* U+1e70 */ { 1, 0, 1, 0, "0054 032D" },
/* U+1e71 */ { 2, 0, 1, 0, "0074 032D" },
/* U+1e72 */ { 1, 0, 1, 0, "0055 0324" },
/* U+1e73 */ { 2, 0, 1, 0, "0075 0324" },
/* U+1e74 */ { 1, 0, 1, 0, "0055 0330" },
/* U+1e75 */ { 2, 0, 1, 0, "0075 0330" },
/* U+1e76 */ { 1, 0, 1, 0, "0055 032D" },
/* U+1e77 */ { 2, 0, 1, 0, "0075 032D" },
/* U+1e78 */ { 1, 0, 1, 0, "0168 0301" },
/* U+1e79 */ { 2, 0, 1, 0, "0169 0301" },
/* U+1e7a */ { 1, 0, 1, 0, "016A 0308" },
/* U+1e7b */ { 2, 0, 1, 0, "016B 0308" },
/* U+1e7c */ { 1, 0, 1, 0, "0056 0303" },
/* U+1e7d */ { 2, 0, 1, 0, "0076 0303" },
/* U+1e7e */ { 1, 0, 1, 0, "0056 0323" },
/* U+1e7f */ { 2, 0, 1, 0, "0076 0323" },
/* U+1e80 */ { 1, 0, 1, 0, "0057 0300" },
/* U+1e81 */ { 2, 0, 1, 0, "0077 0300" },
/* U+1e82 */ { 1, 0, 1, 0, "0057 0301" },
/* U+1e83 */ { 2, 0, 1, 0, "0077 0301" },
/* U+1e84 */ { 1, 0, 1, 0, "0057 0308" },
/* U+1e85 */ { 2, 0, 1, 0, "0077 0308" },
/* U+1e86 */ { 1, 0, 1, 0, "0057 0307" },
/* U+1e87 */ { 2, 0, 1, 0, "0077 0307" },
/* U+1e88 */ { 1, 0, 1, 0, "0057 0323" },
/* U+1e89 */ { 2, 0, 1, 0, "0077 0323" },
/* U+1e8a */ { 1, 0, 1, 0, "0058 0307" },
/* U+1e8b */ { 2, 0, 1, 0, "0078 0307" },
/* U+1e8c */ { 1, 0, 1, 0, "0058 0308" },
/* U+1e8d */ { 2, 0, 1, 0, "0078 0308" },
/* U+1e8e */ { 1, 0, 1, 0, "0059 0307" },
/* U+1e8f */ { 2, 0, 1, 0, "0079 0307" },
/* U+1e90 */ { 1, 0, 1, 0, "005A 0302" },
/* U+1e91 */ { 2, 0, 1, 0, "007A 0302" },
/* U+1e92 */ { 1, 0, 1, 0, "005A 0323" },
/* U+1e93 */ { 2, 0, 1, 0, "007A 0323" },
/* U+1e94 */ { 1, 0, 1, 0, "005A 0331" },
/* U+1e95 */ { 2, 0, 1, 0, "007A 0331" },
/* U+1e96 */ { 2, 0, 1, 0, "0068 0331" },
/* U+1e97 */ { 2, 0, 1, 0, "0074 0308" },
/* U+1e98 */ { 2, 0, 1, 0, "0077 030A" },
/* U+1e99 */ { 2, 0, 1, 0, "0079 030A" },
/* U+1e9a */ { 2, 0, 1, 0, "<compat> 0061 02BE" },
/* U+1e9b */ { 2, 0, 1, 0, "017F 0307" },
/* U+1e9c */ { 0, 0, 0, 0, 0 },
/* U+1e9d */ { 0, 0, 0, 0, 0 },
/* U+1e9e */ { 0, 0, 0, 0, 0 },
/* U+1e9f */ { 0, 0, 0, 0, 0 },
/* U+1ea0 */ { 1, 0, 1, 0, "0041 0323" },
/* U+1ea1 */ { 2, 0, 1, 0, "0061 0323" },
/* U+1ea2 */ { 1, 0, 1, 0, "0041 0309" },
/* U+1ea3 */ { 2, 0, 1, 0, "0061 0309" },
/* U+1ea4 */ { 1, 0, 1, 0, "00C2 0301" },
/* U+1ea5 */ { 2, 0, 1, 0, "00E2 0301" },
/* U+1ea6 */ { 1, 0, 1, 0, "00C2 0300" },
/* U+1ea7 */ { 2, 0, 1, 0, "00E2 0300" },
/* U+1ea8 */ { 1, 0, 1, 0, "00C2 0309" },
/* U+1ea9 */ { 2, 0, 1, 0, "00E2 0309" },
/* U+1eaa */ { 1, 0, 1, 0, "00C2 0303" },
/* U+1eab */ { 2, 0, 1, 0, "00E2 0303" },
/* U+1eac */ { 1, 0, 1, 0, "1EA0 0302" },
/* U+1ead */ { 2, 0, 1, 0, "1EA1 0302" },
/* U+1eae */ { 1, 0, 1, 0, "0102 0301" },
/* U+1eaf */ { 2, 0, 1, 0, "0103 0301" },
/* U+1eb0 */ { 1, 0, 1, 0, "0102 0300" },
/* U+1eb1 */ { 2, 0, 1, 0, "0103 0300" },
/* U+1eb2 */ { 1, 0, 1, 0, "0102 0309" },
/* U+1eb3 */ { 2, 0, 1, 0, "0103 0309" },
/* U+1eb4 */ { 1, 0, 1, 0, "0102 0303" },
/* U+1eb5 */ { 2, 0, 1, 0, "0103 0303" },
/* U+1eb6 */ { 1, 0, 1, 0, "1EA0 0306" },
/* U+1eb7 */ { 2, 0, 1, 0, "1EA1 0306" },
/* U+1eb8 */ { 1, 0, 1, 0, "0045 0323" },
/* U+1eb9 */ { 2, 0, 1, 0, "0065 0323" },
/* U+1eba */ { 1, 0, 1, 0, "0045 0309" },
/* U+1ebb */ { 2, 0, 1, 0, "0065 0309" },
/* U+1ebc */ { 1, 0, 1, 0, "0045 0303" },
/* U+1ebd */ { 2, 0, 1, 0, "0065 0303" },
/* U+1ebe */ { 1, 0, 1, 0, "00CA 0301" },
/* U+1ebf */ { 2, 0, 1, 0, "00EA 0301" },
/* U+1ec0 */ { 1, 0, 1, 0, "00CA 0300" },
/* U+1ec1 */ { 2, 0, 1, 0, "00EA 0300" },
/* U+1ec2 */ { 1, 0, 1, 0, "00CA 0309" },
/* U+1ec3 */ { 2, 0, 1, 0, "00EA 0309" },
/* U+1ec4 */ { 1, 0, 1, 0, "00CA 0303" },
/* U+1ec5 */ { 2, 0, 1, 0, "00EA 0303" },
/* U+1ec6 */ { 1, 0, 1, 0, "1EB8 0302" },
/* U+1ec7 */ { 2, 0, 1, 0, "1EB9 0302" },
/* U+1ec8 */ { 1, 0, 1, 0, "0049 0309" },
/* U+1ec9 */ { 2, 0, 1, 0, "0069 0309" },
/* U+1eca */ { 1, 0, 1, 0, "0049 0323" },
/* U+1ecb */ { 2, 0, 1, 0, "0069 0323" },
/* U+1ecc */ { 1, 0, 1, 0, "004F 0323" },
/* U+1ecd */ { 2, 0, 1, 0, "006F 0323" },
/* U+1ece */ { 1, 0, 1, 0, "004F 0309" },
/* U+1ecf */ { 2, 0, 1, 0, "006F 0309" },
/* U+1ed0 */ { 1, 0, 1, 0, "00D4 0301" },
/* U+1ed1 */ { 2, 0, 1, 0, "00F4 0301" },
/* U+1ed2 */ { 1, 0, 1, 0, "00D4 0300" },
/* U+1ed3 */ { 2, 0, 1, 0, "00F4 0300" },
/* U+1ed4 */ { 1, 0, 1, 0, "00D4 0309" },
/* U+1ed5 */ { 2, 0, 1, 0, "00F4 0309" },
/* U+1ed6 */ { 1, 0, 1, 0, "00D4 0303" },
/* U+1ed7 */ { 2, 0, 1, 0, "00F4 0303" },
/* U+1ed8 */ { 1, 0, 1, 0, "1ECC 0302" },
/* U+1ed9 */ { 2, 0, 1, 0, "1ECD 0302" },
/* U+1eda */ { 1, 0, 1, 0, "01A0 0301" },
/* U+1edb */ { 2, 0, 1, 0, "01A1 0301" },
/* U+1edc */ { 1, 0, 1, 0, "01A0 0300" },
/* U+1edd */ { 2, 0, 1, 0, "01A1 0300" },
/* U+1ede */ { 1, 0, 1, 0, "01A0 0309" },
/* U+1edf */ { 2, 0, 1, 0, "01A1 0309" },
/* U+1ee0 */ { 1, 0, 1, 0, "01A0 0303" },
/* U+1ee1 */ { 2, 0, 1, 0, "01A1 0303" },
/* U+1ee2 */ { 1, 0, 1, 0, "01A0 0323" },
/* U+1ee3 */ { 2, 0, 1, 0, "01A1 0323" },
/* U+1ee4 */ { 1, 0, 1, 0, "0055 0323" },
/* U+1ee5 */ { 2, 0, 1, 0, "0075 0323" },
/* U+1ee6 */ { 1, 0, 1, 0, "0055 0309" },
/* U+1ee7 */ { 2, 0, 1, 0, "0075 0309" },
/* U+1ee8 */ { 1, 0, 1, 0, "01AF 0301" },
/* U+1ee9 */ { 2, 0, 1, 0, "01B0 0301" },
/* U+1eea */ { 1, 0, 1, 0, "01AF 0300" },
/* U+1eeb */ { 2, 0, 1, 0, "01B0 0300" },
/* U+1eec */ { 1, 0, 1, 0, "01AF 0309" },
/* U+1eed */ { 2, 0, 1, 0, "01B0 0309" },
/* U+1eee */ { 1, 0, 1, 0, "01AF 0303" },
/* U+1eef */ { 2, 0, 1, 0, "01B0 0303" },
/* U+1ef0 */ { 1, 0, 1, 0, "01AF 0323" },
/* U+1ef1 */ { 2, 0, 1, 0, "01B0 0323" },
/* U+1ef2 */ { 1, 0, 1, 0, "0059 0300" },
/* U+1ef3 */ { 2, 0, 1, 0, "0079 0300" },
/* U+1ef4 */ { 1, 0, 1, 0, "0059 0323" },
/* U+1ef5 */ { 2, 0, 1, 0, "0079 0323" },
/* U+1ef6 */ { 1, 0, 1, 0, "0059 0309" },
/* U+1ef7 */ { 2, 0, 1, 0, "0079 0309" },
/* U+1ef8 */ { 1, 0, 1, 0, "0059 0303" },
/* U+1ef9 */ { 2, 0, 1, 0, "0079 0303" },
/* U+1efa */ { 0, 0, 0, 0, 0 },
/* U+1efb */ { 0, 0, 0, 0, 0 },
/* U+1efc */ { 0, 0, 0, 0, 0 },
/* U+1efd */ { 0, 0, 0, 0, 0 },
/* U+1efe */ { 0, 0, 0, 0, 0 },
/* U+1eff */ { 0, 0, 0, 0, 0 },
/* U+1f00 */ { 2, 0, 1, 0, "03B1 0313" },
/* U+1f01 */ { 2, 0, 1, 0, "03B1 0314" },
/* U+1f02 */ { 2, 0, 1, 0, "1F00 0300" },
/* U+1f03 */ { 2, 0, 1, 0, "1F01 0300" },
/* U+1f04 */ { 2, 0, 1, 0, "1F00 0301" },
/* U+1f05 */ { 2, 0, 1, 0, "1F01 0301" },
/* U+1f06 */ { 2, 0, 1, 0, "1F00 0342" },
/* U+1f07 */ { 2, 0, 1, 0, "1F01 0342" },
/* U+1f08 */ { 1, 0, 1, 0, "0391 0313" },
/* U+1f09 */ { 1, 0, 1, 0, "0391 0314" },
/* U+1f0a */ { 1, 0, 1, 0, "1F08 0300" },
/* U+1f0b */ { 1, 0, 1, 0, "1F09 0300" },
/* U+1f0c */ { 1, 0, 1, 0, "1F08 0301" },
/* U+1f0d */ { 1, 0, 1, 0, "1F09 0301" },
/* U+1f0e */ { 1, 0, 1, 0, "1F08 0342" },
/* U+1f0f */ { 1, 0, 1, 0, "1F09 0342" },
/* U+1f10 */ { 2, 0, 1, 0, "03B5 0313" },
/* U+1f11 */ { 2, 0, 1, 0, "03B5 0314" },
/* U+1f12 */ { 2, 0, 1, 0, "1F10 0300" },
/* U+1f13 */ { 2, 0, 1, 0, "1F11 0300" },
/* U+1f14 */ { 2, 0, 1, 0, "1F10 0301" },
/* U+1f15 */ { 2, 0, 1, 0, "1F11 0301" },
/* U+1f16 */ { 0, 0, 0, 0, 0 },
/* U+1f17 */ { 0, 0, 0, 0, 0 },
/* U+1f18 */ { 1, 0, 1, 0, "0395 0313" },
/* U+1f19 */ { 1, 0, 1, 0, "0395 0314" },
/* U+1f1a */ { 1, 0, 1, 0, "1F18 0300" },
/* U+1f1b */ { 1, 0, 1, 0, "1F19 0300" },
/* U+1f1c */ { 1, 0, 1, 0, "1F18 0301" },
/* U+1f1d */ { 1, 0, 1, 0, "1F19 0301" },
/* U+1f1e */ { 0, 0, 0, 0, 0 },
/* U+1f1f */ { 0, 0, 0, 0, 0 },
/* U+1f20 */ { 2, 0, 1, 0, "03B7 0313" },
/* U+1f21 */ { 2, 0, 1, 0, "03B7 0314" },
/* U+1f22 */ { 2, 0, 1, 0, "1F20 0300" },
/* U+1f23 */ { 2, 0, 1, 0, "1F21 0300" },
/* U+1f24 */ { 2, 0, 1, 0, "1F20 0301" },
/* U+1f25 */ { 2, 0, 1, 0, "1F21 0301" },
/* U+1f26 */ { 2, 0, 1, 0, "1F20 0342" },
/* U+1f27 */ { 2, 0, 1, 0, "1F21 0342" },
/* U+1f28 */ { 1, 0, 1, 0, "0397 0313" },
/* U+1f29 */ { 1, 0, 1, 0, "0397 0314" },
/* U+1f2a */ { 1, 0, 1, 0, "1F28 0300" },
/* U+1f2b */ { 1, 0, 1, 0, "1F29 0300" },
/* U+1f2c */ { 1, 0, 1, 0, "1F28 0301" },
/* U+1f2d */ { 1, 0, 1, 0, "1F29 0301" },
/* U+1f2e */ { 1, 0, 1, 0, "1F28 0342" },
/* U+1f2f */ { 1, 0, 1, 0, "1F29 0342" },
/* U+1f30 */ { 2, 0, 1, 0, "03B9 0313" },
/* U+1f31 */ { 2, 0, 1, 0, "03B9 0314" },
/* U+1f32 */ { 2, 0, 1, 0, "1F30 0300" },
/* U+1f33 */ { 2, 0, 1, 0, "1F31 0300" },
/* U+1f34 */ { 2, 0, 1, 0, "1F30 0301" },
/* U+1f35 */ { 2, 0, 1, 0, "1F31 0301" },
/* U+1f36 */ { 2, 0, 1, 0, "1F30 0342" },
/* U+1f37 */ { 2, 0, 1, 0, "1F31 0342" },
/* U+1f38 */ { 1, 0, 1, 0, "0399 0313" },
/* U+1f39 */ { 1, 0, 1, 0, "0399 0314" },
/* U+1f3a */ { 1, 0, 1, 0, "1F38 0300" },
/* U+1f3b */ { 1, 0, 1, 0, "1F39 0300" },
/* U+1f3c */ { 1, 0, 1, 0, "1F38 0301" },
/* U+1f3d */ { 1, 0, 1, 0, "1F39 0301" },
/* U+1f3e */ { 1, 0, 1, 0, "1F38 0342" },
/* U+1f3f */ { 1, 0, 1, 0, "1F39 0342" },
/* U+1f40 */ { 2, 0, 1, 0, "03BF 0313" },
/* U+1f41 */ { 2, 0, 1, 0, "03BF 0314" },
/* U+1f42 */ { 2, 0, 1, 0, "1F40 0300" },
/* U+1f43 */ { 2, 0, 1, 0, "1F41 0300" },
/* U+1f44 */ { 2, 0, 1, 0, "1F40 0301" },
/* U+1f45 */ { 2, 0, 1, 0, "1F41 0301" },
/* U+1f46 */ { 0, 0, 0, 0, 0 },
/* U+1f47 */ { 0, 0, 0, 0, 0 },
/* U+1f48 */ { 1, 0, 1, 0, "039F 0313" },
/* U+1f49 */ { 1, 0, 1, 0, "039F 0314" },
/* U+1f4a */ { 1, 0, 1, 0, "1F48 0300" },
/* U+1f4b */ { 1, 0, 1, 0, "1F49 0300" },
/* U+1f4c */ { 1, 0, 1, 0, "1F48 0301" },
/* U+1f4d */ { 1, 0, 1, 0, "1F49 0301" },
/* U+1f4e */ { 0, 0, 0, 0, 0 },
/* U+1f4f */ { 0, 0, 0, 0, 0 },
/* U+1f50 */ { 2, 0, 1, 0, "03C5 0313" },
/* U+1f51 */ { 2, 0, 1, 0, "03C5 0314" },
/* U+1f52 */ { 2, 0, 1, 0, "1F50 0300" },
/* U+1f53 */ { 2, 0, 1, 0, "1F51 0300" },
/* U+1f54 */ { 2, 0, 1, 0, "1F50 0301" },
/* U+1f55 */ { 2, 0, 1, 0, "1F51 0301" },
/* U+1f56 */ { 2, 0, 1, 0, "1F50 0342" },
/* U+1f57 */ { 2, 0, 1, 0, "1F51 0342" },
/* U+1f58 */ { 0, 0, 0, 0, 0 },
/* U+1f59 */ { 1, 0, 1, 0, "03A5 0314" },
/* U+1f5a */ { 0, 0, 0, 0, 0 },
/* U+1f5b */ { 1, 0, 1, 0, "1F59 0300" },
/* U+1f5c */ { 0, 0, 0, 0, 0 },
/* U+1f5d */ { 1, 0, 1, 0, "1F59 0301" },
/* U+1f5e */ { 0, 0, 0, 0, 0 },
/* U+1f5f */ { 1, 0, 1, 0, "1F59 0342" },
/* U+1f60 */ { 2, 0, 1, 0, "03C9 0313" },
/* U+1f61 */ { 2, 0, 1, 0, "03C9 0314" },
/* U+1f62 */ { 2, 0, 1, 0, "1F60 0300" },
/* U+1f63 */ { 2, 0, 1, 0, "1F61 0300" },
/* U+1f64 */ { 2, 0, 1, 0, "1F60 0301" },
/* U+1f65 */ { 2, 0, 1, 0, "1F61 0301" },
/* U+1f66 */ { 2, 0, 1, 0, "1F60 0342" },
/* U+1f67 */ { 2, 0, 1, 0, "1F61 0342" },
/* U+1f68 */ { 1, 0, 1, 0, "03A9 0313" },
/* U+1f69 */ { 1, 0, 1, 0, "03A9 0314" },
/* U+1f6a */ { 1, 0, 1, 0, "1F68 0300" },
/* U+1f6b */ { 1, 0, 1, 0, "1F69 0300" },
/* U+1f6c */ { 1, 0, 1, 0, "1F68 0301" },
/* U+1f6d */ { 1, 0, 1, 0, "1F69 0301" },
/* U+1f6e */ { 1, 0, 1, 0, "1F68 0342" },
/* U+1f6f */ { 1, 0, 1, 0, "1F69 0342" },
/* U+1f70 */ { 2, 0, 1, 0, "03B1 0300" },
/* U+1f71 */ { 2, 0, 1, 0, "03AC" },
/* U+1f72 */ { 2, 0, 1, 0, "03B5 0300" },
/* U+1f73 */ { 2, 0, 1, 0, "03AD" },
/* U+1f74 */ { 2, 0, 1, 0, "03B7 0300" },
/* U+1f75 */ { 2, 0, 1, 0, "03AE" },
/* U+1f76 */ { 2, 0, 1, 0, "03B9 0300" },
/* U+1f77 */ { 2, 0, 1, 0, "03AF" },
/* U+1f78 */ { 2, 0, 1, 0, "03BF 0300" },
/* U+1f79 */ { 2, 0, 1, 0, "03CC" },
/* U+1f7a */ { 2, 0, 1, 0, "03C5 0300" },
/* U+1f7b */ { 2, 0, 1, 0, "03CD" },
/* U+1f7c */ { 2, 0, 1, 0, "03C9 0300" },
/* U+1f7d */ { 2, 0, 1, 0, "03CE" },
/* U+1f7e */ { 0, 0, 0, 0, 0 },
/* U+1f7f */ { 0, 0, 0, 0, 0 },
/* U+1f80 */ { 2, 0, 1, 0, "1F00 0345" },
/* U+1f81 */ { 2, 0, 1, 0, "1F01 0345" },
/* U+1f82 */ { 2, 0, 1, 0, "1F02 0345" },
/* U+1f83 */ { 2, 0, 1, 0, "1F03 0345" },
/* U+1f84 */ { 2, 0, 1, 0, "1F04 0345" },
/* U+1f85 */ { 2, 0, 1, 0, "1F05 0345" },
/* U+1f86 */ { 2, 0, 1, 0, "1F06 0345" },
/* U+1f87 */ { 2, 0, 1, 0, "1F07 0345" },
/* U+1f88 */ { 3, 0, 1, 0, "1F08 0345" },
/* U+1f89 */ { 3, 0, 1, 0, "1F09 0345" },
/* U+1f8a */ { 3, 0, 1, 0, "1F0A 0345" },
/* U+1f8b */ { 3, 0, 1, 0, "1F0B 0345" },
/* U+1f8c */ { 3, 0, 1, 0, "1F0C 0345" },
/* U+1f8d */ { 3, 0, 1, 0, "1F0D 0345" },
/* U+1f8e */ { 3, 0, 1, 0, "1F0E 0345" },
/* U+1f8f */ { 3, 0, 1, 0, "1F0F 0345" },
/* U+1f90 */ { 2, 0, 1, 0, "1F20 0345" },
/* U+1f91 */ { 2, 0, 1, 0, "1F21 0345" },
/* U+1f92 */ { 2, 0, 1, 0, "1F22 0345" },
/* U+1f93 */ { 2, 0, 1, 0, "1F23 0345" },
/* U+1f94 */ { 2, 0, 1, 0, "1F24 0345" },
/* U+1f95 */ { 2, 0, 1, 0, "1F25 0345" },
/* U+1f96 */ { 2, 0, 1, 0, "1F26 0345" },
/* U+1f97 */ { 2, 0, 1, 0, "1F27 0345" },
/* U+1f98 */ { 3, 0, 1, 0, "1F28 0345" },
/* U+1f99 */ { 3, 0, 1, 0, "1F29 0345" },
/* U+1f9a */ { 3, 0, 1, 0, "1F2A 0345" },
/* U+1f9b */ { 3, 0, 1, 0, "1F2B 0345" },
/* U+1f9c */ { 3, 0, 1, 0, "1F2C 0345" },
/* U+1f9d */ { 3, 0, 1, 0, "1F2D 0345" },
/* U+1f9e */ { 3, 0, 1, 0, "1F2E 0345" },
/* U+1f9f */ { 3, 0, 1, 0, "1F2F 0345" },
/* U+1fa0 */ { 2, 0, 1, 0, "1F60 0345" },
/* U+1fa1 */ { 2, 0, 1, 0, "1F61 0345" },
/* U+1fa2 */ { 2, 0, 1, 0, "1F62 0345" },
/* U+1fa3 */ { 2, 0, 1, 0, "1F63 0345" },
/* U+1fa4 */ { 2, 0, 1, 0, "1F64 0345" },
/* U+1fa5 */ { 2, 0, 1, 0, "1F65 0345" },
/* U+1fa6 */ { 2, 0, 1, 0, "1F66 0345" },
/* U+1fa7 */ { 2, 0, 1, 0, "1F67 0345" },
/* U+1fa8 */ { 3, 0, 1, 0, "1F68 0345" },
/* U+1fa9 */ { 3, 0, 1, 0, "1F69 0345" },
/* U+1faa */ { 3, 0, 1, 0, "1F6A 0345" },
/* U+1fab */ { 3, 0, 1, 0, "1F6B 0345" },
/* U+1fac */ { 3, 0, 1, 0, "1F6C 0345" },
/* U+1fad */ { 3, 0, 1, 0, "1F6D 0345" },
/* U+1fae */ { 3, 0, 1, 0, "1F6E 0345" },
/* U+1faf */ { 3, 0, 1, 0, "1F6F 0345" },
/* U+1fb0 */ { 2, 0, 1, 0, "03B1 0306" },
/* U+1fb1 */ { 2, 0, 1, 0, "03B1 0304" },
/* U+1fb2 */ { 2, 0, 1, 0, "1F70 0345" },
/* U+1fb3 */ { 2, 0, 1, 0, "03B1 0345" },
/* U+1fb4 */ { 2, 0, 1, 0, "03AC 0345" },
/* U+1fb5 */ { 0, 0, 0, 0, 0 },
/* U+1fb6 */ { 2, 0, 1, 0, "03B1 0342" },
/* U+1fb7 */ { 2, 0, 1, 0, "1FB6 0345" },
/* U+1fb8 */ { 1, 0, 1, 0, "0391 0306" },
/* U+1fb9 */ { 1, 0, 1, 0, "0391 0304" },
/* U+1fba */ { 1, 0, 1, 0, "0391 0300" },
/* U+1fbb */ { 1, 0, 1, 0, "0386" },
/* U+1fbc */ { 3, 0, 1, 0, "0391 0345" },
/* U+1fbd */ { 29, 0, 19, 0, "<compat> 0020 0313" },
/* U+1fbe */ { 2, 0, 1, 0, "03B9" },
/* U+1fbf */ { 29, 0, 19, 0, "<compat> 0020 0313" },
/* U+1fc0 */ { 29, 0, 19, 0, "<compat> 0020 0342" },
/* U+1fc1 */ { 29, 0, 19, 0, "00A8 0342" },
/* U+1fc2 */ { 2, 0, 1, 0, "1F74 0345" },
/* U+1fc3 */ { 2, 0, 1, 0, "03B7 0345" },
/* U+1fc4 */ { 2, 0, 1, 0, "03AE 0345" },
/* U+1fc5 */ { 0, 0, 0, 0, 0 },
/* U+1fc6 */ { 2, 0, 1, 0, "03B7 0342" },
/* U+1fc7 */ { 2, 0, 1, 0, "1FC6 0345" },
/* U+1fc8 */ { 1, 0, 1, 0, "0395 0300" },
/* U+1fc9 */ { 1, 0, 1, 0, "0388" },
/* U+1fca */ { 1, 0, 1, 0, "0397 0300" },
/* U+1fcb */ { 1, 0, 1, 0, "0389" },
/* U+1fcc */ { 3, 0, 1, 0, "0397 0345" },
/* U+1fcd */ { 29, 0, 19, 0, "1FBF 0300" },
/* U+1fce */ { 29, 0, 19, 0, "1FBF 0301" },
/* U+1fcf */ { 29, 0, 19, 0, "1FBF 0342" },
/* U+1fd0 */ { 2, 0, 1, 0, "03B9 0306" },
/* U+1fd1 */ { 2, 0, 1, 0, "03B9 0304" },
/* U+1fd2 */ { 2, 0, 1, 0, "03CA 0300" },
/* U+1fd3 */ { 2, 0, 1, 0, "0390" },
/* U+1fd4 */ { 0, 0, 0, 0, 0 },
/* U+1fd5 */ { 0, 0, 0, 0, 0 },
/* U+1fd6 */ { 2, 0, 1, 0, "03B9 0342" },
/* U+1fd7 */ { 2, 0, 1, 0, "03CA 0342" },
/* U+1fd8 */ { 1, 0, 1, 0, "0399 0306" },
/* U+1fd9 */ { 1, 0, 1, 0, "0399 0304" },
/* U+1fda */ { 1, 0, 1, 0, "0399 0300" },
/* U+1fdb */ { 1, 0, 1, 0, "038A" },
/* U+1fdc */ { 0, 0, 0, 0, 0 },
/* U+1fdd */ { 29, 0, 19, 0, "1FFE 0300" },
/* U+1fde */ { 29, 0, 19, 0, "1FFE 0301" },
/* U+1fdf */ { 29, 0, 19, 0, "1FFE 0342" },
/* U+1fe0 */ { 2, 0, 1, 0, "03C5 0306" },
/* U+1fe1 */ { 2, 0, 1, 0, "03C5 0304" },
/* U+1fe2 */ { 2, 0, 1, 0, "03CB 0300" },
/* U+1fe3 */ { 2, 0, 1, 0, "03B0" },
/* U+1fe4 */ { 2, 0, 1, 0, "03C1 0313" },
/* U+1fe5 */ { 2, 0, 1, 0, "03C1 0314" },
/* U+1fe6 */ { 2, 0, 1, 0, "03C5 0342" },
/* U+1fe7 */ { 2, 0, 1, 0, "03CB 0342" },
/* U+1fe8 */ { 1, 0, 1, 0, "03A5 0306" },
/* U+1fe9 */ { 1, 0, 1, 0, "03A5 0304" },
/* U+1fea */ { 1, 0, 1, 0, "03A5 0300" },
/* U+1feb */ { 1, 0, 1, 0, "038E" },
/* U+1fec */ { 1, 0, 1, 0, "03A1 0314" },
/* U+1fed */ { 29, 0, 19, 0, "00A8 0300" },
/* U+1fee */ { 29, 0, 19, 0, "0385" },
/* U+1fef */ { 29, 0, 19, 0, "0060" },
/* U+1ff0 */ { 0, 0, 0, 0, 0 },
/* U+1ff1 */ { 0, 0, 0, 0, 0 },
/* U+1ff2 */ { 2, 0, 1, 0, "1F7C 0345" },
/* U+1ff3 */ { 2, 0, 1, 0, "03C9 0345" },
/* U+1ff4 */ { 2, 0, 1, 0, "03CE 0345" },
/* U+1ff5 */ { 0, 0, 0, 0, 0 },
/* U+1ff6 */ { 2, 0, 1, 0, "03C9 0342" },
/* U+1ff7 */ { 2, 0, 1, 0, "1FF6 0345" },
/* U+1ff8 */ { 1, 0, 1, 0, "039F 0300" },
/* U+1ff9 */ { 1, 0, 1, 0, "038C" },
/* U+1ffa */ { 1, 0, 1, 0, "03A9 0300" },
/* U+1ffb */ { 1, 0, 1, 0, "038F" },
/* U+1ffc */ { 3, 0, 1, 0, "03A9 0345" },
/* U+1ffd */ { 29, 0, 19, 0, "00B4" },
/* U+1ffe */ { 29, 0, 19, 0, "<compat> 0020 0314" },
/* U+1fff */ { 0, 0, 0, 0, 0 },

};

const _PyUnicode_DatabaseRecord _PyUnicode_Database_2[4096] = {
    
/* U+2000 */ { 10, 0, 18, 0, "2002" },
/* U+2001 */ { 10, 0, 18, 0, "2003" },
/* U+2002 */ { 10, 0, 18, 0, "<compat> 0020" },
/* U+2003 */ { 10, 0, 18, 0, "<compat> 0020" },
/* U+2004 */ { 10, 0, 18, 0, "<compat> 0020" },
/* U+2005 */ { 10, 0, 18, 0, "<compat> 0020" },
/* U+2006 */ { 10, 0, 18, 0, "<compat> 0020" },
/* U+2007 */ { 10, 0, 18, 0, "<noBreak> 0020" },
/* U+2008 */ { 10, 0, 18, 0, "<compat> 0020" },
/* U+2009 */ { 10, 0, 18, 0, "<compat> 0020" },
/* U+200a */ { 10, 0, 18, 0, "<compat> 0020" },
/* U+200b */ { 10, 0, 15, 0, 0 },
/* U+200c */ { 14, 0, 15, 0, 0 },
/* U+200d */ { 14, 0, 15, 0, 0 },
/* U+200e */ { 14, 0, 1, 0, 0 },
/* U+200f */ { 14, 0, 4, 0, 0 },
/* U+2010 */ { 21, 0, 19, 0, 0 },
/* U+2011 */ { 21, 0, 19, 0, "<noBreak> 2010" },
/* U+2012 */ { 21, 0, 19, 0, 0 },
/* U+2013 */ { 21, 0, 19, 0, 0 },
/* U+2014 */ { 21, 0, 19, 0, 0 },
/* U+2015 */ { 21, 0, 19, 0, 0 },
/* U+2016 */ { 26, 0, 19, 0, 0 },
/* U+2017 */ { 26, 0, 19, 0, "<compat> 0020 0333" },
/* U+2018 */ { 24, 0, 19, 0, 0 },
/* U+2019 */ { 25, 0, 19, 0, 0 },
/* U+201a */ { 22, 0, 19, 0, 0 },
/* U+201b */ { 24, 0, 19, 0, 0 },
/* U+201c */ { 24, 0, 19, 0, 0 },
/* U+201d */ { 25, 0, 19, 0, 0 },
/* U+201e */ { 22, 0, 19, 0, 0 },
/* U+201f */ { 24, 0, 19, 0, 0 },
/* U+2020 */ { 26, 0, 19, 0, 0 },
/* U+2021 */ { 26, 0, 19, 0, 0 },
/* U+2022 */ { 26, 0, 19, 0, 0 },
/* U+2023 */ { 26, 0, 19, 0, 0 },
/* U+2024 */ { 26, 0, 19, 0, "<compat> 002E" },
/* U+2025 */ { 26, 0, 19, 0, "<compat> 002E 002E" },
/* U+2026 */ { 26, 0, 19, 0, "<compat> 002E 002E 002E" },
/* U+2027 */ { 26, 0, 19, 0, 0 },
/* U+2028 */ { 11, 0, 18, 0, 0 },
/* U+2029 */ { 12, 0, 16, 0, 0 },
/* U+202a */ { 14, 0, 2, 0, 0 },
/* U+202b */ { 14, 0, 6, 0, 0 },
/* U+202c */ { 14, 0, 8, 0, 0 },
/* U+202d */ { 14, 0, 3, 0, 0 },
/* U+202e */ { 14, 0, 7, 0, 0 },
/* U+202f */ { 10, 0, 18, 0, "<noBreak> 0020" },
/* U+2030 */ { 26, 0, 11, 0, 0 },
/* U+2031 */ { 26, 0, 11, 0, 0 },
/* U+2032 */ { 26, 0, 11, 0, 0 },
/* U+2033 */ { 26, 0, 11, 0, "<compat> 2032 2032" },
/* U+2034 */ { 26, 0, 11, 0, "<compat> 2032 2032 2032" },
/* U+2035 */ { 26, 0, 19, 0, 0 },
/* U+2036 */ { 26, 0, 19, 0, "<compat> 2035 2035" },
/* U+2037 */ { 26, 0, 19, 0, "<compat> 2035 2035 2035" },
/* U+2038 */ { 26, 0, 19, 0, 0 },
/* U+2039 */ { 24, 0, 19, 1, 0 },
/* U+203a */ { 25, 0, 19, 1, 0 },
/* U+203b */ { 26, 0, 19, 0, 0 },
/* U+203c */ { 26, 0, 19, 0, "<compat> 0021 0021" },
/* U+203d */ { 26, 0, 19, 0, 0 },
/* U+203e */ { 26, 0, 19, 0, "<compat> 0020 0305" },
/* U+203f */ { 20, 0, 19, 0, 0 },
/* U+2040 */ { 20, 0, 19, 0, 0 },
/* U+2041 */ { 26, 0, 19, 0, 0 },
/* U+2042 */ { 26, 0, 19, 0, 0 },
/* U+2043 */ { 26, 0, 19, 0, 0 },
/* U+2044 */ { 27, 0, 19, 0, 0 },
/* U+2045 */ { 22, 0, 19, 1, 0 },
/* U+2046 */ { 23, 0, 19, 1, 0 },
/* U+2047 */ { 0, 0, 0, 0, 0 },
/* U+2048 */ { 26, 0, 19, 0, "<compat> 003F 0021" },
/* U+2049 */ { 26, 0, 19, 0, "<compat> 0021 003F" },
/* U+204a */ { 26, 0, 19, 0, 0 },
/* U+204b */ { 26, 0, 19, 0, 0 },
/* U+204c */ { 26, 0, 19, 0, 0 },
/* U+204d */ { 26, 0, 19, 0, 0 },
/* U+204e */ { 0, 0, 0, 0, 0 },
/* U+204f */ { 0, 0, 0, 0, 0 },
/* U+2050 */ { 0, 0, 0, 0, 0 },
/* U+2051 */ { 0, 0, 0, 0, 0 },
/* U+2052 */ { 0, 0, 0, 0, 0 },
/* U+2053 */ { 0, 0, 0, 0, 0 },
/* U+2054 */ { 0, 0, 0, 0, 0 },
/* U+2055 */ { 0, 0, 0, 0, 0 },
/* U+2056 */ { 0, 0, 0, 0, 0 },
/* U+2057 */ { 0, 0, 0, 0, 0 },
/* U+2058 */ { 0, 0, 0, 0, 0 },
/* U+2059 */ { 0, 0, 0, 0, 0 },
/* U+205a */ { 0, 0, 0, 0, 0 },
/* U+205b */ { 0, 0, 0, 0, 0 },
/* U+205c */ { 0, 0, 0, 0, 0 },
/* U+205d */ { 0, 0, 0, 0, 0 },
/* U+205e */ { 0, 0, 0, 0, 0 },
/* U+205f */ { 0, 0, 0, 0, 0 },
/* U+2060 */ { 0, 0, 0, 0, 0 },
/* U+2061 */ { 0, 0, 0, 0, 0 },
/* U+2062 */ { 0, 0, 0, 0, 0 },
/* U+2063 */ { 0, 0, 0, 0, 0 },
/* U+2064 */ { 0, 0, 0, 0, 0 },
/* U+2065 */ { 0, 0, 0, 0, 0 },
/* U+2066 */ { 0, 0, 0, 0, 0 },
/* U+2067 */ { 0, 0, 0, 0, 0 },
/* U+2068 */ { 0, 0, 0, 0, 0 },
/* U+2069 */ { 0, 0, 0, 0, 0 },
/* U+206a */ { 14, 0, 15, 0, 0 },
/* U+206b */ { 14, 0, 15, 0, 0 },
/* U+206c */ { 14, 0, 15, 0, 0 },
/* U+206d */ { 14, 0, 15, 0, 0 },
/* U+206e */ { 14, 0, 15, 0, 0 },
/* U+206f */ { 14, 0, 15, 0, 0 },
/* U+2070 */ { 9, 0, 9, 0, "<super> 0030" },
/* U+2071 */ { 0, 0, 0, 0, 0 },
/* U+2072 */ { 0, 0, 0, 0, 0 },
/* U+2073 */ { 0, 0, 0, 0, 0 },
/* U+2074 */ { 9, 0, 9, 0, "<super> 0034" },
/* U+2075 */ { 9, 0, 9, 0, "<super> 0035" },
/* U+2076 */ { 9, 0, 9, 0, "<super> 0036" },
/* U+2077 */ { 9, 0, 9, 0, "<super> 0037" },
/* U+2078 */ { 9, 0, 9, 0, "<super> 0038" },
/* U+2079 */ { 9, 0, 9, 0, "<super> 0039" },
/* U+207a */ { 27, 0, 11, 0, "<super> 002B" },
/* U+207b */ { 27, 0, 11, 0, "<super> 2212" },
/* U+207c */ { 27, 0, 19, 0, "<super> 003D" },
/* U+207d */ { 22, 0, 19, 1, "<super> 0028" },
/* U+207e */ { 23, 0, 19, 1, "<super> 0029" },
/* U+207f */ { 2, 0, 1, 0, "<super> 006E" },
/* U+2080 */ { 9, 0, 9, 0, "<sub> 0030" },
/* U+2081 */ { 9, 0, 9, 0, "<sub> 0031" },
/* U+2082 */ { 9, 0, 9, 0, "<sub> 0032" },
/* U+2083 */ { 9, 0, 9, 0, "<sub> 0033" },
/* U+2084 */ { 9, 0, 9, 0, "<sub> 0034" },
/* U+2085 */ { 9, 0, 9, 0, "<sub> 0035" },
/* U+2086 */ { 9, 0, 9, 0, "<sub> 0036" },
/* U+2087 */ { 9, 0, 9, 0, "<sub> 0037" },
/* U+2088 */ { 9, 0, 9, 0, "<sub> 0038" },
/* U+2089 */ { 9, 0, 9, 0, "<sub> 0039" },
/* U+208a */ { 27, 0, 11, 0, "<sub> 002B" },
/* U+208b */ { 27, 0, 11, 0, "<sub> 2212" },
/* U+208c */ { 27, 0, 19, 0, "<sub> 003D" },
/* U+208d */ { 22, 0, 19, 1, "<sub> 0028" },
/* U+208e */ { 23, 0, 19, 1, "<sub> 0029" },
/* U+208f */ { 0, 0, 0, 0, 0 },
/* U+2090 */ { 0, 0, 0, 0, 0 },
/* U+2091 */ { 0, 0, 0, 0, 0 },
/* U+2092 */ { 0, 0, 0, 0, 0 },
/* U+2093 */ { 0, 0, 0, 0, 0 },
/* U+2094 */ { 0, 0, 0, 0, 0 },
/* U+2095 */ { 0, 0, 0, 0, 0 },
/* U+2096 */ { 0, 0, 0, 0, 0 },
/* U+2097 */ { 0, 0, 0, 0, 0 },
/* U+2098 */ { 0, 0, 0, 0, 0 },
/* U+2099 */ { 0, 0, 0, 0, 0 },
/* U+209a */ { 0, 0, 0, 0, 0 },
/* U+209b */ { 0, 0, 0, 0, 0 },
/* U+209c */ { 0, 0, 0, 0, 0 },
/* U+209d */ { 0, 0, 0, 0, 0 },
/* U+209e */ { 0, 0, 0, 0, 0 },
/* U+209f */ { 0, 0, 0, 0, 0 },
/* U+20a0 */ { 28, 0, 11, 0, 0 },
/* U+20a1 */ { 28, 0, 11, 0, 0 },
/* U+20a2 */ { 28, 0, 11, 0, 0 },
/* U+20a3 */ { 28, 0, 11, 0, 0 },
/* U+20a4 */ { 28, 0, 11, 0, 0 },
/* U+20a5 */ { 28, 0, 11, 0, 0 },
/* U+20a6 */ { 28, 0, 11, 0, 0 },
/* U+20a7 */ { 28, 0, 11, 0, 0 },
/* U+20a8 */ { 28, 0, 11, 0, "<compat> 0052 0073" },
/* U+20a9 */ { 28, 0, 11, 0, 0 },
/* U+20aa */ { 28, 0, 11, 0, 0 },
/* U+20ab */ { 28, 0, 11, 0, 0 },
/* U+20ac */ { 28, 0, 11, 0, 0 },
/* U+20ad */ { 28, 0, 11, 0, 0 },
/* U+20ae */ { 28, 0, 11, 0, 0 },
/* U+20af */ { 28, 0, 11, 0, 0 },
/* U+20b0 */ { 0, 0, 0, 0, 0 },
/* U+20b1 */ { 0, 0, 0, 0, 0 },
/* U+20b2 */ { 0, 0, 0, 0, 0 },
/* U+20b3 */ { 0, 0, 0, 0, 0 },
/* U+20b4 */ { 0, 0, 0, 0, 0 },
/* U+20b5 */ { 0, 0, 0, 0, 0 },
/* U+20b6 */ { 0, 0, 0, 0, 0 },
/* U+20b7 */ { 0, 0, 0, 0, 0 },
/* U+20b8 */ { 0, 0, 0, 0, 0 },
/* U+20b9 */ { 0, 0, 0, 0, 0 },
/* U+20ba */ { 0, 0, 0, 0, 0 },
/* U+20bb */ { 0, 0, 0, 0, 0 },
/* U+20bc */ { 0, 0, 0, 0, 0 },
/* U+20bd */ { 0, 0, 0, 0, 0 },
/* U+20be */ { 0, 0, 0, 0, 0 },
/* U+20bf */ { 0, 0, 0, 0, 0 },
/* U+20c0 */ { 0, 0, 0, 0, 0 },
/* U+20c1 */ { 0, 0, 0, 0, 0 },
/* U+20c2 */ { 0, 0, 0, 0, 0 },
/* U+20c3 */ { 0, 0, 0, 0, 0 },
/* U+20c4 */ { 0, 0, 0, 0, 0 },
/* U+20c5 */ { 0, 0, 0, 0, 0 },
/* U+20c6 */ { 0, 0, 0, 0, 0 },
/* U+20c7 */ { 0, 0, 0, 0, 0 },
/* U+20c8 */ { 0, 0, 0, 0, 0 },
/* U+20c9 */ { 0, 0, 0, 0, 0 },
/* U+20ca */ { 0, 0, 0, 0, 0 },
/* U+20cb */ { 0, 0, 0, 0, 0 },
/* U+20cc */ { 0, 0, 0, 0, 0 },
/* U+20cd */ { 0, 0, 0, 0, 0 },
/* U+20ce */ { 0, 0, 0, 0, 0 },
/* U+20cf */ { 0, 0, 0, 0, 0 },
/* U+20d0 */ { 4, 230, 14, 0, 0 },
/* U+20d1 */ { 4, 230, 14, 0, 0 },
/* U+20d2 */ { 4, 1, 14, 0, 0 },
/* U+20d3 */ { 4, 1, 14, 0, 0 },
/* U+20d4 */ { 4, 230, 14, 0, 0 },
/* U+20d5 */ { 4, 230, 14, 0, 0 },
/* U+20d6 */ { 4, 230, 14, 0, 0 },
/* U+20d7 */ { 4, 230, 14, 0, 0 },
/* U+20d8 */ { 4, 1, 14, 0, 0 },
/* U+20d9 */ { 4, 1, 14, 0, 0 },
/* U+20da */ { 4, 1, 14, 0, 0 },
/* U+20db */ { 4, 230, 14, 0, 0 },
/* U+20dc */ { 4, 230, 14, 0, 0 },
/* U+20dd */ { 6, 0, 14, 0, 0 },
/* U+20de */ { 6, 0, 14, 0, 0 },
/* U+20df */ { 6, 0, 14, 0, 0 },
/* U+20e0 */ { 6, 0, 14, 0, 0 },
/* U+20e1 */ { 4, 230, 14, 0, 0 },
/* U+20e2 */ { 6, 0, 14, 0, 0 },
/* U+20e3 */ { 6, 0, 14, 0, 0 },
/* U+20e4 */ { 0, 0, 0, 0, 0 },
/* U+20e5 */ { 0, 0, 0, 0, 0 },
/* U+20e6 */ { 0, 0, 0, 0, 0 },
/* U+20e7 */ { 0, 0, 0, 0, 0 },
/* U+20e8 */ { 0, 0, 0, 0, 0 },
/* U+20e9 */ { 0, 0, 0, 0, 0 },
/* U+20ea */ { 0, 0, 0, 0, 0 },
/* U+20eb */ { 0, 0, 0, 0, 0 },
/* U+20ec */ { 0, 0, 0, 0, 0 },
/* U+20ed */ { 0, 0, 0, 0, 0 },
/* U+20ee */ { 0, 0, 0, 0, 0 },
/* U+20ef */ { 0, 0, 0, 0, 0 },
/* U+20f0 */ { 0, 0, 0, 0, 0 },
/* U+20f1 */ { 0, 0, 0, 0, 0 },
/* U+20f2 */ { 0, 0, 0, 0, 0 },
/* U+20f3 */ { 0, 0, 0, 0, 0 },
/* U+20f4 */ { 0, 0, 0, 0, 0 },
/* U+20f5 */ { 0, 0, 0, 0, 0 },
/* U+20f6 */ { 0, 0, 0, 0, 0 },
/* U+20f7 */ { 0, 0, 0, 0, 0 },
/* U+20f8 */ { 0, 0, 0, 0, 0 },
/* U+20f9 */ { 0, 0, 0, 0, 0 },
/* U+20fa */ { 0, 0, 0, 0, 0 },
/* U+20fb */ { 0, 0, 0, 0, 0 },
/* U+20fc */ { 0, 0, 0, 0, 0 },
/* U+20fd */ { 0, 0, 0, 0, 0 },
/* U+20fe */ { 0, 0, 0, 0, 0 },
/* U+20ff */ { 0, 0, 0, 0, 0 },
/* U+2100 */ { 30, 0, 19, 0, "<compat> 0061 002F 0063" },
/* U+2101 */ { 30, 0, 19, 0, "<compat> 0061 002F 0073" },
/* U+2102 */ { 1, 0, 1, 0, "<font> 0043" },
/* U+2103 */ { 30, 0, 19, 0, "<compat> 00B0 0043" },
/* U+2104 */ { 30, 0, 19, 0, 0 },
/* U+2105 */ { 30, 0, 19, 0, "<compat> 0063 002F 006F" },
/* U+2106 */ { 30, 0, 19, 0, "<compat> 0063 002F 0075" },
/* U+2107 */ { 1, 0, 1, 0, "<compat> 0190" },
/* U+2108 */ { 30, 0, 19, 0, 0 },
/* U+2109 */ { 30, 0, 19, 0, "<compat> 00B0 0046" },
/* U+210a */ { 2, 0, 1, 0, "<font> 0067" },
/* U+210b */ { 1, 0, 1, 0, "<font> 0048" },
/* U+210c */ { 1, 0, 1, 0, "<font> 0048" },
/* U+210d */ { 1, 0, 1, 0, "<font> 0048" },
/* U+210e */ { 2, 0, 1, 0, "<font> 0068" },
/* U+210f */ { 2, 0, 1, 0, "<font> 0127" },
/* U+2110 */ { 1, 0, 1, 0, "<font> 0049" },
/* U+2111 */ { 1, 0, 1, 0, "<font> 0049" },
/* U+2112 */ { 1, 0, 1, 0, "<font> 004C" },
/* U+2113 */ { 2, 0, 1, 0, "<font> 006C" },
/* U+2114 */ { 30, 0, 19, 0, 0 },
/* U+2115 */ { 1, 0, 1, 0, "<font> 004E" },
/* U+2116 */ { 30, 0, 19, 0, "<compat> 004E 006F" },
/* U+2117 */ { 30, 0, 19, 0, 0 },
/* U+2118 */ { 30, 0, 19, 0, 0 },
/* U+2119 */ { 1, 0, 1, 0, "<font> 0050" },
/* U+211a */ { 1, 0, 1, 0, "<font> 0051" },
/* U+211b */ { 1, 0, 1, 0, "<font> 0052" },
/* U+211c */ { 1, 0, 1, 0, "<font> 0052" },
/* U+211d */ { 1, 0, 1, 0, "<font> 0052" },
/* U+211e */ { 30, 0, 19, 0, 0 },
/* U+211f */ { 30, 0, 19, 0, 0 },
/* U+2120 */ { 30, 0, 19, 0, "<super> 0053 004D" },
/* U+2121 */ { 30, 0, 19, 0, "<compat> 0054 0045 004C" },
/* U+2122 */ { 30, 0, 19, 0, "<super> 0054 004D" },
/* U+2123 */ { 30, 0, 19, 0, 0 },
/* U+2124 */ { 1, 0, 1, 0, "<font> 005A" },
/* U+2125 */ { 30, 0, 19, 0, 0 },
/* U+2126 */ { 1, 0, 1, 0, "03A9" },
/* U+2127 */ { 30, 0, 19, 0, 0 },
/* U+2128 */ { 1, 0, 1, 0, "<font> 005A" },
/* U+2129 */ { 30, 0, 19, 0, 0 },
/* U+212a */ { 1, 0, 1, 0, "004B" },
/* U+212b */ { 1, 0, 1, 0, "00C5" },
/* U+212c */ { 1, 0, 1, 0, "<font> 0042" },
/* U+212d */ { 1, 0, 1, 0, "<font> 0043" },
/* U+212e */ { 30, 0, 11, 0, 0 },
/* U+212f */ { 2, 0, 1, 0, "<font> 0065" },
/* U+2130 */ { 1, 0, 1, 0, "<font> 0045" },
/* U+2131 */ { 1, 0, 1, 0, "<font> 0046" },
/* U+2132 */ { 30, 0, 19, 0, 0 },
/* U+2133 */ { 1, 0, 1, 0, "<font> 004D" },
/* U+2134 */ { 2, 0, 1, 0, "<font> 006F" },
/* U+2135 */ { 19, 0, 1, 0, "<compat> 05D0" },
/* U+2136 */ { 19, 0, 1, 0, "<compat> 05D1" },
/* U+2137 */ { 19, 0, 1, 0, "<compat> 05D2" },
/* U+2138 */ { 19, 0, 1, 0, "<compat> 05D3" },
/* U+2139 */ { 2, 0, 1, 0, "<font> 0069" },
/* U+213a */ { 30, 0, 19, 0, 0 },
/* U+213b */ { 0, 0, 0, 0, 0 },
/* U+213c */ { 0, 0, 0, 0, 0 },
/* U+213d */ { 0, 0, 0, 0, 0 },
/* U+213e */ { 0, 0, 0, 0, 0 },
/* U+213f */ { 0, 0, 0, 0, 0 },
/* U+2140 */ { 0, 0, 0, 0, 0 },
/* U+2141 */ { 0, 0, 0, 0, 0 },
/* U+2142 */ { 0, 0, 0, 0, 0 },
/* U+2143 */ { 0, 0, 0, 0, 0 },
/* U+2144 */ { 0, 0, 0, 0, 0 },
/* U+2145 */ { 0, 0, 0, 0, 0 },
/* U+2146 */ { 0, 0, 0, 0, 0 },
/* U+2147 */ { 0, 0, 0, 0, 0 },
/* U+2148 */ { 0, 0, 0, 0, 0 },
/* U+2149 */ { 0, 0, 0, 0, 0 },
/* U+214a */ { 0, 0, 0, 0, 0 },
/* U+214b */ { 0, 0, 0, 0, 0 },
/* U+214c */ { 0, 0, 0, 0, 0 },
/* U+214d */ { 0, 0, 0, 0, 0 },
/* U+214e */ { 0, 0, 0, 0, 0 },
/* U+214f */ { 0, 0, 0, 0, 0 },
/* U+2150 */ { 0, 0, 0, 0, 0 },
/* U+2151 */ { 0, 0, 0, 0, 0 },
/* U+2152 */ { 0, 0, 0, 0, 0 },
/* U+2153 */ { 9, 0, 19, 0, "<fraction> 0031 2044 0033" },
/* U+2154 */ { 9, 0, 19, 0, "<fraction> 0032 2044 0033" },
/* U+2155 */ { 9, 0, 19, 0, "<fraction> 0031 2044 0035" },
/* U+2156 */ { 9, 0, 19, 0, "<fraction> 0032 2044 0035" },
/* U+2157 */ { 9, 0, 19, 0, "<fraction> 0033 2044 0035" },
/* U+2158 */ { 9, 0, 19, 0, "<fraction> 0034 2044 0035" },
/* U+2159 */ { 9, 0, 19, 0, "<fraction> 0031 2044 0036" },
/* U+215a */ { 9, 0, 19, 0, "<fraction> 0035 2044 0036" },
/* U+215b */ { 9, 0, 19, 0, "<fraction> 0031 2044 0038" },
/* U+215c */ { 9, 0, 19, 0, "<fraction> 0033 2044 0038" },
/* U+215d */ { 9, 0, 19, 0, "<fraction> 0035 2044 0038" },
/* U+215e */ { 9, 0, 19, 0, "<fraction> 0037 2044 0038" },
/* U+215f */ { 9, 0, 19, 0, "<fraction> 0031 2044" },
/* U+2160 */ { 8, 0, 1, 0, "<compat> 0049" },
/* U+2161 */ { 8, 0, 1, 0, "<compat> 0049 0049" },
/* U+2162 */ { 8, 0, 1, 0, "<compat> 0049 0049 0049" },
/* U+2163 */ { 8, 0, 1, 0, "<compat> 0049 0056" },
/* U+2164 */ { 8, 0, 1, 0, "<compat> 0056" },
/* U+2165 */ { 8, 0, 1, 0, "<compat> 0056 0049" },
/* U+2166 */ { 8, 0, 1, 0, "<compat> 0056 0049 0049" },
/* U+2167 */ { 8, 0, 1, 0, "<compat> 0056 0049 0049 0049" },
/* U+2168 */ { 8, 0, 1, 0, "<compat> 0049 0058" },
/* U+2169 */ { 8, 0, 1, 0, "<compat> 0058" },
/* U+216a */ { 8, 0, 1, 0, "<compat> 0058 0049" },
/* U+216b */ { 8, 0, 1, 0, "<compat> 0058 0049 0049" },
/* U+216c */ { 8, 0, 1, 0, "<compat> 004C" },
/* U+216d */ { 8, 0, 1, 0, "<compat> 0043" },
/* U+216e */ { 8, 0, 1, 0, "<compat> 0044" },
/* U+216f */ { 8, 0, 1, 0, "<compat> 004D" },
/* U+2170 */ { 8, 0, 1, 0, "<compat> 0069" },
/* U+2171 */ { 8, 0, 1, 0, "<compat> 0069 0069" },
/* U+2172 */ { 8, 0, 1, 0, "<compat> 0069 0069 0069" },
/* U+2173 */ { 8, 0, 1, 0, "<compat> 0069 0076" },
/* U+2174 */ { 8, 0, 1, 0, "<compat> 0076" },
/* U+2175 */ { 8, 0, 1, 0, "<compat> 0076 0069" },
/* U+2176 */ { 8, 0, 1, 0, "<compat> 0076 0069 0069" },
/* U+2177 */ { 8, 0, 1, 0, "<compat> 0076 0069 0069 0069" },
/* U+2178 */ { 8, 0, 1, 0, "<compat> 0069 0078" },
/* U+2179 */ { 8, 0, 1, 0, "<compat> 0078" },
/* U+217a */ { 8, 0, 1, 0, "<compat> 0078 0069" },
/* U+217b */ { 8, 0, 1, 0, "<compat> 0078 0069 0069" },
/* U+217c */ { 8, 0, 1, 0, "<compat> 006C" },
/* U+217d */ { 8, 0, 1, 0, "<compat> 0063" },
/* U+217e */ { 8, 0, 1, 0, "<compat> 0064" },
/* U+217f */ { 8, 0, 1, 0, "<compat> 006D" },
/* U+2180 */ { 8, 0, 1, 0, 0 },
/* U+2181 */ { 8, 0, 1, 0, 0 },
/* U+2182 */ { 8, 0, 1, 0, 0 },
/* U+2183 */ { 8, 0, 1, 0, 0 },
/* U+2184 */ { 0, 0, 0, 0, 0 },
/* U+2185 */ { 0, 0, 0, 0, 0 },
/* U+2186 */ { 0, 0, 0, 0, 0 },
/* U+2187 */ { 0, 0, 0, 0, 0 },
/* U+2188 */ { 0, 0, 0, 0, 0 },
/* U+2189 */ { 0, 0, 0, 0, 0 },
/* U+218a */ { 0, 0, 0, 0, 0 },
/* U+218b */ { 0, 0, 0, 0, 0 },
/* U+218c */ { 0, 0, 0, 0, 0 },
/* U+218d */ { 0, 0, 0, 0, 0 },
/* U+218e */ { 0, 0, 0, 0, 0 },
/* U+218f */ { 0, 0, 0, 0, 0 },
/* U+2190 */ { 27, 0, 19, 0, 0 },
/* U+2191 */ { 27, 0, 19, 0, 0 },
/* U+2192 */ { 27, 0, 19, 0, 0 },
/* U+2193 */ { 27, 0, 19, 0, 0 },
/* U+2194 */ { 27, 0, 19, 0, 0 },
/* U+2195 */ { 30, 0, 19, 0, 0 },
/* U+2196 */ { 30, 0, 19, 0, 0 },
/* U+2197 */ { 30, 0, 19, 0, 0 },
/* U+2198 */ { 30, 0, 19, 0, 0 },
/* U+2199 */ { 30, 0, 19, 0, 0 },
/* U+219a */ { 27, 0, 19, 0, "2190 0338" },
/* U+219b */ { 27, 0, 19, 0, "2192 0338" },
/* U+219c */ { 30, 0, 19, 0, 0 },
/* U+219d */ { 30, 0, 19, 0, 0 },
/* U+219e */ { 30, 0, 19, 0, 0 },
/* U+219f */ { 30, 0, 19, 0, 0 },
/* U+21a0 */ { 27, 0, 19, 0, 0 },
/* U+21a1 */ { 30, 0, 19, 0, 0 },
/* U+21a2 */ { 30, 0, 19, 0, 0 },
/* U+21a3 */ { 27, 0, 19, 0, 0 },
/* U+21a4 */ { 30, 0, 19, 0, 0 },
/* U+21a5 */ { 30, 0, 19, 0, 0 },
/* U+21a6 */ { 27, 0, 19, 0, 0 },
/* U+21a7 */ { 30, 0, 19, 0, 0 },
/* U+21a8 */ { 30, 0, 19, 0, 0 },
/* U+21a9 */ { 30, 0, 19, 0, 0 },
/* U+21aa */ { 30, 0, 19, 0, 0 },
/* U+21ab */ { 30, 0, 19, 0, 0 },
/* U+21ac */ { 30, 0, 19, 0, 0 },
/* U+21ad */ { 30, 0, 19, 0, 0 },
/* U+21ae */ { 27, 0, 19, 0, "2194 0338" },
/* U+21af */ { 30, 0, 19, 0, 0 },
/* U+21b0 */ { 30, 0, 19, 0, 0 },
/* U+21b1 */ { 30, 0, 19, 0, 0 },
/* U+21b2 */ { 30, 0, 19, 0, 0 },
/* U+21b3 */ { 30, 0, 19, 0, 0 },
/* U+21b4 */ { 30, 0, 19, 0, 0 },
/* U+21b5 */ { 30, 0, 19, 0, 0 },
/* U+21b6 */ { 30, 0, 19, 0, 0 },
/* U+21b7 */ { 30, 0, 19, 0, 0 },
/* U+21b8 */ { 30, 0, 19, 0, 0 },
/* U+21b9 */ { 30, 0, 19, 0, 0 },
/* U+21ba */ { 30, 0, 19, 0, 0 },
/* U+21bb */ { 30, 0, 19, 0, 0 },
/* U+21bc */ { 30, 0, 19, 0, 0 },
/* U+21bd */ { 30, 0, 19, 0, 0 },
/* U+21be */ { 30, 0, 19, 0, 0 },
/* U+21bf */ { 30, 0, 19, 0, 0 },
/* U+21c0 */ { 30, 0, 19, 0, 0 },
/* U+21c1 */ { 30, 0, 19, 0, 0 },
/* U+21c2 */ { 30, 0, 19, 0, 0 },
/* U+21c3 */ { 30, 0, 19, 0, 0 },
/* U+21c4 */ { 30, 0, 19, 0, 0 },
/* U+21c5 */ { 30, 0, 19, 0, 0 },
/* U+21c6 */ { 30, 0, 19, 0, 0 },
/* U+21c7 */ { 30, 0, 19, 0, 0 },
/* U+21c8 */ { 30, 0, 19, 0, 0 },
/* U+21c9 */ { 30, 0, 19, 0, 0 },
/* U+21ca */ { 30, 0, 19, 0, 0 },
/* U+21cb */ { 30, 0, 19, 0, 0 },
/* U+21cc */ { 30, 0, 19, 0, 0 },
/* U+21cd */ { 30, 0, 19, 0, "21D0 0338" },
/* U+21ce */ { 27, 0, 19, 0, "21D4 0338" },
/* U+21cf */ { 27, 0, 19, 0, "21D2 0338" },
/* U+21d0 */ { 30, 0, 19, 0, 0 },
/* U+21d1 */ { 30, 0, 19, 0, 0 },
/* U+21d2 */ { 27, 0, 19, 0, 0 },
/* U+21d3 */ { 30, 0, 19, 0, 0 },
/* U+21d4 */ { 27, 0, 19, 0, 0 },
/* U+21d5 */ { 30, 0, 19, 0, 0 },
/* U+21d6 */ { 30, 0, 19, 0, 0 },
/* U+21d7 */ { 30, 0, 19, 0, 0 },
/* U+21d8 */ { 30, 0, 19, 0, 0 },
/* U+21d9 */ { 30, 0, 19, 0, 0 },
/* U+21da */ { 30, 0, 19, 0, 0 },
/* U+21db */ { 30, 0, 19, 0, 0 },
/* U+21dc */ { 30, 0, 19, 0, 0 },
/* U+21dd */ { 30, 0, 19, 0, 0 },
/* U+21de */ { 30, 0, 19, 0, 0 },
/* U+21df */ { 30, 0, 19, 0, 0 },
/* U+21e0 */ { 30, 0, 19, 0, 0 },
/* U+21e1 */ { 30, 0, 19, 0, 0 },
/* U+21e2 */ { 30, 0, 19, 0, 0 },
/* U+21e3 */ { 30, 0, 19, 0, 0 },
/* U+21e4 */ { 30, 0, 19, 0, 0 },
/* U+21e5 */ { 30, 0, 19, 0, 0 },
/* U+21e6 */ { 30, 0, 19, 0, 0 },
/* U+21e7 */ { 30, 0, 19, 0, 0 },
/* U+21e8 */ { 30, 0, 19, 0, 0 },
/* U+21e9 */ { 30, 0, 19, 0, 0 },
/* U+21ea */ { 30, 0, 19, 0, 0 },
/* U+21eb */ { 30, 0, 19, 0, 0 },
/* U+21ec */ { 30, 0, 19, 0, 0 },
/* U+21ed */ { 30, 0, 19, 0, 0 },
/* U+21ee */ { 30, 0, 19, 0, 0 },
/* U+21ef */ { 30, 0, 19, 0, 0 },
/* U+21f0 */ { 30, 0, 19, 0, 0 },
/* U+21f1 */ { 30, 0, 19, 0, 0 },
/* U+21f2 */ { 30, 0, 19, 0, 0 },
/* U+21f3 */ { 30, 0, 19, 0, 0 },
/* U+21f4 */ { 0, 0, 0, 0, 0 },
/* U+21f5 */ { 0, 0, 0, 0, 0 },
/* U+21f6 */ { 0, 0, 0, 0, 0 },
/* U+21f7 */ { 0, 0, 0, 0, 0 },
/* U+21f8 */ { 0, 0, 0, 0, 0 },
/* U+21f9 */ { 0, 0, 0, 0, 0 },
/* U+21fa */ { 0, 0, 0, 0, 0 },
/* U+21fb */ { 0, 0, 0, 0, 0 },
/* U+21fc */ { 0, 0, 0, 0, 0 },
/* U+21fd */ { 0, 0, 0, 0, 0 },
/* U+21fe */ { 0, 0, 0, 0, 0 },
/* U+21ff */ { 0, 0, 0, 0, 0 },
/* U+2200 */ { 27, 0, 19, 0, 0 },
/* U+2201 */ { 27, 0, 19, 1, 0 },
/* U+2202 */ { 27, 0, 19, 1, 0 },
/* U+2203 */ { 27, 0, 19, 1, 0 },
/* U+2204 */ { 27, 0, 19, 1, "2203 0338" },
/* U+2205 */ { 27, 0, 19, 0, 0 },
/* U+2206 */ { 27, 0, 19, 0, 0 },
/* U+2207 */ { 27, 0, 19, 0, 0 },
/* U+2208 */ { 27, 0, 19, 1, 0 },
/* U+2209 */ { 27, 0, 19, 1, "2208 0338" },
/* U+220a */ { 27, 0, 19, 1, 0 },
/* U+220b */ { 27, 0, 19, 1, 0 },
/* U+220c */ { 27, 0, 19, 1, "220B 0338" },
/* U+220d */ { 27, 0, 19, 1, 0 },
/* U+220e */ { 27, 0, 19, 0, 0 },
/* U+220f */ { 27, 0, 19, 0, 0 },
/* U+2210 */ { 27, 0, 19, 0, 0 },
/* U+2211 */ { 27, 0, 19, 1, 0 },
/* U+2212 */ { 27, 0, 11, 0, 0 },
/* U+2213 */ { 27, 0, 11, 0, 0 },
/* U+2214 */ { 27, 0, 19, 0, 0 },
/* U+2215 */ { 27, 0, 19, 1, 0 },
/* U+2216 */ { 27, 0, 19, 1, 0 },
/* U+2217 */ { 27, 0, 19, 0, 0 },
/* U+2218 */ { 27, 0, 19, 0, 0 },
/* U+2219 */ { 27, 0, 19, 0, 0 },
/* U+221a */ { 27, 0, 19, 1, 0 },
/* U+221b */ { 27, 0, 19, 1, 0 },
/* U+221c */ { 27, 0, 19, 1, 0 },
/* U+221d */ { 27, 0, 19, 1, 0 },
/* U+221e */ { 27, 0, 19, 0, 0 },
/* U+221f */ { 27, 0, 19, 1, 0 },
/* U+2220 */ { 27, 0, 19, 1, 0 },
/* U+2221 */ { 27, 0, 19, 1, 0 },
/* U+2222 */ { 27, 0, 19, 1, 0 },
/* U+2223 */ { 27, 0, 19, 0, 0 },
/* U+2224 */ { 27, 0, 19, 1, "2223 0338" },
/* U+2225 */ { 27, 0, 19, 0, 0 },
/* U+2226 */ { 27, 0, 19, 1, "2225 0338" },
/* U+2227 */ { 27, 0, 19, 0, 0 },
/* U+2228 */ { 27, 0, 19, 0, 0 },
/* U+2229 */ { 27, 0, 19, 0, 0 },
/* U+222a */ { 27, 0, 19, 0, 0 },
/* U+222b */ { 27, 0, 19, 1, 0 },
/* U+222c */ { 27, 0, 19, 1, "<compat> 222B 222B" },
/* U+222d */ { 27, 0, 19, 1, "<compat> 222B 222B 222B" },
/* U+222e */ { 27, 0, 19, 1, 0 },
/* U+222f */ { 27, 0, 19, 1, "<compat> 222E 222E" },
/* U+2230 */ { 27, 0, 19, 1, "<compat> 222E 222E 222E" },
/* U+2231 */ { 27, 0, 19, 1, 0 },
/* U+2232 */ { 27, 0, 19, 1, 0 },
/* U+2233 */ { 27, 0, 19, 1, 0 },
/* U+2234 */ { 27, 0, 19, 0, 0 },
/* U+2235 */ { 27, 0, 19, 0, 0 },
/* U+2236 */ { 27, 0, 19, 0, 0 },
/* U+2237 */ { 27, 0, 19, 0, 0 },
/* U+2238 */ { 27, 0, 19, 0, 0 },
/* U+2239 */ { 27, 0, 19, 1, 0 },
/* U+223a */ { 27, 0, 19, 0, 0 },
/* U+223b */ { 27, 0, 19, 1, 0 },
/* U+223c */ { 27, 0, 19, 1, 0 },
/* U+223d */ { 27, 0, 19, 1, 0 },
/* U+223e */ { 27, 0, 19, 1, 0 },
/* U+223f */ { 27, 0, 19, 1, 0 },
/* U+2240 */ { 27, 0, 19, 1, 0 },
/* U+2241 */ { 27, 0, 19, 1, "223C 0338" },
/* U+2242 */ { 27, 0, 19, 1, 0 },
/* U+2243 */ { 27, 0, 19, 1, 0 },
/* U+2244 */ { 27, 0, 19, 1, "2243 0338" },
/* U+2245 */ { 27, 0, 19, 1, 0 },
/* U+2246 */ { 27, 0, 19, 1, 0 },
/* U+2247 */ { 27, 0, 19, 1, "2245 0338" },
/* U+2248 */ { 27, 0, 19, 1, 0 },
/* U+2249 */ { 27, 0, 19, 1, "2248 0338" },
/* U+224a */ { 27, 0, 19, 1, 0 },
/* U+224b */ { 27, 0, 19, 1, 0 },
/* U+224c */ { 27, 0, 19, 1, 0 },
/* U+224d */ { 27, 0, 19, 0, 0 },
/* U+224e */ { 27, 0, 19, 0, 0 },
/* U+224f */ { 27, 0, 19, 0, 0 },
/* U+2250 */ { 27, 0, 19, 0, 0 },
/* U+2251 */ { 27, 0, 19, 0, 0 },
/* U+2252 */ { 27, 0, 19, 1, 0 },
/* U+2253 */ { 27, 0, 19, 1, 0 },
/* U+2254 */ { 27, 0, 19, 1, 0 },
/* U+2255 */ { 27, 0, 19, 1, 0 },
/* U+2256 */ { 27, 0, 19, 0, 0 },
/* U+2257 */ { 27, 0, 19, 0, 0 },
/* U+2258 */ { 27, 0, 19, 0, 0 },
/* U+2259 */ { 27, 0, 19, 0, 0 },
/* U+225a */ { 27, 0, 19, 0, 0 },
/* U+225b */ { 27, 0, 19, 0, 0 },
/* U+225c */ { 27, 0, 19, 0, 0 },
/* U+225d */ { 27, 0, 19, 0, 0 },
/* U+225e */ { 27, 0, 19, 0, 0 },
/* U+225f */ { 27, 0, 19, 1, 0 },
/* U+2260 */ { 27, 0, 19, 1, "003D 0338" },
/* U+2261 */ { 27, 0, 19, 0, 0 },
/* U+2262 */ { 27, 0, 19, 1, "2261 0338" },
/* U+2263 */ { 27, 0, 19, 0, 0 },
/* U+2264 */ { 27, 0, 19, 1, 0 },
/* U+2265 */ { 27, 0, 19, 1, 0 },
/* U+2266 */ { 27, 0, 19, 1, 0 },
/* U+2267 */ { 27, 0, 19, 1, 0 },
/* U+2268 */ { 27, 0, 19, 1, 0 },
/* U+2269 */ { 27, 0, 19, 1, 0 },
/* U+226a */ { 27, 0, 19, 1, 0 },
/* U+226b */ { 27, 0, 19, 1, 0 },
/* U+226c */ { 27, 0, 19, 0, 0 },
/* U+226d */ { 27, 0, 19, 0, "224D 0338" },
/* U+226e */ { 27, 0, 19, 1, "003C 0338" },
/* U+226f */ { 27, 0, 19, 1, "003E 0338" },
/* U+2270 */ { 27, 0, 19, 1, "2264 0338" },
/* U+2271 */ { 27, 0, 19, 1, "2265 0338" },
/* U+2272 */ { 27, 0, 19, 1, 0 },
/* U+2273 */ { 27, 0, 19, 1, 0 },
/* U+2274 */ { 27, 0, 19, 1, "2272 0338" },
/* U+2275 */ { 27, 0, 19, 1, "2273 0338" },
/* U+2276 */ { 27, 0, 19, 1, 0 },
/* U+2277 */ { 27, 0, 19, 1, 0 },
/* U+2278 */ { 27, 0, 19, 1, "2276 0338" },
/* U+2279 */ { 27, 0, 19, 1, "2277 0338" },
/* U+227a */ { 27, 0, 19, 1, 0 },
/* U+227b */ { 27, 0, 19, 1, 0 },
/* U+227c */ { 27, 0, 19, 1, 0 },
/* U+227d */ { 27, 0, 19, 1, 0 },
/* U+227e */ { 27, 0, 19, 1, 0 },
/* U+227f */ { 27, 0, 19, 1, 0 },
/* U+2280 */ { 27, 0, 19, 1, "227A 0338" },
/* U+2281 */ { 27, 0, 19, 1, "227B 0338" },
/* U+2282 */ { 27, 0, 19, 1, 0 },
/* U+2283 */ { 27, 0, 19, 1, 0 },
/* U+2284 */ { 27, 0, 19, 1, "2282 0338" },
/* U+2285 */ { 27, 0, 19, 1, "2283 0338" },
/* U+2286 */ { 27, 0, 19, 1, 0 },
/* U+2287 */ { 27, 0, 19, 1, 0 },
/* U+2288 */ { 27, 0, 19, 1, "2286 0338" },
/* U+2289 */ { 27, 0, 19, 1, "2287 0338" },
/* U+228a */ { 27, 0, 19, 1, 0 },
/* U+228b */ { 27, 0, 19, 1, 0 },
/* U+228c */ { 27, 0, 19, 1, 0 },
/* U+228d */ { 27, 0, 19, 0, 0 },
/* U+228e */ { 27, 0, 19, 0, 0 },
/* U+228f */ { 27, 0, 19, 1, 0 },
/* U+2290 */ { 27, 0, 19, 1, 0 },
/* U+2291 */ { 27, 0, 19, 1, 0 },
/* U+2292 */ { 27, 0, 19, 1, 0 },
/* U+2293 */ { 27, 0, 19, 0, 0 },
/* U+2294 */ { 27, 0, 19, 0, 0 },
/* U+2295 */ { 27, 0, 19, 0, 0 },
/* U+2296 */ { 27, 0, 19, 0, 0 },
/* U+2297 */ { 27, 0, 19, 0, 0 },
/* U+2298 */ { 27, 0, 19, 1, 0 },
/* U+2299 */ { 27, 0, 19, 0, 0 },
/* U+229a */ { 27, 0, 19, 0, 0 },
/* U+229b */ { 27, 0, 19, 0, 0 },
/* U+229c */ { 27, 0, 19, 0, 0 },
/* U+229d */ { 27, 0, 19, 0, 0 },
/* U+229e */ { 27, 0, 19, 0, 0 },
/* U+229f */ { 27, 0, 19, 0, 0 },
/* U+22a0 */ { 27, 0, 19, 0, 0 },
/* U+22a1 */ { 27, 0, 19, 0, 0 },
/* U+22a2 */ { 27, 0, 19, 1, 0 },
/* U+22a3 */ { 27, 0, 19, 1, 0 },
/* U+22a4 */ { 27, 0, 19, 0, 0 },
/* U+22a5 */ { 27, 0, 19, 0, 0 },
/* U+22a6 */ { 27, 0, 19, 1, 0 },
/* U+22a7 */ { 27, 0, 19, 1, 0 },
/* U+22a8 */ { 27, 0, 19, 1, 0 },
/* U+22a9 */ { 27, 0, 19, 1, 0 },
/* U+22aa */ { 27, 0, 19, 1, 0 },
/* U+22ab */ { 27, 0, 19, 1, 0 },
/* U+22ac */ { 27, 0, 19, 1, "22A2 0338" },
/* U+22ad */ { 27, 0, 19, 1, "22A8 0338" },
/* U+22ae */ { 27, 0, 19, 1, "22A9 0338" },
/* U+22af */ { 27, 0, 19, 1, "22AB 0338" },
/* U+22b0 */ { 27, 0, 19, 1, 0 },
/* U+22b1 */ { 27, 0, 19, 1, 0 },
/* U+22b2 */ { 27, 0, 19, 1, 0 },
/* U+22b3 */ { 27, 0, 19, 1, 0 },
/* U+22b4 */ { 27, 0, 19, 1, 0 },
/* U+22b5 */ { 27, 0, 19, 1, 0 },
/* U+22b6 */ { 27, 0, 19, 1, 0 },
/* U+22b7 */ { 27, 0, 19, 1, 0 },
/* U+22b8 */ { 27, 0, 19, 1, 0 },
/* U+22b9 */ { 27, 0, 19, 0, 0 },
/* U+22ba */ { 27, 0, 19, 0, 0 },
/* U+22bb */ { 27, 0, 19, 0, 0 },
/* U+22bc */ { 27, 0, 19, 0, 0 },
/* U+22bd */ { 27, 0, 19, 0, 0 },
/* U+22be */ { 27, 0, 19, 1, 0 },
/* U+22bf */ { 27, 0, 19, 1, 0 },
/* U+22c0 */ { 27, 0, 19, 0, 0 },
/* U+22c1 */ { 27, 0, 19, 0, 0 },
/* U+22c2 */ { 27, 0, 19, 0, 0 },
/* U+22c3 */ { 27, 0, 19, 0, 0 },
/* U+22c4 */ { 27, 0, 19, 0, 0 },
/* U+22c5 */ { 27, 0, 19, 0, 0 },
/* U+22c6 */ { 27, 0, 19, 0, 0 },
/* U+22c7 */ { 27, 0, 19, 0, 0 },
/* U+22c8 */ { 27, 0, 19, 0, 0 },
/* U+22c9 */ { 27, 0, 19, 1, 0 },
/* U+22ca */ { 27, 0, 19, 1, 0 },
/* U+22cb */ { 27, 0, 19, 1, 0 },
/* U+22cc */ { 27, 0, 19, 1, 0 },
/* U+22cd */ { 27, 0, 19, 1, 0 },
/* U+22ce */ { 27, 0, 19, 0, 0 },
/* U+22cf */ { 27, 0, 19, 0, 0 },
/* U+22d0 */ { 27, 0, 19, 1, 0 },
/* U+22d1 */ { 27, 0, 19, 1, 0 },
/* U+22d2 */ { 27, 0, 19, 0, 0 },
/* U+22d3 */ { 27, 0, 19, 0, 0 },
/* U+22d4 */ { 27, 0, 19, 0, 0 },
/* U+22d5 */ { 27, 0, 19, 0, 0 },
/* U+22d6 */ { 27, 0, 19, 1, 0 },
/* U+22d7 */ { 27, 0, 19, 1, 0 },
/* U+22d8 */ { 27, 0, 19, 1, 0 },
/* U+22d9 */ { 27, 0, 19, 1, 0 },
/* U+22da */ { 27, 0, 19, 1, 0 },
/* U+22db */ { 27, 0, 19, 1, 0 },
/* U+22dc */ { 27, 0, 19, 1, 0 },
/* U+22dd */ { 27, 0, 19, 1, 0 },
/* U+22de */ { 27, 0, 19, 1, 0 },
/* U+22df */ { 27, 0, 19, 1, 0 },
/* U+22e0 */ { 27, 0, 19, 1, "227C 0338" },
/* U+22e1 */ { 27, 0, 19, 1, "227D 0338" },
/* U+22e2 */ { 27, 0, 19, 1, "2291 0338" },
/* U+22e3 */ { 27, 0, 19, 1, "2292 0338" },
/* U+22e4 */ { 27, 0, 19, 1, 0 },
/* U+22e5 */ { 27, 0, 19, 1, 0 },
/* U+22e6 */ { 27, 0, 19, 1, 0 },
/* U+22e7 */ { 27, 0, 19, 1, 0 },
/* U+22e8 */ { 27, 0, 19, 1, 0 },
/* U+22e9 */ { 27, 0, 19, 1, 0 },
/* U+22ea */ { 27, 0, 19, 1, "22B2 0338" },
/* U+22eb */ { 27, 0, 19, 1, "22B3 0338" },
/* U+22ec */ { 27, 0, 19, 1, "22B4 0338" },
/* U+22ed */ { 27, 0, 19, 1, "22B5 0338" },
/* U+22ee */ { 27, 0, 19, 0, 0 },
/* U+22ef */ { 27, 0, 19, 0, 0 },
/* U+22f0 */ { 27, 0, 19, 1, 0 },
/* U+22f1 */ { 27, 0, 19, 1, 0 },
/* U+22f2 */ { 0, 0, 0, 0, 0 },
/* U+22f3 */ { 0, 0, 0, 0, 0 },
/* U+22f4 */ { 0, 0, 0, 0, 0 },
/* U+22f5 */ { 0, 0, 0, 0, 0 },
/* U+22f6 */ { 0, 0, 0, 0, 0 },
/* U+22f7 */ { 0, 0, 0, 0, 0 },
/* U+22f8 */ { 0, 0, 0, 0, 0 },
/* U+22f9 */ { 0, 0, 0, 0, 0 },
/* U+22fa */ { 0, 0, 0, 0, 0 },
/* U+22fb */ { 0, 0, 0, 0, 0 },
/* U+22fc */ { 0, 0, 0, 0, 0 },
/* U+22fd */ { 0, 0, 0, 0, 0 },
/* U+22fe */ { 0, 0, 0, 0, 0 },
/* U+22ff */ { 0, 0, 0, 0, 0 },
/* U+2300 */ { 30, 0, 19, 0, 0 },
/* U+2301 */ { 30, 0, 19, 0, 0 },
/* U+2302 */ { 30, 0, 19, 0, 0 },
/* U+2303 */ { 30, 0, 19, 0, 0 },
/* U+2304 */ { 30, 0, 19, 0, 0 },
/* U+2305 */ { 30, 0, 19, 0, 0 },
/* U+2306 */ { 30, 0, 19, 0, 0 },
/* U+2307 */ { 30, 0, 19, 0, 0 },
/* U+2308 */ { 27, 0, 19, 1, 0 },
/* U+2309 */ { 27, 0, 19, 1, 0 },
/* U+230a */ { 27, 0, 19, 1, 0 },
/* U+230b */ { 27, 0, 19, 1, 0 },
/* U+230c */ { 30, 0, 19, 0, 0 },
/* U+230d */ { 30, 0, 19, 0, 0 },
/* U+230e */ { 30, 0, 19, 0, 0 },
/* U+230f */ { 30, 0, 19, 0, 0 },
/* U+2310 */ { 30, 0, 19, 0, 0 },
/* U+2311 */ { 30, 0, 19, 0, 0 },
/* U+2312 */ { 30, 0, 19, 0, 0 },
/* U+2313 */ { 30, 0, 19, 0, 0 },
/* U+2314 */ { 30, 0, 19, 0, 0 },
/* U+2315 */ { 30, 0, 19, 0, 0 },
/* U+2316 */ { 30, 0, 19, 0, 0 },
/* U+2317 */ { 30, 0, 19, 0, 0 },
/* U+2318 */ { 30, 0, 19, 0, 0 },
/* U+2319 */ { 30, 0, 19, 0, 0 },
/* U+231a */ { 30, 0, 19, 0, 0 },
/* U+231b */ { 30, 0, 19, 0, 0 },
/* U+231c */ { 30, 0, 19, 0, 0 },
/* U+231d */ { 30, 0, 19, 0, 0 },
/* U+231e */ { 30, 0, 19, 0, 0 },
/* U+231f */ { 30, 0, 19, 0, 0 },
/* U+2320 */ { 27, 0, 19, 1, 0 },
/* U+2321 */ { 27, 0, 19, 1, 0 },
/* U+2322 */ { 30, 0, 19, 0, 0 },
/* U+2323 */ { 30, 0, 19, 0, 0 },
/* U+2324 */ { 30, 0, 19, 0, 0 },
/* U+2325 */ { 30, 0, 19, 0, 0 },
/* U+2326 */ { 30, 0, 19, 0, 0 },
/* U+2327 */ { 30, 0, 19, 0, 0 },
/* U+2328 */ { 30, 0, 19, 0, 0 },
/* U+2329 */ { 22, 0, 19, 1, "3008" },
/* U+232a */ { 23, 0, 19, 1, "3009" },
/* U+232b */ { 30, 0, 19, 0, 0 },
/* U+232c */ { 30, 0, 19, 0, 0 },
/* U+232d */ { 30, 0, 19, 0, 0 },
/* U+232e */ { 30, 0, 19, 0, 0 },
/* U+232f */ { 30, 0, 19, 0, 0 },
/* U+2330 */ { 30, 0, 19, 0, 0 },
/* U+2331 */ { 30, 0, 19, 0, 0 },
/* U+2332 */ { 30, 0, 19, 0, 0 },
/* U+2333 */ { 30, 0, 19, 0, 0 },
/* U+2334 */ { 30, 0, 19, 0, 0 },
/* U+2335 */ { 30, 0, 19, 0, 0 },
/* U+2336 */ { 30, 0, 1, 0, 0 },
/* U+2337 */ { 30, 0, 1, 0, 0 },
/* U+2338 */ { 30, 0, 1, 0, 0 },
/* U+2339 */ { 30, 0, 1, 0, 0 },
/* U+233a */ { 30, 0, 1, 0, 0 },
/* U+233b */ { 30, 0, 1, 0, 0 },
/* U+233c */ { 30, 0, 1, 0, 0 },
/* U+233d */ { 30, 0, 1, 0, 0 },
/* U+233e */ { 30, 0, 1, 0, 0 },
/* U+233f */ { 30, 0, 1, 0, 0 },
/* U+2340 */ { 30, 0, 1, 0, 0 },
/* U+2341 */ { 30, 0, 1, 0, 0 },
/* U+2342 */ { 30, 0, 1, 0, 0 },
/* U+2343 */ { 30, 0, 1, 0, 0 },
/* U+2344 */ { 30, 0, 1, 0, 0 },
/* U+2345 */ { 30, 0, 1, 0, 0 },
/* U+2346 */ { 30, 0, 1, 0, 0 },
/* U+2347 */ { 30, 0, 1, 0, 0 },
/* U+2348 */ { 30, 0, 1, 0, 0 },
/* U+2349 */ { 30, 0, 1, 0, 0 },
/* U+234a */ { 30, 0, 1, 0, 0 },
/* U+234b */ { 30, 0, 1, 0, 0 },
/* U+234c */ { 30, 0, 1, 0, 0 },
/* U+234d */ { 30, 0, 1, 0, 0 },
/* U+234e */ { 30, 0, 1, 0, 0 },
/* U+234f */ { 30, 0, 1, 0, 0 },
/* U+2350 */ { 30, 0, 1, 0, 0 },
/* U+2351 */ { 30, 0, 1, 0, 0 },
/* U+2352 */ { 30, 0, 1, 0, 0 },
/* U+2353 */ { 30, 0, 1, 0, 0 },
/* U+2354 */ { 30, 0, 1, 0, 0 },
/* U+2355 */ { 30, 0, 1, 0, 0 },
/* U+2356 */ { 30, 0, 1, 0, 0 },
/* U+2357 */ { 30, 0, 1, 0, 0 },
/* U+2358 */ { 30, 0, 1, 0, 0 },
/* U+2359 */ { 30, 0, 1, 0, 0 },
/* U+235a */ { 30, 0, 1, 0, 0 },
/* U+235b */ { 30, 0, 1, 0, 0 },
/* U+235c */ { 30, 0, 1, 0, 0 },
/* U+235d */ { 30, 0, 1, 0, 0 },
/* U+235e */ { 30, 0, 1, 0, 0 },
/* U+235f */ { 30, 0, 1, 0, 0 },
/* U+2360 */ { 30, 0, 1, 0, 0 },
/* U+2361 */ { 30, 0, 1, 0, 0 },
/* U+2362 */ { 30, 0, 1, 0, 0 },
/* U+2363 */ { 30, 0, 1, 0, 0 },
/* U+2364 */ { 30, 0, 1, 0, 0 },
/* U+2365 */ { 30, 0, 1, 0, 0 },
/* U+2366 */ { 30, 0, 1, 0, 0 },
/* U+2367 */ { 30, 0, 1, 0, 0 },
/* U+2368 */ { 30, 0, 1, 0, 0 },
/* U+2369 */ { 30, 0, 1, 0, 0 },
/* U+236a */ { 30, 0, 1, 0, 0 },
/* U+236b */ { 30, 0, 1, 0, 0 },
/* U+236c */ { 30, 0, 1, 0, 0 },
/* U+236d */ { 30, 0, 1, 0, 0 },
/* U+236e */ { 30, 0, 1, 0, 0 },
/* U+236f */ { 30, 0, 1, 0, 0 },
/* U+2370 */ { 30, 0, 1, 0, 0 },
/* U+2371 */ { 30, 0, 1, 0, 0 },
/* U+2372 */ { 30, 0, 1, 0, 0 },
/* U+2373 */ { 30, 0, 1, 0, 0 },
/* U+2374 */ { 30, 0, 1, 0, 0 },
/* U+2375 */ { 30, 0, 1, 0, 0 },
/* U+2376 */ { 30, 0, 1, 0, 0 },
/* U+2377 */ { 30, 0, 1, 0, 0 },
/* U+2378 */ { 30, 0, 1, 0, 0 },
/* U+2379 */ { 30, 0, 1, 0, 0 },
/* U+237a */ { 30, 0, 1, 0, 0 },
/* U+237b */ { 30, 0, 19, 0, 0 },
/* U+237c */ { 0, 0, 0, 0, 0 },
/* U+237d */ { 30, 0, 19, 0, 0 },
/* U+237e */ { 30, 0, 19, 0, 0 },
/* U+237f */ { 30, 0, 19, 0, 0 },
/* U+2380 */ { 30, 0, 19, 0, 0 },
/* U+2381 */ { 30, 0, 19, 0, 0 },
/* U+2382 */ { 30, 0, 19, 0, 0 },
/* U+2383 */ { 30, 0, 19, 0, 0 },
/* U+2384 */ { 30, 0, 19, 0, 0 },
/* U+2385 */ { 30, 0, 19, 0, 0 },
/* U+2386 */ { 30, 0, 19, 0, 0 },
/* U+2387 */ { 30, 0, 19, 0, 0 },
/* U+2388 */ { 30, 0, 19, 0, 0 },
/* U+2389 */ { 30, 0, 19, 0, 0 },
/* U+238a */ { 30, 0, 19, 0, 0 },
/* U+238b */ { 30, 0, 19, 0, 0 },
/* U+238c */ { 30, 0, 19, 0, 0 },
/* U+238d */ { 30, 0, 19, 0, 0 },
/* U+238e */ { 30, 0, 19, 0, 0 },
/* U+238f */ { 30, 0, 19, 0, 0 },
/* U+2390 */ { 30, 0, 19, 0, 0 },
/* U+2391 */ { 30, 0, 19, 0, 0 },
/* U+2392 */ { 30, 0, 19, 0, 0 },
/* U+2393 */ { 30, 0, 19, 0, 0 },
/* U+2394 */ { 30, 0, 19, 0, 0 },
/* U+2395 */ { 30, 0, 1, 0, 0 },
/* U+2396 */ { 30, 0, 19, 0, 0 },
/* U+2397 */ { 30, 0, 19, 0, 0 },
/* U+2398 */ { 30, 0, 19, 0, 0 },
/* U+2399 */ { 30, 0, 19, 0, 0 },
/* U+239a */ { 30, 0, 19, 0, 0 },
/* U+239b */ { 0, 0, 0, 0, 0 },
/* U+239c */ { 0, 0, 0, 0, 0 },
/* U+239d */ { 0, 0, 0, 0, 0 },
/* U+239e */ { 0, 0, 0, 0, 0 },
/* U+239f */ { 0, 0, 0, 0, 0 },
/* U+23a0 */ { 0, 0, 0, 0, 0 },
/* U+23a1 */ { 0, 0, 0, 0, 0 },
/* U+23a2 */ { 0, 0, 0, 0, 0 },
/* U+23a3 */ { 0, 0, 0, 0, 0 },
/* U+23a4 */ { 0, 0, 0, 0, 0 },
/* U+23a5 */ { 0, 0, 0, 0, 0 },
/* U+23a6 */ { 0, 0, 0, 0, 0 },
/* U+23a7 */ { 0, 0, 0, 0, 0 },
/* U+23a8 */ { 0, 0, 0, 0, 0 },
/* U+23a9 */ { 0, 0, 0, 0, 0 },
/* U+23aa */ { 0, 0, 0, 0, 0 },
/* U+23ab */ { 0, 0, 0, 0, 0 },
/* U+23ac */ { 0, 0, 0, 0, 0 },
/* U+23ad */ { 0, 0, 0, 0, 0 },
/* U+23ae */ { 0, 0, 0, 0, 0 },
/* U+23af */ { 0, 0, 0, 0, 0 },
/* U+23b0 */ { 0, 0, 0, 0, 0 },
/* U+23b1 */ { 0, 0, 0, 0, 0 },
/* U+23b2 */ { 0, 0, 0, 0, 0 },
/* U+23b3 */ { 0, 0, 0, 0, 0 },
/* U+23b4 */ { 0, 0, 0, 0, 0 },
/* U+23b5 */ { 0, 0, 0, 0, 0 },
/* U+23b6 */ { 0, 0, 0, 0, 0 },
/* U+23b7 */ { 0, 0, 0, 0, 0 },
/* U+23b8 */ { 0, 0, 0, 0, 0 },
/* U+23b9 */ { 0, 0, 0, 0, 0 },
/* U+23ba */ { 0, 0, 0, 0, 0 },
/* U+23bb */ { 0, 0, 0, 0, 0 },
/* U+23bc */ { 0, 0, 0, 0, 0 },
/* U+23bd */ { 0, 0, 0, 0, 0 },
/* U+23be */ { 0, 0, 0, 0, 0 },
/* U+23bf */ { 0, 0, 0, 0, 0 },
/* U+23c0 */ { 0, 0, 0, 0, 0 },
/* U+23c1 */ { 0, 0, 0, 0, 0 },
/* U+23c2 */ { 0, 0, 0, 0, 0 },
/* U+23c3 */ { 0, 0, 0, 0, 0 },
/* U+23c4 */ { 0, 0, 0, 0, 0 },
/* U+23c5 */ { 0, 0, 0, 0, 0 },
/* U+23c6 */ { 0, 0, 0, 0, 0 },
/* U+23c7 */ { 0, 0, 0, 0, 0 },
/* U+23c8 */ { 0, 0, 0, 0, 0 },
/* U+23c9 */ { 0, 0, 0, 0, 0 },
/* U+23ca */ { 0, 0, 0, 0, 0 },
/* U+23cb */ { 0, 0, 0, 0, 0 },
/* U+23cc */ { 0, 0, 0, 0, 0 },
/* U+23cd */ { 0, 0, 0, 0, 0 },
/* U+23ce */ { 0, 0, 0, 0, 0 },
/* U+23cf */ { 0, 0, 0, 0, 0 },
/* U+23d0 */ { 0, 0, 0, 0, 0 },
/* U+23d1 */ { 0, 0, 0, 0, 0 },
/* U+23d2 */ { 0, 0, 0, 0, 0 },
/* U+23d3 */ { 0, 0, 0, 0, 0 },
/* U+23d4 */ { 0, 0, 0, 0, 0 },
/* U+23d5 */ { 0, 0, 0, 0, 0 },
/* U+23d6 */ { 0, 0, 0, 0, 0 },
/* U+23d7 */ { 0, 0, 0, 0, 0 },
/* U+23d8 */ { 0, 0, 0, 0, 0 },
/* U+23d9 */ { 0, 0, 0, 0, 0 },
/* U+23da */ { 0, 0, 0, 0, 0 },
/* U+23db */ { 0, 0, 0, 0, 0 },
/* U+23dc */ { 0, 0, 0, 0, 0 },
/* U+23dd */ { 0, 0, 0, 0, 0 },
/* U+23de */ { 0, 0, 0, 0, 0 },
/* U+23df */ { 0, 0, 0, 0, 0 },
/* U+23e0 */ { 0, 0, 0, 0, 0 },
/* U+23e1 */ { 0, 0, 0, 0, 0 },
/* U+23e2 */ { 0, 0, 0, 0, 0 },
/* U+23e3 */ { 0, 0, 0, 0, 0 },
/* U+23e4 */ { 0, 0, 0, 0, 0 },
/* U+23e5 */ { 0, 0, 0, 0, 0 },
/* U+23e6 */ { 0, 0, 0, 0, 0 },
/* U+23e7 */ { 0, 0, 0, 0, 0 },
/* U+23e8 */ { 0, 0, 0, 0, 0 },
/* U+23e9 */ { 0, 0, 0, 0, 0 },
/* U+23ea */ { 0, 0, 0, 0, 0 },
/* U+23eb */ { 0, 0, 0, 0, 0 },
/* U+23ec */ { 0, 0, 0, 0, 0 },
/* U+23ed */ { 0, 0, 0, 0, 0 },
/* U+23ee */ { 0, 0, 0, 0, 0 },
/* U+23ef */ { 0, 0, 0, 0, 0 },
/* U+23f0 */ { 0, 0, 0, 0, 0 },
/* U+23f1 */ { 0, 0, 0, 0, 0 },
/* U+23f2 */ { 0, 0, 0, 0, 0 },
/* U+23f3 */ { 0, 0, 0, 0, 0 },
/* U+23f4 */ { 0, 0, 0, 0, 0 },
/* U+23f5 */ { 0, 0, 0, 0, 0 },
/* U+23f6 */ { 0, 0, 0, 0, 0 },
/* U+23f7 */ { 0, 0, 0, 0, 0 },
/* U+23f8 */ { 0, 0, 0, 0, 0 },
/* U+23f9 */ { 0, 0, 0, 0, 0 },
/* U+23fa */ { 0, 0, 0, 0, 0 },
/* U+23fb */ { 0, 0, 0, 0, 0 },
/* U+23fc */ { 0, 0, 0, 0, 0 },
/* U+23fd */ { 0, 0, 0, 0, 0 },
/* U+23fe */ { 0, 0, 0, 0, 0 },
/* U+23ff */ { 0, 0, 0, 0, 0 },
/* U+2400 */ { 30, 0, 19, 0, 0 },
/* U+2401 */ { 30, 0, 19, 0, 0 },
/* U+2402 */ { 30, 0, 19, 0, 0 },
/* U+2403 */ { 30, 0, 19, 0, 0 },
/* U+2404 */ { 30, 0, 19, 0, 0 },
/* U+2405 */ { 30, 0, 19, 0, 0 },
/* U+2406 */ { 30, 0, 19, 0, 0 },
/* U+2407 */ { 30, 0, 19, 0, 0 },
/* U+2408 */ { 30, 0, 19, 0, 0 },
/* U+2409 */ { 30, 0, 19, 0, 0 },
/* U+240a */ { 30, 0, 19, 0, 0 },
/* U+240b */ { 30, 0, 19, 0, 0 },
/* U+240c */ { 30, 0, 19, 0, 0 },
/* U+240d */ { 30, 0, 19, 0, 0 },
/* U+240e */ { 30, 0, 19, 0, 0 },
/* U+240f */ { 30, 0, 19, 0, 0 },
/* U+2410 */ { 30, 0, 19, 0, 0 },
/* U+2411 */ { 30, 0, 19, 0, 0 },
/* U+2412 */ { 30, 0, 19, 0, 0 },
/* U+2413 */ { 30, 0, 19, 0, 0 },
/* U+2414 */ { 30, 0, 19, 0, 0 },
/* U+2415 */ { 30, 0, 19, 0, 0 },
/* U+2416 */ { 30, 0, 19, 0, 0 },
/* U+2417 */ { 30, 0, 19, 0, 0 },
/* U+2418 */ { 30, 0, 19, 0, 0 },
/* U+2419 */ { 30, 0, 19, 0, 0 },
/* U+241a */ { 30, 0, 19, 0, 0 },
/* U+241b */ { 30, 0, 19, 0, 0 },
/* U+241c */ { 30, 0, 19, 0, 0 },
/* U+241d */ { 30, 0, 19, 0, 0 },
/* U+241e */ { 30, 0, 19, 0, 0 },
/* U+241f */ { 30, 0, 19, 0, 0 },
/* U+2420 */ { 30, 0, 19, 0, 0 },
/* U+2421 */ { 30, 0, 19, 0, 0 },
/* U+2422 */ { 30, 0, 19, 0, 0 },
/* U+2423 */ { 30, 0, 19, 0, 0 },
/* U+2424 */ { 30, 0, 19, 0, 0 },
/* U+2425 */ { 30, 0, 19, 0, 0 },
/* U+2426 */ { 30, 0, 19, 0, 0 },
/* U+2427 */ { 0, 0, 0, 0, 0 },
/* U+2428 */ { 0, 0, 0, 0, 0 },
/* U+2429 */ { 0, 0, 0, 0, 0 },
/* U+242a */ { 0, 0, 0, 0, 0 },
/* U+242b */ { 0, 0, 0, 0, 0 },
/* U+242c */ { 0, 0, 0, 0, 0 },
/* U+242d */ { 0, 0, 0, 0, 0 },
/* U+242e */ { 0, 0, 0, 0, 0 },
/* U+242f */ { 0, 0, 0, 0, 0 },
/* U+2430 */ { 0, 0, 0, 0, 0 },
/* U+2431 */ { 0, 0, 0, 0, 0 },
/* U+2432 */ { 0, 0, 0, 0, 0 },
/* U+2433 */ { 0, 0, 0, 0, 0 },
/* U+2434 */ { 0, 0, 0, 0, 0 },
/* U+2435 */ { 0, 0, 0, 0, 0 },
/* U+2436 */ { 0, 0, 0, 0, 0 },
/* U+2437 */ { 0, 0, 0, 0, 0 },
/* U+2438 */ { 0, 0, 0, 0, 0 },
/* U+2439 */ { 0, 0, 0, 0, 0 },
/* U+243a */ { 0, 0, 0, 0, 0 },
/* U+243b */ { 0, 0, 0, 0, 0 },
/* U+243c */ { 0, 0, 0, 0, 0 },
/* U+243d */ { 0, 0, 0, 0, 0 },
/* U+243e */ { 0, 0, 0, 0, 0 },
/* U+243f */ { 0, 0, 0, 0, 0 },
/* U+2440 */ { 30, 0, 19, 0, 0 },
/* U+2441 */ { 30, 0, 19, 0, 0 },
/* U+2442 */ { 30, 0, 19, 0, 0 },
/* U+2443 */ { 30, 0, 19, 0, 0 },
/* U+2444 */ { 30, 0, 19, 0, 0 },
/* U+2445 */ { 30, 0, 19, 0, 0 },
/* U+2446 */ { 30, 0, 19, 0, 0 },
/* U+2447 */ { 30, 0, 19, 0, 0 },
/* U+2448 */ { 30, 0, 19, 0, 0 },
/* U+2449 */ { 30, 0, 19, 0, 0 },
/* U+244a */ { 30, 0, 19, 0, 0 },
/* U+244b */ { 0, 0, 0, 0, 0 },
/* U+244c */ { 0, 0, 0, 0, 0 },
/* U+244d */ { 0, 0, 0, 0, 0 },
/* U+244e */ { 0, 0, 0, 0, 0 },
/* U+244f */ { 0, 0, 0, 0, 0 },
/* U+2450 */ { 0, 0, 0, 0, 0 },
/* U+2451 */ { 0, 0, 0, 0, 0 },
/* U+2452 */ { 0, 0, 0, 0, 0 },
/* U+2453 */ { 0, 0, 0, 0, 0 },
/* U+2454 */ { 0, 0, 0, 0, 0 },
/* U+2455 */ { 0, 0, 0, 0, 0 },
/* U+2456 */ { 0, 0, 0, 0, 0 },
/* U+2457 */ { 0, 0, 0, 0, 0 },
/* U+2458 */ { 0, 0, 0, 0, 0 },
/* U+2459 */ { 0, 0, 0, 0, 0 },
/* U+245a */ { 0, 0, 0, 0, 0 },
/* U+245b */ { 0, 0, 0, 0, 0 },
/* U+245c */ { 0, 0, 0, 0, 0 },
/* U+245d */ { 0, 0, 0, 0, 0 },
/* U+245e */ { 0, 0, 0, 0, 0 },
/* U+245f */ { 0, 0, 0, 0, 0 },
/* U+2460 */ { 9, 0, 9, 0, "<circle> 0031" },
/* U+2461 */ { 9, 0, 9, 0, "<circle> 0032" },
/* U+2462 */ { 9, 0, 9, 0, "<circle> 0033" },
/* U+2463 */ { 9, 0, 9, 0, "<circle> 0034" },
/* U+2464 */ { 9, 0, 9, 0, "<circle> 0035" },
/* U+2465 */ { 9, 0, 9, 0, "<circle> 0036" },
/* U+2466 */ { 9, 0, 9, 0, "<circle> 0037" },
/* U+2467 */ { 9, 0, 9, 0, "<circle> 0038" },
/* U+2468 */ { 9, 0, 9, 0, "<circle> 0039" },
/* U+2469 */ { 9, 0, 9, 0, "<circle> 0031 0030" },
/* U+246a */ { 9, 0, 9, 0, "<circle> 0031 0031" },
/* U+246b */ { 9, 0, 9, 0, "<circle> 0031 0032" },
/* U+246c */ { 9, 0, 9, 0, "<circle> 0031 0033" },
/* U+246d */ { 9, 0, 9, 0, "<circle> 0031 0034" },
/* U+246e */ { 9, 0, 9, 0, "<circle> 0031 0035" },
/* U+246f */ { 9, 0, 9, 0, "<circle> 0031 0036" },
/* U+2470 */ { 9, 0, 9, 0, "<circle> 0031 0037" },
/* U+2471 */ { 9, 0, 9, 0, "<circle> 0031 0038" },
/* U+2472 */ { 9, 0, 9, 0, "<circle> 0031 0039" },
/* U+2473 */ { 9, 0, 9, 0, "<circle> 0032 0030" },
/* U+2474 */ { 9, 0, 9, 0, "<compat> 0028 0031 0029" },
/* U+2475 */ { 9, 0, 9, 0, "<compat> 0028 0032 0029" },
/* U+2476 */ { 9, 0, 9, 0, "<compat> 0028 0033 0029" },
/* U+2477 */ { 9, 0, 9, 0, "<compat> 0028 0034 0029" },
/* U+2478 */ { 9, 0, 9, 0, "<compat> 0028 0035 0029" },
/* U+2479 */ { 9, 0, 9, 0, "<compat> 0028 0036 0029" },
/* U+247a */ { 9, 0, 9, 0, "<compat> 0028 0037 0029" },
/* U+247b */ { 9, 0, 9, 0, "<compat> 0028 0038 0029" },
/* U+247c */ { 9, 0, 9, 0, "<compat> 0028 0039 0029" },
/* U+247d */ { 9, 0, 9, 0, "<compat> 0028 0031 0030 0029" },
/* U+247e */ { 9, 0, 9, 0, "<compat> 0028 0031 0031 0029" },
/* U+247f */ { 9, 0, 9, 0, "<compat> 0028 0031 0032 0029" },
/* U+2480 */ { 9, 0, 9, 0, "<compat> 0028 0031 0033 0029" },
/* U+2481 */ { 9, 0, 9, 0, "<compat> 0028 0031 0034 0029" },
/* U+2482 */ { 9, 0, 9, 0, "<compat> 0028 0031 0035 0029" },
/* U+2483 */ { 9, 0, 9, 0, "<compat> 0028 0031 0036 0029" },
/* U+2484 */ { 9, 0, 9, 0, "<compat> 0028 0031 0037 0029" },
/* U+2485 */ { 9, 0, 9, 0, "<compat> 0028 0031 0038 0029" },
/* U+2486 */ { 9, 0, 9, 0, "<compat> 0028 0031 0039 0029" },
/* U+2487 */ { 9, 0, 9, 0, "<compat> 0028 0032 0030 0029" },
/* U+2488 */ { 9, 0, 9, 0, "<compat> 0031 002E" },
/* U+2489 */ { 9, 0, 9, 0, "<compat> 0032 002E" },
/* U+248a */ { 9, 0, 9, 0, "<compat> 0033 002E" },
/* U+248b */ { 9, 0, 9, 0, "<compat> 0034 002E" },
/* U+248c */ { 9, 0, 9, 0, "<compat> 0035 002E" },
/* U+248d */ { 9, 0, 9, 0, "<compat> 0036 002E" },
/* U+248e */ { 9, 0, 9, 0, "<compat> 0037 002E" },
/* U+248f */ { 9, 0, 9, 0, "<compat> 0038 002E" },
/* U+2490 */ { 9, 0, 9, 0, "<compat> 0039 002E" },
/* U+2491 */ { 9, 0, 9, 0, "<compat> 0031 0030 002E" },
/* U+2492 */ { 9, 0, 9, 0, "<compat> 0031 0031 002E" },
/* U+2493 */ { 9, 0, 9, 0, "<compat> 0031 0032 002E" },
/* U+2494 */ { 9, 0, 9, 0, "<compat> 0031 0033 002E" },
/* U+2495 */ { 9, 0, 9, 0, "<compat> 0031 0034 002E" },
/* U+2496 */ { 9, 0, 9, 0, "<compat> 0031 0035 002E" },
/* U+2497 */ { 9, 0, 9, 0, "<compat> 0031 0036 002E" },
/* U+2498 */ { 9, 0, 9, 0, "<compat> 0031 0037 002E" },
/* U+2499 */ { 9, 0, 9, 0, "<compat> 0031 0038 002E" },
/* U+249a */ { 9, 0, 9, 0, "<compat> 0031 0039 002E" },
/* U+249b */ { 9, 0, 9, 0, "<compat> 0032 0030 002E" },
/* U+249c */ { 30, 0, 1, 0, "<compat> 0028 0061 0029" },
/* U+249d */ { 30, 0, 1, 0, "<compat> 0028 0062 0029" },
/* U+249e */ { 30, 0, 1, 0, "<compat> 0028 0063 0029" },
/* U+249f */ { 30, 0, 1, 0, "<compat> 0028 0064 0029" },
/* U+24a0 */ { 30, 0, 1, 0, "<compat> 0028 0065 0029" },
/* U+24a1 */ { 30, 0, 1, 0, "<compat> 0028 0066 0029" },
/* U+24a2 */ { 30, 0, 1, 0, "<compat> 0028 0067 0029" },
/* U+24a3 */ { 30, 0, 1, 0, "<compat> 0028 0068 0029" },
/* U+24a4 */ { 30, 0, 1, 0, "<compat> 0028 0069 0029" },
/* U+24a5 */ { 30, 0, 1, 0, "<compat> 0028 006A 0029" },
/* U+24a6 */ { 30, 0, 1, 0, "<compat> 0028 006B 0029" },
/* U+24a7 */ { 30, 0, 1, 0, "<compat> 0028 006C 0029" },
/* U+24a8 */ { 30, 0, 1, 0, "<compat> 0028 006D 0029" },
/* U+24a9 */ { 30, 0, 1, 0, "<compat> 0028 006E 0029" },
/* U+24aa */ { 30, 0, 1, 0, "<compat> 0028 006F 0029" },
/* U+24ab */ { 30, 0, 1, 0, "<compat> 0028 0070 0029" },
/* U+24ac */ { 30, 0, 1, 0, "<compat> 0028 0071 0029" },
/* U+24ad */ { 30, 0, 1, 0, "<compat> 0028 0072 0029" },
/* U+24ae */ { 30, 0, 1, 0, "<compat> 0028 0073 0029" },
/* U+24af */ { 30, 0, 1, 0, "<compat> 0028 0074 0029" },
/* U+24b0 */ { 30, 0, 1, 0, "<compat> 0028 0075 0029" },
/* U+24b1 */ { 30, 0, 1, 0, "<compat> 0028 0076 0029" },
/* U+24b2 */ { 30, 0, 1, 0, "<compat> 0028 0077 0029" },
/* U+24b3 */ { 30, 0, 1, 0, "<compat> 0028 0078 0029" },
/* U+24b4 */ { 30, 0, 1, 0, "<compat> 0028 0079 0029" },
/* U+24b5 */ { 30, 0, 1, 0, "<compat> 0028 007A 0029" },
/* U+24b6 */ { 30, 0, 1, 0, "<circle> 0041" },
/* U+24b7 */ { 30, 0, 1, 0, "<circle> 0042" },
/* U+24b8 */ { 30, 0, 1, 0, "<circle> 0043" },
/* U+24b9 */ { 30, 0, 1, 0, "<circle> 0044" },
/* U+24ba */ { 30, 0, 1, 0, "<circle> 0045" },
/* U+24bb */ { 30, 0, 1, 0, "<circle> 0046" },
/* U+24bc */ { 30, 0, 1, 0, "<circle> 0047" },
/* U+24bd */ { 30, 0, 1, 0, "<circle> 0048" },
/* U+24be */ { 30, 0, 1, 0, "<circle> 0049" },
/* U+24bf */ { 30, 0, 1, 0, "<circle> 004A" },
/* U+24c0 */ { 30, 0, 1, 0, "<circle> 004B" },
/* U+24c1 */ { 30, 0, 1, 0, "<circle> 004C" },
/* U+24c2 */ { 30, 0, 1, 0, "<circle> 004D" },
/* U+24c3 */ { 30, 0, 1, 0, "<circle> 004E" },
/* U+24c4 */ { 30, 0, 1, 0, "<circle> 004F" },
/* U+24c5 */ { 30, 0, 1, 0, "<circle> 0050" },
/* U+24c6 */ { 30, 0, 1, 0, "<circle> 0051" },
/* U+24c7 */ { 30, 0, 1, 0, "<circle> 0052" },
/* U+24c8 */ { 30, 0, 1, 0, "<circle> 0053" },
/* U+24c9 */ { 30, 0, 1, 0, "<circle> 0054" },
/* U+24ca */ { 30, 0, 1, 0, "<circle> 0055" },
/* U+24cb */ { 30, 0, 1, 0, "<circle> 0056" },
/* U+24cc */ { 30, 0, 1, 0, "<circle> 0057" },
/* U+24cd */ { 30, 0, 1, 0, "<circle> 0058" },
/* U+24ce */ { 30, 0, 1, 0, "<circle> 0059" },
/* U+24cf */ { 30, 0, 1, 0, "<circle> 005A" },
/* U+24d0 */ { 30, 0, 1, 0, "<circle> 0061" },
/* U+24d1 */ { 30, 0, 1, 0, "<circle> 0062" },
/* U+24d2 */ { 30, 0, 1, 0, "<circle> 0063" },
/* U+24d3 */ { 30, 0, 1, 0, "<circle> 0064" },
/* U+24d4 */ { 30, 0, 1, 0, "<circle> 0065" },
/* U+24d5 */ { 30, 0, 1, 0, "<circle> 0066" },
/* U+24d6 */ { 30, 0, 1, 0, "<circle> 0067" },
/* U+24d7 */ { 30, 0, 1, 0, "<circle> 0068" },
/* U+24d8 */ { 30, 0, 1, 0, "<circle> 0069" },
/* U+24d9 */ { 30, 0, 1, 0, "<circle> 006A" },
/* U+24da */ { 30, 0, 1, 0, "<circle> 006B" },
/* U+24db */ { 30, 0, 1, 0, "<circle> 006C" },
/* U+24dc */ { 30, 0, 1, 0, "<circle> 006D" },
/* U+24dd */ { 30, 0, 1, 0, "<circle> 006E" },
/* U+24de */ { 30, 0, 1, 0, "<circle> 006F" },
/* U+24df */ { 30, 0, 1, 0, "<circle> 0070" },
/* U+24e0 */ { 30, 0, 1, 0, "<circle> 0071" },
/* U+24e1 */ { 30, 0, 1, 0, "<circle> 0072" },
/* U+24e2 */ { 30, 0, 1, 0, "<circle> 0073" },
/* U+24e3 */ { 30, 0, 1, 0, "<circle> 0074" },
/* U+24e4 */ { 30, 0, 1, 0, "<circle> 0075" },
/* U+24e5 */ { 30, 0, 1, 0, "<circle> 0076" },
/* U+24e6 */ { 30, 0, 1, 0, "<circle> 0077" },
/* U+24e7 */ { 30, 0, 1, 0, "<circle> 0078" },
/* U+24e8 */ { 30, 0, 1, 0, "<circle> 0079" },
/* U+24e9 */ { 30, 0, 1, 0, "<circle> 007A" },
/* U+24ea */ { 9, 0, 9, 0, "<circle> 0030" },
/* U+24eb */ { 0, 0, 0, 0, 0 },
/* U+24ec */ { 0, 0, 0, 0, 0 },
/* U+24ed */ { 0, 0, 0, 0, 0 },
/* U+24ee */ { 0, 0, 0, 0, 0 },
/* U+24ef */ { 0, 0, 0, 0, 0 },
/* U+24f0 */ { 0, 0, 0, 0, 0 },
/* U+24f1 */ { 0, 0, 0, 0, 0 },
/* U+24f2 */ { 0, 0, 0, 0, 0 },
/* U+24f3 */ { 0, 0, 0, 0, 0 },
/* U+24f4 */ { 0, 0, 0, 0, 0 },
/* U+24f5 */ { 0, 0, 0, 0, 0 },
/* U+24f6 */ { 0, 0, 0, 0, 0 },
/* U+24f7 */ { 0, 0, 0, 0, 0 },
/* U+24f8 */ { 0, 0, 0, 0, 0 },
/* U+24f9 */ { 0, 0, 0, 0, 0 },
/* U+24fa */ { 0, 0, 0, 0, 0 },
/* U+24fb */ { 0, 0, 0, 0, 0 },
/* U+24fc */ { 0, 0, 0, 0, 0 },
/* U+24fd */ { 0, 0, 0, 0, 0 },
/* U+24fe */ { 0, 0, 0, 0, 0 },
/* U+24ff */ { 0, 0, 0, 0, 0 },
/* U+2500 */ { 30, 0, 19, 0, 0 },
/* U+2501 */ { 30, 0, 19, 0, 0 },
/* U+2502 */ { 30, 0, 19, 0, 0 },
/* U+2503 */ { 30, 0, 19, 0, 0 },
/* U+2504 */ { 30, 0, 19, 0, 0 },
/* U+2505 */ { 30, 0, 19, 0, 0 },
/* U+2506 */ { 30, 0, 19, 0, 0 },
/* U+2507 */ { 30, 0, 19, 0, 0 },
/* U+2508 */ { 30, 0, 19, 0, 0 },
/* U+2509 */ { 30, 0, 19, 0, 0 },
/* U+250a */ { 30, 0, 19, 0, 0 },
/* U+250b */ { 30, 0, 19, 0, 0 },
/* U+250c */ { 30, 0, 19, 0, 0 },
/* U+250d */ { 30, 0, 19, 0, 0 },
/* U+250e */ { 30, 0, 19, 0, 0 },
/* U+250f */ { 30, 0, 19, 0, 0 },
/* U+2510 */ { 30, 0, 19, 0, 0 },
/* U+2511 */ { 30, 0, 19, 0, 0 },
/* U+2512 */ { 30, 0, 19, 0, 0 },
/* U+2513 */ { 30, 0, 19, 0, 0 },
/* U+2514 */ { 30, 0, 19, 0, 0 },
/* U+2515 */ { 30, 0, 19, 0, 0 },
/* U+2516 */ { 30, 0, 19, 0, 0 },
/* U+2517 */ { 30, 0, 19, 0, 0 },
/* U+2518 */ { 30, 0, 19, 0, 0 },
/* U+2519 */ { 30, 0, 19, 0, 0 },
/* U+251a */ { 30, 0, 19, 0, 0 },
/* U+251b */ { 30, 0, 19, 0, 0 },
/* U+251c */ { 30, 0, 19, 0, 0 },
/* U+251d */ { 30, 0, 19, 0, 0 },
/* U+251e */ { 30, 0, 19, 0, 0 },
/* U+251f */ { 30, 0, 19, 0, 0 },
/* U+2520 */ { 30, 0, 19, 0, 0 },
/* U+2521 */ { 30, 0, 19, 0, 0 },
/* U+2522 */ { 30, 0, 19, 0, 0 },
/* U+2523 */ { 30, 0, 19, 0, 0 },
/* U+2524 */ { 30, 0, 19, 0, 0 },
/* U+2525 */ { 30, 0, 19, 0, 0 },
/* U+2526 */ { 30, 0, 19, 0, 0 },
/* U+2527 */ { 30, 0, 19, 0, 0 },
/* U+2528 */ { 30, 0, 19, 0, 0 },
/* U+2529 */ { 30, 0, 19, 0, 0 },
/* U+252a */ { 30, 0, 19, 0, 0 },
/* U+252b */ { 30, 0, 19, 0, 0 },
/* U+252c */ { 30, 0, 19, 0, 0 },
/* U+252d */ { 30, 0, 19, 0, 0 },
/* U+252e */ { 30, 0, 19, 0, 0 },
/* U+252f */ { 30, 0, 19, 0, 0 },
/* U+2530 */ { 30, 0, 19, 0, 0 },
/* U+2531 */ { 30, 0, 19, 0, 0 },
/* U+2532 */ { 30, 0, 19, 0, 0 },
/* U+2533 */ { 30, 0, 19, 0, 0 },
/* U+2534 */ { 30, 0, 19, 0, 0 },
/* U+2535 */ { 30, 0, 19, 0, 0 },
/* U+2536 */ { 30, 0, 19, 0, 0 },
/* U+2537 */ { 30, 0, 19, 0, 0 },
/* U+2538 */ { 30, 0, 19, 0, 0 },
/* U+2539 */ { 30, 0, 19, 0, 0 },
/* U+253a */ { 30, 0, 19, 0, 0 },
/* U+253b */ { 30, 0, 19, 0, 0 },
/* U+253c */ { 30, 0, 19, 0, 0 },
/* U+253d */ { 30, 0, 19, 0, 0 },
/* U+253e */ { 30, 0, 19, 0, 0 },
/* U+253f */ { 30, 0, 19, 0, 0 },
/* U+2540 */ { 30, 0, 19, 0, 0 },
/* U+2541 */ { 30, 0, 19, 0, 0 },
/* U+2542 */ { 30, 0, 19, 0, 0 },
/* U+2543 */ { 30, 0, 19, 0, 0 },
/* U+2544 */ { 30, 0, 19, 0, 0 },
/* U+2545 */ { 30, 0, 19, 0, 0 },
/* U+2546 */ { 30, 0, 19, 0, 0 },
/* U+2547 */ { 30, 0, 19, 0, 0 },
/* U+2548 */ { 30, 0, 19, 0, 0 },
/* U+2549 */ { 30, 0, 19, 0, 0 },
/* U+254a */ { 30, 0, 19, 0, 0 },
/* U+254b */ { 30, 0, 19, 0, 0 },
/* U+254c */ { 30, 0, 19, 0, 0 },
/* U+254d */ { 30, 0, 19, 0, 0 },
/* U+254e */ { 30, 0, 19, 0, 0 },
/* U+254f */ { 30, 0, 19, 0, 0 },
/* U+2550 */ { 30, 0, 19, 0, 0 },
/* U+2551 */ { 30, 0, 19, 0, 0 },
/* U+2552 */ { 30, 0, 19, 0, 0 },
/* U+2553 */ { 30, 0, 19, 0, 0 },
/* U+2554 */ { 30, 0, 19, 0, 0 },
/* U+2555 */ { 30, 0, 19, 0, 0 },
/* U+2556 */ { 30, 0, 19, 0, 0 },
/* U+2557 */ { 30, 0, 19, 0, 0 },
/* U+2558 */ { 30, 0, 19, 0, 0 },
/* U+2559 */ { 30, 0, 19, 0, 0 },
/* U+255a */ { 30, 0, 19, 0, 0 },
/* U+255b */ { 30, 0, 19, 0, 0 },
/* U+255c */ { 30, 0, 19, 0, 0 },
/* U+255d */ { 30, 0, 19, 0, 0 },
/* U+255e */ { 30, 0, 19, 0, 0 },
/* U+255f */ { 30, 0, 19, 0, 0 },
/* U+2560 */ { 30, 0, 19, 0, 0 },
/* U+2561 */ { 30, 0, 19, 0, 0 },
/* U+2562 */ { 30, 0, 19, 0, 0 },
/* U+2563 */ { 30, 0, 19, 0, 0 },
/* U+2564 */ { 30, 0, 19, 0, 0 },
/* U+2565 */ { 30, 0, 19, 0, 0 },
/* U+2566 */ { 30, 0, 19, 0, 0 },
/* U+2567 */ { 30, 0, 19, 0, 0 },
/* U+2568 */ { 30, 0, 19, 0, 0 },
/* U+2569 */ { 30, 0, 19, 0, 0 },
/* U+256a */ { 30, 0, 19, 0, 0 },
/* U+256b */ { 30, 0, 19, 0, 0 },
/* U+256c */ { 30, 0, 19, 0, 0 },
/* U+256d */ { 30, 0, 19, 0, 0 },
/* U+256e */ { 30, 0, 19, 0, 0 },
/* U+256f */ { 30, 0, 19, 0, 0 },
/* U+2570 */ { 30, 0, 19, 0, 0 },
/* U+2571 */ { 30, 0, 19, 0, 0 },
/* U+2572 */ { 30, 0, 19, 0, 0 },
/* U+2573 */ { 30, 0, 19, 0, 0 },
/* U+2574 */ { 30, 0, 19, 0, 0 },
/* U+2575 */ { 30, 0, 19, 0, 0 },
/* U+2576 */ { 30, 0, 19, 0, 0 },
/* U+2577 */ { 30, 0, 19, 0, 0 },
/* U+2578 */ { 30, 0, 19, 0, 0 },
/* U+2579 */ { 30, 0, 19, 0, 0 },
/* U+257a */ { 30, 0, 19, 0, 0 },
/* U+257b */ { 30, 0, 19, 0, 0 },
/* U+257c */ { 30, 0, 19, 0, 0 },
/* U+257d */ { 30, 0, 19, 0, 0 },
/* U+257e */ { 30, 0, 19, 0, 0 },
/* U+257f */ { 30, 0, 19, 0, 0 },
/* U+2580 */ { 30, 0, 19, 0, 0 },
/* U+2581 */ { 30, 0, 19, 0, 0 },
/* U+2582 */ { 30, 0, 19, 0, 0 },
/* U+2583 */ { 30, 0, 19, 0, 0 },
/* U+2584 */ { 30, 0, 19, 0, 0 },
/* U+2585 */ { 30, 0, 19, 0, 0 },
/* U+2586 */ { 30, 0, 19, 0, 0 },
/* U+2587 */ { 30, 0, 19, 0, 0 },
/* U+2588 */ { 30, 0, 19, 0, 0 },
/* U+2589 */ { 30, 0, 19, 0, 0 },
/* U+258a */ { 30, 0, 19, 0, 0 },
/* U+258b */ { 30, 0, 19, 0, 0 },
/* U+258c */ { 30, 0, 19, 0, 0 },
/* U+258d */ { 30, 0, 19, 0, 0 },
/* U+258e */ { 30, 0, 19, 0, 0 },
/* U+258f */ { 30, 0, 19, 0, 0 },
/* U+2590 */ { 30, 0, 19, 0, 0 },
/* U+2591 */ { 30, 0, 19, 0, 0 },
/* U+2592 */ { 30, 0, 19, 0, 0 },
/* U+2593 */ { 30, 0, 19, 0, 0 },
/* U+2594 */ { 30, 0, 19, 0, 0 },
/* U+2595 */ { 30, 0, 19, 0, 0 },
/* U+2596 */ { 0, 0, 0, 0, 0 },
/* U+2597 */ { 0, 0, 0, 0, 0 },
/* U+2598 */ { 0, 0, 0, 0, 0 },
/* U+2599 */ { 0, 0, 0, 0, 0 },
/* U+259a */ { 0, 0, 0, 0, 0 },
/* U+259b */ { 0, 0, 0, 0, 0 },
/* U+259c */ { 0, 0, 0, 0, 0 },
/* U+259d */ { 0, 0, 0, 0, 0 },
/* U+259e */ { 0, 0, 0, 0, 0 },
/* U+259f */ { 0, 0, 0, 0, 0 },
/* U+25a0 */ { 30, 0, 19, 0, 0 },
/* U+25a1 */ { 30, 0, 19, 0, 0 },
/* U+25a2 */ { 30, 0, 19, 0, 0 },
/* U+25a3 */ { 30, 0, 19, 0, 0 },
/* U+25a4 */ { 30, 0, 19, 0, 0 },
/* U+25a5 */ { 30, 0, 19, 0, 0 },
/* U+25a6 */ { 30, 0, 19, 0, 0 },
/* U+25a7 */ { 30, 0, 19, 0, 0 },
/* U+25a8 */ { 30, 0, 19, 0, 0 },
/* U+25a9 */ { 30, 0, 19, 0, 0 },
/* U+25aa */ { 30, 0, 19, 0, 0 },
/* U+25ab */ { 30, 0, 19, 0, 0 },
/* U+25ac */ { 30, 0, 19, 0, 0 },
/* U+25ad */ { 30, 0, 19, 0, 0 },
/* U+25ae */ { 30, 0, 19, 0, 0 },
/* U+25af */ { 30, 0, 19, 0, 0 },
/* U+25b0 */ { 30, 0, 19, 0, 0 },
/* U+25b1 */ { 30, 0, 19, 0, 0 },
/* U+25b2 */ { 30, 0, 19, 0, 0 },
/* U+25b3 */ { 30, 0, 19, 0, 0 },
/* U+25b4 */ { 30, 0, 19, 0, 0 },
/* U+25b5 */ { 30, 0, 19, 0, 0 },
/* U+25b6 */ { 30, 0, 19, 0, 0 },
/* U+25b7 */ { 27, 0, 19, 0, 0 },
/* U+25b8 */ { 30, 0, 19, 0, 0 },
/* U+25b9 */ { 30, 0, 19, 0, 0 },
/* U+25ba */ { 30, 0, 19, 0, 0 },
/* U+25bb */ { 30, 0, 19, 0, 0 },
/* U+25bc */ { 30, 0, 19, 0, 0 },
/* U+25bd */ { 30, 0, 19, 0, 0 },
/* U+25be */ { 30, 0, 19, 0, 0 },
/* U+25bf */ { 30, 0, 19, 0, 0 },
/* U+25c0 */ { 30, 0, 19, 0, 0 },
/* U+25c1 */ { 27, 0, 19, 0, 0 },
/* U+25c2 */ { 30, 0, 19, 0, 0 },
/* U+25c3 */ { 30, 0, 19, 0, 0 },
/* U+25c4 */ { 30, 0, 19, 0, 0 },
/* U+25c5 */ { 30, 0, 19, 0, 0 },
/* U+25c6 */ { 30, 0, 19, 0, 0 },
/* U+25c7 */ { 30, 0, 19, 0, 0 },
/* U+25c8 */ { 30, 0, 19, 0, 0 },
/* U+25c9 */ { 30, 0, 19, 0, 0 },
/* U+25ca */ { 30, 0, 19, 0, 0 },
/* U+25cb */ { 30, 0, 19, 0, 0 },
/* U+25cc */ { 30, 0, 19, 0, 0 },
/* U+25cd */ { 30, 0, 19, 0, 0 },
/* U+25ce */ { 30, 0, 19, 0, 0 },
/* U+25cf */ { 30, 0, 19, 0, 0 },
/* U+25d0 */ { 30, 0, 19, 0, 0 },
/* U+25d1 */ { 30, 0, 19, 0, 0 },
/* U+25d2 */ { 30, 0, 19, 0, 0 },
/* U+25d3 */ { 30, 0, 19, 0, 0 },
/* U+25d4 */ { 30, 0, 19, 0, 0 },
/* U+25d5 */ { 30, 0, 19, 0, 0 },
/* U+25d6 */ { 30, 0, 19, 0, 0 },
/* U+25d7 */ { 30, 0, 19, 0, 0 },
/* U+25d8 */ { 30, 0, 19, 0, 0 },
/* U+25d9 */ { 30, 0, 19, 0, 0 },
/* U+25da */ { 30, 0, 19, 0, 0 },
/* U+25db */ { 30, 0, 19, 0, 0 },
/* U+25dc */ { 30, 0, 19, 0, 0 },
/* U+25dd */ { 30, 0, 19, 0, 0 },
/* U+25de */ { 30, 0, 19, 0, 0 },
/* U+25df */ { 30, 0, 19, 0, 0 },
/* U+25e0 */ { 30, 0, 19, 0, 0 },
/* U+25e1 */ { 30, 0, 19, 0, 0 },
/* U+25e2 */ { 30, 0, 19, 0, 0 },
/* U+25e3 */ { 30, 0, 19, 0, 0 },
/* U+25e4 */ { 30, 0, 19, 0, 0 },
/* U+25e5 */ { 30, 0, 19, 0, 0 },
/* U+25e6 */ { 30, 0, 19, 0, 0 },
/* U+25e7 */ { 30, 0, 19, 0, 0 },
/* U+25e8 */ { 30, 0, 19, 0, 0 },
/* U+25e9 */ { 30, 0, 19, 0, 0 },
/* U+25ea */ { 30, 0, 19, 0, 0 },
/* U+25eb */ { 30, 0, 19, 0, 0 },
/* U+25ec */ { 30, 0, 19, 0, 0 },
/* U+25ed */ { 30, 0, 19, 0, 0 },
/* U+25ee */ { 30, 0, 19, 0, 0 },
/* U+25ef */ { 30, 0, 19, 0, 0 },
/* U+25f0 */ { 30, 0, 19, 0, 0 },
/* U+25f1 */ { 30, 0, 19, 0, 0 },
/* U+25f2 */ { 30, 0, 19, 0, 0 },
/* U+25f3 */ { 30, 0, 19, 0, 0 },
/* U+25f4 */ { 30, 0, 19, 0, 0 },
/* U+25f5 */ { 30, 0, 19, 0, 0 },
/* U+25f6 */ { 30, 0, 19, 0, 0 },
/* U+25f7 */ { 30, 0, 19, 0, 0 },
/* U+25f8 */ { 0, 0, 0, 0, 0 },
/* U+25f9 */ { 0, 0, 0, 0, 0 },
/* U+25fa */ { 0, 0, 0, 0, 0 },
/* U+25fb */ { 0, 0, 0, 0, 0 },
/* U+25fc */ { 0, 0, 0, 0, 0 },
/* U+25fd */ { 0, 0, 0, 0, 0 },
/* U+25fe */ { 0, 0, 0, 0, 0 },
/* U+25ff */ { 0, 0, 0, 0, 0 },
/* U+2600 */ { 30, 0, 19, 0, 0 },
/* U+2601 */ { 30, 0, 19, 0, 0 },
/* U+2602 */ { 30, 0, 19, 0, 0 },
/* U+2603 */ { 30, 0, 19, 0, 0 },
/* U+2604 */ { 30, 0, 19, 0, 0 },
/* U+2605 */ { 30, 0, 19, 0, 0 },
/* U+2606 */ { 30, 0, 19, 0, 0 },
/* U+2607 */ { 30, 0, 19, 0, 0 },
/* U+2608 */ { 30, 0, 19, 0, 0 },
/* U+2609 */ { 30, 0, 19, 0, 0 },
/* U+260a */ { 30, 0, 19, 0, 0 },
/* U+260b */ { 30, 0, 19, 0, 0 },
/* U+260c */ { 30, 0, 19, 0, 0 },
/* U+260d */ { 30, 0, 19, 0, 0 },
/* U+260e */ { 30, 0, 19, 0, 0 },
/* U+260f */ { 30, 0, 19, 0, 0 },
/* U+2610 */ { 30, 0, 19, 0, 0 },
/* U+2611 */ { 30, 0, 19, 0, 0 },
/* U+2612 */ { 30, 0, 19, 0, 0 },
/* U+2613 */ { 30, 0, 19, 0, 0 },
/* U+2614 */ { 0, 0, 0, 0, 0 },
/* U+2615 */ { 0, 0, 0, 0, 0 },
/* U+2616 */ { 0, 0, 0, 0, 0 },
/* U+2617 */ { 0, 0, 0, 0, 0 },
/* U+2618 */ { 0, 0, 0, 0, 0 },
/* U+2619 */ { 30, 0, 19, 0, 0 },
/* U+261a */ { 30, 0, 19, 0, 0 },
/* U+261b */ { 30, 0, 19, 0, 0 },
/* U+261c */ { 30, 0, 19, 0, 0 },
/* U+261d */ { 30, 0, 19, 0, 0 },
/* U+261e */ { 30, 0, 19, 0, 0 },
/* U+261f */ { 30, 0, 19, 0, 0 },
/* U+2620 */ { 30, 0, 19, 0, 0 },
/* U+2621 */ { 30, 0, 19, 0, 0 },
/* U+2622 */ { 30, 0, 19, 0, 0 },
/* U+2623 */ { 30, 0, 19, 0, 0 },
/* U+2624 */ { 30, 0, 19, 0, 0 },
/* U+2625 */ { 30, 0, 19, 0, 0 },
/* U+2626 */ { 30, 0, 19, 0, 0 },
/* U+2627 */ { 30, 0, 19, 0, 0 },
/* U+2628 */ { 30, 0, 19, 0, 0 },
/* U+2629 */ { 30, 0, 19, 0, 0 },
/* U+262a */ { 30, 0, 19, 0, 0 },
/* U+262b */ { 30, 0, 19, 0, 0 },
/* U+262c */ { 30, 0, 19, 0, 0 },
/* U+262d */ { 30, 0, 19, 0, 0 },
/* U+262e */ { 30, 0, 19, 0, 0 },
/* U+262f */ { 30, 0, 19, 0, 0 },
/* U+2630 */ { 30, 0, 19, 0, 0 },
/* U+2631 */ { 30, 0, 19, 0, 0 },
/* U+2632 */ { 30, 0, 19, 0, 0 },
/* U+2633 */ { 30, 0, 19, 0, 0 },
/* U+2634 */ { 30, 0, 19, 0, 0 },
/* U+2635 */ { 30, 0, 19, 0, 0 },
/* U+2636 */ { 30, 0, 19, 0, 0 },
/* U+2637 */ { 30, 0, 19, 0, 0 },
/* U+2638 */ { 30, 0, 19, 0, 0 },
/* U+2639 */ { 30, 0, 19, 0, 0 },
/* U+263a */ { 30, 0, 19, 0, 0 },
/* U+263b */ { 30, 0, 19, 0, 0 },
/* U+263c */ { 30, 0, 19, 0, 0 },
/* U+263d */ { 30, 0, 19, 0, 0 },
/* U+263e */ { 30, 0, 19, 0, 0 },
/* U+263f */ { 30, 0, 19, 0, 0 },
/* U+2640 */ { 30, 0, 19, 0, 0 },
/* U+2641 */ { 30, 0, 19, 0, 0 },
/* U+2642 */ { 30, 0, 19, 0, 0 },
/* U+2643 */ { 30, 0, 19, 0, 0 },
/* U+2644 */ { 30, 0, 19, 0, 0 },
/* U+2645 */ { 30, 0, 19, 0, 0 },
/* U+2646 */ { 30, 0, 19, 0, 0 },
/* U+2647 */ { 30, 0, 19, 0, 0 },
/* U+2648 */ { 30, 0, 19, 0, 0 },
/* U+2649 */ { 30, 0, 19, 0, 0 },
/* U+264a */ { 30, 0, 19, 0, 0 },
/* U+264b */ { 30, 0, 19, 0, 0 },
/* U+264c */ { 30, 0, 19, 0, 0 },
/* U+264d */ { 30, 0, 19, 0, 0 },
/* U+264e */ { 30, 0, 19, 0, 0 },
/* U+264f */ { 30, 0, 19, 0, 0 },
/* U+2650 */ { 30, 0, 19, 0, 0 },
/* U+2651 */ { 30, 0, 19, 0, 0 },
/* U+2652 */ { 30, 0, 19, 0, 0 },
/* U+2653 */ { 30, 0, 19, 0, 0 },
/* U+2654 */ { 30, 0, 19, 0, 0 },
/* U+2655 */ { 30, 0, 19, 0, 0 },
/* U+2656 */ { 30, 0, 19, 0, 0 },
/* U+2657 */ { 30, 0, 19, 0, 0 },
/* U+2658 */ { 30, 0, 19, 0, 0 },
/* U+2659 */ { 30, 0, 19, 0, 0 },
/* U+265a */ { 30, 0, 19, 0, 0 },
/* U+265b */ { 30, 0, 19, 0, 0 },
/* U+265c */ { 30, 0, 19, 0, 0 },
/* U+265d */ { 30, 0, 19, 0, 0 },
/* U+265e */ { 30, 0, 19, 0, 0 },
/* U+265f */ { 30, 0, 19, 0, 0 },
/* U+2660 */ { 30, 0, 19, 0, 0 },
/* U+2661 */ { 30, 0, 19, 0, 0 },
/* U+2662 */ { 30, 0, 19, 0, 0 },
/* U+2663 */ { 30, 0, 19, 0, 0 },
/* U+2664 */ { 30, 0, 19, 0, 0 },
/* U+2665 */ { 30, 0, 19, 0, 0 },
/* U+2666 */ { 30, 0, 19, 0, 0 },
/* U+2667 */ { 30, 0, 19, 0, 0 },
/* U+2668 */ { 30, 0, 19, 0, 0 },
/* U+2669 */ { 30, 0, 19, 0, 0 },
/* U+266a */ { 30, 0, 19, 0, 0 },
/* U+266b */ { 30, 0, 19, 0, 0 },
/* U+266c */ { 30, 0, 19, 0, 0 },
/* U+266d */ { 30, 0, 19, 0, 0 },
/* U+266e */ { 30, 0, 19, 0, 0 },
/* U+266f */ { 27, 0, 19, 0, 0 },
/* U+2670 */ { 30, 0, 19, 0, 0 },
/* U+2671 */ { 30, 0, 19, 0, 0 },
/* U+2672 */ { 0, 0, 0, 0, 0 },
/* U+2673 */ { 0, 0, 0, 0, 0 },
/* U+2674 */ { 0, 0, 0, 0, 0 },
/* U+2675 */ { 0, 0, 0, 0, 0 },
/* U+2676 */ { 0, 0, 0, 0, 0 },
/* U+2677 */ { 0, 0, 0, 0, 0 },
/* U+2678 */ { 0, 0, 0, 0, 0 },
/* U+2679 */ { 0, 0, 0, 0, 0 },
/* U+267a */ { 0, 0, 0, 0, 0 },
/* U+267b */ { 0, 0, 0, 0, 0 },
/* U+267c */ { 0, 0, 0, 0, 0 },
/* U+267d */ { 0, 0, 0, 0, 0 },
/* U+267e */ { 0, 0, 0, 0, 0 },
/* U+267f */ { 0, 0, 0, 0, 0 },
/* U+2680 */ { 0, 0, 0, 0, 0 },
/* U+2681 */ { 0, 0, 0, 0, 0 },
/* U+2682 */ { 0, 0, 0, 0, 0 },
/* U+2683 */ { 0, 0, 0, 0, 0 },
/* U+2684 */ { 0, 0, 0, 0, 0 },
/* U+2685 */ { 0, 0, 0, 0, 0 },
/* U+2686 */ { 0, 0, 0, 0, 0 },
/* U+2687 */ { 0, 0, 0, 0, 0 },
/* U+2688 */ { 0, 0, 0, 0, 0 },
/* U+2689 */ { 0, 0, 0, 0, 0 },
/* U+268a */ { 0, 0, 0, 0, 0 },
/* U+268b */ { 0, 0, 0, 0, 0 },
/* U+268c */ { 0, 0, 0, 0, 0 },
/* U+268d */ { 0, 0, 0, 0, 0 },
/* U+268e */ { 0, 0, 0, 0, 0 },
/* U+268f */ { 0, 0, 0, 0, 0 },
/* U+2690 */ { 0, 0, 0, 0, 0 },
/* U+2691 */ { 0, 0, 0, 0, 0 },
/* U+2692 */ { 0, 0, 0, 0, 0 },
/* U+2693 */ { 0, 0, 0, 0, 0 },
/* U+2694 */ { 0, 0, 0, 0, 0 },
/* U+2695 */ { 0, 0, 0, 0, 0 },
/* U+2696 */ { 0, 0, 0, 0, 0 },
/* U+2697 */ { 0, 0, 0, 0, 0 },
/* U+2698 */ { 0, 0, 0, 0, 0 },
/* U+2699 */ { 0, 0, 0, 0, 0 },
/* U+269a */ { 0, 0, 0, 0, 0 },
/* U+269b */ { 0, 0, 0, 0, 0 },
/* U+269c */ { 0, 0, 0, 0, 0 },
/* U+269d */ { 0, 0, 0, 0, 0 },
/* U+269e */ { 0, 0, 0, 0, 0 },
/* U+269f */ { 0, 0, 0, 0, 0 },
/* U+26a0 */ { 0, 0, 0, 0, 0 },
/* U+26a1 */ { 0, 0, 0, 0, 0 },
/* U+26a2 */ { 0, 0, 0, 0, 0 },
/* U+26a3 */ { 0, 0, 0, 0, 0 },
/* U+26a4 */ { 0, 0, 0, 0, 0 },
/* U+26a5 */ { 0, 0, 0, 0, 0 },
/* U+26a6 */ { 0, 0, 0, 0, 0 },
/* U+26a7 */ { 0, 0, 0, 0, 0 },
/* U+26a8 */ { 0, 0, 0, 0, 0 },
/* U+26a9 */ { 0, 0, 0, 0, 0 },
/* U+26aa */ { 0, 0, 0, 0, 0 },
/* U+26ab */ { 0, 0, 0, 0, 0 },
/* U+26ac */ { 0, 0, 0, 0, 0 },
/* U+26ad */ { 0, 0, 0, 0, 0 },
/* U+26ae */ { 0, 0, 0, 0, 0 },
/* U+26af */ { 0, 0, 0, 0, 0 },
/* U+26b0 */ { 0, 0, 0, 0, 0 },
/* U+26b1 */ { 0, 0, 0, 0, 0 },
/* U+26b2 */ { 0, 0, 0, 0, 0 },
/* U+26b3 */ { 0, 0, 0, 0, 0 },
/* U+26b4 */ { 0, 0, 0, 0, 0 },
/* U+26b5 */ { 0, 0, 0, 0, 0 },
/* U+26b6 */ { 0, 0, 0, 0, 0 },
/* U+26b7 */ { 0, 0, 0, 0, 0 },
/* U+26b8 */ { 0, 0, 0, 0, 0 },
/* U+26b9 */ { 0, 0, 0, 0, 0 },
/* U+26ba */ { 0, 0, 0, 0, 0 },
/* U+26bb */ { 0, 0, 0, 0, 0 },
/* U+26bc */ { 0, 0, 0, 0, 0 },
/* U+26bd */ { 0, 0, 0, 0, 0 },
/* U+26be */ { 0, 0, 0, 0, 0 },
/* U+26bf */ { 0, 0, 0, 0, 0 },
/* U+26c0 */ { 0, 0, 0, 0, 0 },
/* U+26c1 */ { 0, 0, 0, 0, 0 },
/* U+26c2 */ { 0, 0, 0, 0, 0 },
/* U+26c3 */ { 0, 0, 0, 0, 0 },
/* U+26c4 */ { 0, 0, 0, 0, 0 },
/* U+26c5 */ { 0, 0, 0, 0, 0 },
/* U+26c6 */ { 0, 0, 0, 0, 0 },
/* U+26c7 */ { 0, 0, 0, 0, 0 },
/* U+26c8 */ { 0, 0, 0, 0, 0 },
/* U+26c9 */ { 0, 0, 0, 0, 0 },
/* U+26ca */ { 0, 0, 0, 0, 0 },
/* U+26cb */ { 0, 0, 0, 0, 0 },
/* U+26cc */ { 0, 0, 0, 0, 0 },
/* U+26cd */ { 0, 0, 0, 0, 0 },
/* U+26ce */ { 0, 0, 0, 0, 0 },
/* U+26cf */ { 0, 0, 0, 0, 0 },
/* U+26d0 */ { 0, 0, 0, 0, 0 },
/* U+26d1 */ { 0, 0, 0, 0, 0 },
/* U+26d2 */ { 0, 0, 0, 0, 0 },
/* U+26d3 */ { 0, 0, 0, 0, 0 },
/* U+26d4 */ { 0, 0, 0, 0, 0 },
/* U+26d5 */ { 0, 0, 0, 0, 0 },
/* U+26d6 */ { 0, 0, 0, 0, 0 },
/* U+26d7 */ { 0, 0, 0, 0, 0 },
/* U+26d8 */ { 0, 0, 0, 0, 0 },
/* U+26d9 */ { 0, 0, 0, 0, 0 },
/* U+26da */ { 0, 0, 0, 0, 0 },
/* U+26db */ { 0, 0, 0, 0, 0 },
/* U+26dc */ { 0, 0, 0, 0, 0 },
/* U+26dd */ { 0, 0, 0, 0, 0 },
/* U+26de */ { 0, 0, 0, 0, 0 },
/* U+26df */ { 0, 0, 0, 0, 0 },
/* U+26e0 */ { 0, 0, 0, 0, 0 },
/* U+26e1 */ { 0, 0, 0, 0, 0 },
/* U+26e2 */ { 0, 0, 0, 0, 0 },
/* U+26e3 */ { 0, 0, 0, 0, 0 },
/* U+26e4 */ { 0, 0, 0, 0, 0 },
/* U+26e5 */ { 0, 0, 0, 0, 0 },
/* U+26e6 */ { 0, 0, 0, 0, 0 },
/* U+26e7 */ { 0, 0, 0, 0, 0 },
/* U+26e8 */ { 0, 0, 0, 0, 0 },
/* U+26e9 */ { 0, 0, 0, 0, 0 },
/* U+26ea */ { 0, 0, 0, 0, 0 },
/* U+26eb */ { 0, 0, 0, 0, 0 },
/* U+26ec */ { 0, 0, 0, 0, 0 },
/* U+26ed */ { 0, 0, 0, 0, 0 },
/* U+26ee */ { 0, 0, 0, 0, 0 },
/* U+26ef */ { 0, 0, 0, 0, 0 },
/* U+26f0 */ { 0, 0, 0, 0, 0 },
/* U+26f1 */ { 0, 0, 0, 0, 0 },
/* U+26f2 */ { 0, 0, 0, 0, 0 },
/* U+26f3 */ { 0, 0, 0, 0, 0 },
/* U+26f4 */ { 0, 0, 0, 0, 0 },
/* U+26f5 */ { 0, 0, 0, 0, 0 },
/* U+26f6 */ { 0, 0, 0, 0, 0 },
/* U+26f7 */ { 0, 0, 0, 0, 0 },
/* U+26f8 */ { 0, 0, 0, 0, 0 },
/* U+26f9 */ { 0, 0, 0, 0, 0 },
/* U+26fa */ { 0, 0, 0, 0, 0 },
/* U+26fb */ { 0, 0, 0, 0, 0 },
/* U+26fc */ { 0, 0, 0, 0, 0 },
/* U+26fd */ { 0, 0, 0, 0, 0 },
/* U+26fe */ { 0, 0, 0, 0, 0 },
/* U+26ff */ { 0, 0, 0, 0, 0 },
/* U+2700 */ { 0, 0, 0, 0, 0 },
/* U+2701 */ { 30, 0, 19, 0, 0 },
/* U+2702 */ { 30, 0, 19, 0, 0 },
/* U+2703 */ { 30, 0, 19, 0, 0 },
/* U+2704 */ { 30, 0, 19, 0, 0 },
/* U+2705 */ { 0, 0, 0, 0, 0 },
/* U+2706 */ { 30, 0, 19, 0, 0 },
/* U+2707 */ { 30, 0, 19, 0, 0 },
/* U+2708 */ { 30, 0, 19, 0, 0 },
/* U+2709 */ { 30, 0, 19, 0, 0 },
/* U+270a */ { 0, 0, 0, 0, 0 },
/* U+270b */ { 0, 0, 0, 0, 0 },
/* U+270c */ { 30, 0, 19, 0, 0 },
/* U+270d */ { 30, 0, 19, 0, 0 },
/* U+270e */ { 30, 0, 19, 0, 0 },
/* U+270f */ { 30, 0, 19, 0, 0 },
/* U+2710 */ { 30, 0, 19, 0, 0 },
/* U+2711 */ { 30, 0, 19, 0, 0 },
/* U+2712 */ { 30, 0, 19, 0, 0 },
/* U+2713 */ { 30, 0, 19, 0, 0 },
/* U+2714 */ { 30, 0, 19, 0, 0 },
/* U+2715 */ { 30, 0, 19, 0, 0 },
/* U+2716 */ { 30, 0, 19, 0, 0 },
/* U+2717 */ { 30, 0, 19, 0, 0 },
/* U+2718 */ { 30, 0, 19, 0, 0 },
/* U+2719 */ { 30, 0, 19, 0, 0 },
/* U+271a */ { 30, 0, 19, 0, 0 },
/* U+271b */ { 30, 0, 19, 0, 0 },
/* U+271c */ { 30, 0, 19, 0, 0 },
/* U+271d */ { 30, 0, 19, 0, 0 },
/* U+271e */ { 30, 0, 19, 0, 0 },
/* U+271f */ { 30, 0, 19, 0, 0 },
/* U+2720 */ { 30, 0, 19, 0, 0 },
/* U+2721 */ { 30, 0, 19, 0, 0 },
/* U+2722 */ { 30, 0, 19, 0, 0 },
/* U+2723 */ { 30, 0, 19, 0, 0 },
/* U+2724 */ { 30, 0, 19, 0, 0 },
/* U+2725 */ { 30, 0, 19, 0, 0 },
/* U+2726 */ { 30, 0, 19, 0, 0 },
/* U+2727 */ { 30, 0, 19, 0, 0 },
/* U+2728 */ { 0, 0, 0, 0, 0 },
/* U+2729 */ { 30, 0, 19, 0, 0 },
/* U+272a */ { 30, 0, 19, 0, 0 },
/* U+272b */ { 30, 0, 19, 0, 0 },
/* U+272c */ { 30, 0, 19, 0, 0 },
/* U+272d */ { 30, 0, 19, 0, 0 },
/* U+272e */ { 30, 0, 19, 0, 0 },
/* U+272f */ { 30, 0, 19, 0, 0 },
/* U+2730 */ { 30, 0, 19, 0, 0 },
/* U+2731 */ { 30, 0, 19, 0, 0 },
/* U+2732 */ { 30, 0, 19, 0, 0 },
/* U+2733 */ { 30, 0, 19, 0, 0 },
/* U+2734 */ { 30, 0, 19, 0, 0 },
/* U+2735 */ { 30, 0, 19, 0, 0 },
/* U+2736 */ { 30, 0, 19, 0, 0 },
/* U+2737 */ { 30, 0, 19, 0, 0 },
/* U+2738 */ { 30, 0, 19, 0, 0 },
/* U+2739 */ { 30, 0, 19, 0, 0 },
/* U+273a */ { 30, 0, 19, 0, 0 },
/* U+273b */ { 30, 0, 19, 0, 0 },
/* U+273c */ { 30, 0, 19, 0, 0 },
/* U+273d */ { 30, 0, 19, 0, 0 },
/* U+273e */ { 30, 0, 19, 0, 0 },
/* U+273f */ { 30, 0, 19, 0, 0 },
/* U+2740 */ { 30, 0, 19, 0, 0 },
/* U+2741 */ { 30, 0, 19, 0, 0 },
/* U+2742 */ { 30, 0, 19, 0, 0 },
/* U+2743 */ { 30, 0, 19, 0, 0 },
/* U+2744 */ { 30, 0, 19, 0, 0 },
/* U+2745 */ { 30, 0, 19, 0, 0 },
/* U+2746 */ { 30, 0, 19, 0, 0 },
/* U+2747 */ { 30, 0, 19, 0, 0 },
/* U+2748 */ { 30, 0, 19, 0, 0 },
/* U+2749 */ { 30, 0, 19, 0, 0 },
/* U+274a */ { 30, 0, 19, 0, 0 },
/* U+274b */ { 30, 0, 19, 0, 0 },
/* U+274c */ { 0, 0, 0, 0, 0 },
/* U+274d */ { 30, 0, 19, 0, 0 },
/* U+274e */ { 0, 0, 0, 0, 0 },
/* U+274f */ { 30, 0, 19, 0, 0 },
/* U+2750 */ { 30, 0, 19, 0, 0 },
/* U+2751 */ { 30, 0, 19, 0, 0 },
/* U+2752 */ { 30, 0, 19, 0, 0 },
/* U+2753 */ { 0, 0, 0, 0, 0 },
/* U+2754 */ { 0, 0, 0, 0, 0 },
/* U+2755 */ { 0, 0, 0, 0, 0 },
/* U+2756 */ { 30, 0, 19, 0, 0 },
/* U+2757 */ { 0, 0, 0, 0, 0 },
/* U+2758 */ { 30, 0, 19, 0, 0 },
/* U+2759 */ { 30, 0, 19, 0, 0 },
/* U+275a */ { 30, 0, 19, 0, 0 },
/* U+275b */ { 30, 0, 19, 0, 0 },
/* U+275c */ { 30, 0, 19, 0, 0 },
/* U+275d */ { 30, 0, 19, 0, 0 },
/* U+275e */ { 30, 0, 19, 0, 0 },
/* U+275f */ { 0, 0, 0, 0, 0 },
/* U+2760 */ { 0, 0, 0, 0, 0 },
/* U+2761 */ { 30, 0, 19, 0, 0 },
/* U+2762 */ { 30, 0, 19, 0, 0 },
/* U+2763 */ { 30, 0, 19, 0, 0 },
/* U+2764 */ { 30, 0, 19, 0, 0 },
/* U+2765 */ { 30, 0, 19, 0, 0 },
/* U+2766 */ { 30, 0, 19, 0, 0 },
/* U+2767 */ { 30, 0, 19, 0, 0 },
/* U+2768 */ { 0, 0, 0, 0, 0 },
/* U+2769 */ { 0, 0, 0, 0, 0 },
/* U+276a */ { 0, 0, 0, 0, 0 },
/* U+276b */ { 0, 0, 0, 0, 0 },
/* U+276c */ { 0, 0, 0, 0, 0 },
/* U+276d */ { 0, 0, 0, 0, 0 },
/* U+276e */ { 0, 0, 0, 0, 0 },
/* U+276f */ { 0, 0, 0, 0, 0 },
/* U+2770 */ { 0, 0, 0, 0, 0 },
/* U+2771 */ { 0, 0, 0, 0, 0 },
/* U+2772 */ { 0, 0, 0, 0, 0 },
/* U+2773 */ { 0, 0, 0, 0, 0 },
/* U+2774 */ { 0, 0, 0, 0, 0 },
/* U+2775 */ { 0, 0, 0, 0, 0 },
/* U+2776 */ { 9, 0, 19, 0, 0 },
/* U+2777 */ { 9, 0, 19, 0, 0 },
/* U+2778 */ { 9, 0, 19, 0, 0 },
/* U+2779 */ { 9, 0, 19, 0, 0 },
/* U+277a */ { 9, 0, 19, 0, 0 },
/* U+277b */ { 9, 0, 19, 0, 0 },
/* U+277c */ { 9, 0, 19, 0, 0 },
/* U+277d */ { 9, 0, 19, 0, 0 },
/* U+277e */ { 9, 0, 19, 0, 0 },
/* U+277f */ { 9, 0, 19, 0, 0 },
/* U+2780 */ { 9, 0, 19, 0, 0 },
/* U+2781 */ { 9, 0, 19, 0, 0 },
/* U+2782 */ { 9, 0, 19, 0, 0 },
/* U+2783 */ { 9, 0, 19, 0, 0 },
/* U+2784 */ { 9, 0, 19, 0, 0 },
/* U+2785 */ { 9, 0, 19, 0, 0 },
/* U+2786 */ { 9, 0, 19, 0, 0 },
/* U+2787 */ { 9, 0, 19, 0, 0 },
/* U+2788 */ { 9, 0, 19, 0, 0 },
/* U+2789 */ { 9, 0, 19, 0, 0 },
/* U+278a */ { 9, 0, 19, 0, 0 },
/* U+278b */ { 9, 0, 19, 0, 0 },
/* U+278c */ { 9, 0, 19, 0, 0 },
/* U+278d */ { 9, 0, 19, 0, 0 },
/* U+278e */ { 9, 0, 19, 0, 0 },
/* U+278f */ { 9, 0, 19, 0, 0 },
/* U+2790 */ { 9, 0, 19, 0, 0 },
/* U+2791 */ { 9, 0, 19, 0, 0 },
/* U+2792 */ { 9, 0, 19, 0, 0 },
/* U+2793 */ { 9, 0, 19, 0, 0 },
/* U+2794 */ { 30, 0, 19, 0, 0 },
/* U+2795 */ { 0, 0, 0, 0, 0 },
/* U+2796 */ { 0, 0, 0, 0, 0 },
/* U+2797 */ { 0, 0, 0, 0, 0 },
/* U+2798 */ { 30, 0, 19, 0, 0 },
/* U+2799 */ { 30, 0, 19, 0, 0 },
/* U+279a */ { 30, 0, 19, 0, 0 },
/* U+279b */ { 30, 0, 19, 0, 0 },
/* U+279c */ { 30, 0, 19, 0, 0 },
/* U+279d */ { 30, 0, 19, 0, 0 },
/* U+279e */ { 30, 0, 19, 0, 0 },
/* U+279f */ { 30, 0, 19, 0, 0 },
/* U+27a0 */ { 30, 0, 19, 0, 0 },
/* U+27a1 */ { 30, 0, 19, 0, 0 },
/* U+27a2 */ { 30, 0, 19, 0, 0 },
/* U+27a3 */ { 30, 0, 19, 0, 0 },
/* U+27a4 */ { 30, 0, 19, 0, 0 },
/* U+27a5 */ { 30, 0, 19, 0, 0 },
/* U+27a6 */ { 30, 0, 19, 0, 0 },
/* U+27a7 */ { 30, 0, 19, 0, 0 },
/* U+27a8 */ { 30, 0, 19, 0, 0 },
/* U+27a9 */ { 30, 0, 19, 0, 0 },
/* U+27aa */ { 30, 0, 19, 0, 0 },
/* U+27ab */ { 30, 0, 19, 0, 0 },
/* U+27ac */ { 30, 0, 19, 0, 0 },
/* U+27ad */ { 30, 0, 19, 0, 0 },
/* U+27ae */ { 30, 0, 19, 0, 0 },
/* U+27af */ { 30, 0, 19, 0, 0 },
/* U+27b0 */ { 0, 0, 0, 0, 0 },
/* U+27b1 */ { 30, 0, 19, 0, 0 },
/* U+27b2 */ { 30, 0, 19, 0, 0 },
/* U+27b3 */ { 30, 0, 19, 0, 0 },
/* U+27b4 */ { 30, 0, 19, 0, 0 },
/* U+27b5 */ { 30, 0, 19, 0, 0 },
/* U+27b6 */ { 30, 0, 19, 0, 0 },
/* U+27b7 */ { 30, 0, 19, 0, 0 },
/* U+27b8 */ { 30, 0, 19, 0, 0 },
/* U+27b9 */ { 30, 0, 19, 0, 0 },
/* U+27ba */ { 30, 0, 19, 0, 0 },
/* U+27bb */ { 30, 0, 19, 0, 0 },
/* U+27bc */ { 30, 0, 19, 0, 0 },
/* U+27bd */ { 30, 0, 19, 0, 0 },
/* U+27be */ { 30, 0, 19, 0, 0 },
/* U+27bf */ { 0, 0, 0, 0, 0 },
/* U+27c0 */ { 0, 0, 0, 0, 0 },
/* U+27c1 */ { 0, 0, 0, 0, 0 },
/* U+27c2 */ { 0, 0, 0, 0, 0 },
/* U+27c3 */ { 0, 0, 0, 0, 0 },
/* U+27c4 */ { 0, 0, 0, 0, 0 },
/* U+27c5 */ { 0, 0, 0, 0, 0 },
/* U+27c6 */ { 0, 0, 0, 0, 0 },
/* U+27c7 */ { 0, 0, 0, 0, 0 },
/* U+27c8 */ { 0, 0, 0, 0, 0 },
/* U+27c9 */ { 0, 0, 0, 0, 0 },
/* U+27ca */ { 0, 0, 0, 0, 0 },
/* U+27cb */ { 0, 0, 0, 0, 0 },
/* U+27cc */ { 0, 0, 0, 0, 0 },
/* U+27cd */ { 0, 0, 0, 0, 0 },
/* U+27ce */ { 0, 0, 0, 0, 0 },
/* U+27cf */ { 0, 0, 0, 0, 0 },
/* U+27d0 */ { 0, 0, 0, 0, 0 },
/* U+27d1 */ { 0, 0, 0, 0, 0 },
/* U+27d2 */ { 0, 0, 0, 0, 0 },
/* U+27d3 */ { 0, 0, 0, 0, 0 },
/* U+27d4 */ { 0, 0, 0, 0, 0 },
/* U+27d5 */ { 0, 0, 0, 0, 0 },
/* U+27d6 */ { 0, 0, 0, 0, 0 },
/* U+27d7 */ { 0, 0, 0, 0, 0 },
/* U+27d8 */ { 0, 0, 0, 0, 0 },
/* U+27d9 */ { 0, 0, 0, 0, 0 },
/* U+27da */ { 0, 0, 0, 0, 0 },
/* U+27db */ { 0, 0, 0, 0, 0 },
/* U+27dc */ { 0, 0, 0, 0, 0 },
/* U+27dd */ { 0, 0, 0, 0, 0 },
/* U+27de */ { 0, 0, 0, 0, 0 },
/* U+27df */ { 0, 0, 0, 0, 0 },
/* U+27e0 */ { 0, 0, 0, 0, 0 },
/* U+27e1 */ { 0, 0, 0, 0, 0 },
/* U+27e2 */ { 0, 0, 0, 0, 0 },
/* U+27e3 */ { 0, 0, 0, 0, 0 },
/* U+27e4 */ { 0, 0, 0, 0, 0 },
/* U+27e5 */ { 0, 0, 0, 0, 0 },
/* U+27e6 */ { 0, 0, 0, 0, 0 },
/* U+27e7 */ { 0, 0, 0, 0, 0 },
/* U+27e8 */ { 0, 0, 0, 0, 0 },
/* U+27e9 */ { 0, 0, 0, 0, 0 },
/* U+27ea */ { 0, 0, 0, 0, 0 },
/* U+27eb */ { 0, 0, 0, 0, 0 },
/* U+27ec */ { 0, 0, 0, 0, 0 },
/* U+27ed */ { 0, 0, 0, 0, 0 },
/* U+27ee */ { 0, 0, 0, 0, 0 },
/* U+27ef */ { 0, 0, 0, 0, 0 },
/* U+27f0 */ { 0, 0, 0, 0, 0 },
/* U+27f1 */ { 0, 0, 0, 0, 0 },
/* U+27f2 */ { 0, 0, 0, 0, 0 },
/* U+27f3 */ { 0, 0, 0, 0, 0 },
/* U+27f4 */ { 0, 0, 0, 0, 0 },
/* U+27f5 */ { 0, 0, 0, 0, 0 },
/* U+27f6 */ { 0, 0, 0, 0, 0 },
/* U+27f7 */ { 0, 0, 0, 0, 0 },
/* U+27f8 */ { 0, 0, 0, 0, 0 },
/* U+27f9 */ { 0, 0, 0, 0, 0 },
/* U+27fa */ { 0, 0, 0, 0, 0 },
/* U+27fb */ { 0, 0, 0, 0, 0 },
/* U+27fc */ { 0, 0, 0, 0, 0 },
/* U+27fd */ { 0, 0, 0, 0, 0 },
/* U+27fe */ { 0, 0, 0, 0, 0 },
/* U+27ff */ { 0, 0, 0, 0, 0 },
/* U+2800 */ { 30, 0, 19, 0, 0 },
/* U+2801 */ { 30, 0, 19, 0, 0 },
/* U+2802 */ { 30, 0, 19, 0, 0 },
/* U+2803 */ { 30, 0, 19, 0, 0 },
/* U+2804 */ { 30, 0, 19, 0, 0 },
/* U+2805 */ { 30, 0, 19, 0, 0 },
/* U+2806 */ { 30, 0, 19, 0, 0 },
/* U+2807 */ { 30, 0, 19, 0, 0 },
/* U+2808 */ { 30, 0, 19, 0, 0 },
/* U+2809 */ { 30, 0, 19, 0, 0 },
/* U+280a */ { 30, 0, 19, 0, 0 },
/* U+280b */ { 30, 0, 19, 0, 0 },
/* U+280c */ { 30, 0, 19, 0, 0 },
/* U+280d */ { 30, 0, 19, 0, 0 },
/* U+280e */ { 30, 0, 19, 0, 0 },
/* U+280f */ { 30, 0, 19, 0, 0 },
/* U+2810 */ { 30, 0, 19, 0, 0 },
/* U+2811 */ { 30, 0, 19, 0, 0 },
/* U+2812 */ { 30, 0, 19, 0, 0 },
/* U+2813 */ { 30, 0, 19, 0, 0 },
/* U+2814 */ { 30, 0, 19, 0, 0 },
/* U+2815 */ { 30, 0, 19, 0, 0 },
/* U+2816 */ { 30, 0, 19, 0, 0 },
/* U+2817 */ { 30, 0, 19, 0, 0 },
/* U+2818 */ { 30, 0, 19, 0, 0 },
/* U+2819 */ { 30, 0, 19, 0, 0 },
/* U+281a */ { 30, 0, 19, 0, 0 },
/* U+281b */ { 30, 0, 19, 0, 0 },
/* U+281c */ { 30, 0, 19, 0, 0 },
/* U+281d */ { 30, 0, 19, 0, 0 },
/* U+281e */ { 30, 0, 19, 0, 0 },
/* U+281f */ { 30, 0, 19, 0, 0 },
/* U+2820 */ { 30, 0, 19, 0, 0 },
/* U+2821 */ { 30, 0, 19, 0, 0 },
/* U+2822 */ { 30, 0, 19, 0, 0 },
/* U+2823 */ { 30, 0, 19, 0, 0 },
/* U+2824 */ { 30, 0, 19, 0, 0 },
/* U+2825 */ { 30, 0, 19, 0, 0 },
/* U+2826 */ { 30, 0, 19, 0, 0 },
/* U+2827 */ { 30, 0, 19, 0, 0 },
/* U+2828 */ { 30, 0, 19, 0, 0 },
/* U+2829 */ { 30, 0, 19, 0, 0 },
/* U+282a */ { 30, 0, 19, 0, 0 },
/* U+282b */ { 30, 0, 19, 0, 0 },
/* U+282c */ { 30, 0, 19, 0, 0 },
/* U+282d */ { 30, 0, 19, 0, 0 },
/* U+282e */ { 30, 0, 19, 0, 0 },
/* U+282f */ { 30, 0, 19, 0, 0 },
/* U+2830 */ { 30, 0, 19, 0, 0 },
/* U+2831 */ { 30, 0, 19, 0, 0 },
/* U+2832 */ { 30, 0, 19, 0, 0 },
/* U+2833 */ { 30, 0, 19, 0, 0 },
/* U+2834 */ { 30, 0, 19, 0, 0 },
/* U+2835 */ { 30, 0, 19, 0, 0 },
/* U+2836 */ { 30, 0, 19, 0, 0 },
/* U+2837 */ { 30, 0, 19, 0, 0 },
/* U+2838 */ { 30, 0, 19, 0, 0 },
/* U+2839 */ { 30, 0, 19, 0, 0 },
/* U+283a */ { 30, 0, 19, 0, 0 },
/* U+283b */ { 30, 0, 19, 0, 0 },
/* U+283c */ { 30, 0, 19, 0, 0 },
/* U+283d */ { 30, 0, 19, 0, 0 },
/* U+283e */ { 30, 0, 19, 0, 0 },
/* U+283f */ { 30, 0, 19, 0, 0 },
/* U+2840 */ { 30, 0, 19, 0, 0 },
/* U+2841 */ { 30, 0, 19, 0, 0 },
/* U+2842 */ { 30, 0, 19, 0, 0 },
/* U+2843 */ { 30, 0, 19, 0, 0 },
/* U+2844 */ { 30, 0, 19, 0, 0 },
/* U+2845 */ { 30, 0, 19, 0, 0 },
/* U+2846 */ { 30, 0, 19, 0, 0 },
/* U+2847 */ { 30, 0, 19, 0, 0 },
/* U+2848 */ { 30, 0, 19, 0, 0 },
/* U+2849 */ { 30, 0, 19, 0, 0 },
/* U+284a */ { 30, 0, 19, 0, 0 },
/* U+284b */ { 30, 0, 19, 0, 0 },
/* U+284c */ { 30, 0, 19, 0, 0 },
/* U+284d */ { 30, 0, 19, 0, 0 },
/* U+284e */ { 30, 0, 19, 0, 0 },
/* U+284f */ { 30, 0, 19, 0, 0 },
/* U+2850 */ { 30, 0, 19, 0, 0 },
/* U+2851 */ { 30, 0, 19, 0, 0 },
/* U+2852 */ { 30, 0, 19, 0, 0 },
/* U+2853 */ { 30, 0, 19, 0, 0 },
/* U+2854 */ { 30, 0, 19, 0, 0 },
/* U+2855 */ { 30, 0, 19, 0, 0 },
/* U+2856 */ { 30, 0, 19, 0, 0 },
/* U+2857 */ { 30, 0, 19, 0, 0 },
/* U+2858 */ { 30, 0, 19, 0, 0 },
/* U+2859 */ { 30, 0, 19, 0, 0 },
/* U+285a */ { 30, 0, 19, 0, 0 },
/* U+285b */ { 30, 0, 19, 0, 0 },
/* U+285c */ { 30, 0, 19, 0, 0 },
/* U+285d */ { 30, 0, 19, 0, 0 },
/* U+285e */ { 30, 0, 19, 0, 0 },
/* U+285f */ { 30, 0, 19, 0, 0 },
/* U+2860 */ { 30, 0, 19, 0, 0 },
/* U+2861 */ { 30, 0, 19, 0, 0 },
/* U+2862 */ { 30, 0, 19, 0, 0 },
/* U+2863 */ { 30, 0, 19, 0, 0 },
/* U+2864 */ { 30, 0, 19, 0, 0 },
/* U+2865 */ { 30, 0, 19, 0, 0 },
/* U+2866 */ { 30, 0, 19, 0, 0 },
/* U+2867 */ { 30, 0, 19, 0, 0 },
/* U+2868 */ { 30, 0, 19, 0, 0 },
/* U+2869 */ { 30, 0, 19, 0, 0 },
/* U+286a */ { 30, 0, 19, 0, 0 },
/* U+286b */ { 30, 0, 19, 0, 0 },
/* U+286c */ { 30, 0, 19, 0, 0 },
/* U+286d */ { 30, 0, 19, 0, 0 },
/* U+286e */ { 30, 0, 19, 0, 0 },
/* U+286f */ { 30, 0, 19, 0, 0 },
/* U+2870 */ { 30, 0, 19, 0, 0 },
/* U+2871 */ { 30, 0, 19, 0, 0 },
/* U+2872 */ { 30, 0, 19, 0, 0 },
/* U+2873 */ { 30, 0, 19, 0, 0 },
/* U+2874 */ { 30, 0, 19, 0, 0 },
/* U+2875 */ { 30, 0, 19, 0, 0 },
/* U+2876 */ { 30, 0, 19, 0, 0 },
/* U+2877 */ { 30, 0, 19, 0, 0 },
/* U+2878 */ { 30, 0, 19, 0, 0 },
/* U+2879 */ { 30, 0, 19, 0, 0 },
/* U+287a */ { 30, 0, 19, 0, 0 },
/* U+287b */ { 30, 0, 19, 0, 0 },
/* U+287c */ { 30, 0, 19, 0, 0 },
/* U+287d */ { 30, 0, 19, 0, 0 },
/* U+287e */ { 30, 0, 19, 0, 0 },
/* U+287f */ { 30, 0, 19, 0, 0 },
/* U+2880 */ { 30, 0, 19, 0, 0 },
/* U+2881 */ { 30, 0, 19, 0, 0 },
/* U+2882 */ { 30, 0, 19, 0, 0 },
/* U+2883 */ { 30, 0, 19, 0, 0 },
/* U+2884 */ { 30, 0, 19, 0, 0 },
/* U+2885 */ { 30, 0, 19, 0, 0 },
/* U+2886 */ { 30, 0, 19, 0, 0 },
/* U+2887 */ { 30, 0, 19, 0, 0 },
/* U+2888 */ { 30, 0, 19, 0, 0 },
/* U+2889 */ { 30, 0, 19, 0, 0 },
/* U+288a */ { 30, 0, 19, 0, 0 },
/* U+288b */ { 30, 0, 19, 0, 0 },
/* U+288c */ { 30, 0, 19, 0, 0 },
/* U+288d */ { 30, 0, 19, 0, 0 },
/* U+288e */ { 30, 0, 19, 0, 0 },
/* U+288f */ { 30, 0, 19, 0, 0 },
/* U+2890 */ { 30, 0, 19, 0, 0 },
/* U+2891 */ { 30, 0, 19, 0, 0 },
/* U+2892 */ { 30, 0, 19, 0, 0 },
/* U+2893 */ { 30, 0, 19, 0, 0 },
/* U+2894 */ { 30, 0, 19, 0, 0 },
/* U+2895 */ { 30, 0, 19, 0, 0 },
/* U+2896 */ { 30, 0, 19, 0, 0 },
/* U+2897 */ { 30, 0, 19, 0, 0 },
/* U+2898 */ { 30, 0, 19, 0, 0 },
/* U+2899 */ { 30, 0, 19, 0, 0 },
/* U+289a */ { 30, 0, 19, 0, 0 },
/* U+289b */ { 30, 0, 19, 0, 0 },
/* U+289c */ { 30, 0, 19, 0, 0 },
/* U+289d */ { 30, 0, 19, 0, 0 },
/* U+289e */ { 30, 0, 19, 0, 0 },
/* U+289f */ { 30, 0, 19, 0, 0 },
/* U+28a0 */ { 30, 0, 19, 0, 0 },
/* U+28a1 */ { 30, 0, 19, 0, 0 },
/* U+28a2 */ { 30, 0, 19, 0, 0 },
/* U+28a3 */ { 30, 0, 19, 0, 0 },
/* U+28a4 */ { 30, 0, 19, 0, 0 },
/* U+28a5 */ { 30, 0, 19, 0, 0 },
/* U+28a6 */ { 30, 0, 19, 0, 0 },
/* U+28a7 */ { 30, 0, 19, 0, 0 },
/* U+28a8 */ { 30, 0, 19, 0, 0 },
/* U+28a9 */ { 30, 0, 19, 0, 0 },
/* U+28aa */ { 30, 0, 19, 0, 0 },
/* U+28ab */ { 30, 0, 19, 0, 0 },
/* U+28ac */ { 30, 0, 19, 0, 0 },
/* U+28ad */ { 30, 0, 19, 0, 0 },
/* U+28ae */ { 30, 0, 19, 0, 0 },
/* U+28af */ { 30, 0, 19, 0, 0 },
/* U+28b0 */ { 30, 0, 19, 0, 0 },
/* U+28b1 */ { 30, 0, 19, 0, 0 },
/* U+28b2 */ { 30, 0, 19, 0, 0 },
/* U+28b3 */ { 30, 0, 19, 0, 0 },
/* U+28b4 */ { 30, 0, 19, 0, 0 },
/* U+28b5 */ { 30, 0, 19, 0, 0 },
/* U+28b6 */ { 30, 0, 19, 0, 0 },
/* U+28b7 */ { 30, 0, 19, 0, 0 },
/* U+28b8 */ { 30, 0, 19, 0, 0 },
/* U+28b9 */ { 30, 0, 19, 0, 0 },
/* U+28ba */ { 30, 0, 19, 0, 0 },
/* U+28bb */ { 30, 0, 19, 0, 0 },
/* U+28bc */ { 30, 0, 19, 0, 0 },
/* U+28bd */ { 30, 0, 19, 0, 0 },
/* U+28be */ { 30, 0, 19, 0, 0 },
/* U+28bf */ { 30, 0, 19, 0, 0 },
/* U+28c0 */ { 30, 0, 19, 0, 0 },
/* U+28c1 */ { 30, 0, 19, 0, 0 },
/* U+28c2 */ { 30, 0, 19, 0, 0 },
/* U+28c3 */ { 30, 0, 19, 0, 0 },
/* U+28c4 */ { 30, 0, 19, 0, 0 },
/* U+28c5 */ { 30, 0, 19, 0, 0 },
/* U+28c6 */ { 30, 0, 19, 0, 0 },
/* U+28c7 */ { 30, 0, 19, 0, 0 },
/* U+28c8 */ { 30, 0, 19, 0, 0 },
/* U+28c9 */ { 30, 0, 19, 0, 0 },
/* U+28ca */ { 30, 0, 19, 0, 0 },
/* U+28cb */ { 30, 0, 19, 0, 0 },
/* U+28cc */ { 30, 0, 19, 0, 0 },
/* U+28cd */ { 30, 0, 19, 0, 0 },
/* U+28ce */ { 30, 0, 19, 0, 0 },
/* U+28cf */ { 30, 0, 19, 0, 0 },
/* U+28d0 */ { 30, 0, 19, 0, 0 },
/* U+28d1 */ { 30, 0, 19, 0, 0 },
/* U+28d2 */ { 30, 0, 19, 0, 0 },
/* U+28d3 */ { 30, 0, 19, 0, 0 },
/* U+28d4 */ { 30, 0, 19, 0, 0 },
/* U+28d5 */ { 30, 0, 19, 0, 0 },
/* U+28d6 */ { 30, 0, 19, 0, 0 },
/* U+28d7 */ { 30, 0, 19, 0, 0 },
/* U+28d8 */ { 30, 0, 19, 0, 0 },
/* U+28d9 */ { 30, 0, 19, 0, 0 },
/* U+28da */ { 30, 0, 19, 0, 0 },
/* U+28db */ { 30, 0, 19, 0, 0 },
/* U+28dc */ { 30, 0, 19, 0, 0 },
/* U+28dd */ { 30, 0, 19, 0, 0 },
/* U+28de */ { 30, 0, 19, 0, 0 },
/* U+28df */ { 30, 0, 19, 0, 0 },
/* U+28e0 */ { 30, 0, 19, 0, 0 },
/* U+28e1 */ { 30, 0, 19, 0, 0 },
/* U+28e2 */ { 30, 0, 19, 0, 0 },
/* U+28e3 */ { 30, 0, 19, 0, 0 },
/* U+28e4 */ { 30, 0, 19, 0, 0 },
/* U+28e5 */ { 30, 0, 19, 0, 0 },
/* U+28e6 */ { 30, 0, 19, 0, 0 },
/* U+28e7 */ { 30, 0, 19, 0, 0 },
/* U+28e8 */ { 30, 0, 19, 0, 0 },
/* U+28e9 */ { 30, 0, 19, 0, 0 },
/* U+28ea */ { 30, 0, 19, 0, 0 },
/* U+28eb */ { 30, 0, 19, 0, 0 },
/* U+28ec */ { 30, 0, 19, 0, 0 },
/* U+28ed */ { 30, 0, 19, 0, 0 },
/* U+28ee */ { 30, 0, 19, 0, 0 },
/* U+28ef */ { 30, 0, 19, 0, 0 },
/* U+28f0 */ { 30, 0, 19, 0, 0 },
/* U+28f1 */ { 30, 0, 19, 0, 0 },
/* U+28f2 */ { 30, 0, 19, 0, 0 },
/* U+28f3 */ { 30, 0, 19, 0, 0 },
/* U+28f4 */ { 30, 0, 19, 0, 0 },
/* U+28f5 */ { 30, 0, 19, 0, 0 },
/* U+28f6 */ { 30, 0, 19, 0, 0 },
/* U+28f7 */ { 30, 0, 19, 0, 0 },
/* U+28f8 */ { 30, 0, 19, 0, 0 },
/* U+28f9 */ { 30, 0, 19, 0, 0 },
/* U+28fa */ { 30, 0, 19, 0, 0 },
/* U+28fb */ { 30, 0, 19, 0, 0 },
/* U+28fc */ { 30, 0, 19, 0, 0 },
/* U+28fd */ { 30, 0, 19, 0, 0 },
/* U+28fe */ { 30, 0, 19, 0, 0 },
/* U+28ff */ { 30, 0, 19, 0, 0 },
/* U+2900 */ { 0, 0, 0, 0, 0 },
/* U+2901 */ { 0, 0, 0, 0, 0 },
/* U+2902 */ { 0, 0, 0, 0, 0 },
/* U+2903 */ { 0, 0, 0, 0, 0 },
/* U+2904 */ { 0, 0, 0, 0, 0 },
/* U+2905 */ { 0, 0, 0, 0, 0 },
/* U+2906 */ { 0, 0, 0, 0, 0 },
/* U+2907 */ { 0, 0, 0, 0, 0 },
/* U+2908 */ { 0, 0, 0, 0, 0 },
/* U+2909 */ { 0, 0, 0, 0, 0 },
/* U+290a */ { 0, 0, 0, 0, 0 },
/* U+290b */ { 0, 0, 0, 0, 0 },
/* U+290c */ { 0, 0, 0, 0, 0 },
/* U+290d */ { 0, 0, 0, 0, 0 },
/* U+290e */ { 0, 0, 0, 0, 0 },
/* U+290f */ { 0, 0, 0, 0, 0 },
/* U+2910 */ { 0, 0, 0, 0, 0 },
/* U+2911 */ { 0, 0, 0, 0, 0 },
/* U+2912 */ { 0, 0, 0, 0, 0 },
/* U+2913 */ { 0, 0, 0, 0, 0 },
/* U+2914 */ { 0, 0, 0, 0, 0 },
/* U+2915 */ { 0, 0, 0, 0, 0 },
/* U+2916 */ { 0, 0, 0, 0, 0 },
/* U+2917 */ { 0, 0, 0, 0, 0 },
/* U+2918 */ { 0, 0, 0, 0, 0 },
/* U+2919 */ { 0, 0, 0, 0, 0 },
/* U+291a */ { 0, 0, 0, 0, 0 },
/* U+291b */ { 0, 0, 0, 0, 0 },
/* U+291c */ { 0, 0, 0, 0, 0 },
/* U+291d */ { 0, 0, 0, 0, 0 },
/* U+291e */ { 0, 0, 0, 0, 0 },
/* U+291f */ { 0, 0, 0, 0, 0 },
/* U+2920 */ { 0, 0, 0, 0, 0 },
/* U+2921 */ { 0, 0, 0, 0, 0 },
/* U+2922 */ { 0, 0, 0, 0, 0 },
/* U+2923 */ { 0, 0, 0, 0, 0 },
/* U+2924 */ { 0, 0, 0, 0, 0 },
/* U+2925 */ { 0, 0, 0, 0, 0 },
/* U+2926 */ { 0, 0, 0, 0, 0 },
/* U+2927 */ { 0, 0, 0, 0, 0 },
/* U+2928 */ { 0, 0, 0, 0, 0 },
/* U+2929 */ { 0, 0, 0, 0, 0 },
/* U+292a */ { 0, 0, 0, 0, 0 },
/* U+292b */ { 0, 0, 0, 0, 0 },
/* U+292c */ { 0, 0, 0, 0, 0 },
/* U+292d */ { 0, 0, 0, 0, 0 },
/* U+292e */ { 0, 0, 0, 0, 0 },
/* U+292f */ { 0, 0, 0, 0, 0 },
/* U+2930 */ { 0, 0, 0, 0, 0 },
/* U+2931 */ { 0, 0, 0, 0, 0 },
/* U+2932 */ { 0, 0, 0, 0, 0 },
/* U+2933 */ { 0, 0, 0, 0, 0 },
/* U+2934 */ { 0, 0, 0, 0, 0 },
/* U+2935 */ { 0, 0, 0, 0, 0 },
/* U+2936 */ { 0, 0, 0, 0, 0 },
/* U+2937 */ { 0, 0, 0, 0, 0 },
/* U+2938 */ { 0, 0, 0, 0, 0 },
/* U+2939 */ { 0, 0, 0, 0, 0 },
/* U+293a */ { 0, 0, 0, 0, 0 },
/* U+293b */ { 0, 0, 0, 0, 0 },
/* U+293c */ { 0, 0, 0, 0, 0 },
/* U+293d */ { 0, 0, 0, 0, 0 },
/* U+293e */ { 0, 0, 0, 0, 0 },
/* U+293f */ { 0, 0, 0, 0, 0 },
/* U+2940 */ { 0, 0, 0, 0, 0 },
/* U+2941 */ { 0, 0, 0, 0, 0 },
/* U+2942 */ { 0, 0, 0, 0, 0 },
/* U+2943 */ { 0, 0, 0, 0, 0 },
/* U+2944 */ { 0, 0, 0, 0, 0 },
/* U+2945 */ { 0, 0, 0, 0, 0 },
/* U+2946 */ { 0, 0, 0, 0, 0 },
/* U+2947 */ { 0, 0, 0, 0, 0 },
/* U+2948 */ { 0, 0, 0, 0, 0 },
/* U+2949 */ { 0, 0, 0, 0, 0 },
/* U+294a */ { 0, 0, 0, 0, 0 },
/* U+294b */ { 0, 0, 0, 0, 0 },
/* U+294c */ { 0, 0, 0, 0, 0 },
/* U+294d */ { 0, 0, 0, 0, 0 },
/* U+294e */ { 0, 0, 0, 0, 0 },
/* U+294f */ { 0, 0, 0, 0, 0 },
/* U+2950 */ { 0, 0, 0, 0, 0 },
/* U+2951 */ { 0, 0, 0, 0, 0 },
/* U+2952 */ { 0, 0, 0, 0, 0 },
/* U+2953 */ { 0, 0, 0, 0, 0 },
/* U+2954 */ { 0, 0, 0, 0, 0 },
/* U+2955 */ { 0, 0, 0, 0, 0 },
/* U+2956 */ { 0, 0, 0, 0, 0 },
/* U+2957 */ { 0, 0, 0, 0, 0 },
/* U+2958 */ { 0, 0, 0, 0, 0 },
/* U+2959 */ { 0, 0, 0, 0, 0 },
/* U+295a */ { 0, 0, 0, 0, 0 },
/* U+295b */ { 0, 0, 0, 0, 0 },
/* U+295c */ { 0, 0, 0, 0, 0 },
/* U+295d */ { 0, 0, 0, 0, 0 },
/* U+295e */ { 0, 0, 0, 0, 0 },
/* U+295f */ { 0, 0, 0, 0, 0 },
/* U+2960 */ { 0, 0, 0, 0, 0 },
/* U+2961 */ { 0, 0, 0, 0, 0 },
/* U+2962 */ { 0, 0, 0, 0, 0 },
/* U+2963 */ { 0, 0, 0, 0, 0 },
/* U+2964 */ { 0, 0, 0, 0, 0 },
/* U+2965 */ { 0, 0, 0, 0, 0 },
/* U+2966 */ { 0, 0, 0, 0, 0 },
/* U+2967 */ { 0, 0, 0, 0, 0 },
/* U+2968 */ { 0, 0, 0, 0, 0 },
/* U+2969 */ { 0, 0, 0, 0, 0 },
/* U+296a */ { 0, 0, 0, 0, 0 },
/* U+296b */ { 0, 0, 0, 0, 0 },
/* U+296c */ { 0, 0, 0, 0, 0 },
/* U+296d */ { 0, 0, 0, 0, 0 },
/* U+296e */ { 0, 0, 0, 0, 0 },
/* U+296f */ { 0, 0, 0, 0, 0 },
/* U+2970 */ { 0, 0, 0, 0, 0 },
/* U+2971 */ { 0, 0, 0, 0, 0 },
/* U+2972 */ { 0, 0, 0, 0, 0 },
/* U+2973 */ { 0, 0, 0, 0, 0 },
/* U+2974 */ { 0, 0, 0, 0, 0 },
/* U+2975 */ { 0, 0, 0, 0, 0 },
/* U+2976 */ { 0, 0, 0, 0, 0 },
/* U+2977 */ { 0, 0, 0, 0, 0 },
/* U+2978 */ { 0, 0, 0, 0, 0 },
/* U+2979 */ { 0, 0, 0, 0, 0 },
/* U+297a */ { 0, 0, 0, 0, 0 },
/* U+297b */ { 0, 0, 0, 0, 0 },
/* U+297c */ { 0, 0, 0, 0, 0 },
/* U+297d */ { 0, 0, 0, 0, 0 },
/* U+297e */ { 0, 0, 0, 0, 0 },
/* U+297f */ { 0, 0, 0, 0, 0 },
/* U+2980 */ { 0, 0, 0, 0, 0 },
/* U+2981 */ { 0, 0, 0, 0, 0 },
/* U+2982 */ { 0, 0, 0, 0, 0 },
/* U+2983 */ { 0, 0, 0, 0, 0 },
/* U+2984 */ { 0, 0, 0, 0, 0 },
/* U+2985 */ { 0, 0, 0, 0, 0 },
/* U+2986 */ { 0, 0, 0, 0, 0 },
/* U+2987 */ { 0, 0, 0, 0, 0 },
/* U+2988 */ { 0, 0, 0, 0, 0 },
/* U+2989 */ { 0, 0, 0, 0, 0 },
/* U+298a */ { 0, 0, 0, 0, 0 },
/* U+298b */ { 0, 0, 0, 0, 0 },
/* U+298c */ { 0, 0, 0, 0, 0 },
/* U+298d */ { 0, 0, 0, 0, 0 },
/* U+298e */ { 0, 0, 0, 0, 0 },
/* U+298f */ { 0, 0, 0, 0, 0 },
/* U+2990 */ { 0, 0, 0, 0, 0 },
/* U+2991 */ { 0, 0, 0, 0, 0 },
/* U+2992 */ { 0, 0, 0, 0, 0 },
/* U+2993 */ { 0, 0, 0, 0, 0 },
/* U+2994 */ { 0, 0, 0, 0, 0 },
/* U+2995 */ { 0, 0, 0, 0, 0 },
/* U+2996 */ { 0, 0, 0, 0, 0 },
/* U+2997 */ { 0, 0, 0, 0, 0 },
/* U+2998 */ { 0, 0, 0, 0, 0 },
/* U+2999 */ { 0, 0, 0, 0, 0 },
/* U+299a */ { 0, 0, 0, 0, 0 },
/* U+299b */ { 0, 0, 0, 0, 0 },
/* U+299c */ { 0, 0, 0, 0, 0 },
/* U+299d */ { 0, 0, 0, 0, 0 },
/* U+299e */ { 0, 0, 0, 0, 0 },
/* U+299f */ { 0, 0, 0, 0, 0 },
/* U+29a0 */ { 0, 0, 0, 0, 0 },
/* U+29a1 */ { 0, 0, 0, 0, 0 },
/* U+29a2 */ { 0, 0, 0, 0, 0 },
/* U+29a3 */ { 0, 0, 0, 0, 0 },
/* U+29a4 */ { 0, 0, 0, 0, 0 },
/* U+29a5 */ { 0, 0, 0, 0, 0 },
/* U+29a6 */ { 0, 0, 0, 0, 0 },
/* U+29a7 */ { 0, 0, 0, 0, 0 },
/* U+29a8 */ { 0, 0, 0, 0, 0 },
/* U+29a9 */ { 0, 0, 0, 0, 0 },
/* U+29aa */ { 0, 0, 0, 0, 0 },
/* U+29ab */ { 0, 0, 0, 0, 0 },
/* U+29ac */ { 0, 0, 0, 0, 0 },
/* U+29ad */ { 0, 0, 0, 0, 0 },
/* U+29ae */ { 0, 0, 0, 0, 0 },
/* U+29af */ { 0, 0, 0, 0, 0 },
/* U+29b0 */ { 0, 0, 0, 0, 0 },
/* U+29b1 */ { 0, 0, 0, 0, 0 },
/* U+29b2 */ { 0, 0, 0, 0, 0 },
/* U+29b3 */ { 0, 0, 0, 0, 0 },
/* U+29b4 */ { 0, 0, 0, 0, 0 },
/* U+29b5 */ { 0, 0, 0, 0, 0 },
/* U+29b6 */ { 0, 0, 0, 0, 0 },
/* U+29b7 */ { 0, 0, 0, 0, 0 },
/* U+29b8 */ { 0, 0, 0, 0, 0 },
/* U+29b9 */ { 0, 0, 0, 0, 0 },
/* U+29ba */ { 0, 0, 0, 0, 0 },
/* U+29bb */ { 0, 0, 0, 0, 0 },
/* U+29bc */ { 0, 0, 0, 0, 0 },
/* U+29bd */ { 0, 0, 0, 0, 0 },
/* U+29be */ { 0, 0, 0, 0, 0 },
/* U+29bf */ { 0, 0, 0, 0, 0 },
/* U+29c0 */ { 0, 0, 0, 0, 0 },
/* U+29c1 */ { 0, 0, 0, 0, 0 },
/* U+29c2 */ { 0, 0, 0, 0, 0 },
/* U+29c3 */ { 0, 0, 0, 0, 0 },
/* U+29c4 */ { 0, 0, 0, 0, 0 },
/* U+29c5 */ { 0, 0, 0, 0, 0 },
/* U+29c6 */ { 0, 0, 0, 0, 0 },
/* U+29c7 */ { 0, 0, 0, 0, 0 },
/* U+29c8 */ { 0, 0, 0, 0, 0 },
/* U+29c9 */ { 0, 0, 0, 0, 0 },
/* U+29ca */ { 0, 0, 0, 0, 0 },
/* U+29cb */ { 0, 0, 0, 0, 0 },
/* U+29cc */ { 0, 0, 0, 0, 0 },
/* U+29cd */ { 0, 0, 0, 0, 0 },
/* U+29ce */ { 0, 0, 0, 0, 0 },
/* U+29cf */ { 0, 0, 0, 0, 0 },
/* U+29d0 */ { 0, 0, 0, 0, 0 },
/* U+29d1 */ { 0, 0, 0, 0, 0 },
/* U+29d2 */ { 0, 0, 0, 0, 0 },
/* U+29d3 */ { 0, 0, 0, 0, 0 },
/* U+29d4 */ { 0, 0, 0, 0, 0 },
/* U+29d5 */ { 0, 0, 0, 0, 0 },
/* U+29d6 */ { 0, 0, 0, 0, 0 },
/* U+29d7 */ { 0, 0, 0, 0, 0 },
/* U+29d8 */ { 0, 0, 0, 0, 0 },
/* U+29d9 */ { 0, 0, 0, 0, 0 },
/* U+29da */ { 0, 0, 0, 0, 0 },
/* U+29db */ { 0, 0, 0, 0, 0 },
/* U+29dc */ { 0, 0, 0, 0, 0 },
/* U+29dd */ { 0, 0, 0, 0, 0 },
/* U+29de */ { 0, 0, 0, 0, 0 },
/* U+29df */ { 0, 0, 0, 0, 0 },
/* U+29e0 */ { 0, 0, 0, 0, 0 },
/* U+29e1 */ { 0, 0, 0, 0, 0 },
/* U+29e2 */ { 0, 0, 0, 0, 0 },
/* U+29e3 */ { 0, 0, 0, 0, 0 },
/* U+29e4 */ { 0, 0, 0, 0, 0 },
/* U+29e5 */ { 0, 0, 0, 0, 0 },
/* U+29e6 */ { 0, 0, 0, 0, 0 },
/* U+29e7 */ { 0, 0, 0, 0, 0 },
/* U+29e8 */ { 0, 0, 0, 0, 0 },
/* U+29e9 */ { 0, 0, 0, 0, 0 },
/* U+29ea */ { 0, 0, 0, 0, 0 },
/* U+29eb */ { 0, 0, 0, 0, 0 },
/* U+29ec */ { 0, 0, 0, 0, 0 },
/* U+29ed */ { 0, 0, 0, 0, 0 },
/* U+29ee */ { 0, 0, 0, 0, 0 },
/* U+29ef */ { 0, 0, 0, 0, 0 },
/* U+29f0 */ { 0, 0, 0, 0, 0 },
/* U+29f1 */ { 0, 0, 0, 0, 0 },
/* U+29f2 */ { 0, 0, 0, 0, 0 },
/* U+29f3 */ { 0, 0, 0, 0, 0 },
/* U+29f4 */ { 0, 0, 0, 0, 0 },
/* U+29f5 */ { 0, 0, 0, 0, 0 },
/* U+29f6 */ { 0, 0, 0, 0, 0 },
/* U+29f7 */ { 0, 0, 0, 0, 0 },
/* U+29f8 */ { 0, 0, 0, 0, 0 },
/* U+29f9 */ { 0, 0, 0, 0, 0 },
/* U+29fa */ { 0, 0, 0, 0, 0 },
/* U+29fb */ { 0, 0, 0, 0, 0 },
/* U+29fc */ { 0, 0, 0, 0, 0 },
/* U+29fd */ { 0, 0, 0, 0, 0 },
/* U+29fe */ { 0, 0, 0, 0, 0 },
/* U+29ff */ { 0, 0, 0, 0, 0 },
/* U+2a00 */ { 0, 0, 0, 0, 0 },
/* U+2a01 */ { 0, 0, 0, 0, 0 },
/* U+2a02 */ { 0, 0, 0, 0, 0 },
/* U+2a03 */ { 0, 0, 0, 0, 0 },
/* U+2a04 */ { 0, 0, 0, 0, 0 },
/* U+2a05 */ { 0, 0, 0, 0, 0 },
/* U+2a06 */ { 0, 0, 0, 0, 0 },
/* U+2a07 */ { 0, 0, 0, 0, 0 },
/* U+2a08 */ { 0, 0, 0, 0, 0 },
/* U+2a09 */ { 0, 0, 0, 0, 0 },
/* U+2a0a */ { 0, 0, 0, 0, 0 },
/* U+2a0b */ { 0, 0, 0, 0, 0 },
/* U+2a0c */ { 0, 0, 0, 0, 0 },
/* U+2a0d */ { 0, 0, 0, 0, 0 },
/* U+2a0e */ { 0, 0, 0, 0, 0 },
/* U+2a0f */ { 0, 0, 0, 0, 0 },
/* U+2a10 */ { 0, 0, 0, 0, 0 },
/* U+2a11 */ { 0, 0, 0, 0, 0 },
/* U+2a12 */ { 0, 0, 0, 0, 0 },
/* U+2a13 */ { 0, 0, 0, 0, 0 },
/* U+2a14 */ { 0, 0, 0, 0, 0 },
/* U+2a15 */ { 0, 0, 0, 0, 0 },
/* U+2a16 */ { 0, 0, 0, 0, 0 },
/* U+2a17 */ { 0, 0, 0, 0, 0 },
/* U+2a18 */ { 0, 0, 0, 0, 0 },
/* U+2a19 */ { 0, 0, 0, 0, 0 },
/* U+2a1a */ { 0, 0, 0, 0, 0 },
/* U+2a1b */ { 0, 0, 0, 0, 0 },
/* U+2a1c */ { 0, 0, 0, 0, 0 },
/* U+2a1d */ { 0, 0, 0, 0, 0 },
/* U+2a1e */ { 0, 0, 0, 0, 0 },
/* U+2a1f */ { 0, 0, 0, 0, 0 },
/* U+2a20 */ { 0, 0, 0, 0, 0 },
/* U+2a21 */ { 0, 0, 0, 0, 0 },
/* U+2a22 */ { 0, 0, 0, 0, 0 },
/* U+2a23 */ { 0, 0, 0, 0, 0 },
/* U+2a24 */ { 0, 0, 0, 0, 0 },
/* U+2a25 */ { 0, 0, 0, 0, 0 },
/* U+2a26 */ { 0, 0, 0, 0, 0 },
/* U+2a27 */ { 0, 0, 0, 0, 0 },
/* U+2a28 */ { 0, 0, 0, 0, 0 },
/* U+2a29 */ { 0, 0, 0, 0, 0 },
/* U+2a2a */ { 0, 0, 0, 0, 0 },
/* U+2a2b */ { 0, 0, 0, 0, 0 },
/* U+2a2c */ { 0, 0, 0, 0, 0 },
/* U+2a2d */ { 0, 0, 0, 0, 0 },
/* U+2a2e */ { 0, 0, 0, 0, 0 },
/* U+2a2f */ { 0, 0, 0, 0, 0 },
/* U+2a30 */ { 0, 0, 0, 0, 0 },
/* U+2a31 */ { 0, 0, 0, 0, 0 },
/* U+2a32 */ { 0, 0, 0, 0, 0 },
/* U+2a33 */ { 0, 0, 0, 0, 0 },
/* U+2a34 */ { 0, 0, 0, 0, 0 },
/* U+2a35 */ { 0, 0, 0, 0, 0 },
/* U+2a36 */ { 0, 0, 0, 0, 0 },
/* U+2a37 */ { 0, 0, 0, 0, 0 },
/* U+2a38 */ { 0, 0, 0, 0, 0 },
/* U+2a39 */ { 0, 0, 0, 0, 0 },
/* U+2a3a */ { 0, 0, 0, 0, 0 },
/* U+2a3b */ { 0, 0, 0, 0, 0 },
/* U+2a3c */ { 0, 0, 0, 0, 0 },
/* U+2a3d */ { 0, 0, 0, 0, 0 },
/* U+2a3e */ { 0, 0, 0, 0, 0 },
/* U+2a3f */ { 0, 0, 0, 0, 0 },
/* U+2a40 */ { 0, 0, 0, 0, 0 },
/* U+2a41 */ { 0, 0, 0, 0, 0 },
/* U+2a42 */ { 0, 0, 0, 0, 0 },
/* U+2a43 */ { 0, 0, 0, 0, 0 },
/* U+2a44 */ { 0, 0, 0, 0, 0 },
/* U+2a45 */ { 0, 0, 0, 0, 0 },
/* U+2a46 */ { 0, 0, 0, 0, 0 },
/* U+2a47 */ { 0, 0, 0, 0, 0 },
/* U+2a48 */ { 0, 0, 0, 0, 0 },
/* U+2a49 */ { 0, 0, 0, 0, 0 },
/* U+2a4a */ { 0, 0, 0, 0, 0 },
/* U+2a4b */ { 0, 0, 0, 0, 0 },
/* U+2a4c */ { 0, 0, 0, 0, 0 },
/* U+2a4d */ { 0, 0, 0, 0, 0 },
/* U+2a4e */ { 0, 0, 0, 0, 0 },
/* U+2a4f */ { 0, 0, 0, 0, 0 },
/* U+2a50 */ { 0, 0, 0, 0, 0 },
/* U+2a51 */ { 0, 0, 0, 0, 0 },
/* U+2a52 */ { 0, 0, 0, 0, 0 },
/* U+2a53 */ { 0, 0, 0, 0, 0 },
/* U+2a54 */ { 0, 0, 0, 0, 0 },
/* U+2a55 */ { 0, 0, 0, 0, 0 },
/* U+2a56 */ { 0, 0, 0, 0, 0 },
/* U+2a57 */ { 0, 0, 0, 0, 0 },
/* U+2a58 */ { 0, 0, 0, 0, 0 },
/* U+2a59 */ { 0, 0, 0, 0, 0 },
/* U+2a5a */ { 0, 0, 0, 0, 0 },
/* U+2a5b */ { 0, 0, 0, 0, 0 },
/* U+2a5c */ { 0, 0, 0, 0, 0 },
/* U+2a5d */ { 0, 0, 0, 0, 0 },
/* U+2a5e */ { 0, 0, 0, 0, 0 },
/* U+2a5f */ { 0, 0, 0, 0, 0 },
/* U+2a60 */ { 0, 0, 0, 0, 0 },
/* U+2a61 */ { 0, 0, 0, 0, 0 },
/* U+2a62 */ { 0, 0, 0, 0, 0 },
/* U+2a63 */ { 0, 0, 0, 0, 0 },
/* U+2a64 */ { 0, 0, 0, 0, 0 },
/* U+2a65 */ { 0, 0, 0, 0, 0 },
/* U+2a66 */ { 0, 0, 0, 0, 0 },
/* U+2a67 */ { 0, 0, 0, 0, 0 },
/* U+2a68 */ { 0, 0, 0, 0, 0 },
/* U+2a69 */ { 0, 0, 0, 0, 0 },
/* U+2a6a */ { 0, 0, 0, 0, 0 },
/* U+2a6b */ { 0, 0, 0, 0, 0 },
/* U+2a6c */ { 0, 0, 0, 0, 0 },
/* U+2a6d */ { 0, 0, 0, 0, 0 },
/* U+2a6e */ { 0, 0, 0, 0, 0 },
/* U+2a6f */ { 0, 0, 0, 0, 0 },
/* U+2a70 */ { 0, 0, 0, 0, 0 },
/* U+2a71 */ { 0, 0, 0, 0, 0 },
/* U+2a72 */ { 0, 0, 0, 0, 0 },
/* U+2a73 */ { 0, 0, 0, 0, 0 },
/* U+2a74 */ { 0, 0, 0, 0, 0 },
/* U+2a75 */ { 0, 0, 0, 0, 0 },
/* U+2a76 */ { 0, 0, 0, 0, 0 },
/* U+2a77 */ { 0, 0, 0, 0, 0 },
/* U+2a78 */ { 0, 0, 0, 0, 0 },
/* U+2a79 */ { 0, 0, 0, 0, 0 },
/* U+2a7a */ { 0, 0, 0, 0, 0 },
/* U+2a7b */ { 0, 0, 0, 0, 0 },
/* U+2a7c */ { 0, 0, 0, 0, 0 },
/* U+2a7d */ { 0, 0, 0, 0, 0 },
/* U+2a7e */ { 0, 0, 0, 0, 0 },
/* U+2a7f */ { 0, 0, 0, 0, 0 },
/* U+2a80 */ { 0, 0, 0, 0, 0 },
/* U+2a81 */ { 0, 0, 0, 0, 0 },
/* U+2a82 */ { 0, 0, 0, 0, 0 },
/* U+2a83 */ { 0, 0, 0, 0, 0 },
/* U+2a84 */ { 0, 0, 0, 0, 0 },
/* U+2a85 */ { 0, 0, 0, 0, 0 },
/* U+2a86 */ { 0, 0, 0, 0, 0 },
/* U+2a87 */ { 0, 0, 0, 0, 0 },
/* U+2a88 */ { 0, 0, 0, 0, 0 },
/* U+2a89 */ { 0, 0, 0, 0, 0 },
/* U+2a8a */ { 0, 0, 0, 0, 0 },
/* U+2a8b */ { 0, 0, 0, 0, 0 },
/* U+2a8c */ { 0, 0, 0, 0, 0 },
/* U+2a8d */ { 0, 0, 0, 0, 0 },
/* U+2a8e */ { 0, 0, 0, 0, 0 },
/* U+2a8f */ { 0, 0, 0, 0, 0 },
/* U+2a90 */ { 0, 0, 0, 0, 0 },
/* U+2a91 */ { 0, 0, 0, 0, 0 },
/* U+2a92 */ { 0, 0, 0, 0, 0 },
/* U+2a93 */ { 0, 0, 0, 0, 0 },
/* U+2a94 */ { 0, 0, 0, 0, 0 },
/* U+2a95 */ { 0, 0, 0, 0, 0 },
/* U+2a96 */ { 0, 0, 0, 0, 0 },
/* U+2a97 */ { 0, 0, 0, 0, 0 },
/* U+2a98 */ { 0, 0, 0, 0, 0 },
/* U+2a99 */ { 0, 0, 0, 0, 0 },
/* U+2a9a */ { 0, 0, 0, 0, 0 },
/* U+2a9b */ { 0, 0, 0, 0, 0 },
/* U+2a9c */ { 0, 0, 0, 0, 0 },
/* U+2a9d */ { 0, 0, 0, 0, 0 },
/* U+2a9e */ { 0, 0, 0, 0, 0 },
/* U+2a9f */ { 0, 0, 0, 0, 0 },
/* U+2aa0 */ { 0, 0, 0, 0, 0 },
/* U+2aa1 */ { 0, 0, 0, 0, 0 },
/* U+2aa2 */ { 0, 0, 0, 0, 0 },
/* U+2aa3 */ { 0, 0, 0, 0, 0 },
/* U+2aa4 */ { 0, 0, 0, 0, 0 },
/* U+2aa5 */ { 0, 0, 0, 0, 0 },
/* U+2aa6 */ { 0, 0, 0, 0, 0 },
/* U+2aa7 */ { 0, 0, 0, 0, 0 },
/* U+2aa8 */ { 0, 0, 0, 0, 0 },
/* U+2aa9 */ { 0, 0, 0, 0, 0 },
/* U+2aaa */ { 0, 0, 0, 0, 0 },
/* U+2aab */ { 0, 0, 0, 0, 0 },
/* U+2aac */ { 0, 0, 0, 0, 0 },
/* U+2aad */ { 0, 0, 0, 0, 0 },
/* U+2aae */ { 0, 0, 0, 0, 0 },
/* U+2aaf */ { 0, 0, 0, 0, 0 },
/* U+2ab0 */ { 0, 0, 0, 0, 0 },
/* U+2ab1 */ { 0, 0, 0, 0, 0 },
/* U+2ab2 */ { 0, 0, 0, 0, 0 },
/* U+2ab3 */ { 0, 0, 0, 0, 0 },
/* U+2ab4 */ { 0, 0, 0, 0, 0 },
/* U+2ab5 */ { 0, 0, 0, 0, 0 },
/* U+2ab6 */ { 0, 0, 0, 0, 0 },
/* U+2ab7 */ { 0, 0, 0, 0, 0 },
/* U+2ab8 */ { 0, 0, 0, 0, 0 },
/* U+2ab9 */ { 0, 0, 0, 0, 0 },
/* U+2aba */ { 0, 0, 0, 0, 0 },
/* U+2abb */ { 0, 0, 0, 0, 0 },
/* U+2abc */ { 0, 0, 0, 0, 0 },
/* U+2abd */ { 0, 0, 0, 0, 0 },
/* U+2abe */ { 0, 0, 0, 0, 0 },
/* U+2abf */ { 0, 0, 0, 0, 0 },
/* U+2ac0 */ { 0, 0, 0, 0, 0 },
/* U+2ac1 */ { 0, 0, 0, 0, 0 },
/* U+2ac2 */ { 0, 0, 0, 0, 0 },
/* U+2ac3 */ { 0, 0, 0, 0, 0 },
/* U+2ac4 */ { 0, 0, 0, 0, 0 },
/* U+2ac5 */ { 0, 0, 0, 0, 0 },
/* U+2ac6 */ { 0, 0, 0, 0, 0 },
/* U+2ac7 */ { 0, 0, 0, 0, 0 },
/* U+2ac8 */ { 0, 0, 0, 0, 0 },
/* U+2ac9 */ { 0, 0, 0, 0, 0 },
/* U+2aca */ { 0, 0, 0, 0, 0 },
/* U+2acb */ { 0, 0, 0, 0, 0 },
/* U+2acc */ { 0, 0, 0, 0, 0 },
/* U+2acd */ { 0, 0, 0, 0, 0 },
/* U+2ace */ { 0, 0, 0, 0, 0 },
/* U+2acf */ { 0, 0, 0, 0, 0 },
/* U+2ad0 */ { 0, 0, 0, 0, 0 },
/* U+2ad1 */ { 0, 0, 0, 0, 0 },
/* U+2ad2 */ { 0, 0, 0, 0, 0 },
/* U+2ad3 */ { 0, 0, 0, 0, 0 },
/* U+2ad4 */ { 0, 0, 0, 0, 0 },
/* U+2ad5 */ { 0, 0, 0, 0, 0 },
/* U+2ad6 */ { 0, 0, 0, 0, 0 },
/* U+2ad7 */ { 0, 0, 0, 0, 0 },
/* U+2ad8 */ { 0, 0, 0, 0, 0 },
/* U+2ad9 */ { 0, 0, 0, 0, 0 },
/* U+2ada */ { 0, 0, 0, 0, 0 },
/* U+2adb */ { 0, 0, 0, 0, 0 },
/* U+2adc */ { 0, 0, 0, 0, 0 },
/* U+2add */ { 0, 0, 0, 0, 0 },
/* U+2ade */ { 0, 0, 0, 0, 0 },
/* U+2adf */ { 0, 0, 0, 0, 0 },
/* U+2ae0 */ { 0, 0, 0, 0, 0 },
/* U+2ae1 */ { 0, 0, 0, 0, 0 },
/* U+2ae2 */ { 0, 0, 0, 0, 0 },
/* U+2ae3 */ { 0, 0, 0, 0, 0 },
/* U+2ae4 */ { 0, 0, 0, 0, 0 },
/* U+2ae5 */ { 0, 0, 0, 0, 0 },
/* U+2ae6 */ { 0, 0, 0, 0, 0 },
/* U+2ae7 */ { 0, 0, 0, 0, 0 },
/* U+2ae8 */ { 0, 0, 0, 0, 0 },
/* U+2ae9 */ { 0, 0, 0, 0, 0 },
/* U+2aea */ { 0, 0, 0, 0, 0 },
/* U+2aeb */ { 0, 0, 0, 0, 0 },
/* U+2aec */ { 0, 0, 0, 0, 0 },
/* U+2aed */ { 0, 0, 0, 0, 0 },
/* U+2aee */ { 0, 0, 0, 0, 0 },
/* U+2aef */ { 0, 0, 0, 0, 0 },
/* U+2af0 */ { 0, 0, 0, 0, 0 },
/* U+2af1 */ { 0, 0, 0, 0, 0 },
/* U+2af2 */ { 0, 0, 0, 0, 0 },
/* U+2af3 */ { 0, 0, 0, 0, 0 },
/* U+2af4 */ { 0, 0, 0, 0, 0 },
/* U+2af5 */ { 0, 0, 0, 0, 0 },
/* U+2af6 */ { 0, 0, 0, 0, 0 },
/* U+2af7 */ { 0, 0, 0, 0, 0 },
/* U+2af8 */ { 0, 0, 0, 0, 0 },
/* U+2af9 */ { 0, 0, 0, 0, 0 },
/* U+2afa */ { 0, 0, 0, 0, 0 },
/* U+2afb */ { 0, 0, 0, 0, 0 },
/* U+2afc */ { 0, 0, 0, 0, 0 },
/* U+2afd */ { 0, 0, 0, 0, 0 },
/* U+2afe */ { 0, 0, 0, 0, 0 },
/* U+2aff */ { 0, 0, 0, 0, 0 },
/* U+2b00 */ { 0, 0, 0, 0, 0 },
/* U+2b01 */ { 0, 0, 0, 0, 0 },
/* U+2b02 */ { 0, 0, 0, 0, 0 },
/* U+2b03 */ { 0, 0, 0, 0, 0 },
/* U+2b04 */ { 0, 0, 0, 0, 0 },
/* U+2b05 */ { 0, 0, 0, 0, 0 },
/* U+2b06 */ { 0, 0, 0, 0, 0 },
/* U+2b07 */ { 0, 0, 0, 0, 0 },
/* U+2b08 */ { 0, 0, 0, 0, 0 },
/* U+2b09 */ { 0, 0, 0, 0, 0 },
/* U+2b0a */ { 0, 0, 0, 0, 0 },
/* U+2b0b */ { 0, 0, 0, 0, 0 },
/* U+2b0c */ { 0, 0, 0, 0, 0 },
/* U+2b0d */ { 0, 0, 0, 0, 0 },
/* U+2b0e */ { 0, 0, 0, 0, 0 },
/* U+2b0f */ { 0, 0, 0, 0, 0 },
/* U+2b10 */ { 0, 0, 0, 0, 0 },
/* U+2b11 */ { 0, 0, 0, 0, 0 },
/* U+2b12 */ { 0, 0, 0, 0, 0 },
/* U+2b13 */ { 0, 0, 0, 0, 0 },
/* U+2b14 */ { 0, 0, 0, 0, 0 },
/* U+2b15 */ { 0, 0, 0, 0, 0 },
/* U+2b16 */ { 0, 0, 0, 0, 0 },
/* U+2b17 */ { 0, 0, 0, 0, 0 },
/* U+2b18 */ { 0, 0, 0, 0, 0 },
/* U+2b19 */ { 0, 0, 0, 0, 0 },
/* U+2b1a */ { 0, 0, 0, 0, 0 },
/* U+2b1b */ { 0, 0, 0, 0, 0 },
/* U+2b1c */ { 0, 0, 0, 0, 0 },
/* U+2b1d */ { 0, 0, 0, 0, 0 },
/* U+2b1e */ { 0, 0, 0, 0, 0 },
/* U+2b1f */ { 0, 0, 0, 0, 0 },
/* U+2b20 */ { 0, 0, 0, 0, 0 },
/* U+2b21 */ { 0, 0, 0, 0, 0 },
/* U+2b22 */ { 0, 0, 0, 0, 0 },
/* U+2b23 */ { 0, 0, 0, 0, 0 },
/* U+2b24 */ { 0, 0, 0, 0, 0 },
/* U+2b25 */ { 0, 0, 0, 0, 0 },
/* U+2b26 */ { 0, 0, 0, 0, 0 },
/* U+2b27 */ { 0, 0, 0, 0, 0 },
/* U+2b28 */ { 0, 0, 0, 0, 0 },
/* U+2b29 */ { 0, 0, 0, 0, 0 },
/* U+2b2a */ { 0, 0, 0, 0, 0 },
/* U+2b2b */ { 0, 0, 0, 0, 0 },
/* U+2b2c */ { 0, 0, 0, 0, 0 },
/* U+2b2d */ { 0, 0, 0, 0, 0 },
/* U+2b2e */ { 0, 0, 0, 0, 0 },
/* U+2b2f */ { 0, 0, 0, 0, 0 },
/* U+2b30 */ { 0, 0, 0, 0, 0 },
/* U+2b31 */ { 0, 0, 0, 0, 0 },
/* U+2b32 */ { 0, 0, 0, 0, 0 },
/* U+2b33 */ { 0, 0, 0, 0, 0 },
/* U+2b34 */ { 0, 0, 0, 0, 0 },
/* U+2b35 */ { 0, 0, 0, 0, 0 },
/* U+2b36 */ { 0, 0, 0, 0, 0 },
/* U+2b37 */ { 0, 0, 0, 0, 0 },
/* U+2b38 */ { 0, 0, 0, 0, 0 },
/* U+2b39 */ { 0, 0, 0, 0, 0 },
/* U+2b3a */ { 0, 0, 0, 0, 0 },
/* U+2b3b */ { 0, 0, 0, 0, 0 },
/* U+2b3c */ { 0, 0, 0, 0, 0 },
/* U+2b3d */ { 0, 0, 0, 0, 0 },
/* U+2b3e */ { 0, 0, 0, 0, 0 },
/* U+2b3f */ { 0, 0, 0, 0, 0 },
/* U+2b40 */ { 0, 0, 0, 0, 0 },
/* U+2b41 */ { 0, 0, 0, 0, 0 },
/* U+2b42 */ { 0, 0, 0, 0, 0 },
/* U+2b43 */ { 0, 0, 0, 0, 0 },
/* U+2b44 */ { 0, 0, 0, 0, 0 },
/* U+2b45 */ { 0, 0, 0, 0, 0 },
/* U+2b46 */ { 0, 0, 0, 0, 0 },
/* U+2b47 */ { 0, 0, 0, 0, 0 },
/* U+2b48 */ { 0, 0, 0, 0, 0 },
/* U+2b49 */ { 0, 0, 0, 0, 0 },
/* U+2b4a */ { 0, 0, 0, 0, 0 },
/* U+2b4b */ { 0, 0, 0, 0, 0 },
/* U+2b4c */ { 0, 0, 0, 0, 0 },
/* U+2b4d */ { 0, 0, 0, 0, 0 },
/* U+2b4e */ { 0, 0, 0, 0, 0 },
/* U+2b4f */ { 0, 0, 0, 0, 0 },
/* U+2b50 */ { 0, 0, 0, 0, 0 },
/* U+2b51 */ { 0, 0, 0, 0, 0 },
/* U+2b52 */ { 0, 0, 0, 0, 0 },
/* U+2b53 */ { 0, 0, 0, 0, 0 },
/* U+2b54 */ { 0, 0, 0, 0, 0 },
/* U+2b55 */ { 0, 0, 0, 0, 0 },
/* U+2b56 */ { 0, 0, 0, 0, 0 },
/* U+2b57 */ { 0, 0, 0, 0, 0 },
/* U+2b58 */ { 0, 0, 0, 0, 0 },
/* U+2b59 */ { 0, 0, 0, 0, 0 },
/* U+2b5a */ { 0, 0, 0, 0, 0 },
/* U+2b5b */ { 0, 0, 0, 0, 0 },
/* U+2b5c */ { 0, 0, 0, 0, 0 },
/* U+2b5d */ { 0, 0, 0, 0, 0 },
/* U+2b5e */ { 0, 0, 0, 0, 0 },
/* U+2b5f */ { 0, 0, 0, 0, 0 },
/* U+2b60 */ { 0, 0, 0, 0, 0 },
/* U+2b61 */ { 0, 0, 0, 0, 0 },
/* U+2b62 */ { 0, 0, 0, 0, 0 },
/* U+2b63 */ { 0, 0, 0, 0, 0 },
/* U+2b64 */ { 0, 0, 0, 0, 0 },
/* U+2b65 */ { 0, 0, 0, 0, 0 },
/* U+2b66 */ { 0, 0, 0, 0, 0 },
/* U+2b67 */ { 0, 0, 0, 0, 0 },
/* U+2b68 */ { 0, 0, 0, 0, 0 },
/* U+2b69 */ { 0, 0, 0, 0, 0 },
/* U+2b6a */ { 0, 0, 0, 0, 0 },
/* U+2b6b */ { 0, 0, 0, 0, 0 },
/* U+2b6c */ { 0, 0, 0, 0, 0 },
/* U+2b6d */ { 0, 0, 0, 0, 0 },
/* U+2b6e */ { 0, 0, 0, 0, 0 },
/* U+2b6f */ { 0, 0, 0, 0, 0 },
/* U+2b70 */ { 0, 0, 0, 0, 0 },
/* U+2b71 */ { 0, 0, 0, 0, 0 },
/* U+2b72 */ { 0, 0, 0, 0, 0 },
/* U+2b73 */ { 0, 0, 0, 0, 0 },
/* U+2b74 */ { 0, 0, 0, 0, 0 },
/* U+2b75 */ { 0, 0, 0, 0, 0 },
/* U+2b76 */ { 0, 0, 0, 0, 0 },
/* U+2b77 */ { 0, 0, 0, 0, 0 },
/* U+2b78 */ { 0, 0, 0, 0, 0 },
/* U+2b79 */ { 0, 0, 0, 0, 0 },
/* U+2b7a */ { 0, 0, 0, 0, 0 },
/* U+2b7b */ { 0, 0, 0, 0, 0 },
/* U+2b7c */ { 0, 0, 0, 0, 0 },
/* U+2b7d */ { 0, 0, 0, 0, 0 },
/* U+2b7e */ { 0, 0, 0, 0, 0 },
/* U+2b7f */ { 0, 0, 0, 0, 0 },
/* U+2b80 */ { 0, 0, 0, 0, 0 },
/* U+2b81 */ { 0, 0, 0, 0, 0 },
/* U+2b82 */ { 0, 0, 0, 0, 0 },
/* U+2b83 */ { 0, 0, 0, 0, 0 },
/* U+2b84 */ { 0, 0, 0, 0, 0 },
/* U+2b85 */ { 0, 0, 0, 0, 0 },
/* U+2b86 */ { 0, 0, 0, 0, 0 },
/* U+2b87 */ { 0, 0, 0, 0, 0 },
/* U+2b88 */ { 0, 0, 0, 0, 0 },
/* U+2b89 */ { 0, 0, 0, 0, 0 },
/* U+2b8a */ { 0, 0, 0, 0, 0 },
/* U+2b8b */ { 0, 0, 0, 0, 0 },
/* U+2b8c */ { 0, 0, 0, 0, 0 },
/* U+2b8d */ { 0, 0, 0, 0, 0 },
/* U+2b8e */ { 0, 0, 0, 0, 0 },
/* U+2b8f */ { 0, 0, 0, 0, 0 },
/* U+2b90 */ { 0, 0, 0, 0, 0 },
/* U+2b91 */ { 0, 0, 0, 0, 0 },
/* U+2b92 */ { 0, 0, 0, 0, 0 },
/* U+2b93 */ { 0, 0, 0, 0, 0 },
/* U+2b94 */ { 0, 0, 0, 0, 0 },
/* U+2b95 */ { 0, 0, 0, 0, 0 },
/* U+2b96 */ { 0, 0, 0, 0, 0 },
/* U+2b97 */ { 0, 0, 0, 0, 0 },
/* U+2b98 */ { 0, 0, 0, 0, 0 },
/* U+2b99 */ { 0, 0, 0, 0, 0 },
/* U+2b9a */ { 0, 0, 0, 0, 0 },
/* U+2b9b */ { 0, 0, 0, 0, 0 },
/* U+2b9c */ { 0, 0, 0, 0, 0 },
/* U+2b9d */ { 0, 0, 0, 0, 0 },
/* U+2b9e */ { 0, 0, 0, 0, 0 },
/* U+2b9f */ { 0, 0, 0, 0, 0 },
/* U+2ba0 */ { 0, 0, 0, 0, 0 },
/* U+2ba1 */ { 0, 0, 0, 0, 0 },
/* U+2ba2 */ { 0, 0, 0, 0, 0 },
/* U+2ba3 */ { 0, 0, 0, 0, 0 },
/* U+2ba4 */ { 0, 0, 0, 0, 0 },
/* U+2ba5 */ { 0, 0, 0, 0, 0 },
/* U+2ba6 */ { 0, 0, 0, 0, 0 },
/* U+2ba7 */ { 0, 0, 0, 0, 0 },
/* U+2ba8 */ { 0, 0, 0, 0, 0 },
/* U+2ba9 */ { 0, 0, 0, 0, 0 },
/* U+2baa */ { 0, 0, 0, 0, 0 },
/* U+2bab */ { 0, 0, 0, 0, 0 },
/* U+2bac */ { 0, 0, 0, 0, 0 },
/* U+2bad */ { 0, 0, 0, 0, 0 },
/* U+2bae */ { 0, 0, 0, 0, 0 },
/* U+2baf */ { 0, 0, 0, 0, 0 },
/* U+2bb0 */ { 0, 0, 0, 0, 0 },
/* U+2bb1 */ { 0, 0, 0, 0, 0 },
/* U+2bb2 */ { 0, 0, 0, 0, 0 },
/* U+2bb3 */ { 0, 0, 0, 0, 0 },
/* U+2bb4 */ { 0, 0, 0, 0, 0 },
/* U+2bb5 */ { 0, 0, 0, 0, 0 },
/* U+2bb6 */ { 0, 0, 0, 0, 0 },
/* U+2bb7 */ { 0, 0, 0, 0, 0 },
/* U+2bb8 */ { 0, 0, 0, 0, 0 },
/* U+2bb9 */ { 0, 0, 0, 0, 0 },
/* U+2bba */ { 0, 0, 0, 0, 0 },
/* U+2bbb */ { 0, 0, 0, 0, 0 },
/* U+2bbc */ { 0, 0, 0, 0, 0 },
/* U+2bbd */ { 0, 0, 0, 0, 0 },
/* U+2bbe */ { 0, 0, 0, 0, 0 },
/* U+2bbf */ { 0, 0, 0, 0, 0 },
/* U+2bc0 */ { 0, 0, 0, 0, 0 },
/* U+2bc1 */ { 0, 0, 0, 0, 0 },
/* U+2bc2 */ { 0, 0, 0, 0, 0 },
/* U+2bc3 */ { 0, 0, 0, 0, 0 },
/* U+2bc4 */ { 0, 0, 0, 0, 0 },
/* U+2bc5 */ { 0, 0, 0, 0, 0 },
/* U+2bc6 */ { 0, 0, 0, 0, 0 },
/* U+2bc7 */ { 0, 0, 0, 0, 0 },
/* U+2bc8 */ { 0, 0, 0, 0, 0 },
/* U+2bc9 */ { 0, 0, 0, 0, 0 },
/* U+2bca */ { 0, 0, 0, 0, 0 },
/* U+2bcb */ { 0, 0, 0, 0, 0 },
/* U+2bcc */ { 0, 0, 0, 0, 0 },
/* U+2bcd */ { 0, 0, 0, 0, 0 },
/* U+2bce */ { 0, 0, 0, 0, 0 },
/* U+2bcf */ { 0, 0, 0, 0, 0 },
/* U+2bd0 */ { 0, 0, 0, 0, 0 },
/* U+2bd1 */ { 0, 0, 0, 0, 0 },
/* U+2bd2 */ { 0, 0, 0, 0, 0 },
/* U+2bd3 */ { 0, 0, 0, 0, 0 },
/* U+2bd4 */ { 0, 0, 0, 0, 0 },
/* U+2bd5 */ { 0, 0, 0, 0, 0 },
/* U+2bd6 */ { 0, 0, 0, 0, 0 },
/* U+2bd7 */ { 0, 0, 0, 0, 0 },
/* U+2bd8 */ { 0, 0, 0, 0, 0 },
/* U+2bd9 */ { 0, 0, 0, 0, 0 },
/* U+2bda */ { 0, 0, 0, 0, 0 },
/* U+2bdb */ { 0, 0, 0, 0, 0 },
/* U+2bdc */ { 0, 0, 0, 0, 0 },
/* U+2bdd */ { 0, 0, 0, 0, 0 },
/* U+2bde */ { 0, 0, 0, 0, 0 },
/* U+2bdf */ { 0, 0, 0, 0, 0 },
/* U+2be0 */ { 0, 0, 0, 0, 0 },
/* U+2be1 */ { 0, 0, 0, 0, 0 },
/* U+2be2 */ { 0, 0, 0, 0, 0 },
/* U+2be3 */ { 0, 0, 0, 0, 0 },
/* U+2be4 */ { 0, 0, 0, 0, 0 },
/* U+2be5 */ { 0, 0, 0, 0, 0 },
/* U+2be6 */ { 0, 0, 0, 0, 0 },
/* U+2be7 */ { 0, 0, 0, 0, 0 },
/* U+2be8 */ { 0, 0, 0, 0, 0 },
/* U+2be9 */ { 0, 0, 0, 0, 0 },
/* U+2bea */ { 0, 0, 0, 0, 0 },
/* U+2beb */ { 0, 0, 0, 0, 0 },
/* U+2bec */ { 0, 0, 0, 0, 0 },
/* U+2bed */ { 0, 0, 0, 0, 0 },
/* U+2bee */ { 0, 0, 0, 0, 0 },
/* U+2bef */ { 0, 0, 0, 0, 0 },
/* U+2bf0 */ { 0, 0, 0, 0, 0 },
/* U+2bf1 */ { 0, 0, 0, 0, 0 },
/* U+2bf2 */ { 0, 0, 0, 0, 0 },
/* U+2bf3 */ { 0, 0, 0, 0, 0 },
/* U+2bf4 */ { 0, 0, 0, 0, 0 },
/* U+2bf5 */ { 0, 0, 0, 0, 0 },
/* U+2bf6 */ { 0, 0, 0, 0, 0 },
/* U+2bf7 */ { 0, 0, 0, 0, 0 },
/* U+2bf8 */ { 0, 0, 0, 0, 0 },
/* U+2bf9 */ { 0, 0, 0, 0, 0 },
/* U+2bfa */ { 0, 0, 0, 0, 0 },
/* U+2bfb */ { 0, 0, 0, 0, 0 },
/* U+2bfc */ { 0, 0, 0, 0, 0 },
/* U+2bfd */ { 0, 0, 0, 0, 0 },
/* U+2bfe */ { 0, 0, 0, 0, 0 },
/* U+2bff */ { 0, 0, 0, 0, 0 },
/* U+2c00 */ { 0, 0, 0, 0, 0 },
/* U+2c01 */ { 0, 0, 0, 0, 0 },
/* U+2c02 */ { 0, 0, 0, 0, 0 },
/* U+2c03 */ { 0, 0, 0, 0, 0 },
/* U+2c04 */ { 0, 0, 0, 0, 0 },
/* U+2c05 */ { 0, 0, 0, 0, 0 },
/* U+2c06 */ { 0, 0, 0, 0, 0 },
/* U+2c07 */ { 0, 0, 0, 0, 0 },
/* U+2c08 */ { 0, 0, 0, 0, 0 },
/* U+2c09 */ { 0, 0, 0, 0, 0 },
/* U+2c0a */ { 0, 0, 0, 0, 0 },
/* U+2c0b */ { 0, 0, 0, 0, 0 },
/* U+2c0c */ { 0, 0, 0, 0, 0 },
/* U+2c0d */ { 0, 0, 0, 0, 0 },
/* U+2c0e */ { 0, 0, 0, 0, 0 },
/* U+2c0f */ { 0, 0, 0, 0, 0 },
/* U+2c10 */ { 0, 0, 0, 0, 0 },
/* U+2c11 */ { 0, 0, 0, 0, 0 },
/* U+2c12 */ { 0, 0, 0, 0, 0 },
/* U+2c13 */ { 0, 0, 0, 0, 0 },
/* U+2c14 */ { 0, 0, 0, 0, 0 },
/* U+2c15 */ { 0, 0, 0, 0, 0 },
/* U+2c16 */ { 0, 0, 0, 0, 0 },
/* U+2c17 */ { 0, 0, 0, 0, 0 },
/* U+2c18 */ { 0, 0, 0, 0, 0 },
/* U+2c19 */ { 0, 0, 0, 0, 0 },
/* U+2c1a */ { 0, 0, 0, 0, 0 },
/* U+2c1b */ { 0, 0, 0, 0, 0 },
/* U+2c1c */ { 0, 0, 0, 0, 0 },
/* U+2c1d */ { 0, 0, 0, 0, 0 },
/* U+2c1e */ { 0, 0, 0, 0, 0 },
/* U+2c1f */ { 0, 0, 0, 0, 0 },
/* U+2c20 */ { 0, 0, 0, 0, 0 },
/* U+2c21 */ { 0, 0, 0, 0, 0 },
/* U+2c22 */ { 0, 0, 0, 0, 0 },
/* U+2c23 */ { 0, 0, 0, 0, 0 },
/* U+2c24 */ { 0, 0, 0, 0, 0 },
/* U+2c25 */ { 0, 0, 0, 0, 0 },
/* U+2c26 */ { 0, 0, 0, 0, 0 },
/* U+2c27 */ { 0, 0, 0, 0, 0 },
/* U+2c28 */ { 0, 0, 0, 0, 0 },
/* U+2c29 */ { 0, 0, 0, 0, 0 },
/* U+2c2a */ { 0, 0, 0, 0, 0 },
/* U+2c2b */ { 0, 0, 0, 0, 0 },
/* U+2c2c */ { 0, 0, 0, 0, 0 },
/* U+2c2d */ { 0, 0, 0, 0, 0 },
/* U+2c2e */ { 0, 0, 0, 0, 0 },
/* U+2c2f */ { 0, 0, 0, 0, 0 },
/* U+2c30 */ { 0, 0, 0, 0, 0 },
/* U+2c31 */ { 0, 0, 0, 0, 0 },
/* U+2c32 */ { 0, 0, 0, 0, 0 },
/* U+2c33 */ { 0, 0, 0, 0, 0 },
/* U+2c34 */ { 0, 0, 0, 0, 0 },
/* U+2c35 */ { 0, 0, 0, 0, 0 },
/* U+2c36 */ { 0, 0, 0, 0, 0 },
/* U+2c37 */ { 0, 0, 0, 0, 0 },
/* U+2c38 */ { 0, 0, 0, 0, 0 },
/* U+2c39 */ { 0, 0, 0, 0, 0 },
/* U+2c3a */ { 0, 0, 0, 0, 0 },
/* U+2c3b */ { 0, 0, 0, 0, 0 },
/* U+2c3c */ { 0, 0, 0, 0, 0 },
/* U+2c3d */ { 0, 0, 0, 0, 0 },
/* U+2c3e */ { 0, 0, 0, 0, 0 },
/* U+2c3f */ { 0, 0, 0, 0, 0 },
/* U+2c40 */ { 0, 0, 0, 0, 0 },
/* U+2c41 */ { 0, 0, 0, 0, 0 },
/* U+2c42 */ { 0, 0, 0, 0, 0 },
/* U+2c43 */ { 0, 0, 0, 0, 0 },
/* U+2c44 */ { 0, 0, 0, 0, 0 },
/* U+2c45 */ { 0, 0, 0, 0, 0 },
/* U+2c46 */ { 0, 0, 0, 0, 0 },
/* U+2c47 */ { 0, 0, 0, 0, 0 },
/* U+2c48 */ { 0, 0, 0, 0, 0 },
/* U+2c49 */ { 0, 0, 0, 0, 0 },
/* U+2c4a */ { 0, 0, 0, 0, 0 },
/* U+2c4b */ { 0, 0, 0, 0, 0 },
/* U+2c4c */ { 0, 0, 0, 0, 0 },
/* U+2c4d */ { 0, 0, 0, 0, 0 },
/* U+2c4e */ { 0, 0, 0, 0, 0 },
/* U+2c4f */ { 0, 0, 0, 0, 0 },
/* U+2c50 */ { 0, 0, 0, 0, 0 },
/* U+2c51 */ { 0, 0, 0, 0, 0 },
/* U+2c52 */ { 0, 0, 0, 0, 0 },
/* U+2c53 */ { 0, 0, 0, 0, 0 },
/* U+2c54 */ { 0, 0, 0, 0, 0 },
/* U+2c55 */ { 0, 0, 0, 0, 0 },
/* U+2c56 */ { 0, 0, 0, 0, 0 },
/* U+2c57 */ { 0, 0, 0, 0, 0 },
/* U+2c58 */ { 0, 0, 0, 0, 0 },
/* U+2c59 */ { 0, 0, 0, 0, 0 },
/* U+2c5a */ { 0, 0, 0, 0, 0 },
/* U+2c5b */ { 0, 0, 0, 0, 0 },
/* U+2c5c */ { 0, 0, 0, 0, 0 },
/* U+2c5d */ { 0, 0, 0, 0, 0 },
/* U+2c5e */ { 0, 0, 0, 0, 0 },
/* U+2c5f */ { 0, 0, 0, 0, 0 },
/* U+2c60 */ { 0, 0, 0, 0, 0 },
/* U+2c61 */ { 0, 0, 0, 0, 0 },
/* U+2c62 */ { 0, 0, 0, 0, 0 },
/* U+2c63 */ { 0, 0, 0, 0, 0 },
/* U+2c64 */ { 0, 0, 0, 0, 0 },
/* U+2c65 */ { 0, 0, 0, 0, 0 },
/* U+2c66 */ { 0, 0, 0, 0, 0 },
/* U+2c67 */ { 0, 0, 0, 0, 0 },
/* U+2c68 */ { 0, 0, 0, 0, 0 },
/* U+2c69 */ { 0, 0, 0, 0, 0 },
/* U+2c6a */ { 0, 0, 0, 0, 0 },
/* U+2c6b */ { 0, 0, 0, 0, 0 },
/* U+2c6c */ { 0, 0, 0, 0, 0 },
/* U+2c6d */ { 0, 0, 0, 0, 0 },
/* U+2c6e */ { 0, 0, 0, 0, 0 },
/* U+2c6f */ { 0, 0, 0, 0, 0 },
/* U+2c70 */ { 0, 0, 0, 0, 0 },
/* U+2c71 */ { 0, 0, 0, 0, 0 },
/* U+2c72 */ { 0, 0, 0, 0, 0 },
/* U+2c73 */ { 0, 0, 0, 0, 0 },
/* U+2c74 */ { 0, 0, 0, 0, 0 },
/* U+2c75 */ { 0, 0, 0, 0, 0 },
/* U+2c76 */ { 0, 0, 0, 0, 0 },
/* U+2c77 */ { 0, 0, 0, 0, 0 },
/* U+2c78 */ { 0, 0, 0, 0, 0 },
/* U+2c79 */ { 0, 0, 0, 0, 0 },
/* U+2c7a */ { 0, 0, 0, 0, 0 },
/* U+2c7b */ { 0, 0, 0, 0, 0 },
/* U+2c7c */ { 0, 0, 0, 0, 0 },
/* U+2c7d */ { 0, 0, 0, 0, 0 },
/* U+2c7e */ { 0, 0, 0, 0, 0 },
/* U+2c7f */ { 0, 0, 0, 0, 0 },
/* U+2c80 */ { 0, 0, 0, 0, 0 },
/* U+2c81 */ { 0, 0, 0, 0, 0 },
/* U+2c82 */ { 0, 0, 0, 0, 0 },
/* U+2c83 */ { 0, 0, 0, 0, 0 },
/* U+2c84 */ { 0, 0, 0, 0, 0 },
/* U+2c85 */ { 0, 0, 0, 0, 0 },
/* U+2c86 */ { 0, 0, 0, 0, 0 },
/* U+2c87 */ { 0, 0, 0, 0, 0 },
/* U+2c88 */ { 0, 0, 0, 0, 0 },
/* U+2c89 */ { 0, 0, 0, 0, 0 },
/* U+2c8a */ { 0, 0, 0, 0, 0 },
/* U+2c8b */ { 0, 0, 0, 0, 0 },
/* U+2c8c */ { 0, 0, 0, 0, 0 },
/* U+2c8d */ { 0, 0, 0, 0, 0 },
/* U+2c8e */ { 0, 0, 0, 0, 0 },
/* U+2c8f */ { 0, 0, 0, 0, 0 },
/* U+2c90 */ { 0, 0, 0, 0, 0 },
/* U+2c91 */ { 0, 0, 0, 0, 0 },
/* U+2c92 */ { 0, 0, 0, 0, 0 },
/* U+2c93 */ { 0, 0, 0, 0, 0 },
/* U+2c94 */ { 0, 0, 0, 0, 0 },
/* U+2c95 */ { 0, 0, 0, 0, 0 },
/* U+2c96 */ { 0, 0, 0, 0, 0 },
/* U+2c97 */ { 0, 0, 0, 0, 0 },
/* U+2c98 */ { 0, 0, 0, 0, 0 },
/* U+2c99 */ { 0, 0, 0, 0, 0 },
/* U+2c9a */ { 0, 0, 0, 0, 0 },
/* U+2c9b */ { 0, 0, 0, 0, 0 },
/* U+2c9c */ { 0, 0, 0, 0, 0 },
/* U+2c9d */ { 0, 0, 0, 0, 0 },
/* U+2c9e */ { 0, 0, 0, 0, 0 },
/* U+2c9f */ { 0, 0, 0, 0, 0 },
/* U+2ca0 */ { 0, 0, 0, 0, 0 },
/* U+2ca1 */ { 0, 0, 0, 0, 0 },
/* U+2ca2 */ { 0, 0, 0, 0, 0 },
/* U+2ca3 */ { 0, 0, 0, 0, 0 },
/* U+2ca4 */ { 0, 0, 0, 0, 0 },
/* U+2ca5 */ { 0, 0, 0, 0, 0 },
/* U+2ca6 */ { 0, 0, 0, 0, 0 },
/* U+2ca7 */ { 0, 0, 0, 0, 0 },
/* U+2ca8 */ { 0, 0, 0, 0, 0 },
/* U+2ca9 */ { 0, 0, 0, 0, 0 },
/* U+2caa */ { 0, 0, 0, 0, 0 },
/* U+2cab */ { 0, 0, 0, 0, 0 },
/* U+2cac */ { 0, 0, 0, 0, 0 },
/* U+2cad */ { 0, 0, 0, 0, 0 },
/* U+2cae */ { 0, 0, 0, 0, 0 },
/* U+2caf */ { 0, 0, 0, 0, 0 },
/* U+2cb0 */ { 0, 0, 0, 0, 0 },
/* U+2cb1 */ { 0, 0, 0, 0, 0 },
/* U+2cb2 */ { 0, 0, 0, 0, 0 },
/* U+2cb3 */ { 0, 0, 0, 0, 0 },
/* U+2cb4 */ { 0, 0, 0, 0, 0 },
/* U+2cb5 */ { 0, 0, 0, 0, 0 },
/* U+2cb6 */ { 0, 0, 0, 0, 0 },
/* U+2cb7 */ { 0, 0, 0, 0, 0 },
/* U+2cb8 */ { 0, 0, 0, 0, 0 },
/* U+2cb9 */ { 0, 0, 0, 0, 0 },
/* U+2cba */ { 0, 0, 0, 0, 0 },
/* U+2cbb */ { 0, 0, 0, 0, 0 },
/* U+2cbc */ { 0, 0, 0, 0, 0 },
/* U+2cbd */ { 0, 0, 0, 0, 0 },
/* U+2cbe */ { 0, 0, 0, 0, 0 },
/* U+2cbf */ { 0, 0, 0, 0, 0 },
/* U+2cc0 */ { 0, 0, 0, 0, 0 },
/* U+2cc1 */ { 0, 0, 0, 0, 0 },
/* U+2cc2 */ { 0, 0, 0, 0, 0 },
/* U+2cc3 */ { 0, 0, 0, 0, 0 },
/* U+2cc4 */ { 0, 0, 0, 0, 0 },
/* U+2cc5 */ { 0, 0, 0, 0, 0 },
/* U+2cc6 */ { 0, 0, 0, 0, 0 },
/* U+2cc7 */ { 0, 0, 0, 0, 0 },
/* U+2cc8 */ { 0, 0, 0, 0, 0 },
/* U+2cc9 */ { 0, 0, 0, 0, 0 },
/* U+2cca */ { 0, 0, 0, 0, 0 },
/* U+2ccb */ { 0, 0, 0, 0, 0 },
/* U+2ccc */ { 0, 0, 0, 0, 0 },
/* U+2ccd */ { 0, 0, 0, 0, 0 },
/* U+2cce */ { 0, 0, 0, 0, 0 },
/* U+2ccf */ { 0, 0, 0, 0, 0 },
/* U+2cd0 */ { 0, 0, 0, 0, 0 },
/* U+2cd1 */ { 0, 0, 0, 0, 0 },
/* U+2cd2 */ { 0, 0, 0, 0, 0 },
/* U+2cd3 */ { 0, 0, 0, 0, 0 },
/* U+2cd4 */ { 0, 0, 0, 0, 0 },
/* U+2cd5 */ { 0, 0, 0, 0, 0 },
/* U+2cd6 */ { 0, 0, 0, 0, 0 },
/* U+2cd7 */ { 0, 0, 0, 0, 0 },
/* U+2cd8 */ { 0, 0, 0, 0, 0 },
/* U+2cd9 */ { 0, 0, 0, 0, 0 },
/* U+2cda */ { 0, 0, 0, 0, 0 },
/* U+2cdb */ { 0, 0, 0, 0, 0 },
/* U+2cdc */ { 0, 0, 0, 0, 0 },
/* U+2cdd */ { 0, 0, 0, 0, 0 },
/* U+2cde */ { 0, 0, 0, 0, 0 },
/* U+2cdf */ { 0, 0, 0, 0, 0 },
/* U+2ce0 */ { 0, 0, 0, 0, 0 },
/* U+2ce1 */ { 0, 0, 0, 0, 0 },
/* U+2ce2 */ { 0, 0, 0, 0, 0 },
/* U+2ce3 */ { 0, 0, 0, 0, 0 },
/* U+2ce4 */ { 0, 0, 0, 0, 0 },
/* U+2ce5 */ { 0, 0, 0, 0, 0 },
/* U+2ce6 */ { 0, 0, 0, 0, 0 },
/* U+2ce7 */ { 0, 0, 0, 0, 0 },
/* U+2ce8 */ { 0, 0, 0, 0, 0 },
/* U+2ce9 */ { 0, 0, 0, 0, 0 },
/* U+2cea */ { 0, 0, 0, 0, 0 },
/* U+2ceb */ { 0, 0, 0, 0, 0 },
/* U+2cec */ { 0, 0, 0, 0, 0 },
/* U+2ced */ { 0, 0, 0, 0, 0 },
/* U+2cee */ { 0, 0, 0, 0, 0 },
/* U+2cef */ { 0, 0, 0, 0, 0 },
/* U+2cf0 */ { 0, 0, 0, 0, 0 },
/* U+2cf1 */ { 0, 0, 0, 0, 0 },
/* U+2cf2 */ { 0, 0, 0, 0, 0 },
/* U+2cf3 */ { 0, 0, 0, 0, 0 },
/* U+2cf4 */ { 0, 0, 0, 0, 0 },
/* U+2cf5 */ { 0, 0, 0, 0, 0 },
/* U+2cf6 */ { 0, 0, 0, 0, 0 },
/* U+2cf7 */ { 0, 0, 0, 0, 0 },
/* U+2cf8 */ { 0, 0, 0, 0, 0 },
/* U+2cf9 */ { 0, 0, 0, 0, 0 },
/* U+2cfa */ { 0, 0, 0, 0, 0 },
/* U+2cfb */ { 0, 0, 0, 0, 0 },
/* U+2cfc */ { 0, 0, 0, 0, 0 },
/* U+2cfd */ { 0, 0, 0, 0, 0 },
/* U+2cfe */ { 0, 0, 0, 0, 0 },
/* U+2cff */ { 0, 0, 0, 0, 0 },
/* U+2d00 */ { 0, 0, 0, 0, 0 },
/* U+2d01 */ { 0, 0, 0, 0, 0 },
/* U+2d02 */ { 0, 0, 0, 0, 0 },
/* U+2d03 */ { 0, 0, 0, 0, 0 },
/* U+2d04 */ { 0, 0, 0, 0, 0 },
/* U+2d05 */ { 0, 0, 0, 0, 0 },
/* U+2d06 */ { 0, 0, 0, 0, 0 },
/* U+2d07 */ { 0, 0, 0, 0, 0 },
/* U+2d08 */ { 0, 0, 0, 0, 0 },
/* U+2d09 */ { 0, 0, 0, 0, 0 },
/* U+2d0a */ { 0, 0, 0, 0, 0 },
/* U+2d0b */ { 0, 0, 0, 0, 0 },
/* U+2d0c */ { 0, 0, 0, 0, 0 },
/* U+2d0d */ { 0, 0, 0, 0, 0 },
/* U+2d0e */ { 0, 0, 0, 0, 0 },
/* U+2d0f */ { 0, 0, 0, 0, 0 },
/* U+2d10 */ { 0, 0, 0, 0, 0 },
/* U+2d11 */ { 0, 0, 0, 0, 0 },
/* U+2d12 */ { 0, 0, 0, 0, 0 },
/* U+2d13 */ { 0, 0, 0, 0, 0 },
/* U+2d14 */ { 0, 0, 0, 0, 0 },
/* U+2d15 */ { 0, 0, 0, 0, 0 },
/* U+2d16 */ { 0, 0, 0, 0, 0 },
/* U+2d17 */ { 0, 0, 0, 0, 0 },
/* U+2d18 */ { 0, 0, 0, 0, 0 },
/* U+2d19 */ { 0, 0, 0, 0, 0 },
/* U+2d1a */ { 0, 0, 0, 0, 0 },
/* U+2d1b */ { 0, 0, 0, 0, 0 },
/* U+2d1c */ { 0, 0, 0, 0, 0 },
/* U+2d1d */ { 0, 0, 0, 0, 0 },
/* U+2d1e */ { 0, 0, 0, 0, 0 },
/* U+2d1f */ { 0, 0, 0, 0, 0 },
/* U+2d20 */ { 0, 0, 0, 0, 0 },
/* U+2d21 */ { 0, 0, 0, 0, 0 },
/* U+2d22 */ { 0, 0, 0, 0, 0 },
/* U+2d23 */ { 0, 0, 0, 0, 0 },
/* U+2d24 */ { 0, 0, 0, 0, 0 },
/* U+2d25 */ { 0, 0, 0, 0, 0 },
/* U+2d26 */ { 0, 0, 0, 0, 0 },
/* U+2d27 */ { 0, 0, 0, 0, 0 },
/* U+2d28 */ { 0, 0, 0, 0, 0 },
/* U+2d29 */ { 0, 0, 0, 0, 0 },
/* U+2d2a */ { 0, 0, 0, 0, 0 },
/* U+2d2b */ { 0, 0, 0, 0, 0 },
/* U+2d2c */ { 0, 0, 0, 0, 0 },
/* U+2d2d */ { 0, 0, 0, 0, 0 },
/* U+2d2e */ { 0, 0, 0, 0, 0 },
/* U+2d2f */ { 0, 0, 0, 0, 0 },
/* U+2d30 */ { 0, 0, 0, 0, 0 },
/* U+2d31 */ { 0, 0, 0, 0, 0 },
/* U+2d32 */ { 0, 0, 0, 0, 0 },
/* U+2d33 */ { 0, 0, 0, 0, 0 },
/* U+2d34 */ { 0, 0, 0, 0, 0 },
/* U+2d35 */ { 0, 0, 0, 0, 0 },
/* U+2d36 */ { 0, 0, 0, 0, 0 },
/* U+2d37 */ { 0, 0, 0, 0, 0 },
/* U+2d38 */ { 0, 0, 0, 0, 0 },
/* U+2d39 */ { 0, 0, 0, 0, 0 },
/* U+2d3a */ { 0, 0, 0, 0, 0 },
/* U+2d3b */ { 0, 0, 0, 0, 0 },
/* U+2d3c */ { 0, 0, 0, 0, 0 },
/* U+2d3d */ { 0, 0, 0, 0, 0 },
/* U+2d3e */ { 0, 0, 0, 0, 0 },
/* U+2d3f */ { 0, 0, 0, 0, 0 },
/* U+2d40 */ { 0, 0, 0, 0, 0 },
/* U+2d41 */ { 0, 0, 0, 0, 0 },
/* U+2d42 */ { 0, 0, 0, 0, 0 },
/* U+2d43 */ { 0, 0, 0, 0, 0 },
/* U+2d44 */ { 0, 0, 0, 0, 0 },
/* U+2d45 */ { 0, 0, 0, 0, 0 },
/* U+2d46 */ { 0, 0, 0, 0, 0 },
/* U+2d47 */ { 0, 0, 0, 0, 0 },
/* U+2d48 */ { 0, 0, 0, 0, 0 },
/* U+2d49 */ { 0, 0, 0, 0, 0 },
/* U+2d4a */ { 0, 0, 0, 0, 0 },
/* U+2d4b */ { 0, 0, 0, 0, 0 },
/* U+2d4c */ { 0, 0, 0, 0, 0 },
/* U+2d4d */ { 0, 0, 0, 0, 0 },
/* U+2d4e */ { 0, 0, 0, 0, 0 },
/* U+2d4f */ { 0, 0, 0, 0, 0 },
/* U+2d50 */ { 0, 0, 0, 0, 0 },
/* U+2d51 */ { 0, 0, 0, 0, 0 },
/* U+2d52 */ { 0, 0, 0, 0, 0 },
/* U+2d53 */ { 0, 0, 0, 0, 0 },
/* U+2d54 */ { 0, 0, 0, 0, 0 },
/* U+2d55 */ { 0, 0, 0, 0, 0 },
/* U+2d56 */ { 0, 0, 0, 0, 0 },
/* U+2d57 */ { 0, 0, 0, 0, 0 },
/* U+2d58 */ { 0, 0, 0, 0, 0 },
/* U+2d59 */ { 0, 0, 0, 0, 0 },
/* U+2d5a */ { 0, 0, 0, 0, 0 },
/* U+2d5b */ { 0, 0, 0, 0, 0 },
/* U+2d5c */ { 0, 0, 0, 0, 0 },
/* U+2d5d */ { 0, 0, 0, 0, 0 },
/* U+2d5e */ { 0, 0, 0, 0, 0 },
/* U+2d5f */ { 0, 0, 0, 0, 0 },
/* U+2d60 */ { 0, 0, 0, 0, 0 },
/* U+2d61 */ { 0, 0, 0, 0, 0 },
/* U+2d62 */ { 0, 0, 0, 0, 0 },
/* U+2d63 */ { 0, 0, 0, 0, 0 },
/* U+2d64 */ { 0, 0, 0, 0, 0 },
/* U+2d65 */ { 0, 0, 0, 0, 0 },
/* U+2d66 */ { 0, 0, 0, 0, 0 },
/* U+2d67 */ { 0, 0, 0, 0, 0 },
/* U+2d68 */ { 0, 0, 0, 0, 0 },
/* U+2d69 */ { 0, 0, 0, 0, 0 },
/* U+2d6a */ { 0, 0, 0, 0, 0 },
/* U+2d6b */ { 0, 0, 0, 0, 0 },
/* U+2d6c */ { 0, 0, 0, 0, 0 },
/* U+2d6d */ { 0, 0, 0, 0, 0 },
/* U+2d6e */ { 0, 0, 0, 0, 0 },
/* U+2d6f */ { 0, 0, 0, 0, 0 },
/* U+2d70 */ { 0, 0, 0, 0, 0 },
/* U+2d71 */ { 0, 0, 0, 0, 0 },
/* U+2d72 */ { 0, 0, 0, 0, 0 },
/* U+2d73 */ { 0, 0, 0, 0, 0 },
/* U+2d74 */ { 0, 0, 0, 0, 0 },
/* U+2d75 */ { 0, 0, 0, 0, 0 },
/* U+2d76 */ { 0, 0, 0, 0, 0 },
/* U+2d77 */ { 0, 0, 0, 0, 0 },
/* U+2d78 */ { 0, 0, 0, 0, 0 },
/* U+2d79 */ { 0, 0, 0, 0, 0 },
/* U+2d7a */ { 0, 0, 0, 0, 0 },
/* U+2d7b */ { 0, 0, 0, 0, 0 },
/* U+2d7c */ { 0, 0, 0, 0, 0 },
/* U+2d7d */ { 0, 0, 0, 0, 0 },
/* U+2d7e */ { 0, 0, 0, 0, 0 },
/* U+2d7f */ { 0, 0, 0, 0, 0 },
/* U+2d80 */ { 0, 0, 0, 0, 0 },
/* U+2d81 */ { 0, 0, 0, 0, 0 },
/* U+2d82 */ { 0, 0, 0, 0, 0 },
/* U+2d83 */ { 0, 0, 0, 0, 0 },
/* U+2d84 */ { 0, 0, 0, 0, 0 },
/* U+2d85 */ { 0, 0, 0, 0, 0 },
/* U+2d86 */ { 0, 0, 0, 0, 0 },
/* U+2d87 */ { 0, 0, 0, 0, 0 },
/* U+2d88 */ { 0, 0, 0, 0, 0 },
/* U+2d89 */ { 0, 0, 0, 0, 0 },
/* U+2d8a */ { 0, 0, 0, 0, 0 },
/* U+2d8b */ { 0, 0, 0, 0, 0 },
/* U+2d8c */ { 0, 0, 0, 0, 0 },
/* U+2d8d */ { 0, 0, 0, 0, 0 },
/* U+2d8e */ { 0, 0, 0, 0, 0 },
/* U+2d8f */ { 0, 0, 0, 0, 0 },
/* U+2d90 */ { 0, 0, 0, 0, 0 },
/* U+2d91 */ { 0, 0, 0, 0, 0 },
/* U+2d92 */ { 0, 0, 0, 0, 0 },
/* U+2d93 */ { 0, 0, 0, 0, 0 },
/* U+2d94 */ { 0, 0, 0, 0, 0 },
/* U+2d95 */ { 0, 0, 0, 0, 0 },
/* U+2d96 */ { 0, 0, 0, 0, 0 },
/* U+2d97 */ { 0, 0, 0, 0, 0 },
/* U+2d98 */ { 0, 0, 0, 0, 0 },
/* U+2d99 */ { 0, 0, 0, 0, 0 },
/* U+2d9a */ { 0, 0, 0, 0, 0 },
/* U+2d9b */ { 0, 0, 0, 0, 0 },
/* U+2d9c */ { 0, 0, 0, 0, 0 },
/* U+2d9d */ { 0, 0, 0, 0, 0 },
/* U+2d9e */ { 0, 0, 0, 0, 0 },
/* U+2d9f */ { 0, 0, 0, 0, 0 },
/* U+2da0 */ { 0, 0, 0, 0, 0 },
/* U+2da1 */ { 0, 0, 0, 0, 0 },
/* U+2da2 */ { 0, 0, 0, 0, 0 },
/* U+2da3 */ { 0, 0, 0, 0, 0 },
/* U+2da4 */ { 0, 0, 0, 0, 0 },
/* U+2da5 */ { 0, 0, 0, 0, 0 },
/* U+2da6 */ { 0, 0, 0, 0, 0 },
/* U+2da7 */ { 0, 0, 0, 0, 0 },
/* U+2da8 */ { 0, 0, 0, 0, 0 },
/* U+2da9 */ { 0, 0, 0, 0, 0 },
/* U+2daa */ { 0, 0, 0, 0, 0 },
/* U+2dab */ { 0, 0, 0, 0, 0 },
/* U+2dac */ { 0, 0, 0, 0, 0 },
/* U+2dad */ { 0, 0, 0, 0, 0 },
/* U+2dae */ { 0, 0, 0, 0, 0 },
/* U+2daf */ { 0, 0, 0, 0, 0 },
/* U+2db0 */ { 0, 0, 0, 0, 0 },
/* U+2db1 */ { 0, 0, 0, 0, 0 },
/* U+2db2 */ { 0, 0, 0, 0, 0 },
/* U+2db3 */ { 0, 0, 0, 0, 0 },
/* U+2db4 */ { 0, 0, 0, 0, 0 },
/* U+2db5 */ { 0, 0, 0, 0, 0 },
/* U+2db6 */ { 0, 0, 0, 0, 0 },
/* U+2db7 */ { 0, 0, 0, 0, 0 },
/* U+2db8 */ { 0, 0, 0, 0, 0 },
/* U+2db9 */ { 0, 0, 0, 0, 0 },
/* U+2dba */ { 0, 0, 0, 0, 0 },
/* U+2dbb */ { 0, 0, 0, 0, 0 },
/* U+2dbc */ { 0, 0, 0, 0, 0 },
/* U+2dbd */ { 0, 0, 0, 0, 0 },
/* U+2dbe */ { 0, 0, 0, 0, 0 },
/* U+2dbf */ { 0, 0, 0, 0, 0 },
/* U+2dc0 */ { 0, 0, 0, 0, 0 },
/* U+2dc1 */ { 0, 0, 0, 0, 0 },
/* U+2dc2 */ { 0, 0, 0, 0, 0 },
/* U+2dc3 */ { 0, 0, 0, 0, 0 },
/* U+2dc4 */ { 0, 0, 0, 0, 0 },
/* U+2dc5 */ { 0, 0, 0, 0, 0 },
/* U+2dc6 */ { 0, 0, 0, 0, 0 },
/* U+2dc7 */ { 0, 0, 0, 0, 0 },
/* U+2dc8 */ { 0, 0, 0, 0, 0 },
/* U+2dc9 */ { 0, 0, 0, 0, 0 },
/* U+2dca */ { 0, 0, 0, 0, 0 },
/* U+2dcb */ { 0, 0, 0, 0, 0 },
/* U+2dcc */ { 0, 0, 0, 0, 0 },
/* U+2dcd */ { 0, 0, 0, 0, 0 },
/* U+2dce */ { 0, 0, 0, 0, 0 },
/* U+2dcf */ { 0, 0, 0, 0, 0 },
/* U+2dd0 */ { 0, 0, 0, 0, 0 },
/* U+2dd1 */ { 0, 0, 0, 0, 0 },
/* U+2dd2 */ { 0, 0, 0, 0, 0 },
/* U+2dd3 */ { 0, 0, 0, 0, 0 },
/* U+2dd4 */ { 0, 0, 0, 0, 0 },
/* U+2dd5 */ { 0, 0, 0, 0, 0 },
/* U+2dd6 */ { 0, 0, 0, 0, 0 },
/* U+2dd7 */ { 0, 0, 0, 0, 0 },
/* U+2dd8 */ { 0, 0, 0, 0, 0 },
/* U+2dd9 */ { 0, 0, 0, 0, 0 },
/* U+2dda */ { 0, 0, 0, 0, 0 },
/* U+2ddb */ { 0, 0, 0, 0, 0 },
/* U+2ddc */ { 0, 0, 0, 0, 0 },
/* U+2ddd */ { 0, 0, 0, 0, 0 },
/* U+2dde */ { 0, 0, 0, 0, 0 },
/* U+2ddf */ { 0, 0, 0, 0, 0 },
/* U+2de0 */ { 0, 0, 0, 0, 0 },
/* U+2de1 */ { 0, 0, 0, 0, 0 },
/* U+2de2 */ { 0, 0, 0, 0, 0 },
/* U+2de3 */ { 0, 0, 0, 0, 0 },
/* U+2de4 */ { 0, 0, 0, 0, 0 },
/* U+2de5 */ { 0, 0, 0, 0, 0 },
/* U+2de6 */ { 0, 0, 0, 0, 0 },
/* U+2de7 */ { 0, 0, 0, 0, 0 },
/* U+2de8 */ { 0, 0, 0, 0, 0 },
/* U+2de9 */ { 0, 0, 0, 0, 0 },
/* U+2dea */ { 0, 0, 0, 0, 0 },
/* U+2deb */ { 0, 0, 0, 0, 0 },
/* U+2dec */ { 0, 0, 0, 0, 0 },
/* U+2ded */ { 0, 0, 0, 0, 0 },
/* U+2dee */ { 0, 0, 0, 0, 0 },
/* U+2def */ { 0, 0, 0, 0, 0 },
/* U+2df0 */ { 0, 0, 0, 0, 0 },
/* U+2df1 */ { 0, 0, 0, 0, 0 },
/* U+2df2 */ { 0, 0, 0, 0, 0 },
/* U+2df3 */ { 0, 0, 0, 0, 0 },
/* U+2df4 */ { 0, 0, 0, 0, 0 },
/* U+2df5 */ { 0, 0, 0, 0, 0 },
/* U+2df6 */ { 0, 0, 0, 0, 0 },
/* U+2df7 */ { 0, 0, 0, 0, 0 },
/* U+2df8 */ { 0, 0, 0, 0, 0 },
/* U+2df9 */ { 0, 0, 0, 0, 0 },
/* U+2dfa */ { 0, 0, 0, 0, 0 },
/* U+2dfb */ { 0, 0, 0, 0, 0 },
/* U+2dfc */ { 0, 0, 0, 0, 0 },
/* U+2dfd */ { 0, 0, 0, 0, 0 },
/* U+2dfe */ { 0, 0, 0, 0, 0 },
/* U+2dff */ { 0, 0, 0, 0, 0 },
/* U+2e00 */ { 0, 0, 0, 0, 0 },
/* U+2e01 */ { 0, 0, 0, 0, 0 },
/* U+2e02 */ { 0, 0, 0, 0, 0 },
/* U+2e03 */ { 0, 0, 0, 0, 0 },
/* U+2e04 */ { 0, 0, 0, 0, 0 },
/* U+2e05 */ { 0, 0, 0, 0, 0 },
/* U+2e06 */ { 0, 0, 0, 0, 0 },
/* U+2e07 */ { 0, 0, 0, 0, 0 },
/* U+2e08 */ { 0, 0, 0, 0, 0 },
/* U+2e09 */ { 0, 0, 0, 0, 0 },
/* U+2e0a */ { 0, 0, 0, 0, 0 },
/* U+2e0b */ { 0, 0, 0, 0, 0 },
/* U+2e0c */ { 0, 0, 0, 0, 0 },
/* U+2e0d */ { 0, 0, 0, 0, 0 },
/* U+2e0e */ { 0, 0, 0, 0, 0 },
/* U+2e0f */ { 0, 0, 0, 0, 0 },
/* U+2e10 */ { 0, 0, 0, 0, 0 },
/* U+2e11 */ { 0, 0, 0, 0, 0 },
/* U+2e12 */ { 0, 0, 0, 0, 0 },
/* U+2e13 */ { 0, 0, 0, 0, 0 },
/* U+2e14 */ { 0, 0, 0, 0, 0 },
/* U+2e15 */ { 0, 0, 0, 0, 0 },
/* U+2e16 */ { 0, 0, 0, 0, 0 },
/* U+2e17 */ { 0, 0, 0, 0, 0 },
/* U+2e18 */ { 0, 0, 0, 0, 0 },
/* U+2e19 */ { 0, 0, 0, 0, 0 },
/* U+2e1a */ { 0, 0, 0, 0, 0 },
/* U+2e1b */ { 0, 0, 0, 0, 0 },
/* U+2e1c */ { 0, 0, 0, 0, 0 },
/* U+2e1d */ { 0, 0, 0, 0, 0 },
/* U+2e1e */ { 0, 0, 0, 0, 0 },
/* U+2e1f */ { 0, 0, 0, 0, 0 },
/* U+2e20 */ { 0, 0, 0, 0, 0 },
/* U+2e21 */ { 0, 0, 0, 0, 0 },
/* U+2e22 */ { 0, 0, 0, 0, 0 },
/* U+2e23 */ { 0, 0, 0, 0, 0 },
/* U+2e24 */ { 0, 0, 0, 0, 0 },
/* U+2e25 */ { 0, 0, 0, 0, 0 },
/* U+2e26 */ { 0, 0, 0, 0, 0 },
/* U+2e27 */ { 0, 0, 0, 0, 0 },
/* U+2e28 */ { 0, 0, 0, 0, 0 },
/* U+2e29 */ { 0, 0, 0, 0, 0 },
/* U+2e2a */ { 0, 0, 0, 0, 0 },
/* U+2e2b */ { 0, 0, 0, 0, 0 },
/* U+2e2c */ { 0, 0, 0, 0, 0 },
/* U+2e2d */ { 0, 0, 0, 0, 0 },
/* U+2e2e */ { 0, 0, 0, 0, 0 },
/* U+2e2f */ { 0, 0, 0, 0, 0 },
/* U+2e30 */ { 0, 0, 0, 0, 0 },
/* U+2e31 */ { 0, 0, 0, 0, 0 },
/* U+2e32 */ { 0, 0, 0, 0, 0 },
/* U+2e33 */ { 0, 0, 0, 0, 0 },
/* U+2e34 */ { 0, 0, 0, 0, 0 },
/* U+2e35 */ { 0, 0, 0, 0, 0 },
/* U+2e36 */ { 0, 0, 0, 0, 0 },
/* U+2e37 */ { 0, 0, 0, 0, 0 },
/* U+2e38 */ { 0, 0, 0, 0, 0 },
/* U+2e39 */ { 0, 0, 0, 0, 0 },
/* U+2e3a */ { 0, 0, 0, 0, 0 },
/* U+2e3b */ { 0, 0, 0, 0, 0 },
/* U+2e3c */ { 0, 0, 0, 0, 0 },
/* U+2e3d */ { 0, 0, 0, 0, 0 },
/* U+2e3e */ { 0, 0, 0, 0, 0 },
/* U+2e3f */ { 0, 0, 0, 0, 0 },
/* U+2e40 */ { 0, 0, 0, 0, 0 },
/* U+2e41 */ { 0, 0, 0, 0, 0 },
/* U+2e42 */ { 0, 0, 0, 0, 0 },
/* U+2e43 */ { 0, 0, 0, 0, 0 },
/* U+2e44 */ { 0, 0, 0, 0, 0 },
/* U+2e45 */ { 0, 0, 0, 0, 0 },
/* U+2e46 */ { 0, 0, 0, 0, 0 },
/* U+2e47 */ { 0, 0, 0, 0, 0 },
/* U+2e48 */ { 0, 0, 0, 0, 0 },
/* U+2e49 */ { 0, 0, 0, 0, 0 },
/* U+2e4a */ { 0, 0, 0, 0, 0 },
/* U+2e4b */ { 0, 0, 0, 0, 0 },
/* U+2e4c */ { 0, 0, 0, 0, 0 },
/* U+2e4d */ { 0, 0, 0, 0, 0 },
/* U+2e4e */ { 0, 0, 0, 0, 0 },
/* U+2e4f */ { 0, 0, 0, 0, 0 },
/* U+2e50 */ { 0, 0, 0, 0, 0 },
/* U+2e51 */ { 0, 0, 0, 0, 0 },
/* U+2e52 */ { 0, 0, 0, 0, 0 },
/* U+2e53 */ { 0, 0, 0, 0, 0 },
/* U+2e54 */ { 0, 0, 0, 0, 0 },
/* U+2e55 */ { 0, 0, 0, 0, 0 },
/* U+2e56 */ { 0, 0, 0, 0, 0 },
/* U+2e57 */ { 0, 0, 0, 0, 0 },
/* U+2e58 */ { 0, 0, 0, 0, 0 },
/* U+2e59 */ { 0, 0, 0, 0, 0 },
/* U+2e5a */ { 0, 0, 0, 0, 0 },
/* U+2e5b */ { 0, 0, 0, 0, 0 },
/* U+2e5c */ { 0, 0, 0, 0, 0 },
/* U+2e5d */ { 0, 0, 0, 0, 0 },
/* U+2e5e */ { 0, 0, 0, 0, 0 },
/* U+2e5f */ { 0, 0, 0, 0, 0 },
/* U+2e60 */ { 0, 0, 0, 0, 0 },
/* U+2e61 */ { 0, 0, 0, 0, 0 },
/* U+2e62 */ { 0, 0, 0, 0, 0 },
/* U+2e63 */ { 0, 0, 0, 0, 0 },
/* U+2e64 */ { 0, 0, 0, 0, 0 },
/* U+2e65 */ { 0, 0, 0, 0, 0 },
/* U+2e66 */ { 0, 0, 0, 0, 0 },
/* U+2e67 */ { 0, 0, 0, 0, 0 },
/* U+2e68 */ { 0, 0, 0, 0, 0 },
/* U+2e69 */ { 0, 0, 0, 0, 0 },
/* U+2e6a */ { 0, 0, 0, 0, 0 },
/* U+2e6b */ { 0, 0, 0, 0, 0 },
/* U+2e6c */ { 0, 0, 0, 0, 0 },
/* U+2e6d */ { 0, 0, 0, 0, 0 },
/* U+2e6e */ { 0, 0, 0, 0, 0 },
/* U+2e6f */ { 0, 0, 0, 0, 0 },
/* U+2e70 */ { 0, 0, 0, 0, 0 },
/* U+2e71 */ { 0, 0, 0, 0, 0 },
/* U+2e72 */ { 0, 0, 0, 0, 0 },
/* U+2e73 */ { 0, 0, 0, 0, 0 },
/* U+2e74 */ { 0, 0, 0, 0, 0 },
/* U+2e75 */ { 0, 0, 0, 0, 0 },
/* U+2e76 */ { 0, 0, 0, 0, 0 },
/* U+2e77 */ { 0, 0, 0, 0, 0 },
/* U+2e78 */ { 0, 0, 0, 0, 0 },
/* U+2e79 */ { 0, 0, 0, 0, 0 },
/* U+2e7a */ { 0, 0, 0, 0, 0 },
/* U+2e7b */ { 0, 0, 0, 0, 0 },
/* U+2e7c */ { 0, 0, 0, 0, 0 },
/* U+2e7d */ { 0, 0, 0, 0, 0 },
/* U+2e7e */ { 0, 0, 0, 0, 0 },
/* U+2e7f */ { 0, 0, 0, 0, 0 },
/* U+2e80 */ { 30, 0, 19, 0, 0 },
/* U+2e81 */ { 30, 0, 19, 0, 0 },
/* U+2e82 */ { 30, 0, 19, 0, 0 },
/* U+2e83 */ { 30, 0, 19, 0, 0 },
/* U+2e84 */ { 30, 0, 19, 0, 0 },
/* U+2e85 */ { 30, 0, 19, 0, 0 },
/* U+2e86 */ { 30, 0, 19, 0, 0 },
/* U+2e87 */ { 30, 0, 19, 0, 0 },
/* U+2e88 */ { 30, 0, 19, 0, 0 },
/* U+2e89 */ { 30, 0, 19, 0, 0 },
/* U+2e8a */ { 30, 0, 19, 0, 0 },
/* U+2e8b */ { 30, 0, 19, 0, 0 },
/* U+2e8c */ { 30, 0, 19, 0, 0 },
/* U+2e8d */ { 30, 0, 19, 0, 0 },
/* U+2e8e */ { 30, 0, 19, 0, 0 },
/* U+2e8f */ { 30, 0, 19, 0, 0 },
/* U+2e90 */ { 30, 0, 19, 0, 0 },
/* U+2e91 */ { 30, 0, 19, 0, 0 },
/* U+2e92 */ { 30, 0, 19, 0, 0 },
/* U+2e93 */ { 30, 0, 19, 0, 0 },
/* U+2e94 */ { 30, 0, 19, 0, 0 },
/* U+2e95 */ { 30, 0, 19, 0, 0 },
/* U+2e96 */ { 30, 0, 19, 0, 0 },
/* U+2e97 */ { 30, 0, 19, 0, 0 },
/* U+2e98 */ { 30, 0, 19, 0, 0 },
/* U+2e99 */ { 30, 0, 19, 0, 0 },
/* U+2e9a */ { 0, 0, 0, 0, 0 },
/* U+2e9b */ { 30, 0, 19, 0, 0 },
/* U+2e9c */ { 30, 0, 19, 0, 0 },
/* U+2e9d */ { 30, 0, 19, 0, 0 },
/* U+2e9e */ { 30, 0, 19, 0, 0 },
/* U+2e9f */ { 30, 0, 19, 0, "<compat> 6BCD" },
/* U+2ea0 */ { 30, 0, 19, 0, 0 },
/* U+2ea1 */ { 30, 0, 19, 0, 0 },
/* U+2ea2 */ { 30, 0, 19, 0, 0 },
/* U+2ea3 */ { 30, 0, 19, 0, 0 },
/* U+2ea4 */ { 30, 0, 19, 0, 0 },
/* U+2ea5 */ { 30, 0, 19, 0, 0 },
/* U+2ea6 */ { 30, 0, 19, 0, 0 },
/* U+2ea7 */ { 30, 0, 19, 0, 0 },
/* U+2ea8 */ { 30, 0, 19, 0, 0 },
/* U+2ea9 */ { 30, 0, 19, 0, 0 },
/* U+2eaa */ { 30, 0, 19, 0, 0 },
/* U+2eab */ { 30, 0, 19, 0, 0 },
/* U+2eac */ { 30, 0, 19, 0, 0 },
/* U+2ead */ { 30, 0, 19, 0, 0 },
/* U+2eae */ { 30, 0, 19, 0, 0 },
/* U+2eaf */ { 30, 0, 19, 0, 0 },
/* U+2eb0 */ { 30, 0, 19, 0, 0 },
/* U+2eb1 */ { 30, 0, 19, 0, 0 },
/* U+2eb2 */ { 30, 0, 19, 0, 0 },
/* U+2eb3 */ { 30, 0, 19, 0, 0 },
/* U+2eb4 */ { 30, 0, 19, 0, 0 },
/* U+2eb5 */ { 30, 0, 19, 0, 0 },
/* U+2eb6 */ { 30, 0, 19, 0, 0 },
/* U+2eb7 */ { 30, 0, 19, 0, 0 },
/* U+2eb8 */ { 30, 0, 19, 0, 0 },
/* U+2eb9 */ { 30, 0, 19, 0, 0 },
/* U+2eba */ { 30, 0, 19, 0, 0 },
/* U+2ebb */ { 30, 0, 19, 0, 0 },
/* U+2ebc */ { 30, 0, 19, 0, 0 },
/* U+2ebd */ { 30, 0, 19, 0, 0 },
/* U+2ebe */ { 30, 0, 19, 0, 0 },
/* U+2ebf */ { 30, 0, 19, 0, 0 },
/* U+2ec0 */ { 30, 0, 19, 0, 0 },
/* U+2ec1 */ { 30, 0, 19, 0, 0 },
/* U+2ec2 */ { 30, 0, 19, 0, 0 },
/* U+2ec3 */ { 30, 0, 19, 0, 0 },
/* U+2ec4 */ { 30, 0, 19, 0, 0 },
/* U+2ec5 */ { 30, 0, 19, 0, 0 },
/* U+2ec6 */ { 30, 0, 19, 0, 0 },
/* U+2ec7 */ { 30, 0, 19, 0, 0 },
/* U+2ec8 */ { 30, 0, 19, 0, 0 },
/* U+2ec9 */ { 30, 0, 19, 0, 0 },
/* U+2eca */ { 30, 0, 19, 0, 0 },
/* U+2ecb */ { 30, 0, 19, 0, 0 },
/* U+2ecc */ { 30, 0, 19, 0, 0 },
/* U+2ecd */ { 30, 0, 19, 0, 0 },
/* U+2ece */ { 30, 0, 19, 0, 0 },
/* U+2ecf */ { 30, 0, 19, 0, 0 },
/* U+2ed0 */ { 30, 0, 19, 0, 0 },
/* U+2ed1 */ { 30, 0, 19, 0, 0 },
/* U+2ed2 */ { 30, 0, 19, 0, 0 },
/* U+2ed3 */ { 30, 0, 19, 0, 0 },
/* U+2ed4 */ { 30, 0, 19, 0, 0 },
/* U+2ed5 */ { 30, 0, 19, 0, 0 },
/* U+2ed6 */ { 30, 0, 19, 0, 0 },
/* U+2ed7 */ { 30, 0, 19, 0, 0 },
/* U+2ed8 */ { 30, 0, 19, 0, 0 },
/* U+2ed9 */ { 30, 0, 19, 0, 0 },
/* U+2eda */ { 30, 0, 19, 0, 0 },
/* U+2edb */ { 30, 0, 19, 0, 0 },
/* U+2edc */ { 30, 0, 19, 0, 0 },
/* U+2edd */ { 30, 0, 19, 0, 0 },
/* U+2ede */ { 30, 0, 19, 0, 0 },
/* U+2edf */ { 30, 0, 19, 0, 0 },
/* U+2ee0 */ { 30, 0, 19, 0, 0 },
/* U+2ee1 */ { 30, 0, 19, 0, 0 },
/* U+2ee2 */ { 30, 0, 19, 0, 0 },
/* U+2ee3 */ { 30, 0, 19, 0, 0 },
/* U+2ee4 */ { 30, 0, 19, 0, 0 },
/* U+2ee5 */ { 30, 0, 19, 0, 0 },
/* U+2ee6 */ { 30, 0, 19, 0, 0 },
/* U+2ee7 */ { 30, 0, 19, 0, 0 },
/* U+2ee8 */ { 30, 0, 19, 0, 0 },
/* U+2ee9 */ { 30, 0, 19, 0, 0 },
/* U+2eea */ { 30, 0, 19, 0, 0 },
/* U+2eeb */ { 30, 0, 19, 0, 0 },
/* U+2eec */ { 30, 0, 19, 0, 0 },
/* U+2eed */ { 30, 0, 19, 0, 0 },
/* U+2eee */ { 30, 0, 19, 0, 0 },
/* U+2eef */ { 30, 0, 19, 0, 0 },
/* U+2ef0 */ { 30, 0, 19, 0, 0 },
/* U+2ef1 */ { 30, 0, 19, 0, 0 },
/* U+2ef2 */ { 30, 0, 19, 0, 0 },
/* U+2ef3 */ { 30, 0, 19, 0, "<compat> 9F9F" },
/* U+2ef4 */ { 0, 0, 0, 0, 0 },
/* U+2ef5 */ { 0, 0, 0, 0, 0 },
/* U+2ef6 */ { 0, 0, 0, 0, 0 },
/* U+2ef7 */ { 0, 0, 0, 0, 0 },
/* U+2ef8 */ { 0, 0, 0, 0, 0 },
/* U+2ef9 */ { 0, 0, 0, 0, 0 },
/* U+2efa */ { 0, 0, 0, 0, 0 },
/* U+2efb */ { 0, 0, 0, 0, 0 },
/* U+2efc */ { 0, 0, 0, 0, 0 },
/* U+2efd */ { 0, 0, 0, 0, 0 },
/* U+2efe */ { 0, 0, 0, 0, 0 },
/* U+2eff */ { 0, 0, 0, 0, 0 },
/* U+2f00 */ { 30, 0, 19, 0, "<compat> 4E00" },
/* U+2f01 */ { 30, 0, 19, 0, "<compat> 4E28" },
/* U+2f02 */ { 30, 0, 19, 0, "<compat> 4E36" },
/* U+2f03 */ { 30, 0, 19, 0, "<compat> 4E3F" },
/* U+2f04 */ { 30, 0, 19, 0, "<compat> 4E59" },
/* U+2f05 */ { 30, 0, 19, 0, "<compat> 4E85" },
/* U+2f06 */ { 30, 0, 19, 0, "<compat> 4E8C" },
/* U+2f07 */ { 30, 0, 19, 0, "<compat> 4EA0" },
/* U+2f08 */ { 30, 0, 19, 0, "<compat> 4EBA" },
/* U+2f09 */ { 30, 0, 19, 0, "<compat> 513F" },
/* U+2f0a */ { 30, 0, 19, 0, "<compat> 5165" },
/* U+2f0b */ { 30, 0, 19, 0, "<compat> 516B" },
/* U+2f0c */ { 30, 0, 19, 0, "<compat> 5182" },
/* U+2f0d */ { 30, 0, 19, 0, "<compat> 5196" },
/* U+2f0e */ { 30, 0, 19, 0, "<compat> 51AB" },
/* U+2f0f */ { 30, 0, 19, 0, "<compat> 51E0" },
/* U+2f10 */ { 30, 0, 19, 0, "<compat> 51F5" },
/* U+2f11 */ { 30, 0, 19, 0, "<compat> 5200" },
/* U+2f12 */ { 30, 0, 19, 0, "<compat> 529B" },
/* U+2f13 */ { 30, 0, 19, 0, "<compat> 52F9" },
/* U+2f14 */ { 30, 0, 19, 0, "<compat> 5315" },
/* U+2f15 */ { 30, 0, 19, 0, "<compat> 531A" },
/* U+2f16 */ { 30, 0, 19, 0, "<compat> 5338" },
/* U+2f17 */ { 30, 0, 19, 0, "<compat> 5341" },
/* U+2f18 */ { 30, 0, 19, 0, "<compat> 535C" },
/* U+2f19 */ { 30, 0, 19, 0, "<compat> 5369" },
/* U+2f1a */ { 30, 0, 19, 0, "<compat> 5382" },
/* U+2f1b */ { 30, 0, 19, 0, "<compat> 53B6" },
/* U+2f1c */ { 30, 0, 19, 0, "<compat> 53C8" },
/* U+2f1d */ { 30, 0, 19, 0, "<compat> 53E3" },
/* U+2f1e */ { 30, 0, 19, 0, "<compat> 56D7" },
/* U+2f1f */ { 30, 0, 19, 0, "<compat> 571F" },
/* U+2f20 */ { 30, 0, 19, 0, "<compat> 58EB" },
/* U+2f21 */ { 30, 0, 19, 0, "<compat> 5902" },
/* U+2f22 */ { 30, 0, 19, 0, "<compat> 590A" },
/* U+2f23 */ { 30, 0, 19, 0, "<compat> 5915" },
/* U+2f24 */ { 30, 0, 19, 0, "<compat> 5927" },
/* U+2f25 */ { 30, 0, 19, 0, "<compat> 5973" },
/* U+2f26 */ { 30, 0, 19, 0, "<compat> 5B50" },
/* U+2f27 */ { 30, 0, 19, 0, "<compat> 5B80" },
/* U+2f28 */ { 30, 0, 19, 0, "<compat> 5BF8" },
/* U+2f29 */ { 30, 0, 19, 0, "<compat> 5C0F" },
/* U+2f2a */ { 30, 0, 19, 0, "<compat> 5C22" },
/* U+2f2b */ { 30, 0, 19, 0, "<compat> 5C38" },
/* U+2f2c */ { 30, 0, 19, 0, "<compat> 5C6E" },
/* U+2f2d */ { 30, 0, 19, 0, "<compat> 5C71" },
/* U+2f2e */ { 30, 0, 19, 0, "<compat> 5DDB" },
/* U+2f2f */ { 30, 0, 19, 0, "<compat> 5DE5" },
/* U+2f30 */ { 30, 0, 19, 0, "<compat> 5DF1" },
/* U+2f31 */ { 30, 0, 19, 0, "<compat> 5DFE" },
/* U+2f32 */ { 30, 0, 19, 0, "<compat> 5E72" },
/* U+2f33 */ { 30, 0, 19, 0, "<compat> 5E7A" },
/* U+2f34 */ { 30, 0, 19, 0, "<compat> 5E7F" },
/* U+2f35 */ { 30, 0, 19, 0, "<compat> 5EF4" },
/* U+2f36 */ { 30, 0, 19, 0, "<compat> 5EFE" },
/* U+2f37 */ { 30, 0, 19, 0, "<compat> 5F0B" },
/* U+2f38 */ { 30, 0, 19, 0, "<compat> 5F13" },
/* U+2f39 */ { 30, 0, 19, 0, "<compat> 5F50" },
/* U+2f3a */ { 30, 0, 19, 0, "<compat> 5F61" },
/* U+2f3b */ { 30, 0, 19, 0, "<compat> 5F73" },
/* U+2f3c */ { 30, 0, 19, 0, "<compat> 5FC3" },
/* U+2f3d */ { 30, 0, 19, 0, "<compat> 6208" },
/* U+2f3e */ { 30, 0, 19, 0, "<compat> 6236" },
/* U+2f3f */ { 30, 0, 19, 0, "<compat> 624B" },
/* U+2f40 */ { 30, 0, 19, 0, "<compat> 652F" },
/* U+2f41 */ { 30, 0, 19, 0, "<compat> 6534" },
/* U+2f42 */ { 30, 0, 19, 0, "<compat> 6587" },
/* U+2f43 */ { 30, 0, 19, 0, "<compat> 6597" },
/* U+2f44 */ { 30, 0, 19, 0, "<compat> 65A4" },
/* U+2f45 */ { 30, 0, 19, 0, "<compat> 65B9" },
/* U+2f46 */ { 30, 0, 19, 0, "<compat> 65E0" },
/* U+2f47 */ { 30, 0, 19, 0, "<compat> 65E5" },
/* U+2f48 */ { 30, 0, 19, 0, "<compat> 66F0" },
/* U+2f49 */ { 30, 0, 19, 0, "<compat> 6708" },
/* U+2f4a */ { 30, 0, 19, 0, "<compat> 6728" },
/* U+2f4b */ { 30, 0, 19, 0, "<compat> 6B20" },
/* U+2f4c */ { 30, 0, 19, 0, "<compat> 6B62" },
/* U+2f4d */ { 30, 0, 19, 0, "<compat> 6B79" },
/* U+2f4e */ { 30, 0, 19, 0, "<compat> 6BB3" },
/* U+2f4f */ { 30, 0, 19, 0, "<compat> 6BCB" },
/* U+2f50 */ { 30, 0, 19, 0, "<compat> 6BD4" },
/* U+2f51 */ { 30, 0, 19, 0, "<compat> 6BDB" },
/* U+2f52 */ { 30, 0, 19, 0, "<compat> 6C0F" },
/* U+2f53 */ { 30, 0, 19, 0, "<compat> 6C14" },
/* U+2f54 */ { 30, 0, 19, 0, "<compat> 6C34" },
/* U+2f55 */ { 30, 0, 19, 0, "<compat> 706B" },
/* U+2f56 */ { 30, 0, 19, 0, "<compat> 722A" },
/* U+2f57 */ { 30, 0, 19, 0, "<compat> 7236" },
/* U+2f58 */ { 30, 0, 19, 0, "<compat> 723B" },
/* U+2f59 */ { 30, 0, 19, 0, "<compat> 723F" },
/* U+2f5a */ { 30, 0, 19, 0, "<compat> 7247" },
/* U+2f5b */ { 30, 0, 19, 0, "<compat> 7259" },
/* U+2f5c */ { 30, 0, 19, 0, "<compat> 725B" },
/* U+2f5d */ { 30, 0, 19, 0, "<compat> 72AC" },
/* U+2f5e */ { 30, 0, 19, 0, "<compat> 7384" },
/* U+2f5f */ { 30, 0, 19, 0, "<compat> 7389" },
/* U+2f60 */ { 30, 0, 19, 0, "<compat> 74DC" },
/* U+2f61 */ { 30, 0, 19, 0, "<compat> 74E6" },
/* U+2f62 */ { 30, 0, 19, 0, "<compat> 7518" },
/* U+2f63 */ { 30, 0, 19, 0, "<compat> 751F" },
/* U+2f64 */ { 30, 0, 19, 0, "<compat> 7528" },
/* U+2f65 */ { 30, 0, 19, 0, "<compat> 7530" },
/* U+2f66 */ { 30, 0, 19, 0, "<compat> 758B" },
/* U+2f67 */ { 30, 0, 19, 0, "<compat> 7592" },
/* U+2f68 */ { 30, 0, 19, 0, "<compat> 7676" },
/* U+2f69 */ { 30, 0, 19, 0, "<compat> 767D" },
/* U+2f6a */ { 30, 0, 19, 0, "<compat> 76AE" },
/* U+2f6b */ { 30, 0, 19, 0, "<compat> 76BF" },
/* U+2f6c */ { 30, 0, 19, 0, "<compat> 76EE" },
/* U+2f6d */ { 30, 0, 19, 0, "<compat> 77DB" },
/* U+2f6e */ { 30, 0, 19, 0, "<compat> 77E2" },
/* U+2f6f */ { 30, 0, 19, 0, "<compat> 77F3" },
/* U+2f70 */ { 30, 0, 19, 0, "<compat> 793A" },
/* U+2f71 */ { 30, 0, 19, 0, "<compat> 79B8" },
/* U+2f72 */ { 30, 0, 19, 0, "<compat> 79BE" },
/* U+2f73 */ { 30, 0, 19, 0, "<compat> 7A74" },
/* U+2f74 */ { 30, 0, 19, 0, "<compat> 7ACB" },
/* U+2f75 */ { 30, 0, 19, 0, "<compat> 7AF9" },
/* U+2f76 */ { 30, 0, 19, 0, "<compat> 7C73" },
/* U+2f77 */ { 30, 0, 19, 0, "<compat> 7CF8" },
/* U+2f78 */ { 30, 0, 19, 0, "<compat> 7F36" },
/* U+2f79 */ { 30, 0, 19, 0, "<compat> 7F51" },
/* U+2f7a */ { 30, 0, 19, 0, "<compat> 7F8A" },
/* U+2f7b */ { 30, 0, 19, 0, "<compat> 7FBD" },
/* U+2f7c */ { 30, 0, 19, 0, "<compat> 8001" },
/* U+2f7d */ { 30, 0, 19, 0, "<compat> 800C" },
/* U+2f7e */ { 30, 0, 19, 0, "<compat> 8012" },
/* U+2f7f */ { 30, 0, 19, 0, "<compat> 8033" },
/* U+2f80 */ { 30, 0, 19, 0, "<compat> 807F" },
/* U+2f81 */ { 30, 0, 19, 0, "<compat> 8089" },
/* U+2f82 */ { 30, 0, 19, 0, "<compat> 81E3" },
/* U+2f83 */ { 30, 0, 19, 0, "<compat> 81EA" },
/* U+2f84 */ { 30, 0, 19, 0, "<compat> 81F3" },
/* U+2f85 */ { 30, 0, 19, 0, "<compat> 81FC" },
/* U+2f86 */ { 30, 0, 19, 0, "<compat> 820C" },
/* U+2f87 */ { 30, 0, 19, 0, "<compat> 821B" },
/* U+2f88 */ { 30, 0, 19, 0, "<compat> 821F" },
/* U+2f89 */ { 30, 0, 19, 0, "<compat> 826E" },
/* U+2f8a */ { 30, 0, 19, 0, "<compat> 8272" },
/* U+2f8b */ { 30, 0, 19, 0, "<compat> 8278" },
/* U+2f8c */ { 30, 0, 19, 0, "<compat> 864D" },
/* U+2f8d */ { 30, 0, 19, 0, "<compat> 866B" },
/* U+2f8e */ { 30, 0, 19, 0, "<compat> 8840" },
/* U+2f8f */ { 30, 0, 19, 0, "<compat> 884C" },
/* U+2f90 */ { 30, 0, 19, 0, "<compat> 8863" },
/* U+2f91 */ { 30, 0, 19, 0, "<compat> 897E" },
/* U+2f92 */ { 30, 0, 19, 0, "<compat> 898B" },
/* U+2f93 */ { 30, 0, 19, 0, "<compat> 89D2" },
/* U+2f94 */ { 30, 0, 19, 0, "<compat> 8A00" },
/* U+2f95 */ { 30, 0, 19, 0, "<compat> 8C37" },
/* U+2f96 */ { 30, 0, 19, 0, "<compat> 8C46" },
/* U+2f97 */ { 30, 0, 19, 0, "<compat> 8C55" },
/* U+2f98 */ { 30, 0, 19, 0, "<compat> 8C78" },
/* U+2f99 */ { 30, 0, 19, 0, "<compat> 8C9D" },
/* U+2f9a */ { 30, 0, 19, 0, "<compat> 8D64" },
/* U+2f9b */ { 30, 0, 19, 0, "<compat> 8D70" },
/* U+2f9c */ { 30, 0, 19, 0, "<compat> 8DB3" },
/* U+2f9d */ { 30, 0, 19, 0, "<compat> 8EAB" },
/* U+2f9e */ { 30, 0, 19, 0, "<compat> 8ECA" },
/* U+2f9f */ { 30, 0, 19, 0, "<compat> 8F9B" },
/* U+2fa0 */ { 30, 0, 19, 0, "<compat> 8FB0" },
/* U+2fa1 */ { 30, 0, 19, 0, "<compat> 8FB5" },
/* U+2fa2 */ { 30, 0, 19, 0, "<compat> 9091" },
/* U+2fa3 */ { 30, 0, 19, 0, "<compat> 9149" },
/* U+2fa4 */ { 30, 0, 19, 0, "<compat> 91C6" },
/* U+2fa5 */ { 30, 0, 19, 0, "<compat> 91CC" },
/* U+2fa6 */ { 30, 0, 19, 0, "<compat> 91D1" },
/* U+2fa7 */ { 30, 0, 19, 0, "<compat> 9577" },
/* U+2fa8 */ { 30, 0, 19, 0, "<compat> 9580" },
/* U+2fa9 */ { 30, 0, 19, 0, "<compat> 961C" },
/* U+2faa */ { 30, 0, 19, 0, "<compat> 96B6" },
/* U+2fab */ { 30, 0, 19, 0, "<compat> 96B9" },
/* U+2fac */ { 30, 0, 19, 0, "<compat> 96E8" },
/* U+2fad */ { 30, 0, 19, 0, "<compat> 9751" },
/* U+2fae */ { 30, 0, 19, 0, "<compat> 975E" },
/* U+2faf */ { 30, 0, 19, 0, "<compat> 9762" },
/* U+2fb0 */ { 30, 0, 19, 0, "<compat> 9769" },
/* U+2fb1 */ { 30, 0, 19, 0, "<compat> 97CB" },
/* U+2fb2 */ { 30, 0, 19, 0, "<compat> 97ED" },
/* U+2fb3 */ { 30, 0, 19, 0, "<compat> 97F3" },
/* U+2fb4 */ { 30, 0, 19, 0, "<compat> 9801" },
/* U+2fb5 */ { 30, 0, 19, 0, "<compat> 98A8" },
/* U+2fb6 */ { 30, 0, 19, 0, "<compat> 98DB" },
/* U+2fb7 */ { 30, 0, 19, 0, "<compat> 98DF" },
/* U+2fb8 */ { 30, 0, 19, 0, "<compat> 9996" },
/* U+2fb9 */ { 30, 0, 19, 0, "<compat> 9999" },
/* U+2fba */ { 30, 0, 19, 0, "<compat> 99AC" },
/* U+2fbb */ { 30, 0, 19, 0, "<compat> 9AA8" },
/* U+2fbc */ { 30, 0, 19, 0, "<compat> 9AD8" },
/* U+2fbd */ { 30, 0, 19, 0, "<compat> 9ADF" },
/* U+2fbe */ { 30, 0, 19, 0, "<compat> 9B25" },
/* U+2fbf */ { 30, 0, 19, 0, "<compat> 9B2F" },
/* U+2fc0 */ { 30, 0, 19, 0, "<compat> 9B32" },
/* U+2fc1 */ { 30, 0, 19, 0, "<compat> 9B3C" },
/* U+2fc2 */ { 30, 0, 19, 0, "<compat> 9B5A" },
/* U+2fc3 */ { 30, 0, 19, 0, "<compat> 9CE5" },
/* U+2fc4 */ { 30, 0, 19, 0, "<compat> 9E75" },
/* U+2fc5 */ { 30, 0, 19, 0, "<compat> 9E7F" },
/* U+2fc6 */ { 30, 0, 19, 0, "<compat> 9EA5" },
/* U+2fc7 */ { 30, 0, 19, 0, "<compat> 9EBB" },
/* U+2fc8 */ { 30, 0, 19, 0, "<compat> 9EC3" },
/* U+2fc9 */ { 30, 0, 19, 0, "<compat> 9ECD" },
/* U+2fca */ { 30, 0, 19, 0, "<compat> 9ED1" },
/* U+2fcb */ { 30, 0, 19, 0, "<compat> 9EF9" },
/* U+2fcc */ { 30, 0, 19, 0, "<compat> 9EFD" },
/* U+2fcd */ { 30, 0, 19, 0, "<compat> 9F0E" },
/* U+2fce */ { 30, 0, 19, 0, "<compat> 9F13" },
/* U+2fcf */ { 30, 0, 19, 0, "<compat> 9F20" },
/* U+2fd0 */ { 30, 0, 19, 0, "<compat> 9F3B" },
/* U+2fd1 */ { 30, 0, 19, 0, "<compat> 9F4A" },
/* U+2fd2 */ { 30, 0, 19, 0, "<compat> 9F52" },
/* U+2fd3 */ { 30, 0, 19, 0, "<compat> 9F8D" },
/* U+2fd4 */ { 30, 0, 19, 0, "<compat> 9F9C" },
/* U+2fd5 */ { 30, 0, 19, 0, "<compat> 9FA0" },
/* U+2fd6 */ { 0, 0, 0, 0, 0 },
/* U+2fd7 */ { 0, 0, 0, 0, 0 },
/* U+2fd8 */ { 0, 0, 0, 0, 0 },
/* U+2fd9 */ { 0, 0, 0, 0, 0 },
/* U+2fda */ { 0, 0, 0, 0, 0 },
/* U+2fdb */ { 0, 0, 0, 0, 0 },
/* U+2fdc */ { 0, 0, 0, 0, 0 },
/* U+2fdd */ { 0, 0, 0, 0, 0 },
/* U+2fde */ { 0, 0, 0, 0, 0 },
/* U+2fdf */ { 0, 0, 0, 0, 0 },
/* U+2fe0 */ { 0, 0, 0, 0, 0 },
/* U+2fe1 */ { 0, 0, 0, 0, 0 },
/* U+2fe2 */ { 0, 0, 0, 0, 0 },
/* U+2fe3 */ { 0, 0, 0, 0, 0 },
/* U+2fe4 */ { 0, 0, 0, 0, 0 },
/* U+2fe5 */ { 0, 0, 0, 0, 0 },
/* U+2fe6 */ { 0, 0, 0, 0, 0 },
/* U+2fe7 */ { 0, 0, 0, 0, 0 },
/* U+2fe8 */ { 0, 0, 0, 0, 0 },
/* U+2fe9 */ { 0, 0, 0, 0, 0 },
/* U+2fea */ { 0, 0, 0, 0, 0 },
/* U+2feb */ { 0, 0, 0, 0, 0 },
/* U+2fec */ { 0, 0, 0, 0, 0 },
/* U+2fed */ { 0, 0, 0, 0, 0 },
/* U+2fee */ { 0, 0, 0, 0, 0 },
/* U+2fef */ { 0, 0, 0, 0, 0 },
/* U+2ff0 */ { 30, 0, 19, 0, 0 },
/* U+2ff1 */ { 30, 0, 19, 0, 0 },
/* U+2ff2 */ { 30, 0, 19, 0, 0 },
/* U+2ff3 */ { 30, 0, 19, 0, 0 },
/* U+2ff4 */ { 30, 0, 19, 0, 0 },
/* U+2ff5 */ { 30, 0, 19, 0, 0 },
/* U+2ff6 */ { 30, 0, 19, 0, 0 },
/* U+2ff7 */ { 30, 0, 19, 0, 0 },
/* U+2ff8 */ { 30, 0, 19, 0, 0 },
/* U+2ff9 */ { 30, 0, 19, 0, 0 },
/* U+2ffa */ { 30, 0, 19, 0, 0 },
/* U+2ffb */ { 30, 0, 19, 0, 0 },
/* U+2ffc */ { 0, 0, 0, 0, 0 },
/* U+2ffd */ { 0, 0, 0, 0, 0 },
/* U+2ffe */ { 0, 0, 0, 0, 0 },
/* U+2fff */ { 0, 0, 0, 0, 0 },

};

const _PyUnicode_DatabaseRecord _PyUnicode_Database_3[4096] = {
    
/* U+3000 */ { 10, 0, 18, 0, "<wide> 0020" },
/* U+3001 */ { 26, 0, 19, 0, 0 },
/* U+3002 */ { 26, 0, 19, 0, 0 },
/* U+3003 */ { 26, 0, 19, 0, 0 },
/* U+3004 */ { 30, 0, 19, 0, 0 },
/* U+3005 */ { 18, 0, 1, 0, 0 },
/* U+3006 */ { 19, 0, 1, 0, 0 },
/* U+3007 */ { 8, 0, 1, 0, 0 },
/* U+3008 */ { 22, 0, 19, 1, 0 },
/* U+3009 */ { 23, 0, 19, 1, 0 },
/* U+300a */ { 22, 0, 19, 1, 0 },
/* U+300b */ { 23, 0, 19, 1, 0 },
/* U+300c */ { 22, 0, 19, 1, 0 },
/* U+300d */ { 23, 0, 19, 1, 0 },
/* U+300e */ { 22, 0, 19, 1, 0 },
/* U+300f */ { 23, 0, 19, 1, 0 },
/* U+3010 */ { 22, 0, 19, 1, 0 },
/* U+3011 */ { 23, 0, 19, 1, 0 },
/* U+3012 */ { 30, 0, 19, 0, 0 },
/* U+3013 */ { 30, 0, 19, 0, 0 },
/* U+3014 */ { 22, 0, 19, 1, 0 },
/* U+3015 */ { 23, 0, 19, 1, 0 },
/* U+3016 */ { 22, 0, 19, 1, 0 },
/* U+3017 */ { 23, 0, 19, 1, 0 },
/* U+3018 */ { 22, 0, 19, 1, 0 },
/* U+3019 */ { 23, 0, 19, 1, 0 },
/* U+301a */ { 22, 0, 19, 1, 0 },
/* U+301b */ { 23, 0, 19, 1, 0 },
/* U+301c */ { 21, 0, 19, 0, 0 },
/* U+301d */ { 22, 0, 19, 0, 0 },
/* U+301e */ { 23, 0, 19, 0, 0 },
/* U+301f */ { 23, 0, 19, 0, 0 },
/* U+3020 */ { 30, 0, 19, 0, 0 },
/* U+3021 */ { 8, 0, 1, 0, 0 },
/* U+3022 */ { 8, 0, 1, 0, 0 },
/* U+3023 */ { 8, 0, 1, 0, 0 },
/* U+3024 */ { 8, 0, 1, 0, 0 },
/* U+3025 */ { 8, 0, 1, 0, 0 },
/* U+3026 */ { 8, 0, 1, 0, 0 },
/* U+3027 */ { 8, 0, 1, 0, 0 },
/* U+3028 */ { 8, 0, 1, 0, 0 },
/* U+3029 */ { 8, 0, 1, 0, 0 },
/* U+302a */ { 4, 218, 14, 0, 0 },
/* U+302b */ { 4, 228, 14, 0, 0 },
/* U+302c */ { 4, 232, 14, 0, 0 },
/* U+302d */ { 4, 222, 14, 0, 0 },
/* U+302e */ { 4, 224, 14, 0, 0 },
/* U+302f */ { 4, 224, 14, 0, 0 },
/* U+3030 */ { 21, 0, 19, 0, 0 },
/* U+3031 */ { 18, 0, 1, 0, 0 },
/* U+3032 */ { 18, 0, 1, 0, 0 },
/* U+3033 */ { 18, 0, 1, 0, 0 },
/* U+3034 */ { 18, 0, 1, 0, 0 },
/* U+3035 */ { 18, 0, 1, 0, 0 },
/* U+3036 */ { 30, 0, 19, 0, "<compat> 3012" },
/* U+3037 */ { 30, 0, 19, 0, 0 },
/* U+3038 */ { 8, 0, 1, 0, "<compat> 5341" },
/* U+3039 */ { 8, 0, 1, 0, "<compat> 5344" },
/* U+303a */ { 8, 0, 1, 0, "<compat> 5345" },
/* U+303b */ { 0, 0, 0, 0, 0 },
/* U+303c */ { 0, 0, 0, 0, 0 },
/* U+303d */ { 0, 0, 0, 0, 0 },
/* U+303e */ { 30, 0, 19, 0, 0 },
/* U+303f */ { 30, 0, 19, 0, 0 },
/* U+3040 */ { 0, 0, 0, 0, 0 },
/* U+3041 */ { 19, 0, 1, 0, 0 },
/* U+3042 */ { 19, 0, 1, 0, 0 },
/* U+3043 */ { 19, 0, 1, 0, 0 },
/* U+3044 */ { 19, 0, 1, 0, 0 },
/* U+3045 */ { 19, 0, 1, 0, 0 },
/* U+3046 */ { 19, 0, 1, 0, 0 },
/* U+3047 */ { 19, 0, 1, 0, 0 },
/* U+3048 */ { 19, 0, 1, 0, 0 },
/* U+3049 */ { 19, 0, 1, 0, 0 },
/* U+304a */ { 19, 0, 1, 0, 0 },
/* U+304b */ { 19, 0, 1, 0, 0 },
/* U+304c */ { 19, 0, 1, 0, "304B 3099" },
/* U+304d */ { 19, 0, 1, 0, 0 },
/* U+304e */ { 19, 0, 1, 0, "304D 3099" },
/* U+304f */ { 19, 0, 1, 0, 0 },
/* U+3050 */ { 19, 0, 1, 0, "304F 3099" },
/* U+3051 */ { 19, 0, 1, 0, 0 },
/* U+3052 */ { 19, 0, 1, 0, "3051 3099" },
/* U+3053 */ { 19, 0, 1, 0, 0 },
/* U+3054 */ { 19, 0, 1, 0, "3053 3099" },
/* U+3055 */ { 19, 0, 1, 0, 0 },
/* U+3056 */ { 19, 0, 1, 0, "3055 3099" },
/* U+3057 */ { 19, 0, 1, 0, 0 },
/* U+3058 */ { 19, 0, 1, 0, "3057 3099" },
/* U+3059 */ { 19, 0, 1, 0, 0 },
/* U+305a */ { 19, 0, 1, 0, "3059 3099" },
/* U+305b */ { 19, 0, 1, 0, 0 },
/* U+305c */ { 19, 0, 1, 0, "305B 3099" },
/* U+305d */ { 19, 0, 1, 0, 0 },
/* U+305e */ { 19, 0, 1, 0, "305D 3099" },
/* U+305f */ { 19, 0, 1, 0, 0 },
/* U+3060 */ { 19, 0, 1, 0, "305F 3099" },
/* U+3061 */ { 19, 0, 1, 0, 0 },
/* U+3062 */ { 19, 0, 1, 0, "3061 3099" },
/* U+3063 */ { 19, 0, 1, 0, 0 },
/* U+3064 */ { 19, 0, 1, 0, 0 },
/* U+3065 */ { 19, 0, 1, 0, "3064 3099" },
/* U+3066 */ { 19, 0, 1, 0, 0 },
/* U+3067 */ { 19, 0, 1, 0, "3066 3099" },
/* U+3068 */ { 19, 0, 1, 0, 0 },
/* U+3069 */ { 19, 0, 1, 0, "3068 3099" },
/* U+306a */ { 19, 0, 1, 0, 0 },
/* U+306b */ { 19, 0, 1, 0, 0 },
/* U+306c */ { 19, 0, 1, 0, 0 },
/* U+306d */ { 19, 0, 1, 0, 0 },
/* U+306e */ { 19, 0, 1, 0, 0 },
/* U+306f */ { 19, 0, 1, 0, 0 },
/* U+3070 */ { 19, 0, 1, 0, "306F 3099" },
/* U+3071 */ { 19, 0, 1, 0, "306F 309A" },
/* U+3072 */ { 19, 0, 1, 0, 0 },
/* U+3073 */ { 19, 0, 1, 0, "3072 3099" },
/* U+3074 */ { 19, 0, 1, 0, "3072 309A" },
/* U+3075 */ { 19, 0, 1, 0, 0 },
/* U+3076 */ { 19, 0, 1, 0, "3075 3099" },
/* U+3077 */ { 19, 0, 1, 0, "3075 309A" },
/* U+3078 */ { 19, 0, 1, 0, 0 },
/* U+3079 */ { 19, 0, 1, 0, "3078 3099" },
/* U+307a */ { 19, 0, 1, 0, "3078 309A" },
/* U+307b */ { 19, 0, 1, 0, 0 },
/* U+307c */ { 19, 0, 1, 0, "307B 3099" },
/* U+307d */ { 19, 0, 1, 0, "307B 309A" },
/* U+307e */ { 19, 0, 1, 0, 0 },
/* U+307f */ { 19, 0, 1, 0, 0 },
/* U+3080 */ { 19, 0, 1, 0, 0 },
/* U+3081 */ { 19, 0, 1, 0, 0 },
/* U+3082 */ { 19, 0, 1, 0, 0 },
/* U+3083 */ { 19, 0, 1, 0, 0 },
/* U+3084 */ { 19, 0, 1, 0, 0 },
/* U+3085 */ { 19, 0, 1, 0, 0 },
/* U+3086 */ { 19, 0, 1, 0, 0 },
/* U+3087 */ { 19, 0, 1, 0, 0 },
/* U+3088 */ { 19, 0, 1, 0, 0 },
/* U+3089 */ { 19, 0, 1, 0, 0 },
/* U+308a */ { 19, 0, 1, 0, 0 },
/* U+308b */ { 19, 0, 1, 0, 0 },
/* U+308c */ { 19, 0, 1, 0, 0 },
/* U+308d */ { 19, 0, 1, 0, 0 },
/* U+308e */ { 19, 0, 1, 0, 0 },
/* U+308f */ { 19, 0, 1, 0, 0 },
/* U+3090 */ { 19, 0, 1, 0, 0 },
/* U+3091 */ { 19, 0, 1, 0, 0 },
/* U+3092 */ { 19, 0, 1, 0, 0 },
/* U+3093 */ { 19, 0, 1, 0, 0 },
/* U+3094 */ { 19, 0, 1, 0, "3046 3099" },
/* U+3095 */ { 0, 0, 0, 0, 0 },
/* U+3096 */ { 0, 0, 0, 0, 0 },
/* U+3097 */ { 0, 0, 0, 0, 0 },
/* U+3098 */ { 0, 0, 0, 0, 0 },
/* U+3099 */ { 4, 8, 14, 0, 0 },
/* U+309a */ { 4, 8, 14, 0, 0 },
/* U+309b */ { 29, 0, 19, 0, "<compat> 0020 3099" },
/* U+309c */ { 29, 0, 19, 0, "<compat> 0020 309A" },
/* U+309d */ { 18, 0, 1, 0, 0 },
/* U+309e */ { 18, 0, 1, 0, "309D 3099" },
/* U+309f */ { 0, 0, 0, 0, 0 },
/* U+30a0 */ { 0, 0, 0, 0, 0 },
/* U+30a1 */ { 19, 0, 1, 0, 0 },
/* U+30a2 */ { 19, 0, 1, 0, 0 },
/* U+30a3 */ { 19, 0, 1, 0, 0 },
/* U+30a4 */ { 19, 0, 1, 0, 0 },
/* U+30a5 */ { 19, 0, 1, 0, 0 },
/* U+30a6 */ { 19, 0, 1, 0, 0 },
/* U+30a7 */ { 19, 0, 1, 0, 0 },
/* U+30a8 */ { 19, 0, 1, 0, 0 },
/* U+30a9 */ { 19, 0, 1, 0, 0 },
/* U+30aa */ { 19, 0, 1, 0, 0 },
/* U+30ab */ { 19, 0, 1, 0, 0 },
/* U+30ac */ { 19, 0, 1, 0, "30AB 3099" },
/* U+30ad */ { 19, 0, 1, 0, 0 },
/* U+30ae */ { 19, 0, 1, 0, "30AD 3099" },
/* U+30af */ { 19, 0, 1, 0, 0 },
/* U+30b0 */ { 19, 0, 1, 0, "30AF 3099" },
/* U+30b1 */ { 19, 0, 1, 0, 0 },
/* U+30b2 */ { 19, 0, 1, 0, "30B1 3099" },
/* U+30b3 */ { 19, 0, 1, 0, 0 },
/* U+30b4 */ { 19, 0, 1, 0, "30B3 3099" },
/* U+30b5 */ { 19, 0, 1, 0, 0 },
/* U+30b6 */ { 19, 0, 1, 0, "30B5 3099" },
/* U+30b7 */ { 19, 0, 1, 0, 0 },
/* U+30b8 */ { 19, 0, 1, 0, "30B7 3099" },
/* U+30b9 */ { 19, 0, 1, 0, 0 },
/* U+30ba */ { 19, 0, 1, 0, "30B9 3099" },
/* U+30bb */ { 19, 0, 1, 0, 0 },
/* U+30bc */ { 19, 0, 1, 0, "30BB 3099" },
/* U+30bd */ { 19, 0, 1, 0, 0 },
/* U+30be */ { 19, 0, 1, 0, "30BD 3099" },
/* U+30bf */ { 19, 0, 1, 0, 0 },
/* U+30c0 */ { 19, 0, 1, 0, "30BF 3099" },
/* U+30c1 */ { 19, 0, 1, 0, 0 },
/* U+30c2 */ { 19, 0, 1, 0, "30C1 3099" },
/* U+30c3 */ { 19, 0, 1, 0, 0 },
/* U+30c4 */ { 19, 0, 1, 0, 0 },
/* U+30c5 */ { 19, 0, 1, 0, "30C4 3099" },
/* U+30c6 */ { 19, 0, 1, 0, 0 },
/* U+30c7 */ { 19, 0, 1, 0, "30C6 3099" },
/* U+30c8 */ { 19, 0, 1, 0, 0 },
/* U+30c9 */ { 19, 0, 1, 0, "30C8 3099" },
/* U+30ca */ { 19, 0, 1, 0, 0 },
/* U+30cb */ { 19, 0, 1, 0, 0 },
/* U+30cc */ { 19, 0, 1, 0, 0 },
/* U+30cd */ { 19, 0, 1, 0, 0 },
/* U+30ce */ { 19, 0, 1, 0, 0 },
/* U+30cf */ { 19, 0, 1, 0, 0 },
/* U+30d0 */ { 19, 0, 1, 0, "30CF 3099" },
/* U+30d1 */ { 19, 0, 1, 0, "30CF 309A" },
/* U+30d2 */ { 19, 0, 1, 0, 0 },
/* U+30d3 */ { 19, 0, 1, 0, "30D2 3099" },
/* U+30d4 */ { 19, 0, 1, 0, "30D2 309A" },
/* U+30d5 */ { 19, 0, 1, 0, 0 },
/* U+30d6 */ { 19, 0, 1, 0, "30D5 3099" },
/* U+30d7 */ { 19, 0, 1, 0, "30D5 309A" },
/* U+30d8 */ { 19, 0, 1, 0, 0 },
/* U+30d9 */ { 19, 0, 1, 0, "30D8 3099" },
/* U+30da */ { 19, 0, 1, 0, "30D8 309A" },
/* U+30db */ { 19, 0, 1, 0, 0 },
/* U+30dc */ { 19, 0, 1, 0, "30DB 3099" },
/* U+30dd */ { 19, 0, 1, 0, "30DB 309A" },
/* U+30de */ { 19, 0, 1, 0, 0 },
/* U+30df */ { 19, 0, 1, 0, 0 },
/* U+30e0 */ { 19, 0, 1, 0, 0 },
/* U+30e1 */ { 19, 0, 1, 0, 0 },
/* U+30e2 */ { 19, 0, 1, 0, 0 },
/* U+30e3 */ { 19, 0, 1, 0, 0 },
/* U+30e4 */ { 19, 0, 1, 0, 0 },
/* U+30e5 */ { 19, 0, 1, 0, 0 },
/* U+30e6 */ { 19, 0, 1, 0, 0 },
/* U+30e7 */ { 19, 0, 1, 0, 0 },
/* U+30e8 */ { 19, 0, 1, 0, 0 },
/* U+30e9 */ { 19, 0, 1, 0, 0 },
/* U+30ea */ { 19, 0, 1, 0, 0 },
/* U+30eb */ { 19, 0, 1, 0, 0 },
/* U+30ec */ { 19, 0, 1, 0, 0 },
/* U+30ed */ { 19, 0, 1, 0, 0 },
/* U+30ee */ { 19, 0, 1, 0, 0 },
/* U+30ef */ { 19, 0, 1, 0, 0 },
/* U+30f0 */ { 19, 0, 1, 0, 0 },
/* U+30f1 */ { 19, 0, 1, 0, 0 },
/* U+30f2 */ { 19, 0, 1, 0, 0 },
/* U+30f3 */ { 19, 0, 1, 0, 0 },
/* U+30f4 */ { 19, 0, 1, 0, "30A6 3099" },
/* U+30f5 */ { 19, 0, 1, 0, 0 },
/* U+30f6 */ { 19, 0, 1, 0, 0 },
/* U+30f7 */ { 19, 0, 1, 0, "30EF 3099" },
/* U+30f8 */ { 19, 0, 1, 0, "30F0 3099" },
/* U+30f9 */ { 19, 0, 1, 0, "30F1 3099" },
/* U+30fa */ { 19, 0, 1, 0, "30F2 3099" },
/* U+30fb */ { 20, 0, 19, 0, 0 },
/* U+30fc */ { 18, 0, 1, 0, 0 },
/* U+30fd */ { 18, 0, 1, 0, 0 },
/* U+30fe */ { 18, 0, 1, 0, "30FD 3099" },
/* U+30ff */ { 0, 0, 0, 0, 0 },
/* U+3100 */ { 0, 0, 0, 0, 0 },
/* U+3101 */ { 0, 0, 0, 0, 0 },
/* U+3102 */ { 0, 0, 0, 0, 0 },
/* U+3103 */ { 0, 0, 0, 0, 0 },
/* U+3104 */ { 0, 0, 0, 0, 0 },
/* U+3105 */ { 19, 0, 1, 0, 0 },
/* U+3106 */ { 19, 0, 1, 0, 0 },
/* U+3107 */ { 19, 0, 1, 0, 0 },
/* U+3108 */ { 19, 0, 1, 0, 0 },
/* U+3109 */ { 19, 0, 1, 0, 0 },
/* U+310a */ { 19, 0, 1, 0, 0 },
/* U+310b */ { 19, 0, 1, 0, 0 },
/* U+310c */ { 19, 0, 1, 0, 0 },
/* U+310d */ { 19, 0, 1, 0, 0 },
/* U+310e */ { 19, 0, 1, 0, 0 },
/* U+310f */ { 19, 0, 1, 0, 0 },
/* U+3110 */ { 19, 0, 1, 0, 0 },
/* U+3111 */ { 19, 0, 1, 0, 0 },
/* U+3112 */ { 19, 0, 1, 0, 0 },
/* U+3113 */ { 19, 0, 1, 0, 0 },
/* U+3114 */ { 19, 0, 1, 0, 0 },
/* U+3115 */ { 19, 0, 1, 0, 0 },
/* U+3116 */ { 19, 0, 1, 0, 0 },
/* U+3117 */ { 19, 0, 1, 0, 0 },
/* U+3118 */ { 19, 0, 1, 0, 0 },
/* U+3119 */ { 19, 0, 1, 0, 0 },
/* U+311a */ { 19, 0, 1, 0, 0 },
/* U+311b */ { 19, 0, 1, 0, 0 },
/* U+311c */ { 19, 0, 1, 0, 0 },
/* U+311d */ { 19, 0, 1, 0, 0 },
/* U+311e */ { 19, 0, 1, 0, 0 },
/* U+311f */ { 19, 0, 1, 0, 0 },
/* U+3120 */ { 19, 0, 1, 0, 0 },
/* U+3121 */ { 19, 0, 1, 0, 0 },
/* U+3122 */ { 19, 0, 1, 0, 0 },
/* U+3123 */ { 19, 0, 1, 0, 0 },
/* U+3124 */ { 19, 0, 1, 0, 0 },
/* U+3125 */ { 19, 0, 1, 0, 0 },
/* U+3126 */ { 19, 0, 1, 0, 0 },
/* U+3127 */ { 19, 0, 1, 0, 0 },
/* U+3128 */ { 19, 0, 1, 0, 0 },
/* U+3129 */ { 19, 0, 1, 0, 0 },
/* U+312a */ { 19, 0, 1, 0, 0 },
/* U+312b */ { 19, 0, 1, 0, 0 },
/* U+312c */ { 19, 0, 1, 0, 0 },
/* U+312d */ { 0, 0, 0, 0, 0 },
/* U+312e */ { 0, 0, 0, 0, 0 },
/* U+312f */ { 0, 0, 0, 0, 0 },
/* U+3130 */ { 0, 0, 0, 0, 0 },
/* U+3131 */ { 19, 0, 1, 0, "<compat> 1100" },
/* U+3132 */ { 19, 0, 1, 0, "<compat> 1101" },
/* U+3133 */ { 19, 0, 1, 0, "<compat> 11AA" },
/* U+3134 */ { 19, 0, 1, 0, "<compat> 1102" },
/* U+3135 */ { 19, 0, 1, 0, "<compat> 11AC" },
/* U+3136 */ { 19, 0, 1, 0, "<compat> 11AD" },
/* U+3137 */ { 19, 0, 1, 0, "<compat> 1103" },
/* U+3138 */ { 19, 0, 1, 0, "<compat> 1104" },
/* U+3139 */ { 19, 0, 1, 0, "<compat> 1105" },
/* U+313a */ { 19, 0, 1, 0, "<compat> 11B0" },
/* U+313b */ { 19, 0, 1, 0, "<compat> 11B1" },
/* U+313c */ { 19, 0, 1, 0, "<compat> 11B2" },
/* U+313d */ { 19, 0, 1, 0, "<compat> 11B3" },
/* U+313e */ { 19, 0, 1, 0, "<compat> 11B4" },
/* U+313f */ { 19, 0, 1, 0, "<compat> 11B5" },
/* U+3140 */ { 19, 0, 1, 0, "<compat> 111A" },
/* U+3141 */ { 19, 0, 1, 0, "<compat> 1106" },
/* U+3142 */ { 19, 0, 1, 0, "<compat> 1107" },
/* U+3143 */ { 19, 0, 1, 0, "<compat> 1108" },
/* U+3144 */ { 19, 0, 1, 0, "<compat> 1121" },
/* U+3145 */ { 19, 0, 1, 0, "<compat> 1109" },
/* U+3146 */ { 19, 0, 1, 0, "<compat> 110A" },
/* U+3147 */ { 19, 0, 1, 0, "<compat> 110B" },
/* U+3148 */ { 19, 0, 1, 0, "<compat> 110C" },
/* U+3149 */ { 19, 0, 1, 0, "<compat> 110D" },
/* U+314a */ { 19, 0, 1, 0, "<compat> 110E" },
/* U+314b */ { 19, 0, 1, 0, "<compat> 110F" },
/* U+314c */ { 19, 0, 1, 0, "<compat> 1110" },
/* U+314d */ { 19, 0, 1, 0, "<compat> 1111" },
/* U+314e */ { 19, 0, 1, 0, "<compat> 1112" },
/* U+314f */ { 19, 0, 1, 0, "<compat> 1161" },
/* U+3150 */ { 19, 0, 1, 0, "<compat> 1162" },
/* U+3151 */ { 19, 0, 1, 0, "<compat> 1163" },
/* U+3152 */ { 19, 0, 1, 0, "<compat> 1164" },
/* U+3153 */ { 19, 0, 1, 0, "<compat> 1165" },
/* U+3154 */ { 19, 0, 1, 0, "<compat> 1166" },
/* U+3155 */ { 19, 0, 1, 0, "<compat> 1167" },
/* U+3156 */ { 19, 0, 1, 0, "<compat> 1168" },
/* U+3157 */ { 19, 0, 1, 0, "<compat> 1169" },
/* U+3158 */ { 19, 0, 1, 0, "<compat> 116A" },
/* U+3159 */ { 19, 0, 1, 0, "<compat> 116B" },
/* U+315a */ { 19, 0, 1, 0, "<compat> 116C" },
/* U+315b */ { 19, 0, 1, 0, "<compat> 116D" },
/* U+315c */ { 19, 0, 1, 0, "<compat> 116E" },
/* U+315d */ { 19, 0, 1, 0, "<compat> 116F" },
/* U+315e */ { 19, 0, 1, 0, "<compat> 1170" },
/* U+315f */ { 19, 0, 1, 0, "<compat> 1171" },
/* U+3160 */ { 19, 0, 1, 0, "<compat> 1172" },
/* U+3161 */ { 19, 0, 1, 0, "<compat> 1173" },
/* U+3162 */ { 19, 0, 1, 0, "<compat> 1174" },
/* U+3163 */ { 19, 0, 1, 0, "<compat> 1175" },
/* U+3164 */ { 19, 0, 1, 0, "<compat> 1160" },
/* U+3165 */ { 19, 0, 1, 0, "<compat> 1114" },
/* U+3166 */ { 19, 0, 1, 0, "<compat> 1115" },
/* U+3167 */ { 19, 0, 1, 0, "<compat> 11C7" },
/* U+3168 */ { 19, 0, 1, 0, "<compat> 11C8" },
/* U+3169 */ { 19, 0, 1, 0, "<compat> 11CC" },
/* U+316a */ { 19, 0, 1, 0, "<compat> 11CE" },
/* U+316b */ { 19, 0, 1, 0, "<compat> 11D3" },
/* U+316c */ { 19, 0, 1, 0, "<compat> 11D7" },
/* U+316d */ { 19, 0, 1, 0, "<compat> 11D9" },
/* U+316e */ { 19, 0, 1, 0, "<compat> 111C" },
/* U+316f */ { 19, 0, 1, 0, "<compat> 11DD" },
/* U+3170 */ { 19, 0, 1, 0, "<compat> 11DF" },
/* U+3171 */ { 19, 0, 1, 0, "<compat> 111D" },
/* U+3172 */ { 19, 0, 1, 0, "<compat> 111E" },
/* U+3173 */ { 19, 0, 1, 0, "<compat> 1120" },
/* U+3174 */ { 19, 0, 1, 0, "<compat> 1122" },
/* U+3175 */ { 19, 0, 1, 0, "<compat> 1123" },
/* U+3176 */ { 19, 0, 1, 0, "<compat> 1127" },
/* U+3177 */ { 19, 0, 1, 0, "<compat> 1129" },
/* U+3178 */ { 19, 0, 1, 0, "<compat> 112B" },
/* U+3179 */ { 19, 0, 1, 0, "<compat> 112C" },
/* U+317a */ { 19, 0, 1, 0, "<compat> 112D" },
/* U+317b */ { 19, 0, 1, 0, "<compat> 112E" },
/* U+317c */ { 19, 0, 1, 0, "<compat> 112F" },
/* U+317d */ { 19, 0, 1, 0, "<compat> 1132" },
/* U+317e */ { 19, 0, 1, 0, "<compat> 1136" },
/* U+317f */ { 19, 0, 1, 0, "<compat> 1140" },
/* U+3180 */ { 19, 0, 1, 0, "<compat> 1147" },
/* U+3181 */ { 19, 0, 1, 0, "<compat> 114C" },
/* U+3182 */ { 19, 0, 1, 0, "<compat> 11F1" },
/* U+3183 */ { 19, 0, 1, 0, "<compat> 11F2" },
/* U+3184 */ { 19, 0, 1, 0, "<compat> 1157" },
/* U+3185 */ { 19, 0, 1, 0, "<compat> 1158" },
/* U+3186 */ { 19, 0, 1, 0, "<compat> 1159" },
/* U+3187 */ { 19, 0, 1, 0, "<compat> 1184" },
/* U+3188 */ { 19, 0, 1, 0, "<compat> 1185" },
/* U+3189 */ { 19, 0, 1, 0, "<compat> 1188" },
/* U+318a */ { 19, 0, 1, 0, "<compat> 1191" },
/* U+318b */ { 19, 0, 1, 0, "<compat> 1192" },
/* U+318c */ { 19, 0, 1, 0, "<compat> 1194" },
/* U+318d */ { 19, 0, 1, 0, "<compat> 119E" },
/* U+318e */ { 19, 0, 1, 0, "<compat> 11A1" },
/* U+318f */ { 0, 0, 0, 0, 0 },
/* U+3190 */ { 30, 0, 1, 0, 0 },
/* U+3191 */ { 30, 0, 1, 0, 0 },
/* U+3192 */ { 9, 0, 1, 0, "<super> 4E00" },
/* U+3193 */ { 9, 0, 1, 0, "<super> 4E8C" },
/* U+3194 */ { 9, 0, 1, 0, "<super> 4E09" },
/* U+3195 */ { 9, 0, 1, 0, "<super> 56DB" },
/* U+3196 */ { 30, 0, 1, 0, "<super> 4E0A" },
/* U+3197 */ { 30, 0, 1, 0, "<super> 4E2D" },
/* U+3198 */ { 30, 0, 1, 0, "<super> 4E0B" },
/* U+3199 */ { 30, 0, 1, 0, "<super> 7532" },
/* U+319a */ { 30, 0, 1, 0, "<super> 4E59" },
/* U+319b */ { 30, 0, 1, 0, "<super> 4E19" },
/* U+319c */ { 30, 0, 1, 0, "<super> 4E01" },
/* U+319d */ { 30, 0, 1, 0, "<super> 5929" },
/* U+319e */ { 30, 0, 1, 0, "<super> 5730" },
/* U+319f */ { 30, 0, 1, 0, "<super> 4EBA" },
/* U+31a0 */ { 19, 0, 1, 0, 0 },
/* U+31a1 */ { 19, 0, 1, 0, 0 },
/* U+31a2 */ { 19, 0, 1, 0, 0 },
/* U+31a3 */ { 19, 0, 1, 0, 0 },
/* U+31a4 */ { 19, 0, 1, 0, 0 },
/* U+31a5 */ { 19, 0, 1, 0, 0 },
/* U+31a6 */ { 19, 0, 1, 0, 0 },
/* U+31a7 */ { 19, 0, 1, 0, 0 },
/* U+31a8 */ { 19, 0, 1, 0, 0 },
/* U+31a9 */ { 19, 0, 1, 0, 0 },
/* U+31aa */ { 19, 0, 1, 0, 0 },
/* U+31ab */ { 19, 0, 1, 0, 0 },
/* U+31ac */ { 19, 0, 1, 0, 0 },
/* U+31ad */ { 19, 0, 1, 0, 0 },
/* U+31ae */ { 19, 0, 1, 0, 0 },
/* U+31af */ { 19, 0, 1, 0, 0 },
/* U+31b0 */ { 19, 0, 1, 0, 0 },
/* U+31b1 */ { 19, 0, 1, 0, 0 },
/* U+31b2 */ { 19, 0, 1, 0, 0 },
/* U+31b3 */ { 19, 0, 1, 0, 0 },
/* U+31b4 */ { 19, 0, 1, 0, 0 },
/* U+31b5 */ { 19, 0, 1, 0, 0 },
/* U+31b6 */ { 19, 0, 1, 0, 0 },
/* U+31b7 */ { 19, 0, 1, 0, 0 },
/* U+31b8 */ { 0, 0, 0, 0, 0 },
/* U+31b9 */ { 0, 0, 0, 0, 0 },
/* U+31ba */ { 0, 0, 0, 0, 0 },
/* U+31bb */ { 0, 0, 0, 0, 0 },
/* U+31bc */ { 0, 0, 0, 0, 0 },
/* U+31bd */ { 0, 0, 0, 0, 0 },
/* U+31be */ { 0, 0, 0, 0, 0 },
/* U+31bf */ { 0, 0, 0, 0, 0 },
/* U+31c0 */ { 0, 0, 0, 0, 0 },
/* U+31c1 */ { 0, 0, 0, 0, 0 },
/* U+31c2 */ { 0, 0, 0, 0, 0 },
/* U+31c3 */ { 0, 0, 0, 0, 0 },
/* U+31c4 */ { 0, 0, 0, 0, 0 },
/* U+31c5 */ { 0, 0, 0, 0, 0 },
/* U+31c6 */ { 0, 0, 0, 0, 0 },
/* U+31c7 */ { 0, 0, 0, 0, 0 },
/* U+31c8 */ { 0, 0, 0, 0, 0 },
/* U+31c9 */ { 0, 0, 0, 0, 0 },
/* U+31ca */ { 0, 0, 0, 0, 0 },
/* U+31cb */ { 0, 0, 0, 0, 0 },
/* U+31cc */ { 0, 0, 0, 0, 0 },
/* U+31cd */ { 0, 0, 0, 0, 0 },
/* U+31ce */ { 0, 0, 0, 0, 0 },
/* U+31cf */ { 0, 0, 0, 0, 0 },
/* U+31d0 */ { 0, 0, 0, 0, 0 },
/* U+31d1 */ { 0, 0, 0, 0, 0 },
/* U+31d2 */ { 0, 0, 0, 0, 0 },
/* U+31d3 */ { 0, 0, 0, 0, 0 },
/* U+31d4 */ { 0, 0, 0, 0, 0 },
/* U+31d5 */ { 0, 0, 0, 0, 0 },
/* U+31d6 */ { 0, 0, 0, 0, 0 },
/* U+31d7 */ { 0, 0, 0, 0, 0 },
/* U+31d8 */ { 0, 0, 0, 0, 0 },
/* U+31d9 */ { 0, 0, 0, 0, 0 },
/* U+31da */ { 0, 0, 0, 0, 0 },
/* U+31db */ { 0, 0, 0, 0, 0 },
/* U+31dc */ { 0, 0, 0, 0, 0 },
/* U+31dd */ { 0, 0, 0, 0, 0 },
/* U+31de */ { 0, 0, 0, 0, 0 },
/* U+31df */ { 0, 0, 0, 0, 0 },
/* U+31e0 */ { 0, 0, 0, 0, 0 },
/* U+31e1 */ { 0, 0, 0, 0, 0 },
/* U+31e2 */ { 0, 0, 0, 0, 0 },
/* U+31e3 */ { 0, 0, 0, 0, 0 },
/* U+31e4 */ { 0, 0, 0, 0, 0 },
/* U+31e5 */ { 0, 0, 0, 0, 0 },
/* U+31e6 */ { 0, 0, 0, 0, 0 },
/* U+31e7 */ { 0, 0, 0, 0, 0 },
/* U+31e8 */ { 0, 0, 0, 0, 0 },
/* U+31e9 */ { 0, 0, 0, 0, 0 },
/* U+31ea */ { 0, 0, 0, 0, 0 },
/* U+31eb */ { 0, 0, 0, 0, 0 },
/* U+31ec */ { 0, 0, 0, 0, 0 },
/* U+31ed */ { 0, 0, 0, 0, 0 },
/* U+31ee */ { 0, 0, 0, 0, 0 },
/* U+31ef */ { 0, 0, 0, 0, 0 },
/* U+31f0 */ { 0, 0, 0, 0, 0 },
/* U+31f1 */ { 0, 0, 0, 0, 0 },
/* U+31f2 */ { 0, 0, 0, 0, 0 },
/* U+31f3 */ { 0, 0, 0, 0, 0 },
/* U+31f4 */ { 0, 0, 0, 0, 0 },
/* U+31f5 */ { 0, 0, 0, 0, 0 },
/* U+31f6 */ { 0, 0, 0, 0, 0 },
/* U+31f7 */ { 0, 0, 0, 0, 0 },
/* U+31f8 */ { 0, 0, 0, 0, 0 },
/* U+31f9 */ { 0, 0, 0, 0, 0 },
/* U+31fa */ { 0, 0, 0, 0, 0 },
/* U+31fb */ { 0, 0, 0, 0, 0 },
/* U+31fc */ { 0, 0, 0, 0, 0 },
/* U+31fd */ { 0, 0, 0, 0, 0 },
/* U+31fe */ { 0, 0, 0, 0, 0 },
/* U+31ff */ { 0, 0, 0, 0, 0 },
/* U+3200 */ { 30, 0, 1, 0, "<compat> 0028 1100 0029" },
/* U+3201 */ { 30, 0, 1, 0, "<compat> 0028 1102 0029" },
/* U+3202 */ { 30, 0, 1, 0, "<compat> 0028 1103 0029" },
/* U+3203 */ { 30, 0, 1, 0, "<compat> 0028 1105 0029" },
/* U+3204 */ { 30, 0, 1, 0, "<compat> 0028 1106 0029" },
/* U+3205 */ { 30, 0, 1, 0, "<compat> 0028 1107 0029" },
/* U+3206 */ { 30, 0, 1, 0, "<compat> 0028 1109 0029" },
/* U+3207 */ { 30, 0, 1, 0, "<compat> 0028 110B 0029" },
/* U+3208 */ { 30, 0, 1, 0, "<compat> 0028 110C 0029" },
/* U+3209 */ { 30, 0, 1, 0, "<compat> 0028 110E 0029" },
/* U+320a */ { 30, 0, 1, 0, "<compat> 0028 110F 0029" },
/* U+320b */ { 30, 0, 1, 0, "<compat> 0028 1110 0029" },
/* U+320c */ { 30, 0, 1, 0, "<compat> 0028 1111 0029" },
/* U+320d */ { 30, 0, 1, 0, "<compat> 0028 1112 0029" },
/* U+320e */ { 30, 0, 1, 0, "<compat> 0028 1100 1161 0029" },
/* U+320f */ { 30, 0, 1, 0, "<compat> 0028 1102 1161 0029" },
/* U+3210 */ { 30, 0, 1, 0, "<compat> 0028 1103 1161 0029" },
/* U+3211 */ { 30, 0, 1, 0, "<compat> 0028 1105 1161 0029" },
/* U+3212 */ { 30, 0, 1, 0, "<compat> 0028 1106 1161 0029" },
/* U+3213 */ { 30, 0, 1, 0, "<compat> 0028 1107 1161 0029" },
/* U+3214 */ { 30, 0, 1, 0, "<compat> 0028 1109 1161 0029" },
/* U+3215 */ { 30, 0, 1, 0, "<compat> 0028 110B 1161 0029" },
/* U+3216 */ { 30, 0, 1, 0, "<compat> 0028 110C 1161 0029" },
/* U+3217 */ { 30, 0, 1, 0, "<compat> 0028 110E 1161 0029" },
/* U+3218 */ { 30, 0, 1, 0, "<compat> 0028 110F 1161 0029" },
/* U+3219 */ { 30, 0, 1, 0, "<compat> 0028 1110 1161 0029" },
/* U+321a */ { 30, 0, 1, 0, "<compat> 0028 1111 1161 0029" },
/* U+321b */ { 30, 0, 1, 0, "<compat> 0028 1112 1161 0029" },
/* U+321c */ { 30, 0, 1, 0, "<compat> 0028 110C 116E 0029" },
/* U+321d */ { 0, 0, 0, 0, 0 },
/* U+321e */ { 0, 0, 0, 0, 0 },
/* U+321f */ { 0, 0, 0, 0, 0 },
/* U+3220 */ { 9, 0, 1, 0, "<compat> 0028 4E00 0029" },
/* U+3221 */ { 9, 0, 1, 0, "<compat> 0028 4E8C 0029" },
/* U+3222 */ { 9, 0, 1, 0, "<compat> 0028 4E09 0029" },
/* U+3223 */ { 9, 0, 1, 0, "<compat> 0028 56DB 0029" },
/* U+3224 */ { 9, 0, 1, 0, "<compat> 0028 4E94 0029" },
/* U+3225 */ { 9, 0, 1, 0, "<compat> 0028 516D 0029" },
/* U+3226 */ { 9, 0, 1, 0, "<compat> 0028 4E03 0029" },
/* U+3227 */ { 9, 0, 1, 0, "<compat> 0028 516B 0029" },
/* U+3228 */ { 9, 0, 1, 0, "<compat> 0028 4E5D 0029" },
/* U+3229 */ { 9, 0, 1, 0, "<compat> 0028 5341 0029" },
/* U+322a */ { 30, 0, 1, 0, "<compat> 0028 6708 0029" },
/* U+322b */ { 30, 0, 1, 0, "<compat> 0028 706B 0029" },
/* U+322c */ { 30, 0, 1, 0, "<compat> 0028 6C34 0029" },
/* U+322d */ { 30, 0, 1, 0, "<compat> 0028 6728 0029" },
/* U+322e */ { 30, 0, 1, 0, "<compat> 0028 91D1 0029" },
/* U+322f */ { 30, 0, 1, 0, "<compat> 0028 571F 0029" },
/* U+3230 */ { 30, 0, 1, 0, "<compat> 0028 65E5 0029" },
/* U+3231 */ { 30, 0, 1, 0, "<compat> 0028 682A 0029" },
/* U+3232 */ { 30, 0, 1, 0, "<compat> 0028 6709 0029" },
/* U+3233 */ { 30, 0, 1, 0, "<compat> 0028 793E 0029" },
/* U+3234 */ { 30, 0, 1, 0, "<compat> 0028 540D 0029" },
/* U+3235 */ { 30, 0, 1, 0, "<compat> 0028 7279 0029" },
/* U+3236 */ { 30, 0, 1, 0, "<compat> 0028 8CA1 0029" },
/* U+3237 */ { 30, 0, 1, 0, "<compat> 0028 795D 0029" },
/* U+3238 */ { 30, 0, 1, 0, "<compat> 0028 52B4 0029" },
/* U+3239 */ { 30, 0, 1, 0, "<compat> 0028 4EE3 0029" },
/* U+323a */ { 30, 0, 1, 0, "<compat> 0028 547C 0029" },
/* U+323b */ { 30, 0, 1, 0, "<compat> 0028 5B66 0029" },
/* U+323c */ { 30, 0, 1, 0, "<compat> 0028 76E3 0029" },
/* U+323d */ { 30, 0, 1, 0, "<compat> 0028 4F01 0029" },
/* U+323e */ { 30, 0, 1, 0, "<compat> 0028 8CC7 0029" },
/* U+323f */ { 30, 0, 1, 0, "<compat> 0028 5354 0029" },
/* U+3240 */ { 30, 0, 1, 0, "<compat> 0028 796D 0029" },
/* U+3241 */ { 30, 0, 1, 0, "<compat> 0028 4F11 0029" },
/* U+3242 */ { 30, 0, 1, 0, "<compat> 0028 81EA 0029" },
/* U+3243 */ { 30, 0, 1, 0, "<compat> 0028 81F3 0029" },
/* U+3244 */ { 0, 0, 0, 0, 0 },
/* U+3245 */ { 0, 0, 0, 0, 0 },
/* U+3246 */ { 0, 0, 0, 0, 0 },
/* U+3247 */ { 0, 0, 0, 0, 0 },
/* U+3248 */ { 0, 0, 0, 0, 0 },
/* U+3249 */ { 0, 0, 0, 0, 0 },
/* U+324a */ { 0, 0, 0, 0, 0 },
/* U+324b */ { 0, 0, 0, 0, 0 },
/* U+324c */ { 0, 0, 0, 0, 0 },
/* U+324d */ { 0, 0, 0, 0, 0 },
/* U+324e */ { 0, 0, 0, 0, 0 },
/* U+324f */ { 0, 0, 0, 0, 0 },
/* U+3250 */ { 0, 0, 0, 0, 0 },
/* U+3251 */ { 0, 0, 0, 0, 0 },
/* U+3252 */ { 0, 0, 0, 0, 0 },
/* U+3253 */ { 0, 0, 0, 0, 0 },
/* U+3254 */ { 0, 0, 0, 0, 0 },
/* U+3255 */ { 0, 0, 0, 0, 0 },
/* U+3256 */ { 0, 0, 0, 0, 0 },
/* U+3257 */ { 0, 0, 0, 0, 0 },
/* U+3258 */ { 0, 0, 0, 0, 0 },
/* U+3259 */ { 0, 0, 0, 0, 0 },
/* U+325a */ { 0, 0, 0, 0, 0 },
/* U+325b */ { 0, 0, 0, 0, 0 },
/* U+325c */ { 0, 0, 0, 0, 0 },
/* U+325d */ { 0, 0, 0, 0, 0 },
/* U+325e */ { 0, 0, 0, 0, 0 },
/* U+325f */ { 0, 0, 0, 0, 0 },
/* U+3260 */ { 30, 0, 1, 0, "<circle> 1100" },
/* U+3261 */ { 30, 0, 1, 0, "<circle> 1102" },
/* U+3262 */ { 30, 0, 1, 0, "<circle> 1103" },
/* U+3263 */ { 30, 0, 1, 0, "<circle> 1105" },
/* U+3264 */ { 30, 0, 1, 0, "<circle> 1106" },
/* U+3265 */ { 30, 0, 1, 0, "<circle> 1107" },
/* U+3266 */ { 30, 0, 1, 0, "<circle> 1109" },
/* U+3267 */ { 30, 0, 1, 0, "<circle> 110B" },
/* U+3268 */ { 30, 0, 1, 0, "<circle> 110C" },
/* U+3269 */ { 30, 0, 1, 0, "<circle> 110E" },
/* U+326a */ { 30, 0, 1, 0, "<circle> 110F" },
/* U+326b */ { 30, 0, 1, 0, "<circle> 1110" },
/* U+326c */ { 30, 0, 1, 0, "<circle> 1111" },
/* U+326d */ { 30, 0, 1, 0, "<circle> 1112" },
/* U+326e */ { 30, 0, 1, 0, "<circle> 1100 1161" },
/* U+326f */ { 30, 0, 1, 0, "<circle> 1102 1161" },
/* U+3270 */ { 30, 0, 1, 0, "<circle> 1103 1161" },
/* U+3271 */ { 30, 0, 1, 0, "<circle> 1105 1161" },
/* U+3272 */ { 30, 0, 1, 0, "<circle> 1106 1161" },
/* U+3273 */ { 30, 0, 1, 0, "<circle> 1107 1161" },
/* U+3274 */ { 30, 0, 1, 0, "<circle> 1109 1161" },
/* U+3275 */ { 30, 0, 1, 0, "<circle> 110B 1161" },
/* U+3276 */ { 30, 0, 1, 0, "<circle> 110C 1161" },
/* U+3277 */ { 30, 0, 1, 0, "<circle> 110E 1161" },
/* U+3278 */ { 30, 0, 1, 0, "<circle> 110F 1161" },
/* U+3279 */ { 30, 0, 1, 0, "<circle> 1110 1161" },
/* U+327a */ { 30, 0, 1, 0, "<circle> 1111 1161" },
/* U+327b */ { 30, 0, 1, 0, "<circle> 1112 1161" },
/* U+327c */ { 0, 0, 0, 0, 0 },
/* U+327d */ { 0, 0, 0, 0, 0 },
/* U+327e */ { 0, 0, 0, 0, 0 },
/* U+327f */ { 30, 0, 1, 0, 0 },
/* U+3280 */ { 9, 0, 1, 0, "<circle> 4E00" },
/* U+3281 */ { 9, 0, 1, 0, "<circle> 4E8C" },
/* U+3282 */ { 9, 0, 1, 0, "<circle> 4E09" },
/* U+3283 */ { 9, 0, 1, 0, "<circle> 56DB" },
/* U+3284 */ { 9, 0, 1, 0, "<circle> 4E94" },
/* U+3285 */ { 9, 0, 1, 0, "<circle> 516D" },
/* U+3286 */ { 9, 0, 1, 0, "<circle> 4E03" },
/* U+3287 */ { 9, 0, 1, 0, "<circle> 516B" },
/* U+3288 */ { 9, 0, 1, 0, "<circle> 4E5D" },
/* U+3289 */ { 9, 0, 1, 0, "<circle> 5341" },
/* U+328a */ { 30, 0, 1, 0, "<circle> 6708" },
/* U+328b */ { 30, 0, 1, 0, "<circle> 706B" },
/* U+328c */ { 30, 0, 1, 0, "<circle> 6C34" },
/* U+328d */ { 30, 0, 1, 0, "<circle> 6728" },
/* U+328e */ { 30, 0, 1, 0, "<circle> 91D1" },
/* U+328f */ { 30, 0, 1, 0, "<circle> 571F" },
/* U+3290 */ { 30, 0, 1, 0, "<circle> 65E5" },
/* U+3291 */ { 30, 0, 1, 0, "<circle> 682A" },
/* U+3292 */ { 30, 0, 1, 0, "<circle> 6709" },
/* U+3293 */ { 30, 0, 1, 0, "<circle> 793E" },
/* U+3294 */ { 30, 0, 1, 0, "<circle> 540D" },
/* U+3295 */ { 30, 0, 1, 0, "<circle> 7279" },
/* U+3296 */ { 30, 0, 1, 0, "<circle> 8CA1" },
/* U+3297 */ { 30, 0, 1, 0, "<circle> 795D" },
/* U+3298 */ { 30, 0, 1, 0, "<circle> 52B4" },
/* U+3299 */ { 30, 0, 1, 0, "<circle> 79D8" },
/* U+329a */ { 30, 0, 1, 0, "<circle> 7537" },
/* U+329b */ { 30, 0, 1, 0, "<circle> 5973" },
/* U+329c */ { 30, 0, 1, 0, "<circle> 9069" },
/* U+329d */ { 30, 0, 1, 0, "<circle> 512A" },
/* U+329e */ { 30, 0, 1, 0, "<circle> 5370" },
/* U+329f */ { 30, 0, 1, 0, "<circle> 6CE8" },
/* U+32a0 */ { 30, 0, 1, 0, "<circle> 9805" },
/* U+32a1 */ { 30, 0, 1, 0, "<circle> 4F11" },
/* U+32a2 */ { 30, 0, 1, 0, "<circle> 5199" },
/* U+32a3 */ { 30, 0, 1, 0, "<circle> 6B63" },
/* U+32a4 */ { 30, 0, 1, 0, "<circle> 4E0A" },
/* U+32a5 */ { 30, 0, 1, 0, "<circle> 4E2D" },
/* U+32a6 */ { 30, 0, 1, 0, "<circle> 4E0B" },
/* U+32a7 */ { 30, 0, 1, 0, "<circle> 5DE6" },
/* U+32a8 */ { 30, 0, 1, 0, "<circle> 53F3" },
/* U+32a9 */ { 30, 0, 1, 0, "<circle> 533B" },
/* U+32aa */ { 30, 0, 1, 0, "<circle> 5B97" },
/* U+32ab */ { 30, 0, 1, 0, "<circle> 5B66" },
/* U+32ac */ { 30, 0, 1, 0, "<circle> 76E3" },
/* U+32ad */ { 30, 0, 1, 0, "<circle> 4F01" },
/* U+32ae */ { 30, 0, 1, 0, "<circle> 8CC7" },
/* U+32af */ { 30, 0, 1, 0, "<circle> 5354" },
/* U+32b0 */ { 30, 0, 1, 0, "<circle> 591C" },
/* U+32b1 */ { 0, 0, 0, 0, 0 },
/* U+32b2 */ { 0, 0, 0, 0, 0 },
/* U+32b3 */ { 0, 0, 0, 0, 0 },
/* U+32b4 */ { 0, 0, 0, 0, 0 },
/* U+32b5 */ { 0, 0, 0, 0, 0 },
/* U+32b6 */ { 0, 0, 0, 0, 0 },
/* U+32b7 */ { 0, 0, 0, 0, 0 },
/* U+32b8 */ { 0, 0, 0, 0, 0 },
/* U+32b9 */ { 0, 0, 0, 0, 0 },
/* U+32ba */ { 0, 0, 0, 0, 0 },
/* U+32bb */ { 0, 0, 0, 0, 0 },
/* U+32bc */ { 0, 0, 0, 0, 0 },
/* U+32bd */ { 0, 0, 0, 0, 0 },
/* U+32be */ { 0, 0, 0, 0, 0 },
/* U+32bf */ { 0, 0, 0, 0, 0 },
/* U+32c0 */ { 30, 0, 1, 0, "<compat> 0031 6708" },
/* U+32c1 */ { 30, 0, 1, 0, "<compat> 0032 6708" },
/* U+32c2 */ { 30, 0, 1, 0, "<compat> 0033 6708" },
/* U+32c3 */ { 30, 0, 1, 0, "<compat> 0034 6708" },
/* U+32c4 */ { 30, 0, 1, 0, "<compat> 0035 6708" },
/* U+32c5 */ { 30, 0, 1, 0, "<compat> 0036 6708" },
/* U+32c6 */ { 30, 0, 1, 0, "<compat> 0037 6708" },
/* U+32c7 */ { 30, 0, 1, 0, "<compat> 0038 6708" },
/* U+32c8 */ { 30, 0, 1, 0, "<compat> 0039 6708" },
/* U+32c9 */ { 30, 0, 1, 0, "<compat> 0031 0030 6708" },
/* U+32ca */ { 30, 0, 1, 0, "<compat> 0031 0031 6708" },
/* U+32cb */ { 30, 0, 1, 0, "<compat> 0031 0032 6708" },
/* U+32cc */ { 0, 0, 0, 0, 0 },
/* U+32cd */ { 0, 0, 0, 0, 0 },
/* U+32ce */ { 0, 0, 0, 0, 0 },
/* U+32cf */ { 0, 0, 0, 0, 0 },
/* U+32d0 */ { 30, 0, 1, 0, "<circle> 30A2" },
/* U+32d1 */ { 30, 0, 1, 0, "<circle> 30A4" },
/* U+32d2 */ { 30, 0, 1, 0, "<circle> 30A6" },
/* U+32d3 */ { 30, 0, 1, 0, "<circle> 30A8" },
/* U+32d4 */ { 30, 0, 1, 0, "<circle> 30AA" },
/* U+32d5 */ { 30, 0, 1, 0, "<circle> 30AB" },
/* U+32d6 */ { 30, 0, 1, 0, "<circle> 30AD" },
/* U+32d7 */ { 30, 0, 1, 0, "<circle> 30AF" },
/* U+32d8 */ { 30, 0, 1, 0, "<circle> 30B1" },
/* U+32d9 */ { 30, 0, 1, 0, "<circle> 30B3" },
/* U+32da */ { 30, 0, 1, 0, "<circle> 30B5" },
/* U+32db */ { 30, 0, 1, 0, "<circle> 30B7" },
/* U+32dc */ { 30, 0, 1, 0, "<circle> 30B9" },
/* U+32dd */ { 30, 0, 1, 0, "<circle> 30BB" },
/* U+32de */ { 30, 0, 1, 0, "<circle> 30BD" },
/* U+32df */ { 30, 0, 1, 0, "<circle> 30BF" },
/* U+32e0 */ { 30, 0, 1, 0, "<circle> 30C1" },
/* U+32e1 */ { 30, 0, 1, 0, "<circle> 30C4" },
/* U+32e2 */ { 30, 0, 1, 0, "<circle> 30C6" },
/* U+32e3 */ { 30, 0, 1, 0, "<circle> 30C8" },
/* U+32e4 */ { 30, 0, 1, 0, "<circle> 30CA" },
/* U+32e5 */ { 30, 0, 1, 0, "<circle> 30CB" },
/* U+32e6 */ { 30, 0, 1, 0, "<circle> 30CC" },
/* U+32e7 */ { 30, 0, 1, 0, "<circle> 30CD" },
/* U+32e8 */ { 30, 0, 1, 0, "<circle> 30CE" },
/* U+32e9 */ { 30, 0, 1, 0, "<circle> 30CF" },
/* U+32ea */ { 30, 0, 1, 0, "<circle> 30D2" },
/* U+32eb */ { 30, 0, 1, 0, "<circle> 30D5" },
/* U+32ec */ { 30, 0, 1, 0, "<circle> 30D8" },
/* U+32ed */ { 30, 0, 1, 0, "<circle> 30DB" },
/* U+32ee */ { 30, 0, 1, 0, "<circle> 30DE" },
/* U+32ef */ { 30, 0, 1, 0, "<circle> 30DF" },
/* U+32f0 */ { 30, 0, 1, 0, "<circle> 30E0" },
/* U+32f1 */ { 30, 0, 1, 0, "<circle> 30E1" },
/* U+32f2 */ { 30, 0, 1, 0, "<circle> 30E2" },
/* U+32f3 */ { 30, 0, 1, 0, "<circle> 30E4" },
/* U+32f4 */ { 30, 0, 1, 0, "<circle> 30E6" },
/* U+32f5 */ { 30, 0, 1, 0, "<circle> 30E8" },
/* U+32f6 */ { 30, 0, 1, 0, "<circle> 30E9" },
/* U+32f7 */ { 30, 0, 1, 0, "<circle> 30EA" },
/* U+32f8 */ { 30, 0, 1, 0, "<circle> 30EB" },
/* U+32f9 */ { 30, 0, 1, 0, "<circle> 30EC" },
/* U+32fa */ { 30, 0, 1, 0, "<circle> 30ED" },
/* U+32fb */ { 30, 0, 1, 0, "<circle> 30EF" },
/* U+32fc */ { 30, 0, 1, 0, "<circle> 30F0" },
/* U+32fd */ { 30, 0, 1, 0, "<circle> 30F1" },
/* U+32fe */ { 30, 0, 1, 0, "<circle> 30F2" },
/* U+32ff */ { 0, 0, 0, 0, 0 },
/* U+3300 */ { 30, 0, 1, 0, "<square> 30A2 30D1 30FC 30C8" },
/* U+3301 */ { 30, 0, 1, 0, "<square> 30A2 30EB 30D5 30A1" },
/* U+3302 */ { 30, 0, 1, 0, "<square> 30A2 30F3 30DA 30A2" },
/* U+3303 */ { 30, 0, 1, 0, "<square> 30A2 30FC 30EB" },
/* U+3304 */ { 30, 0, 1, 0, "<square> 30A4 30CB 30F3 30B0" },
/* U+3305 */ { 30, 0, 1, 0, "<square> 30A4 30F3 30C1" },
/* U+3306 */ { 30, 0, 1, 0, "<square> 30A6 30A9 30F3" },
/* U+3307 */ { 30, 0, 1, 0, "<square> 30A8 30B9 30AF 30FC 30C9" },
/* U+3308 */ { 30, 0, 1, 0, "<square> 30A8 30FC 30AB 30FC" },
/* U+3309 */ { 30, 0, 1, 0, "<square> 30AA 30F3 30B9" },
/* U+330a */ { 30, 0, 1, 0, "<square> 30AA 30FC 30E0" },
/* U+330b */ { 30, 0, 1, 0, "<square> 30AB 30A4 30EA" },
/* U+330c */ { 30, 0, 1, 0, "<square> 30AB 30E9 30C3 30C8" },
/* U+330d */ { 30, 0, 1, 0, "<square> 30AB 30ED 30EA 30FC" },
/* U+330e */ { 30, 0, 1, 0, "<square> 30AC 30ED 30F3" },
/* U+330f */ { 30, 0, 1, 0, "<square> 30AC 30F3 30DE" },
/* U+3310 */ { 30, 0, 1, 0, "<square> 30AE 30AC" },
/* U+3311 */ { 30, 0, 1, 0, "<square> 30AE 30CB 30FC" },
/* U+3312 */ { 30, 0, 1, 0, "<square> 30AD 30E5 30EA 30FC" },
/* U+3313 */ { 30, 0, 1, 0, "<square> 30AE 30EB 30C0 30FC" },
/* U+3314 */ { 30, 0, 1, 0, "<square> 30AD 30ED" },
/* U+3315 */ { 30, 0, 1, 0, "<square> 30AD 30ED 30B0 30E9 30E0" },
/* U+3316 */ { 30, 0, 1, 0, "<square> 30AD 30ED 30E1 30FC 30C8 30EB" },
/* U+3317 */ { 30, 0, 1, 0, "<square> 30AD 30ED 30EF 30C3 30C8" },
/* U+3318 */ { 30, 0, 1, 0, "<square> 30B0 30E9 30E0" },
/* U+3319 */ { 30, 0, 1, 0, "<square> 30B0 30E9 30E0 30C8 30F3" },
/* U+331a */ { 30, 0, 1, 0, "<square> 30AF 30EB 30BC 30A4 30ED" },
/* U+331b */ { 30, 0, 1, 0, "<square> 30AF 30ED 30FC 30CD" },
/* U+331c */ { 30, 0, 1, 0, "<square> 30B1 30FC 30B9" },
/* U+331d */ { 30, 0, 1, 0, "<square> 30B3 30EB 30CA" },
/* U+331e */ { 30, 0, 1, 0, "<square> 30B3 30FC 30DD" },
/* U+331f */ { 30, 0, 1, 0, "<square> 30B5 30A4 30AF 30EB" },
/* U+3320 */ { 30, 0, 1, 0, "<square> 30B5 30F3 30C1 30FC 30E0" },
/* U+3321 */ { 30, 0, 1, 0, "<square> 30B7 30EA 30F3 30B0" },
/* U+3322 */ { 30, 0, 1, 0, "<square> 30BB 30F3 30C1" },
/* U+3323 */ { 30, 0, 1, 0, "<square> 30BB 30F3 30C8" },
/* U+3324 */ { 30, 0, 1, 0, "<square> 30C0 30FC 30B9" },
/* U+3325 */ { 30, 0, 1, 0, "<square> 30C7 30B7" },
/* U+3326 */ { 30, 0, 1, 0, "<square> 30C9 30EB" },
/* U+3327 */ { 30, 0, 1, 0, "<square> 30C8 30F3" },
/* U+3328 */ { 30, 0, 1, 0, "<square> 30CA 30CE" },
/* U+3329 */ { 30, 0, 1, 0, "<square> 30CE 30C3 30C8" },
/* U+332a */ { 30, 0, 1, 0, "<square> 30CF 30A4 30C4" },
/* U+332b */ { 30, 0, 1, 0, "<square> 30D1 30FC 30BB 30F3 30C8" },
/* U+332c */ { 30, 0, 1, 0, "<square> 30D1 30FC 30C4" },
/* U+332d */ { 30, 0, 1, 0, "<square> 30D0 30FC 30EC 30EB" },
/* U+332e */ { 30, 0, 1, 0, "<square> 30D4 30A2 30B9 30C8 30EB" },
/* U+332f */ { 30, 0, 1, 0, "<square> 30D4 30AF 30EB" },
/* U+3330 */ { 30, 0, 1, 0, "<square> 30D4 30B3" },
/* U+3331 */ { 30, 0, 1, 0, "<square> 30D3 30EB" },
/* U+3332 */ { 30, 0, 1, 0, "<square> 30D5 30A1 30E9 30C3 30C9" },
/* U+3333 */ { 30, 0, 1, 0, "<square> 30D5 30A3 30FC 30C8" },
/* U+3334 */ { 30, 0, 1, 0, "<square> 30D6 30C3 30B7 30A7 30EB" },
/* U+3335 */ { 30, 0, 1, 0, "<square> 30D5 30E9 30F3" },
/* U+3336 */ { 30, 0, 1, 0, "<square> 30D8 30AF 30BF 30FC 30EB" },
/* U+3337 */ { 30, 0, 1, 0, "<square> 30DA 30BD" },
/* U+3338 */ { 30, 0, 1, 0, "<square> 30DA 30CB 30D2" },
/* U+3339 */ { 30, 0, 1, 0, "<square> 30D8 30EB 30C4" },
/* U+333a */ { 30, 0, 1, 0, "<square> 30DA 30F3 30B9" },
/* U+333b */ { 30, 0, 1, 0, "<square> 30DA 30FC 30B8" },
/* U+333c */ { 30, 0, 1, 0, "<square> 30D9 30FC 30BF" },
/* U+333d */ { 30, 0, 1, 0, "<square> 30DD 30A4 30F3 30C8" },
/* U+333e */ { 30, 0, 1, 0, "<square> 30DC 30EB 30C8" },
/* U+333f */ { 30, 0, 1, 0, "<square> 30DB 30F3" },
/* U+3340 */ { 30, 0, 1, 0, "<square> 30DD 30F3 30C9" },
/* U+3341 */ { 30, 0, 1, 0, "<square> 30DB 30FC 30EB" },
/* U+3342 */ { 30, 0, 1, 0, "<square> 30DB 30FC 30F3" },
/* U+3343 */ { 30, 0, 1, 0, "<square> 30DE 30A4 30AF 30ED" },
/* U+3344 */ { 30, 0, 1, 0, "<square> 30DE 30A4 30EB" },
/* U+3345 */ { 30, 0, 1, 0, "<square> 30DE 30C3 30CF" },
/* U+3346 */ { 30, 0, 1, 0, "<square> 30DE 30EB 30AF" },
/* U+3347 */ { 30, 0, 1, 0, "<square> 30DE 30F3 30B7 30E7 30F3" },
/* U+3348 */ { 30, 0, 1, 0, "<square> 30DF 30AF 30ED 30F3" },
/* U+3349 */ { 30, 0, 1, 0, "<square> 30DF 30EA" },
/* U+334a */ { 30, 0, 1, 0, "<square> 30DF 30EA 30D0 30FC 30EB" },
/* U+334b */ { 30, 0, 1, 0, "<square> 30E1 30AC" },
/* U+334c */ { 30, 0, 1, 0, "<square> 30E1 30AC 30C8 30F3" },
/* U+334d */ { 30, 0, 1, 0, "<square> 30E1 30FC 30C8 30EB" },
/* U+334e */ { 30, 0, 1, 0, "<square> 30E4 30FC 30C9" },
/* U+334f */ { 30, 0, 1, 0, "<square> 30E4 30FC 30EB" },
/* U+3350 */ { 30, 0, 1, 0, "<square> 30E6 30A2 30F3" },
/* U+3351 */ { 30, 0, 1, 0, "<square> 30EA 30C3 30C8 30EB" },
/* U+3352 */ { 30, 0, 1, 0, "<square> 30EA 30E9" },
/* U+3353 */ { 30, 0, 1, 0, "<square> 30EB 30D4 30FC" },
/* U+3354 */ { 30, 0, 1, 0, "<square> 30EB 30FC 30D6 30EB" },
/* U+3355 */ { 30, 0, 1, 0, "<square> 30EC 30E0" },
/* U+3356 */ { 30, 0, 1, 0, "<square> 30EC 30F3 30C8 30B2 30F3" },
/* U+3357 */ { 30, 0, 1, 0, "<square> 30EF 30C3 30C8" },
/* U+3358 */ { 30, 0, 1, 0, "<compat> 0030 70B9" },
/* U+3359 */ { 30, 0, 1, 0, "<compat> 0031 70B9" },
/* U+335a */ { 30, 0, 1, 0, "<compat> 0032 70B9" },
/* U+335b */ { 30, 0, 1, 0, "<compat> 0033 70B9" },
/* U+335c */ { 30, 0, 1, 0, "<compat> 0034 70B9" },
/* U+335d */ { 30, 0, 1, 0, "<compat> 0035 70B9" },
/* U+335e */ { 30, 0, 1, 0, "<compat> 0036 70B9" },
/* U+335f */ { 30, 0, 1, 0, "<compat> 0037 70B9" },
/* U+3360 */ { 30, 0, 1, 0, "<compat> 0038 70B9" },
/* U+3361 */ { 30, 0, 1, 0, "<compat> 0039 70B9" },
/* U+3362 */ { 30, 0, 1, 0, "<compat> 0031 0030 70B9" },
/* U+3363 */ { 30, 0, 1, 0, "<compat> 0031 0031 70B9" },
/* U+3364 */ { 30, 0, 1, 0, "<compat> 0031 0032 70B9" },
/* U+3365 */ { 30, 0, 1, 0, "<compat> 0031 0033 70B9" },
/* U+3366 */ { 30, 0, 1, 0, "<compat> 0031 0034 70B9" },
/* U+3367 */ { 30, 0, 1, 0, "<compat> 0031 0035 70B9" },
/* U+3368 */ { 30, 0, 1, 0, "<compat> 0031 0036 70B9" },
/* U+3369 */ { 30, 0, 1, 0, "<compat> 0031 0037 70B9" },
/* U+336a */ { 30, 0, 1, 0, "<compat> 0031 0038 70B9" },
/* U+336b */ { 30, 0, 1, 0, "<compat> 0031 0039 70B9" },
/* U+336c */ { 30, 0, 1, 0, "<compat> 0032 0030 70B9" },
/* U+336d */ { 30, 0, 1, 0, "<compat> 0032 0031 70B9" },
/* U+336e */ { 30, 0, 1, 0, "<compat> 0032 0032 70B9" },
/* U+336f */ { 30, 0, 1, 0, "<compat> 0032 0033 70B9" },
/* U+3370 */ { 30, 0, 1, 0, "<compat> 0032 0034 70B9" },
/* U+3371 */ { 30, 0, 1, 0, "<square> 0068 0050 0061" },
/* U+3372 */ { 30, 0, 1, 0, "<square> 0064 0061" },
/* U+3373 */ { 30, 0, 1, 0, "<square> 0041 0055" },
/* U+3374 */ { 30, 0, 1, 0, "<square> 0062 0061 0072" },
/* U+3375 */ { 30, 0, 1, 0, "<square> 006F 0056" },
/* U+3376 */ { 30, 0, 1, 0, "<square> 0070 0063" },
/* U+3377 */ { 0, 0, 0, 0, 0 },
/* U+3378 */ { 0, 0, 0, 0, 0 },
/* U+3379 */ { 0, 0, 0, 0, 0 },
/* U+337a */ { 0, 0, 0, 0, 0 },
/* U+337b */ { 30, 0, 1, 0, "<square> 5E73 6210" },
/* U+337c */ { 30, 0, 1, 0, "<square> 662D 548C" },
/* U+337d */ { 30, 0, 1, 0, "<square> 5927 6B63" },
/* U+337e */ { 30, 0, 1, 0, "<square> 660E 6CBB" },
/* U+337f */ { 30, 0, 1, 0, "<square> 682A 5F0F 4F1A 793E" },
/* U+3380 */ { 30, 0, 1, 0, "<square> 0070 0041" },
/* U+3381 */ { 30, 0, 1, 0, "<square> 006E 0041" },
/* U+3382 */ { 30, 0, 1, 0, "<square> 03BC 0041" },
/* U+3383 */ { 30, 0, 1, 0, "<square> 006D 0041" },
/* U+3384 */ { 30, 0, 1, 0, "<square> 006B 0041" },
/* U+3385 */ { 30, 0, 1, 0, "<square> 004B 0042" },
/* U+3386 */ { 30, 0, 1, 0, "<square> 004D 0042" },
/* U+3387 */ { 30, 0, 1, 0, "<square> 0047 0042" },
/* U+3388 */ { 30, 0, 1, 0, "<square> 0063 0061 006C" },
/* U+3389 */ { 30, 0, 1, 0, "<square> 006B 0063 0061 006C" },
/* U+338a */ { 30, 0, 1, 0, "<square> 0070 0046" },
/* U+338b */ { 30, 0, 1, 0, "<square> 006E 0046" },
/* U+338c */ { 30, 0, 1, 0, "<square> 03BC 0046" },
/* U+338d */ { 30, 0, 1, 0, "<square> 03BC 0067" },
/* U+338e */ { 30, 0, 1, 0, "<square> 006D 0067" },
/* U+338f */ { 30, 0, 1, 0, "<square> 006B 0067" },
/* U+3390 */ { 30, 0, 1, 0, "<square> 0048 007A" },
/* U+3391 */ { 30, 0, 1, 0, "<square> 006B 0048 007A" },
/* U+3392 */ { 30, 0, 1, 0, "<square> 004D 0048 007A" },
/* U+3393 */ { 30, 0, 1, 0, "<square> 0047 0048 007A" },
/* U+3394 */ { 30, 0, 1, 0, "<square> 0054 0048 007A" },
/* U+3395 */ { 30, 0, 1, 0, "<square> 03BC 2113" },
/* U+3396 */ { 30, 0, 1, 0, "<square> 006D 2113" },
/* U+3397 */ { 30, 0, 1, 0, "<square> 0064 2113" },
/* U+3398 */ { 30, 0, 1, 0, "<square> 006B 2113" },
/* U+3399 */ { 30, 0, 1, 0, "<square> 0066 006D" },
/* U+339a */ { 30, 0, 1, 0, "<square> 006E 006D" },
/* U+339b */ { 30, 0, 1, 0, "<square> 03BC 006D" },
/* U+339c */ { 30, 0, 1, 0, "<square> 006D 006D" },
/* U+339d */ { 30, 0, 1, 0, "<square> 0063 006D" },
/* U+339e */ { 30, 0, 1, 0, "<square> 006B 006D" },
/* U+339f */ { 30, 0, 1, 0, "<square> 006D 006D 00B2" },
/* U+33a0 */ { 30, 0, 1, 0, "<square> 0063 006D 00B2" },
/* U+33a1 */ { 30, 0, 1, 0, "<square> 006D 00B2" },
/* U+33a2 */ { 30, 0, 1, 0, "<square> 006B 006D 00B2" },
/* U+33a3 */ { 30, 0, 1, 0, "<square> 006D 006D 00B3" },
/* U+33a4 */ { 30, 0, 1, 0, "<square> 0063 006D 00B3" },
/* U+33a5 */ { 30, 0, 1, 0, "<square> 006D 00B3" },
/* U+33a6 */ { 30, 0, 1, 0, "<square> 006B 006D 00B3" },
/* U+33a7 */ { 30, 0, 1, 0, "<square> 006D 2215 0073" },
/* U+33a8 */ { 30, 0, 1, 0, "<square> 006D 2215 0073 00B2" },
/* U+33a9 */ { 30, 0, 1, 0, "<square> 0050 0061" },
/* U+33aa */ { 30, 0, 1, 0, "<square> 006B 0050 0061" },
/* U+33ab */ { 30, 0, 1, 0, "<square> 004D 0050 0061" },
/* U+33ac */ { 30, 0, 1, 0, "<square> 0047 0050 0061" },
/* U+33ad */ { 30, 0, 1, 0, "<square> 0072 0061 0064" },
/* U+33ae */ { 30, 0, 1, 0, "<square> 0072 0061 0064 2215 0073" },
/* U+33af */ { 30, 0, 1, 0, "<square> 0072 0061 0064 2215 0073 00B2" },
/* U+33b0 */ { 30, 0, 1, 0, "<square> 0070 0073" },
/* U+33b1 */ { 30, 0, 1, 0, "<square> 006E 0073" },
/* U+33b2 */ { 30, 0, 1, 0, "<square> 03BC 0073" },
/* U+33b3 */ { 30, 0, 1, 0, "<square> 006D 0073" },
/* U+33b4 */ { 30, 0, 1, 0, "<square> 0070 0056" },
/* U+33b5 */ { 30, 0, 1, 0, "<square> 006E 0056" },
/* U+33b6 */ { 30, 0, 1, 0, "<square> 03BC 0056" },
/* U+33b7 */ { 30, 0, 1, 0, "<square> 006D 0056" },
/* U+33b8 */ { 30, 0, 1, 0, "<square> 006B 0056" },
/* U+33b9 */ { 30, 0, 1, 0, "<square> 004D 0056" },
/* U+33ba */ { 30, 0, 1, 0, "<square> 0070 0057" },
/* U+33bb */ { 30, 0, 1, 0, "<square> 006E 0057" },
/* U+33bc */ { 30, 0, 1, 0, "<square> 03BC 0057" },
/* U+33bd */ { 30, 0, 1, 0, "<square> 006D 0057" },
/* U+33be */ { 30, 0, 1, 0, "<square> 006B 0057" },
/* U+33bf */ { 30, 0, 1, 0, "<square> 004D 0057" },
/* U+33c0 */ { 30, 0, 1, 0, "<square> 006B 03A9" },
/* U+33c1 */ { 30, 0, 1, 0, "<square> 004D 03A9" },
/* U+33c2 */ { 30, 0, 1, 0, "<square> 0061 002E 006D 002E" },
/* U+33c3 */ { 30, 0, 1, 0, "<square> 0042 0071" },
/* U+33c4 */ { 30, 0, 1, 0, "<square> 0063 0063" },
/* U+33c5 */ { 30, 0, 1, 0, "<square> 0063 0064" },
/* U+33c6 */ { 30, 0, 1, 0, "<square> 0043 2215 006B 0067" },
/* U+33c7 */ { 30, 0, 1, 0, "<square> 0043 006F 002E" },
/* U+33c8 */ { 30, 0, 1, 0, "<square> 0064 0042" },
/* U+33c9 */ { 30, 0, 1, 0, "<square> 0047 0079" },
/* U+33ca */ { 30, 0, 1, 0, "<square> 0068 0061" },
/* U+33cb */ { 30, 0, 1, 0, "<square> 0048 0050" },
/* U+33cc */ { 30, 0, 1, 0, "<square> 0069 006E" },
/* U+33cd */ { 30, 0, 1, 0, "<square> 004B 004B" },
/* U+33ce */ { 30, 0, 1, 0, "<square> 004B 004D" },
/* U+33cf */ { 30, 0, 1, 0, "<square> 006B 0074" },
/* U+33d0 */ { 30, 0, 1, 0, "<square> 006C 006D" },
/* U+33d1 */ { 30, 0, 1, 0, "<square> 006C 006E" },
/* U+33d2 */ { 30, 0, 1, 0, "<square> 006C 006F 0067" },
/* U+33d3 */ { 30, 0, 1, 0, "<square> 006C 0078" },
/* U+33d4 */ { 30, 0, 1, 0, "<square> 006D 0062" },
/* U+33d5 */ { 30, 0, 1, 0, "<square> 006D 0069 006C" },
/* U+33d6 */ { 30, 0, 1, 0, "<square> 006D 006F 006C" },
/* U+33d7 */ { 30, 0, 1, 0, "<square> 0050 0048" },
/* U+33d8 */ { 30, 0, 1, 0, "<square> 0070 002E 006D 002E" },
/* U+33d9 */ { 30, 0, 1, 0, "<square> 0050 0050 004D" },
/* U+33da */ { 30, 0, 1, 0, "<square> 0050 0052" },
/* U+33db */ { 30, 0, 1, 0, "<square> 0073 0072" },
/* U+33dc */ { 30, 0, 1, 0, "<square> 0053 0076" },
/* U+33dd */ { 30, 0, 1, 0, "<square> 0057 0062" },
/* U+33de */ { 0, 0, 0, 0, 0 },
/* U+33df */ { 0, 0, 0, 0, 0 },
/* U+33e0 */ { 30, 0, 1, 0, "<compat> 0031 65E5" },
/* U+33e1 */ { 30, 0, 1, 0, "<compat> 0032 65E5" },
/* U+33e2 */ { 30, 0, 1, 0, "<compat> 0033 65E5" },
/* U+33e3 */ { 30, 0, 1, 0, "<compat> 0034 65E5" },
/* U+33e4 */ { 30, 0, 1, 0, "<compat> 0035 65E5" },
/* U+33e5 */ { 30, 0, 1, 0, "<compat> 0036 65E5" },
/* U+33e6 */ { 30, 0, 1, 0, "<compat> 0037 65E5" },
/* U+33e7 */ { 30, 0, 1, 0, "<compat> 0038 65E5" },
/* U+33e8 */ { 30, 0, 1, 0, "<compat> 0039 65E5" },
/* U+33e9 */ { 30, 0, 1, 0, "<compat> 0031 0030 65E5" },
/* U+33ea */ { 30, 0, 1, 0, "<compat> 0031 0031 65E5" },
/* U+33eb */ { 30, 0, 1, 0, "<compat> 0031 0032 65E5" },
/* U+33ec */ { 30, 0, 1, 0, "<compat> 0031 0033 65E5" },
/* U+33ed */ { 30, 0, 1, 0, "<compat> 0031 0034 65E5" },
/* U+33ee */ { 30, 0, 1, 0, "<compat> 0031 0035 65E5" },
/* U+33ef */ { 30, 0, 1, 0, "<compat> 0031 0036 65E5" },
/* U+33f0 */ { 30, 0, 1, 0, "<compat> 0031 0037 65E5" },
/* U+33f1 */ { 30, 0, 1, 0, "<compat> 0031 0038 65E5" },
/* U+33f2 */ { 30, 0, 1, 0, "<compat> 0031 0039 65E5" },
/* U+33f3 */ { 30, 0, 1, 0, "<compat> 0032 0030 65E5" },
/* U+33f4 */ { 30, 0, 1, 0, "<compat> 0032 0031 65E5" },
/* U+33f5 */ { 30, 0, 1, 0, "<compat> 0032 0032 65E5" },
/* U+33f6 */ { 30, 0, 1, 0, "<compat> 0032 0033 65E5" },
/* U+33f7 */ { 30, 0, 1, 0, "<compat> 0032 0034 65E5" },
/* U+33f8 */ { 30, 0, 1, 0, "<compat> 0032 0035 65E5" },
/* U+33f9 */ { 30, 0, 1, 0, "<compat> 0032 0036 65E5" },
/* U+33fa */ { 30, 0, 1, 0, "<compat> 0032 0037 65E5" },
/* U+33fb */ { 30, 0, 1, 0, "<compat> 0032 0038 65E5" },
/* U+33fc */ { 30, 0, 1, 0, "<compat> 0032 0039 65E5" },
/* U+33fd */ { 30, 0, 1, 0, "<compat> 0033 0030 65E5" },
/* U+33fe */ { 30, 0, 1, 0, "<compat> 0033 0031 65E5" },
/* U+33ff */ { 0, 0, 0, 0, 0 },
/* U+3400 */ { 19, 0, 1, 0, 0 },
/* U+3401 */ { 0, 0, 0, 0, 0 },
/* U+3402 */ { 0, 0, 0, 0, 0 },
/* U+3403 */ { 0, 0, 0, 0, 0 },
/* U+3404 */ { 0, 0, 0, 0, 0 },
/* U+3405 */ { 0, 0, 0, 0, 0 },
/* U+3406 */ { 0, 0, 0, 0, 0 },
/* U+3407 */ { 0, 0, 0, 0, 0 },
/* U+3408 */ { 0, 0, 0, 0, 0 },
/* U+3409 */ { 0, 0, 0, 0, 0 },
/* U+340a */ { 0, 0, 0, 0, 0 },
/* U+340b */ { 0, 0, 0, 0, 0 },
/* U+340c */ { 0, 0, 0, 0, 0 },
/* U+340d */ { 0, 0, 0, 0, 0 },
/* U+340e */ { 0, 0, 0, 0, 0 },
/* U+340f */ { 0, 0, 0, 0, 0 },
/* U+3410 */ { 0, 0, 0, 0, 0 },
/* U+3411 */ { 0, 0, 0, 0, 0 },
/* U+3412 */ { 0, 0, 0, 0, 0 },
/* U+3413 */ { 0, 0, 0, 0, 0 },
/* U+3414 */ { 0, 0, 0, 0, 0 },
/* U+3415 */ { 0, 0, 0, 0, 0 },
/* U+3416 */ { 0, 0, 0, 0, 0 },
/* U+3417 */ { 0, 0, 0, 0, 0 },
/* U+3418 */ { 0, 0, 0, 0, 0 },
/* U+3419 */ { 0, 0, 0, 0, 0 },
/* U+341a */ { 0, 0, 0, 0, 0 },
/* U+341b */ { 0, 0, 0, 0, 0 },
/* U+341c */ { 0, 0, 0, 0, 0 },
/* U+341d */ { 0, 0, 0, 0, 0 },
/* U+341e */ { 0, 0, 0, 0, 0 },
/* U+341f */ { 0, 0, 0, 0, 0 },
/* U+3420 */ { 0, 0, 0, 0, 0 },
/* U+3421 */ { 0, 0, 0, 0, 0 },
/* U+3422 */ { 0, 0, 0, 0, 0 },
/* U+3423 */ { 0, 0, 0, 0, 0 },
/* U+3424 */ { 0, 0, 0, 0, 0 },
/* U+3425 */ { 0, 0, 0, 0, 0 },
/* U+3426 */ { 0, 0, 0, 0, 0 },
/* U+3427 */ { 0, 0, 0, 0, 0 },
/* U+3428 */ { 0, 0, 0, 0, 0 },
/* U+3429 */ { 0, 0, 0, 0, 0 },
/* U+342a */ { 0, 0, 0, 0, 0 },
/* U+342b */ { 0, 0, 0, 0, 0 },
/* U+342c */ { 0, 0, 0, 0, 0 },
/* U+342d */ { 0, 0, 0, 0, 0 },
/* U+342e */ { 0, 0, 0, 0, 0 },
/* U+342f */ { 0, 0, 0, 0, 0 },
/* U+3430 */ { 0, 0, 0, 0, 0 },
/* U+3431 */ { 0, 0, 0, 0, 0 },
/* U+3432 */ { 0, 0, 0, 0, 0 },
/* U+3433 */ { 0, 0, 0, 0, 0 },
/* U+3434 */ { 0, 0, 0, 0, 0 },
/* U+3435 */ { 0, 0, 0, 0, 0 },
/* U+3436 */ { 0, 0, 0, 0, 0 },
/* U+3437 */ { 0, 0, 0, 0, 0 },
/* U+3438 */ { 0, 0, 0, 0, 0 },
/* U+3439 */ { 0, 0, 0, 0, 0 },
/* U+343a */ { 0, 0, 0, 0, 0 },
/* U+343b */ { 0, 0, 0, 0, 0 },
/* U+343c */ { 0, 0, 0, 0, 0 },
/* U+343d */ { 0, 0, 0, 0, 0 },
/* U+343e */ { 0, 0, 0, 0, 0 },
/* U+343f */ { 0, 0, 0, 0, 0 },
/* U+3440 */ { 0, 0, 0, 0, 0 },
/* U+3441 */ { 0, 0, 0, 0, 0 },
/* U+3442 */ { 0, 0, 0, 0, 0 },
/* U+3443 */ { 0, 0, 0, 0, 0 },
/* U+3444 */ { 0, 0, 0, 0, 0 },
/* U+3445 */ { 0, 0, 0, 0, 0 },
/* U+3446 */ { 0, 0, 0, 0, 0 },
/* U+3447 */ { 0, 0, 0, 0, 0 },
/* U+3448 */ { 0, 0, 0, 0, 0 },
/* U+3449 */ { 0, 0, 0, 0, 0 },
/* U+344a */ { 0, 0, 0, 0, 0 },
/* U+344b */ { 0, 0, 0, 0, 0 },
/* U+344c */ { 0, 0, 0, 0, 0 },
/* U+344d */ { 0, 0, 0, 0, 0 },
/* U+344e */ { 0, 0, 0, 0, 0 },
/* U+344f */ { 0, 0, 0, 0, 0 },
/* U+3450 */ { 0, 0, 0, 0, 0 },
/* U+3451 */ { 0, 0, 0, 0, 0 },
/* U+3452 */ { 0, 0, 0, 0, 0 },
/* U+3453 */ { 0, 0, 0, 0, 0 },
/* U+3454 */ { 0, 0, 0, 0, 0 },
/* U+3455 */ { 0, 0, 0, 0, 0 },
/* U+3456 */ { 0, 0, 0, 0, 0 },
/* U+3457 */ { 0, 0, 0, 0, 0 },
/* U+3458 */ { 0, 0, 0, 0, 0 },
/* U+3459 */ { 0, 0, 0, 0, 0 },
/* U+345a */ { 0, 0, 0, 0, 0 },
/* U+345b */ { 0, 0, 0, 0, 0 },
/* U+345c */ { 0, 0, 0, 0, 0 },
/* U+345d */ { 0, 0, 0, 0, 0 },
/* U+345e */ { 0, 0, 0, 0, 0 },
/* U+345f */ { 0, 0, 0, 0, 0 },
/* U+3460 */ { 0, 0, 0, 0, 0 },
/* U+3461 */ { 0, 0, 0, 0, 0 },
/* U+3462 */ { 0, 0, 0, 0, 0 },
/* U+3463 */ { 0, 0, 0, 0, 0 },
/* U+3464 */ { 0, 0, 0, 0, 0 },
/* U+3465 */ { 0, 0, 0, 0, 0 },
/* U+3466 */ { 0, 0, 0, 0, 0 },
/* U+3467 */ { 0, 0, 0, 0, 0 },
/* U+3468 */ { 0, 0, 0, 0, 0 },
/* U+3469 */ { 0, 0, 0, 0, 0 },
/* U+346a */ { 0, 0, 0, 0, 0 },
/* U+346b */ { 0, 0, 0, 0, 0 },
/* U+346c */ { 0, 0, 0, 0, 0 },
/* U+346d */ { 0, 0, 0, 0, 0 },
/* U+346e */ { 0, 0, 0, 0, 0 },
/* U+346f */ { 0, 0, 0, 0, 0 },
/* U+3470 */ { 0, 0, 0, 0, 0 },
/* U+3471 */ { 0, 0, 0, 0, 0 },
/* U+3472 */ { 0, 0, 0, 0, 0 },
/* U+3473 */ { 0, 0, 0, 0, 0 },
/* U+3474 */ { 0, 0, 0, 0, 0 },
/* U+3475 */ { 0, 0, 0, 0, 0 },
/* U+3476 */ { 0, 0, 0, 0, 0 },
/* U+3477 */ { 0, 0, 0, 0, 0 },
/* U+3478 */ { 0, 0, 0, 0, 0 },
/* U+3479 */ { 0, 0, 0, 0, 0 },
/* U+347a */ { 0, 0, 0, 0, 0 },
/* U+347b */ { 0, 0, 0, 0, 0 },
/* U+347c */ { 0, 0, 0, 0, 0 },
/* U+347d */ { 0, 0, 0, 0, 0 },
/* U+347e */ { 0, 0, 0, 0, 0 },
/* U+347f */ { 0, 0, 0, 0, 0 },
/* U+3480 */ { 0, 0, 0, 0, 0 },
/* U+3481 */ { 0, 0, 0, 0, 0 },
/* U+3482 */ { 0, 0, 0, 0, 0 },
/* U+3483 */ { 0, 0, 0, 0, 0 },
/* U+3484 */ { 0, 0, 0, 0, 0 },
/* U+3485 */ { 0, 0, 0, 0, 0 },
/* U+3486 */ { 0, 0, 0, 0, 0 },
/* U+3487 */ { 0, 0, 0, 0, 0 },
/* U+3488 */ { 0, 0, 0, 0, 0 },
/* U+3489 */ { 0, 0, 0, 0, 0 },
/* U+348a */ { 0, 0, 0, 0, 0 },
/* U+348b */ { 0, 0, 0, 0, 0 },
/* U+348c */ { 0, 0, 0, 0, 0 },
/* U+348d */ { 0, 0, 0, 0, 0 },
/* U+348e */ { 0, 0, 0, 0, 0 },
/* U+348f */ { 0, 0, 0, 0, 0 },
/* U+3490 */ { 0, 0, 0, 0, 0 },
/* U+3491 */ { 0, 0, 0, 0, 0 },
/* U+3492 */ { 0, 0, 0, 0, 0 },
/* U+3493 */ { 0, 0, 0, 0, 0 },
/* U+3494 */ { 0, 0, 0, 0, 0 },
/* U+3495 */ { 0, 0, 0, 0, 0 },
/* U+3496 */ { 0, 0, 0, 0, 0 },
/* U+3497 */ { 0, 0, 0, 0, 0 },
/* U+3498 */ { 0, 0, 0, 0, 0 },
/* U+3499 */ { 0, 0, 0, 0, 0 },
/* U+349a */ { 0, 0, 0, 0, 0 },
/* U+349b */ { 0, 0, 0, 0, 0 },
/* U+349c */ { 0, 0, 0, 0, 0 },
/* U+349d */ { 0, 0, 0, 0, 0 },
/* U+349e */ { 0, 0, 0, 0, 0 },
/* U+349f */ { 0, 0, 0, 0, 0 },
/* U+34a0 */ { 0, 0, 0, 0, 0 },
/* U+34a1 */ { 0, 0, 0, 0, 0 },
/* U+34a2 */ { 0, 0, 0, 0, 0 },
/* U+34a3 */ { 0, 0, 0, 0, 0 },
/* U+34a4 */ { 0, 0, 0, 0, 0 },
/* U+34a5 */ { 0, 0, 0, 0, 0 },
/* U+34a6 */ { 0, 0, 0, 0, 0 },
/* U+34a7 */ { 0, 0, 0, 0, 0 },
/* U+34a8 */ { 0, 0, 0, 0, 0 },
/* U+34a9 */ { 0, 0, 0, 0, 0 },
/* U+34aa */ { 0, 0, 0, 0, 0 },
/* U+34ab */ { 0, 0, 0, 0, 0 },
/* U+34ac */ { 0, 0, 0, 0, 0 },
/* U+34ad */ { 0, 0, 0, 0, 0 },
/* U+34ae */ { 0, 0, 0, 0, 0 },
/* U+34af */ { 0, 0, 0, 0, 0 },
/* U+34b0 */ { 0, 0, 0, 0, 0 },
/* U+34b1 */ { 0, 0, 0, 0, 0 },
/* U+34b2 */ { 0, 0, 0, 0, 0 },
/* U+34b3 */ { 0, 0, 0, 0, 0 },
/* U+34b4 */ { 0, 0, 0, 0, 0 },
/* U+34b5 */ { 0, 0, 0, 0, 0 },
/* U+34b6 */ { 0, 0, 0, 0, 0 },
/* U+34b7 */ { 0, 0, 0, 0, 0 },
/* U+34b8 */ { 0, 0, 0, 0, 0 },
/* U+34b9 */ { 0, 0, 0, 0, 0 },
/* U+34ba */ { 0, 0, 0, 0, 0 },
/* U+34bb */ { 0, 0, 0, 0, 0 },
/* U+34bc */ { 0, 0, 0, 0, 0 },
/* U+34bd */ { 0, 0, 0, 0, 0 },
/* U+34be */ { 0, 0, 0, 0, 0 },
/* U+34bf */ { 0, 0, 0, 0, 0 },
/* U+34c0 */ { 0, 0, 0, 0, 0 },
/* U+34c1 */ { 0, 0, 0, 0, 0 },
/* U+34c2 */ { 0, 0, 0, 0, 0 },
/* U+34c3 */ { 0, 0, 0, 0, 0 },
/* U+34c4 */ { 0, 0, 0, 0, 0 },
/* U+34c5 */ { 0, 0, 0, 0, 0 },
/* U+34c6 */ { 0, 0, 0, 0, 0 },
/* U+34c7 */ { 0, 0, 0, 0, 0 },
/* U+34c8 */ { 0, 0, 0, 0, 0 },
/* U+34c9 */ { 0, 0, 0, 0, 0 },
/* U+34ca */ { 0, 0, 0, 0, 0 },
/* U+34cb */ { 0, 0, 0, 0, 0 },
/* U+34cc */ { 0, 0, 0, 0, 0 },
/* U+34cd */ { 0, 0, 0, 0, 0 },
/* U+34ce */ { 0, 0, 0, 0, 0 },
/* U+34cf */ { 0, 0, 0, 0, 0 },
/* U+34d0 */ { 0, 0, 0, 0, 0 },
/* U+34d1 */ { 0, 0, 0, 0, 0 },
/* U+34d2 */ { 0, 0, 0, 0, 0 },
/* U+34d3 */ { 0, 0, 0, 0, 0 },
/* U+34d4 */ { 0, 0, 0, 0, 0 },
/* U+34d5 */ { 0, 0, 0, 0, 0 },
/* U+34d6 */ { 0, 0, 0, 0, 0 },
/* U+34d7 */ { 0, 0, 0, 0, 0 },
/* U+34d8 */ { 0, 0, 0, 0, 0 },
/* U+34d9 */ { 0, 0, 0, 0, 0 },
/* U+34da */ { 0, 0, 0, 0, 0 },
/* U+34db */ { 0, 0, 0, 0, 0 },
/* U+34dc */ { 0, 0, 0, 0, 0 },
/* U+34dd */ { 0, 0, 0, 0, 0 },
/* U+34de */ { 0, 0, 0, 0, 0 },
/* U+34df */ { 0, 0, 0, 0, 0 },
/* U+34e0 */ { 0, 0, 0, 0, 0 },
/* U+34e1 */ { 0, 0, 0, 0, 0 },
/* U+34e2 */ { 0, 0, 0, 0, 0 },
/* U+34e3 */ { 0, 0, 0, 0, 0 },
/* U+34e4 */ { 0, 0, 0, 0, 0 },
/* U+34e5 */ { 0, 0, 0, 0, 0 },
/* U+34e6 */ { 0, 0, 0, 0, 0 },
/* U+34e7 */ { 0, 0, 0, 0, 0 },
/* U+34e8 */ { 0, 0, 0, 0, 0 },
/* U+34e9 */ { 0, 0, 0, 0, 0 },
/* U+34ea */ { 0, 0, 0, 0, 0 },
/* U+34eb */ { 0, 0, 0, 0, 0 },
/* U+34ec */ { 0, 0, 0, 0, 0 },
/* U+34ed */ { 0, 0, 0, 0, 0 },
/* U+34ee */ { 0, 0, 0, 0, 0 },
/* U+34ef */ { 0, 0, 0, 0, 0 },
/* U+34f0 */ { 0, 0, 0, 0, 0 },
/* U+34f1 */ { 0, 0, 0, 0, 0 },
/* U+34f2 */ { 0, 0, 0, 0, 0 },
/* U+34f3 */ { 0, 0, 0, 0, 0 },
/* U+34f4 */ { 0, 0, 0, 0, 0 },
/* U+34f5 */ { 0, 0, 0, 0, 0 },
/* U+34f6 */ { 0, 0, 0, 0, 0 },
/* U+34f7 */ { 0, 0, 0, 0, 0 },
/* U+34f8 */ { 0, 0, 0, 0, 0 },
/* U+34f9 */ { 0, 0, 0, 0, 0 },
/* U+34fa */ { 0, 0, 0, 0, 0 },
/* U+34fb */ { 0, 0, 0, 0, 0 },
/* U+34fc */ { 0, 0, 0, 0, 0 },
/* U+34fd */ { 0, 0, 0, 0, 0 },
/* U+34fe */ { 0, 0, 0, 0, 0 },
/* U+34ff */ { 0, 0, 0, 0, 0 },
/* U+3500 */ { 0, 0, 0, 0, 0 },
/* U+3501 */ { 0, 0, 0, 0, 0 },
/* U+3502 */ { 0, 0, 0, 0, 0 },
/* U+3503 */ { 0, 0, 0, 0, 0 },
/* U+3504 */ { 0, 0, 0, 0, 0 },
/* U+3505 */ { 0, 0, 0, 0, 0 },
/* U+3506 */ { 0, 0, 0, 0, 0 },
/* U+3507 */ { 0, 0, 0, 0, 0 },
/* U+3508 */ { 0, 0, 0, 0, 0 },
/* U+3509 */ { 0, 0, 0, 0, 0 },
/* U+350a */ { 0, 0, 0, 0, 0 },
/* U+350b */ { 0, 0, 0, 0, 0 },
/* U+350c */ { 0, 0, 0, 0, 0 },
/* U+350d */ { 0, 0, 0, 0, 0 },
/* U+350e */ { 0, 0, 0, 0, 0 },
/* U+350f */ { 0, 0, 0, 0, 0 },
/* U+3510 */ { 0, 0, 0, 0, 0 },
/* U+3511 */ { 0, 0, 0, 0, 0 },
/* U+3512 */ { 0, 0, 0, 0, 0 },
/* U+3513 */ { 0, 0, 0, 0, 0 },
/* U+3514 */ { 0, 0, 0, 0, 0 },
/* U+3515 */ { 0, 0, 0, 0, 0 },
/* U+3516 */ { 0, 0, 0, 0, 0 },
/* U+3517 */ { 0, 0, 0, 0, 0 },
/* U+3518 */ { 0, 0, 0, 0, 0 },
/* U+3519 */ { 0, 0, 0, 0, 0 },
/* U+351a */ { 0, 0, 0, 0, 0 },
/* U+351b */ { 0, 0, 0, 0, 0 },
/* U+351c */ { 0, 0, 0, 0, 0 },
/* U+351d */ { 0, 0, 0, 0, 0 },
/* U+351e */ { 0, 0, 0, 0, 0 },
/* U+351f */ { 0, 0, 0, 0, 0 },
/* U+3520 */ { 0, 0, 0, 0, 0 },
/* U+3521 */ { 0, 0, 0, 0, 0 },
/* U+3522 */ { 0, 0, 0, 0, 0 },
/* U+3523 */ { 0, 0, 0, 0, 0 },
/* U+3524 */ { 0, 0, 0, 0, 0 },
/* U+3525 */ { 0, 0, 0, 0, 0 },
/* U+3526 */ { 0, 0, 0, 0, 0 },
/* U+3527 */ { 0, 0, 0, 0, 0 },
/* U+3528 */ { 0, 0, 0, 0, 0 },
/* U+3529 */ { 0, 0, 0, 0, 0 },
/* U+352a */ { 0, 0, 0, 0, 0 },
/* U+352b */ { 0, 0, 0, 0, 0 },
/* U+352c */ { 0, 0, 0, 0, 0 },
/* U+352d */ { 0, 0, 0, 0, 0 },
/* U+352e */ { 0, 0, 0, 0, 0 },
/* U+352f */ { 0, 0, 0, 0, 0 },
/* U+3530 */ { 0, 0, 0, 0, 0 },
/* U+3531 */ { 0, 0, 0, 0, 0 },
/* U+3532 */ { 0, 0, 0, 0, 0 },
/* U+3533 */ { 0, 0, 0, 0, 0 },
/* U+3534 */ { 0, 0, 0, 0, 0 },
/* U+3535 */ { 0, 0, 0, 0, 0 },
/* U+3536 */ { 0, 0, 0, 0, 0 },
/* U+3537 */ { 0, 0, 0, 0, 0 },
/* U+3538 */ { 0, 0, 0, 0, 0 },
/* U+3539 */ { 0, 0, 0, 0, 0 },
/* U+353a */ { 0, 0, 0, 0, 0 },
/* U+353b */ { 0, 0, 0, 0, 0 },
/* U+353c */ { 0, 0, 0, 0, 0 },
/* U+353d */ { 0, 0, 0, 0, 0 },
/* U+353e */ { 0, 0, 0, 0, 0 },
/* U+353f */ { 0, 0, 0, 0, 0 },
/* U+3540 */ { 0, 0, 0, 0, 0 },
/* U+3541 */ { 0, 0, 0, 0, 0 },
/* U+3542 */ { 0, 0, 0, 0, 0 },
/* U+3543 */ { 0, 0, 0, 0, 0 },
/* U+3544 */ { 0, 0, 0, 0, 0 },
/* U+3545 */ { 0, 0, 0, 0, 0 },
/* U+3546 */ { 0, 0, 0, 0, 0 },
/* U+3547 */ { 0, 0, 0, 0, 0 },
/* U+3548 */ { 0, 0, 0, 0, 0 },
/* U+3549 */ { 0, 0, 0, 0, 0 },
/* U+354a */ { 0, 0, 0, 0, 0 },
/* U+354b */ { 0, 0, 0, 0, 0 },
/* U+354c */ { 0, 0, 0, 0, 0 },
/* U+354d */ { 0, 0, 0, 0, 0 },
/* U+354e */ { 0, 0, 0, 0, 0 },
/* U+354f */ { 0, 0, 0, 0, 0 },
/* U+3550 */ { 0, 0, 0, 0, 0 },
/* U+3551 */ { 0, 0, 0, 0, 0 },
/* U+3552 */ { 0, 0, 0, 0, 0 },
/* U+3553 */ { 0, 0, 0, 0, 0 },
/* U+3554 */ { 0, 0, 0, 0, 0 },
/* U+3555 */ { 0, 0, 0, 0, 0 },
/* U+3556 */ { 0, 0, 0, 0, 0 },
/* U+3557 */ { 0, 0, 0, 0, 0 },
/* U+3558 */ { 0, 0, 0, 0, 0 },
/* U+3559 */ { 0, 0, 0, 0, 0 },
/* U+355a */ { 0, 0, 0, 0, 0 },
/* U+355b */ { 0, 0, 0, 0, 0 },
/* U+355c */ { 0, 0, 0, 0, 0 },
/* U+355d */ { 0, 0, 0, 0, 0 },
/* U+355e */ { 0, 0, 0, 0, 0 },
/* U+355f */ { 0, 0, 0, 0, 0 },
/* U+3560 */ { 0, 0, 0, 0, 0 },
/* U+3561 */ { 0, 0, 0, 0, 0 },
/* U+3562 */ { 0, 0, 0, 0, 0 },
/* U+3563 */ { 0, 0, 0, 0, 0 },
/* U+3564 */ { 0, 0, 0, 0, 0 },
/* U+3565 */ { 0, 0, 0, 0, 0 },
/* U+3566 */ { 0, 0, 0, 0, 0 },
/* U+3567 */ { 0, 0, 0, 0, 0 },
/* U+3568 */ { 0, 0, 0, 0, 0 },
/* U+3569 */ { 0, 0, 0, 0, 0 },
/* U+356a */ { 0, 0, 0, 0, 0 },
/* U+356b */ { 0, 0, 0, 0, 0 },
/* U+356c */ { 0, 0, 0, 0, 0 },
/* U+356d */ { 0, 0, 0, 0, 0 },
/* U+356e */ { 0, 0, 0, 0, 0 },
/* U+356f */ { 0, 0, 0, 0, 0 },
/* U+3570 */ { 0, 0, 0, 0, 0 },
/* U+3571 */ { 0, 0, 0, 0, 0 },
/* U+3572 */ { 0, 0, 0, 0, 0 },
/* U+3573 */ { 0, 0, 0, 0, 0 },
/* U+3574 */ { 0, 0, 0, 0, 0 },
/* U+3575 */ { 0, 0, 0, 0, 0 },
/* U+3576 */ { 0, 0, 0, 0, 0 },
/* U+3577 */ { 0, 0, 0, 0, 0 },
/* U+3578 */ { 0, 0, 0, 0, 0 },
/* U+3579 */ { 0, 0, 0, 0, 0 },
/* U+357a */ { 0, 0, 0, 0, 0 },
/* U+357b */ { 0, 0, 0, 0, 0 },
/* U+357c */ { 0, 0, 0, 0, 0 },
/* U+357d */ { 0, 0, 0, 0, 0 },
/* U+357e */ { 0, 0, 0, 0, 0 },
/* U+357f */ { 0, 0, 0, 0, 0 },
/* U+3580 */ { 0, 0, 0, 0, 0 },
/* U+3581 */ { 0, 0, 0, 0, 0 },
/* U+3582 */ { 0, 0, 0, 0, 0 },
/* U+3583 */ { 0, 0, 0, 0, 0 },
/* U+3584 */ { 0, 0, 0, 0, 0 },
/* U+3585 */ { 0, 0, 0, 0, 0 },
/* U+3586 */ { 0, 0, 0, 0, 0 },
/* U+3587 */ { 0, 0, 0, 0, 0 },
/* U+3588 */ { 0, 0, 0, 0, 0 },
/* U+3589 */ { 0, 0, 0, 0, 0 },
/* U+358a */ { 0, 0, 0, 0, 0 },
/* U+358b */ { 0, 0, 0, 0, 0 },
/* U+358c */ { 0, 0, 0, 0, 0 },
/* U+358d */ { 0, 0, 0, 0, 0 },
/* U+358e */ { 0, 0, 0, 0, 0 },
/* U+358f */ { 0, 0, 0, 0, 0 },
/* U+3590 */ { 0, 0, 0, 0, 0 },
/* U+3591 */ { 0, 0, 0, 0, 0 },
/* U+3592 */ { 0, 0, 0, 0, 0 },
/* U+3593 */ { 0, 0, 0, 0, 0 },
/* U+3594 */ { 0, 0, 0, 0, 0 },
/* U+3595 */ { 0, 0, 0, 0, 0 },
/* U+3596 */ { 0, 0, 0, 0, 0 },
/* U+3597 */ { 0, 0, 0, 0, 0 },
/* U+3598 */ { 0, 0, 0, 0, 0 },
/* U+3599 */ { 0, 0, 0, 0, 0 },
/* U+359a */ { 0, 0, 0, 0, 0 },
/* U+359b */ { 0, 0, 0, 0, 0 },
/* U+359c */ { 0, 0, 0, 0, 0 },
/* U+359d */ { 0, 0, 0, 0, 0 },
/* U+359e */ { 0, 0, 0, 0, 0 },
/* U+359f */ { 0, 0, 0, 0, 0 },
/* U+35a0 */ { 0, 0, 0, 0, 0 },
/* U+35a1 */ { 0, 0, 0, 0, 0 },
/* U+35a2 */ { 0, 0, 0, 0, 0 },
/* U+35a3 */ { 0, 0, 0, 0, 0 },
/* U+35a4 */ { 0, 0, 0, 0, 0 },
/* U+35a5 */ { 0, 0, 0, 0, 0 },
/* U+35a6 */ { 0, 0, 0, 0, 0 },
/* U+35a7 */ { 0, 0, 0, 0, 0 },
/* U+35a8 */ { 0, 0, 0, 0, 0 },
/* U+35a9 */ { 0, 0, 0, 0, 0 },
/* U+35aa */ { 0, 0, 0, 0, 0 },
/* U+35ab */ { 0, 0, 0, 0, 0 },
/* U+35ac */ { 0, 0, 0, 0, 0 },
/* U+35ad */ { 0, 0, 0, 0, 0 },
/* U+35ae */ { 0, 0, 0, 0, 0 },
/* U+35af */ { 0, 0, 0, 0, 0 },
/* U+35b0 */ { 0, 0, 0, 0, 0 },
/* U+35b1 */ { 0, 0, 0, 0, 0 },
/* U+35b2 */ { 0, 0, 0, 0, 0 },
/* U+35b3 */ { 0, 0, 0, 0, 0 },
/* U+35b4 */ { 0, 0, 0, 0, 0 },
/* U+35b5 */ { 0, 0, 0, 0, 0 },
/* U+35b6 */ { 0, 0, 0, 0, 0 },
/* U+35b7 */ { 0, 0, 0, 0, 0 },
/* U+35b8 */ { 0, 0, 0, 0, 0 },
/* U+35b9 */ { 0, 0, 0, 0, 0 },
/* U+35ba */ { 0, 0, 0, 0, 0 },
/* U+35bb */ { 0, 0, 0, 0, 0 },
/* U+35bc */ { 0, 0, 0, 0, 0 },
/* U+35bd */ { 0, 0, 0, 0, 0 },
/* U+35be */ { 0, 0, 0, 0, 0 },
/* U+35bf */ { 0, 0, 0, 0, 0 },
/* U+35c0 */ { 0, 0, 0, 0, 0 },
/* U+35c1 */ { 0, 0, 0, 0, 0 },
/* U+35c2 */ { 0, 0, 0, 0, 0 },
/* U+35c3 */ { 0, 0, 0, 0, 0 },
/* U+35c4 */ { 0, 0, 0, 0, 0 },
/* U+35c5 */ { 0, 0, 0, 0, 0 },
/* U+35c6 */ { 0, 0, 0, 0, 0 },
/* U+35c7 */ { 0, 0, 0, 0, 0 },
/* U+35c8 */ { 0, 0, 0, 0, 0 },
/* U+35c9 */ { 0, 0, 0, 0, 0 },
/* U+35ca */ { 0, 0, 0, 0, 0 },
/* U+35cb */ { 0, 0, 0, 0, 0 },
/* U+35cc */ { 0, 0, 0, 0, 0 },
/* U+35cd */ { 0, 0, 0, 0, 0 },
/* U+35ce */ { 0, 0, 0, 0, 0 },
/* U+35cf */ { 0, 0, 0, 0, 0 },
/* U+35d0 */ { 0, 0, 0, 0, 0 },
/* U+35d1 */ { 0, 0, 0, 0, 0 },
/* U+35d2 */ { 0, 0, 0, 0, 0 },
/* U+35d3 */ { 0, 0, 0, 0, 0 },
/* U+35d4 */ { 0, 0, 0, 0, 0 },
/* U+35d5 */ { 0, 0, 0, 0, 0 },
/* U+35d6 */ { 0, 0, 0, 0, 0 },
/* U+35d7 */ { 0, 0, 0, 0, 0 },
/* U+35d8 */ { 0, 0, 0, 0, 0 },
/* U+35d9 */ { 0, 0, 0, 0, 0 },
/* U+35da */ { 0, 0, 0, 0, 0 },
/* U+35db */ { 0, 0, 0, 0, 0 },
/* U+35dc */ { 0, 0, 0, 0, 0 },
/* U+35dd */ { 0, 0, 0, 0, 0 },
/* U+35de */ { 0, 0, 0, 0, 0 },
/* U+35df */ { 0, 0, 0, 0, 0 },
/* U+35e0 */ { 0, 0, 0, 0, 0 },
/* U+35e1 */ { 0, 0, 0, 0, 0 },
/* U+35e2 */ { 0, 0, 0, 0, 0 },
/* U+35e3 */ { 0, 0, 0, 0, 0 },
/* U+35e4 */ { 0, 0, 0, 0, 0 },
/* U+35e5 */ { 0, 0, 0, 0, 0 },
/* U+35e6 */ { 0, 0, 0, 0, 0 },
/* U+35e7 */ { 0, 0, 0, 0, 0 },
/* U+35e8 */ { 0, 0, 0, 0, 0 },
/* U+35e9 */ { 0, 0, 0, 0, 0 },
/* U+35ea */ { 0, 0, 0, 0, 0 },
/* U+35eb */ { 0, 0, 0, 0, 0 },
/* U+35ec */ { 0, 0, 0, 0, 0 },
/* U+35ed */ { 0, 0, 0, 0, 0 },
/* U+35ee */ { 0, 0, 0, 0, 0 },
/* U+35ef */ { 0, 0, 0, 0, 0 },
/* U+35f0 */ { 0, 0, 0, 0, 0 },
/* U+35f1 */ { 0, 0, 0, 0, 0 },
/* U+35f2 */ { 0, 0, 0, 0, 0 },
/* U+35f3 */ { 0, 0, 0, 0, 0 },
/* U+35f4 */ { 0, 0, 0, 0, 0 },
/* U+35f5 */ { 0, 0, 0, 0, 0 },
/* U+35f6 */ { 0, 0, 0, 0, 0 },
/* U+35f7 */ { 0, 0, 0, 0, 0 },
/* U+35f8 */ { 0, 0, 0, 0, 0 },
/* U+35f9 */ { 0, 0, 0, 0, 0 },
/* U+35fa */ { 0, 0, 0, 0, 0 },
/* U+35fb */ { 0, 0, 0, 0, 0 },
/* U+35fc */ { 0, 0, 0, 0, 0 },
/* U+35fd */ { 0, 0, 0, 0, 0 },
/* U+35fe */ { 0, 0, 0, 0, 0 },
/* U+35ff */ { 0, 0, 0, 0, 0 },
/* U+3600 */ { 0, 0, 0, 0, 0 },
/* U+3601 */ { 0, 0, 0, 0, 0 },
/* U+3602 */ { 0, 0, 0, 0, 0 },
/* U+3603 */ { 0, 0, 0, 0, 0 },
/* U+3604 */ { 0, 0, 0, 0, 0 },
/* U+3605 */ { 0, 0, 0, 0, 0 },
/* U+3606 */ { 0, 0, 0, 0, 0 },
/* U+3607 */ { 0, 0, 0, 0, 0 },
/* U+3608 */ { 0, 0, 0, 0, 0 },
/* U+3609 */ { 0, 0, 0, 0, 0 },
/* U+360a */ { 0, 0, 0, 0, 0 },
/* U+360b */ { 0, 0, 0, 0, 0 },
/* U+360c */ { 0, 0, 0, 0, 0 },
/* U+360d */ { 0, 0, 0, 0, 0 },
/* U+360e */ { 0, 0, 0, 0, 0 },
/* U+360f */ { 0, 0, 0, 0, 0 },
/* U+3610 */ { 0, 0, 0, 0, 0 },
/* U+3611 */ { 0, 0, 0, 0, 0 },
/* U+3612 */ { 0, 0, 0, 0, 0 },
/* U+3613 */ { 0, 0, 0, 0, 0 },
/* U+3614 */ { 0, 0, 0, 0, 0 },
/* U+3615 */ { 0, 0, 0, 0, 0 },
/* U+3616 */ { 0, 0, 0, 0, 0 },
/* U+3617 */ { 0, 0, 0, 0, 0 },
/* U+3618 */ { 0, 0, 0, 0, 0 },
/* U+3619 */ { 0, 0, 0, 0, 0 },
/* U+361a */ { 0, 0, 0, 0, 0 },
/* U+361b */ { 0, 0, 0, 0, 0 },
/* U+361c */ { 0, 0, 0, 0, 0 },
/* U+361d */ { 0, 0, 0, 0, 0 },
/* U+361e */ { 0, 0, 0, 0, 0 },
/* U+361f */ { 0, 0, 0, 0, 0 },
/* U+3620 */ { 0, 0, 0, 0, 0 },
/* U+3621 */ { 0, 0, 0, 0, 0 },
/* U+3622 */ { 0, 0, 0, 0, 0 },
/* U+3623 */ { 0, 0, 0, 0, 0 },
/* U+3624 */ { 0, 0, 0, 0, 0 },
/* U+3625 */ { 0, 0, 0, 0, 0 },
/* U+3626 */ { 0, 0, 0, 0, 0 },
/* U+3627 */ { 0, 0, 0, 0, 0 },
/* U+3628 */ { 0, 0, 0, 0, 0 },
/* U+3629 */ { 0, 0, 0, 0, 0 },
/* U+362a */ { 0, 0, 0, 0, 0 },
/* U+362b */ { 0, 0, 0, 0, 0 },
/* U+362c */ { 0, 0, 0, 0, 0 },
/* U+362d */ { 0, 0, 0, 0, 0 },
/* U+362e */ { 0, 0, 0, 0, 0 },
/* U+362f */ { 0, 0, 0, 0, 0 },
/* U+3630 */ { 0, 0, 0, 0, 0 },
/* U+3631 */ { 0, 0, 0, 0, 0 },
/* U+3632 */ { 0, 0, 0, 0, 0 },
/* U+3633 */ { 0, 0, 0, 0, 0 },
/* U+3634 */ { 0, 0, 0, 0, 0 },
/* U+3635 */ { 0, 0, 0, 0, 0 },
/* U+3636 */ { 0, 0, 0, 0, 0 },
/* U+3637 */ { 0, 0, 0, 0, 0 },
/* U+3638 */ { 0, 0, 0, 0, 0 },
/* U+3639 */ { 0, 0, 0, 0, 0 },
/* U+363a */ { 0, 0, 0, 0, 0 },
/* U+363b */ { 0, 0, 0, 0, 0 },
/* U+363c */ { 0, 0, 0, 0, 0 },
/* U+363d */ { 0, 0, 0, 0, 0 },
/* U+363e */ { 0, 0, 0, 0, 0 },
/* U+363f */ { 0, 0, 0, 0, 0 },
/* U+3640 */ { 0, 0, 0, 0, 0 },
/* U+3641 */ { 0, 0, 0, 0, 0 },
/* U+3642 */ { 0, 0, 0, 0, 0 },
/* U+3643 */ { 0, 0, 0, 0, 0 },
/* U+3644 */ { 0, 0, 0, 0, 0 },
/* U+3645 */ { 0, 0, 0, 0, 0 },
/* U+3646 */ { 0, 0, 0, 0, 0 },
/* U+3647 */ { 0, 0, 0, 0, 0 },
/* U+3648 */ { 0, 0, 0, 0, 0 },
/* U+3649 */ { 0, 0, 0, 0, 0 },
/* U+364a */ { 0, 0, 0, 0, 0 },
/* U+364b */ { 0, 0, 0, 0, 0 },
/* U+364c */ { 0, 0, 0, 0, 0 },
/* U+364d */ { 0, 0, 0, 0, 0 },
/* U+364e */ { 0, 0, 0, 0, 0 },
/* U+364f */ { 0, 0, 0, 0, 0 },
/* U+3650 */ { 0, 0, 0, 0, 0 },
/* U+3651 */ { 0, 0, 0, 0, 0 },
/* U+3652 */ { 0, 0, 0, 0, 0 },
/* U+3653 */ { 0, 0, 0, 0, 0 },
/* U+3654 */ { 0, 0, 0, 0, 0 },
/* U+3655 */ { 0, 0, 0, 0, 0 },
/* U+3656 */ { 0, 0, 0, 0, 0 },
/* U+3657 */ { 0, 0, 0, 0, 0 },
/* U+3658 */ { 0, 0, 0, 0, 0 },
/* U+3659 */ { 0, 0, 0, 0, 0 },
/* U+365a */ { 0, 0, 0, 0, 0 },
/* U+365b */ { 0, 0, 0, 0, 0 },
/* U+365c */ { 0, 0, 0, 0, 0 },
/* U+365d */ { 0, 0, 0, 0, 0 },
/* U+365e */ { 0, 0, 0, 0, 0 },
/* U+365f */ { 0, 0, 0, 0, 0 },
/* U+3660 */ { 0, 0, 0, 0, 0 },
/* U+3661 */ { 0, 0, 0, 0, 0 },
/* U+3662 */ { 0, 0, 0, 0, 0 },
/* U+3663 */ { 0, 0, 0, 0, 0 },
/* U+3664 */ { 0, 0, 0, 0, 0 },
/* U+3665 */ { 0, 0, 0, 0, 0 },
/* U+3666 */ { 0, 0, 0, 0, 0 },
/* U+3667 */ { 0, 0, 0, 0, 0 },
/* U+3668 */ { 0, 0, 0, 0, 0 },
/* U+3669 */ { 0, 0, 0, 0, 0 },
/* U+366a */ { 0, 0, 0, 0, 0 },
/* U+366b */ { 0, 0, 0, 0, 0 },
/* U+366c */ { 0, 0, 0, 0, 0 },
/* U+366d */ { 0, 0, 0, 0, 0 },
/* U+366e */ { 0, 0, 0, 0, 0 },
/* U+366f */ { 0, 0, 0, 0, 0 },
/* U+3670 */ { 0, 0, 0, 0, 0 },
/* U+3671 */ { 0, 0, 0, 0, 0 },
/* U+3672 */ { 0, 0, 0, 0, 0 },
/* U+3673 */ { 0, 0, 0, 0, 0 },
/* U+3674 */ { 0, 0, 0, 0, 0 },
/* U+3675 */ { 0, 0, 0, 0, 0 },
/* U+3676 */ { 0, 0, 0, 0, 0 },
/* U+3677 */ { 0, 0, 0, 0, 0 },
/* U+3678 */ { 0, 0, 0, 0, 0 },
/* U+3679 */ { 0, 0, 0, 0, 0 },
/* U+367a */ { 0, 0, 0, 0, 0 },
/* U+367b */ { 0, 0, 0, 0, 0 },
/* U+367c */ { 0, 0, 0, 0, 0 },
/* U+367d */ { 0, 0, 0, 0, 0 },
/* U+367e */ { 0, 0, 0, 0, 0 },
/* U+367f */ { 0, 0, 0, 0, 0 },
/* U+3680 */ { 0, 0, 0, 0, 0 },
/* U+3681 */ { 0, 0, 0, 0, 0 },
/* U+3682 */ { 0, 0, 0, 0, 0 },
/* U+3683 */ { 0, 0, 0, 0, 0 },
/* U+3684 */ { 0, 0, 0, 0, 0 },
/* U+3685 */ { 0, 0, 0, 0, 0 },
/* U+3686 */ { 0, 0, 0, 0, 0 },
/* U+3687 */ { 0, 0, 0, 0, 0 },
/* U+3688 */ { 0, 0, 0, 0, 0 },
/* U+3689 */ { 0, 0, 0, 0, 0 },
/* U+368a */ { 0, 0, 0, 0, 0 },
/* U+368b */ { 0, 0, 0, 0, 0 },
/* U+368c */ { 0, 0, 0, 0, 0 },
/* U+368d */ { 0, 0, 0, 0, 0 },
/* U+368e */ { 0, 0, 0, 0, 0 },
/* U+368f */ { 0, 0, 0, 0, 0 },
/* U+3690 */ { 0, 0, 0, 0, 0 },
/* U+3691 */ { 0, 0, 0, 0, 0 },
/* U+3692 */ { 0, 0, 0, 0, 0 },
/* U+3693 */ { 0, 0, 0, 0, 0 },
/* U+3694 */ { 0, 0, 0, 0, 0 },
/* U+3695 */ { 0, 0, 0, 0, 0 },
/* U+3696 */ { 0, 0, 0, 0, 0 },
/* U+3697 */ { 0, 0, 0, 0, 0 },
/* U+3698 */ { 0, 0, 0, 0, 0 },
/* U+3699 */ { 0, 0, 0, 0, 0 },
/* U+369a */ { 0, 0, 0, 0, 0 },
/* U+369b */ { 0, 0, 0, 0, 0 },
/* U+369c */ { 0, 0, 0, 0, 0 },
/* U+369d */ { 0, 0, 0, 0, 0 },
/* U+369e */ { 0, 0, 0, 0, 0 },
/* U+369f */ { 0, 0, 0, 0, 0 },
/* U+36a0 */ { 0, 0, 0, 0, 0 },
/* U+36a1 */ { 0, 0, 0, 0, 0 },
/* U+36a2 */ { 0, 0, 0, 0, 0 },
/* U+36a3 */ { 0, 0, 0, 0, 0 },
/* U+36a4 */ { 0, 0, 0, 0, 0 },
/* U+36a5 */ { 0, 0, 0, 0, 0 },
/* U+36a6 */ { 0, 0, 0, 0, 0 },
/* U+36a7 */ { 0, 0, 0, 0, 0 },
/* U+36a8 */ { 0, 0, 0, 0, 0 },
/* U+36a9 */ { 0, 0, 0, 0, 0 },
/* U+36aa */ { 0, 0, 0, 0, 0 },
/* U+36ab */ { 0, 0, 0, 0, 0 },
/* U+36ac */ { 0, 0, 0, 0, 0 },
/* U+36ad */ { 0, 0, 0, 0, 0 },
/* U+36ae */ { 0, 0, 0, 0, 0 },
/* U+36af */ { 0, 0, 0, 0, 0 },
/* U+36b0 */ { 0, 0, 0, 0, 0 },
/* U+36b1 */ { 0, 0, 0, 0, 0 },
/* U+36b2 */ { 0, 0, 0, 0, 0 },
/* U+36b3 */ { 0, 0, 0, 0, 0 },
/* U+36b4 */ { 0, 0, 0, 0, 0 },
/* U+36b5 */ { 0, 0, 0, 0, 0 },
/* U+36b6 */ { 0, 0, 0, 0, 0 },
/* U+36b7 */ { 0, 0, 0, 0, 0 },
/* U+36b8 */ { 0, 0, 0, 0, 0 },
/* U+36b9 */ { 0, 0, 0, 0, 0 },
/* U+36ba */ { 0, 0, 0, 0, 0 },
/* U+36bb */ { 0, 0, 0, 0, 0 },
/* U+36bc */ { 0, 0, 0, 0, 0 },
/* U+36bd */ { 0, 0, 0, 0, 0 },
/* U+36be */ { 0, 0, 0, 0, 0 },
/* U+36bf */ { 0, 0, 0, 0, 0 },
/* U+36c0 */ { 0, 0, 0, 0, 0 },
/* U+36c1 */ { 0, 0, 0, 0, 0 },
/* U+36c2 */ { 0, 0, 0, 0, 0 },
/* U+36c3 */ { 0, 0, 0, 0, 0 },
/* U+36c4 */ { 0, 0, 0, 0, 0 },
/* U+36c5 */ { 0, 0, 0, 0, 0 },
/* U+36c6 */ { 0, 0, 0, 0, 0 },
/* U+36c7 */ { 0, 0, 0, 0, 0 },
/* U+36c8 */ { 0, 0, 0, 0, 0 },
/* U+36c9 */ { 0, 0, 0, 0, 0 },
/* U+36ca */ { 0, 0, 0, 0, 0 },
/* U+36cb */ { 0, 0, 0, 0, 0 },
/* U+36cc */ { 0, 0, 0, 0, 0 },
/* U+36cd */ { 0, 0, 0, 0, 0 },
/* U+36ce */ { 0, 0, 0, 0, 0 },
/* U+36cf */ { 0, 0, 0, 0, 0 },
/* U+36d0 */ { 0, 0, 0, 0, 0 },
/* U+36d1 */ { 0, 0, 0, 0, 0 },
/* U+36d2 */ { 0, 0, 0, 0, 0 },
/* U+36d3 */ { 0, 0, 0, 0, 0 },
/* U+36d4 */ { 0, 0, 0, 0, 0 },
/* U+36d5 */ { 0, 0, 0, 0, 0 },
/* U+36d6 */ { 0, 0, 0, 0, 0 },
/* U+36d7 */ { 0, 0, 0, 0, 0 },
/* U+36d8 */ { 0, 0, 0, 0, 0 },
/* U+36d9 */ { 0, 0, 0, 0, 0 },
/* U+36da */ { 0, 0, 0, 0, 0 },
/* U+36db */ { 0, 0, 0, 0, 0 },
/* U+36dc */ { 0, 0, 0, 0, 0 },
/* U+36dd */ { 0, 0, 0, 0, 0 },
/* U+36de */ { 0, 0, 0, 0, 0 },
/* U+36df */ { 0, 0, 0, 0, 0 },
/* U+36e0 */ { 0, 0, 0, 0, 0 },
/* U+36e1 */ { 0, 0, 0, 0, 0 },
/* U+36e2 */ { 0, 0, 0, 0, 0 },
/* U+36e3 */ { 0, 0, 0, 0, 0 },
/* U+36e4 */ { 0, 0, 0, 0, 0 },
/* U+36e5 */ { 0, 0, 0, 0, 0 },
/* U+36e6 */ { 0, 0, 0, 0, 0 },
/* U+36e7 */ { 0, 0, 0, 0, 0 },
/* U+36e8 */ { 0, 0, 0, 0, 0 },
/* U+36e9 */ { 0, 0, 0, 0, 0 },
/* U+36ea */ { 0, 0, 0, 0, 0 },
/* U+36eb */ { 0, 0, 0, 0, 0 },
/* U+36ec */ { 0, 0, 0, 0, 0 },
/* U+36ed */ { 0, 0, 0, 0, 0 },
/* U+36ee */ { 0, 0, 0, 0, 0 },
/* U+36ef */ { 0, 0, 0, 0, 0 },
/* U+36f0 */ { 0, 0, 0, 0, 0 },
/* U+36f1 */ { 0, 0, 0, 0, 0 },
/* U+36f2 */ { 0, 0, 0, 0, 0 },
/* U+36f3 */ { 0, 0, 0, 0, 0 },
/* U+36f4 */ { 0, 0, 0, 0, 0 },
/* U+36f5 */ { 0, 0, 0, 0, 0 },
/* U+36f6 */ { 0, 0, 0, 0, 0 },
/* U+36f7 */ { 0, 0, 0, 0, 0 },
/* U+36f8 */ { 0, 0, 0, 0, 0 },
/* U+36f9 */ { 0, 0, 0, 0, 0 },
/* U+36fa */ { 0, 0, 0, 0, 0 },
/* U+36fb */ { 0, 0, 0, 0, 0 },
/* U+36fc */ { 0, 0, 0, 0, 0 },
/* U+36fd */ { 0, 0, 0, 0, 0 },
/* U+36fe */ { 0, 0, 0, 0, 0 },
/* U+36ff */ { 0, 0, 0, 0, 0 },
/* U+3700 */ { 0, 0, 0, 0, 0 },
/* U+3701 */ { 0, 0, 0, 0, 0 },
/* U+3702 */ { 0, 0, 0, 0, 0 },
/* U+3703 */ { 0, 0, 0, 0, 0 },
/* U+3704 */ { 0, 0, 0, 0, 0 },
/* U+3705 */ { 0, 0, 0, 0, 0 },
/* U+3706 */ { 0, 0, 0, 0, 0 },
/* U+3707 */ { 0, 0, 0, 0, 0 },
/* U+3708 */ { 0, 0, 0, 0, 0 },
/* U+3709 */ { 0, 0, 0, 0, 0 },
/* U+370a */ { 0, 0, 0, 0, 0 },
/* U+370b */ { 0, 0, 0, 0, 0 },
/* U+370c */ { 0, 0, 0, 0, 0 },
/* U+370d */ { 0, 0, 0, 0, 0 },
/* U+370e */ { 0, 0, 0, 0, 0 },
/* U+370f */ { 0, 0, 0, 0, 0 },
/* U+3710 */ { 0, 0, 0, 0, 0 },
/* U+3711 */ { 0, 0, 0, 0, 0 },
/* U+3712 */ { 0, 0, 0, 0, 0 },
/* U+3713 */ { 0, 0, 0, 0, 0 },
/* U+3714 */ { 0, 0, 0, 0, 0 },
/* U+3715 */ { 0, 0, 0, 0, 0 },
/* U+3716 */ { 0, 0, 0, 0, 0 },
/* U+3717 */ { 0, 0, 0, 0, 0 },
/* U+3718 */ { 0, 0, 0, 0, 0 },
/* U+3719 */ { 0, 0, 0, 0, 0 },
/* U+371a */ { 0, 0, 0, 0, 0 },
/* U+371b */ { 0, 0, 0, 0, 0 },
/* U+371c */ { 0, 0, 0, 0, 0 },
/* U+371d */ { 0, 0, 0, 0, 0 },
/* U+371e */ { 0, 0, 0, 0, 0 },
/* U+371f */ { 0, 0, 0, 0, 0 },
/* U+3720 */ { 0, 0, 0, 0, 0 },
/* U+3721 */ { 0, 0, 0, 0, 0 },
/* U+3722 */ { 0, 0, 0, 0, 0 },
/* U+3723 */ { 0, 0, 0, 0, 0 },
/* U+3724 */ { 0, 0, 0, 0, 0 },
/* U+3725 */ { 0, 0, 0, 0, 0 },
/* U+3726 */ { 0, 0, 0, 0, 0 },
/* U+3727 */ { 0, 0, 0, 0, 0 },
/* U+3728 */ { 0, 0, 0, 0, 0 },
/* U+3729 */ { 0, 0, 0, 0, 0 },
/* U+372a */ { 0, 0, 0, 0, 0 },
/* U+372b */ { 0, 0, 0, 0, 0 },
/* U+372c */ { 0, 0, 0, 0, 0 },
/* U+372d */ { 0, 0, 0, 0, 0 },
/* U+372e */ { 0, 0, 0, 0, 0 },
/* U+372f */ { 0, 0, 0, 0, 0 },
/* U+3730 */ { 0, 0, 0, 0, 0 },
/* U+3731 */ { 0, 0, 0, 0, 0 },
/* U+3732 */ { 0, 0, 0, 0, 0 },
/* U+3733 */ { 0, 0, 0, 0, 0 },
/* U+3734 */ { 0, 0, 0, 0, 0 },
/* U+3735 */ { 0, 0, 0, 0, 0 },
/* U+3736 */ { 0, 0, 0, 0, 0 },
/* U+3737 */ { 0, 0, 0, 0, 0 },
/* U+3738 */ { 0, 0, 0, 0, 0 },
/* U+3739 */ { 0, 0, 0, 0, 0 },
/* U+373a */ { 0, 0, 0, 0, 0 },
/* U+373b */ { 0, 0, 0, 0, 0 },
/* U+373c */ { 0, 0, 0, 0, 0 },
/* U+373d */ { 0, 0, 0, 0, 0 },
/* U+373e */ { 0, 0, 0, 0, 0 },
/* U+373f */ { 0, 0, 0, 0, 0 },
/* U+3740 */ { 0, 0, 0, 0, 0 },
/* U+3741 */ { 0, 0, 0, 0, 0 },
/* U+3742 */ { 0, 0, 0, 0, 0 },
/* U+3743 */ { 0, 0, 0, 0, 0 },
/* U+3744 */ { 0, 0, 0, 0, 0 },
/* U+3745 */ { 0, 0, 0, 0, 0 },
/* U+3746 */ { 0, 0, 0, 0, 0 },
/* U+3747 */ { 0, 0, 0, 0, 0 },
/* U+3748 */ { 0, 0, 0, 0, 0 },
/* U+3749 */ { 0, 0, 0, 0, 0 },
/* U+374a */ { 0, 0, 0, 0, 0 },
/* U+374b */ { 0, 0, 0, 0, 0 },
/* U+374c */ { 0, 0, 0, 0, 0 },
/* U+374d */ { 0, 0, 0, 0, 0 },
/* U+374e */ { 0, 0, 0, 0, 0 },
/* U+374f */ { 0, 0, 0, 0, 0 },
/* U+3750 */ { 0, 0, 0, 0, 0 },
/* U+3751 */ { 0, 0, 0, 0, 0 },
/* U+3752 */ { 0, 0, 0, 0, 0 },
/* U+3753 */ { 0, 0, 0, 0, 0 },
/* U+3754 */ { 0, 0, 0, 0, 0 },
/* U+3755 */ { 0, 0, 0, 0, 0 },
/* U+3756 */ { 0, 0, 0, 0, 0 },
/* U+3757 */ { 0, 0, 0, 0, 0 },
/* U+3758 */ { 0, 0, 0, 0, 0 },
/* U+3759 */ { 0, 0, 0, 0, 0 },
/* U+375a */ { 0, 0, 0, 0, 0 },
/* U+375b */ { 0, 0, 0, 0, 0 },
/* U+375c */ { 0, 0, 0, 0, 0 },
/* U+375d */ { 0, 0, 0, 0, 0 },
/* U+375e */ { 0, 0, 0, 0, 0 },
/* U+375f */ { 0, 0, 0, 0, 0 },
/* U+3760 */ { 0, 0, 0, 0, 0 },
/* U+3761 */ { 0, 0, 0, 0, 0 },
/* U+3762 */ { 0, 0, 0, 0, 0 },
/* U+3763 */ { 0, 0, 0, 0, 0 },
/* U+3764 */ { 0, 0, 0, 0, 0 },
/* U+3765 */ { 0, 0, 0, 0, 0 },
/* U+3766 */ { 0, 0, 0, 0, 0 },
/* U+3767 */ { 0, 0, 0, 0, 0 },
/* U+3768 */ { 0, 0, 0, 0, 0 },
/* U+3769 */ { 0, 0, 0, 0, 0 },
/* U+376a */ { 0, 0, 0, 0, 0 },
/* U+376b */ { 0, 0, 0, 0, 0 },
/* U+376c */ { 0, 0, 0, 0, 0 },
/* U+376d */ { 0, 0, 0, 0, 0 },
/* U+376e */ { 0, 0, 0, 0, 0 },
/* U+376f */ { 0, 0, 0, 0, 0 },
/* U+3770 */ { 0, 0, 0, 0, 0 },
/* U+3771 */ { 0, 0, 0, 0, 0 },
/* U+3772 */ { 0, 0, 0, 0, 0 },
/* U+3773 */ { 0, 0, 0, 0, 0 },
/* U+3774 */ { 0, 0, 0, 0, 0 },
/* U+3775 */ { 0, 0, 0, 0, 0 },
/* U+3776 */ { 0, 0, 0, 0, 0 },
/* U+3777 */ { 0, 0, 0, 0, 0 },
/* U+3778 */ { 0, 0, 0, 0, 0 },
/* U+3779 */ { 0, 0, 0, 0, 0 },
/* U+377a */ { 0, 0, 0, 0, 0 },
/* U+377b */ { 0, 0, 0, 0, 0 },
/* U+377c */ { 0, 0, 0, 0, 0 },
/* U+377d */ { 0, 0, 0, 0, 0 },
/* U+377e */ { 0, 0, 0, 0, 0 },
/* U+377f */ { 0, 0, 0, 0, 0 },
/* U+3780 */ { 0, 0, 0, 0, 0 },
/* U+3781 */ { 0, 0, 0, 0, 0 },
/* U+3782 */ { 0, 0, 0, 0, 0 },
/* U+3783 */ { 0, 0, 0, 0, 0 },
/* U+3784 */ { 0, 0, 0, 0, 0 },
/* U+3785 */ { 0, 0, 0, 0, 0 },
/* U+3786 */ { 0, 0, 0, 0, 0 },
/* U+3787 */ { 0, 0, 0, 0, 0 },
/* U+3788 */ { 0, 0, 0, 0, 0 },
/* U+3789 */ { 0, 0, 0, 0, 0 },
/* U+378a */ { 0, 0, 0, 0, 0 },
/* U+378b */ { 0, 0, 0, 0, 0 },
/* U+378c */ { 0, 0, 0, 0, 0 },
/* U+378d */ { 0, 0, 0, 0, 0 },
/* U+378e */ { 0, 0, 0, 0, 0 },
/* U+378f */ { 0, 0, 0, 0, 0 },
/* U+3790 */ { 0, 0, 0, 0, 0 },
/* U+3791 */ { 0, 0, 0, 0, 0 },
/* U+3792 */ { 0, 0, 0, 0, 0 },
/* U+3793 */ { 0, 0, 0, 0, 0 },
/* U+3794 */ { 0, 0, 0, 0, 0 },
/* U+3795 */ { 0, 0, 0, 0, 0 },
/* U+3796 */ { 0, 0, 0, 0, 0 },
/* U+3797 */ { 0, 0, 0, 0, 0 },
/* U+3798 */ { 0, 0, 0, 0, 0 },
/* U+3799 */ { 0, 0, 0, 0, 0 },
/* U+379a */ { 0, 0, 0, 0, 0 },
/* U+379b */ { 0, 0, 0, 0, 0 },
/* U+379c */ { 0, 0, 0, 0, 0 },
/* U+379d */ { 0, 0, 0, 0, 0 },
/* U+379e */ { 0, 0, 0, 0, 0 },
/* U+379f */ { 0, 0, 0, 0, 0 },
/* U+37a0 */ { 0, 0, 0, 0, 0 },
/* U+37a1 */ { 0, 0, 0, 0, 0 },
/* U+37a2 */ { 0, 0, 0, 0, 0 },
/* U+37a3 */ { 0, 0, 0, 0, 0 },
/* U+37a4 */ { 0, 0, 0, 0, 0 },
/* U+37a5 */ { 0, 0, 0, 0, 0 },
/* U+37a6 */ { 0, 0, 0, 0, 0 },
/* U+37a7 */ { 0, 0, 0, 0, 0 },
/* U+37a8 */ { 0, 0, 0, 0, 0 },
/* U+37a9 */ { 0, 0, 0, 0, 0 },
/* U+37aa */ { 0, 0, 0, 0, 0 },
/* U+37ab */ { 0, 0, 0, 0, 0 },
/* U+37ac */ { 0, 0, 0, 0, 0 },
/* U+37ad */ { 0, 0, 0, 0, 0 },
/* U+37ae */ { 0, 0, 0, 0, 0 },
/* U+37af */ { 0, 0, 0, 0, 0 },
/* U+37b0 */ { 0, 0, 0, 0, 0 },
/* U+37b1 */ { 0, 0, 0, 0, 0 },
/* U+37b2 */ { 0, 0, 0, 0, 0 },
/* U+37b3 */ { 0, 0, 0, 0, 0 },
/* U+37b4 */ { 0, 0, 0, 0, 0 },
/* U+37b5 */ { 0, 0, 0, 0, 0 },
/* U+37b6 */ { 0, 0, 0, 0, 0 },
/* U+37b7 */ { 0, 0, 0, 0, 0 },
/* U+37b8 */ { 0, 0, 0, 0, 0 },
/* U+37b9 */ { 0, 0, 0, 0, 0 },
/* U+37ba */ { 0, 0, 0, 0, 0 },
/* U+37bb */ { 0, 0, 0, 0, 0 },
/* U+37bc */ { 0, 0, 0, 0, 0 },
/* U+37bd */ { 0, 0, 0, 0, 0 },
/* U+37be */ { 0, 0, 0, 0, 0 },
/* U+37bf */ { 0, 0, 0, 0, 0 },
/* U+37c0 */ { 0, 0, 0, 0, 0 },
/* U+37c1 */ { 0, 0, 0, 0, 0 },
/* U+37c2 */ { 0, 0, 0, 0, 0 },
/* U+37c3 */ { 0, 0, 0, 0, 0 },
/* U+37c4 */ { 0, 0, 0, 0, 0 },
/* U+37c5 */ { 0, 0, 0, 0, 0 },
/* U+37c6 */ { 0, 0, 0, 0, 0 },
/* U+37c7 */ { 0, 0, 0, 0, 0 },
/* U+37c8 */ { 0, 0, 0, 0, 0 },
/* U+37c9 */ { 0, 0, 0, 0, 0 },
/* U+37ca */ { 0, 0, 0, 0, 0 },
/* U+37cb */ { 0, 0, 0, 0, 0 },
/* U+37cc */ { 0, 0, 0, 0, 0 },
/* U+37cd */ { 0, 0, 0, 0, 0 },
/* U+37ce */ { 0, 0, 0, 0, 0 },
/* U+37cf */ { 0, 0, 0, 0, 0 },
/* U+37d0 */ { 0, 0, 0, 0, 0 },
/* U+37d1 */ { 0, 0, 0, 0, 0 },
/* U+37d2 */ { 0, 0, 0, 0, 0 },
/* U+37d3 */ { 0, 0, 0, 0, 0 },
/* U+37d4 */ { 0, 0, 0, 0, 0 },
/* U+37d5 */ { 0, 0, 0, 0, 0 },
/* U+37d6 */ { 0, 0, 0, 0, 0 },
/* U+37d7 */ { 0, 0, 0, 0, 0 },
/* U+37d8 */ { 0, 0, 0, 0, 0 },
/* U+37d9 */ { 0, 0, 0, 0, 0 },
/* U+37da */ { 0, 0, 0, 0, 0 },
/* U+37db */ { 0, 0, 0, 0, 0 },
/* U+37dc */ { 0, 0, 0, 0, 0 },
/* U+37dd */ { 0, 0, 0, 0, 0 },
/* U+37de */ { 0, 0, 0, 0, 0 },
/* U+37df */ { 0, 0, 0, 0, 0 },
/* U+37e0 */ { 0, 0, 0, 0, 0 },
/* U+37e1 */ { 0, 0, 0, 0, 0 },
/* U+37e2 */ { 0, 0, 0, 0, 0 },
/* U+37e3 */ { 0, 0, 0, 0, 0 },
/* U+37e4 */ { 0, 0, 0, 0, 0 },
/* U+37e5 */ { 0, 0, 0, 0, 0 },
/* U+37e6 */ { 0, 0, 0, 0, 0 },
/* U+37e7 */ { 0, 0, 0, 0, 0 },
/* U+37e8 */ { 0, 0, 0, 0, 0 },
/* U+37e9 */ { 0, 0, 0, 0, 0 },
/* U+37ea */ { 0, 0, 0, 0, 0 },
/* U+37eb */ { 0, 0, 0, 0, 0 },
/* U+37ec */ { 0, 0, 0, 0, 0 },
/* U+37ed */ { 0, 0, 0, 0, 0 },
/* U+37ee */ { 0, 0, 0, 0, 0 },
/* U+37ef */ { 0, 0, 0, 0, 0 },
/* U+37f0 */ { 0, 0, 0, 0, 0 },
/* U+37f1 */ { 0, 0, 0, 0, 0 },
/* U+37f2 */ { 0, 0, 0, 0, 0 },
/* U+37f3 */ { 0, 0, 0, 0, 0 },
/* U+37f4 */ { 0, 0, 0, 0, 0 },
/* U+37f5 */ { 0, 0, 0, 0, 0 },
/* U+37f6 */ { 0, 0, 0, 0, 0 },
/* U+37f7 */ { 0, 0, 0, 0, 0 },
/* U+37f8 */ { 0, 0, 0, 0, 0 },
/* U+37f9 */ { 0, 0, 0, 0, 0 },
/* U+37fa */ { 0, 0, 0, 0, 0 },
/* U+37fb */ { 0, 0, 0, 0, 0 },
/* U+37fc */ { 0, 0, 0, 0, 0 },
/* U+37fd */ { 0, 0, 0, 0, 0 },
/* U+37fe */ { 0, 0, 0, 0, 0 },
/* U+37ff */ { 0, 0, 0, 0, 0 },
/* U+3800 */ { 0, 0, 0, 0, 0 },
/* U+3801 */ { 0, 0, 0, 0, 0 },
/* U+3802 */ { 0, 0, 0, 0, 0 },
/* U+3803 */ { 0, 0, 0, 0, 0 },
/* U+3804 */ { 0, 0, 0, 0, 0 },
/* U+3805 */ { 0, 0, 0, 0, 0 },
/* U+3806 */ { 0, 0, 0, 0, 0 },
/* U+3807 */ { 0, 0, 0, 0, 0 },
/* U+3808 */ { 0, 0, 0, 0, 0 },
/* U+3809 */ { 0, 0, 0, 0, 0 },
/* U+380a */ { 0, 0, 0, 0, 0 },
/* U+380b */ { 0, 0, 0, 0, 0 },
/* U+380c */ { 0, 0, 0, 0, 0 },
/* U+380d */ { 0, 0, 0, 0, 0 },
/* U+380e */ { 0, 0, 0, 0, 0 },
/* U+380f */ { 0, 0, 0, 0, 0 },
/* U+3810 */ { 0, 0, 0, 0, 0 },
/* U+3811 */ { 0, 0, 0, 0, 0 },
/* U+3812 */ { 0, 0, 0, 0, 0 },
/* U+3813 */ { 0, 0, 0, 0, 0 },
/* U+3814 */ { 0, 0, 0, 0, 0 },
/* U+3815 */ { 0, 0, 0, 0, 0 },
/* U+3816 */ { 0, 0, 0, 0, 0 },
/* U+3817 */ { 0, 0, 0, 0, 0 },
/* U+3818 */ { 0, 0, 0, 0, 0 },
/* U+3819 */ { 0, 0, 0, 0, 0 },
/* U+381a */ { 0, 0, 0, 0, 0 },
/* U+381b */ { 0, 0, 0, 0, 0 },
/* U+381c */ { 0, 0, 0, 0, 0 },
/* U+381d */ { 0, 0, 0, 0, 0 },
/* U+381e */ { 0, 0, 0, 0, 0 },
/* U+381f */ { 0, 0, 0, 0, 0 },
/* U+3820 */ { 0, 0, 0, 0, 0 },
/* U+3821 */ { 0, 0, 0, 0, 0 },
/* U+3822 */ { 0, 0, 0, 0, 0 },
/* U+3823 */ { 0, 0, 0, 0, 0 },
/* U+3824 */ { 0, 0, 0, 0, 0 },
/* U+3825 */ { 0, 0, 0, 0, 0 },
/* U+3826 */ { 0, 0, 0, 0, 0 },
/* U+3827 */ { 0, 0, 0, 0, 0 },
/* U+3828 */ { 0, 0, 0, 0, 0 },
/* U+3829 */ { 0, 0, 0, 0, 0 },
/* U+382a */ { 0, 0, 0, 0, 0 },
/* U+382b */ { 0, 0, 0, 0, 0 },
/* U+382c */ { 0, 0, 0, 0, 0 },
/* U+382d */ { 0, 0, 0, 0, 0 },
/* U+382e */ { 0, 0, 0, 0, 0 },
/* U+382f */ { 0, 0, 0, 0, 0 },
/* U+3830 */ { 0, 0, 0, 0, 0 },
/* U+3831 */ { 0, 0, 0, 0, 0 },
/* U+3832 */ { 0, 0, 0, 0, 0 },
/* U+3833 */ { 0, 0, 0, 0, 0 },
/* U+3834 */ { 0, 0, 0, 0, 0 },
/* U+3835 */ { 0, 0, 0, 0, 0 },
/* U+3836 */ { 0, 0, 0, 0, 0 },
/* U+3837 */ { 0, 0, 0, 0, 0 },
/* U+3838 */ { 0, 0, 0, 0, 0 },
/* U+3839 */ { 0, 0, 0, 0, 0 },
/* U+383a */ { 0, 0, 0, 0, 0 },
/* U+383b */ { 0, 0, 0, 0, 0 },
/* U+383c */ { 0, 0, 0, 0, 0 },
/* U+383d */ { 0, 0, 0, 0, 0 },
/* U+383e */ { 0, 0, 0, 0, 0 },
/* U+383f */ { 0, 0, 0, 0, 0 },
/* U+3840 */ { 0, 0, 0, 0, 0 },
/* U+3841 */ { 0, 0, 0, 0, 0 },
/* U+3842 */ { 0, 0, 0, 0, 0 },
/* U+3843 */ { 0, 0, 0, 0, 0 },
/* U+3844 */ { 0, 0, 0, 0, 0 },
/* U+3845 */ { 0, 0, 0, 0, 0 },
/* U+3846 */ { 0, 0, 0, 0, 0 },
/* U+3847 */ { 0, 0, 0, 0, 0 },
/* U+3848 */ { 0, 0, 0, 0, 0 },
/* U+3849 */ { 0, 0, 0, 0, 0 },
/* U+384a */ { 0, 0, 0, 0, 0 },
/* U+384b */ { 0, 0, 0, 0, 0 },
/* U+384c */ { 0, 0, 0, 0, 0 },
/* U+384d */ { 0, 0, 0, 0, 0 },
/* U+384e */ { 0, 0, 0, 0, 0 },
/* U+384f */ { 0, 0, 0, 0, 0 },
/* U+3850 */ { 0, 0, 0, 0, 0 },
/* U+3851 */ { 0, 0, 0, 0, 0 },
/* U+3852 */ { 0, 0, 0, 0, 0 },
/* U+3853 */ { 0, 0, 0, 0, 0 },
/* U+3854 */ { 0, 0, 0, 0, 0 },
/* U+3855 */ { 0, 0, 0, 0, 0 },
/* U+3856 */ { 0, 0, 0, 0, 0 },
/* U+3857 */ { 0, 0, 0, 0, 0 },
/* U+3858 */ { 0, 0, 0, 0, 0 },
/* U+3859 */ { 0, 0, 0, 0, 0 },
/* U+385a */ { 0, 0, 0, 0, 0 },
/* U+385b */ { 0, 0, 0, 0, 0 },
/* U+385c */ { 0, 0, 0, 0, 0 },
/* U+385d */ { 0, 0, 0, 0, 0 },
/* U+385e */ { 0, 0, 0, 0, 0 },
/* U+385f */ { 0, 0, 0, 0, 0 },
/* U+3860 */ { 0, 0, 0, 0, 0 },
/* U+3861 */ { 0, 0, 0, 0, 0 },
/* U+3862 */ { 0, 0, 0, 0, 0 },
/* U+3863 */ { 0, 0, 0, 0, 0 },
/* U+3864 */ { 0, 0, 0, 0, 0 },
/* U+3865 */ { 0, 0, 0, 0, 0 },
/* U+3866 */ { 0, 0, 0, 0, 0 },
/* U+3867 */ { 0, 0, 0, 0, 0 },
/* U+3868 */ { 0, 0, 0, 0, 0 },
/* U+3869 */ { 0, 0, 0, 0, 0 },
/* U+386a */ { 0, 0, 0, 0, 0 },
/* U+386b */ { 0, 0, 0, 0, 0 },
/* U+386c */ { 0, 0, 0, 0, 0 },
/* U+386d */ { 0, 0, 0, 0, 0 },
/* U+386e */ { 0, 0, 0, 0, 0 },
/* U+386f */ { 0, 0, 0, 0, 0 },
/* U+3870 */ { 0, 0, 0, 0, 0 },
/* U+3871 */ { 0, 0, 0, 0, 0 },
/* U+3872 */ { 0, 0, 0, 0, 0 },
/* U+3873 */ { 0, 0, 0, 0, 0 },
/* U+3874 */ { 0, 0, 0, 0, 0 },
/* U+3875 */ { 0, 0, 0, 0, 0 },
/* U+3876 */ { 0, 0, 0, 0, 0 },
/* U+3877 */ { 0, 0, 0, 0, 0 },
/* U+3878 */ { 0, 0, 0, 0, 0 },
/* U+3879 */ { 0, 0, 0, 0, 0 },
/* U+387a */ { 0, 0, 0, 0, 0 },
/* U+387b */ { 0, 0, 0, 0, 0 },
/* U+387c */ { 0, 0, 0, 0, 0 },
/* U+387d */ { 0, 0, 0, 0, 0 },
/* U+387e */ { 0, 0, 0, 0, 0 },
/* U+387f */ { 0, 0, 0, 0, 0 },
/* U+3880 */ { 0, 0, 0, 0, 0 },
/* U+3881 */ { 0, 0, 0, 0, 0 },
/* U+3882 */ { 0, 0, 0, 0, 0 },
/* U+3883 */ { 0, 0, 0, 0, 0 },
/* U+3884 */ { 0, 0, 0, 0, 0 },
/* U+3885 */ { 0, 0, 0, 0, 0 },
/* U+3886 */ { 0, 0, 0, 0, 0 },
/* U+3887 */ { 0, 0, 0, 0, 0 },
/* U+3888 */ { 0, 0, 0, 0, 0 },
/* U+3889 */ { 0, 0, 0, 0, 0 },
/* U+388a */ { 0, 0, 0, 0, 0 },
/* U+388b */ { 0, 0, 0, 0, 0 },
/* U+388c */ { 0, 0, 0, 0, 0 },
/* U+388d */ { 0, 0, 0, 0, 0 },
/* U+388e */ { 0, 0, 0, 0, 0 },
/* U+388f */ { 0, 0, 0, 0, 0 },
/* U+3890 */ { 0, 0, 0, 0, 0 },
/* U+3891 */ { 0, 0, 0, 0, 0 },
/* U+3892 */ { 0, 0, 0, 0, 0 },
/* U+3893 */ { 0, 0, 0, 0, 0 },
/* U+3894 */ { 0, 0, 0, 0, 0 },
/* U+3895 */ { 0, 0, 0, 0, 0 },
/* U+3896 */ { 0, 0, 0, 0, 0 },
/* U+3897 */ { 0, 0, 0, 0, 0 },
/* U+3898 */ { 0, 0, 0, 0, 0 },
/* U+3899 */ { 0, 0, 0, 0, 0 },
/* U+389a */ { 0, 0, 0, 0, 0 },
/* U+389b */ { 0, 0, 0, 0, 0 },
/* U+389c */ { 0, 0, 0, 0, 0 },
/* U+389d */ { 0, 0, 0, 0, 0 },
/* U+389e */ { 0, 0, 0, 0, 0 },
/* U+389f */ { 0, 0, 0, 0, 0 },
/* U+38a0 */ { 0, 0, 0, 0, 0 },
/* U+38a1 */ { 0, 0, 0, 0, 0 },
/* U+38a2 */ { 0, 0, 0, 0, 0 },
/* U+38a3 */ { 0, 0, 0, 0, 0 },
/* U+38a4 */ { 0, 0, 0, 0, 0 },
/* U+38a5 */ { 0, 0, 0, 0, 0 },
/* U+38a6 */ { 0, 0, 0, 0, 0 },
/* U+38a7 */ { 0, 0, 0, 0, 0 },
/* U+38a8 */ { 0, 0, 0, 0, 0 },
/* U+38a9 */ { 0, 0, 0, 0, 0 },
/* U+38aa */ { 0, 0, 0, 0, 0 },
/* U+38ab */ { 0, 0, 0, 0, 0 },
/* U+38ac */ { 0, 0, 0, 0, 0 },
/* U+38ad */ { 0, 0, 0, 0, 0 },
/* U+38ae */ { 0, 0, 0, 0, 0 },
/* U+38af */ { 0, 0, 0, 0, 0 },
/* U+38b0 */ { 0, 0, 0, 0, 0 },
/* U+38b1 */ { 0, 0, 0, 0, 0 },
/* U+38b2 */ { 0, 0, 0, 0, 0 },
/* U+38b3 */ { 0, 0, 0, 0, 0 },
/* U+38b4 */ { 0, 0, 0, 0, 0 },
/* U+38b5 */ { 0, 0, 0, 0, 0 },
/* U+38b6 */ { 0, 0, 0, 0, 0 },
/* U+38b7 */ { 0, 0, 0, 0, 0 },
/* U+38b8 */ { 0, 0, 0, 0, 0 },
/* U+38b9 */ { 0, 0, 0, 0, 0 },
/* U+38ba */ { 0, 0, 0, 0, 0 },
/* U+38bb */ { 0, 0, 0, 0, 0 },
/* U+38bc */ { 0, 0, 0, 0, 0 },
/* U+38bd */ { 0, 0, 0, 0, 0 },
/* U+38be */ { 0, 0, 0, 0, 0 },
/* U+38bf */ { 0, 0, 0, 0, 0 },
/* U+38c0 */ { 0, 0, 0, 0, 0 },
/* U+38c1 */ { 0, 0, 0, 0, 0 },
/* U+38c2 */ { 0, 0, 0, 0, 0 },
/* U+38c3 */ { 0, 0, 0, 0, 0 },
/* U+38c4 */ { 0, 0, 0, 0, 0 },
/* U+38c5 */ { 0, 0, 0, 0, 0 },
/* U+38c6 */ { 0, 0, 0, 0, 0 },
/* U+38c7 */ { 0, 0, 0, 0, 0 },
/* U+38c8 */ { 0, 0, 0, 0, 0 },
/* U+38c9 */ { 0, 0, 0, 0, 0 },
/* U+38ca */ { 0, 0, 0, 0, 0 },
/* U+38cb */ { 0, 0, 0, 0, 0 },
/* U+38cc */ { 0, 0, 0, 0, 0 },
/* U+38cd */ { 0, 0, 0, 0, 0 },
/* U+38ce */ { 0, 0, 0, 0, 0 },
/* U+38cf */ { 0, 0, 0, 0, 0 },
/* U+38d0 */ { 0, 0, 0, 0, 0 },
/* U+38d1 */ { 0, 0, 0, 0, 0 },
/* U+38d2 */ { 0, 0, 0, 0, 0 },
/* U+38d3 */ { 0, 0, 0, 0, 0 },
/* U+38d4 */ { 0, 0, 0, 0, 0 },
/* U+38d5 */ { 0, 0, 0, 0, 0 },
/* U+38d6 */ { 0, 0, 0, 0, 0 },
/* U+38d7 */ { 0, 0, 0, 0, 0 },
/* U+38d8 */ { 0, 0, 0, 0, 0 },
/* U+38d9 */ { 0, 0, 0, 0, 0 },
/* U+38da */ { 0, 0, 0, 0, 0 },
/* U+38db */ { 0, 0, 0, 0, 0 },
/* U+38dc */ { 0, 0, 0, 0, 0 },
/* U+38dd */ { 0, 0, 0, 0, 0 },
/* U+38de */ { 0, 0, 0, 0, 0 },
/* U+38df */ { 0, 0, 0, 0, 0 },
/* U+38e0 */ { 0, 0, 0, 0, 0 },
/* U+38e1 */ { 0, 0, 0, 0, 0 },
/* U+38e2 */ { 0, 0, 0, 0, 0 },
/* U+38e3 */ { 0, 0, 0, 0, 0 },
/* U+38e4 */ { 0, 0, 0, 0, 0 },
/* U+38e5 */ { 0, 0, 0, 0, 0 },
/* U+38e6 */ { 0, 0, 0, 0, 0 },
/* U+38e7 */ { 0, 0, 0, 0, 0 },
/* U+38e8 */ { 0, 0, 0, 0, 0 },
/* U+38e9 */ { 0, 0, 0, 0, 0 },
/* U+38ea */ { 0, 0, 0, 0, 0 },
/* U+38eb */ { 0, 0, 0, 0, 0 },
/* U+38ec */ { 0, 0, 0, 0, 0 },
/* U+38ed */ { 0, 0, 0, 0, 0 },
/* U+38ee */ { 0, 0, 0, 0, 0 },
/* U+38ef */ { 0, 0, 0, 0, 0 },
/* U+38f0 */ { 0, 0, 0, 0, 0 },
/* U+38f1 */ { 0, 0, 0, 0, 0 },
/* U+38f2 */ { 0, 0, 0, 0, 0 },
/* U+38f3 */ { 0, 0, 0, 0, 0 },
/* U+38f4 */ { 0, 0, 0, 0, 0 },
/* U+38f5 */ { 0, 0, 0, 0, 0 },
/* U+38f6 */ { 0, 0, 0, 0, 0 },
/* U+38f7 */ { 0, 0, 0, 0, 0 },
/* U+38f8 */ { 0, 0, 0, 0, 0 },
/* U+38f9 */ { 0, 0, 0, 0, 0 },
/* U+38fa */ { 0, 0, 0, 0, 0 },
/* U+38fb */ { 0, 0, 0, 0, 0 },
/* U+38fc */ { 0, 0, 0, 0, 0 },
/* U+38fd */ { 0, 0, 0, 0, 0 },
/* U+38fe */ { 0, 0, 0, 0, 0 },
/* U+38ff */ { 0, 0, 0, 0, 0 },
/* U+3900 */ { 0, 0, 0, 0, 0 },
/* U+3901 */ { 0, 0, 0, 0, 0 },
/* U+3902 */ { 0, 0, 0, 0, 0 },
/* U+3903 */ { 0, 0, 0, 0, 0 },
/* U+3904 */ { 0, 0, 0, 0, 0 },
/* U+3905 */ { 0, 0, 0, 0, 0 },
/* U+3906 */ { 0, 0, 0, 0, 0 },
/* U+3907 */ { 0, 0, 0, 0, 0 },
/* U+3908 */ { 0, 0, 0, 0, 0 },
/* U+3909 */ { 0, 0, 0, 0, 0 },
/* U+390a */ { 0, 0, 0, 0, 0 },
/* U+390b */ { 0, 0, 0, 0, 0 },
/* U+390c */ { 0, 0, 0, 0, 0 },
/* U+390d */ { 0, 0, 0, 0, 0 },
/* U+390e */ { 0, 0, 0, 0, 0 },
/* U+390f */ { 0, 0, 0, 0, 0 },
/* U+3910 */ { 0, 0, 0, 0, 0 },
/* U+3911 */ { 0, 0, 0, 0, 0 },
/* U+3912 */ { 0, 0, 0, 0, 0 },
/* U+3913 */ { 0, 0, 0, 0, 0 },
/* U+3914 */ { 0, 0, 0, 0, 0 },
/* U+3915 */ { 0, 0, 0, 0, 0 },
/* U+3916 */ { 0, 0, 0, 0, 0 },
/* U+3917 */ { 0, 0, 0, 0, 0 },
/* U+3918 */ { 0, 0, 0, 0, 0 },
/* U+3919 */ { 0, 0, 0, 0, 0 },
/* U+391a */ { 0, 0, 0, 0, 0 },
/* U+391b */ { 0, 0, 0, 0, 0 },
/* U+391c */ { 0, 0, 0, 0, 0 },
/* U+391d */ { 0, 0, 0, 0, 0 },
/* U+391e */ { 0, 0, 0, 0, 0 },
/* U+391f */ { 0, 0, 0, 0, 0 },
/* U+3920 */ { 0, 0, 0, 0, 0 },
/* U+3921 */ { 0, 0, 0, 0, 0 },
/* U+3922 */ { 0, 0, 0, 0, 0 },
/* U+3923 */ { 0, 0, 0, 0, 0 },
/* U+3924 */ { 0, 0, 0, 0, 0 },
/* U+3925 */ { 0, 0, 0, 0, 0 },
/* U+3926 */ { 0, 0, 0, 0, 0 },
/* U+3927 */ { 0, 0, 0, 0, 0 },
/* U+3928 */ { 0, 0, 0, 0, 0 },
/* U+3929 */ { 0, 0, 0, 0, 0 },
/* U+392a */ { 0, 0, 0, 0, 0 },
/* U+392b */ { 0, 0, 0, 0, 0 },
/* U+392c */ { 0, 0, 0, 0, 0 },
/* U+392d */ { 0, 0, 0, 0, 0 },
/* U+392e */ { 0, 0, 0, 0, 0 },
/* U+392f */ { 0, 0, 0, 0, 0 },
/* U+3930 */ { 0, 0, 0, 0, 0 },
/* U+3931 */ { 0, 0, 0, 0, 0 },
/* U+3932 */ { 0, 0, 0, 0, 0 },
/* U+3933 */ { 0, 0, 0, 0, 0 },
/* U+3934 */ { 0, 0, 0, 0, 0 },
/* U+3935 */ { 0, 0, 0, 0, 0 },
/* U+3936 */ { 0, 0, 0, 0, 0 },
/* U+3937 */ { 0, 0, 0, 0, 0 },
/* U+3938 */ { 0, 0, 0, 0, 0 },
/* U+3939 */ { 0, 0, 0, 0, 0 },
/* U+393a */ { 0, 0, 0, 0, 0 },
/* U+393b */ { 0, 0, 0, 0, 0 },
/* U+393c */ { 0, 0, 0, 0, 0 },
/* U+393d */ { 0, 0, 0, 0, 0 },
/* U+393e */ { 0, 0, 0, 0, 0 },
/* U+393f */ { 0, 0, 0, 0, 0 },
/* U+3940 */ { 0, 0, 0, 0, 0 },
/* U+3941 */ { 0, 0, 0, 0, 0 },
/* U+3942 */ { 0, 0, 0, 0, 0 },
/* U+3943 */ { 0, 0, 0, 0, 0 },
/* U+3944 */ { 0, 0, 0, 0, 0 },
/* U+3945 */ { 0, 0, 0, 0, 0 },
/* U+3946 */ { 0, 0, 0, 0, 0 },
/* U+3947 */ { 0, 0, 0, 0, 0 },
/* U+3948 */ { 0, 0, 0, 0, 0 },
/* U+3949 */ { 0, 0, 0, 0, 0 },
/* U+394a */ { 0, 0, 0, 0, 0 },
/* U+394b */ { 0, 0, 0, 0, 0 },
/* U+394c */ { 0, 0, 0, 0, 0 },
/* U+394d */ { 0, 0, 0, 0, 0 },
/* U+394e */ { 0, 0, 0, 0, 0 },
/* U+394f */ { 0, 0, 0, 0, 0 },
/* U+3950 */ { 0, 0, 0, 0, 0 },
/* U+3951 */ { 0, 0, 0, 0, 0 },
/* U+3952 */ { 0, 0, 0, 0, 0 },
/* U+3953 */ { 0, 0, 0, 0, 0 },
/* U+3954 */ { 0, 0, 0, 0, 0 },
/* U+3955 */ { 0, 0, 0, 0, 0 },
/* U+3956 */ { 0, 0, 0, 0, 0 },
/* U+3957 */ { 0, 0, 0, 0, 0 },
/* U+3958 */ { 0, 0, 0, 0, 0 },
/* U+3959 */ { 0, 0, 0, 0, 0 },
/* U+395a */ { 0, 0, 0, 0, 0 },
/* U+395b */ { 0, 0, 0, 0, 0 },
/* U+395c */ { 0, 0, 0, 0, 0 },
/* U+395d */ { 0, 0, 0, 0, 0 },
/* U+395e */ { 0, 0, 0, 0, 0 },
/* U+395f */ { 0, 0, 0, 0, 0 },
/* U+3960 */ { 0, 0, 0, 0, 0 },
/* U+3961 */ { 0, 0, 0, 0, 0 },
/* U+3962 */ { 0, 0, 0, 0, 0 },
/* U+3963 */ { 0, 0, 0, 0, 0 },
/* U+3964 */ { 0, 0, 0, 0, 0 },
/* U+3965 */ { 0, 0, 0, 0, 0 },
/* U+3966 */ { 0, 0, 0, 0, 0 },
/* U+3967 */ { 0, 0, 0, 0, 0 },
/* U+3968 */ { 0, 0, 0, 0, 0 },
/* U+3969 */ { 0, 0, 0, 0, 0 },
/* U+396a */ { 0, 0, 0, 0, 0 },
/* U+396b */ { 0, 0, 0, 0, 0 },
/* U+396c */ { 0, 0, 0, 0, 0 },
/* U+396d */ { 0, 0, 0, 0, 0 },
/* U+396e */ { 0, 0, 0, 0, 0 },
/* U+396f */ { 0, 0, 0, 0, 0 },
/* U+3970 */ { 0, 0, 0, 0, 0 },
/* U+3971 */ { 0, 0, 0, 0, 0 },
/* U+3972 */ { 0, 0, 0, 0, 0 },
/* U+3973 */ { 0, 0, 0, 0, 0 },
/* U+3974 */ { 0, 0, 0, 0, 0 },
/* U+3975 */ { 0, 0, 0, 0, 0 },
/* U+3976 */ { 0, 0, 0, 0, 0 },
/* U+3977 */ { 0, 0, 0, 0, 0 },
/* U+3978 */ { 0, 0, 0, 0, 0 },
/* U+3979 */ { 0, 0, 0, 0, 0 },
/* U+397a */ { 0, 0, 0, 0, 0 },
/* U+397b */ { 0, 0, 0, 0, 0 },
/* U+397c */ { 0, 0, 0, 0, 0 },
/* U+397d */ { 0, 0, 0, 0, 0 },
/* U+397e */ { 0, 0, 0, 0, 0 },
/* U+397f */ { 0, 0, 0, 0, 0 },
/* U+3980 */ { 0, 0, 0, 0, 0 },
/* U+3981 */ { 0, 0, 0, 0, 0 },
/* U+3982 */ { 0, 0, 0, 0, 0 },
/* U+3983 */ { 0, 0, 0, 0, 0 },
/* U+3984 */ { 0, 0, 0, 0, 0 },
/* U+3985 */ { 0, 0, 0, 0, 0 },
/* U+3986 */ { 0, 0, 0, 0, 0 },
/* U+3987 */ { 0, 0, 0, 0, 0 },
/* U+3988 */ { 0, 0, 0, 0, 0 },
/* U+3989 */ { 0, 0, 0, 0, 0 },
/* U+398a */ { 0, 0, 0, 0, 0 },
/* U+398b */ { 0, 0, 0, 0, 0 },
/* U+398c */ { 0, 0, 0, 0, 0 },
/* U+398d */ { 0, 0, 0, 0, 0 },
/* U+398e */ { 0, 0, 0, 0, 0 },
/* U+398f */ { 0, 0, 0, 0, 0 },
/* U+3990 */ { 0, 0, 0, 0, 0 },
/* U+3991 */ { 0, 0, 0, 0, 0 },
/* U+3992 */ { 0, 0, 0, 0, 0 },
/* U+3993 */ { 0, 0, 0, 0, 0 },
/* U+3994 */ { 0, 0, 0, 0, 0 },
/* U+3995 */ { 0, 0, 0, 0, 0 },
/* U+3996 */ { 0, 0, 0, 0, 0 },
/* U+3997 */ { 0, 0, 0, 0, 0 },
/* U+3998 */ { 0, 0, 0, 0, 0 },
/* U+3999 */ { 0, 0, 0, 0, 0 },
/* U+399a */ { 0, 0, 0, 0, 0 },
/* U+399b */ { 0, 0, 0, 0, 0 },
/* U+399c */ { 0, 0, 0, 0, 0 },
/* U+399d */ { 0, 0, 0, 0, 0 },
/* U+399e */ { 0, 0, 0, 0, 0 },
/* U+399f */ { 0, 0, 0, 0, 0 },
/* U+39a0 */ { 0, 0, 0, 0, 0 },
/* U+39a1 */ { 0, 0, 0, 0, 0 },
/* U+39a2 */ { 0, 0, 0, 0, 0 },
/* U+39a3 */ { 0, 0, 0, 0, 0 },
/* U+39a4 */ { 0, 0, 0, 0, 0 },
/* U+39a5 */ { 0, 0, 0, 0, 0 },
/* U+39a6 */ { 0, 0, 0, 0, 0 },
/* U+39a7 */ { 0, 0, 0, 0, 0 },
/* U+39a8 */ { 0, 0, 0, 0, 0 },
/* U+39a9 */ { 0, 0, 0, 0, 0 },
/* U+39aa */ { 0, 0, 0, 0, 0 },
/* U+39ab */ { 0, 0, 0, 0, 0 },
/* U+39ac */ { 0, 0, 0, 0, 0 },
/* U+39ad */ { 0, 0, 0, 0, 0 },
/* U+39ae */ { 0, 0, 0, 0, 0 },
/* U+39af */ { 0, 0, 0, 0, 0 },
/* U+39b0 */ { 0, 0, 0, 0, 0 },
/* U+39b1 */ { 0, 0, 0, 0, 0 },
/* U+39b2 */ { 0, 0, 0, 0, 0 },
/* U+39b3 */ { 0, 0, 0, 0, 0 },
/* U+39b4 */ { 0, 0, 0, 0, 0 },
/* U+39b5 */ { 0, 0, 0, 0, 0 },
/* U+39b6 */ { 0, 0, 0, 0, 0 },
/* U+39b7 */ { 0, 0, 0, 0, 0 },
/* U+39b8 */ { 0, 0, 0, 0, 0 },
/* U+39b9 */ { 0, 0, 0, 0, 0 },
/* U+39ba */ { 0, 0, 0, 0, 0 },
/* U+39bb */ { 0, 0, 0, 0, 0 },
/* U+39bc */ { 0, 0, 0, 0, 0 },
/* U+39bd */ { 0, 0, 0, 0, 0 },
/* U+39be */ { 0, 0, 0, 0, 0 },
/* U+39bf */ { 0, 0, 0, 0, 0 },
/* U+39c0 */ { 0, 0, 0, 0, 0 },
/* U+39c1 */ { 0, 0, 0, 0, 0 },
/* U+39c2 */ { 0, 0, 0, 0, 0 },
/* U+39c3 */ { 0, 0, 0, 0, 0 },
/* U+39c4 */ { 0, 0, 0, 0, 0 },
/* U+39c5 */ { 0, 0, 0, 0, 0 },
/* U+39c6 */ { 0, 0, 0, 0, 0 },
/* U+39c7 */ { 0, 0, 0, 0, 0 },
/* U+39c8 */ { 0, 0, 0, 0, 0 },
/* U+39c9 */ { 0, 0, 0, 0, 0 },
/* U+39ca */ { 0, 0, 0, 0, 0 },
/* U+39cb */ { 0, 0, 0, 0, 0 },
/* U+39cc */ { 0, 0, 0, 0, 0 },
/* U+39cd */ { 0, 0, 0, 0, 0 },
/* U+39ce */ { 0, 0, 0, 0, 0 },
/* U+39cf */ { 0, 0, 0, 0, 0 },
/* U+39d0 */ { 0, 0, 0, 0, 0 },
/* U+39d1 */ { 0, 0, 0, 0, 0 },
/* U+39d2 */ { 0, 0, 0, 0, 0 },
/* U+39d3 */ { 0, 0, 0, 0, 0 },
/* U+39d4 */ { 0, 0, 0, 0, 0 },
/* U+39d5 */ { 0, 0, 0, 0, 0 },
/* U+39d6 */ { 0, 0, 0, 0, 0 },
/* U+39d7 */ { 0, 0, 0, 0, 0 },
/* U+39d8 */ { 0, 0, 0, 0, 0 },
/* U+39d9 */ { 0, 0, 0, 0, 0 },
/* U+39da */ { 0, 0, 0, 0, 0 },
/* U+39db */ { 0, 0, 0, 0, 0 },
/* U+39dc */ { 0, 0, 0, 0, 0 },
/* U+39dd */ { 0, 0, 0, 0, 0 },
/* U+39de */ { 0, 0, 0, 0, 0 },
/* U+39df */ { 0, 0, 0, 0, 0 },
/* U+39e0 */ { 0, 0, 0, 0, 0 },
/* U+39e1 */ { 0, 0, 0, 0, 0 },
/* U+39e2 */ { 0, 0, 0, 0, 0 },
/* U+39e3 */ { 0, 0, 0, 0, 0 },
/* U+39e4 */ { 0, 0, 0, 0, 0 },
/* U+39e5 */ { 0, 0, 0, 0, 0 },
/* U+39e6 */ { 0, 0, 0, 0, 0 },
/* U+39e7 */ { 0, 0, 0, 0, 0 },
/* U+39e8 */ { 0, 0, 0, 0, 0 },
/* U+39e9 */ { 0, 0, 0, 0, 0 },
/* U+39ea */ { 0, 0, 0, 0, 0 },
/* U+39eb */ { 0, 0, 0, 0, 0 },
/* U+39ec */ { 0, 0, 0, 0, 0 },
/* U+39ed */ { 0, 0, 0, 0, 0 },
/* U+39ee */ { 0, 0, 0, 0, 0 },
/* U+39ef */ { 0, 0, 0, 0, 0 },
/* U+39f0 */ { 0, 0, 0, 0, 0 },
/* U+39f1 */ { 0, 0, 0, 0, 0 },
/* U+39f2 */ { 0, 0, 0, 0, 0 },
/* U+39f3 */ { 0, 0, 0, 0, 0 },
/* U+39f4 */ { 0, 0, 0, 0, 0 },
/* U+39f5 */ { 0, 0, 0, 0, 0 },
/* U+39f6 */ { 0, 0, 0, 0, 0 },
/* U+39f7 */ { 0, 0, 0, 0, 0 },
/* U+39f8 */ { 0, 0, 0, 0, 0 },
/* U+39f9 */ { 0, 0, 0, 0, 0 },
/* U+39fa */ { 0, 0, 0, 0, 0 },
/* U+39fb */ { 0, 0, 0, 0, 0 },
/* U+39fc */ { 0, 0, 0, 0, 0 },
/* U+39fd */ { 0, 0, 0, 0, 0 },
/* U+39fe */ { 0, 0, 0, 0, 0 },
/* U+39ff */ { 0, 0, 0, 0, 0 },
/* U+3a00 */ { 0, 0, 0, 0, 0 },
/* U+3a01 */ { 0, 0, 0, 0, 0 },
/* U+3a02 */ { 0, 0, 0, 0, 0 },
/* U+3a03 */ { 0, 0, 0, 0, 0 },
/* U+3a04 */ { 0, 0, 0, 0, 0 },
/* U+3a05 */ { 0, 0, 0, 0, 0 },
/* U+3a06 */ { 0, 0, 0, 0, 0 },
/* U+3a07 */ { 0, 0, 0, 0, 0 },
/* U+3a08 */ { 0, 0, 0, 0, 0 },
/* U+3a09 */ { 0, 0, 0, 0, 0 },
/* U+3a0a */ { 0, 0, 0, 0, 0 },
/* U+3a0b */ { 0, 0, 0, 0, 0 },
/* U+3a0c */ { 0, 0, 0, 0, 0 },
/* U+3a0d */ { 0, 0, 0, 0, 0 },
/* U+3a0e */ { 0, 0, 0, 0, 0 },
/* U+3a0f */ { 0, 0, 0, 0, 0 },
/* U+3a10 */ { 0, 0, 0, 0, 0 },
/* U+3a11 */ { 0, 0, 0, 0, 0 },
/* U+3a12 */ { 0, 0, 0, 0, 0 },
/* U+3a13 */ { 0, 0, 0, 0, 0 },
/* U+3a14 */ { 0, 0, 0, 0, 0 },
/* U+3a15 */ { 0, 0, 0, 0, 0 },
/* U+3a16 */ { 0, 0, 0, 0, 0 },
/* U+3a17 */ { 0, 0, 0, 0, 0 },
/* U+3a18 */ { 0, 0, 0, 0, 0 },
/* U+3a19 */ { 0, 0, 0, 0, 0 },
/* U+3a1a */ { 0, 0, 0, 0, 0 },
/* U+3a1b */ { 0, 0, 0, 0, 0 },
/* U+3a1c */ { 0, 0, 0, 0, 0 },
/* U+3a1d */ { 0, 0, 0, 0, 0 },
/* U+3a1e */ { 0, 0, 0, 0, 0 },
/* U+3a1f */ { 0, 0, 0, 0, 0 },
/* U+3a20 */ { 0, 0, 0, 0, 0 },
/* U+3a21 */ { 0, 0, 0, 0, 0 },
/* U+3a22 */ { 0, 0, 0, 0, 0 },
/* U+3a23 */ { 0, 0, 0, 0, 0 },
/* U+3a24 */ { 0, 0, 0, 0, 0 },
/* U+3a25 */ { 0, 0, 0, 0, 0 },
/* U+3a26 */ { 0, 0, 0, 0, 0 },
/* U+3a27 */ { 0, 0, 0, 0, 0 },
/* U+3a28 */ { 0, 0, 0, 0, 0 },
/* U+3a29 */ { 0, 0, 0, 0, 0 },
/* U+3a2a */ { 0, 0, 0, 0, 0 },
/* U+3a2b */ { 0, 0, 0, 0, 0 },
/* U+3a2c */ { 0, 0, 0, 0, 0 },
/* U+3a2d */ { 0, 0, 0, 0, 0 },
/* U+3a2e */ { 0, 0, 0, 0, 0 },
/* U+3a2f */ { 0, 0, 0, 0, 0 },
/* U+3a30 */ { 0, 0, 0, 0, 0 },
/* U+3a31 */ { 0, 0, 0, 0, 0 },
/* U+3a32 */ { 0, 0, 0, 0, 0 },
/* U+3a33 */ { 0, 0, 0, 0, 0 },
/* U+3a34 */ { 0, 0, 0, 0, 0 },
/* U+3a35 */ { 0, 0, 0, 0, 0 },
/* U+3a36 */ { 0, 0, 0, 0, 0 },
/* U+3a37 */ { 0, 0, 0, 0, 0 },
/* U+3a38 */ { 0, 0, 0, 0, 0 },
/* U+3a39 */ { 0, 0, 0, 0, 0 },
/* U+3a3a */ { 0, 0, 0, 0, 0 },
/* U+3a3b */ { 0, 0, 0, 0, 0 },
/* U+3a3c */ { 0, 0, 0, 0, 0 },
/* U+3a3d */ { 0, 0, 0, 0, 0 },
/* U+3a3e */ { 0, 0, 0, 0, 0 },
/* U+3a3f */ { 0, 0, 0, 0, 0 },
/* U+3a40 */ { 0, 0, 0, 0, 0 },
/* U+3a41 */ { 0, 0, 0, 0, 0 },
/* U+3a42 */ { 0, 0, 0, 0, 0 },
/* U+3a43 */ { 0, 0, 0, 0, 0 },
/* U+3a44 */ { 0, 0, 0, 0, 0 },
/* U+3a45 */ { 0, 0, 0, 0, 0 },
/* U+3a46 */ { 0, 0, 0, 0, 0 },
/* U+3a47 */ { 0, 0, 0, 0, 0 },
/* U+3a48 */ { 0, 0, 0, 0, 0 },
/* U+3a49 */ { 0, 0, 0, 0, 0 },
/* U+3a4a */ { 0, 0, 0, 0, 0 },
/* U+3a4b */ { 0, 0, 0, 0, 0 },
/* U+3a4c */ { 0, 0, 0, 0, 0 },
/* U+3a4d */ { 0, 0, 0, 0, 0 },
/* U+3a4e */ { 0, 0, 0, 0, 0 },
/* U+3a4f */ { 0, 0, 0, 0, 0 },
/* U+3a50 */ { 0, 0, 0, 0, 0 },
/* U+3a51 */ { 0, 0, 0, 0, 0 },
/* U+3a52 */ { 0, 0, 0, 0, 0 },
/* U+3a53 */ { 0, 0, 0, 0, 0 },
/* U+3a54 */ { 0, 0, 0, 0, 0 },
/* U+3a55 */ { 0, 0, 0, 0, 0 },
/* U+3a56 */ { 0, 0, 0, 0, 0 },
/* U+3a57 */ { 0, 0, 0, 0, 0 },
/* U+3a58 */ { 0, 0, 0, 0, 0 },
/* U+3a59 */ { 0, 0, 0, 0, 0 },
/* U+3a5a */ { 0, 0, 0, 0, 0 },
/* U+3a5b */ { 0, 0, 0, 0, 0 },
/* U+3a5c */ { 0, 0, 0, 0, 0 },
/* U+3a5d */ { 0, 0, 0, 0, 0 },
/* U+3a5e */ { 0, 0, 0, 0, 0 },
/* U+3a5f */ { 0, 0, 0, 0, 0 },
/* U+3a60 */ { 0, 0, 0, 0, 0 },
/* U+3a61 */ { 0, 0, 0, 0, 0 },
/* U+3a62 */ { 0, 0, 0, 0, 0 },
/* U+3a63 */ { 0, 0, 0, 0, 0 },
/* U+3a64 */ { 0, 0, 0, 0, 0 },
/* U+3a65 */ { 0, 0, 0, 0, 0 },
/* U+3a66 */ { 0, 0, 0, 0, 0 },
/* U+3a67 */ { 0, 0, 0, 0, 0 },
/* U+3a68 */ { 0, 0, 0, 0, 0 },
/* U+3a69 */ { 0, 0, 0, 0, 0 },
/* U+3a6a */ { 0, 0, 0, 0, 0 },
/* U+3a6b */ { 0, 0, 0, 0, 0 },
/* U+3a6c */ { 0, 0, 0, 0, 0 },
/* U+3a6d */ { 0, 0, 0, 0, 0 },
/* U+3a6e */ { 0, 0, 0, 0, 0 },
/* U+3a6f */ { 0, 0, 0, 0, 0 },
/* U+3a70 */ { 0, 0, 0, 0, 0 },
/* U+3a71 */ { 0, 0, 0, 0, 0 },
/* U+3a72 */ { 0, 0, 0, 0, 0 },
/* U+3a73 */ { 0, 0, 0, 0, 0 },
/* U+3a74 */ { 0, 0, 0, 0, 0 },
/* U+3a75 */ { 0, 0, 0, 0, 0 },
/* U+3a76 */ { 0, 0, 0, 0, 0 },
/* U+3a77 */ { 0, 0, 0, 0, 0 },
/* U+3a78 */ { 0, 0, 0, 0, 0 },
/* U+3a79 */ { 0, 0, 0, 0, 0 },
/* U+3a7a */ { 0, 0, 0, 0, 0 },
/* U+3a7b */ { 0, 0, 0, 0, 0 },
/* U+3a7c */ { 0, 0, 0, 0, 0 },
/* U+3a7d */ { 0, 0, 0, 0, 0 },
/* U+3a7e */ { 0, 0, 0, 0, 0 },
/* U+3a7f */ { 0, 0, 0, 0, 0 },
/* U+3a80 */ { 0, 0, 0, 0, 0 },
/* U+3a81 */ { 0, 0, 0, 0, 0 },
/* U+3a82 */ { 0, 0, 0, 0, 0 },
/* U+3a83 */ { 0, 0, 0, 0, 0 },
/* U+3a84 */ { 0, 0, 0, 0, 0 },
/* U+3a85 */ { 0, 0, 0, 0, 0 },
/* U+3a86 */ { 0, 0, 0, 0, 0 },
/* U+3a87 */ { 0, 0, 0, 0, 0 },
/* U+3a88 */ { 0, 0, 0, 0, 0 },
/* U+3a89 */ { 0, 0, 0, 0, 0 },
/* U+3a8a */ { 0, 0, 0, 0, 0 },
/* U+3a8b */ { 0, 0, 0, 0, 0 },
/* U+3a8c */ { 0, 0, 0, 0, 0 },
/* U+3a8d */ { 0, 0, 0, 0, 0 },
/* U+3a8e */ { 0, 0, 0, 0, 0 },
/* U+3a8f */ { 0, 0, 0, 0, 0 },
/* U+3a90 */ { 0, 0, 0, 0, 0 },
/* U+3a91 */ { 0, 0, 0, 0, 0 },
/* U+3a92 */ { 0, 0, 0, 0, 0 },
/* U+3a93 */ { 0, 0, 0, 0, 0 },
/* U+3a94 */ { 0, 0, 0, 0, 0 },
/* U+3a95 */ { 0, 0, 0, 0, 0 },
/* U+3a96 */ { 0, 0, 0, 0, 0 },
/* U+3a97 */ { 0, 0, 0, 0, 0 },
/* U+3a98 */ { 0, 0, 0, 0, 0 },
/* U+3a99 */ { 0, 0, 0, 0, 0 },
/* U+3a9a */ { 0, 0, 0, 0, 0 },
/* U+3a9b */ { 0, 0, 0, 0, 0 },
/* U+3a9c */ { 0, 0, 0, 0, 0 },
/* U+3a9d */ { 0, 0, 0, 0, 0 },
/* U+3a9e */ { 0, 0, 0, 0, 0 },
/* U+3a9f */ { 0, 0, 0, 0, 0 },
/* U+3aa0 */ { 0, 0, 0, 0, 0 },
/* U+3aa1 */ { 0, 0, 0, 0, 0 },
/* U+3aa2 */ { 0, 0, 0, 0, 0 },
/* U+3aa3 */ { 0, 0, 0, 0, 0 },
/* U+3aa4 */ { 0, 0, 0, 0, 0 },
/* U+3aa5 */ { 0, 0, 0, 0, 0 },
/* U+3aa6 */ { 0, 0, 0, 0, 0 },
/* U+3aa7 */ { 0, 0, 0, 0, 0 },
/* U+3aa8 */ { 0, 0, 0, 0, 0 },
/* U+3aa9 */ { 0, 0, 0, 0, 0 },
/* U+3aaa */ { 0, 0, 0, 0, 0 },
/* U+3aab */ { 0, 0, 0, 0, 0 },
/* U+3aac */ { 0, 0, 0, 0, 0 },
/* U+3aad */ { 0, 0, 0, 0, 0 },
/* U+3aae */ { 0, 0, 0, 0, 0 },
/* U+3aaf */ { 0, 0, 0, 0, 0 },
/* U+3ab0 */ { 0, 0, 0, 0, 0 },
/* U+3ab1 */ { 0, 0, 0, 0, 0 },
/* U+3ab2 */ { 0, 0, 0, 0, 0 },
/* U+3ab3 */ { 0, 0, 0, 0, 0 },
/* U+3ab4 */ { 0, 0, 0, 0, 0 },
/* U+3ab5 */ { 0, 0, 0, 0, 0 },
/* U+3ab6 */ { 0, 0, 0, 0, 0 },
/* U+3ab7 */ { 0, 0, 0, 0, 0 },
/* U+3ab8 */ { 0, 0, 0, 0, 0 },
/* U+3ab9 */ { 0, 0, 0, 0, 0 },
/* U+3aba */ { 0, 0, 0, 0, 0 },
/* U+3abb */ { 0, 0, 0, 0, 0 },
/* U+3abc */ { 0, 0, 0, 0, 0 },
/* U+3abd */ { 0, 0, 0, 0, 0 },
/* U+3abe */ { 0, 0, 0, 0, 0 },
/* U+3abf */ { 0, 0, 0, 0, 0 },
/* U+3ac0 */ { 0, 0, 0, 0, 0 },
/* U+3ac1 */ { 0, 0, 0, 0, 0 },
/* U+3ac2 */ { 0, 0, 0, 0, 0 },
/* U+3ac3 */ { 0, 0, 0, 0, 0 },
/* U+3ac4 */ { 0, 0, 0, 0, 0 },
/* U+3ac5 */ { 0, 0, 0, 0, 0 },
/* U+3ac6 */ { 0, 0, 0, 0, 0 },
/* U+3ac7 */ { 0, 0, 0, 0, 0 },
/* U+3ac8 */ { 0, 0, 0, 0, 0 },
/* U+3ac9 */ { 0, 0, 0, 0, 0 },
/* U+3aca */ { 0, 0, 0, 0, 0 },
/* U+3acb */ { 0, 0, 0, 0, 0 },
/* U+3acc */ { 0, 0, 0, 0, 0 },
/* U+3acd */ { 0, 0, 0, 0, 0 },
/* U+3ace */ { 0, 0, 0, 0, 0 },
/* U+3acf */ { 0, 0, 0, 0, 0 },
/* U+3ad0 */ { 0, 0, 0, 0, 0 },
/* U+3ad1 */ { 0, 0, 0, 0, 0 },
/* U+3ad2 */ { 0, 0, 0, 0, 0 },
/* U+3ad3 */ { 0, 0, 0, 0, 0 },
/* U+3ad4 */ { 0, 0, 0, 0, 0 },
/* U+3ad5 */ { 0, 0, 0, 0, 0 },
/* U+3ad6 */ { 0, 0, 0, 0, 0 },
/* U+3ad7 */ { 0, 0, 0, 0, 0 },
/* U+3ad8 */ { 0, 0, 0, 0, 0 },
/* U+3ad9 */ { 0, 0, 0, 0, 0 },
/* U+3ada */ { 0, 0, 0, 0, 0 },
/* U+3adb */ { 0, 0, 0, 0, 0 },
/* U+3adc */ { 0, 0, 0, 0, 0 },
/* U+3add */ { 0, 0, 0, 0, 0 },
/* U+3ade */ { 0, 0, 0, 0, 0 },
/* U+3adf */ { 0, 0, 0, 0, 0 },
/* U+3ae0 */ { 0, 0, 0, 0, 0 },
/* U+3ae1 */ { 0, 0, 0, 0, 0 },
/* U+3ae2 */ { 0, 0, 0, 0, 0 },
/* U+3ae3 */ { 0, 0, 0, 0, 0 },
/* U+3ae4 */ { 0, 0, 0, 0, 0 },
/* U+3ae5 */ { 0, 0, 0, 0, 0 },
/* U+3ae6 */ { 0, 0, 0, 0, 0 },
/* U+3ae7 */ { 0, 0, 0, 0, 0 },
/* U+3ae8 */ { 0, 0, 0, 0, 0 },
/* U+3ae9 */ { 0, 0, 0, 0, 0 },
/* U+3aea */ { 0, 0, 0, 0, 0 },
/* U+3aeb */ { 0, 0, 0, 0, 0 },
/* U+3aec */ { 0, 0, 0, 0, 0 },
/* U+3aed */ { 0, 0, 0, 0, 0 },
/* U+3aee */ { 0, 0, 0, 0, 0 },
/* U+3aef */ { 0, 0, 0, 0, 0 },
/* U+3af0 */ { 0, 0, 0, 0, 0 },
/* U+3af1 */ { 0, 0, 0, 0, 0 },
/* U+3af2 */ { 0, 0, 0, 0, 0 },
/* U+3af3 */ { 0, 0, 0, 0, 0 },
/* U+3af4 */ { 0, 0, 0, 0, 0 },
/* U+3af5 */ { 0, 0, 0, 0, 0 },
/* U+3af6 */ { 0, 0, 0, 0, 0 },
/* U+3af7 */ { 0, 0, 0, 0, 0 },
/* U+3af8 */ { 0, 0, 0, 0, 0 },
/* U+3af9 */ { 0, 0, 0, 0, 0 },
/* U+3afa */ { 0, 0, 0, 0, 0 },
/* U+3afb */ { 0, 0, 0, 0, 0 },
/* U+3afc */ { 0, 0, 0, 0, 0 },
/* U+3afd */ { 0, 0, 0, 0, 0 },
/* U+3afe */ { 0, 0, 0, 0, 0 },
/* U+3aff */ { 0, 0, 0, 0, 0 },
/* U+3b00 */ { 0, 0, 0, 0, 0 },
/* U+3b01 */ { 0, 0, 0, 0, 0 },
/* U+3b02 */ { 0, 0, 0, 0, 0 },
/* U+3b03 */ { 0, 0, 0, 0, 0 },
/* U+3b04 */ { 0, 0, 0, 0, 0 },
/* U+3b05 */ { 0, 0, 0, 0, 0 },
/* U+3b06 */ { 0, 0, 0, 0, 0 },
/* U+3b07 */ { 0, 0, 0, 0, 0 },
/* U+3b08 */ { 0, 0, 0, 0, 0 },
/* U+3b09 */ { 0, 0, 0, 0, 0 },
/* U+3b0a */ { 0, 0, 0, 0, 0 },
/* U+3b0b */ { 0, 0, 0, 0, 0 },
/* U+3b0c */ { 0, 0, 0, 0, 0 },
/* U+3b0d */ { 0, 0, 0, 0, 0 },
/* U+3b0e */ { 0, 0, 0, 0, 0 },
/* U+3b0f */ { 0, 0, 0, 0, 0 },
/* U+3b10 */ { 0, 0, 0, 0, 0 },
/* U+3b11 */ { 0, 0, 0, 0, 0 },
/* U+3b12 */ { 0, 0, 0, 0, 0 },
/* U+3b13 */ { 0, 0, 0, 0, 0 },
/* U+3b14 */ { 0, 0, 0, 0, 0 },
/* U+3b15 */ { 0, 0, 0, 0, 0 },
/* U+3b16 */ { 0, 0, 0, 0, 0 },
/* U+3b17 */ { 0, 0, 0, 0, 0 },
/* U+3b18 */ { 0, 0, 0, 0, 0 },
/* U+3b19 */ { 0, 0, 0, 0, 0 },
/* U+3b1a */ { 0, 0, 0, 0, 0 },
/* U+3b1b */ { 0, 0, 0, 0, 0 },
/* U+3b1c */ { 0, 0, 0, 0, 0 },
/* U+3b1d */ { 0, 0, 0, 0, 0 },
/* U+3b1e */ { 0, 0, 0, 0, 0 },
/* U+3b1f */ { 0, 0, 0, 0, 0 },
/* U+3b20 */ { 0, 0, 0, 0, 0 },
/* U+3b21 */ { 0, 0, 0, 0, 0 },
/* U+3b22 */ { 0, 0, 0, 0, 0 },
/* U+3b23 */ { 0, 0, 0, 0, 0 },
/* U+3b24 */ { 0, 0, 0, 0, 0 },
/* U+3b25 */ { 0, 0, 0, 0, 0 },
/* U+3b26 */ { 0, 0, 0, 0, 0 },
/* U+3b27 */ { 0, 0, 0, 0, 0 },
/* U+3b28 */ { 0, 0, 0, 0, 0 },
/* U+3b29 */ { 0, 0, 0, 0, 0 },
/* U+3b2a */ { 0, 0, 0, 0, 0 },
/* U+3b2b */ { 0, 0, 0, 0, 0 },
/* U+3b2c */ { 0, 0, 0, 0, 0 },
/* U+3b2d */ { 0, 0, 0, 0, 0 },
/* U+3b2e */ { 0, 0, 0, 0, 0 },
/* U+3b2f */ { 0, 0, 0, 0, 0 },
/* U+3b30 */ { 0, 0, 0, 0, 0 },
/* U+3b31 */ { 0, 0, 0, 0, 0 },
/* U+3b32 */ { 0, 0, 0, 0, 0 },
/* U+3b33 */ { 0, 0, 0, 0, 0 },
/* U+3b34 */ { 0, 0, 0, 0, 0 },
/* U+3b35 */ { 0, 0, 0, 0, 0 },
/* U+3b36 */ { 0, 0, 0, 0, 0 },
/* U+3b37 */ { 0, 0, 0, 0, 0 },
/* U+3b38 */ { 0, 0, 0, 0, 0 },
/* U+3b39 */ { 0, 0, 0, 0, 0 },
/* U+3b3a */ { 0, 0, 0, 0, 0 },
/* U+3b3b */ { 0, 0, 0, 0, 0 },
/* U+3b3c */ { 0, 0, 0, 0, 0 },
/* U+3b3d */ { 0, 0, 0, 0, 0 },
/* U+3b3e */ { 0, 0, 0, 0, 0 },
/* U+3b3f */ { 0, 0, 0, 0, 0 },
/* U+3b40 */ { 0, 0, 0, 0, 0 },
/* U+3b41 */ { 0, 0, 0, 0, 0 },
/* U+3b42 */ { 0, 0, 0, 0, 0 },
/* U+3b43 */ { 0, 0, 0, 0, 0 },
/* U+3b44 */ { 0, 0, 0, 0, 0 },
/* U+3b45 */ { 0, 0, 0, 0, 0 },
/* U+3b46 */ { 0, 0, 0, 0, 0 },
/* U+3b47 */ { 0, 0, 0, 0, 0 },
/* U+3b48 */ { 0, 0, 0, 0, 0 },
/* U+3b49 */ { 0, 0, 0, 0, 0 },
/* U+3b4a */ { 0, 0, 0, 0, 0 },
/* U+3b4b */ { 0, 0, 0, 0, 0 },
/* U+3b4c */ { 0, 0, 0, 0, 0 },
/* U+3b4d */ { 0, 0, 0, 0, 0 },
/* U+3b4e */ { 0, 0, 0, 0, 0 },
/* U+3b4f */ { 0, 0, 0, 0, 0 },
/* U+3b50 */ { 0, 0, 0, 0, 0 },
/* U+3b51 */ { 0, 0, 0, 0, 0 },
/* U+3b52 */ { 0, 0, 0, 0, 0 },
/* U+3b53 */ { 0, 0, 0, 0, 0 },
/* U+3b54 */ { 0, 0, 0, 0, 0 },
/* U+3b55 */ { 0, 0, 0, 0, 0 },
/* U+3b56 */ { 0, 0, 0, 0, 0 },
/* U+3b57 */ { 0, 0, 0, 0, 0 },
/* U+3b58 */ { 0, 0, 0, 0, 0 },
/* U+3b59 */ { 0, 0, 0, 0, 0 },
/* U+3b5a */ { 0, 0, 0, 0, 0 },
/* U+3b5b */ { 0, 0, 0, 0, 0 },
/* U+3b5c */ { 0, 0, 0, 0, 0 },
/* U+3b5d */ { 0, 0, 0, 0, 0 },
/* U+3b5e */ { 0, 0, 0, 0, 0 },
/* U+3b5f */ { 0, 0, 0, 0, 0 },
/* U+3b60 */ { 0, 0, 0, 0, 0 },
/* U+3b61 */ { 0, 0, 0, 0, 0 },
/* U+3b62 */ { 0, 0, 0, 0, 0 },
/* U+3b63 */ { 0, 0, 0, 0, 0 },
/* U+3b64 */ { 0, 0, 0, 0, 0 },
/* U+3b65 */ { 0, 0, 0, 0, 0 },
/* U+3b66 */ { 0, 0, 0, 0, 0 },
/* U+3b67 */ { 0, 0, 0, 0, 0 },
/* U+3b68 */ { 0, 0, 0, 0, 0 },
/* U+3b69 */ { 0, 0, 0, 0, 0 },
/* U+3b6a */ { 0, 0, 0, 0, 0 },
/* U+3b6b */ { 0, 0, 0, 0, 0 },
/* U+3b6c */ { 0, 0, 0, 0, 0 },
/* U+3b6d */ { 0, 0, 0, 0, 0 },
/* U+3b6e */ { 0, 0, 0, 0, 0 },
/* U+3b6f */ { 0, 0, 0, 0, 0 },
/* U+3b70 */ { 0, 0, 0, 0, 0 },
/* U+3b71 */ { 0, 0, 0, 0, 0 },
/* U+3b72 */ { 0, 0, 0, 0, 0 },
/* U+3b73 */ { 0, 0, 0, 0, 0 },
/* U+3b74 */ { 0, 0, 0, 0, 0 },
/* U+3b75 */ { 0, 0, 0, 0, 0 },
/* U+3b76 */ { 0, 0, 0, 0, 0 },
/* U+3b77 */ { 0, 0, 0, 0, 0 },
/* U+3b78 */ { 0, 0, 0, 0, 0 },
/* U+3b79 */ { 0, 0, 0, 0, 0 },
/* U+3b7a */ { 0, 0, 0, 0, 0 },
/* U+3b7b */ { 0, 0, 0, 0, 0 },
/* U+3b7c */ { 0, 0, 0, 0, 0 },
/* U+3b7d */ { 0, 0, 0, 0, 0 },
/* U+3b7e */ { 0, 0, 0, 0, 0 },
/* U+3b7f */ { 0, 0, 0, 0, 0 },
/* U+3b80 */ { 0, 0, 0, 0, 0 },
/* U+3b81 */ { 0, 0, 0, 0, 0 },
/* U+3b82 */ { 0, 0, 0, 0, 0 },
/* U+3b83 */ { 0, 0, 0, 0, 0 },
/* U+3b84 */ { 0, 0, 0, 0, 0 },
/* U+3b85 */ { 0, 0, 0, 0, 0 },
/* U+3b86 */ { 0, 0, 0, 0, 0 },
/* U+3b87 */ { 0, 0, 0, 0, 0 },
/* U+3b88 */ { 0, 0, 0, 0, 0 },
/* U+3b89 */ { 0, 0, 0, 0, 0 },
/* U+3b8a */ { 0, 0, 0, 0, 0 },
/* U+3b8b */ { 0, 0, 0, 0, 0 },
/* U+3b8c */ { 0, 0, 0, 0, 0 },
/* U+3b8d */ { 0, 0, 0, 0, 0 },
/* U+3b8e */ { 0, 0, 0, 0, 0 },
/* U+3b8f */ { 0, 0, 0, 0, 0 },
/* U+3b90 */ { 0, 0, 0, 0, 0 },
/* U+3b91 */ { 0, 0, 0, 0, 0 },
/* U+3b92 */ { 0, 0, 0, 0, 0 },
/* U+3b93 */ { 0, 0, 0, 0, 0 },
/* U+3b94 */ { 0, 0, 0, 0, 0 },
/* U+3b95 */ { 0, 0, 0, 0, 0 },
/* U+3b96 */ { 0, 0, 0, 0, 0 },
/* U+3b97 */ { 0, 0, 0, 0, 0 },
/* U+3b98 */ { 0, 0, 0, 0, 0 },
/* U+3b99 */ { 0, 0, 0, 0, 0 },
/* U+3b9a */ { 0, 0, 0, 0, 0 },
/* U+3b9b */ { 0, 0, 0, 0, 0 },
/* U+3b9c */ { 0, 0, 0, 0, 0 },
/* U+3b9d */ { 0, 0, 0, 0, 0 },
/* U+3b9e */ { 0, 0, 0, 0, 0 },
/* U+3b9f */ { 0, 0, 0, 0, 0 },
/* U+3ba0 */ { 0, 0, 0, 0, 0 },
/* U+3ba1 */ { 0, 0, 0, 0, 0 },
/* U+3ba2 */ { 0, 0, 0, 0, 0 },
/* U+3ba3 */ { 0, 0, 0, 0, 0 },
/* U+3ba4 */ { 0, 0, 0, 0, 0 },
/* U+3ba5 */ { 0, 0, 0, 0, 0 },
/* U+3ba6 */ { 0, 0, 0, 0, 0 },
/* U+3ba7 */ { 0, 0, 0, 0, 0 },
/* U+3ba8 */ { 0, 0, 0, 0, 0 },
/* U+3ba9 */ { 0, 0, 0, 0, 0 },
/* U+3baa */ { 0, 0, 0, 0, 0 },
/* U+3bab */ { 0, 0, 0, 0, 0 },
/* U+3bac */ { 0, 0, 0, 0, 0 },
/* U+3bad */ { 0, 0, 0, 0, 0 },
/* U+3bae */ { 0, 0, 0, 0, 0 },
/* U+3baf */ { 0, 0, 0, 0, 0 },
/* U+3bb0 */ { 0, 0, 0, 0, 0 },
/* U+3bb1 */ { 0, 0, 0, 0, 0 },
/* U+3bb2 */ { 0, 0, 0, 0, 0 },
/* U+3bb3 */ { 0, 0, 0, 0, 0 },
/* U+3bb4 */ { 0, 0, 0, 0, 0 },
/* U+3bb5 */ { 0, 0, 0, 0, 0 },
/* U+3bb6 */ { 0, 0, 0, 0, 0 },
/* U+3bb7 */ { 0, 0, 0, 0, 0 },
/* U+3bb8 */ { 0, 0, 0, 0, 0 },
/* U+3bb9 */ { 0, 0, 0, 0, 0 },
/* U+3bba */ { 0, 0, 0, 0, 0 },
/* U+3bbb */ { 0, 0, 0, 0, 0 },
/* U+3bbc */ { 0, 0, 0, 0, 0 },
/* U+3bbd */ { 0, 0, 0, 0, 0 },
/* U+3bbe */ { 0, 0, 0, 0, 0 },
/* U+3bbf */ { 0, 0, 0, 0, 0 },
/* U+3bc0 */ { 0, 0, 0, 0, 0 },
/* U+3bc1 */ { 0, 0, 0, 0, 0 },
/* U+3bc2 */ { 0, 0, 0, 0, 0 },
/* U+3bc3 */ { 0, 0, 0, 0, 0 },
/* U+3bc4 */ { 0, 0, 0, 0, 0 },
/* U+3bc5 */ { 0, 0, 0, 0, 0 },
/* U+3bc6 */ { 0, 0, 0, 0, 0 },
/* U+3bc7 */ { 0, 0, 0, 0, 0 },
/* U+3bc8 */ { 0, 0, 0, 0, 0 },
/* U+3bc9 */ { 0, 0, 0, 0, 0 },
/* U+3bca */ { 0, 0, 0, 0, 0 },
/* U+3bcb */ { 0, 0, 0, 0, 0 },
/* U+3bcc */ { 0, 0, 0, 0, 0 },
/* U+3bcd */ { 0, 0, 0, 0, 0 },
/* U+3bce */ { 0, 0, 0, 0, 0 },
/* U+3bcf */ { 0, 0, 0, 0, 0 },
/* U+3bd0 */ { 0, 0, 0, 0, 0 },
/* U+3bd1 */ { 0, 0, 0, 0, 0 },
/* U+3bd2 */ { 0, 0, 0, 0, 0 },
/* U+3bd3 */ { 0, 0, 0, 0, 0 },
/* U+3bd4 */ { 0, 0, 0, 0, 0 },
/* U+3bd5 */ { 0, 0, 0, 0, 0 },
/* U+3bd6 */ { 0, 0, 0, 0, 0 },
/* U+3bd7 */ { 0, 0, 0, 0, 0 },
/* U+3bd8 */ { 0, 0, 0, 0, 0 },
/* U+3bd9 */ { 0, 0, 0, 0, 0 },
/* U+3bda */ { 0, 0, 0, 0, 0 },
/* U+3bdb */ { 0, 0, 0, 0, 0 },
/* U+3bdc */ { 0, 0, 0, 0, 0 },
/* U+3bdd */ { 0, 0, 0, 0, 0 },
/* U+3bde */ { 0, 0, 0, 0, 0 },
/* U+3bdf */ { 0, 0, 0, 0, 0 },
/* U+3be0 */ { 0, 0, 0, 0, 0 },
/* U+3be1 */ { 0, 0, 0, 0, 0 },
/* U+3be2 */ { 0, 0, 0, 0, 0 },
/* U+3be3 */ { 0, 0, 0, 0, 0 },
/* U+3be4 */ { 0, 0, 0, 0, 0 },
/* U+3be5 */ { 0, 0, 0, 0, 0 },
/* U+3be6 */ { 0, 0, 0, 0, 0 },
/* U+3be7 */ { 0, 0, 0, 0, 0 },
/* U+3be8 */ { 0, 0, 0, 0, 0 },
/* U+3be9 */ { 0, 0, 0, 0, 0 },
/* U+3bea */ { 0, 0, 0, 0, 0 },
/* U+3beb */ { 0, 0, 0, 0, 0 },
/* U+3bec */ { 0, 0, 0, 0, 0 },
/* U+3bed */ { 0, 0, 0, 0, 0 },
/* U+3bee */ { 0, 0, 0, 0, 0 },
/* U+3bef */ { 0, 0, 0, 0, 0 },
/* U+3bf0 */ { 0, 0, 0, 0, 0 },
/* U+3bf1 */ { 0, 0, 0, 0, 0 },
/* U+3bf2 */ { 0, 0, 0, 0, 0 },
/* U+3bf3 */ { 0, 0, 0, 0, 0 },
/* U+3bf4 */ { 0, 0, 0, 0, 0 },
/* U+3bf5 */ { 0, 0, 0, 0, 0 },
/* U+3bf6 */ { 0, 0, 0, 0, 0 },
/* U+3bf7 */ { 0, 0, 0, 0, 0 },
/* U+3bf8 */ { 0, 0, 0, 0, 0 },
/* U+3bf9 */ { 0, 0, 0, 0, 0 },
/* U+3bfa */ { 0, 0, 0, 0, 0 },
/* U+3bfb */ { 0, 0, 0, 0, 0 },
/* U+3bfc */ { 0, 0, 0, 0, 0 },
/* U+3bfd */ { 0, 0, 0, 0, 0 },
/* U+3bfe */ { 0, 0, 0, 0, 0 },
/* U+3bff */ { 0, 0, 0, 0, 0 },
/* U+3c00 */ { 0, 0, 0, 0, 0 },
/* U+3c01 */ { 0, 0, 0, 0, 0 },
/* U+3c02 */ { 0, 0, 0, 0, 0 },
/* U+3c03 */ { 0, 0, 0, 0, 0 },
/* U+3c04 */ { 0, 0, 0, 0, 0 },
/* U+3c05 */ { 0, 0, 0, 0, 0 },
/* U+3c06 */ { 0, 0, 0, 0, 0 },
/* U+3c07 */ { 0, 0, 0, 0, 0 },
/* U+3c08 */ { 0, 0, 0, 0, 0 },
/* U+3c09 */ { 0, 0, 0, 0, 0 },
/* U+3c0a */ { 0, 0, 0, 0, 0 },
/* U+3c0b */ { 0, 0, 0, 0, 0 },
/* U+3c0c */ { 0, 0, 0, 0, 0 },
/* U+3c0d */ { 0, 0, 0, 0, 0 },
/* U+3c0e */ { 0, 0, 0, 0, 0 },
/* U+3c0f */ { 0, 0, 0, 0, 0 },
/* U+3c10 */ { 0, 0, 0, 0, 0 },
/* U+3c11 */ { 0, 0, 0, 0, 0 },
/* U+3c12 */ { 0, 0, 0, 0, 0 },
/* U+3c13 */ { 0, 0, 0, 0, 0 },
/* U+3c14 */ { 0, 0, 0, 0, 0 },
/* U+3c15 */ { 0, 0, 0, 0, 0 },
/* U+3c16 */ { 0, 0, 0, 0, 0 },
/* U+3c17 */ { 0, 0, 0, 0, 0 },
/* U+3c18 */ { 0, 0, 0, 0, 0 },
/* U+3c19 */ { 0, 0, 0, 0, 0 },
/* U+3c1a */ { 0, 0, 0, 0, 0 },
/* U+3c1b */ { 0, 0, 0, 0, 0 },
/* U+3c1c */ { 0, 0, 0, 0, 0 },
/* U+3c1d */ { 0, 0, 0, 0, 0 },
/* U+3c1e */ { 0, 0, 0, 0, 0 },
/* U+3c1f */ { 0, 0, 0, 0, 0 },
/* U+3c20 */ { 0, 0, 0, 0, 0 },
/* U+3c21 */ { 0, 0, 0, 0, 0 },
/* U+3c22 */ { 0, 0, 0, 0, 0 },
/* U+3c23 */ { 0, 0, 0, 0, 0 },
/* U+3c24 */ { 0, 0, 0, 0, 0 },
/* U+3c25 */ { 0, 0, 0, 0, 0 },
/* U+3c26 */ { 0, 0, 0, 0, 0 },
/* U+3c27 */ { 0, 0, 0, 0, 0 },
/* U+3c28 */ { 0, 0, 0, 0, 0 },
/* U+3c29 */ { 0, 0, 0, 0, 0 },
/* U+3c2a */ { 0, 0, 0, 0, 0 },
/* U+3c2b */ { 0, 0, 0, 0, 0 },
/* U+3c2c */ { 0, 0, 0, 0, 0 },
/* U+3c2d */ { 0, 0, 0, 0, 0 },
/* U+3c2e */ { 0, 0, 0, 0, 0 },
/* U+3c2f */ { 0, 0, 0, 0, 0 },
/* U+3c30 */ { 0, 0, 0, 0, 0 },
/* U+3c31 */ { 0, 0, 0, 0, 0 },
/* U+3c32 */ { 0, 0, 0, 0, 0 },
/* U+3c33 */ { 0, 0, 0, 0, 0 },
/* U+3c34 */ { 0, 0, 0, 0, 0 },
/* U+3c35 */ { 0, 0, 0, 0, 0 },
/* U+3c36 */ { 0, 0, 0, 0, 0 },
/* U+3c37 */ { 0, 0, 0, 0, 0 },
/* U+3c38 */ { 0, 0, 0, 0, 0 },
/* U+3c39 */ { 0, 0, 0, 0, 0 },
/* U+3c3a */ { 0, 0, 0, 0, 0 },
/* U+3c3b */ { 0, 0, 0, 0, 0 },
/* U+3c3c */ { 0, 0, 0, 0, 0 },
/* U+3c3d */ { 0, 0, 0, 0, 0 },
/* U+3c3e */ { 0, 0, 0, 0, 0 },
/* U+3c3f */ { 0, 0, 0, 0, 0 },
/* U+3c40 */ { 0, 0, 0, 0, 0 },
/* U+3c41 */ { 0, 0, 0, 0, 0 },
/* U+3c42 */ { 0, 0, 0, 0, 0 },
/* U+3c43 */ { 0, 0, 0, 0, 0 },
/* U+3c44 */ { 0, 0, 0, 0, 0 },
/* U+3c45 */ { 0, 0, 0, 0, 0 },
/* U+3c46 */ { 0, 0, 0, 0, 0 },
/* U+3c47 */ { 0, 0, 0, 0, 0 },
/* U+3c48 */ { 0, 0, 0, 0, 0 },
/* U+3c49 */ { 0, 0, 0, 0, 0 },
/* U+3c4a */ { 0, 0, 0, 0, 0 },
/* U+3c4b */ { 0, 0, 0, 0, 0 },
/* U+3c4c */ { 0, 0, 0, 0, 0 },
/* U+3c4d */ { 0, 0, 0, 0, 0 },
/* U+3c4e */ { 0, 0, 0, 0, 0 },
/* U+3c4f */ { 0, 0, 0, 0, 0 },
/* U+3c50 */ { 0, 0, 0, 0, 0 },
/* U+3c51 */ { 0, 0, 0, 0, 0 },
/* U+3c52 */ { 0, 0, 0, 0, 0 },
/* U+3c53 */ { 0, 0, 0, 0, 0 },
/* U+3c54 */ { 0, 0, 0, 0, 0 },
/* U+3c55 */ { 0, 0, 0, 0, 0 },
/* U+3c56 */ { 0, 0, 0, 0, 0 },
/* U+3c57 */ { 0, 0, 0, 0, 0 },
/* U+3c58 */ { 0, 0, 0, 0, 0 },
/* U+3c59 */ { 0, 0, 0, 0, 0 },
/* U+3c5a */ { 0, 0, 0, 0, 0 },
/* U+3c5b */ { 0, 0, 0, 0, 0 },
/* U+3c5c */ { 0, 0, 0, 0, 0 },
/* U+3c5d */ { 0, 0, 0, 0, 0 },
/* U+3c5e */ { 0, 0, 0, 0, 0 },
/* U+3c5f */ { 0, 0, 0, 0, 0 },
/* U+3c60 */ { 0, 0, 0, 0, 0 },
/* U+3c61 */ { 0, 0, 0, 0, 0 },
/* U+3c62 */ { 0, 0, 0, 0, 0 },
/* U+3c63 */ { 0, 0, 0, 0, 0 },
/* U+3c64 */ { 0, 0, 0, 0, 0 },
/* U+3c65 */ { 0, 0, 0, 0, 0 },
/* U+3c66 */ { 0, 0, 0, 0, 0 },
/* U+3c67 */ { 0, 0, 0, 0, 0 },
/* U+3c68 */ { 0, 0, 0, 0, 0 },
/* U+3c69 */ { 0, 0, 0, 0, 0 },
/* U+3c6a */ { 0, 0, 0, 0, 0 },
/* U+3c6b */ { 0, 0, 0, 0, 0 },
/* U+3c6c */ { 0, 0, 0, 0, 0 },
/* U+3c6d */ { 0, 0, 0, 0, 0 },
/* U+3c6e */ { 0, 0, 0, 0, 0 },
/* U+3c6f */ { 0, 0, 0, 0, 0 },
/* U+3c70 */ { 0, 0, 0, 0, 0 },
/* U+3c71 */ { 0, 0, 0, 0, 0 },
/* U+3c72 */ { 0, 0, 0, 0, 0 },
/* U+3c73 */ { 0, 0, 0, 0, 0 },
/* U+3c74 */ { 0, 0, 0, 0, 0 },
/* U+3c75 */ { 0, 0, 0, 0, 0 },
/* U+3c76 */ { 0, 0, 0, 0, 0 },
/* U+3c77 */ { 0, 0, 0, 0, 0 },
/* U+3c78 */ { 0, 0, 0, 0, 0 },
/* U+3c79 */ { 0, 0, 0, 0, 0 },
/* U+3c7a */ { 0, 0, 0, 0, 0 },
/* U+3c7b */ { 0, 0, 0, 0, 0 },
/* U+3c7c */ { 0, 0, 0, 0, 0 },
/* U+3c7d */ { 0, 0, 0, 0, 0 },
/* U+3c7e */ { 0, 0, 0, 0, 0 },
/* U+3c7f */ { 0, 0, 0, 0, 0 },
/* U+3c80 */ { 0, 0, 0, 0, 0 },
/* U+3c81 */ { 0, 0, 0, 0, 0 },
/* U+3c82 */ { 0, 0, 0, 0, 0 },
/* U+3c83 */ { 0, 0, 0, 0, 0 },
/* U+3c84 */ { 0, 0, 0, 0, 0 },
/* U+3c85 */ { 0, 0, 0, 0, 0 },
/* U+3c86 */ { 0, 0, 0, 0, 0 },
/* U+3c87 */ { 0, 0, 0, 0, 0 },
/* U+3c88 */ { 0, 0, 0, 0, 0 },
/* U+3c89 */ { 0, 0, 0, 0, 0 },
/* U+3c8a */ { 0, 0, 0, 0, 0 },
/* U+3c8b */ { 0, 0, 0, 0, 0 },
/* U+3c8c */ { 0, 0, 0, 0, 0 },
/* U+3c8d */ { 0, 0, 0, 0, 0 },
/* U+3c8e */ { 0, 0, 0, 0, 0 },
/* U+3c8f */ { 0, 0, 0, 0, 0 },
/* U+3c90 */ { 0, 0, 0, 0, 0 },
/* U+3c91 */ { 0, 0, 0, 0, 0 },
/* U+3c92 */ { 0, 0, 0, 0, 0 },
/* U+3c93 */ { 0, 0, 0, 0, 0 },
/* U+3c94 */ { 0, 0, 0, 0, 0 },
/* U+3c95 */ { 0, 0, 0, 0, 0 },
/* U+3c96 */ { 0, 0, 0, 0, 0 },
/* U+3c97 */ { 0, 0, 0, 0, 0 },
/* U+3c98 */ { 0, 0, 0, 0, 0 },
/* U+3c99 */ { 0, 0, 0, 0, 0 },
/* U+3c9a */ { 0, 0, 0, 0, 0 },
/* U+3c9b */ { 0, 0, 0, 0, 0 },
/* U+3c9c */ { 0, 0, 0, 0, 0 },
/* U+3c9d */ { 0, 0, 0, 0, 0 },
/* U+3c9e */ { 0, 0, 0, 0, 0 },
/* U+3c9f */ { 0, 0, 0, 0, 0 },
/* U+3ca0 */ { 0, 0, 0, 0, 0 },
/* U+3ca1 */ { 0, 0, 0, 0, 0 },
/* U+3ca2 */ { 0, 0, 0, 0, 0 },
/* U+3ca3 */ { 0, 0, 0, 0, 0 },
/* U+3ca4 */ { 0, 0, 0, 0, 0 },
/* U+3ca5 */ { 0, 0, 0, 0, 0 },
/* U+3ca6 */ { 0, 0, 0, 0, 0 },
/* U+3ca7 */ { 0, 0, 0, 0, 0 },
/* U+3ca8 */ { 0, 0, 0, 0, 0 },
/* U+3ca9 */ { 0, 0, 0, 0, 0 },
/* U+3caa */ { 0, 0, 0, 0, 0 },
/* U+3cab */ { 0, 0, 0, 0, 0 },
/* U+3cac */ { 0, 0, 0, 0, 0 },
/* U+3cad */ { 0, 0, 0, 0, 0 },
/* U+3cae */ { 0, 0, 0, 0, 0 },
/* U+3caf */ { 0, 0, 0, 0, 0 },
/* U+3cb0 */ { 0, 0, 0, 0, 0 },
/* U+3cb1 */ { 0, 0, 0, 0, 0 },
/* U+3cb2 */ { 0, 0, 0, 0, 0 },
/* U+3cb3 */ { 0, 0, 0, 0, 0 },
/* U+3cb4 */ { 0, 0, 0, 0, 0 },
/* U+3cb5 */ { 0, 0, 0, 0, 0 },
/* U+3cb6 */ { 0, 0, 0, 0, 0 },
/* U+3cb7 */ { 0, 0, 0, 0, 0 },
/* U+3cb8 */ { 0, 0, 0, 0, 0 },
/* U+3cb9 */ { 0, 0, 0, 0, 0 },
/* U+3cba */ { 0, 0, 0, 0, 0 },
/* U+3cbb */ { 0, 0, 0, 0, 0 },
/* U+3cbc */ { 0, 0, 0, 0, 0 },
/* U+3cbd */ { 0, 0, 0, 0, 0 },
/* U+3cbe */ { 0, 0, 0, 0, 0 },
/* U+3cbf */ { 0, 0, 0, 0, 0 },
/* U+3cc0 */ { 0, 0, 0, 0, 0 },
/* U+3cc1 */ { 0, 0, 0, 0, 0 },
/* U+3cc2 */ { 0, 0, 0, 0, 0 },
/* U+3cc3 */ { 0, 0, 0, 0, 0 },
/* U+3cc4 */ { 0, 0, 0, 0, 0 },
/* U+3cc5 */ { 0, 0, 0, 0, 0 },
/* U+3cc6 */ { 0, 0, 0, 0, 0 },
/* U+3cc7 */ { 0, 0, 0, 0, 0 },
/* U+3cc8 */ { 0, 0, 0, 0, 0 },
/* U+3cc9 */ { 0, 0, 0, 0, 0 },
/* U+3cca */ { 0, 0, 0, 0, 0 },
/* U+3ccb */ { 0, 0, 0, 0, 0 },
/* U+3ccc */ { 0, 0, 0, 0, 0 },
/* U+3ccd */ { 0, 0, 0, 0, 0 },
/* U+3cce */ { 0, 0, 0, 0, 0 },
/* U+3ccf */ { 0, 0, 0, 0, 0 },
/* U+3cd0 */ { 0, 0, 0, 0, 0 },
/* U+3cd1 */ { 0, 0, 0, 0, 0 },
/* U+3cd2 */ { 0, 0, 0, 0, 0 },
/* U+3cd3 */ { 0, 0, 0, 0, 0 },
/* U+3cd4 */ { 0, 0, 0, 0, 0 },
/* U+3cd5 */ { 0, 0, 0, 0, 0 },
/* U+3cd6 */ { 0, 0, 0, 0, 0 },
/* U+3cd7 */ { 0, 0, 0, 0, 0 },
/* U+3cd8 */ { 0, 0, 0, 0, 0 },
/* U+3cd9 */ { 0, 0, 0, 0, 0 },
/* U+3cda */ { 0, 0, 0, 0, 0 },
/* U+3cdb */ { 0, 0, 0, 0, 0 },
/* U+3cdc */ { 0, 0, 0, 0, 0 },
/* U+3cdd */ { 0, 0, 0, 0, 0 },
/* U+3cde */ { 0, 0, 0, 0, 0 },
/* U+3cdf */ { 0, 0, 0, 0, 0 },
/* U+3ce0 */ { 0, 0, 0, 0, 0 },
/* U+3ce1 */ { 0, 0, 0, 0, 0 },
/* U+3ce2 */ { 0, 0, 0, 0, 0 },
/* U+3ce3 */ { 0, 0, 0, 0, 0 },
/* U+3ce4 */ { 0, 0, 0, 0, 0 },
/* U+3ce5 */ { 0, 0, 0, 0, 0 },
/* U+3ce6 */ { 0, 0, 0, 0, 0 },
/* U+3ce7 */ { 0, 0, 0, 0, 0 },
/* U+3ce8 */ { 0, 0, 0, 0, 0 },
/* U+3ce9 */ { 0, 0, 0, 0, 0 },
/* U+3cea */ { 0, 0, 0, 0, 0 },
/* U+3ceb */ { 0, 0, 0, 0, 0 },
/* U+3cec */ { 0, 0, 0, 0, 0 },
/* U+3ced */ { 0, 0, 0, 0, 0 },
/* U+3cee */ { 0, 0, 0, 0, 0 },
/* U+3cef */ { 0, 0, 0, 0, 0 },
/* U+3cf0 */ { 0, 0, 0, 0, 0 },
/* U+3cf1 */ { 0, 0, 0, 0, 0 },
/* U+3cf2 */ { 0, 0, 0, 0, 0 },
/* U+3cf3 */ { 0, 0, 0, 0, 0 },
/* U+3cf4 */ { 0, 0, 0, 0, 0 },
/* U+3cf5 */ { 0, 0, 0, 0, 0 },
/* U+3cf6 */ { 0, 0, 0, 0, 0 },
/* U+3cf7 */ { 0, 0, 0, 0, 0 },
/* U+3cf8 */ { 0, 0, 0, 0, 0 },
/* U+3cf9 */ { 0, 0, 0, 0, 0 },
/* U+3cfa */ { 0, 0, 0, 0, 0 },
/* U+3cfb */ { 0, 0, 0, 0, 0 },
/* U+3cfc */ { 0, 0, 0, 0, 0 },
/* U+3cfd */ { 0, 0, 0, 0, 0 },
/* U+3cfe */ { 0, 0, 0, 0, 0 },
/* U+3cff */ { 0, 0, 0, 0, 0 },
/* U+3d00 */ { 0, 0, 0, 0, 0 },
/* U+3d01 */ { 0, 0, 0, 0, 0 },
/* U+3d02 */ { 0, 0, 0, 0, 0 },
/* U+3d03 */ { 0, 0, 0, 0, 0 },
/* U+3d04 */ { 0, 0, 0, 0, 0 },
/* U+3d05 */ { 0, 0, 0, 0, 0 },
/* U+3d06 */ { 0, 0, 0, 0, 0 },
/* U+3d07 */ { 0, 0, 0, 0, 0 },
/* U+3d08 */ { 0, 0, 0, 0, 0 },
/* U+3d09 */ { 0, 0, 0, 0, 0 },
/* U+3d0a */ { 0, 0, 0, 0, 0 },
/* U+3d0b */ { 0, 0, 0, 0, 0 },
/* U+3d0c */ { 0, 0, 0, 0, 0 },
/* U+3d0d */ { 0, 0, 0, 0, 0 },
/* U+3d0e */ { 0, 0, 0, 0, 0 },
/* U+3d0f */ { 0, 0, 0, 0, 0 },
/* U+3d10 */ { 0, 0, 0, 0, 0 },
/* U+3d11 */ { 0, 0, 0, 0, 0 },
/* U+3d12 */ { 0, 0, 0, 0, 0 },
/* U+3d13 */ { 0, 0, 0, 0, 0 },
/* U+3d14 */ { 0, 0, 0, 0, 0 },
/* U+3d15 */ { 0, 0, 0, 0, 0 },
/* U+3d16 */ { 0, 0, 0, 0, 0 },
/* U+3d17 */ { 0, 0, 0, 0, 0 },
/* U+3d18 */ { 0, 0, 0, 0, 0 },
/* U+3d19 */ { 0, 0, 0, 0, 0 },
/* U+3d1a */ { 0, 0, 0, 0, 0 },
/* U+3d1b */ { 0, 0, 0, 0, 0 },
/* U+3d1c */ { 0, 0, 0, 0, 0 },
/* U+3d1d */ { 0, 0, 0, 0, 0 },
/* U+3d1e */ { 0, 0, 0, 0, 0 },
/* U+3d1f */ { 0, 0, 0, 0, 0 },
/* U+3d20 */ { 0, 0, 0, 0, 0 },
/* U+3d21 */ { 0, 0, 0, 0, 0 },
/* U+3d22 */ { 0, 0, 0, 0, 0 },
/* U+3d23 */ { 0, 0, 0, 0, 0 },
/* U+3d24 */ { 0, 0, 0, 0, 0 },
/* U+3d25 */ { 0, 0, 0, 0, 0 },
/* U+3d26 */ { 0, 0, 0, 0, 0 },
/* U+3d27 */ { 0, 0, 0, 0, 0 },
/* U+3d28 */ { 0, 0, 0, 0, 0 },
/* U+3d29 */ { 0, 0, 0, 0, 0 },
/* U+3d2a */ { 0, 0, 0, 0, 0 },
/* U+3d2b */ { 0, 0, 0, 0, 0 },
/* U+3d2c */ { 0, 0, 0, 0, 0 },
/* U+3d2d */ { 0, 0, 0, 0, 0 },
/* U+3d2e */ { 0, 0, 0, 0, 0 },
/* U+3d2f */ { 0, 0, 0, 0, 0 },
/* U+3d30 */ { 0, 0, 0, 0, 0 },
/* U+3d31 */ { 0, 0, 0, 0, 0 },
/* U+3d32 */ { 0, 0, 0, 0, 0 },
/* U+3d33 */ { 0, 0, 0, 0, 0 },
/* U+3d34 */ { 0, 0, 0, 0, 0 },
/* U+3d35 */ { 0, 0, 0, 0, 0 },
/* U+3d36 */ { 0, 0, 0, 0, 0 },
/* U+3d37 */ { 0, 0, 0, 0, 0 },
/* U+3d38 */ { 0, 0, 0, 0, 0 },
/* U+3d39 */ { 0, 0, 0, 0, 0 },
/* U+3d3a */ { 0, 0, 0, 0, 0 },
/* U+3d3b */ { 0, 0, 0, 0, 0 },
/* U+3d3c */ { 0, 0, 0, 0, 0 },
/* U+3d3d */ { 0, 0, 0, 0, 0 },
/* U+3d3e */ { 0, 0, 0, 0, 0 },
/* U+3d3f */ { 0, 0, 0, 0, 0 },
/* U+3d40 */ { 0, 0, 0, 0, 0 },
/* U+3d41 */ { 0, 0, 0, 0, 0 },
/* U+3d42 */ { 0, 0, 0, 0, 0 },
/* U+3d43 */ { 0, 0, 0, 0, 0 },
/* U+3d44 */ { 0, 0, 0, 0, 0 },
/* U+3d45 */ { 0, 0, 0, 0, 0 },
/* U+3d46 */ { 0, 0, 0, 0, 0 },
/* U+3d47 */ { 0, 0, 0, 0, 0 },
/* U+3d48 */ { 0, 0, 0, 0, 0 },
/* U+3d49 */ { 0, 0, 0, 0, 0 },
/* U+3d4a */ { 0, 0, 0, 0, 0 },
/* U+3d4b */ { 0, 0, 0, 0, 0 },
/* U+3d4c */ { 0, 0, 0, 0, 0 },
/* U+3d4d */ { 0, 0, 0, 0, 0 },
/* U+3d4e */ { 0, 0, 0, 0, 0 },
/* U+3d4f */ { 0, 0, 0, 0, 0 },
/* U+3d50 */ { 0, 0, 0, 0, 0 },
/* U+3d51 */ { 0, 0, 0, 0, 0 },
/* U+3d52 */ { 0, 0, 0, 0, 0 },
/* U+3d53 */ { 0, 0, 0, 0, 0 },
/* U+3d54 */ { 0, 0, 0, 0, 0 },
/* U+3d55 */ { 0, 0, 0, 0, 0 },
/* U+3d56 */ { 0, 0, 0, 0, 0 },
/* U+3d57 */ { 0, 0, 0, 0, 0 },
/* U+3d58 */ { 0, 0, 0, 0, 0 },
/* U+3d59 */ { 0, 0, 0, 0, 0 },
/* U+3d5a */ { 0, 0, 0, 0, 0 },
/* U+3d5b */ { 0, 0, 0, 0, 0 },
/* U+3d5c */ { 0, 0, 0, 0, 0 },
/* U+3d5d */ { 0, 0, 0, 0, 0 },
/* U+3d5e */ { 0, 0, 0, 0, 0 },
/* U+3d5f */ { 0, 0, 0, 0, 0 },
/* U+3d60 */ { 0, 0, 0, 0, 0 },
/* U+3d61 */ { 0, 0, 0, 0, 0 },
/* U+3d62 */ { 0, 0, 0, 0, 0 },
/* U+3d63 */ { 0, 0, 0, 0, 0 },
/* U+3d64 */ { 0, 0, 0, 0, 0 },
/* U+3d65 */ { 0, 0, 0, 0, 0 },
/* U+3d66 */ { 0, 0, 0, 0, 0 },
/* U+3d67 */ { 0, 0, 0, 0, 0 },
/* U+3d68 */ { 0, 0, 0, 0, 0 },
/* U+3d69 */ { 0, 0, 0, 0, 0 },
/* U+3d6a */ { 0, 0, 0, 0, 0 },
/* U+3d6b */ { 0, 0, 0, 0, 0 },
/* U+3d6c */ { 0, 0, 0, 0, 0 },
/* U+3d6d */ { 0, 0, 0, 0, 0 },
/* U+3d6e */ { 0, 0, 0, 0, 0 },
/* U+3d6f */ { 0, 0, 0, 0, 0 },
/* U+3d70 */ { 0, 0, 0, 0, 0 },
/* U+3d71 */ { 0, 0, 0, 0, 0 },
/* U+3d72 */ { 0, 0, 0, 0, 0 },
/* U+3d73 */ { 0, 0, 0, 0, 0 },
/* U+3d74 */ { 0, 0, 0, 0, 0 },
/* U+3d75 */ { 0, 0, 0, 0, 0 },
/* U+3d76 */ { 0, 0, 0, 0, 0 },
/* U+3d77 */ { 0, 0, 0, 0, 0 },
/* U+3d78 */ { 0, 0, 0, 0, 0 },
/* U+3d79 */ { 0, 0, 0, 0, 0 },
/* U+3d7a */ { 0, 0, 0, 0, 0 },
/* U+3d7b */ { 0, 0, 0, 0, 0 },
/* U+3d7c */ { 0, 0, 0, 0, 0 },
/* U+3d7d */ { 0, 0, 0, 0, 0 },
/* U+3d7e */ { 0, 0, 0, 0, 0 },
/* U+3d7f */ { 0, 0, 0, 0, 0 },
/* U+3d80 */ { 0, 0, 0, 0, 0 },
/* U+3d81 */ { 0, 0, 0, 0, 0 },
/* U+3d82 */ { 0, 0, 0, 0, 0 },
/* U+3d83 */ { 0, 0, 0, 0, 0 },
/* U+3d84 */ { 0, 0, 0, 0, 0 },
/* U+3d85 */ { 0, 0, 0, 0, 0 },
/* U+3d86 */ { 0, 0, 0, 0, 0 },
/* U+3d87 */ { 0, 0, 0, 0, 0 },
/* U+3d88 */ { 0, 0, 0, 0, 0 },
/* U+3d89 */ { 0, 0, 0, 0, 0 },
/* U+3d8a */ { 0, 0, 0, 0, 0 },
/* U+3d8b */ { 0, 0, 0, 0, 0 },
/* U+3d8c */ { 0, 0, 0, 0, 0 },
/* U+3d8d */ { 0, 0, 0, 0, 0 },
/* U+3d8e */ { 0, 0, 0, 0, 0 },
/* U+3d8f */ { 0, 0, 0, 0, 0 },
/* U+3d90 */ { 0, 0, 0, 0, 0 },
/* U+3d91 */ { 0, 0, 0, 0, 0 },
/* U+3d92 */ { 0, 0, 0, 0, 0 },
/* U+3d93 */ { 0, 0, 0, 0, 0 },
/* U+3d94 */ { 0, 0, 0, 0, 0 },
/* U+3d95 */ { 0, 0, 0, 0, 0 },
/* U+3d96 */ { 0, 0, 0, 0, 0 },
/* U+3d97 */ { 0, 0, 0, 0, 0 },
/* U+3d98 */ { 0, 0, 0, 0, 0 },
/* U+3d99 */ { 0, 0, 0, 0, 0 },
/* U+3d9a */ { 0, 0, 0, 0, 0 },
/* U+3d9b */ { 0, 0, 0, 0, 0 },
/* U+3d9c */ { 0, 0, 0, 0, 0 },
/* U+3d9d */ { 0, 0, 0, 0, 0 },
/* U+3d9e */ { 0, 0, 0, 0, 0 },
/* U+3d9f */ { 0, 0, 0, 0, 0 },
/* U+3da0 */ { 0, 0, 0, 0, 0 },
/* U+3da1 */ { 0, 0, 0, 0, 0 },
/* U+3da2 */ { 0, 0, 0, 0, 0 },
/* U+3da3 */ { 0, 0, 0, 0, 0 },
/* U+3da4 */ { 0, 0, 0, 0, 0 },
/* U+3da5 */ { 0, 0, 0, 0, 0 },
/* U+3da6 */ { 0, 0, 0, 0, 0 },
/* U+3da7 */ { 0, 0, 0, 0, 0 },
/* U+3da8 */ { 0, 0, 0, 0, 0 },
/* U+3da9 */ { 0, 0, 0, 0, 0 },
/* U+3daa */ { 0, 0, 0, 0, 0 },
/* U+3dab */ { 0, 0, 0, 0, 0 },
/* U+3dac */ { 0, 0, 0, 0, 0 },
/* U+3dad */ { 0, 0, 0, 0, 0 },
/* U+3dae */ { 0, 0, 0, 0, 0 },
/* U+3daf */ { 0, 0, 0, 0, 0 },
/* U+3db0 */ { 0, 0, 0, 0, 0 },
/* U+3db1 */ { 0, 0, 0, 0, 0 },
/* U+3db2 */ { 0, 0, 0, 0, 0 },
/* U+3db3 */ { 0, 0, 0, 0, 0 },
/* U+3db4 */ { 0, 0, 0, 0, 0 },
/* U+3db5 */ { 0, 0, 0, 0, 0 },
/* U+3db6 */ { 0, 0, 0, 0, 0 },
/* U+3db7 */ { 0, 0, 0, 0, 0 },
/* U+3db8 */ { 0, 0, 0, 0, 0 },
/* U+3db9 */ { 0, 0, 0, 0, 0 },
/* U+3dba */ { 0, 0, 0, 0, 0 },
/* U+3dbb */ { 0, 0, 0, 0, 0 },
/* U+3dbc */ { 0, 0, 0, 0, 0 },
/* U+3dbd */ { 0, 0, 0, 0, 0 },
/* U+3dbe */ { 0, 0, 0, 0, 0 },
/* U+3dbf */ { 0, 0, 0, 0, 0 },
/* U+3dc0 */ { 0, 0, 0, 0, 0 },
/* U+3dc1 */ { 0, 0, 0, 0, 0 },
/* U+3dc2 */ { 0, 0, 0, 0, 0 },
/* U+3dc3 */ { 0, 0, 0, 0, 0 },
/* U+3dc4 */ { 0, 0, 0, 0, 0 },
/* U+3dc5 */ { 0, 0, 0, 0, 0 },
/* U+3dc6 */ { 0, 0, 0, 0, 0 },
/* U+3dc7 */ { 0, 0, 0, 0, 0 },
/* U+3dc8 */ { 0, 0, 0, 0, 0 },
/* U+3dc9 */ { 0, 0, 0, 0, 0 },
/* U+3dca */ { 0, 0, 0, 0, 0 },
/* U+3dcb */ { 0, 0, 0, 0, 0 },
/* U+3dcc */ { 0, 0, 0, 0, 0 },
/* U+3dcd */ { 0, 0, 0, 0, 0 },
/* U+3dce */ { 0, 0, 0, 0, 0 },
/* U+3dcf */ { 0, 0, 0, 0, 0 },
/* U+3dd0 */ { 0, 0, 0, 0, 0 },
/* U+3dd1 */ { 0, 0, 0, 0, 0 },
/* U+3dd2 */ { 0, 0, 0, 0, 0 },
/* U+3dd3 */ { 0, 0, 0, 0, 0 },
/* U+3dd4 */ { 0, 0, 0, 0, 0 },
/* U+3dd5 */ { 0, 0, 0, 0, 0 },
/* U+3dd6 */ { 0, 0, 0, 0, 0 },
/* U+3dd7 */ { 0, 0, 0, 0, 0 },
/* U+3dd8 */ { 0, 0, 0, 0, 0 },
/* U+3dd9 */ { 0, 0, 0, 0, 0 },
/* U+3dda */ { 0, 0, 0, 0, 0 },
/* U+3ddb */ { 0, 0, 0, 0, 0 },
/* U+3ddc */ { 0, 0, 0, 0, 0 },
/* U+3ddd */ { 0, 0, 0, 0, 0 },
/* U+3dde */ { 0, 0, 0, 0, 0 },
/* U+3ddf */ { 0, 0, 0, 0, 0 },
/* U+3de0 */ { 0, 0, 0, 0, 0 },
/* U+3de1 */ { 0, 0, 0, 0, 0 },
/* U+3de2 */ { 0, 0, 0, 0, 0 },
/* U+3de3 */ { 0, 0, 0, 0, 0 },
/* U+3de4 */ { 0, 0, 0, 0, 0 },
/* U+3de5 */ { 0, 0, 0, 0, 0 },
/* U+3de6 */ { 0, 0, 0, 0, 0 },
/* U+3de7 */ { 0, 0, 0, 0, 0 },
/* U+3de8 */ { 0, 0, 0, 0, 0 },
/* U+3de9 */ { 0, 0, 0, 0, 0 },
/* U+3dea */ { 0, 0, 0, 0, 0 },
/* U+3deb */ { 0, 0, 0, 0, 0 },
/* U+3dec */ { 0, 0, 0, 0, 0 },
/* U+3ded */ { 0, 0, 0, 0, 0 },
/* U+3dee */ { 0, 0, 0, 0, 0 },
/* U+3def */ { 0, 0, 0, 0, 0 },
/* U+3df0 */ { 0, 0, 0, 0, 0 },
/* U+3df1 */ { 0, 0, 0, 0, 0 },
/* U+3df2 */ { 0, 0, 0, 0, 0 },
/* U+3df3 */ { 0, 0, 0, 0, 0 },
/* U+3df4 */ { 0, 0, 0, 0, 0 },
/* U+3df5 */ { 0, 0, 0, 0, 0 },
/* U+3df6 */ { 0, 0, 0, 0, 0 },
/* U+3df7 */ { 0, 0, 0, 0, 0 },
/* U+3df8 */ { 0, 0, 0, 0, 0 },
/* U+3df9 */ { 0, 0, 0, 0, 0 },
/* U+3dfa */ { 0, 0, 0, 0, 0 },
/* U+3dfb */ { 0, 0, 0, 0, 0 },
/* U+3dfc */ { 0, 0, 0, 0, 0 },
/* U+3dfd */ { 0, 0, 0, 0, 0 },
/* U+3dfe */ { 0, 0, 0, 0, 0 },
/* U+3dff */ { 0, 0, 0, 0, 0 },
/* U+3e00 */ { 0, 0, 0, 0, 0 },
/* U+3e01 */ { 0, 0, 0, 0, 0 },
/* U+3e02 */ { 0, 0, 0, 0, 0 },
/* U+3e03 */ { 0, 0, 0, 0, 0 },
/* U+3e04 */ { 0, 0, 0, 0, 0 },
/* U+3e05 */ { 0, 0, 0, 0, 0 },
/* U+3e06 */ { 0, 0, 0, 0, 0 },
/* U+3e07 */ { 0, 0, 0, 0, 0 },
/* U+3e08 */ { 0, 0, 0, 0, 0 },
/* U+3e09 */ { 0, 0, 0, 0, 0 },
/* U+3e0a */ { 0, 0, 0, 0, 0 },
/* U+3e0b */ { 0, 0, 0, 0, 0 },
/* U+3e0c */ { 0, 0, 0, 0, 0 },
/* U+3e0d */ { 0, 0, 0, 0, 0 },
/* U+3e0e */ { 0, 0, 0, 0, 0 },
/* U+3e0f */ { 0, 0, 0, 0, 0 },
/* U+3e10 */ { 0, 0, 0, 0, 0 },
/* U+3e11 */ { 0, 0, 0, 0, 0 },
/* U+3e12 */ { 0, 0, 0, 0, 0 },
/* U+3e13 */ { 0, 0, 0, 0, 0 },
/* U+3e14 */ { 0, 0, 0, 0, 0 },
/* U+3e15 */ { 0, 0, 0, 0, 0 },
/* U+3e16 */ { 0, 0, 0, 0, 0 },
/* U+3e17 */ { 0, 0, 0, 0, 0 },
/* U+3e18 */ { 0, 0, 0, 0, 0 },
/* U+3e19 */ { 0, 0, 0, 0, 0 },
/* U+3e1a */ { 0, 0, 0, 0, 0 },
/* U+3e1b */ { 0, 0, 0, 0, 0 },
/* U+3e1c */ { 0, 0, 0, 0, 0 },
/* U+3e1d */ { 0, 0, 0, 0, 0 },
/* U+3e1e */ { 0, 0, 0, 0, 0 },
/* U+3e1f */ { 0, 0, 0, 0, 0 },
/* U+3e20 */ { 0, 0, 0, 0, 0 },
/* U+3e21 */ { 0, 0, 0, 0, 0 },
/* U+3e22 */ { 0, 0, 0, 0, 0 },
/* U+3e23 */ { 0, 0, 0, 0, 0 },
/* U+3e24 */ { 0, 0, 0, 0, 0 },
/* U+3e25 */ { 0, 0, 0, 0, 0 },
/* U+3e26 */ { 0, 0, 0, 0, 0 },
/* U+3e27 */ { 0, 0, 0, 0, 0 },
/* U+3e28 */ { 0, 0, 0, 0, 0 },
/* U+3e29 */ { 0, 0, 0, 0, 0 },
/* U+3e2a */ { 0, 0, 0, 0, 0 },
/* U+3e2b */ { 0, 0, 0, 0, 0 },
/* U+3e2c */ { 0, 0, 0, 0, 0 },
/* U+3e2d */ { 0, 0, 0, 0, 0 },
/* U+3e2e */ { 0, 0, 0, 0, 0 },
/* U+3e2f */ { 0, 0, 0, 0, 0 },
/* U+3e30 */ { 0, 0, 0, 0, 0 },
/* U+3e31 */ { 0, 0, 0, 0, 0 },
/* U+3e32 */ { 0, 0, 0, 0, 0 },
/* U+3e33 */ { 0, 0, 0, 0, 0 },
/* U+3e34 */ { 0, 0, 0, 0, 0 },
/* U+3e35 */ { 0, 0, 0, 0, 0 },
/* U+3e36 */ { 0, 0, 0, 0, 0 },
/* U+3e37 */ { 0, 0, 0, 0, 0 },
/* U+3e38 */ { 0, 0, 0, 0, 0 },
/* U+3e39 */ { 0, 0, 0, 0, 0 },
/* U+3e3a */ { 0, 0, 0, 0, 0 },
/* U+3e3b */ { 0, 0, 0, 0, 0 },
/* U+3e3c */ { 0, 0, 0, 0, 0 },
/* U+3e3d */ { 0, 0, 0, 0, 0 },
/* U+3e3e */ { 0, 0, 0, 0, 0 },
/* U+3e3f */ { 0, 0, 0, 0, 0 },
/* U+3e40 */ { 0, 0, 0, 0, 0 },
/* U+3e41 */ { 0, 0, 0, 0, 0 },
/* U+3e42 */ { 0, 0, 0, 0, 0 },
/* U+3e43 */ { 0, 0, 0, 0, 0 },
/* U+3e44 */ { 0, 0, 0, 0, 0 },
/* U+3e45 */ { 0, 0, 0, 0, 0 },
/* U+3e46 */ { 0, 0, 0, 0, 0 },
/* U+3e47 */ { 0, 0, 0, 0, 0 },
/* U+3e48 */ { 0, 0, 0, 0, 0 },
/* U+3e49 */ { 0, 0, 0, 0, 0 },
/* U+3e4a */ { 0, 0, 0, 0, 0 },
/* U+3e4b */ { 0, 0, 0, 0, 0 },
/* U+3e4c */ { 0, 0, 0, 0, 0 },
/* U+3e4d */ { 0, 0, 0, 0, 0 },
/* U+3e4e */ { 0, 0, 0, 0, 0 },
/* U+3e4f */ { 0, 0, 0, 0, 0 },
/* U+3e50 */ { 0, 0, 0, 0, 0 },
/* U+3e51 */ { 0, 0, 0, 0, 0 },
/* U+3e52 */ { 0, 0, 0, 0, 0 },
/* U+3e53 */ { 0, 0, 0, 0, 0 },
/* U+3e54 */ { 0, 0, 0, 0, 0 },
/* U+3e55 */ { 0, 0, 0, 0, 0 },
/* U+3e56 */ { 0, 0, 0, 0, 0 },
/* U+3e57 */ { 0, 0, 0, 0, 0 },
/* U+3e58 */ { 0, 0, 0, 0, 0 },
/* U+3e59 */ { 0, 0, 0, 0, 0 },
/* U+3e5a */ { 0, 0, 0, 0, 0 },
/* U+3e5b */ { 0, 0, 0, 0, 0 },
/* U+3e5c */ { 0, 0, 0, 0, 0 },
/* U+3e5d */ { 0, 0, 0, 0, 0 },
/* U+3e5e */ { 0, 0, 0, 0, 0 },
/* U+3e5f */ { 0, 0, 0, 0, 0 },
/* U+3e60 */ { 0, 0, 0, 0, 0 },
/* U+3e61 */ { 0, 0, 0, 0, 0 },
/* U+3e62 */ { 0, 0, 0, 0, 0 },
/* U+3e63 */ { 0, 0, 0, 0, 0 },
/* U+3e64 */ { 0, 0, 0, 0, 0 },
/* U+3e65 */ { 0, 0, 0, 0, 0 },
/* U+3e66 */ { 0, 0, 0, 0, 0 },
/* U+3e67 */ { 0, 0, 0, 0, 0 },
/* U+3e68 */ { 0, 0, 0, 0, 0 },
/* U+3e69 */ { 0, 0, 0, 0, 0 },
/* U+3e6a */ { 0, 0, 0, 0, 0 },
/* U+3e6b */ { 0, 0, 0, 0, 0 },
/* U+3e6c */ { 0, 0, 0, 0, 0 },
/* U+3e6d */ { 0, 0, 0, 0, 0 },
/* U+3e6e */ { 0, 0, 0, 0, 0 },
/* U+3e6f */ { 0, 0, 0, 0, 0 },
/* U+3e70 */ { 0, 0, 0, 0, 0 },
/* U+3e71 */ { 0, 0, 0, 0, 0 },
/* U+3e72 */ { 0, 0, 0, 0, 0 },
/* U+3e73 */ { 0, 0, 0, 0, 0 },
/* U+3e74 */ { 0, 0, 0, 0, 0 },
/* U+3e75 */ { 0, 0, 0, 0, 0 },
/* U+3e76 */ { 0, 0, 0, 0, 0 },
/* U+3e77 */ { 0, 0, 0, 0, 0 },
/* U+3e78 */ { 0, 0, 0, 0, 0 },
/* U+3e79 */ { 0, 0, 0, 0, 0 },
/* U+3e7a */ { 0, 0, 0, 0, 0 },
/* U+3e7b */ { 0, 0, 0, 0, 0 },
/* U+3e7c */ { 0, 0, 0, 0, 0 },
/* U+3e7d */ { 0, 0, 0, 0, 0 },
/* U+3e7e */ { 0, 0, 0, 0, 0 },
/* U+3e7f */ { 0, 0, 0, 0, 0 },
/* U+3e80 */ { 0, 0, 0, 0, 0 },
/* U+3e81 */ { 0, 0, 0, 0, 0 },
/* U+3e82 */ { 0, 0, 0, 0, 0 },
/* U+3e83 */ { 0, 0, 0, 0, 0 },
/* U+3e84 */ { 0, 0, 0, 0, 0 },
/* U+3e85 */ { 0, 0, 0, 0, 0 },
/* U+3e86 */ { 0, 0, 0, 0, 0 },
/* U+3e87 */ { 0, 0, 0, 0, 0 },
/* U+3e88 */ { 0, 0, 0, 0, 0 },
/* U+3e89 */ { 0, 0, 0, 0, 0 },
/* U+3e8a */ { 0, 0, 0, 0, 0 },
/* U+3e8b */ { 0, 0, 0, 0, 0 },
/* U+3e8c */ { 0, 0, 0, 0, 0 },
/* U+3e8d */ { 0, 0, 0, 0, 0 },
/* U+3e8e */ { 0, 0, 0, 0, 0 },
/* U+3e8f */ { 0, 0, 0, 0, 0 },
/* U+3e90 */ { 0, 0, 0, 0, 0 },
/* U+3e91 */ { 0, 0, 0, 0, 0 },
/* U+3e92 */ { 0, 0, 0, 0, 0 },
/* U+3e93 */ { 0, 0, 0, 0, 0 },
/* U+3e94 */ { 0, 0, 0, 0, 0 },
/* U+3e95 */ { 0, 0, 0, 0, 0 },
/* U+3e96 */ { 0, 0, 0, 0, 0 },
/* U+3e97 */ { 0, 0, 0, 0, 0 },
/* U+3e98 */ { 0, 0, 0, 0, 0 },
/* U+3e99 */ { 0, 0, 0, 0, 0 },
/* U+3e9a */ { 0, 0, 0, 0, 0 },
/* U+3e9b */ { 0, 0, 0, 0, 0 },
/* U+3e9c */ { 0, 0, 0, 0, 0 },
/* U+3e9d */ { 0, 0, 0, 0, 0 },
/* U+3e9e */ { 0, 0, 0, 0, 0 },
/* U+3e9f */ { 0, 0, 0, 0, 0 },
/* U+3ea0 */ { 0, 0, 0, 0, 0 },
/* U+3ea1 */ { 0, 0, 0, 0, 0 },
/* U+3ea2 */ { 0, 0, 0, 0, 0 },
/* U+3ea3 */ { 0, 0, 0, 0, 0 },
/* U+3ea4 */ { 0, 0, 0, 0, 0 },
/* U+3ea5 */ { 0, 0, 0, 0, 0 },
/* U+3ea6 */ { 0, 0, 0, 0, 0 },
/* U+3ea7 */ { 0, 0, 0, 0, 0 },
/* U+3ea8 */ { 0, 0, 0, 0, 0 },
/* U+3ea9 */ { 0, 0, 0, 0, 0 },
/* U+3eaa */ { 0, 0, 0, 0, 0 },
/* U+3eab */ { 0, 0, 0, 0, 0 },
/* U+3eac */ { 0, 0, 0, 0, 0 },
/* U+3ead */ { 0, 0, 0, 0, 0 },
/* U+3eae */ { 0, 0, 0, 0, 0 },
/* U+3eaf */ { 0, 0, 0, 0, 0 },
/* U+3eb0 */ { 0, 0, 0, 0, 0 },
/* U+3eb1 */ { 0, 0, 0, 0, 0 },
/* U+3eb2 */ { 0, 0, 0, 0, 0 },
/* U+3eb3 */ { 0, 0, 0, 0, 0 },
/* U+3eb4 */ { 0, 0, 0, 0, 0 },
/* U+3eb5 */ { 0, 0, 0, 0, 0 },
/* U+3eb6 */ { 0, 0, 0, 0, 0 },
/* U+3eb7 */ { 0, 0, 0, 0, 0 },
/* U+3eb8 */ { 0, 0, 0, 0, 0 },
/* U+3eb9 */ { 0, 0, 0, 0, 0 },
/* U+3eba */ { 0, 0, 0, 0, 0 },
/* U+3ebb */ { 0, 0, 0, 0, 0 },
/* U+3ebc */ { 0, 0, 0, 0, 0 },
/* U+3ebd */ { 0, 0, 0, 0, 0 },
/* U+3ebe */ { 0, 0, 0, 0, 0 },
/* U+3ebf */ { 0, 0, 0, 0, 0 },
/* U+3ec0 */ { 0, 0, 0, 0, 0 },
/* U+3ec1 */ { 0, 0, 0, 0, 0 },
/* U+3ec2 */ { 0, 0, 0, 0, 0 },
/* U+3ec3 */ { 0, 0, 0, 0, 0 },
/* U+3ec4 */ { 0, 0, 0, 0, 0 },
/* U+3ec5 */ { 0, 0, 0, 0, 0 },
/* U+3ec6 */ { 0, 0, 0, 0, 0 },
/* U+3ec7 */ { 0, 0, 0, 0, 0 },
/* U+3ec8 */ { 0, 0, 0, 0, 0 },
/* U+3ec9 */ { 0, 0, 0, 0, 0 },
/* U+3eca */ { 0, 0, 0, 0, 0 },
/* U+3ecb */ { 0, 0, 0, 0, 0 },
/* U+3ecc */ { 0, 0, 0, 0, 0 },
/* U+3ecd */ { 0, 0, 0, 0, 0 },
/* U+3ece */ { 0, 0, 0, 0, 0 },
/* U+3ecf */ { 0, 0, 0, 0, 0 },
/* U+3ed0 */ { 0, 0, 0, 0, 0 },
/* U+3ed1 */ { 0, 0, 0, 0, 0 },
/* U+3ed2 */ { 0, 0, 0, 0, 0 },
/* U+3ed3 */ { 0, 0, 0, 0, 0 },
/* U+3ed4 */ { 0, 0, 0, 0, 0 },
/* U+3ed5 */ { 0, 0, 0, 0, 0 },
/* U+3ed6 */ { 0, 0, 0, 0, 0 },
/* U+3ed7 */ { 0, 0, 0, 0, 0 },
/* U+3ed8 */ { 0, 0, 0, 0, 0 },
/* U+3ed9 */ { 0, 0, 0, 0, 0 },
/* U+3eda */ { 0, 0, 0, 0, 0 },
/* U+3edb */ { 0, 0, 0, 0, 0 },
/* U+3edc */ { 0, 0, 0, 0, 0 },
/* U+3edd */ { 0, 0, 0, 0, 0 },
/* U+3ede */ { 0, 0, 0, 0, 0 },
/* U+3edf */ { 0, 0, 0, 0, 0 },
/* U+3ee0 */ { 0, 0, 0, 0, 0 },
/* U+3ee1 */ { 0, 0, 0, 0, 0 },
/* U+3ee2 */ { 0, 0, 0, 0, 0 },
/* U+3ee3 */ { 0, 0, 0, 0, 0 },
/* U+3ee4 */ { 0, 0, 0, 0, 0 },
/* U+3ee5 */ { 0, 0, 0, 0, 0 },
/* U+3ee6 */ { 0, 0, 0, 0, 0 },
/* U+3ee7 */ { 0, 0, 0, 0, 0 },
/* U+3ee8 */ { 0, 0, 0, 0, 0 },
/* U+3ee9 */ { 0, 0, 0, 0, 0 },
/* U+3eea */ { 0, 0, 0, 0, 0 },
/* U+3eeb */ { 0, 0, 0, 0, 0 },
/* U+3eec */ { 0, 0, 0, 0, 0 },
/* U+3eed */ { 0, 0, 0, 0, 0 },
/* U+3eee */ { 0, 0, 0, 0, 0 },
/* U+3eef */ { 0, 0, 0, 0, 0 },
/* U+3ef0 */ { 0, 0, 0, 0, 0 },
/* U+3ef1 */ { 0, 0, 0, 0, 0 },
/* U+3ef2 */ { 0, 0, 0, 0, 0 },
/* U+3ef3 */ { 0, 0, 0, 0, 0 },
/* U+3ef4 */ { 0, 0, 0, 0, 0 },
/* U+3ef5 */ { 0, 0, 0, 0, 0 },
/* U+3ef6 */ { 0, 0, 0, 0, 0 },
/* U+3ef7 */ { 0, 0, 0, 0, 0 },
/* U+3ef8 */ { 0, 0, 0, 0, 0 },
/* U+3ef9 */ { 0, 0, 0, 0, 0 },
/* U+3efa */ { 0, 0, 0, 0, 0 },
/* U+3efb */ { 0, 0, 0, 0, 0 },
/* U+3efc */ { 0, 0, 0, 0, 0 },
/* U+3efd */ { 0, 0, 0, 0, 0 },
/* U+3efe */ { 0, 0, 0, 0, 0 },
/* U+3eff */ { 0, 0, 0, 0, 0 },
/* U+3f00 */ { 0, 0, 0, 0, 0 },
/* U+3f01 */ { 0, 0, 0, 0, 0 },
/* U+3f02 */ { 0, 0, 0, 0, 0 },
/* U+3f03 */ { 0, 0, 0, 0, 0 },
/* U+3f04 */ { 0, 0, 0, 0, 0 },
/* U+3f05 */ { 0, 0, 0, 0, 0 },
/* U+3f06 */ { 0, 0, 0, 0, 0 },
/* U+3f07 */ { 0, 0, 0, 0, 0 },
/* U+3f08 */ { 0, 0, 0, 0, 0 },
/* U+3f09 */ { 0, 0, 0, 0, 0 },
/* U+3f0a */ { 0, 0, 0, 0, 0 },
/* U+3f0b */ { 0, 0, 0, 0, 0 },
/* U+3f0c */ { 0, 0, 0, 0, 0 },
/* U+3f0d */ { 0, 0, 0, 0, 0 },
/* U+3f0e */ { 0, 0, 0, 0, 0 },
/* U+3f0f */ { 0, 0, 0, 0, 0 },
/* U+3f10 */ { 0, 0, 0, 0, 0 },
/* U+3f11 */ { 0, 0, 0, 0, 0 },
/* U+3f12 */ { 0, 0, 0, 0, 0 },
/* U+3f13 */ { 0, 0, 0, 0, 0 },
/* U+3f14 */ { 0, 0, 0, 0, 0 },
/* U+3f15 */ { 0, 0, 0, 0, 0 },
/* U+3f16 */ { 0, 0, 0, 0, 0 },
/* U+3f17 */ { 0, 0, 0, 0, 0 },
/* U+3f18 */ { 0, 0, 0, 0, 0 },
/* U+3f19 */ { 0, 0, 0, 0, 0 },
/* U+3f1a */ { 0, 0, 0, 0, 0 },
/* U+3f1b */ { 0, 0, 0, 0, 0 },
/* U+3f1c */ { 0, 0, 0, 0, 0 },
/* U+3f1d */ { 0, 0, 0, 0, 0 },
/* U+3f1e */ { 0, 0, 0, 0, 0 },
/* U+3f1f */ { 0, 0, 0, 0, 0 },
/* U+3f20 */ { 0, 0, 0, 0, 0 },
/* U+3f21 */ { 0, 0, 0, 0, 0 },
/* U+3f22 */ { 0, 0, 0, 0, 0 },
/* U+3f23 */ { 0, 0, 0, 0, 0 },
/* U+3f24 */ { 0, 0, 0, 0, 0 },
/* U+3f25 */ { 0, 0, 0, 0, 0 },
/* U+3f26 */ { 0, 0, 0, 0, 0 },
/* U+3f27 */ { 0, 0, 0, 0, 0 },
/* U+3f28 */ { 0, 0, 0, 0, 0 },
/* U+3f29 */ { 0, 0, 0, 0, 0 },
/* U+3f2a */ { 0, 0, 0, 0, 0 },
/* U+3f2b */ { 0, 0, 0, 0, 0 },
/* U+3f2c */ { 0, 0, 0, 0, 0 },
/* U+3f2d */ { 0, 0, 0, 0, 0 },
/* U+3f2e */ { 0, 0, 0, 0, 0 },
/* U+3f2f */ { 0, 0, 0, 0, 0 },
/* U+3f30 */ { 0, 0, 0, 0, 0 },
/* U+3f31 */ { 0, 0, 0, 0, 0 },
/* U+3f32 */ { 0, 0, 0, 0, 0 },
/* U+3f33 */ { 0, 0, 0, 0, 0 },
/* U+3f34 */ { 0, 0, 0, 0, 0 },
/* U+3f35 */ { 0, 0, 0, 0, 0 },
/* U+3f36 */ { 0, 0, 0, 0, 0 },
/* U+3f37 */ { 0, 0, 0, 0, 0 },
/* U+3f38 */ { 0, 0, 0, 0, 0 },
/* U+3f39 */ { 0, 0, 0, 0, 0 },
/* U+3f3a */ { 0, 0, 0, 0, 0 },
/* U+3f3b */ { 0, 0, 0, 0, 0 },
/* U+3f3c */ { 0, 0, 0, 0, 0 },
/* U+3f3d */ { 0, 0, 0, 0, 0 },
/* U+3f3e */ { 0, 0, 0, 0, 0 },
/* U+3f3f */ { 0, 0, 0, 0, 0 },
/* U+3f40 */ { 0, 0, 0, 0, 0 },
/* U+3f41 */ { 0, 0, 0, 0, 0 },
/* U+3f42 */ { 0, 0, 0, 0, 0 },
/* U+3f43 */ { 0, 0, 0, 0, 0 },
/* U+3f44 */ { 0, 0, 0, 0, 0 },
/* U+3f45 */ { 0, 0, 0, 0, 0 },
/* U+3f46 */ { 0, 0, 0, 0, 0 },
/* U+3f47 */ { 0, 0, 0, 0, 0 },
/* U+3f48 */ { 0, 0, 0, 0, 0 },
/* U+3f49 */ { 0, 0, 0, 0, 0 },
/* U+3f4a */ { 0, 0, 0, 0, 0 },
/* U+3f4b */ { 0, 0, 0, 0, 0 },
/* U+3f4c */ { 0, 0, 0, 0, 0 },
/* U+3f4d */ { 0, 0, 0, 0, 0 },
/* U+3f4e */ { 0, 0, 0, 0, 0 },
/* U+3f4f */ { 0, 0, 0, 0, 0 },
/* U+3f50 */ { 0, 0, 0, 0, 0 },
/* U+3f51 */ { 0, 0, 0, 0, 0 },
/* U+3f52 */ { 0, 0, 0, 0, 0 },
/* U+3f53 */ { 0, 0, 0, 0, 0 },
/* U+3f54 */ { 0, 0, 0, 0, 0 },
/* U+3f55 */ { 0, 0, 0, 0, 0 },
/* U+3f56 */ { 0, 0, 0, 0, 0 },
/* U+3f57 */ { 0, 0, 0, 0, 0 },
/* U+3f58 */ { 0, 0, 0, 0, 0 },
/* U+3f59 */ { 0, 0, 0, 0, 0 },
/* U+3f5a */ { 0, 0, 0, 0, 0 },
/* U+3f5b */ { 0, 0, 0, 0, 0 },
/* U+3f5c */ { 0, 0, 0, 0, 0 },
/* U+3f5d */ { 0, 0, 0, 0, 0 },
/* U+3f5e */ { 0, 0, 0, 0, 0 },
/* U+3f5f */ { 0, 0, 0, 0, 0 },
/* U+3f60 */ { 0, 0, 0, 0, 0 },
/* U+3f61 */ { 0, 0, 0, 0, 0 },
/* U+3f62 */ { 0, 0, 0, 0, 0 },
/* U+3f63 */ { 0, 0, 0, 0, 0 },
/* U+3f64 */ { 0, 0, 0, 0, 0 },
/* U+3f65 */ { 0, 0, 0, 0, 0 },
/* U+3f66 */ { 0, 0, 0, 0, 0 },
/* U+3f67 */ { 0, 0, 0, 0, 0 },
/* U+3f68 */ { 0, 0, 0, 0, 0 },
/* U+3f69 */ { 0, 0, 0, 0, 0 },
/* U+3f6a */ { 0, 0, 0, 0, 0 },
/* U+3f6b */ { 0, 0, 0, 0, 0 },
/* U+3f6c */ { 0, 0, 0, 0, 0 },
/* U+3f6d */ { 0, 0, 0, 0, 0 },
/* U+3f6e */ { 0, 0, 0, 0, 0 },
/* U+3f6f */ { 0, 0, 0, 0, 0 },
/* U+3f70 */ { 0, 0, 0, 0, 0 },
/* U+3f71 */ { 0, 0, 0, 0, 0 },
/* U+3f72 */ { 0, 0, 0, 0, 0 },
/* U+3f73 */ { 0, 0, 0, 0, 0 },
/* U+3f74 */ { 0, 0, 0, 0, 0 },
/* U+3f75 */ { 0, 0, 0, 0, 0 },
/* U+3f76 */ { 0, 0, 0, 0, 0 },
/* U+3f77 */ { 0, 0, 0, 0, 0 },
/* U+3f78 */ { 0, 0, 0, 0, 0 },
/* U+3f79 */ { 0, 0, 0, 0, 0 },
/* U+3f7a */ { 0, 0, 0, 0, 0 },
/* U+3f7b */ { 0, 0, 0, 0, 0 },
/* U+3f7c */ { 0, 0, 0, 0, 0 },
/* U+3f7d */ { 0, 0, 0, 0, 0 },
/* U+3f7e */ { 0, 0, 0, 0, 0 },
/* U+3f7f */ { 0, 0, 0, 0, 0 },
/* U+3f80 */ { 0, 0, 0, 0, 0 },
/* U+3f81 */ { 0, 0, 0, 0, 0 },
/* U+3f82 */ { 0, 0, 0, 0, 0 },
/* U+3f83 */ { 0, 0, 0, 0, 0 },
/* U+3f84 */ { 0, 0, 0, 0, 0 },
/* U+3f85 */ { 0, 0, 0, 0, 0 },
/* U+3f86 */ { 0, 0, 0, 0, 0 },
/* U+3f87 */ { 0, 0, 0, 0, 0 },
/* U+3f88 */ { 0, 0, 0, 0, 0 },
/* U+3f89 */ { 0, 0, 0, 0, 0 },
/* U+3f8a */ { 0, 0, 0, 0, 0 },
/* U+3f8b */ { 0, 0, 0, 0, 0 },
/* U+3f8c */ { 0, 0, 0, 0, 0 },
/* U+3f8d */ { 0, 0, 0, 0, 0 },
/* U+3f8e */ { 0, 0, 0, 0, 0 },
/* U+3f8f */ { 0, 0, 0, 0, 0 },
/* U+3f90 */ { 0, 0, 0, 0, 0 },
/* U+3f91 */ { 0, 0, 0, 0, 0 },
/* U+3f92 */ { 0, 0, 0, 0, 0 },
/* U+3f93 */ { 0, 0, 0, 0, 0 },
/* U+3f94 */ { 0, 0, 0, 0, 0 },
/* U+3f95 */ { 0, 0, 0, 0, 0 },
/* U+3f96 */ { 0, 0, 0, 0, 0 },
/* U+3f97 */ { 0, 0, 0, 0, 0 },
/* U+3f98 */ { 0, 0, 0, 0, 0 },
/* U+3f99 */ { 0, 0, 0, 0, 0 },
/* U+3f9a */ { 0, 0, 0, 0, 0 },
/* U+3f9b */ { 0, 0, 0, 0, 0 },
/* U+3f9c */ { 0, 0, 0, 0, 0 },
/* U+3f9d */ { 0, 0, 0, 0, 0 },
/* U+3f9e */ { 0, 0, 0, 0, 0 },
/* U+3f9f */ { 0, 0, 0, 0, 0 },
/* U+3fa0 */ { 0, 0, 0, 0, 0 },
/* U+3fa1 */ { 0, 0, 0, 0, 0 },
/* U+3fa2 */ { 0, 0, 0, 0, 0 },
/* U+3fa3 */ { 0, 0, 0, 0, 0 },
/* U+3fa4 */ { 0, 0, 0, 0, 0 },
/* U+3fa5 */ { 0, 0, 0, 0, 0 },
/* U+3fa6 */ { 0, 0, 0, 0, 0 },
/* U+3fa7 */ { 0, 0, 0, 0, 0 },
/* U+3fa8 */ { 0, 0, 0, 0, 0 },
/* U+3fa9 */ { 0, 0, 0, 0, 0 },
/* U+3faa */ { 0, 0, 0, 0, 0 },
/* U+3fab */ { 0, 0, 0, 0, 0 },
/* U+3fac */ { 0, 0, 0, 0, 0 },
/* U+3fad */ { 0, 0, 0, 0, 0 },
/* U+3fae */ { 0, 0, 0, 0, 0 },
/* U+3faf */ { 0, 0, 0, 0, 0 },
/* U+3fb0 */ { 0, 0, 0, 0, 0 },
/* U+3fb1 */ { 0, 0, 0, 0, 0 },
/* U+3fb2 */ { 0, 0, 0, 0, 0 },
/* U+3fb3 */ { 0, 0, 0, 0, 0 },
/* U+3fb4 */ { 0, 0, 0, 0, 0 },
/* U+3fb5 */ { 0, 0, 0, 0, 0 },
/* U+3fb6 */ { 0, 0, 0, 0, 0 },
/* U+3fb7 */ { 0, 0, 0, 0, 0 },
/* U+3fb8 */ { 0, 0, 0, 0, 0 },
/* U+3fb9 */ { 0, 0, 0, 0, 0 },
/* U+3fba */ { 0, 0, 0, 0, 0 },
/* U+3fbb */ { 0, 0, 0, 0, 0 },
/* U+3fbc */ { 0, 0, 0, 0, 0 },
/* U+3fbd */ { 0, 0, 0, 0, 0 },
/* U+3fbe */ { 0, 0, 0, 0, 0 },
/* U+3fbf */ { 0, 0, 0, 0, 0 },
/* U+3fc0 */ { 0, 0, 0, 0, 0 },
/* U+3fc1 */ { 0, 0, 0, 0, 0 },
/* U+3fc2 */ { 0, 0, 0, 0, 0 },
/* U+3fc3 */ { 0, 0, 0, 0, 0 },
/* U+3fc4 */ { 0, 0, 0, 0, 0 },
/* U+3fc5 */ { 0, 0, 0, 0, 0 },
/* U+3fc6 */ { 0, 0, 0, 0, 0 },
/* U+3fc7 */ { 0, 0, 0, 0, 0 },
/* U+3fc8 */ { 0, 0, 0, 0, 0 },
/* U+3fc9 */ { 0, 0, 0, 0, 0 },
/* U+3fca */ { 0, 0, 0, 0, 0 },
/* U+3fcb */ { 0, 0, 0, 0, 0 },
/* U+3fcc */ { 0, 0, 0, 0, 0 },
/* U+3fcd */ { 0, 0, 0, 0, 0 },
/* U+3fce */ { 0, 0, 0, 0, 0 },
/* U+3fcf */ { 0, 0, 0, 0, 0 },
/* U+3fd0 */ { 0, 0, 0, 0, 0 },
/* U+3fd1 */ { 0, 0, 0, 0, 0 },
/* U+3fd2 */ { 0, 0, 0, 0, 0 },
/* U+3fd3 */ { 0, 0, 0, 0, 0 },
/* U+3fd4 */ { 0, 0, 0, 0, 0 },
/* U+3fd5 */ { 0, 0, 0, 0, 0 },
/* U+3fd6 */ { 0, 0, 0, 0, 0 },
/* U+3fd7 */ { 0, 0, 0, 0, 0 },
/* U+3fd8 */ { 0, 0, 0, 0, 0 },
/* U+3fd9 */ { 0, 0, 0, 0, 0 },
/* U+3fda */ { 0, 0, 0, 0, 0 },
/* U+3fdb */ { 0, 0, 0, 0, 0 },
/* U+3fdc */ { 0, 0, 0, 0, 0 },
/* U+3fdd */ { 0, 0, 0, 0, 0 },
/* U+3fde */ { 0, 0, 0, 0, 0 },
/* U+3fdf */ { 0, 0, 0, 0, 0 },
/* U+3fe0 */ { 0, 0, 0, 0, 0 },
/* U+3fe1 */ { 0, 0, 0, 0, 0 },
/* U+3fe2 */ { 0, 0, 0, 0, 0 },
/* U+3fe3 */ { 0, 0, 0, 0, 0 },
/* U+3fe4 */ { 0, 0, 0, 0, 0 },
/* U+3fe5 */ { 0, 0, 0, 0, 0 },
/* U+3fe6 */ { 0, 0, 0, 0, 0 },
/* U+3fe7 */ { 0, 0, 0, 0, 0 },
/* U+3fe8 */ { 0, 0, 0, 0, 0 },
/* U+3fe9 */ { 0, 0, 0, 0, 0 },
/* U+3fea */ { 0, 0, 0, 0, 0 },
/* U+3feb */ { 0, 0, 0, 0, 0 },
/* U+3fec */ { 0, 0, 0, 0, 0 },
/* U+3fed */ { 0, 0, 0, 0, 0 },
/* U+3fee */ { 0, 0, 0, 0, 0 },
/* U+3fef */ { 0, 0, 0, 0, 0 },
/* U+3ff0 */ { 0, 0, 0, 0, 0 },
/* U+3ff1 */ { 0, 0, 0, 0, 0 },
/* U+3ff2 */ { 0, 0, 0, 0, 0 },
/* U+3ff3 */ { 0, 0, 0, 0, 0 },
/* U+3ff4 */ { 0, 0, 0, 0, 0 },
/* U+3ff5 */ { 0, 0, 0, 0, 0 },
/* U+3ff6 */ { 0, 0, 0, 0, 0 },
/* U+3ff7 */ { 0, 0, 0, 0, 0 },
/* U+3ff8 */ { 0, 0, 0, 0, 0 },
/* U+3ff9 */ { 0, 0, 0, 0, 0 },
/* U+3ffa */ { 0, 0, 0, 0, 0 },
/* U+3ffb */ { 0, 0, 0, 0, 0 },
/* U+3ffc */ { 0, 0, 0, 0, 0 },
/* U+3ffd */ { 0, 0, 0, 0, 0 },
/* U+3ffe */ { 0, 0, 0, 0, 0 },
/* U+3fff */ { 0, 0, 0, 0, 0 },

};

const _PyUnicode_DatabaseRecord _PyUnicode_Database_4[4096] = {
    
/* U+4000 */ { 0, 0, 0, 0, 0 },
/* U+4001 */ { 0, 0, 0, 0, 0 },
/* U+4002 */ { 0, 0, 0, 0, 0 },
/* U+4003 */ { 0, 0, 0, 0, 0 },
/* U+4004 */ { 0, 0, 0, 0, 0 },
/* U+4005 */ { 0, 0, 0, 0, 0 },
/* U+4006 */ { 0, 0, 0, 0, 0 },
/* U+4007 */ { 0, 0, 0, 0, 0 },
/* U+4008 */ { 0, 0, 0, 0, 0 },
/* U+4009 */ { 0, 0, 0, 0, 0 },
/* U+400a */ { 0, 0, 0, 0, 0 },
/* U+400b */ { 0, 0, 0, 0, 0 },
/* U+400c */ { 0, 0, 0, 0, 0 },
/* U+400d */ { 0, 0, 0, 0, 0 },
/* U+400e */ { 0, 0, 0, 0, 0 },
/* U+400f */ { 0, 0, 0, 0, 0 },
/* U+4010 */ { 0, 0, 0, 0, 0 },
/* U+4011 */ { 0, 0, 0, 0, 0 },
/* U+4012 */ { 0, 0, 0, 0, 0 },
/* U+4013 */ { 0, 0, 0, 0, 0 },
/* U+4014 */ { 0, 0, 0, 0, 0 },
/* U+4015 */ { 0, 0, 0, 0, 0 },
/* U+4016 */ { 0, 0, 0, 0, 0 },
/* U+4017 */ { 0, 0, 0, 0, 0 },
/* U+4018 */ { 0, 0, 0, 0, 0 },
/* U+4019 */ { 0, 0, 0, 0, 0 },
/* U+401a */ { 0, 0, 0, 0, 0 },
/* U+401b */ { 0, 0, 0, 0, 0 },
/* U+401c */ { 0, 0, 0, 0, 0 },
/* U+401d */ { 0, 0, 0, 0, 0 },
/* U+401e */ { 0, 0, 0, 0, 0 },
/* U+401f */ { 0, 0, 0, 0, 0 },
/* U+4020 */ { 0, 0, 0, 0, 0 },
/* U+4021 */ { 0, 0, 0, 0, 0 },
/* U+4022 */ { 0, 0, 0, 0, 0 },
/* U+4023 */ { 0, 0, 0, 0, 0 },
/* U+4024 */ { 0, 0, 0, 0, 0 },
/* U+4025 */ { 0, 0, 0, 0, 0 },
/* U+4026 */ { 0, 0, 0, 0, 0 },
/* U+4027 */ { 0, 0, 0, 0, 0 },
/* U+4028 */ { 0, 0, 0, 0, 0 },
/* U+4029 */ { 0, 0, 0, 0, 0 },
/* U+402a */ { 0, 0, 0, 0, 0 },
/* U+402b */ { 0, 0, 0, 0, 0 },
/* U+402c */ { 0, 0, 0, 0, 0 },
/* U+402d */ { 0, 0, 0, 0, 0 },
/* U+402e */ { 0, 0, 0, 0, 0 },
/* U+402f */ { 0, 0, 0, 0, 0 },
/* U+4030 */ { 0, 0, 0, 0, 0 },
/* U+4031 */ { 0, 0, 0, 0, 0 },
/* U+4032 */ { 0, 0, 0, 0, 0 },
/* U+4033 */ { 0, 0, 0, 0, 0 },
/* U+4034 */ { 0, 0, 0, 0, 0 },
/* U+4035 */ { 0, 0, 0, 0, 0 },
/* U+4036 */ { 0, 0, 0, 0, 0 },
/* U+4037 */ { 0, 0, 0, 0, 0 },
/* U+4038 */ { 0, 0, 0, 0, 0 },
/* U+4039 */ { 0, 0, 0, 0, 0 },
/* U+403a */ { 0, 0, 0, 0, 0 },
/* U+403b */ { 0, 0, 0, 0, 0 },
/* U+403c */ { 0, 0, 0, 0, 0 },
/* U+403d */ { 0, 0, 0, 0, 0 },
/* U+403e */ { 0, 0, 0, 0, 0 },
/* U+403f */ { 0, 0, 0, 0, 0 },
/* U+4040 */ { 0, 0, 0, 0, 0 },
/* U+4041 */ { 0, 0, 0, 0, 0 },
/* U+4042 */ { 0, 0, 0, 0, 0 },
/* U+4043 */ { 0, 0, 0, 0, 0 },
/* U+4044 */ { 0, 0, 0, 0, 0 },
/* U+4045 */ { 0, 0, 0, 0, 0 },
/* U+4046 */ { 0, 0, 0, 0, 0 },
/* U+4047 */ { 0, 0, 0, 0, 0 },
/* U+4048 */ { 0, 0, 0, 0, 0 },
/* U+4049 */ { 0, 0, 0, 0, 0 },
/* U+404a */ { 0, 0, 0, 0, 0 },
/* U+404b */ { 0, 0, 0, 0, 0 },
/* U+404c */ { 0, 0, 0, 0, 0 },
/* U+404d */ { 0, 0, 0, 0, 0 },
/* U+404e */ { 0, 0, 0, 0, 0 },
/* U+404f */ { 0, 0, 0, 0, 0 },
/* U+4050 */ { 0, 0, 0, 0, 0 },
/* U+4051 */ { 0, 0, 0, 0, 0 },
/* U+4052 */ { 0, 0, 0, 0, 0 },
/* U+4053 */ { 0, 0, 0, 0, 0 },
/* U+4054 */ { 0, 0, 0, 0, 0 },
/* U+4055 */ { 0, 0, 0, 0, 0 },
/* U+4056 */ { 0, 0, 0, 0, 0 },
/* U+4057 */ { 0, 0, 0, 0, 0 },
/* U+4058 */ { 0, 0, 0, 0, 0 },
/* U+4059 */ { 0, 0, 0, 0, 0 },
/* U+405a */ { 0, 0, 0, 0, 0 },
/* U+405b */ { 0, 0, 0, 0, 0 },
/* U+405c */ { 0, 0, 0, 0, 0 },
/* U+405d */ { 0, 0, 0, 0, 0 },
/* U+405e */ { 0, 0, 0, 0, 0 },
/* U+405f */ { 0, 0, 0, 0, 0 },
/* U+4060 */ { 0, 0, 0, 0, 0 },
/* U+4061 */ { 0, 0, 0, 0, 0 },
/* U+4062 */ { 0, 0, 0, 0, 0 },
/* U+4063 */ { 0, 0, 0, 0, 0 },
/* U+4064 */ { 0, 0, 0, 0, 0 },
/* U+4065 */ { 0, 0, 0, 0, 0 },
/* U+4066 */ { 0, 0, 0, 0, 0 },
/* U+4067 */ { 0, 0, 0, 0, 0 },
/* U+4068 */ { 0, 0, 0, 0, 0 },
/* U+4069 */ { 0, 0, 0, 0, 0 },
/* U+406a */ { 0, 0, 0, 0, 0 },
/* U+406b */ { 0, 0, 0, 0, 0 },
/* U+406c */ { 0, 0, 0, 0, 0 },
/* U+406d */ { 0, 0, 0, 0, 0 },
/* U+406e */ { 0, 0, 0, 0, 0 },
/* U+406f */ { 0, 0, 0, 0, 0 },
/* U+4070 */ { 0, 0, 0, 0, 0 },
/* U+4071 */ { 0, 0, 0, 0, 0 },
/* U+4072 */ { 0, 0, 0, 0, 0 },
/* U+4073 */ { 0, 0, 0, 0, 0 },
/* U+4074 */ { 0, 0, 0, 0, 0 },
/* U+4075 */ { 0, 0, 0, 0, 0 },
/* U+4076 */ { 0, 0, 0, 0, 0 },
/* U+4077 */ { 0, 0, 0, 0, 0 },
/* U+4078 */ { 0, 0, 0, 0, 0 },
/* U+4079 */ { 0, 0, 0, 0, 0 },
/* U+407a */ { 0, 0, 0, 0, 0 },
/* U+407b */ { 0, 0, 0, 0, 0 },
/* U+407c */ { 0, 0, 0, 0, 0 },
/* U+407d */ { 0, 0, 0, 0, 0 },
/* U+407e */ { 0, 0, 0, 0, 0 },
/* U+407f */ { 0, 0, 0, 0, 0 },
/* U+4080 */ { 0, 0, 0, 0, 0 },
/* U+4081 */ { 0, 0, 0, 0, 0 },
/* U+4082 */ { 0, 0, 0, 0, 0 },
/* U+4083 */ { 0, 0, 0, 0, 0 },
/* U+4084 */ { 0, 0, 0, 0, 0 },
/* U+4085 */ { 0, 0, 0, 0, 0 },
/* U+4086 */ { 0, 0, 0, 0, 0 },
/* U+4087 */ { 0, 0, 0, 0, 0 },
/* U+4088 */ { 0, 0, 0, 0, 0 },
/* U+4089 */ { 0, 0, 0, 0, 0 },
/* U+408a */ { 0, 0, 0, 0, 0 },
/* U+408b */ { 0, 0, 0, 0, 0 },
/* U+408c */ { 0, 0, 0, 0, 0 },
/* U+408d */ { 0, 0, 0, 0, 0 },
/* U+408e */ { 0, 0, 0, 0, 0 },
/* U+408f */ { 0, 0, 0, 0, 0 },
/* U+4090 */ { 0, 0, 0, 0, 0 },
/* U+4091 */ { 0, 0, 0, 0, 0 },
/* U+4092 */ { 0, 0, 0, 0, 0 },
/* U+4093 */ { 0, 0, 0, 0, 0 },
/* U+4094 */ { 0, 0, 0, 0, 0 },
/* U+4095 */ { 0, 0, 0, 0, 0 },
/* U+4096 */ { 0, 0, 0, 0, 0 },
/* U+4097 */ { 0, 0, 0, 0, 0 },
/* U+4098 */ { 0, 0, 0, 0, 0 },
/* U+4099 */ { 0, 0, 0, 0, 0 },
/* U+409a */ { 0, 0, 0, 0, 0 },
/* U+409b */ { 0, 0, 0, 0, 0 },
/* U+409c */ { 0, 0, 0, 0, 0 },
/* U+409d */ { 0, 0, 0, 0, 0 },
/* U+409e */ { 0, 0, 0, 0, 0 },
/* U+409f */ { 0, 0, 0, 0, 0 },
/* U+40a0 */ { 0, 0, 0, 0, 0 },
/* U+40a1 */ { 0, 0, 0, 0, 0 },
/* U+40a2 */ { 0, 0, 0, 0, 0 },
/* U+40a3 */ { 0, 0, 0, 0, 0 },
/* U+40a4 */ { 0, 0, 0, 0, 0 },
/* U+40a5 */ { 0, 0, 0, 0, 0 },
/* U+40a6 */ { 0, 0, 0, 0, 0 },
/* U+40a7 */ { 0, 0, 0, 0, 0 },
/* U+40a8 */ { 0, 0, 0, 0, 0 },
/* U+40a9 */ { 0, 0, 0, 0, 0 },
/* U+40aa */ { 0, 0, 0, 0, 0 },
/* U+40ab */ { 0, 0, 0, 0, 0 },
/* U+40ac */ { 0, 0, 0, 0, 0 },
/* U+40ad */ { 0, 0, 0, 0, 0 },
/* U+40ae */ { 0, 0, 0, 0, 0 },
/* U+40af */ { 0, 0, 0, 0, 0 },
/* U+40b0 */ { 0, 0, 0, 0, 0 },
/* U+40b1 */ { 0, 0, 0, 0, 0 },
/* U+40b2 */ { 0, 0, 0, 0, 0 },
/* U+40b3 */ { 0, 0, 0, 0, 0 },
/* U+40b4 */ { 0, 0, 0, 0, 0 },
/* U+40b5 */ { 0, 0, 0, 0, 0 },
/* U+40b6 */ { 0, 0, 0, 0, 0 },
/* U+40b7 */ { 0, 0, 0, 0, 0 },
/* U+40b8 */ { 0, 0, 0, 0, 0 },
/* U+40b9 */ { 0, 0, 0, 0, 0 },
/* U+40ba */ { 0, 0, 0, 0, 0 },
/* U+40bb */ { 0, 0, 0, 0, 0 },
/* U+40bc */ { 0, 0, 0, 0, 0 },
/* U+40bd */ { 0, 0, 0, 0, 0 },
/* U+40be */ { 0, 0, 0, 0, 0 },
/* U+40bf */ { 0, 0, 0, 0, 0 },
/* U+40c0 */ { 0, 0, 0, 0, 0 },
/* U+40c1 */ { 0, 0, 0, 0, 0 },
/* U+40c2 */ { 0, 0, 0, 0, 0 },
/* U+40c3 */ { 0, 0, 0, 0, 0 },
/* U+40c4 */ { 0, 0, 0, 0, 0 },
/* U+40c5 */ { 0, 0, 0, 0, 0 },
/* U+40c6 */ { 0, 0, 0, 0, 0 },
/* U+40c7 */ { 0, 0, 0, 0, 0 },
/* U+40c8 */ { 0, 0, 0, 0, 0 },
/* U+40c9 */ { 0, 0, 0, 0, 0 },
/* U+40ca */ { 0, 0, 0, 0, 0 },
/* U+40cb */ { 0, 0, 0, 0, 0 },
/* U+40cc */ { 0, 0, 0, 0, 0 },
/* U+40cd */ { 0, 0, 0, 0, 0 },
/* U+40ce */ { 0, 0, 0, 0, 0 },
/* U+40cf */ { 0, 0, 0, 0, 0 },
/* U+40d0 */ { 0, 0, 0, 0, 0 },
/* U+40d1 */ { 0, 0, 0, 0, 0 },
/* U+40d2 */ { 0, 0, 0, 0, 0 },
/* U+40d3 */ { 0, 0, 0, 0, 0 },
/* U+40d4 */ { 0, 0, 0, 0, 0 },
/* U+40d5 */ { 0, 0, 0, 0, 0 },
/* U+40d6 */ { 0, 0, 0, 0, 0 },
/* U+40d7 */ { 0, 0, 0, 0, 0 },
/* U+40d8 */ { 0, 0, 0, 0, 0 },
/* U+40d9 */ { 0, 0, 0, 0, 0 },
/* U+40da */ { 0, 0, 0, 0, 0 },
/* U+40db */ { 0, 0, 0, 0, 0 },
/* U+40dc */ { 0, 0, 0, 0, 0 },
/* U+40dd */ { 0, 0, 0, 0, 0 },
/* U+40de */ { 0, 0, 0, 0, 0 },
/* U+40df */ { 0, 0, 0, 0, 0 },
/* U+40e0 */ { 0, 0, 0, 0, 0 },
/* U+40e1 */ { 0, 0, 0, 0, 0 },
/* U+40e2 */ { 0, 0, 0, 0, 0 },
/* U+40e3 */ { 0, 0, 0, 0, 0 },
/* U+40e4 */ { 0, 0, 0, 0, 0 },
/* U+40e5 */ { 0, 0, 0, 0, 0 },
/* U+40e6 */ { 0, 0, 0, 0, 0 },
/* U+40e7 */ { 0, 0, 0, 0, 0 },
/* U+40e8 */ { 0, 0, 0, 0, 0 },
/* U+40e9 */ { 0, 0, 0, 0, 0 },
/* U+40ea */ { 0, 0, 0, 0, 0 },
/* U+40eb */ { 0, 0, 0, 0, 0 },
/* U+40ec */ { 0, 0, 0, 0, 0 },
/* U+40ed */ { 0, 0, 0, 0, 0 },
/* U+40ee */ { 0, 0, 0, 0, 0 },
/* U+40ef */ { 0, 0, 0, 0, 0 },
/* U+40f0 */ { 0, 0, 0, 0, 0 },
/* U+40f1 */ { 0, 0, 0, 0, 0 },
/* U+40f2 */ { 0, 0, 0, 0, 0 },
/* U+40f3 */ { 0, 0, 0, 0, 0 },
/* U+40f4 */ { 0, 0, 0, 0, 0 },
/* U+40f5 */ { 0, 0, 0, 0, 0 },
/* U+40f6 */ { 0, 0, 0, 0, 0 },
/* U+40f7 */ { 0, 0, 0, 0, 0 },
/* U+40f8 */ { 0, 0, 0, 0, 0 },
/* U+40f9 */ { 0, 0, 0, 0, 0 },
/* U+40fa */ { 0, 0, 0, 0, 0 },
/* U+40fb */ { 0, 0, 0, 0, 0 },
/* U+40fc */ { 0, 0, 0, 0, 0 },
/* U+40fd */ { 0, 0, 0, 0, 0 },
/* U+40fe */ { 0, 0, 0, 0, 0 },
/* U+40ff */ { 0, 0, 0, 0, 0 },
/* U+4100 */ { 0, 0, 0, 0, 0 },
/* U+4101 */ { 0, 0, 0, 0, 0 },
/* U+4102 */ { 0, 0, 0, 0, 0 },
/* U+4103 */ { 0, 0, 0, 0, 0 },
/* U+4104 */ { 0, 0, 0, 0, 0 },
/* U+4105 */ { 0, 0, 0, 0, 0 },
/* U+4106 */ { 0, 0, 0, 0, 0 },
/* U+4107 */ { 0, 0, 0, 0, 0 },
/* U+4108 */ { 0, 0, 0, 0, 0 },
/* U+4109 */ { 0, 0, 0, 0, 0 },
/* U+410a */ { 0, 0, 0, 0, 0 },
/* U+410b */ { 0, 0, 0, 0, 0 },
/* U+410c */ { 0, 0, 0, 0, 0 },
/* U+410d */ { 0, 0, 0, 0, 0 },
/* U+410e */ { 0, 0, 0, 0, 0 },
/* U+410f */ { 0, 0, 0, 0, 0 },
/* U+4110 */ { 0, 0, 0, 0, 0 },
/* U+4111 */ { 0, 0, 0, 0, 0 },
/* U+4112 */ { 0, 0, 0, 0, 0 },
/* U+4113 */ { 0, 0, 0, 0, 0 },
/* U+4114 */ { 0, 0, 0, 0, 0 },
/* U+4115 */ { 0, 0, 0, 0, 0 },
/* U+4116 */ { 0, 0, 0, 0, 0 },
/* U+4117 */ { 0, 0, 0, 0, 0 },
/* U+4118 */ { 0, 0, 0, 0, 0 },
/* U+4119 */ { 0, 0, 0, 0, 0 },
/* U+411a */ { 0, 0, 0, 0, 0 },
/* U+411b */ { 0, 0, 0, 0, 0 },
/* U+411c */ { 0, 0, 0, 0, 0 },
/* U+411d */ { 0, 0, 0, 0, 0 },
/* U+411e */ { 0, 0, 0, 0, 0 },
/* U+411f */ { 0, 0, 0, 0, 0 },
/* U+4120 */ { 0, 0, 0, 0, 0 },
/* U+4121 */ { 0, 0, 0, 0, 0 },
/* U+4122 */ { 0, 0, 0, 0, 0 },
/* U+4123 */ { 0, 0, 0, 0, 0 },
/* U+4124 */ { 0, 0, 0, 0, 0 },
/* U+4125 */ { 0, 0, 0, 0, 0 },
/* U+4126 */ { 0, 0, 0, 0, 0 },
/* U+4127 */ { 0, 0, 0, 0, 0 },
/* U+4128 */ { 0, 0, 0, 0, 0 },
/* U+4129 */ { 0, 0, 0, 0, 0 },
/* U+412a */ { 0, 0, 0, 0, 0 },
/* U+412b */ { 0, 0, 0, 0, 0 },
/* U+412c */ { 0, 0, 0, 0, 0 },
/* U+412d */ { 0, 0, 0, 0, 0 },
/* U+412e */ { 0, 0, 0, 0, 0 },
/* U+412f */ { 0, 0, 0, 0, 0 },
/* U+4130 */ { 0, 0, 0, 0, 0 },
/* U+4131 */ { 0, 0, 0, 0, 0 },
/* U+4132 */ { 0, 0, 0, 0, 0 },
/* U+4133 */ { 0, 0, 0, 0, 0 },
/* U+4134 */ { 0, 0, 0, 0, 0 },
/* U+4135 */ { 0, 0, 0, 0, 0 },
/* U+4136 */ { 0, 0, 0, 0, 0 },
/* U+4137 */ { 0, 0, 0, 0, 0 },
/* U+4138 */ { 0, 0, 0, 0, 0 },
/* U+4139 */ { 0, 0, 0, 0, 0 },
/* U+413a */ { 0, 0, 0, 0, 0 },
/* U+413b */ { 0, 0, 0, 0, 0 },
/* U+413c */ { 0, 0, 0, 0, 0 },
/* U+413d */ { 0, 0, 0, 0, 0 },
/* U+413e */ { 0, 0, 0, 0, 0 },
/* U+413f */ { 0, 0, 0, 0, 0 },
/* U+4140 */ { 0, 0, 0, 0, 0 },
/* U+4141 */ { 0, 0, 0, 0, 0 },
/* U+4142 */ { 0, 0, 0, 0, 0 },
/* U+4143 */ { 0, 0, 0, 0, 0 },
/* U+4144 */ { 0, 0, 0, 0, 0 },
/* U+4145 */ { 0, 0, 0, 0, 0 },
/* U+4146 */ { 0, 0, 0, 0, 0 },
/* U+4147 */ { 0, 0, 0, 0, 0 },
/* U+4148 */ { 0, 0, 0, 0, 0 },
/* U+4149 */ { 0, 0, 0, 0, 0 },
/* U+414a */ { 0, 0, 0, 0, 0 },
/* U+414b */ { 0, 0, 0, 0, 0 },
/* U+414c */ { 0, 0, 0, 0, 0 },
/* U+414d */ { 0, 0, 0, 0, 0 },
/* U+414e */ { 0, 0, 0, 0, 0 },
/* U+414f */ { 0, 0, 0, 0, 0 },
/* U+4150 */ { 0, 0, 0, 0, 0 },
/* U+4151 */ { 0, 0, 0, 0, 0 },
/* U+4152 */ { 0, 0, 0, 0, 0 },
/* U+4153 */ { 0, 0, 0, 0, 0 },
/* U+4154 */ { 0, 0, 0, 0, 0 },
/* U+4155 */ { 0, 0, 0, 0, 0 },
/* U+4156 */ { 0, 0, 0, 0, 0 },
/* U+4157 */ { 0, 0, 0, 0, 0 },
/* U+4158 */ { 0, 0, 0, 0, 0 },
/* U+4159 */ { 0, 0, 0, 0, 0 },
/* U+415a */ { 0, 0, 0, 0, 0 },
/* U+415b */ { 0, 0, 0, 0, 0 },
/* U+415c */ { 0, 0, 0, 0, 0 },
/* U+415d */ { 0, 0, 0, 0, 0 },
/* U+415e */ { 0, 0, 0, 0, 0 },
/* U+415f */ { 0, 0, 0, 0, 0 },
/* U+4160 */ { 0, 0, 0, 0, 0 },
/* U+4161 */ { 0, 0, 0, 0, 0 },
/* U+4162 */ { 0, 0, 0, 0, 0 },
/* U+4163 */ { 0, 0, 0, 0, 0 },
/* U+4164 */ { 0, 0, 0, 0, 0 },
/* U+4165 */ { 0, 0, 0, 0, 0 },
/* U+4166 */ { 0, 0, 0, 0, 0 },
/* U+4167 */ { 0, 0, 0, 0, 0 },
/* U+4168 */ { 0, 0, 0, 0, 0 },
/* U+4169 */ { 0, 0, 0, 0, 0 },
/* U+416a */ { 0, 0, 0, 0, 0 },
/* U+416b */ { 0, 0, 0, 0, 0 },
/* U+416c */ { 0, 0, 0, 0, 0 },
/* U+416d */ { 0, 0, 0, 0, 0 },
/* U+416e */ { 0, 0, 0, 0, 0 },
/* U+416f */ { 0, 0, 0, 0, 0 },
/* U+4170 */ { 0, 0, 0, 0, 0 },
/* U+4171 */ { 0, 0, 0, 0, 0 },
/* U+4172 */ { 0, 0, 0, 0, 0 },
/* U+4173 */ { 0, 0, 0, 0, 0 },
/* U+4174 */ { 0, 0, 0, 0, 0 },
/* U+4175 */ { 0, 0, 0, 0, 0 },
/* U+4176 */ { 0, 0, 0, 0, 0 },
/* U+4177 */ { 0, 0, 0, 0, 0 },
/* U+4178 */ { 0, 0, 0, 0, 0 },
/* U+4179 */ { 0, 0, 0, 0, 0 },
/* U+417a */ { 0, 0, 0, 0, 0 },
/* U+417b */ { 0, 0, 0, 0, 0 },
/* U+417c */ { 0, 0, 0, 0, 0 },
/* U+417d */ { 0, 0, 0, 0, 0 },
/* U+417e */ { 0, 0, 0, 0, 0 },
/* U+417f */ { 0, 0, 0, 0, 0 },
/* U+4180 */ { 0, 0, 0, 0, 0 },
/* U+4181 */ { 0, 0, 0, 0, 0 },
/* U+4182 */ { 0, 0, 0, 0, 0 },
/* U+4183 */ { 0, 0, 0, 0, 0 },
/* U+4184 */ { 0, 0, 0, 0, 0 },
/* U+4185 */ { 0, 0, 0, 0, 0 },
/* U+4186 */ { 0, 0, 0, 0, 0 },
/* U+4187 */ { 0, 0, 0, 0, 0 },
/* U+4188 */ { 0, 0, 0, 0, 0 },
/* U+4189 */ { 0, 0, 0, 0, 0 },
/* U+418a */ { 0, 0, 0, 0, 0 },
/* U+418b */ { 0, 0, 0, 0, 0 },
/* U+418c */ { 0, 0, 0, 0, 0 },
/* U+418d */ { 0, 0, 0, 0, 0 },
/* U+418e */ { 0, 0, 0, 0, 0 },
/* U+418f */ { 0, 0, 0, 0, 0 },
/* U+4190 */ { 0, 0, 0, 0, 0 },
/* U+4191 */ { 0, 0, 0, 0, 0 },
/* U+4192 */ { 0, 0, 0, 0, 0 },
/* U+4193 */ { 0, 0, 0, 0, 0 },
/* U+4194 */ { 0, 0, 0, 0, 0 },
/* U+4195 */ { 0, 0, 0, 0, 0 },
/* U+4196 */ { 0, 0, 0, 0, 0 },
/* U+4197 */ { 0, 0, 0, 0, 0 },
/* U+4198 */ { 0, 0, 0, 0, 0 },
/* U+4199 */ { 0, 0, 0, 0, 0 },
/* U+419a */ { 0, 0, 0, 0, 0 },
/* U+419b */ { 0, 0, 0, 0, 0 },
/* U+419c */ { 0, 0, 0, 0, 0 },
/* U+419d */ { 0, 0, 0, 0, 0 },
/* U+419e */ { 0, 0, 0, 0, 0 },
/* U+419f */ { 0, 0, 0, 0, 0 },
/* U+41a0 */ { 0, 0, 0, 0, 0 },
/* U+41a1 */ { 0, 0, 0, 0, 0 },
/* U+41a2 */ { 0, 0, 0, 0, 0 },
/* U+41a3 */ { 0, 0, 0, 0, 0 },
/* U+41a4 */ { 0, 0, 0, 0, 0 },
/* U+41a5 */ { 0, 0, 0, 0, 0 },
/* U+41a6 */ { 0, 0, 0, 0, 0 },
/* U+41a7 */ { 0, 0, 0, 0, 0 },
/* U+41a8 */ { 0, 0, 0, 0, 0 },
/* U+41a9 */ { 0, 0, 0, 0, 0 },
/* U+41aa */ { 0, 0, 0, 0, 0 },
/* U+41ab */ { 0, 0, 0, 0, 0 },
/* U+41ac */ { 0, 0, 0, 0, 0 },
/* U+41ad */ { 0, 0, 0, 0, 0 },
/* U+41ae */ { 0, 0, 0, 0, 0 },
/* U+41af */ { 0, 0, 0, 0, 0 },
/* U+41b0 */ { 0, 0, 0, 0, 0 },
/* U+41b1 */ { 0, 0, 0, 0, 0 },
/* U+41b2 */ { 0, 0, 0, 0, 0 },
/* U+41b3 */ { 0, 0, 0, 0, 0 },
/* U+41b4 */ { 0, 0, 0, 0, 0 },
/* U+41b5 */ { 0, 0, 0, 0, 0 },
/* U+41b6 */ { 0, 0, 0, 0, 0 },
/* U+41b7 */ { 0, 0, 0, 0, 0 },
/* U+41b8 */ { 0, 0, 0, 0, 0 },
/* U+41b9 */ { 0, 0, 0, 0, 0 },
/* U+41ba */ { 0, 0, 0, 0, 0 },
/* U+41bb */ { 0, 0, 0, 0, 0 },
/* U+41bc */ { 0, 0, 0, 0, 0 },
/* U+41bd */ { 0, 0, 0, 0, 0 },
/* U+41be */ { 0, 0, 0, 0, 0 },
/* U+41bf */ { 0, 0, 0, 0, 0 },
/* U+41c0 */ { 0, 0, 0, 0, 0 },
/* U+41c1 */ { 0, 0, 0, 0, 0 },
/* U+41c2 */ { 0, 0, 0, 0, 0 },
/* U+41c3 */ { 0, 0, 0, 0, 0 },
/* U+41c4 */ { 0, 0, 0, 0, 0 },
/* U+41c5 */ { 0, 0, 0, 0, 0 },
/* U+41c6 */ { 0, 0, 0, 0, 0 },
/* U+41c7 */ { 0, 0, 0, 0, 0 },
/* U+41c8 */ { 0, 0, 0, 0, 0 },
/* U+41c9 */ { 0, 0, 0, 0, 0 },
/* U+41ca */ { 0, 0, 0, 0, 0 },
/* U+41cb */ { 0, 0, 0, 0, 0 },
/* U+41cc */ { 0, 0, 0, 0, 0 },
/* U+41cd */ { 0, 0, 0, 0, 0 },
/* U+41ce */ { 0, 0, 0, 0, 0 },
/* U+41cf */ { 0, 0, 0, 0, 0 },
/* U+41d0 */ { 0, 0, 0, 0, 0 },
/* U+41d1 */ { 0, 0, 0, 0, 0 },
/* U+41d2 */ { 0, 0, 0, 0, 0 },
/* U+41d3 */ { 0, 0, 0, 0, 0 },
/* U+41d4 */ { 0, 0, 0, 0, 0 },
/* U+41d5 */ { 0, 0, 0, 0, 0 },
/* U+41d6 */ { 0, 0, 0, 0, 0 },
/* U+41d7 */ { 0, 0, 0, 0, 0 },
/* U+41d8 */ { 0, 0, 0, 0, 0 },
/* U+41d9 */ { 0, 0, 0, 0, 0 },
/* U+41da */ { 0, 0, 0, 0, 0 },
/* U+41db */ { 0, 0, 0, 0, 0 },
/* U+41dc */ { 0, 0, 0, 0, 0 },
/* U+41dd */ { 0, 0, 0, 0, 0 },
/* U+41de */ { 0, 0, 0, 0, 0 },
/* U+41df */ { 0, 0, 0, 0, 0 },
/* U+41e0 */ { 0, 0, 0, 0, 0 },
/* U+41e1 */ { 0, 0, 0, 0, 0 },
/* U+41e2 */ { 0, 0, 0, 0, 0 },
/* U+41e3 */ { 0, 0, 0, 0, 0 },
/* U+41e4 */ { 0, 0, 0, 0, 0 },
/* U+41e5 */ { 0, 0, 0, 0, 0 },
/* U+41e6 */ { 0, 0, 0, 0, 0 },
/* U+41e7 */ { 0, 0, 0, 0, 0 },
/* U+41e8 */ { 0, 0, 0, 0, 0 },
/* U+41e9 */ { 0, 0, 0, 0, 0 },
/* U+41ea */ { 0, 0, 0, 0, 0 },
/* U+41eb */ { 0, 0, 0, 0, 0 },
/* U+41ec */ { 0, 0, 0, 0, 0 },
/* U+41ed */ { 0, 0, 0, 0, 0 },
/* U+41ee */ { 0, 0, 0, 0, 0 },
/* U+41ef */ { 0, 0, 0, 0, 0 },
/* U+41f0 */ { 0, 0, 0, 0, 0 },
/* U+41f1 */ { 0, 0, 0, 0, 0 },
/* U+41f2 */ { 0, 0, 0, 0, 0 },
/* U+41f3 */ { 0, 0, 0, 0, 0 },
/* U+41f4 */ { 0, 0, 0, 0, 0 },
/* U+41f5 */ { 0, 0, 0, 0, 0 },
/* U+41f6 */ { 0, 0, 0, 0, 0 },
/* U+41f7 */ { 0, 0, 0, 0, 0 },
/* U+41f8 */ { 0, 0, 0, 0, 0 },
/* U+41f9 */ { 0, 0, 0, 0, 0 },
/* U+41fa */ { 0, 0, 0, 0, 0 },
/* U+41fb */ { 0, 0, 0, 0, 0 },
/* U+41fc */ { 0, 0, 0, 0, 0 },
/* U+41fd */ { 0, 0, 0, 0, 0 },
/* U+41fe */ { 0, 0, 0, 0, 0 },
/* U+41ff */ { 0, 0, 0, 0, 0 },
/* U+4200 */ { 0, 0, 0, 0, 0 },
/* U+4201 */ { 0, 0, 0, 0, 0 },
/* U+4202 */ { 0, 0, 0, 0, 0 },
/* U+4203 */ { 0, 0, 0, 0, 0 },
/* U+4204 */ { 0, 0, 0, 0, 0 },
/* U+4205 */ { 0, 0, 0, 0, 0 },
/* U+4206 */ { 0, 0, 0, 0, 0 },
/* U+4207 */ { 0, 0, 0, 0, 0 },
/* U+4208 */ { 0, 0, 0, 0, 0 },
/* U+4209 */ { 0, 0, 0, 0, 0 },
/* U+420a */ { 0, 0, 0, 0, 0 },
/* U+420b */ { 0, 0, 0, 0, 0 },
/* U+420c */ { 0, 0, 0, 0, 0 },
/* U+420d */ { 0, 0, 0, 0, 0 },
/* U+420e */ { 0, 0, 0, 0, 0 },
/* U+420f */ { 0, 0, 0, 0, 0 },
/* U+4210 */ { 0, 0, 0, 0, 0 },
/* U+4211 */ { 0, 0, 0, 0, 0 },
/* U+4212 */ { 0, 0, 0, 0, 0 },
/* U+4213 */ { 0, 0, 0, 0, 0 },
/* U+4214 */ { 0, 0, 0, 0, 0 },
/* U+4215 */ { 0, 0, 0, 0, 0 },
/* U+4216 */ { 0, 0, 0, 0, 0 },
/* U+4217 */ { 0, 0, 0, 0, 0 },
/* U+4218 */ { 0, 0, 0, 0, 0 },
/* U+4219 */ { 0, 0, 0, 0, 0 },
/* U+421a */ { 0, 0, 0, 0, 0 },
/* U+421b */ { 0, 0, 0, 0, 0 },
/* U+421c */ { 0, 0, 0, 0, 0 },
/* U+421d */ { 0, 0, 0, 0, 0 },
/* U+421e */ { 0, 0, 0, 0, 0 },
/* U+421f */ { 0, 0, 0, 0, 0 },
/* U+4220 */ { 0, 0, 0, 0, 0 },
/* U+4221 */ { 0, 0, 0, 0, 0 },
/* U+4222 */ { 0, 0, 0, 0, 0 },
/* U+4223 */ { 0, 0, 0, 0, 0 },
/* U+4224 */ { 0, 0, 0, 0, 0 },
/* U+4225 */ { 0, 0, 0, 0, 0 },
/* U+4226 */ { 0, 0, 0, 0, 0 },
/* U+4227 */ { 0, 0, 0, 0, 0 },
/* U+4228 */ { 0, 0, 0, 0, 0 },
/* U+4229 */ { 0, 0, 0, 0, 0 },
/* U+422a */ { 0, 0, 0, 0, 0 },
/* U+422b */ { 0, 0, 0, 0, 0 },
/* U+422c */ { 0, 0, 0, 0, 0 },
/* U+422d */ { 0, 0, 0, 0, 0 },
/* U+422e */ { 0, 0, 0, 0, 0 },
/* U+422f */ { 0, 0, 0, 0, 0 },
/* U+4230 */ { 0, 0, 0, 0, 0 },
/* U+4231 */ { 0, 0, 0, 0, 0 },
/* U+4232 */ { 0, 0, 0, 0, 0 },
/* U+4233 */ { 0, 0, 0, 0, 0 },
/* U+4234 */ { 0, 0, 0, 0, 0 },
/* U+4235 */ { 0, 0, 0, 0, 0 },
/* U+4236 */ { 0, 0, 0, 0, 0 },
/* U+4237 */ { 0, 0, 0, 0, 0 },
/* U+4238 */ { 0, 0, 0, 0, 0 },
/* U+4239 */ { 0, 0, 0, 0, 0 },
/* U+423a */ { 0, 0, 0, 0, 0 },
/* U+423b */ { 0, 0, 0, 0, 0 },
/* U+423c */ { 0, 0, 0, 0, 0 },
/* U+423d */ { 0, 0, 0, 0, 0 },
/* U+423e */ { 0, 0, 0, 0, 0 },
/* U+423f */ { 0, 0, 0, 0, 0 },
/* U+4240 */ { 0, 0, 0, 0, 0 },
/* U+4241 */ { 0, 0, 0, 0, 0 },
/* U+4242 */ { 0, 0, 0, 0, 0 },
/* U+4243 */ { 0, 0, 0, 0, 0 },
/* U+4244 */ { 0, 0, 0, 0, 0 },
/* U+4245 */ { 0, 0, 0, 0, 0 },
/* U+4246 */ { 0, 0, 0, 0, 0 },
/* U+4247 */ { 0, 0, 0, 0, 0 },
/* U+4248 */ { 0, 0, 0, 0, 0 },
/* U+4249 */ { 0, 0, 0, 0, 0 },
/* U+424a */ { 0, 0, 0, 0, 0 },
/* U+424b */ { 0, 0, 0, 0, 0 },
/* U+424c */ { 0, 0, 0, 0, 0 },
/* U+424d */ { 0, 0, 0, 0, 0 },
/* U+424e */ { 0, 0, 0, 0, 0 },
/* U+424f */ { 0, 0, 0, 0, 0 },
/* U+4250 */ { 0, 0, 0, 0, 0 },
/* U+4251 */ { 0, 0, 0, 0, 0 },
/* U+4252 */ { 0, 0, 0, 0, 0 },
/* U+4253 */ { 0, 0, 0, 0, 0 },
/* U+4254 */ { 0, 0, 0, 0, 0 },
/* U+4255 */ { 0, 0, 0, 0, 0 },
/* U+4256 */ { 0, 0, 0, 0, 0 },
/* U+4257 */ { 0, 0, 0, 0, 0 },
/* U+4258 */ { 0, 0, 0, 0, 0 },
/* U+4259 */ { 0, 0, 0, 0, 0 },
/* U+425a */ { 0, 0, 0, 0, 0 },
/* U+425b */ { 0, 0, 0, 0, 0 },
/* U+425c */ { 0, 0, 0, 0, 0 },
/* U+425d */ { 0, 0, 0, 0, 0 },
/* U+425e */ { 0, 0, 0, 0, 0 },
/* U+425f */ { 0, 0, 0, 0, 0 },
/* U+4260 */ { 0, 0, 0, 0, 0 },
/* U+4261 */ { 0, 0, 0, 0, 0 },
/* U+4262 */ { 0, 0, 0, 0, 0 },
/* U+4263 */ { 0, 0, 0, 0, 0 },
/* U+4264 */ { 0, 0, 0, 0, 0 },
/* U+4265 */ { 0, 0, 0, 0, 0 },
/* U+4266 */ { 0, 0, 0, 0, 0 },
/* U+4267 */ { 0, 0, 0, 0, 0 },
/* U+4268 */ { 0, 0, 0, 0, 0 },
/* U+4269 */ { 0, 0, 0, 0, 0 },
/* U+426a */ { 0, 0, 0, 0, 0 },
/* U+426b */ { 0, 0, 0, 0, 0 },
/* U+426c */ { 0, 0, 0, 0, 0 },
/* U+426d */ { 0, 0, 0, 0, 0 },
/* U+426e */ { 0, 0, 0, 0, 0 },
/* U+426f */ { 0, 0, 0, 0, 0 },
/* U+4270 */ { 0, 0, 0, 0, 0 },
/* U+4271 */ { 0, 0, 0, 0, 0 },
/* U+4272 */ { 0, 0, 0, 0, 0 },
/* U+4273 */ { 0, 0, 0, 0, 0 },
/* U+4274 */ { 0, 0, 0, 0, 0 },
/* U+4275 */ { 0, 0, 0, 0, 0 },
/* U+4276 */ { 0, 0, 0, 0, 0 },
/* U+4277 */ { 0, 0, 0, 0, 0 },
/* U+4278 */ { 0, 0, 0, 0, 0 },
/* U+4279 */ { 0, 0, 0, 0, 0 },
/* U+427a */ { 0, 0, 0, 0, 0 },
/* U+427b */ { 0, 0, 0, 0, 0 },
/* U+427c */ { 0, 0, 0, 0, 0 },
/* U+427d */ { 0, 0, 0, 0, 0 },
/* U+427e */ { 0, 0, 0, 0, 0 },
/* U+427f */ { 0, 0, 0, 0, 0 },
/* U+4280 */ { 0, 0, 0, 0, 0 },
/* U+4281 */ { 0, 0, 0, 0, 0 },
/* U+4282 */ { 0, 0, 0, 0, 0 },
/* U+4283 */ { 0, 0, 0, 0, 0 },
/* U+4284 */ { 0, 0, 0, 0, 0 },
/* U+4285 */ { 0, 0, 0, 0, 0 },
/* U+4286 */ { 0, 0, 0, 0, 0 },
/* U+4287 */ { 0, 0, 0, 0, 0 },
/* U+4288 */ { 0, 0, 0, 0, 0 },
/* U+4289 */ { 0, 0, 0, 0, 0 },
/* U+428a */ { 0, 0, 0, 0, 0 },
/* U+428b */ { 0, 0, 0, 0, 0 },
/* U+428c */ { 0, 0, 0, 0, 0 },
/* U+428d */ { 0, 0, 0, 0, 0 },
/* U+428e */ { 0, 0, 0, 0, 0 },
/* U+428f */ { 0, 0, 0, 0, 0 },
/* U+4290 */ { 0, 0, 0, 0, 0 },
/* U+4291 */ { 0, 0, 0, 0, 0 },
/* U+4292 */ { 0, 0, 0, 0, 0 },
/* U+4293 */ { 0, 0, 0, 0, 0 },
/* U+4294 */ { 0, 0, 0, 0, 0 },
/* U+4295 */ { 0, 0, 0, 0, 0 },
/* U+4296 */ { 0, 0, 0, 0, 0 },
/* U+4297 */ { 0, 0, 0, 0, 0 },
/* U+4298 */ { 0, 0, 0, 0, 0 },
/* U+4299 */ { 0, 0, 0, 0, 0 },
/* U+429a */ { 0, 0, 0, 0, 0 },
/* U+429b */ { 0, 0, 0, 0, 0 },
/* U+429c */ { 0, 0, 0, 0, 0 },
/* U+429d */ { 0, 0, 0, 0, 0 },
/* U+429e */ { 0, 0, 0, 0, 0 },
/* U+429f */ { 0, 0, 0, 0, 0 },
/* U+42a0 */ { 0, 0, 0, 0, 0 },
/* U+42a1 */ { 0, 0, 0, 0, 0 },
/* U+42a2 */ { 0, 0, 0, 0, 0 },
/* U+42a3 */ { 0, 0, 0, 0, 0 },
/* U+42a4 */ { 0, 0, 0, 0, 0 },
/* U+42a5 */ { 0, 0, 0, 0, 0 },
/* U+42a6 */ { 0, 0, 0, 0, 0 },
/* U+42a7 */ { 0, 0, 0, 0, 0 },
/* U+42a8 */ { 0, 0, 0, 0, 0 },
/* U+42a9 */ { 0, 0, 0, 0, 0 },
/* U+42aa */ { 0, 0, 0, 0, 0 },
/* U+42ab */ { 0, 0, 0, 0, 0 },
/* U+42ac */ { 0, 0, 0, 0, 0 },
/* U+42ad */ { 0, 0, 0, 0, 0 },
/* U+42ae */ { 0, 0, 0, 0, 0 },
/* U+42af */ { 0, 0, 0, 0, 0 },
/* U+42b0 */ { 0, 0, 0, 0, 0 },
/* U+42b1 */ { 0, 0, 0, 0, 0 },
/* U+42b2 */ { 0, 0, 0, 0, 0 },
/* U+42b3 */ { 0, 0, 0, 0, 0 },
/* U+42b4 */ { 0, 0, 0, 0, 0 },
/* U+42b5 */ { 0, 0, 0, 0, 0 },
/* U+42b6 */ { 0, 0, 0, 0, 0 },
/* U+42b7 */ { 0, 0, 0, 0, 0 },
/* U+42b8 */ { 0, 0, 0, 0, 0 },
/* U+42b9 */ { 0, 0, 0, 0, 0 },
/* U+42ba */ { 0, 0, 0, 0, 0 },
/* U+42bb */ { 0, 0, 0, 0, 0 },
/* U+42bc */ { 0, 0, 0, 0, 0 },
/* U+42bd */ { 0, 0, 0, 0, 0 },
/* U+42be */ { 0, 0, 0, 0, 0 },
/* U+42bf */ { 0, 0, 0, 0, 0 },
/* U+42c0 */ { 0, 0, 0, 0, 0 },
/* U+42c1 */ { 0, 0, 0, 0, 0 },
/* U+42c2 */ { 0, 0, 0, 0, 0 },
/* U+42c3 */ { 0, 0, 0, 0, 0 },
/* U+42c4 */ { 0, 0, 0, 0, 0 },
/* U+42c5 */ { 0, 0, 0, 0, 0 },
/* U+42c6 */ { 0, 0, 0, 0, 0 },
/* U+42c7 */ { 0, 0, 0, 0, 0 },
/* U+42c8 */ { 0, 0, 0, 0, 0 },
/* U+42c9 */ { 0, 0, 0, 0, 0 },
/* U+42ca */ { 0, 0, 0, 0, 0 },
/* U+42cb */ { 0, 0, 0, 0, 0 },
/* U+42cc */ { 0, 0, 0, 0, 0 },
/* U+42cd */ { 0, 0, 0, 0, 0 },
/* U+42ce */ { 0, 0, 0, 0, 0 },
/* U+42cf */ { 0, 0, 0, 0, 0 },
/* U+42d0 */ { 0, 0, 0, 0, 0 },
/* U+42d1 */ { 0, 0, 0, 0, 0 },
/* U+42d2 */ { 0, 0, 0, 0, 0 },
/* U+42d3 */ { 0, 0, 0, 0, 0 },
/* U+42d4 */ { 0, 0, 0, 0, 0 },
/* U+42d5 */ { 0, 0, 0, 0, 0 },
/* U+42d6 */ { 0, 0, 0, 0, 0 },
/* U+42d7 */ { 0, 0, 0, 0, 0 },
/* U+42d8 */ { 0, 0, 0, 0, 0 },
/* U+42d9 */ { 0, 0, 0, 0, 0 },
/* U+42da */ { 0, 0, 0, 0, 0 },
/* U+42db */ { 0, 0, 0, 0, 0 },
/* U+42dc */ { 0, 0, 0, 0, 0 },
/* U+42dd */ { 0, 0, 0, 0, 0 },
/* U+42de */ { 0, 0, 0, 0, 0 },
/* U+42df */ { 0, 0, 0, 0, 0 },
/* U+42e0 */ { 0, 0, 0, 0, 0 },
/* U+42e1 */ { 0, 0, 0, 0, 0 },
/* U+42e2 */ { 0, 0, 0, 0, 0 },
/* U+42e3 */ { 0, 0, 0, 0, 0 },
/* U+42e4 */ { 0, 0, 0, 0, 0 },
/* U+42e5 */ { 0, 0, 0, 0, 0 },
/* U+42e6 */ { 0, 0, 0, 0, 0 },
/* U+42e7 */ { 0, 0, 0, 0, 0 },
/* U+42e8 */ { 0, 0, 0, 0, 0 },
/* U+42e9 */ { 0, 0, 0, 0, 0 },
/* U+42ea */ { 0, 0, 0, 0, 0 },
/* U+42eb */ { 0, 0, 0, 0, 0 },
/* U+42ec */ { 0, 0, 0, 0, 0 },
/* U+42ed */ { 0, 0, 0, 0, 0 },
/* U+42ee */ { 0, 0, 0, 0, 0 },
/* U+42ef */ { 0, 0, 0, 0, 0 },
/* U+42f0 */ { 0, 0, 0, 0, 0 },
/* U+42f1 */ { 0, 0, 0, 0, 0 },
/* U+42f2 */ { 0, 0, 0, 0, 0 },
/* U+42f3 */ { 0, 0, 0, 0, 0 },
/* U+42f4 */ { 0, 0, 0, 0, 0 },
/* U+42f5 */ { 0, 0, 0, 0, 0 },
/* U+42f6 */ { 0, 0, 0, 0, 0 },
/* U+42f7 */ { 0, 0, 0, 0, 0 },
/* U+42f8 */ { 0, 0, 0, 0, 0 },
/* U+42f9 */ { 0, 0, 0, 0, 0 },
/* U+42fa */ { 0, 0, 0, 0, 0 },
/* U+42fb */ { 0, 0, 0, 0, 0 },
/* U+42fc */ { 0, 0, 0, 0, 0 },
/* U+42fd */ { 0, 0, 0, 0, 0 },
/* U+42fe */ { 0, 0, 0, 0, 0 },
/* U+42ff */ { 0, 0, 0, 0, 0 },
/* U+4300 */ { 0, 0, 0, 0, 0 },
/* U+4301 */ { 0, 0, 0, 0, 0 },
/* U+4302 */ { 0, 0, 0, 0, 0 },
/* U+4303 */ { 0, 0, 0, 0, 0 },
/* U+4304 */ { 0, 0, 0, 0, 0 },
/* U+4305 */ { 0, 0, 0, 0, 0 },
/* U+4306 */ { 0, 0, 0, 0, 0 },
/* U+4307 */ { 0, 0, 0, 0, 0 },
/* U+4308 */ { 0, 0, 0, 0, 0 },
/* U+4309 */ { 0, 0, 0, 0, 0 },
/* U+430a */ { 0, 0, 0, 0, 0 },
/* U+430b */ { 0, 0, 0, 0, 0 },
/* U+430c */ { 0, 0, 0, 0, 0 },
/* U+430d */ { 0, 0, 0, 0, 0 },
/* U+430e */ { 0, 0, 0, 0, 0 },
/* U+430f */ { 0, 0, 0, 0, 0 },
/* U+4310 */ { 0, 0, 0, 0, 0 },
/* U+4311 */ { 0, 0, 0, 0, 0 },
/* U+4312 */ { 0, 0, 0, 0, 0 },
/* U+4313 */ { 0, 0, 0, 0, 0 },
/* U+4314 */ { 0, 0, 0, 0, 0 },
/* U+4315 */ { 0, 0, 0, 0, 0 },
/* U+4316 */ { 0, 0, 0, 0, 0 },
/* U+4317 */ { 0, 0, 0, 0, 0 },
/* U+4318 */ { 0, 0, 0, 0, 0 },
/* U+4319 */ { 0, 0, 0, 0, 0 },
/* U+431a */ { 0, 0, 0, 0, 0 },
/* U+431b */ { 0, 0, 0, 0, 0 },
/* U+431c */ { 0, 0, 0, 0, 0 },
/* U+431d */ { 0, 0, 0, 0, 0 },
/* U+431e */ { 0, 0, 0, 0, 0 },
/* U+431f */ { 0, 0, 0, 0, 0 },
/* U+4320 */ { 0, 0, 0, 0, 0 },
/* U+4321 */ { 0, 0, 0, 0, 0 },
/* U+4322 */ { 0, 0, 0, 0, 0 },
/* U+4323 */ { 0, 0, 0, 0, 0 },
/* U+4324 */ { 0, 0, 0, 0, 0 },
/* U+4325 */ { 0, 0, 0, 0, 0 },
/* U+4326 */ { 0, 0, 0, 0, 0 },
/* U+4327 */ { 0, 0, 0, 0, 0 },
/* U+4328 */ { 0, 0, 0, 0, 0 },
/* U+4329 */ { 0, 0, 0, 0, 0 },
/* U+432a */ { 0, 0, 0, 0, 0 },
/* U+432b */ { 0, 0, 0, 0, 0 },
/* U+432c */ { 0, 0, 0, 0, 0 },
/* U+432d */ { 0, 0, 0, 0, 0 },
/* U+432e */ { 0, 0, 0, 0, 0 },
/* U+432f */ { 0, 0, 0, 0, 0 },
/* U+4330 */ { 0, 0, 0, 0, 0 },
/* U+4331 */ { 0, 0, 0, 0, 0 },
/* U+4332 */ { 0, 0, 0, 0, 0 },
/* U+4333 */ { 0, 0, 0, 0, 0 },
/* U+4334 */ { 0, 0, 0, 0, 0 },
/* U+4335 */ { 0, 0, 0, 0, 0 },
/* U+4336 */ { 0, 0, 0, 0, 0 },
/* U+4337 */ { 0, 0, 0, 0, 0 },
/* U+4338 */ { 0, 0, 0, 0, 0 },
/* U+4339 */ { 0, 0, 0, 0, 0 },
/* U+433a */ { 0, 0, 0, 0, 0 },
/* U+433b */ { 0, 0, 0, 0, 0 },
/* U+433c */ { 0, 0, 0, 0, 0 },
/* U+433d */ { 0, 0, 0, 0, 0 },
/* U+433e */ { 0, 0, 0, 0, 0 },
/* U+433f */ { 0, 0, 0, 0, 0 },
/* U+4340 */ { 0, 0, 0, 0, 0 },
/* U+4341 */ { 0, 0, 0, 0, 0 },
/* U+4342 */ { 0, 0, 0, 0, 0 },
/* U+4343 */ { 0, 0, 0, 0, 0 },
/* U+4344 */ { 0, 0, 0, 0, 0 },
/* U+4345 */ { 0, 0, 0, 0, 0 },
/* U+4346 */ { 0, 0, 0, 0, 0 },
/* U+4347 */ { 0, 0, 0, 0, 0 },
/* U+4348 */ { 0, 0, 0, 0, 0 },
/* U+4349 */ { 0, 0, 0, 0, 0 },
/* U+434a */ { 0, 0, 0, 0, 0 },
/* U+434b */ { 0, 0, 0, 0, 0 },
/* U+434c */ { 0, 0, 0, 0, 0 },
/* U+434d */ { 0, 0, 0, 0, 0 },
/* U+434e */ { 0, 0, 0, 0, 0 },
/* U+434f */ { 0, 0, 0, 0, 0 },
/* U+4350 */ { 0, 0, 0, 0, 0 },
/* U+4351 */ { 0, 0, 0, 0, 0 },
/* U+4352 */ { 0, 0, 0, 0, 0 },
/* U+4353 */ { 0, 0, 0, 0, 0 },
/* U+4354 */ { 0, 0, 0, 0, 0 },
/* U+4355 */ { 0, 0, 0, 0, 0 },
/* U+4356 */ { 0, 0, 0, 0, 0 },
/* U+4357 */ { 0, 0, 0, 0, 0 },
/* U+4358 */ { 0, 0, 0, 0, 0 },
/* U+4359 */ { 0, 0, 0, 0, 0 },
/* U+435a */ { 0, 0, 0, 0, 0 },
/* U+435b */ { 0, 0, 0, 0, 0 },
/* U+435c */ { 0, 0, 0, 0, 0 },
/* U+435d */ { 0, 0, 0, 0, 0 },
/* U+435e */ { 0, 0, 0, 0, 0 },
/* U+435f */ { 0, 0, 0, 0, 0 },
/* U+4360 */ { 0, 0, 0, 0, 0 },
/* U+4361 */ { 0, 0, 0, 0, 0 },
/* U+4362 */ { 0, 0, 0, 0, 0 },
/* U+4363 */ { 0, 0, 0, 0, 0 },
/* U+4364 */ { 0, 0, 0, 0, 0 },
/* U+4365 */ { 0, 0, 0, 0, 0 },
/* U+4366 */ { 0, 0, 0, 0, 0 },
/* U+4367 */ { 0, 0, 0, 0, 0 },
/* U+4368 */ { 0, 0, 0, 0, 0 },
/* U+4369 */ { 0, 0, 0, 0, 0 },
/* U+436a */ { 0, 0, 0, 0, 0 },
/* U+436b */ { 0, 0, 0, 0, 0 },
/* U+436c */ { 0, 0, 0, 0, 0 },
/* U+436d */ { 0, 0, 0, 0, 0 },
/* U+436e */ { 0, 0, 0, 0, 0 },
/* U+436f */ { 0, 0, 0, 0, 0 },
/* U+4370 */ { 0, 0, 0, 0, 0 },
/* U+4371 */ { 0, 0, 0, 0, 0 },
/* U+4372 */ { 0, 0, 0, 0, 0 },
/* U+4373 */ { 0, 0, 0, 0, 0 },
/* U+4374 */ { 0, 0, 0, 0, 0 },
/* U+4375 */ { 0, 0, 0, 0, 0 },
/* U+4376 */ { 0, 0, 0, 0, 0 },
/* U+4377 */ { 0, 0, 0, 0, 0 },
/* U+4378 */ { 0, 0, 0, 0, 0 },
/* U+4379 */ { 0, 0, 0, 0, 0 },
/* U+437a */ { 0, 0, 0, 0, 0 },
/* U+437b */ { 0, 0, 0, 0, 0 },
/* U+437c */ { 0, 0, 0, 0, 0 },
/* U+437d */ { 0, 0, 0, 0, 0 },
/* U+437e */ { 0, 0, 0, 0, 0 },
/* U+437f */ { 0, 0, 0, 0, 0 },
/* U+4380 */ { 0, 0, 0, 0, 0 },
/* U+4381 */ { 0, 0, 0, 0, 0 },
/* U+4382 */ { 0, 0, 0, 0, 0 },
/* U+4383 */ { 0, 0, 0, 0, 0 },
/* U+4384 */ { 0, 0, 0, 0, 0 },
/* U+4385 */ { 0, 0, 0, 0, 0 },
/* U+4386 */ { 0, 0, 0, 0, 0 },
/* U+4387 */ { 0, 0, 0, 0, 0 },
/* U+4388 */ { 0, 0, 0, 0, 0 },
/* U+4389 */ { 0, 0, 0, 0, 0 },
/* U+438a */ { 0, 0, 0, 0, 0 },
/* U+438b */ { 0, 0, 0, 0, 0 },
/* U+438c */ { 0, 0, 0, 0, 0 },
/* U+438d */ { 0, 0, 0, 0, 0 },
/* U+438e */ { 0, 0, 0, 0, 0 },
/* U+438f */ { 0, 0, 0, 0, 0 },
/* U+4390 */ { 0, 0, 0, 0, 0 },
/* U+4391 */ { 0, 0, 0, 0, 0 },
/* U+4392 */ { 0, 0, 0, 0, 0 },
/* U+4393 */ { 0, 0, 0, 0, 0 },
/* U+4394 */ { 0, 0, 0, 0, 0 },
/* U+4395 */ { 0, 0, 0, 0, 0 },
/* U+4396 */ { 0, 0, 0, 0, 0 },
/* U+4397 */ { 0, 0, 0, 0, 0 },
/* U+4398 */ { 0, 0, 0, 0, 0 },
/* U+4399 */ { 0, 0, 0, 0, 0 },
/* U+439a */ { 0, 0, 0, 0, 0 },
/* U+439b */ { 0, 0, 0, 0, 0 },
/* U+439c */ { 0, 0, 0, 0, 0 },
/* U+439d */ { 0, 0, 0, 0, 0 },
/* U+439e */ { 0, 0, 0, 0, 0 },
/* U+439f */ { 0, 0, 0, 0, 0 },
/* U+43a0 */ { 0, 0, 0, 0, 0 },
/* U+43a1 */ { 0, 0, 0, 0, 0 },
/* U+43a2 */ { 0, 0, 0, 0, 0 },
/* U+43a3 */ { 0, 0, 0, 0, 0 },
/* U+43a4 */ { 0, 0, 0, 0, 0 },
/* U+43a5 */ { 0, 0, 0, 0, 0 },
/* U+43a6 */ { 0, 0, 0, 0, 0 },
/* U+43a7 */ { 0, 0, 0, 0, 0 },
/* U+43a8 */ { 0, 0, 0, 0, 0 },
/* U+43a9 */ { 0, 0, 0, 0, 0 },
/* U+43aa */ { 0, 0, 0, 0, 0 },
/* U+43ab */ { 0, 0, 0, 0, 0 },
/* U+43ac */ { 0, 0, 0, 0, 0 },
/* U+43ad */ { 0, 0, 0, 0, 0 },
/* U+43ae */ { 0, 0, 0, 0, 0 },
/* U+43af */ { 0, 0, 0, 0, 0 },
/* U+43b0 */ { 0, 0, 0, 0, 0 },
/* U+43b1 */ { 0, 0, 0, 0, 0 },
/* U+43b2 */ { 0, 0, 0, 0, 0 },
/* U+43b3 */ { 0, 0, 0, 0, 0 },
/* U+43b4 */ { 0, 0, 0, 0, 0 },
/* U+43b5 */ { 0, 0, 0, 0, 0 },
/* U+43b6 */ { 0, 0, 0, 0, 0 },
/* U+43b7 */ { 0, 0, 0, 0, 0 },
/* U+43b8 */ { 0, 0, 0, 0, 0 },
/* U+43b9 */ { 0, 0, 0, 0, 0 },
/* U+43ba */ { 0, 0, 0, 0, 0 },
/* U+43bb */ { 0, 0, 0, 0, 0 },
/* U+43bc */ { 0, 0, 0, 0, 0 },
/* U+43bd */ { 0, 0, 0, 0, 0 },
/* U+43be */ { 0, 0, 0, 0, 0 },
/* U+43bf */ { 0, 0, 0, 0, 0 },
/* U+43c0 */ { 0, 0, 0, 0, 0 },
/* U+43c1 */ { 0, 0, 0, 0, 0 },
/* U+43c2 */ { 0, 0, 0, 0, 0 },
/* U+43c3 */ { 0, 0, 0, 0, 0 },
/* U+43c4 */ { 0, 0, 0, 0, 0 },
/* U+43c5 */ { 0, 0, 0, 0, 0 },
/* U+43c6 */ { 0, 0, 0, 0, 0 },
/* U+43c7 */ { 0, 0, 0, 0, 0 },
/* U+43c8 */ { 0, 0, 0, 0, 0 },
/* U+43c9 */ { 0, 0, 0, 0, 0 },
/* U+43ca */ { 0, 0, 0, 0, 0 },
/* U+43cb */ { 0, 0, 0, 0, 0 },
/* U+43cc */ { 0, 0, 0, 0, 0 },
/* U+43cd */ { 0, 0, 0, 0, 0 },
/* U+43ce */ { 0, 0, 0, 0, 0 },
/* U+43cf */ { 0, 0, 0, 0, 0 },
/* U+43d0 */ { 0, 0, 0, 0, 0 },
/* U+43d1 */ { 0, 0, 0, 0, 0 },
/* U+43d2 */ { 0, 0, 0, 0, 0 },
/* U+43d3 */ { 0, 0, 0, 0, 0 },
/* U+43d4 */ { 0, 0, 0, 0, 0 },
/* U+43d5 */ { 0, 0, 0, 0, 0 },
/* U+43d6 */ { 0, 0, 0, 0, 0 },
/* U+43d7 */ { 0, 0, 0, 0, 0 },
/* U+43d8 */ { 0, 0, 0, 0, 0 },
/* U+43d9 */ { 0, 0, 0, 0, 0 },
/* U+43da */ { 0, 0, 0, 0, 0 },
/* U+43db */ { 0, 0, 0, 0, 0 },
/* U+43dc */ { 0, 0, 0, 0, 0 },
/* U+43dd */ { 0, 0, 0, 0, 0 },
/* U+43de */ { 0, 0, 0, 0, 0 },
/* U+43df */ { 0, 0, 0, 0, 0 },
/* U+43e0 */ { 0, 0, 0, 0, 0 },
/* U+43e1 */ { 0, 0, 0, 0, 0 },
/* U+43e2 */ { 0, 0, 0, 0, 0 },
/* U+43e3 */ { 0, 0, 0, 0, 0 },
/* U+43e4 */ { 0, 0, 0, 0, 0 },
/* U+43e5 */ { 0, 0, 0, 0, 0 },
/* U+43e6 */ { 0, 0, 0, 0, 0 },
/* U+43e7 */ { 0, 0, 0, 0, 0 },
/* U+43e8 */ { 0, 0, 0, 0, 0 },
/* U+43e9 */ { 0, 0, 0, 0, 0 },
/* U+43ea */ { 0, 0, 0, 0, 0 },
/* U+43eb */ { 0, 0, 0, 0, 0 },
/* U+43ec */ { 0, 0, 0, 0, 0 },
/* U+43ed */ { 0, 0, 0, 0, 0 },
/* U+43ee */ { 0, 0, 0, 0, 0 },
/* U+43ef */ { 0, 0, 0, 0, 0 },
/* U+43f0 */ { 0, 0, 0, 0, 0 },
/* U+43f1 */ { 0, 0, 0, 0, 0 },
/* U+43f2 */ { 0, 0, 0, 0, 0 },
/* U+43f3 */ { 0, 0, 0, 0, 0 },
/* U+43f4 */ { 0, 0, 0, 0, 0 },
/* U+43f5 */ { 0, 0, 0, 0, 0 },
/* U+43f6 */ { 0, 0, 0, 0, 0 },
/* U+43f7 */ { 0, 0, 0, 0, 0 },
/* U+43f8 */ { 0, 0, 0, 0, 0 },
/* U+43f9 */ { 0, 0, 0, 0, 0 },
/* U+43fa */ { 0, 0, 0, 0, 0 },
/* U+43fb */ { 0, 0, 0, 0, 0 },
/* U+43fc */ { 0, 0, 0, 0, 0 },
/* U+43fd */ { 0, 0, 0, 0, 0 },
/* U+43fe */ { 0, 0, 0, 0, 0 },
/* U+43ff */ { 0, 0, 0, 0, 0 },
/* U+4400 */ { 0, 0, 0, 0, 0 },
/* U+4401 */ { 0, 0, 0, 0, 0 },
/* U+4402 */ { 0, 0, 0, 0, 0 },
/* U+4403 */ { 0, 0, 0, 0, 0 },
/* U+4404 */ { 0, 0, 0, 0, 0 },
/* U+4405 */ { 0, 0, 0, 0, 0 },
/* U+4406 */ { 0, 0, 0, 0, 0 },
/* U+4407 */ { 0, 0, 0, 0, 0 },
/* U+4408 */ { 0, 0, 0, 0, 0 },
/* U+4409 */ { 0, 0, 0, 0, 0 },
/* U+440a */ { 0, 0, 0, 0, 0 },
/* U+440b */ { 0, 0, 0, 0, 0 },
/* U+440c */ { 0, 0, 0, 0, 0 },
/* U+440d */ { 0, 0, 0, 0, 0 },
/* U+440e */ { 0, 0, 0, 0, 0 },
/* U+440f */ { 0, 0, 0, 0, 0 },
/* U+4410 */ { 0, 0, 0, 0, 0 },
/* U+4411 */ { 0, 0, 0, 0, 0 },
/* U+4412 */ { 0, 0, 0, 0, 0 },
/* U+4413 */ { 0, 0, 0, 0, 0 },
/* U+4414 */ { 0, 0, 0, 0, 0 },
/* U+4415 */ { 0, 0, 0, 0, 0 },
/* U+4416 */ { 0, 0, 0, 0, 0 },
/* U+4417 */ { 0, 0, 0, 0, 0 },
/* U+4418 */ { 0, 0, 0, 0, 0 },
/* U+4419 */ { 0, 0, 0, 0, 0 },
/* U+441a */ { 0, 0, 0, 0, 0 },
/* U+441b */ { 0, 0, 0, 0, 0 },
/* U+441c */ { 0, 0, 0, 0, 0 },
/* U+441d */ { 0, 0, 0, 0, 0 },
/* U+441e */ { 0, 0, 0, 0, 0 },
/* U+441f */ { 0, 0, 0, 0, 0 },
/* U+4420 */ { 0, 0, 0, 0, 0 },
/* U+4421 */ { 0, 0, 0, 0, 0 },
/* U+4422 */ { 0, 0, 0, 0, 0 },
/* U+4423 */ { 0, 0, 0, 0, 0 },
/* U+4424 */ { 0, 0, 0, 0, 0 },
/* U+4425 */ { 0, 0, 0, 0, 0 },
/* U+4426 */ { 0, 0, 0, 0, 0 },
/* U+4427 */ { 0, 0, 0, 0, 0 },
/* U+4428 */ { 0, 0, 0, 0, 0 },
/* U+4429 */ { 0, 0, 0, 0, 0 },
/* U+442a */ { 0, 0, 0, 0, 0 },
/* U+442b */ { 0, 0, 0, 0, 0 },
/* U+442c */ { 0, 0, 0, 0, 0 },
/* U+442d */ { 0, 0, 0, 0, 0 },
/* U+442e */ { 0, 0, 0, 0, 0 },
/* U+442f */ { 0, 0, 0, 0, 0 },
/* U+4430 */ { 0, 0, 0, 0, 0 },
/* U+4431 */ { 0, 0, 0, 0, 0 },
/* U+4432 */ { 0, 0, 0, 0, 0 },
/* U+4433 */ { 0, 0, 0, 0, 0 },
/* U+4434 */ { 0, 0, 0, 0, 0 },
/* U+4435 */ { 0, 0, 0, 0, 0 },
/* U+4436 */ { 0, 0, 0, 0, 0 },
/* U+4437 */ { 0, 0, 0, 0, 0 },
/* U+4438 */ { 0, 0, 0, 0, 0 },
/* U+4439 */ { 0, 0, 0, 0, 0 },
/* U+443a */ { 0, 0, 0, 0, 0 },
/* U+443b */ { 0, 0, 0, 0, 0 },
/* U+443c */ { 0, 0, 0, 0, 0 },
/* U+443d */ { 0, 0, 0, 0, 0 },
/* U+443e */ { 0, 0, 0, 0, 0 },
/* U+443f */ { 0, 0, 0, 0, 0 },
/* U+4440 */ { 0, 0, 0, 0, 0 },
/* U+4441 */ { 0, 0, 0, 0, 0 },
/* U+4442 */ { 0, 0, 0, 0, 0 },
/* U+4443 */ { 0, 0, 0, 0, 0 },
/* U+4444 */ { 0, 0, 0, 0, 0 },
/* U+4445 */ { 0, 0, 0, 0, 0 },
/* U+4446 */ { 0, 0, 0, 0, 0 },
/* U+4447 */ { 0, 0, 0, 0, 0 },
/* U+4448 */ { 0, 0, 0, 0, 0 },
/* U+4449 */ { 0, 0, 0, 0, 0 },
/* U+444a */ { 0, 0, 0, 0, 0 },
/* U+444b */ { 0, 0, 0, 0, 0 },
/* U+444c */ { 0, 0, 0, 0, 0 },
/* U+444d */ { 0, 0, 0, 0, 0 },
/* U+444e */ { 0, 0, 0, 0, 0 },
/* U+444f */ { 0, 0, 0, 0, 0 },
/* U+4450 */ { 0, 0, 0, 0, 0 },
/* U+4451 */ { 0, 0, 0, 0, 0 },
/* U+4452 */ { 0, 0, 0, 0, 0 },
/* U+4453 */ { 0, 0, 0, 0, 0 },
/* U+4454 */ { 0, 0, 0, 0, 0 },
/* U+4455 */ { 0, 0, 0, 0, 0 },
/* U+4456 */ { 0, 0, 0, 0, 0 },
/* U+4457 */ { 0, 0, 0, 0, 0 },
/* U+4458 */ { 0, 0, 0, 0, 0 },
/* U+4459 */ { 0, 0, 0, 0, 0 },
/* U+445a */ { 0, 0, 0, 0, 0 },
/* U+445b */ { 0, 0, 0, 0, 0 },
/* U+445c */ { 0, 0, 0, 0, 0 },
/* U+445d */ { 0, 0, 0, 0, 0 },
/* U+445e */ { 0, 0, 0, 0, 0 },
/* U+445f */ { 0, 0, 0, 0, 0 },
/* U+4460 */ { 0, 0, 0, 0, 0 },
/* U+4461 */ { 0, 0, 0, 0, 0 },
/* U+4462 */ { 0, 0, 0, 0, 0 },
/* U+4463 */ { 0, 0, 0, 0, 0 },
/* U+4464 */ { 0, 0, 0, 0, 0 },
/* U+4465 */ { 0, 0, 0, 0, 0 },
/* U+4466 */ { 0, 0, 0, 0, 0 },
/* U+4467 */ { 0, 0, 0, 0, 0 },
/* U+4468 */ { 0, 0, 0, 0, 0 },
/* U+4469 */ { 0, 0, 0, 0, 0 },
/* U+446a */ { 0, 0, 0, 0, 0 },
/* U+446b */ { 0, 0, 0, 0, 0 },
/* U+446c */ { 0, 0, 0, 0, 0 },
/* U+446d */ { 0, 0, 0, 0, 0 },
/* U+446e */ { 0, 0, 0, 0, 0 },
/* U+446f */ { 0, 0, 0, 0, 0 },
/* U+4470 */ { 0, 0, 0, 0, 0 },
/* U+4471 */ { 0, 0, 0, 0, 0 },
/* U+4472 */ { 0, 0, 0, 0, 0 },
/* U+4473 */ { 0, 0, 0, 0, 0 },
/* U+4474 */ { 0, 0, 0, 0, 0 },
/* U+4475 */ { 0, 0, 0, 0, 0 },
/* U+4476 */ { 0, 0, 0, 0, 0 },
/* U+4477 */ { 0, 0, 0, 0, 0 },
/* U+4478 */ { 0, 0, 0, 0, 0 },
/* U+4479 */ { 0, 0, 0, 0, 0 },
/* U+447a */ { 0, 0, 0, 0, 0 },
/* U+447b */ { 0, 0, 0, 0, 0 },
/* U+447c */ { 0, 0, 0, 0, 0 },
/* U+447d */ { 0, 0, 0, 0, 0 },
/* U+447e */ { 0, 0, 0, 0, 0 },
/* U+447f */ { 0, 0, 0, 0, 0 },
/* U+4480 */ { 0, 0, 0, 0, 0 },
/* U+4481 */ { 0, 0, 0, 0, 0 },
/* U+4482 */ { 0, 0, 0, 0, 0 },
/* U+4483 */ { 0, 0, 0, 0, 0 },
/* U+4484 */ { 0, 0, 0, 0, 0 },
/* U+4485 */ { 0, 0, 0, 0, 0 },
/* U+4486 */ { 0, 0, 0, 0, 0 },
/* U+4487 */ { 0, 0, 0, 0, 0 },
/* U+4488 */ { 0, 0, 0, 0, 0 },
/* U+4489 */ { 0, 0, 0, 0, 0 },
/* U+448a */ { 0, 0, 0, 0, 0 },
/* U+448b */ { 0, 0, 0, 0, 0 },
/* U+448c */ { 0, 0, 0, 0, 0 },
/* U+448d */ { 0, 0, 0, 0, 0 },
/* U+448e */ { 0, 0, 0, 0, 0 },
/* U+448f */ { 0, 0, 0, 0, 0 },
/* U+4490 */ { 0, 0, 0, 0, 0 },
/* U+4491 */ { 0, 0, 0, 0, 0 },
/* U+4492 */ { 0, 0, 0, 0, 0 },
/* U+4493 */ { 0, 0, 0, 0, 0 },
/* U+4494 */ { 0, 0, 0, 0, 0 },
/* U+4495 */ { 0, 0, 0, 0, 0 },
/* U+4496 */ { 0, 0, 0, 0, 0 },
/* U+4497 */ { 0, 0, 0, 0, 0 },
/* U+4498 */ { 0, 0, 0, 0, 0 },
/* U+4499 */ { 0, 0, 0, 0, 0 },
/* U+449a */ { 0, 0, 0, 0, 0 },
/* U+449b */ { 0, 0, 0, 0, 0 },
/* U+449c */ { 0, 0, 0, 0, 0 },
/* U+449d */ { 0, 0, 0, 0, 0 },
/* U+449e */ { 0, 0, 0, 0, 0 },
/* U+449f */ { 0, 0, 0, 0, 0 },
/* U+44a0 */ { 0, 0, 0, 0, 0 },
/* U+44a1 */ { 0, 0, 0, 0, 0 },
/* U+44a2 */ { 0, 0, 0, 0, 0 },
/* U+44a3 */ { 0, 0, 0, 0, 0 },
/* U+44a4 */ { 0, 0, 0, 0, 0 },
/* U+44a5 */ { 0, 0, 0, 0, 0 },
/* U+44a6 */ { 0, 0, 0, 0, 0 },
/* U+44a7 */ { 0, 0, 0, 0, 0 },
/* U+44a8 */ { 0, 0, 0, 0, 0 },
/* U+44a9 */ { 0, 0, 0, 0, 0 },
/* U+44aa */ { 0, 0, 0, 0, 0 },
/* U+44ab */ { 0, 0, 0, 0, 0 },
/* U+44ac */ { 0, 0, 0, 0, 0 },
/* U+44ad */ { 0, 0, 0, 0, 0 },
/* U+44ae */ { 0, 0, 0, 0, 0 },
/* U+44af */ { 0, 0, 0, 0, 0 },
/* U+44b0 */ { 0, 0, 0, 0, 0 },
/* U+44b1 */ { 0, 0, 0, 0, 0 },
/* U+44b2 */ { 0, 0, 0, 0, 0 },
/* U+44b3 */ { 0, 0, 0, 0, 0 },
/* U+44b4 */ { 0, 0, 0, 0, 0 },
/* U+44b5 */ { 0, 0, 0, 0, 0 },
/* U+44b6 */ { 0, 0, 0, 0, 0 },
/* U+44b7 */ { 0, 0, 0, 0, 0 },
/* U+44b8 */ { 0, 0, 0, 0, 0 },
/* U+44b9 */ { 0, 0, 0, 0, 0 },
/* U+44ba */ { 0, 0, 0, 0, 0 },
/* U+44bb */ { 0, 0, 0, 0, 0 },
/* U+44bc */ { 0, 0, 0, 0, 0 },
/* U+44bd */ { 0, 0, 0, 0, 0 },
/* U+44be */ { 0, 0, 0, 0, 0 },
/* U+44bf */ { 0, 0, 0, 0, 0 },
/* U+44c0 */ { 0, 0, 0, 0, 0 },
/* U+44c1 */ { 0, 0, 0, 0, 0 },
/* U+44c2 */ { 0, 0, 0, 0, 0 },
/* U+44c3 */ { 0, 0, 0, 0, 0 },
/* U+44c4 */ { 0, 0, 0, 0, 0 },
/* U+44c5 */ { 0, 0, 0, 0, 0 },
/* U+44c6 */ { 0, 0, 0, 0, 0 },
/* U+44c7 */ { 0, 0, 0, 0, 0 },
/* U+44c8 */ { 0, 0, 0, 0, 0 },
/* U+44c9 */ { 0, 0, 0, 0, 0 },
/* U+44ca */ { 0, 0, 0, 0, 0 },
/* U+44cb */ { 0, 0, 0, 0, 0 },
/* U+44cc */ { 0, 0, 0, 0, 0 },
/* U+44cd */ { 0, 0, 0, 0, 0 },
/* U+44ce */ { 0, 0, 0, 0, 0 },
/* U+44cf */ { 0, 0, 0, 0, 0 },
/* U+44d0 */ { 0, 0, 0, 0, 0 },
/* U+44d1 */ { 0, 0, 0, 0, 0 },
/* U+44d2 */ { 0, 0, 0, 0, 0 },
/* U+44d3 */ { 0, 0, 0, 0, 0 },
/* U+44d4 */ { 0, 0, 0, 0, 0 },
/* U+44d5 */ { 0, 0, 0, 0, 0 },
/* U+44d6 */ { 0, 0, 0, 0, 0 },
/* U+44d7 */ { 0, 0, 0, 0, 0 },
/* U+44d8 */ { 0, 0, 0, 0, 0 },
/* U+44d9 */ { 0, 0, 0, 0, 0 },
/* U+44da */ { 0, 0, 0, 0, 0 },
/* U+44db */ { 0, 0, 0, 0, 0 },
/* U+44dc */ { 0, 0, 0, 0, 0 },
/* U+44dd */ { 0, 0, 0, 0, 0 },
/* U+44de */ { 0, 0, 0, 0, 0 },
/* U+44df */ { 0, 0, 0, 0, 0 },
/* U+44e0 */ { 0, 0, 0, 0, 0 },
/* U+44e1 */ { 0, 0, 0, 0, 0 },
/* U+44e2 */ { 0, 0, 0, 0, 0 },
/* U+44e3 */ { 0, 0, 0, 0, 0 },
/* U+44e4 */ { 0, 0, 0, 0, 0 },
/* U+44e5 */ { 0, 0, 0, 0, 0 },
/* U+44e6 */ { 0, 0, 0, 0, 0 },
/* U+44e7 */ { 0, 0, 0, 0, 0 },
/* U+44e8 */ { 0, 0, 0, 0, 0 },
/* U+44e9 */ { 0, 0, 0, 0, 0 },
/* U+44ea */ { 0, 0, 0, 0, 0 },
/* U+44eb */ { 0, 0, 0, 0, 0 },
/* U+44ec */ { 0, 0, 0, 0, 0 },
/* U+44ed */ { 0, 0, 0, 0, 0 },
/* U+44ee */ { 0, 0, 0, 0, 0 },
/* U+44ef */ { 0, 0, 0, 0, 0 },
/* U+44f0 */ { 0, 0, 0, 0, 0 },
/* U+44f1 */ { 0, 0, 0, 0, 0 },
/* U+44f2 */ { 0, 0, 0, 0, 0 },
/* U+44f3 */ { 0, 0, 0, 0, 0 },
/* U+44f4 */ { 0, 0, 0, 0, 0 },
/* U+44f5 */ { 0, 0, 0, 0, 0 },
/* U+44f6 */ { 0, 0, 0, 0, 0 },
/* U+44f7 */ { 0, 0, 0, 0, 0 },
/* U+44f8 */ { 0, 0, 0, 0, 0 },
/* U+44f9 */ { 0, 0, 0, 0, 0 },
/* U+44fa */ { 0, 0, 0, 0, 0 },
/* U+44fb */ { 0, 0, 0, 0, 0 },
/* U+44fc */ { 0, 0, 0, 0, 0 },
/* U+44fd */ { 0, 0, 0, 0, 0 },
/* U+44fe */ { 0, 0, 0, 0, 0 },
/* U+44ff */ { 0, 0, 0, 0, 0 },
/* U+4500 */ { 0, 0, 0, 0, 0 },
/* U+4501 */ { 0, 0, 0, 0, 0 },
/* U+4502 */ { 0, 0, 0, 0, 0 },
/* U+4503 */ { 0, 0, 0, 0, 0 },
/* U+4504 */ { 0, 0, 0, 0, 0 },
/* U+4505 */ { 0, 0, 0, 0, 0 },
/* U+4506 */ { 0, 0, 0, 0, 0 },
/* U+4507 */ { 0, 0, 0, 0, 0 },
/* U+4508 */ { 0, 0, 0, 0, 0 },
/* U+4509 */ { 0, 0, 0, 0, 0 },
/* U+450a */ { 0, 0, 0, 0, 0 },
/* U+450b */ { 0, 0, 0, 0, 0 },
/* U+450c */ { 0, 0, 0, 0, 0 },
/* U+450d */ { 0, 0, 0, 0, 0 },
/* U+450e */ { 0, 0, 0, 0, 0 },
/* U+450f */ { 0, 0, 0, 0, 0 },
/* U+4510 */ { 0, 0, 0, 0, 0 },
/* U+4511 */ { 0, 0, 0, 0, 0 },
/* U+4512 */ { 0, 0, 0, 0, 0 },
/* U+4513 */ { 0, 0, 0, 0, 0 },
/* U+4514 */ { 0, 0, 0, 0, 0 },
/* U+4515 */ { 0, 0, 0, 0, 0 },
/* U+4516 */ { 0, 0, 0, 0, 0 },
/* U+4517 */ { 0, 0, 0, 0, 0 },
/* U+4518 */ { 0, 0, 0, 0, 0 },
/* U+4519 */ { 0, 0, 0, 0, 0 },
/* U+451a */ { 0, 0, 0, 0, 0 },
/* U+451b */ { 0, 0, 0, 0, 0 },
/* U+451c */ { 0, 0, 0, 0, 0 },
/* U+451d */ { 0, 0, 0, 0, 0 },
/* U+451e */ { 0, 0, 0, 0, 0 },
/* U+451f */ { 0, 0, 0, 0, 0 },
/* U+4520 */ { 0, 0, 0, 0, 0 },
/* U+4521 */ { 0, 0, 0, 0, 0 },
/* U+4522 */ { 0, 0, 0, 0, 0 },
/* U+4523 */ { 0, 0, 0, 0, 0 },
/* U+4524 */ { 0, 0, 0, 0, 0 },
/* U+4525 */ { 0, 0, 0, 0, 0 },
/* U+4526 */ { 0, 0, 0, 0, 0 },
/* U+4527 */ { 0, 0, 0, 0, 0 },
/* U+4528 */ { 0, 0, 0, 0, 0 },
/* U+4529 */ { 0, 0, 0, 0, 0 },
/* U+452a */ { 0, 0, 0, 0, 0 },
/* U+452b */ { 0, 0, 0, 0, 0 },
/* U+452c */ { 0, 0, 0, 0, 0 },
/* U+452d */ { 0, 0, 0, 0, 0 },
/* U+452e */ { 0, 0, 0, 0, 0 },
/* U+452f */ { 0, 0, 0, 0, 0 },
/* U+4530 */ { 0, 0, 0, 0, 0 },
/* U+4531 */ { 0, 0, 0, 0, 0 },
/* U+4532 */ { 0, 0, 0, 0, 0 },
/* U+4533 */ { 0, 0, 0, 0, 0 },
/* U+4534 */ { 0, 0, 0, 0, 0 },
/* U+4535 */ { 0, 0, 0, 0, 0 },
/* U+4536 */ { 0, 0, 0, 0, 0 },
/* U+4537 */ { 0, 0, 0, 0, 0 },
/* U+4538 */ { 0, 0, 0, 0, 0 },
/* U+4539 */ { 0, 0, 0, 0, 0 },
/* U+453a */ { 0, 0, 0, 0, 0 },
/* U+453b */ { 0, 0, 0, 0, 0 },
/* U+453c */ { 0, 0, 0, 0, 0 },
/* U+453d */ { 0, 0, 0, 0, 0 },
/* U+453e */ { 0, 0, 0, 0, 0 },
/* U+453f */ { 0, 0, 0, 0, 0 },
/* U+4540 */ { 0, 0, 0, 0, 0 },
/* U+4541 */ { 0, 0, 0, 0, 0 },
/* U+4542 */ { 0, 0, 0, 0, 0 },
/* U+4543 */ { 0, 0, 0, 0, 0 },
/* U+4544 */ { 0, 0, 0, 0, 0 },
/* U+4545 */ { 0, 0, 0, 0, 0 },
/* U+4546 */ { 0, 0, 0, 0, 0 },
/* U+4547 */ { 0, 0, 0, 0, 0 },
/* U+4548 */ { 0, 0, 0, 0, 0 },
/* U+4549 */ { 0, 0, 0, 0, 0 },
/* U+454a */ { 0, 0, 0, 0, 0 },
/* U+454b */ { 0, 0, 0, 0, 0 },
/* U+454c */ { 0, 0, 0, 0, 0 },
/* U+454d */ { 0, 0, 0, 0, 0 },
/* U+454e */ { 0, 0, 0, 0, 0 },
/* U+454f */ { 0, 0, 0, 0, 0 },
/* U+4550 */ { 0, 0, 0, 0, 0 },
/* U+4551 */ { 0, 0, 0, 0, 0 },
/* U+4552 */ { 0, 0, 0, 0, 0 },
/* U+4553 */ { 0, 0, 0, 0, 0 },
/* U+4554 */ { 0, 0, 0, 0, 0 },
/* U+4555 */ { 0, 0, 0, 0, 0 },
/* U+4556 */ { 0, 0, 0, 0, 0 },
/* U+4557 */ { 0, 0, 0, 0, 0 },
/* U+4558 */ { 0, 0, 0, 0, 0 },
/* U+4559 */ { 0, 0, 0, 0, 0 },
/* U+455a */ { 0, 0, 0, 0, 0 },
/* U+455b */ { 0, 0, 0, 0, 0 },
/* U+455c */ { 0, 0, 0, 0, 0 },
/* U+455d */ { 0, 0, 0, 0, 0 },
/* U+455e */ { 0, 0, 0, 0, 0 },
/* U+455f */ { 0, 0, 0, 0, 0 },
/* U+4560 */ { 0, 0, 0, 0, 0 },
/* U+4561 */ { 0, 0, 0, 0, 0 },
/* U+4562 */ { 0, 0, 0, 0, 0 },
/* U+4563 */ { 0, 0, 0, 0, 0 },
/* U+4564 */ { 0, 0, 0, 0, 0 },
/* U+4565 */ { 0, 0, 0, 0, 0 },
/* U+4566 */ { 0, 0, 0, 0, 0 },
/* U+4567 */ { 0, 0, 0, 0, 0 },
/* U+4568 */ { 0, 0, 0, 0, 0 },
/* U+4569 */ { 0, 0, 0, 0, 0 },
/* U+456a */ { 0, 0, 0, 0, 0 },
/* U+456b */ { 0, 0, 0, 0, 0 },
/* U+456c */ { 0, 0, 0, 0, 0 },
/* U+456d */ { 0, 0, 0, 0, 0 },
/* U+456e */ { 0, 0, 0, 0, 0 },
/* U+456f */ { 0, 0, 0, 0, 0 },
/* U+4570 */ { 0, 0, 0, 0, 0 },
/* U+4571 */ { 0, 0, 0, 0, 0 },
/* U+4572 */ { 0, 0, 0, 0, 0 },
/* U+4573 */ { 0, 0, 0, 0, 0 },
/* U+4574 */ { 0, 0, 0, 0, 0 },
/* U+4575 */ { 0, 0, 0, 0, 0 },
/* U+4576 */ { 0, 0, 0, 0, 0 },
/* U+4577 */ { 0, 0, 0, 0, 0 },
/* U+4578 */ { 0, 0, 0, 0, 0 },
/* U+4579 */ { 0, 0, 0, 0, 0 },
/* U+457a */ { 0, 0, 0, 0, 0 },
/* U+457b */ { 0, 0, 0, 0, 0 },
/* U+457c */ { 0, 0, 0, 0, 0 },
/* U+457d */ { 0, 0, 0, 0, 0 },
/* U+457e */ { 0, 0, 0, 0, 0 },
/* U+457f */ { 0, 0, 0, 0, 0 },
/* U+4580 */ { 0, 0, 0, 0, 0 },
/* U+4581 */ { 0, 0, 0, 0, 0 },
/* U+4582 */ { 0, 0, 0, 0, 0 },
/* U+4583 */ { 0, 0, 0, 0, 0 },
/* U+4584 */ { 0, 0, 0, 0, 0 },
/* U+4585 */ { 0, 0, 0, 0, 0 },
/* U+4586 */ { 0, 0, 0, 0, 0 },
/* U+4587 */ { 0, 0, 0, 0, 0 },
/* U+4588 */ { 0, 0, 0, 0, 0 },
/* U+4589 */ { 0, 0, 0, 0, 0 },
/* U+458a */ { 0, 0, 0, 0, 0 },
/* U+458b */ { 0, 0, 0, 0, 0 },
/* U+458c */ { 0, 0, 0, 0, 0 },
/* U+458d */ { 0, 0, 0, 0, 0 },
/* U+458e */ { 0, 0, 0, 0, 0 },
/* U+458f */ { 0, 0, 0, 0, 0 },
/* U+4590 */ { 0, 0, 0, 0, 0 },
/* U+4591 */ { 0, 0, 0, 0, 0 },
/* U+4592 */ { 0, 0, 0, 0, 0 },
/* U+4593 */ { 0, 0, 0, 0, 0 },
/* U+4594 */ { 0, 0, 0, 0, 0 },
/* U+4595 */ { 0, 0, 0, 0, 0 },
/* U+4596 */ { 0, 0, 0, 0, 0 },
/* U+4597 */ { 0, 0, 0, 0, 0 },
/* U+4598 */ { 0, 0, 0, 0, 0 },
/* U+4599 */ { 0, 0, 0, 0, 0 },
/* U+459a */ { 0, 0, 0, 0, 0 },
/* U+459b */ { 0, 0, 0, 0, 0 },
/* U+459c */ { 0, 0, 0, 0, 0 },
/* U+459d */ { 0, 0, 0, 0, 0 },
/* U+459e */ { 0, 0, 0, 0, 0 },
/* U+459f */ { 0, 0, 0, 0, 0 },
/* U+45a0 */ { 0, 0, 0, 0, 0 },
/* U+45a1 */ { 0, 0, 0, 0, 0 },
/* U+45a2 */ { 0, 0, 0, 0, 0 },
/* U+45a3 */ { 0, 0, 0, 0, 0 },
/* U+45a4 */ { 0, 0, 0, 0, 0 },
/* U+45a5 */ { 0, 0, 0, 0, 0 },
/* U+45a6 */ { 0, 0, 0, 0, 0 },
/* U+45a7 */ { 0, 0, 0, 0, 0 },
/* U+45a8 */ { 0, 0, 0, 0, 0 },
/* U+45a9 */ { 0, 0, 0, 0, 0 },
/* U+45aa */ { 0, 0, 0, 0, 0 },
/* U+45ab */ { 0, 0, 0, 0, 0 },
/* U+45ac */ { 0, 0, 0, 0, 0 },
/* U+45ad */ { 0, 0, 0, 0, 0 },
/* U+45ae */ { 0, 0, 0, 0, 0 },
/* U+45af */ { 0, 0, 0, 0, 0 },
/* U+45b0 */ { 0, 0, 0, 0, 0 },
/* U+45b1 */ { 0, 0, 0, 0, 0 },
/* U+45b2 */ { 0, 0, 0, 0, 0 },
/* U+45b3 */ { 0, 0, 0, 0, 0 },
/* U+45b4 */ { 0, 0, 0, 0, 0 },
/* U+45b5 */ { 0, 0, 0, 0, 0 },
/* U+45b6 */ { 0, 0, 0, 0, 0 },
/* U+45b7 */ { 0, 0, 0, 0, 0 },
/* U+45b8 */ { 0, 0, 0, 0, 0 },
/* U+45b9 */ { 0, 0, 0, 0, 0 },
/* U+45ba */ { 0, 0, 0, 0, 0 },
/* U+45bb */ { 0, 0, 0, 0, 0 },
/* U+45bc */ { 0, 0, 0, 0, 0 },
/* U+45bd */ { 0, 0, 0, 0, 0 },
/* U+45be */ { 0, 0, 0, 0, 0 },
/* U+45bf */ { 0, 0, 0, 0, 0 },
/* U+45c0 */ { 0, 0, 0, 0, 0 },
/* U+45c1 */ { 0, 0, 0, 0, 0 },
/* U+45c2 */ { 0, 0, 0, 0, 0 },
/* U+45c3 */ { 0, 0, 0, 0, 0 },
/* U+45c4 */ { 0, 0, 0, 0, 0 },
/* U+45c5 */ { 0, 0, 0, 0, 0 },
/* U+45c6 */ { 0, 0, 0, 0, 0 },
/* U+45c7 */ { 0, 0, 0, 0, 0 },
/* U+45c8 */ { 0, 0, 0, 0, 0 },
/* U+45c9 */ { 0, 0, 0, 0, 0 },
/* U+45ca */ { 0, 0, 0, 0, 0 },
/* U+45cb */ { 0, 0, 0, 0, 0 },
/* U+45cc */ { 0, 0, 0, 0, 0 },
/* U+45cd */ { 0, 0, 0, 0, 0 },
/* U+45ce */ { 0, 0, 0, 0, 0 },
/* U+45cf */ { 0, 0, 0, 0, 0 },
/* U+45d0 */ { 0, 0, 0, 0, 0 },
/* U+45d1 */ { 0, 0, 0, 0, 0 },
/* U+45d2 */ { 0, 0, 0, 0, 0 },
/* U+45d3 */ { 0, 0, 0, 0, 0 },
/* U+45d4 */ { 0, 0, 0, 0, 0 },
/* U+45d5 */ { 0, 0, 0, 0, 0 },
/* U+45d6 */ { 0, 0, 0, 0, 0 },
/* U+45d7 */ { 0, 0, 0, 0, 0 },
/* U+45d8 */ { 0, 0, 0, 0, 0 },
/* U+45d9 */ { 0, 0, 0, 0, 0 },
/* U+45da */ { 0, 0, 0, 0, 0 },
/* U+45db */ { 0, 0, 0, 0, 0 },
/* U+45dc */ { 0, 0, 0, 0, 0 },
/* U+45dd */ { 0, 0, 0, 0, 0 },
/* U+45de */ { 0, 0, 0, 0, 0 },
/* U+45df */ { 0, 0, 0, 0, 0 },
/* U+45e0 */ { 0, 0, 0, 0, 0 },
/* U+45e1 */ { 0, 0, 0, 0, 0 },
/* U+45e2 */ { 0, 0, 0, 0, 0 },
/* U+45e3 */ { 0, 0, 0, 0, 0 },
/* U+45e4 */ { 0, 0, 0, 0, 0 },
/* U+45e5 */ { 0, 0, 0, 0, 0 },
/* U+45e6 */ { 0, 0, 0, 0, 0 },
/* U+45e7 */ { 0, 0, 0, 0, 0 },
/* U+45e8 */ { 0, 0, 0, 0, 0 },
/* U+45e9 */ { 0, 0, 0, 0, 0 },
/* U+45ea */ { 0, 0, 0, 0, 0 },
/* U+45eb */ { 0, 0, 0, 0, 0 },
/* U+45ec */ { 0, 0, 0, 0, 0 },
/* U+45ed */ { 0, 0, 0, 0, 0 },
/* U+45ee */ { 0, 0, 0, 0, 0 },
/* U+45ef */ { 0, 0, 0, 0, 0 },
/* U+45f0 */ { 0, 0, 0, 0, 0 },
/* U+45f1 */ { 0, 0, 0, 0, 0 },
/* U+45f2 */ { 0, 0, 0, 0, 0 },
/* U+45f3 */ { 0, 0, 0, 0, 0 },
/* U+45f4 */ { 0, 0, 0, 0, 0 },
/* U+45f5 */ { 0, 0, 0, 0, 0 },
/* U+45f6 */ { 0, 0, 0, 0, 0 },
/* U+45f7 */ { 0, 0, 0, 0, 0 },
/* U+45f8 */ { 0, 0, 0, 0, 0 },
/* U+45f9 */ { 0, 0, 0, 0, 0 },
/* U+45fa */ { 0, 0, 0, 0, 0 },
/* U+45fb */ { 0, 0, 0, 0, 0 },
/* U+45fc */ { 0, 0, 0, 0, 0 },
/* U+45fd */ { 0, 0, 0, 0, 0 },
/* U+45fe */ { 0, 0, 0, 0, 0 },
/* U+45ff */ { 0, 0, 0, 0, 0 },
/* U+4600 */ { 0, 0, 0, 0, 0 },
/* U+4601 */ { 0, 0, 0, 0, 0 },
/* U+4602 */ { 0, 0, 0, 0, 0 },
/* U+4603 */ { 0, 0, 0, 0, 0 },
/* U+4604 */ { 0, 0, 0, 0, 0 },
/* U+4605 */ { 0, 0, 0, 0, 0 },
/* U+4606 */ { 0, 0, 0, 0, 0 },
/* U+4607 */ { 0, 0, 0, 0, 0 },
/* U+4608 */ { 0, 0, 0, 0, 0 },
/* U+4609 */ { 0, 0, 0, 0, 0 },
/* U+460a */ { 0, 0, 0, 0, 0 },
/* U+460b */ { 0, 0, 0, 0, 0 },
/* U+460c */ { 0, 0, 0, 0, 0 },
/* U+460d */ { 0, 0, 0, 0, 0 },
/* U+460e */ { 0, 0, 0, 0, 0 },
/* U+460f */ { 0, 0, 0, 0, 0 },
/* U+4610 */ { 0, 0, 0, 0, 0 },
/* U+4611 */ { 0, 0, 0, 0, 0 },
/* U+4612 */ { 0, 0, 0, 0, 0 },
/* U+4613 */ { 0, 0, 0, 0, 0 },
/* U+4614 */ { 0, 0, 0, 0, 0 },
/* U+4615 */ { 0, 0, 0, 0, 0 },
/* U+4616 */ { 0, 0, 0, 0, 0 },
/* U+4617 */ { 0, 0, 0, 0, 0 },
/* U+4618 */ { 0, 0, 0, 0, 0 },
/* U+4619 */ { 0, 0, 0, 0, 0 },
/* U+461a */ { 0, 0, 0, 0, 0 },
/* U+461b */ { 0, 0, 0, 0, 0 },
/* U+461c */ { 0, 0, 0, 0, 0 },
/* U+461d */ { 0, 0, 0, 0, 0 },
/* U+461e */ { 0, 0, 0, 0, 0 },
/* U+461f */ { 0, 0, 0, 0, 0 },
/* U+4620 */ { 0, 0, 0, 0, 0 },
/* U+4621 */ { 0, 0, 0, 0, 0 },
/* U+4622 */ { 0, 0, 0, 0, 0 },
/* U+4623 */ { 0, 0, 0, 0, 0 },
/* U+4624 */ { 0, 0, 0, 0, 0 },
/* U+4625 */ { 0, 0, 0, 0, 0 },
/* U+4626 */ { 0, 0, 0, 0, 0 },
/* U+4627 */ { 0, 0, 0, 0, 0 },
/* U+4628 */ { 0, 0, 0, 0, 0 },
/* U+4629 */ { 0, 0, 0, 0, 0 },
/* U+462a */ { 0, 0, 0, 0, 0 },
/* U+462b */ { 0, 0, 0, 0, 0 },
/* U+462c */ { 0, 0, 0, 0, 0 },
/* U+462d */ { 0, 0, 0, 0, 0 },
/* U+462e */ { 0, 0, 0, 0, 0 },
/* U+462f */ { 0, 0, 0, 0, 0 },
/* U+4630 */ { 0, 0, 0, 0, 0 },
/* U+4631 */ { 0, 0, 0, 0, 0 },
/* U+4632 */ { 0, 0, 0, 0, 0 },
/* U+4633 */ { 0, 0, 0, 0, 0 },
/* U+4634 */ { 0, 0, 0, 0, 0 },
/* U+4635 */ { 0, 0, 0, 0, 0 },
/* U+4636 */ { 0, 0, 0, 0, 0 },
/* U+4637 */ { 0, 0, 0, 0, 0 },
/* U+4638 */ { 0, 0, 0, 0, 0 },
/* U+4639 */ { 0, 0, 0, 0, 0 },
/* U+463a */ { 0, 0, 0, 0, 0 },
/* U+463b */ { 0, 0, 0, 0, 0 },
/* U+463c */ { 0, 0, 0, 0, 0 },
/* U+463d */ { 0, 0, 0, 0, 0 },
/* U+463e */ { 0, 0, 0, 0, 0 },
/* U+463f */ { 0, 0, 0, 0, 0 },
/* U+4640 */ { 0, 0, 0, 0, 0 },
/* U+4641 */ { 0, 0, 0, 0, 0 },
/* U+4642 */ { 0, 0, 0, 0, 0 },
/* U+4643 */ { 0, 0, 0, 0, 0 },
/* U+4644 */ { 0, 0, 0, 0, 0 },
/* U+4645 */ { 0, 0, 0, 0, 0 },
/* U+4646 */ { 0, 0, 0, 0, 0 },
/* U+4647 */ { 0, 0, 0, 0, 0 },
/* U+4648 */ { 0, 0, 0, 0, 0 },
/* U+4649 */ { 0, 0, 0, 0, 0 },
/* U+464a */ { 0, 0, 0, 0, 0 },
/* U+464b */ { 0, 0, 0, 0, 0 },
/* U+464c */ { 0, 0, 0, 0, 0 },
/* U+464d */ { 0, 0, 0, 0, 0 },
/* U+464e */ { 0, 0, 0, 0, 0 },
/* U+464f */ { 0, 0, 0, 0, 0 },
/* U+4650 */ { 0, 0, 0, 0, 0 },
/* U+4651 */ { 0, 0, 0, 0, 0 },
/* U+4652 */ { 0, 0, 0, 0, 0 },
/* U+4653 */ { 0, 0, 0, 0, 0 },
/* U+4654 */ { 0, 0, 0, 0, 0 },
/* U+4655 */ { 0, 0, 0, 0, 0 },
/* U+4656 */ { 0, 0, 0, 0, 0 },
/* U+4657 */ { 0, 0, 0, 0, 0 },
/* U+4658 */ { 0, 0, 0, 0, 0 },
/* U+4659 */ { 0, 0, 0, 0, 0 },
/* U+465a */ { 0, 0, 0, 0, 0 },
/* U+465b */ { 0, 0, 0, 0, 0 },
/* U+465c */ { 0, 0, 0, 0, 0 },
/* U+465d */ { 0, 0, 0, 0, 0 },
/* U+465e */ { 0, 0, 0, 0, 0 },
/* U+465f */ { 0, 0, 0, 0, 0 },
/* U+4660 */ { 0, 0, 0, 0, 0 },
/* U+4661 */ { 0, 0, 0, 0, 0 },
/* U+4662 */ { 0, 0, 0, 0, 0 },
/* U+4663 */ { 0, 0, 0, 0, 0 },
/* U+4664 */ { 0, 0, 0, 0, 0 },
/* U+4665 */ { 0, 0, 0, 0, 0 },
/* U+4666 */ { 0, 0, 0, 0, 0 },
/* U+4667 */ { 0, 0, 0, 0, 0 },
/* U+4668 */ { 0, 0, 0, 0, 0 },
/* U+4669 */ { 0, 0, 0, 0, 0 },
/* U+466a */ { 0, 0, 0, 0, 0 },
/* U+466b */ { 0, 0, 0, 0, 0 },
/* U+466c */ { 0, 0, 0, 0, 0 },
/* U+466d */ { 0, 0, 0, 0, 0 },
/* U+466e */ { 0, 0, 0, 0, 0 },
/* U+466f */ { 0, 0, 0, 0, 0 },
/* U+4670 */ { 0, 0, 0, 0, 0 },
/* U+4671 */ { 0, 0, 0, 0, 0 },
/* U+4672 */ { 0, 0, 0, 0, 0 },
/* U+4673 */ { 0, 0, 0, 0, 0 },
/* U+4674 */ { 0, 0, 0, 0, 0 },
/* U+4675 */ { 0, 0, 0, 0, 0 },
/* U+4676 */ { 0, 0, 0, 0, 0 },
/* U+4677 */ { 0, 0, 0, 0, 0 },
/* U+4678 */ { 0, 0, 0, 0, 0 },
/* U+4679 */ { 0, 0, 0, 0, 0 },
/* U+467a */ { 0, 0, 0, 0, 0 },
/* U+467b */ { 0, 0, 0, 0, 0 },
/* U+467c */ { 0, 0, 0, 0, 0 },
/* U+467d */ { 0, 0, 0, 0, 0 },
/* U+467e */ { 0, 0, 0, 0, 0 },
/* U+467f */ { 0, 0, 0, 0, 0 },
/* U+4680 */ { 0, 0, 0, 0, 0 },
/* U+4681 */ { 0, 0, 0, 0, 0 },
/* U+4682 */ { 0, 0, 0, 0, 0 },
/* U+4683 */ { 0, 0, 0, 0, 0 },
/* U+4684 */ { 0, 0, 0, 0, 0 },
/* U+4685 */ { 0, 0, 0, 0, 0 },
/* U+4686 */ { 0, 0, 0, 0, 0 },
/* U+4687 */ { 0, 0, 0, 0, 0 },
/* U+4688 */ { 0, 0, 0, 0, 0 },
/* U+4689 */ { 0, 0, 0, 0, 0 },
/* U+468a */ { 0, 0, 0, 0, 0 },
/* U+468b */ { 0, 0, 0, 0, 0 },
/* U+468c */ { 0, 0, 0, 0, 0 },
/* U+468d */ { 0, 0, 0, 0, 0 },
/* U+468e */ { 0, 0, 0, 0, 0 },
/* U+468f */ { 0, 0, 0, 0, 0 },
/* U+4690 */ { 0, 0, 0, 0, 0 },
/* U+4691 */ { 0, 0, 0, 0, 0 },
/* U+4692 */ { 0, 0, 0, 0, 0 },
/* U+4693 */ { 0, 0, 0, 0, 0 },
/* U+4694 */ { 0, 0, 0, 0, 0 },
/* U+4695 */ { 0, 0, 0, 0, 0 },
/* U+4696 */ { 0, 0, 0, 0, 0 },
/* U+4697 */ { 0, 0, 0, 0, 0 },
/* U+4698 */ { 0, 0, 0, 0, 0 },
/* U+4699 */ { 0, 0, 0, 0, 0 },
/* U+469a */ { 0, 0, 0, 0, 0 },
/* U+469b */ { 0, 0, 0, 0, 0 },
/* U+469c */ { 0, 0, 0, 0, 0 },
/* U+469d */ { 0, 0, 0, 0, 0 },
/* U+469e */ { 0, 0, 0, 0, 0 },
/* U+469f */ { 0, 0, 0, 0, 0 },
/* U+46a0 */ { 0, 0, 0, 0, 0 },
/* U+46a1 */ { 0, 0, 0, 0, 0 },
/* U+46a2 */ { 0, 0, 0, 0, 0 },
/* U+46a3 */ { 0, 0, 0, 0, 0 },
/* U+46a4 */ { 0, 0, 0, 0, 0 },
/* U+46a5 */ { 0, 0, 0, 0, 0 },
/* U+46a6 */ { 0, 0, 0, 0, 0 },
/* U+46a7 */ { 0, 0, 0, 0, 0 },
/* U+46a8 */ { 0, 0, 0, 0, 0 },
/* U+46a9 */ { 0, 0, 0, 0, 0 },
/* U+46aa */ { 0, 0, 0, 0, 0 },
/* U+46ab */ { 0, 0, 0, 0, 0 },
/* U+46ac */ { 0, 0, 0, 0, 0 },
/* U+46ad */ { 0, 0, 0, 0, 0 },
/* U+46ae */ { 0, 0, 0, 0, 0 },
/* U+46af */ { 0, 0, 0, 0, 0 },
/* U+46b0 */ { 0, 0, 0, 0, 0 },
/* U+46b1 */ { 0, 0, 0, 0, 0 },
/* U+46b2 */ { 0, 0, 0, 0, 0 },
/* U+46b3 */ { 0, 0, 0, 0, 0 },
/* U+46b4 */ { 0, 0, 0, 0, 0 },
/* U+46b5 */ { 0, 0, 0, 0, 0 },
/* U+46b6 */ { 0, 0, 0, 0, 0 },
/* U+46b7 */ { 0, 0, 0, 0, 0 },
/* U+46b8 */ { 0, 0, 0, 0, 0 },
/* U+46b9 */ { 0, 0, 0, 0, 0 },
/* U+46ba */ { 0, 0, 0, 0, 0 },
/* U+46bb */ { 0, 0, 0, 0, 0 },
/* U+46bc */ { 0, 0, 0, 0, 0 },
/* U+46bd */ { 0, 0, 0, 0, 0 },
/* U+46be */ { 0, 0, 0, 0, 0 },
/* U+46bf */ { 0, 0, 0, 0, 0 },
/* U+46c0 */ { 0, 0, 0, 0, 0 },
/* U+46c1 */ { 0, 0, 0, 0, 0 },
/* U+46c2 */ { 0, 0, 0, 0, 0 },
/* U+46c3 */ { 0, 0, 0, 0, 0 },
/* U+46c4 */ { 0, 0, 0, 0, 0 },
/* U+46c5 */ { 0, 0, 0, 0, 0 },
/* U+46c6 */ { 0, 0, 0, 0, 0 },
/* U+46c7 */ { 0, 0, 0, 0, 0 },
/* U+46c8 */ { 0, 0, 0, 0, 0 },
/* U+46c9 */ { 0, 0, 0, 0, 0 },
/* U+46ca */ { 0, 0, 0, 0, 0 },
/* U+46cb */ { 0, 0, 0, 0, 0 },
/* U+46cc */ { 0, 0, 0, 0, 0 },
/* U+46cd */ { 0, 0, 0, 0, 0 },
/* U+46ce */ { 0, 0, 0, 0, 0 },
/* U+46cf */ { 0, 0, 0, 0, 0 },
/* U+46d0 */ { 0, 0, 0, 0, 0 },
/* U+46d1 */ { 0, 0, 0, 0, 0 },
/* U+46d2 */ { 0, 0, 0, 0, 0 },
/* U+46d3 */ { 0, 0, 0, 0, 0 },
/* U+46d4 */ { 0, 0, 0, 0, 0 },
/* U+46d5 */ { 0, 0, 0, 0, 0 },
/* U+46d6 */ { 0, 0, 0, 0, 0 },
/* U+46d7 */ { 0, 0, 0, 0, 0 },
/* U+46d8 */ { 0, 0, 0, 0, 0 },
/* U+46d9 */ { 0, 0, 0, 0, 0 },
/* U+46da */ { 0, 0, 0, 0, 0 },
/* U+46db */ { 0, 0, 0, 0, 0 },
/* U+46dc */ { 0, 0, 0, 0, 0 },
/* U+46dd */ { 0, 0, 0, 0, 0 },
/* U+46de */ { 0, 0, 0, 0, 0 },
/* U+46df */ { 0, 0, 0, 0, 0 },
/* U+46e0 */ { 0, 0, 0, 0, 0 },
/* U+46e1 */ { 0, 0, 0, 0, 0 },
/* U+46e2 */ { 0, 0, 0, 0, 0 },
/* U+46e3 */ { 0, 0, 0, 0, 0 },
/* U+46e4 */ { 0, 0, 0, 0, 0 },
/* U+46e5 */ { 0, 0, 0, 0, 0 },
/* U+46e6 */ { 0, 0, 0, 0, 0 },
/* U+46e7 */ { 0, 0, 0, 0, 0 },
/* U+46e8 */ { 0, 0, 0, 0, 0 },
/* U+46e9 */ { 0, 0, 0, 0, 0 },
/* U+46ea */ { 0, 0, 0, 0, 0 },
/* U+46eb */ { 0, 0, 0, 0, 0 },
/* U+46ec */ { 0, 0, 0, 0, 0 },
/* U+46ed */ { 0, 0, 0, 0, 0 },
/* U+46ee */ { 0, 0, 0, 0, 0 },
/* U+46ef */ { 0, 0, 0, 0, 0 },
/* U+46f0 */ { 0, 0, 0, 0, 0 },
/* U+46f1 */ { 0, 0, 0, 0, 0 },
/* U+46f2 */ { 0, 0, 0, 0, 0 },
/* U+46f3 */ { 0, 0, 0, 0, 0 },
/* U+46f4 */ { 0, 0, 0, 0, 0 },
/* U+46f5 */ { 0, 0, 0, 0, 0 },
/* U+46f6 */ { 0, 0, 0, 0, 0 },
/* U+46f7 */ { 0, 0, 0, 0, 0 },
/* U+46f8 */ { 0, 0, 0, 0, 0 },
/* U+46f9 */ { 0, 0, 0, 0, 0 },
/* U+46fa */ { 0, 0, 0, 0, 0 },
/* U+46fb */ { 0, 0, 0, 0, 0 },
/* U+46fc */ { 0, 0, 0, 0, 0 },
/* U+46fd */ { 0, 0, 0, 0, 0 },
/* U+46fe */ { 0, 0, 0, 0, 0 },
/* U+46ff */ { 0, 0, 0, 0, 0 },
/* U+4700 */ { 0, 0, 0, 0, 0 },
/* U+4701 */ { 0, 0, 0, 0, 0 },
/* U+4702 */ { 0, 0, 0, 0, 0 },
/* U+4703 */ { 0, 0, 0, 0, 0 },
/* U+4704 */ { 0, 0, 0, 0, 0 },
/* U+4705 */ { 0, 0, 0, 0, 0 },
/* U+4706 */ { 0, 0, 0, 0, 0 },
/* U+4707 */ { 0, 0, 0, 0, 0 },
/* U+4708 */ { 0, 0, 0, 0, 0 },
/* U+4709 */ { 0, 0, 0, 0, 0 },
/* U+470a */ { 0, 0, 0, 0, 0 },
/* U+470b */ { 0, 0, 0, 0, 0 },
/* U+470c */ { 0, 0, 0, 0, 0 },
/* U+470d */ { 0, 0, 0, 0, 0 },
/* U+470e */ { 0, 0, 0, 0, 0 },
/* U+470f */ { 0, 0, 0, 0, 0 },
/* U+4710 */ { 0, 0, 0, 0, 0 },
/* U+4711 */ { 0, 0, 0, 0, 0 },
/* U+4712 */ { 0, 0, 0, 0, 0 },
/* U+4713 */ { 0, 0, 0, 0, 0 },
/* U+4714 */ { 0, 0, 0, 0, 0 },
/* U+4715 */ { 0, 0, 0, 0, 0 },
/* U+4716 */ { 0, 0, 0, 0, 0 },
/* U+4717 */ { 0, 0, 0, 0, 0 },
/* U+4718 */ { 0, 0, 0, 0, 0 },
/* U+4719 */ { 0, 0, 0, 0, 0 },
/* U+471a */ { 0, 0, 0, 0, 0 },
/* U+471b */ { 0, 0, 0, 0, 0 },
/* U+471c */ { 0, 0, 0, 0, 0 },
/* U+471d */ { 0, 0, 0, 0, 0 },
/* U+471e */ { 0, 0, 0, 0, 0 },
/* U+471f */ { 0, 0, 0, 0, 0 },
/* U+4720 */ { 0, 0, 0, 0, 0 },
/* U+4721 */ { 0, 0, 0, 0, 0 },
/* U+4722 */ { 0, 0, 0, 0, 0 },
/* U+4723 */ { 0, 0, 0, 0, 0 },
/* U+4724 */ { 0, 0, 0, 0, 0 },
/* U+4725 */ { 0, 0, 0, 0, 0 },
/* U+4726 */ { 0, 0, 0, 0, 0 },
/* U+4727 */ { 0, 0, 0, 0, 0 },
/* U+4728 */ { 0, 0, 0, 0, 0 },
/* U+4729 */ { 0, 0, 0, 0, 0 },
/* U+472a */ { 0, 0, 0, 0, 0 },
/* U+472b */ { 0, 0, 0, 0, 0 },
/* U+472c */ { 0, 0, 0, 0, 0 },
/* U+472d */ { 0, 0, 0, 0, 0 },
/* U+472e */ { 0, 0, 0, 0, 0 },
/* U+472f */ { 0, 0, 0, 0, 0 },
/* U+4730 */ { 0, 0, 0, 0, 0 },
/* U+4731 */ { 0, 0, 0, 0, 0 },
/* U+4732 */ { 0, 0, 0, 0, 0 },
/* U+4733 */ { 0, 0, 0, 0, 0 },
/* U+4734 */ { 0, 0, 0, 0, 0 },
/* U+4735 */ { 0, 0, 0, 0, 0 },
/* U+4736 */ { 0, 0, 0, 0, 0 },
/* U+4737 */ { 0, 0, 0, 0, 0 },
/* U+4738 */ { 0, 0, 0, 0, 0 },
/* U+4739 */ { 0, 0, 0, 0, 0 },
/* U+473a */ { 0, 0, 0, 0, 0 },
/* U+473b */ { 0, 0, 0, 0, 0 },
/* U+473c */ { 0, 0, 0, 0, 0 },
/* U+473d */ { 0, 0, 0, 0, 0 },
/* U+473e */ { 0, 0, 0, 0, 0 },
/* U+473f */ { 0, 0, 0, 0, 0 },
/* U+4740 */ { 0, 0, 0, 0, 0 },
/* U+4741 */ { 0, 0, 0, 0, 0 },
/* U+4742 */ { 0, 0, 0, 0, 0 },
/* U+4743 */ { 0, 0, 0, 0, 0 },
/* U+4744 */ { 0, 0, 0, 0, 0 },
/* U+4745 */ { 0, 0, 0, 0, 0 },
/* U+4746 */ { 0, 0, 0, 0, 0 },
/* U+4747 */ { 0, 0, 0, 0, 0 },
/* U+4748 */ { 0, 0, 0, 0, 0 },
/* U+4749 */ { 0, 0, 0, 0, 0 },
/* U+474a */ { 0, 0, 0, 0, 0 },
/* U+474b */ { 0, 0, 0, 0, 0 },
/* U+474c */ { 0, 0, 0, 0, 0 },
/* U+474d */ { 0, 0, 0, 0, 0 },
/* U+474e */ { 0, 0, 0, 0, 0 },
/* U+474f */ { 0, 0, 0, 0, 0 },
/* U+4750 */ { 0, 0, 0, 0, 0 },
/* U+4751 */ { 0, 0, 0, 0, 0 },
/* U+4752 */ { 0, 0, 0, 0, 0 },
/* U+4753 */ { 0, 0, 0, 0, 0 },
/* U+4754 */ { 0, 0, 0, 0, 0 },
/* U+4755 */ { 0, 0, 0, 0, 0 },
/* U+4756 */ { 0, 0, 0, 0, 0 },
/* U+4757 */ { 0, 0, 0, 0, 0 },
/* U+4758 */ { 0, 0, 0, 0, 0 },
/* U+4759 */ { 0, 0, 0, 0, 0 },
/* U+475a */ { 0, 0, 0, 0, 0 },
/* U+475b */ { 0, 0, 0, 0, 0 },
/* U+475c */ { 0, 0, 0, 0, 0 },
/* U+475d */ { 0, 0, 0, 0, 0 },
/* U+475e */ { 0, 0, 0, 0, 0 },
/* U+475f */ { 0, 0, 0, 0, 0 },
/* U+4760 */ { 0, 0, 0, 0, 0 },
/* U+4761 */ { 0, 0, 0, 0, 0 },
/* U+4762 */ { 0, 0, 0, 0, 0 },
/* U+4763 */ { 0, 0, 0, 0, 0 },
/* U+4764 */ { 0, 0, 0, 0, 0 },
/* U+4765 */ { 0, 0, 0, 0, 0 },
/* U+4766 */ { 0, 0, 0, 0, 0 },
/* U+4767 */ { 0, 0, 0, 0, 0 },
/* U+4768 */ { 0, 0, 0, 0, 0 },
/* U+4769 */ { 0, 0, 0, 0, 0 },
/* U+476a */ { 0, 0, 0, 0, 0 },
/* U+476b */ { 0, 0, 0, 0, 0 },
/* U+476c */ { 0, 0, 0, 0, 0 },
/* U+476d */ { 0, 0, 0, 0, 0 },
/* U+476e */ { 0, 0, 0, 0, 0 },
/* U+476f */ { 0, 0, 0, 0, 0 },
/* U+4770 */ { 0, 0, 0, 0, 0 },
/* U+4771 */ { 0, 0, 0, 0, 0 },
/* U+4772 */ { 0, 0, 0, 0, 0 },
/* U+4773 */ { 0, 0, 0, 0, 0 },
/* U+4774 */ { 0, 0, 0, 0, 0 },
/* U+4775 */ { 0, 0, 0, 0, 0 },
/* U+4776 */ { 0, 0, 0, 0, 0 },
/* U+4777 */ { 0, 0, 0, 0, 0 },
/* U+4778 */ { 0, 0, 0, 0, 0 },
/* U+4779 */ { 0, 0, 0, 0, 0 },
/* U+477a */ { 0, 0, 0, 0, 0 },
/* U+477b */ { 0, 0, 0, 0, 0 },
/* U+477c */ { 0, 0, 0, 0, 0 },
/* U+477d */ { 0, 0, 0, 0, 0 },
/* U+477e */ { 0, 0, 0, 0, 0 },
/* U+477f */ { 0, 0, 0, 0, 0 },
/* U+4780 */ { 0, 0, 0, 0, 0 },
/* U+4781 */ { 0, 0, 0, 0, 0 },
/* U+4782 */ { 0, 0, 0, 0, 0 },
/* U+4783 */ { 0, 0, 0, 0, 0 },
/* U+4784 */ { 0, 0, 0, 0, 0 },
/* U+4785 */ { 0, 0, 0, 0, 0 },
/* U+4786 */ { 0, 0, 0, 0, 0 },
/* U+4787 */ { 0, 0, 0, 0, 0 },
/* U+4788 */ { 0, 0, 0, 0, 0 },
/* U+4789 */ { 0, 0, 0, 0, 0 },
/* U+478a */ { 0, 0, 0, 0, 0 },
/* U+478b */ { 0, 0, 0, 0, 0 },
/* U+478c */ { 0, 0, 0, 0, 0 },
/* U+478d */ { 0, 0, 0, 0, 0 },
/* U+478e */ { 0, 0, 0, 0, 0 },
/* U+478f */ { 0, 0, 0, 0, 0 },
/* U+4790 */ { 0, 0, 0, 0, 0 },
/* U+4791 */ { 0, 0, 0, 0, 0 },
/* U+4792 */ { 0, 0, 0, 0, 0 },
/* U+4793 */ { 0, 0, 0, 0, 0 },
/* U+4794 */ { 0, 0, 0, 0, 0 },
/* U+4795 */ { 0, 0, 0, 0, 0 },
/* U+4796 */ { 0, 0, 0, 0, 0 },
/* U+4797 */ { 0, 0, 0, 0, 0 },
/* U+4798 */ { 0, 0, 0, 0, 0 },
/* U+4799 */ { 0, 0, 0, 0, 0 },
/* U+479a */ { 0, 0, 0, 0, 0 },
/* U+479b */ { 0, 0, 0, 0, 0 },
/* U+479c */ { 0, 0, 0, 0, 0 },
/* U+479d */ { 0, 0, 0, 0, 0 },
/* U+479e */ { 0, 0, 0, 0, 0 },
/* U+479f */ { 0, 0, 0, 0, 0 },
/* U+47a0 */ { 0, 0, 0, 0, 0 },
/* U+47a1 */ { 0, 0, 0, 0, 0 },
/* U+47a2 */ { 0, 0, 0, 0, 0 },
/* U+47a3 */ { 0, 0, 0, 0, 0 },
/* U+47a4 */ { 0, 0, 0, 0, 0 },
/* U+47a5 */ { 0, 0, 0, 0, 0 },
/* U+47a6 */ { 0, 0, 0, 0, 0 },
/* U+47a7 */ { 0, 0, 0, 0, 0 },
/* U+47a8 */ { 0, 0, 0, 0, 0 },
/* U+47a9 */ { 0, 0, 0, 0, 0 },
/* U+47aa */ { 0, 0, 0, 0, 0 },
/* U+47ab */ { 0, 0, 0, 0, 0 },
/* U+47ac */ { 0, 0, 0, 0, 0 },
/* U+47ad */ { 0, 0, 0, 0, 0 },
/* U+47ae */ { 0, 0, 0, 0, 0 },
/* U+47af */ { 0, 0, 0, 0, 0 },
/* U+47b0 */ { 0, 0, 0, 0, 0 },
/* U+47b1 */ { 0, 0, 0, 0, 0 },
/* U+47b2 */ { 0, 0, 0, 0, 0 },
/* U+47b3 */ { 0, 0, 0, 0, 0 },
/* U+47b4 */ { 0, 0, 0, 0, 0 },
/* U+47b5 */ { 0, 0, 0, 0, 0 },
/* U+47b6 */ { 0, 0, 0, 0, 0 },
/* U+47b7 */ { 0, 0, 0, 0, 0 },
/* U+47b8 */ { 0, 0, 0, 0, 0 },
/* U+47b9 */ { 0, 0, 0, 0, 0 },
/* U+47ba */ { 0, 0, 0, 0, 0 },
/* U+47bb */ { 0, 0, 0, 0, 0 },
/* U+47bc */ { 0, 0, 0, 0, 0 },
/* U+47bd */ { 0, 0, 0, 0, 0 },
/* U+47be */ { 0, 0, 0, 0, 0 },
/* U+47bf */ { 0, 0, 0, 0, 0 },
/* U+47c0 */ { 0, 0, 0, 0, 0 },
/* U+47c1 */ { 0, 0, 0, 0, 0 },
/* U+47c2 */ { 0, 0, 0, 0, 0 },
/* U+47c3 */ { 0, 0, 0, 0, 0 },
/* U+47c4 */ { 0, 0, 0, 0, 0 },
/* U+47c5 */ { 0, 0, 0, 0, 0 },
/* U+47c6 */ { 0, 0, 0, 0, 0 },
/* U+47c7 */ { 0, 0, 0, 0, 0 },
/* U+47c8 */ { 0, 0, 0, 0, 0 },
/* U+47c9 */ { 0, 0, 0, 0, 0 },
/* U+47ca */ { 0, 0, 0, 0, 0 },
/* U+47cb */ { 0, 0, 0, 0, 0 },
/* U+47cc */ { 0, 0, 0, 0, 0 },
/* U+47cd */ { 0, 0, 0, 0, 0 },
/* U+47ce */ { 0, 0, 0, 0, 0 },
/* U+47cf */ { 0, 0, 0, 0, 0 },
/* U+47d0 */ { 0, 0, 0, 0, 0 },
/* U+47d1 */ { 0, 0, 0, 0, 0 },
/* U+47d2 */ { 0, 0, 0, 0, 0 },
/* U+47d3 */ { 0, 0, 0, 0, 0 },
/* U+47d4 */ { 0, 0, 0, 0, 0 },
/* U+47d5 */ { 0, 0, 0, 0, 0 },
/* U+47d6 */ { 0, 0, 0, 0, 0 },
/* U+47d7 */ { 0, 0, 0, 0, 0 },
/* U+47d8 */ { 0, 0, 0, 0, 0 },
/* U+47d9 */ { 0, 0, 0, 0, 0 },
/* U+47da */ { 0, 0, 0, 0, 0 },
/* U+47db */ { 0, 0, 0, 0, 0 },
/* U+47dc */ { 0, 0, 0, 0, 0 },
/* U+47dd */ { 0, 0, 0, 0, 0 },
/* U+47de */ { 0, 0, 0, 0, 0 },
/* U+47df */ { 0, 0, 0, 0, 0 },
/* U+47e0 */ { 0, 0, 0, 0, 0 },
/* U+47e1 */ { 0, 0, 0, 0, 0 },
/* U+47e2 */ { 0, 0, 0, 0, 0 },
/* U+47e3 */ { 0, 0, 0, 0, 0 },
/* U+47e4 */ { 0, 0, 0, 0, 0 },
/* U+47e5 */ { 0, 0, 0, 0, 0 },
/* U+47e6 */ { 0, 0, 0, 0, 0 },
/* U+47e7 */ { 0, 0, 0, 0, 0 },
/* U+47e8 */ { 0, 0, 0, 0, 0 },
/* U+47e9 */ { 0, 0, 0, 0, 0 },
/* U+47ea */ { 0, 0, 0, 0, 0 },
/* U+47eb */ { 0, 0, 0, 0, 0 },
/* U+47ec */ { 0, 0, 0, 0, 0 },
/* U+47ed */ { 0, 0, 0, 0, 0 },
/* U+47ee */ { 0, 0, 0, 0, 0 },
/* U+47ef */ { 0, 0, 0, 0, 0 },
/* U+47f0 */ { 0, 0, 0, 0, 0 },
/* U+47f1 */ { 0, 0, 0, 0, 0 },
/* U+47f2 */ { 0, 0, 0, 0, 0 },
/* U+47f3 */ { 0, 0, 0, 0, 0 },
/* U+47f4 */ { 0, 0, 0, 0, 0 },
/* U+47f5 */ { 0, 0, 0, 0, 0 },
/* U+47f6 */ { 0, 0, 0, 0, 0 },
/* U+47f7 */ { 0, 0, 0, 0, 0 },
/* U+47f8 */ { 0, 0, 0, 0, 0 },
/* U+47f9 */ { 0, 0, 0, 0, 0 },
/* U+47fa */ { 0, 0, 0, 0, 0 },
/* U+47fb */ { 0, 0, 0, 0, 0 },
/* U+47fc */ { 0, 0, 0, 0, 0 },
/* U+47fd */ { 0, 0, 0, 0, 0 },
/* U+47fe */ { 0, 0, 0, 0, 0 },
/* U+47ff */ { 0, 0, 0, 0, 0 },
/* U+4800 */ { 0, 0, 0, 0, 0 },
/* U+4801 */ { 0, 0, 0, 0, 0 },
/* U+4802 */ { 0, 0, 0, 0, 0 },
/* U+4803 */ { 0, 0, 0, 0, 0 },
/* U+4804 */ { 0, 0, 0, 0, 0 },
/* U+4805 */ { 0, 0, 0, 0, 0 },
/* U+4806 */ { 0, 0, 0, 0, 0 },
/* U+4807 */ { 0, 0, 0, 0, 0 },
/* U+4808 */ { 0, 0, 0, 0, 0 },
/* U+4809 */ { 0, 0, 0, 0, 0 },
/* U+480a */ { 0, 0, 0, 0, 0 },
/* U+480b */ { 0, 0, 0, 0, 0 },
/* U+480c */ { 0, 0, 0, 0, 0 },
/* U+480d */ { 0, 0, 0, 0, 0 },
/* U+480e */ { 0, 0, 0, 0, 0 },
/* U+480f */ { 0, 0, 0, 0, 0 },
/* U+4810 */ { 0, 0, 0, 0, 0 },
/* U+4811 */ { 0, 0, 0, 0, 0 },
/* U+4812 */ { 0, 0, 0, 0, 0 },
/* U+4813 */ { 0, 0, 0, 0, 0 },
/* U+4814 */ { 0, 0, 0, 0, 0 },
/* U+4815 */ { 0, 0, 0, 0, 0 },
/* U+4816 */ { 0, 0, 0, 0, 0 },
/* U+4817 */ { 0, 0, 0, 0, 0 },
/* U+4818 */ { 0, 0, 0, 0, 0 },
/* U+4819 */ { 0, 0, 0, 0, 0 },
/* U+481a */ { 0, 0, 0, 0, 0 },
/* U+481b */ { 0, 0, 0, 0, 0 },
/* U+481c */ { 0, 0, 0, 0, 0 },
/* U+481d */ { 0, 0, 0, 0, 0 },
/* U+481e */ { 0, 0, 0, 0, 0 },
/* U+481f */ { 0, 0, 0, 0, 0 },
/* U+4820 */ { 0, 0, 0, 0, 0 },
/* U+4821 */ { 0, 0, 0, 0, 0 },
/* U+4822 */ { 0, 0, 0, 0, 0 },
/* U+4823 */ { 0, 0, 0, 0, 0 },
/* U+4824 */ { 0, 0, 0, 0, 0 },
/* U+4825 */ { 0, 0, 0, 0, 0 },
/* U+4826 */ { 0, 0, 0, 0, 0 },
/* U+4827 */ { 0, 0, 0, 0, 0 },
/* U+4828 */ { 0, 0, 0, 0, 0 },
/* U+4829 */ { 0, 0, 0, 0, 0 },
/* U+482a */ { 0, 0, 0, 0, 0 },
/* U+482b */ { 0, 0, 0, 0, 0 },
/* U+482c */ { 0, 0, 0, 0, 0 },
/* U+482d */ { 0, 0, 0, 0, 0 },
/* U+482e */ { 0, 0, 0, 0, 0 },
/* U+482f */ { 0, 0, 0, 0, 0 },
/* U+4830 */ { 0, 0, 0, 0, 0 },
/* U+4831 */ { 0, 0, 0, 0, 0 },
/* U+4832 */ { 0, 0, 0, 0, 0 },
/* U+4833 */ { 0, 0, 0, 0, 0 },
/* U+4834 */ { 0, 0, 0, 0, 0 },
/* U+4835 */ { 0, 0, 0, 0, 0 },
/* U+4836 */ { 0, 0, 0, 0, 0 },
/* U+4837 */ { 0, 0, 0, 0, 0 },
/* U+4838 */ { 0, 0, 0, 0, 0 },
/* U+4839 */ { 0, 0, 0, 0, 0 },
/* U+483a */ { 0, 0, 0, 0, 0 },
/* U+483b */ { 0, 0, 0, 0, 0 },
/* U+483c */ { 0, 0, 0, 0, 0 },
/* U+483d */ { 0, 0, 0, 0, 0 },
/* U+483e */ { 0, 0, 0, 0, 0 },
/* U+483f */ { 0, 0, 0, 0, 0 },
/* U+4840 */ { 0, 0, 0, 0, 0 },
/* U+4841 */ { 0, 0, 0, 0, 0 },
/* U+4842 */ { 0, 0, 0, 0, 0 },
/* U+4843 */ { 0, 0, 0, 0, 0 },
/* U+4844 */ { 0, 0, 0, 0, 0 },
/* U+4845 */ { 0, 0, 0, 0, 0 },
/* U+4846 */ { 0, 0, 0, 0, 0 },
/* U+4847 */ { 0, 0, 0, 0, 0 },
/* U+4848 */ { 0, 0, 0, 0, 0 },
/* U+4849 */ { 0, 0, 0, 0, 0 },
/* U+484a */ { 0, 0, 0, 0, 0 },
/* U+484b */ { 0, 0, 0, 0, 0 },
/* U+484c */ { 0, 0, 0, 0, 0 },
/* U+484d */ { 0, 0, 0, 0, 0 },
/* U+484e */ { 0, 0, 0, 0, 0 },
/* U+484f */ { 0, 0, 0, 0, 0 },
/* U+4850 */ { 0, 0, 0, 0, 0 },
/* U+4851 */ { 0, 0, 0, 0, 0 },
/* U+4852 */ { 0, 0, 0, 0, 0 },
/* U+4853 */ { 0, 0, 0, 0, 0 },
/* U+4854 */ { 0, 0, 0, 0, 0 },
/* U+4855 */ { 0, 0, 0, 0, 0 },
/* U+4856 */ { 0, 0, 0, 0, 0 },
/* U+4857 */ { 0, 0, 0, 0, 0 },
/* U+4858 */ { 0, 0, 0, 0, 0 },
/* U+4859 */ { 0, 0, 0, 0, 0 },
/* U+485a */ { 0, 0, 0, 0, 0 },
/* U+485b */ { 0, 0, 0, 0, 0 },
/* U+485c */ { 0, 0, 0, 0, 0 },
/* U+485d */ { 0, 0, 0, 0, 0 },
/* U+485e */ { 0, 0, 0, 0, 0 },
/* U+485f */ { 0, 0, 0, 0, 0 },
/* U+4860 */ { 0, 0, 0, 0, 0 },
/* U+4861 */ { 0, 0, 0, 0, 0 },
/* U+4862 */ { 0, 0, 0, 0, 0 },
/* U+4863 */ { 0, 0, 0, 0, 0 },
/* U+4864 */ { 0, 0, 0, 0, 0 },
/* U+4865 */ { 0, 0, 0, 0, 0 },
/* U+4866 */ { 0, 0, 0, 0, 0 },
/* U+4867 */ { 0, 0, 0, 0, 0 },
/* U+4868 */ { 0, 0, 0, 0, 0 },
/* U+4869 */ { 0, 0, 0, 0, 0 },
/* U+486a */ { 0, 0, 0, 0, 0 },
/* U+486b */ { 0, 0, 0, 0, 0 },
/* U+486c */ { 0, 0, 0, 0, 0 },
/* U+486d */ { 0, 0, 0, 0, 0 },
/* U+486e */ { 0, 0, 0, 0, 0 },
/* U+486f */ { 0, 0, 0, 0, 0 },
/* U+4870 */ { 0, 0, 0, 0, 0 },
/* U+4871 */ { 0, 0, 0, 0, 0 },
/* U+4872 */ { 0, 0, 0, 0, 0 },
/* U+4873 */ { 0, 0, 0, 0, 0 },
/* U+4874 */ { 0, 0, 0, 0, 0 },
/* U+4875 */ { 0, 0, 0, 0, 0 },
/* U+4876 */ { 0, 0, 0, 0, 0 },
/* U+4877 */ { 0, 0, 0, 0, 0 },
/* U+4878 */ { 0, 0, 0, 0, 0 },
/* U+4879 */ { 0, 0, 0, 0, 0 },
/* U+487a */ { 0, 0, 0, 0, 0 },
/* U+487b */ { 0, 0, 0, 0, 0 },
/* U+487c */ { 0, 0, 0, 0, 0 },
/* U+487d */ { 0, 0, 0, 0, 0 },
/* U+487e */ { 0, 0, 0, 0, 0 },
/* U+487f */ { 0, 0, 0, 0, 0 },
/* U+4880 */ { 0, 0, 0, 0, 0 },
/* U+4881 */ { 0, 0, 0, 0, 0 },
/* U+4882 */ { 0, 0, 0, 0, 0 },
/* U+4883 */ { 0, 0, 0, 0, 0 },
/* U+4884 */ { 0, 0, 0, 0, 0 },
/* U+4885 */ { 0, 0, 0, 0, 0 },
/* U+4886 */ { 0, 0, 0, 0, 0 },
/* U+4887 */ { 0, 0, 0, 0, 0 },
/* U+4888 */ { 0, 0, 0, 0, 0 },
/* U+4889 */ { 0, 0, 0, 0, 0 },
/* U+488a */ { 0, 0, 0, 0, 0 },
/* U+488b */ { 0, 0, 0, 0, 0 },
/* U+488c */ { 0, 0, 0, 0, 0 },
/* U+488d */ { 0, 0, 0, 0, 0 },
/* U+488e */ { 0, 0, 0, 0, 0 },
/* U+488f */ { 0, 0, 0, 0, 0 },
/* U+4890 */ { 0, 0, 0, 0, 0 },
/* U+4891 */ { 0, 0, 0, 0, 0 },
/* U+4892 */ { 0, 0, 0, 0, 0 },
/* U+4893 */ { 0, 0, 0, 0, 0 },
/* U+4894 */ { 0, 0, 0, 0, 0 },
/* U+4895 */ { 0, 0, 0, 0, 0 },
/* U+4896 */ { 0, 0, 0, 0, 0 },
/* U+4897 */ { 0, 0, 0, 0, 0 },
/* U+4898 */ { 0, 0, 0, 0, 0 },
/* U+4899 */ { 0, 0, 0, 0, 0 },
/* U+489a */ { 0, 0, 0, 0, 0 },
/* U+489b */ { 0, 0, 0, 0, 0 },
/* U+489c */ { 0, 0, 0, 0, 0 },
/* U+489d */ { 0, 0, 0, 0, 0 },
/* U+489e */ { 0, 0, 0, 0, 0 },
/* U+489f */ { 0, 0, 0, 0, 0 },
/* U+48a0 */ { 0, 0, 0, 0, 0 },
/* U+48a1 */ { 0, 0, 0, 0, 0 },
/* U+48a2 */ { 0, 0, 0, 0, 0 },
/* U+48a3 */ { 0, 0, 0, 0, 0 },
/* U+48a4 */ { 0, 0, 0, 0, 0 },
/* U+48a5 */ { 0, 0, 0, 0, 0 },
/* U+48a6 */ { 0, 0, 0, 0, 0 },
/* U+48a7 */ { 0, 0, 0, 0, 0 },
/* U+48a8 */ { 0, 0, 0, 0, 0 },
/* U+48a9 */ { 0, 0, 0, 0, 0 },
/* U+48aa */ { 0, 0, 0, 0, 0 },
/* U+48ab */ { 0, 0, 0, 0, 0 },
/* U+48ac */ { 0, 0, 0, 0, 0 },
/* U+48ad */ { 0, 0, 0, 0, 0 },
/* U+48ae */ { 0, 0, 0, 0, 0 },
/* U+48af */ { 0, 0, 0, 0, 0 },
/* U+48b0 */ { 0, 0, 0, 0, 0 },
/* U+48b1 */ { 0, 0, 0, 0, 0 },
/* U+48b2 */ { 0, 0, 0, 0, 0 },
/* U+48b3 */ { 0, 0, 0, 0, 0 },
/* U+48b4 */ { 0, 0, 0, 0, 0 },
/* U+48b5 */ { 0, 0, 0, 0, 0 },
/* U+48b6 */ { 0, 0, 0, 0, 0 },
/* U+48b7 */ { 0, 0, 0, 0, 0 },
/* U+48b8 */ { 0, 0, 0, 0, 0 },
/* U+48b9 */ { 0, 0, 0, 0, 0 },
/* U+48ba */ { 0, 0, 0, 0, 0 },
/* U+48bb */ { 0, 0, 0, 0, 0 },
/* U+48bc */ { 0, 0, 0, 0, 0 },
/* U+48bd */ { 0, 0, 0, 0, 0 },
/* U+48be */ { 0, 0, 0, 0, 0 },
/* U+48bf */ { 0, 0, 0, 0, 0 },
/* U+48c0 */ { 0, 0, 0, 0, 0 },
/* U+48c1 */ { 0, 0, 0, 0, 0 },
/* U+48c2 */ { 0, 0, 0, 0, 0 },
/* U+48c3 */ { 0, 0, 0, 0, 0 },
/* U+48c4 */ { 0, 0, 0, 0, 0 },
/* U+48c5 */ { 0, 0, 0, 0, 0 },
/* U+48c6 */ { 0, 0, 0, 0, 0 },
/* U+48c7 */ { 0, 0, 0, 0, 0 },
/* U+48c8 */ { 0, 0, 0, 0, 0 },
/* U+48c9 */ { 0, 0, 0, 0, 0 },
/* U+48ca */ { 0, 0, 0, 0, 0 },
/* U+48cb */ { 0, 0, 0, 0, 0 },
/* U+48cc */ { 0, 0, 0, 0, 0 },
/* U+48cd */ { 0, 0, 0, 0, 0 },
/* U+48ce */ { 0, 0, 0, 0, 0 },
/* U+48cf */ { 0, 0, 0, 0, 0 },
/* U+48d0 */ { 0, 0, 0, 0, 0 },
/* U+48d1 */ { 0, 0, 0, 0, 0 },
/* U+48d2 */ { 0, 0, 0, 0, 0 },
/* U+48d3 */ { 0, 0, 0, 0, 0 },
/* U+48d4 */ { 0, 0, 0, 0, 0 },
/* U+48d5 */ { 0, 0, 0, 0, 0 },
/* U+48d6 */ { 0, 0, 0, 0, 0 },
/* U+48d7 */ { 0, 0, 0, 0, 0 },
/* U+48d8 */ { 0, 0, 0, 0, 0 },
/* U+48d9 */ { 0, 0, 0, 0, 0 },
/* U+48da */ { 0, 0, 0, 0, 0 },
/* U+48db */ { 0, 0, 0, 0, 0 },
/* U+48dc */ { 0, 0, 0, 0, 0 },
/* U+48dd */ { 0, 0, 0, 0, 0 },
/* U+48de */ { 0, 0, 0, 0, 0 },
/* U+48df */ { 0, 0, 0, 0, 0 },
/* U+48e0 */ { 0, 0, 0, 0, 0 },
/* U+48e1 */ { 0, 0, 0, 0, 0 },
/* U+48e2 */ { 0, 0, 0, 0, 0 },
/* U+48e3 */ { 0, 0, 0, 0, 0 },
/* U+48e4 */ { 0, 0, 0, 0, 0 },
/* U+48e5 */ { 0, 0, 0, 0, 0 },
/* U+48e6 */ { 0, 0, 0, 0, 0 },
/* U+48e7 */ { 0, 0, 0, 0, 0 },
/* U+48e8 */ { 0, 0, 0, 0, 0 },
/* U+48e9 */ { 0, 0, 0, 0, 0 },
/* U+48ea */ { 0, 0, 0, 0, 0 },
/* U+48eb */ { 0, 0, 0, 0, 0 },
/* U+48ec */ { 0, 0, 0, 0, 0 },
/* U+48ed */ { 0, 0, 0, 0, 0 },
/* U+48ee */ { 0, 0, 0, 0, 0 },
/* U+48ef */ { 0, 0, 0, 0, 0 },
/* U+48f0 */ { 0, 0, 0, 0, 0 },
/* U+48f1 */ { 0, 0, 0, 0, 0 },
/* U+48f2 */ { 0, 0, 0, 0, 0 },
/* U+48f3 */ { 0, 0, 0, 0, 0 },
/* U+48f4 */ { 0, 0, 0, 0, 0 },
/* U+48f5 */ { 0, 0, 0, 0, 0 },
/* U+48f6 */ { 0, 0, 0, 0, 0 },
/* U+48f7 */ { 0, 0, 0, 0, 0 },
/* U+48f8 */ { 0, 0, 0, 0, 0 },
/* U+48f9 */ { 0, 0, 0, 0, 0 },
/* U+48fa */ { 0, 0, 0, 0, 0 },
/* U+48fb */ { 0, 0, 0, 0, 0 },
/* U+48fc */ { 0, 0, 0, 0, 0 },
/* U+48fd */ { 0, 0, 0, 0, 0 },
/* U+48fe */ { 0, 0, 0, 0, 0 },
/* U+48ff */ { 0, 0, 0, 0, 0 },
/* U+4900 */ { 0, 0, 0, 0, 0 },
/* U+4901 */ { 0, 0, 0, 0, 0 },
/* U+4902 */ { 0, 0, 0, 0, 0 },
/* U+4903 */ { 0, 0, 0, 0, 0 },
/* U+4904 */ { 0, 0, 0, 0, 0 },
/* U+4905 */ { 0, 0, 0, 0, 0 },
/* U+4906 */ { 0, 0, 0, 0, 0 },
/* U+4907 */ { 0, 0, 0, 0, 0 },
/* U+4908 */ { 0, 0, 0, 0, 0 },
/* U+4909 */ { 0, 0, 0, 0, 0 },
/* U+490a */ { 0, 0, 0, 0, 0 },
/* U+490b */ { 0, 0, 0, 0, 0 },
/* U+490c */ { 0, 0, 0, 0, 0 },
/* U+490d */ { 0, 0, 0, 0, 0 },
/* U+490e */ { 0, 0, 0, 0, 0 },
/* U+490f */ { 0, 0, 0, 0, 0 },
/* U+4910 */ { 0, 0, 0, 0, 0 },
/* U+4911 */ { 0, 0, 0, 0, 0 },
/* U+4912 */ { 0, 0, 0, 0, 0 },
/* U+4913 */ { 0, 0, 0, 0, 0 },
/* U+4914 */ { 0, 0, 0, 0, 0 },
/* U+4915 */ { 0, 0, 0, 0, 0 },
/* U+4916 */ { 0, 0, 0, 0, 0 },
/* U+4917 */ { 0, 0, 0, 0, 0 },
/* U+4918 */ { 0, 0, 0, 0, 0 },
/* U+4919 */ { 0, 0, 0, 0, 0 },
/* U+491a */ { 0, 0, 0, 0, 0 },
/* U+491b */ { 0, 0, 0, 0, 0 },
/* U+491c */ { 0, 0, 0, 0, 0 },
/* U+491d */ { 0, 0, 0, 0, 0 },
/* U+491e */ { 0, 0, 0, 0, 0 },
/* U+491f */ { 0, 0, 0, 0, 0 },
/* U+4920 */ { 0, 0, 0, 0, 0 },
/* U+4921 */ { 0, 0, 0, 0, 0 },
/* U+4922 */ { 0, 0, 0, 0, 0 },
/* U+4923 */ { 0, 0, 0, 0, 0 },
/* U+4924 */ { 0, 0, 0, 0, 0 },
/* U+4925 */ { 0, 0, 0, 0, 0 },
/* U+4926 */ { 0, 0, 0, 0, 0 },
/* U+4927 */ { 0, 0, 0, 0, 0 },
/* U+4928 */ { 0, 0, 0, 0, 0 },
/* U+4929 */ { 0, 0, 0, 0, 0 },
/* U+492a */ { 0, 0, 0, 0, 0 },
/* U+492b */ { 0, 0, 0, 0, 0 },
/* U+492c */ { 0, 0, 0, 0, 0 },
/* U+492d */ { 0, 0, 0, 0, 0 },
/* U+492e */ { 0, 0, 0, 0, 0 },
/* U+492f */ { 0, 0, 0, 0, 0 },
/* U+4930 */ { 0, 0, 0, 0, 0 },
/* U+4931 */ { 0, 0, 0, 0, 0 },
/* U+4932 */ { 0, 0, 0, 0, 0 },
/* U+4933 */ { 0, 0, 0, 0, 0 },
/* U+4934 */ { 0, 0, 0, 0, 0 },
/* U+4935 */ { 0, 0, 0, 0, 0 },
/* U+4936 */ { 0, 0, 0, 0, 0 },
/* U+4937 */ { 0, 0, 0, 0, 0 },
/* U+4938 */ { 0, 0, 0, 0, 0 },
/* U+4939 */ { 0, 0, 0, 0, 0 },
/* U+493a */ { 0, 0, 0, 0, 0 },
/* U+493b */ { 0, 0, 0, 0, 0 },
/* U+493c */ { 0, 0, 0, 0, 0 },
/* U+493d */ { 0, 0, 0, 0, 0 },
/* U+493e */ { 0, 0, 0, 0, 0 },
/* U+493f */ { 0, 0, 0, 0, 0 },
/* U+4940 */ { 0, 0, 0, 0, 0 },
/* U+4941 */ { 0, 0, 0, 0, 0 },
/* U+4942 */ { 0, 0, 0, 0, 0 },
/* U+4943 */ { 0, 0, 0, 0, 0 },
/* U+4944 */ { 0, 0, 0, 0, 0 },
/* U+4945 */ { 0, 0, 0, 0, 0 },
/* U+4946 */ { 0, 0, 0, 0, 0 },
/* U+4947 */ { 0, 0, 0, 0, 0 },
/* U+4948 */ { 0, 0, 0, 0, 0 },
/* U+4949 */ { 0, 0, 0, 0, 0 },
/* U+494a */ { 0, 0, 0, 0, 0 },
/* U+494b */ { 0, 0, 0, 0, 0 },
/* U+494c */ { 0, 0, 0, 0, 0 },
/* U+494d */ { 0, 0, 0, 0, 0 },
/* U+494e */ { 0, 0, 0, 0, 0 },
/* U+494f */ { 0, 0, 0, 0, 0 },
/* U+4950 */ { 0, 0, 0, 0, 0 },
/* U+4951 */ { 0, 0, 0, 0, 0 },
/* U+4952 */ { 0, 0, 0, 0, 0 },
/* U+4953 */ { 0, 0, 0, 0, 0 },
/* U+4954 */ { 0, 0, 0, 0, 0 },
/* U+4955 */ { 0, 0, 0, 0, 0 },
/* U+4956 */ { 0, 0, 0, 0, 0 },
/* U+4957 */ { 0, 0, 0, 0, 0 },
/* U+4958 */ { 0, 0, 0, 0, 0 },
/* U+4959 */ { 0, 0, 0, 0, 0 },
/* U+495a */ { 0, 0, 0, 0, 0 },
/* U+495b */ { 0, 0, 0, 0, 0 },
/* U+495c */ { 0, 0, 0, 0, 0 },
/* U+495d */ { 0, 0, 0, 0, 0 },
/* U+495e */ { 0, 0, 0, 0, 0 },
/* U+495f */ { 0, 0, 0, 0, 0 },
/* U+4960 */ { 0, 0, 0, 0, 0 },
/* U+4961 */ { 0, 0, 0, 0, 0 },
/* U+4962 */ { 0, 0, 0, 0, 0 },
/* U+4963 */ { 0, 0, 0, 0, 0 },
/* U+4964 */ { 0, 0, 0, 0, 0 },
/* U+4965 */ { 0, 0, 0, 0, 0 },
/* U+4966 */ { 0, 0, 0, 0, 0 },
/* U+4967 */ { 0, 0, 0, 0, 0 },
/* U+4968 */ { 0, 0, 0, 0, 0 },
/* U+4969 */ { 0, 0, 0, 0, 0 },
/* U+496a */ { 0, 0, 0, 0, 0 },
/* U+496b */ { 0, 0, 0, 0, 0 },
/* U+496c */ { 0, 0, 0, 0, 0 },
/* U+496d */ { 0, 0, 0, 0, 0 },
/* U+496e */ { 0, 0, 0, 0, 0 },
/* U+496f */ { 0, 0, 0, 0, 0 },
/* U+4970 */ { 0, 0, 0, 0, 0 },
/* U+4971 */ { 0, 0, 0, 0, 0 },
/* U+4972 */ { 0, 0, 0, 0, 0 },
/* U+4973 */ { 0, 0, 0, 0, 0 },
/* U+4974 */ { 0, 0, 0, 0, 0 },
/* U+4975 */ { 0, 0, 0, 0, 0 },
/* U+4976 */ { 0, 0, 0, 0, 0 },
/* U+4977 */ { 0, 0, 0, 0, 0 },
/* U+4978 */ { 0, 0, 0, 0, 0 },
/* U+4979 */ { 0, 0, 0, 0, 0 },
/* U+497a */ { 0, 0, 0, 0, 0 },
/* U+497b */ { 0, 0, 0, 0, 0 },
/* U+497c */ { 0, 0, 0, 0, 0 },
/* U+497d */ { 0, 0, 0, 0, 0 },
/* U+497e */ { 0, 0, 0, 0, 0 },
/* U+497f */ { 0, 0, 0, 0, 0 },
/* U+4980 */ { 0, 0, 0, 0, 0 },
/* U+4981 */ { 0, 0, 0, 0, 0 },
/* U+4982 */ { 0, 0, 0, 0, 0 },
/* U+4983 */ { 0, 0, 0, 0, 0 },
/* U+4984 */ { 0, 0, 0, 0, 0 },
/* U+4985 */ { 0, 0, 0, 0, 0 },
/* U+4986 */ { 0, 0, 0, 0, 0 },
/* U+4987 */ { 0, 0, 0, 0, 0 },
/* U+4988 */ { 0, 0, 0, 0, 0 },
/* U+4989 */ { 0, 0, 0, 0, 0 },
/* U+498a */ { 0, 0, 0, 0, 0 },
/* U+498b */ { 0, 0, 0, 0, 0 },
/* U+498c */ { 0, 0, 0, 0, 0 },
/* U+498d */ { 0, 0, 0, 0, 0 },
/* U+498e */ { 0, 0, 0, 0, 0 },
/* U+498f */ { 0, 0, 0, 0, 0 },
/* U+4990 */ { 0, 0, 0, 0, 0 },
/* U+4991 */ { 0, 0, 0, 0, 0 },
/* U+4992 */ { 0, 0, 0, 0, 0 },
/* U+4993 */ { 0, 0, 0, 0, 0 },
/* U+4994 */ { 0, 0, 0, 0, 0 },
/* U+4995 */ { 0, 0, 0, 0, 0 },
/* U+4996 */ { 0, 0, 0, 0, 0 },
/* U+4997 */ { 0, 0, 0, 0, 0 },
/* U+4998 */ { 0, 0, 0, 0, 0 },
/* U+4999 */ { 0, 0, 0, 0, 0 },
/* U+499a */ { 0, 0, 0, 0, 0 },
/* U+499b */ { 0, 0, 0, 0, 0 },
/* U+499c */ { 0, 0, 0, 0, 0 },
/* U+499d */ { 0, 0, 0, 0, 0 },
/* U+499e */ { 0, 0, 0, 0, 0 },
/* U+499f */ { 0, 0, 0, 0, 0 },
/* U+49a0 */ { 0, 0, 0, 0, 0 },
/* U+49a1 */ { 0, 0, 0, 0, 0 },
/* U+49a2 */ { 0, 0, 0, 0, 0 },
/* U+49a3 */ { 0, 0, 0, 0, 0 },
/* U+49a4 */ { 0, 0, 0, 0, 0 },
/* U+49a5 */ { 0, 0, 0, 0, 0 },
/* U+49a6 */ { 0, 0, 0, 0, 0 },
/* U+49a7 */ { 0, 0, 0, 0, 0 },
/* U+49a8 */ { 0, 0, 0, 0, 0 },
/* U+49a9 */ { 0, 0, 0, 0, 0 },
/* U+49aa */ { 0, 0, 0, 0, 0 },
/* U+49ab */ { 0, 0, 0, 0, 0 },
/* U+49ac */ { 0, 0, 0, 0, 0 },
/* U+49ad */ { 0, 0, 0, 0, 0 },
/* U+49ae */ { 0, 0, 0, 0, 0 },
/* U+49af */ { 0, 0, 0, 0, 0 },
/* U+49b0 */ { 0, 0, 0, 0, 0 },
/* U+49b1 */ { 0, 0, 0, 0, 0 },
/* U+49b2 */ { 0, 0, 0, 0, 0 },
/* U+49b3 */ { 0, 0, 0, 0, 0 },
/* U+49b4 */ { 0, 0, 0, 0, 0 },
/* U+49b5 */ { 0, 0, 0, 0, 0 },
/* U+49b6 */ { 0, 0, 0, 0, 0 },
/* U+49b7 */ { 0, 0, 0, 0, 0 },
/* U+49b8 */ { 0, 0, 0, 0, 0 },
/* U+49b9 */ { 0, 0, 0, 0, 0 },
/* U+49ba */ { 0, 0, 0, 0, 0 },
/* U+49bb */ { 0, 0, 0, 0, 0 },
/* U+49bc */ { 0, 0, 0, 0, 0 },
/* U+49bd */ { 0, 0, 0, 0, 0 },
/* U+49be */ { 0, 0, 0, 0, 0 },
/* U+49bf */ { 0, 0, 0, 0, 0 },
/* U+49c0 */ { 0, 0, 0, 0, 0 },
/* U+49c1 */ { 0, 0, 0, 0, 0 },
/* U+49c2 */ { 0, 0, 0, 0, 0 },
/* U+49c3 */ { 0, 0, 0, 0, 0 },
/* U+49c4 */ { 0, 0, 0, 0, 0 },
/* U+49c5 */ { 0, 0, 0, 0, 0 },
/* U+49c6 */ { 0, 0, 0, 0, 0 },
/* U+49c7 */ { 0, 0, 0, 0, 0 },
/* U+49c8 */ { 0, 0, 0, 0, 0 },
/* U+49c9 */ { 0, 0, 0, 0, 0 },
/* U+49ca */ { 0, 0, 0, 0, 0 },
/* U+49cb */ { 0, 0, 0, 0, 0 },
/* U+49cc */ { 0, 0, 0, 0, 0 },
/* U+49cd */ { 0, 0, 0, 0, 0 },
/* U+49ce */ { 0, 0, 0, 0, 0 },
/* U+49cf */ { 0, 0, 0, 0, 0 },
/* U+49d0 */ { 0, 0, 0, 0, 0 },
/* U+49d1 */ { 0, 0, 0, 0, 0 },
/* U+49d2 */ { 0, 0, 0, 0, 0 },
/* U+49d3 */ { 0, 0, 0, 0, 0 },
/* U+49d4 */ { 0, 0, 0, 0, 0 },
/* U+49d5 */ { 0, 0, 0, 0, 0 },
/* U+49d6 */ { 0, 0, 0, 0, 0 },
/* U+49d7 */ { 0, 0, 0, 0, 0 },
/* U+49d8 */ { 0, 0, 0, 0, 0 },
/* U+49d9 */ { 0, 0, 0, 0, 0 },
/* U+49da */ { 0, 0, 0, 0, 0 },
/* U+49db */ { 0, 0, 0, 0, 0 },
/* U+49dc */ { 0, 0, 0, 0, 0 },
/* U+49dd */ { 0, 0, 0, 0, 0 },
/* U+49de */ { 0, 0, 0, 0, 0 },
/* U+49df */ { 0, 0, 0, 0, 0 },
/* U+49e0 */ { 0, 0, 0, 0, 0 },
/* U+49e1 */ { 0, 0, 0, 0, 0 },
/* U+49e2 */ { 0, 0, 0, 0, 0 },
/* U+49e3 */ { 0, 0, 0, 0, 0 },
/* U+49e4 */ { 0, 0, 0, 0, 0 },
/* U+49e5 */ { 0, 0, 0, 0, 0 },
/* U+49e6 */ { 0, 0, 0, 0, 0 },
/* U+49e7 */ { 0, 0, 0, 0, 0 },
/* U+49e8 */ { 0, 0, 0, 0, 0 },
/* U+49e9 */ { 0, 0, 0, 0, 0 },
/* U+49ea */ { 0, 0, 0, 0, 0 },
/* U+49eb */ { 0, 0, 0, 0, 0 },
/* U+49ec */ { 0, 0, 0, 0, 0 },
/* U+49ed */ { 0, 0, 0, 0, 0 },
/* U+49ee */ { 0, 0, 0, 0, 0 },
/* U+49ef */ { 0, 0, 0, 0, 0 },
/* U+49f0 */ { 0, 0, 0, 0, 0 },
/* U+49f1 */ { 0, 0, 0, 0, 0 },
/* U+49f2 */ { 0, 0, 0, 0, 0 },
/* U+49f3 */ { 0, 0, 0, 0, 0 },
/* U+49f4 */ { 0, 0, 0, 0, 0 },
/* U+49f5 */ { 0, 0, 0, 0, 0 },
/* U+49f6 */ { 0, 0, 0, 0, 0 },
/* U+49f7 */ { 0, 0, 0, 0, 0 },
/* U+49f8 */ { 0, 0, 0, 0, 0 },
/* U+49f9 */ { 0, 0, 0, 0, 0 },
/* U+49fa */ { 0, 0, 0, 0, 0 },
/* U+49fb */ { 0, 0, 0, 0, 0 },
/* U+49fc */ { 0, 0, 0, 0, 0 },
/* U+49fd */ { 0, 0, 0, 0, 0 },
/* U+49fe */ { 0, 0, 0, 0, 0 },
/* U+49ff */ { 0, 0, 0, 0, 0 },
/* U+4a00 */ { 0, 0, 0, 0, 0 },
/* U+4a01 */ { 0, 0, 0, 0, 0 },
/* U+4a02 */ { 0, 0, 0, 0, 0 },
/* U+4a03 */ { 0, 0, 0, 0, 0 },
/* U+4a04 */ { 0, 0, 0, 0, 0 },
/* U+4a05 */ { 0, 0, 0, 0, 0 },
/* U+4a06 */ { 0, 0, 0, 0, 0 },
/* U+4a07 */ { 0, 0, 0, 0, 0 },
/* U+4a08 */ { 0, 0, 0, 0, 0 },
/* U+4a09 */ { 0, 0, 0, 0, 0 },
/* U+4a0a */ { 0, 0, 0, 0, 0 },
/* U+4a0b */ { 0, 0, 0, 0, 0 },
/* U+4a0c */ { 0, 0, 0, 0, 0 },
/* U+4a0d */ { 0, 0, 0, 0, 0 },
/* U+4a0e */ { 0, 0, 0, 0, 0 },
/* U+4a0f */ { 0, 0, 0, 0, 0 },
/* U+4a10 */ { 0, 0, 0, 0, 0 },
/* U+4a11 */ { 0, 0, 0, 0, 0 },
/* U+4a12 */ { 0, 0, 0, 0, 0 },
/* U+4a13 */ { 0, 0, 0, 0, 0 },
/* U+4a14 */ { 0, 0, 0, 0, 0 },
/* U+4a15 */ { 0, 0, 0, 0, 0 },
/* U+4a16 */ { 0, 0, 0, 0, 0 },
/* U+4a17 */ { 0, 0, 0, 0, 0 },
/* U+4a18 */ { 0, 0, 0, 0, 0 },
/* U+4a19 */ { 0, 0, 0, 0, 0 },
/* U+4a1a */ { 0, 0, 0, 0, 0 },
/* U+4a1b */ { 0, 0, 0, 0, 0 },
/* U+4a1c */ { 0, 0, 0, 0, 0 },
/* U+4a1d */ { 0, 0, 0, 0, 0 },
/* U+4a1e */ { 0, 0, 0, 0, 0 },
/* U+4a1f */ { 0, 0, 0, 0, 0 },
/* U+4a20 */ { 0, 0, 0, 0, 0 },
/* U+4a21 */ { 0, 0, 0, 0, 0 },
/* U+4a22 */ { 0, 0, 0, 0, 0 },
/* U+4a23 */ { 0, 0, 0, 0, 0 },
/* U+4a24 */ { 0, 0, 0, 0, 0 },
/* U+4a25 */ { 0, 0, 0, 0, 0 },
/* U+4a26 */ { 0, 0, 0, 0, 0 },
/* U+4a27 */ { 0, 0, 0, 0, 0 },
/* U+4a28 */ { 0, 0, 0, 0, 0 },
/* U+4a29 */ { 0, 0, 0, 0, 0 },
/* U+4a2a */ { 0, 0, 0, 0, 0 },
/* U+4a2b */ { 0, 0, 0, 0, 0 },
/* U+4a2c */ { 0, 0, 0, 0, 0 },
/* U+4a2d */ { 0, 0, 0, 0, 0 },
/* U+4a2e */ { 0, 0, 0, 0, 0 },
/* U+4a2f */ { 0, 0, 0, 0, 0 },
/* U+4a30 */ { 0, 0, 0, 0, 0 },
/* U+4a31 */ { 0, 0, 0, 0, 0 },
/* U+4a32 */ { 0, 0, 0, 0, 0 },
/* U+4a33 */ { 0, 0, 0, 0, 0 },
/* U+4a34 */ { 0, 0, 0, 0, 0 },
/* U+4a35 */ { 0, 0, 0, 0, 0 },
/* U+4a36 */ { 0, 0, 0, 0, 0 },
/* U+4a37 */ { 0, 0, 0, 0, 0 },
/* U+4a38 */ { 0, 0, 0, 0, 0 },
/* U+4a39 */ { 0, 0, 0, 0, 0 },
/* U+4a3a */ { 0, 0, 0, 0, 0 },
/* U+4a3b */ { 0, 0, 0, 0, 0 },
/* U+4a3c */ { 0, 0, 0, 0, 0 },
/* U+4a3d */ { 0, 0, 0, 0, 0 },
/* U+4a3e */ { 0, 0, 0, 0, 0 },
/* U+4a3f */ { 0, 0, 0, 0, 0 },
/* U+4a40 */ { 0, 0, 0, 0, 0 },
/* U+4a41 */ { 0, 0, 0, 0, 0 },
/* U+4a42 */ { 0, 0, 0, 0, 0 },
/* U+4a43 */ { 0, 0, 0, 0, 0 },
/* U+4a44 */ { 0, 0, 0, 0, 0 },
/* U+4a45 */ { 0, 0, 0, 0, 0 },
/* U+4a46 */ { 0, 0, 0, 0, 0 },
/* U+4a47 */ { 0, 0, 0, 0, 0 },
/* U+4a48 */ { 0, 0, 0, 0, 0 },
/* U+4a49 */ { 0, 0, 0, 0, 0 },
/* U+4a4a */ { 0, 0, 0, 0, 0 },
/* U+4a4b */ { 0, 0, 0, 0, 0 },
/* U+4a4c */ { 0, 0, 0, 0, 0 },
/* U+4a4d */ { 0, 0, 0, 0, 0 },
/* U+4a4e */ { 0, 0, 0, 0, 0 },
/* U+4a4f */ { 0, 0, 0, 0, 0 },
/* U+4a50 */ { 0, 0, 0, 0, 0 },
/* U+4a51 */ { 0, 0, 0, 0, 0 },
/* U+4a52 */ { 0, 0, 0, 0, 0 },
/* U+4a53 */ { 0, 0, 0, 0, 0 },
/* U+4a54 */ { 0, 0, 0, 0, 0 },
/* U+4a55 */ { 0, 0, 0, 0, 0 },
/* U+4a56 */ { 0, 0, 0, 0, 0 },
/* U+4a57 */ { 0, 0, 0, 0, 0 },
/* U+4a58 */ { 0, 0, 0, 0, 0 },
/* U+4a59 */ { 0, 0, 0, 0, 0 },
/* U+4a5a */ { 0, 0, 0, 0, 0 },
/* U+4a5b */ { 0, 0, 0, 0, 0 },
/* U+4a5c */ { 0, 0, 0, 0, 0 },
/* U+4a5d */ { 0, 0, 0, 0, 0 },
/* U+4a5e */ { 0, 0, 0, 0, 0 },
/* U+4a5f */ { 0, 0, 0, 0, 0 },
/* U+4a60 */ { 0, 0, 0, 0, 0 },
/* U+4a61 */ { 0, 0, 0, 0, 0 },
/* U+4a62 */ { 0, 0, 0, 0, 0 },
/* U+4a63 */ { 0, 0, 0, 0, 0 },
/* U+4a64 */ { 0, 0, 0, 0, 0 },
/* U+4a65 */ { 0, 0, 0, 0, 0 },
/* U+4a66 */ { 0, 0, 0, 0, 0 },
/* U+4a67 */ { 0, 0, 0, 0, 0 },
/* U+4a68 */ { 0, 0, 0, 0, 0 },
/* U+4a69 */ { 0, 0, 0, 0, 0 },
/* U+4a6a */ { 0, 0, 0, 0, 0 },
/* U+4a6b */ { 0, 0, 0, 0, 0 },
/* U+4a6c */ { 0, 0, 0, 0, 0 },
/* U+4a6d */ { 0, 0, 0, 0, 0 },
/* U+4a6e */ { 0, 0, 0, 0, 0 },
/* U+4a6f */ { 0, 0, 0, 0, 0 },
/* U+4a70 */ { 0, 0, 0, 0, 0 },
/* U+4a71 */ { 0, 0, 0, 0, 0 },
/* U+4a72 */ { 0, 0, 0, 0, 0 },
/* U+4a73 */ { 0, 0, 0, 0, 0 },
/* U+4a74 */ { 0, 0, 0, 0, 0 },
/* U+4a75 */ { 0, 0, 0, 0, 0 },
/* U+4a76 */ { 0, 0, 0, 0, 0 },
/* U+4a77 */ { 0, 0, 0, 0, 0 },
/* U+4a78 */ { 0, 0, 0, 0, 0 },
/* U+4a79 */ { 0, 0, 0, 0, 0 },
/* U+4a7a */ { 0, 0, 0, 0, 0 },
/* U+4a7b */ { 0, 0, 0, 0, 0 },
/* U+4a7c */ { 0, 0, 0, 0, 0 },
/* U+4a7d */ { 0, 0, 0, 0, 0 },
/* U+4a7e */ { 0, 0, 0, 0, 0 },
/* U+4a7f */ { 0, 0, 0, 0, 0 },
/* U+4a80 */ { 0, 0, 0, 0, 0 },
/* U+4a81 */ { 0, 0, 0, 0, 0 },
/* U+4a82 */ { 0, 0, 0, 0, 0 },
/* U+4a83 */ { 0, 0, 0, 0, 0 },
/* U+4a84 */ { 0, 0, 0, 0, 0 },
/* U+4a85 */ { 0, 0, 0, 0, 0 },
/* U+4a86 */ { 0, 0, 0, 0, 0 },
/* U+4a87 */ { 0, 0, 0, 0, 0 },
/* U+4a88 */ { 0, 0, 0, 0, 0 },
/* U+4a89 */ { 0, 0, 0, 0, 0 },
/* U+4a8a */ { 0, 0, 0, 0, 0 },
/* U+4a8b */ { 0, 0, 0, 0, 0 },
/* U+4a8c */ { 0, 0, 0, 0, 0 },
/* U+4a8d */ { 0, 0, 0, 0, 0 },
/* U+4a8e */ { 0, 0, 0, 0, 0 },
/* U+4a8f */ { 0, 0, 0, 0, 0 },
/* U+4a90 */ { 0, 0, 0, 0, 0 },
/* U+4a91 */ { 0, 0, 0, 0, 0 },
/* U+4a92 */ { 0, 0, 0, 0, 0 },
/* U+4a93 */ { 0, 0, 0, 0, 0 },
/* U+4a94 */ { 0, 0, 0, 0, 0 },
/* U+4a95 */ { 0, 0, 0, 0, 0 },
/* U+4a96 */ { 0, 0, 0, 0, 0 },
/* U+4a97 */ { 0, 0, 0, 0, 0 },
/* U+4a98 */ { 0, 0, 0, 0, 0 },
/* U+4a99 */ { 0, 0, 0, 0, 0 },
/* U+4a9a */ { 0, 0, 0, 0, 0 },
/* U+4a9b */ { 0, 0, 0, 0, 0 },
/* U+4a9c */ { 0, 0, 0, 0, 0 },
/* U+4a9d */ { 0, 0, 0, 0, 0 },
/* U+4a9e */ { 0, 0, 0, 0, 0 },
/* U+4a9f */ { 0, 0, 0, 0, 0 },
/* U+4aa0 */ { 0, 0, 0, 0, 0 },
/* U+4aa1 */ { 0, 0, 0, 0, 0 },
/* U+4aa2 */ { 0, 0, 0, 0, 0 },
/* U+4aa3 */ { 0, 0, 0, 0, 0 },
/* U+4aa4 */ { 0, 0, 0, 0, 0 },
/* U+4aa5 */ { 0, 0, 0, 0, 0 },
/* U+4aa6 */ { 0, 0, 0, 0, 0 },
/* U+4aa7 */ { 0, 0, 0, 0, 0 },
/* U+4aa8 */ { 0, 0, 0, 0, 0 },
/* U+4aa9 */ { 0, 0, 0, 0, 0 },
/* U+4aaa */ { 0, 0, 0, 0, 0 },
/* U+4aab */ { 0, 0, 0, 0, 0 },
/* U+4aac */ { 0, 0, 0, 0, 0 },
/* U+4aad */ { 0, 0, 0, 0, 0 },
/* U+4aae */ { 0, 0, 0, 0, 0 },
/* U+4aaf */ { 0, 0, 0, 0, 0 },
/* U+4ab0 */ { 0, 0, 0, 0, 0 },
/* U+4ab1 */ { 0, 0, 0, 0, 0 },
/* U+4ab2 */ { 0, 0, 0, 0, 0 },
/* U+4ab3 */ { 0, 0, 0, 0, 0 },
/* U+4ab4 */ { 0, 0, 0, 0, 0 },
/* U+4ab5 */ { 0, 0, 0, 0, 0 },
/* U+4ab6 */ { 0, 0, 0, 0, 0 },
/* U+4ab7 */ { 0, 0, 0, 0, 0 },
/* U+4ab8 */ { 0, 0, 0, 0, 0 },
/* U+4ab9 */ { 0, 0, 0, 0, 0 },
/* U+4aba */ { 0, 0, 0, 0, 0 },
/* U+4abb */ { 0, 0, 0, 0, 0 },
/* U+4abc */ { 0, 0, 0, 0, 0 },
/* U+4abd */ { 0, 0, 0, 0, 0 },
/* U+4abe */ { 0, 0, 0, 0, 0 },
/* U+4abf */ { 0, 0, 0, 0, 0 },
/* U+4ac0 */ { 0, 0, 0, 0, 0 },
/* U+4ac1 */ { 0, 0, 0, 0, 0 },
/* U+4ac2 */ { 0, 0, 0, 0, 0 },
/* U+4ac3 */ { 0, 0, 0, 0, 0 },
/* U+4ac4 */ { 0, 0, 0, 0, 0 },
/* U+4ac5 */ { 0, 0, 0, 0, 0 },
/* U+4ac6 */ { 0, 0, 0, 0, 0 },
/* U+4ac7 */ { 0, 0, 0, 0, 0 },
/* U+4ac8 */ { 0, 0, 0, 0, 0 },
/* U+4ac9 */ { 0, 0, 0, 0, 0 },
/* U+4aca */ { 0, 0, 0, 0, 0 },
/* U+4acb */ { 0, 0, 0, 0, 0 },
/* U+4acc */ { 0, 0, 0, 0, 0 },
/* U+4acd */ { 0, 0, 0, 0, 0 },
/* U+4ace */ { 0, 0, 0, 0, 0 },
/* U+4acf */ { 0, 0, 0, 0, 0 },
/* U+4ad0 */ { 0, 0, 0, 0, 0 },
/* U+4ad1 */ { 0, 0, 0, 0, 0 },
/* U+4ad2 */ { 0, 0, 0, 0, 0 },
/* U+4ad3 */ { 0, 0, 0, 0, 0 },
/* U+4ad4 */ { 0, 0, 0, 0, 0 },
/* U+4ad5 */ { 0, 0, 0, 0, 0 },
/* U+4ad6 */ { 0, 0, 0, 0, 0 },
/* U+4ad7 */ { 0, 0, 0, 0, 0 },
/* U+4ad8 */ { 0, 0, 0, 0, 0 },
/* U+4ad9 */ { 0, 0, 0, 0, 0 },
/* U+4ada */ { 0, 0, 0, 0, 0 },
/* U+4adb */ { 0, 0, 0, 0, 0 },
/* U+4adc */ { 0, 0, 0, 0, 0 },
/* U+4add */ { 0, 0, 0, 0, 0 },
/* U+4ade */ { 0, 0, 0, 0, 0 },
/* U+4adf */ { 0, 0, 0, 0, 0 },
/* U+4ae0 */ { 0, 0, 0, 0, 0 },
/* U+4ae1 */ { 0, 0, 0, 0, 0 },
/* U+4ae2 */ { 0, 0, 0, 0, 0 },
/* U+4ae3 */ { 0, 0, 0, 0, 0 },
/* U+4ae4 */ { 0, 0, 0, 0, 0 },
/* U+4ae5 */ { 0, 0, 0, 0, 0 },
/* U+4ae6 */ { 0, 0, 0, 0, 0 },
/* U+4ae7 */ { 0, 0, 0, 0, 0 },
/* U+4ae8 */ { 0, 0, 0, 0, 0 },
/* U+4ae9 */ { 0, 0, 0, 0, 0 },
/* U+4aea */ { 0, 0, 0, 0, 0 },
/* U+4aeb */ { 0, 0, 0, 0, 0 },
/* U+4aec */ { 0, 0, 0, 0, 0 },
/* U+4aed */ { 0, 0, 0, 0, 0 },
/* U+4aee */ { 0, 0, 0, 0, 0 },
/* U+4aef */ { 0, 0, 0, 0, 0 },
/* U+4af0 */ { 0, 0, 0, 0, 0 },
/* U+4af1 */ { 0, 0, 0, 0, 0 },
/* U+4af2 */ { 0, 0, 0, 0, 0 },
/* U+4af3 */ { 0, 0, 0, 0, 0 },
/* U+4af4 */ { 0, 0, 0, 0, 0 },
/* U+4af5 */ { 0, 0, 0, 0, 0 },
/* U+4af6 */ { 0, 0, 0, 0, 0 },
/* U+4af7 */ { 0, 0, 0, 0, 0 },
/* U+4af8 */ { 0, 0, 0, 0, 0 },
/* U+4af9 */ { 0, 0, 0, 0, 0 },
/* U+4afa */ { 0, 0, 0, 0, 0 },
/* U+4afb */ { 0, 0, 0, 0, 0 },
/* U+4afc */ { 0, 0, 0, 0, 0 },
/* U+4afd */ { 0, 0, 0, 0, 0 },
/* U+4afe */ { 0, 0, 0, 0, 0 },
/* U+4aff */ { 0, 0, 0, 0, 0 },
/* U+4b00 */ { 0, 0, 0, 0, 0 },
/* U+4b01 */ { 0, 0, 0, 0, 0 },
/* U+4b02 */ { 0, 0, 0, 0, 0 },
/* U+4b03 */ { 0, 0, 0, 0, 0 },
/* U+4b04 */ { 0, 0, 0, 0, 0 },
/* U+4b05 */ { 0, 0, 0, 0, 0 },
/* U+4b06 */ { 0, 0, 0, 0, 0 },
/* U+4b07 */ { 0, 0, 0, 0, 0 },
/* U+4b08 */ { 0, 0, 0, 0, 0 },
/* U+4b09 */ { 0, 0, 0, 0, 0 },
/* U+4b0a */ { 0, 0, 0, 0, 0 },
/* U+4b0b */ { 0, 0, 0, 0, 0 },
/* U+4b0c */ { 0, 0, 0, 0, 0 },
/* U+4b0d */ { 0, 0, 0, 0, 0 },
/* U+4b0e */ { 0, 0, 0, 0, 0 },
/* U+4b0f */ { 0, 0, 0, 0, 0 },
/* U+4b10 */ { 0, 0, 0, 0, 0 },
/* U+4b11 */ { 0, 0, 0, 0, 0 },
/* U+4b12 */ { 0, 0, 0, 0, 0 },
/* U+4b13 */ { 0, 0, 0, 0, 0 },
/* U+4b14 */ { 0, 0, 0, 0, 0 },
/* U+4b15 */ { 0, 0, 0, 0, 0 },
/* U+4b16 */ { 0, 0, 0, 0, 0 },
/* U+4b17 */ { 0, 0, 0, 0, 0 },
/* U+4b18 */ { 0, 0, 0, 0, 0 },
/* U+4b19 */ { 0, 0, 0, 0, 0 },
/* U+4b1a */ { 0, 0, 0, 0, 0 },
/* U+4b1b */ { 0, 0, 0, 0, 0 },
/* U+4b1c */ { 0, 0, 0, 0, 0 },
/* U+4b1d */ { 0, 0, 0, 0, 0 },
/* U+4b1e */ { 0, 0, 0, 0, 0 },
/* U+4b1f */ { 0, 0, 0, 0, 0 },
/* U+4b20 */ { 0, 0, 0, 0, 0 },
/* U+4b21 */ { 0, 0, 0, 0, 0 },
/* U+4b22 */ { 0, 0, 0, 0, 0 },
/* U+4b23 */ { 0, 0, 0, 0, 0 },
/* U+4b24 */ { 0, 0, 0, 0, 0 },
/* U+4b25 */ { 0, 0, 0, 0, 0 },
/* U+4b26 */ { 0, 0, 0, 0, 0 },
/* U+4b27 */ { 0, 0, 0, 0, 0 },
/* U+4b28 */ { 0, 0, 0, 0, 0 },
/* U+4b29 */ { 0, 0, 0, 0, 0 },
/* U+4b2a */ { 0, 0, 0, 0, 0 },
/* U+4b2b */ { 0, 0, 0, 0, 0 },
/* U+4b2c */ { 0, 0, 0, 0, 0 },
/* U+4b2d */ { 0, 0, 0, 0, 0 },
/* U+4b2e */ { 0, 0, 0, 0, 0 },
/* U+4b2f */ { 0, 0, 0, 0, 0 },
/* U+4b30 */ { 0, 0, 0, 0, 0 },
/* U+4b31 */ { 0, 0, 0, 0, 0 },
/* U+4b32 */ { 0, 0, 0, 0, 0 },
/* U+4b33 */ { 0, 0, 0, 0, 0 },
/* U+4b34 */ { 0, 0, 0, 0, 0 },
/* U+4b35 */ { 0, 0, 0, 0, 0 },
/* U+4b36 */ { 0, 0, 0, 0, 0 },
/* U+4b37 */ { 0, 0, 0, 0, 0 },
/* U+4b38 */ { 0, 0, 0, 0, 0 },
/* U+4b39 */ { 0, 0, 0, 0, 0 },
/* U+4b3a */ { 0, 0, 0, 0, 0 },
/* U+4b3b */ { 0, 0, 0, 0, 0 },
/* U+4b3c */ { 0, 0, 0, 0, 0 },
/* U+4b3d */ { 0, 0, 0, 0, 0 },
/* U+4b3e */ { 0, 0, 0, 0, 0 },
/* U+4b3f */ { 0, 0, 0, 0, 0 },
/* U+4b40 */ { 0, 0, 0, 0, 0 },
/* U+4b41 */ { 0, 0, 0, 0, 0 },
/* U+4b42 */ { 0, 0, 0, 0, 0 },
/* U+4b43 */ { 0, 0, 0, 0, 0 },
/* U+4b44 */ { 0, 0, 0, 0, 0 },
/* U+4b45 */ { 0, 0, 0, 0, 0 },
/* U+4b46 */ { 0, 0, 0, 0, 0 },
/* U+4b47 */ { 0, 0, 0, 0, 0 },
/* U+4b48 */ { 0, 0, 0, 0, 0 },
/* U+4b49 */ { 0, 0, 0, 0, 0 },
/* U+4b4a */ { 0, 0, 0, 0, 0 },
/* U+4b4b */ { 0, 0, 0, 0, 0 },
/* U+4b4c */ { 0, 0, 0, 0, 0 },
/* U+4b4d */ { 0, 0, 0, 0, 0 },
/* U+4b4e */ { 0, 0, 0, 0, 0 },
/* U+4b4f */ { 0, 0, 0, 0, 0 },
/* U+4b50 */ { 0, 0, 0, 0, 0 },
/* U+4b51 */ { 0, 0, 0, 0, 0 },
/* U+4b52 */ { 0, 0, 0, 0, 0 },
/* U+4b53 */ { 0, 0, 0, 0, 0 },
/* U+4b54 */ { 0, 0, 0, 0, 0 },
/* U+4b55 */ { 0, 0, 0, 0, 0 },
/* U+4b56 */ { 0, 0, 0, 0, 0 },
/* U+4b57 */ { 0, 0, 0, 0, 0 },
/* U+4b58 */ { 0, 0, 0, 0, 0 },
/* U+4b59 */ { 0, 0, 0, 0, 0 },
/* U+4b5a */ { 0, 0, 0, 0, 0 },
/* U+4b5b */ { 0, 0, 0, 0, 0 },
/* U+4b5c */ { 0, 0, 0, 0, 0 },
/* U+4b5d */ { 0, 0, 0, 0, 0 },
/* U+4b5e */ { 0, 0, 0, 0, 0 },
/* U+4b5f */ { 0, 0, 0, 0, 0 },
/* U+4b60 */ { 0, 0, 0, 0, 0 },
/* U+4b61 */ { 0, 0, 0, 0, 0 },
/* U+4b62 */ { 0, 0, 0, 0, 0 },
/* U+4b63 */ { 0, 0, 0, 0, 0 },
/* U+4b64 */ { 0, 0, 0, 0, 0 },
/* U+4b65 */ { 0, 0, 0, 0, 0 },
/* U+4b66 */ { 0, 0, 0, 0, 0 },
/* U+4b67 */ { 0, 0, 0, 0, 0 },
/* U+4b68 */ { 0, 0, 0, 0, 0 },
/* U+4b69 */ { 0, 0, 0, 0, 0 },
/* U+4b6a */ { 0, 0, 0, 0, 0 },
/* U+4b6b */ { 0, 0, 0, 0, 0 },
/* U+4b6c */ { 0, 0, 0, 0, 0 },
/* U+4b6d */ { 0, 0, 0, 0, 0 },
/* U+4b6e */ { 0, 0, 0, 0, 0 },
/* U+4b6f */ { 0, 0, 0, 0, 0 },
/* U+4b70 */ { 0, 0, 0, 0, 0 },
/* U+4b71 */ { 0, 0, 0, 0, 0 },
/* U+4b72 */ { 0, 0, 0, 0, 0 },
/* U+4b73 */ { 0, 0, 0, 0, 0 },
/* U+4b74 */ { 0, 0, 0, 0, 0 },
/* U+4b75 */ { 0, 0, 0, 0, 0 },
/* U+4b76 */ { 0, 0, 0, 0, 0 },
/* U+4b77 */ { 0, 0, 0, 0, 0 },
/* U+4b78 */ { 0, 0, 0, 0, 0 },
/* U+4b79 */ { 0, 0, 0, 0, 0 },
/* U+4b7a */ { 0, 0, 0, 0, 0 },
/* U+4b7b */ { 0, 0, 0, 0, 0 },
/* U+4b7c */ { 0, 0, 0, 0, 0 },
/* U+4b7d */ { 0, 0, 0, 0, 0 },
/* U+4b7e */ { 0, 0, 0, 0, 0 },
/* U+4b7f */ { 0, 0, 0, 0, 0 },
/* U+4b80 */ { 0, 0, 0, 0, 0 },
/* U+4b81 */ { 0, 0, 0, 0, 0 },
/* U+4b82 */ { 0, 0, 0, 0, 0 },
/* U+4b83 */ { 0, 0, 0, 0, 0 },
/* U+4b84 */ { 0, 0, 0, 0, 0 },
/* U+4b85 */ { 0, 0, 0, 0, 0 },
/* U+4b86 */ { 0, 0, 0, 0, 0 },
/* U+4b87 */ { 0, 0, 0, 0, 0 },
/* U+4b88 */ { 0, 0, 0, 0, 0 },
/* U+4b89 */ { 0, 0, 0, 0, 0 },
/* U+4b8a */ { 0, 0, 0, 0, 0 },
/* U+4b8b */ { 0, 0, 0, 0, 0 },
/* U+4b8c */ { 0, 0, 0, 0, 0 },
/* U+4b8d */ { 0, 0, 0, 0, 0 },
/* U+4b8e */ { 0, 0, 0, 0, 0 },
/* U+4b8f */ { 0, 0, 0, 0, 0 },
/* U+4b90 */ { 0, 0, 0, 0, 0 },
/* U+4b91 */ { 0, 0, 0, 0, 0 },
/* U+4b92 */ { 0, 0, 0, 0, 0 },
/* U+4b93 */ { 0, 0, 0, 0, 0 },
/* U+4b94 */ { 0, 0, 0, 0, 0 },
/* U+4b95 */ { 0, 0, 0, 0, 0 },
/* U+4b96 */ { 0, 0, 0, 0, 0 },
/* U+4b97 */ { 0, 0, 0, 0, 0 },
/* U+4b98 */ { 0, 0, 0, 0, 0 },
/* U+4b99 */ { 0, 0, 0, 0, 0 },
/* U+4b9a */ { 0, 0, 0, 0, 0 },
/* U+4b9b */ { 0, 0, 0, 0, 0 },
/* U+4b9c */ { 0, 0, 0, 0, 0 },
/* U+4b9d */ { 0, 0, 0, 0, 0 },
/* U+4b9e */ { 0, 0, 0, 0, 0 },
/* U+4b9f */ { 0, 0, 0, 0, 0 },
/* U+4ba0 */ { 0, 0, 0, 0, 0 },
/* U+4ba1 */ { 0, 0, 0, 0, 0 },
/* U+4ba2 */ { 0, 0, 0, 0, 0 },
/* U+4ba3 */ { 0, 0, 0, 0, 0 },
/* U+4ba4 */ { 0, 0, 0, 0, 0 },
/* U+4ba5 */ { 0, 0, 0, 0, 0 },
/* U+4ba6 */ { 0, 0, 0, 0, 0 },
/* U+4ba7 */ { 0, 0, 0, 0, 0 },
/* U+4ba8 */ { 0, 0, 0, 0, 0 },
/* U+4ba9 */ { 0, 0, 0, 0, 0 },
/* U+4baa */ { 0, 0, 0, 0, 0 },
/* U+4bab */ { 0, 0, 0, 0, 0 },
/* U+4bac */ { 0, 0, 0, 0, 0 },
/* U+4bad */ { 0, 0, 0, 0, 0 },
/* U+4bae */ { 0, 0, 0, 0, 0 },
/* U+4baf */ { 0, 0, 0, 0, 0 },
/* U+4bb0 */ { 0, 0, 0, 0, 0 },
/* U+4bb1 */ { 0, 0, 0, 0, 0 },
/* U+4bb2 */ { 0, 0, 0, 0, 0 },
/* U+4bb3 */ { 0, 0, 0, 0, 0 },
/* U+4bb4 */ { 0, 0, 0, 0, 0 },
/* U+4bb5 */ { 0, 0, 0, 0, 0 },
/* U+4bb6 */ { 0, 0, 0, 0, 0 },
/* U+4bb7 */ { 0, 0, 0, 0, 0 },
/* U+4bb8 */ { 0, 0, 0, 0, 0 },
/* U+4bb9 */ { 0, 0, 0, 0, 0 },
/* U+4bba */ { 0, 0, 0, 0, 0 },
/* U+4bbb */ { 0, 0, 0, 0, 0 },
/* U+4bbc */ { 0, 0, 0, 0, 0 },
/* U+4bbd */ { 0, 0, 0, 0, 0 },
/* U+4bbe */ { 0, 0, 0, 0, 0 },
/* U+4bbf */ { 0, 0, 0, 0, 0 },
/* U+4bc0 */ { 0, 0, 0, 0, 0 },
/* U+4bc1 */ { 0, 0, 0, 0, 0 },
/* U+4bc2 */ { 0, 0, 0, 0, 0 },
/* U+4bc3 */ { 0, 0, 0, 0, 0 },
/* U+4bc4 */ { 0, 0, 0, 0, 0 },
/* U+4bc5 */ { 0, 0, 0, 0, 0 },
/* U+4bc6 */ { 0, 0, 0, 0, 0 },
/* U+4bc7 */ { 0, 0, 0, 0, 0 },
/* U+4bc8 */ { 0, 0, 0, 0, 0 },
/* U+4bc9 */ { 0, 0, 0, 0, 0 },
/* U+4bca */ { 0, 0, 0, 0, 0 },
/* U+4bcb */ { 0, 0, 0, 0, 0 },
/* U+4bcc */ { 0, 0, 0, 0, 0 },
/* U+4bcd */ { 0, 0, 0, 0, 0 },
/* U+4bce */ { 0, 0, 0, 0, 0 },
/* U+4bcf */ { 0, 0, 0, 0, 0 },
/* U+4bd0 */ { 0, 0, 0, 0, 0 },
/* U+4bd1 */ { 0, 0, 0, 0, 0 },
/* U+4bd2 */ { 0, 0, 0, 0, 0 },
/* U+4bd3 */ { 0, 0, 0, 0, 0 },
/* U+4bd4 */ { 0, 0, 0, 0, 0 },
/* U+4bd5 */ { 0, 0, 0, 0, 0 },
/* U+4bd6 */ { 0, 0, 0, 0, 0 },
/* U+4bd7 */ { 0, 0, 0, 0, 0 },
/* U+4bd8 */ { 0, 0, 0, 0, 0 },
/* U+4bd9 */ { 0, 0, 0, 0, 0 },
/* U+4bda */ { 0, 0, 0, 0, 0 },
/* U+4bdb */ { 0, 0, 0, 0, 0 },
/* U+4bdc */ { 0, 0, 0, 0, 0 },
/* U+4bdd */ { 0, 0, 0, 0, 0 },
/* U+4bde */ { 0, 0, 0, 0, 0 },
/* U+4bdf */ { 0, 0, 0, 0, 0 },
/* U+4be0 */ { 0, 0, 0, 0, 0 },
/* U+4be1 */ { 0, 0, 0, 0, 0 },
/* U+4be2 */ { 0, 0, 0, 0, 0 },
/* U+4be3 */ { 0, 0, 0, 0, 0 },
/* U+4be4 */ { 0, 0, 0, 0, 0 },
/* U+4be5 */ { 0, 0, 0, 0, 0 },
/* U+4be6 */ { 0, 0, 0, 0, 0 },
/* U+4be7 */ { 0, 0, 0, 0, 0 },
/* U+4be8 */ { 0, 0, 0, 0, 0 },
/* U+4be9 */ { 0, 0, 0, 0, 0 },
/* U+4bea */ { 0, 0, 0, 0, 0 },
/* U+4beb */ { 0, 0, 0, 0, 0 },
/* U+4bec */ { 0, 0, 0, 0, 0 },
/* U+4bed */ { 0, 0, 0, 0, 0 },
/* U+4bee */ { 0, 0, 0, 0, 0 },
/* U+4bef */ { 0, 0, 0, 0, 0 },
/* U+4bf0 */ { 0, 0, 0, 0, 0 },
/* U+4bf1 */ { 0, 0, 0, 0, 0 },
/* U+4bf2 */ { 0, 0, 0, 0, 0 },
/* U+4bf3 */ { 0, 0, 0, 0, 0 },
/* U+4bf4 */ { 0, 0, 0, 0, 0 },
/* U+4bf5 */ { 0, 0, 0, 0, 0 },
/* U+4bf6 */ { 0, 0, 0, 0, 0 },
/* U+4bf7 */ { 0, 0, 0, 0, 0 },
/* U+4bf8 */ { 0, 0, 0, 0, 0 },
/* U+4bf9 */ { 0, 0, 0, 0, 0 },
/* U+4bfa */ { 0, 0, 0, 0, 0 },
/* U+4bfb */ { 0, 0, 0, 0, 0 },
/* U+4bfc */ { 0, 0, 0, 0, 0 },
/* U+4bfd */ { 0, 0, 0, 0, 0 },
/* U+4bfe */ { 0, 0, 0, 0, 0 },
/* U+4bff */ { 0, 0, 0, 0, 0 },
/* U+4c00 */ { 0, 0, 0, 0, 0 },
/* U+4c01 */ { 0, 0, 0, 0, 0 },
/* U+4c02 */ { 0, 0, 0, 0, 0 },
/* U+4c03 */ { 0, 0, 0, 0, 0 },
/* U+4c04 */ { 0, 0, 0, 0, 0 },
/* U+4c05 */ { 0, 0, 0, 0, 0 },
/* U+4c06 */ { 0, 0, 0, 0, 0 },
/* U+4c07 */ { 0, 0, 0, 0, 0 },
/* U+4c08 */ { 0, 0, 0, 0, 0 },
/* U+4c09 */ { 0, 0, 0, 0, 0 },
/* U+4c0a */ { 0, 0, 0, 0, 0 },
/* U+4c0b */ { 0, 0, 0, 0, 0 },
/* U+4c0c */ { 0, 0, 0, 0, 0 },
/* U+4c0d */ { 0, 0, 0, 0, 0 },
/* U+4c0e */ { 0, 0, 0, 0, 0 },
/* U+4c0f */ { 0, 0, 0, 0, 0 },
/* U+4c10 */ { 0, 0, 0, 0, 0 },
/* U+4c11 */ { 0, 0, 0, 0, 0 },
/* U+4c12 */ { 0, 0, 0, 0, 0 },
/* U+4c13 */ { 0, 0, 0, 0, 0 },
/* U+4c14 */ { 0, 0, 0, 0, 0 },
/* U+4c15 */ { 0, 0, 0, 0, 0 },
/* U+4c16 */ { 0, 0, 0, 0, 0 },
/* U+4c17 */ { 0, 0, 0, 0, 0 },
/* U+4c18 */ { 0, 0, 0, 0, 0 },
/* U+4c19 */ { 0, 0, 0, 0, 0 },
/* U+4c1a */ { 0, 0, 0, 0, 0 },
/* U+4c1b */ { 0, 0, 0, 0, 0 },
/* U+4c1c */ { 0, 0, 0, 0, 0 },
/* U+4c1d */ { 0, 0, 0, 0, 0 },
/* U+4c1e */ { 0, 0, 0, 0, 0 },
/* U+4c1f */ { 0, 0, 0, 0, 0 },
/* U+4c20 */ { 0, 0, 0, 0, 0 },
/* U+4c21 */ { 0, 0, 0, 0, 0 },
/* U+4c22 */ { 0, 0, 0, 0, 0 },
/* U+4c23 */ { 0, 0, 0, 0, 0 },
/* U+4c24 */ { 0, 0, 0, 0, 0 },
/* U+4c25 */ { 0, 0, 0, 0, 0 },
/* U+4c26 */ { 0, 0, 0, 0, 0 },
/* U+4c27 */ { 0, 0, 0, 0, 0 },
/* U+4c28 */ { 0, 0, 0, 0, 0 },
/* U+4c29 */ { 0, 0, 0, 0, 0 },
/* U+4c2a */ { 0, 0, 0, 0, 0 },
/* U+4c2b */ { 0, 0, 0, 0, 0 },
/* U+4c2c */ { 0, 0, 0, 0, 0 },
/* U+4c2d */ { 0, 0, 0, 0, 0 },
/* U+4c2e */ { 0, 0, 0, 0, 0 },
/* U+4c2f */ { 0, 0, 0, 0, 0 },
/* U+4c30 */ { 0, 0, 0, 0, 0 },
/* U+4c31 */ { 0, 0, 0, 0, 0 },
/* U+4c32 */ { 0, 0, 0, 0, 0 },
/* U+4c33 */ { 0, 0, 0, 0, 0 },
/* U+4c34 */ { 0, 0, 0, 0, 0 },
/* U+4c35 */ { 0, 0, 0, 0, 0 },
/* U+4c36 */ { 0, 0, 0, 0, 0 },
/* U+4c37 */ { 0, 0, 0, 0, 0 },
/* U+4c38 */ { 0, 0, 0, 0, 0 },
/* U+4c39 */ { 0, 0, 0, 0, 0 },
/* U+4c3a */ { 0, 0, 0, 0, 0 },
/* U+4c3b */ { 0, 0, 0, 0, 0 },
/* U+4c3c */ { 0, 0, 0, 0, 0 },
/* U+4c3d */ { 0, 0, 0, 0, 0 },
/* U+4c3e */ { 0, 0, 0, 0, 0 },
/* U+4c3f */ { 0, 0, 0, 0, 0 },
/* U+4c40 */ { 0, 0, 0, 0, 0 },
/* U+4c41 */ { 0, 0, 0, 0, 0 },
/* U+4c42 */ { 0, 0, 0, 0, 0 },
/* U+4c43 */ { 0, 0, 0, 0, 0 },
/* U+4c44 */ { 0, 0, 0, 0, 0 },
/* U+4c45 */ { 0, 0, 0, 0, 0 },
/* U+4c46 */ { 0, 0, 0, 0, 0 },
/* U+4c47 */ { 0, 0, 0, 0, 0 },
/* U+4c48 */ { 0, 0, 0, 0, 0 },
/* U+4c49 */ { 0, 0, 0, 0, 0 },
/* U+4c4a */ { 0, 0, 0, 0, 0 },
/* U+4c4b */ { 0, 0, 0, 0, 0 },
/* U+4c4c */ { 0, 0, 0, 0, 0 },
/* U+4c4d */ { 0, 0, 0, 0, 0 },
/* U+4c4e */ { 0, 0, 0, 0, 0 },
/* U+4c4f */ { 0, 0, 0, 0, 0 },
/* U+4c50 */ { 0, 0, 0, 0, 0 },
/* U+4c51 */ { 0, 0, 0, 0, 0 },
/* U+4c52 */ { 0, 0, 0, 0, 0 },
/* U+4c53 */ { 0, 0, 0, 0, 0 },
/* U+4c54 */ { 0, 0, 0, 0, 0 },
/* U+4c55 */ { 0, 0, 0, 0, 0 },
/* U+4c56 */ { 0, 0, 0, 0, 0 },
/* U+4c57 */ { 0, 0, 0, 0, 0 },
/* U+4c58 */ { 0, 0, 0, 0, 0 },
/* U+4c59 */ { 0, 0, 0, 0, 0 },
/* U+4c5a */ { 0, 0, 0, 0, 0 },
/* U+4c5b */ { 0, 0, 0, 0, 0 },
/* U+4c5c */ { 0, 0, 0, 0, 0 },
/* U+4c5d */ { 0, 0, 0, 0, 0 },
/* U+4c5e */ { 0, 0, 0, 0, 0 },
/* U+4c5f */ { 0, 0, 0, 0, 0 },
/* U+4c60 */ { 0, 0, 0, 0, 0 },
/* U+4c61 */ { 0, 0, 0, 0, 0 },
/* U+4c62 */ { 0, 0, 0, 0, 0 },
/* U+4c63 */ { 0, 0, 0, 0, 0 },
/* U+4c64 */ { 0, 0, 0, 0, 0 },
/* U+4c65 */ { 0, 0, 0, 0, 0 },
/* U+4c66 */ { 0, 0, 0, 0, 0 },
/* U+4c67 */ { 0, 0, 0, 0, 0 },
/* U+4c68 */ { 0, 0, 0, 0, 0 },
/* U+4c69 */ { 0, 0, 0, 0, 0 },
/* U+4c6a */ { 0, 0, 0, 0, 0 },
/* U+4c6b */ { 0, 0, 0, 0, 0 },
/* U+4c6c */ { 0, 0, 0, 0, 0 },
/* U+4c6d */ { 0, 0, 0, 0, 0 },
/* U+4c6e */ { 0, 0, 0, 0, 0 },
/* U+4c6f */ { 0, 0, 0, 0, 0 },
/* U+4c70 */ { 0, 0, 0, 0, 0 },
/* U+4c71 */ { 0, 0, 0, 0, 0 },
/* U+4c72 */ { 0, 0, 0, 0, 0 },
/* U+4c73 */ { 0, 0, 0, 0, 0 },
/* U+4c74 */ { 0, 0, 0, 0, 0 },
/* U+4c75 */ { 0, 0, 0, 0, 0 },
/* U+4c76 */ { 0, 0, 0, 0, 0 },
/* U+4c77 */ { 0, 0, 0, 0, 0 },
/* U+4c78 */ { 0, 0, 0, 0, 0 },
/* U+4c79 */ { 0, 0, 0, 0, 0 },
/* U+4c7a */ { 0, 0, 0, 0, 0 },
/* U+4c7b */ { 0, 0, 0, 0, 0 },
/* U+4c7c */ { 0, 0, 0, 0, 0 },
/* U+4c7d */ { 0, 0, 0, 0, 0 },
/* U+4c7e */ { 0, 0, 0, 0, 0 },
/* U+4c7f */ { 0, 0, 0, 0, 0 },
/* U+4c80 */ { 0, 0, 0, 0, 0 },
/* U+4c81 */ { 0, 0, 0, 0, 0 },
/* U+4c82 */ { 0, 0, 0, 0, 0 },
/* U+4c83 */ { 0, 0, 0, 0, 0 },
/* U+4c84 */ { 0, 0, 0, 0, 0 },
/* U+4c85 */ { 0, 0, 0, 0, 0 },
/* U+4c86 */ { 0, 0, 0, 0, 0 },
/* U+4c87 */ { 0, 0, 0, 0, 0 },
/* U+4c88 */ { 0, 0, 0, 0, 0 },
/* U+4c89 */ { 0, 0, 0, 0, 0 },
/* U+4c8a */ { 0, 0, 0, 0, 0 },
/* U+4c8b */ { 0, 0, 0, 0, 0 },
/* U+4c8c */ { 0, 0, 0, 0, 0 },
/* U+4c8d */ { 0, 0, 0, 0, 0 },
/* U+4c8e */ { 0, 0, 0, 0, 0 },
/* U+4c8f */ { 0, 0, 0, 0, 0 },
/* U+4c90 */ { 0, 0, 0, 0, 0 },
/* U+4c91 */ { 0, 0, 0, 0, 0 },
/* U+4c92 */ { 0, 0, 0, 0, 0 },
/* U+4c93 */ { 0, 0, 0, 0, 0 },
/* U+4c94 */ { 0, 0, 0, 0, 0 },
/* U+4c95 */ { 0, 0, 0, 0, 0 },
/* U+4c96 */ { 0, 0, 0, 0, 0 },
/* U+4c97 */ { 0, 0, 0, 0, 0 },
/* U+4c98 */ { 0, 0, 0, 0, 0 },
/* U+4c99 */ { 0, 0, 0, 0, 0 },
/* U+4c9a */ { 0, 0, 0, 0, 0 },
/* U+4c9b */ { 0, 0, 0, 0, 0 },
/* U+4c9c */ { 0, 0, 0, 0, 0 },
/* U+4c9d */ { 0, 0, 0, 0, 0 },
/* U+4c9e */ { 0, 0, 0, 0, 0 },
/* U+4c9f */ { 0, 0, 0, 0, 0 },
/* U+4ca0 */ { 0, 0, 0, 0, 0 },
/* U+4ca1 */ { 0, 0, 0, 0, 0 },
/* U+4ca2 */ { 0, 0, 0, 0, 0 },
/* U+4ca3 */ { 0, 0, 0, 0, 0 },
/* U+4ca4 */ { 0, 0, 0, 0, 0 },
/* U+4ca5 */ { 0, 0, 0, 0, 0 },
/* U+4ca6 */ { 0, 0, 0, 0, 0 },
/* U+4ca7 */ { 0, 0, 0, 0, 0 },
/* U+4ca8 */ { 0, 0, 0, 0, 0 },
/* U+4ca9 */ { 0, 0, 0, 0, 0 },
/* U+4caa */ { 0, 0, 0, 0, 0 },
/* U+4cab */ { 0, 0, 0, 0, 0 },
/* U+4cac */ { 0, 0, 0, 0, 0 },
/* U+4cad */ { 0, 0, 0, 0, 0 },
/* U+4cae */ { 0, 0, 0, 0, 0 },
/* U+4caf */ { 0, 0, 0, 0, 0 },
/* U+4cb0 */ { 0, 0, 0, 0, 0 },
/* U+4cb1 */ { 0, 0, 0, 0, 0 },
/* U+4cb2 */ { 0, 0, 0, 0, 0 },
/* U+4cb3 */ { 0, 0, 0, 0, 0 },
/* U+4cb4 */ { 0, 0, 0, 0, 0 },
/* U+4cb5 */ { 0, 0, 0, 0, 0 },
/* U+4cb6 */ { 0, 0, 0, 0, 0 },
/* U+4cb7 */ { 0, 0, 0, 0, 0 },
/* U+4cb8 */ { 0, 0, 0, 0, 0 },
/* U+4cb9 */ { 0, 0, 0, 0, 0 },
/* U+4cba */ { 0, 0, 0, 0, 0 },
/* U+4cbb */ { 0, 0, 0, 0, 0 },
/* U+4cbc */ { 0, 0, 0, 0, 0 },
/* U+4cbd */ { 0, 0, 0, 0, 0 },
/* U+4cbe */ { 0, 0, 0, 0, 0 },
/* U+4cbf */ { 0, 0, 0, 0, 0 },
/* U+4cc0 */ { 0, 0, 0, 0, 0 },
/* U+4cc1 */ { 0, 0, 0, 0, 0 },
/* U+4cc2 */ { 0, 0, 0, 0, 0 },
/* U+4cc3 */ { 0, 0, 0, 0, 0 },
/* U+4cc4 */ { 0, 0, 0, 0, 0 },
/* U+4cc5 */ { 0, 0, 0, 0, 0 },
/* U+4cc6 */ { 0, 0, 0, 0, 0 },
/* U+4cc7 */ { 0, 0, 0, 0, 0 },
/* U+4cc8 */ { 0, 0, 0, 0, 0 },
/* U+4cc9 */ { 0, 0, 0, 0, 0 },
/* U+4cca */ { 0, 0, 0, 0, 0 },
/* U+4ccb */ { 0, 0, 0, 0, 0 },
/* U+4ccc */ { 0, 0, 0, 0, 0 },
/* U+4ccd */ { 0, 0, 0, 0, 0 },
/* U+4cce */ { 0, 0, 0, 0, 0 },
/* U+4ccf */ { 0, 0, 0, 0, 0 },
/* U+4cd0 */ { 0, 0, 0, 0, 0 },
/* U+4cd1 */ { 0, 0, 0, 0, 0 },
/* U+4cd2 */ { 0, 0, 0, 0, 0 },
/* U+4cd3 */ { 0, 0, 0, 0, 0 },
/* U+4cd4 */ { 0, 0, 0, 0, 0 },
/* U+4cd5 */ { 0, 0, 0, 0, 0 },
/* U+4cd6 */ { 0, 0, 0, 0, 0 },
/* U+4cd7 */ { 0, 0, 0, 0, 0 },
/* U+4cd8 */ { 0, 0, 0, 0, 0 },
/* U+4cd9 */ { 0, 0, 0, 0, 0 },
/* U+4cda */ { 0, 0, 0, 0, 0 },
/* U+4cdb */ { 0, 0, 0, 0, 0 },
/* U+4cdc */ { 0, 0, 0, 0, 0 },
/* U+4cdd */ { 0, 0, 0, 0, 0 },
/* U+4cde */ { 0, 0, 0, 0, 0 },
/* U+4cdf */ { 0, 0, 0, 0, 0 },
/* U+4ce0 */ { 0, 0, 0, 0, 0 },
/* U+4ce1 */ { 0, 0, 0, 0, 0 },
/* U+4ce2 */ { 0, 0, 0, 0, 0 },
/* U+4ce3 */ { 0, 0, 0, 0, 0 },
/* U+4ce4 */ { 0, 0, 0, 0, 0 },
/* U+4ce5 */ { 0, 0, 0, 0, 0 },
/* U+4ce6 */ { 0, 0, 0, 0, 0 },
/* U+4ce7 */ { 0, 0, 0, 0, 0 },
/* U+4ce8 */ { 0, 0, 0, 0, 0 },
/* U+4ce9 */ { 0, 0, 0, 0, 0 },
/* U+4cea */ { 0, 0, 0, 0, 0 },
/* U+4ceb */ { 0, 0, 0, 0, 0 },
/* U+4cec */ { 0, 0, 0, 0, 0 },
/* U+4ced */ { 0, 0, 0, 0, 0 },
/* U+4cee */ { 0, 0, 0, 0, 0 },
/* U+4cef */ { 0, 0, 0, 0, 0 },
/* U+4cf0 */ { 0, 0, 0, 0, 0 },
/* U+4cf1 */ { 0, 0, 0, 0, 0 },
/* U+4cf2 */ { 0, 0, 0, 0, 0 },
/* U+4cf3 */ { 0, 0, 0, 0, 0 },
/* U+4cf4 */ { 0, 0, 0, 0, 0 },
/* U+4cf5 */ { 0, 0, 0, 0, 0 },
/* U+4cf6 */ { 0, 0, 0, 0, 0 },
/* U+4cf7 */ { 0, 0, 0, 0, 0 },
/* U+4cf8 */ { 0, 0, 0, 0, 0 },
/* U+4cf9 */ { 0, 0, 0, 0, 0 },
/* U+4cfa */ { 0, 0, 0, 0, 0 },
/* U+4cfb */ { 0, 0, 0, 0, 0 },
/* U+4cfc */ { 0, 0, 0, 0, 0 },
/* U+4cfd */ { 0, 0, 0, 0, 0 },
/* U+4cfe */ { 0, 0, 0, 0, 0 },
/* U+4cff */ { 0, 0, 0, 0, 0 },
/* U+4d00 */ { 0, 0, 0, 0, 0 },
/* U+4d01 */ { 0, 0, 0, 0, 0 },
/* U+4d02 */ { 0, 0, 0, 0, 0 },
/* U+4d03 */ { 0, 0, 0, 0, 0 },
/* U+4d04 */ { 0, 0, 0, 0, 0 },
/* U+4d05 */ { 0, 0, 0, 0, 0 },
/* U+4d06 */ { 0, 0, 0, 0, 0 },
/* U+4d07 */ { 0, 0, 0, 0, 0 },
/* U+4d08 */ { 0, 0, 0, 0, 0 },
/* U+4d09 */ { 0, 0, 0, 0, 0 },
/* U+4d0a */ { 0, 0, 0, 0, 0 },
/* U+4d0b */ { 0, 0, 0, 0, 0 },
/* U+4d0c */ { 0, 0, 0, 0, 0 },
/* U+4d0d */ { 0, 0, 0, 0, 0 },
/* U+4d0e */ { 0, 0, 0, 0, 0 },
/* U+4d0f */ { 0, 0, 0, 0, 0 },
/* U+4d10 */ { 0, 0, 0, 0, 0 },
/* U+4d11 */ { 0, 0, 0, 0, 0 },
/* U+4d12 */ { 0, 0, 0, 0, 0 },
/* U+4d13 */ { 0, 0, 0, 0, 0 },
/* U+4d14 */ { 0, 0, 0, 0, 0 },
/* U+4d15 */ { 0, 0, 0, 0, 0 },
/* U+4d16 */ { 0, 0, 0, 0, 0 },
/* U+4d17 */ { 0, 0, 0, 0, 0 },
/* U+4d18 */ { 0, 0, 0, 0, 0 },
/* U+4d19 */ { 0, 0, 0, 0, 0 },
/* U+4d1a */ { 0, 0, 0, 0, 0 },
/* U+4d1b */ { 0, 0, 0, 0, 0 },
/* U+4d1c */ { 0, 0, 0, 0, 0 },
/* U+4d1d */ { 0, 0, 0, 0, 0 },
/* U+4d1e */ { 0, 0, 0, 0, 0 },
/* U+4d1f */ { 0, 0, 0, 0, 0 },
/* U+4d20 */ { 0, 0, 0, 0, 0 },
/* U+4d21 */ { 0, 0, 0, 0, 0 },
/* U+4d22 */ { 0, 0, 0, 0, 0 },
/* U+4d23 */ { 0, 0, 0, 0, 0 },
/* U+4d24 */ { 0, 0, 0, 0, 0 },
/* U+4d25 */ { 0, 0, 0, 0, 0 },
/* U+4d26 */ { 0, 0, 0, 0, 0 },
/* U+4d27 */ { 0, 0, 0, 0, 0 },
/* U+4d28 */ { 0, 0, 0, 0, 0 },
/* U+4d29 */ { 0, 0, 0, 0, 0 },
/* U+4d2a */ { 0, 0, 0, 0, 0 },
/* U+4d2b */ { 0, 0, 0, 0, 0 },
/* U+4d2c */ { 0, 0, 0, 0, 0 },
/* U+4d2d */ { 0, 0, 0, 0, 0 },
/* U+4d2e */ { 0, 0, 0, 0, 0 },
/* U+4d2f */ { 0, 0, 0, 0, 0 },
/* U+4d30 */ { 0, 0, 0, 0, 0 },
/* U+4d31 */ { 0, 0, 0, 0, 0 },
/* U+4d32 */ { 0, 0, 0, 0, 0 },
/* U+4d33 */ { 0, 0, 0, 0, 0 },
/* U+4d34 */ { 0, 0, 0, 0, 0 },
/* U+4d35 */ { 0, 0, 0, 0, 0 },
/* U+4d36 */ { 0, 0, 0, 0, 0 },
/* U+4d37 */ { 0, 0, 0, 0, 0 },
/* U+4d38 */ { 0, 0, 0, 0, 0 },
/* U+4d39 */ { 0, 0, 0, 0, 0 },
/* U+4d3a */ { 0, 0, 0, 0, 0 },
/* U+4d3b */ { 0, 0, 0, 0, 0 },
/* U+4d3c */ { 0, 0, 0, 0, 0 },
/* U+4d3d */ { 0, 0, 0, 0, 0 },
/* U+4d3e */ { 0, 0, 0, 0, 0 },
/* U+4d3f */ { 0, 0, 0, 0, 0 },
/* U+4d40 */ { 0, 0, 0, 0, 0 },
/* U+4d41 */ { 0, 0, 0, 0, 0 },
/* U+4d42 */ { 0, 0, 0, 0, 0 },
/* U+4d43 */ { 0, 0, 0, 0, 0 },
/* U+4d44 */ { 0, 0, 0, 0, 0 },
/* U+4d45 */ { 0, 0, 0, 0, 0 },
/* U+4d46 */ { 0, 0, 0, 0, 0 },
/* U+4d47 */ { 0, 0, 0, 0, 0 },
/* U+4d48 */ { 0, 0, 0, 0, 0 },
/* U+4d49 */ { 0, 0, 0, 0, 0 },
/* U+4d4a */ { 0, 0, 0, 0, 0 },
/* U+4d4b */ { 0, 0, 0, 0, 0 },
/* U+4d4c */ { 0, 0, 0, 0, 0 },
/* U+4d4d */ { 0, 0, 0, 0, 0 },
/* U+4d4e */ { 0, 0, 0, 0, 0 },
/* U+4d4f */ { 0, 0, 0, 0, 0 },
/* U+4d50 */ { 0, 0, 0, 0, 0 },
/* U+4d51 */ { 0, 0, 0, 0, 0 },
/* U+4d52 */ { 0, 0, 0, 0, 0 },
/* U+4d53 */ { 0, 0, 0, 0, 0 },
/* U+4d54 */ { 0, 0, 0, 0, 0 },
/* U+4d55 */ { 0, 0, 0, 0, 0 },
/* U+4d56 */ { 0, 0, 0, 0, 0 },
/* U+4d57 */ { 0, 0, 0, 0, 0 },
/* U+4d58 */ { 0, 0, 0, 0, 0 },
/* U+4d59 */ { 0, 0, 0, 0, 0 },
/* U+4d5a */ { 0, 0, 0, 0, 0 },
/* U+4d5b */ { 0, 0, 0, 0, 0 },
/* U+4d5c */ { 0, 0, 0, 0, 0 },
/* U+4d5d */ { 0, 0, 0, 0, 0 },
/* U+4d5e */ { 0, 0, 0, 0, 0 },
/* U+4d5f */ { 0, 0, 0, 0, 0 },
/* U+4d60 */ { 0, 0, 0, 0, 0 },
/* U+4d61 */ { 0, 0, 0, 0, 0 },
/* U+4d62 */ { 0, 0, 0, 0, 0 },
/* U+4d63 */ { 0, 0, 0, 0, 0 },
/* U+4d64 */ { 0, 0, 0, 0, 0 },
/* U+4d65 */ { 0, 0, 0, 0, 0 },
/* U+4d66 */ { 0, 0, 0, 0, 0 },
/* U+4d67 */ { 0, 0, 0, 0, 0 },
/* U+4d68 */ { 0, 0, 0, 0, 0 },
/* U+4d69 */ { 0, 0, 0, 0, 0 },
/* U+4d6a */ { 0, 0, 0, 0, 0 },
/* U+4d6b */ { 0, 0, 0, 0, 0 },
/* U+4d6c */ { 0, 0, 0, 0, 0 },
/* U+4d6d */ { 0, 0, 0, 0, 0 },
/* U+4d6e */ { 0, 0, 0, 0, 0 },
/* U+4d6f */ { 0, 0, 0, 0, 0 },
/* U+4d70 */ { 0, 0, 0, 0, 0 },
/* U+4d71 */ { 0, 0, 0, 0, 0 },
/* U+4d72 */ { 0, 0, 0, 0, 0 },
/* U+4d73 */ { 0, 0, 0, 0, 0 },
/* U+4d74 */ { 0, 0, 0, 0, 0 },
/* U+4d75 */ { 0, 0, 0, 0, 0 },
/* U+4d76 */ { 0, 0, 0, 0, 0 },
/* U+4d77 */ { 0, 0, 0, 0, 0 },
/* U+4d78 */ { 0, 0, 0, 0, 0 },
/* U+4d79 */ { 0, 0, 0, 0, 0 },
/* U+4d7a */ { 0, 0, 0, 0, 0 },
/* U+4d7b */ { 0, 0, 0, 0, 0 },
/* U+4d7c */ { 0, 0, 0, 0, 0 },
/* U+4d7d */ { 0, 0, 0, 0, 0 },
/* U+4d7e */ { 0, 0, 0, 0, 0 },
/* U+4d7f */ { 0, 0, 0, 0, 0 },
/* U+4d80 */ { 0, 0, 0, 0, 0 },
/* U+4d81 */ { 0, 0, 0, 0, 0 },
/* U+4d82 */ { 0, 0, 0, 0, 0 },
/* U+4d83 */ { 0, 0, 0, 0, 0 },
/* U+4d84 */ { 0, 0, 0, 0, 0 },
/* U+4d85 */ { 0, 0, 0, 0, 0 },
/* U+4d86 */ { 0, 0, 0, 0, 0 },
/* U+4d87 */ { 0, 0, 0, 0, 0 },
/* U+4d88 */ { 0, 0, 0, 0, 0 },
/* U+4d89 */ { 0, 0, 0, 0, 0 },
/* U+4d8a */ { 0, 0, 0, 0, 0 },
/* U+4d8b */ { 0, 0, 0, 0, 0 },
/* U+4d8c */ { 0, 0, 0, 0, 0 },
/* U+4d8d */ { 0, 0, 0, 0, 0 },
/* U+4d8e */ { 0, 0, 0, 0, 0 },
/* U+4d8f */ { 0, 0, 0, 0, 0 },
/* U+4d90 */ { 0, 0, 0, 0, 0 },
/* U+4d91 */ { 0, 0, 0, 0, 0 },
/* U+4d92 */ { 0, 0, 0, 0, 0 },
/* U+4d93 */ { 0, 0, 0, 0, 0 },
/* U+4d94 */ { 0, 0, 0, 0, 0 },
/* U+4d95 */ { 0, 0, 0, 0, 0 },
/* U+4d96 */ { 0, 0, 0, 0, 0 },
/* U+4d97 */ { 0, 0, 0, 0, 0 },
/* U+4d98 */ { 0, 0, 0, 0, 0 },
/* U+4d99 */ { 0, 0, 0, 0, 0 },
/* U+4d9a */ { 0, 0, 0, 0, 0 },
/* U+4d9b */ { 0, 0, 0, 0, 0 },
/* U+4d9c */ { 0, 0, 0, 0, 0 },
/* U+4d9d */ { 0, 0, 0, 0, 0 },
/* U+4d9e */ { 0, 0, 0, 0, 0 },
/* U+4d9f */ { 0, 0, 0, 0, 0 },
/* U+4da0 */ { 0, 0, 0, 0, 0 },
/* U+4da1 */ { 0, 0, 0, 0, 0 },
/* U+4da2 */ { 0, 0, 0, 0, 0 },
/* U+4da3 */ { 0, 0, 0, 0, 0 },
/* U+4da4 */ { 0, 0, 0, 0, 0 },
/* U+4da5 */ { 0, 0, 0, 0, 0 },
/* U+4da6 */ { 0, 0, 0, 0, 0 },
/* U+4da7 */ { 0, 0, 0, 0, 0 },
/* U+4da8 */ { 0, 0, 0, 0, 0 },
/* U+4da9 */ { 0, 0, 0, 0, 0 },
/* U+4daa */ { 0, 0, 0, 0, 0 },
/* U+4dab */ { 0, 0, 0, 0, 0 },
/* U+4dac */ { 0, 0, 0, 0, 0 },
/* U+4dad */ { 0, 0, 0, 0, 0 },
/* U+4dae */ { 0, 0, 0, 0, 0 },
/* U+4daf */ { 0, 0, 0, 0, 0 },
/* U+4db0 */ { 0, 0, 0, 0, 0 },
/* U+4db1 */ { 0, 0, 0, 0, 0 },
/* U+4db2 */ { 0, 0, 0, 0, 0 },
/* U+4db3 */ { 0, 0, 0, 0, 0 },
/* U+4db4 */ { 0, 0, 0, 0, 0 },
/* U+4db5 */ { 19, 0, 1, 0, 0 },
/* U+4db6 */ { 0, 0, 0, 0, 0 },
/* U+4db7 */ { 0, 0, 0, 0, 0 },
/* U+4db8 */ { 0, 0, 0, 0, 0 },
/* U+4db9 */ { 0, 0, 0, 0, 0 },
/* U+4dba */ { 0, 0, 0, 0, 0 },
/* U+4dbb */ { 0, 0, 0, 0, 0 },
/* U+4dbc */ { 0, 0, 0, 0, 0 },
/* U+4dbd */ { 0, 0, 0, 0, 0 },
/* U+4dbe */ { 0, 0, 0, 0, 0 },
/* U+4dbf */ { 0, 0, 0, 0, 0 },
/* U+4dc0 */ { 0, 0, 0, 0, 0 },
/* U+4dc1 */ { 0, 0, 0, 0, 0 },
/* U+4dc2 */ { 0, 0, 0, 0, 0 },
/* U+4dc3 */ { 0, 0, 0, 0, 0 },
/* U+4dc4 */ { 0, 0, 0, 0, 0 },
/* U+4dc5 */ { 0, 0, 0, 0, 0 },
/* U+4dc6 */ { 0, 0, 0, 0, 0 },
/* U+4dc7 */ { 0, 0, 0, 0, 0 },
/* U+4dc8 */ { 0, 0, 0, 0, 0 },
/* U+4dc9 */ { 0, 0, 0, 0, 0 },
/* U+4dca */ { 0, 0, 0, 0, 0 },
/* U+4dcb */ { 0, 0, 0, 0, 0 },
/* U+4dcc */ { 0, 0, 0, 0, 0 },
/* U+4dcd */ { 0, 0, 0, 0, 0 },
/* U+4dce */ { 0, 0, 0, 0, 0 },
/* U+4dcf */ { 0, 0, 0, 0, 0 },
/* U+4dd0 */ { 0, 0, 0, 0, 0 },
/* U+4dd1 */ { 0, 0, 0, 0, 0 },
/* U+4dd2 */ { 0, 0, 0, 0, 0 },
/* U+4dd3 */ { 0, 0, 0, 0, 0 },
/* U+4dd4 */ { 0, 0, 0, 0, 0 },
/* U+4dd5 */ { 0, 0, 0, 0, 0 },
/* U+4dd6 */ { 0, 0, 0, 0, 0 },
/* U+4dd7 */ { 0, 0, 0, 0, 0 },
/* U+4dd8 */ { 0, 0, 0, 0, 0 },
/* U+4dd9 */ { 0, 0, 0, 0, 0 },
/* U+4dda */ { 0, 0, 0, 0, 0 },
/* U+4ddb */ { 0, 0, 0, 0, 0 },
/* U+4ddc */ { 0, 0, 0, 0, 0 },
/* U+4ddd */ { 0, 0, 0, 0, 0 },
/* U+4dde */ { 0, 0, 0, 0, 0 },
/* U+4ddf */ { 0, 0, 0, 0, 0 },
/* U+4de0 */ { 0, 0, 0, 0, 0 },
/* U+4de1 */ { 0, 0, 0, 0, 0 },
/* U+4de2 */ { 0, 0, 0, 0, 0 },
/* U+4de3 */ { 0, 0, 0, 0, 0 },
/* U+4de4 */ { 0, 0, 0, 0, 0 },
/* U+4de5 */ { 0, 0, 0, 0, 0 },
/* U+4de6 */ { 0, 0, 0, 0, 0 },
/* U+4de7 */ { 0, 0, 0, 0, 0 },
/* U+4de8 */ { 0, 0, 0, 0, 0 },
/* U+4de9 */ { 0, 0, 0, 0, 0 },
/* U+4dea */ { 0, 0, 0, 0, 0 },
/* U+4deb */ { 0, 0, 0, 0, 0 },
/* U+4dec */ { 0, 0, 0, 0, 0 },
/* U+4ded */ { 0, 0, 0, 0, 0 },
/* U+4dee */ { 0, 0, 0, 0, 0 },
/* U+4def */ { 0, 0, 0, 0, 0 },
/* U+4df0 */ { 0, 0, 0, 0, 0 },
/* U+4df1 */ { 0, 0, 0, 0, 0 },
/* U+4df2 */ { 0, 0, 0, 0, 0 },
/* U+4df3 */ { 0, 0, 0, 0, 0 },
/* U+4df4 */ { 0, 0, 0, 0, 0 },
/* U+4df5 */ { 0, 0, 0, 0, 0 },
/* U+4df6 */ { 0, 0, 0, 0, 0 },
/* U+4df7 */ { 0, 0, 0, 0, 0 },
/* U+4df8 */ { 0, 0, 0, 0, 0 },
/* U+4df9 */ { 0, 0, 0, 0, 0 },
/* U+4dfa */ { 0, 0, 0, 0, 0 },
/* U+4dfb */ { 0, 0, 0, 0, 0 },
/* U+4dfc */ { 0, 0, 0, 0, 0 },
/* U+4dfd */ { 0, 0, 0, 0, 0 },
/* U+4dfe */ { 0, 0, 0, 0, 0 },
/* U+4dff */ { 0, 0, 0, 0, 0 },
/* U+4e00 */ { 19, 0, 1, 0, 0 },
/* U+4e01 */ { 0, 0, 0, 0, 0 },
/* U+4e02 */ { 0, 0, 0, 0, 0 },
/* U+4e03 */ { 0, 0, 0, 0, 0 },
/* U+4e04 */ { 0, 0, 0, 0, 0 },
/* U+4e05 */ { 0, 0, 0, 0, 0 },
/* U+4e06 */ { 0, 0, 0, 0, 0 },
/* U+4e07 */ { 0, 0, 0, 0, 0 },
/* U+4e08 */ { 0, 0, 0, 0, 0 },
/* U+4e09 */ { 0, 0, 0, 0, 0 },
/* U+4e0a */ { 0, 0, 0, 0, 0 },
/* U+4e0b */ { 0, 0, 0, 0, 0 },
/* U+4e0c */ { 0, 0, 0, 0, 0 },
/* U+4e0d */ { 0, 0, 0, 0, 0 },
/* U+4e0e */ { 0, 0, 0, 0, 0 },
/* U+4e0f */ { 0, 0, 0, 0, 0 },
/* U+4e10 */ { 0, 0, 0, 0, 0 },
/* U+4e11 */ { 0, 0, 0, 0, 0 },
/* U+4e12 */ { 0, 0, 0, 0, 0 },
/* U+4e13 */ { 0, 0, 0, 0, 0 },
/* U+4e14 */ { 0, 0, 0, 0, 0 },
/* U+4e15 */ { 0, 0, 0, 0, 0 },
/* U+4e16 */ { 0, 0, 0, 0, 0 },
/* U+4e17 */ { 0, 0, 0, 0, 0 },
/* U+4e18 */ { 0, 0, 0, 0, 0 },
/* U+4e19 */ { 0, 0, 0, 0, 0 },
/* U+4e1a */ { 0, 0, 0, 0, 0 },
/* U+4e1b */ { 0, 0, 0, 0, 0 },
/* U+4e1c */ { 0, 0, 0, 0, 0 },
/* U+4e1d */ { 0, 0, 0, 0, 0 },
/* U+4e1e */ { 0, 0, 0, 0, 0 },
/* U+4e1f */ { 0, 0, 0, 0, 0 },
/* U+4e20 */ { 0, 0, 0, 0, 0 },
/* U+4e21 */ { 0, 0, 0, 0, 0 },
/* U+4e22 */ { 0, 0, 0, 0, 0 },
/* U+4e23 */ { 0, 0, 0, 0, 0 },
/* U+4e24 */ { 0, 0, 0, 0, 0 },
/* U+4e25 */ { 0, 0, 0, 0, 0 },
/* U+4e26 */ { 0, 0, 0, 0, 0 },
/* U+4e27 */ { 0, 0, 0, 0, 0 },
/* U+4e28 */ { 0, 0, 0, 0, 0 },
/* U+4e29 */ { 0, 0, 0, 0, 0 },
/* U+4e2a */ { 0, 0, 0, 0, 0 },
/* U+4e2b */ { 0, 0, 0, 0, 0 },
/* U+4e2c */ { 0, 0, 0, 0, 0 },
/* U+4e2d */ { 0, 0, 0, 0, 0 },
/* U+4e2e */ { 0, 0, 0, 0, 0 },
/* U+4e2f */ { 0, 0, 0, 0, 0 },
/* U+4e30 */ { 0, 0, 0, 0, 0 },
/* U+4e31 */ { 0, 0, 0, 0, 0 },
/* U+4e32 */ { 0, 0, 0, 0, 0 },
/* U+4e33 */ { 0, 0, 0, 0, 0 },
/* U+4e34 */ { 0, 0, 0, 0, 0 },
/* U+4e35 */ { 0, 0, 0, 0, 0 },
/* U+4e36 */ { 0, 0, 0, 0, 0 },
/* U+4e37 */ { 0, 0, 0, 0, 0 },
/* U+4e38 */ { 0, 0, 0, 0, 0 },
/* U+4e39 */ { 0, 0, 0, 0, 0 },
/* U+4e3a */ { 0, 0, 0, 0, 0 },
/* U+4e3b */ { 0, 0, 0, 0, 0 },
/* U+4e3c */ { 0, 0, 0, 0, 0 },
/* U+4e3d */ { 0, 0, 0, 0, 0 },
/* U+4e3e */ { 0, 0, 0, 0, 0 },
/* U+4e3f */ { 0, 0, 0, 0, 0 },
/* U+4e40 */ { 0, 0, 0, 0, 0 },
/* U+4e41 */ { 0, 0, 0, 0, 0 },
/* U+4e42 */ { 0, 0, 0, 0, 0 },
/* U+4e43 */ { 0, 0, 0, 0, 0 },
/* U+4e44 */ { 0, 0, 0, 0, 0 },
/* U+4e45 */ { 0, 0, 0, 0, 0 },
/* U+4e46 */ { 0, 0, 0, 0, 0 },
/* U+4e47 */ { 0, 0, 0, 0, 0 },
/* U+4e48 */ { 0, 0, 0, 0, 0 },
/* U+4e49 */ { 0, 0, 0, 0, 0 },
/* U+4e4a */ { 0, 0, 0, 0, 0 },
/* U+4e4b */ { 0, 0, 0, 0, 0 },
/* U+4e4c */ { 0, 0, 0, 0, 0 },
/* U+4e4d */ { 0, 0, 0, 0, 0 },
/* U+4e4e */ { 0, 0, 0, 0, 0 },
/* U+4e4f */ { 0, 0, 0, 0, 0 },
/* U+4e50 */ { 0, 0, 0, 0, 0 },
/* U+4e51 */ { 0, 0, 0, 0, 0 },
/* U+4e52 */ { 0, 0, 0, 0, 0 },
/* U+4e53 */ { 0, 0, 0, 0, 0 },
/* U+4e54 */ { 0, 0, 0, 0, 0 },
/* U+4e55 */ { 0, 0, 0, 0, 0 },
/* U+4e56 */ { 0, 0, 0, 0, 0 },
/* U+4e57 */ { 0, 0, 0, 0, 0 },
/* U+4e58 */ { 0, 0, 0, 0, 0 },
/* U+4e59 */ { 0, 0, 0, 0, 0 },
/* U+4e5a */ { 0, 0, 0, 0, 0 },
/* U+4e5b */ { 0, 0, 0, 0, 0 },
/* U+4e5c */ { 0, 0, 0, 0, 0 },
/* U+4e5d */ { 0, 0, 0, 0, 0 },
/* U+4e5e */ { 0, 0, 0, 0, 0 },
/* U+4e5f */ { 0, 0, 0, 0, 0 },
/* U+4e60 */ { 0, 0, 0, 0, 0 },
/* U+4e61 */ { 0, 0, 0, 0, 0 },
/* U+4e62 */ { 0, 0, 0, 0, 0 },
/* U+4e63 */ { 0, 0, 0, 0, 0 },
/* U+4e64 */ { 0, 0, 0, 0, 0 },
/* U+4e65 */ { 0, 0, 0, 0, 0 },
/* U+4e66 */ { 0, 0, 0, 0, 0 },
/* U+4e67 */ { 0, 0, 0, 0, 0 },
/* U+4e68 */ { 0, 0, 0, 0, 0 },
/* U+4e69 */ { 0, 0, 0, 0, 0 },
/* U+4e6a */ { 0, 0, 0, 0, 0 },
/* U+4e6b */ { 0, 0, 0, 0, 0 },
/* U+4e6c */ { 0, 0, 0, 0, 0 },
/* U+4e6d */ { 0, 0, 0, 0, 0 },
/* U+4e6e */ { 0, 0, 0, 0, 0 },
/* U+4e6f */ { 0, 0, 0, 0, 0 },
/* U+4e70 */ { 0, 0, 0, 0, 0 },
/* U+4e71 */ { 0, 0, 0, 0, 0 },
/* U+4e72 */ { 0, 0, 0, 0, 0 },
/* U+4e73 */ { 0, 0, 0, 0, 0 },
/* U+4e74 */ { 0, 0, 0, 0, 0 },
/* U+4e75 */ { 0, 0, 0, 0, 0 },
/* U+4e76 */ { 0, 0, 0, 0, 0 },
/* U+4e77 */ { 0, 0, 0, 0, 0 },
/* U+4e78 */ { 0, 0, 0, 0, 0 },
/* U+4e79 */ { 0, 0, 0, 0, 0 },
/* U+4e7a */ { 0, 0, 0, 0, 0 },
/* U+4e7b */ { 0, 0, 0, 0, 0 },
/* U+4e7c */ { 0, 0, 0, 0, 0 },
/* U+4e7d */ { 0, 0, 0, 0, 0 },
/* U+4e7e */ { 0, 0, 0, 0, 0 },
/* U+4e7f */ { 0, 0, 0, 0, 0 },
/* U+4e80 */ { 0, 0, 0, 0, 0 },
/* U+4e81 */ { 0, 0, 0, 0, 0 },
/* U+4e82 */ { 0, 0, 0, 0, 0 },
/* U+4e83 */ { 0, 0, 0, 0, 0 },
/* U+4e84 */ { 0, 0, 0, 0, 0 },
/* U+4e85 */ { 0, 0, 0, 0, 0 },
/* U+4e86 */ { 0, 0, 0, 0, 0 },
/* U+4e87 */ { 0, 0, 0, 0, 0 },
/* U+4e88 */ { 0, 0, 0, 0, 0 },
/* U+4e89 */ { 0, 0, 0, 0, 0 },
/* U+4e8a */ { 0, 0, 0, 0, 0 },
/* U+4e8b */ { 0, 0, 0, 0, 0 },
/* U+4e8c */ { 0, 0, 0, 0, 0 },
/* U+4e8d */ { 0, 0, 0, 0, 0 },
/* U+4e8e */ { 0, 0, 0, 0, 0 },
/* U+4e8f */ { 0, 0, 0, 0, 0 },
/* U+4e90 */ { 0, 0, 0, 0, 0 },
/* U+4e91 */ { 0, 0, 0, 0, 0 },
/* U+4e92 */ { 0, 0, 0, 0, 0 },
/* U+4e93 */ { 0, 0, 0, 0, 0 },
/* U+4e94 */ { 0, 0, 0, 0, 0 },
/* U+4e95 */ { 0, 0, 0, 0, 0 },
/* U+4e96 */ { 0, 0, 0, 0, 0 },
/* U+4e97 */ { 0, 0, 0, 0, 0 },
/* U+4e98 */ { 0, 0, 0, 0, 0 },
/* U+4e99 */ { 0, 0, 0, 0, 0 },
/* U+4e9a */ { 0, 0, 0, 0, 0 },
/* U+4e9b */ { 0, 0, 0, 0, 0 },
/* U+4e9c */ { 0, 0, 0, 0, 0 },
/* U+4e9d */ { 0, 0, 0, 0, 0 },
/* U+4e9e */ { 0, 0, 0, 0, 0 },
/* U+4e9f */ { 0, 0, 0, 0, 0 },
/* U+4ea0 */ { 0, 0, 0, 0, 0 },
/* U+4ea1 */ { 0, 0, 0, 0, 0 },
/* U+4ea2 */ { 0, 0, 0, 0, 0 },
/* U+4ea3 */ { 0, 0, 0, 0, 0 },
/* U+4ea4 */ { 0, 0, 0, 0, 0 },
/* U+4ea5 */ { 0, 0, 0, 0, 0 },
/* U+4ea6 */ { 0, 0, 0, 0, 0 },
/* U+4ea7 */ { 0, 0, 0, 0, 0 },
/* U+4ea8 */ { 0, 0, 0, 0, 0 },
/* U+4ea9 */ { 0, 0, 0, 0, 0 },
/* U+4eaa */ { 0, 0, 0, 0, 0 },
/* U+4eab */ { 0, 0, 0, 0, 0 },
/* U+4eac */ { 0, 0, 0, 0, 0 },
/* U+4ead */ { 0, 0, 0, 0, 0 },
/* U+4eae */ { 0, 0, 0, 0, 0 },
/* U+4eaf */ { 0, 0, 0, 0, 0 },
/* U+4eb0 */ { 0, 0, 0, 0, 0 },
/* U+4eb1 */ { 0, 0, 0, 0, 0 },
/* U+4eb2 */ { 0, 0, 0, 0, 0 },
/* U+4eb3 */ { 0, 0, 0, 0, 0 },
/* U+4eb4 */ { 0, 0, 0, 0, 0 },
/* U+4eb5 */ { 0, 0, 0, 0, 0 },
/* U+4eb6 */ { 0, 0, 0, 0, 0 },
/* U+4eb7 */ { 0, 0, 0, 0, 0 },
/* U+4eb8 */ { 0, 0, 0, 0, 0 },
/* U+4eb9 */ { 0, 0, 0, 0, 0 },
/* U+4eba */ { 0, 0, 0, 0, 0 },
/* U+4ebb */ { 0, 0, 0, 0, 0 },
/* U+4ebc */ { 0, 0, 0, 0, 0 },
/* U+4ebd */ { 0, 0, 0, 0, 0 },
/* U+4ebe */ { 0, 0, 0, 0, 0 },
/* U+4ebf */ { 0, 0, 0, 0, 0 },
/* U+4ec0 */ { 0, 0, 0, 0, 0 },
/* U+4ec1 */ { 0, 0, 0, 0, 0 },
/* U+4ec2 */ { 0, 0, 0, 0, 0 },
/* U+4ec3 */ { 0, 0, 0, 0, 0 },
/* U+4ec4 */ { 0, 0, 0, 0, 0 },
/* U+4ec5 */ { 0, 0, 0, 0, 0 },
/* U+4ec6 */ { 0, 0, 0, 0, 0 },
/* U+4ec7 */ { 0, 0, 0, 0, 0 },
/* U+4ec8 */ { 0, 0, 0, 0, 0 },
/* U+4ec9 */ { 0, 0, 0, 0, 0 },
/* U+4eca */ { 0, 0, 0, 0, 0 },
/* U+4ecb */ { 0, 0, 0, 0, 0 },
/* U+4ecc */ { 0, 0, 0, 0, 0 },
/* U+4ecd */ { 0, 0, 0, 0, 0 },
/* U+4ece */ { 0, 0, 0, 0, 0 },
/* U+4ecf */ { 0, 0, 0, 0, 0 },
/* U+4ed0 */ { 0, 0, 0, 0, 0 },
/* U+4ed1 */ { 0, 0, 0, 0, 0 },
/* U+4ed2 */ { 0, 0, 0, 0, 0 },
/* U+4ed3 */ { 0, 0, 0, 0, 0 },
/* U+4ed4 */ { 0, 0, 0, 0, 0 },
/* U+4ed5 */ { 0, 0, 0, 0, 0 },
/* U+4ed6 */ { 0, 0, 0, 0, 0 },
/* U+4ed7 */ { 0, 0, 0, 0, 0 },
/* U+4ed8 */ { 0, 0, 0, 0, 0 },
/* U+4ed9 */ { 0, 0, 0, 0, 0 },
/* U+4eda */ { 0, 0, 0, 0, 0 },
/* U+4edb */ { 0, 0, 0, 0, 0 },
/* U+4edc */ { 0, 0, 0, 0, 0 },
/* U+4edd */ { 0, 0, 0, 0, 0 },
/* U+4ede */ { 0, 0, 0, 0, 0 },
/* U+4edf */ { 0, 0, 0, 0, 0 },
/* U+4ee0 */ { 0, 0, 0, 0, 0 },
/* U+4ee1 */ { 0, 0, 0, 0, 0 },
/* U+4ee2 */ { 0, 0, 0, 0, 0 },
/* U+4ee3 */ { 0, 0, 0, 0, 0 },
/* U+4ee4 */ { 0, 0, 0, 0, 0 },
/* U+4ee5 */ { 0, 0, 0, 0, 0 },
/* U+4ee6 */ { 0, 0, 0, 0, 0 },
/* U+4ee7 */ { 0, 0, 0, 0, 0 },
/* U+4ee8 */ { 0, 0, 0, 0, 0 },
/* U+4ee9 */ { 0, 0, 0, 0, 0 },
/* U+4eea */ { 0, 0, 0, 0, 0 },
/* U+4eeb */ { 0, 0, 0, 0, 0 },
/* U+4eec */ { 0, 0, 0, 0, 0 },
/* U+4eed */ { 0, 0, 0, 0, 0 },
/* U+4eee */ { 0, 0, 0, 0, 0 },
/* U+4eef */ { 0, 0, 0, 0, 0 },
/* U+4ef0 */ { 0, 0, 0, 0, 0 },
/* U+4ef1 */ { 0, 0, 0, 0, 0 },
/* U+4ef2 */ { 0, 0, 0, 0, 0 },
/* U+4ef3 */ { 0, 0, 0, 0, 0 },
/* U+4ef4 */ { 0, 0, 0, 0, 0 },
/* U+4ef5 */ { 0, 0, 0, 0, 0 },
/* U+4ef6 */ { 0, 0, 0, 0, 0 },
/* U+4ef7 */ { 0, 0, 0, 0, 0 },
/* U+4ef8 */ { 0, 0, 0, 0, 0 },
/* U+4ef9 */ { 0, 0, 0, 0, 0 },
/* U+4efa */ { 0, 0, 0, 0, 0 },
/* U+4efb */ { 0, 0, 0, 0, 0 },
/* U+4efc */ { 0, 0, 0, 0, 0 },
/* U+4efd */ { 0, 0, 0, 0, 0 },
/* U+4efe */ { 0, 0, 0, 0, 0 },
/* U+4eff */ { 0, 0, 0, 0, 0 },
/* U+4f00 */ { 0, 0, 0, 0, 0 },
/* U+4f01 */ { 0, 0, 0, 0, 0 },
/* U+4f02 */ { 0, 0, 0, 0, 0 },
/* U+4f03 */ { 0, 0, 0, 0, 0 },
/* U+4f04 */ { 0, 0, 0, 0, 0 },
/* U+4f05 */ { 0, 0, 0, 0, 0 },
/* U+4f06 */ { 0, 0, 0, 0, 0 },
/* U+4f07 */ { 0, 0, 0, 0, 0 },
/* U+4f08 */ { 0, 0, 0, 0, 0 },
/* U+4f09 */ { 0, 0, 0, 0, 0 },
/* U+4f0a */ { 0, 0, 0, 0, 0 },
/* U+4f0b */ { 0, 0, 0, 0, 0 },
/* U+4f0c */ { 0, 0, 0, 0, 0 },
/* U+4f0d */ { 0, 0, 0, 0, 0 },
/* U+4f0e */ { 0, 0, 0, 0, 0 },
/* U+4f0f */ { 0, 0, 0, 0, 0 },
/* U+4f10 */ { 0, 0, 0, 0, 0 },
/* U+4f11 */ { 0, 0, 0, 0, 0 },
/* U+4f12 */ { 0, 0, 0, 0, 0 },
/* U+4f13 */ { 0, 0, 0, 0, 0 },
/* U+4f14 */ { 0, 0, 0, 0, 0 },
/* U+4f15 */ { 0, 0, 0, 0, 0 },
/* U+4f16 */ { 0, 0, 0, 0, 0 },
/* U+4f17 */ { 0, 0, 0, 0, 0 },
/* U+4f18 */ { 0, 0, 0, 0, 0 },
/* U+4f19 */ { 0, 0, 0, 0, 0 },
/* U+4f1a */ { 0, 0, 0, 0, 0 },
/* U+4f1b */ { 0, 0, 0, 0, 0 },
/* U+4f1c */ { 0, 0, 0, 0, 0 },
/* U+4f1d */ { 0, 0, 0, 0, 0 },
/* U+4f1e */ { 0, 0, 0, 0, 0 },
/* U+4f1f */ { 0, 0, 0, 0, 0 },
/* U+4f20 */ { 0, 0, 0, 0, 0 },
/* U+4f21 */ { 0, 0, 0, 0, 0 },
/* U+4f22 */ { 0, 0, 0, 0, 0 },
/* U+4f23 */ { 0, 0, 0, 0, 0 },
/* U+4f24 */ { 0, 0, 0, 0, 0 },
/* U+4f25 */ { 0, 0, 0, 0, 0 },
/* U+4f26 */ { 0, 0, 0, 0, 0 },
/* U+4f27 */ { 0, 0, 0, 0, 0 },
/* U+4f28 */ { 0, 0, 0, 0, 0 },
/* U+4f29 */ { 0, 0, 0, 0, 0 },
/* U+4f2a */ { 0, 0, 0, 0, 0 },
/* U+4f2b */ { 0, 0, 0, 0, 0 },
/* U+4f2c */ { 0, 0, 0, 0, 0 },
/* U+4f2d */ { 0, 0, 0, 0, 0 },
/* U+4f2e */ { 0, 0, 0, 0, 0 },
/* U+4f2f */ { 0, 0, 0, 0, 0 },
/* U+4f30 */ { 0, 0, 0, 0, 0 },
/* U+4f31 */ { 0, 0, 0, 0, 0 },
/* U+4f32 */ { 0, 0, 0, 0, 0 },
/* U+4f33 */ { 0, 0, 0, 0, 0 },
/* U+4f34 */ { 0, 0, 0, 0, 0 },
/* U+4f35 */ { 0, 0, 0, 0, 0 },
/* U+4f36 */ { 0, 0, 0, 0, 0 },
/* U+4f37 */ { 0, 0, 0, 0, 0 },
/* U+4f38 */ { 0, 0, 0, 0, 0 },
/* U+4f39 */ { 0, 0, 0, 0, 0 },
/* U+4f3a */ { 0, 0, 0, 0, 0 },
/* U+4f3b */ { 0, 0, 0, 0, 0 },
/* U+4f3c */ { 0, 0, 0, 0, 0 },
/* U+4f3d */ { 0, 0, 0, 0, 0 },
/* U+4f3e */ { 0, 0, 0, 0, 0 },
/* U+4f3f */ { 0, 0, 0, 0, 0 },
/* U+4f40 */ { 0, 0, 0, 0, 0 },
/* U+4f41 */ { 0, 0, 0, 0, 0 },
/* U+4f42 */ { 0, 0, 0, 0, 0 },
/* U+4f43 */ { 0, 0, 0, 0, 0 },
/* U+4f44 */ { 0, 0, 0, 0, 0 },
/* U+4f45 */ { 0, 0, 0, 0, 0 },
/* U+4f46 */ { 0, 0, 0, 0, 0 },
/* U+4f47 */ { 0, 0, 0, 0, 0 },
/* U+4f48 */ { 0, 0, 0, 0, 0 },
/* U+4f49 */ { 0, 0, 0, 0, 0 },
/* U+4f4a */ { 0, 0, 0, 0, 0 },
/* U+4f4b */ { 0, 0, 0, 0, 0 },
/* U+4f4c */ { 0, 0, 0, 0, 0 },
/* U+4f4d */ { 0, 0, 0, 0, 0 },
/* U+4f4e */ { 0, 0, 0, 0, 0 },
/* U+4f4f */ { 0, 0, 0, 0, 0 },
/* U+4f50 */ { 0, 0, 0, 0, 0 },
/* U+4f51 */ { 0, 0, 0, 0, 0 },
/* U+4f52 */ { 0, 0, 0, 0, 0 },
/* U+4f53 */ { 0, 0, 0, 0, 0 },
/* U+4f54 */ { 0, 0, 0, 0, 0 },
/* U+4f55 */ { 0, 0, 0, 0, 0 },
/* U+4f56 */ { 0, 0, 0, 0, 0 },
/* U+4f57 */ { 0, 0, 0, 0, 0 },
/* U+4f58 */ { 0, 0, 0, 0, 0 },
/* U+4f59 */ { 0, 0, 0, 0, 0 },
/* U+4f5a */ { 0, 0, 0, 0, 0 },
/* U+4f5b */ { 0, 0, 0, 0, 0 },
/* U+4f5c */ { 0, 0, 0, 0, 0 },
/* U+4f5d */ { 0, 0, 0, 0, 0 },
/* U+4f5e */ { 0, 0, 0, 0, 0 },
/* U+4f5f */ { 0, 0, 0, 0, 0 },
/* U+4f60 */ { 0, 0, 0, 0, 0 },
/* U+4f61 */ { 0, 0, 0, 0, 0 },
/* U+4f62 */ { 0, 0, 0, 0, 0 },
/* U+4f63 */ { 0, 0, 0, 0, 0 },
/* U+4f64 */ { 0, 0, 0, 0, 0 },
/* U+4f65 */ { 0, 0, 0, 0, 0 },
/* U+4f66 */ { 0, 0, 0, 0, 0 },
/* U+4f67 */ { 0, 0, 0, 0, 0 },
/* U+4f68 */ { 0, 0, 0, 0, 0 },
/* U+4f69 */ { 0, 0, 0, 0, 0 },
/* U+4f6a */ { 0, 0, 0, 0, 0 },
/* U+4f6b */ { 0, 0, 0, 0, 0 },
/* U+4f6c */ { 0, 0, 0, 0, 0 },
/* U+4f6d */ { 0, 0, 0, 0, 0 },
/* U+4f6e */ { 0, 0, 0, 0, 0 },
/* U+4f6f */ { 0, 0, 0, 0, 0 },
/* U+4f70 */ { 0, 0, 0, 0, 0 },
/* U+4f71 */ { 0, 0, 0, 0, 0 },
/* U+4f72 */ { 0, 0, 0, 0, 0 },
/* U+4f73 */ { 0, 0, 0, 0, 0 },
/* U+4f74 */ { 0, 0, 0, 0, 0 },
/* U+4f75 */ { 0, 0, 0, 0, 0 },
/* U+4f76 */ { 0, 0, 0, 0, 0 },
/* U+4f77 */ { 0, 0, 0, 0, 0 },
/* U+4f78 */ { 0, 0, 0, 0, 0 },
/* U+4f79 */ { 0, 0, 0, 0, 0 },
/* U+4f7a */ { 0, 0, 0, 0, 0 },
/* U+4f7b */ { 0, 0, 0, 0, 0 },
/* U+4f7c */ { 0, 0, 0, 0, 0 },
/* U+4f7d */ { 0, 0, 0, 0, 0 },
/* U+4f7e */ { 0, 0, 0, 0, 0 },
/* U+4f7f */ { 0, 0, 0, 0, 0 },
/* U+4f80 */ { 0, 0, 0, 0, 0 },
/* U+4f81 */ { 0, 0, 0, 0, 0 },
/* U+4f82 */ { 0, 0, 0, 0, 0 },
/* U+4f83 */ { 0, 0, 0, 0, 0 },
/* U+4f84 */ { 0, 0, 0, 0, 0 },
/* U+4f85 */ { 0, 0, 0, 0, 0 },
/* U+4f86 */ { 0, 0, 0, 0, 0 },
/* U+4f87 */ { 0, 0, 0, 0, 0 },
/* U+4f88 */ { 0, 0, 0, 0, 0 },
/* U+4f89 */ { 0, 0, 0, 0, 0 },
/* U+4f8a */ { 0, 0, 0, 0, 0 },
/* U+4f8b */ { 0, 0, 0, 0, 0 },
/* U+4f8c */ { 0, 0, 0, 0, 0 },
/* U+4f8d */ { 0, 0, 0, 0, 0 },
/* U+4f8e */ { 0, 0, 0, 0, 0 },
/* U+4f8f */ { 0, 0, 0, 0, 0 },
/* U+4f90 */ { 0, 0, 0, 0, 0 },
/* U+4f91 */ { 0, 0, 0, 0, 0 },
/* U+4f92 */ { 0, 0, 0, 0, 0 },
/* U+4f93 */ { 0, 0, 0, 0, 0 },
/* U+4f94 */ { 0, 0, 0, 0, 0 },
/* U+4f95 */ { 0, 0, 0, 0, 0 },
/* U+4f96 */ { 0, 0, 0, 0, 0 },
/* U+4f97 */ { 0, 0, 0, 0, 0 },
/* U+4f98 */ { 0, 0, 0, 0, 0 },
/* U+4f99 */ { 0, 0, 0, 0, 0 },
/* U+4f9a */ { 0, 0, 0, 0, 0 },
/* U+4f9b */ { 0, 0, 0, 0, 0 },
/* U+4f9c */ { 0, 0, 0, 0, 0 },
/* U+4f9d */ { 0, 0, 0, 0, 0 },
/* U+4f9e */ { 0, 0, 0, 0, 0 },
/* U+4f9f */ { 0, 0, 0, 0, 0 },
/* U+4fa0 */ { 0, 0, 0, 0, 0 },
/* U+4fa1 */ { 0, 0, 0, 0, 0 },
/* U+4fa2 */ { 0, 0, 0, 0, 0 },
/* U+4fa3 */ { 0, 0, 0, 0, 0 },
/* U+4fa4 */ { 0, 0, 0, 0, 0 },
/* U+4fa5 */ { 0, 0, 0, 0, 0 },
/* U+4fa6 */ { 0, 0, 0, 0, 0 },
/* U+4fa7 */ { 0, 0, 0, 0, 0 },
/* U+4fa8 */ { 0, 0, 0, 0, 0 },
/* U+4fa9 */ { 0, 0, 0, 0, 0 },
/* U+4faa */ { 0, 0, 0, 0, 0 },
/* U+4fab */ { 0, 0, 0, 0, 0 },
/* U+4fac */ { 0, 0, 0, 0, 0 },
/* U+4fad */ { 0, 0, 0, 0, 0 },
/* U+4fae */ { 0, 0, 0, 0, 0 },
/* U+4faf */ { 0, 0, 0, 0, 0 },
/* U+4fb0 */ { 0, 0, 0, 0, 0 },
/* U+4fb1 */ { 0, 0, 0, 0, 0 },
/* U+4fb2 */ { 0, 0, 0, 0, 0 },
/* U+4fb3 */ { 0, 0, 0, 0, 0 },
/* U+4fb4 */ { 0, 0, 0, 0, 0 },
/* U+4fb5 */ { 0, 0, 0, 0, 0 },
/* U+4fb6 */ { 0, 0, 0, 0, 0 },
/* U+4fb7 */ { 0, 0, 0, 0, 0 },
/* U+4fb8 */ { 0, 0, 0, 0, 0 },
/* U+4fb9 */ { 0, 0, 0, 0, 0 },
/* U+4fba */ { 0, 0, 0, 0, 0 },
/* U+4fbb */ { 0, 0, 0, 0, 0 },
/* U+4fbc */ { 0, 0, 0, 0, 0 },
/* U+4fbd */ { 0, 0, 0, 0, 0 },
/* U+4fbe */ { 0, 0, 0, 0, 0 },
/* U+4fbf */ { 0, 0, 0, 0, 0 },
/* U+4fc0 */ { 0, 0, 0, 0, 0 },
/* U+4fc1 */ { 0, 0, 0, 0, 0 },
/* U+4fc2 */ { 0, 0, 0, 0, 0 },
/* U+4fc3 */ { 0, 0, 0, 0, 0 },
/* U+4fc4 */ { 0, 0, 0, 0, 0 },
/* U+4fc5 */ { 0, 0, 0, 0, 0 },
/* U+4fc6 */ { 0, 0, 0, 0, 0 },
/* U+4fc7 */ { 0, 0, 0, 0, 0 },
/* U+4fc8 */ { 0, 0, 0, 0, 0 },
/* U+4fc9 */ { 0, 0, 0, 0, 0 },
/* U+4fca */ { 0, 0, 0, 0, 0 },
/* U+4fcb */ { 0, 0, 0, 0, 0 },
/* U+4fcc */ { 0, 0, 0, 0, 0 },
/* U+4fcd */ { 0, 0, 0, 0, 0 },
/* U+4fce */ { 0, 0, 0, 0, 0 },
/* U+4fcf */ { 0, 0, 0, 0, 0 },
/* U+4fd0 */ { 0, 0, 0, 0, 0 },
/* U+4fd1 */ { 0, 0, 0, 0, 0 },
/* U+4fd2 */ { 0, 0, 0, 0, 0 },
/* U+4fd3 */ { 0, 0, 0, 0, 0 },
/* U+4fd4 */ { 0, 0, 0, 0, 0 },
/* U+4fd5 */ { 0, 0, 0, 0, 0 },
/* U+4fd6 */ { 0, 0, 0, 0, 0 },
/* U+4fd7 */ { 0, 0, 0, 0, 0 },
/* U+4fd8 */ { 0, 0, 0, 0, 0 },
/* U+4fd9 */ { 0, 0, 0, 0, 0 },
/* U+4fda */ { 0, 0, 0, 0, 0 },
/* U+4fdb */ { 0, 0, 0, 0, 0 },
/* U+4fdc */ { 0, 0, 0, 0, 0 },
/* U+4fdd */ { 0, 0, 0, 0, 0 },
/* U+4fde */ { 0, 0, 0, 0, 0 },
/* U+4fdf */ { 0, 0, 0, 0, 0 },
/* U+4fe0 */ { 0, 0, 0, 0, 0 },
/* U+4fe1 */ { 0, 0, 0, 0, 0 },
/* U+4fe2 */ { 0, 0, 0, 0, 0 },
/* U+4fe3 */ { 0, 0, 0, 0, 0 },
/* U+4fe4 */ { 0, 0, 0, 0, 0 },
/* U+4fe5 */ { 0, 0, 0, 0, 0 },
/* U+4fe6 */ { 0, 0, 0, 0, 0 },
/* U+4fe7 */ { 0, 0, 0, 0, 0 },
/* U+4fe8 */ { 0, 0, 0, 0, 0 },
/* U+4fe9 */ { 0, 0, 0, 0, 0 },
/* U+4fea */ { 0, 0, 0, 0, 0 },
/* U+4feb */ { 0, 0, 0, 0, 0 },
/* U+4fec */ { 0, 0, 0, 0, 0 },
/* U+4fed */ { 0, 0, 0, 0, 0 },
/* U+4fee */ { 0, 0, 0, 0, 0 },
/* U+4fef */ { 0, 0, 0, 0, 0 },
/* U+4ff0 */ { 0, 0, 0, 0, 0 },
/* U+4ff1 */ { 0, 0, 0, 0, 0 },
/* U+4ff2 */ { 0, 0, 0, 0, 0 },
/* U+4ff3 */ { 0, 0, 0, 0, 0 },
/* U+4ff4 */ { 0, 0, 0, 0, 0 },
/* U+4ff5 */ { 0, 0, 0, 0, 0 },
/* U+4ff6 */ { 0, 0, 0, 0, 0 },
/* U+4ff7 */ { 0, 0, 0, 0, 0 },
/* U+4ff8 */ { 0, 0, 0, 0, 0 },
/* U+4ff9 */ { 0, 0, 0, 0, 0 },
/* U+4ffa */ { 0, 0, 0, 0, 0 },
/* U+4ffb */ { 0, 0, 0, 0, 0 },
/* U+4ffc */ { 0, 0, 0, 0, 0 },
/* U+4ffd */ { 0, 0, 0, 0, 0 },
/* U+4ffe */ { 0, 0, 0, 0, 0 },
/* U+4fff */ { 0, 0, 0, 0, 0 },

};

const _PyUnicode_DatabaseRecord _PyUnicode_Database_5[4096] = {
    
/* U+5000 */ { 0, 0, 0, 0, 0 },
/* U+5001 */ { 0, 0, 0, 0, 0 },
/* U+5002 */ { 0, 0, 0, 0, 0 },
/* U+5003 */ { 0, 0, 0, 0, 0 },
/* U+5004 */ { 0, 0, 0, 0, 0 },
/* U+5005 */ { 0, 0, 0, 0, 0 },
/* U+5006 */ { 0, 0, 0, 0, 0 },
/* U+5007 */ { 0, 0, 0, 0, 0 },
/* U+5008 */ { 0, 0, 0, 0, 0 },
/* U+5009 */ { 0, 0, 0, 0, 0 },
/* U+500a */ { 0, 0, 0, 0, 0 },
/* U+500b */ { 0, 0, 0, 0, 0 },
/* U+500c */ { 0, 0, 0, 0, 0 },
/* U+500d */ { 0, 0, 0, 0, 0 },
/* U+500e */ { 0, 0, 0, 0, 0 },
/* U+500f */ { 0, 0, 0, 0, 0 },
/* U+5010 */ { 0, 0, 0, 0, 0 },
/* U+5011 */ { 0, 0, 0, 0, 0 },
/* U+5012 */ { 0, 0, 0, 0, 0 },
/* U+5013 */ { 0, 0, 0, 0, 0 },
/* U+5014 */ { 0, 0, 0, 0, 0 },
/* U+5015 */ { 0, 0, 0, 0, 0 },
/* U+5016 */ { 0, 0, 0, 0, 0 },
/* U+5017 */ { 0, 0, 0, 0, 0 },
/* U+5018 */ { 0, 0, 0, 0, 0 },
/* U+5019 */ { 0, 0, 0, 0, 0 },
/* U+501a */ { 0, 0, 0, 0, 0 },
/* U+501b */ { 0, 0, 0, 0, 0 },
/* U+501c */ { 0, 0, 0, 0, 0 },
/* U+501d */ { 0, 0, 0, 0, 0 },
/* U+501e */ { 0, 0, 0, 0, 0 },
/* U+501f */ { 0, 0, 0, 0, 0 },
/* U+5020 */ { 0, 0, 0, 0, 0 },
/* U+5021 */ { 0, 0, 0, 0, 0 },
/* U+5022 */ { 0, 0, 0, 0, 0 },
/* U+5023 */ { 0, 0, 0, 0, 0 },
/* U+5024 */ { 0, 0, 0, 0, 0 },
/* U+5025 */ { 0, 0, 0, 0, 0 },
/* U+5026 */ { 0, 0, 0, 0, 0 },
/* U+5027 */ { 0, 0, 0, 0, 0 },
/* U+5028 */ { 0, 0, 0, 0, 0 },
/* U+5029 */ { 0, 0, 0, 0, 0 },
/* U+502a */ { 0, 0, 0, 0, 0 },
/* U+502b */ { 0, 0, 0, 0, 0 },
/* U+502c */ { 0, 0, 0, 0, 0 },
/* U+502d */ { 0, 0, 0, 0, 0 },
/* U+502e */ { 0, 0, 0, 0, 0 },
/* U+502f */ { 0, 0, 0, 0, 0 },
/* U+5030 */ { 0, 0, 0, 0, 0 },
/* U+5031 */ { 0, 0, 0, 0, 0 },
/* U+5032 */ { 0, 0, 0, 0, 0 },
/* U+5033 */ { 0, 0, 0, 0, 0 },
/* U+5034 */ { 0, 0, 0, 0, 0 },
/* U+5035 */ { 0, 0, 0, 0, 0 },
/* U+5036 */ { 0, 0, 0, 0, 0 },
/* U+5037 */ { 0, 0, 0, 0, 0 },
/* U+5038 */ { 0, 0, 0, 0, 0 },
/* U+5039 */ { 0, 0, 0, 0, 0 },
/* U+503a */ { 0, 0, 0, 0, 0 },
/* U+503b */ { 0, 0, 0, 0, 0 },
/* U+503c */ { 0, 0, 0, 0, 0 },
/* U+503d */ { 0, 0, 0, 0, 0 },
/* U+503e */ { 0, 0, 0, 0, 0 },
/* U+503f */ { 0, 0, 0, 0, 0 },
/* U+5040 */ { 0, 0, 0, 0, 0 },
/* U+5041 */ { 0, 0, 0, 0, 0 },
/* U+5042 */ { 0, 0, 0, 0, 0 },
/* U+5043 */ { 0, 0, 0, 0, 0 },
/* U+5044 */ { 0, 0, 0, 0, 0 },
/* U+5045 */ { 0, 0, 0, 0, 0 },
/* U+5046 */ { 0, 0, 0, 0, 0 },
/* U+5047 */ { 0, 0, 0, 0, 0 },
/* U+5048 */ { 0, 0, 0, 0, 0 },
/* U+5049 */ { 0, 0, 0, 0, 0 },
/* U+504a */ { 0, 0, 0, 0, 0 },
/* U+504b */ { 0, 0, 0, 0, 0 },
/* U+504c */ { 0, 0, 0, 0, 0 },
/* U+504d */ { 0, 0, 0, 0, 0 },
/* U+504e */ { 0, 0, 0, 0, 0 },
/* U+504f */ { 0, 0, 0, 0, 0 },
/* U+5050 */ { 0, 0, 0, 0, 0 },
/* U+5051 */ { 0, 0, 0, 0, 0 },
/* U+5052 */ { 0, 0, 0, 0, 0 },
/* U+5053 */ { 0, 0, 0, 0, 0 },
/* U+5054 */ { 0, 0, 0, 0, 0 },
/* U+5055 */ { 0, 0, 0, 0, 0 },
/* U+5056 */ { 0, 0, 0, 0, 0 },
/* U+5057 */ { 0, 0, 0, 0, 0 },
/* U+5058 */ { 0, 0, 0, 0, 0 },
/* U+5059 */ { 0, 0, 0, 0, 0 },
/* U+505a */ { 0, 0, 0, 0, 0 },
/* U+505b */ { 0, 0, 0, 0, 0 },
/* U+505c */ { 0, 0, 0, 0, 0 },
/* U+505d */ { 0, 0, 0, 0, 0 },
/* U+505e */ { 0, 0, 0, 0, 0 },
/* U+505f */ { 0, 0, 0, 0, 0 },
/* U+5060 */ { 0, 0, 0, 0, 0 },
/* U+5061 */ { 0, 0, 0, 0, 0 },
/* U+5062 */ { 0, 0, 0, 0, 0 },
/* U+5063 */ { 0, 0, 0, 0, 0 },
/* U+5064 */ { 0, 0, 0, 0, 0 },
/* U+5065 */ { 0, 0, 0, 0, 0 },
/* U+5066 */ { 0, 0, 0, 0, 0 },
/* U+5067 */ { 0, 0, 0, 0, 0 },
/* U+5068 */ { 0, 0, 0, 0, 0 },
/* U+5069 */ { 0, 0, 0, 0, 0 },
/* U+506a */ { 0, 0, 0, 0, 0 },
/* U+506b */ { 0, 0, 0, 0, 0 },
/* U+506c */ { 0, 0, 0, 0, 0 },
/* U+506d */ { 0, 0, 0, 0, 0 },
/* U+506e */ { 0, 0, 0, 0, 0 },
/* U+506f */ { 0, 0, 0, 0, 0 },
/* U+5070 */ { 0, 0, 0, 0, 0 },
/* U+5071 */ { 0, 0, 0, 0, 0 },
/* U+5072 */ { 0, 0, 0, 0, 0 },
/* U+5073 */ { 0, 0, 0, 0, 0 },
/* U+5074 */ { 0, 0, 0, 0, 0 },
/* U+5075 */ { 0, 0, 0, 0, 0 },
/* U+5076 */ { 0, 0, 0, 0, 0 },
/* U+5077 */ { 0, 0, 0, 0, 0 },
/* U+5078 */ { 0, 0, 0, 0, 0 },
/* U+5079 */ { 0, 0, 0, 0, 0 },
/* U+507a */ { 0, 0, 0, 0, 0 },
/* U+507b */ { 0, 0, 0, 0, 0 },
/* U+507c */ { 0, 0, 0, 0, 0 },
/* U+507d */ { 0, 0, 0, 0, 0 },
/* U+507e */ { 0, 0, 0, 0, 0 },
/* U+507f */ { 0, 0, 0, 0, 0 },
/* U+5080 */ { 0, 0, 0, 0, 0 },
/* U+5081 */ { 0, 0, 0, 0, 0 },
/* U+5082 */ { 0, 0, 0, 0, 0 },
/* U+5083 */ { 0, 0, 0, 0, 0 },
/* U+5084 */ { 0, 0, 0, 0, 0 },
/* U+5085 */ { 0, 0, 0, 0, 0 },
/* U+5086 */ { 0, 0, 0, 0, 0 },
/* U+5087 */ { 0, 0, 0, 0, 0 },
/* U+5088 */ { 0, 0, 0, 0, 0 },
/* U+5089 */ { 0, 0, 0, 0, 0 },
/* U+508a */ { 0, 0, 0, 0, 0 },
/* U+508b */ { 0, 0, 0, 0, 0 },
/* U+508c */ { 0, 0, 0, 0, 0 },
/* U+508d */ { 0, 0, 0, 0, 0 },
/* U+508e */ { 0, 0, 0, 0, 0 },
/* U+508f */ { 0, 0, 0, 0, 0 },
/* U+5090 */ { 0, 0, 0, 0, 0 },
/* U+5091 */ { 0, 0, 0, 0, 0 },
/* U+5092 */ { 0, 0, 0, 0, 0 },
/* U+5093 */ { 0, 0, 0, 0, 0 },
/* U+5094 */ { 0, 0, 0, 0, 0 },
/* U+5095 */ { 0, 0, 0, 0, 0 },
/* U+5096 */ { 0, 0, 0, 0, 0 },
/* U+5097 */ { 0, 0, 0, 0, 0 },
/* U+5098 */ { 0, 0, 0, 0, 0 },
/* U+5099 */ { 0, 0, 0, 0, 0 },
/* U+509a */ { 0, 0, 0, 0, 0 },
/* U+509b */ { 0, 0, 0, 0, 0 },
/* U+509c */ { 0, 0, 0, 0, 0 },
/* U+509d */ { 0, 0, 0, 0, 0 },
/* U+509e */ { 0, 0, 0, 0, 0 },
/* U+509f */ { 0, 0, 0, 0, 0 },
/* U+50a0 */ { 0, 0, 0, 0, 0 },
/* U+50a1 */ { 0, 0, 0, 0, 0 },
/* U+50a2 */ { 0, 0, 0, 0, 0 },
/* U+50a3 */ { 0, 0, 0, 0, 0 },
/* U+50a4 */ { 0, 0, 0, 0, 0 },
/* U+50a5 */ { 0, 0, 0, 0, 0 },
/* U+50a6 */ { 0, 0, 0, 0, 0 },
/* U+50a7 */ { 0, 0, 0, 0, 0 },
/* U+50a8 */ { 0, 0, 0, 0, 0 },
/* U+50a9 */ { 0, 0, 0, 0, 0 },
/* U+50aa */ { 0, 0, 0, 0, 0 },
/* U+50ab */ { 0, 0, 0, 0, 0 },
/* U+50ac */ { 0, 0, 0, 0, 0 },
/* U+50ad */ { 0, 0, 0, 0, 0 },
/* U+50ae */ { 0, 0, 0, 0, 0 },
/* U+50af */ { 0, 0, 0, 0, 0 },
/* U+50b0 */ { 0, 0, 0, 0, 0 },
/* U+50b1 */ { 0, 0, 0, 0, 0 },
/* U+50b2 */ { 0, 0, 0, 0, 0 },
/* U+50b3 */ { 0, 0, 0, 0, 0 },
/* U+50b4 */ { 0, 0, 0, 0, 0 },
/* U+50b5 */ { 0, 0, 0, 0, 0 },
/* U+50b6 */ { 0, 0, 0, 0, 0 },
/* U+50b7 */ { 0, 0, 0, 0, 0 },
/* U+50b8 */ { 0, 0, 0, 0, 0 },
/* U+50b9 */ { 0, 0, 0, 0, 0 },
/* U+50ba */ { 0, 0, 0, 0, 0 },
/* U+50bb */ { 0, 0, 0, 0, 0 },
/* U+50bc */ { 0, 0, 0, 0, 0 },
/* U+50bd */ { 0, 0, 0, 0, 0 },
/* U+50be */ { 0, 0, 0, 0, 0 },
/* U+50bf */ { 0, 0, 0, 0, 0 },
/* U+50c0 */ { 0, 0, 0, 0, 0 },
/* U+50c1 */ { 0, 0, 0, 0, 0 },
/* U+50c2 */ { 0, 0, 0, 0, 0 },
/* U+50c3 */ { 0, 0, 0, 0, 0 },
/* U+50c4 */ { 0, 0, 0, 0, 0 },
/* U+50c5 */ { 0, 0, 0, 0, 0 },
/* U+50c6 */ { 0, 0, 0, 0, 0 },
/* U+50c7 */ { 0, 0, 0, 0, 0 },
/* U+50c8 */ { 0, 0, 0, 0, 0 },
/* U+50c9 */ { 0, 0, 0, 0, 0 },
/* U+50ca */ { 0, 0, 0, 0, 0 },
/* U+50cb */ { 0, 0, 0, 0, 0 },
/* U+50cc */ { 0, 0, 0, 0, 0 },
/* U+50cd */ { 0, 0, 0, 0, 0 },
/* U+50ce */ { 0, 0, 0, 0, 0 },
/* U+50cf */ { 0, 0, 0, 0, 0 },
/* U+50d0 */ { 0, 0, 0, 0, 0 },
/* U+50d1 */ { 0, 0, 0, 0, 0 },
/* U+50d2 */ { 0, 0, 0, 0, 0 },
/* U+50d3 */ { 0, 0, 0, 0, 0 },
/* U+50d4 */ { 0, 0, 0, 0, 0 },
/* U+50d5 */ { 0, 0, 0, 0, 0 },
/* U+50d6 */ { 0, 0, 0, 0, 0 },
/* U+50d7 */ { 0, 0, 0, 0, 0 },
/* U+50d8 */ { 0, 0, 0, 0, 0 },
/* U+50d9 */ { 0, 0, 0, 0, 0 },
/* U+50da */ { 0, 0, 0, 0, 0 },
/* U+50db */ { 0, 0, 0, 0, 0 },
/* U+50dc */ { 0, 0, 0, 0, 0 },
/* U+50dd */ { 0, 0, 0, 0, 0 },
/* U+50de */ { 0, 0, 0, 0, 0 },
/* U+50df */ { 0, 0, 0, 0, 0 },
/* U+50e0 */ { 0, 0, 0, 0, 0 },
/* U+50e1 */ { 0, 0, 0, 0, 0 },
/* U+50e2 */ { 0, 0, 0, 0, 0 },
/* U+50e3 */ { 0, 0, 0, 0, 0 },
/* U+50e4 */ { 0, 0, 0, 0, 0 },
/* U+50e5 */ { 0, 0, 0, 0, 0 },
/* U+50e6 */ { 0, 0, 0, 0, 0 },
/* U+50e7 */ { 0, 0, 0, 0, 0 },
/* U+50e8 */ { 0, 0, 0, 0, 0 },
/* U+50e9 */ { 0, 0, 0, 0, 0 },
/* U+50ea */ { 0, 0, 0, 0, 0 },
/* U+50eb */ { 0, 0, 0, 0, 0 },
/* U+50ec */ { 0, 0, 0, 0, 0 },
/* U+50ed */ { 0, 0, 0, 0, 0 },
/* U+50ee */ { 0, 0, 0, 0, 0 },
/* U+50ef */ { 0, 0, 0, 0, 0 },
/* U+50f0 */ { 0, 0, 0, 0, 0 },
/* U+50f1 */ { 0, 0, 0, 0, 0 },
/* U+50f2 */ { 0, 0, 0, 0, 0 },
/* U+50f3 */ { 0, 0, 0, 0, 0 },
/* U+50f4 */ { 0, 0, 0, 0, 0 },
/* U+50f5 */ { 0, 0, 0, 0, 0 },
/* U+50f6 */ { 0, 0, 0, 0, 0 },
/* U+50f7 */ { 0, 0, 0, 0, 0 },
/* U+50f8 */ { 0, 0, 0, 0, 0 },
/* U+50f9 */ { 0, 0, 0, 0, 0 },
/* U+50fa */ { 0, 0, 0, 0, 0 },
/* U+50fb */ { 0, 0, 0, 0, 0 },
/* U+50fc */ { 0, 0, 0, 0, 0 },
/* U+50fd */ { 0, 0, 0, 0, 0 },
/* U+50fe */ { 0, 0, 0, 0, 0 },
/* U+50ff */ { 0, 0, 0, 0, 0 },
/* U+5100 */ { 0, 0, 0, 0, 0 },
/* U+5101 */ { 0, 0, 0, 0, 0 },
/* U+5102 */ { 0, 0, 0, 0, 0 },
/* U+5103 */ { 0, 0, 0, 0, 0 },
/* U+5104 */ { 0, 0, 0, 0, 0 },
/* U+5105 */ { 0, 0, 0, 0, 0 },
/* U+5106 */ { 0, 0, 0, 0, 0 },
/* U+5107 */ { 0, 0, 0, 0, 0 },
/* U+5108 */ { 0, 0, 0, 0, 0 },
/* U+5109 */ { 0, 0, 0, 0, 0 },
/* U+510a */ { 0, 0, 0, 0, 0 },
/* U+510b */ { 0, 0, 0, 0, 0 },
/* U+510c */ { 0, 0, 0, 0, 0 },
/* U+510d */ { 0, 0, 0, 0, 0 },
/* U+510e */ { 0, 0, 0, 0, 0 },
/* U+510f */ { 0, 0, 0, 0, 0 },
/* U+5110 */ { 0, 0, 0, 0, 0 },
/* U+5111 */ { 0, 0, 0, 0, 0 },
/* U+5112 */ { 0, 0, 0, 0, 0 },
/* U+5113 */ { 0, 0, 0, 0, 0 },
/* U+5114 */ { 0, 0, 0, 0, 0 },
/* U+5115 */ { 0, 0, 0, 0, 0 },
/* U+5116 */ { 0, 0, 0, 0, 0 },
/* U+5117 */ { 0, 0, 0, 0, 0 },
/* U+5118 */ { 0, 0, 0, 0, 0 },
/* U+5119 */ { 0, 0, 0, 0, 0 },
/* U+511a */ { 0, 0, 0, 0, 0 },
/* U+511b */ { 0, 0, 0, 0, 0 },
/* U+511c */ { 0, 0, 0, 0, 0 },
/* U+511d */ { 0, 0, 0, 0, 0 },
/* U+511e */ { 0, 0, 0, 0, 0 },
/* U+511f */ { 0, 0, 0, 0, 0 },
/* U+5120 */ { 0, 0, 0, 0, 0 },
/* U+5121 */ { 0, 0, 0, 0, 0 },
/* U+5122 */ { 0, 0, 0, 0, 0 },
/* U+5123 */ { 0, 0, 0, 0, 0 },
/* U+5124 */ { 0, 0, 0, 0, 0 },
/* U+5125 */ { 0, 0, 0, 0, 0 },
/* U+5126 */ { 0, 0, 0, 0, 0 },
/* U+5127 */ { 0, 0, 0, 0, 0 },
/* U+5128 */ { 0, 0, 0, 0, 0 },
/* U+5129 */ { 0, 0, 0, 0, 0 },
/* U+512a */ { 0, 0, 0, 0, 0 },
/* U+512b */ { 0, 0, 0, 0, 0 },
/* U+512c */ { 0, 0, 0, 0, 0 },
/* U+512d */ { 0, 0, 0, 0, 0 },
/* U+512e */ { 0, 0, 0, 0, 0 },
/* U+512f */ { 0, 0, 0, 0, 0 },
/* U+5130 */ { 0, 0, 0, 0, 0 },
/* U+5131 */ { 0, 0, 0, 0, 0 },
/* U+5132 */ { 0, 0, 0, 0, 0 },
/* U+5133 */ { 0, 0, 0, 0, 0 },
/* U+5134 */ { 0, 0, 0, 0, 0 },
/* U+5135 */ { 0, 0, 0, 0, 0 },
/* U+5136 */ { 0, 0, 0, 0, 0 },
/* U+5137 */ { 0, 0, 0, 0, 0 },
/* U+5138 */ { 0, 0, 0, 0, 0 },
/* U+5139 */ { 0, 0, 0, 0, 0 },
/* U+513a */ { 0, 0, 0, 0, 0 },
/* U+513b */ { 0, 0, 0, 0, 0 },
/* U+513c */ { 0, 0, 0, 0, 0 },
/* U+513d */ { 0, 0, 0, 0, 0 },
/* U+513e */ { 0, 0, 0, 0, 0 },
/* U+513f */ { 0, 0, 0, 0, 0 },
/* U+5140 */ { 0, 0, 0, 0, 0 },
/* U+5141 */ { 0, 0, 0, 0, 0 },
/* U+5142 */ { 0, 0, 0, 0, 0 },
/* U+5143 */ { 0, 0, 0, 0, 0 },
/* U+5144 */ { 0, 0, 0, 0, 0 },
/* U+5145 */ { 0, 0, 0, 0, 0 },
/* U+5146 */ { 0, 0, 0, 0, 0 },
/* U+5147 */ { 0, 0, 0, 0, 0 },
/* U+5148 */ { 0, 0, 0, 0, 0 },
/* U+5149 */ { 0, 0, 0, 0, 0 },
/* U+514a */ { 0, 0, 0, 0, 0 },
/* U+514b */ { 0, 0, 0, 0, 0 },
/* U+514c */ { 0, 0, 0, 0, 0 },
/* U+514d */ { 0, 0, 0, 0, 0 },
/* U+514e */ { 0, 0, 0, 0, 0 },
/* U+514f */ { 0, 0, 0, 0, 0 },
/* U+5150 */ { 0, 0, 0, 0, 0 },
/* U+5151 */ { 0, 0, 0, 0, 0 },
/* U+5152 */ { 0, 0, 0, 0, 0 },
/* U+5153 */ { 0, 0, 0, 0, 0 },
/* U+5154 */ { 0, 0, 0, 0, 0 },
/* U+5155 */ { 0, 0, 0, 0, 0 },
/* U+5156 */ { 0, 0, 0, 0, 0 },
/* U+5157 */ { 0, 0, 0, 0, 0 },
/* U+5158 */ { 0, 0, 0, 0, 0 },
/* U+5159 */ { 0, 0, 0, 0, 0 },
/* U+515a */ { 0, 0, 0, 0, 0 },
/* U+515b */ { 0, 0, 0, 0, 0 },
/* U+515c */ { 0, 0, 0, 0, 0 },
/* U+515d */ { 0, 0, 0, 0, 0 },
/* U+515e */ { 0, 0, 0, 0, 0 },
/* U+515f */ { 0, 0, 0, 0, 0 },
/* U+5160 */ { 0, 0, 0, 0, 0 },
/* U+5161 */ { 0, 0, 0, 0, 0 },
/* U+5162 */ { 0, 0, 0, 0, 0 },
/* U+5163 */ { 0, 0, 0, 0, 0 },
/* U+5164 */ { 0, 0, 0, 0, 0 },
/* U+5165 */ { 0, 0, 0, 0, 0 },
/* U+5166 */ { 0, 0, 0, 0, 0 },
/* U+5167 */ { 0, 0, 0, 0, 0 },
/* U+5168 */ { 0, 0, 0, 0, 0 },
/* U+5169 */ { 0, 0, 0, 0, 0 },
/* U+516a */ { 0, 0, 0, 0, 0 },
/* U+516b */ { 0, 0, 0, 0, 0 },
/* U+516c */ { 0, 0, 0, 0, 0 },
/* U+516d */ { 0, 0, 0, 0, 0 },
/* U+516e */ { 0, 0, 0, 0, 0 },
/* U+516f */ { 0, 0, 0, 0, 0 },
/* U+5170 */ { 0, 0, 0, 0, 0 },
/* U+5171 */ { 0, 0, 0, 0, 0 },
/* U+5172 */ { 0, 0, 0, 0, 0 },
/* U+5173 */ { 0, 0, 0, 0, 0 },
/* U+5174 */ { 0, 0, 0, 0, 0 },
/* U+5175 */ { 0, 0, 0, 0, 0 },
/* U+5176 */ { 0, 0, 0, 0, 0 },
/* U+5177 */ { 0, 0, 0, 0, 0 },
/* U+5178 */ { 0, 0, 0, 0, 0 },
/* U+5179 */ { 0, 0, 0, 0, 0 },
/* U+517a */ { 0, 0, 0, 0, 0 },
/* U+517b */ { 0, 0, 0, 0, 0 },
/* U+517c */ { 0, 0, 0, 0, 0 },
/* U+517d */ { 0, 0, 0, 0, 0 },
/* U+517e */ { 0, 0, 0, 0, 0 },
/* U+517f */ { 0, 0, 0, 0, 0 },
/* U+5180 */ { 0, 0, 0, 0, 0 },
/* U+5181 */ { 0, 0, 0, 0, 0 },
/* U+5182 */ { 0, 0, 0, 0, 0 },
/* U+5183 */ { 0, 0, 0, 0, 0 },
/* U+5184 */ { 0, 0, 0, 0, 0 },
/* U+5185 */ { 0, 0, 0, 0, 0 },
/* U+5186 */ { 0, 0, 0, 0, 0 },
/* U+5187 */ { 0, 0, 0, 0, 0 },
/* U+5188 */ { 0, 0, 0, 0, 0 },
/* U+5189 */ { 0, 0, 0, 0, 0 },
/* U+518a */ { 0, 0, 0, 0, 0 },
/* U+518b */ { 0, 0, 0, 0, 0 },
/* U+518c */ { 0, 0, 0, 0, 0 },
/* U+518d */ { 0, 0, 0, 0, 0 },
/* U+518e */ { 0, 0, 0, 0, 0 },
/* U+518f */ { 0, 0, 0, 0, 0 },
/* U+5190 */ { 0, 0, 0, 0, 0 },
/* U+5191 */ { 0, 0, 0, 0, 0 },
/* U+5192 */ { 0, 0, 0, 0, 0 },
/* U+5193 */ { 0, 0, 0, 0, 0 },
/* U+5194 */ { 0, 0, 0, 0, 0 },
/* U+5195 */ { 0, 0, 0, 0, 0 },
/* U+5196 */ { 0, 0, 0, 0, 0 },
/* U+5197 */ { 0, 0, 0, 0, 0 },
/* U+5198 */ { 0, 0, 0, 0, 0 },
/* U+5199 */ { 0, 0, 0, 0, 0 },
/* U+519a */ { 0, 0, 0, 0, 0 },
/* U+519b */ { 0, 0, 0, 0, 0 },
/* U+519c */ { 0, 0, 0, 0, 0 },
/* U+519d */ { 0, 0, 0, 0, 0 },
/* U+519e */ { 0, 0, 0, 0, 0 },
/* U+519f */ { 0, 0, 0, 0, 0 },
/* U+51a0 */ { 0, 0, 0, 0, 0 },
/* U+51a1 */ { 0, 0, 0, 0, 0 },
/* U+51a2 */ { 0, 0, 0, 0, 0 },
/* U+51a3 */ { 0, 0, 0, 0, 0 },
/* U+51a4 */ { 0, 0, 0, 0, 0 },
/* U+51a5 */ { 0, 0, 0, 0, 0 },
/* U+51a6 */ { 0, 0, 0, 0, 0 },
/* U+51a7 */ { 0, 0, 0, 0, 0 },
/* U+51a8 */ { 0, 0, 0, 0, 0 },
/* U+51a9 */ { 0, 0, 0, 0, 0 },
/* U+51aa */ { 0, 0, 0, 0, 0 },
/* U+51ab */ { 0, 0, 0, 0, 0 },
/* U+51ac */ { 0, 0, 0, 0, 0 },
/* U+51ad */ { 0, 0, 0, 0, 0 },
/* U+51ae */ { 0, 0, 0, 0, 0 },
/* U+51af */ { 0, 0, 0, 0, 0 },
/* U+51b0 */ { 0, 0, 0, 0, 0 },
/* U+51b1 */ { 0, 0, 0, 0, 0 },
/* U+51b2 */ { 0, 0, 0, 0, 0 },
/* U+51b3 */ { 0, 0, 0, 0, 0 },
/* U+51b4 */ { 0, 0, 0, 0, 0 },
/* U+51b5 */ { 0, 0, 0, 0, 0 },
/* U+51b6 */ { 0, 0, 0, 0, 0 },
/* U+51b7 */ { 0, 0, 0, 0, 0 },
/* U+51b8 */ { 0, 0, 0, 0, 0 },
/* U+51b9 */ { 0, 0, 0, 0, 0 },
/* U+51ba */ { 0, 0, 0, 0, 0 },
/* U+51bb */ { 0, 0, 0, 0, 0 },
/* U+51bc */ { 0, 0, 0, 0, 0 },
/* U+51bd */ { 0, 0, 0, 0, 0 },
/* U+51be */ { 0, 0, 0, 0, 0 },
/* U+51bf */ { 0, 0, 0, 0, 0 },
/* U+51c0 */ { 0, 0, 0, 0, 0 },
/* U+51c1 */ { 0, 0, 0, 0, 0 },
/* U+51c2 */ { 0, 0, 0, 0, 0 },
/* U+51c3 */ { 0, 0, 0, 0, 0 },
/* U+51c4 */ { 0, 0, 0, 0, 0 },
/* U+51c5 */ { 0, 0, 0, 0, 0 },
/* U+51c6 */ { 0, 0, 0, 0, 0 },
/* U+51c7 */ { 0, 0, 0, 0, 0 },
/* U+51c8 */ { 0, 0, 0, 0, 0 },
/* U+51c9 */ { 0, 0, 0, 0, 0 },
/* U+51ca */ { 0, 0, 0, 0, 0 },
/* U+51cb */ { 0, 0, 0, 0, 0 },
/* U+51cc */ { 0, 0, 0, 0, 0 },
/* U+51cd */ { 0, 0, 0, 0, 0 },
/* U+51ce */ { 0, 0, 0, 0, 0 },
/* U+51cf */ { 0, 0, 0, 0, 0 },
/* U+51d0 */ { 0, 0, 0, 0, 0 },
/* U+51d1 */ { 0, 0, 0, 0, 0 },
/* U+51d2 */ { 0, 0, 0, 0, 0 },
/* U+51d3 */ { 0, 0, 0, 0, 0 },
/* U+51d4 */ { 0, 0, 0, 0, 0 },
/* U+51d5 */ { 0, 0, 0, 0, 0 },
/* U+51d6 */ { 0, 0, 0, 0, 0 },
/* U+51d7 */ { 0, 0, 0, 0, 0 },
/* U+51d8 */ { 0, 0, 0, 0, 0 },
/* U+51d9 */ { 0, 0, 0, 0, 0 },
/* U+51da */ { 0, 0, 0, 0, 0 },
/* U+51db */ { 0, 0, 0, 0, 0 },
/* U+51dc */ { 0, 0, 0, 0, 0 },
/* U+51dd */ { 0, 0, 0, 0, 0 },
/* U+51de */ { 0, 0, 0, 0, 0 },
/* U+51df */ { 0, 0, 0, 0, 0 },
/* U+51e0 */ { 0, 0, 0, 0, 0 },
/* U+51e1 */ { 0, 0, 0, 0, 0 },
/* U+51e2 */ { 0, 0, 0, 0, 0 },
/* U+51e3 */ { 0, 0, 0, 0, 0 },
/* U+51e4 */ { 0, 0, 0, 0, 0 },
/* U+51e5 */ { 0, 0, 0, 0, 0 },
/* U+51e6 */ { 0, 0, 0, 0, 0 },
/* U+51e7 */ { 0, 0, 0, 0, 0 },
/* U+51e8 */ { 0, 0, 0, 0, 0 },
/* U+51e9 */ { 0, 0, 0, 0, 0 },
/* U+51ea */ { 0, 0, 0, 0, 0 },
/* U+51eb */ { 0, 0, 0, 0, 0 },
/* U+51ec */ { 0, 0, 0, 0, 0 },
/* U+51ed */ { 0, 0, 0, 0, 0 },
/* U+51ee */ { 0, 0, 0, 0, 0 },
/* U+51ef */ { 0, 0, 0, 0, 0 },
/* U+51f0 */ { 0, 0, 0, 0, 0 },
/* U+51f1 */ { 0, 0, 0, 0, 0 },
/* U+51f2 */ { 0, 0, 0, 0, 0 },
/* U+51f3 */ { 0, 0, 0, 0, 0 },
/* U+51f4 */ { 0, 0, 0, 0, 0 },
/* U+51f5 */ { 0, 0, 0, 0, 0 },
/* U+51f6 */ { 0, 0, 0, 0, 0 },
/* U+51f7 */ { 0, 0, 0, 0, 0 },
/* U+51f8 */ { 0, 0, 0, 0, 0 },
/* U+51f9 */ { 0, 0, 0, 0, 0 },
/* U+51fa */ { 0, 0, 0, 0, 0 },
/* U+51fb */ { 0, 0, 0, 0, 0 },
/* U+51fc */ { 0, 0, 0, 0, 0 },
/* U+51fd */ { 0, 0, 0, 0, 0 },
/* U+51fe */ { 0, 0, 0, 0, 0 },
/* U+51ff */ { 0, 0, 0, 0, 0 },
/* U+5200 */ { 0, 0, 0, 0, 0 },
/* U+5201 */ { 0, 0, 0, 0, 0 },
/* U+5202 */ { 0, 0, 0, 0, 0 },
/* U+5203 */ { 0, 0, 0, 0, 0 },
/* U+5204 */ { 0, 0, 0, 0, 0 },
/* U+5205 */ { 0, 0, 0, 0, 0 },
/* U+5206 */ { 0, 0, 0, 0, 0 },
/* U+5207 */ { 0, 0, 0, 0, 0 },
/* U+5208 */ { 0, 0, 0, 0, 0 },
/* U+5209 */ { 0, 0, 0, 0, 0 },
/* U+520a */ { 0, 0, 0, 0, 0 },
/* U+520b */ { 0, 0, 0, 0, 0 },
/* U+520c */ { 0, 0, 0, 0, 0 },
/* U+520d */ { 0, 0, 0, 0, 0 },
/* U+520e */ { 0, 0, 0, 0, 0 },
/* U+520f */ { 0, 0, 0, 0, 0 },
/* U+5210 */ { 0, 0, 0, 0, 0 },
/* U+5211 */ { 0, 0, 0, 0, 0 },
/* U+5212 */ { 0, 0, 0, 0, 0 },
/* U+5213 */ { 0, 0, 0, 0, 0 },
/* U+5214 */ { 0, 0, 0, 0, 0 },
/* U+5215 */ { 0, 0, 0, 0, 0 },
/* U+5216 */ { 0, 0, 0, 0, 0 },
/* U+5217 */ { 0, 0, 0, 0, 0 },
/* U+5218 */ { 0, 0, 0, 0, 0 },
/* U+5219 */ { 0, 0, 0, 0, 0 },
/* U+521a */ { 0, 0, 0, 0, 0 },
/* U+521b */ { 0, 0, 0, 0, 0 },
/* U+521c */ { 0, 0, 0, 0, 0 },
/* U+521d */ { 0, 0, 0, 0, 0 },
/* U+521e */ { 0, 0, 0, 0, 0 },
/* U+521f */ { 0, 0, 0, 0, 0 },
/* U+5220 */ { 0, 0, 0, 0, 0 },
/* U+5221 */ { 0, 0, 0, 0, 0 },
/* U+5222 */ { 0, 0, 0, 0, 0 },
/* U+5223 */ { 0, 0, 0, 0, 0 },
/* U+5224 */ { 0, 0, 0, 0, 0 },
/* U+5225 */ { 0, 0, 0, 0, 0 },
/* U+5226 */ { 0, 0, 0, 0, 0 },
/* U+5227 */ { 0, 0, 0, 0, 0 },
/* U+5228 */ { 0, 0, 0, 0, 0 },
/* U+5229 */ { 0, 0, 0, 0, 0 },
/* U+522a */ { 0, 0, 0, 0, 0 },
/* U+522b */ { 0, 0, 0, 0, 0 },
/* U+522c */ { 0, 0, 0, 0, 0 },
/* U+522d */ { 0, 0, 0, 0, 0 },
/* U+522e */ { 0, 0, 0, 0, 0 },
/* U+522f */ { 0, 0, 0, 0, 0 },
/* U+5230 */ { 0, 0, 0, 0, 0 },
/* U+5231 */ { 0, 0, 0, 0, 0 },
/* U+5232 */ { 0, 0, 0, 0, 0 },
/* U+5233 */ { 0, 0, 0, 0, 0 },
/* U+5234 */ { 0, 0, 0, 0, 0 },
/* U+5235 */ { 0, 0, 0, 0, 0 },
/* U+5236 */ { 0, 0, 0, 0, 0 },
/* U+5237 */ { 0, 0, 0, 0, 0 },
/* U+5238 */ { 0, 0, 0, 0, 0 },
/* U+5239 */ { 0, 0, 0, 0, 0 },
/* U+523a */ { 0, 0, 0, 0, 0 },
/* U+523b */ { 0, 0, 0, 0, 0 },
/* U+523c */ { 0, 0, 0, 0, 0 },
/* U+523d */ { 0, 0, 0, 0, 0 },
/* U+523e */ { 0, 0, 0, 0, 0 },
/* U+523f */ { 0, 0, 0, 0, 0 },
/* U+5240 */ { 0, 0, 0, 0, 0 },
/* U+5241 */ { 0, 0, 0, 0, 0 },
/* U+5242 */ { 0, 0, 0, 0, 0 },
/* U+5243 */ { 0, 0, 0, 0, 0 },
/* U+5244 */ { 0, 0, 0, 0, 0 },
/* U+5245 */ { 0, 0, 0, 0, 0 },
/* U+5246 */ { 0, 0, 0, 0, 0 },
/* U+5247 */ { 0, 0, 0, 0, 0 },
/* U+5248 */ { 0, 0, 0, 0, 0 },
/* U+5249 */ { 0, 0, 0, 0, 0 },
/* U+524a */ { 0, 0, 0, 0, 0 },
/* U+524b */ { 0, 0, 0, 0, 0 },
/* U+524c */ { 0, 0, 0, 0, 0 },
/* U+524d */ { 0, 0, 0, 0, 0 },
/* U+524e */ { 0, 0, 0, 0, 0 },
/* U+524f */ { 0, 0, 0, 0, 0 },
/* U+5250 */ { 0, 0, 0, 0, 0 },
/* U+5251 */ { 0, 0, 0, 0, 0 },
/* U+5252 */ { 0, 0, 0, 0, 0 },
/* U+5253 */ { 0, 0, 0, 0, 0 },
/* U+5254 */ { 0, 0, 0, 0, 0 },
/* U+5255 */ { 0, 0, 0, 0, 0 },
/* U+5256 */ { 0, 0, 0, 0, 0 },
/* U+5257 */ { 0, 0, 0, 0, 0 },
/* U+5258 */ { 0, 0, 0, 0, 0 },
/* U+5259 */ { 0, 0, 0, 0, 0 },
/* U+525a */ { 0, 0, 0, 0, 0 },
/* U+525b */ { 0, 0, 0, 0, 0 },
/* U+525c */ { 0, 0, 0, 0, 0 },
/* U+525d */ { 0, 0, 0, 0, 0 },
/* U+525e */ { 0, 0, 0, 0, 0 },
/* U+525f */ { 0, 0, 0, 0, 0 },
/* U+5260 */ { 0, 0, 0, 0, 0 },
/* U+5261 */ { 0, 0, 0, 0, 0 },
/* U+5262 */ { 0, 0, 0, 0, 0 },
/* U+5263 */ { 0, 0, 0, 0, 0 },
/* U+5264 */ { 0, 0, 0, 0, 0 },
/* U+5265 */ { 0, 0, 0, 0, 0 },
/* U+5266 */ { 0, 0, 0, 0, 0 },
/* U+5267 */ { 0, 0, 0, 0, 0 },
/* U+5268 */ { 0, 0, 0, 0, 0 },
/* U+5269 */ { 0, 0, 0, 0, 0 },
/* U+526a */ { 0, 0, 0, 0, 0 },
/* U+526b */ { 0, 0, 0, 0, 0 },
/* U+526c */ { 0, 0, 0, 0, 0 },
/* U+526d */ { 0, 0, 0, 0, 0 },
/* U+526e */ { 0, 0, 0, 0, 0 },
/* U+526f */ { 0, 0, 0, 0, 0 },
/* U+5270 */ { 0, 0, 0, 0, 0 },
/* U+5271 */ { 0, 0, 0, 0, 0 },
/* U+5272 */ { 0, 0, 0, 0, 0 },
/* U+5273 */ { 0, 0, 0, 0, 0 },
/* U+5274 */ { 0, 0, 0, 0, 0 },
/* U+5275 */ { 0, 0, 0, 0, 0 },
/* U+5276 */ { 0, 0, 0, 0, 0 },
/* U+5277 */ { 0, 0, 0, 0, 0 },
/* U+5278 */ { 0, 0, 0, 0, 0 },
/* U+5279 */ { 0, 0, 0, 0, 0 },
/* U+527a */ { 0, 0, 0, 0, 0 },
/* U+527b */ { 0, 0, 0, 0, 0 },
/* U+527c */ { 0, 0, 0, 0, 0 },
/* U+527d */ { 0, 0, 0, 0, 0 },
/* U+527e */ { 0, 0, 0, 0, 0 },
/* U+527f */ { 0, 0, 0, 0, 0 },
/* U+5280 */ { 0, 0, 0, 0, 0 },
/* U+5281 */ { 0, 0, 0, 0, 0 },
/* U+5282 */ { 0, 0, 0, 0, 0 },
/* U+5283 */ { 0, 0, 0, 0, 0 },
/* U+5284 */ { 0, 0, 0, 0, 0 },
/* U+5285 */ { 0, 0, 0, 0, 0 },
/* U+5286 */ { 0, 0, 0, 0, 0 },
/* U+5287 */ { 0, 0, 0, 0, 0 },
/* U+5288 */ { 0, 0, 0, 0, 0 },
/* U+5289 */ { 0, 0, 0, 0, 0 },
/* U+528a */ { 0, 0, 0, 0, 0 },
/* U+528b */ { 0, 0, 0, 0, 0 },
/* U+528c */ { 0, 0, 0, 0, 0 },
/* U+528d */ { 0, 0, 0, 0, 0 },
/* U+528e */ { 0, 0, 0, 0, 0 },
/* U+528f */ { 0, 0, 0, 0, 0 },
/* U+5290 */ { 0, 0, 0, 0, 0 },
/* U+5291 */ { 0, 0, 0, 0, 0 },
/* U+5292 */ { 0, 0, 0, 0, 0 },
/* U+5293 */ { 0, 0, 0, 0, 0 },
/* U+5294 */ { 0, 0, 0, 0, 0 },
/* U+5295 */ { 0, 0, 0, 0, 0 },
/* U+5296 */ { 0, 0, 0, 0, 0 },
/* U+5297 */ { 0, 0, 0, 0, 0 },
/* U+5298 */ { 0, 0, 0, 0, 0 },
/* U+5299 */ { 0, 0, 0, 0, 0 },
/* U+529a */ { 0, 0, 0, 0, 0 },
/* U+529b */ { 0, 0, 0, 0, 0 },
/* U+529c */ { 0, 0, 0, 0, 0 },
/* U+529d */ { 0, 0, 0, 0, 0 },
/* U+529e */ { 0, 0, 0, 0, 0 },
/* U+529f */ { 0, 0, 0, 0, 0 },
/* U+52a0 */ { 0, 0, 0, 0, 0 },
/* U+52a1 */ { 0, 0, 0, 0, 0 },
/* U+52a2 */ { 0, 0, 0, 0, 0 },
/* U+52a3 */ { 0, 0, 0, 0, 0 },
/* U+52a4 */ { 0, 0, 0, 0, 0 },
/* U+52a5 */ { 0, 0, 0, 0, 0 },
/* U+52a6 */ { 0, 0, 0, 0, 0 },
/* U+52a7 */ { 0, 0, 0, 0, 0 },
/* U+52a8 */ { 0, 0, 0, 0, 0 },
/* U+52a9 */ { 0, 0, 0, 0, 0 },
/* U+52aa */ { 0, 0, 0, 0, 0 },
/* U+52ab */ { 0, 0, 0, 0, 0 },
/* U+52ac */ { 0, 0, 0, 0, 0 },
/* U+52ad */ { 0, 0, 0, 0, 0 },
/* U+52ae */ { 0, 0, 0, 0, 0 },
/* U+52af */ { 0, 0, 0, 0, 0 },
/* U+52b0 */ { 0, 0, 0, 0, 0 },
/* U+52b1 */ { 0, 0, 0, 0, 0 },
/* U+52b2 */ { 0, 0, 0, 0, 0 },
/* U+52b3 */ { 0, 0, 0, 0, 0 },
/* U+52b4 */ { 0, 0, 0, 0, 0 },
/* U+52b5 */ { 0, 0, 0, 0, 0 },
/* U+52b6 */ { 0, 0, 0, 0, 0 },
/* U+52b7 */ { 0, 0, 0, 0, 0 },
/* U+52b8 */ { 0, 0, 0, 0, 0 },
/* U+52b9 */ { 0, 0, 0, 0, 0 },
/* U+52ba */ { 0, 0, 0, 0, 0 },
/* U+52bb */ { 0, 0, 0, 0, 0 },
/* U+52bc */ { 0, 0, 0, 0, 0 },
/* U+52bd */ { 0, 0, 0, 0, 0 },
/* U+52be */ { 0, 0, 0, 0, 0 },
/* U+52bf */ { 0, 0, 0, 0, 0 },
/* U+52c0 */ { 0, 0, 0, 0, 0 },
/* U+52c1 */ { 0, 0, 0, 0, 0 },
/* U+52c2 */ { 0, 0, 0, 0, 0 },
/* U+52c3 */ { 0, 0, 0, 0, 0 },
/* U+52c4 */ { 0, 0, 0, 0, 0 },
/* U+52c5 */ { 0, 0, 0, 0, 0 },
/* U+52c6 */ { 0, 0, 0, 0, 0 },
/* U+52c7 */ { 0, 0, 0, 0, 0 },
/* U+52c8 */ { 0, 0, 0, 0, 0 },
/* U+52c9 */ { 0, 0, 0, 0, 0 },
/* U+52ca */ { 0, 0, 0, 0, 0 },
/* U+52cb */ { 0, 0, 0, 0, 0 },
/* U+52cc */ { 0, 0, 0, 0, 0 },
/* U+52cd */ { 0, 0, 0, 0, 0 },
/* U+52ce */ { 0, 0, 0, 0, 0 },
/* U+52cf */ { 0, 0, 0, 0, 0 },
/* U+52d0 */ { 0, 0, 0, 0, 0 },
/* U+52d1 */ { 0, 0, 0, 0, 0 },
/* U+52d2 */ { 0, 0, 0, 0, 0 },
/* U+52d3 */ { 0, 0, 0, 0, 0 },
/* U+52d4 */ { 0, 0, 0, 0, 0 },
/* U+52d5 */ { 0, 0, 0, 0, 0 },
/* U+52d6 */ { 0, 0, 0, 0, 0 },
/* U+52d7 */ { 0, 0, 0, 0, 0 },
/* U+52d8 */ { 0, 0, 0, 0, 0 },
/* U+52d9 */ { 0, 0, 0, 0, 0 },
/* U+52da */ { 0, 0, 0, 0, 0 },
/* U+52db */ { 0, 0, 0, 0, 0 },
/* U+52dc */ { 0, 0, 0, 0, 0 },
/* U+52dd */ { 0, 0, 0, 0, 0 },
/* U+52de */ { 0, 0, 0, 0, 0 },
/* U+52df */ { 0, 0, 0, 0, 0 },
/* U+52e0 */ { 0, 0, 0, 0, 0 },
/* U+52e1 */ { 0, 0, 0, 0, 0 },
/* U+52e2 */ { 0, 0, 0, 0, 0 },
/* U+52e3 */ { 0, 0, 0, 0, 0 },
/* U+52e4 */ { 0, 0, 0, 0, 0 },
/* U+52e5 */ { 0, 0, 0, 0, 0 },
/* U+52e6 */ { 0, 0, 0, 0, 0 },
/* U+52e7 */ { 0, 0, 0, 0, 0 },
/* U+52e8 */ { 0, 0, 0, 0, 0 },
/* U+52e9 */ { 0, 0, 0, 0, 0 },
/* U+52ea */ { 0, 0, 0, 0, 0 },
/* U+52eb */ { 0, 0, 0, 0, 0 },
/* U+52ec */ { 0, 0, 0, 0, 0 },
/* U+52ed */ { 0, 0, 0, 0, 0 },
/* U+52ee */ { 0, 0, 0, 0, 0 },
/* U+52ef */ { 0, 0, 0, 0, 0 },
/* U+52f0 */ { 0, 0, 0, 0, 0 },
/* U+52f1 */ { 0, 0, 0, 0, 0 },
/* U+52f2 */ { 0, 0, 0, 0, 0 },
/* U+52f3 */ { 0, 0, 0, 0, 0 },
/* U+52f4 */ { 0, 0, 0, 0, 0 },
/* U+52f5 */ { 0, 0, 0, 0, 0 },
/* U+52f6 */ { 0, 0, 0, 0, 0 },
/* U+52f7 */ { 0, 0, 0, 0, 0 },
/* U+52f8 */ { 0, 0, 0, 0, 0 },
/* U+52f9 */ { 0, 0, 0, 0, 0 },
/* U+52fa */ { 0, 0, 0, 0, 0 },
/* U+52fb */ { 0, 0, 0, 0, 0 },
/* U+52fc */ { 0, 0, 0, 0, 0 },
/* U+52fd */ { 0, 0, 0, 0, 0 },
/* U+52fe */ { 0, 0, 0, 0, 0 },
/* U+52ff */ { 0, 0, 0, 0, 0 },
/* U+5300 */ { 0, 0, 0, 0, 0 },
/* U+5301 */ { 0, 0, 0, 0, 0 },
/* U+5302 */ { 0, 0, 0, 0, 0 },
/* U+5303 */ { 0, 0, 0, 0, 0 },
/* U+5304 */ { 0, 0, 0, 0, 0 },
/* U+5305 */ { 0, 0, 0, 0, 0 },
/* U+5306 */ { 0, 0, 0, 0, 0 },
/* U+5307 */ { 0, 0, 0, 0, 0 },
/* U+5308 */ { 0, 0, 0, 0, 0 },
/* U+5309 */ { 0, 0, 0, 0, 0 },
/* U+530a */ { 0, 0, 0, 0, 0 },
/* U+530b */ { 0, 0, 0, 0, 0 },
/* U+530c */ { 0, 0, 0, 0, 0 },
/* U+530d */ { 0, 0, 0, 0, 0 },
/* U+530e */ { 0, 0, 0, 0, 0 },
/* U+530f */ { 0, 0, 0, 0, 0 },
/* U+5310 */ { 0, 0, 0, 0, 0 },
/* U+5311 */ { 0, 0, 0, 0, 0 },
/* U+5312 */ { 0, 0, 0, 0, 0 },
/* U+5313 */ { 0, 0, 0, 0, 0 },
/* U+5314 */ { 0, 0, 0, 0, 0 },
/* U+5315 */ { 0, 0, 0, 0, 0 },
/* U+5316 */ { 0, 0, 0, 0, 0 },
/* U+5317 */ { 0, 0, 0, 0, 0 },
/* U+5318 */ { 0, 0, 0, 0, 0 },
/* U+5319 */ { 0, 0, 0, 0, 0 },
/* U+531a */ { 0, 0, 0, 0, 0 },
/* U+531b */ { 0, 0, 0, 0, 0 },
/* U+531c */ { 0, 0, 0, 0, 0 },
/* U+531d */ { 0, 0, 0, 0, 0 },
/* U+531e */ { 0, 0, 0, 0, 0 },
/* U+531f */ { 0, 0, 0, 0, 0 },
/* U+5320 */ { 0, 0, 0, 0, 0 },
/* U+5321 */ { 0, 0, 0, 0, 0 },
/* U+5322 */ { 0, 0, 0, 0, 0 },
/* U+5323 */ { 0, 0, 0, 0, 0 },
/* U+5324 */ { 0, 0, 0, 0, 0 },
/* U+5325 */ { 0, 0, 0, 0, 0 },
/* U+5326 */ { 0, 0, 0, 0, 0 },
/* U+5327 */ { 0, 0, 0, 0, 0 },
/* U+5328 */ { 0, 0, 0, 0, 0 },
/* U+5329 */ { 0, 0, 0, 0, 0 },
/* U+532a */ { 0, 0, 0, 0, 0 },
/* U+532b */ { 0, 0, 0, 0, 0 },
/* U+532c */ { 0, 0, 0, 0, 0 },
/* U+532d */ { 0, 0, 0, 0, 0 },
/* U+532e */ { 0, 0, 0, 0, 0 },
/* U+532f */ { 0, 0, 0, 0, 0 },
/* U+5330 */ { 0, 0, 0, 0, 0 },
/* U+5331 */ { 0, 0, 0, 0, 0 },
/* U+5332 */ { 0, 0, 0, 0, 0 },
/* U+5333 */ { 0, 0, 0, 0, 0 },
/* U+5334 */ { 0, 0, 0, 0, 0 },
/* U+5335 */ { 0, 0, 0, 0, 0 },
/* U+5336 */ { 0, 0, 0, 0, 0 },
/* U+5337 */ { 0, 0, 0, 0, 0 },
/* U+5338 */ { 0, 0, 0, 0, 0 },
/* U+5339 */ { 0, 0, 0, 0, 0 },
/* U+533a */ { 0, 0, 0, 0, 0 },
/* U+533b */ { 0, 0, 0, 0, 0 },
/* U+533c */ { 0, 0, 0, 0, 0 },
/* U+533d */ { 0, 0, 0, 0, 0 },
/* U+533e */ { 0, 0, 0, 0, 0 },
/* U+533f */ { 0, 0, 0, 0, 0 },
/* U+5340 */ { 0, 0, 0, 0, 0 },
/* U+5341 */ { 0, 0, 0, 0, 0 },
/* U+5342 */ { 0, 0, 0, 0, 0 },
/* U+5343 */ { 0, 0, 0, 0, 0 },
/* U+5344 */ { 0, 0, 0, 0, 0 },
/* U+5345 */ { 0, 0, 0, 0, 0 },
/* U+5346 */ { 0, 0, 0, 0, 0 },
/* U+5347 */ { 0, 0, 0, 0, 0 },
/* U+5348 */ { 0, 0, 0, 0, 0 },
/* U+5349 */ { 0, 0, 0, 0, 0 },
/* U+534a */ { 0, 0, 0, 0, 0 },
/* U+534b */ { 0, 0, 0, 0, 0 },
/* U+534c */ { 0, 0, 0, 0, 0 },
/* U+534d */ { 0, 0, 0, 0, 0 },
/* U+534e */ { 0, 0, 0, 0, 0 },
/* U+534f */ { 0, 0, 0, 0, 0 },
/* U+5350 */ { 0, 0, 0, 0, 0 },
/* U+5351 */ { 0, 0, 0, 0, 0 },
/* U+5352 */ { 0, 0, 0, 0, 0 },
/* U+5353 */ { 0, 0, 0, 0, 0 },
/* U+5354 */ { 0, 0, 0, 0, 0 },
/* U+5355 */ { 0, 0, 0, 0, 0 },
/* U+5356 */ { 0, 0, 0, 0, 0 },
/* U+5357 */ { 0, 0, 0, 0, 0 },
/* U+5358 */ { 0, 0, 0, 0, 0 },
/* U+5359 */ { 0, 0, 0, 0, 0 },
/* U+535a */ { 0, 0, 0, 0, 0 },
/* U+535b */ { 0, 0, 0, 0, 0 },
/* U+535c */ { 0, 0, 0, 0, 0 },
/* U+535d */ { 0, 0, 0, 0, 0 },
/* U+535e */ { 0, 0, 0, 0, 0 },
/* U+535f */ { 0, 0, 0, 0, 0 },
/* U+5360 */ { 0, 0, 0, 0, 0 },
/* U+5361 */ { 0, 0, 0, 0, 0 },
/* U+5362 */ { 0, 0, 0, 0, 0 },
/* U+5363 */ { 0, 0, 0, 0, 0 },
/* U+5364 */ { 0, 0, 0, 0, 0 },
/* U+5365 */ { 0, 0, 0, 0, 0 },
/* U+5366 */ { 0, 0, 0, 0, 0 },
/* U+5367 */ { 0, 0, 0, 0, 0 },
/* U+5368 */ { 0, 0, 0, 0, 0 },
/* U+5369 */ { 0, 0, 0, 0, 0 },
/* U+536a */ { 0, 0, 0, 0, 0 },
/* U+536b */ { 0, 0, 0, 0, 0 },
/* U+536c */ { 0, 0, 0, 0, 0 },
/* U+536d */ { 0, 0, 0, 0, 0 },
/* U+536e */ { 0, 0, 0, 0, 0 },
/* U+536f */ { 0, 0, 0, 0, 0 },
/* U+5370 */ { 0, 0, 0, 0, 0 },
/* U+5371 */ { 0, 0, 0, 0, 0 },
/* U+5372 */ { 0, 0, 0, 0, 0 },
/* U+5373 */ { 0, 0, 0, 0, 0 },
/* U+5374 */ { 0, 0, 0, 0, 0 },
/* U+5375 */ { 0, 0, 0, 0, 0 },
/* U+5376 */ { 0, 0, 0, 0, 0 },
/* U+5377 */ { 0, 0, 0, 0, 0 },
/* U+5378 */ { 0, 0, 0, 0, 0 },
/* U+5379 */ { 0, 0, 0, 0, 0 },
/* U+537a */ { 0, 0, 0, 0, 0 },
/* U+537b */ { 0, 0, 0, 0, 0 },
/* U+537c */ { 0, 0, 0, 0, 0 },
/* U+537d */ { 0, 0, 0, 0, 0 },
/* U+537e */ { 0, 0, 0, 0, 0 },
/* U+537f */ { 0, 0, 0, 0, 0 },
/* U+5380 */ { 0, 0, 0, 0, 0 },
/* U+5381 */ { 0, 0, 0, 0, 0 },
/* U+5382 */ { 0, 0, 0, 0, 0 },
/* U+5383 */ { 0, 0, 0, 0, 0 },
/* U+5384 */ { 0, 0, 0, 0, 0 },
/* U+5385 */ { 0, 0, 0, 0, 0 },
/* U+5386 */ { 0, 0, 0, 0, 0 },
/* U+5387 */ { 0, 0, 0, 0, 0 },
/* U+5388 */ { 0, 0, 0, 0, 0 },
/* U+5389 */ { 0, 0, 0, 0, 0 },
/* U+538a */ { 0, 0, 0, 0, 0 },
/* U+538b */ { 0, 0, 0, 0, 0 },
/* U+538c */ { 0, 0, 0, 0, 0 },
/* U+538d */ { 0, 0, 0, 0, 0 },
/* U+538e */ { 0, 0, 0, 0, 0 },
/* U+538f */ { 0, 0, 0, 0, 0 },
/* U+5390 */ { 0, 0, 0, 0, 0 },
/* U+5391 */ { 0, 0, 0, 0, 0 },
/* U+5392 */ { 0, 0, 0, 0, 0 },
/* U+5393 */ { 0, 0, 0, 0, 0 },
/* U+5394 */ { 0, 0, 0, 0, 0 },
/* U+5395 */ { 0, 0, 0, 0, 0 },
/* U+5396 */ { 0, 0, 0, 0, 0 },
/* U+5397 */ { 0, 0, 0, 0, 0 },
/* U+5398 */ { 0, 0, 0, 0, 0 },
/* U+5399 */ { 0, 0, 0, 0, 0 },
/* U+539a */ { 0, 0, 0, 0, 0 },
/* U+539b */ { 0, 0, 0, 0, 0 },
/* U+539c */ { 0, 0, 0, 0, 0 },
/* U+539d */ { 0, 0, 0, 0, 0 },
/* U+539e */ { 0, 0, 0, 0, 0 },
/* U+539f */ { 0, 0, 0, 0, 0 },
/* U+53a0 */ { 0, 0, 0, 0, 0 },
/* U+53a1 */ { 0, 0, 0, 0, 0 },
/* U+53a2 */ { 0, 0, 0, 0, 0 },
/* U+53a3 */ { 0, 0, 0, 0, 0 },
/* U+53a4 */ { 0, 0, 0, 0, 0 },
/* U+53a5 */ { 0, 0, 0, 0, 0 },
/* U+53a6 */ { 0, 0, 0, 0, 0 },
/* U+53a7 */ { 0, 0, 0, 0, 0 },
/* U+53a8 */ { 0, 0, 0, 0, 0 },
/* U+53a9 */ { 0, 0, 0, 0, 0 },
/* U+53aa */ { 0, 0, 0, 0, 0 },
/* U+53ab */ { 0, 0, 0, 0, 0 },
/* U+53ac */ { 0, 0, 0, 0, 0 },
/* U+53ad */ { 0, 0, 0, 0, 0 },
/* U+53ae */ { 0, 0, 0, 0, 0 },
/* U+53af */ { 0, 0, 0, 0, 0 },
/* U+53b0 */ { 0, 0, 0, 0, 0 },
/* U+53b1 */ { 0, 0, 0, 0, 0 },
/* U+53b2 */ { 0, 0, 0, 0, 0 },
/* U+53b3 */ { 0, 0, 0, 0, 0 },
/* U+53b4 */ { 0, 0, 0, 0, 0 },
/* U+53b5 */ { 0, 0, 0, 0, 0 },
/* U+53b6 */ { 0, 0, 0, 0, 0 },
/* U+53b7 */ { 0, 0, 0, 0, 0 },
/* U+53b8 */ { 0, 0, 0, 0, 0 },
/* U+53b9 */ { 0, 0, 0, 0, 0 },
/* U+53ba */ { 0, 0, 0, 0, 0 },
/* U+53bb */ { 0, 0, 0, 0, 0 },
/* U+53bc */ { 0, 0, 0, 0, 0 },
/* U+53bd */ { 0, 0, 0, 0, 0 },
/* U+53be */ { 0, 0, 0, 0, 0 },
/* U+53bf */ { 0, 0, 0, 0, 0 },
/* U+53c0 */ { 0, 0, 0, 0, 0 },
/* U+53c1 */ { 0, 0, 0, 0, 0 },
/* U+53c2 */ { 0, 0, 0, 0, 0 },
/* U+53c3 */ { 0, 0, 0, 0, 0 },
/* U+53c4 */ { 0, 0, 0, 0, 0 },
/* U+53c5 */ { 0, 0, 0, 0, 0 },
/* U+53c6 */ { 0, 0, 0, 0, 0 },
/* U+53c7 */ { 0, 0, 0, 0, 0 },
/* U+53c8 */ { 0, 0, 0, 0, 0 },
/* U+53c9 */ { 0, 0, 0, 0, 0 },
/* U+53ca */ { 0, 0, 0, 0, 0 },
/* U+53cb */ { 0, 0, 0, 0, 0 },
/* U+53cc */ { 0, 0, 0, 0, 0 },
/* U+53cd */ { 0, 0, 0, 0, 0 },
/* U+53ce */ { 0, 0, 0, 0, 0 },
/* U+53cf */ { 0, 0, 0, 0, 0 },
/* U+53d0 */ { 0, 0, 0, 0, 0 },
/* U+53d1 */ { 0, 0, 0, 0, 0 },
/* U+53d2 */ { 0, 0, 0, 0, 0 },
/* U+53d3 */ { 0, 0, 0, 0, 0 },
/* U+53d4 */ { 0, 0, 0, 0, 0 },
/* U+53d5 */ { 0, 0, 0, 0, 0 },
/* U+53d6 */ { 0, 0, 0, 0, 0 },
/* U+53d7 */ { 0, 0, 0, 0, 0 },
/* U+53d8 */ { 0, 0, 0, 0, 0 },
/* U+53d9 */ { 0, 0, 0, 0, 0 },
/* U+53da */ { 0, 0, 0, 0, 0 },
/* U+53db */ { 0, 0, 0, 0, 0 },
/* U+53dc */ { 0, 0, 0, 0, 0 },
/* U+53dd */ { 0, 0, 0, 0, 0 },
/* U+53de */ { 0, 0, 0, 0, 0 },
/* U+53df */ { 0, 0, 0, 0, 0 },
/* U+53e0 */ { 0, 0, 0, 0, 0 },
/* U+53e1 */ { 0, 0, 0, 0, 0 },
/* U+53e2 */ { 0, 0, 0, 0, 0 },
/* U+53e3 */ { 0, 0, 0, 0, 0 },
/* U+53e4 */ { 0, 0, 0, 0, 0 },
/* U+53e5 */ { 0, 0, 0, 0, 0 },
/* U+53e6 */ { 0, 0, 0, 0, 0 },
/* U+53e7 */ { 0, 0, 0, 0, 0 },
/* U+53e8 */ { 0, 0, 0, 0, 0 },
/* U+53e9 */ { 0, 0, 0, 0, 0 },
/* U+53ea */ { 0, 0, 0, 0, 0 },
/* U+53eb */ { 0, 0, 0, 0, 0 },
/* U+53ec */ { 0, 0, 0, 0, 0 },
/* U+53ed */ { 0, 0, 0, 0, 0 },
/* U+53ee */ { 0, 0, 0, 0, 0 },
/* U+53ef */ { 0, 0, 0, 0, 0 },
/* U+53f0 */ { 0, 0, 0, 0, 0 },
/* U+53f1 */ { 0, 0, 0, 0, 0 },
/* U+53f2 */ { 0, 0, 0, 0, 0 },
/* U+53f3 */ { 0, 0, 0, 0, 0 },
/* U+53f4 */ { 0, 0, 0, 0, 0 },
/* U+53f5 */ { 0, 0, 0, 0, 0 },
/* U+53f6 */ { 0, 0, 0, 0, 0 },
/* U+53f7 */ { 0, 0, 0, 0, 0 },
/* U+53f8 */ { 0, 0, 0, 0, 0 },
/* U+53f9 */ { 0, 0, 0, 0, 0 },
/* U+53fa */ { 0, 0, 0, 0, 0 },
/* U+53fb */ { 0, 0, 0, 0, 0 },
/* U+53fc */ { 0, 0, 0, 0, 0 },
/* U+53fd */ { 0, 0, 0, 0, 0 },
/* U+53fe */ { 0, 0, 0, 0, 0 },
/* U+53ff */ { 0, 0, 0, 0, 0 },
/* U+5400 */ { 0, 0, 0, 0, 0 },
/* U+5401 */ { 0, 0, 0, 0, 0 },
/* U+5402 */ { 0, 0, 0, 0, 0 },
/* U+5403 */ { 0, 0, 0, 0, 0 },
/* U+5404 */ { 0, 0, 0, 0, 0 },
/* U+5405 */ { 0, 0, 0, 0, 0 },
/* U+5406 */ { 0, 0, 0, 0, 0 },
/* U+5407 */ { 0, 0, 0, 0, 0 },
/* U+5408 */ { 0, 0, 0, 0, 0 },
/* U+5409 */ { 0, 0, 0, 0, 0 },
/* U+540a */ { 0, 0, 0, 0, 0 },
/* U+540b */ { 0, 0, 0, 0, 0 },
/* U+540c */ { 0, 0, 0, 0, 0 },
/* U+540d */ { 0, 0, 0, 0, 0 },
/* U+540e */ { 0, 0, 0, 0, 0 },
/* U+540f */ { 0, 0, 0, 0, 0 },
/* U+5410 */ { 0, 0, 0, 0, 0 },
/* U+5411 */ { 0, 0, 0, 0, 0 },
/* U+5412 */ { 0, 0, 0, 0, 0 },
/* U+5413 */ { 0, 0, 0, 0, 0 },
/* U+5414 */ { 0, 0, 0, 0, 0 },
/* U+5415 */ { 0, 0, 0, 0, 0 },
/* U+5416 */ { 0, 0, 0, 0, 0 },
/* U+5417 */ { 0, 0, 0, 0, 0 },
/* U+5418 */ { 0, 0, 0, 0, 0 },
/* U+5419 */ { 0, 0, 0, 0, 0 },
/* U+541a */ { 0, 0, 0, 0, 0 },
/* U+541b */ { 0, 0, 0, 0, 0 },
/* U+541c */ { 0, 0, 0, 0, 0 },
/* U+541d */ { 0, 0, 0, 0, 0 },
/* U+541e */ { 0, 0, 0, 0, 0 },
/* U+541f */ { 0, 0, 0, 0, 0 },
/* U+5420 */ { 0, 0, 0, 0, 0 },
/* U+5421 */ { 0, 0, 0, 0, 0 },
/* U+5422 */ { 0, 0, 0, 0, 0 },
/* U+5423 */ { 0, 0, 0, 0, 0 },
/* U+5424 */ { 0, 0, 0, 0, 0 },
/* U+5425 */ { 0, 0, 0, 0, 0 },
/* U+5426 */ { 0, 0, 0, 0, 0 },
/* U+5427 */ { 0, 0, 0, 0, 0 },
/* U+5428 */ { 0, 0, 0, 0, 0 },
/* U+5429 */ { 0, 0, 0, 0, 0 },
/* U+542a */ { 0, 0, 0, 0, 0 },
/* U+542b */ { 0, 0, 0, 0, 0 },
/* U+542c */ { 0, 0, 0, 0, 0 },
/* U+542d */ { 0, 0, 0, 0, 0 },
/* U+542e */ { 0, 0, 0, 0, 0 },
/* U+542f */ { 0, 0, 0, 0, 0 },
/* U+5430 */ { 0, 0, 0, 0, 0 },
/* U+5431 */ { 0, 0, 0, 0, 0 },
/* U+5432 */ { 0, 0, 0, 0, 0 },
/* U+5433 */ { 0, 0, 0, 0, 0 },
/* U+5434 */ { 0, 0, 0, 0, 0 },
/* U+5435 */ { 0, 0, 0, 0, 0 },
/* U+5436 */ { 0, 0, 0, 0, 0 },
/* U+5437 */ { 0, 0, 0, 0, 0 },
/* U+5438 */ { 0, 0, 0, 0, 0 },
/* U+5439 */ { 0, 0, 0, 0, 0 },
/* U+543a */ { 0, 0, 0, 0, 0 },
/* U+543b */ { 0, 0, 0, 0, 0 },
/* U+543c */ { 0, 0, 0, 0, 0 },
/* U+543d */ { 0, 0, 0, 0, 0 },
/* U+543e */ { 0, 0, 0, 0, 0 },
/* U+543f */ { 0, 0, 0, 0, 0 },
/* U+5440 */ { 0, 0, 0, 0, 0 },
/* U+5441 */ { 0, 0, 0, 0, 0 },
/* U+5442 */ { 0, 0, 0, 0, 0 },
/* U+5443 */ { 0, 0, 0, 0, 0 },
/* U+5444 */ { 0, 0, 0, 0, 0 },
/* U+5445 */ { 0, 0, 0, 0, 0 },
/* U+5446 */ { 0, 0, 0, 0, 0 },
/* U+5447 */ { 0, 0, 0, 0, 0 },
/* U+5448 */ { 0, 0, 0, 0, 0 },
/* U+5449 */ { 0, 0, 0, 0, 0 },
/* U+544a */ { 0, 0, 0, 0, 0 },
/* U+544b */ { 0, 0, 0, 0, 0 },
/* U+544c */ { 0, 0, 0, 0, 0 },
/* U+544d */ { 0, 0, 0, 0, 0 },
/* U+544e */ { 0, 0, 0, 0, 0 },
/* U+544f */ { 0, 0, 0, 0, 0 },
/* U+5450 */ { 0, 0, 0, 0, 0 },
/* U+5451 */ { 0, 0, 0, 0, 0 },
/* U+5452 */ { 0, 0, 0, 0, 0 },
/* U+5453 */ { 0, 0, 0, 0, 0 },
/* U+5454 */ { 0, 0, 0, 0, 0 },
/* U+5455 */ { 0, 0, 0, 0, 0 },
/* U+5456 */ { 0, 0, 0, 0, 0 },
/* U+5457 */ { 0, 0, 0, 0, 0 },
/* U+5458 */ { 0, 0, 0, 0, 0 },
/* U+5459 */ { 0, 0, 0, 0, 0 },
/* U+545a */ { 0, 0, 0, 0, 0 },
/* U+545b */ { 0, 0, 0, 0, 0 },
/* U+545c */ { 0, 0, 0, 0, 0 },
/* U+545d */ { 0, 0, 0, 0, 0 },
/* U+545e */ { 0, 0, 0, 0, 0 },
/* U+545f */ { 0, 0, 0, 0, 0 },
/* U+5460 */ { 0, 0, 0, 0, 0 },
/* U+5461 */ { 0, 0, 0, 0, 0 },
/* U+5462 */ { 0, 0, 0, 0, 0 },
/* U+5463 */ { 0, 0, 0, 0, 0 },
/* U+5464 */ { 0, 0, 0, 0, 0 },
/* U+5465 */ { 0, 0, 0, 0, 0 },
/* U+5466 */ { 0, 0, 0, 0, 0 },
/* U+5467 */ { 0, 0, 0, 0, 0 },
/* U+5468 */ { 0, 0, 0, 0, 0 },
/* U+5469 */ { 0, 0, 0, 0, 0 },
/* U+546a */ { 0, 0, 0, 0, 0 },
/* U+546b */ { 0, 0, 0, 0, 0 },
/* U+546c */ { 0, 0, 0, 0, 0 },
/* U+546d */ { 0, 0, 0, 0, 0 },
/* U+546e */ { 0, 0, 0, 0, 0 },
/* U+546f */ { 0, 0, 0, 0, 0 },
/* U+5470 */ { 0, 0, 0, 0, 0 },
/* U+5471 */ { 0, 0, 0, 0, 0 },
/* U+5472 */ { 0, 0, 0, 0, 0 },
/* U+5473 */ { 0, 0, 0, 0, 0 },
/* U+5474 */ { 0, 0, 0, 0, 0 },
/* U+5475 */ { 0, 0, 0, 0, 0 },
/* U+5476 */ { 0, 0, 0, 0, 0 },
/* U+5477 */ { 0, 0, 0, 0, 0 },
/* U+5478 */ { 0, 0, 0, 0, 0 },
/* U+5479 */ { 0, 0, 0, 0, 0 },
/* U+547a */ { 0, 0, 0, 0, 0 },
/* U+547b */ { 0, 0, 0, 0, 0 },
/* U+547c */ { 0, 0, 0, 0, 0 },
/* U+547d */ { 0, 0, 0, 0, 0 },
/* U+547e */ { 0, 0, 0, 0, 0 },
/* U+547f */ { 0, 0, 0, 0, 0 },
/* U+5480 */ { 0, 0, 0, 0, 0 },
/* U+5481 */ { 0, 0, 0, 0, 0 },
/* U+5482 */ { 0, 0, 0, 0, 0 },
/* U+5483 */ { 0, 0, 0, 0, 0 },
/* U+5484 */ { 0, 0, 0, 0, 0 },
/* U+5485 */ { 0, 0, 0, 0, 0 },
/* U+5486 */ { 0, 0, 0, 0, 0 },
/* U+5487 */ { 0, 0, 0, 0, 0 },
/* U+5488 */ { 0, 0, 0, 0, 0 },
/* U+5489 */ { 0, 0, 0, 0, 0 },
/* U+548a */ { 0, 0, 0, 0, 0 },
/* U+548b */ { 0, 0, 0, 0, 0 },
/* U+548c */ { 0, 0, 0, 0, 0 },
/* U+548d */ { 0, 0, 0, 0, 0 },
/* U+548e */ { 0, 0, 0, 0, 0 },
/* U+548f */ { 0, 0, 0, 0, 0 },
/* U+5490 */ { 0, 0, 0, 0, 0 },
/* U+5491 */ { 0, 0, 0, 0, 0 },
/* U+5492 */ { 0, 0, 0, 0, 0 },
/* U+5493 */ { 0, 0, 0, 0, 0 },
/* U+5494 */ { 0, 0, 0, 0, 0 },
/* U+5495 */ { 0, 0, 0, 0, 0 },
/* U+5496 */ { 0, 0, 0, 0, 0 },
/* U+5497 */ { 0, 0, 0, 0, 0 },
/* U+5498 */ { 0, 0, 0, 0, 0 },
/* U+5499 */ { 0, 0, 0, 0, 0 },
/* U+549a */ { 0, 0, 0, 0, 0 },
/* U+549b */ { 0, 0, 0, 0, 0 },
/* U+549c */ { 0, 0, 0, 0, 0 },
/* U+549d */ { 0, 0, 0, 0, 0 },
/* U+549e */ { 0, 0, 0, 0, 0 },
/* U+549f */ { 0, 0, 0, 0, 0 },
/* U+54a0 */ { 0, 0, 0, 0, 0 },
/* U+54a1 */ { 0, 0, 0, 0, 0 },
/* U+54a2 */ { 0, 0, 0, 0, 0 },
/* U+54a3 */ { 0, 0, 0, 0, 0 },
/* U+54a4 */ { 0, 0, 0, 0, 0 },
/* U+54a5 */ { 0, 0, 0, 0, 0 },
/* U+54a6 */ { 0, 0, 0, 0, 0 },
/* U+54a7 */ { 0, 0, 0, 0, 0 },
/* U+54a8 */ { 0, 0, 0, 0, 0 },
/* U+54a9 */ { 0, 0, 0, 0, 0 },
/* U+54aa */ { 0, 0, 0, 0, 0 },
/* U+54ab */ { 0, 0, 0, 0, 0 },
/* U+54ac */ { 0, 0, 0, 0, 0 },
/* U+54ad */ { 0, 0, 0, 0, 0 },
/* U+54ae */ { 0, 0, 0, 0, 0 },
/* U+54af */ { 0, 0, 0, 0, 0 },
/* U+54b0 */ { 0, 0, 0, 0, 0 },
/* U+54b1 */ { 0, 0, 0, 0, 0 },
/* U+54b2 */ { 0, 0, 0, 0, 0 },
/* U+54b3 */ { 0, 0, 0, 0, 0 },
/* U+54b4 */ { 0, 0, 0, 0, 0 },
/* U+54b5 */ { 0, 0, 0, 0, 0 },
/* U+54b6 */ { 0, 0, 0, 0, 0 },
/* U+54b7 */ { 0, 0, 0, 0, 0 },
/* U+54b8 */ { 0, 0, 0, 0, 0 },
/* U+54b9 */ { 0, 0, 0, 0, 0 },
/* U+54ba */ { 0, 0, 0, 0, 0 },
/* U+54bb */ { 0, 0, 0, 0, 0 },
/* U+54bc */ { 0, 0, 0, 0, 0 },
/* U+54bd */ { 0, 0, 0, 0, 0 },
/* U+54be */ { 0, 0, 0, 0, 0 },
/* U+54bf */ { 0, 0, 0, 0, 0 },
/* U+54c0 */ { 0, 0, 0, 0, 0 },
/* U+54c1 */ { 0, 0, 0, 0, 0 },
/* U+54c2 */ { 0, 0, 0, 0, 0 },
/* U+54c3 */ { 0, 0, 0, 0, 0 },
/* U+54c4 */ { 0, 0, 0, 0, 0 },
/* U+54c5 */ { 0, 0, 0, 0, 0 },
/* U+54c6 */ { 0, 0, 0, 0, 0 },
/* U+54c7 */ { 0, 0, 0, 0, 0 },
/* U+54c8 */ { 0, 0, 0, 0, 0 },
/* U+54c9 */ { 0, 0, 0, 0, 0 },
/* U+54ca */ { 0, 0, 0, 0, 0 },
/* U+54cb */ { 0, 0, 0, 0, 0 },
/* U+54cc */ { 0, 0, 0, 0, 0 },
/* U+54cd */ { 0, 0, 0, 0, 0 },
/* U+54ce */ { 0, 0, 0, 0, 0 },
/* U+54cf */ { 0, 0, 0, 0, 0 },
/* U+54d0 */ { 0, 0, 0, 0, 0 },
/* U+54d1 */ { 0, 0, 0, 0, 0 },
/* U+54d2 */ { 0, 0, 0, 0, 0 },
/* U+54d3 */ { 0, 0, 0, 0, 0 },
/* U+54d4 */ { 0, 0, 0, 0, 0 },
/* U+54d5 */ { 0, 0, 0, 0, 0 },
/* U+54d6 */ { 0, 0, 0, 0, 0 },
/* U+54d7 */ { 0, 0, 0, 0, 0 },
/* U+54d8 */ { 0, 0, 0, 0, 0 },
/* U+54d9 */ { 0, 0, 0, 0, 0 },
/* U+54da */ { 0, 0, 0, 0, 0 },
/* U+54db */ { 0, 0, 0, 0, 0 },
/* U+54dc */ { 0, 0, 0, 0, 0 },
/* U+54dd */ { 0, 0, 0, 0, 0 },
/* U+54de */ { 0, 0, 0, 0, 0 },
/* U+54df */ { 0, 0, 0, 0, 0 },
/* U+54e0 */ { 0, 0, 0, 0, 0 },
/* U+54e1 */ { 0, 0, 0, 0, 0 },
/* U+54e2 */ { 0, 0, 0, 0, 0 },
/* U+54e3 */ { 0, 0, 0, 0, 0 },
/* U+54e4 */ { 0, 0, 0, 0, 0 },
/* U+54e5 */ { 0, 0, 0, 0, 0 },
/* U+54e6 */ { 0, 0, 0, 0, 0 },
/* U+54e7 */ { 0, 0, 0, 0, 0 },
/* U+54e8 */ { 0, 0, 0, 0, 0 },
/* U+54e9 */ { 0, 0, 0, 0, 0 },
/* U+54ea */ { 0, 0, 0, 0, 0 },
/* U+54eb */ { 0, 0, 0, 0, 0 },
/* U+54ec */ { 0, 0, 0, 0, 0 },
/* U+54ed */ { 0, 0, 0, 0, 0 },
/* U+54ee */ { 0, 0, 0, 0, 0 },
/* U+54ef */ { 0, 0, 0, 0, 0 },
/* U+54f0 */ { 0, 0, 0, 0, 0 },
/* U+54f1 */ { 0, 0, 0, 0, 0 },
/* U+54f2 */ { 0, 0, 0, 0, 0 },
/* U+54f3 */ { 0, 0, 0, 0, 0 },
/* U+54f4 */ { 0, 0, 0, 0, 0 },
/* U+54f5 */ { 0, 0, 0, 0, 0 },
/* U+54f6 */ { 0, 0, 0, 0, 0 },
/* U+54f7 */ { 0, 0, 0, 0, 0 },
/* U+54f8 */ { 0, 0, 0, 0, 0 },
/* U+54f9 */ { 0, 0, 0, 0, 0 },
/* U+54fa */ { 0, 0, 0, 0, 0 },
/* U+54fb */ { 0, 0, 0, 0, 0 },
/* U+54fc */ { 0, 0, 0, 0, 0 },
/* U+54fd */ { 0, 0, 0, 0, 0 },
/* U+54fe */ { 0, 0, 0, 0, 0 },
/* U+54ff */ { 0, 0, 0, 0, 0 },
/* U+5500 */ { 0, 0, 0, 0, 0 },
/* U+5501 */ { 0, 0, 0, 0, 0 },
/* U+5502 */ { 0, 0, 0, 0, 0 },
/* U+5503 */ { 0, 0, 0, 0, 0 },
/* U+5504 */ { 0, 0, 0, 0, 0 },
/* U+5505 */ { 0, 0, 0, 0, 0 },
/* U+5506 */ { 0, 0, 0, 0, 0 },
/* U+5507 */ { 0, 0, 0, 0, 0 },
/* U+5508 */ { 0, 0, 0, 0, 0 },
/* U+5509 */ { 0, 0, 0, 0, 0 },
/* U+550a */ { 0, 0, 0, 0, 0 },
/* U+550b */ { 0, 0, 0, 0, 0 },
/* U+550c */ { 0, 0, 0, 0, 0 },
/* U+550d */ { 0, 0, 0, 0, 0 },
/* U+550e */ { 0, 0, 0, 0, 0 },
/* U+550f */ { 0, 0, 0, 0, 0 },
/* U+5510 */ { 0, 0, 0, 0, 0 },
/* U+5511 */ { 0, 0, 0, 0, 0 },
/* U+5512 */ { 0, 0, 0, 0, 0 },
/* U+5513 */ { 0, 0, 0, 0, 0 },
/* U+5514 */ { 0, 0, 0, 0, 0 },
/* U+5515 */ { 0, 0, 0, 0, 0 },
/* U+5516 */ { 0, 0, 0, 0, 0 },
/* U+5517 */ { 0, 0, 0, 0, 0 },
/* U+5518 */ { 0, 0, 0, 0, 0 },
/* U+5519 */ { 0, 0, 0, 0, 0 },
/* U+551a */ { 0, 0, 0, 0, 0 },
/* U+551b */ { 0, 0, 0, 0, 0 },
/* U+551c */ { 0, 0, 0, 0, 0 },
/* U+551d */ { 0, 0, 0, 0, 0 },
/* U+551e */ { 0, 0, 0, 0, 0 },
/* U+551f */ { 0, 0, 0, 0, 0 },
/* U+5520 */ { 0, 0, 0, 0, 0 },
/* U+5521 */ { 0, 0, 0, 0, 0 },
/* U+5522 */ { 0, 0, 0, 0, 0 },
/* U+5523 */ { 0, 0, 0, 0, 0 },
/* U+5524 */ { 0, 0, 0, 0, 0 },
/* U+5525 */ { 0, 0, 0, 0, 0 },
/* U+5526 */ { 0, 0, 0, 0, 0 },
/* U+5527 */ { 0, 0, 0, 0, 0 },
/* U+5528 */ { 0, 0, 0, 0, 0 },
/* U+5529 */ { 0, 0, 0, 0, 0 },
/* U+552a */ { 0, 0, 0, 0, 0 },
/* U+552b */ { 0, 0, 0, 0, 0 },
/* U+552c */ { 0, 0, 0, 0, 0 },
/* U+552d */ { 0, 0, 0, 0, 0 },
/* U+552e */ { 0, 0, 0, 0, 0 },
/* U+552f */ { 0, 0, 0, 0, 0 },
/* U+5530 */ { 0, 0, 0, 0, 0 },
/* U+5531 */ { 0, 0, 0, 0, 0 },
/* U+5532 */ { 0, 0, 0, 0, 0 },
/* U+5533 */ { 0, 0, 0, 0, 0 },
/* U+5534 */ { 0, 0, 0, 0, 0 },
/* U+5535 */ { 0, 0, 0, 0, 0 },
/* U+5536 */ { 0, 0, 0, 0, 0 },
/* U+5537 */ { 0, 0, 0, 0, 0 },
/* U+5538 */ { 0, 0, 0, 0, 0 },
/* U+5539 */ { 0, 0, 0, 0, 0 },
/* U+553a */ { 0, 0, 0, 0, 0 },
/* U+553b */ { 0, 0, 0, 0, 0 },
/* U+553c */ { 0, 0, 0, 0, 0 },
/* U+553d */ { 0, 0, 0, 0, 0 },
/* U+553e */ { 0, 0, 0, 0, 0 },
/* U+553f */ { 0, 0, 0, 0, 0 },
/* U+5540 */ { 0, 0, 0, 0, 0 },
/* U+5541 */ { 0, 0, 0, 0, 0 },
/* U+5542 */ { 0, 0, 0, 0, 0 },
/* U+5543 */ { 0, 0, 0, 0, 0 },
/* U+5544 */ { 0, 0, 0, 0, 0 },
/* U+5545 */ { 0, 0, 0, 0, 0 },
/* U+5546 */ { 0, 0, 0, 0, 0 },
/* U+5547 */ { 0, 0, 0, 0, 0 },
/* U+5548 */ { 0, 0, 0, 0, 0 },
/* U+5549 */ { 0, 0, 0, 0, 0 },
/* U+554a */ { 0, 0, 0, 0, 0 },
/* U+554b */ { 0, 0, 0, 0, 0 },
/* U+554c */ { 0, 0, 0, 0, 0 },
/* U+554d */ { 0, 0, 0, 0, 0 },
/* U+554e */ { 0, 0, 0, 0, 0 },
/* U+554f */ { 0, 0, 0, 0, 0 },
/* U+5550 */ { 0, 0, 0, 0, 0 },
/* U+5551 */ { 0, 0, 0, 0, 0 },
/* U+5552 */ { 0, 0, 0, 0, 0 },
/* U+5553 */ { 0, 0, 0, 0, 0 },
/* U+5554 */ { 0, 0, 0, 0, 0 },
/* U+5555 */ { 0, 0, 0, 0, 0 },
/* U+5556 */ { 0, 0, 0, 0, 0 },
/* U+5557 */ { 0, 0, 0, 0, 0 },
/* U+5558 */ { 0, 0, 0, 0, 0 },
/* U+5559 */ { 0, 0, 0, 0, 0 },
/* U+555a */ { 0, 0, 0, 0, 0 },
/* U+555b */ { 0, 0, 0, 0, 0 },
/* U+555c */ { 0, 0, 0, 0, 0 },
/* U+555d */ { 0, 0, 0, 0, 0 },
/* U+555e */ { 0, 0, 0, 0, 0 },
/* U+555f */ { 0, 0, 0, 0, 0 },
/* U+5560 */ { 0, 0, 0, 0, 0 },
/* U+5561 */ { 0, 0, 0, 0, 0 },
/* U+5562 */ { 0, 0, 0, 0, 0 },
/* U+5563 */ { 0, 0, 0, 0, 0 },
/* U+5564 */ { 0, 0, 0, 0, 0 },
/* U+5565 */ { 0, 0, 0, 0, 0 },
/* U+5566 */ { 0, 0, 0, 0, 0 },
/* U+5567 */ { 0, 0, 0, 0, 0 },
/* U+5568 */ { 0, 0, 0, 0, 0 },
/* U+5569 */ { 0, 0, 0, 0, 0 },
/* U+556a */ { 0, 0, 0, 0, 0 },
/* U+556b */ { 0, 0, 0, 0, 0 },
/* U+556c */ { 0, 0, 0, 0, 0 },
/* U+556d */ { 0, 0, 0, 0, 0 },
/* U+556e */ { 0, 0, 0, 0, 0 },
/* U+556f */ { 0, 0, 0, 0, 0 },
/* U+5570 */ { 0, 0, 0, 0, 0 },
/* U+5571 */ { 0, 0, 0, 0, 0 },
/* U+5572 */ { 0, 0, 0, 0, 0 },
/* U+5573 */ { 0, 0, 0, 0, 0 },
/* U+5574 */ { 0, 0, 0, 0, 0 },
/* U+5575 */ { 0, 0, 0, 0, 0 },
/* U+5576 */ { 0, 0, 0, 0, 0 },
/* U+5577 */ { 0, 0, 0, 0, 0 },
/* U+5578 */ { 0, 0, 0, 0, 0 },
/* U+5579 */ { 0, 0, 0, 0, 0 },
/* U+557a */ { 0, 0, 0, 0, 0 },
/* U+557b */ { 0, 0, 0, 0, 0 },
/* U+557c */ { 0, 0, 0, 0, 0 },
/* U+557d */ { 0, 0, 0, 0, 0 },
/* U+557e */ { 0, 0, 0, 0, 0 },
/* U+557f */ { 0, 0, 0, 0, 0 },
/* U+5580 */ { 0, 0, 0, 0, 0 },
/* U+5581 */ { 0, 0, 0, 0, 0 },
/* U+5582 */ { 0, 0, 0, 0, 0 },
/* U+5583 */ { 0, 0, 0, 0, 0 },
/* U+5584 */ { 0, 0, 0, 0, 0 },
/* U+5585 */ { 0, 0, 0, 0, 0 },
/* U+5586 */ { 0, 0, 0, 0, 0 },
/* U+5587 */ { 0, 0, 0, 0, 0 },
/* U+5588 */ { 0, 0, 0, 0, 0 },
/* U+5589 */ { 0, 0, 0, 0, 0 },
/* U+558a */ { 0, 0, 0, 0, 0 },
/* U+558b */ { 0, 0, 0, 0, 0 },
/* U+558c */ { 0, 0, 0, 0, 0 },
/* U+558d */ { 0, 0, 0, 0, 0 },
/* U+558e */ { 0, 0, 0, 0, 0 },
/* U+558f */ { 0, 0, 0, 0, 0 },
/* U+5590 */ { 0, 0, 0, 0, 0 },
/* U+5591 */ { 0, 0, 0, 0, 0 },
/* U+5592 */ { 0, 0, 0, 0, 0 },
/* U+5593 */ { 0, 0, 0, 0, 0 },
/* U+5594 */ { 0, 0, 0, 0, 0 },
/* U+5595 */ { 0, 0, 0, 0, 0 },
/* U+5596 */ { 0, 0, 0, 0, 0 },
/* U+5597 */ { 0, 0, 0, 0, 0 },
/* U+5598 */ { 0, 0, 0, 0, 0 },
/* U+5599 */ { 0, 0, 0, 0, 0 },
/* U+559a */ { 0, 0, 0, 0, 0 },
/* U+559b */ { 0, 0, 0, 0, 0 },
/* U+559c */ { 0, 0, 0, 0, 0 },
/* U+559d */ { 0, 0, 0, 0, 0 },
/* U+559e */ { 0, 0, 0, 0, 0 },
/* U+559f */ { 0, 0, 0, 0, 0 },
/* U+55a0 */ { 0, 0, 0, 0, 0 },
/* U+55a1 */ { 0, 0, 0, 0, 0 },
/* U+55a2 */ { 0, 0, 0, 0, 0 },
/* U+55a3 */ { 0, 0, 0, 0, 0 },
/* U+55a4 */ { 0, 0, 0, 0, 0 },
/* U+55a5 */ { 0, 0, 0, 0, 0 },
/* U+55a6 */ { 0, 0, 0, 0, 0 },
/* U+55a7 */ { 0, 0, 0, 0, 0 },
/* U+55a8 */ { 0, 0, 0, 0, 0 },
/* U+55a9 */ { 0, 0, 0, 0, 0 },
/* U+55aa */ { 0, 0, 0, 0, 0 },
/* U+55ab */ { 0, 0, 0, 0, 0 },
/* U+55ac */ { 0, 0, 0, 0, 0 },
/* U+55ad */ { 0, 0, 0, 0, 0 },
/* U+55ae */ { 0, 0, 0, 0, 0 },
/* U+55af */ { 0, 0, 0, 0, 0 },
/* U+55b0 */ { 0, 0, 0, 0, 0 },
/* U+55b1 */ { 0, 0, 0, 0, 0 },
/* U+55b2 */ { 0, 0, 0, 0, 0 },
/* U+55b3 */ { 0, 0, 0, 0, 0 },
/* U+55b4 */ { 0, 0, 0, 0, 0 },
/* U+55b5 */ { 0, 0, 0, 0, 0 },
/* U+55b6 */ { 0, 0, 0, 0, 0 },
/* U+55b7 */ { 0, 0, 0, 0, 0 },
/* U+55b8 */ { 0, 0, 0, 0, 0 },
/* U+55b9 */ { 0, 0, 0, 0, 0 },
/* U+55ba */ { 0, 0, 0, 0, 0 },
/* U+55bb */ { 0, 0, 0, 0, 0 },
/* U+55bc */ { 0, 0, 0, 0, 0 },
/* U+55bd */ { 0, 0, 0, 0, 0 },
/* U+55be */ { 0, 0, 0, 0, 0 },
/* U+55bf */ { 0, 0, 0, 0, 0 },
/* U+55c0 */ { 0, 0, 0, 0, 0 },
/* U+55c1 */ { 0, 0, 0, 0, 0 },
/* U+55c2 */ { 0, 0, 0, 0, 0 },
/* U+55c3 */ { 0, 0, 0, 0, 0 },
/* U+55c4 */ { 0, 0, 0, 0, 0 },
/* U+55c5 */ { 0, 0, 0, 0, 0 },
/* U+55c6 */ { 0, 0, 0, 0, 0 },
/* U+55c7 */ { 0, 0, 0, 0, 0 },
/* U+55c8 */ { 0, 0, 0, 0, 0 },
/* U+55c9 */ { 0, 0, 0, 0, 0 },
/* U+55ca */ { 0, 0, 0, 0, 0 },
/* U+55cb */ { 0, 0, 0, 0, 0 },
/* U+55cc */ { 0, 0, 0, 0, 0 },
/* U+55cd */ { 0, 0, 0, 0, 0 },
/* U+55ce */ { 0, 0, 0, 0, 0 },
/* U+55cf */ { 0, 0, 0, 0, 0 },
/* U+55d0 */ { 0, 0, 0, 0, 0 },
/* U+55d1 */ { 0, 0, 0, 0, 0 },
/* U+55d2 */ { 0, 0, 0, 0, 0 },
/* U+55d3 */ { 0, 0, 0, 0, 0 },
/* U+55d4 */ { 0, 0, 0, 0, 0 },
/* U+55d5 */ { 0, 0, 0, 0, 0 },
/* U+55d6 */ { 0, 0, 0, 0, 0 },
/* U+55d7 */ { 0, 0, 0, 0, 0 },
/* U+55d8 */ { 0, 0, 0, 0, 0 },
/* U+55d9 */ { 0, 0, 0, 0, 0 },
/* U+55da */ { 0, 0, 0, 0, 0 },
/* U+55db */ { 0, 0, 0, 0, 0 },
/* U+55dc */ { 0, 0, 0, 0, 0 },
/* U+55dd */ { 0, 0, 0, 0, 0 },
/* U+55de */ { 0, 0, 0, 0, 0 },
/* U+55df */ { 0, 0, 0, 0, 0 },
/* U+55e0 */ { 0, 0, 0, 0, 0 },
/* U+55e1 */ { 0, 0, 0, 0, 0 },
/* U+55e2 */ { 0, 0, 0, 0, 0 },
/* U+55e3 */ { 0, 0, 0, 0, 0 },
/* U+55e4 */ { 0, 0, 0, 0, 0 },
/* U+55e5 */ { 0, 0, 0, 0, 0 },
/* U+55e6 */ { 0, 0, 0, 0, 0 },
/* U+55e7 */ { 0, 0, 0, 0, 0 },
/* U+55e8 */ { 0, 0, 0, 0, 0 },
/* U+55e9 */ { 0, 0, 0, 0, 0 },
/* U+55ea */ { 0, 0, 0, 0, 0 },
/* U+55eb */ { 0, 0, 0, 0, 0 },
/* U+55ec */ { 0, 0, 0, 0, 0 },
/* U+55ed */ { 0, 0, 0, 0, 0 },
/* U+55ee */ { 0, 0, 0, 0, 0 },
/* U+55ef */ { 0, 0, 0, 0, 0 },
/* U+55f0 */ { 0, 0, 0, 0, 0 },
/* U+55f1 */ { 0, 0, 0, 0, 0 },
/* U+55f2 */ { 0, 0, 0, 0, 0 },
/* U+55f3 */ { 0, 0, 0, 0, 0 },
/* U+55f4 */ { 0, 0, 0, 0, 0 },
/* U+55f5 */ { 0, 0, 0, 0, 0 },
/* U+55f6 */ { 0, 0, 0, 0, 0 },
/* U+55f7 */ { 0, 0, 0, 0, 0 },
/* U+55f8 */ { 0, 0, 0, 0, 0 },
/* U+55f9 */ { 0, 0, 0, 0, 0 },
/* U+55fa */ { 0, 0, 0, 0, 0 },
/* U+55fb */ { 0, 0, 0, 0, 0 },
/* U+55fc */ { 0, 0, 0, 0, 0 },
/* U+55fd */ { 0, 0, 0, 0, 0 },
/* U+55fe */ { 0, 0, 0, 0, 0 },
/* U+55ff */ { 0, 0, 0, 0, 0 },
/* U+5600 */ { 0, 0, 0, 0, 0 },
/* U+5601 */ { 0, 0, 0, 0, 0 },
/* U+5602 */ { 0, 0, 0, 0, 0 },
/* U+5603 */ { 0, 0, 0, 0, 0 },
/* U+5604 */ { 0, 0, 0, 0, 0 },
/* U+5605 */ { 0, 0, 0, 0, 0 },
/* U+5606 */ { 0, 0, 0, 0, 0 },
/* U+5607 */ { 0, 0, 0, 0, 0 },
/* U+5608 */ { 0, 0, 0, 0, 0 },
/* U+5609 */ { 0, 0, 0, 0, 0 },
/* U+560a */ { 0, 0, 0, 0, 0 },
/* U+560b */ { 0, 0, 0, 0, 0 },
/* U+560c */ { 0, 0, 0, 0, 0 },
/* U+560d */ { 0, 0, 0, 0, 0 },
/* U+560e */ { 0, 0, 0, 0, 0 },
/* U+560f */ { 0, 0, 0, 0, 0 },
/* U+5610 */ { 0, 0, 0, 0, 0 },
/* U+5611 */ { 0, 0, 0, 0, 0 },
/* U+5612 */ { 0, 0, 0, 0, 0 },
/* U+5613 */ { 0, 0, 0, 0, 0 },
/* U+5614 */ { 0, 0, 0, 0, 0 },
/* U+5615 */ { 0, 0, 0, 0, 0 },
/* U+5616 */ { 0, 0, 0, 0, 0 },
/* U+5617 */ { 0, 0, 0, 0, 0 },
/* U+5618 */ { 0, 0, 0, 0, 0 },
/* U+5619 */ { 0, 0, 0, 0, 0 },
/* U+561a */ { 0, 0, 0, 0, 0 },
/* U+561b */ { 0, 0, 0, 0, 0 },
/* U+561c */ { 0, 0, 0, 0, 0 },
/* U+561d */ { 0, 0, 0, 0, 0 },
/* U+561e */ { 0, 0, 0, 0, 0 },
/* U+561f */ { 0, 0, 0, 0, 0 },
/* U+5620 */ { 0, 0, 0, 0, 0 },
/* U+5621 */ { 0, 0, 0, 0, 0 },
/* U+5622 */ { 0, 0, 0, 0, 0 },
/* U+5623 */ { 0, 0, 0, 0, 0 },
/* U+5624 */ { 0, 0, 0, 0, 0 },
/* U+5625 */ { 0, 0, 0, 0, 0 },
/* U+5626 */ { 0, 0, 0, 0, 0 },
/* U+5627 */ { 0, 0, 0, 0, 0 },
/* U+5628 */ { 0, 0, 0, 0, 0 },
/* U+5629 */ { 0, 0, 0, 0, 0 },
/* U+562a */ { 0, 0, 0, 0, 0 },
/* U+562b */ { 0, 0, 0, 0, 0 },
/* U+562c */ { 0, 0, 0, 0, 0 },
/* U+562d */ { 0, 0, 0, 0, 0 },
/* U+562e */ { 0, 0, 0, 0, 0 },
/* U+562f */ { 0, 0, 0, 0, 0 },
/* U+5630 */ { 0, 0, 0, 0, 0 },
/* U+5631 */ { 0, 0, 0, 0, 0 },
/* U+5632 */ { 0, 0, 0, 0, 0 },
/* U+5633 */ { 0, 0, 0, 0, 0 },
/* U+5634 */ { 0, 0, 0, 0, 0 },
/* U+5635 */ { 0, 0, 0, 0, 0 },
/* U+5636 */ { 0, 0, 0, 0, 0 },
/* U+5637 */ { 0, 0, 0, 0, 0 },
/* U+5638 */ { 0, 0, 0, 0, 0 },
/* U+5639 */ { 0, 0, 0, 0, 0 },
/* U+563a */ { 0, 0, 0, 0, 0 },
/* U+563b */ { 0, 0, 0, 0, 0 },
/* U+563c */ { 0, 0, 0, 0, 0 },
/* U+563d */ { 0, 0, 0, 0, 0 },
/* U+563e */ { 0, 0, 0, 0, 0 },
/* U+563f */ { 0, 0, 0, 0, 0 },
/* U+5640 */ { 0, 0, 0, 0, 0 },
/* U+5641 */ { 0, 0, 0, 0, 0 },
/* U+5642 */ { 0, 0, 0, 0, 0 },
/* U+5643 */ { 0, 0, 0, 0, 0 },
/* U+5644 */ { 0, 0, 0, 0, 0 },
/* U+5645 */ { 0, 0, 0, 0, 0 },
/* U+5646 */ { 0, 0, 0, 0, 0 },
/* U+5647 */ { 0, 0, 0, 0, 0 },
/* U+5648 */ { 0, 0, 0, 0, 0 },
/* U+5649 */ { 0, 0, 0, 0, 0 },
/* U+564a */ { 0, 0, 0, 0, 0 },
/* U+564b */ { 0, 0, 0, 0, 0 },
/* U+564c */ { 0, 0, 0, 0, 0 },
/* U+564d */ { 0, 0, 0, 0, 0 },
/* U+564e */ { 0, 0, 0, 0, 0 },
/* U+564f */ { 0, 0, 0, 0, 0 },
/* U+5650 */ { 0, 0, 0, 0, 0 },
/* U+5651 */ { 0, 0, 0, 0, 0 },
/* U+5652 */ { 0, 0, 0, 0, 0 },
/* U+5653 */ { 0, 0, 0, 0, 0 },
/* U+5654 */ { 0, 0, 0, 0, 0 },
/* U+5655 */ { 0, 0, 0, 0, 0 },
/* U+5656 */ { 0, 0, 0, 0, 0 },
/* U+5657 */ { 0, 0, 0, 0, 0 },
/* U+5658 */ { 0, 0, 0, 0, 0 },
/* U+5659 */ { 0, 0, 0, 0, 0 },
/* U+565a */ { 0, 0, 0, 0, 0 },
/* U+565b */ { 0, 0, 0, 0, 0 },
/* U+565c */ { 0, 0, 0, 0, 0 },
/* U+565d */ { 0, 0, 0, 0, 0 },
/* U+565e */ { 0, 0, 0, 0, 0 },
/* U+565f */ { 0, 0, 0, 0, 0 },
/* U+5660 */ { 0, 0, 0, 0, 0 },
/* U+5661 */ { 0, 0, 0, 0, 0 },
/* U+5662 */ { 0, 0, 0, 0, 0 },
/* U+5663 */ { 0, 0, 0, 0, 0 },
/* U+5664 */ { 0, 0, 0, 0, 0 },
/* U+5665 */ { 0, 0, 0, 0, 0 },
/* U+5666 */ { 0, 0, 0, 0, 0 },
/* U+5667 */ { 0, 0, 0, 0, 0 },
/* U+5668 */ { 0, 0, 0, 0, 0 },
/* U+5669 */ { 0, 0, 0, 0, 0 },
/* U+566a */ { 0, 0, 0, 0, 0 },
/* U+566b */ { 0, 0, 0, 0, 0 },
/* U+566c */ { 0, 0, 0, 0, 0 },
/* U+566d */ { 0, 0, 0, 0, 0 },
/* U+566e */ { 0, 0, 0, 0, 0 },
/* U+566f */ { 0, 0, 0, 0, 0 },
/* U+5670 */ { 0, 0, 0, 0, 0 },
/* U+5671 */ { 0, 0, 0, 0, 0 },
/* U+5672 */ { 0, 0, 0, 0, 0 },
/* U+5673 */ { 0, 0, 0, 0, 0 },
/* U+5674 */ { 0, 0, 0, 0, 0 },
/* U+5675 */ { 0, 0, 0, 0, 0 },
/* U+5676 */ { 0, 0, 0, 0, 0 },
/* U+5677 */ { 0, 0, 0, 0, 0 },
/* U+5678 */ { 0, 0, 0, 0, 0 },
/* U+5679 */ { 0, 0, 0, 0, 0 },
/* U+567a */ { 0, 0, 0, 0, 0 },
/* U+567b */ { 0, 0, 0, 0, 0 },
/* U+567c */ { 0, 0, 0, 0, 0 },
/* U+567d */ { 0, 0, 0, 0, 0 },
/* U+567e */ { 0, 0, 0, 0, 0 },
/* U+567f */ { 0, 0, 0, 0, 0 },
/* U+5680 */ { 0, 0, 0, 0, 0 },
/* U+5681 */ { 0, 0, 0, 0, 0 },
/* U+5682 */ { 0, 0, 0, 0, 0 },
/* U+5683 */ { 0, 0, 0, 0, 0 },
/* U+5684 */ { 0, 0, 0, 0, 0 },
/* U+5685 */ { 0, 0, 0, 0, 0 },
/* U+5686 */ { 0, 0, 0, 0, 0 },
/* U+5687 */ { 0, 0, 0, 0, 0 },
/* U+5688 */ { 0, 0, 0, 0, 0 },
/* U+5689 */ { 0, 0, 0, 0, 0 },
/* U+568a */ { 0, 0, 0, 0, 0 },
/* U+568b */ { 0, 0, 0, 0, 0 },
/* U+568c */ { 0, 0, 0, 0, 0 },
/* U+568d */ { 0, 0, 0, 0, 0 },
/* U+568e */ { 0, 0, 0, 0, 0 },
/* U+568f */ { 0, 0, 0, 0, 0 },
/* U+5690 */ { 0, 0, 0, 0, 0 },
/* U+5691 */ { 0, 0, 0, 0, 0 },
/* U+5692 */ { 0, 0, 0, 0, 0 },
/* U+5693 */ { 0, 0, 0, 0, 0 },
/* U+5694 */ { 0, 0, 0, 0, 0 },
/* U+5695 */ { 0, 0, 0, 0, 0 },
/* U+5696 */ { 0, 0, 0, 0, 0 },
/* U+5697 */ { 0, 0, 0, 0, 0 },
/* U+5698 */ { 0, 0, 0, 0, 0 },
/* U+5699 */ { 0, 0, 0, 0, 0 },
/* U+569a */ { 0, 0, 0, 0, 0 },
/* U+569b */ { 0, 0, 0, 0, 0 },
/* U+569c */ { 0, 0, 0, 0, 0 },
/* U+569d */ { 0, 0, 0, 0, 0 },
/* U+569e */ { 0, 0, 0, 0, 0 },
/* U+569f */ { 0, 0, 0, 0, 0 },
/* U+56a0 */ { 0, 0, 0, 0, 0 },
/* U+56a1 */ { 0, 0, 0, 0, 0 },
/* U+56a2 */ { 0, 0, 0, 0, 0 },
/* U+56a3 */ { 0, 0, 0, 0, 0 },
/* U+56a4 */ { 0, 0, 0, 0, 0 },
/* U+56a5 */ { 0, 0, 0, 0, 0 },
/* U+56a6 */ { 0, 0, 0, 0, 0 },
/* U+56a7 */ { 0, 0, 0, 0, 0 },
/* U+56a8 */ { 0, 0, 0, 0, 0 },
/* U+56a9 */ { 0, 0, 0, 0, 0 },
/* U+56aa */ { 0, 0, 0, 0, 0 },
/* U+56ab */ { 0, 0, 0, 0, 0 },
/* U+56ac */ { 0, 0, 0, 0, 0 },
/* U+56ad */ { 0, 0, 0, 0, 0 },
/* U+56ae */ { 0, 0, 0, 0, 0 },
/* U+56af */ { 0, 0, 0, 0, 0 },
/* U+56b0 */ { 0, 0, 0, 0, 0 },
/* U+56b1 */ { 0, 0, 0, 0, 0 },
/* U+56b2 */ { 0, 0, 0, 0, 0 },
/* U+56b3 */ { 0, 0, 0, 0, 0 },
/* U+56b4 */ { 0, 0, 0, 0, 0 },
/* U+56b5 */ { 0, 0, 0, 0, 0 },
/* U+56b6 */ { 0, 0, 0, 0, 0 },
/* U+56b7 */ { 0, 0, 0, 0, 0 },
/* U+56b8 */ { 0, 0, 0, 0, 0 },
/* U+56b9 */ { 0, 0, 0, 0, 0 },
/* U+56ba */ { 0, 0, 0, 0, 0 },
/* U+56bb */ { 0, 0, 0, 0, 0 },
/* U+56bc */ { 0, 0, 0, 0, 0 },
/* U+56bd */ { 0, 0, 0, 0, 0 },
/* U+56be */ { 0, 0, 0, 0, 0 },
/* U+56bf */ { 0, 0, 0, 0, 0 },
/* U+56c0 */ { 0, 0, 0, 0, 0 },
/* U+56c1 */ { 0, 0, 0, 0, 0 },
/* U+56c2 */ { 0, 0, 0, 0, 0 },
/* U+56c3 */ { 0, 0, 0, 0, 0 },
/* U+56c4 */ { 0, 0, 0, 0, 0 },
/* U+56c5 */ { 0, 0, 0, 0, 0 },
/* U+56c6 */ { 0, 0, 0, 0, 0 },
/* U+56c7 */ { 0, 0, 0, 0, 0 },
/* U+56c8 */ { 0, 0, 0, 0, 0 },
/* U+56c9 */ { 0, 0, 0, 0, 0 },
/* U+56ca */ { 0, 0, 0, 0, 0 },
/* U+56cb */ { 0, 0, 0, 0, 0 },
/* U+56cc */ { 0, 0, 0, 0, 0 },
/* U+56cd */ { 0, 0, 0, 0, 0 },
/* U+56ce */ { 0, 0, 0, 0, 0 },
/* U+56cf */ { 0, 0, 0, 0, 0 },
/* U+56d0 */ { 0, 0, 0, 0, 0 },
/* U+56d1 */ { 0, 0, 0, 0, 0 },
/* U+56d2 */ { 0, 0, 0, 0, 0 },
/* U+56d3 */ { 0, 0, 0, 0, 0 },
/* U+56d4 */ { 0, 0, 0, 0, 0 },
/* U+56d5 */ { 0, 0, 0, 0, 0 },
/* U+56d6 */ { 0, 0, 0, 0, 0 },
/* U+56d7 */ { 0, 0, 0, 0, 0 },
/* U+56d8 */ { 0, 0, 0, 0, 0 },
/* U+56d9 */ { 0, 0, 0, 0, 0 },
/* U+56da */ { 0, 0, 0, 0, 0 },
/* U+56db */ { 0, 0, 0, 0, 0 },
/* U+56dc */ { 0, 0, 0, 0, 0 },
/* U+56dd */ { 0, 0, 0, 0, 0 },
/* U+56de */ { 0, 0, 0, 0, 0 },
/* U+56df */ { 0, 0, 0, 0, 0 },
/* U+56e0 */ { 0, 0, 0, 0, 0 },
/* U+56e1 */ { 0, 0, 0, 0, 0 },
/* U+56e2 */ { 0, 0, 0, 0, 0 },
/* U+56e3 */ { 0, 0, 0, 0, 0 },
/* U+56e4 */ { 0, 0, 0, 0, 0 },
/* U+56e5 */ { 0, 0, 0, 0, 0 },
/* U+56e6 */ { 0, 0, 0, 0, 0 },
/* U+56e7 */ { 0, 0, 0, 0, 0 },
/* U+56e8 */ { 0, 0, 0, 0, 0 },
/* U+56e9 */ { 0, 0, 0, 0, 0 },
/* U+56ea */ { 0, 0, 0, 0, 0 },
/* U+56eb */ { 0, 0, 0, 0, 0 },
/* U+56ec */ { 0, 0, 0, 0, 0 },
/* U+56ed */ { 0, 0, 0, 0, 0 },
/* U+56ee */ { 0, 0, 0, 0, 0 },
/* U+56ef */ { 0, 0, 0, 0, 0 },
/* U+56f0 */ { 0, 0, 0, 0, 0 },
/* U+56f1 */ { 0, 0, 0, 0, 0 },
/* U+56f2 */ { 0, 0, 0, 0, 0 },
/* U+56f3 */ { 0, 0, 0, 0, 0 },
/* U+56f4 */ { 0, 0, 0, 0, 0 },
/* U+56f5 */ { 0, 0, 0, 0, 0 },
/* U+56f6 */ { 0, 0, 0, 0, 0 },
/* U+56f7 */ { 0, 0, 0, 0, 0 },
/* U+56f8 */ { 0, 0, 0, 0, 0 },
/* U+56f9 */ { 0, 0, 0, 0, 0 },
/* U+56fa */ { 0, 0, 0, 0, 0 },
/* U+56fb */ { 0, 0, 0, 0, 0 },
/* U+56fc */ { 0, 0, 0, 0, 0 },
/* U+56fd */ { 0, 0, 0, 0, 0 },
/* U+56fe */ { 0, 0, 0, 0, 0 },
/* U+56ff */ { 0, 0, 0, 0, 0 },
/* U+5700 */ { 0, 0, 0, 0, 0 },
/* U+5701 */ { 0, 0, 0, 0, 0 },
/* U+5702 */ { 0, 0, 0, 0, 0 },
/* U+5703 */ { 0, 0, 0, 0, 0 },
/* U+5704 */ { 0, 0, 0, 0, 0 },
/* U+5705 */ { 0, 0, 0, 0, 0 },
/* U+5706 */ { 0, 0, 0, 0, 0 },
/* U+5707 */ { 0, 0, 0, 0, 0 },
/* U+5708 */ { 0, 0, 0, 0, 0 },
/* U+5709 */ { 0, 0, 0, 0, 0 },
/* U+570a */ { 0, 0, 0, 0, 0 },
/* U+570b */ { 0, 0, 0, 0, 0 },
/* U+570c */ { 0, 0, 0, 0, 0 },
/* U+570d */ { 0, 0, 0, 0, 0 },
/* U+570e */ { 0, 0, 0, 0, 0 },
/* U+570f */ { 0, 0, 0, 0, 0 },
/* U+5710 */ { 0, 0, 0, 0, 0 },
/* U+5711 */ { 0, 0, 0, 0, 0 },
/* U+5712 */ { 0, 0, 0, 0, 0 },
/* U+5713 */ { 0, 0, 0, 0, 0 },
/* U+5714 */ { 0, 0, 0, 0, 0 },
/* U+5715 */ { 0, 0, 0, 0, 0 },
/* U+5716 */ { 0, 0, 0, 0, 0 },
/* U+5717 */ { 0, 0, 0, 0, 0 },
/* U+5718 */ { 0, 0, 0, 0, 0 },
/* U+5719 */ { 0, 0, 0, 0, 0 },
/* U+571a */ { 0, 0, 0, 0, 0 },
/* U+571b */ { 0, 0, 0, 0, 0 },
/* U+571c */ { 0, 0, 0, 0, 0 },
/* U+571d */ { 0, 0, 0, 0, 0 },
/* U+571e */ { 0, 0, 0, 0, 0 },
/* U+571f */ { 0, 0, 0, 0, 0 },
/* U+5720 */ { 0, 0, 0, 0, 0 },
/* U+5721 */ { 0, 0, 0, 0, 0 },
/* U+5722 */ { 0, 0, 0, 0, 0 },
/* U+5723 */ { 0, 0, 0, 0, 0 },
/* U+5724 */ { 0, 0, 0, 0, 0 },
/* U+5725 */ { 0, 0, 0, 0, 0 },
/* U+5726 */ { 0, 0, 0, 0, 0 },
/* U+5727 */ { 0, 0, 0, 0, 0 },
/* U+5728 */ { 0, 0, 0, 0, 0 },
/* U+5729 */ { 0, 0, 0, 0, 0 },
/* U+572a */ { 0, 0, 0, 0, 0 },
/* U+572b */ { 0, 0, 0, 0, 0 },
/* U+572c */ { 0, 0, 0, 0, 0 },
/* U+572d */ { 0, 0, 0, 0, 0 },
/* U+572e */ { 0, 0, 0, 0, 0 },
/* U+572f */ { 0, 0, 0, 0, 0 },
/* U+5730 */ { 0, 0, 0, 0, 0 },
/* U+5731 */ { 0, 0, 0, 0, 0 },
/* U+5732 */ { 0, 0, 0, 0, 0 },
/* U+5733 */ { 0, 0, 0, 0, 0 },
/* U+5734 */ { 0, 0, 0, 0, 0 },
/* U+5735 */ { 0, 0, 0, 0, 0 },
/* U+5736 */ { 0, 0, 0, 0, 0 },
/* U+5737 */ { 0, 0, 0, 0, 0 },
/* U+5738 */ { 0, 0, 0, 0, 0 },
/* U+5739 */ { 0, 0, 0, 0, 0 },
/* U+573a */ { 0, 0, 0, 0, 0 },
/* U+573b */ { 0, 0, 0, 0, 0 },
/* U+573c */ { 0, 0, 0, 0, 0 },
/* U+573d */ { 0, 0, 0, 0, 0 },
/* U+573e */ { 0, 0, 0, 0, 0 },
/* U+573f */ { 0, 0, 0, 0, 0 },
/* U+5740 */ { 0, 0, 0, 0, 0 },
/* U+5741 */ { 0, 0, 0, 0, 0 },
/* U+5742 */ { 0, 0, 0, 0, 0 },
/* U+5743 */ { 0, 0, 0, 0, 0 },
/* U+5744 */ { 0, 0, 0, 0, 0 },
/* U+5745 */ { 0, 0, 0, 0, 0 },
/* U+5746 */ { 0, 0, 0, 0, 0 },
/* U+5747 */ { 0, 0, 0, 0, 0 },
/* U+5748 */ { 0, 0, 0, 0, 0 },
/* U+5749 */ { 0, 0, 0, 0, 0 },
/* U+574a */ { 0, 0, 0, 0, 0 },
/* U+574b */ { 0, 0, 0, 0, 0 },
/* U+574c */ { 0, 0, 0, 0, 0 },
/* U+574d */ { 0, 0, 0, 0, 0 },
/* U+574e */ { 0, 0, 0, 0, 0 },
/* U+574f */ { 0, 0, 0, 0, 0 },
/* U+5750 */ { 0, 0, 0, 0, 0 },
/* U+5751 */ { 0, 0, 0, 0, 0 },
/* U+5752 */ { 0, 0, 0, 0, 0 },
/* U+5753 */ { 0, 0, 0, 0, 0 },
/* U+5754 */ { 0, 0, 0, 0, 0 },
/* U+5755 */ { 0, 0, 0, 0, 0 },
/* U+5756 */ { 0, 0, 0, 0, 0 },
/* U+5757 */ { 0, 0, 0, 0, 0 },
/* U+5758 */ { 0, 0, 0, 0, 0 },
/* U+5759 */ { 0, 0, 0, 0, 0 },
/* U+575a */ { 0, 0, 0, 0, 0 },
/* U+575b */ { 0, 0, 0, 0, 0 },
/* U+575c */ { 0, 0, 0, 0, 0 },
/* U+575d */ { 0, 0, 0, 0, 0 },
/* U+575e */ { 0, 0, 0, 0, 0 },
/* U+575f */ { 0, 0, 0, 0, 0 },
/* U+5760 */ { 0, 0, 0, 0, 0 },
/* U+5761 */ { 0, 0, 0, 0, 0 },
/* U+5762 */ { 0, 0, 0, 0, 0 },
/* U+5763 */ { 0, 0, 0, 0, 0 },
/* U+5764 */ { 0, 0, 0, 0, 0 },
/* U+5765 */ { 0, 0, 0, 0, 0 },
/* U+5766 */ { 0, 0, 0, 0, 0 },
/* U+5767 */ { 0, 0, 0, 0, 0 },
/* U+5768 */ { 0, 0, 0, 0, 0 },
/* U+5769 */ { 0, 0, 0, 0, 0 },
/* U+576a */ { 0, 0, 0, 0, 0 },
/* U+576b */ { 0, 0, 0, 0, 0 },
/* U+576c */ { 0, 0, 0, 0, 0 },
/* U+576d */ { 0, 0, 0, 0, 0 },
/* U+576e */ { 0, 0, 0, 0, 0 },
/* U+576f */ { 0, 0, 0, 0, 0 },
/* U+5770 */ { 0, 0, 0, 0, 0 },
/* U+5771 */ { 0, 0, 0, 0, 0 },
/* U+5772 */ { 0, 0, 0, 0, 0 },
/* U+5773 */ { 0, 0, 0, 0, 0 },
/* U+5774 */ { 0, 0, 0, 0, 0 },
/* U+5775 */ { 0, 0, 0, 0, 0 },
/* U+5776 */ { 0, 0, 0, 0, 0 },
/* U+5777 */ { 0, 0, 0, 0, 0 },
/* U+5778 */ { 0, 0, 0, 0, 0 },
/* U+5779 */ { 0, 0, 0, 0, 0 },
/* U+577a */ { 0, 0, 0, 0, 0 },
/* U+577b */ { 0, 0, 0, 0, 0 },
/* U+577c */ { 0, 0, 0, 0, 0 },
/* U+577d */ { 0, 0, 0, 0, 0 },
/* U+577e */ { 0, 0, 0, 0, 0 },
/* U+577f */ { 0, 0, 0, 0, 0 },
/* U+5780 */ { 0, 0, 0, 0, 0 },
/* U+5781 */ { 0, 0, 0, 0, 0 },
/* U+5782 */ { 0, 0, 0, 0, 0 },
/* U+5783 */ { 0, 0, 0, 0, 0 },
/* U+5784 */ { 0, 0, 0, 0, 0 },
/* U+5785 */ { 0, 0, 0, 0, 0 },
/* U+5786 */ { 0, 0, 0, 0, 0 },
/* U+5787 */ { 0, 0, 0, 0, 0 },
/* U+5788 */ { 0, 0, 0, 0, 0 },
/* U+5789 */ { 0, 0, 0, 0, 0 },
/* U+578a */ { 0, 0, 0, 0, 0 },
/* U+578b */ { 0, 0, 0, 0, 0 },
/* U+578c */ { 0, 0, 0, 0, 0 },
/* U+578d */ { 0, 0, 0, 0, 0 },
/* U+578e */ { 0, 0, 0, 0, 0 },
/* U+578f */ { 0, 0, 0, 0, 0 },
/* U+5790 */ { 0, 0, 0, 0, 0 },
/* U+5791 */ { 0, 0, 0, 0, 0 },
/* U+5792 */ { 0, 0, 0, 0, 0 },
/* U+5793 */ { 0, 0, 0, 0, 0 },
/* U+5794 */ { 0, 0, 0, 0, 0 },
/* U+5795 */ { 0, 0, 0, 0, 0 },
/* U+5796 */ { 0, 0, 0, 0, 0 },
/* U+5797 */ { 0, 0, 0, 0, 0 },
/* U+5798 */ { 0, 0, 0, 0, 0 },
/* U+5799 */ { 0, 0, 0, 0, 0 },
/* U+579a */ { 0, 0, 0, 0, 0 },
/* U+579b */ { 0, 0, 0, 0, 0 },
/* U+579c */ { 0, 0, 0, 0, 0 },
/* U+579d */ { 0, 0, 0, 0, 0 },
/* U+579e */ { 0, 0, 0, 0, 0 },
/* U+579f */ { 0, 0, 0, 0, 0 },
/* U+57a0 */ { 0, 0, 0, 0, 0 },
/* U+57a1 */ { 0, 0, 0, 0, 0 },
/* U+57a2 */ { 0, 0, 0, 0, 0 },
/* U+57a3 */ { 0, 0, 0, 0, 0 },
/* U+57a4 */ { 0, 0, 0, 0, 0 },
/* U+57a5 */ { 0, 0, 0, 0, 0 },
/* U+57a6 */ { 0, 0, 0, 0, 0 },
/* U+57a7 */ { 0, 0, 0, 0, 0 },
/* U+57a8 */ { 0, 0, 0, 0, 0 },
/* U+57a9 */ { 0, 0, 0, 0, 0 },
/* U+57aa */ { 0, 0, 0, 0, 0 },
/* U+57ab */ { 0, 0, 0, 0, 0 },
/* U+57ac */ { 0, 0, 0, 0, 0 },
/* U+57ad */ { 0, 0, 0, 0, 0 },
/* U+57ae */ { 0, 0, 0, 0, 0 },
/* U+57af */ { 0, 0, 0, 0, 0 },
/* U+57b0 */ { 0, 0, 0, 0, 0 },
/* U+57b1 */ { 0, 0, 0, 0, 0 },
/* U+57b2 */ { 0, 0, 0, 0, 0 },
/* U+57b3 */ { 0, 0, 0, 0, 0 },
/* U+57b4 */ { 0, 0, 0, 0, 0 },
/* U+57b5 */ { 0, 0, 0, 0, 0 },
/* U+57b6 */ { 0, 0, 0, 0, 0 },
/* U+57b7 */ { 0, 0, 0, 0, 0 },
/* U+57b8 */ { 0, 0, 0, 0, 0 },
/* U+57b9 */ { 0, 0, 0, 0, 0 },
/* U+57ba */ { 0, 0, 0, 0, 0 },
/* U+57bb */ { 0, 0, 0, 0, 0 },
/* U+57bc */ { 0, 0, 0, 0, 0 },
/* U+57bd */ { 0, 0, 0, 0, 0 },
/* U+57be */ { 0, 0, 0, 0, 0 },
/* U+57bf */ { 0, 0, 0, 0, 0 },
/* U+57c0 */ { 0, 0, 0, 0, 0 },
/* U+57c1 */ { 0, 0, 0, 0, 0 },
/* U+57c2 */ { 0, 0, 0, 0, 0 },
/* U+57c3 */ { 0, 0, 0, 0, 0 },
/* U+57c4 */ { 0, 0, 0, 0, 0 },
/* U+57c5 */ { 0, 0, 0, 0, 0 },
/* U+57c6 */ { 0, 0, 0, 0, 0 },
/* U+57c7 */ { 0, 0, 0, 0, 0 },
/* U+57c8 */ { 0, 0, 0, 0, 0 },
/* U+57c9 */ { 0, 0, 0, 0, 0 },
/* U+57ca */ { 0, 0, 0, 0, 0 },
/* U+57cb */ { 0, 0, 0, 0, 0 },
/* U+57cc */ { 0, 0, 0, 0, 0 },
/* U+57cd */ { 0, 0, 0, 0, 0 },
/* U+57ce */ { 0, 0, 0, 0, 0 },
/* U+57cf */ { 0, 0, 0, 0, 0 },
/* U+57d0 */ { 0, 0, 0, 0, 0 },
/* U+57d1 */ { 0, 0, 0, 0, 0 },
/* U+57d2 */ { 0, 0, 0, 0, 0 },
/* U+57d3 */ { 0, 0, 0, 0, 0 },
/* U+57d4 */ { 0, 0, 0, 0, 0 },
/* U+57d5 */ { 0, 0, 0, 0, 0 },
/* U+57d6 */ { 0, 0, 0, 0, 0 },
/* U+57d7 */ { 0, 0, 0, 0, 0 },
/* U+57d8 */ { 0, 0, 0, 0, 0 },
/* U+57d9 */ { 0, 0, 0, 0, 0 },
/* U+57da */ { 0, 0, 0, 0, 0 },
/* U+57db */ { 0, 0, 0, 0, 0 },
/* U+57dc */ { 0, 0, 0, 0, 0 },
/* U+57dd */ { 0, 0, 0, 0, 0 },
/* U+57de */ { 0, 0, 0, 0, 0 },
/* U+57df */ { 0, 0, 0, 0, 0 },
/* U+57e0 */ { 0, 0, 0, 0, 0 },
/* U+57e1 */ { 0, 0, 0, 0, 0 },
/* U+57e2 */ { 0, 0, 0, 0, 0 },
/* U+57e3 */ { 0, 0, 0, 0, 0 },
/* U+57e4 */ { 0, 0, 0, 0, 0 },
/* U+57e5 */ { 0, 0, 0, 0, 0 },
/* U+57e6 */ { 0, 0, 0, 0, 0 },
/* U+57e7 */ { 0, 0, 0, 0, 0 },
/* U+57e8 */ { 0, 0, 0, 0, 0 },
/* U+57e9 */ { 0, 0, 0, 0, 0 },
/* U+57ea */ { 0, 0, 0, 0, 0 },
/* U+57eb */ { 0, 0, 0, 0, 0 },
/* U+57ec */ { 0, 0, 0, 0, 0 },
/* U+57ed */ { 0, 0, 0, 0, 0 },
/* U+57ee */ { 0, 0, 0, 0, 0 },
/* U+57ef */ { 0, 0, 0, 0, 0 },
/* U+57f0 */ { 0, 0, 0, 0, 0 },
/* U+57f1 */ { 0, 0, 0, 0, 0 },
/* U+57f2 */ { 0, 0, 0, 0, 0 },
/* U+57f3 */ { 0, 0, 0, 0, 0 },
/* U+57f4 */ { 0, 0, 0, 0, 0 },
/* U+57f5 */ { 0, 0, 0, 0, 0 },
/* U+57f6 */ { 0, 0, 0, 0, 0 },
/* U+57f7 */ { 0, 0, 0, 0, 0 },
/* U+57f8 */ { 0, 0, 0, 0, 0 },
/* U+57f9 */ { 0, 0, 0, 0, 0 },
/* U+57fa */ { 0, 0, 0, 0, 0 },
/* U+57fb */ { 0, 0, 0, 0, 0 },
/* U+57fc */ { 0, 0, 0, 0, 0 },
/* U+57fd */ { 0, 0, 0, 0, 0 },
/* U+57fe */ { 0, 0, 0, 0, 0 },
/* U+57ff */ { 0, 0, 0, 0, 0 },
/* U+5800 */ { 0, 0, 0, 0, 0 },
/* U+5801 */ { 0, 0, 0, 0, 0 },
/* U+5802 */ { 0, 0, 0, 0, 0 },
/* U+5803 */ { 0, 0, 0, 0, 0 },
/* U+5804 */ { 0, 0, 0, 0, 0 },
/* U+5805 */ { 0, 0, 0, 0, 0 },
/* U+5806 */ { 0, 0, 0, 0, 0 },
/* U+5807 */ { 0, 0, 0, 0, 0 },
/* U+5808 */ { 0, 0, 0, 0, 0 },
/* U+5809 */ { 0, 0, 0, 0, 0 },
/* U+580a */ { 0, 0, 0, 0, 0 },
/* U+580b */ { 0, 0, 0, 0, 0 },
/* U+580c */ { 0, 0, 0, 0, 0 },
/* U+580d */ { 0, 0, 0, 0, 0 },
/* U+580e */ { 0, 0, 0, 0, 0 },
/* U+580f */ { 0, 0, 0, 0, 0 },
/* U+5810 */ { 0, 0, 0, 0, 0 },
/* U+5811 */ { 0, 0, 0, 0, 0 },
/* U+5812 */ { 0, 0, 0, 0, 0 },
/* U+5813 */ { 0, 0, 0, 0, 0 },
/* U+5814 */ { 0, 0, 0, 0, 0 },
/* U+5815 */ { 0, 0, 0, 0, 0 },
/* U+5816 */ { 0, 0, 0, 0, 0 },
/* U+5817 */ { 0, 0, 0, 0, 0 },
/* U+5818 */ { 0, 0, 0, 0, 0 },
/* U+5819 */ { 0, 0, 0, 0, 0 },
/* U+581a */ { 0, 0, 0, 0, 0 },
/* U+581b */ { 0, 0, 0, 0, 0 },
/* U+581c */ { 0, 0, 0, 0, 0 },
/* U+581d */ { 0, 0, 0, 0, 0 },
/* U+581e */ { 0, 0, 0, 0, 0 },
/* U+581f */ { 0, 0, 0, 0, 0 },
/* U+5820 */ { 0, 0, 0, 0, 0 },
/* U+5821 */ { 0, 0, 0, 0, 0 },
/* U+5822 */ { 0, 0, 0, 0, 0 },
/* U+5823 */ { 0, 0, 0, 0, 0 },
/* U+5824 */ { 0, 0, 0, 0, 0 },
/* U+5825 */ { 0, 0, 0, 0, 0 },
/* U+5826 */ { 0, 0, 0, 0, 0 },
/* U+5827 */ { 0, 0, 0, 0, 0 },
/* U+5828 */ { 0, 0, 0, 0, 0 },
/* U+5829 */ { 0, 0, 0, 0, 0 },
/* U+582a */ { 0, 0, 0, 0, 0 },
/* U+582b */ { 0, 0, 0, 0, 0 },
/* U+582c */ { 0, 0, 0, 0, 0 },
/* U+582d */ { 0, 0, 0, 0, 0 },
/* U+582e */ { 0, 0, 0, 0, 0 },
/* U+582f */ { 0, 0, 0, 0, 0 },
/* U+5830 */ { 0, 0, 0, 0, 0 },
/* U+5831 */ { 0, 0, 0, 0, 0 },
/* U+5832 */ { 0, 0, 0, 0, 0 },
/* U+5833 */ { 0, 0, 0, 0, 0 },
/* U+5834 */ { 0, 0, 0, 0, 0 },
/* U+5835 */ { 0, 0, 0, 0, 0 },
/* U+5836 */ { 0, 0, 0, 0, 0 },
/* U+5837 */ { 0, 0, 0, 0, 0 },
/* U+5838 */ { 0, 0, 0, 0, 0 },
/* U+5839 */ { 0, 0, 0, 0, 0 },
/* U+583a */ { 0, 0, 0, 0, 0 },
/* U+583b */ { 0, 0, 0, 0, 0 },
/* U+583c */ { 0, 0, 0, 0, 0 },
/* U+583d */ { 0, 0, 0, 0, 0 },
/* U+583e */ { 0, 0, 0, 0, 0 },
/* U+583f */ { 0, 0, 0, 0, 0 },
/* U+5840 */ { 0, 0, 0, 0, 0 },
/* U+5841 */ { 0, 0, 0, 0, 0 },
/* U+5842 */ { 0, 0, 0, 0, 0 },
/* U+5843 */ { 0, 0, 0, 0, 0 },
/* U+5844 */ { 0, 0, 0, 0, 0 },
/* U+5845 */ { 0, 0, 0, 0, 0 },
/* U+5846 */ { 0, 0, 0, 0, 0 },
/* U+5847 */ { 0, 0, 0, 0, 0 },
/* U+5848 */ { 0, 0, 0, 0, 0 },
/* U+5849 */ { 0, 0, 0, 0, 0 },
/* U+584a */ { 0, 0, 0, 0, 0 },
/* U+584b */ { 0, 0, 0, 0, 0 },
/* U+584c */ { 0, 0, 0, 0, 0 },
/* U+584d */ { 0, 0, 0, 0, 0 },
/* U+584e */ { 0, 0, 0, 0, 0 },
/* U+584f */ { 0, 0, 0, 0, 0 },
/* U+5850 */ { 0, 0, 0, 0, 0 },
/* U+5851 */ { 0, 0, 0, 0, 0 },
/* U+5852 */ { 0, 0, 0, 0, 0 },
/* U+5853 */ { 0, 0, 0, 0, 0 },
/* U+5854 */ { 0, 0, 0, 0, 0 },
/* U+5855 */ { 0, 0, 0, 0, 0 },
/* U+5856 */ { 0, 0, 0, 0, 0 },
/* U+5857 */ { 0, 0, 0, 0, 0 },
/* U+5858 */ { 0, 0, 0, 0, 0 },
/* U+5859 */ { 0, 0, 0, 0, 0 },
/* U+585a */ { 0, 0, 0, 0, 0 },
/* U+585b */ { 0, 0, 0, 0, 0 },
/* U+585c */ { 0, 0, 0, 0, 0 },
/* U+585d */ { 0, 0, 0, 0, 0 },
/* U+585e */ { 0, 0, 0, 0, 0 },
/* U+585f */ { 0, 0, 0, 0, 0 },
/* U+5860 */ { 0, 0, 0, 0, 0 },
/* U+5861 */ { 0, 0, 0, 0, 0 },
/* U+5862 */ { 0, 0, 0, 0, 0 },
/* U+5863 */ { 0, 0, 0, 0, 0 },
/* U+5864 */ { 0, 0, 0, 0, 0 },
/* U+5865 */ { 0, 0, 0, 0, 0 },
/* U+5866 */ { 0, 0, 0, 0, 0 },
/* U+5867 */ { 0, 0, 0, 0, 0 },
/* U+5868 */ { 0, 0, 0, 0, 0 },
/* U+5869 */ { 0, 0, 0, 0, 0 },
/* U+586a */ { 0, 0, 0, 0, 0 },
/* U+586b */ { 0, 0, 0, 0, 0 },
/* U+586c */ { 0, 0, 0, 0, 0 },
/* U+586d */ { 0, 0, 0, 0, 0 },
/* U+586e */ { 0, 0, 0, 0, 0 },
/* U+586f */ { 0, 0, 0, 0, 0 },
/* U+5870 */ { 0, 0, 0, 0, 0 },
/* U+5871 */ { 0, 0, 0, 0, 0 },
/* U+5872 */ { 0, 0, 0, 0, 0 },
/* U+5873 */ { 0, 0, 0, 0, 0 },
/* U+5874 */ { 0, 0, 0, 0, 0 },
/* U+5875 */ { 0, 0, 0, 0, 0 },
/* U+5876 */ { 0, 0, 0, 0, 0 },
/* U+5877 */ { 0, 0, 0, 0, 0 },
/* U+5878 */ { 0, 0, 0, 0, 0 },
/* U+5879 */ { 0, 0, 0, 0, 0 },
/* U+587a */ { 0, 0, 0, 0, 0 },
/* U+587b */ { 0, 0, 0, 0, 0 },
/* U+587c */ { 0, 0, 0, 0, 0 },
/* U+587d */ { 0, 0, 0, 0, 0 },
/* U+587e */ { 0, 0, 0, 0, 0 },
/* U+587f */ { 0, 0, 0, 0, 0 },
/* U+5880 */ { 0, 0, 0, 0, 0 },
/* U+5881 */ { 0, 0, 0, 0, 0 },
/* U+5882 */ { 0, 0, 0, 0, 0 },
/* U+5883 */ { 0, 0, 0, 0, 0 },
/* U+5884 */ { 0, 0, 0, 0, 0 },
/* U+5885 */ { 0, 0, 0, 0, 0 },
/* U+5886 */ { 0, 0, 0, 0, 0 },
/* U+5887 */ { 0, 0, 0, 0, 0 },
/* U+5888 */ { 0, 0, 0, 0, 0 },
/* U+5889 */ { 0, 0, 0, 0, 0 },
/* U+588a */ { 0, 0, 0, 0, 0 },
/* U+588b */ { 0, 0, 0, 0, 0 },
/* U+588c */ { 0, 0, 0, 0, 0 },
/* U+588d */ { 0, 0, 0, 0, 0 },
/* U+588e */ { 0, 0, 0, 0, 0 },
/* U+588f */ { 0, 0, 0, 0, 0 },
/* U+5890 */ { 0, 0, 0, 0, 0 },
/* U+5891 */ { 0, 0, 0, 0, 0 },
/* U+5892 */ { 0, 0, 0, 0, 0 },
/* U+5893 */ { 0, 0, 0, 0, 0 },
/* U+5894 */ { 0, 0, 0, 0, 0 },
/* U+5895 */ { 0, 0, 0, 0, 0 },
/* U+5896 */ { 0, 0, 0, 0, 0 },
/* U+5897 */ { 0, 0, 0, 0, 0 },
/* U+5898 */ { 0, 0, 0, 0, 0 },
/* U+5899 */ { 0, 0, 0, 0, 0 },
/* U+589a */ { 0, 0, 0, 0, 0 },
/* U+589b */ { 0, 0, 0, 0, 0 },
/* U+589c */ { 0, 0, 0, 0, 0 },
/* U+589d */ { 0, 0, 0, 0, 0 },
/* U+589e */ { 0, 0, 0, 0, 0 },
/* U+589f */ { 0, 0, 0, 0, 0 },
/* U+58a0 */ { 0, 0, 0, 0, 0 },
/* U+58a1 */ { 0, 0, 0, 0, 0 },
/* U+58a2 */ { 0, 0, 0, 0, 0 },
/* U+58a3 */ { 0, 0, 0, 0, 0 },
/* U+58a4 */ { 0, 0, 0, 0, 0 },
/* U+58a5 */ { 0, 0, 0, 0, 0 },
/* U+58a6 */ { 0, 0, 0, 0, 0 },
/* U+58a7 */ { 0, 0, 0, 0, 0 },
/* U+58a8 */ { 0, 0, 0, 0, 0 },
/* U+58a9 */ { 0, 0, 0, 0, 0 },
/* U+58aa */ { 0, 0, 0, 0, 0 },
/* U+58ab */ { 0, 0, 0, 0, 0 },
/* U+58ac */ { 0, 0, 0, 0, 0 },
/* U+58ad */ { 0, 0, 0, 0, 0 },
/* U+58ae */ { 0, 0, 0, 0, 0 },
/* U+58af */ { 0, 0, 0, 0, 0 },
/* U+58b0 */ { 0, 0, 0, 0, 0 },
/* U+58b1 */ { 0, 0, 0, 0, 0 },
/* U+58b2 */ { 0, 0, 0, 0, 0 },
/* U+58b3 */ { 0, 0, 0, 0, 0 },
/* U+58b4 */ { 0, 0, 0, 0, 0 },
/* U+58b5 */ { 0, 0, 0, 0, 0 },
/* U+58b6 */ { 0, 0, 0, 0, 0 },
/* U+58b7 */ { 0, 0, 0, 0, 0 },
/* U+58b8 */ { 0, 0, 0, 0, 0 },
/* U+58b9 */ { 0, 0, 0, 0, 0 },
/* U+58ba */ { 0, 0, 0, 0, 0 },
/* U+58bb */ { 0, 0, 0, 0, 0 },
/* U+58bc */ { 0, 0, 0, 0, 0 },
/* U+58bd */ { 0, 0, 0, 0, 0 },
/* U+58be */ { 0, 0, 0, 0, 0 },
/* U+58bf */ { 0, 0, 0, 0, 0 },
/* U+58c0 */ { 0, 0, 0, 0, 0 },
/* U+58c1 */ { 0, 0, 0, 0, 0 },
/* U+58c2 */ { 0, 0, 0, 0, 0 },
/* U+58c3 */ { 0, 0, 0, 0, 0 },
/* U+58c4 */ { 0, 0, 0, 0, 0 },
/* U+58c5 */ { 0, 0, 0, 0, 0 },
/* U+58c6 */ { 0, 0, 0, 0, 0 },
/* U+58c7 */ { 0, 0, 0, 0, 0 },
/* U+58c8 */ { 0, 0, 0, 0, 0 },
/* U+58c9 */ { 0, 0, 0, 0, 0 },
/* U+58ca */ { 0, 0, 0, 0, 0 },
/* U+58cb */ { 0, 0, 0, 0, 0 },
/* U+58cc */ { 0, 0, 0, 0, 0 },
/* U+58cd */ { 0, 0, 0, 0, 0 },
/* U+58ce */ { 0, 0, 0, 0, 0 },
/* U+58cf */ { 0, 0, 0, 0, 0 },
/* U+58d0 */ { 0, 0, 0, 0, 0 },
/* U+58d1 */ { 0, 0, 0, 0, 0 },
/* U+58d2 */ { 0, 0, 0, 0, 0 },
/* U+58d3 */ { 0, 0, 0, 0, 0 },
/* U+58d4 */ { 0, 0, 0, 0, 0 },
/* U+58d5 */ { 0, 0, 0, 0, 0 },
/* U+58d6 */ { 0, 0, 0, 0, 0 },
/* U+58d7 */ { 0, 0, 0, 0, 0 },
/* U+58d8 */ { 0, 0, 0, 0, 0 },
/* U+58d9 */ { 0, 0, 0, 0, 0 },
/* U+58da */ { 0, 0, 0, 0, 0 },
/* U+58db */ { 0, 0, 0, 0, 0 },
/* U+58dc */ { 0, 0, 0, 0, 0 },
/* U+58dd */ { 0, 0, 0, 0, 0 },
/* U+58de */ { 0, 0, 0, 0, 0 },
/* U+58df */ { 0, 0, 0, 0, 0 },
/* U+58e0 */ { 0, 0, 0, 0, 0 },
/* U+58e1 */ { 0, 0, 0, 0, 0 },
/* U+58e2 */ { 0, 0, 0, 0, 0 },
/* U+58e3 */ { 0, 0, 0, 0, 0 },
/* U+58e4 */ { 0, 0, 0, 0, 0 },
/* U+58e5 */ { 0, 0, 0, 0, 0 },
/* U+58e6 */ { 0, 0, 0, 0, 0 },
/* U+58e7 */ { 0, 0, 0, 0, 0 },
/* U+58e8 */ { 0, 0, 0, 0, 0 },
/* U+58e9 */ { 0, 0, 0, 0, 0 },
/* U+58ea */ { 0, 0, 0, 0, 0 },
/* U+58eb */ { 0, 0, 0, 0, 0 },
/* U+58ec */ { 0, 0, 0, 0, 0 },
/* U+58ed */ { 0, 0, 0, 0, 0 },
/* U+58ee */ { 0, 0, 0, 0, 0 },
/* U+58ef */ { 0, 0, 0, 0, 0 },
/* U+58f0 */ { 0, 0, 0, 0, 0 },
/* U+58f1 */ { 0, 0, 0, 0, 0 },
/* U+58f2 */ { 0, 0, 0, 0, 0 },
/* U+58f3 */ { 0, 0, 0, 0, 0 },
/* U+58f4 */ { 0, 0, 0, 0, 0 },
/* U+58f5 */ { 0, 0, 0, 0, 0 },
/* U+58f6 */ { 0, 0, 0, 0, 0 },
/* U+58f7 */ { 0, 0, 0, 0, 0 },
/* U+58f8 */ { 0, 0, 0, 0, 0 },
/* U+58f9 */ { 0, 0, 0, 0, 0 },
/* U+58fa */ { 0, 0, 0, 0, 0 },
/* U+58fb */ { 0, 0, 0, 0, 0 },
/* U+58fc */ { 0, 0, 0, 0, 0 },
/* U+58fd */ { 0, 0, 0, 0, 0 },
/* U+58fe */ { 0, 0, 0, 0, 0 },
/* U+58ff */ { 0, 0, 0, 0, 0 },
/* U+5900 */ { 0, 0, 0, 0, 0 },
/* U+5901 */ { 0, 0, 0, 0, 0 },
/* U+5902 */ { 0, 0, 0, 0, 0 },
/* U+5903 */ { 0, 0, 0, 0, 0 },
/* U+5904 */ { 0, 0, 0, 0, 0 },
/* U+5905 */ { 0, 0, 0, 0, 0 },
/* U+5906 */ { 0, 0, 0, 0, 0 },
/* U+5907 */ { 0, 0, 0, 0, 0 },
/* U+5908 */ { 0, 0, 0, 0, 0 },
/* U+5909 */ { 0, 0, 0, 0, 0 },
/* U+590a */ { 0, 0, 0, 0, 0 },
/* U+590b */ { 0, 0, 0, 0, 0 },
/* U+590c */ { 0, 0, 0, 0, 0 },
/* U+590d */ { 0, 0, 0, 0, 0 },
/* U+590e */ { 0, 0, 0, 0, 0 },
/* U+590f */ { 0, 0, 0, 0, 0 },
/* U+5910 */ { 0, 0, 0, 0, 0 },
/* U+5911 */ { 0, 0, 0, 0, 0 },
/* U+5912 */ { 0, 0, 0, 0, 0 },
/* U+5913 */ { 0, 0, 0, 0, 0 },
/* U+5914 */ { 0, 0, 0, 0, 0 },
/* U+5915 */ { 0, 0, 0, 0, 0 },
/* U+5916 */ { 0, 0, 0, 0, 0 },
/* U+5917 */ { 0, 0, 0, 0, 0 },
/* U+5918 */ { 0, 0, 0, 0, 0 },
/* U+5919 */ { 0, 0, 0, 0, 0 },
/* U+591a */ { 0, 0, 0, 0, 0 },
/* U+591b */ { 0, 0, 0, 0, 0 },
/* U+591c */ { 0, 0, 0, 0, 0 },
/* U+591d */ { 0, 0, 0, 0, 0 },
/* U+591e */ { 0, 0, 0, 0, 0 },
/* U+591f */ { 0, 0, 0, 0, 0 },
/* U+5920 */ { 0, 0, 0, 0, 0 },
/* U+5921 */ { 0, 0, 0, 0, 0 },
/* U+5922 */ { 0, 0, 0, 0, 0 },
/* U+5923 */ { 0, 0, 0, 0, 0 },
/* U+5924 */ { 0, 0, 0, 0, 0 },
/* U+5925 */ { 0, 0, 0, 0, 0 },
/* U+5926 */ { 0, 0, 0, 0, 0 },
/* U+5927 */ { 0, 0, 0, 0, 0 },
/* U+5928 */ { 0, 0, 0, 0, 0 },
/* U+5929 */ { 0, 0, 0, 0, 0 },
/* U+592a */ { 0, 0, 0, 0, 0 },
/* U+592b */ { 0, 0, 0, 0, 0 },
/* U+592c */ { 0, 0, 0, 0, 0 },
/* U+592d */ { 0, 0, 0, 0, 0 },
/* U+592e */ { 0, 0, 0, 0, 0 },
/* U+592f */ { 0, 0, 0, 0, 0 },
/* U+5930 */ { 0, 0, 0, 0, 0 },
/* U+5931 */ { 0, 0, 0, 0, 0 },
/* U+5932 */ { 0, 0, 0, 0, 0 },
/* U+5933 */ { 0, 0, 0, 0, 0 },
/* U+5934 */ { 0, 0, 0, 0, 0 },
/* U+5935 */ { 0, 0, 0, 0, 0 },
/* U+5936 */ { 0, 0, 0, 0, 0 },
/* U+5937 */ { 0, 0, 0, 0, 0 },
/* U+5938 */ { 0, 0, 0, 0, 0 },
/* U+5939 */ { 0, 0, 0, 0, 0 },
/* U+593a */ { 0, 0, 0, 0, 0 },
/* U+593b */ { 0, 0, 0, 0, 0 },
/* U+593c */ { 0, 0, 0, 0, 0 },
/* U+593d */ { 0, 0, 0, 0, 0 },
/* U+593e */ { 0, 0, 0, 0, 0 },
/* U+593f */ { 0, 0, 0, 0, 0 },
/* U+5940 */ { 0, 0, 0, 0, 0 },
/* U+5941 */ { 0, 0, 0, 0, 0 },
/* U+5942 */ { 0, 0, 0, 0, 0 },
/* U+5943 */ { 0, 0, 0, 0, 0 },
/* U+5944 */ { 0, 0, 0, 0, 0 },
/* U+5945 */ { 0, 0, 0, 0, 0 },
/* U+5946 */ { 0, 0, 0, 0, 0 },
/* U+5947 */ { 0, 0, 0, 0, 0 },
/* U+5948 */ { 0, 0, 0, 0, 0 },
/* U+5949 */ { 0, 0, 0, 0, 0 },
/* U+594a */ { 0, 0, 0, 0, 0 },
/* U+594b */ { 0, 0, 0, 0, 0 },
/* U+594c */ { 0, 0, 0, 0, 0 },
/* U+594d */ { 0, 0, 0, 0, 0 },
/* U+594e */ { 0, 0, 0, 0, 0 },
/* U+594f */ { 0, 0, 0, 0, 0 },
/* U+5950 */ { 0, 0, 0, 0, 0 },
/* U+5951 */ { 0, 0, 0, 0, 0 },
/* U+5952 */ { 0, 0, 0, 0, 0 },
/* U+5953 */ { 0, 0, 0, 0, 0 },
/* U+5954 */ { 0, 0, 0, 0, 0 },
/* U+5955 */ { 0, 0, 0, 0, 0 },
/* U+5956 */ { 0, 0, 0, 0, 0 },
/* U+5957 */ { 0, 0, 0, 0, 0 },
/* U+5958 */ { 0, 0, 0, 0, 0 },
/* U+5959 */ { 0, 0, 0, 0, 0 },
/* U+595a */ { 0, 0, 0, 0, 0 },
/* U+595b */ { 0, 0, 0, 0, 0 },
/* U+595c */ { 0, 0, 0, 0, 0 },
/* U+595d */ { 0, 0, 0, 0, 0 },
/* U+595e */ { 0, 0, 0, 0, 0 },
/* U+595f */ { 0, 0, 0, 0, 0 },
/* U+5960 */ { 0, 0, 0, 0, 0 },
/* U+5961 */ { 0, 0, 0, 0, 0 },
/* U+5962 */ { 0, 0, 0, 0, 0 },
/* U+5963 */ { 0, 0, 0, 0, 0 },
/* U+5964 */ { 0, 0, 0, 0, 0 },
/* U+5965 */ { 0, 0, 0, 0, 0 },
/* U+5966 */ { 0, 0, 0, 0, 0 },
/* U+5967 */ { 0, 0, 0, 0, 0 },
/* U+5968 */ { 0, 0, 0, 0, 0 },
/* U+5969 */ { 0, 0, 0, 0, 0 },
/* U+596a */ { 0, 0, 0, 0, 0 },
/* U+596b */ { 0, 0, 0, 0, 0 },
/* U+596c */ { 0, 0, 0, 0, 0 },
/* U+596d */ { 0, 0, 0, 0, 0 },
/* U+596e */ { 0, 0, 0, 0, 0 },
/* U+596f */ { 0, 0, 0, 0, 0 },
/* U+5970 */ { 0, 0, 0, 0, 0 },
/* U+5971 */ { 0, 0, 0, 0, 0 },
/* U+5972 */ { 0, 0, 0, 0, 0 },
/* U+5973 */ { 0, 0, 0, 0, 0 },
/* U+5974 */ { 0, 0, 0, 0, 0 },
/* U+5975 */ { 0, 0, 0, 0, 0 },
/* U+5976 */ { 0, 0, 0, 0, 0 },
/* U+5977 */ { 0, 0, 0, 0, 0 },
/* U+5978 */ { 0, 0, 0, 0, 0 },
/* U+5979 */ { 0, 0, 0, 0, 0 },
/* U+597a */ { 0, 0, 0, 0, 0 },
/* U+597b */ { 0, 0, 0, 0, 0 },
/* U+597c */ { 0, 0, 0, 0, 0 },
/* U+597d */ { 0, 0, 0, 0, 0 },
/* U+597e */ { 0, 0, 0, 0, 0 },
/* U+597f */ { 0, 0, 0, 0, 0 },
/* U+5980 */ { 0, 0, 0, 0, 0 },
/* U+5981 */ { 0, 0, 0, 0, 0 },
/* U+5982 */ { 0, 0, 0, 0, 0 },
/* U+5983 */ { 0, 0, 0, 0, 0 },
/* U+5984 */ { 0, 0, 0, 0, 0 },
/* U+5985 */ { 0, 0, 0, 0, 0 },
/* U+5986 */ { 0, 0, 0, 0, 0 },
/* U+5987 */ { 0, 0, 0, 0, 0 },
/* U+5988 */ { 0, 0, 0, 0, 0 },
/* U+5989 */ { 0, 0, 0, 0, 0 },
/* U+598a */ { 0, 0, 0, 0, 0 },
/* U+598b */ { 0, 0, 0, 0, 0 },
/* U+598c */ { 0, 0, 0, 0, 0 },
/* U+598d */ { 0, 0, 0, 0, 0 },
/* U+598e */ { 0, 0, 0, 0, 0 },
/* U+598f */ { 0, 0, 0, 0, 0 },
/* U+5990 */ { 0, 0, 0, 0, 0 },
/* U+5991 */ { 0, 0, 0, 0, 0 },
/* U+5992 */ { 0, 0, 0, 0, 0 },
/* U+5993 */ { 0, 0, 0, 0, 0 },
/* U+5994 */ { 0, 0, 0, 0, 0 },
/* U+5995 */ { 0, 0, 0, 0, 0 },
/* U+5996 */ { 0, 0, 0, 0, 0 },
/* U+5997 */ { 0, 0, 0, 0, 0 },
/* U+5998 */ { 0, 0, 0, 0, 0 },
/* U+5999 */ { 0, 0, 0, 0, 0 },
/* U+599a */ { 0, 0, 0, 0, 0 },
/* U+599b */ { 0, 0, 0, 0, 0 },
/* U+599c */ { 0, 0, 0, 0, 0 },
/* U+599d */ { 0, 0, 0, 0, 0 },
/* U+599e */ { 0, 0, 0, 0, 0 },
/* U+599f */ { 0, 0, 0, 0, 0 },
/* U+59a0 */ { 0, 0, 0, 0, 0 },
/* U+59a1 */ { 0, 0, 0, 0, 0 },
/* U+59a2 */ { 0, 0, 0, 0, 0 },
/* U+59a3 */ { 0, 0, 0, 0, 0 },
/* U+59a4 */ { 0, 0, 0, 0, 0 },
/* U+59a5 */ { 0, 0, 0, 0, 0 },
/* U+59a6 */ { 0, 0, 0, 0, 0 },
/* U+59a7 */ { 0, 0, 0, 0, 0 },
/* U+59a8 */ { 0, 0, 0, 0, 0 },
/* U+59a9 */ { 0, 0, 0, 0, 0 },
/* U+59aa */ { 0, 0, 0, 0, 0 },
/* U+59ab */ { 0, 0, 0, 0, 0 },
/* U+59ac */ { 0, 0, 0, 0, 0 },
/* U+59ad */ { 0, 0, 0, 0, 0 },
/* U+59ae */ { 0, 0, 0, 0, 0 },
/* U+59af */ { 0, 0, 0, 0, 0 },
/* U+59b0 */ { 0, 0, 0, 0, 0 },
/* U+59b1 */ { 0, 0, 0, 0, 0 },
/* U+59b2 */ { 0, 0, 0, 0, 0 },
/* U+59b3 */ { 0, 0, 0, 0, 0 },
/* U+59b4 */ { 0, 0, 0, 0, 0 },
/* U+59b5 */ { 0, 0, 0, 0, 0 },
/* U+59b6 */ { 0, 0, 0, 0, 0 },
/* U+59b7 */ { 0, 0, 0, 0, 0 },
/* U+59b8 */ { 0, 0, 0, 0, 0 },
/* U+59b9 */ { 0, 0, 0, 0, 0 },
/* U+59ba */ { 0, 0, 0, 0, 0 },
/* U+59bb */ { 0, 0, 0, 0, 0 },
/* U+59bc */ { 0, 0, 0, 0, 0 },
/* U+59bd */ { 0, 0, 0, 0, 0 },
/* U+59be */ { 0, 0, 0, 0, 0 },
/* U+59bf */ { 0, 0, 0, 0, 0 },
/* U+59c0 */ { 0, 0, 0, 0, 0 },
/* U+59c1 */ { 0, 0, 0, 0, 0 },
/* U+59c2 */ { 0, 0, 0, 0, 0 },
/* U+59c3 */ { 0, 0, 0, 0, 0 },
/* U+59c4 */ { 0, 0, 0, 0, 0 },
/* U+59c5 */ { 0, 0, 0, 0, 0 },
/* U+59c6 */ { 0, 0, 0, 0, 0 },
/* U+59c7 */ { 0, 0, 0, 0, 0 },
/* U+59c8 */ { 0, 0, 0, 0, 0 },
/* U+59c9 */ { 0, 0, 0, 0, 0 },
/* U+59ca */ { 0, 0, 0, 0, 0 },
/* U+59cb */ { 0, 0, 0, 0, 0 },
/* U+59cc */ { 0, 0, 0, 0, 0 },
/* U+59cd */ { 0, 0, 0, 0, 0 },
/* U+59ce */ { 0, 0, 0, 0, 0 },
/* U+59cf */ { 0, 0, 0, 0, 0 },
/* U+59d0 */ { 0, 0, 0, 0, 0 },
/* U+59d1 */ { 0, 0, 0, 0, 0 },
/* U+59d2 */ { 0, 0, 0, 0, 0 },
/* U+59d3 */ { 0, 0, 0, 0, 0 },
/* U+59d4 */ { 0, 0, 0, 0, 0 },
/* U+59d5 */ { 0, 0, 0, 0, 0 },
/* U+59d6 */ { 0, 0, 0, 0, 0 },
/* U+59d7 */ { 0, 0, 0, 0, 0 },
/* U+59d8 */ { 0, 0, 0, 0, 0 },
/* U+59d9 */ { 0, 0, 0, 0, 0 },
/* U+59da */ { 0, 0, 0, 0, 0 },
/* U+59db */ { 0, 0, 0, 0, 0 },
/* U+59dc */ { 0, 0, 0, 0, 0 },
/* U+59dd */ { 0, 0, 0, 0, 0 },
/* U+59de */ { 0, 0, 0, 0, 0 },
/* U+59df */ { 0, 0, 0, 0, 0 },
/* U+59e0 */ { 0, 0, 0, 0, 0 },
/* U+59e1 */ { 0, 0, 0, 0, 0 },
/* U+59e2 */ { 0, 0, 0, 0, 0 },
/* U+59e3 */ { 0, 0, 0, 0, 0 },
/* U+59e4 */ { 0, 0, 0, 0, 0 },
/* U+59e5 */ { 0, 0, 0, 0, 0 },
/* U+59e6 */ { 0, 0, 0, 0, 0 },
/* U+59e7 */ { 0, 0, 0, 0, 0 },
/* U+59e8 */ { 0, 0, 0, 0, 0 },
/* U+59e9 */ { 0, 0, 0, 0, 0 },
/* U+59ea */ { 0, 0, 0, 0, 0 },
/* U+59eb */ { 0, 0, 0, 0, 0 },
/* U+59ec */ { 0, 0, 0, 0, 0 },
/* U+59ed */ { 0, 0, 0, 0, 0 },
/* U+59ee */ { 0, 0, 0, 0, 0 },
/* U+59ef */ { 0, 0, 0, 0, 0 },
/* U+59f0 */ { 0, 0, 0, 0, 0 },
/* U+59f1 */ { 0, 0, 0, 0, 0 },
/* U+59f2 */ { 0, 0, 0, 0, 0 },
/* U+59f3 */ { 0, 0, 0, 0, 0 },
/* U+59f4 */ { 0, 0, 0, 0, 0 },
/* U+59f5 */ { 0, 0, 0, 0, 0 },
/* U+59f6 */ { 0, 0, 0, 0, 0 },
/* U+59f7 */ { 0, 0, 0, 0, 0 },
/* U+59f8 */ { 0, 0, 0, 0, 0 },
/* U+59f9 */ { 0, 0, 0, 0, 0 },
/* U+59fa */ { 0, 0, 0, 0, 0 },
/* U+59fb */ { 0, 0, 0, 0, 0 },
/* U+59fc */ { 0, 0, 0, 0, 0 },
/* U+59fd */ { 0, 0, 0, 0, 0 },
/* U+59fe */ { 0, 0, 0, 0, 0 },
/* U+59ff */ { 0, 0, 0, 0, 0 },
/* U+5a00 */ { 0, 0, 0, 0, 0 },
/* U+5a01 */ { 0, 0, 0, 0, 0 },
/* U+5a02 */ { 0, 0, 0, 0, 0 },
/* U+5a03 */ { 0, 0, 0, 0, 0 },
/* U+5a04 */ { 0, 0, 0, 0, 0 },
/* U+5a05 */ { 0, 0, 0, 0, 0 },
/* U+5a06 */ { 0, 0, 0, 0, 0 },
/* U+5a07 */ { 0, 0, 0, 0, 0 },
/* U+5a08 */ { 0, 0, 0, 0, 0 },
/* U+5a09 */ { 0, 0, 0, 0, 0 },
/* U+5a0a */ { 0, 0, 0, 0, 0 },
/* U+5a0b */ { 0, 0, 0, 0, 0 },
/* U+5a0c */ { 0, 0, 0, 0, 0 },
/* U+5a0d */ { 0, 0, 0, 0, 0 },
/* U+5a0e */ { 0, 0, 0, 0, 0 },
/* U+5a0f */ { 0, 0, 0, 0, 0 },
/* U+5a10 */ { 0, 0, 0, 0, 0 },
/* U+5a11 */ { 0, 0, 0, 0, 0 },
/* U+5a12 */ { 0, 0, 0, 0, 0 },
/* U+5a13 */ { 0, 0, 0, 0, 0 },
/* U+5a14 */ { 0, 0, 0, 0, 0 },
/* U+5a15 */ { 0, 0, 0, 0, 0 },
/* U+5a16 */ { 0, 0, 0, 0, 0 },
/* U+5a17 */ { 0, 0, 0, 0, 0 },
/* U+5a18 */ { 0, 0, 0, 0, 0 },
/* U+5a19 */ { 0, 0, 0, 0, 0 },
/* U+5a1a */ { 0, 0, 0, 0, 0 },
/* U+5a1b */ { 0, 0, 0, 0, 0 },
/* U+5a1c */ { 0, 0, 0, 0, 0 },
/* U+5a1d */ { 0, 0, 0, 0, 0 },
/* U+5a1e */ { 0, 0, 0, 0, 0 },
/* U+5a1f */ { 0, 0, 0, 0, 0 },
/* U+5a20 */ { 0, 0, 0, 0, 0 },
/* U+5a21 */ { 0, 0, 0, 0, 0 },
/* U+5a22 */ { 0, 0, 0, 0, 0 },
/* U+5a23 */ { 0, 0, 0, 0, 0 },
/* U+5a24 */ { 0, 0, 0, 0, 0 },
/* U+5a25 */ { 0, 0, 0, 0, 0 },
/* U+5a26 */ { 0, 0, 0, 0, 0 },
/* U+5a27 */ { 0, 0, 0, 0, 0 },
/* U+5a28 */ { 0, 0, 0, 0, 0 },
/* U+5a29 */ { 0, 0, 0, 0, 0 },
/* U+5a2a */ { 0, 0, 0, 0, 0 },
/* U+5a2b */ { 0, 0, 0, 0, 0 },
/* U+5a2c */ { 0, 0, 0, 0, 0 },
/* U+5a2d */ { 0, 0, 0, 0, 0 },
/* U+5a2e */ { 0, 0, 0, 0, 0 },
/* U+5a2f */ { 0, 0, 0, 0, 0 },
/* U+5a30 */ { 0, 0, 0, 0, 0 },
/* U+5a31 */ { 0, 0, 0, 0, 0 },
/* U+5a32 */ { 0, 0, 0, 0, 0 },
/* U+5a33 */ { 0, 0, 0, 0, 0 },
/* U+5a34 */ { 0, 0, 0, 0, 0 },
/* U+5a35 */ { 0, 0, 0, 0, 0 },
/* U+5a36 */ { 0, 0, 0, 0, 0 },
/* U+5a37 */ { 0, 0, 0, 0, 0 },
/* U+5a38 */ { 0, 0, 0, 0, 0 },
/* U+5a39 */ { 0, 0, 0, 0, 0 },
/* U+5a3a */ { 0, 0, 0, 0, 0 },
/* U+5a3b */ { 0, 0, 0, 0, 0 },
/* U+5a3c */ { 0, 0, 0, 0, 0 },
/* U+5a3d */ { 0, 0, 0, 0, 0 },
/* U+5a3e */ { 0, 0, 0, 0, 0 },
/* U+5a3f */ { 0, 0, 0, 0, 0 },
/* U+5a40 */ { 0, 0, 0, 0, 0 },
/* U+5a41 */ { 0, 0, 0, 0, 0 },
/* U+5a42 */ { 0, 0, 0, 0, 0 },
/* U+5a43 */ { 0, 0, 0, 0, 0 },
/* U+5a44 */ { 0, 0, 0, 0, 0 },
/* U+5a45 */ { 0, 0, 0, 0, 0 },
/* U+5a46 */ { 0, 0, 0, 0, 0 },
/* U+5a47 */ { 0, 0, 0, 0, 0 },
/* U+5a48 */ { 0, 0, 0, 0, 0 },
/* U+5a49 */ { 0, 0, 0, 0, 0 },
/* U+5a4a */ { 0, 0, 0, 0, 0 },
/* U+5a4b */ { 0, 0, 0, 0, 0 },
/* U+5a4c */ { 0, 0, 0, 0, 0 },
/* U+5a4d */ { 0, 0, 0, 0, 0 },
/* U+5a4e */ { 0, 0, 0, 0, 0 },
/* U+5a4f */ { 0, 0, 0, 0, 0 },
/* U+5a50 */ { 0, 0, 0, 0, 0 },
/* U+5a51 */ { 0, 0, 0, 0, 0 },
/* U+5a52 */ { 0, 0, 0, 0, 0 },
/* U+5a53 */ { 0, 0, 0, 0, 0 },
/* U+5a54 */ { 0, 0, 0, 0, 0 },
/* U+5a55 */ { 0, 0, 0, 0, 0 },
/* U+5a56 */ { 0, 0, 0, 0, 0 },
/* U+5a57 */ { 0, 0, 0, 0, 0 },
/* U+5a58 */ { 0, 0, 0, 0, 0 },
/* U+5a59 */ { 0, 0, 0, 0, 0 },
/* U+5a5a */ { 0, 0, 0, 0, 0 },
/* U+5a5b */ { 0, 0, 0, 0, 0 },
/* U+5a5c */ { 0, 0, 0, 0, 0 },
/* U+5a5d */ { 0, 0, 0, 0, 0 },
/* U+5a5e */ { 0, 0, 0, 0, 0 },
/* U+5a5f */ { 0, 0, 0, 0, 0 },
/* U+5a60 */ { 0, 0, 0, 0, 0 },
/* U+5a61 */ { 0, 0, 0, 0, 0 },
/* U+5a62 */ { 0, 0, 0, 0, 0 },
/* U+5a63 */ { 0, 0, 0, 0, 0 },
/* U+5a64 */ { 0, 0, 0, 0, 0 },
/* U+5a65 */ { 0, 0, 0, 0, 0 },
/* U+5a66 */ { 0, 0, 0, 0, 0 },
/* U+5a67 */ { 0, 0, 0, 0, 0 },
/* U+5a68 */ { 0, 0, 0, 0, 0 },
/* U+5a69 */ { 0, 0, 0, 0, 0 },
/* U+5a6a */ { 0, 0, 0, 0, 0 },
/* U+5a6b */ { 0, 0, 0, 0, 0 },
/* U+5a6c */ { 0, 0, 0, 0, 0 },
/* U+5a6d */ { 0, 0, 0, 0, 0 },
/* U+5a6e */ { 0, 0, 0, 0, 0 },
/* U+5a6f */ { 0, 0, 0, 0, 0 },
/* U+5a70 */ { 0, 0, 0, 0, 0 },
/* U+5a71 */ { 0, 0, 0, 0, 0 },
/* U+5a72 */ { 0, 0, 0, 0, 0 },
/* U+5a73 */ { 0, 0, 0, 0, 0 },
/* U+5a74 */ { 0, 0, 0, 0, 0 },
/* U+5a75 */ { 0, 0, 0, 0, 0 },
/* U+5a76 */ { 0, 0, 0, 0, 0 },
/* U+5a77 */ { 0, 0, 0, 0, 0 },
/* U+5a78 */ { 0, 0, 0, 0, 0 },
/* U+5a79 */ { 0, 0, 0, 0, 0 },
/* U+5a7a */ { 0, 0, 0, 0, 0 },
/* U+5a7b */ { 0, 0, 0, 0, 0 },
/* U+5a7c */ { 0, 0, 0, 0, 0 },
/* U+5a7d */ { 0, 0, 0, 0, 0 },
/* U+5a7e */ { 0, 0, 0, 0, 0 },
/* U+5a7f */ { 0, 0, 0, 0, 0 },
/* U+5a80 */ { 0, 0, 0, 0, 0 },
/* U+5a81 */ { 0, 0, 0, 0, 0 },
/* U+5a82 */ { 0, 0, 0, 0, 0 },
/* U+5a83 */ { 0, 0, 0, 0, 0 },
/* U+5a84 */ { 0, 0, 0, 0, 0 },
/* U+5a85 */ { 0, 0, 0, 0, 0 },
/* U+5a86 */ { 0, 0, 0, 0, 0 },
/* U+5a87 */ { 0, 0, 0, 0, 0 },
/* U+5a88 */ { 0, 0, 0, 0, 0 },
/* U+5a89 */ { 0, 0, 0, 0, 0 },
/* U+5a8a */ { 0, 0, 0, 0, 0 },
/* U+5a8b */ { 0, 0, 0, 0, 0 },
/* U+5a8c */ { 0, 0, 0, 0, 0 },
/* U+5a8d */ { 0, 0, 0, 0, 0 },
/* U+5a8e */ { 0, 0, 0, 0, 0 },
/* U+5a8f */ { 0, 0, 0, 0, 0 },
/* U+5a90 */ { 0, 0, 0, 0, 0 },
/* U+5a91 */ { 0, 0, 0, 0, 0 },
/* U+5a92 */ { 0, 0, 0, 0, 0 },
/* U+5a93 */ { 0, 0, 0, 0, 0 },
/* U+5a94 */ { 0, 0, 0, 0, 0 },
/* U+5a95 */ { 0, 0, 0, 0, 0 },
/* U+5a96 */ { 0, 0, 0, 0, 0 },
/* U+5a97 */ { 0, 0, 0, 0, 0 },
/* U+5a98 */ { 0, 0, 0, 0, 0 },
/* U+5a99 */ { 0, 0, 0, 0, 0 },
/* U+5a9a */ { 0, 0, 0, 0, 0 },
/* U+5a9b */ { 0, 0, 0, 0, 0 },
/* U+5a9c */ { 0, 0, 0, 0, 0 },
/* U+5a9d */ { 0, 0, 0, 0, 0 },
/* U+5a9e */ { 0, 0, 0, 0, 0 },
/* U+5a9f */ { 0, 0, 0, 0, 0 },
/* U+5aa0 */ { 0, 0, 0, 0, 0 },
/* U+5aa1 */ { 0, 0, 0, 0, 0 },
/* U+5aa2 */ { 0, 0, 0, 0, 0 },
/* U+5aa3 */ { 0, 0, 0, 0, 0 },
/* U+5aa4 */ { 0, 0, 0, 0, 0 },
/* U+5aa5 */ { 0, 0, 0, 0, 0 },
/* U+5aa6 */ { 0, 0, 0, 0, 0 },
/* U+5aa7 */ { 0, 0, 0, 0, 0 },
/* U+5aa8 */ { 0, 0, 0, 0, 0 },
/* U+5aa9 */ { 0, 0, 0, 0, 0 },
/* U+5aaa */ { 0, 0, 0, 0, 0 },
/* U+5aab */ { 0, 0, 0, 0, 0 },
/* U+5aac */ { 0, 0, 0, 0, 0 },
/* U+5aad */ { 0, 0, 0, 0, 0 },
/* U+5aae */ { 0, 0, 0, 0, 0 },
/* U+5aaf */ { 0, 0, 0, 0, 0 },
/* U+5ab0 */ { 0, 0, 0, 0, 0 },
/* U+5ab1 */ { 0, 0, 0, 0, 0 },
/* U+5ab2 */ { 0, 0, 0, 0, 0 },
/* U+5ab3 */ { 0, 0, 0, 0, 0 },
/* U+5ab4 */ { 0, 0, 0, 0, 0 },
/* U+5ab5 */ { 0, 0, 0, 0, 0 },
/* U+5ab6 */ { 0, 0, 0, 0, 0 },
/* U+5ab7 */ { 0, 0, 0, 0, 0 },
/* U+5ab8 */ { 0, 0, 0, 0, 0 },
/* U+5ab9 */ { 0, 0, 0, 0, 0 },
/* U+5aba */ { 0, 0, 0, 0, 0 },
/* U+5abb */ { 0, 0, 0, 0, 0 },
/* U+5abc */ { 0, 0, 0, 0, 0 },
/* U+5abd */ { 0, 0, 0, 0, 0 },
/* U+5abe */ { 0, 0, 0, 0, 0 },
/* U+5abf */ { 0, 0, 0, 0, 0 },
/* U+5ac0 */ { 0, 0, 0, 0, 0 },
/* U+5ac1 */ { 0, 0, 0, 0, 0 },
/* U+5ac2 */ { 0, 0, 0, 0, 0 },
/* U+5ac3 */ { 0, 0, 0, 0, 0 },
/* U+5ac4 */ { 0, 0, 0, 0, 0 },
/* U+5ac5 */ { 0, 0, 0, 0, 0 },
/* U+5ac6 */ { 0, 0, 0, 0, 0 },
/* U+5ac7 */ { 0, 0, 0, 0, 0 },
/* U+5ac8 */ { 0, 0, 0, 0, 0 },
/* U+5ac9 */ { 0, 0, 0, 0, 0 },
/* U+5aca */ { 0, 0, 0, 0, 0 },
/* U+5acb */ { 0, 0, 0, 0, 0 },
/* U+5acc */ { 0, 0, 0, 0, 0 },
/* U+5acd */ { 0, 0, 0, 0, 0 },
/* U+5ace */ { 0, 0, 0, 0, 0 },
/* U+5acf */ { 0, 0, 0, 0, 0 },
/* U+5ad0 */ { 0, 0, 0, 0, 0 },
/* U+5ad1 */ { 0, 0, 0, 0, 0 },
/* U+5ad2 */ { 0, 0, 0, 0, 0 },
/* U+5ad3 */ { 0, 0, 0, 0, 0 },
/* U+5ad4 */ { 0, 0, 0, 0, 0 },
/* U+5ad5 */ { 0, 0, 0, 0, 0 },
/* U+5ad6 */ { 0, 0, 0, 0, 0 },
/* U+5ad7 */ { 0, 0, 0, 0, 0 },
/* U+5ad8 */ { 0, 0, 0, 0, 0 },
/* U+5ad9 */ { 0, 0, 0, 0, 0 },
/* U+5ada */ { 0, 0, 0, 0, 0 },
/* U+5adb */ { 0, 0, 0, 0, 0 },
/* U+5adc */ { 0, 0, 0, 0, 0 },
/* U+5add */ { 0, 0, 0, 0, 0 },
/* U+5ade */ { 0, 0, 0, 0, 0 },
/* U+5adf */ { 0, 0, 0, 0, 0 },
/* U+5ae0 */ { 0, 0, 0, 0, 0 },
/* U+5ae1 */ { 0, 0, 0, 0, 0 },
/* U+5ae2 */ { 0, 0, 0, 0, 0 },
/* U+5ae3 */ { 0, 0, 0, 0, 0 },
/* U+5ae4 */ { 0, 0, 0, 0, 0 },
/* U+5ae5 */ { 0, 0, 0, 0, 0 },
/* U+5ae6 */ { 0, 0, 0, 0, 0 },
/* U+5ae7 */ { 0, 0, 0, 0, 0 },
/* U+5ae8 */ { 0, 0, 0, 0, 0 },
/* U+5ae9 */ { 0, 0, 0, 0, 0 },
/* U+5aea */ { 0, 0, 0, 0, 0 },
/* U+5aeb */ { 0, 0, 0, 0, 0 },
/* U+5aec */ { 0, 0, 0, 0, 0 },
/* U+5aed */ { 0, 0, 0, 0, 0 },
/* U+5aee */ { 0, 0, 0, 0, 0 },
/* U+5aef */ { 0, 0, 0, 0, 0 },
/* U+5af0 */ { 0, 0, 0, 0, 0 },
/* U+5af1 */ { 0, 0, 0, 0, 0 },
/* U+5af2 */ { 0, 0, 0, 0, 0 },
/* U+5af3 */ { 0, 0, 0, 0, 0 },
/* U+5af4 */ { 0, 0, 0, 0, 0 },
/* U+5af5 */ { 0, 0, 0, 0, 0 },
/* U+5af6 */ { 0, 0, 0, 0, 0 },
/* U+5af7 */ { 0, 0, 0, 0, 0 },
/* U+5af8 */ { 0, 0, 0, 0, 0 },
/* U+5af9 */ { 0, 0, 0, 0, 0 },
/* U+5afa */ { 0, 0, 0, 0, 0 },
/* U+5afb */ { 0, 0, 0, 0, 0 },
/* U+5afc */ { 0, 0, 0, 0, 0 },
/* U+5afd */ { 0, 0, 0, 0, 0 },
/* U+5afe */ { 0, 0, 0, 0, 0 },
/* U+5aff */ { 0, 0, 0, 0, 0 },
/* U+5b00 */ { 0, 0, 0, 0, 0 },
/* U+5b01 */ { 0, 0, 0, 0, 0 },
/* U+5b02 */ { 0, 0, 0, 0, 0 },
/* U+5b03 */ { 0, 0, 0, 0, 0 },
/* U+5b04 */ { 0, 0, 0, 0, 0 },
/* U+5b05 */ { 0, 0, 0, 0, 0 },
/* U+5b06 */ { 0, 0, 0, 0, 0 },
/* U+5b07 */ { 0, 0, 0, 0, 0 },
/* U+5b08 */ { 0, 0, 0, 0, 0 },
/* U+5b09 */ { 0, 0, 0, 0, 0 },
/* U+5b0a */ { 0, 0, 0, 0, 0 },
/* U+5b0b */ { 0, 0, 0, 0, 0 },
/* U+5b0c */ { 0, 0, 0, 0, 0 },
/* U+5b0d */ { 0, 0, 0, 0, 0 },
/* U+5b0e */ { 0, 0, 0, 0, 0 },
/* U+5b0f */ { 0, 0, 0, 0, 0 },
/* U+5b10 */ { 0, 0, 0, 0, 0 },
/* U+5b11 */ { 0, 0, 0, 0, 0 },
/* U+5b12 */ { 0, 0, 0, 0, 0 },
/* U+5b13 */ { 0, 0, 0, 0, 0 },
/* U+5b14 */ { 0, 0, 0, 0, 0 },
/* U+5b15 */ { 0, 0, 0, 0, 0 },
/* U+5b16 */ { 0, 0, 0, 0, 0 },
/* U+5b17 */ { 0, 0, 0, 0, 0 },
/* U+5b18 */ { 0, 0, 0, 0, 0 },
/* U+5b19 */ { 0, 0, 0, 0, 0 },
/* U+5b1a */ { 0, 0, 0, 0, 0 },
/* U+5b1b */ { 0, 0, 0, 0, 0 },
/* U+5b1c */ { 0, 0, 0, 0, 0 },
/* U+5b1d */ { 0, 0, 0, 0, 0 },
/* U+5b1e */ { 0, 0, 0, 0, 0 },
/* U+5b1f */ { 0, 0, 0, 0, 0 },
/* U+5b20 */ { 0, 0, 0, 0, 0 },
/* U+5b21 */ { 0, 0, 0, 0, 0 },
/* U+5b22 */ { 0, 0, 0, 0, 0 },
/* U+5b23 */ { 0, 0, 0, 0, 0 },
/* U+5b24 */ { 0, 0, 0, 0, 0 },
/* U+5b25 */ { 0, 0, 0, 0, 0 },
/* U+5b26 */ { 0, 0, 0, 0, 0 },
/* U+5b27 */ { 0, 0, 0, 0, 0 },
/* U+5b28 */ { 0, 0, 0, 0, 0 },
/* U+5b29 */ { 0, 0, 0, 0, 0 },
/* U+5b2a */ { 0, 0, 0, 0, 0 },
/* U+5b2b */ { 0, 0, 0, 0, 0 },
/* U+5b2c */ { 0, 0, 0, 0, 0 },
/* U+5b2d */ { 0, 0, 0, 0, 0 },
/* U+5b2e */ { 0, 0, 0, 0, 0 },
/* U+5b2f */ { 0, 0, 0, 0, 0 },
/* U+5b30 */ { 0, 0, 0, 0, 0 },
/* U+5b31 */ { 0, 0, 0, 0, 0 },
/* U+5b32 */ { 0, 0, 0, 0, 0 },
/* U+5b33 */ { 0, 0, 0, 0, 0 },
/* U+5b34 */ { 0, 0, 0, 0, 0 },
/* U+5b35 */ { 0, 0, 0, 0, 0 },
/* U+5b36 */ { 0, 0, 0, 0, 0 },
/* U+5b37 */ { 0, 0, 0, 0, 0 },
/* U+5b38 */ { 0, 0, 0, 0, 0 },
/* U+5b39 */ { 0, 0, 0, 0, 0 },
/* U+5b3a */ { 0, 0, 0, 0, 0 },
/* U+5b3b */ { 0, 0, 0, 0, 0 },
/* U+5b3c */ { 0, 0, 0, 0, 0 },
/* U+5b3d */ { 0, 0, 0, 0, 0 },
/* U+5b3e */ { 0, 0, 0, 0, 0 },
/* U+5b3f */ { 0, 0, 0, 0, 0 },
/* U+5b40 */ { 0, 0, 0, 0, 0 },
/* U+5b41 */ { 0, 0, 0, 0, 0 },
/* U+5b42 */ { 0, 0, 0, 0, 0 },
/* U+5b43 */ { 0, 0, 0, 0, 0 },
/* U+5b44 */ { 0, 0, 0, 0, 0 },
/* U+5b45 */ { 0, 0, 0, 0, 0 },
/* U+5b46 */ { 0, 0, 0, 0, 0 },
/* U+5b47 */ { 0, 0, 0, 0, 0 },
/* U+5b48 */ { 0, 0, 0, 0, 0 },
/* U+5b49 */ { 0, 0, 0, 0, 0 },
/* U+5b4a */ { 0, 0, 0, 0, 0 },
/* U+5b4b */ { 0, 0, 0, 0, 0 },
/* U+5b4c */ { 0, 0, 0, 0, 0 },
/* U+5b4d */ { 0, 0, 0, 0, 0 },
/* U+5b4e */ { 0, 0, 0, 0, 0 },
/* U+5b4f */ { 0, 0, 0, 0, 0 },
/* U+5b50 */ { 0, 0, 0, 0, 0 },
/* U+5b51 */ { 0, 0, 0, 0, 0 },
/* U+5b52 */ { 0, 0, 0, 0, 0 },
/* U+5b53 */ { 0, 0, 0, 0, 0 },
/* U+5b54 */ { 0, 0, 0, 0, 0 },
/* U+5b55 */ { 0, 0, 0, 0, 0 },
/* U+5b56 */ { 0, 0, 0, 0, 0 },
/* U+5b57 */ { 0, 0, 0, 0, 0 },
/* U+5b58 */ { 0, 0, 0, 0, 0 },
/* U+5b59 */ { 0, 0, 0, 0, 0 },
/* U+5b5a */ { 0, 0, 0, 0, 0 },
/* U+5b5b */ { 0, 0, 0, 0, 0 },
/* U+5b5c */ { 0, 0, 0, 0, 0 },
/* U+5b5d */ { 0, 0, 0, 0, 0 },
/* U+5b5e */ { 0, 0, 0, 0, 0 },
/* U+5b5f */ { 0, 0, 0, 0, 0 },
/* U+5b60 */ { 0, 0, 0, 0, 0 },
/* U+5b61 */ { 0, 0, 0, 0, 0 },
/* U+5b62 */ { 0, 0, 0, 0, 0 },
/* U+5b63 */ { 0, 0, 0, 0, 0 },
/* U+5b64 */ { 0, 0, 0, 0, 0 },
/* U+5b65 */ { 0, 0, 0, 0, 0 },
/* U+5b66 */ { 0, 0, 0, 0, 0 },
/* U+5b67 */ { 0, 0, 0, 0, 0 },
/* U+5b68 */ { 0, 0, 0, 0, 0 },
/* U+5b69 */ { 0, 0, 0, 0, 0 },
/* U+5b6a */ { 0, 0, 0, 0, 0 },
/* U+5b6b */ { 0, 0, 0, 0, 0 },
/* U+5b6c */ { 0, 0, 0, 0, 0 },
/* U+5b6d */ { 0, 0, 0, 0, 0 },
/* U+5b6e */ { 0, 0, 0, 0, 0 },
/* U+5b6f */ { 0, 0, 0, 0, 0 },
/* U+5b70 */ { 0, 0, 0, 0, 0 },
/* U+5b71 */ { 0, 0, 0, 0, 0 },
/* U+5b72 */ { 0, 0, 0, 0, 0 },
/* U+5b73 */ { 0, 0, 0, 0, 0 },
/* U+5b74 */ { 0, 0, 0, 0, 0 },
/* U+5b75 */ { 0, 0, 0, 0, 0 },
/* U+5b76 */ { 0, 0, 0, 0, 0 },
/* U+5b77 */ { 0, 0, 0, 0, 0 },
/* U+5b78 */ { 0, 0, 0, 0, 0 },
/* U+5b79 */ { 0, 0, 0, 0, 0 },
/* U+5b7a */ { 0, 0, 0, 0, 0 },
/* U+5b7b */ { 0, 0, 0, 0, 0 },
/* U+5b7c */ { 0, 0, 0, 0, 0 },
/* U+5b7d */ { 0, 0, 0, 0, 0 },
/* U+5b7e */ { 0, 0, 0, 0, 0 },
/* U+5b7f */ { 0, 0, 0, 0, 0 },
/* U+5b80 */ { 0, 0, 0, 0, 0 },
/* U+5b81 */ { 0, 0, 0, 0, 0 },
/* U+5b82 */ { 0, 0, 0, 0, 0 },
/* U+5b83 */ { 0, 0, 0, 0, 0 },
/* U+5b84 */ { 0, 0, 0, 0, 0 },
/* U+5b85 */ { 0, 0, 0, 0, 0 },
/* U+5b86 */ { 0, 0, 0, 0, 0 },
/* U+5b87 */ { 0, 0, 0, 0, 0 },
/* U+5b88 */ { 0, 0, 0, 0, 0 },
/* U+5b89 */ { 0, 0, 0, 0, 0 },
/* U+5b8a */ { 0, 0, 0, 0, 0 },
/* U+5b8b */ { 0, 0, 0, 0, 0 },
/* U+5b8c */ { 0, 0, 0, 0, 0 },
/* U+5b8d */ { 0, 0, 0, 0, 0 },
/* U+5b8e */ { 0, 0, 0, 0, 0 },
/* U+5b8f */ { 0, 0, 0, 0, 0 },
/* U+5b90 */ { 0, 0, 0, 0, 0 },
/* U+5b91 */ { 0, 0, 0, 0, 0 },
/* U+5b92 */ { 0, 0, 0, 0, 0 },
/* U+5b93 */ { 0, 0, 0, 0, 0 },
/* U+5b94 */ { 0, 0, 0, 0, 0 },
/* U+5b95 */ { 0, 0, 0, 0, 0 },
/* U+5b96 */ { 0, 0, 0, 0, 0 },
/* U+5b97 */ { 0, 0, 0, 0, 0 },
/* U+5b98 */ { 0, 0, 0, 0, 0 },
/* U+5b99 */ { 0, 0, 0, 0, 0 },
/* U+5b9a */ { 0, 0, 0, 0, 0 },
/* U+5b9b */ { 0, 0, 0, 0, 0 },
/* U+5b9c */ { 0, 0, 0, 0, 0 },
/* U+5b9d */ { 0, 0, 0, 0, 0 },
/* U+5b9e */ { 0, 0, 0, 0, 0 },
/* U+5b9f */ { 0, 0, 0, 0, 0 },
/* U+5ba0 */ { 0, 0, 0, 0, 0 },
/* U+5ba1 */ { 0, 0, 0, 0, 0 },
/* U+5ba2 */ { 0, 0, 0, 0, 0 },
/* U+5ba3 */ { 0, 0, 0, 0, 0 },
/* U+5ba4 */ { 0, 0, 0, 0, 0 },
/* U+5ba5 */ { 0, 0, 0, 0, 0 },
/* U+5ba6 */ { 0, 0, 0, 0, 0 },
/* U+5ba7 */ { 0, 0, 0, 0, 0 },
/* U+5ba8 */ { 0, 0, 0, 0, 0 },
/* U+5ba9 */ { 0, 0, 0, 0, 0 },
/* U+5baa */ { 0, 0, 0, 0, 0 },
/* U+5bab */ { 0, 0, 0, 0, 0 },
/* U+5bac */ { 0, 0, 0, 0, 0 },
/* U+5bad */ { 0, 0, 0, 0, 0 },
/* U+5bae */ { 0, 0, 0, 0, 0 },
/* U+5baf */ { 0, 0, 0, 0, 0 },
/* U+5bb0 */ { 0, 0, 0, 0, 0 },
/* U+5bb1 */ { 0, 0, 0, 0, 0 },
/* U+5bb2 */ { 0, 0, 0, 0, 0 },
/* U+5bb3 */ { 0, 0, 0, 0, 0 },
/* U+5bb4 */ { 0, 0, 0, 0, 0 },
/* U+5bb5 */ { 0, 0, 0, 0, 0 },
/* U+5bb6 */ { 0, 0, 0, 0, 0 },
/* U+5bb7 */ { 0, 0, 0, 0, 0 },
/* U+5bb8 */ { 0, 0, 0, 0, 0 },
/* U+5bb9 */ { 0, 0, 0, 0, 0 },
/* U+5bba */ { 0, 0, 0, 0, 0 },
/* U+5bbb */ { 0, 0, 0, 0, 0 },
/* U+5bbc */ { 0, 0, 0, 0, 0 },
/* U+5bbd */ { 0, 0, 0, 0, 0 },
/* U+5bbe */ { 0, 0, 0, 0, 0 },
/* U+5bbf */ { 0, 0, 0, 0, 0 },
/* U+5bc0 */ { 0, 0, 0, 0, 0 },
/* U+5bc1 */ { 0, 0, 0, 0, 0 },
/* U+5bc2 */ { 0, 0, 0, 0, 0 },
/* U+5bc3 */ { 0, 0, 0, 0, 0 },
/* U+5bc4 */ { 0, 0, 0, 0, 0 },
/* U+5bc5 */ { 0, 0, 0, 0, 0 },
/* U+5bc6 */ { 0, 0, 0, 0, 0 },
/* U+5bc7 */ { 0, 0, 0, 0, 0 },
/* U+5bc8 */ { 0, 0, 0, 0, 0 },
/* U+5bc9 */ { 0, 0, 0, 0, 0 },
/* U+5bca */ { 0, 0, 0, 0, 0 },
/* U+5bcb */ { 0, 0, 0, 0, 0 },
/* U+5bcc */ { 0, 0, 0, 0, 0 },
/* U+5bcd */ { 0, 0, 0, 0, 0 },
/* U+5bce */ { 0, 0, 0, 0, 0 },
/* U+5bcf */ { 0, 0, 0, 0, 0 },
/* U+5bd0 */ { 0, 0, 0, 0, 0 },
/* U+5bd1 */ { 0, 0, 0, 0, 0 },
/* U+5bd2 */ { 0, 0, 0, 0, 0 },
/* U+5bd3 */ { 0, 0, 0, 0, 0 },
/* U+5bd4 */ { 0, 0, 0, 0, 0 },
/* U+5bd5 */ { 0, 0, 0, 0, 0 },
/* U+5bd6 */ { 0, 0, 0, 0, 0 },
/* U+5bd7 */ { 0, 0, 0, 0, 0 },
/* U+5bd8 */ { 0, 0, 0, 0, 0 },
/* U+5bd9 */ { 0, 0, 0, 0, 0 },
/* U+5bda */ { 0, 0, 0, 0, 0 },
/* U+5bdb */ { 0, 0, 0, 0, 0 },
/* U+5bdc */ { 0, 0, 0, 0, 0 },
/* U+5bdd */ { 0, 0, 0, 0, 0 },
/* U+5bde */ { 0, 0, 0, 0, 0 },
/* U+5bdf */ { 0, 0, 0, 0, 0 },
/* U+5be0 */ { 0, 0, 0, 0, 0 },
/* U+5be1 */ { 0, 0, 0, 0, 0 },
/* U+5be2 */ { 0, 0, 0, 0, 0 },
/* U+5be3 */ { 0, 0, 0, 0, 0 },
/* U+5be4 */ { 0, 0, 0, 0, 0 },
/* U+5be5 */ { 0, 0, 0, 0, 0 },
/* U+5be6 */ { 0, 0, 0, 0, 0 },
/* U+5be7 */ { 0, 0, 0, 0, 0 },
/* U+5be8 */ { 0, 0, 0, 0, 0 },
/* U+5be9 */ { 0, 0, 0, 0, 0 },
/* U+5bea */ { 0, 0, 0, 0, 0 },
/* U+5beb */ { 0, 0, 0, 0, 0 },
/* U+5bec */ { 0, 0, 0, 0, 0 },
/* U+5bed */ { 0, 0, 0, 0, 0 },
/* U+5bee */ { 0, 0, 0, 0, 0 },
/* U+5bef */ { 0, 0, 0, 0, 0 },
/* U+5bf0 */ { 0, 0, 0, 0, 0 },
/* U+5bf1 */ { 0, 0, 0, 0, 0 },
/* U+5bf2 */ { 0, 0, 0, 0, 0 },
/* U+5bf3 */ { 0, 0, 0, 0, 0 },
/* U+5bf4 */ { 0, 0, 0, 0, 0 },
/* U+5bf5 */ { 0, 0, 0, 0, 0 },
/* U+5bf6 */ { 0, 0, 0, 0, 0 },
/* U+5bf7 */ { 0, 0, 0, 0, 0 },
/* U+5bf8 */ { 0, 0, 0, 0, 0 },
/* U+5bf9 */ { 0, 0, 0, 0, 0 },
/* U+5bfa */ { 0, 0, 0, 0, 0 },
/* U+5bfb */ { 0, 0, 0, 0, 0 },
/* U+5bfc */ { 0, 0, 0, 0, 0 },
/* U+5bfd */ { 0, 0, 0, 0, 0 },
/* U+5bfe */ { 0, 0, 0, 0, 0 },
/* U+5bff */ { 0, 0, 0, 0, 0 },
/* U+5c00 */ { 0, 0, 0, 0, 0 },
/* U+5c01 */ { 0, 0, 0, 0, 0 },
/* U+5c02 */ { 0, 0, 0, 0, 0 },
/* U+5c03 */ { 0, 0, 0, 0, 0 },
/* U+5c04 */ { 0, 0, 0, 0, 0 },
/* U+5c05 */ { 0, 0, 0, 0, 0 },
/* U+5c06 */ { 0, 0, 0, 0, 0 },
/* U+5c07 */ { 0, 0, 0, 0, 0 },
/* U+5c08 */ { 0, 0, 0, 0, 0 },
/* U+5c09 */ { 0, 0, 0, 0, 0 },
/* U+5c0a */ { 0, 0, 0, 0, 0 },
/* U+5c0b */ { 0, 0, 0, 0, 0 },
/* U+5c0c */ { 0, 0, 0, 0, 0 },
/* U+5c0d */ { 0, 0, 0, 0, 0 },
/* U+5c0e */ { 0, 0, 0, 0, 0 },
/* U+5c0f */ { 0, 0, 0, 0, 0 },
/* U+5c10 */ { 0, 0, 0, 0, 0 },
/* U+5c11 */ { 0, 0, 0, 0, 0 },
/* U+5c12 */ { 0, 0, 0, 0, 0 },
/* U+5c13 */ { 0, 0, 0, 0, 0 },
/* U+5c14 */ { 0, 0, 0, 0, 0 },
/* U+5c15 */ { 0, 0, 0, 0, 0 },
/* U+5c16 */ { 0, 0, 0, 0, 0 },
/* U+5c17 */ { 0, 0, 0, 0, 0 },
/* U+5c18 */ { 0, 0, 0, 0, 0 },
/* U+5c19 */ { 0, 0, 0, 0, 0 },
/* U+5c1a */ { 0, 0, 0, 0, 0 },
/* U+5c1b */ { 0, 0, 0, 0, 0 },
/* U+5c1c */ { 0, 0, 0, 0, 0 },
/* U+5c1d */ { 0, 0, 0, 0, 0 },
/* U+5c1e */ { 0, 0, 0, 0, 0 },
/* U+5c1f */ { 0, 0, 0, 0, 0 },
/* U+5c20 */ { 0, 0, 0, 0, 0 },
/* U+5c21 */ { 0, 0, 0, 0, 0 },
/* U+5c22 */ { 0, 0, 0, 0, 0 },
/* U+5c23 */ { 0, 0, 0, 0, 0 },
/* U+5c24 */ { 0, 0, 0, 0, 0 },
/* U+5c25 */ { 0, 0, 0, 0, 0 },
/* U+5c26 */ { 0, 0, 0, 0, 0 },
/* U+5c27 */ { 0, 0, 0, 0, 0 },
/* U+5c28 */ { 0, 0, 0, 0, 0 },
/* U+5c29 */ { 0, 0, 0, 0, 0 },
/* U+5c2a */ { 0, 0, 0, 0, 0 },
/* U+5c2b */ { 0, 0, 0, 0, 0 },
/* U+5c2c */ { 0, 0, 0, 0, 0 },
/* U+5c2d */ { 0, 0, 0, 0, 0 },
/* U+5c2e */ { 0, 0, 0, 0, 0 },
/* U+5c2f */ { 0, 0, 0, 0, 0 },
/* U+5c30 */ { 0, 0, 0, 0, 0 },
/* U+5c31 */ { 0, 0, 0, 0, 0 },
/* U+5c32 */ { 0, 0, 0, 0, 0 },
/* U+5c33 */ { 0, 0, 0, 0, 0 },
/* U+5c34 */ { 0, 0, 0, 0, 0 },
/* U+5c35 */ { 0, 0, 0, 0, 0 },
/* U+5c36 */ { 0, 0, 0, 0, 0 },
/* U+5c37 */ { 0, 0, 0, 0, 0 },
/* U+5c38 */ { 0, 0, 0, 0, 0 },
/* U+5c39 */ { 0, 0, 0, 0, 0 },
/* U+5c3a */ { 0, 0, 0, 0, 0 },
/* U+5c3b */ { 0, 0, 0, 0, 0 },
/* U+5c3c */ { 0, 0, 0, 0, 0 },
/* U+5c3d */ { 0, 0, 0, 0, 0 },
/* U+5c3e */ { 0, 0, 0, 0, 0 },
/* U+5c3f */ { 0, 0, 0, 0, 0 },
/* U+5c40 */ { 0, 0, 0, 0, 0 },
/* U+5c41 */ { 0, 0, 0, 0, 0 },
/* U+5c42 */ { 0, 0, 0, 0, 0 },
/* U+5c43 */ { 0, 0, 0, 0, 0 },
/* U+5c44 */ { 0, 0, 0, 0, 0 },
/* U+5c45 */ { 0, 0, 0, 0, 0 },
/* U+5c46 */ { 0, 0, 0, 0, 0 },
/* U+5c47 */ { 0, 0, 0, 0, 0 },
/* U+5c48 */ { 0, 0, 0, 0, 0 },
/* U+5c49 */ { 0, 0, 0, 0, 0 },
/* U+5c4a */ { 0, 0, 0, 0, 0 },
/* U+5c4b */ { 0, 0, 0, 0, 0 },
/* U+5c4c */ { 0, 0, 0, 0, 0 },
/* U+5c4d */ { 0, 0, 0, 0, 0 },
/* U+5c4e */ { 0, 0, 0, 0, 0 },
/* U+5c4f */ { 0, 0, 0, 0, 0 },
/* U+5c50 */ { 0, 0, 0, 0, 0 },
/* U+5c51 */ { 0, 0, 0, 0, 0 },
/* U+5c52 */ { 0, 0, 0, 0, 0 },
/* U+5c53 */ { 0, 0, 0, 0, 0 },
/* U+5c54 */ { 0, 0, 0, 0, 0 },
/* U+5c55 */ { 0, 0, 0, 0, 0 },
/* U+5c56 */ { 0, 0, 0, 0, 0 },
/* U+5c57 */ { 0, 0, 0, 0, 0 },
/* U+5c58 */ { 0, 0, 0, 0, 0 },
/* U+5c59 */ { 0, 0, 0, 0, 0 },
/* U+5c5a */ { 0, 0, 0, 0, 0 },
/* U+5c5b */ { 0, 0, 0, 0, 0 },
/* U+5c5c */ { 0, 0, 0, 0, 0 },
/* U+5c5d */ { 0, 0, 0, 0, 0 },
/* U+5c5e */ { 0, 0, 0, 0, 0 },
/* U+5c5f */ { 0, 0, 0, 0, 0 },
/* U+5c60 */ { 0, 0, 0, 0, 0 },
/* U+5c61 */ { 0, 0, 0, 0, 0 },
/* U+5c62 */ { 0, 0, 0, 0, 0 },
/* U+5c63 */ { 0, 0, 0, 0, 0 },
/* U+5c64 */ { 0, 0, 0, 0, 0 },
/* U+5c65 */ { 0, 0, 0, 0, 0 },
/* U+5c66 */ { 0, 0, 0, 0, 0 },
/* U+5c67 */ { 0, 0, 0, 0, 0 },
/* U+5c68 */ { 0, 0, 0, 0, 0 },
/* U+5c69 */ { 0, 0, 0, 0, 0 },
/* U+5c6a */ { 0, 0, 0, 0, 0 },
/* U+5c6b */ { 0, 0, 0, 0, 0 },
/* U+5c6c */ { 0, 0, 0, 0, 0 },
/* U+5c6d */ { 0, 0, 0, 0, 0 },
/* U+5c6e */ { 0, 0, 0, 0, 0 },
/* U+5c6f */ { 0, 0, 0, 0, 0 },
/* U+5c70 */ { 0, 0, 0, 0, 0 },
/* U+5c71 */ { 0, 0, 0, 0, 0 },
/* U+5c72 */ { 0, 0, 0, 0, 0 },
/* U+5c73 */ { 0, 0, 0, 0, 0 },
/* U+5c74 */ { 0, 0, 0, 0, 0 },
/* U+5c75 */ { 0, 0, 0, 0, 0 },
/* U+5c76 */ { 0, 0, 0, 0, 0 },
/* U+5c77 */ { 0, 0, 0, 0, 0 },
/* U+5c78 */ { 0, 0, 0, 0, 0 },
/* U+5c79 */ { 0, 0, 0, 0, 0 },
/* U+5c7a */ { 0, 0, 0, 0, 0 },
/* U+5c7b */ { 0, 0, 0, 0, 0 },
/* U+5c7c */ { 0, 0, 0, 0, 0 },
/* U+5c7d */ { 0, 0, 0, 0, 0 },
/* U+5c7e */ { 0, 0, 0, 0, 0 },
/* U+5c7f */ { 0, 0, 0, 0, 0 },
/* U+5c80 */ { 0, 0, 0, 0, 0 },
/* U+5c81 */ { 0, 0, 0, 0, 0 },
/* U+5c82 */ { 0, 0, 0, 0, 0 },
/* U+5c83 */ { 0, 0, 0, 0, 0 },
/* U+5c84 */ { 0, 0, 0, 0, 0 },
/* U+5c85 */ { 0, 0, 0, 0, 0 },
/* U+5c86 */ { 0, 0, 0, 0, 0 },
/* U+5c87 */ { 0, 0, 0, 0, 0 },
/* U+5c88 */ { 0, 0, 0, 0, 0 },
/* U+5c89 */ { 0, 0, 0, 0, 0 },
/* U+5c8a */ { 0, 0, 0, 0, 0 },
/* U+5c8b */ { 0, 0, 0, 0, 0 },
/* U+5c8c */ { 0, 0, 0, 0, 0 },
/* U+5c8d */ { 0, 0, 0, 0, 0 },
/* U+5c8e */ { 0, 0, 0, 0, 0 },
/* U+5c8f */ { 0, 0, 0, 0, 0 },
/* U+5c90 */ { 0, 0, 0, 0, 0 },
/* U+5c91 */ { 0, 0, 0, 0, 0 },
/* U+5c92 */ { 0, 0, 0, 0, 0 },
/* U+5c93 */ { 0, 0, 0, 0, 0 },
/* U+5c94 */ { 0, 0, 0, 0, 0 },
/* U+5c95 */ { 0, 0, 0, 0, 0 },
/* U+5c96 */ { 0, 0, 0, 0, 0 },
/* U+5c97 */ { 0, 0, 0, 0, 0 },
/* U+5c98 */ { 0, 0, 0, 0, 0 },
/* U+5c99 */ { 0, 0, 0, 0, 0 },
/* U+5c9a */ { 0, 0, 0, 0, 0 },
/* U+5c9b */ { 0, 0, 0, 0, 0 },
/* U+5c9c */ { 0, 0, 0, 0, 0 },
/* U+5c9d */ { 0, 0, 0, 0, 0 },
/* U+5c9e */ { 0, 0, 0, 0, 0 },
/* U+5c9f */ { 0, 0, 0, 0, 0 },
/* U+5ca0 */ { 0, 0, 0, 0, 0 },
/* U+5ca1 */ { 0, 0, 0, 0, 0 },
/* U+5ca2 */ { 0, 0, 0, 0, 0 },
/* U+5ca3 */ { 0, 0, 0, 0, 0 },
/* U+5ca4 */ { 0, 0, 0, 0, 0 },
/* U+5ca5 */ { 0, 0, 0, 0, 0 },
/* U+5ca6 */ { 0, 0, 0, 0, 0 },
/* U+5ca7 */ { 0, 0, 0, 0, 0 },
/* U+5ca8 */ { 0, 0, 0, 0, 0 },
/* U+5ca9 */ { 0, 0, 0, 0, 0 },
/* U+5caa */ { 0, 0, 0, 0, 0 },
/* U+5cab */ { 0, 0, 0, 0, 0 },
/* U+5cac */ { 0, 0, 0, 0, 0 },
/* U+5cad */ { 0, 0, 0, 0, 0 },
/* U+5cae */ { 0, 0, 0, 0, 0 },
/* U+5caf */ { 0, 0, 0, 0, 0 },
/* U+5cb0 */ { 0, 0, 0, 0, 0 },
/* U+5cb1 */ { 0, 0, 0, 0, 0 },
/* U+5cb2 */ { 0, 0, 0, 0, 0 },
/* U+5cb3 */ { 0, 0, 0, 0, 0 },
/* U+5cb4 */ { 0, 0, 0, 0, 0 },
/* U+5cb5 */ { 0, 0, 0, 0, 0 },
/* U+5cb6 */ { 0, 0, 0, 0, 0 },
/* U+5cb7 */ { 0, 0, 0, 0, 0 },
/* U+5cb8 */ { 0, 0, 0, 0, 0 },
/* U+5cb9 */ { 0, 0, 0, 0, 0 },
/* U+5cba */ { 0, 0, 0, 0, 0 },
/* U+5cbb */ { 0, 0, 0, 0, 0 },
/* U+5cbc */ { 0, 0, 0, 0, 0 },
/* U+5cbd */ { 0, 0, 0, 0, 0 },
/* U+5cbe */ { 0, 0, 0, 0, 0 },
/* U+5cbf */ { 0, 0, 0, 0, 0 },
/* U+5cc0 */ { 0, 0, 0, 0, 0 },
/* U+5cc1 */ { 0, 0, 0, 0, 0 },
/* U+5cc2 */ { 0, 0, 0, 0, 0 },
/* U+5cc3 */ { 0, 0, 0, 0, 0 },
/* U+5cc4 */ { 0, 0, 0, 0, 0 },
/* U+5cc5 */ { 0, 0, 0, 0, 0 },
/* U+5cc6 */ { 0, 0, 0, 0, 0 },
/* U+5cc7 */ { 0, 0, 0, 0, 0 },
/* U+5cc8 */ { 0, 0, 0, 0, 0 },
/* U+5cc9 */ { 0, 0, 0, 0, 0 },
/* U+5cca */ { 0, 0, 0, 0, 0 },
/* U+5ccb */ { 0, 0, 0, 0, 0 },
/* U+5ccc */ { 0, 0, 0, 0, 0 },
/* U+5ccd */ { 0, 0, 0, 0, 0 },
/* U+5cce */ { 0, 0, 0, 0, 0 },
/* U+5ccf */ { 0, 0, 0, 0, 0 },
/* U+5cd0 */ { 0, 0, 0, 0, 0 },
/* U+5cd1 */ { 0, 0, 0, 0, 0 },
/* U+5cd2 */ { 0, 0, 0, 0, 0 },
/* U+5cd3 */ { 0, 0, 0, 0, 0 },
/* U+5cd4 */ { 0, 0, 0, 0, 0 },
/* U+5cd5 */ { 0, 0, 0, 0, 0 },
/* U+5cd6 */ { 0, 0, 0, 0, 0 },
/* U+5cd7 */ { 0, 0, 0, 0, 0 },
/* U+5cd8 */ { 0, 0, 0, 0, 0 },
/* U+5cd9 */ { 0, 0, 0, 0, 0 },
/* U+5cda */ { 0, 0, 0, 0, 0 },
/* U+5cdb */ { 0, 0, 0, 0, 0 },
/* U+5cdc */ { 0, 0, 0, 0, 0 },
/* U+5cdd */ { 0, 0, 0, 0, 0 },
/* U+5cde */ { 0, 0, 0, 0, 0 },
/* U+5cdf */ { 0, 0, 0, 0, 0 },
/* U+5ce0 */ { 0, 0, 0, 0, 0 },
/* U+5ce1 */ { 0, 0, 0, 0, 0 },
/* U+5ce2 */ { 0, 0, 0, 0, 0 },
/* U+5ce3 */ { 0, 0, 0, 0, 0 },
/* U+5ce4 */ { 0, 0, 0, 0, 0 },
/* U+5ce5 */ { 0, 0, 0, 0, 0 },
/* U+5ce6 */ { 0, 0, 0, 0, 0 },
/* U+5ce7 */ { 0, 0, 0, 0, 0 },
/* U+5ce8 */ { 0, 0, 0, 0, 0 },
/* U+5ce9 */ { 0, 0, 0, 0, 0 },
/* U+5cea */ { 0, 0, 0, 0, 0 },
/* U+5ceb */ { 0, 0, 0, 0, 0 },
/* U+5cec */ { 0, 0, 0, 0, 0 },
/* U+5ced */ { 0, 0, 0, 0, 0 },
/* U+5cee */ { 0, 0, 0, 0, 0 },
/* U+5cef */ { 0, 0, 0, 0, 0 },
/* U+5cf0 */ { 0, 0, 0, 0, 0 },
/* U+5cf1 */ { 0, 0, 0, 0, 0 },
/* U+5cf2 */ { 0, 0, 0, 0, 0 },
/* U+5cf3 */ { 0, 0, 0, 0, 0 },
/* U+5cf4 */ { 0, 0, 0, 0, 0 },
/* U+5cf5 */ { 0, 0, 0, 0, 0 },
/* U+5cf6 */ { 0, 0, 0, 0, 0 },
/* U+5cf7 */ { 0, 0, 0, 0, 0 },
/* U+5cf8 */ { 0, 0, 0, 0, 0 },
/* U+5cf9 */ { 0, 0, 0, 0, 0 },
/* U+5cfa */ { 0, 0, 0, 0, 0 },
/* U+5cfb */ { 0, 0, 0, 0, 0 },
/* U+5cfc */ { 0, 0, 0, 0, 0 },
/* U+5cfd */ { 0, 0, 0, 0, 0 },
/* U+5cfe */ { 0, 0, 0, 0, 0 },
/* U+5cff */ { 0, 0, 0, 0, 0 },
/* U+5d00 */ { 0, 0, 0, 0, 0 },
/* U+5d01 */ { 0, 0, 0, 0, 0 },
/* U+5d02 */ { 0, 0, 0, 0, 0 },
/* U+5d03 */ { 0, 0, 0, 0, 0 },
/* U+5d04 */ { 0, 0, 0, 0, 0 },
/* U+5d05 */ { 0, 0, 0, 0, 0 },
/* U+5d06 */ { 0, 0, 0, 0, 0 },
/* U+5d07 */ { 0, 0, 0, 0, 0 },
/* U+5d08 */ { 0, 0, 0, 0, 0 },
/* U+5d09 */ { 0, 0, 0, 0, 0 },
/* U+5d0a */ { 0, 0, 0, 0, 0 },
/* U+5d0b */ { 0, 0, 0, 0, 0 },
/* U+5d0c */ { 0, 0, 0, 0, 0 },
/* U+5d0d */ { 0, 0, 0, 0, 0 },
/* U+5d0e */ { 0, 0, 0, 0, 0 },
/* U+5d0f */ { 0, 0, 0, 0, 0 },
/* U+5d10 */ { 0, 0, 0, 0, 0 },
/* U+5d11 */ { 0, 0, 0, 0, 0 },
/* U+5d12 */ { 0, 0, 0, 0, 0 },
/* U+5d13 */ { 0, 0, 0, 0, 0 },
/* U+5d14 */ { 0, 0, 0, 0, 0 },
/* U+5d15 */ { 0, 0, 0, 0, 0 },
/* U+5d16 */ { 0, 0, 0, 0, 0 },
/* U+5d17 */ { 0, 0, 0, 0, 0 },
/* U+5d18 */ { 0, 0, 0, 0, 0 },
/* U+5d19 */ { 0, 0, 0, 0, 0 },
/* U+5d1a */ { 0, 0, 0, 0, 0 },
/* U+5d1b */ { 0, 0, 0, 0, 0 },
/* U+5d1c */ { 0, 0, 0, 0, 0 },
/* U+5d1d */ { 0, 0, 0, 0, 0 },
/* U+5d1e */ { 0, 0, 0, 0, 0 },
/* U+5d1f */ { 0, 0, 0, 0, 0 },
/* U+5d20 */ { 0, 0, 0, 0, 0 },
/* U+5d21 */ { 0, 0, 0, 0, 0 },
/* U+5d22 */ { 0, 0, 0, 0, 0 },
/* U+5d23 */ { 0, 0, 0, 0, 0 },
/* U+5d24 */ { 0, 0, 0, 0, 0 },
/* U+5d25 */ { 0, 0, 0, 0, 0 },
/* U+5d26 */ { 0, 0, 0, 0, 0 },
/* U+5d27 */ { 0, 0, 0, 0, 0 },
/* U+5d28 */ { 0, 0, 0, 0, 0 },
/* U+5d29 */ { 0, 0, 0, 0, 0 },
/* U+5d2a */ { 0, 0, 0, 0, 0 },
/* U+5d2b */ { 0, 0, 0, 0, 0 },
/* U+5d2c */ { 0, 0, 0, 0, 0 },
/* U+5d2d */ { 0, 0, 0, 0, 0 },
/* U+5d2e */ { 0, 0, 0, 0, 0 },
/* U+5d2f */ { 0, 0, 0, 0, 0 },
/* U+5d30 */ { 0, 0, 0, 0, 0 },
/* U+5d31 */ { 0, 0, 0, 0, 0 },
/* U+5d32 */ { 0, 0, 0, 0, 0 },
/* U+5d33 */ { 0, 0, 0, 0, 0 },
/* U+5d34 */ { 0, 0, 0, 0, 0 },
/* U+5d35 */ { 0, 0, 0, 0, 0 },
/* U+5d36 */ { 0, 0, 0, 0, 0 },
/* U+5d37 */ { 0, 0, 0, 0, 0 },
/* U+5d38 */ { 0, 0, 0, 0, 0 },
/* U+5d39 */ { 0, 0, 0, 0, 0 },
/* U+5d3a */ { 0, 0, 0, 0, 0 },
/* U+5d3b */ { 0, 0, 0, 0, 0 },
/* U+5d3c */ { 0, 0, 0, 0, 0 },
/* U+5d3d */ { 0, 0, 0, 0, 0 },
/* U+5d3e */ { 0, 0, 0, 0, 0 },
/* U+5d3f */ { 0, 0, 0, 0, 0 },
/* U+5d40 */ { 0, 0, 0, 0, 0 },
/* U+5d41 */ { 0, 0, 0, 0, 0 },
/* U+5d42 */ { 0, 0, 0, 0, 0 },
/* U+5d43 */ { 0, 0, 0, 0, 0 },
/* U+5d44 */ { 0, 0, 0, 0, 0 },
/* U+5d45 */ { 0, 0, 0, 0, 0 },
/* U+5d46 */ { 0, 0, 0, 0, 0 },
/* U+5d47 */ { 0, 0, 0, 0, 0 },
/* U+5d48 */ { 0, 0, 0, 0, 0 },
/* U+5d49 */ { 0, 0, 0, 0, 0 },
/* U+5d4a */ { 0, 0, 0, 0, 0 },
/* U+5d4b */ { 0, 0, 0, 0, 0 },
/* U+5d4c */ { 0, 0, 0, 0, 0 },
/* U+5d4d */ { 0, 0, 0, 0, 0 },
/* U+5d4e */ { 0, 0, 0, 0, 0 },
/* U+5d4f */ { 0, 0, 0, 0, 0 },
/* U+5d50 */ { 0, 0, 0, 0, 0 },
/* U+5d51 */ { 0, 0, 0, 0, 0 },
/* U+5d52 */ { 0, 0, 0, 0, 0 },
/* U+5d53 */ { 0, 0, 0, 0, 0 },
/* U+5d54 */ { 0, 0, 0, 0, 0 },
/* U+5d55 */ { 0, 0, 0, 0, 0 },
/* U+5d56 */ { 0, 0, 0, 0, 0 },
/* U+5d57 */ { 0, 0, 0, 0, 0 },
/* U+5d58 */ { 0, 0, 0, 0, 0 },
/* U+5d59 */ { 0, 0, 0, 0, 0 },
/* U+5d5a */ { 0, 0, 0, 0, 0 },
/* U+5d5b */ { 0, 0, 0, 0, 0 },
/* U+5d5c */ { 0, 0, 0, 0, 0 },
/* U+5d5d */ { 0, 0, 0, 0, 0 },
/* U+5d5e */ { 0, 0, 0, 0, 0 },
/* U+5d5f */ { 0, 0, 0, 0, 0 },
/* U+5d60 */ { 0, 0, 0, 0, 0 },
/* U+5d61 */ { 0, 0, 0, 0, 0 },
/* U+5d62 */ { 0, 0, 0, 0, 0 },
/* U+5d63 */ { 0, 0, 0, 0, 0 },
/* U+5d64 */ { 0, 0, 0, 0, 0 },
/* U+5d65 */ { 0, 0, 0, 0, 0 },
/* U+5d66 */ { 0, 0, 0, 0, 0 },
/* U+5d67 */ { 0, 0, 0, 0, 0 },
/* U+5d68 */ { 0, 0, 0, 0, 0 },
/* U+5d69 */ { 0, 0, 0, 0, 0 },
/* U+5d6a */ { 0, 0, 0, 0, 0 },
/* U+5d6b */ { 0, 0, 0, 0, 0 },
/* U+5d6c */ { 0, 0, 0, 0, 0 },
/* U+5d6d */ { 0, 0, 0, 0, 0 },
/* U+5d6e */ { 0, 0, 0, 0, 0 },
/* U+5d6f */ { 0, 0, 0, 0, 0 },
/* U+5d70 */ { 0, 0, 0, 0, 0 },
/* U+5d71 */ { 0, 0, 0, 0, 0 },
/* U+5d72 */ { 0, 0, 0, 0, 0 },
/* U+5d73 */ { 0, 0, 0, 0, 0 },
/* U+5d74 */ { 0, 0, 0, 0, 0 },
/* U+5d75 */ { 0, 0, 0, 0, 0 },
/* U+5d76 */ { 0, 0, 0, 0, 0 },
/* U+5d77 */ { 0, 0, 0, 0, 0 },
/* U+5d78 */ { 0, 0, 0, 0, 0 },
/* U+5d79 */ { 0, 0, 0, 0, 0 },
/* U+5d7a */ { 0, 0, 0, 0, 0 },
/* U+5d7b */ { 0, 0, 0, 0, 0 },
/* U+5d7c */ { 0, 0, 0, 0, 0 },
/* U+5d7d */ { 0, 0, 0, 0, 0 },
/* U+5d7e */ { 0, 0, 0, 0, 0 },
/* U+5d7f */ { 0, 0, 0, 0, 0 },
/* U+5d80 */ { 0, 0, 0, 0, 0 },
/* U+5d81 */ { 0, 0, 0, 0, 0 },
/* U+5d82 */ { 0, 0, 0, 0, 0 },
/* U+5d83 */ { 0, 0, 0, 0, 0 },
/* U+5d84 */ { 0, 0, 0, 0, 0 },
/* U+5d85 */ { 0, 0, 0, 0, 0 },
/* U+5d86 */ { 0, 0, 0, 0, 0 },
/* U+5d87 */ { 0, 0, 0, 0, 0 },
/* U+5d88 */ { 0, 0, 0, 0, 0 },
/* U+5d89 */ { 0, 0, 0, 0, 0 },
/* U+5d8a */ { 0, 0, 0, 0, 0 },
/* U+5d8b */ { 0, 0, 0, 0, 0 },
/* U+5d8c */ { 0, 0, 0, 0, 0 },
/* U+5d8d */ { 0, 0, 0, 0, 0 },
/* U+5d8e */ { 0, 0, 0, 0, 0 },
/* U+5d8f */ { 0, 0, 0, 0, 0 },
/* U+5d90 */ { 0, 0, 0, 0, 0 },
/* U+5d91 */ { 0, 0, 0, 0, 0 },
/* U+5d92 */ { 0, 0, 0, 0, 0 },
/* U+5d93 */ { 0, 0, 0, 0, 0 },
/* U+5d94 */ { 0, 0, 0, 0, 0 },
/* U+5d95 */ { 0, 0, 0, 0, 0 },
/* U+5d96 */ { 0, 0, 0, 0, 0 },
/* U+5d97 */ { 0, 0, 0, 0, 0 },
/* U+5d98 */ { 0, 0, 0, 0, 0 },
/* U+5d99 */ { 0, 0, 0, 0, 0 },
/* U+5d9a */ { 0, 0, 0, 0, 0 },
/* U+5d9b */ { 0, 0, 0, 0, 0 },
/* U+5d9c */ { 0, 0, 0, 0, 0 },
/* U+5d9d */ { 0, 0, 0, 0, 0 },
/* U+5d9e */ { 0, 0, 0, 0, 0 },
/* U+5d9f */ { 0, 0, 0, 0, 0 },
/* U+5da0 */ { 0, 0, 0, 0, 0 },
/* U+5da1 */ { 0, 0, 0, 0, 0 },
/* U+5da2 */ { 0, 0, 0, 0, 0 },
/* U+5da3 */ { 0, 0, 0, 0, 0 },
/* U+5da4 */ { 0, 0, 0, 0, 0 },
/* U+5da5 */ { 0, 0, 0, 0, 0 },
/* U+5da6 */ { 0, 0, 0, 0, 0 },
/* U+5da7 */ { 0, 0, 0, 0, 0 },
/* U+5da8 */ { 0, 0, 0, 0, 0 },
/* U+5da9 */ { 0, 0, 0, 0, 0 },
/* U+5daa */ { 0, 0, 0, 0, 0 },
/* U+5dab */ { 0, 0, 0, 0, 0 },
/* U+5dac */ { 0, 0, 0, 0, 0 },
/* U+5dad */ { 0, 0, 0, 0, 0 },
/* U+5dae */ { 0, 0, 0, 0, 0 },
/* U+5daf */ { 0, 0, 0, 0, 0 },
/* U+5db0 */ { 0, 0, 0, 0, 0 },
/* U+5db1 */ { 0, 0, 0, 0, 0 },
/* U+5db2 */ { 0, 0, 0, 0, 0 },
/* U+5db3 */ { 0, 0, 0, 0, 0 },
/* U+5db4 */ { 0, 0, 0, 0, 0 },
/* U+5db5 */ { 0, 0, 0, 0, 0 },
/* U+5db6 */ { 0, 0, 0, 0, 0 },
/* U+5db7 */ { 0, 0, 0, 0, 0 },
/* U+5db8 */ { 0, 0, 0, 0, 0 },
/* U+5db9 */ { 0, 0, 0, 0, 0 },
/* U+5dba */ { 0, 0, 0, 0, 0 },
/* U+5dbb */ { 0, 0, 0, 0, 0 },
/* U+5dbc */ { 0, 0, 0, 0, 0 },
/* U+5dbd */ { 0, 0, 0, 0, 0 },
/* U+5dbe */ { 0, 0, 0, 0, 0 },
/* U+5dbf */ { 0, 0, 0, 0, 0 },
/* U+5dc0 */ { 0, 0, 0, 0, 0 },
/* U+5dc1 */ { 0, 0, 0, 0, 0 },
/* U+5dc2 */ { 0, 0, 0, 0, 0 },
/* U+5dc3 */ { 0, 0, 0, 0, 0 },
/* U+5dc4 */ { 0, 0, 0, 0, 0 },
/* U+5dc5 */ { 0, 0, 0, 0, 0 },
/* U+5dc6 */ { 0, 0, 0, 0, 0 },
/* U+5dc7 */ { 0, 0, 0, 0, 0 },
/* U+5dc8 */ { 0, 0, 0, 0, 0 },
/* U+5dc9 */ { 0, 0, 0, 0, 0 },
/* U+5dca */ { 0, 0, 0, 0, 0 },
/* U+5dcb */ { 0, 0, 0, 0, 0 },
/* U+5dcc */ { 0, 0, 0, 0, 0 },
/* U+5dcd */ { 0, 0, 0, 0, 0 },
/* U+5dce */ { 0, 0, 0, 0, 0 },
/* U+5dcf */ { 0, 0, 0, 0, 0 },
/* U+5dd0 */ { 0, 0, 0, 0, 0 },
/* U+5dd1 */ { 0, 0, 0, 0, 0 },
/* U+5dd2 */ { 0, 0, 0, 0, 0 },
/* U+5dd3 */ { 0, 0, 0, 0, 0 },
/* U+5dd4 */ { 0, 0, 0, 0, 0 },
/* U+5dd5 */ { 0, 0, 0, 0, 0 },
/* U+5dd6 */ { 0, 0, 0, 0, 0 },
/* U+5dd7 */ { 0, 0, 0, 0, 0 },
/* U+5dd8 */ { 0, 0, 0, 0, 0 },
/* U+5dd9 */ { 0, 0, 0, 0, 0 },
/* U+5dda */ { 0, 0, 0, 0, 0 },
/* U+5ddb */ { 0, 0, 0, 0, 0 },
/* U+5ddc */ { 0, 0, 0, 0, 0 },
/* U+5ddd */ { 0, 0, 0, 0, 0 },
/* U+5dde */ { 0, 0, 0, 0, 0 },
/* U+5ddf */ { 0, 0, 0, 0, 0 },
/* U+5de0 */ { 0, 0, 0, 0, 0 },
/* U+5de1 */ { 0, 0, 0, 0, 0 },
/* U+5de2 */ { 0, 0, 0, 0, 0 },
/* U+5de3 */ { 0, 0, 0, 0, 0 },
/* U+5de4 */ { 0, 0, 0, 0, 0 },
/* U+5de5 */ { 0, 0, 0, 0, 0 },
/* U+5de6 */ { 0, 0, 0, 0, 0 },
/* U+5de7 */ { 0, 0, 0, 0, 0 },
/* U+5de8 */ { 0, 0, 0, 0, 0 },
/* U+5de9 */ { 0, 0, 0, 0, 0 },
/* U+5dea */ { 0, 0, 0, 0, 0 },
/* U+5deb */ { 0, 0, 0, 0, 0 },
/* U+5dec */ { 0, 0, 0, 0, 0 },
/* U+5ded */ { 0, 0, 0, 0, 0 },
/* U+5dee */ { 0, 0, 0, 0, 0 },
/* U+5def */ { 0, 0, 0, 0, 0 },
/* U+5df0 */ { 0, 0, 0, 0, 0 },
/* U+5df1 */ { 0, 0, 0, 0, 0 },
/* U+5df2 */ { 0, 0, 0, 0, 0 },
/* U+5df3 */ { 0, 0, 0, 0, 0 },
/* U+5df4 */ { 0, 0, 0, 0, 0 },
/* U+5df5 */ { 0, 0, 0, 0, 0 },
/* U+5df6 */ { 0, 0, 0, 0, 0 },
/* U+5df7 */ { 0, 0, 0, 0, 0 },
/* U+5df8 */ { 0, 0, 0, 0, 0 },
/* U+5df9 */ { 0, 0, 0, 0, 0 },
/* U+5dfa */ { 0, 0, 0, 0, 0 },
/* U+5dfb */ { 0, 0, 0, 0, 0 },
/* U+5dfc */ { 0, 0, 0, 0, 0 },
/* U+5dfd */ { 0, 0, 0, 0, 0 },
/* U+5dfe */ { 0, 0, 0, 0, 0 },
/* U+5dff */ { 0, 0, 0, 0, 0 },
/* U+5e00 */ { 0, 0, 0, 0, 0 },
/* U+5e01 */ { 0, 0, 0, 0, 0 },
/* U+5e02 */ { 0, 0, 0, 0, 0 },
/* U+5e03 */ { 0, 0, 0, 0, 0 },
/* U+5e04 */ { 0, 0, 0, 0, 0 },
/* U+5e05 */ { 0, 0, 0, 0, 0 },
/* U+5e06 */ { 0, 0, 0, 0, 0 },
/* U+5e07 */ { 0, 0, 0, 0, 0 },
/* U+5e08 */ { 0, 0, 0, 0, 0 },
/* U+5e09 */ { 0, 0, 0, 0, 0 },
/* U+5e0a */ { 0, 0, 0, 0, 0 },
/* U+5e0b */ { 0, 0, 0, 0, 0 },
/* U+5e0c */ { 0, 0, 0, 0, 0 },
/* U+5e0d */ { 0, 0, 0, 0, 0 },
/* U+5e0e */ { 0, 0, 0, 0, 0 },
/* U+5e0f */ { 0, 0, 0, 0, 0 },
/* U+5e10 */ { 0, 0, 0, 0, 0 },
/* U+5e11 */ { 0, 0, 0, 0, 0 },
/* U+5e12 */ { 0, 0, 0, 0, 0 },
/* U+5e13 */ { 0, 0, 0, 0, 0 },
/* U+5e14 */ { 0, 0, 0, 0, 0 },
/* U+5e15 */ { 0, 0, 0, 0, 0 },
/* U+5e16 */ { 0, 0, 0, 0, 0 },
/* U+5e17 */ { 0, 0, 0, 0, 0 },
/* U+5e18 */ { 0, 0, 0, 0, 0 },
/* U+5e19 */ { 0, 0, 0, 0, 0 },
/* U+5e1a */ { 0, 0, 0, 0, 0 },
/* U+5e1b */ { 0, 0, 0, 0, 0 },
/* U+5e1c */ { 0, 0, 0, 0, 0 },
/* U+5e1d */ { 0, 0, 0, 0, 0 },
/* U+5e1e */ { 0, 0, 0, 0, 0 },
/* U+5e1f */ { 0, 0, 0, 0, 0 },
/* U+5e20 */ { 0, 0, 0, 0, 0 },
/* U+5e21 */ { 0, 0, 0, 0, 0 },
/* U+5e22 */ { 0, 0, 0, 0, 0 },
/* U+5e23 */ { 0, 0, 0, 0, 0 },
/* U+5e24 */ { 0, 0, 0, 0, 0 },
/* U+5e25 */ { 0, 0, 0, 0, 0 },
/* U+5e26 */ { 0, 0, 0, 0, 0 },
/* U+5e27 */ { 0, 0, 0, 0, 0 },
/* U+5e28 */ { 0, 0, 0, 0, 0 },
/* U+5e29 */ { 0, 0, 0, 0, 0 },
/* U+5e2a */ { 0, 0, 0, 0, 0 },
/* U+5e2b */ { 0, 0, 0, 0, 0 },
/* U+5e2c */ { 0, 0, 0, 0, 0 },
/* U+5e2d */ { 0, 0, 0, 0, 0 },
/* U+5e2e */ { 0, 0, 0, 0, 0 },
/* U+5e2f */ { 0, 0, 0, 0, 0 },
/* U+5e30 */ { 0, 0, 0, 0, 0 },
/* U+5e31 */ { 0, 0, 0, 0, 0 },
/* U+5e32 */ { 0, 0, 0, 0, 0 },
/* U+5e33 */ { 0, 0, 0, 0, 0 },
/* U+5e34 */ { 0, 0, 0, 0, 0 },
/* U+5e35 */ { 0, 0, 0, 0, 0 },
/* U+5e36 */ { 0, 0, 0, 0, 0 },
/* U+5e37 */ { 0, 0, 0, 0, 0 },
/* U+5e38 */ { 0, 0, 0, 0, 0 },
/* U+5e39 */ { 0, 0, 0, 0, 0 },
/* U+5e3a */ { 0, 0, 0, 0, 0 },
/* U+5e3b */ { 0, 0, 0, 0, 0 },
/* U+5e3c */ { 0, 0, 0, 0, 0 },
/* U+5e3d */ { 0, 0, 0, 0, 0 },
/* U+5e3e */ { 0, 0, 0, 0, 0 },
/* U+5e3f */ { 0, 0, 0, 0, 0 },
/* U+5e40 */ { 0, 0, 0, 0, 0 },
/* U+5e41 */ { 0, 0, 0, 0, 0 },
/* U+5e42 */ { 0, 0, 0, 0, 0 },
/* U+5e43 */ { 0, 0, 0, 0, 0 },
/* U+5e44 */ { 0, 0, 0, 0, 0 },
/* U+5e45 */ { 0, 0, 0, 0, 0 },
/* U+5e46 */ { 0, 0, 0, 0, 0 },
/* U+5e47 */ { 0, 0, 0, 0, 0 },
/* U+5e48 */ { 0, 0, 0, 0, 0 },
/* U+5e49 */ { 0, 0, 0, 0, 0 },
/* U+5e4a */ { 0, 0, 0, 0, 0 },
/* U+5e4b */ { 0, 0, 0, 0, 0 },
/* U+5e4c */ { 0, 0, 0, 0, 0 },
/* U+5e4d */ { 0, 0, 0, 0, 0 },
/* U+5e4e */ { 0, 0, 0, 0, 0 },
/* U+5e4f */ { 0, 0, 0, 0, 0 },
/* U+5e50 */ { 0, 0, 0, 0, 0 },
/* U+5e51 */ { 0, 0, 0, 0, 0 },
/* U+5e52 */ { 0, 0, 0, 0, 0 },
/* U+5e53 */ { 0, 0, 0, 0, 0 },
/* U+5e54 */ { 0, 0, 0, 0, 0 },
/* U+5e55 */ { 0, 0, 0, 0, 0 },
/* U+5e56 */ { 0, 0, 0, 0, 0 },
/* U+5e57 */ { 0, 0, 0, 0, 0 },
/* U+5e58 */ { 0, 0, 0, 0, 0 },
/* U+5e59 */ { 0, 0, 0, 0, 0 },
/* U+5e5a */ { 0, 0, 0, 0, 0 },
/* U+5e5b */ { 0, 0, 0, 0, 0 },
/* U+5e5c */ { 0, 0, 0, 0, 0 },
/* U+5e5d */ { 0, 0, 0, 0, 0 },
/* U+5e5e */ { 0, 0, 0, 0, 0 },
/* U+5e5f */ { 0, 0, 0, 0, 0 },
/* U+5e60 */ { 0, 0, 0, 0, 0 },
/* U+5e61 */ { 0, 0, 0, 0, 0 },
/* U+5e62 */ { 0, 0, 0, 0, 0 },
/* U+5e63 */ { 0, 0, 0, 0, 0 },
/* U+5e64 */ { 0, 0, 0, 0, 0 },
/* U+5e65 */ { 0, 0, 0, 0, 0 },
/* U+5e66 */ { 0, 0, 0, 0, 0 },
/* U+5e67 */ { 0, 0, 0, 0, 0 },
/* U+5e68 */ { 0, 0, 0, 0, 0 },
/* U+5e69 */ { 0, 0, 0, 0, 0 },
/* U+5e6a */ { 0, 0, 0, 0, 0 },
/* U+5e6b */ { 0, 0, 0, 0, 0 },
/* U+5e6c */ { 0, 0, 0, 0, 0 },
/* U+5e6d */ { 0, 0, 0, 0, 0 },
/* U+5e6e */ { 0, 0, 0, 0, 0 },
/* U+5e6f */ { 0, 0, 0, 0, 0 },
/* U+5e70 */ { 0, 0, 0, 0, 0 },
/* U+5e71 */ { 0, 0, 0, 0, 0 },
/* U+5e72 */ { 0, 0, 0, 0, 0 },
/* U+5e73 */ { 0, 0, 0, 0, 0 },
/* U+5e74 */ { 0, 0, 0, 0, 0 },
/* U+5e75 */ { 0, 0, 0, 0, 0 },
/* U+5e76 */ { 0, 0, 0, 0, 0 },
/* U+5e77 */ { 0, 0, 0, 0, 0 },
/* U+5e78 */ { 0, 0, 0, 0, 0 },
/* U+5e79 */ { 0, 0, 0, 0, 0 },
/* U+5e7a */ { 0, 0, 0, 0, 0 },
/* U+5e7b */ { 0, 0, 0, 0, 0 },
/* U+5e7c */ { 0, 0, 0, 0, 0 },
/* U+5e7d */ { 0, 0, 0, 0, 0 },
/* U+5e7e */ { 0, 0, 0, 0, 0 },
/* U+5e7f */ { 0, 0, 0, 0, 0 },
/* U+5e80 */ { 0, 0, 0, 0, 0 },
/* U+5e81 */ { 0, 0, 0, 0, 0 },
/* U+5e82 */ { 0, 0, 0, 0, 0 },
/* U+5e83 */ { 0, 0, 0, 0, 0 },
/* U+5e84 */ { 0, 0, 0, 0, 0 },
/* U+5e85 */ { 0, 0, 0, 0, 0 },
/* U+5e86 */ { 0, 0, 0, 0, 0 },
/* U+5e87 */ { 0, 0, 0, 0, 0 },
/* U+5e88 */ { 0, 0, 0, 0, 0 },
/* U+5e89 */ { 0, 0, 0, 0, 0 },
/* U+5e8a */ { 0, 0, 0, 0, 0 },
/* U+5e8b */ { 0, 0, 0, 0, 0 },
/* U+5e8c */ { 0, 0, 0, 0, 0 },
/* U+5e8d */ { 0, 0, 0, 0, 0 },
/* U+5e8e */ { 0, 0, 0, 0, 0 },
/* U+5e8f */ { 0, 0, 0, 0, 0 },
/* U+5e90 */ { 0, 0, 0, 0, 0 },
/* U+5e91 */ { 0, 0, 0, 0, 0 },
/* U+5e92 */ { 0, 0, 0, 0, 0 },
/* U+5e93 */ { 0, 0, 0, 0, 0 },
/* U+5e94 */ { 0, 0, 0, 0, 0 },
/* U+5e95 */ { 0, 0, 0, 0, 0 },
/* U+5e96 */ { 0, 0, 0, 0, 0 },
/* U+5e97 */ { 0, 0, 0, 0, 0 },
/* U+5e98 */ { 0, 0, 0, 0, 0 },
/* U+5e99 */ { 0, 0, 0, 0, 0 },
/* U+5e9a */ { 0, 0, 0, 0, 0 },
/* U+5e9b */ { 0, 0, 0, 0, 0 },
/* U+5e9c */ { 0, 0, 0, 0, 0 },
/* U+5e9d */ { 0, 0, 0, 0, 0 },
/* U+5e9e */ { 0, 0, 0, 0, 0 },
/* U+5e9f */ { 0, 0, 0, 0, 0 },
/* U+5ea0 */ { 0, 0, 0, 0, 0 },
/* U+5ea1 */ { 0, 0, 0, 0, 0 },
/* U+5ea2 */ { 0, 0, 0, 0, 0 },
/* U+5ea3 */ { 0, 0, 0, 0, 0 },
/* U+5ea4 */ { 0, 0, 0, 0, 0 },
/* U+5ea5 */ { 0, 0, 0, 0, 0 },
/* U+5ea6 */ { 0, 0, 0, 0, 0 },
/* U+5ea7 */ { 0, 0, 0, 0, 0 },
/* U+5ea8 */ { 0, 0, 0, 0, 0 },
/* U+5ea9 */ { 0, 0, 0, 0, 0 },
/* U+5eaa */ { 0, 0, 0, 0, 0 },
/* U+5eab */ { 0, 0, 0, 0, 0 },
/* U+5eac */ { 0, 0, 0, 0, 0 },
/* U+5ead */ { 0, 0, 0, 0, 0 },
/* U+5eae */ { 0, 0, 0, 0, 0 },
/* U+5eaf */ { 0, 0, 0, 0, 0 },
/* U+5eb0 */ { 0, 0, 0, 0, 0 },
/* U+5eb1 */ { 0, 0, 0, 0, 0 },
/* U+5eb2 */ { 0, 0, 0, 0, 0 },
/* U+5eb3 */ { 0, 0, 0, 0, 0 },
/* U+5eb4 */ { 0, 0, 0, 0, 0 },
/* U+5eb5 */ { 0, 0, 0, 0, 0 },
/* U+5eb6 */ { 0, 0, 0, 0, 0 },
/* U+5eb7 */ { 0, 0, 0, 0, 0 },
/* U+5eb8 */ { 0, 0, 0, 0, 0 },
/* U+5eb9 */ { 0, 0, 0, 0, 0 },
/* U+5eba */ { 0, 0, 0, 0, 0 },
/* U+5ebb */ { 0, 0, 0, 0, 0 },
/* U+5ebc */ { 0, 0, 0, 0, 0 },
/* U+5ebd */ { 0, 0, 0, 0, 0 },
/* U+5ebe */ { 0, 0, 0, 0, 0 },
/* U+5ebf */ { 0, 0, 0, 0, 0 },
/* U+5ec0 */ { 0, 0, 0, 0, 0 },
/* U+5ec1 */ { 0, 0, 0, 0, 0 },
/* U+5ec2 */ { 0, 0, 0, 0, 0 },
/* U+5ec3 */ { 0, 0, 0, 0, 0 },
/* U+5ec4 */ { 0, 0, 0, 0, 0 },
/* U+5ec5 */ { 0, 0, 0, 0, 0 },
/* U+5ec6 */ { 0, 0, 0, 0, 0 },
/* U+5ec7 */ { 0, 0, 0, 0, 0 },
/* U+5ec8 */ { 0, 0, 0, 0, 0 },
/* U+5ec9 */ { 0, 0, 0, 0, 0 },
/* U+5eca */ { 0, 0, 0, 0, 0 },
/* U+5ecb */ { 0, 0, 0, 0, 0 },
/* U+5ecc */ { 0, 0, 0, 0, 0 },
/* U+5ecd */ { 0, 0, 0, 0, 0 },
/* U+5ece */ { 0, 0, 0, 0, 0 },
/* U+5ecf */ { 0, 0, 0, 0, 0 },
/* U+5ed0 */ { 0, 0, 0, 0, 0 },
/* U+5ed1 */ { 0, 0, 0, 0, 0 },
/* U+5ed2 */ { 0, 0, 0, 0, 0 },
/* U+5ed3 */ { 0, 0, 0, 0, 0 },
/* U+5ed4 */ { 0, 0, 0, 0, 0 },
/* U+5ed5 */ { 0, 0, 0, 0, 0 },
/* U+5ed6 */ { 0, 0, 0, 0, 0 },
/* U+5ed7 */ { 0, 0, 0, 0, 0 },
/* U+5ed8 */ { 0, 0, 0, 0, 0 },
/* U+5ed9 */ { 0, 0, 0, 0, 0 },
/* U+5eda */ { 0, 0, 0, 0, 0 },
/* U+5edb */ { 0, 0, 0, 0, 0 },
/* U+5edc */ { 0, 0, 0, 0, 0 },
/* U+5edd */ { 0, 0, 0, 0, 0 },
/* U+5ede */ { 0, 0, 0, 0, 0 },
/* U+5edf */ { 0, 0, 0, 0, 0 },
/* U+5ee0 */ { 0, 0, 0, 0, 0 },
/* U+5ee1 */ { 0, 0, 0, 0, 0 },
/* U+5ee2 */ { 0, 0, 0, 0, 0 },
/* U+5ee3 */ { 0, 0, 0, 0, 0 },
/* U+5ee4 */ { 0, 0, 0, 0, 0 },
/* U+5ee5 */ { 0, 0, 0, 0, 0 },
/* U+5ee6 */ { 0, 0, 0, 0, 0 },
/* U+5ee7 */ { 0, 0, 0, 0, 0 },
/* U+5ee8 */ { 0, 0, 0, 0, 0 },
/* U+5ee9 */ { 0, 0, 0, 0, 0 },
/* U+5eea */ { 0, 0, 0, 0, 0 },
/* U+5eeb */ { 0, 0, 0, 0, 0 },
/* U+5eec */ { 0, 0, 0, 0, 0 },
/* U+5eed */ { 0, 0, 0, 0, 0 },
/* U+5eee */ { 0, 0, 0, 0, 0 },
/* U+5eef */ { 0, 0, 0, 0, 0 },
/* U+5ef0 */ { 0, 0, 0, 0, 0 },
/* U+5ef1 */ { 0, 0, 0, 0, 0 },
/* U+5ef2 */ { 0, 0, 0, 0, 0 },
/* U+5ef3 */ { 0, 0, 0, 0, 0 },
/* U+5ef4 */ { 0, 0, 0, 0, 0 },
/* U+5ef5 */ { 0, 0, 0, 0, 0 },
/* U+5ef6 */ { 0, 0, 0, 0, 0 },
/* U+5ef7 */ { 0, 0, 0, 0, 0 },
/* U+5ef8 */ { 0, 0, 0, 0, 0 },
/* U+5ef9 */ { 0, 0, 0, 0, 0 },
/* U+5efa */ { 0, 0, 0, 0, 0 },
/* U+5efb */ { 0, 0, 0, 0, 0 },
/* U+5efc */ { 0, 0, 0, 0, 0 },
/* U+5efd */ { 0, 0, 0, 0, 0 },
/* U+5efe */ { 0, 0, 0, 0, 0 },
/* U+5eff */ { 0, 0, 0, 0, 0 },
/* U+5f00 */ { 0, 0, 0, 0, 0 },
/* U+5f01 */ { 0, 0, 0, 0, 0 },
/* U+5f02 */ { 0, 0, 0, 0, 0 },
/* U+5f03 */ { 0, 0, 0, 0, 0 },
/* U+5f04 */ { 0, 0, 0, 0, 0 },
/* U+5f05 */ { 0, 0, 0, 0, 0 },
/* U+5f06 */ { 0, 0, 0, 0, 0 },
/* U+5f07 */ { 0, 0, 0, 0, 0 },
/* U+5f08 */ { 0, 0, 0, 0, 0 },
/* U+5f09 */ { 0, 0, 0, 0, 0 },
/* U+5f0a */ { 0, 0, 0, 0, 0 },
/* U+5f0b */ { 0, 0, 0, 0, 0 },
/* U+5f0c */ { 0, 0, 0, 0, 0 },
/* U+5f0d */ { 0, 0, 0, 0, 0 },
/* U+5f0e */ { 0, 0, 0, 0, 0 },
/* U+5f0f */ { 0, 0, 0, 0, 0 },
/* U+5f10 */ { 0, 0, 0, 0, 0 },
/* U+5f11 */ { 0, 0, 0, 0, 0 },
/* U+5f12 */ { 0, 0, 0, 0, 0 },
/* U+5f13 */ { 0, 0, 0, 0, 0 },
/* U+5f14 */ { 0, 0, 0, 0, 0 },
/* U+5f15 */ { 0, 0, 0, 0, 0 },
/* U+5f16 */ { 0, 0, 0, 0, 0 },
/* U+5f17 */ { 0, 0, 0, 0, 0 },
/* U+5f18 */ { 0, 0, 0, 0, 0 },
/* U+5f19 */ { 0, 0, 0, 0, 0 },
/* U+5f1a */ { 0, 0, 0, 0, 0 },
/* U+5f1b */ { 0, 0, 0, 0, 0 },
/* U+5f1c */ { 0, 0, 0, 0, 0 },
/* U+5f1d */ { 0, 0, 0, 0, 0 },
/* U+5f1e */ { 0, 0, 0, 0, 0 },
/* U+5f1f */ { 0, 0, 0, 0, 0 },
/* U+5f20 */ { 0, 0, 0, 0, 0 },
/* U+5f21 */ { 0, 0, 0, 0, 0 },
/* U+5f22 */ { 0, 0, 0, 0, 0 },
/* U+5f23 */ { 0, 0, 0, 0, 0 },
/* U+5f24 */ { 0, 0, 0, 0, 0 },
/* U+5f25 */ { 0, 0, 0, 0, 0 },
/* U+5f26 */ { 0, 0, 0, 0, 0 },
/* U+5f27 */ { 0, 0, 0, 0, 0 },
/* U+5f28 */ { 0, 0, 0, 0, 0 },
/* U+5f29 */ { 0, 0, 0, 0, 0 },
/* U+5f2a */ { 0, 0, 0, 0, 0 },
/* U+5f2b */ { 0, 0, 0, 0, 0 },
/* U+5f2c */ { 0, 0, 0, 0, 0 },
/* U+5f2d */ { 0, 0, 0, 0, 0 },
/* U+5f2e */ { 0, 0, 0, 0, 0 },
/* U+5f2f */ { 0, 0, 0, 0, 0 },
/* U+5f30 */ { 0, 0, 0, 0, 0 },
/* U+5f31 */ { 0, 0, 0, 0, 0 },
/* U+5f32 */ { 0, 0, 0, 0, 0 },
/* U+5f33 */ { 0, 0, 0, 0, 0 },
/* U+5f34 */ { 0, 0, 0, 0, 0 },
/* U+5f35 */ { 0, 0, 0, 0, 0 },
/* U+5f36 */ { 0, 0, 0, 0, 0 },
/* U+5f37 */ { 0, 0, 0, 0, 0 },
/* U+5f38 */ { 0, 0, 0, 0, 0 },
/* U+5f39 */ { 0, 0, 0, 0, 0 },
/* U+5f3a */ { 0, 0, 0, 0, 0 },
/* U+5f3b */ { 0, 0, 0, 0, 0 },
/* U+5f3c */ { 0, 0, 0, 0, 0 },
/* U+5f3d */ { 0, 0, 0, 0, 0 },
/* U+5f3e */ { 0, 0, 0, 0, 0 },
/* U+5f3f */ { 0, 0, 0, 0, 0 },
/* U+5f40 */ { 0, 0, 0, 0, 0 },
/* U+5f41 */ { 0, 0, 0, 0, 0 },
/* U+5f42 */ { 0, 0, 0, 0, 0 },
/* U+5f43 */ { 0, 0, 0, 0, 0 },
/* U+5f44 */ { 0, 0, 0, 0, 0 },
/* U+5f45 */ { 0, 0, 0, 0, 0 },
/* U+5f46 */ { 0, 0, 0, 0, 0 },
/* U+5f47 */ { 0, 0, 0, 0, 0 },
/* U+5f48 */ { 0, 0, 0, 0, 0 },
/* U+5f49 */ { 0, 0, 0, 0, 0 },
/* U+5f4a */ { 0, 0, 0, 0, 0 },
/* U+5f4b */ { 0, 0, 0, 0, 0 },
/* U+5f4c */ { 0, 0, 0, 0, 0 },
/* U+5f4d */ { 0, 0, 0, 0, 0 },
/* U+5f4e */ { 0, 0, 0, 0, 0 },
/* U+5f4f */ { 0, 0, 0, 0, 0 },
/* U+5f50 */ { 0, 0, 0, 0, 0 },
/* U+5f51 */ { 0, 0, 0, 0, 0 },
/* U+5f52 */ { 0, 0, 0, 0, 0 },
/* U+5f53 */ { 0, 0, 0, 0, 0 },
/* U+5f54 */ { 0, 0, 0, 0, 0 },
/* U+5f55 */ { 0, 0, 0, 0, 0 },
/* U+5f56 */ { 0, 0, 0, 0, 0 },
/* U+5f57 */ { 0, 0, 0, 0, 0 },
/* U+5f58 */ { 0, 0, 0, 0, 0 },
/* U+5f59 */ { 0, 0, 0, 0, 0 },
/* U+5f5a */ { 0, 0, 0, 0, 0 },
/* U+5f5b */ { 0, 0, 0, 0, 0 },
/* U+5f5c */ { 0, 0, 0, 0, 0 },
/* U+5f5d */ { 0, 0, 0, 0, 0 },
/* U+5f5e */ { 0, 0, 0, 0, 0 },
/* U+5f5f */ { 0, 0, 0, 0, 0 },
/* U+5f60 */ { 0, 0, 0, 0, 0 },
/* U+5f61 */ { 0, 0, 0, 0, 0 },
/* U+5f62 */ { 0, 0, 0, 0, 0 },
/* U+5f63 */ { 0, 0, 0, 0, 0 },
/* U+5f64 */ { 0, 0, 0, 0, 0 },
/* U+5f65 */ { 0, 0, 0, 0, 0 },
/* U+5f66 */ { 0, 0, 0, 0, 0 },
/* U+5f67 */ { 0, 0, 0, 0, 0 },
/* U+5f68 */ { 0, 0, 0, 0, 0 },
/* U+5f69 */ { 0, 0, 0, 0, 0 },
/* U+5f6a */ { 0, 0, 0, 0, 0 },
/* U+5f6b */ { 0, 0, 0, 0, 0 },
/* U+5f6c */ { 0, 0, 0, 0, 0 },
/* U+5f6d */ { 0, 0, 0, 0, 0 },
/* U+5f6e */ { 0, 0, 0, 0, 0 },
/* U+5f6f */ { 0, 0, 0, 0, 0 },
/* U+5f70 */ { 0, 0, 0, 0, 0 },
/* U+5f71 */ { 0, 0, 0, 0, 0 },
/* U+5f72 */ { 0, 0, 0, 0, 0 },
/* U+5f73 */ { 0, 0, 0, 0, 0 },
/* U+5f74 */ { 0, 0, 0, 0, 0 },
/* U+5f75 */ { 0, 0, 0, 0, 0 },
/* U+5f76 */ { 0, 0, 0, 0, 0 },
/* U+5f77 */ { 0, 0, 0, 0, 0 },
/* U+5f78 */ { 0, 0, 0, 0, 0 },
/* U+5f79 */ { 0, 0, 0, 0, 0 },
/* U+5f7a */ { 0, 0, 0, 0, 0 },
/* U+5f7b */ { 0, 0, 0, 0, 0 },
/* U+5f7c */ { 0, 0, 0, 0, 0 },
/* U+5f7d */ { 0, 0, 0, 0, 0 },
/* U+5f7e */ { 0, 0, 0, 0, 0 },
/* U+5f7f */ { 0, 0, 0, 0, 0 },
/* U+5f80 */ { 0, 0, 0, 0, 0 },
/* U+5f81 */ { 0, 0, 0, 0, 0 },
/* U+5f82 */ { 0, 0, 0, 0, 0 },
/* U+5f83 */ { 0, 0, 0, 0, 0 },
/* U+5f84 */ { 0, 0, 0, 0, 0 },
/* U+5f85 */ { 0, 0, 0, 0, 0 },
/* U+5f86 */ { 0, 0, 0, 0, 0 },
/* U+5f87 */ { 0, 0, 0, 0, 0 },
/* U+5f88 */ { 0, 0, 0, 0, 0 },
/* U+5f89 */ { 0, 0, 0, 0, 0 },
/* U+5f8a */ { 0, 0, 0, 0, 0 },
/* U+5f8b */ { 0, 0, 0, 0, 0 },
/* U+5f8c */ { 0, 0, 0, 0, 0 },
/* U+5f8d */ { 0, 0, 0, 0, 0 },
/* U+5f8e */ { 0, 0, 0, 0, 0 },
/* U+5f8f */ { 0, 0, 0, 0, 0 },
/* U+5f90 */ { 0, 0, 0, 0, 0 },
/* U+5f91 */ { 0, 0, 0, 0, 0 },
/* U+5f92 */ { 0, 0, 0, 0, 0 },
/* U+5f93 */ { 0, 0, 0, 0, 0 },
/* U+5f94 */ { 0, 0, 0, 0, 0 },
/* U+5f95 */ { 0, 0, 0, 0, 0 },
/* U+5f96 */ { 0, 0, 0, 0, 0 },
/* U+5f97 */ { 0, 0, 0, 0, 0 },
/* U+5f98 */ { 0, 0, 0, 0, 0 },
/* U+5f99 */ { 0, 0, 0, 0, 0 },
/* U+5f9a */ { 0, 0, 0, 0, 0 },
/* U+5f9b */ { 0, 0, 0, 0, 0 },
/* U+5f9c */ { 0, 0, 0, 0, 0 },
/* U+5f9d */ { 0, 0, 0, 0, 0 },
/* U+5f9e */ { 0, 0, 0, 0, 0 },
/* U+5f9f */ { 0, 0, 0, 0, 0 },
/* U+5fa0 */ { 0, 0, 0, 0, 0 },
/* U+5fa1 */ { 0, 0, 0, 0, 0 },
/* U+5fa2 */ { 0, 0, 0, 0, 0 },
/* U+5fa3 */ { 0, 0, 0, 0, 0 },
/* U+5fa4 */ { 0, 0, 0, 0, 0 },
/* U+5fa5 */ { 0, 0, 0, 0, 0 },
/* U+5fa6 */ { 0, 0, 0, 0, 0 },
/* U+5fa7 */ { 0, 0, 0, 0, 0 },
/* U+5fa8 */ { 0, 0, 0, 0, 0 },
/* U+5fa9 */ { 0, 0, 0, 0, 0 },
/* U+5faa */ { 0, 0, 0, 0, 0 },
/* U+5fab */ { 0, 0, 0, 0, 0 },
/* U+5fac */ { 0, 0, 0, 0, 0 },
/* U+5fad */ { 0, 0, 0, 0, 0 },
/* U+5fae */ { 0, 0, 0, 0, 0 },
/* U+5faf */ { 0, 0, 0, 0, 0 },
/* U+5fb0 */ { 0, 0, 0, 0, 0 },
/* U+5fb1 */ { 0, 0, 0, 0, 0 },
/* U+5fb2 */ { 0, 0, 0, 0, 0 },
/* U+5fb3 */ { 0, 0, 0, 0, 0 },
/* U+5fb4 */ { 0, 0, 0, 0, 0 },
/* U+5fb5 */ { 0, 0, 0, 0, 0 },
/* U+5fb6 */ { 0, 0, 0, 0, 0 },
/* U+5fb7 */ { 0, 0, 0, 0, 0 },
/* U+5fb8 */ { 0, 0, 0, 0, 0 },
/* U+5fb9 */ { 0, 0, 0, 0, 0 },
/* U+5fba */ { 0, 0, 0, 0, 0 },
/* U+5fbb */ { 0, 0, 0, 0, 0 },
/* U+5fbc */ { 0, 0, 0, 0, 0 },
/* U+5fbd */ { 0, 0, 0, 0, 0 },
/* U+5fbe */ { 0, 0, 0, 0, 0 },
/* U+5fbf */ { 0, 0, 0, 0, 0 },
/* U+5fc0 */ { 0, 0, 0, 0, 0 },
/* U+5fc1 */ { 0, 0, 0, 0, 0 },
/* U+5fc2 */ { 0, 0, 0, 0, 0 },
/* U+5fc3 */ { 0, 0, 0, 0, 0 },
/* U+5fc4 */ { 0, 0, 0, 0, 0 },
/* U+5fc5 */ { 0, 0, 0, 0, 0 },
/* U+5fc6 */ { 0, 0, 0, 0, 0 },
/* U+5fc7 */ { 0, 0, 0, 0, 0 },
/* U+5fc8 */ { 0, 0, 0, 0, 0 },
/* U+5fc9 */ { 0, 0, 0, 0, 0 },
/* U+5fca */ { 0, 0, 0, 0, 0 },
/* U+5fcb */ { 0, 0, 0, 0, 0 },
/* U+5fcc */ { 0, 0, 0, 0, 0 },
/* U+5fcd */ { 0, 0, 0, 0, 0 },
/* U+5fce */ { 0, 0, 0, 0, 0 },
/* U+5fcf */ { 0, 0, 0, 0, 0 },
/* U+5fd0 */ { 0, 0, 0, 0, 0 },
/* U+5fd1 */ { 0, 0, 0, 0, 0 },
/* U+5fd2 */ { 0, 0, 0, 0, 0 },
/* U+5fd3 */ { 0, 0, 0, 0, 0 },
/* U+5fd4 */ { 0, 0, 0, 0, 0 },
/* U+5fd5 */ { 0, 0, 0, 0, 0 },
/* U+5fd6 */ { 0, 0, 0, 0, 0 },
/* U+5fd7 */ { 0, 0, 0, 0, 0 },
/* U+5fd8 */ { 0, 0, 0, 0, 0 },
/* U+5fd9 */ { 0, 0, 0, 0, 0 },
/* U+5fda */ { 0, 0, 0, 0, 0 },
/* U+5fdb */ { 0, 0, 0, 0, 0 },
/* U+5fdc */ { 0, 0, 0, 0, 0 },
/* U+5fdd */ { 0, 0, 0, 0, 0 },
/* U+5fde */ { 0, 0, 0, 0, 0 },
/* U+5fdf */ { 0, 0, 0, 0, 0 },
/* U+5fe0 */ { 0, 0, 0, 0, 0 },
/* U+5fe1 */ { 0, 0, 0, 0, 0 },
/* U+5fe2 */ { 0, 0, 0, 0, 0 },
/* U+5fe3 */ { 0, 0, 0, 0, 0 },
/* U+5fe4 */ { 0, 0, 0, 0, 0 },
/* U+5fe5 */ { 0, 0, 0, 0, 0 },
/* U+5fe6 */ { 0, 0, 0, 0, 0 },
/* U+5fe7 */ { 0, 0, 0, 0, 0 },
/* U+5fe8 */ { 0, 0, 0, 0, 0 },
/* U+5fe9 */ { 0, 0, 0, 0, 0 },
/* U+5fea */ { 0, 0, 0, 0, 0 },
/* U+5feb */ { 0, 0, 0, 0, 0 },
/* U+5fec */ { 0, 0, 0, 0, 0 },
/* U+5fed */ { 0, 0, 0, 0, 0 },
/* U+5fee */ { 0, 0, 0, 0, 0 },
/* U+5fef */ { 0, 0, 0, 0, 0 },
/* U+5ff0 */ { 0, 0, 0, 0, 0 },
/* U+5ff1 */ { 0, 0, 0, 0, 0 },
/* U+5ff2 */ { 0, 0, 0, 0, 0 },
/* U+5ff3 */ { 0, 0, 0, 0, 0 },
/* U+5ff4 */ { 0, 0, 0, 0, 0 },
/* U+5ff5 */ { 0, 0, 0, 0, 0 },
/* U+5ff6 */ { 0, 0, 0, 0, 0 },
/* U+5ff7 */ { 0, 0, 0, 0, 0 },
/* U+5ff8 */ { 0, 0, 0, 0, 0 },
/* U+5ff9 */ { 0, 0, 0, 0, 0 },
/* U+5ffa */ { 0, 0, 0, 0, 0 },
/* U+5ffb */ { 0, 0, 0, 0, 0 },
/* U+5ffc */ { 0, 0, 0, 0, 0 },
/* U+5ffd */ { 0, 0, 0, 0, 0 },
/* U+5ffe */ { 0, 0, 0, 0, 0 },
/* U+5fff */ { 0, 0, 0, 0, 0 },

};

const _PyUnicode_DatabaseRecord _PyUnicode_Database_6[4096] = {
    
/* U+6000 */ { 0, 0, 0, 0, 0 },
/* U+6001 */ { 0, 0, 0, 0, 0 },
/* U+6002 */ { 0, 0, 0, 0, 0 },
/* U+6003 */ { 0, 0, 0, 0, 0 },
/* U+6004 */ { 0, 0, 0, 0, 0 },
/* U+6005 */ { 0, 0, 0, 0, 0 },
/* U+6006 */ { 0, 0, 0, 0, 0 },
/* U+6007 */ { 0, 0, 0, 0, 0 },
/* U+6008 */ { 0, 0, 0, 0, 0 },
/* U+6009 */ { 0, 0, 0, 0, 0 },
/* U+600a */ { 0, 0, 0, 0, 0 },
/* U+600b */ { 0, 0, 0, 0, 0 },
/* U+600c */ { 0, 0, 0, 0, 0 },
/* U+600d */ { 0, 0, 0, 0, 0 },
/* U+600e */ { 0, 0, 0, 0, 0 },
/* U+600f */ { 0, 0, 0, 0, 0 },
/* U+6010 */ { 0, 0, 0, 0, 0 },
/* U+6011 */ { 0, 0, 0, 0, 0 },
/* U+6012 */ { 0, 0, 0, 0, 0 },
/* U+6013 */ { 0, 0, 0, 0, 0 },
/* U+6014 */ { 0, 0, 0, 0, 0 },
/* U+6015 */ { 0, 0, 0, 0, 0 },
/* U+6016 */ { 0, 0, 0, 0, 0 },
/* U+6017 */ { 0, 0, 0, 0, 0 },
/* U+6018 */ { 0, 0, 0, 0, 0 },
/* U+6019 */ { 0, 0, 0, 0, 0 },
/* U+601a */ { 0, 0, 0, 0, 0 },
/* U+601b */ { 0, 0, 0, 0, 0 },
/* U+601c */ { 0, 0, 0, 0, 0 },
/* U+601d */ { 0, 0, 0, 0, 0 },
/* U+601e */ { 0, 0, 0, 0, 0 },
/* U+601f */ { 0, 0, 0, 0, 0 },
/* U+6020 */ { 0, 0, 0, 0, 0 },
/* U+6021 */ { 0, 0, 0, 0, 0 },
/* U+6022 */ { 0, 0, 0, 0, 0 },
/* U+6023 */ { 0, 0, 0, 0, 0 },
/* U+6024 */ { 0, 0, 0, 0, 0 },
/* U+6025 */ { 0, 0, 0, 0, 0 },
/* U+6026 */ { 0, 0, 0, 0, 0 },
/* U+6027 */ { 0, 0, 0, 0, 0 },
/* U+6028 */ { 0, 0, 0, 0, 0 },
/* U+6029 */ { 0, 0, 0, 0, 0 },
/* U+602a */ { 0, 0, 0, 0, 0 },
/* U+602b */ { 0, 0, 0, 0, 0 },
/* U+602c */ { 0, 0, 0, 0, 0 },
/* U+602d */ { 0, 0, 0, 0, 0 },
/* U+602e */ { 0, 0, 0, 0, 0 },
/* U+602f */ { 0, 0, 0, 0, 0 },
/* U+6030 */ { 0, 0, 0, 0, 0 },
/* U+6031 */ { 0, 0, 0, 0, 0 },
/* U+6032 */ { 0, 0, 0, 0, 0 },
/* U+6033 */ { 0, 0, 0, 0, 0 },
/* U+6034 */ { 0, 0, 0, 0, 0 },
/* U+6035 */ { 0, 0, 0, 0, 0 },
/* U+6036 */ { 0, 0, 0, 0, 0 },
/* U+6037 */ { 0, 0, 0, 0, 0 },
/* U+6038 */ { 0, 0, 0, 0, 0 },
/* U+6039 */ { 0, 0, 0, 0, 0 },
/* U+603a */ { 0, 0, 0, 0, 0 },
/* U+603b */ { 0, 0, 0, 0, 0 },
/* U+603c */ { 0, 0, 0, 0, 0 },
/* U+603d */ { 0, 0, 0, 0, 0 },
/* U+603e */ { 0, 0, 0, 0, 0 },
/* U+603f */ { 0, 0, 0, 0, 0 },
/* U+6040 */ { 0, 0, 0, 0, 0 },
/* U+6041 */ { 0, 0, 0, 0, 0 },
/* U+6042 */ { 0, 0, 0, 0, 0 },
/* U+6043 */ { 0, 0, 0, 0, 0 },
/* U+6044 */ { 0, 0, 0, 0, 0 },
/* U+6045 */ { 0, 0, 0, 0, 0 },
/* U+6046 */ { 0, 0, 0, 0, 0 },
/* U+6047 */ { 0, 0, 0, 0, 0 },
/* U+6048 */ { 0, 0, 0, 0, 0 },
/* U+6049 */ { 0, 0, 0, 0, 0 },
/* U+604a */ { 0, 0, 0, 0, 0 },
/* U+604b */ { 0, 0, 0, 0, 0 },
/* U+604c */ { 0, 0, 0, 0, 0 },
/* U+604d */ { 0, 0, 0, 0, 0 },
/* U+604e */ { 0, 0, 0, 0, 0 },
/* U+604f */ { 0, 0, 0, 0, 0 },
/* U+6050 */ { 0, 0, 0, 0, 0 },
/* U+6051 */ { 0, 0, 0, 0, 0 },
/* U+6052 */ { 0, 0, 0, 0, 0 },
/* U+6053 */ { 0, 0, 0, 0, 0 },
/* U+6054 */ { 0, 0, 0, 0, 0 },
/* U+6055 */ { 0, 0, 0, 0, 0 },
/* U+6056 */ { 0, 0, 0, 0, 0 },
/* U+6057 */ { 0, 0, 0, 0, 0 },
/* U+6058 */ { 0, 0, 0, 0, 0 },
/* U+6059 */ { 0, 0, 0, 0, 0 },
/* U+605a */ { 0, 0, 0, 0, 0 },
/* U+605b */ { 0, 0, 0, 0, 0 },
/* U+605c */ { 0, 0, 0, 0, 0 },
/* U+605d */ { 0, 0, 0, 0, 0 },
/* U+605e */ { 0, 0, 0, 0, 0 },
/* U+605f */ { 0, 0, 0, 0, 0 },
/* U+6060 */ { 0, 0, 0, 0, 0 },
/* U+6061 */ { 0, 0, 0, 0, 0 },
/* U+6062 */ { 0, 0, 0, 0, 0 },
/* U+6063 */ { 0, 0, 0, 0, 0 },
/* U+6064 */ { 0, 0, 0, 0, 0 },
/* U+6065 */ { 0, 0, 0, 0, 0 },
/* U+6066 */ { 0, 0, 0, 0, 0 },
/* U+6067 */ { 0, 0, 0, 0, 0 },
/* U+6068 */ { 0, 0, 0, 0, 0 },
/* U+6069 */ { 0, 0, 0, 0, 0 },
/* U+606a */ { 0, 0, 0, 0, 0 },
/* U+606b */ { 0, 0, 0, 0, 0 },
/* U+606c */ { 0, 0, 0, 0, 0 },
/* U+606d */ { 0, 0, 0, 0, 0 },
/* U+606e */ { 0, 0, 0, 0, 0 },
/* U+606f */ { 0, 0, 0, 0, 0 },
/* U+6070 */ { 0, 0, 0, 0, 0 },
/* U+6071 */ { 0, 0, 0, 0, 0 },
/* U+6072 */ { 0, 0, 0, 0, 0 },
/* U+6073 */ { 0, 0, 0, 0, 0 },
/* U+6074 */ { 0, 0, 0, 0, 0 },
/* U+6075 */ { 0, 0, 0, 0, 0 },
/* U+6076 */ { 0, 0, 0, 0, 0 },
/* U+6077 */ { 0, 0, 0, 0, 0 },
/* U+6078 */ { 0, 0, 0, 0, 0 },
/* U+6079 */ { 0, 0, 0, 0, 0 },
/* U+607a */ { 0, 0, 0, 0, 0 },
/* U+607b */ { 0, 0, 0, 0, 0 },
/* U+607c */ { 0, 0, 0, 0, 0 },
/* U+607d */ { 0, 0, 0, 0, 0 },
/* U+607e */ { 0, 0, 0, 0, 0 },
/* U+607f */ { 0, 0, 0, 0, 0 },
/* U+6080 */ { 0, 0, 0, 0, 0 },
/* U+6081 */ { 0, 0, 0, 0, 0 },
/* U+6082 */ { 0, 0, 0, 0, 0 },
/* U+6083 */ { 0, 0, 0, 0, 0 },
/* U+6084 */ { 0, 0, 0, 0, 0 },
/* U+6085 */ { 0, 0, 0, 0, 0 },
/* U+6086 */ { 0, 0, 0, 0, 0 },
/* U+6087 */ { 0, 0, 0, 0, 0 },
/* U+6088 */ { 0, 0, 0, 0, 0 },
/* U+6089 */ { 0, 0, 0, 0, 0 },
/* U+608a */ { 0, 0, 0, 0, 0 },
/* U+608b */ { 0, 0, 0, 0, 0 },
/* U+608c */ { 0, 0, 0, 0, 0 },
/* U+608d */ { 0, 0, 0, 0, 0 },
/* U+608e */ { 0, 0, 0, 0, 0 },
/* U+608f */ { 0, 0, 0, 0, 0 },
/* U+6090 */ { 0, 0, 0, 0, 0 },
/* U+6091 */ { 0, 0, 0, 0, 0 },
/* U+6092 */ { 0, 0, 0, 0, 0 },
/* U+6093 */ { 0, 0, 0, 0, 0 },
/* U+6094 */ { 0, 0, 0, 0, 0 },
/* U+6095 */ { 0, 0, 0, 0, 0 },
/* U+6096 */ { 0, 0, 0, 0, 0 },
/* U+6097 */ { 0, 0, 0, 0, 0 },
/* U+6098 */ { 0, 0, 0, 0, 0 },
/* U+6099 */ { 0, 0, 0, 0, 0 },
/* U+609a */ { 0, 0, 0, 0, 0 },
/* U+609b */ { 0, 0, 0, 0, 0 },
/* U+609c */ { 0, 0, 0, 0, 0 },
/* U+609d */ { 0, 0, 0, 0, 0 },
/* U+609e */ { 0, 0, 0, 0, 0 },
/* U+609f */ { 0, 0, 0, 0, 0 },
/* U+60a0 */ { 0, 0, 0, 0, 0 },
/* U+60a1 */ { 0, 0, 0, 0, 0 },
/* U+60a2 */ { 0, 0, 0, 0, 0 },
/* U+60a3 */ { 0, 0, 0, 0, 0 },
/* U+60a4 */ { 0, 0, 0, 0, 0 },
/* U+60a5 */ { 0, 0, 0, 0, 0 },
/* U+60a6 */ { 0, 0, 0, 0, 0 },
/* U+60a7 */ { 0, 0, 0, 0, 0 },
/* U+60a8 */ { 0, 0, 0, 0, 0 },
/* U+60a9 */ { 0, 0, 0, 0, 0 },
/* U+60aa */ { 0, 0, 0, 0, 0 },
/* U+60ab */ { 0, 0, 0, 0, 0 },
/* U+60ac */ { 0, 0, 0, 0, 0 },
/* U+60ad */ { 0, 0, 0, 0, 0 },
/* U+60ae */ { 0, 0, 0, 0, 0 },
/* U+60af */ { 0, 0, 0, 0, 0 },
/* U+60b0 */ { 0, 0, 0, 0, 0 },
/* U+60b1 */ { 0, 0, 0, 0, 0 },
/* U+60b2 */ { 0, 0, 0, 0, 0 },
/* U+60b3 */ { 0, 0, 0, 0, 0 },
/* U+60b4 */ { 0, 0, 0, 0, 0 },
/* U+60b5 */ { 0, 0, 0, 0, 0 },
/* U+60b6 */ { 0, 0, 0, 0, 0 },
/* U+60b7 */ { 0, 0, 0, 0, 0 },
/* U+60b8 */ { 0, 0, 0, 0, 0 },
/* U+60b9 */ { 0, 0, 0, 0, 0 },
/* U+60ba */ { 0, 0, 0, 0, 0 },
/* U+60bb */ { 0, 0, 0, 0, 0 },
/* U+60bc */ { 0, 0, 0, 0, 0 },
/* U+60bd */ { 0, 0, 0, 0, 0 },
/* U+60be */ { 0, 0, 0, 0, 0 },
/* U+60bf */ { 0, 0, 0, 0, 0 },
/* U+60c0 */ { 0, 0, 0, 0, 0 },
/* U+60c1 */ { 0, 0, 0, 0, 0 },
/* U+60c2 */ { 0, 0, 0, 0, 0 },
/* U+60c3 */ { 0, 0, 0, 0, 0 },
/* U+60c4 */ { 0, 0, 0, 0, 0 },
/* U+60c5 */ { 0, 0, 0, 0, 0 },
/* U+60c6 */ { 0, 0, 0, 0, 0 },
/* U+60c7 */ { 0, 0, 0, 0, 0 },
/* U+60c8 */ { 0, 0, 0, 0, 0 },
/* U+60c9 */ { 0, 0, 0, 0, 0 },
/* U+60ca */ { 0, 0, 0, 0, 0 },
/* U+60cb */ { 0, 0, 0, 0, 0 },
/* U+60cc */ { 0, 0, 0, 0, 0 },
/* U+60cd */ { 0, 0, 0, 0, 0 },
/* U+60ce */ { 0, 0, 0, 0, 0 },
/* U+60cf */ { 0, 0, 0, 0, 0 },
/* U+60d0 */ { 0, 0, 0, 0, 0 },
/* U+60d1 */ { 0, 0, 0, 0, 0 },
/* U+60d2 */ { 0, 0, 0, 0, 0 },
/* U+60d3 */ { 0, 0, 0, 0, 0 },
/* U+60d4 */ { 0, 0, 0, 0, 0 },
/* U+60d5 */ { 0, 0, 0, 0, 0 },
/* U+60d6 */ { 0, 0, 0, 0, 0 },
/* U+60d7 */ { 0, 0, 0, 0, 0 },
/* U+60d8 */ { 0, 0, 0, 0, 0 },
/* U+60d9 */ { 0, 0, 0, 0, 0 },
/* U+60da */ { 0, 0, 0, 0, 0 },
/* U+60db */ { 0, 0, 0, 0, 0 },
/* U+60dc */ { 0, 0, 0, 0, 0 },
/* U+60dd */ { 0, 0, 0, 0, 0 },
/* U+60de */ { 0, 0, 0, 0, 0 },
/* U+60df */ { 0, 0, 0, 0, 0 },
/* U+60e0 */ { 0, 0, 0, 0, 0 },
/* U+60e1 */ { 0, 0, 0, 0, 0 },
/* U+60e2 */ { 0, 0, 0, 0, 0 },
/* U+60e3 */ { 0, 0, 0, 0, 0 },
/* U+60e4 */ { 0, 0, 0, 0, 0 },
/* U+60e5 */ { 0, 0, 0, 0, 0 },
/* U+60e6 */ { 0, 0, 0, 0, 0 },
/* U+60e7 */ { 0, 0, 0, 0, 0 },
/* U+60e8 */ { 0, 0, 0, 0, 0 },
/* U+60e9 */ { 0, 0, 0, 0, 0 },
/* U+60ea */ { 0, 0, 0, 0, 0 },
/* U+60eb */ { 0, 0, 0, 0, 0 },
/* U+60ec */ { 0, 0, 0, 0, 0 },
/* U+60ed */ { 0, 0, 0, 0, 0 },
/* U+60ee */ { 0, 0, 0, 0, 0 },
/* U+60ef */ { 0, 0, 0, 0, 0 },
/* U+60f0 */ { 0, 0, 0, 0, 0 },
/* U+60f1 */ { 0, 0, 0, 0, 0 },
/* U+60f2 */ { 0, 0, 0, 0, 0 },
/* U+60f3 */ { 0, 0, 0, 0, 0 },
/* U+60f4 */ { 0, 0, 0, 0, 0 },
/* U+60f5 */ { 0, 0, 0, 0, 0 },
/* U+60f6 */ { 0, 0, 0, 0, 0 },
/* U+60f7 */ { 0, 0, 0, 0, 0 },
/* U+60f8 */ { 0, 0, 0, 0, 0 },
/* U+60f9 */ { 0, 0, 0, 0, 0 },
/* U+60fa */ { 0, 0, 0, 0, 0 },
/* U+60fb */ { 0, 0, 0, 0, 0 },
/* U+60fc */ { 0, 0, 0, 0, 0 },
/* U+60fd */ { 0, 0, 0, 0, 0 },
/* U+60fe */ { 0, 0, 0, 0, 0 },
/* U+60ff */ { 0, 0, 0, 0, 0 },
/* U+6100 */ { 0, 0, 0, 0, 0 },
/* U+6101 */ { 0, 0, 0, 0, 0 },
/* U+6102 */ { 0, 0, 0, 0, 0 },
/* U+6103 */ { 0, 0, 0, 0, 0 },
/* U+6104 */ { 0, 0, 0, 0, 0 },
/* U+6105 */ { 0, 0, 0, 0, 0 },
/* U+6106 */ { 0, 0, 0, 0, 0 },
/* U+6107 */ { 0, 0, 0, 0, 0 },
/* U+6108 */ { 0, 0, 0, 0, 0 },
/* U+6109 */ { 0, 0, 0, 0, 0 },
/* U+610a */ { 0, 0, 0, 0, 0 },
/* U+610b */ { 0, 0, 0, 0, 0 },
/* U+610c */ { 0, 0, 0, 0, 0 },
/* U+610d */ { 0, 0, 0, 0, 0 },
/* U+610e */ { 0, 0, 0, 0, 0 },
/* U+610f */ { 0, 0, 0, 0, 0 },
/* U+6110 */ { 0, 0, 0, 0, 0 },
/* U+6111 */ { 0, 0, 0, 0, 0 },
/* U+6112 */ { 0, 0, 0, 0, 0 },
/* U+6113 */ { 0, 0, 0, 0, 0 },
/* U+6114 */ { 0, 0, 0, 0, 0 },
/* U+6115 */ { 0, 0, 0, 0, 0 },
/* U+6116 */ { 0, 0, 0, 0, 0 },
/* U+6117 */ { 0, 0, 0, 0, 0 },
/* U+6118 */ { 0, 0, 0, 0, 0 },
/* U+6119 */ { 0, 0, 0, 0, 0 },
/* U+611a */ { 0, 0, 0, 0, 0 },
/* U+611b */ { 0, 0, 0, 0, 0 },
/* U+611c */ { 0, 0, 0, 0, 0 },
/* U+611d */ { 0, 0, 0, 0, 0 },
/* U+611e */ { 0, 0, 0, 0, 0 },
/* U+611f */ { 0, 0, 0, 0, 0 },
/* U+6120 */ { 0, 0, 0, 0, 0 },
/* U+6121 */ { 0, 0, 0, 0, 0 },
/* U+6122 */ { 0, 0, 0, 0, 0 },
/* U+6123 */ { 0, 0, 0, 0, 0 },
/* U+6124 */ { 0, 0, 0, 0, 0 },
/* U+6125 */ { 0, 0, 0, 0, 0 },
/* U+6126 */ { 0, 0, 0, 0, 0 },
/* U+6127 */ { 0, 0, 0, 0, 0 },
/* U+6128 */ { 0, 0, 0, 0, 0 },
/* U+6129 */ { 0, 0, 0, 0, 0 },
/* U+612a */ { 0, 0, 0, 0, 0 },
/* U+612b */ { 0, 0, 0, 0, 0 },
/* U+612c */ { 0, 0, 0, 0, 0 },
/* U+612d */ { 0, 0, 0, 0, 0 },
/* U+612e */ { 0, 0, 0, 0, 0 },
/* U+612f */ { 0, 0, 0, 0, 0 },
/* U+6130 */ { 0, 0, 0, 0, 0 },
/* U+6131 */ { 0, 0, 0, 0, 0 },
/* U+6132 */ { 0, 0, 0, 0, 0 },
/* U+6133 */ { 0, 0, 0, 0, 0 },
/* U+6134 */ { 0, 0, 0, 0, 0 },
/* U+6135 */ { 0, 0, 0, 0, 0 },
/* U+6136 */ { 0, 0, 0, 0, 0 },
/* U+6137 */ { 0, 0, 0, 0, 0 },
/* U+6138 */ { 0, 0, 0, 0, 0 },
/* U+6139 */ { 0, 0, 0, 0, 0 },
/* U+613a */ { 0, 0, 0, 0, 0 },
/* U+613b */ { 0, 0, 0, 0, 0 },
/* U+613c */ { 0, 0, 0, 0, 0 },
/* U+613d */ { 0, 0, 0, 0, 0 },
/* U+613e */ { 0, 0, 0, 0, 0 },
/* U+613f */ { 0, 0, 0, 0, 0 },
/* U+6140 */ { 0, 0, 0, 0, 0 },
/* U+6141 */ { 0, 0, 0, 0, 0 },
/* U+6142 */ { 0, 0, 0, 0, 0 },
/* U+6143 */ { 0, 0, 0, 0, 0 },
/* U+6144 */ { 0, 0, 0, 0, 0 },
/* U+6145 */ { 0, 0, 0, 0, 0 },
/* U+6146 */ { 0, 0, 0, 0, 0 },
/* U+6147 */ { 0, 0, 0, 0, 0 },
/* U+6148 */ { 0, 0, 0, 0, 0 },
/* U+6149 */ { 0, 0, 0, 0, 0 },
/* U+614a */ { 0, 0, 0, 0, 0 },
/* U+614b */ { 0, 0, 0, 0, 0 },
/* U+614c */ { 0, 0, 0, 0, 0 },
/* U+614d */ { 0, 0, 0, 0, 0 },
/* U+614e */ { 0, 0, 0, 0, 0 },
/* U+614f */ { 0, 0, 0, 0, 0 },
/* U+6150 */ { 0, 0, 0, 0, 0 },
/* U+6151 */ { 0, 0, 0, 0, 0 },
/* U+6152 */ { 0, 0, 0, 0, 0 },
/* U+6153 */ { 0, 0, 0, 0, 0 },
/* U+6154 */ { 0, 0, 0, 0, 0 },
/* U+6155 */ { 0, 0, 0, 0, 0 },
/* U+6156 */ { 0, 0, 0, 0, 0 },
/* U+6157 */ { 0, 0, 0, 0, 0 },
/* U+6158 */ { 0, 0, 0, 0, 0 },
/* U+6159 */ { 0, 0, 0, 0, 0 },
/* U+615a */ { 0, 0, 0, 0, 0 },
/* U+615b */ { 0, 0, 0, 0, 0 },
/* U+615c */ { 0, 0, 0, 0, 0 },
/* U+615d */ { 0, 0, 0, 0, 0 },
/* U+615e */ { 0, 0, 0, 0, 0 },
/* U+615f */ { 0, 0, 0, 0, 0 },
/* U+6160 */ { 0, 0, 0, 0, 0 },
/* U+6161 */ { 0, 0, 0, 0, 0 },
/* U+6162 */ { 0, 0, 0, 0, 0 },
/* U+6163 */ { 0, 0, 0, 0, 0 },
/* U+6164 */ { 0, 0, 0, 0, 0 },
/* U+6165 */ { 0, 0, 0, 0, 0 },
/* U+6166 */ { 0, 0, 0, 0, 0 },
/* U+6167 */ { 0, 0, 0, 0, 0 },
/* U+6168 */ { 0, 0, 0, 0, 0 },
/* U+6169 */ { 0, 0, 0, 0, 0 },
/* U+616a */ { 0, 0, 0, 0, 0 },
/* U+616b */ { 0, 0, 0, 0, 0 },
/* U+616c */ { 0, 0, 0, 0, 0 },
/* U+616d */ { 0, 0, 0, 0, 0 },
/* U+616e */ { 0, 0, 0, 0, 0 },
/* U+616f */ { 0, 0, 0, 0, 0 },
/* U+6170 */ { 0, 0, 0, 0, 0 },
/* U+6171 */ { 0, 0, 0, 0, 0 },
/* U+6172 */ { 0, 0, 0, 0, 0 },
/* U+6173 */ { 0, 0, 0, 0, 0 },
/* U+6174 */ { 0, 0, 0, 0, 0 },
/* U+6175 */ { 0, 0, 0, 0, 0 },
/* U+6176 */ { 0, 0, 0, 0, 0 },
/* U+6177 */ { 0, 0, 0, 0, 0 },
/* U+6178 */ { 0, 0, 0, 0, 0 },
/* U+6179 */ { 0, 0, 0, 0, 0 },
/* U+617a */ { 0, 0, 0, 0, 0 },
/* U+617b */ { 0, 0, 0, 0, 0 },
/* U+617c */ { 0, 0, 0, 0, 0 },
/* U+617d */ { 0, 0, 0, 0, 0 },
/* U+617e */ { 0, 0, 0, 0, 0 },
/* U+617f */ { 0, 0, 0, 0, 0 },
/* U+6180 */ { 0, 0, 0, 0, 0 },
/* U+6181 */ { 0, 0, 0, 0, 0 },
/* U+6182 */ { 0, 0, 0, 0, 0 },
/* U+6183 */ { 0, 0, 0, 0, 0 },
/* U+6184 */ { 0, 0, 0, 0, 0 },
/* U+6185 */ { 0, 0, 0, 0, 0 },
/* U+6186 */ { 0, 0, 0, 0, 0 },
/* U+6187 */ { 0, 0, 0, 0, 0 },
/* U+6188 */ { 0, 0, 0, 0, 0 },
/* U+6189 */ { 0, 0, 0, 0, 0 },
/* U+618a */ { 0, 0, 0, 0, 0 },
/* U+618b */ { 0, 0, 0, 0, 0 },
/* U+618c */ { 0, 0, 0, 0, 0 },
/* U+618d */ { 0, 0, 0, 0, 0 },
/* U+618e */ { 0, 0, 0, 0, 0 },
/* U+618f */ { 0, 0, 0, 0, 0 },
/* U+6190 */ { 0, 0, 0, 0, 0 },
/* U+6191 */ { 0, 0, 0, 0, 0 },
/* U+6192 */ { 0, 0, 0, 0, 0 },
/* U+6193 */ { 0, 0, 0, 0, 0 },
/* U+6194 */ { 0, 0, 0, 0, 0 },
/* U+6195 */ { 0, 0, 0, 0, 0 },
/* U+6196 */ { 0, 0, 0, 0, 0 },
/* U+6197 */ { 0, 0, 0, 0, 0 },
/* U+6198 */ { 0, 0, 0, 0, 0 },
/* U+6199 */ { 0, 0, 0, 0, 0 },
/* U+619a */ { 0, 0, 0, 0, 0 },
/* U+619b */ { 0, 0, 0, 0, 0 },
/* U+619c */ { 0, 0, 0, 0, 0 },
/* U+619d */ { 0, 0, 0, 0, 0 },
/* U+619e */ { 0, 0, 0, 0, 0 },
/* U+619f */ { 0, 0, 0, 0, 0 },
/* U+61a0 */ { 0, 0, 0, 0, 0 },
/* U+61a1 */ { 0, 0, 0, 0, 0 },
/* U+61a2 */ { 0, 0, 0, 0, 0 },
/* U+61a3 */ { 0, 0, 0, 0, 0 },
/* U+61a4 */ { 0, 0, 0, 0, 0 },
/* U+61a5 */ { 0, 0, 0, 0, 0 },
/* U+61a6 */ { 0, 0, 0, 0, 0 },
/* U+61a7 */ { 0, 0, 0, 0, 0 },
/* U+61a8 */ { 0, 0, 0, 0, 0 },
/* U+61a9 */ { 0, 0, 0, 0, 0 },
/* U+61aa */ { 0, 0, 0, 0, 0 },
/* U+61ab */ { 0, 0, 0, 0, 0 },
/* U+61ac */ { 0, 0, 0, 0, 0 },
/* U+61ad */ { 0, 0, 0, 0, 0 },
/* U+61ae */ { 0, 0, 0, 0, 0 },
/* U+61af */ { 0, 0, 0, 0, 0 },
/* U+61b0 */ { 0, 0, 0, 0, 0 },
/* U+61b1 */ { 0, 0, 0, 0, 0 },
/* U+61b2 */ { 0, 0, 0, 0, 0 },
/* U+61b3 */ { 0, 0, 0, 0, 0 },
/* U+61b4 */ { 0, 0, 0, 0, 0 },
/* U+61b5 */ { 0, 0, 0, 0, 0 },
/* U+61b6 */ { 0, 0, 0, 0, 0 },
/* U+61b7 */ { 0, 0, 0, 0, 0 },
/* U+61b8 */ { 0, 0, 0, 0, 0 },
/* U+61b9 */ { 0, 0, 0, 0, 0 },
/* U+61ba */ { 0, 0, 0, 0, 0 },
/* U+61bb */ { 0, 0, 0, 0, 0 },
/* U+61bc */ { 0, 0, 0, 0, 0 },
/* U+61bd */ { 0, 0, 0, 0, 0 },
/* U+61be */ { 0, 0, 0, 0, 0 },
/* U+61bf */ { 0, 0, 0, 0, 0 },
/* U+61c0 */ { 0, 0, 0, 0, 0 },
/* U+61c1 */ { 0, 0, 0, 0, 0 },
/* U+61c2 */ { 0, 0, 0, 0, 0 },
/* U+61c3 */ { 0, 0, 0, 0, 0 },
/* U+61c4 */ { 0, 0, 0, 0, 0 },
/* U+61c5 */ { 0, 0, 0, 0, 0 },
/* U+61c6 */ { 0, 0, 0, 0, 0 },
/* U+61c7 */ { 0, 0, 0, 0, 0 },
/* U+61c8 */ { 0, 0, 0, 0, 0 },
/* U+61c9 */ { 0, 0, 0, 0, 0 },
/* U+61ca */ { 0, 0, 0, 0, 0 },
/* U+61cb */ { 0, 0, 0, 0, 0 },
/* U+61cc */ { 0, 0, 0, 0, 0 },
/* U+61cd */ { 0, 0, 0, 0, 0 },
/* U+61ce */ { 0, 0, 0, 0, 0 },
/* U+61cf */ { 0, 0, 0, 0, 0 },
/* U+61d0 */ { 0, 0, 0, 0, 0 },
/* U+61d1 */ { 0, 0, 0, 0, 0 },
/* U+61d2 */ { 0, 0, 0, 0, 0 },
/* U+61d3 */ { 0, 0, 0, 0, 0 },
/* U+61d4 */ { 0, 0, 0, 0, 0 },
/* U+61d5 */ { 0, 0, 0, 0, 0 },
/* U+61d6 */ { 0, 0, 0, 0, 0 },
/* U+61d7 */ { 0, 0, 0, 0, 0 },
/* U+61d8 */ { 0, 0, 0, 0, 0 },
/* U+61d9 */ { 0, 0, 0, 0, 0 },
/* U+61da */ { 0, 0, 0, 0, 0 },
/* U+61db */ { 0, 0, 0, 0, 0 },
/* U+61dc */ { 0, 0, 0, 0, 0 },
/* U+61dd */ { 0, 0, 0, 0, 0 },
/* U+61de */ { 0, 0, 0, 0, 0 },
/* U+61df */ { 0, 0, 0, 0, 0 },
/* U+61e0 */ { 0, 0, 0, 0, 0 },
/* U+61e1 */ { 0, 0, 0, 0, 0 },
/* U+61e2 */ { 0, 0, 0, 0, 0 },
/* U+61e3 */ { 0, 0, 0, 0, 0 },
/* U+61e4 */ { 0, 0, 0, 0, 0 },
/* U+61e5 */ { 0, 0, 0, 0, 0 },
/* U+61e6 */ { 0, 0, 0, 0, 0 },
/* U+61e7 */ { 0, 0, 0, 0, 0 },
/* U+61e8 */ { 0, 0, 0, 0, 0 },
/* U+61e9 */ { 0, 0, 0, 0, 0 },
/* U+61ea */ { 0, 0, 0, 0, 0 },
/* U+61eb */ { 0, 0, 0, 0, 0 },
/* U+61ec */ { 0, 0, 0, 0, 0 },
/* U+61ed */ { 0, 0, 0, 0, 0 },
/* U+61ee */ { 0, 0, 0, 0, 0 },
/* U+61ef */ { 0, 0, 0, 0, 0 },
/* U+61f0 */ { 0, 0, 0, 0, 0 },
/* U+61f1 */ { 0, 0, 0, 0, 0 },
/* U+61f2 */ { 0, 0, 0, 0, 0 },
/* U+61f3 */ { 0, 0, 0, 0, 0 },
/* U+61f4 */ { 0, 0, 0, 0, 0 },
/* U+61f5 */ { 0, 0, 0, 0, 0 },
/* U+61f6 */ { 0, 0, 0, 0, 0 },
/* U+61f7 */ { 0, 0, 0, 0, 0 },
/* U+61f8 */ { 0, 0, 0, 0, 0 },
/* U+61f9 */ { 0, 0, 0, 0, 0 },
/* U+61fa */ { 0, 0, 0, 0, 0 },
/* U+61fb */ { 0, 0, 0, 0, 0 },
/* U+61fc */ { 0, 0, 0, 0, 0 },
/* U+61fd */ { 0, 0, 0, 0, 0 },
/* U+61fe */ { 0, 0, 0, 0, 0 },
/* U+61ff */ { 0, 0, 0, 0, 0 },
/* U+6200 */ { 0, 0, 0, 0, 0 },
/* U+6201 */ { 0, 0, 0, 0, 0 },
/* U+6202 */ { 0, 0, 0, 0, 0 },
/* U+6203 */ { 0, 0, 0, 0, 0 },
/* U+6204 */ { 0, 0, 0, 0, 0 },
/* U+6205 */ { 0, 0, 0, 0, 0 },
/* U+6206 */ { 0, 0, 0, 0, 0 },
/* U+6207 */ { 0, 0, 0, 0, 0 },
/* U+6208 */ { 0, 0, 0, 0, 0 },
/* U+6209 */ { 0, 0, 0, 0, 0 },
/* U+620a */ { 0, 0, 0, 0, 0 },
/* U+620b */ { 0, 0, 0, 0, 0 },
/* U+620c */ { 0, 0, 0, 0, 0 },
/* U+620d */ { 0, 0, 0, 0, 0 },
/* U+620e */ { 0, 0, 0, 0, 0 },
/* U+620f */ { 0, 0, 0, 0, 0 },
/* U+6210 */ { 0, 0, 0, 0, 0 },
/* U+6211 */ { 0, 0, 0, 0, 0 },
/* U+6212 */ { 0, 0, 0, 0, 0 },
/* U+6213 */ { 0, 0, 0, 0, 0 },
/* U+6214 */ { 0, 0, 0, 0, 0 },
/* U+6215 */ { 0, 0, 0, 0, 0 },
/* U+6216 */ { 0, 0, 0, 0, 0 },
/* U+6217 */ { 0, 0, 0, 0, 0 },
/* U+6218 */ { 0, 0, 0, 0, 0 },
/* U+6219 */ { 0, 0, 0, 0, 0 },
/* U+621a */ { 0, 0, 0, 0, 0 },
/* U+621b */ { 0, 0, 0, 0, 0 },
/* U+621c */ { 0, 0, 0, 0, 0 },
/* U+621d */ { 0, 0, 0, 0, 0 },
/* U+621e */ { 0, 0, 0, 0, 0 },
/* U+621f */ { 0, 0, 0, 0, 0 },
/* U+6220 */ { 0, 0, 0, 0, 0 },
/* U+6221 */ { 0, 0, 0, 0, 0 },
/* U+6222 */ { 0, 0, 0, 0, 0 },
/* U+6223 */ { 0, 0, 0, 0, 0 },
/* U+6224 */ { 0, 0, 0, 0, 0 },
/* U+6225 */ { 0, 0, 0, 0, 0 },
/* U+6226 */ { 0, 0, 0, 0, 0 },
/* U+6227 */ { 0, 0, 0, 0, 0 },
/* U+6228 */ { 0, 0, 0, 0, 0 },
/* U+6229 */ { 0, 0, 0, 0, 0 },
/* U+622a */ { 0, 0, 0, 0, 0 },
/* U+622b */ { 0, 0, 0, 0, 0 },
/* U+622c */ { 0, 0, 0, 0, 0 },
/* U+622d */ { 0, 0, 0, 0, 0 },
/* U+622e */ { 0, 0, 0, 0, 0 },
/* U+622f */ { 0, 0, 0, 0, 0 },
/* U+6230 */ { 0, 0, 0, 0, 0 },
/* U+6231 */ { 0, 0, 0, 0, 0 },
/* U+6232 */ { 0, 0, 0, 0, 0 },
/* U+6233 */ { 0, 0, 0, 0, 0 },
/* U+6234 */ { 0, 0, 0, 0, 0 },
/* U+6235 */ { 0, 0, 0, 0, 0 },
/* U+6236 */ { 0, 0, 0, 0, 0 },
/* U+6237 */ { 0, 0, 0, 0, 0 },
/* U+6238 */ { 0, 0, 0, 0, 0 },
/* U+6239 */ { 0, 0, 0, 0, 0 },
/* U+623a */ { 0, 0, 0, 0, 0 },
/* U+623b */ { 0, 0, 0, 0, 0 },
/* U+623c */ { 0, 0, 0, 0, 0 },
/* U+623d */ { 0, 0, 0, 0, 0 },
/* U+623e */ { 0, 0, 0, 0, 0 },
/* U+623f */ { 0, 0, 0, 0, 0 },
/* U+6240 */ { 0, 0, 0, 0, 0 },
/* U+6241 */ { 0, 0, 0, 0, 0 },
/* U+6242 */ { 0, 0, 0, 0, 0 },
/* U+6243 */ { 0, 0, 0, 0, 0 },
/* U+6244 */ { 0, 0, 0, 0, 0 },
/* U+6245 */ { 0, 0, 0, 0, 0 },
/* U+6246 */ { 0, 0, 0, 0, 0 },
/* U+6247 */ { 0, 0, 0, 0, 0 },
/* U+6248 */ { 0, 0, 0, 0, 0 },
/* U+6249 */ { 0, 0, 0, 0, 0 },
/* U+624a */ { 0, 0, 0, 0, 0 },
/* U+624b */ { 0, 0, 0, 0, 0 },
/* U+624c */ { 0, 0, 0, 0, 0 },
/* U+624d */ { 0, 0, 0, 0, 0 },
/* U+624e */ { 0, 0, 0, 0, 0 },
/* U+624f */ { 0, 0, 0, 0, 0 },
/* U+6250 */ { 0, 0, 0, 0, 0 },
/* U+6251 */ { 0, 0, 0, 0, 0 },
/* U+6252 */ { 0, 0, 0, 0, 0 },
/* U+6253 */ { 0, 0, 0, 0, 0 },
/* U+6254 */ { 0, 0, 0, 0, 0 },
/* U+6255 */ { 0, 0, 0, 0, 0 },
/* U+6256 */ { 0, 0, 0, 0, 0 },
/* U+6257 */ { 0, 0, 0, 0, 0 },
/* U+6258 */ { 0, 0, 0, 0, 0 },
/* U+6259 */ { 0, 0, 0, 0, 0 },
/* U+625a */ { 0, 0, 0, 0, 0 },
/* U+625b */ { 0, 0, 0, 0, 0 },
/* U+625c */ { 0, 0, 0, 0, 0 },
/* U+625d */ { 0, 0, 0, 0, 0 },
/* U+625e */ { 0, 0, 0, 0, 0 },
/* U+625f */ { 0, 0, 0, 0, 0 },
/* U+6260 */ { 0, 0, 0, 0, 0 },
/* U+6261 */ { 0, 0, 0, 0, 0 },
/* U+6262 */ { 0, 0, 0, 0, 0 },
/* U+6263 */ { 0, 0, 0, 0, 0 },
/* U+6264 */ { 0, 0, 0, 0, 0 },
/* U+6265 */ { 0, 0, 0, 0, 0 },
/* U+6266 */ { 0, 0, 0, 0, 0 },
/* U+6267 */ { 0, 0, 0, 0, 0 },
/* U+6268 */ { 0, 0, 0, 0, 0 },
/* U+6269 */ { 0, 0, 0, 0, 0 },
/* U+626a */ { 0, 0, 0, 0, 0 },
/* U+626b */ { 0, 0, 0, 0, 0 },
/* U+626c */ { 0, 0, 0, 0, 0 },
/* U+626d */ { 0, 0, 0, 0, 0 },
/* U+626e */ { 0, 0, 0, 0, 0 },
/* U+626f */ { 0, 0, 0, 0, 0 },
/* U+6270 */ { 0, 0, 0, 0, 0 },
/* U+6271 */ { 0, 0, 0, 0, 0 },
/* U+6272 */ { 0, 0, 0, 0, 0 },
/* U+6273 */ { 0, 0, 0, 0, 0 },
/* U+6274 */ { 0, 0, 0, 0, 0 },
/* U+6275 */ { 0, 0, 0, 0, 0 },
/* U+6276 */ { 0, 0, 0, 0, 0 },
/* U+6277 */ { 0, 0, 0, 0, 0 },
/* U+6278 */ { 0, 0, 0, 0, 0 },
/* U+6279 */ { 0, 0, 0, 0, 0 },
/* U+627a */ { 0, 0, 0, 0, 0 },
/* U+627b */ { 0, 0, 0, 0, 0 },
/* U+627c */ { 0, 0, 0, 0, 0 },
/* U+627d */ { 0, 0, 0, 0, 0 },
/* U+627e */ { 0, 0, 0, 0, 0 },
/* U+627f */ { 0, 0, 0, 0, 0 },
/* U+6280 */ { 0, 0, 0, 0, 0 },
/* U+6281 */ { 0, 0, 0, 0, 0 },
/* U+6282 */ { 0, 0, 0, 0, 0 },
/* U+6283 */ { 0, 0, 0, 0, 0 },
/* U+6284 */ { 0, 0, 0, 0, 0 },
/* U+6285 */ { 0, 0, 0, 0, 0 },
/* U+6286 */ { 0, 0, 0, 0, 0 },
/* U+6287 */ { 0, 0, 0, 0, 0 },
/* U+6288 */ { 0, 0, 0, 0, 0 },
/* U+6289 */ { 0, 0, 0, 0, 0 },
/* U+628a */ { 0, 0, 0, 0, 0 },
/* U+628b */ { 0, 0, 0, 0, 0 },
/* U+628c */ { 0, 0, 0, 0, 0 },
/* U+628d */ { 0, 0, 0, 0, 0 },
/* U+628e */ { 0, 0, 0, 0, 0 },
/* U+628f */ { 0, 0, 0, 0, 0 },
/* U+6290 */ { 0, 0, 0, 0, 0 },
/* U+6291 */ { 0, 0, 0, 0, 0 },
/* U+6292 */ { 0, 0, 0, 0, 0 },
/* U+6293 */ { 0, 0, 0, 0, 0 },
/* U+6294 */ { 0, 0, 0, 0, 0 },
/* U+6295 */ { 0, 0, 0, 0, 0 },
/* U+6296 */ { 0, 0, 0, 0, 0 },
/* U+6297 */ { 0, 0, 0, 0, 0 },
/* U+6298 */ { 0, 0, 0, 0, 0 },
/* U+6299 */ { 0, 0, 0, 0, 0 },
/* U+629a */ { 0, 0, 0, 0, 0 },
/* U+629b */ { 0, 0, 0, 0, 0 },
/* U+629c */ { 0, 0, 0, 0, 0 },
/* U+629d */ { 0, 0, 0, 0, 0 },
/* U+629e */ { 0, 0, 0, 0, 0 },
/* U+629f */ { 0, 0, 0, 0, 0 },
/* U+62a0 */ { 0, 0, 0, 0, 0 },
/* U+62a1 */ { 0, 0, 0, 0, 0 },
/* U+62a2 */ { 0, 0, 0, 0, 0 },
/* U+62a3 */ { 0, 0, 0, 0, 0 },
/* U+62a4 */ { 0, 0, 0, 0, 0 },
/* U+62a5 */ { 0, 0, 0, 0, 0 },
/* U+62a6 */ { 0, 0, 0, 0, 0 },
/* U+62a7 */ { 0, 0, 0, 0, 0 },
/* U+62a8 */ { 0, 0, 0, 0, 0 },
/* U+62a9 */ { 0, 0, 0, 0, 0 },
/* U+62aa */ { 0, 0, 0, 0, 0 },
/* U+62ab */ { 0, 0, 0, 0, 0 },
/* U+62ac */ { 0, 0, 0, 0, 0 },
/* U+62ad */ { 0, 0, 0, 0, 0 },
/* U+62ae */ { 0, 0, 0, 0, 0 },
/* U+62af */ { 0, 0, 0, 0, 0 },
/* U+62b0 */ { 0, 0, 0, 0, 0 },
/* U+62b1 */ { 0, 0, 0, 0, 0 },
/* U+62b2 */ { 0, 0, 0, 0, 0 },
/* U+62b3 */ { 0, 0, 0, 0, 0 },
/* U+62b4 */ { 0, 0, 0, 0, 0 },
/* U+62b5 */ { 0, 0, 0, 0, 0 },
/* U+62b6 */ { 0, 0, 0, 0, 0 },
/* U+62b7 */ { 0, 0, 0, 0, 0 },
/* U+62b8 */ { 0, 0, 0, 0, 0 },
/* U+62b9 */ { 0, 0, 0, 0, 0 },
/* U+62ba */ { 0, 0, 0, 0, 0 },
/* U+62bb */ { 0, 0, 0, 0, 0 },
/* U+62bc */ { 0, 0, 0, 0, 0 },
/* U+62bd */ { 0, 0, 0, 0, 0 },
/* U+62be */ { 0, 0, 0, 0, 0 },
/* U+62bf */ { 0, 0, 0, 0, 0 },
/* U+62c0 */ { 0, 0, 0, 0, 0 },
/* U+62c1 */ { 0, 0, 0, 0, 0 },
/* U+62c2 */ { 0, 0, 0, 0, 0 },
/* U+62c3 */ { 0, 0, 0, 0, 0 },
/* U+62c4 */ { 0, 0, 0, 0, 0 },
/* U+62c5 */ { 0, 0, 0, 0, 0 },
/* U+62c6 */ { 0, 0, 0, 0, 0 },
/* U+62c7 */ { 0, 0, 0, 0, 0 },
/* U+62c8 */ { 0, 0, 0, 0, 0 },
/* U+62c9 */ { 0, 0, 0, 0, 0 },
/* U+62ca */ { 0, 0, 0, 0, 0 },
/* U+62cb */ { 0, 0, 0, 0, 0 },
/* U+62cc */ { 0, 0, 0, 0, 0 },
/* U+62cd */ { 0, 0, 0, 0, 0 },
/* U+62ce */ { 0, 0, 0, 0, 0 },
/* U+62cf */ { 0, 0, 0, 0, 0 },
/* U+62d0 */ { 0, 0, 0, 0, 0 },
/* U+62d1 */ { 0, 0, 0, 0, 0 },
/* U+62d2 */ { 0, 0, 0, 0, 0 },
/* U+62d3 */ { 0, 0, 0, 0, 0 },
/* U+62d4 */ { 0, 0, 0, 0, 0 },
/* U+62d5 */ { 0, 0, 0, 0, 0 },
/* U+62d6 */ { 0, 0, 0, 0, 0 },
/* U+62d7 */ { 0, 0, 0, 0, 0 },
/* U+62d8 */ { 0, 0, 0, 0, 0 },
/* U+62d9 */ { 0, 0, 0, 0, 0 },
/* U+62da */ { 0, 0, 0, 0, 0 },
/* U+62db */ { 0, 0, 0, 0, 0 },
/* U+62dc */ { 0, 0, 0, 0, 0 },
/* U+62dd */ { 0, 0, 0, 0, 0 },
/* U+62de */ { 0, 0, 0, 0, 0 },
/* U+62df */ { 0, 0, 0, 0, 0 },
/* U+62e0 */ { 0, 0, 0, 0, 0 },
/* U+62e1 */ { 0, 0, 0, 0, 0 },
/* U+62e2 */ { 0, 0, 0, 0, 0 },
/* U+62e3 */ { 0, 0, 0, 0, 0 },
/* U+62e4 */ { 0, 0, 0, 0, 0 },
/* U+62e5 */ { 0, 0, 0, 0, 0 },
/* U+62e6 */ { 0, 0, 0, 0, 0 },
/* U+62e7 */ { 0, 0, 0, 0, 0 },
/* U+62e8 */ { 0, 0, 0, 0, 0 },
/* U+62e9 */ { 0, 0, 0, 0, 0 },
/* U+62ea */ { 0, 0, 0, 0, 0 },
/* U+62eb */ { 0, 0, 0, 0, 0 },
/* U+62ec */ { 0, 0, 0, 0, 0 },
/* U+62ed */ { 0, 0, 0, 0, 0 },
/* U+62ee */ { 0, 0, 0, 0, 0 },
/* U+62ef */ { 0, 0, 0, 0, 0 },
/* U+62f0 */ { 0, 0, 0, 0, 0 },
/* U+62f1 */ { 0, 0, 0, 0, 0 },
/* U+62f2 */ { 0, 0, 0, 0, 0 },
/* U+62f3 */ { 0, 0, 0, 0, 0 },
/* U+62f4 */ { 0, 0, 0, 0, 0 },
/* U+62f5 */ { 0, 0, 0, 0, 0 },
/* U+62f6 */ { 0, 0, 0, 0, 0 },
/* U+62f7 */ { 0, 0, 0, 0, 0 },
/* U+62f8 */ { 0, 0, 0, 0, 0 },
/* U+62f9 */ { 0, 0, 0, 0, 0 },
/* U+62fa */ { 0, 0, 0, 0, 0 },
/* U+62fb */ { 0, 0, 0, 0, 0 },
/* U+62fc */ { 0, 0, 0, 0, 0 },
/* U+62fd */ { 0, 0, 0, 0, 0 },
/* U+62fe */ { 0, 0, 0, 0, 0 },
/* U+62ff */ { 0, 0, 0, 0, 0 },
/* U+6300 */ { 0, 0, 0, 0, 0 },
/* U+6301 */ { 0, 0, 0, 0, 0 },
/* U+6302 */ { 0, 0, 0, 0, 0 },
/* U+6303 */ { 0, 0, 0, 0, 0 },
/* U+6304 */ { 0, 0, 0, 0, 0 },
/* U+6305 */ { 0, 0, 0, 0, 0 },
/* U+6306 */ { 0, 0, 0, 0, 0 },
/* U+6307 */ { 0, 0, 0, 0, 0 },
/* U+6308 */ { 0, 0, 0, 0, 0 },
/* U+6309 */ { 0, 0, 0, 0, 0 },
/* U+630a */ { 0, 0, 0, 0, 0 },
/* U+630b */ { 0, 0, 0, 0, 0 },
/* U+630c */ { 0, 0, 0, 0, 0 },
/* U+630d */ { 0, 0, 0, 0, 0 },
/* U+630e */ { 0, 0, 0, 0, 0 },
/* U+630f */ { 0, 0, 0, 0, 0 },
/* U+6310 */ { 0, 0, 0, 0, 0 },
/* U+6311 */ { 0, 0, 0, 0, 0 },
/* U+6312 */ { 0, 0, 0, 0, 0 },
/* U+6313 */ { 0, 0, 0, 0, 0 },
/* U+6314 */ { 0, 0, 0, 0, 0 },
/* U+6315 */ { 0, 0, 0, 0, 0 },
/* U+6316 */ { 0, 0, 0, 0, 0 },
/* U+6317 */ { 0, 0, 0, 0, 0 },
/* U+6318 */ { 0, 0, 0, 0, 0 },
/* U+6319 */ { 0, 0, 0, 0, 0 },
/* U+631a */ { 0, 0, 0, 0, 0 },
/* U+631b */ { 0, 0, 0, 0, 0 },
/* U+631c */ { 0, 0, 0, 0, 0 },
/* U+631d */ { 0, 0, 0, 0, 0 },
/* U+631e */ { 0, 0, 0, 0, 0 },
/* U+631f */ { 0, 0, 0, 0, 0 },
/* U+6320 */ { 0, 0, 0, 0, 0 },
/* U+6321 */ { 0, 0, 0, 0, 0 },
/* U+6322 */ { 0, 0, 0, 0, 0 },
/* U+6323 */ { 0, 0, 0, 0, 0 },
/* U+6324 */ { 0, 0, 0, 0, 0 },
/* U+6325 */ { 0, 0, 0, 0, 0 },
/* U+6326 */ { 0, 0, 0, 0, 0 },
/* U+6327 */ { 0, 0, 0, 0, 0 },
/* U+6328 */ { 0, 0, 0, 0, 0 },
/* U+6329 */ { 0, 0, 0, 0, 0 },
/* U+632a */ { 0, 0, 0, 0, 0 },
/* U+632b */ { 0, 0, 0, 0, 0 },
/* U+632c */ { 0, 0, 0, 0, 0 },
/* U+632d */ { 0, 0, 0, 0, 0 },
/* U+632e */ { 0, 0, 0, 0, 0 },
/* U+632f */ { 0, 0, 0, 0, 0 },
/* U+6330 */ { 0, 0, 0, 0, 0 },
/* U+6331 */ { 0, 0, 0, 0, 0 },
/* U+6332 */ { 0, 0, 0, 0, 0 },
/* U+6333 */ { 0, 0, 0, 0, 0 },
/* U+6334 */ { 0, 0, 0, 0, 0 },
/* U+6335 */ { 0, 0, 0, 0, 0 },
/* U+6336 */ { 0, 0, 0, 0, 0 },
/* U+6337 */ { 0, 0, 0, 0, 0 },
/* U+6338 */ { 0, 0, 0, 0, 0 },
/* U+6339 */ { 0, 0, 0, 0, 0 },
/* U+633a */ { 0, 0, 0, 0, 0 },
/* U+633b */ { 0, 0, 0, 0, 0 },
/* U+633c */ { 0, 0, 0, 0, 0 },
/* U+633d */ { 0, 0, 0, 0, 0 },
/* U+633e */ { 0, 0, 0, 0, 0 },
/* U+633f */ { 0, 0, 0, 0, 0 },
/* U+6340 */ { 0, 0, 0, 0, 0 },
/* U+6341 */ { 0, 0, 0, 0, 0 },
/* U+6342 */ { 0, 0, 0, 0, 0 },
/* U+6343 */ { 0, 0, 0, 0, 0 },
/* U+6344 */ { 0, 0, 0, 0, 0 },
/* U+6345 */ { 0, 0, 0, 0, 0 },
/* U+6346 */ { 0, 0, 0, 0, 0 },
/* U+6347 */ { 0, 0, 0, 0, 0 },
/* U+6348 */ { 0, 0, 0, 0, 0 },
/* U+6349 */ { 0, 0, 0, 0, 0 },
/* U+634a */ { 0, 0, 0, 0, 0 },
/* U+634b */ { 0, 0, 0, 0, 0 },
/* U+634c */ { 0, 0, 0, 0, 0 },
/* U+634d */ { 0, 0, 0, 0, 0 },
/* U+634e */ { 0, 0, 0, 0, 0 },
/* U+634f */ { 0, 0, 0, 0, 0 },
/* U+6350 */ { 0, 0, 0, 0, 0 },
/* U+6351 */ { 0, 0, 0, 0, 0 },
/* U+6352 */ { 0, 0, 0, 0, 0 },
/* U+6353 */ { 0, 0, 0, 0, 0 },
/* U+6354 */ { 0, 0, 0, 0, 0 },
/* U+6355 */ { 0, 0, 0, 0, 0 },
/* U+6356 */ { 0, 0, 0, 0, 0 },
/* U+6357 */ { 0, 0, 0, 0, 0 },
/* U+6358 */ { 0, 0, 0, 0, 0 },
/* U+6359 */ { 0, 0, 0, 0, 0 },
/* U+635a */ { 0, 0, 0, 0, 0 },
/* U+635b */ { 0, 0, 0, 0, 0 },
/* U+635c */ { 0, 0, 0, 0, 0 },
/* U+635d */ { 0, 0, 0, 0, 0 },
/* U+635e */ { 0, 0, 0, 0, 0 },
/* U+635f */ { 0, 0, 0, 0, 0 },
/* U+6360 */ { 0, 0, 0, 0, 0 },
/* U+6361 */ { 0, 0, 0, 0, 0 },
/* U+6362 */ { 0, 0, 0, 0, 0 },
/* U+6363 */ { 0, 0, 0, 0, 0 },
/* U+6364 */ { 0, 0, 0, 0, 0 },
/* U+6365 */ { 0, 0, 0, 0, 0 },
/* U+6366 */ { 0, 0, 0, 0, 0 },
/* U+6367 */ { 0, 0, 0, 0, 0 },
/* U+6368 */ { 0, 0, 0, 0, 0 },
/* U+6369 */ { 0, 0, 0, 0, 0 },
/* U+636a */ { 0, 0, 0, 0, 0 },
/* U+636b */ { 0, 0, 0, 0, 0 },
/* U+636c */ { 0, 0, 0, 0, 0 },
/* U+636d */ { 0, 0, 0, 0, 0 },
/* U+636e */ { 0, 0, 0, 0, 0 },
/* U+636f */ { 0, 0, 0, 0, 0 },
/* U+6370 */ { 0, 0, 0, 0, 0 },
/* U+6371 */ { 0, 0, 0, 0, 0 },
/* U+6372 */ { 0, 0, 0, 0, 0 },
/* U+6373 */ { 0, 0, 0, 0, 0 },
/* U+6374 */ { 0, 0, 0, 0, 0 },
/* U+6375 */ { 0, 0, 0, 0, 0 },
/* U+6376 */ { 0, 0, 0, 0, 0 },
/* U+6377 */ { 0, 0, 0, 0, 0 },
/* U+6378 */ { 0, 0, 0, 0, 0 },
/* U+6379 */ { 0, 0, 0, 0, 0 },
/* U+637a */ { 0, 0, 0, 0, 0 },
/* U+637b */ { 0, 0, 0, 0, 0 },
/* U+637c */ { 0, 0, 0, 0, 0 },
/* U+637d */ { 0, 0, 0, 0, 0 },
/* U+637e */ { 0, 0, 0, 0, 0 },
/* U+637f */ { 0, 0, 0, 0, 0 },
/* U+6380 */ { 0, 0, 0, 0, 0 },
/* U+6381 */ { 0, 0, 0, 0, 0 },
/* U+6382 */ { 0, 0, 0, 0, 0 },
/* U+6383 */ { 0, 0, 0, 0, 0 },
/* U+6384 */ { 0, 0, 0, 0, 0 },
/* U+6385 */ { 0, 0, 0, 0, 0 },
/* U+6386 */ { 0, 0, 0, 0, 0 },
/* U+6387 */ { 0, 0, 0, 0, 0 },
/* U+6388 */ { 0, 0, 0, 0, 0 },
/* U+6389 */ { 0, 0, 0, 0, 0 },
/* U+638a */ { 0, 0, 0, 0, 0 },
/* U+638b */ { 0, 0, 0, 0, 0 },
/* U+638c */ { 0, 0, 0, 0, 0 },
/* U+638d */ { 0, 0, 0, 0, 0 },
/* U+638e */ { 0, 0, 0, 0, 0 },
/* U+638f */ { 0, 0, 0, 0, 0 },
/* U+6390 */ { 0, 0, 0, 0, 0 },
/* U+6391 */ { 0, 0, 0, 0, 0 },
/* U+6392 */ { 0, 0, 0, 0, 0 },
/* U+6393 */ { 0, 0, 0, 0, 0 },
/* U+6394 */ { 0, 0, 0, 0, 0 },
/* U+6395 */ { 0, 0, 0, 0, 0 },
/* U+6396 */ { 0, 0, 0, 0, 0 },
/* U+6397 */ { 0, 0, 0, 0, 0 },
/* U+6398 */ { 0, 0, 0, 0, 0 },
/* U+6399 */ { 0, 0, 0, 0, 0 },
/* U+639a */ { 0, 0, 0, 0, 0 },
/* U+639b */ { 0, 0, 0, 0, 0 },
/* U+639c */ { 0, 0, 0, 0, 0 },
/* U+639d */ { 0, 0, 0, 0, 0 },
/* U+639e */ { 0, 0, 0, 0, 0 },
/* U+639f */ { 0, 0, 0, 0, 0 },
/* U+63a0 */ { 0, 0, 0, 0, 0 },
/* U+63a1 */ { 0, 0, 0, 0, 0 },
/* U+63a2 */ { 0, 0, 0, 0, 0 },
/* U+63a3 */ { 0, 0, 0, 0, 0 },
/* U+63a4 */ { 0, 0, 0, 0, 0 },
/* U+63a5 */ { 0, 0, 0, 0, 0 },
/* U+63a6 */ { 0, 0, 0, 0, 0 },
/* U+63a7 */ { 0, 0, 0, 0, 0 },
/* U+63a8 */ { 0, 0, 0, 0, 0 },
/* U+63a9 */ { 0, 0, 0, 0, 0 },
/* U+63aa */ { 0, 0, 0, 0, 0 },
/* U+63ab */ { 0, 0, 0, 0, 0 },
/* U+63ac */ { 0, 0, 0, 0, 0 },
/* U+63ad */ { 0, 0, 0, 0, 0 },
/* U+63ae */ { 0, 0, 0, 0, 0 },
/* U+63af */ { 0, 0, 0, 0, 0 },
/* U+63b0 */ { 0, 0, 0, 0, 0 },
/* U+63b1 */ { 0, 0, 0, 0, 0 },
/* U+63b2 */ { 0, 0, 0, 0, 0 },
/* U+63b3 */ { 0, 0, 0, 0, 0 },
/* U+63b4 */ { 0, 0, 0, 0, 0 },
/* U+63b5 */ { 0, 0, 0, 0, 0 },
/* U+63b6 */ { 0, 0, 0, 0, 0 },
/* U+63b7 */ { 0, 0, 0, 0, 0 },
/* U+63b8 */ { 0, 0, 0, 0, 0 },
/* U+63b9 */ { 0, 0, 0, 0, 0 },
/* U+63ba */ { 0, 0, 0, 0, 0 },
/* U+63bb */ { 0, 0, 0, 0, 0 },
/* U+63bc */ { 0, 0, 0, 0, 0 },
/* U+63bd */ { 0, 0, 0, 0, 0 },
/* U+63be */ { 0, 0, 0, 0, 0 },
/* U+63bf */ { 0, 0, 0, 0, 0 },
/* U+63c0 */ { 0, 0, 0, 0, 0 },
/* U+63c1 */ { 0, 0, 0, 0, 0 },
/* U+63c2 */ { 0, 0, 0, 0, 0 },
/* U+63c3 */ { 0, 0, 0, 0, 0 },
/* U+63c4 */ { 0, 0, 0, 0, 0 },
/* U+63c5 */ { 0, 0, 0, 0, 0 },
/* U+63c6 */ { 0, 0, 0, 0, 0 },
/* U+63c7 */ { 0, 0, 0, 0, 0 },
/* U+63c8 */ { 0, 0, 0, 0, 0 },
/* U+63c9 */ { 0, 0, 0, 0, 0 },
/* U+63ca */ { 0, 0, 0, 0, 0 },
/* U+63cb */ { 0, 0, 0, 0, 0 },
/* U+63cc */ { 0, 0, 0, 0, 0 },
/* U+63cd */ { 0, 0, 0, 0, 0 },
/* U+63ce */ { 0, 0, 0, 0, 0 },
/* U+63cf */ { 0, 0, 0, 0, 0 },
/* U+63d0 */ { 0, 0, 0, 0, 0 },
/* U+63d1 */ { 0, 0, 0, 0, 0 },
/* U+63d2 */ { 0, 0, 0, 0, 0 },
/* U+63d3 */ { 0, 0, 0, 0, 0 },
/* U+63d4 */ { 0, 0, 0, 0, 0 },
/* U+63d5 */ { 0, 0, 0, 0, 0 },
/* U+63d6 */ { 0, 0, 0, 0, 0 },
/* U+63d7 */ { 0, 0, 0, 0, 0 },
/* U+63d8 */ { 0, 0, 0, 0, 0 },
/* U+63d9 */ { 0, 0, 0, 0, 0 },
/* U+63da */ { 0, 0, 0, 0, 0 },
/* U+63db */ { 0, 0, 0, 0, 0 },
/* U+63dc */ { 0, 0, 0, 0, 0 },
/* U+63dd */ { 0, 0, 0, 0, 0 },
/* U+63de */ { 0, 0, 0, 0, 0 },
/* U+63df */ { 0, 0, 0, 0, 0 },
/* U+63e0 */ { 0, 0, 0, 0, 0 },
/* U+63e1 */ { 0, 0, 0, 0, 0 },
/* U+63e2 */ { 0, 0, 0, 0, 0 },
/* U+63e3 */ { 0, 0, 0, 0, 0 },
/* U+63e4 */ { 0, 0, 0, 0, 0 },
/* U+63e5 */ { 0, 0, 0, 0, 0 },
/* U+63e6 */ { 0, 0, 0, 0, 0 },
/* U+63e7 */ { 0, 0, 0, 0, 0 },
/* U+63e8 */ { 0, 0, 0, 0, 0 },
/* U+63e9 */ { 0, 0, 0, 0, 0 },
/* U+63ea */ { 0, 0, 0, 0, 0 },
/* U+63eb */ { 0, 0, 0, 0, 0 },
/* U+63ec */ { 0, 0, 0, 0, 0 },
/* U+63ed */ { 0, 0, 0, 0, 0 },
/* U+63ee */ { 0, 0, 0, 0, 0 },
/* U+63ef */ { 0, 0, 0, 0, 0 },
/* U+63f0 */ { 0, 0, 0, 0, 0 },
/* U+63f1 */ { 0, 0, 0, 0, 0 },
/* U+63f2 */ { 0, 0, 0, 0, 0 },
/* U+63f3 */ { 0, 0, 0, 0, 0 },
/* U+63f4 */ { 0, 0, 0, 0, 0 },
/* U+63f5 */ { 0, 0, 0, 0, 0 },
/* U+63f6 */ { 0, 0, 0, 0, 0 },
/* U+63f7 */ { 0, 0, 0, 0, 0 },
/* U+63f8 */ { 0, 0, 0, 0, 0 },
/* U+63f9 */ { 0, 0, 0, 0, 0 },
/* U+63fa */ { 0, 0, 0, 0, 0 },
/* U+63fb */ { 0, 0, 0, 0, 0 },
/* U+63fc */ { 0, 0, 0, 0, 0 },
/* U+63fd */ { 0, 0, 0, 0, 0 },
/* U+63fe */ { 0, 0, 0, 0, 0 },
/* U+63ff */ { 0, 0, 0, 0, 0 },
/* U+6400 */ { 0, 0, 0, 0, 0 },
/* U+6401 */ { 0, 0, 0, 0, 0 },
/* U+6402 */ { 0, 0, 0, 0, 0 },
/* U+6403 */ { 0, 0, 0, 0, 0 },
/* U+6404 */ { 0, 0, 0, 0, 0 },
/* U+6405 */ { 0, 0, 0, 0, 0 },
/* U+6406 */ { 0, 0, 0, 0, 0 },
/* U+6407 */ { 0, 0, 0, 0, 0 },
/* U+6408 */ { 0, 0, 0, 0, 0 },
/* U+6409 */ { 0, 0, 0, 0, 0 },
/* U+640a */ { 0, 0, 0, 0, 0 },
/* U+640b */ { 0, 0, 0, 0, 0 },
/* U+640c */ { 0, 0, 0, 0, 0 },
/* U+640d */ { 0, 0, 0, 0, 0 },
/* U+640e */ { 0, 0, 0, 0, 0 },
/* U+640f */ { 0, 0, 0, 0, 0 },
/* U+6410 */ { 0, 0, 0, 0, 0 },
/* U+6411 */ { 0, 0, 0, 0, 0 },
/* U+6412 */ { 0, 0, 0, 0, 0 },
/* U+6413 */ { 0, 0, 0, 0, 0 },
/* U+6414 */ { 0, 0, 0, 0, 0 },
/* U+6415 */ { 0, 0, 0, 0, 0 },
/* U+6416 */ { 0, 0, 0, 0, 0 },
/* U+6417 */ { 0, 0, 0, 0, 0 },
/* U+6418 */ { 0, 0, 0, 0, 0 },
/* U+6419 */ { 0, 0, 0, 0, 0 },
/* U+641a */ { 0, 0, 0, 0, 0 },
/* U+641b */ { 0, 0, 0, 0, 0 },
/* U+641c */ { 0, 0, 0, 0, 0 },
/* U+641d */ { 0, 0, 0, 0, 0 },
/* U+641e */ { 0, 0, 0, 0, 0 },
/* U+641f */ { 0, 0, 0, 0, 0 },
/* U+6420 */ { 0, 0, 0, 0, 0 },
/* U+6421 */ { 0, 0, 0, 0, 0 },
/* U+6422 */ { 0, 0, 0, 0, 0 },
/* U+6423 */ { 0, 0, 0, 0, 0 },
/* U+6424 */ { 0, 0, 0, 0, 0 },
/* U+6425 */ { 0, 0, 0, 0, 0 },
/* U+6426 */ { 0, 0, 0, 0, 0 },
/* U+6427 */ { 0, 0, 0, 0, 0 },
/* U+6428 */ { 0, 0, 0, 0, 0 },
/* U+6429 */ { 0, 0, 0, 0, 0 },
/* U+642a */ { 0, 0, 0, 0, 0 },
/* U+642b */ { 0, 0, 0, 0, 0 },
/* U+642c */ { 0, 0, 0, 0, 0 },
/* U+642d */ { 0, 0, 0, 0, 0 },
/* U+642e */ { 0, 0, 0, 0, 0 },
/* U+642f */ { 0, 0, 0, 0, 0 },
/* U+6430 */ { 0, 0, 0, 0, 0 },
/* U+6431 */ { 0, 0, 0, 0, 0 },
/* U+6432 */ { 0, 0, 0, 0, 0 },
/* U+6433 */ { 0, 0, 0, 0, 0 },
/* U+6434 */ { 0, 0, 0, 0, 0 },
/* U+6435 */ { 0, 0, 0, 0, 0 },
/* U+6436 */ { 0, 0, 0, 0, 0 },
/* U+6437 */ { 0, 0, 0, 0, 0 },
/* U+6438 */ { 0, 0, 0, 0, 0 },
/* U+6439 */ { 0, 0, 0, 0, 0 },
/* U+643a */ { 0, 0, 0, 0, 0 },
/* U+643b */ { 0, 0, 0, 0, 0 },
/* U+643c */ { 0, 0, 0, 0, 0 },
/* U+643d */ { 0, 0, 0, 0, 0 },
/* U+643e */ { 0, 0, 0, 0, 0 },
/* U+643f */ { 0, 0, 0, 0, 0 },
/* U+6440 */ { 0, 0, 0, 0, 0 },
/* U+6441 */ { 0, 0, 0, 0, 0 },
/* U+6442 */ { 0, 0, 0, 0, 0 },
/* U+6443 */ { 0, 0, 0, 0, 0 },
/* U+6444 */ { 0, 0, 0, 0, 0 },
/* U+6445 */ { 0, 0, 0, 0, 0 },
/* U+6446 */ { 0, 0, 0, 0, 0 },
/* U+6447 */ { 0, 0, 0, 0, 0 },
/* U+6448 */ { 0, 0, 0, 0, 0 },
/* U+6449 */ { 0, 0, 0, 0, 0 },
/* U+644a */ { 0, 0, 0, 0, 0 },
/* U+644b */ { 0, 0, 0, 0, 0 },
/* U+644c */ { 0, 0, 0, 0, 0 },
/* U+644d */ { 0, 0, 0, 0, 0 },
/* U+644e */ { 0, 0, 0, 0, 0 },
/* U+644f */ { 0, 0, 0, 0, 0 },
/* U+6450 */ { 0, 0, 0, 0, 0 },
/* U+6451 */ { 0, 0, 0, 0, 0 },
/* U+6452 */ { 0, 0, 0, 0, 0 },
/* U+6453 */ { 0, 0, 0, 0, 0 },
/* U+6454 */ { 0, 0, 0, 0, 0 },
/* U+6455 */ { 0, 0, 0, 0, 0 },
/* U+6456 */ { 0, 0, 0, 0, 0 },
/* U+6457 */ { 0, 0, 0, 0, 0 },
/* U+6458 */ { 0, 0, 0, 0, 0 },
/* U+6459 */ { 0, 0, 0, 0, 0 },
/* U+645a */ { 0, 0, 0, 0, 0 },
/* U+645b */ { 0, 0, 0, 0, 0 },
/* U+645c */ { 0, 0, 0, 0, 0 },
/* U+645d */ { 0, 0, 0, 0, 0 },
/* U+645e */ { 0, 0, 0, 0, 0 },
/* U+645f */ { 0, 0, 0, 0, 0 },
/* U+6460 */ { 0, 0, 0, 0, 0 },
/* U+6461 */ { 0, 0, 0, 0, 0 },
/* U+6462 */ { 0, 0, 0, 0, 0 },
/* U+6463 */ { 0, 0, 0, 0, 0 },
/* U+6464 */ { 0, 0, 0, 0, 0 },
/* U+6465 */ { 0, 0, 0, 0, 0 },
/* U+6466 */ { 0, 0, 0, 0, 0 },
/* U+6467 */ { 0, 0, 0, 0, 0 },
/* U+6468 */ { 0, 0, 0, 0, 0 },
/* U+6469 */ { 0, 0, 0, 0, 0 },
/* U+646a */ { 0, 0, 0, 0, 0 },
/* U+646b */ { 0, 0, 0, 0, 0 },
/* U+646c */ { 0, 0, 0, 0, 0 },
/* U+646d */ { 0, 0, 0, 0, 0 },
/* U+646e */ { 0, 0, 0, 0, 0 },
/* U+646f */ { 0, 0, 0, 0, 0 },
/* U+6470 */ { 0, 0, 0, 0, 0 },
/* U+6471 */ { 0, 0, 0, 0, 0 },
/* U+6472 */ { 0, 0, 0, 0, 0 },
/* U+6473 */ { 0, 0, 0, 0, 0 },
/* U+6474 */ { 0, 0, 0, 0, 0 },
/* U+6475 */ { 0, 0, 0, 0, 0 },
/* U+6476 */ { 0, 0, 0, 0, 0 },
/* U+6477 */ { 0, 0, 0, 0, 0 },
/* U+6478 */ { 0, 0, 0, 0, 0 },
/* U+6479 */ { 0, 0, 0, 0, 0 },
/* U+647a */ { 0, 0, 0, 0, 0 },
/* U+647b */ { 0, 0, 0, 0, 0 },
/* U+647c */ { 0, 0, 0, 0, 0 },
/* U+647d */ { 0, 0, 0, 0, 0 },
/* U+647e */ { 0, 0, 0, 0, 0 },
/* U+647f */ { 0, 0, 0, 0, 0 },
/* U+6480 */ { 0, 0, 0, 0, 0 },
/* U+6481 */ { 0, 0, 0, 0, 0 },
/* U+6482 */ { 0, 0, 0, 0, 0 },
/* U+6483 */ { 0, 0, 0, 0, 0 },
/* U+6484 */ { 0, 0, 0, 0, 0 },
/* U+6485 */ { 0, 0, 0, 0, 0 },
/* U+6486 */ { 0, 0, 0, 0, 0 },
/* U+6487 */ { 0, 0, 0, 0, 0 },
/* U+6488 */ { 0, 0, 0, 0, 0 },
/* U+6489 */ { 0, 0, 0, 0, 0 },
/* U+648a */ { 0, 0, 0, 0, 0 },
/* U+648b */ { 0, 0, 0, 0, 0 },
/* U+648c */ { 0, 0, 0, 0, 0 },
/* U+648d */ { 0, 0, 0, 0, 0 },
/* U+648e */ { 0, 0, 0, 0, 0 },
/* U+648f */ { 0, 0, 0, 0, 0 },
/* U+6490 */ { 0, 0, 0, 0, 0 },
/* U+6491 */ { 0, 0, 0, 0, 0 },
/* U+6492 */ { 0, 0, 0, 0, 0 },
/* U+6493 */ { 0, 0, 0, 0, 0 },
/* U+6494 */ { 0, 0, 0, 0, 0 },
/* U+6495 */ { 0, 0, 0, 0, 0 },
/* U+6496 */ { 0, 0, 0, 0, 0 },
/* U+6497 */ { 0, 0, 0, 0, 0 },
/* U+6498 */ { 0, 0, 0, 0, 0 },
/* U+6499 */ { 0, 0, 0, 0, 0 },
/* U+649a */ { 0, 0, 0, 0, 0 },
/* U+649b */ { 0, 0, 0, 0, 0 },
/* U+649c */ { 0, 0, 0, 0, 0 },
/* U+649d */ { 0, 0, 0, 0, 0 },
/* U+649e */ { 0, 0, 0, 0, 0 },
/* U+649f */ { 0, 0, 0, 0, 0 },
/* U+64a0 */ { 0, 0, 0, 0, 0 },
/* U+64a1 */ { 0, 0, 0, 0, 0 },
/* U+64a2 */ { 0, 0, 0, 0, 0 },
/* U+64a3 */ { 0, 0, 0, 0, 0 },
/* U+64a4 */ { 0, 0, 0, 0, 0 },
/* U+64a5 */ { 0, 0, 0, 0, 0 },
/* U+64a6 */ { 0, 0, 0, 0, 0 },
/* U+64a7 */ { 0, 0, 0, 0, 0 },
/* U+64a8 */ { 0, 0, 0, 0, 0 },
/* U+64a9 */ { 0, 0, 0, 0, 0 },
/* U+64aa */ { 0, 0, 0, 0, 0 },
/* U+64ab */ { 0, 0, 0, 0, 0 },
/* U+64ac */ { 0, 0, 0, 0, 0 },
/* U+64ad */ { 0, 0, 0, 0, 0 },
/* U+64ae */ { 0, 0, 0, 0, 0 },
/* U+64af */ { 0, 0, 0, 0, 0 },
/* U+64b0 */ { 0, 0, 0, 0, 0 },
/* U+64b1 */ { 0, 0, 0, 0, 0 },
/* U+64b2 */ { 0, 0, 0, 0, 0 },
/* U+64b3 */ { 0, 0, 0, 0, 0 },
/* U+64b4 */ { 0, 0, 0, 0, 0 },
/* U+64b5 */ { 0, 0, 0, 0, 0 },
/* U+64b6 */ { 0, 0, 0, 0, 0 },
/* U+64b7 */ { 0, 0, 0, 0, 0 },
/* U+64b8 */ { 0, 0, 0, 0, 0 },
/* U+64b9 */ { 0, 0, 0, 0, 0 },
/* U+64ba */ { 0, 0, 0, 0, 0 },
/* U+64bb */ { 0, 0, 0, 0, 0 },
/* U+64bc */ { 0, 0, 0, 0, 0 },
/* U+64bd */ { 0, 0, 0, 0, 0 },
/* U+64be */ { 0, 0, 0, 0, 0 },
/* U+64bf */ { 0, 0, 0, 0, 0 },
/* U+64c0 */ { 0, 0, 0, 0, 0 },
/* U+64c1 */ { 0, 0, 0, 0, 0 },
/* U+64c2 */ { 0, 0, 0, 0, 0 },
/* U+64c3 */ { 0, 0, 0, 0, 0 },
/* U+64c4 */ { 0, 0, 0, 0, 0 },
/* U+64c5 */ { 0, 0, 0, 0, 0 },
/* U+64c6 */ { 0, 0, 0, 0, 0 },
/* U+64c7 */ { 0, 0, 0, 0, 0 },
/* U+64c8 */ { 0, 0, 0, 0, 0 },
/* U+64c9 */ { 0, 0, 0, 0, 0 },
/* U+64ca */ { 0, 0, 0, 0, 0 },
/* U+64cb */ { 0, 0, 0, 0, 0 },
/* U+64cc */ { 0, 0, 0, 0, 0 },
/* U+64cd */ { 0, 0, 0, 0, 0 },
/* U+64ce */ { 0, 0, 0, 0, 0 },
/* U+64cf */ { 0, 0, 0, 0, 0 },
/* U+64d0 */ { 0, 0, 0, 0, 0 },
/* U+64d1 */ { 0, 0, 0, 0, 0 },
/* U+64d2 */ { 0, 0, 0, 0, 0 },
/* U+64d3 */ { 0, 0, 0, 0, 0 },
/* U+64d4 */ { 0, 0, 0, 0, 0 },
/* U+64d5 */ { 0, 0, 0, 0, 0 },
/* U+64d6 */ { 0, 0, 0, 0, 0 },
/* U+64d7 */ { 0, 0, 0, 0, 0 },
/* U+64d8 */ { 0, 0, 0, 0, 0 },
/* U+64d9 */ { 0, 0, 0, 0, 0 },
/* U+64da */ { 0, 0, 0, 0, 0 },
/* U+64db */ { 0, 0, 0, 0, 0 },
/* U+64dc */ { 0, 0, 0, 0, 0 },
/* U+64dd */ { 0, 0, 0, 0, 0 },
/* U+64de */ { 0, 0, 0, 0, 0 },
/* U+64df */ { 0, 0, 0, 0, 0 },
/* U+64e0 */ { 0, 0, 0, 0, 0 },
/* U+64e1 */ { 0, 0, 0, 0, 0 },
/* U+64e2 */ { 0, 0, 0, 0, 0 },
/* U+64e3 */ { 0, 0, 0, 0, 0 },
/* U+64e4 */ { 0, 0, 0, 0, 0 },
/* U+64e5 */ { 0, 0, 0, 0, 0 },
/* U+64e6 */ { 0, 0, 0, 0, 0 },
/* U+64e7 */ { 0, 0, 0, 0, 0 },
/* U+64e8 */ { 0, 0, 0, 0, 0 },
/* U+64e9 */ { 0, 0, 0, 0, 0 },
/* U+64ea */ { 0, 0, 0, 0, 0 },
/* U+64eb */ { 0, 0, 0, 0, 0 },
/* U+64ec */ { 0, 0, 0, 0, 0 },
/* U+64ed */ { 0, 0, 0, 0, 0 },
/* U+64ee */ { 0, 0, 0, 0, 0 },
/* U+64ef */ { 0, 0, 0, 0, 0 },
/* U+64f0 */ { 0, 0, 0, 0, 0 },
/* U+64f1 */ { 0, 0, 0, 0, 0 },
/* U+64f2 */ { 0, 0, 0, 0, 0 },
/* U+64f3 */ { 0, 0, 0, 0, 0 },
/* U+64f4 */ { 0, 0, 0, 0, 0 },
/* U+64f5 */ { 0, 0, 0, 0, 0 },
/* U+64f6 */ { 0, 0, 0, 0, 0 },
/* U+64f7 */ { 0, 0, 0, 0, 0 },
/* U+64f8 */ { 0, 0, 0, 0, 0 },
/* U+64f9 */ { 0, 0, 0, 0, 0 },
/* U+64fa */ { 0, 0, 0, 0, 0 },
/* U+64fb */ { 0, 0, 0, 0, 0 },
/* U+64fc */ { 0, 0, 0, 0, 0 },
/* U+64fd */ { 0, 0, 0, 0, 0 },
/* U+64fe */ { 0, 0, 0, 0, 0 },
/* U+64ff */ { 0, 0, 0, 0, 0 },
/* U+6500 */ { 0, 0, 0, 0, 0 },
/* U+6501 */ { 0, 0, 0, 0, 0 },
/* U+6502 */ { 0, 0, 0, 0, 0 },
/* U+6503 */ { 0, 0, 0, 0, 0 },
/* U+6504 */ { 0, 0, 0, 0, 0 },
/* U+6505 */ { 0, 0, 0, 0, 0 },
/* U+6506 */ { 0, 0, 0, 0, 0 },
/* U+6507 */ { 0, 0, 0, 0, 0 },
/* U+6508 */ { 0, 0, 0, 0, 0 },
/* U+6509 */ { 0, 0, 0, 0, 0 },
/* U+650a */ { 0, 0, 0, 0, 0 },
/* U+650b */ { 0, 0, 0, 0, 0 },
/* U+650c */ { 0, 0, 0, 0, 0 },
/* U+650d */ { 0, 0, 0, 0, 0 },
/* U+650e */ { 0, 0, 0, 0, 0 },
/* U+650f */ { 0, 0, 0, 0, 0 },
/* U+6510 */ { 0, 0, 0, 0, 0 },
/* U+6511 */ { 0, 0, 0, 0, 0 },
/* U+6512 */ { 0, 0, 0, 0, 0 },
/* U+6513 */ { 0, 0, 0, 0, 0 },
/* U+6514 */ { 0, 0, 0, 0, 0 },
/* U+6515 */ { 0, 0, 0, 0, 0 },
/* U+6516 */ { 0, 0, 0, 0, 0 },
/* U+6517 */ { 0, 0, 0, 0, 0 },
/* U+6518 */ { 0, 0, 0, 0, 0 },
/* U+6519 */ { 0, 0, 0, 0, 0 },
/* U+651a */ { 0, 0, 0, 0, 0 },
/* U+651b */ { 0, 0, 0, 0, 0 },
/* U+651c */ { 0, 0, 0, 0, 0 },
/* U+651d */ { 0, 0, 0, 0, 0 },
/* U+651e */ { 0, 0, 0, 0, 0 },
/* U+651f */ { 0, 0, 0, 0, 0 },
/* U+6520 */ { 0, 0, 0, 0, 0 },
/* U+6521 */ { 0, 0, 0, 0, 0 },
/* U+6522 */ { 0, 0, 0, 0, 0 },
/* U+6523 */ { 0, 0, 0, 0, 0 },
/* U+6524 */ { 0, 0, 0, 0, 0 },
/* U+6525 */ { 0, 0, 0, 0, 0 },
/* U+6526 */ { 0, 0, 0, 0, 0 },
/* U+6527 */ { 0, 0, 0, 0, 0 },
/* U+6528 */ { 0, 0, 0, 0, 0 },
/* U+6529 */ { 0, 0, 0, 0, 0 },
/* U+652a */ { 0, 0, 0, 0, 0 },
/* U+652b */ { 0, 0, 0, 0, 0 },
/* U+652c */ { 0, 0, 0, 0, 0 },
/* U+652d */ { 0, 0, 0, 0, 0 },
/* U+652e */ { 0, 0, 0, 0, 0 },
/* U+652f */ { 0, 0, 0, 0, 0 },
/* U+6530 */ { 0, 0, 0, 0, 0 },
/* U+6531 */ { 0, 0, 0, 0, 0 },
/* U+6532 */ { 0, 0, 0, 0, 0 },
/* U+6533 */ { 0, 0, 0, 0, 0 },
/* U+6534 */ { 0, 0, 0, 0, 0 },
/* U+6535 */ { 0, 0, 0, 0, 0 },
/* U+6536 */ { 0, 0, 0, 0, 0 },
/* U+6537 */ { 0, 0, 0, 0, 0 },
/* U+6538 */ { 0, 0, 0, 0, 0 },
/* U+6539 */ { 0, 0, 0, 0, 0 },
/* U+653a */ { 0, 0, 0, 0, 0 },
/* U+653b */ { 0, 0, 0, 0, 0 },
/* U+653c */ { 0, 0, 0, 0, 0 },
/* U+653d */ { 0, 0, 0, 0, 0 },
/* U+653e */ { 0, 0, 0, 0, 0 },
/* U+653f */ { 0, 0, 0, 0, 0 },
/* U+6540 */ { 0, 0, 0, 0, 0 },
/* U+6541 */ { 0, 0, 0, 0, 0 },
/* U+6542 */ { 0, 0, 0, 0, 0 },
/* U+6543 */ { 0, 0, 0, 0, 0 },
/* U+6544 */ { 0, 0, 0, 0, 0 },
/* U+6545 */ { 0, 0, 0, 0, 0 },
/* U+6546 */ { 0, 0, 0, 0, 0 },
/* U+6547 */ { 0, 0, 0, 0, 0 },
/* U+6548 */ { 0, 0, 0, 0, 0 },
/* U+6549 */ { 0, 0, 0, 0, 0 },
/* U+654a */ { 0, 0, 0, 0, 0 },
/* U+654b */ { 0, 0, 0, 0, 0 },
/* U+654c */ { 0, 0, 0, 0, 0 },
/* U+654d */ { 0, 0, 0, 0, 0 },
/* U+654e */ { 0, 0, 0, 0, 0 },
/* U+654f */ { 0, 0, 0, 0, 0 },
/* U+6550 */ { 0, 0, 0, 0, 0 },
/* U+6551 */ { 0, 0, 0, 0, 0 },
/* U+6552 */ { 0, 0, 0, 0, 0 },
/* U+6553 */ { 0, 0, 0, 0, 0 },
/* U+6554 */ { 0, 0, 0, 0, 0 },
/* U+6555 */ { 0, 0, 0, 0, 0 },
/* U+6556 */ { 0, 0, 0, 0, 0 },
/* U+6557 */ { 0, 0, 0, 0, 0 },
/* U+6558 */ { 0, 0, 0, 0, 0 },
/* U+6559 */ { 0, 0, 0, 0, 0 },
/* U+655a */ { 0, 0, 0, 0, 0 },
/* U+655b */ { 0, 0, 0, 0, 0 },
/* U+655c */ { 0, 0, 0, 0, 0 },
/* U+655d */ { 0, 0, 0, 0, 0 },
/* U+655e */ { 0, 0, 0, 0, 0 },
/* U+655f */ { 0, 0, 0, 0, 0 },
/* U+6560 */ { 0, 0, 0, 0, 0 },
/* U+6561 */ { 0, 0, 0, 0, 0 },
/* U+6562 */ { 0, 0, 0, 0, 0 },
/* U+6563 */ { 0, 0, 0, 0, 0 },
/* U+6564 */ { 0, 0, 0, 0, 0 },
/* U+6565 */ { 0, 0, 0, 0, 0 },
/* U+6566 */ { 0, 0, 0, 0, 0 },
/* U+6567 */ { 0, 0, 0, 0, 0 },
/* U+6568 */ { 0, 0, 0, 0, 0 },
/* U+6569 */ { 0, 0, 0, 0, 0 },
/* U+656a */ { 0, 0, 0, 0, 0 },
/* U+656b */ { 0, 0, 0, 0, 0 },
/* U+656c */ { 0, 0, 0, 0, 0 },
/* U+656d */ { 0, 0, 0, 0, 0 },
/* U+656e */ { 0, 0, 0, 0, 0 },
/* U+656f */ { 0, 0, 0, 0, 0 },
/* U+6570 */ { 0, 0, 0, 0, 0 },
/* U+6571 */ { 0, 0, 0, 0, 0 },
/* U+6572 */ { 0, 0, 0, 0, 0 },
/* U+6573 */ { 0, 0, 0, 0, 0 },
/* U+6574 */ { 0, 0, 0, 0, 0 },
/* U+6575 */ { 0, 0, 0, 0, 0 },
/* U+6576 */ { 0, 0, 0, 0, 0 },
/* U+6577 */ { 0, 0, 0, 0, 0 },
/* U+6578 */ { 0, 0, 0, 0, 0 },
/* U+6579 */ { 0, 0, 0, 0, 0 },
/* U+657a */ { 0, 0, 0, 0, 0 },
/* U+657b */ { 0, 0, 0, 0, 0 },
/* U+657c */ { 0, 0, 0, 0, 0 },
/* U+657d */ { 0, 0, 0, 0, 0 },
/* U+657e */ { 0, 0, 0, 0, 0 },
/* U+657f */ { 0, 0, 0, 0, 0 },
/* U+6580 */ { 0, 0, 0, 0, 0 },
/* U+6581 */ { 0, 0, 0, 0, 0 },
/* U+6582 */ { 0, 0, 0, 0, 0 },
/* U+6583 */ { 0, 0, 0, 0, 0 },
/* U+6584 */ { 0, 0, 0, 0, 0 },
/* U+6585 */ { 0, 0, 0, 0, 0 },
/* U+6586 */ { 0, 0, 0, 0, 0 },
/* U+6587 */ { 0, 0, 0, 0, 0 },
/* U+6588 */ { 0, 0, 0, 0, 0 },
/* U+6589 */ { 0, 0, 0, 0, 0 },
/* U+658a */ { 0, 0, 0, 0, 0 },
/* U+658b */ { 0, 0, 0, 0, 0 },
/* U+658c */ { 0, 0, 0, 0, 0 },
/* U+658d */ { 0, 0, 0, 0, 0 },
/* U+658e */ { 0, 0, 0, 0, 0 },
/* U+658f */ { 0, 0, 0, 0, 0 },
/* U+6590 */ { 0, 0, 0, 0, 0 },
/* U+6591 */ { 0, 0, 0, 0, 0 },
/* U+6592 */ { 0, 0, 0, 0, 0 },
/* U+6593 */ { 0, 0, 0, 0, 0 },
/* U+6594 */ { 0, 0, 0, 0, 0 },
/* U+6595 */ { 0, 0, 0, 0, 0 },
/* U+6596 */ { 0, 0, 0, 0, 0 },
/* U+6597 */ { 0, 0, 0, 0, 0 },
/* U+6598 */ { 0, 0, 0, 0, 0 },
/* U+6599 */ { 0, 0, 0, 0, 0 },
/* U+659a */ { 0, 0, 0, 0, 0 },
/* U+659b */ { 0, 0, 0, 0, 0 },
/* U+659c */ { 0, 0, 0, 0, 0 },
/* U+659d */ { 0, 0, 0, 0, 0 },
/* U+659e */ { 0, 0, 0, 0, 0 },
/* U+659f */ { 0, 0, 0, 0, 0 },
/* U+65a0 */ { 0, 0, 0, 0, 0 },
/* U+65a1 */ { 0, 0, 0, 0, 0 },
/* U+65a2 */ { 0, 0, 0, 0, 0 },
/* U+65a3 */ { 0, 0, 0, 0, 0 },
/* U+65a4 */ { 0, 0, 0, 0, 0 },
/* U+65a5 */ { 0, 0, 0, 0, 0 },
/* U+65a6 */ { 0, 0, 0, 0, 0 },
/* U+65a7 */ { 0, 0, 0, 0, 0 },
/* U+65a8 */ { 0, 0, 0, 0, 0 },
/* U+65a9 */ { 0, 0, 0, 0, 0 },
/* U+65aa */ { 0, 0, 0, 0, 0 },
/* U+65ab */ { 0, 0, 0, 0, 0 },
/* U+65ac */ { 0, 0, 0, 0, 0 },
/* U+65ad */ { 0, 0, 0, 0, 0 },
/* U+65ae */ { 0, 0, 0, 0, 0 },
/* U+65af */ { 0, 0, 0, 0, 0 },
/* U+65b0 */ { 0, 0, 0, 0, 0 },
/* U+65b1 */ { 0, 0, 0, 0, 0 },
/* U+65b2 */ { 0, 0, 0, 0, 0 },
/* U+65b3 */ { 0, 0, 0, 0, 0 },
/* U+65b4 */ { 0, 0, 0, 0, 0 },
/* U+65b5 */ { 0, 0, 0, 0, 0 },
/* U+65b6 */ { 0, 0, 0, 0, 0 },
/* U+65b7 */ { 0, 0, 0, 0, 0 },
/* U+65b8 */ { 0, 0, 0, 0, 0 },
/* U+65b9 */ { 0, 0, 0, 0, 0 },
/* U+65ba */ { 0, 0, 0, 0, 0 },
/* U+65bb */ { 0, 0, 0, 0, 0 },
/* U+65bc */ { 0, 0, 0, 0, 0 },
/* U+65bd */ { 0, 0, 0, 0, 0 },
/* U+65be */ { 0, 0, 0, 0, 0 },
/* U+65bf */ { 0, 0, 0, 0, 0 },
/* U+65c0 */ { 0, 0, 0, 0, 0 },
/* U+65c1 */ { 0, 0, 0, 0, 0 },
/* U+65c2 */ { 0, 0, 0, 0, 0 },
/* U+65c3 */ { 0, 0, 0, 0, 0 },
/* U+65c4 */ { 0, 0, 0, 0, 0 },
/* U+65c5 */ { 0, 0, 0, 0, 0 },
/* U+65c6 */ { 0, 0, 0, 0, 0 },
/* U+65c7 */ { 0, 0, 0, 0, 0 },
/* U+65c8 */ { 0, 0, 0, 0, 0 },
/* U+65c9 */ { 0, 0, 0, 0, 0 },
/* U+65ca */ { 0, 0, 0, 0, 0 },
/* U+65cb */ { 0, 0, 0, 0, 0 },
/* U+65cc */ { 0, 0, 0, 0, 0 },
/* U+65cd */ { 0, 0, 0, 0, 0 },
/* U+65ce */ { 0, 0, 0, 0, 0 },
/* U+65cf */ { 0, 0, 0, 0, 0 },
/* U+65d0 */ { 0, 0, 0, 0, 0 },
/* U+65d1 */ { 0, 0, 0, 0, 0 },
/* U+65d2 */ { 0, 0, 0, 0, 0 },
/* U+65d3 */ { 0, 0, 0, 0, 0 },
/* U+65d4 */ { 0, 0, 0, 0, 0 },
/* U+65d5 */ { 0, 0, 0, 0, 0 },
/* U+65d6 */ { 0, 0, 0, 0, 0 },
/* U+65d7 */ { 0, 0, 0, 0, 0 },
/* U+65d8 */ { 0, 0, 0, 0, 0 },
/* U+65d9 */ { 0, 0, 0, 0, 0 },
/* U+65da */ { 0, 0, 0, 0, 0 },
/* U+65db */ { 0, 0, 0, 0, 0 },
/* U+65dc */ { 0, 0, 0, 0, 0 },
/* U+65dd */ { 0, 0, 0, 0, 0 },
/* U+65de */ { 0, 0, 0, 0, 0 },
/* U+65df */ { 0, 0, 0, 0, 0 },
/* U+65e0 */ { 0, 0, 0, 0, 0 },
/* U+65e1 */ { 0, 0, 0, 0, 0 },
/* U+65e2 */ { 0, 0, 0, 0, 0 },
/* U+65e3 */ { 0, 0, 0, 0, 0 },
/* U+65e4 */ { 0, 0, 0, 0, 0 },
/* U+65e5 */ { 0, 0, 0, 0, 0 },
/* U+65e6 */ { 0, 0, 0, 0, 0 },
/* U+65e7 */ { 0, 0, 0, 0, 0 },
/* U+65e8 */ { 0, 0, 0, 0, 0 },
/* U+65e9 */ { 0, 0, 0, 0, 0 },
/* U+65ea */ { 0, 0, 0, 0, 0 },
/* U+65eb */ { 0, 0, 0, 0, 0 },
/* U+65ec */ { 0, 0, 0, 0, 0 },
/* U+65ed */ { 0, 0, 0, 0, 0 },
/* U+65ee */ { 0, 0, 0, 0, 0 },
/* U+65ef */ { 0, 0, 0, 0, 0 },
/* U+65f0 */ { 0, 0, 0, 0, 0 },
/* U+65f1 */ { 0, 0, 0, 0, 0 },
/* U+65f2 */ { 0, 0, 0, 0, 0 },
/* U+65f3 */ { 0, 0, 0, 0, 0 },
/* U+65f4 */ { 0, 0, 0, 0, 0 },
/* U+65f5 */ { 0, 0, 0, 0, 0 },
/* U+65f6 */ { 0, 0, 0, 0, 0 },
/* U+65f7 */ { 0, 0, 0, 0, 0 },
/* U+65f8 */ { 0, 0, 0, 0, 0 },
/* U+65f9 */ { 0, 0, 0, 0, 0 },
/* U+65fa */ { 0, 0, 0, 0, 0 },
/* U+65fb */ { 0, 0, 0, 0, 0 },
/* U+65fc */ { 0, 0, 0, 0, 0 },
/* U+65fd */ { 0, 0, 0, 0, 0 },
/* U+65fe */ { 0, 0, 0, 0, 0 },
/* U+65ff */ { 0, 0, 0, 0, 0 },
/* U+6600 */ { 0, 0, 0, 0, 0 },
/* U+6601 */ { 0, 0, 0, 0, 0 },
/* U+6602 */ { 0, 0, 0, 0, 0 },
/* U+6603 */ { 0, 0, 0, 0, 0 },
/* U+6604 */ { 0, 0, 0, 0, 0 },
/* U+6605 */ { 0, 0, 0, 0, 0 },
/* U+6606 */ { 0, 0, 0, 0, 0 },
/* U+6607 */ { 0, 0, 0, 0, 0 },
/* U+6608 */ { 0, 0, 0, 0, 0 },
/* U+6609 */ { 0, 0, 0, 0, 0 },
/* U+660a */ { 0, 0, 0, 0, 0 },
/* U+660b */ { 0, 0, 0, 0, 0 },
/* U+660c */ { 0, 0, 0, 0, 0 },
/* U+660d */ { 0, 0, 0, 0, 0 },
/* U+660e */ { 0, 0, 0, 0, 0 },
/* U+660f */ { 0, 0, 0, 0, 0 },
/* U+6610 */ { 0, 0, 0, 0, 0 },
/* U+6611 */ { 0, 0, 0, 0, 0 },
/* U+6612 */ { 0, 0, 0, 0, 0 },
/* U+6613 */ { 0, 0, 0, 0, 0 },
/* U+6614 */ { 0, 0, 0, 0, 0 },
/* U+6615 */ { 0, 0, 0, 0, 0 },
/* U+6616 */ { 0, 0, 0, 0, 0 },
/* U+6617 */ { 0, 0, 0, 0, 0 },
/* U+6618 */ { 0, 0, 0, 0, 0 },
/* U+6619 */ { 0, 0, 0, 0, 0 },
/* U+661a */ { 0, 0, 0, 0, 0 },
/* U+661b */ { 0, 0, 0, 0, 0 },
/* U+661c */ { 0, 0, 0, 0, 0 },
/* U+661d */ { 0, 0, 0, 0, 0 },
/* U+661e */ { 0, 0, 0, 0, 0 },
/* U+661f */ { 0, 0, 0, 0, 0 },
/* U+6620 */ { 0, 0, 0, 0, 0 },
/* U+6621 */ { 0, 0, 0, 0, 0 },
/* U+6622 */ { 0, 0, 0, 0, 0 },
/* U+6623 */ { 0, 0, 0, 0, 0 },
/* U+6624 */ { 0, 0, 0, 0, 0 },
/* U+6625 */ { 0, 0, 0, 0, 0 },
/* U+6626 */ { 0, 0, 0, 0, 0 },
/* U+6627 */ { 0, 0, 0, 0, 0 },
/* U+6628 */ { 0, 0, 0, 0, 0 },
/* U+6629 */ { 0, 0, 0, 0, 0 },
/* U+662a */ { 0, 0, 0, 0, 0 },
/* U+662b */ { 0, 0, 0, 0, 0 },
/* U+662c */ { 0, 0, 0, 0, 0 },
/* U+662d */ { 0, 0, 0, 0, 0 },
/* U+662e */ { 0, 0, 0, 0, 0 },
/* U+662f */ { 0, 0, 0, 0, 0 },
/* U+6630 */ { 0, 0, 0, 0, 0 },
/* U+6631 */ { 0, 0, 0, 0, 0 },
/* U+6632 */ { 0, 0, 0, 0, 0 },
/* U+6633 */ { 0, 0, 0, 0, 0 },
/* U+6634 */ { 0, 0, 0, 0, 0 },
/* U+6635 */ { 0, 0, 0, 0, 0 },
/* U+6636 */ { 0, 0, 0, 0, 0 },
/* U+6637 */ { 0, 0, 0, 0, 0 },
/* U+6638 */ { 0, 0, 0, 0, 0 },
/* U+6639 */ { 0, 0, 0, 0, 0 },
/* U+663a */ { 0, 0, 0, 0, 0 },
/* U+663b */ { 0, 0, 0, 0, 0 },
/* U+663c */ { 0, 0, 0, 0, 0 },
/* U+663d */ { 0, 0, 0, 0, 0 },
/* U+663e */ { 0, 0, 0, 0, 0 },
/* U+663f */ { 0, 0, 0, 0, 0 },
/* U+6640 */ { 0, 0, 0, 0, 0 },
/* U+6641 */ { 0, 0, 0, 0, 0 },
/* U+6642 */ { 0, 0, 0, 0, 0 },
/* U+6643 */ { 0, 0, 0, 0, 0 },
/* U+6644 */ { 0, 0, 0, 0, 0 },
/* U+6645 */ { 0, 0, 0, 0, 0 },
/* U+6646 */ { 0, 0, 0, 0, 0 },
/* U+6647 */ { 0, 0, 0, 0, 0 },
/* U+6648 */ { 0, 0, 0, 0, 0 },
/* U+6649 */ { 0, 0, 0, 0, 0 },
/* U+664a */ { 0, 0, 0, 0, 0 },
/* U+664b */ { 0, 0, 0, 0, 0 },
/* U+664c */ { 0, 0, 0, 0, 0 },
/* U+664d */ { 0, 0, 0, 0, 0 },
/* U+664e */ { 0, 0, 0, 0, 0 },
/* U+664f */ { 0, 0, 0, 0, 0 },
/* U+6650 */ { 0, 0, 0, 0, 0 },
/* U+6651 */ { 0, 0, 0, 0, 0 },
/* U+6652 */ { 0, 0, 0, 0, 0 },
/* U+6653 */ { 0, 0, 0, 0, 0 },
/* U+6654 */ { 0, 0, 0, 0, 0 },
/* U+6655 */ { 0, 0, 0, 0, 0 },
/* U+6656 */ { 0, 0, 0, 0, 0 },
/* U+6657 */ { 0, 0, 0, 0, 0 },
/* U+6658 */ { 0, 0, 0, 0, 0 },
/* U+6659 */ { 0, 0, 0, 0, 0 },
/* U+665a */ { 0, 0, 0, 0, 0 },
/* U+665b */ { 0, 0, 0, 0, 0 },
/* U+665c */ { 0, 0, 0, 0, 0 },
/* U+665d */ { 0, 0, 0, 0, 0 },
/* U+665e */ { 0, 0, 0, 0, 0 },
/* U+665f */ { 0, 0, 0, 0, 0 },
/* U+6660 */ { 0, 0, 0, 0, 0 },
/* U+6661 */ { 0, 0, 0, 0, 0 },
/* U+6662 */ { 0, 0, 0, 0, 0 },
/* U+6663 */ { 0, 0, 0, 0, 0 },
/* U+6664 */ { 0, 0, 0, 0, 0 },
/* U+6665 */ { 0, 0, 0, 0, 0 },
/* U+6666 */ { 0, 0, 0, 0, 0 },
/* U+6667 */ { 0, 0, 0, 0, 0 },
/* U+6668 */ { 0, 0, 0, 0, 0 },
/* U+6669 */ { 0, 0, 0, 0, 0 },
/* U+666a */ { 0, 0, 0, 0, 0 },
/* U+666b */ { 0, 0, 0, 0, 0 },
/* U+666c */ { 0, 0, 0, 0, 0 },
/* U+666d */ { 0, 0, 0, 0, 0 },
/* U+666e */ { 0, 0, 0, 0, 0 },
/* U+666f */ { 0, 0, 0, 0, 0 },
/* U+6670 */ { 0, 0, 0, 0, 0 },
/* U+6671 */ { 0, 0, 0, 0, 0 },
/* U+6672 */ { 0, 0, 0, 0, 0 },
/* U+6673 */ { 0, 0, 0, 0, 0 },
/* U+6674 */ { 0, 0, 0, 0, 0 },
/* U+6675 */ { 0, 0, 0, 0, 0 },
/* U+6676 */ { 0, 0, 0, 0, 0 },
/* U+6677 */ { 0, 0, 0, 0, 0 },
/* U+6678 */ { 0, 0, 0, 0, 0 },
/* U+6679 */ { 0, 0, 0, 0, 0 },
/* U+667a */ { 0, 0, 0, 0, 0 },
/* U+667b */ { 0, 0, 0, 0, 0 },
/* U+667c */ { 0, 0, 0, 0, 0 },
/* U+667d */ { 0, 0, 0, 0, 0 },
/* U+667e */ { 0, 0, 0, 0, 0 },
/* U+667f */ { 0, 0, 0, 0, 0 },
/* U+6680 */ { 0, 0, 0, 0, 0 },
/* U+6681 */ { 0, 0, 0, 0, 0 },
/* U+6682 */ { 0, 0, 0, 0, 0 },
/* U+6683 */ { 0, 0, 0, 0, 0 },
/* U+6684 */ { 0, 0, 0, 0, 0 },
/* U+6685 */ { 0, 0, 0, 0, 0 },
/* U+6686 */ { 0, 0, 0, 0, 0 },
/* U+6687 */ { 0, 0, 0, 0, 0 },
/* U+6688 */ { 0, 0, 0, 0, 0 },
/* U+6689 */ { 0, 0, 0, 0, 0 },
/* U+668a */ { 0, 0, 0, 0, 0 },
/* U+668b */ { 0, 0, 0, 0, 0 },
/* U+668c */ { 0, 0, 0, 0, 0 },
/* U+668d */ { 0, 0, 0, 0, 0 },
/* U+668e */ { 0, 0, 0, 0, 0 },
/* U+668f */ { 0, 0, 0, 0, 0 },
/* U+6690 */ { 0, 0, 0, 0, 0 },
/* U+6691 */ { 0, 0, 0, 0, 0 },
/* U+6692 */ { 0, 0, 0, 0, 0 },
/* U+6693 */ { 0, 0, 0, 0, 0 },
/* U+6694 */ { 0, 0, 0, 0, 0 },
/* U+6695 */ { 0, 0, 0, 0, 0 },
/* U+6696 */ { 0, 0, 0, 0, 0 },
/* U+6697 */ { 0, 0, 0, 0, 0 },
/* U+6698 */ { 0, 0, 0, 0, 0 },
/* U+6699 */ { 0, 0, 0, 0, 0 },
/* U+669a */ { 0, 0, 0, 0, 0 },
/* U+669b */ { 0, 0, 0, 0, 0 },
/* U+669c */ { 0, 0, 0, 0, 0 },
/* U+669d */ { 0, 0, 0, 0, 0 },
/* U+669e */ { 0, 0, 0, 0, 0 },
/* U+669f */ { 0, 0, 0, 0, 0 },
/* U+66a0 */ { 0, 0, 0, 0, 0 },
/* U+66a1 */ { 0, 0, 0, 0, 0 },
/* U+66a2 */ { 0, 0, 0, 0, 0 },
/* U+66a3 */ { 0, 0, 0, 0, 0 },
/* U+66a4 */ { 0, 0, 0, 0, 0 },
/* U+66a5 */ { 0, 0, 0, 0, 0 },
/* U+66a6 */ { 0, 0, 0, 0, 0 },
/* U+66a7 */ { 0, 0, 0, 0, 0 },
/* U+66a8 */ { 0, 0, 0, 0, 0 },
/* U+66a9 */ { 0, 0, 0, 0, 0 },
/* U+66aa */ { 0, 0, 0, 0, 0 },
/* U+66ab */ { 0, 0, 0, 0, 0 },
/* U+66ac */ { 0, 0, 0, 0, 0 },
/* U+66ad */ { 0, 0, 0, 0, 0 },
/* U+66ae */ { 0, 0, 0, 0, 0 },
/* U+66af */ { 0, 0, 0, 0, 0 },
/* U+66b0 */ { 0, 0, 0, 0, 0 },
/* U+66b1 */ { 0, 0, 0, 0, 0 },
/* U+66b2 */ { 0, 0, 0, 0, 0 },
/* U+66b3 */ { 0, 0, 0, 0, 0 },
/* U+66b4 */ { 0, 0, 0, 0, 0 },
/* U+66b5 */ { 0, 0, 0, 0, 0 },
/* U+66b6 */ { 0, 0, 0, 0, 0 },
/* U+66b7 */ { 0, 0, 0, 0, 0 },
/* U+66b8 */ { 0, 0, 0, 0, 0 },
/* U+66b9 */ { 0, 0, 0, 0, 0 },
/* U+66ba */ { 0, 0, 0, 0, 0 },
/* U+66bb */ { 0, 0, 0, 0, 0 },
/* U+66bc */ { 0, 0, 0, 0, 0 },
/* U+66bd */ { 0, 0, 0, 0, 0 },
/* U+66be */ { 0, 0, 0, 0, 0 },
/* U+66bf */ { 0, 0, 0, 0, 0 },
/* U+66c0 */ { 0, 0, 0, 0, 0 },
/* U+66c1 */ { 0, 0, 0, 0, 0 },
/* U+66c2 */ { 0, 0, 0, 0, 0 },
/* U+66c3 */ { 0, 0, 0, 0, 0 },
/* U+66c4 */ { 0, 0, 0, 0, 0 },
/* U+66c5 */ { 0, 0, 0, 0, 0 },
/* U+66c6 */ { 0, 0, 0, 0, 0 },
/* U+66c7 */ { 0, 0, 0, 0, 0 },
/* U+66c8 */ { 0, 0, 0, 0, 0 },
/* U+66c9 */ { 0, 0, 0, 0, 0 },
/* U+66ca */ { 0, 0, 0, 0, 0 },
/* U+66cb */ { 0, 0, 0, 0, 0 },
/* U+66cc */ { 0, 0, 0, 0, 0 },
/* U+66cd */ { 0, 0, 0, 0, 0 },
/* U+66ce */ { 0, 0, 0, 0, 0 },
/* U+66cf */ { 0, 0, 0, 0, 0 },
/* U+66d0 */ { 0, 0, 0, 0, 0 },
/* U+66d1 */ { 0, 0, 0, 0, 0 },
/* U+66d2 */ { 0, 0, 0, 0, 0 },
/* U+66d3 */ { 0, 0, 0, 0, 0 },
/* U+66d4 */ { 0, 0, 0, 0, 0 },
/* U+66d5 */ { 0, 0, 0, 0, 0 },
/* U+66d6 */ { 0, 0, 0, 0, 0 },
/* U+66d7 */ { 0, 0, 0, 0, 0 },
/* U+66d8 */ { 0, 0, 0, 0, 0 },
/* U+66d9 */ { 0, 0, 0, 0, 0 },
/* U+66da */ { 0, 0, 0, 0, 0 },
/* U+66db */ { 0, 0, 0, 0, 0 },
/* U+66dc */ { 0, 0, 0, 0, 0 },
/* U+66dd */ { 0, 0, 0, 0, 0 },
/* U+66de */ { 0, 0, 0, 0, 0 },
/* U+66df */ { 0, 0, 0, 0, 0 },
/* U+66e0 */ { 0, 0, 0, 0, 0 },
/* U+66e1 */ { 0, 0, 0, 0, 0 },
/* U+66e2 */ { 0, 0, 0, 0, 0 },
/* U+66e3 */ { 0, 0, 0, 0, 0 },
/* U+66e4 */ { 0, 0, 0, 0, 0 },
/* U+66e5 */ { 0, 0, 0, 0, 0 },
/* U+66e6 */ { 0, 0, 0, 0, 0 },
/* U+66e7 */ { 0, 0, 0, 0, 0 },
/* U+66e8 */ { 0, 0, 0, 0, 0 },
/* U+66e9 */ { 0, 0, 0, 0, 0 },
/* U+66ea */ { 0, 0, 0, 0, 0 },
/* U+66eb */ { 0, 0, 0, 0, 0 },
/* U+66ec */ { 0, 0, 0, 0, 0 },
/* U+66ed */ { 0, 0, 0, 0, 0 },
/* U+66ee */ { 0, 0, 0, 0, 0 },
/* U+66ef */ { 0, 0, 0, 0, 0 },
/* U+66f0 */ { 0, 0, 0, 0, 0 },
/* U+66f1 */ { 0, 0, 0, 0, 0 },
/* U+66f2 */ { 0, 0, 0, 0, 0 },
/* U+66f3 */ { 0, 0, 0, 0, 0 },
/* U+66f4 */ { 0, 0, 0, 0, 0 },
/* U+66f5 */ { 0, 0, 0, 0, 0 },
/* U+66f6 */ { 0, 0, 0, 0, 0 },
/* U+66f7 */ { 0, 0, 0, 0, 0 },
/* U+66f8 */ { 0, 0, 0, 0, 0 },
/* U+66f9 */ { 0, 0, 0, 0, 0 },
/* U+66fa */ { 0, 0, 0, 0, 0 },
/* U+66fb */ { 0, 0, 0, 0, 0 },
/* U+66fc */ { 0, 0, 0, 0, 0 },
/* U+66fd */ { 0, 0, 0, 0, 0 },
/* U+66fe */ { 0, 0, 0, 0, 0 },
/* U+66ff */ { 0, 0, 0, 0, 0 },
/* U+6700 */ { 0, 0, 0, 0, 0 },
/* U+6701 */ { 0, 0, 0, 0, 0 },
/* U+6702 */ { 0, 0, 0, 0, 0 },
/* U+6703 */ { 0, 0, 0, 0, 0 },
/* U+6704 */ { 0, 0, 0, 0, 0 },
/* U+6705 */ { 0, 0, 0, 0, 0 },
/* U+6706 */ { 0, 0, 0, 0, 0 },
/* U+6707 */ { 0, 0, 0, 0, 0 },
/* U+6708 */ { 0, 0, 0, 0, 0 },
/* U+6709 */ { 0, 0, 0, 0, 0 },
/* U+670a */ { 0, 0, 0, 0, 0 },
/* U+670b */ { 0, 0, 0, 0, 0 },
/* U+670c */ { 0, 0, 0, 0, 0 },
/* U+670d */ { 0, 0, 0, 0, 0 },
/* U+670e */ { 0, 0, 0, 0, 0 },
/* U+670f */ { 0, 0, 0, 0, 0 },
/* U+6710 */ { 0, 0, 0, 0, 0 },
/* U+6711 */ { 0, 0, 0, 0, 0 },
/* U+6712 */ { 0, 0, 0, 0, 0 },
/* U+6713 */ { 0, 0, 0, 0, 0 },
/* U+6714 */ { 0, 0, 0, 0, 0 },
/* U+6715 */ { 0, 0, 0, 0, 0 },
/* U+6716 */ { 0, 0, 0, 0, 0 },
/* U+6717 */ { 0, 0, 0, 0, 0 },
/* U+6718 */ { 0, 0, 0, 0, 0 },
/* U+6719 */ { 0, 0, 0, 0, 0 },
/* U+671a */ { 0, 0, 0, 0, 0 },
/* U+671b */ { 0, 0, 0, 0, 0 },
/* U+671c */ { 0, 0, 0, 0, 0 },
/* U+671d */ { 0, 0, 0, 0, 0 },
/* U+671e */ { 0, 0, 0, 0, 0 },
/* U+671f */ { 0, 0, 0, 0, 0 },
/* U+6720 */ { 0, 0, 0, 0, 0 },
/* U+6721 */ { 0, 0, 0, 0, 0 },
/* U+6722 */ { 0, 0, 0, 0, 0 },
/* U+6723 */ { 0, 0, 0, 0, 0 },
/* U+6724 */ { 0, 0, 0, 0, 0 },
/* U+6725 */ { 0, 0, 0, 0, 0 },
/* U+6726 */ { 0, 0, 0, 0, 0 },
/* U+6727 */ { 0, 0, 0, 0, 0 },
/* U+6728 */ { 0, 0, 0, 0, 0 },
/* U+6729 */ { 0, 0, 0, 0, 0 },
/* U+672a */ { 0, 0, 0, 0, 0 },
/* U+672b */ { 0, 0, 0, 0, 0 },
/* U+672c */ { 0, 0, 0, 0, 0 },
/* U+672d */ { 0, 0, 0, 0, 0 },
/* U+672e */ { 0, 0, 0, 0, 0 },
/* U+672f */ { 0, 0, 0, 0, 0 },
/* U+6730 */ { 0, 0, 0, 0, 0 },
/* U+6731 */ { 0, 0, 0, 0, 0 },
/* U+6732 */ { 0, 0, 0, 0, 0 },
/* U+6733 */ { 0, 0, 0, 0, 0 },
/* U+6734 */ { 0, 0, 0, 0, 0 },
/* U+6735 */ { 0, 0, 0, 0, 0 },
/* U+6736 */ { 0, 0, 0, 0, 0 },
/* U+6737 */ { 0, 0, 0, 0, 0 },
/* U+6738 */ { 0, 0, 0, 0, 0 },
/* U+6739 */ { 0, 0, 0, 0, 0 },
/* U+673a */ { 0, 0, 0, 0, 0 },
/* U+673b */ { 0, 0, 0, 0, 0 },
/* U+673c */ { 0, 0, 0, 0, 0 },
/* U+673d */ { 0, 0, 0, 0, 0 },
/* U+673e */ { 0, 0, 0, 0, 0 },
/* U+673f */ { 0, 0, 0, 0, 0 },
/* U+6740 */ { 0, 0, 0, 0, 0 },
/* U+6741 */ { 0, 0, 0, 0, 0 },
/* U+6742 */ { 0, 0, 0, 0, 0 },
/* U+6743 */ { 0, 0, 0, 0, 0 },
/* U+6744 */ { 0, 0, 0, 0, 0 },
/* U+6745 */ { 0, 0, 0, 0, 0 },
/* U+6746 */ { 0, 0, 0, 0, 0 },
/* U+6747 */ { 0, 0, 0, 0, 0 },
/* U+6748 */ { 0, 0, 0, 0, 0 },
/* U+6749 */ { 0, 0, 0, 0, 0 },
/* U+674a */ { 0, 0, 0, 0, 0 },
/* U+674b */ { 0, 0, 0, 0, 0 },
/* U+674c */ { 0, 0, 0, 0, 0 },
/* U+674d */ { 0, 0, 0, 0, 0 },
/* U+674e */ { 0, 0, 0, 0, 0 },
/* U+674f */ { 0, 0, 0, 0, 0 },
/* U+6750 */ { 0, 0, 0, 0, 0 },
/* U+6751 */ { 0, 0, 0, 0, 0 },
/* U+6752 */ { 0, 0, 0, 0, 0 },
/* U+6753 */ { 0, 0, 0, 0, 0 },
/* U+6754 */ { 0, 0, 0, 0, 0 },
/* U+6755 */ { 0, 0, 0, 0, 0 },
/* U+6756 */ { 0, 0, 0, 0, 0 },
/* U+6757 */ { 0, 0, 0, 0, 0 },
/* U+6758 */ { 0, 0, 0, 0, 0 },
/* U+6759 */ { 0, 0, 0, 0, 0 },
/* U+675a */ { 0, 0, 0, 0, 0 },
/* U+675b */ { 0, 0, 0, 0, 0 },
/* U+675c */ { 0, 0, 0, 0, 0 },
/* U+675d */ { 0, 0, 0, 0, 0 },
/* U+675e */ { 0, 0, 0, 0, 0 },
/* U+675f */ { 0, 0, 0, 0, 0 },
/* U+6760 */ { 0, 0, 0, 0, 0 },
/* U+6761 */ { 0, 0, 0, 0, 0 },
/* U+6762 */ { 0, 0, 0, 0, 0 },
/* U+6763 */ { 0, 0, 0, 0, 0 },
/* U+6764 */ { 0, 0, 0, 0, 0 },
/* U+6765 */ { 0, 0, 0, 0, 0 },
/* U+6766 */ { 0, 0, 0, 0, 0 },
/* U+6767 */ { 0, 0, 0, 0, 0 },
/* U+6768 */ { 0, 0, 0, 0, 0 },
/* U+6769 */ { 0, 0, 0, 0, 0 },
/* U+676a */ { 0, 0, 0, 0, 0 },
/* U+676b */ { 0, 0, 0, 0, 0 },
/* U+676c */ { 0, 0, 0, 0, 0 },
/* U+676d */ { 0, 0, 0, 0, 0 },
/* U+676e */ { 0, 0, 0, 0, 0 },
/* U+676f */ { 0, 0, 0, 0, 0 },
/* U+6770 */ { 0, 0, 0, 0, 0 },
/* U+6771 */ { 0, 0, 0, 0, 0 },
/* U+6772 */ { 0, 0, 0, 0, 0 },
/* U+6773 */ { 0, 0, 0, 0, 0 },
/* U+6774 */ { 0, 0, 0, 0, 0 },
/* U+6775 */ { 0, 0, 0, 0, 0 },
/* U+6776 */ { 0, 0, 0, 0, 0 },
/* U+6777 */ { 0, 0, 0, 0, 0 },
/* U+6778 */ { 0, 0, 0, 0, 0 },
/* U+6779 */ { 0, 0, 0, 0, 0 },
/* U+677a */ { 0, 0, 0, 0, 0 },
/* U+677b */ { 0, 0, 0, 0, 0 },
/* U+677c */ { 0, 0, 0, 0, 0 },
/* U+677d */ { 0, 0, 0, 0, 0 },
/* U+677e */ { 0, 0, 0, 0, 0 },
/* U+677f */ { 0, 0, 0, 0, 0 },
/* U+6780 */ { 0, 0, 0, 0, 0 },
/* U+6781 */ { 0, 0, 0, 0, 0 },
/* U+6782 */ { 0, 0, 0, 0, 0 },
/* U+6783 */ { 0, 0, 0, 0, 0 },
/* U+6784 */ { 0, 0, 0, 0, 0 },
/* U+6785 */ { 0, 0, 0, 0, 0 },
/* U+6786 */ { 0, 0, 0, 0, 0 },
/* U+6787 */ { 0, 0, 0, 0, 0 },
/* U+6788 */ { 0, 0, 0, 0, 0 },
/* U+6789 */ { 0, 0, 0, 0, 0 },
/* U+678a */ { 0, 0, 0, 0, 0 },
/* U+678b */ { 0, 0, 0, 0, 0 },
/* U+678c */ { 0, 0, 0, 0, 0 },
/* U+678d */ { 0, 0, 0, 0, 0 },
/* U+678e */ { 0, 0, 0, 0, 0 },
/* U+678f */ { 0, 0, 0, 0, 0 },
/* U+6790 */ { 0, 0, 0, 0, 0 },
/* U+6791 */ { 0, 0, 0, 0, 0 },
/* U+6792 */ { 0, 0, 0, 0, 0 },
/* U+6793 */ { 0, 0, 0, 0, 0 },
/* U+6794 */ { 0, 0, 0, 0, 0 },
/* U+6795 */ { 0, 0, 0, 0, 0 },
/* U+6796 */ { 0, 0, 0, 0, 0 },
/* U+6797 */ { 0, 0, 0, 0, 0 },
/* U+6798 */ { 0, 0, 0, 0, 0 },
/* U+6799 */ { 0, 0, 0, 0, 0 },
/* U+679a */ { 0, 0, 0, 0, 0 },
/* U+679b */ { 0, 0, 0, 0, 0 },
/* U+679c */ { 0, 0, 0, 0, 0 },
/* U+679d */ { 0, 0, 0, 0, 0 },
/* U+679e */ { 0, 0, 0, 0, 0 },
/* U+679f */ { 0, 0, 0, 0, 0 },
/* U+67a0 */ { 0, 0, 0, 0, 0 },
/* U+67a1 */ { 0, 0, 0, 0, 0 },
/* U+67a2 */ { 0, 0, 0, 0, 0 },
/* U+67a3 */ { 0, 0, 0, 0, 0 },
/* U+67a4 */ { 0, 0, 0, 0, 0 },
/* U+67a5 */ { 0, 0, 0, 0, 0 },
/* U+67a6 */ { 0, 0, 0, 0, 0 },
/* U+67a7 */ { 0, 0, 0, 0, 0 },
/* U+67a8 */ { 0, 0, 0, 0, 0 },
/* U+67a9 */ { 0, 0, 0, 0, 0 },
/* U+67aa */ { 0, 0, 0, 0, 0 },
/* U+67ab */ { 0, 0, 0, 0, 0 },
/* U+67ac */ { 0, 0, 0, 0, 0 },
/* U+67ad */ { 0, 0, 0, 0, 0 },
/* U+67ae */ { 0, 0, 0, 0, 0 },
/* U+67af */ { 0, 0, 0, 0, 0 },
/* U+67b0 */ { 0, 0, 0, 0, 0 },
/* U+67b1 */ { 0, 0, 0, 0, 0 },
/* U+67b2 */ { 0, 0, 0, 0, 0 },
/* U+67b3 */ { 0, 0, 0, 0, 0 },
/* U+67b4 */ { 0, 0, 0, 0, 0 },
/* U+67b5 */ { 0, 0, 0, 0, 0 },
/* U+67b6 */ { 0, 0, 0, 0, 0 },
/* U+67b7 */ { 0, 0, 0, 0, 0 },
/* U+67b8 */ { 0, 0, 0, 0, 0 },
/* U+67b9 */ { 0, 0, 0, 0, 0 },
/* U+67ba */ { 0, 0, 0, 0, 0 },
/* U+67bb */ { 0, 0, 0, 0, 0 },
/* U+67bc */ { 0, 0, 0, 0, 0 },
/* U+67bd */ { 0, 0, 0, 0, 0 },
/* U+67be */ { 0, 0, 0, 0, 0 },
/* U+67bf */ { 0, 0, 0, 0, 0 },
/* U+67c0 */ { 0, 0, 0, 0, 0 },
/* U+67c1 */ { 0, 0, 0, 0, 0 },
/* U+67c2 */ { 0, 0, 0, 0, 0 },
/* U+67c3 */ { 0, 0, 0, 0, 0 },
/* U+67c4 */ { 0, 0, 0, 0, 0 },
/* U+67c5 */ { 0, 0, 0, 0, 0 },
/* U+67c6 */ { 0, 0, 0, 0, 0 },
/* U+67c7 */ { 0, 0, 0, 0, 0 },
/* U+67c8 */ { 0, 0, 0, 0, 0 },
/* U+67c9 */ { 0, 0, 0, 0, 0 },
/* U+67ca */ { 0, 0, 0, 0, 0 },
/* U+67cb */ { 0, 0, 0, 0, 0 },
/* U+67cc */ { 0, 0, 0, 0, 0 },
/* U+67cd */ { 0, 0, 0, 0, 0 },
/* U+67ce */ { 0, 0, 0, 0, 0 },
/* U+67cf */ { 0, 0, 0, 0, 0 },
/* U+67d0 */ { 0, 0, 0, 0, 0 },
/* U+67d1 */ { 0, 0, 0, 0, 0 },
/* U+67d2 */ { 0, 0, 0, 0, 0 },
/* U+67d3 */ { 0, 0, 0, 0, 0 },
/* U+67d4 */ { 0, 0, 0, 0, 0 },
/* U+67d5 */ { 0, 0, 0, 0, 0 },
/* U+67d6 */ { 0, 0, 0, 0, 0 },
/* U+67d7 */ { 0, 0, 0, 0, 0 },
/* U+67d8 */ { 0, 0, 0, 0, 0 },
/* U+67d9 */ { 0, 0, 0, 0, 0 },
/* U+67da */ { 0, 0, 0, 0, 0 },
/* U+67db */ { 0, 0, 0, 0, 0 },
/* U+67dc */ { 0, 0, 0, 0, 0 },
/* U+67dd */ { 0, 0, 0, 0, 0 },
/* U+67de */ { 0, 0, 0, 0, 0 },
/* U+67df */ { 0, 0, 0, 0, 0 },
/* U+67e0 */ { 0, 0, 0, 0, 0 },
/* U+67e1 */ { 0, 0, 0, 0, 0 },
/* U+67e2 */ { 0, 0, 0, 0, 0 },
/* U+67e3 */ { 0, 0, 0, 0, 0 },
/* U+67e4 */ { 0, 0, 0, 0, 0 },
/* U+67e5 */ { 0, 0, 0, 0, 0 },
/* U+67e6 */ { 0, 0, 0, 0, 0 },
/* U+67e7 */ { 0, 0, 0, 0, 0 },
/* U+67e8 */ { 0, 0, 0, 0, 0 },
/* U+67e9 */ { 0, 0, 0, 0, 0 },
/* U+67ea */ { 0, 0, 0, 0, 0 },
/* U+67eb */ { 0, 0, 0, 0, 0 },
/* U+67ec */ { 0, 0, 0, 0, 0 },
/* U+67ed */ { 0, 0, 0, 0, 0 },
/* U+67ee */ { 0, 0, 0, 0, 0 },
/* U+67ef */ { 0, 0, 0, 0, 0 },
/* U+67f0 */ { 0, 0, 0, 0, 0 },
/* U+67f1 */ { 0, 0, 0, 0, 0 },
/* U+67f2 */ { 0, 0, 0, 0, 0 },
/* U+67f3 */ { 0, 0, 0, 0, 0 },
/* U+67f4 */ { 0, 0, 0, 0, 0 },
/* U+67f5 */ { 0, 0, 0, 0, 0 },
/* U+67f6 */ { 0, 0, 0, 0, 0 },
/* U+67f7 */ { 0, 0, 0, 0, 0 },
/* U+67f8 */ { 0, 0, 0, 0, 0 },
/* U+67f9 */ { 0, 0, 0, 0, 0 },
/* U+67fa */ { 0, 0, 0, 0, 0 },
/* U+67fb */ { 0, 0, 0, 0, 0 },
/* U+67fc */ { 0, 0, 0, 0, 0 },
/* U+67fd */ { 0, 0, 0, 0, 0 },
/* U+67fe */ { 0, 0, 0, 0, 0 },
/* U+67ff */ { 0, 0, 0, 0, 0 },
/* U+6800 */ { 0, 0, 0, 0, 0 },
/* U+6801 */ { 0, 0, 0, 0, 0 },
/* U+6802 */ { 0, 0, 0, 0, 0 },
/* U+6803 */ { 0, 0, 0, 0, 0 },
/* U+6804 */ { 0, 0, 0, 0, 0 },
/* U+6805 */ { 0, 0, 0, 0, 0 },
/* U+6806 */ { 0, 0, 0, 0, 0 },
/* U+6807 */ { 0, 0, 0, 0, 0 },
/* U+6808 */ { 0, 0, 0, 0, 0 },
/* U+6809 */ { 0, 0, 0, 0, 0 },
/* U+680a */ { 0, 0, 0, 0, 0 },
/* U+680b */ { 0, 0, 0, 0, 0 },
/* U+680c */ { 0, 0, 0, 0, 0 },
/* U+680d */ { 0, 0, 0, 0, 0 },
/* U+680e */ { 0, 0, 0, 0, 0 },
/* U+680f */ { 0, 0, 0, 0, 0 },
/* U+6810 */ { 0, 0, 0, 0, 0 },
/* U+6811 */ { 0, 0, 0, 0, 0 },
/* U+6812 */ { 0, 0, 0, 0, 0 },
/* U+6813 */ { 0, 0, 0, 0, 0 },
/* U+6814 */ { 0, 0, 0, 0, 0 },
/* U+6815 */ { 0, 0, 0, 0, 0 },
/* U+6816 */ { 0, 0, 0, 0, 0 },
/* U+6817 */ { 0, 0, 0, 0, 0 },
/* U+6818 */ { 0, 0, 0, 0, 0 },
/* U+6819 */ { 0, 0, 0, 0, 0 },
/* U+681a */ { 0, 0, 0, 0, 0 },
/* U+681b */ { 0, 0, 0, 0, 0 },
/* U+681c */ { 0, 0, 0, 0, 0 },
/* U+681d */ { 0, 0, 0, 0, 0 },
/* U+681e */ { 0, 0, 0, 0, 0 },
/* U+681f */ { 0, 0, 0, 0, 0 },
/* U+6820 */ { 0, 0, 0, 0, 0 },
/* U+6821 */ { 0, 0, 0, 0, 0 },
/* U+6822 */ { 0, 0, 0, 0, 0 },
/* U+6823 */ { 0, 0, 0, 0, 0 },
/* U+6824 */ { 0, 0, 0, 0, 0 },
/* U+6825 */ { 0, 0, 0, 0, 0 },
/* U+6826 */ { 0, 0, 0, 0, 0 },
/* U+6827 */ { 0, 0, 0, 0, 0 },
/* U+6828 */ { 0, 0, 0, 0, 0 },
/* U+6829 */ { 0, 0, 0, 0, 0 },
/* U+682a */ { 0, 0, 0, 0, 0 },
/* U+682b */ { 0, 0, 0, 0, 0 },
/* U+682c */ { 0, 0, 0, 0, 0 },
/* U+682d */ { 0, 0, 0, 0, 0 },
/* U+682e */ { 0, 0, 0, 0, 0 },
/* U+682f */ { 0, 0, 0, 0, 0 },
/* U+6830 */ { 0, 0, 0, 0, 0 },
/* U+6831 */ { 0, 0, 0, 0, 0 },
/* U+6832 */ { 0, 0, 0, 0, 0 },
/* U+6833 */ { 0, 0, 0, 0, 0 },
/* U+6834 */ { 0, 0, 0, 0, 0 },
/* U+6835 */ { 0, 0, 0, 0, 0 },
/* U+6836 */ { 0, 0, 0, 0, 0 },
/* U+6837 */ { 0, 0, 0, 0, 0 },
/* U+6838 */ { 0, 0, 0, 0, 0 },
/* U+6839 */ { 0, 0, 0, 0, 0 },
/* U+683a */ { 0, 0, 0, 0, 0 },
/* U+683b */ { 0, 0, 0, 0, 0 },
/* U+683c */ { 0, 0, 0, 0, 0 },
/* U+683d */ { 0, 0, 0, 0, 0 },
/* U+683e */ { 0, 0, 0, 0, 0 },
/* U+683f */ { 0, 0, 0, 0, 0 },
/* U+6840 */ { 0, 0, 0, 0, 0 },
/* U+6841 */ { 0, 0, 0, 0, 0 },
/* U+6842 */ { 0, 0, 0, 0, 0 },
/* U+6843 */ { 0, 0, 0, 0, 0 },
/* U+6844 */ { 0, 0, 0, 0, 0 },
/* U+6845 */ { 0, 0, 0, 0, 0 },
/* U+6846 */ { 0, 0, 0, 0, 0 },
/* U+6847 */ { 0, 0, 0, 0, 0 },
/* U+6848 */ { 0, 0, 0, 0, 0 },
/* U+6849 */ { 0, 0, 0, 0, 0 },
/* U+684a */ { 0, 0, 0, 0, 0 },
/* U+684b */ { 0, 0, 0, 0, 0 },
/* U+684c */ { 0, 0, 0, 0, 0 },
/* U+684d */ { 0, 0, 0, 0, 0 },
/* U+684e */ { 0, 0, 0, 0, 0 },
/* U+684f */ { 0, 0, 0, 0, 0 },
/* U+6850 */ { 0, 0, 0, 0, 0 },
/* U+6851 */ { 0, 0, 0, 0, 0 },
/* U+6852 */ { 0, 0, 0, 0, 0 },
/* U+6853 */ { 0, 0, 0, 0, 0 },
/* U+6854 */ { 0, 0, 0, 0, 0 },
/* U+6855 */ { 0, 0, 0, 0, 0 },
/* U+6856 */ { 0, 0, 0, 0, 0 },
/* U+6857 */ { 0, 0, 0, 0, 0 },
/* U+6858 */ { 0, 0, 0, 0, 0 },
/* U+6859 */ { 0, 0, 0, 0, 0 },
/* U+685a */ { 0, 0, 0, 0, 0 },
/* U+685b */ { 0, 0, 0, 0, 0 },
/* U+685c */ { 0, 0, 0, 0, 0 },
/* U+685d */ { 0, 0, 0, 0, 0 },
/* U+685e */ { 0, 0, 0, 0, 0 },
/* U+685f */ { 0, 0, 0, 0, 0 },
/* U+6860 */ { 0, 0, 0, 0, 0 },
/* U+6861 */ { 0, 0, 0, 0, 0 },
/* U+6862 */ { 0, 0, 0, 0, 0 },
/* U+6863 */ { 0, 0, 0, 0, 0 },
/* U+6864 */ { 0, 0, 0, 0, 0 },
/* U+6865 */ { 0, 0, 0, 0, 0 },
/* U+6866 */ { 0, 0, 0, 0, 0 },
/* U+6867 */ { 0, 0, 0, 0, 0 },
/* U+6868 */ { 0, 0, 0, 0, 0 },
/* U+6869 */ { 0, 0, 0, 0, 0 },
/* U+686a */ { 0, 0, 0, 0, 0 },
/* U+686b */ { 0, 0, 0, 0, 0 },
/* U+686c */ { 0, 0, 0, 0, 0 },
/* U+686d */ { 0, 0, 0, 0, 0 },
/* U+686e */ { 0, 0, 0, 0, 0 },
/* U+686f */ { 0, 0, 0, 0, 0 },
/* U+6870 */ { 0, 0, 0, 0, 0 },
/* U+6871 */ { 0, 0, 0, 0, 0 },
/* U+6872 */ { 0, 0, 0, 0, 0 },
/* U+6873 */ { 0, 0, 0, 0, 0 },
/* U+6874 */ { 0, 0, 0, 0, 0 },
/* U+6875 */ { 0, 0, 0, 0, 0 },
/* U+6876 */ { 0, 0, 0, 0, 0 },
/* U+6877 */ { 0, 0, 0, 0, 0 },
/* U+6878 */ { 0, 0, 0, 0, 0 },
/* U+6879 */ { 0, 0, 0, 0, 0 },
/* U+687a */ { 0, 0, 0, 0, 0 },
/* U+687b */ { 0, 0, 0, 0, 0 },
/* U+687c */ { 0, 0, 0, 0, 0 },
/* U+687d */ { 0, 0, 0, 0, 0 },
/* U+687e */ { 0, 0, 0, 0, 0 },
/* U+687f */ { 0, 0, 0, 0, 0 },
/* U+6880 */ { 0, 0, 0, 0, 0 },
/* U+6881 */ { 0, 0, 0, 0, 0 },
/* U+6882 */ { 0, 0, 0, 0, 0 },
/* U+6883 */ { 0, 0, 0, 0, 0 },
/* U+6884 */ { 0, 0, 0, 0, 0 },
/* U+6885 */ { 0, 0, 0, 0, 0 },
/* U+6886 */ { 0, 0, 0, 0, 0 },
/* U+6887 */ { 0, 0, 0, 0, 0 },
/* U+6888 */ { 0, 0, 0, 0, 0 },
/* U+6889 */ { 0, 0, 0, 0, 0 },
/* U+688a */ { 0, 0, 0, 0, 0 },
/* U+688b */ { 0, 0, 0, 0, 0 },
/* U+688c */ { 0, 0, 0, 0, 0 },
/* U+688d */ { 0, 0, 0, 0, 0 },
/* U+688e */ { 0, 0, 0, 0, 0 },
/* U+688f */ { 0, 0, 0, 0, 0 },
/* U+6890 */ { 0, 0, 0, 0, 0 },
/* U+6891 */ { 0, 0, 0, 0, 0 },
/* U+6892 */ { 0, 0, 0, 0, 0 },
/* U+6893 */ { 0, 0, 0, 0, 0 },
/* U+6894 */ { 0, 0, 0, 0, 0 },
/* U+6895 */ { 0, 0, 0, 0, 0 },
/* U+6896 */ { 0, 0, 0, 0, 0 },
/* U+6897 */ { 0, 0, 0, 0, 0 },
/* U+6898 */ { 0, 0, 0, 0, 0 },
/* U+6899 */ { 0, 0, 0, 0, 0 },
/* U+689a */ { 0, 0, 0, 0, 0 },
/* U+689b */ { 0, 0, 0, 0, 0 },
/* U+689c */ { 0, 0, 0, 0, 0 },
/* U+689d */ { 0, 0, 0, 0, 0 },
/* U+689e */ { 0, 0, 0, 0, 0 },
/* U+689f */ { 0, 0, 0, 0, 0 },
/* U+68a0 */ { 0, 0, 0, 0, 0 },
/* U+68a1 */ { 0, 0, 0, 0, 0 },
/* U+68a2 */ { 0, 0, 0, 0, 0 },
/* U+68a3 */ { 0, 0, 0, 0, 0 },
/* U+68a4 */ { 0, 0, 0, 0, 0 },
/* U+68a5 */ { 0, 0, 0, 0, 0 },
/* U+68a6 */ { 0, 0, 0, 0, 0 },
/* U+68a7 */ { 0, 0, 0, 0, 0 },
/* U+68a8 */ { 0, 0, 0, 0, 0 },
/* U+68a9 */ { 0, 0, 0, 0, 0 },
/* U+68aa */ { 0, 0, 0, 0, 0 },
/* U+68ab */ { 0, 0, 0, 0, 0 },
/* U+68ac */ { 0, 0, 0, 0, 0 },
/* U+68ad */ { 0, 0, 0, 0, 0 },
/* U+68ae */ { 0, 0, 0, 0, 0 },
/* U+68af */ { 0, 0, 0, 0, 0 },
/* U+68b0 */ { 0, 0, 0, 0, 0 },
/* U+68b1 */ { 0, 0, 0, 0, 0 },
/* U+68b2 */ { 0, 0, 0, 0, 0 },
/* U+68b3 */ { 0, 0, 0, 0, 0 },
/* U+68b4 */ { 0, 0, 0, 0, 0 },
/* U+68b5 */ { 0, 0, 0, 0, 0 },
/* U+68b6 */ { 0, 0, 0, 0, 0 },
/* U+68b7 */ { 0, 0, 0, 0, 0 },
/* U+68b8 */ { 0, 0, 0, 0, 0 },
/* U+68b9 */ { 0, 0, 0, 0, 0 },
/* U+68ba */ { 0, 0, 0, 0, 0 },
/* U+68bb */ { 0, 0, 0, 0, 0 },
/* U+68bc */ { 0, 0, 0, 0, 0 },
/* U+68bd */ { 0, 0, 0, 0, 0 },
/* U+68be */ { 0, 0, 0, 0, 0 },
/* U+68bf */ { 0, 0, 0, 0, 0 },
/* U+68c0 */ { 0, 0, 0, 0, 0 },
/* U+68c1 */ { 0, 0, 0, 0, 0 },
/* U+68c2 */ { 0, 0, 0, 0, 0 },
/* U+68c3 */ { 0, 0, 0, 0, 0 },
/* U+68c4 */ { 0, 0, 0, 0, 0 },
/* U+68c5 */ { 0, 0, 0, 0, 0 },
/* U+68c6 */ { 0, 0, 0, 0, 0 },
/* U+68c7 */ { 0, 0, 0, 0, 0 },
/* U+68c8 */ { 0, 0, 0, 0, 0 },
/* U+68c9 */ { 0, 0, 0, 0, 0 },
/* U+68ca */ { 0, 0, 0, 0, 0 },
/* U+68cb */ { 0, 0, 0, 0, 0 },
/* U+68cc */ { 0, 0, 0, 0, 0 },
/* U+68cd */ { 0, 0, 0, 0, 0 },
/* U+68ce */ { 0, 0, 0, 0, 0 },
/* U+68cf */ { 0, 0, 0, 0, 0 },
/* U+68d0 */ { 0, 0, 0, 0, 0 },
/* U+68d1 */ { 0, 0, 0, 0, 0 },
/* U+68d2 */ { 0, 0, 0, 0, 0 },
/* U+68d3 */ { 0, 0, 0, 0, 0 },
/* U+68d4 */ { 0, 0, 0, 0, 0 },
/* U+68d5 */ { 0, 0, 0, 0, 0 },
/* U+68d6 */ { 0, 0, 0, 0, 0 },
/* U+68d7 */ { 0, 0, 0, 0, 0 },
/* U+68d8 */ { 0, 0, 0, 0, 0 },
/* U+68d9 */ { 0, 0, 0, 0, 0 },
/* U+68da */ { 0, 0, 0, 0, 0 },
/* U+68db */ { 0, 0, 0, 0, 0 },
/* U+68dc */ { 0, 0, 0, 0, 0 },
/* U+68dd */ { 0, 0, 0, 0, 0 },
/* U+68de */ { 0, 0, 0, 0, 0 },
/* U+68df */ { 0, 0, 0, 0, 0 },
/* U+68e0 */ { 0, 0, 0, 0, 0 },
/* U+68e1 */ { 0, 0, 0, 0, 0 },
/* U+68e2 */ { 0, 0, 0, 0, 0 },
/* U+68e3 */ { 0, 0, 0, 0, 0 },
/* U+68e4 */ { 0, 0, 0, 0, 0 },
/* U+68e5 */ { 0, 0, 0, 0, 0 },
/* U+68e6 */ { 0, 0, 0, 0, 0 },
/* U+68e7 */ { 0, 0, 0, 0, 0 },
/* U+68e8 */ { 0, 0, 0, 0, 0 },
/* U+68e9 */ { 0, 0, 0, 0, 0 },
/* U+68ea */ { 0, 0, 0, 0, 0 },
/* U+68eb */ { 0, 0, 0, 0, 0 },
/* U+68ec */ { 0, 0, 0, 0, 0 },
/* U+68ed */ { 0, 0, 0, 0, 0 },
/* U+68ee */ { 0, 0, 0, 0, 0 },
/* U+68ef */ { 0, 0, 0, 0, 0 },
/* U+68f0 */ { 0, 0, 0, 0, 0 },
/* U+68f1 */ { 0, 0, 0, 0, 0 },
/* U+68f2 */ { 0, 0, 0, 0, 0 },
/* U+68f3 */ { 0, 0, 0, 0, 0 },
/* U+68f4 */ { 0, 0, 0, 0, 0 },
/* U+68f5 */ { 0, 0, 0, 0, 0 },
/* U+68f6 */ { 0, 0, 0, 0, 0 },
/* U+68f7 */ { 0, 0, 0, 0, 0 },
/* U+68f8 */ { 0, 0, 0, 0, 0 },
/* U+68f9 */ { 0, 0, 0, 0, 0 },
/* U+68fa */ { 0, 0, 0, 0, 0 },
/* U+68fb */ { 0, 0, 0, 0, 0 },
/* U+68fc */ { 0, 0, 0, 0, 0 },
/* U+68fd */ { 0, 0, 0, 0, 0 },
/* U+68fe */ { 0, 0, 0, 0, 0 },
/* U+68ff */ { 0, 0, 0, 0, 0 },
/* U+6900 */ { 0, 0, 0, 0, 0 },
/* U+6901 */ { 0, 0, 0, 0, 0 },
/* U+6902 */ { 0, 0, 0, 0, 0 },
/* U+6903 */ { 0, 0, 0, 0, 0 },
/* U+6904 */ { 0, 0, 0, 0, 0 },
/* U+6905 */ { 0, 0, 0, 0, 0 },
/* U+6906 */ { 0, 0, 0, 0, 0 },
/* U+6907 */ { 0, 0, 0, 0, 0 },
/* U+6908 */ { 0, 0, 0, 0, 0 },
/* U+6909 */ { 0, 0, 0, 0, 0 },
/* U+690a */ { 0, 0, 0, 0, 0 },
/* U+690b */ { 0, 0, 0, 0, 0 },
/* U+690c */ { 0, 0, 0, 0, 0 },
/* U+690d */ { 0, 0, 0, 0, 0 },
/* U+690e */ { 0, 0, 0, 0, 0 },
/* U+690f */ { 0, 0, 0, 0, 0 },
/* U+6910 */ { 0, 0, 0, 0, 0 },
/* U+6911 */ { 0, 0, 0, 0, 0 },
/* U+6912 */ { 0, 0, 0, 0, 0 },
/* U+6913 */ { 0, 0, 0, 0, 0 },
/* U+6914 */ { 0, 0, 0, 0, 0 },
/* U+6915 */ { 0, 0, 0, 0, 0 },
/* U+6916 */ { 0, 0, 0, 0, 0 },
/* U+6917 */ { 0, 0, 0, 0, 0 },
/* U+6918 */ { 0, 0, 0, 0, 0 },
/* U+6919 */ { 0, 0, 0, 0, 0 },
/* U+691a */ { 0, 0, 0, 0, 0 },
/* U+691b */ { 0, 0, 0, 0, 0 },
/* U+691c */ { 0, 0, 0, 0, 0 },
/* U+691d */ { 0, 0, 0, 0, 0 },
/* U+691e */ { 0, 0, 0, 0, 0 },
/* U+691f */ { 0, 0, 0, 0, 0 },
/* U+6920 */ { 0, 0, 0, 0, 0 },
/* U+6921 */ { 0, 0, 0, 0, 0 },
/* U+6922 */ { 0, 0, 0, 0, 0 },
/* U+6923 */ { 0, 0, 0, 0, 0 },
/* U+6924 */ { 0, 0, 0, 0, 0 },
/* U+6925 */ { 0, 0, 0, 0, 0 },
/* U+6926 */ { 0, 0, 0, 0, 0 },
/* U+6927 */ { 0, 0, 0, 0, 0 },
/* U+6928 */ { 0, 0, 0, 0, 0 },
/* U+6929 */ { 0, 0, 0, 0, 0 },
/* U+692a */ { 0, 0, 0, 0, 0 },
/* U+692b */ { 0, 0, 0, 0, 0 },
/* U+692c */ { 0, 0, 0, 0, 0 },
/* U+692d */ { 0, 0, 0, 0, 0 },
/* U+692e */ { 0, 0, 0, 0, 0 },
/* U+692f */ { 0, 0, 0, 0, 0 },
/* U+6930 */ { 0, 0, 0, 0, 0 },
/* U+6931 */ { 0, 0, 0, 0, 0 },
/* U+6932 */ { 0, 0, 0, 0, 0 },
/* U+6933 */ { 0, 0, 0, 0, 0 },
/* U+6934 */ { 0, 0, 0, 0, 0 },
/* U+6935 */ { 0, 0, 0, 0, 0 },
/* U+6936 */ { 0, 0, 0, 0, 0 },
/* U+6937 */ { 0, 0, 0, 0, 0 },
/* U+6938 */ { 0, 0, 0, 0, 0 },
/* U+6939 */ { 0, 0, 0, 0, 0 },
/* U+693a */ { 0, 0, 0, 0, 0 },
/* U+693b */ { 0, 0, 0, 0, 0 },
/* U+693c */ { 0, 0, 0, 0, 0 },
/* U+693d */ { 0, 0, 0, 0, 0 },
/* U+693e */ { 0, 0, 0, 0, 0 },
/* U+693f */ { 0, 0, 0, 0, 0 },
/* U+6940 */ { 0, 0, 0, 0, 0 },
/* U+6941 */ { 0, 0, 0, 0, 0 },
/* U+6942 */ { 0, 0, 0, 0, 0 },
/* U+6943 */ { 0, 0, 0, 0, 0 },
/* U+6944 */ { 0, 0, 0, 0, 0 },
/* U+6945 */ { 0, 0, 0, 0, 0 },
/* U+6946 */ { 0, 0, 0, 0, 0 },
/* U+6947 */ { 0, 0, 0, 0, 0 },
/* U+6948 */ { 0, 0, 0, 0, 0 },
/* U+6949 */ { 0, 0, 0, 0, 0 },
/* U+694a */ { 0, 0, 0, 0, 0 },
/* U+694b */ { 0, 0, 0, 0, 0 },
/* U+694c */ { 0, 0, 0, 0, 0 },
/* U+694d */ { 0, 0, 0, 0, 0 },
/* U+694e */ { 0, 0, 0, 0, 0 },
/* U+694f */ { 0, 0, 0, 0, 0 },
/* U+6950 */ { 0, 0, 0, 0, 0 },
/* U+6951 */ { 0, 0, 0, 0, 0 },
/* U+6952 */ { 0, 0, 0, 0, 0 },
/* U+6953 */ { 0, 0, 0, 0, 0 },
/* U+6954 */ { 0, 0, 0, 0, 0 },
/* U+6955 */ { 0, 0, 0, 0, 0 },
/* U+6956 */ { 0, 0, 0, 0, 0 },
/* U+6957 */ { 0, 0, 0, 0, 0 },
/* U+6958 */ { 0, 0, 0, 0, 0 },
/* U+6959 */ { 0, 0, 0, 0, 0 },
/* U+695a */ { 0, 0, 0, 0, 0 },
/* U+695b */ { 0, 0, 0, 0, 0 },
/* U+695c */ { 0, 0, 0, 0, 0 },
/* U+695d */ { 0, 0, 0, 0, 0 },
/* U+695e */ { 0, 0, 0, 0, 0 },
/* U+695f */ { 0, 0, 0, 0, 0 },
/* U+6960 */ { 0, 0, 0, 0, 0 },
/* U+6961 */ { 0, 0, 0, 0, 0 },
/* U+6962 */ { 0, 0, 0, 0, 0 },
/* U+6963 */ { 0, 0, 0, 0, 0 },
/* U+6964 */ { 0, 0, 0, 0, 0 },
/* U+6965 */ { 0, 0, 0, 0, 0 },
/* U+6966 */ { 0, 0, 0, 0, 0 },
/* U+6967 */ { 0, 0, 0, 0, 0 },
/* U+6968 */ { 0, 0, 0, 0, 0 },
/* U+6969 */ { 0, 0, 0, 0, 0 },
/* U+696a */ { 0, 0, 0, 0, 0 },
/* U+696b */ { 0, 0, 0, 0, 0 },
/* U+696c */ { 0, 0, 0, 0, 0 },
/* U+696d */ { 0, 0, 0, 0, 0 },
/* U+696e */ { 0, 0, 0, 0, 0 },
/* U+696f */ { 0, 0, 0, 0, 0 },
/* U+6970 */ { 0, 0, 0, 0, 0 },
/* U+6971 */ { 0, 0, 0, 0, 0 },
/* U+6972 */ { 0, 0, 0, 0, 0 },
/* U+6973 */ { 0, 0, 0, 0, 0 },
/* U+6974 */ { 0, 0, 0, 0, 0 },
/* U+6975 */ { 0, 0, 0, 0, 0 },
/* U+6976 */ { 0, 0, 0, 0, 0 },
/* U+6977 */ { 0, 0, 0, 0, 0 },
/* U+6978 */ { 0, 0, 0, 0, 0 },
/* U+6979 */ { 0, 0, 0, 0, 0 },
/* U+697a */ { 0, 0, 0, 0, 0 },
/* U+697b */ { 0, 0, 0, 0, 0 },
/* U+697c */ { 0, 0, 0, 0, 0 },
/* U+697d */ { 0, 0, 0, 0, 0 },
/* U+697e */ { 0, 0, 0, 0, 0 },
/* U+697f */ { 0, 0, 0, 0, 0 },
/* U+6980 */ { 0, 0, 0, 0, 0 },
/* U+6981 */ { 0, 0, 0, 0, 0 },
/* U+6982 */ { 0, 0, 0, 0, 0 },
/* U+6983 */ { 0, 0, 0, 0, 0 },
/* U+6984 */ { 0, 0, 0, 0, 0 },
/* U+6985 */ { 0, 0, 0, 0, 0 },
/* U+6986 */ { 0, 0, 0, 0, 0 },
/* U+6987 */ { 0, 0, 0, 0, 0 },
/* U+6988 */ { 0, 0, 0, 0, 0 },
/* U+6989 */ { 0, 0, 0, 0, 0 },
/* U+698a */ { 0, 0, 0, 0, 0 },
/* U+698b */ { 0, 0, 0, 0, 0 },
/* U+698c */ { 0, 0, 0, 0, 0 },
/* U+698d */ { 0, 0, 0, 0, 0 },
/* U+698e */ { 0, 0, 0, 0, 0 },
/* U+698f */ { 0, 0, 0, 0, 0 },
/* U+6990 */ { 0, 0, 0, 0, 0 },
/* U+6991 */ { 0, 0, 0, 0, 0 },
/* U+6992 */ { 0, 0, 0, 0, 0 },
/* U+6993 */ { 0, 0, 0, 0, 0 },
/* U+6994 */ { 0, 0, 0, 0, 0 },
/* U+6995 */ { 0, 0, 0, 0, 0 },
/* U+6996 */ { 0, 0, 0, 0, 0 },
/* U+6997 */ { 0, 0, 0, 0, 0 },
/* U+6998 */ { 0, 0, 0, 0, 0 },
/* U+6999 */ { 0, 0, 0, 0, 0 },
/* U+699a */ { 0, 0, 0, 0, 0 },
/* U+699b */ { 0, 0, 0, 0, 0 },
/* U+699c */ { 0, 0, 0, 0, 0 },
/* U+699d */ { 0, 0, 0, 0, 0 },
/* U+699e */ { 0, 0, 0, 0, 0 },
/* U+699f */ { 0, 0, 0, 0, 0 },
/* U+69a0 */ { 0, 0, 0, 0, 0 },
/* U+69a1 */ { 0, 0, 0, 0, 0 },
/* U+69a2 */ { 0, 0, 0, 0, 0 },
/* U+69a3 */ { 0, 0, 0, 0, 0 },
/* U+69a4 */ { 0, 0, 0, 0, 0 },
/* U+69a5 */ { 0, 0, 0, 0, 0 },
/* U+69a6 */ { 0, 0, 0, 0, 0 },
/* U+69a7 */ { 0, 0, 0, 0, 0 },
/* U+69a8 */ { 0, 0, 0, 0, 0 },
/* U+69a9 */ { 0, 0, 0, 0, 0 },
/* U+69aa */ { 0, 0, 0, 0, 0 },
/* U+69ab */ { 0, 0, 0, 0, 0 },
/* U+69ac */ { 0, 0, 0, 0, 0 },
/* U+69ad */ { 0, 0, 0, 0, 0 },
/* U+69ae */ { 0, 0, 0, 0, 0 },
/* U+69af */ { 0, 0, 0, 0, 0 },
/* U+69b0 */ { 0, 0, 0, 0, 0 },
/* U+69b1 */ { 0, 0, 0, 0, 0 },
/* U+69b2 */ { 0, 0, 0, 0, 0 },
/* U+69b3 */ { 0, 0, 0, 0, 0 },
/* U+69b4 */ { 0, 0, 0, 0, 0 },
/* U+69b5 */ { 0, 0, 0, 0, 0 },
/* U+69b6 */ { 0, 0, 0, 0, 0 },
/* U+69b7 */ { 0, 0, 0, 0, 0 },
/* U+69b8 */ { 0, 0, 0, 0, 0 },
/* U+69b9 */ { 0, 0, 0, 0, 0 },
/* U+69ba */ { 0, 0, 0, 0, 0 },
/* U+69bb */ { 0, 0, 0, 0, 0 },
/* U+69bc */ { 0, 0, 0, 0, 0 },
/* U+69bd */ { 0, 0, 0, 0, 0 },
/* U+69be */ { 0, 0, 0, 0, 0 },
/* U+69bf */ { 0, 0, 0, 0, 0 },
/* U+69c0 */ { 0, 0, 0, 0, 0 },
/* U+69c1 */ { 0, 0, 0, 0, 0 },
/* U+69c2 */ { 0, 0, 0, 0, 0 },
/* U+69c3 */ { 0, 0, 0, 0, 0 },
/* U+69c4 */ { 0, 0, 0, 0, 0 },
/* U+69c5 */ { 0, 0, 0, 0, 0 },
/* U+69c6 */ { 0, 0, 0, 0, 0 },
/* U+69c7 */ { 0, 0, 0, 0, 0 },
/* U+69c8 */ { 0, 0, 0, 0, 0 },
/* U+69c9 */ { 0, 0, 0, 0, 0 },
/* U+69ca */ { 0, 0, 0, 0, 0 },
/* U+69cb */ { 0, 0, 0, 0, 0 },
/* U+69cc */ { 0, 0, 0, 0, 0 },
/* U+69cd */ { 0, 0, 0, 0, 0 },
/* U+69ce */ { 0, 0, 0, 0, 0 },
/* U+69cf */ { 0, 0, 0, 0, 0 },
/* U+69d0 */ { 0, 0, 0, 0, 0 },
/* U+69d1 */ { 0, 0, 0, 0, 0 },
/* U+69d2 */ { 0, 0, 0, 0, 0 },
/* U+69d3 */ { 0, 0, 0, 0, 0 },
/* U+69d4 */ { 0, 0, 0, 0, 0 },
/* U+69d5 */ { 0, 0, 0, 0, 0 },
/* U+69d6 */ { 0, 0, 0, 0, 0 },
/* U+69d7 */ { 0, 0, 0, 0, 0 },
/* U+69d8 */ { 0, 0, 0, 0, 0 },
/* U+69d9 */ { 0, 0, 0, 0, 0 },
/* U+69da */ { 0, 0, 0, 0, 0 },
/* U+69db */ { 0, 0, 0, 0, 0 },
/* U+69dc */ { 0, 0, 0, 0, 0 },
/* U+69dd */ { 0, 0, 0, 0, 0 },
/* U+69de */ { 0, 0, 0, 0, 0 },
/* U+69df */ { 0, 0, 0, 0, 0 },
/* U+69e0 */ { 0, 0, 0, 0, 0 },
/* U+69e1 */ { 0, 0, 0, 0, 0 },
/* U+69e2 */ { 0, 0, 0, 0, 0 },
/* U+69e3 */ { 0, 0, 0, 0, 0 },
/* U+69e4 */ { 0, 0, 0, 0, 0 },
/* U+69e5 */ { 0, 0, 0, 0, 0 },
/* U+69e6 */ { 0, 0, 0, 0, 0 },
/* U+69e7 */ { 0, 0, 0, 0, 0 },
/* U+69e8 */ { 0, 0, 0, 0, 0 },
/* U+69e9 */ { 0, 0, 0, 0, 0 },
/* U+69ea */ { 0, 0, 0, 0, 0 },
/* U+69eb */ { 0, 0, 0, 0, 0 },
/* U+69ec */ { 0, 0, 0, 0, 0 },
/* U+69ed */ { 0, 0, 0, 0, 0 },
/* U+69ee */ { 0, 0, 0, 0, 0 },
/* U+69ef */ { 0, 0, 0, 0, 0 },
/* U+69f0 */ { 0, 0, 0, 0, 0 },
/* U+69f1 */ { 0, 0, 0, 0, 0 },
/* U+69f2 */ { 0, 0, 0, 0, 0 },
/* U+69f3 */ { 0, 0, 0, 0, 0 },
/* U+69f4 */ { 0, 0, 0, 0, 0 },
/* U+69f5 */ { 0, 0, 0, 0, 0 },
/* U+69f6 */ { 0, 0, 0, 0, 0 },
/* U+69f7 */ { 0, 0, 0, 0, 0 },
/* U+69f8 */ { 0, 0, 0, 0, 0 },
/* U+69f9 */ { 0, 0, 0, 0, 0 },
/* U+69fa */ { 0, 0, 0, 0, 0 },
/* U+69fb */ { 0, 0, 0, 0, 0 },
/* U+69fc */ { 0, 0, 0, 0, 0 },
/* U+69fd */ { 0, 0, 0, 0, 0 },
/* U+69fe */ { 0, 0, 0, 0, 0 },
/* U+69ff */ { 0, 0, 0, 0, 0 },
/* U+6a00 */ { 0, 0, 0, 0, 0 },
/* U+6a01 */ { 0, 0, 0, 0, 0 },
/* U+6a02 */ { 0, 0, 0, 0, 0 },
/* U+6a03 */ { 0, 0, 0, 0, 0 },
/* U+6a04 */ { 0, 0, 0, 0, 0 },
/* U+6a05 */ { 0, 0, 0, 0, 0 },
/* U+6a06 */ { 0, 0, 0, 0, 0 },
/* U+6a07 */ { 0, 0, 0, 0, 0 },
/* U+6a08 */ { 0, 0, 0, 0, 0 },
/* U+6a09 */ { 0, 0, 0, 0, 0 },
/* U+6a0a */ { 0, 0, 0, 0, 0 },
/* U+6a0b */ { 0, 0, 0, 0, 0 },
/* U+6a0c */ { 0, 0, 0, 0, 0 },
/* U+6a0d */ { 0, 0, 0, 0, 0 },
/* U+6a0e */ { 0, 0, 0, 0, 0 },
/* U+6a0f */ { 0, 0, 0, 0, 0 },
/* U+6a10 */ { 0, 0, 0, 0, 0 },
/* U+6a11 */ { 0, 0, 0, 0, 0 },
/* U+6a12 */ { 0, 0, 0, 0, 0 },
/* U+6a13 */ { 0, 0, 0, 0, 0 },
/* U+6a14 */ { 0, 0, 0, 0, 0 },
/* U+6a15 */ { 0, 0, 0, 0, 0 },
/* U+6a16 */ { 0, 0, 0, 0, 0 },
/* U+6a17 */ { 0, 0, 0, 0, 0 },
/* U+6a18 */ { 0, 0, 0, 0, 0 },
/* U+6a19 */ { 0, 0, 0, 0, 0 },
/* U+6a1a */ { 0, 0, 0, 0, 0 },
/* U+6a1b */ { 0, 0, 0, 0, 0 },
/* U+6a1c */ { 0, 0, 0, 0, 0 },
/* U+6a1d */ { 0, 0, 0, 0, 0 },
/* U+6a1e */ { 0, 0, 0, 0, 0 },
/* U+6a1f */ { 0, 0, 0, 0, 0 },
/* U+6a20 */ { 0, 0, 0, 0, 0 },
/* U+6a21 */ { 0, 0, 0, 0, 0 },
/* U+6a22 */ { 0, 0, 0, 0, 0 },
/* U+6a23 */ { 0, 0, 0, 0, 0 },
/* U+6a24 */ { 0, 0, 0, 0, 0 },
/* U+6a25 */ { 0, 0, 0, 0, 0 },
/* U+6a26 */ { 0, 0, 0, 0, 0 },
/* U+6a27 */ { 0, 0, 0, 0, 0 },
/* U+6a28 */ { 0, 0, 0, 0, 0 },
/* U+6a29 */ { 0, 0, 0, 0, 0 },
/* U+6a2a */ { 0, 0, 0, 0, 0 },
/* U+6a2b */ { 0, 0, 0, 0, 0 },
/* U+6a2c */ { 0, 0, 0, 0, 0 },
/* U+6a2d */ { 0, 0, 0, 0, 0 },
/* U+6a2e */ { 0, 0, 0, 0, 0 },
/* U+6a2f */ { 0, 0, 0, 0, 0 },
/* U+6a30 */ { 0, 0, 0, 0, 0 },
/* U+6a31 */ { 0, 0, 0, 0, 0 },
/* U+6a32 */ { 0, 0, 0, 0, 0 },
/* U+6a33 */ { 0, 0, 0, 0, 0 },
/* U+6a34 */ { 0, 0, 0, 0, 0 },
/* U+6a35 */ { 0, 0, 0, 0, 0 },
/* U+6a36 */ { 0, 0, 0, 0, 0 },
/* U+6a37 */ { 0, 0, 0, 0, 0 },
/* U+6a38 */ { 0, 0, 0, 0, 0 },
/* U+6a39 */ { 0, 0, 0, 0, 0 },
/* U+6a3a */ { 0, 0, 0, 0, 0 },
/* U+6a3b */ { 0, 0, 0, 0, 0 },
/* U+6a3c */ { 0, 0, 0, 0, 0 },
/* U+6a3d */ { 0, 0, 0, 0, 0 },
/* U+6a3e */ { 0, 0, 0, 0, 0 },
/* U+6a3f */ { 0, 0, 0, 0, 0 },
/* U+6a40 */ { 0, 0, 0, 0, 0 },
/* U+6a41 */ { 0, 0, 0, 0, 0 },
/* U+6a42 */ { 0, 0, 0, 0, 0 },
/* U+6a43 */ { 0, 0, 0, 0, 0 },
/* U+6a44 */ { 0, 0, 0, 0, 0 },
/* U+6a45 */ { 0, 0, 0, 0, 0 },
/* U+6a46 */ { 0, 0, 0, 0, 0 },
/* U+6a47 */ { 0, 0, 0, 0, 0 },
/* U+6a48 */ { 0, 0, 0, 0, 0 },
/* U+6a49 */ { 0, 0, 0, 0, 0 },
/* U+6a4a */ { 0, 0, 0, 0, 0 },
/* U+6a4b */ { 0, 0, 0, 0, 0 },
/* U+6a4c */ { 0, 0, 0, 0, 0 },
/* U+6a4d */ { 0, 0, 0, 0, 0 },
/* U+6a4e */ { 0, 0, 0, 0, 0 },
/* U+6a4f */ { 0, 0, 0, 0, 0 },
/* U+6a50 */ { 0, 0, 0, 0, 0 },
/* U+6a51 */ { 0, 0, 0, 0, 0 },
/* U+6a52 */ { 0, 0, 0, 0, 0 },
/* U+6a53 */ { 0, 0, 0, 0, 0 },
/* U+6a54 */ { 0, 0, 0, 0, 0 },
/* U+6a55 */ { 0, 0, 0, 0, 0 },
/* U+6a56 */ { 0, 0, 0, 0, 0 },
/* U+6a57 */ { 0, 0, 0, 0, 0 },
/* U+6a58 */ { 0, 0, 0, 0, 0 },
/* U+6a59 */ { 0, 0, 0, 0, 0 },
/* U+6a5a */ { 0, 0, 0, 0, 0 },
/* U+6a5b */ { 0, 0, 0, 0, 0 },
/* U+6a5c */ { 0, 0, 0, 0, 0 },
/* U+6a5d */ { 0, 0, 0, 0, 0 },
/* U+6a5e */ { 0, 0, 0, 0, 0 },
/* U+6a5f */ { 0, 0, 0, 0, 0 },
/* U+6a60 */ { 0, 0, 0, 0, 0 },
/* U+6a61 */ { 0, 0, 0, 0, 0 },
/* U+6a62 */ { 0, 0, 0, 0, 0 },
/* U+6a63 */ { 0, 0, 0, 0, 0 },
/* U+6a64 */ { 0, 0, 0, 0, 0 },
/* U+6a65 */ { 0, 0, 0, 0, 0 },
/* U+6a66 */ { 0, 0, 0, 0, 0 },
/* U+6a67 */ { 0, 0, 0, 0, 0 },
/* U+6a68 */ { 0, 0, 0, 0, 0 },
/* U+6a69 */ { 0, 0, 0, 0, 0 },
/* U+6a6a */ { 0, 0, 0, 0, 0 },
/* U+6a6b */ { 0, 0, 0, 0, 0 },
/* U+6a6c */ { 0, 0, 0, 0, 0 },
/* U+6a6d */ { 0, 0, 0, 0, 0 },
/* U+6a6e */ { 0, 0, 0, 0, 0 },
/* U+6a6f */ { 0, 0, 0, 0, 0 },
/* U+6a70 */ { 0, 0, 0, 0, 0 },
/* U+6a71 */ { 0, 0, 0, 0, 0 },
/* U+6a72 */ { 0, 0, 0, 0, 0 },
/* U+6a73 */ { 0, 0, 0, 0, 0 },
/* U+6a74 */ { 0, 0, 0, 0, 0 },
/* U+6a75 */ { 0, 0, 0, 0, 0 },
/* U+6a76 */ { 0, 0, 0, 0, 0 },
/* U+6a77 */ { 0, 0, 0, 0, 0 },
/* U+6a78 */ { 0, 0, 0, 0, 0 },
/* U+6a79 */ { 0, 0, 0, 0, 0 },
/* U+6a7a */ { 0, 0, 0, 0, 0 },
/* U+6a7b */ { 0, 0, 0, 0, 0 },
/* U+6a7c */ { 0, 0, 0, 0, 0 },
/* U+6a7d */ { 0, 0, 0, 0, 0 },
/* U+6a7e */ { 0, 0, 0, 0, 0 },
/* U+6a7f */ { 0, 0, 0, 0, 0 },
/* U+6a80 */ { 0, 0, 0, 0, 0 },
/* U+6a81 */ { 0, 0, 0, 0, 0 },
/* U+6a82 */ { 0, 0, 0, 0, 0 },
/* U+6a83 */ { 0, 0, 0, 0, 0 },
/* U+6a84 */ { 0, 0, 0, 0, 0 },
/* U+6a85 */ { 0, 0, 0, 0, 0 },
/* U+6a86 */ { 0, 0, 0, 0, 0 },
/* U+6a87 */ { 0, 0, 0, 0, 0 },
/* U+6a88 */ { 0, 0, 0, 0, 0 },
/* U+6a89 */ { 0, 0, 0, 0, 0 },
/* U+6a8a */ { 0, 0, 0, 0, 0 },
/* U+6a8b */ { 0, 0, 0, 0, 0 },
/* U+6a8c */ { 0, 0, 0, 0, 0 },
/* U+6a8d */ { 0, 0, 0, 0, 0 },
/* U+6a8e */ { 0, 0, 0, 0, 0 },
/* U+6a8f */ { 0, 0, 0, 0, 0 },
/* U+6a90 */ { 0, 0, 0, 0, 0 },
/* U+6a91 */ { 0, 0, 0, 0, 0 },
/* U+6a92 */ { 0, 0, 0, 0, 0 },
/* U+6a93 */ { 0, 0, 0, 0, 0 },
/* U+6a94 */ { 0, 0, 0, 0, 0 },
/* U+6a95 */ { 0, 0, 0, 0, 0 },
/* U+6a96 */ { 0, 0, 0, 0, 0 },
/* U+6a97 */ { 0, 0, 0, 0, 0 },
/* U+6a98 */ { 0, 0, 0, 0, 0 },
/* U+6a99 */ { 0, 0, 0, 0, 0 },
/* U+6a9a */ { 0, 0, 0, 0, 0 },
/* U+6a9b */ { 0, 0, 0, 0, 0 },
/* U+6a9c */ { 0, 0, 0, 0, 0 },
/* U+6a9d */ { 0, 0, 0, 0, 0 },
/* U+6a9e */ { 0, 0, 0, 0, 0 },
/* U+6a9f */ { 0, 0, 0, 0, 0 },
/* U+6aa0 */ { 0, 0, 0, 0, 0 },
/* U+6aa1 */ { 0, 0, 0, 0, 0 },
/* U+6aa2 */ { 0, 0, 0, 0, 0 },
/* U+6aa3 */ { 0, 0, 0, 0, 0 },
/* U+6aa4 */ { 0, 0, 0, 0, 0 },
/* U+6aa5 */ { 0, 0, 0, 0, 0 },
/* U+6aa6 */ { 0, 0, 0, 0, 0 },
/* U+6aa7 */ { 0, 0, 0, 0, 0 },
/* U+6aa8 */ { 0, 0, 0, 0, 0 },
/* U+6aa9 */ { 0, 0, 0, 0, 0 },
/* U+6aaa */ { 0, 0, 0, 0, 0 },
/* U+6aab */ { 0, 0, 0, 0, 0 },
/* U+6aac */ { 0, 0, 0, 0, 0 },
/* U+6aad */ { 0, 0, 0, 0, 0 },
/* U+6aae */ { 0, 0, 0, 0, 0 },
/* U+6aaf */ { 0, 0, 0, 0, 0 },
/* U+6ab0 */ { 0, 0, 0, 0, 0 },
/* U+6ab1 */ { 0, 0, 0, 0, 0 },
/* U+6ab2 */ { 0, 0, 0, 0, 0 },
/* U+6ab3 */ { 0, 0, 0, 0, 0 },
/* U+6ab4 */ { 0, 0, 0, 0, 0 },
/* U+6ab5 */ { 0, 0, 0, 0, 0 },
/* U+6ab6 */ { 0, 0, 0, 0, 0 },
/* U+6ab7 */ { 0, 0, 0, 0, 0 },
/* U+6ab8 */ { 0, 0, 0, 0, 0 },
/* U+6ab9 */ { 0, 0, 0, 0, 0 },
/* U+6aba */ { 0, 0, 0, 0, 0 },
/* U+6abb */ { 0, 0, 0, 0, 0 },
/* U+6abc */ { 0, 0, 0, 0, 0 },
/* U+6abd */ { 0, 0, 0, 0, 0 },
/* U+6abe */ { 0, 0, 0, 0, 0 },
/* U+6abf */ { 0, 0, 0, 0, 0 },
/* U+6ac0 */ { 0, 0, 0, 0, 0 },
/* U+6ac1 */ { 0, 0, 0, 0, 0 },
/* U+6ac2 */ { 0, 0, 0, 0, 0 },
/* U+6ac3 */ { 0, 0, 0, 0, 0 },
/* U+6ac4 */ { 0, 0, 0, 0, 0 },
/* U+6ac5 */ { 0, 0, 0, 0, 0 },
/* U+6ac6 */ { 0, 0, 0, 0, 0 },
/* U+6ac7 */ { 0, 0, 0, 0, 0 },
/* U+6ac8 */ { 0, 0, 0, 0, 0 },
/* U+6ac9 */ { 0, 0, 0, 0, 0 },
/* U+6aca */ { 0, 0, 0, 0, 0 },
/* U+6acb */ { 0, 0, 0, 0, 0 },
/* U+6acc */ { 0, 0, 0, 0, 0 },
/* U+6acd */ { 0, 0, 0, 0, 0 },
/* U+6ace */ { 0, 0, 0, 0, 0 },
/* U+6acf */ { 0, 0, 0, 0, 0 },
/* U+6ad0 */ { 0, 0, 0, 0, 0 },
/* U+6ad1 */ { 0, 0, 0, 0, 0 },
/* U+6ad2 */ { 0, 0, 0, 0, 0 },
/* U+6ad3 */ { 0, 0, 0, 0, 0 },
/* U+6ad4 */ { 0, 0, 0, 0, 0 },
/* U+6ad5 */ { 0, 0, 0, 0, 0 },
/* U+6ad6 */ { 0, 0, 0, 0, 0 },
/* U+6ad7 */ { 0, 0, 0, 0, 0 },
/* U+6ad8 */ { 0, 0, 0, 0, 0 },
/* U+6ad9 */ { 0, 0, 0, 0, 0 },
/* U+6ada */ { 0, 0, 0, 0, 0 },
/* U+6adb */ { 0, 0, 0, 0, 0 },
/* U+6adc */ { 0, 0, 0, 0, 0 },
/* U+6add */ { 0, 0, 0, 0, 0 },
/* U+6ade */ { 0, 0, 0, 0, 0 },
/* U+6adf */ { 0, 0, 0, 0, 0 },
/* U+6ae0 */ { 0, 0, 0, 0, 0 },
/* U+6ae1 */ { 0, 0, 0, 0, 0 },
/* U+6ae2 */ { 0, 0, 0, 0, 0 },
/* U+6ae3 */ { 0, 0, 0, 0, 0 },
/* U+6ae4 */ { 0, 0, 0, 0, 0 },
/* U+6ae5 */ { 0, 0, 0, 0, 0 },
/* U+6ae6 */ { 0, 0, 0, 0, 0 },
/* U+6ae7 */ { 0, 0, 0, 0, 0 },
/* U+6ae8 */ { 0, 0, 0, 0, 0 },
/* U+6ae9 */ { 0, 0, 0, 0, 0 },
/* U+6aea */ { 0, 0, 0, 0, 0 },
/* U+6aeb */ { 0, 0, 0, 0, 0 },
/* U+6aec */ { 0, 0, 0, 0, 0 },
/* U+6aed */ { 0, 0, 0, 0, 0 },
/* U+6aee */ { 0, 0, 0, 0, 0 },
/* U+6aef */ { 0, 0, 0, 0, 0 },
/* U+6af0 */ { 0, 0, 0, 0, 0 },
/* U+6af1 */ { 0, 0, 0, 0, 0 },
/* U+6af2 */ { 0, 0, 0, 0, 0 },
/* U+6af3 */ { 0, 0, 0, 0, 0 },
/* U+6af4 */ { 0, 0, 0, 0, 0 },
/* U+6af5 */ { 0, 0, 0, 0, 0 },
/* U+6af6 */ { 0, 0, 0, 0, 0 },
/* U+6af7 */ { 0, 0, 0, 0, 0 },
/* U+6af8 */ { 0, 0, 0, 0, 0 },
/* U+6af9 */ { 0, 0, 0, 0, 0 },
/* U+6afa */ { 0, 0, 0, 0, 0 },
/* U+6afb */ { 0, 0, 0, 0, 0 },
/* U+6afc */ { 0, 0, 0, 0, 0 },
/* U+6afd */ { 0, 0, 0, 0, 0 },
/* U+6afe */ { 0, 0, 0, 0, 0 },
/* U+6aff */ { 0, 0, 0, 0, 0 },
/* U+6b00 */ { 0, 0, 0, 0, 0 },
/* U+6b01 */ { 0, 0, 0, 0, 0 },
/* U+6b02 */ { 0, 0, 0, 0, 0 },
/* U+6b03 */ { 0, 0, 0, 0, 0 },
/* U+6b04 */ { 0, 0, 0, 0, 0 },
/* U+6b05 */ { 0, 0, 0, 0, 0 },
/* U+6b06 */ { 0, 0, 0, 0, 0 },
/* U+6b07 */ { 0, 0, 0, 0, 0 },
/* U+6b08 */ { 0, 0, 0, 0, 0 },
/* U+6b09 */ { 0, 0, 0, 0, 0 },
/* U+6b0a */ { 0, 0, 0, 0, 0 },
/* U+6b0b */ { 0, 0, 0, 0, 0 },
/* U+6b0c */ { 0, 0, 0, 0, 0 },
/* U+6b0d */ { 0, 0, 0, 0, 0 },
/* U+6b0e */ { 0, 0, 0, 0, 0 },
/* U+6b0f */ { 0, 0, 0, 0, 0 },
/* U+6b10 */ { 0, 0, 0, 0, 0 },
/* U+6b11 */ { 0, 0, 0, 0, 0 },
/* U+6b12 */ { 0, 0, 0, 0, 0 },
/* U+6b13 */ { 0, 0, 0, 0, 0 },
/* U+6b14 */ { 0, 0, 0, 0, 0 },
/* U+6b15 */ { 0, 0, 0, 0, 0 },
/* U+6b16 */ { 0, 0, 0, 0, 0 },
/* U+6b17 */ { 0, 0, 0, 0, 0 },
/* U+6b18 */ { 0, 0, 0, 0, 0 },
/* U+6b19 */ { 0, 0, 0, 0, 0 },
/* U+6b1a */ { 0, 0, 0, 0, 0 },
/* U+6b1b */ { 0, 0, 0, 0, 0 },
/* U+6b1c */ { 0, 0, 0, 0, 0 },
/* U+6b1d */ { 0, 0, 0, 0, 0 },
/* U+6b1e */ { 0, 0, 0, 0, 0 },
/* U+6b1f */ { 0, 0, 0, 0, 0 },
/* U+6b20 */ { 0, 0, 0, 0, 0 },
/* U+6b21 */ { 0, 0, 0, 0, 0 },
/* U+6b22 */ { 0, 0, 0, 0, 0 },
/* U+6b23 */ { 0, 0, 0, 0, 0 },
/* U+6b24 */ { 0, 0, 0, 0, 0 },
/* U+6b25 */ { 0, 0, 0, 0, 0 },
/* U+6b26 */ { 0, 0, 0, 0, 0 },
/* U+6b27 */ { 0, 0, 0, 0, 0 },
/* U+6b28 */ { 0, 0, 0, 0, 0 },
/* U+6b29 */ { 0, 0, 0, 0, 0 },
/* U+6b2a */ { 0, 0, 0, 0, 0 },
/* U+6b2b */ { 0, 0, 0, 0, 0 },
/* U+6b2c */ { 0, 0, 0, 0, 0 },
/* U+6b2d */ { 0, 0, 0, 0, 0 },
/* U+6b2e */ { 0, 0, 0, 0, 0 },
/* U+6b2f */ { 0, 0, 0, 0, 0 },
/* U+6b30 */ { 0, 0, 0, 0, 0 },
/* U+6b31 */ { 0, 0, 0, 0, 0 },
/* U+6b32 */ { 0, 0, 0, 0, 0 },
/* U+6b33 */ { 0, 0, 0, 0, 0 },
/* U+6b34 */ { 0, 0, 0, 0, 0 },
/* U+6b35 */ { 0, 0, 0, 0, 0 },
/* U+6b36 */ { 0, 0, 0, 0, 0 },
/* U+6b37 */ { 0, 0, 0, 0, 0 },
/* U+6b38 */ { 0, 0, 0, 0, 0 },
/* U+6b39 */ { 0, 0, 0, 0, 0 },
/* U+6b3a */ { 0, 0, 0, 0, 0 },
/* U+6b3b */ { 0, 0, 0, 0, 0 },
/* U+6b3c */ { 0, 0, 0, 0, 0 },
/* U+6b3d */ { 0, 0, 0, 0, 0 },
/* U+6b3e */ { 0, 0, 0, 0, 0 },
/* U+6b3f */ { 0, 0, 0, 0, 0 },
/* U+6b40 */ { 0, 0, 0, 0, 0 },
/* U+6b41 */ { 0, 0, 0, 0, 0 },
/* U+6b42 */ { 0, 0, 0, 0, 0 },
/* U+6b43 */ { 0, 0, 0, 0, 0 },
/* U+6b44 */ { 0, 0, 0, 0, 0 },
/* U+6b45 */ { 0, 0, 0, 0, 0 },
/* U+6b46 */ { 0, 0, 0, 0, 0 },
/* U+6b47 */ { 0, 0, 0, 0, 0 },
/* U+6b48 */ { 0, 0, 0, 0, 0 },
/* U+6b49 */ { 0, 0, 0, 0, 0 },
/* U+6b4a */ { 0, 0, 0, 0, 0 },
/* U+6b4b */ { 0, 0, 0, 0, 0 },
/* U+6b4c */ { 0, 0, 0, 0, 0 },
/* U+6b4d */ { 0, 0, 0, 0, 0 },
/* U+6b4e */ { 0, 0, 0, 0, 0 },
/* U+6b4f */ { 0, 0, 0, 0, 0 },
/* U+6b50 */ { 0, 0, 0, 0, 0 },
/* U+6b51 */ { 0, 0, 0, 0, 0 },
/* U+6b52 */ { 0, 0, 0, 0, 0 },
/* U+6b53 */ { 0, 0, 0, 0, 0 },
/* U+6b54 */ { 0, 0, 0, 0, 0 },
/* U+6b55 */ { 0, 0, 0, 0, 0 },
/* U+6b56 */ { 0, 0, 0, 0, 0 },
/* U+6b57 */ { 0, 0, 0, 0, 0 },
/* U+6b58 */ { 0, 0, 0, 0, 0 },
/* U+6b59 */ { 0, 0, 0, 0, 0 },
/* U+6b5a */ { 0, 0, 0, 0, 0 },
/* U+6b5b */ { 0, 0, 0, 0, 0 },
/* U+6b5c */ { 0, 0, 0, 0, 0 },
/* U+6b5d */ { 0, 0, 0, 0, 0 },
/* U+6b5e */ { 0, 0, 0, 0, 0 },
/* U+6b5f */ { 0, 0, 0, 0, 0 },
/* U+6b60 */ { 0, 0, 0, 0, 0 },
/* U+6b61 */ { 0, 0, 0, 0, 0 },
/* U+6b62 */ { 0, 0, 0, 0, 0 },
/* U+6b63 */ { 0, 0, 0, 0, 0 },
/* U+6b64 */ { 0, 0, 0, 0, 0 },
/* U+6b65 */ { 0, 0, 0, 0, 0 },
/* U+6b66 */ { 0, 0, 0, 0, 0 },
/* U+6b67 */ { 0, 0, 0, 0, 0 },
/* U+6b68 */ { 0, 0, 0, 0, 0 },
/* U+6b69 */ { 0, 0, 0, 0, 0 },
/* U+6b6a */ { 0, 0, 0, 0, 0 },
/* U+6b6b */ { 0, 0, 0, 0, 0 },
/* U+6b6c */ { 0, 0, 0, 0, 0 },
/* U+6b6d */ { 0, 0, 0, 0, 0 },
/* U+6b6e */ { 0, 0, 0, 0, 0 },
/* U+6b6f */ { 0, 0, 0, 0, 0 },
/* U+6b70 */ { 0, 0, 0, 0, 0 },
/* U+6b71 */ { 0, 0, 0, 0, 0 },
/* U+6b72 */ { 0, 0, 0, 0, 0 },
/* U+6b73 */ { 0, 0, 0, 0, 0 },
/* U+6b74 */ { 0, 0, 0, 0, 0 },
/* U+6b75 */ { 0, 0, 0, 0, 0 },
/* U+6b76 */ { 0, 0, 0, 0, 0 },
/* U+6b77 */ { 0, 0, 0, 0, 0 },
/* U+6b78 */ { 0, 0, 0, 0, 0 },
/* U+6b79 */ { 0, 0, 0, 0, 0 },
/* U+6b7a */ { 0, 0, 0, 0, 0 },
/* U+6b7b */ { 0, 0, 0, 0, 0 },
/* U+6b7c */ { 0, 0, 0, 0, 0 },
/* U+6b7d */ { 0, 0, 0, 0, 0 },
/* U+6b7e */ { 0, 0, 0, 0, 0 },
/* U+6b7f */ { 0, 0, 0, 0, 0 },
/* U+6b80 */ { 0, 0, 0, 0, 0 },
/* U+6b81 */ { 0, 0, 0, 0, 0 },
/* U+6b82 */ { 0, 0, 0, 0, 0 },
/* U+6b83 */ { 0, 0, 0, 0, 0 },
/* U+6b84 */ { 0, 0, 0, 0, 0 },
/* U+6b85 */ { 0, 0, 0, 0, 0 },
/* U+6b86 */ { 0, 0, 0, 0, 0 },
/* U+6b87 */ { 0, 0, 0, 0, 0 },
/* U+6b88 */ { 0, 0, 0, 0, 0 },
/* U+6b89 */ { 0, 0, 0, 0, 0 },
/* U+6b8a */ { 0, 0, 0, 0, 0 },
/* U+6b8b */ { 0, 0, 0, 0, 0 },
/* U+6b8c */ { 0, 0, 0, 0, 0 },
/* U+6b8d */ { 0, 0, 0, 0, 0 },
/* U+6b8e */ { 0, 0, 0, 0, 0 },
/* U+6b8f */ { 0, 0, 0, 0, 0 },
/* U+6b90 */ { 0, 0, 0, 0, 0 },
/* U+6b91 */ { 0, 0, 0, 0, 0 },
/* U+6b92 */ { 0, 0, 0, 0, 0 },
/* U+6b93 */ { 0, 0, 0, 0, 0 },
/* U+6b94 */ { 0, 0, 0, 0, 0 },
/* U+6b95 */ { 0, 0, 0, 0, 0 },
/* U+6b96 */ { 0, 0, 0, 0, 0 },
/* U+6b97 */ { 0, 0, 0, 0, 0 },
/* U+6b98 */ { 0, 0, 0, 0, 0 },
/* U+6b99 */ { 0, 0, 0, 0, 0 },
/* U+6b9a */ { 0, 0, 0, 0, 0 },
/* U+6b9b */ { 0, 0, 0, 0, 0 },
/* U+6b9c */ { 0, 0, 0, 0, 0 },
/* U+6b9d */ { 0, 0, 0, 0, 0 },
/* U+6b9e */ { 0, 0, 0, 0, 0 },
/* U+6b9f */ { 0, 0, 0, 0, 0 },
/* U+6ba0 */ { 0, 0, 0, 0, 0 },
/* U+6ba1 */ { 0, 0, 0, 0, 0 },
/* U+6ba2 */ { 0, 0, 0, 0, 0 },
/* U+6ba3 */ { 0, 0, 0, 0, 0 },
/* U+6ba4 */ { 0, 0, 0, 0, 0 },
/* U+6ba5 */ { 0, 0, 0, 0, 0 },
/* U+6ba6 */ { 0, 0, 0, 0, 0 },
/* U+6ba7 */ { 0, 0, 0, 0, 0 },
/* U+6ba8 */ { 0, 0, 0, 0, 0 },
/* U+6ba9 */ { 0, 0, 0, 0, 0 },
/* U+6baa */ { 0, 0, 0, 0, 0 },
/* U+6bab */ { 0, 0, 0, 0, 0 },
/* U+6bac */ { 0, 0, 0, 0, 0 },
/* U+6bad */ { 0, 0, 0, 0, 0 },
/* U+6bae */ { 0, 0, 0, 0, 0 },
/* U+6baf */ { 0, 0, 0, 0, 0 },
/* U+6bb0 */ { 0, 0, 0, 0, 0 },
/* U+6bb1 */ { 0, 0, 0, 0, 0 },
/* U+6bb2 */ { 0, 0, 0, 0, 0 },
/* U+6bb3 */ { 0, 0, 0, 0, 0 },
/* U+6bb4 */ { 0, 0, 0, 0, 0 },
/* U+6bb5 */ { 0, 0, 0, 0, 0 },
/* U+6bb6 */ { 0, 0, 0, 0, 0 },
/* U+6bb7 */ { 0, 0, 0, 0, 0 },
/* U+6bb8 */ { 0, 0, 0, 0, 0 },
/* U+6bb9 */ { 0, 0, 0, 0, 0 },
/* U+6bba */ { 0, 0, 0, 0, 0 },
/* U+6bbb */ { 0, 0, 0, 0, 0 },
/* U+6bbc */ { 0, 0, 0, 0, 0 },
/* U+6bbd */ { 0, 0, 0, 0, 0 },
/* U+6bbe */ { 0, 0, 0, 0, 0 },
/* U+6bbf */ { 0, 0, 0, 0, 0 },
/* U+6bc0 */ { 0, 0, 0, 0, 0 },
/* U+6bc1 */ { 0, 0, 0, 0, 0 },
/* U+6bc2 */ { 0, 0, 0, 0, 0 },
/* U+6bc3 */ { 0, 0, 0, 0, 0 },
/* U+6bc4 */ { 0, 0, 0, 0, 0 },
/* U+6bc5 */ { 0, 0, 0, 0, 0 },
/* U+6bc6 */ { 0, 0, 0, 0, 0 },
/* U+6bc7 */ { 0, 0, 0, 0, 0 },
/* U+6bc8 */ { 0, 0, 0, 0, 0 },
/* U+6bc9 */ { 0, 0, 0, 0, 0 },
/* U+6bca */ { 0, 0, 0, 0, 0 },
/* U+6bcb */ { 0, 0, 0, 0, 0 },
/* U+6bcc */ { 0, 0, 0, 0, 0 },
/* U+6bcd */ { 0, 0, 0, 0, 0 },
/* U+6bce */ { 0, 0, 0, 0, 0 },
/* U+6bcf */ { 0, 0, 0, 0, 0 },
/* U+6bd0 */ { 0, 0, 0, 0, 0 },
/* U+6bd1 */ { 0, 0, 0, 0, 0 },
/* U+6bd2 */ { 0, 0, 0, 0, 0 },
/* U+6bd3 */ { 0, 0, 0, 0, 0 },
/* U+6bd4 */ { 0, 0, 0, 0, 0 },
/* U+6bd5 */ { 0, 0, 0, 0, 0 },
/* U+6bd6 */ { 0, 0, 0, 0, 0 },
/* U+6bd7 */ { 0, 0, 0, 0, 0 },
/* U+6bd8 */ { 0, 0, 0, 0, 0 },
/* U+6bd9 */ { 0, 0, 0, 0, 0 },
/* U+6bda */ { 0, 0, 0, 0, 0 },
/* U+6bdb */ { 0, 0, 0, 0, 0 },
/* U+6bdc */ { 0, 0, 0, 0, 0 },
/* U+6bdd */ { 0, 0, 0, 0, 0 },
/* U+6bde */ { 0, 0, 0, 0, 0 },
/* U+6bdf */ { 0, 0, 0, 0, 0 },
/* U+6be0 */ { 0, 0, 0, 0, 0 },
/* U+6be1 */ { 0, 0, 0, 0, 0 },
/* U+6be2 */ { 0, 0, 0, 0, 0 },
/* U+6be3 */ { 0, 0, 0, 0, 0 },
/* U+6be4 */ { 0, 0, 0, 0, 0 },
/* U+6be5 */ { 0, 0, 0, 0, 0 },
/* U+6be6 */ { 0, 0, 0, 0, 0 },
/* U+6be7 */ { 0, 0, 0, 0, 0 },
/* U+6be8 */ { 0, 0, 0, 0, 0 },
/* U+6be9 */ { 0, 0, 0, 0, 0 },
/* U+6bea */ { 0, 0, 0, 0, 0 },
/* U+6beb */ { 0, 0, 0, 0, 0 },
/* U+6bec */ { 0, 0, 0, 0, 0 },
/* U+6bed */ { 0, 0, 0, 0, 0 },
/* U+6bee */ { 0, 0, 0, 0, 0 },
/* U+6bef */ { 0, 0, 0, 0, 0 },
/* U+6bf0 */ { 0, 0, 0, 0, 0 },
/* U+6bf1 */ { 0, 0, 0, 0, 0 },
/* U+6bf2 */ { 0, 0, 0, 0, 0 },
/* U+6bf3 */ { 0, 0, 0, 0, 0 },
/* U+6bf4 */ { 0, 0, 0, 0, 0 },
/* U+6bf5 */ { 0, 0, 0, 0, 0 },
/* U+6bf6 */ { 0, 0, 0, 0, 0 },
/* U+6bf7 */ { 0, 0, 0, 0, 0 },
/* U+6bf8 */ { 0, 0, 0, 0, 0 },
/* U+6bf9 */ { 0, 0, 0, 0, 0 },
/* U+6bfa */ { 0, 0, 0, 0, 0 },
/* U+6bfb */ { 0, 0, 0, 0, 0 },
/* U+6bfc */ { 0, 0, 0, 0, 0 },
/* U+6bfd */ { 0, 0, 0, 0, 0 },
/* U+6bfe */ { 0, 0, 0, 0, 0 },
/* U+6bff */ { 0, 0, 0, 0, 0 },
/* U+6c00 */ { 0, 0, 0, 0, 0 },
/* U+6c01 */ { 0, 0, 0, 0, 0 },
/* U+6c02 */ { 0, 0, 0, 0, 0 },
/* U+6c03 */ { 0, 0, 0, 0, 0 },
/* U+6c04 */ { 0, 0, 0, 0, 0 },
/* U+6c05 */ { 0, 0, 0, 0, 0 },
/* U+6c06 */ { 0, 0, 0, 0, 0 },
/* U+6c07 */ { 0, 0, 0, 0, 0 },
/* U+6c08 */ { 0, 0, 0, 0, 0 },
/* U+6c09 */ { 0, 0, 0, 0, 0 },
/* U+6c0a */ { 0, 0, 0, 0, 0 },
/* U+6c0b */ { 0, 0, 0, 0, 0 },
/* U+6c0c */ { 0, 0, 0, 0, 0 },
/* U+6c0d */ { 0, 0, 0, 0, 0 },
/* U+6c0e */ { 0, 0, 0, 0, 0 },
/* U+6c0f */ { 0, 0, 0, 0, 0 },
/* U+6c10 */ { 0, 0, 0, 0, 0 },
/* U+6c11 */ { 0, 0, 0, 0, 0 },
/* U+6c12 */ { 0, 0, 0, 0, 0 },
/* U+6c13 */ { 0, 0, 0, 0, 0 },
/* U+6c14 */ { 0, 0, 0, 0, 0 },
/* U+6c15 */ { 0, 0, 0, 0, 0 },
/* U+6c16 */ { 0, 0, 0, 0, 0 },
/* U+6c17 */ { 0, 0, 0, 0, 0 },
/* U+6c18 */ { 0, 0, 0, 0, 0 },
/* U+6c19 */ { 0, 0, 0, 0, 0 },
/* U+6c1a */ { 0, 0, 0, 0, 0 },
/* U+6c1b */ { 0, 0, 0, 0, 0 },
/* U+6c1c */ { 0, 0, 0, 0, 0 },
/* U+6c1d */ { 0, 0, 0, 0, 0 },
/* U+6c1e */ { 0, 0, 0, 0, 0 },
/* U+6c1f */ { 0, 0, 0, 0, 0 },
/* U+6c20 */ { 0, 0, 0, 0, 0 },
/* U+6c21 */ { 0, 0, 0, 0, 0 },
/* U+6c22 */ { 0, 0, 0, 0, 0 },
/* U+6c23 */ { 0, 0, 0, 0, 0 },
/* U+6c24 */ { 0, 0, 0, 0, 0 },
/* U+6c25 */ { 0, 0, 0, 0, 0 },
/* U+6c26 */ { 0, 0, 0, 0, 0 },
/* U+6c27 */ { 0, 0, 0, 0, 0 },
/* U+6c28 */ { 0, 0, 0, 0, 0 },
/* U+6c29 */ { 0, 0, 0, 0, 0 },
/* U+6c2a */ { 0, 0, 0, 0, 0 },
/* U+6c2b */ { 0, 0, 0, 0, 0 },
/* U+6c2c */ { 0, 0, 0, 0, 0 },
/* U+6c2d */ { 0, 0, 0, 0, 0 },
/* U+6c2e */ { 0, 0, 0, 0, 0 },
/* U+6c2f */ { 0, 0, 0, 0, 0 },
/* U+6c30 */ { 0, 0, 0, 0, 0 },
/* U+6c31 */ { 0, 0, 0, 0, 0 },
/* U+6c32 */ { 0, 0, 0, 0, 0 },
/* U+6c33 */ { 0, 0, 0, 0, 0 },
/* U+6c34 */ { 0, 0, 0, 0, 0 },
/* U+6c35 */ { 0, 0, 0, 0, 0 },
/* U+6c36 */ { 0, 0, 0, 0, 0 },
/* U+6c37 */ { 0, 0, 0, 0, 0 },
/* U+6c38 */ { 0, 0, 0, 0, 0 },
/* U+6c39 */ { 0, 0, 0, 0, 0 },
/* U+6c3a */ { 0, 0, 0, 0, 0 },
/* U+6c3b */ { 0, 0, 0, 0, 0 },
/* U+6c3c */ { 0, 0, 0, 0, 0 },
/* U+6c3d */ { 0, 0, 0, 0, 0 },
/* U+6c3e */ { 0, 0, 0, 0, 0 },
/* U+6c3f */ { 0, 0, 0, 0, 0 },
/* U+6c40 */ { 0, 0, 0, 0, 0 },
/* U+6c41 */ { 0, 0, 0, 0, 0 },
/* U+6c42 */ { 0, 0, 0, 0, 0 },
/* U+6c43 */ { 0, 0, 0, 0, 0 },
/* U+6c44 */ { 0, 0, 0, 0, 0 },
/* U+6c45 */ { 0, 0, 0, 0, 0 },
/* U+6c46 */ { 0, 0, 0, 0, 0 },
/* U+6c47 */ { 0, 0, 0, 0, 0 },
/* U+6c48 */ { 0, 0, 0, 0, 0 },
/* U+6c49 */ { 0, 0, 0, 0, 0 },
/* U+6c4a */ { 0, 0, 0, 0, 0 },
/* U+6c4b */ { 0, 0, 0, 0, 0 },
/* U+6c4c */ { 0, 0, 0, 0, 0 },
/* U+6c4d */ { 0, 0, 0, 0, 0 },
/* U+6c4e */ { 0, 0, 0, 0, 0 },
/* U+6c4f */ { 0, 0, 0, 0, 0 },
/* U+6c50 */ { 0, 0, 0, 0, 0 },
/* U+6c51 */ { 0, 0, 0, 0, 0 },
/* U+6c52 */ { 0, 0, 0, 0, 0 },
/* U+6c53 */ { 0, 0, 0, 0, 0 },
/* U+6c54 */ { 0, 0, 0, 0, 0 },
/* U+6c55 */ { 0, 0, 0, 0, 0 },
/* U+6c56 */ { 0, 0, 0, 0, 0 },
/* U+6c57 */ { 0, 0, 0, 0, 0 },
/* U+6c58 */ { 0, 0, 0, 0, 0 },
/* U+6c59 */ { 0, 0, 0, 0, 0 },
/* U+6c5a */ { 0, 0, 0, 0, 0 },
/* U+6c5b */ { 0, 0, 0, 0, 0 },
/* U+6c5c */ { 0, 0, 0, 0, 0 },
/* U+6c5d */ { 0, 0, 0, 0, 0 },
/* U+6c5e */ { 0, 0, 0, 0, 0 },
/* U+6c5f */ { 0, 0, 0, 0, 0 },
/* U+6c60 */ { 0, 0, 0, 0, 0 },
/* U+6c61 */ { 0, 0, 0, 0, 0 },
/* U+6c62 */ { 0, 0, 0, 0, 0 },
/* U+6c63 */ { 0, 0, 0, 0, 0 },
/* U+6c64 */ { 0, 0, 0, 0, 0 },
/* U+6c65 */ { 0, 0, 0, 0, 0 },
/* U+6c66 */ { 0, 0, 0, 0, 0 },
/* U+6c67 */ { 0, 0, 0, 0, 0 },
/* U+6c68 */ { 0, 0, 0, 0, 0 },
/* U+6c69 */ { 0, 0, 0, 0, 0 },
/* U+6c6a */ { 0, 0, 0, 0, 0 },
/* U+6c6b */ { 0, 0, 0, 0, 0 },
/* U+6c6c */ { 0, 0, 0, 0, 0 },
/* U+6c6d */ { 0, 0, 0, 0, 0 },
/* U+6c6e */ { 0, 0, 0, 0, 0 },
/* U+6c6f */ { 0, 0, 0, 0, 0 },
/* U+6c70 */ { 0, 0, 0, 0, 0 },
/* U+6c71 */ { 0, 0, 0, 0, 0 },
/* U+6c72 */ { 0, 0, 0, 0, 0 },
/* U+6c73 */ { 0, 0, 0, 0, 0 },
/* U+6c74 */ { 0, 0, 0, 0, 0 },
/* U+6c75 */ { 0, 0, 0, 0, 0 },
/* U+6c76 */ { 0, 0, 0, 0, 0 },
/* U+6c77 */ { 0, 0, 0, 0, 0 },
/* U+6c78 */ { 0, 0, 0, 0, 0 },
/* U+6c79 */ { 0, 0, 0, 0, 0 },
/* U+6c7a */ { 0, 0, 0, 0, 0 },
/* U+6c7b */ { 0, 0, 0, 0, 0 },
/* U+6c7c */ { 0, 0, 0, 0, 0 },
/* U+6c7d */ { 0, 0, 0, 0, 0 },
/* U+6c7e */ { 0, 0, 0, 0, 0 },
/* U+6c7f */ { 0, 0, 0, 0, 0 },
/* U+6c80 */ { 0, 0, 0, 0, 0 },
/* U+6c81 */ { 0, 0, 0, 0, 0 },
/* U+6c82 */ { 0, 0, 0, 0, 0 },
/* U+6c83 */ { 0, 0, 0, 0, 0 },
/* U+6c84 */ { 0, 0, 0, 0, 0 },
/* U+6c85 */ { 0, 0, 0, 0, 0 },
/* U+6c86 */ { 0, 0, 0, 0, 0 },
/* U+6c87 */ { 0, 0, 0, 0, 0 },
/* U+6c88 */ { 0, 0, 0, 0, 0 },
/* U+6c89 */ { 0, 0, 0, 0, 0 },
/* U+6c8a */ { 0, 0, 0, 0, 0 },
/* U+6c8b */ { 0, 0, 0, 0, 0 },
/* U+6c8c */ { 0, 0, 0, 0, 0 },
/* U+6c8d */ { 0, 0, 0, 0, 0 },
/* U+6c8e */ { 0, 0, 0, 0, 0 },
/* U+6c8f */ { 0, 0, 0, 0, 0 },
/* U+6c90 */ { 0, 0, 0, 0, 0 },
/* U+6c91 */ { 0, 0, 0, 0, 0 },
/* U+6c92 */ { 0, 0, 0, 0, 0 },
/* U+6c93 */ { 0, 0, 0, 0, 0 },
/* U+6c94 */ { 0, 0, 0, 0, 0 },
/* U+6c95 */ { 0, 0, 0, 0, 0 },
/* U+6c96 */ { 0, 0, 0, 0, 0 },
/* U+6c97 */ { 0, 0, 0, 0, 0 },
/* U+6c98 */ { 0, 0, 0, 0, 0 },
/* U+6c99 */ { 0, 0, 0, 0, 0 },
/* U+6c9a */ { 0, 0, 0, 0, 0 },
/* U+6c9b */ { 0, 0, 0, 0, 0 },
/* U+6c9c */ { 0, 0, 0, 0, 0 },
/* U+6c9d */ { 0, 0, 0, 0, 0 },
/* U+6c9e */ { 0, 0, 0, 0, 0 },
/* U+6c9f */ { 0, 0, 0, 0, 0 },
/* U+6ca0 */ { 0, 0, 0, 0, 0 },
/* U+6ca1 */ { 0, 0, 0, 0, 0 },
/* U+6ca2 */ { 0, 0, 0, 0, 0 },
/* U+6ca3 */ { 0, 0, 0, 0, 0 },
/* U+6ca4 */ { 0, 0, 0, 0, 0 },
/* U+6ca5 */ { 0, 0, 0, 0, 0 },
/* U+6ca6 */ { 0, 0, 0, 0, 0 },
/* U+6ca7 */ { 0, 0, 0, 0, 0 },
/* U+6ca8 */ { 0, 0, 0, 0, 0 },
/* U+6ca9 */ { 0, 0, 0, 0, 0 },
/* U+6caa */ { 0, 0, 0, 0, 0 },
/* U+6cab */ { 0, 0, 0, 0, 0 },
/* U+6cac */ { 0, 0, 0, 0, 0 },
/* U+6cad */ { 0, 0, 0, 0, 0 },
/* U+6cae */ { 0, 0, 0, 0, 0 },
/* U+6caf */ { 0, 0, 0, 0, 0 },
/* U+6cb0 */ { 0, 0, 0, 0, 0 },
/* U+6cb1 */ { 0, 0, 0, 0, 0 },
/* U+6cb2 */ { 0, 0, 0, 0, 0 },
/* U+6cb3 */ { 0, 0, 0, 0, 0 },
/* U+6cb4 */ { 0, 0, 0, 0, 0 },
/* U+6cb5 */ { 0, 0, 0, 0, 0 },
/* U+6cb6 */ { 0, 0, 0, 0, 0 },
/* U+6cb7 */ { 0, 0, 0, 0, 0 },
/* U+6cb8 */ { 0, 0, 0, 0, 0 },
/* U+6cb9 */ { 0, 0, 0, 0, 0 },
/* U+6cba */ { 0, 0, 0, 0, 0 },
/* U+6cbb */ { 0, 0, 0, 0, 0 },
/* U+6cbc */ { 0, 0, 0, 0, 0 },
/* U+6cbd */ { 0, 0, 0, 0, 0 },
/* U+6cbe */ { 0, 0, 0, 0, 0 },
/* U+6cbf */ { 0, 0, 0, 0, 0 },
/* U+6cc0 */ { 0, 0, 0, 0, 0 },
/* U+6cc1 */ { 0, 0, 0, 0, 0 },
/* U+6cc2 */ { 0, 0, 0, 0, 0 },
/* U+6cc3 */ { 0, 0, 0, 0, 0 },
/* U+6cc4 */ { 0, 0, 0, 0, 0 },
/* U+6cc5 */ { 0, 0, 0, 0, 0 },
/* U+6cc6 */ { 0, 0, 0, 0, 0 },
/* U+6cc7 */ { 0, 0, 0, 0, 0 },
/* U+6cc8 */ { 0, 0, 0, 0, 0 },
/* U+6cc9 */ { 0, 0, 0, 0, 0 },
/* U+6cca */ { 0, 0, 0, 0, 0 },
/* U+6ccb */ { 0, 0, 0, 0, 0 },
/* U+6ccc */ { 0, 0, 0, 0, 0 },
/* U+6ccd */ { 0, 0, 0, 0, 0 },
/* U+6cce */ { 0, 0, 0, 0, 0 },
/* U+6ccf */ { 0, 0, 0, 0, 0 },
/* U+6cd0 */ { 0, 0, 0, 0, 0 },
/* U+6cd1 */ { 0, 0, 0, 0, 0 },
/* U+6cd2 */ { 0, 0, 0, 0, 0 },
/* U+6cd3 */ { 0, 0, 0, 0, 0 },
/* U+6cd4 */ { 0, 0, 0, 0, 0 },
/* U+6cd5 */ { 0, 0, 0, 0, 0 },
/* U+6cd6 */ { 0, 0, 0, 0, 0 },
/* U+6cd7 */ { 0, 0, 0, 0, 0 },
/* U+6cd8 */ { 0, 0, 0, 0, 0 },
/* U+6cd9 */ { 0, 0, 0, 0, 0 },
/* U+6cda */ { 0, 0, 0, 0, 0 },
/* U+6cdb */ { 0, 0, 0, 0, 0 },
/* U+6cdc */ { 0, 0, 0, 0, 0 },
/* U+6cdd */ { 0, 0, 0, 0, 0 },
/* U+6cde */ { 0, 0, 0, 0, 0 },
/* U+6cdf */ { 0, 0, 0, 0, 0 },
/* U+6ce0 */ { 0, 0, 0, 0, 0 },
/* U+6ce1 */ { 0, 0, 0, 0, 0 },
/* U+6ce2 */ { 0, 0, 0, 0, 0 },
/* U+6ce3 */ { 0, 0, 0, 0, 0 },
/* U+6ce4 */ { 0, 0, 0, 0, 0 },
/* U+6ce5 */ { 0, 0, 0, 0, 0 },
/* U+6ce6 */ { 0, 0, 0, 0, 0 },
/* U+6ce7 */ { 0, 0, 0, 0, 0 },
/* U+6ce8 */ { 0, 0, 0, 0, 0 },
/* U+6ce9 */ { 0, 0, 0, 0, 0 },
/* U+6cea */ { 0, 0, 0, 0, 0 },
/* U+6ceb */ { 0, 0, 0, 0, 0 },
/* U+6cec */ { 0, 0, 0, 0, 0 },
/* U+6ced */ { 0, 0, 0, 0, 0 },
/* U+6cee */ { 0, 0, 0, 0, 0 },
/* U+6cef */ { 0, 0, 0, 0, 0 },
/* U+6cf0 */ { 0, 0, 0, 0, 0 },
/* U+6cf1 */ { 0, 0, 0, 0, 0 },
/* U+6cf2 */ { 0, 0, 0, 0, 0 },
/* U+6cf3 */ { 0, 0, 0, 0, 0 },
/* U+6cf4 */ { 0, 0, 0, 0, 0 },
/* U+6cf5 */ { 0, 0, 0, 0, 0 },
/* U+6cf6 */ { 0, 0, 0, 0, 0 },
/* U+6cf7 */ { 0, 0, 0, 0, 0 },
/* U+6cf8 */ { 0, 0, 0, 0, 0 },
/* U+6cf9 */ { 0, 0, 0, 0, 0 },
/* U+6cfa */ { 0, 0, 0, 0, 0 },
/* U+6cfb */ { 0, 0, 0, 0, 0 },
/* U+6cfc */ { 0, 0, 0, 0, 0 },
/* U+6cfd */ { 0, 0, 0, 0, 0 },
/* U+6cfe */ { 0, 0, 0, 0, 0 },
/* U+6cff */ { 0, 0, 0, 0, 0 },
/* U+6d00 */ { 0, 0, 0, 0, 0 },
/* U+6d01 */ { 0, 0, 0, 0, 0 },
/* U+6d02 */ { 0, 0, 0, 0, 0 },
/* U+6d03 */ { 0, 0, 0, 0, 0 },
/* U+6d04 */ { 0, 0, 0, 0, 0 },
/* U+6d05 */ { 0, 0, 0, 0, 0 },
/* U+6d06 */ { 0, 0, 0, 0, 0 },
/* U+6d07 */ { 0, 0, 0, 0, 0 },
/* U+6d08 */ { 0, 0, 0, 0, 0 },
/* U+6d09 */ { 0, 0, 0, 0, 0 },
/* U+6d0a */ { 0, 0, 0, 0, 0 },
/* U+6d0b */ { 0, 0, 0, 0, 0 },
/* U+6d0c */ { 0, 0, 0, 0, 0 },
/* U+6d0d */ { 0, 0, 0, 0, 0 },
/* U+6d0e */ { 0, 0, 0, 0, 0 },
/* U+6d0f */ { 0, 0, 0, 0, 0 },
/* U+6d10 */ { 0, 0, 0, 0, 0 },
/* U+6d11 */ { 0, 0, 0, 0, 0 },
/* U+6d12 */ { 0, 0, 0, 0, 0 },
/* U+6d13 */ { 0, 0, 0, 0, 0 },
/* U+6d14 */ { 0, 0, 0, 0, 0 },
/* U+6d15 */ { 0, 0, 0, 0, 0 },
/* U+6d16 */ { 0, 0, 0, 0, 0 },
/* U+6d17 */ { 0, 0, 0, 0, 0 },
/* U+6d18 */ { 0, 0, 0, 0, 0 },
/* U+6d19 */ { 0, 0, 0, 0, 0 },
/* U+6d1a */ { 0, 0, 0, 0, 0 },
/* U+6d1b */ { 0, 0, 0, 0, 0 },
/* U+6d1c */ { 0, 0, 0, 0, 0 },
/* U+6d1d */ { 0, 0, 0, 0, 0 },
/* U+6d1e */ { 0, 0, 0, 0, 0 },
/* U+6d1f */ { 0, 0, 0, 0, 0 },
/* U+6d20 */ { 0, 0, 0, 0, 0 },
/* U+6d21 */ { 0, 0, 0, 0, 0 },
/* U+6d22 */ { 0, 0, 0, 0, 0 },
/* U+6d23 */ { 0, 0, 0, 0, 0 },
/* U+6d24 */ { 0, 0, 0, 0, 0 },
/* U+6d25 */ { 0, 0, 0, 0, 0 },
/* U+6d26 */ { 0, 0, 0, 0, 0 },
/* U+6d27 */ { 0, 0, 0, 0, 0 },
/* U+6d28 */ { 0, 0, 0, 0, 0 },
/* U+6d29 */ { 0, 0, 0, 0, 0 },
/* U+6d2a */ { 0, 0, 0, 0, 0 },
/* U+6d2b */ { 0, 0, 0, 0, 0 },
/* U+6d2c */ { 0, 0, 0, 0, 0 },
/* U+6d2d */ { 0, 0, 0, 0, 0 },
/* U+6d2e */ { 0, 0, 0, 0, 0 },
/* U+6d2f */ { 0, 0, 0, 0, 0 },
/* U+6d30 */ { 0, 0, 0, 0, 0 },
/* U+6d31 */ { 0, 0, 0, 0, 0 },
/* U+6d32 */ { 0, 0, 0, 0, 0 },
/* U+6d33 */ { 0, 0, 0, 0, 0 },
/* U+6d34 */ { 0, 0, 0, 0, 0 },
/* U+6d35 */ { 0, 0, 0, 0, 0 },
/* U+6d36 */ { 0, 0, 0, 0, 0 },
/* U+6d37 */ { 0, 0, 0, 0, 0 },
/* U+6d38 */ { 0, 0, 0, 0, 0 },
/* U+6d39 */ { 0, 0, 0, 0, 0 },
/* U+6d3a */ { 0, 0, 0, 0, 0 },
/* U+6d3b */ { 0, 0, 0, 0, 0 },
/* U+6d3c */ { 0, 0, 0, 0, 0 },
/* U+6d3d */ { 0, 0, 0, 0, 0 },
/* U+6d3e */ { 0, 0, 0, 0, 0 },
/* U+6d3f */ { 0, 0, 0, 0, 0 },
/* U+6d40 */ { 0, 0, 0, 0, 0 },
/* U+6d41 */ { 0, 0, 0, 0, 0 },
/* U+6d42 */ { 0, 0, 0, 0, 0 },
/* U+6d43 */ { 0, 0, 0, 0, 0 },
/* U+6d44 */ { 0, 0, 0, 0, 0 },
/* U+6d45 */ { 0, 0, 0, 0, 0 },
/* U+6d46 */ { 0, 0, 0, 0, 0 },
/* U+6d47 */ { 0, 0, 0, 0, 0 },
/* U+6d48 */ { 0, 0, 0, 0, 0 },
/* U+6d49 */ { 0, 0, 0, 0, 0 },
/* U+6d4a */ { 0, 0, 0, 0, 0 },
/* U+6d4b */ { 0, 0, 0, 0, 0 },
/* U+6d4c */ { 0, 0, 0, 0, 0 },
/* U+6d4d */ { 0, 0, 0, 0, 0 },
/* U+6d4e */ { 0, 0, 0, 0, 0 },
/* U+6d4f */ { 0, 0, 0, 0, 0 },
/* U+6d50 */ { 0, 0, 0, 0, 0 },
/* U+6d51 */ { 0, 0, 0, 0, 0 },
/* U+6d52 */ { 0, 0, 0, 0, 0 },
/* U+6d53 */ { 0, 0, 0, 0, 0 },
/* U+6d54 */ { 0, 0, 0, 0, 0 },
/* U+6d55 */ { 0, 0, 0, 0, 0 },
/* U+6d56 */ { 0, 0, 0, 0, 0 },
/* U+6d57 */ { 0, 0, 0, 0, 0 },
/* U+6d58 */ { 0, 0, 0, 0, 0 },
/* U+6d59 */ { 0, 0, 0, 0, 0 },
/* U+6d5a */ { 0, 0, 0, 0, 0 },
/* U+6d5b */ { 0, 0, 0, 0, 0 },
/* U+6d5c */ { 0, 0, 0, 0, 0 },
/* U+6d5d */ { 0, 0, 0, 0, 0 },
/* U+6d5e */ { 0, 0, 0, 0, 0 },
/* U+6d5f */ { 0, 0, 0, 0, 0 },
/* U+6d60 */ { 0, 0, 0, 0, 0 },
/* U+6d61 */ { 0, 0, 0, 0, 0 },
/* U+6d62 */ { 0, 0, 0, 0, 0 },
/* U+6d63 */ { 0, 0, 0, 0, 0 },
/* U+6d64 */ { 0, 0, 0, 0, 0 },
/* U+6d65 */ { 0, 0, 0, 0, 0 },
/* U+6d66 */ { 0, 0, 0, 0, 0 },
/* U+6d67 */ { 0, 0, 0, 0, 0 },
/* U+6d68 */ { 0, 0, 0, 0, 0 },
/* U+6d69 */ { 0, 0, 0, 0, 0 },
/* U+6d6a */ { 0, 0, 0, 0, 0 },
/* U+6d6b */ { 0, 0, 0, 0, 0 },
/* U+6d6c */ { 0, 0, 0, 0, 0 },
/* U+6d6d */ { 0, 0, 0, 0, 0 },
/* U+6d6e */ { 0, 0, 0, 0, 0 },
/* U+6d6f */ { 0, 0, 0, 0, 0 },
/* U+6d70 */ { 0, 0, 0, 0, 0 },
/* U+6d71 */ { 0, 0, 0, 0, 0 },
/* U+6d72 */ { 0, 0, 0, 0, 0 },
/* U+6d73 */ { 0, 0, 0, 0, 0 },
/* U+6d74 */ { 0, 0, 0, 0, 0 },
/* U+6d75 */ { 0, 0, 0, 0, 0 },
/* U+6d76 */ { 0, 0, 0, 0, 0 },
/* U+6d77 */ { 0, 0, 0, 0, 0 },
/* U+6d78 */ { 0, 0, 0, 0, 0 },
/* U+6d79 */ { 0, 0, 0, 0, 0 },
/* U+6d7a */ { 0, 0, 0, 0, 0 },
/* U+6d7b */ { 0, 0, 0, 0, 0 },
/* U+6d7c */ { 0, 0, 0, 0, 0 },
/* U+6d7d */ { 0, 0, 0, 0, 0 },
/* U+6d7e */ { 0, 0, 0, 0, 0 },
/* U+6d7f */ { 0, 0, 0, 0, 0 },
/* U+6d80 */ { 0, 0, 0, 0, 0 },
/* U+6d81 */ { 0, 0, 0, 0, 0 },
/* U+6d82 */ { 0, 0, 0, 0, 0 },
/* U+6d83 */ { 0, 0, 0, 0, 0 },
/* U+6d84 */ { 0, 0, 0, 0, 0 },
/* U+6d85 */ { 0, 0, 0, 0, 0 },
/* U+6d86 */ { 0, 0, 0, 0, 0 },
/* U+6d87 */ { 0, 0, 0, 0, 0 },
/* U+6d88 */ { 0, 0, 0, 0, 0 },
/* U+6d89 */ { 0, 0, 0, 0, 0 },
/* U+6d8a */ { 0, 0, 0, 0, 0 },
/* U+6d8b */ { 0, 0, 0, 0, 0 },
/* U+6d8c */ { 0, 0, 0, 0, 0 },
/* U+6d8d */ { 0, 0, 0, 0, 0 },
/* U+6d8e */ { 0, 0, 0, 0, 0 },
/* U+6d8f */ { 0, 0, 0, 0, 0 },
/* U+6d90 */ { 0, 0, 0, 0, 0 },
/* U+6d91 */ { 0, 0, 0, 0, 0 },
/* U+6d92 */ { 0, 0, 0, 0, 0 },
/* U+6d93 */ { 0, 0, 0, 0, 0 },
/* U+6d94 */ { 0, 0, 0, 0, 0 },
/* U+6d95 */ { 0, 0, 0, 0, 0 },
/* U+6d96 */ { 0, 0, 0, 0, 0 },
/* U+6d97 */ { 0, 0, 0, 0, 0 },
/* U+6d98 */ { 0, 0, 0, 0, 0 },
/* U+6d99 */ { 0, 0, 0, 0, 0 },
/* U+6d9a */ { 0, 0, 0, 0, 0 },
/* U+6d9b */ { 0, 0, 0, 0, 0 },
/* U+6d9c */ { 0, 0, 0, 0, 0 },
/* U+6d9d */ { 0, 0, 0, 0, 0 },
/* U+6d9e */ { 0, 0, 0, 0, 0 },
/* U+6d9f */ { 0, 0, 0, 0, 0 },
/* U+6da0 */ { 0, 0, 0, 0, 0 },
/* U+6da1 */ { 0, 0, 0, 0, 0 },
/* U+6da2 */ { 0, 0, 0, 0, 0 },
/* U+6da3 */ { 0, 0, 0, 0, 0 },
/* U+6da4 */ { 0, 0, 0, 0, 0 },
/* U+6da5 */ { 0, 0, 0, 0, 0 },
/* U+6da6 */ { 0, 0, 0, 0, 0 },
/* U+6da7 */ { 0, 0, 0, 0, 0 },
/* U+6da8 */ { 0, 0, 0, 0, 0 },
/* U+6da9 */ { 0, 0, 0, 0, 0 },
/* U+6daa */ { 0, 0, 0, 0, 0 },
/* U+6dab */ { 0, 0, 0, 0, 0 },
/* U+6dac */ { 0, 0, 0, 0, 0 },
/* U+6dad */ { 0, 0, 0, 0, 0 },
/* U+6dae */ { 0, 0, 0, 0, 0 },
/* U+6daf */ { 0, 0, 0, 0, 0 },
/* U+6db0 */ { 0, 0, 0, 0, 0 },
/* U+6db1 */ { 0, 0, 0, 0, 0 },
/* U+6db2 */ { 0, 0, 0, 0, 0 },
/* U+6db3 */ { 0, 0, 0, 0, 0 },
/* U+6db4 */ { 0, 0, 0, 0, 0 },
/* U+6db5 */ { 0, 0, 0, 0, 0 },
/* U+6db6 */ { 0, 0, 0, 0, 0 },
/* U+6db7 */ { 0, 0, 0, 0, 0 },
/* U+6db8 */ { 0, 0, 0, 0, 0 },
/* U+6db9 */ { 0, 0, 0, 0, 0 },
/* U+6dba */ { 0, 0, 0, 0, 0 },
/* U+6dbb */ { 0, 0, 0, 0, 0 },
/* U+6dbc */ { 0, 0, 0, 0, 0 },
/* U+6dbd */ { 0, 0, 0, 0, 0 },
/* U+6dbe */ { 0, 0, 0, 0, 0 },
/* U+6dbf */ { 0, 0, 0, 0, 0 },
/* U+6dc0 */ { 0, 0, 0, 0, 0 },
/* U+6dc1 */ { 0, 0, 0, 0, 0 },
/* U+6dc2 */ { 0, 0, 0, 0, 0 },
/* U+6dc3 */ { 0, 0, 0, 0, 0 },
/* U+6dc4 */ { 0, 0, 0, 0, 0 },
/* U+6dc5 */ { 0, 0, 0, 0, 0 },
/* U+6dc6 */ { 0, 0, 0, 0, 0 },
/* U+6dc7 */ { 0, 0, 0, 0, 0 },
/* U+6dc8 */ { 0, 0, 0, 0, 0 },
/* U+6dc9 */ { 0, 0, 0, 0, 0 },
/* U+6dca */ { 0, 0, 0, 0, 0 },
/* U+6dcb */ { 0, 0, 0, 0, 0 },
/* U+6dcc */ { 0, 0, 0, 0, 0 },
/* U+6dcd */ { 0, 0, 0, 0, 0 },
/* U+6dce */ { 0, 0, 0, 0, 0 },
/* U+6dcf */ { 0, 0, 0, 0, 0 },
/* U+6dd0 */ { 0, 0, 0, 0, 0 },
/* U+6dd1 */ { 0, 0, 0, 0, 0 },
/* U+6dd2 */ { 0, 0, 0, 0, 0 },
/* U+6dd3 */ { 0, 0, 0, 0, 0 },
/* U+6dd4 */ { 0, 0, 0, 0, 0 },
/* U+6dd5 */ { 0, 0, 0, 0, 0 },
/* U+6dd6 */ { 0, 0, 0, 0, 0 },
/* U+6dd7 */ { 0, 0, 0, 0, 0 },
/* U+6dd8 */ { 0, 0, 0, 0, 0 },
/* U+6dd9 */ { 0, 0, 0, 0, 0 },
/* U+6dda */ { 0, 0, 0, 0, 0 },
/* U+6ddb */ { 0, 0, 0, 0, 0 },
/* U+6ddc */ { 0, 0, 0, 0, 0 },
/* U+6ddd */ { 0, 0, 0, 0, 0 },
/* U+6dde */ { 0, 0, 0, 0, 0 },
/* U+6ddf */ { 0, 0, 0, 0, 0 },
/* U+6de0 */ { 0, 0, 0, 0, 0 },
/* U+6de1 */ { 0, 0, 0, 0, 0 },
/* U+6de2 */ { 0, 0, 0, 0, 0 },
/* U+6de3 */ { 0, 0, 0, 0, 0 },
/* U+6de4 */ { 0, 0, 0, 0, 0 },
/* U+6de5 */ { 0, 0, 0, 0, 0 },
/* U+6de6 */ { 0, 0, 0, 0, 0 },
/* U+6de7 */ { 0, 0, 0, 0, 0 },
/* U+6de8 */ { 0, 0, 0, 0, 0 },
/* U+6de9 */ { 0, 0, 0, 0, 0 },
/* U+6dea */ { 0, 0, 0, 0, 0 },
/* U+6deb */ { 0, 0, 0, 0, 0 },
/* U+6dec */ { 0, 0, 0, 0, 0 },
/* U+6ded */ { 0, 0, 0, 0, 0 },
/* U+6dee */ { 0, 0, 0, 0, 0 },
/* U+6def */ { 0, 0, 0, 0, 0 },
/* U+6df0 */ { 0, 0, 0, 0, 0 },
/* U+6df1 */ { 0, 0, 0, 0, 0 },
/* U+6df2 */ { 0, 0, 0, 0, 0 },
/* U+6df3 */ { 0, 0, 0, 0, 0 },
/* U+6df4 */ { 0, 0, 0, 0, 0 },
/* U+6df5 */ { 0, 0, 0, 0, 0 },
/* U+6df6 */ { 0, 0, 0, 0, 0 },
/* U+6df7 */ { 0, 0, 0, 0, 0 },
/* U+6df8 */ { 0, 0, 0, 0, 0 },
/* U+6df9 */ { 0, 0, 0, 0, 0 },
/* U+6dfa */ { 0, 0, 0, 0, 0 },
/* U+6dfb */ { 0, 0, 0, 0, 0 },
/* U+6dfc */ { 0, 0, 0, 0, 0 },
/* U+6dfd */ { 0, 0, 0, 0, 0 },
/* U+6dfe */ { 0, 0, 0, 0, 0 },
/* U+6dff */ { 0, 0, 0, 0, 0 },
/* U+6e00 */ { 0, 0, 0, 0, 0 },
/* U+6e01 */ { 0, 0, 0, 0, 0 },
/* U+6e02 */ { 0, 0, 0, 0, 0 },
/* U+6e03 */ { 0, 0, 0, 0, 0 },
/* U+6e04 */ { 0, 0, 0, 0, 0 },
/* U+6e05 */ { 0, 0, 0, 0, 0 },
/* U+6e06 */ { 0, 0, 0, 0, 0 },
/* U+6e07 */ { 0, 0, 0, 0, 0 },
/* U+6e08 */ { 0, 0, 0, 0, 0 },
/* U+6e09 */ { 0, 0, 0, 0, 0 },
/* U+6e0a */ { 0, 0, 0, 0, 0 },
/* U+6e0b */ { 0, 0, 0, 0, 0 },
/* U+6e0c */ { 0, 0, 0, 0, 0 },
/* U+6e0d */ { 0, 0, 0, 0, 0 },
/* U+6e0e */ { 0, 0, 0, 0, 0 },
/* U+6e0f */ { 0, 0, 0, 0, 0 },
/* U+6e10 */ { 0, 0, 0, 0, 0 },
/* U+6e11 */ { 0, 0, 0, 0, 0 },
/* U+6e12 */ { 0, 0, 0, 0, 0 },
/* U+6e13 */ { 0, 0, 0, 0, 0 },
/* U+6e14 */ { 0, 0, 0, 0, 0 },
/* U+6e15 */ { 0, 0, 0, 0, 0 },
/* U+6e16 */ { 0, 0, 0, 0, 0 },
/* U+6e17 */ { 0, 0, 0, 0, 0 },
/* U+6e18 */ { 0, 0, 0, 0, 0 },
/* U+6e19 */ { 0, 0, 0, 0, 0 },
/* U+6e1a */ { 0, 0, 0, 0, 0 },
/* U+6e1b */ { 0, 0, 0, 0, 0 },
/* U+6e1c */ { 0, 0, 0, 0, 0 },
/* U+6e1d */ { 0, 0, 0, 0, 0 },
/* U+6e1e */ { 0, 0, 0, 0, 0 },
/* U+6e1f */ { 0, 0, 0, 0, 0 },
/* U+6e20 */ { 0, 0, 0, 0, 0 },
/* U+6e21 */ { 0, 0, 0, 0, 0 },
/* U+6e22 */ { 0, 0, 0, 0, 0 },
/* U+6e23 */ { 0, 0, 0, 0, 0 },
/* U+6e24 */ { 0, 0, 0, 0, 0 },
/* U+6e25 */ { 0, 0, 0, 0, 0 },
/* U+6e26 */ { 0, 0, 0, 0, 0 },
/* U+6e27 */ { 0, 0, 0, 0, 0 },
/* U+6e28 */ { 0, 0, 0, 0, 0 },
/* U+6e29 */ { 0, 0, 0, 0, 0 },
/* U+6e2a */ { 0, 0, 0, 0, 0 },
/* U+6e2b */ { 0, 0, 0, 0, 0 },
/* U+6e2c */ { 0, 0, 0, 0, 0 },
/* U+6e2d */ { 0, 0, 0, 0, 0 },
/* U+6e2e */ { 0, 0, 0, 0, 0 },
/* U+6e2f */ { 0, 0, 0, 0, 0 },
/* U+6e30 */ { 0, 0, 0, 0, 0 },
/* U+6e31 */ { 0, 0, 0, 0, 0 },
/* U+6e32 */ { 0, 0, 0, 0, 0 },
/* U+6e33 */ { 0, 0, 0, 0, 0 },
/* U+6e34 */ { 0, 0, 0, 0, 0 },
/* U+6e35 */ { 0, 0, 0, 0, 0 },
/* U+6e36 */ { 0, 0, 0, 0, 0 },
/* U+6e37 */ { 0, 0, 0, 0, 0 },
/* U+6e38 */ { 0, 0, 0, 0, 0 },
/* U+6e39 */ { 0, 0, 0, 0, 0 },
/* U+6e3a */ { 0, 0, 0, 0, 0 },
/* U+6e3b */ { 0, 0, 0, 0, 0 },
/* U+6e3c */ { 0, 0, 0, 0, 0 },
/* U+6e3d */ { 0, 0, 0, 0, 0 },
/* U+6e3e */ { 0, 0, 0, 0, 0 },
/* U+6e3f */ { 0, 0, 0, 0, 0 },
/* U+6e40 */ { 0, 0, 0, 0, 0 },
/* U+6e41 */ { 0, 0, 0, 0, 0 },
/* U+6e42 */ { 0, 0, 0, 0, 0 },
/* U+6e43 */ { 0, 0, 0, 0, 0 },
/* U+6e44 */ { 0, 0, 0, 0, 0 },
/* U+6e45 */ { 0, 0, 0, 0, 0 },
/* U+6e46 */ { 0, 0, 0, 0, 0 },
/* U+6e47 */ { 0, 0, 0, 0, 0 },
/* U+6e48 */ { 0, 0, 0, 0, 0 },
/* U+6e49 */ { 0, 0, 0, 0, 0 },
/* U+6e4a */ { 0, 0, 0, 0, 0 },
/* U+6e4b */ { 0, 0, 0, 0, 0 },
/* U+6e4c */ { 0, 0, 0, 0, 0 },
/* U+6e4d */ { 0, 0, 0, 0, 0 },
/* U+6e4e */ { 0, 0, 0, 0, 0 },
/* U+6e4f */ { 0, 0, 0, 0, 0 },
/* U+6e50 */ { 0, 0, 0, 0, 0 },
/* U+6e51 */ { 0, 0, 0, 0, 0 },
/* U+6e52 */ { 0, 0, 0, 0, 0 },
/* U+6e53 */ { 0, 0, 0, 0, 0 },
/* U+6e54 */ { 0, 0, 0, 0, 0 },
/* U+6e55 */ { 0, 0, 0, 0, 0 },
/* U+6e56 */ { 0, 0, 0, 0, 0 },
/* U+6e57 */ { 0, 0, 0, 0, 0 },
/* U+6e58 */ { 0, 0, 0, 0, 0 },
/* U+6e59 */ { 0, 0, 0, 0, 0 },
/* U+6e5a */ { 0, 0, 0, 0, 0 },
/* U+6e5b */ { 0, 0, 0, 0, 0 },
/* U+6e5c */ { 0, 0, 0, 0, 0 },
/* U+6e5d */ { 0, 0, 0, 0, 0 },
/* U+6e5e */ { 0, 0, 0, 0, 0 },
/* U+6e5f */ { 0, 0, 0, 0, 0 },
/* U+6e60 */ { 0, 0, 0, 0, 0 },
/* U+6e61 */ { 0, 0, 0, 0, 0 },
/* U+6e62 */ { 0, 0, 0, 0, 0 },
/* U+6e63 */ { 0, 0, 0, 0, 0 },
/* U+6e64 */ { 0, 0, 0, 0, 0 },
/* U+6e65 */ { 0, 0, 0, 0, 0 },
/* U+6e66 */ { 0, 0, 0, 0, 0 },
/* U+6e67 */ { 0, 0, 0, 0, 0 },
/* U+6e68 */ { 0, 0, 0, 0, 0 },
/* U+6e69 */ { 0, 0, 0, 0, 0 },
/* U+6e6a */ { 0, 0, 0, 0, 0 },
/* U+6e6b */ { 0, 0, 0, 0, 0 },
/* U+6e6c */ { 0, 0, 0, 0, 0 },
/* U+6e6d */ { 0, 0, 0, 0, 0 },
/* U+6e6e */ { 0, 0, 0, 0, 0 },
/* U+6e6f */ { 0, 0, 0, 0, 0 },
/* U+6e70 */ { 0, 0, 0, 0, 0 },
/* U+6e71 */ { 0, 0, 0, 0, 0 },
/* U+6e72 */ { 0, 0, 0, 0, 0 },
/* U+6e73 */ { 0, 0, 0, 0, 0 },
/* U+6e74 */ { 0, 0, 0, 0, 0 },
/* U+6e75 */ { 0, 0, 0, 0, 0 },
/* U+6e76 */ { 0, 0, 0, 0, 0 },
/* U+6e77 */ { 0, 0, 0, 0, 0 },
/* U+6e78 */ { 0, 0, 0, 0, 0 },
/* U+6e79 */ { 0, 0, 0, 0, 0 },
/* U+6e7a */ { 0, 0, 0, 0, 0 },
/* U+6e7b */ { 0, 0, 0, 0, 0 },
/* U+6e7c */ { 0, 0, 0, 0, 0 },
/* U+6e7d */ { 0, 0, 0, 0, 0 },
/* U+6e7e */ { 0, 0, 0, 0, 0 },
/* U+6e7f */ { 0, 0, 0, 0, 0 },
/* U+6e80 */ { 0, 0, 0, 0, 0 },
/* U+6e81 */ { 0, 0, 0, 0, 0 },
/* U+6e82 */ { 0, 0, 0, 0, 0 },
/* U+6e83 */ { 0, 0, 0, 0, 0 },
/* U+6e84 */ { 0, 0, 0, 0, 0 },
/* U+6e85 */ { 0, 0, 0, 0, 0 },
/* U+6e86 */ { 0, 0, 0, 0, 0 },
/* U+6e87 */ { 0, 0, 0, 0, 0 },
/* U+6e88 */ { 0, 0, 0, 0, 0 },
/* U+6e89 */ { 0, 0, 0, 0, 0 },
/* U+6e8a */ { 0, 0, 0, 0, 0 },
/* U+6e8b */ { 0, 0, 0, 0, 0 },
/* U+6e8c */ { 0, 0, 0, 0, 0 },
/* U+6e8d */ { 0, 0, 0, 0, 0 },
/* U+6e8e */ { 0, 0, 0, 0, 0 },
/* U+6e8f */ { 0, 0, 0, 0, 0 },
/* U+6e90 */ { 0, 0, 0, 0, 0 },
/* U+6e91 */ { 0, 0, 0, 0, 0 },
/* U+6e92 */ { 0, 0, 0, 0, 0 },
/* U+6e93 */ { 0, 0, 0, 0, 0 },
/* U+6e94 */ { 0, 0, 0, 0, 0 },
/* U+6e95 */ { 0, 0, 0, 0, 0 },
/* U+6e96 */ { 0, 0, 0, 0, 0 },
/* U+6e97 */ { 0, 0, 0, 0, 0 },
/* U+6e98 */ { 0, 0, 0, 0, 0 },
/* U+6e99 */ { 0, 0, 0, 0, 0 },
/* U+6e9a */ { 0, 0, 0, 0, 0 },
/* U+6e9b */ { 0, 0, 0, 0, 0 },
/* U+6e9c */ { 0, 0, 0, 0, 0 },
/* U+6e9d */ { 0, 0, 0, 0, 0 },
/* U+6e9e */ { 0, 0, 0, 0, 0 },
/* U+6e9f */ { 0, 0, 0, 0, 0 },
/* U+6ea0 */ { 0, 0, 0, 0, 0 },
/* U+6ea1 */ { 0, 0, 0, 0, 0 },
/* U+6ea2 */ { 0, 0, 0, 0, 0 },
/* U+6ea3 */ { 0, 0, 0, 0, 0 },
/* U+6ea4 */ { 0, 0, 0, 0, 0 },
/* U+6ea5 */ { 0, 0, 0, 0, 0 },
/* U+6ea6 */ { 0, 0, 0, 0, 0 },
/* U+6ea7 */ { 0, 0, 0, 0, 0 },
/* U+6ea8 */ { 0, 0, 0, 0, 0 },
/* U+6ea9 */ { 0, 0, 0, 0, 0 },
/* U+6eaa */ { 0, 0, 0, 0, 0 },
/* U+6eab */ { 0, 0, 0, 0, 0 },
/* U+6eac */ { 0, 0, 0, 0, 0 },
/* U+6ead */ { 0, 0, 0, 0, 0 },
/* U+6eae */ { 0, 0, 0, 0, 0 },
/* U+6eaf */ { 0, 0, 0, 0, 0 },
/* U+6eb0 */ { 0, 0, 0, 0, 0 },
/* U+6eb1 */ { 0, 0, 0, 0, 0 },
/* U+6eb2 */ { 0, 0, 0, 0, 0 },
/* U+6eb3 */ { 0, 0, 0, 0, 0 },
/* U+6eb4 */ { 0, 0, 0, 0, 0 },
/* U+6eb5 */ { 0, 0, 0, 0, 0 },
/* U+6eb6 */ { 0, 0, 0, 0, 0 },
/* U+6eb7 */ { 0, 0, 0, 0, 0 },
/* U+6eb8 */ { 0, 0, 0, 0, 0 },
/* U+6eb9 */ { 0, 0, 0, 0, 0 },
/* U+6eba */ { 0, 0, 0, 0, 0 },
/* U+6ebb */ { 0, 0, 0, 0, 0 },
/* U+6ebc */ { 0, 0, 0, 0, 0 },
/* U+6ebd */ { 0, 0, 0, 0, 0 },
/* U+6ebe */ { 0, 0, 0, 0, 0 },
/* U+6ebf */ { 0, 0, 0, 0, 0 },
/* U+6ec0 */ { 0, 0, 0, 0, 0 },
/* U+6ec1 */ { 0, 0, 0, 0, 0 },
/* U+6ec2 */ { 0, 0, 0, 0, 0 },
/* U+6ec3 */ { 0, 0, 0, 0, 0 },
/* U+6ec4 */ { 0, 0, 0, 0, 0 },
/* U+6ec5 */ { 0, 0, 0, 0, 0 },
/* U+6ec6 */ { 0, 0, 0, 0, 0 },
/* U+6ec7 */ { 0, 0, 0, 0, 0 },
/* U+6ec8 */ { 0, 0, 0, 0, 0 },
/* U+6ec9 */ { 0, 0, 0, 0, 0 },
/* U+6eca */ { 0, 0, 0, 0, 0 },
/* U+6ecb */ { 0, 0, 0, 0, 0 },
/* U+6ecc */ { 0, 0, 0, 0, 0 },
/* U+6ecd */ { 0, 0, 0, 0, 0 },
/* U+6ece */ { 0, 0, 0, 0, 0 },
/* U+6ecf */ { 0, 0, 0, 0, 0 },
/* U+6ed0 */ { 0, 0, 0, 0, 0 },
/* U+6ed1 */ { 0, 0, 0, 0, 0 },
/* U+6ed2 */ { 0, 0, 0, 0, 0 },
/* U+6ed3 */ { 0, 0, 0, 0, 0 },
/* U+6ed4 */ { 0, 0, 0, 0, 0 },
/* U+6ed5 */ { 0, 0, 0, 0, 0 },
/* U+6ed6 */ { 0, 0, 0, 0, 0 },
/* U+6ed7 */ { 0, 0, 0, 0, 0 },
/* U+6ed8 */ { 0, 0, 0, 0, 0 },
/* U+6ed9 */ { 0, 0, 0, 0, 0 },
/* U+6eda */ { 0, 0, 0, 0, 0 },
/* U+6edb */ { 0, 0, 0, 0, 0 },
/* U+6edc */ { 0, 0, 0, 0, 0 },
/* U+6edd */ { 0, 0, 0, 0, 0 },
/* U+6ede */ { 0, 0, 0, 0, 0 },
/* U+6edf */ { 0, 0, 0, 0, 0 },
/* U+6ee0 */ { 0, 0, 0, 0, 0 },
/* U+6ee1 */ { 0, 0, 0, 0, 0 },
/* U+6ee2 */ { 0, 0, 0, 0, 0 },
/* U+6ee3 */ { 0, 0, 0, 0, 0 },
/* U+6ee4 */ { 0, 0, 0, 0, 0 },
/* U+6ee5 */ { 0, 0, 0, 0, 0 },
/* U+6ee6 */ { 0, 0, 0, 0, 0 },
/* U+6ee7 */ { 0, 0, 0, 0, 0 },
/* U+6ee8 */ { 0, 0, 0, 0, 0 },
/* U+6ee9 */ { 0, 0, 0, 0, 0 },
/* U+6eea */ { 0, 0, 0, 0, 0 },
/* U+6eeb */ { 0, 0, 0, 0, 0 },
/* U+6eec */ { 0, 0, 0, 0, 0 },
/* U+6eed */ { 0, 0, 0, 0, 0 },
/* U+6eee */ { 0, 0, 0, 0, 0 },
/* U+6eef */ { 0, 0, 0, 0, 0 },
/* U+6ef0 */ { 0, 0, 0, 0, 0 },
/* U+6ef1 */ { 0, 0, 0, 0, 0 },
/* U+6ef2 */ { 0, 0, 0, 0, 0 },
/* U+6ef3 */ { 0, 0, 0, 0, 0 },
/* U+6ef4 */ { 0, 0, 0, 0, 0 },
/* U+6ef5 */ { 0, 0, 0, 0, 0 },
/* U+6ef6 */ { 0, 0, 0, 0, 0 },
/* U+6ef7 */ { 0, 0, 0, 0, 0 },
/* U+6ef8 */ { 0, 0, 0, 0, 0 },
/* U+6ef9 */ { 0, 0, 0, 0, 0 },
/* U+6efa */ { 0, 0, 0, 0, 0 },
/* U+6efb */ { 0, 0, 0, 0, 0 },
/* U+6efc */ { 0, 0, 0, 0, 0 },
/* U+6efd */ { 0, 0, 0, 0, 0 },
/* U+6efe */ { 0, 0, 0, 0, 0 },
/* U+6eff */ { 0, 0, 0, 0, 0 },
/* U+6f00 */ { 0, 0, 0, 0, 0 },
/* U+6f01 */ { 0, 0, 0, 0, 0 },
/* U+6f02 */ { 0, 0, 0, 0, 0 },
/* U+6f03 */ { 0, 0, 0, 0, 0 },
/* U+6f04 */ { 0, 0, 0, 0, 0 },
/* U+6f05 */ { 0, 0, 0, 0, 0 },
/* U+6f06 */ { 0, 0, 0, 0, 0 },
/* U+6f07 */ { 0, 0, 0, 0, 0 },
/* U+6f08 */ { 0, 0, 0, 0, 0 },
/* U+6f09 */ { 0, 0, 0, 0, 0 },
/* U+6f0a */ { 0, 0, 0, 0, 0 },
/* U+6f0b */ { 0, 0, 0, 0, 0 },
/* U+6f0c */ { 0, 0, 0, 0, 0 },
/* U+6f0d */ { 0, 0, 0, 0, 0 },
/* U+6f0e */ { 0, 0, 0, 0, 0 },
/* U+6f0f */ { 0, 0, 0, 0, 0 },
/* U+6f10 */ { 0, 0, 0, 0, 0 },
/* U+6f11 */ { 0, 0, 0, 0, 0 },
/* U+6f12 */ { 0, 0, 0, 0, 0 },
/* U+6f13 */ { 0, 0, 0, 0, 0 },
/* U+6f14 */ { 0, 0, 0, 0, 0 },
/* U+6f15 */ { 0, 0, 0, 0, 0 },
/* U+6f16 */ { 0, 0, 0, 0, 0 },
/* U+6f17 */ { 0, 0, 0, 0, 0 },
/* U+6f18 */ { 0, 0, 0, 0, 0 },
/* U+6f19 */ { 0, 0, 0, 0, 0 },
/* U+6f1a */ { 0, 0, 0, 0, 0 },
/* U+6f1b */ { 0, 0, 0, 0, 0 },
/* U+6f1c */ { 0, 0, 0, 0, 0 },
/* U+6f1d */ { 0, 0, 0, 0, 0 },
/* U+6f1e */ { 0, 0, 0, 0, 0 },
/* U+6f1f */ { 0, 0, 0, 0, 0 },
/* U+6f20 */ { 0, 0, 0, 0, 0 },
/* U+6f21 */ { 0, 0, 0, 0, 0 },
/* U+6f22 */ { 0, 0, 0, 0, 0 },
/* U+6f23 */ { 0, 0, 0, 0, 0 },
/* U+6f24 */ { 0, 0, 0, 0, 0 },
/* U+6f25 */ { 0, 0, 0, 0, 0 },
/* U+6f26 */ { 0, 0, 0, 0, 0 },
/* U+6f27 */ { 0, 0, 0, 0, 0 },
/* U+6f28 */ { 0, 0, 0, 0, 0 },
/* U+6f29 */ { 0, 0, 0, 0, 0 },
/* U+6f2a */ { 0, 0, 0, 0, 0 },
/* U+6f2b */ { 0, 0, 0, 0, 0 },
/* U+6f2c */ { 0, 0, 0, 0, 0 },
/* U+6f2d */ { 0, 0, 0, 0, 0 },
/* U+6f2e */ { 0, 0, 0, 0, 0 },
/* U+6f2f */ { 0, 0, 0, 0, 0 },
/* U+6f30 */ { 0, 0, 0, 0, 0 },
/* U+6f31 */ { 0, 0, 0, 0, 0 },
/* U+6f32 */ { 0, 0, 0, 0, 0 },
/* U+6f33 */ { 0, 0, 0, 0, 0 },
/* U+6f34 */ { 0, 0, 0, 0, 0 },
/* U+6f35 */ { 0, 0, 0, 0, 0 },
/* U+6f36 */ { 0, 0, 0, 0, 0 },
/* U+6f37 */ { 0, 0, 0, 0, 0 },
/* U+6f38 */ { 0, 0, 0, 0, 0 },
/* U+6f39 */ { 0, 0, 0, 0, 0 },
/* U+6f3a */ { 0, 0, 0, 0, 0 },
/* U+6f3b */ { 0, 0, 0, 0, 0 },
/* U+6f3c */ { 0, 0, 0, 0, 0 },
/* U+6f3d */ { 0, 0, 0, 0, 0 },
/* U+6f3e */ { 0, 0, 0, 0, 0 },
/* U+6f3f */ { 0, 0, 0, 0, 0 },
/* U+6f40 */ { 0, 0, 0, 0, 0 },
/* U+6f41 */ { 0, 0, 0, 0, 0 },
/* U+6f42 */ { 0, 0, 0, 0, 0 },
/* U+6f43 */ { 0, 0, 0, 0, 0 },
/* U+6f44 */ { 0, 0, 0, 0, 0 },
/* U+6f45 */ { 0, 0, 0, 0, 0 },
/* U+6f46 */ { 0, 0, 0, 0, 0 },
/* U+6f47 */ { 0, 0, 0, 0, 0 },
/* U+6f48 */ { 0, 0, 0, 0, 0 },
/* U+6f49 */ { 0, 0, 0, 0, 0 },
/* U+6f4a */ { 0, 0, 0, 0, 0 },
/* U+6f4b */ { 0, 0, 0, 0, 0 },
/* U+6f4c */ { 0, 0, 0, 0, 0 },
/* U+6f4d */ { 0, 0, 0, 0, 0 },
/* U+6f4e */ { 0, 0, 0, 0, 0 },
/* U+6f4f */ { 0, 0, 0, 0, 0 },
/* U+6f50 */ { 0, 0, 0, 0, 0 },
/* U+6f51 */ { 0, 0, 0, 0, 0 },
/* U+6f52 */ { 0, 0, 0, 0, 0 },
/* U+6f53 */ { 0, 0, 0, 0, 0 },
/* U+6f54 */ { 0, 0, 0, 0, 0 },
/* U+6f55 */ { 0, 0, 0, 0, 0 },
/* U+6f56 */ { 0, 0, 0, 0, 0 },
/* U+6f57 */ { 0, 0, 0, 0, 0 },
/* U+6f58 */ { 0, 0, 0, 0, 0 },
/* U+6f59 */ { 0, 0, 0, 0, 0 },
/* U+6f5a */ { 0, 0, 0, 0, 0 },
/* U+6f5b */ { 0, 0, 0, 0, 0 },
/* U+6f5c */ { 0, 0, 0, 0, 0 },
/* U+6f5d */ { 0, 0, 0, 0, 0 },
/* U+6f5e */ { 0, 0, 0, 0, 0 },
/* U+6f5f */ { 0, 0, 0, 0, 0 },
/* U+6f60 */ { 0, 0, 0, 0, 0 },
/* U+6f61 */ { 0, 0, 0, 0, 0 },
/* U+6f62 */ { 0, 0, 0, 0, 0 },
/* U+6f63 */ { 0, 0, 0, 0, 0 },
/* U+6f64 */ { 0, 0, 0, 0, 0 },
/* U+6f65 */ { 0, 0, 0, 0, 0 },
/* U+6f66 */ { 0, 0, 0, 0, 0 },
/* U+6f67 */ { 0, 0, 0, 0, 0 },
/* U+6f68 */ { 0, 0, 0, 0, 0 },
/* U+6f69 */ { 0, 0, 0, 0, 0 },
/* U+6f6a */ { 0, 0, 0, 0, 0 },
/* U+6f6b */ { 0, 0, 0, 0, 0 },
/* U+6f6c */ { 0, 0, 0, 0, 0 },
/* U+6f6d */ { 0, 0, 0, 0, 0 },
/* U+6f6e */ { 0, 0, 0, 0, 0 },
/* U+6f6f */ { 0, 0, 0, 0, 0 },
/* U+6f70 */ { 0, 0, 0, 0, 0 },
/* U+6f71 */ { 0, 0, 0, 0, 0 },
/* U+6f72 */ { 0, 0, 0, 0, 0 },
/* U+6f73 */ { 0, 0, 0, 0, 0 },
/* U+6f74 */ { 0, 0, 0, 0, 0 },
/* U+6f75 */ { 0, 0, 0, 0, 0 },
/* U+6f76 */ { 0, 0, 0, 0, 0 },
/* U+6f77 */ { 0, 0, 0, 0, 0 },
/* U+6f78 */ { 0, 0, 0, 0, 0 },
/* U+6f79 */ { 0, 0, 0, 0, 0 },
/* U+6f7a */ { 0, 0, 0, 0, 0 },
/* U+6f7b */ { 0, 0, 0, 0, 0 },
/* U+6f7c */ { 0, 0, 0, 0, 0 },
/* U+6f7d */ { 0, 0, 0, 0, 0 },
/* U+6f7e */ { 0, 0, 0, 0, 0 },
/* U+6f7f */ { 0, 0, 0, 0, 0 },
/* U+6f80 */ { 0, 0, 0, 0, 0 },
/* U+6f81 */ { 0, 0, 0, 0, 0 },
/* U+6f82 */ { 0, 0, 0, 0, 0 },
/* U+6f83 */ { 0, 0, 0, 0, 0 },
/* U+6f84 */ { 0, 0, 0, 0, 0 },
/* U+6f85 */ { 0, 0, 0, 0, 0 },
/* U+6f86 */ { 0, 0, 0, 0, 0 },
/* U+6f87 */ { 0, 0, 0, 0, 0 },
/* U+6f88 */ { 0, 0, 0, 0, 0 },
/* U+6f89 */ { 0, 0, 0, 0, 0 },
/* U+6f8a */ { 0, 0, 0, 0, 0 },
/* U+6f8b */ { 0, 0, 0, 0, 0 },
/* U+6f8c */ { 0, 0, 0, 0, 0 },
/* U+6f8d */ { 0, 0, 0, 0, 0 },
/* U+6f8e */ { 0, 0, 0, 0, 0 },
/* U+6f8f */ { 0, 0, 0, 0, 0 },
/* U+6f90 */ { 0, 0, 0, 0, 0 },
/* U+6f91 */ { 0, 0, 0, 0, 0 },
/* U+6f92 */ { 0, 0, 0, 0, 0 },
/* U+6f93 */ { 0, 0, 0, 0, 0 },
/* U+6f94 */ { 0, 0, 0, 0, 0 },
/* U+6f95 */ { 0, 0, 0, 0, 0 },
/* U+6f96 */ { 0, 0, 0, 0, 0 },
/* U+6f97 */ { 0, 0, 0, 0, 0 },
/* U+6f98 */ { 0, 0, 0, 0, 0 },
/* U+6f99 */ { 0, 0, 0, 0, 0 },
/* U+6f9a */ { 0, 0, 0, 0, 0 },
/* U+6f9b */ { 0, 0, 0, 0, 0 },
/* U+6f9c */ { 0, 0, 0, 0, 0 },
/* U+6f9d */ { 0, 0, 0, 0, 0 },
/* U+6f9e */ { 0, 0, 0, 0, 0 },
/* U+6f9f */ { 0, 0, 0, 0, 0 },
/* U+6fa0 */ { 0, 0, 0, 0, 0 },
/* U+6fa1 */ { 0, 0, 0, 0, 0 },
/* U+6fa2 */ { 0, 0, 0, 0, 0 },
/* U+6fa3 */ { 0, 0, 0, 0, 0 },
/* U+6fa4 */ { 0, 0, 0, 0, 0 },
/* U+6fa5 */ { 0, 0, 0, 0, 0 },
/* U+6fa6 */ { 0, 0, 0, 0, 0 },
/* U+6fa7 */ { 0, 0, 0, 0, 0 },
/* U+6fa8 */ { 0, 0, 0, 0, 0 },
/* U+6fa9 */ { 0, 0, 0, 0, 0 },
/* U+6faa */ { 0, 0, 0, 0, 0 },
/* U+6fab */ { 0, 0, 0, 0, 0 },
/* U+6fac */ { 0, 0, 0, 0, 0 },
/* U+6fad */ { 0, 0, 0, 0, 0 },
/* U+6fae */ { 0, 0, 0, 0, 0 },
/* U+6faf */ { 0, 0, 0, 0, 0 },
/* U+6fb0 */ { 0, 0, 0, 0, 0 },
/* U+6fb1 */ { 0, 0, 0, 0, 0 },
/* U+6fb2 */ { 0, 0, 0, 0, 0 },
/* U+6fb3 */ { 0, 0, 0, 0, 0 },
/* U+6fb4 */ { 0, 0, 0, 0, 0 },
/* U+6fb5 */ { 0, 0, 0, 0, 0 },
/* U+6fb6 */ { 0, 0, 0, 0, 0 },
/* U+6fb7 */ { 0, 0, 0, 0, 0 },
/* U+6fb8 */ { 0, 0, 0, 0, 0 },
/* U+6fb9 */ { 0, 0, 0, 0, 0 },
/* U+6fba */ { 0, 0, 0, 0, 0 },
/* U+6fbb */ { 0, 0, 0, 0, 0 },
/* U+6fbc */ { 0, 0, 0, 0, 0 },
/* U+6fbd */ { 0, 0, 0, 0, 0 },
/* U+6fbe */ { 0, 0, 0, 0, 0 },
/* U+6fbf */ { 0, 0, 0, 0, 0 },
/* U+6fc0 */ { 0, 0, 0, 0, 0 },
/* U+6fc1 */ { 0, 0, 0, 0, 0 },
/* U+6fc2 */ { 0, 0, 0, 0, 0 },
/* U+6fc3 */ { 0, 0, 0, 0, 0 },
/* U+6fc4 */ { 0, 0, 0, 0, 0 },
/* U+6fc5 */ { 0, 0, 0, 0, 0 },
/* U+6fc6 */ { 0, 0, 0, 0, 0 },
/* U+6fc7 */ { 0, 0, 0, 0, 0 },
/* U+6fc8 */ { 0, 0, 0, 0, 0 },
/* U+6fc9 */ { 0, 0, 0, 0, 0 },
/* U+6fca */ { 0, 0, 0, 0, 0 },
/* U+6fcb */ { 0, 0, 0, 0, 0 },
/* U+6fcc */ { 0, 0, 0, 0, 0 },
/* U+6fcd */ { 0, 0, 0, 0, 0 },
/* U+6fce */ { 0, 0, 0, 0, 0 },
/* U+6fcf */ { 0, 0, 0, 0, 0 },
/* U+6fd0 */ { 0, 0, 0, 0, 0 },
/* U+6fd1 */ { 0, 0, 0, 0, 0 },
/* U+6fd2 */ { 0, 0, 0, 0, 0 },
/* U+6fd3 */ { 0, 0, 0, 0, 0 },
/* U+6fd4 */ { 0, 0, 0, 0, 0 },
/* U+6fd5 */ { 0, 0, 0, 0, 0 },
/* U+6fd6 */ { 0, 0, 0, 0, 0 },
/* U+6fd7 */ { 0, 0, 0, 0, 0 },
/* U+6fd8 */ { 0, 0, 0, 0, 0 },
/* U+6fd9 */ { 0, 0, 0, 0, 0 },
/* U+6fda */ { 0, 0, 0, 0, 0 },
/* U+6fdb */ { 0, 0, 0, 0, 0 },
/* U+6fdc */ { 0, 0, 0, 0, 0 },
/* U+6fdd */ { 0, 0, 0, 0, 0 },
/* U+6fde */ { 0, 0, 0, 0, 0 },
/* U+6fdf */ { 0, 0, 0, 0, 0 },
/* U+6fe0 */ { 0, 0, 0, 0, 0 },
/* U+6fe1 */ { 0, 0, 0, 0, 0 },
/* U+6fe2 */ { 0, 0, 0, 0, 0 },
/* U+6fe3 */ { 0, 0, 0, 0, 0 },
/* U+6fe4 */ { 0, 0, 0, 0, 0 },
/* U+6fe5 */ { 0, 0, 0, 0, 0 },
/* U+6fe6 */ { 0, 0, 0, 0, 0 },
/* U+6fe7 */ { 0, 0, 0, 0, 0 },
/* U+6fe8 */ { 0, 0, 0, 0, 0 },
/* U+6fe9 */ { 0, 0, 0, 0, 0 },
/* U+6fea */ { 0, 0, 0, 0, 0 },
/* U+6feb */ { 0, 0, 0, 0, 0 },
/* U+6fec */ { 0, 0, 0, 0, 0 },
/* U+6fed */ { 0, 0, 0, 0, 0 },
/* U+6fee */ { 0, 0, 0, 0, 0 },
/* U+6fef */ { 0, 0, 0, 0, 0 },
/* U+6ff0 */ { 0, 0, 0, 0, 0 },
/* U+6ff1 */ { 0, 0, 0, 0, 0 },
/* U+6ff2 */ { 0, 0, 0, 0, 0 },
/* U+6ff3 */ { 0, 0, 0, 0, 0 },
/* U+6ff4 */ { 0, 0, 0, 0, 0 },
/* U+6ff5 */ { 0, 0, 0, 0, 0 },
/* U+6ff6 */ { 0, 0, 0, 0, 0 },
/* U+6ff7 */ { 0, 0, 0, 0, 0 },
/* U+6ff8 */ { 0, 0, 0, 0, 0 },
/* U+6ff9 */ { 0, 0, 0, 0, 0 },
/* U+6ffa */ { 0, 0, 0, 0, 0 },
/* U+6ffb */ { 0, 0, 0, 0, 0 },
/* U+6ffc */ { 0, 0, 0, 0, 0 },
/* U+6ffd */ { 0, 0, 0, 0, 0 },
/* U+6ffe */ { 0, 0, 0, 0, 0 },
/* U+6fff */ { 0, 0, 0, 0, 0 },

};

const _PyUnicode_DatabaseRecord _PyUnicode_Database_7[4096] = {
    
/* U+7000 */ { 0, 0, 0, 0, 0 },
/* U+7001 */ { 0, 0, 0, 0, 0 },
/* U+7002 */ { 0, 0, 0, 0, 0 },
/* U+7003 */ { 0, 0, 0, 0, 0 },
/* U+7004 */ { 0, 0, 0, 0, 0 },
/* U+7005 */ { 0, 0, 0, 0, 0 },
/* U+7006 */ { 0, 0, 0, 0, 0 },
/* U+7007 */ { 0, 0, 0, 0, 0 },
/* U+7008 */ { 0, 0, 0, 0, 0 },
/* U+7009 */ { 0, 0, 0, 0, 0 },
/* U+700a */ { 0, 0, 0, 0, 0 },
/* U+700b */ { 0, 0, 0, 0, 0 },
/* U+700c */ { 0, 0, 0, 0, 0 },
/* U+700d */ { 0, 0, 0, 0, 0 },
/* U+700e */ { 0, 0, 0, 0, 0 },
/* U+700f */ { 0, 0, 0, 0, 0 },
/* U+7010 */ { 0, 0, 0, 0, 0 },
/* U+7011 */ { 0, 0, 0, 0, 0 },
/* U+7012 */ { 0, 0, 0, 0, 0 },
/* U+7013 */ { 0, 0, 0, 0, 0 },
/* U+7014 */ { 0, 0, 0, 0, 0 },
/* U+7015 */ { 0, 0, 0, 0, 0 },
/* U+7016 */ { 0, 0, 0, 0, 0 },
/* U+7017 */ { 0, 0, 0, 0, 0 },
/* U+7018 */ { 0, 0, 0, 0, 0 },
/* U+7019 */ { 0, 0, 0, 0, 0 },
/* U+701a */ { 0, 0, 0, 0, 0 },
/* U+701b */ { 0, 0, 0, 0, 0 },
/* U+701c */ { 0, 0, 0, 0, 0 },
/* U+701d */ { 0, 0, 0, 0, 0 },
/* U+701e */ { 0, 0, 0, 0, 0 },
/* U+701f */ { 0, 0, 0, 0, 0 },
/* U+7020 */ { 0, 0, 0, 0, 0 },
/* U+7021 */ { 0, 0, 0, 0, 0 },
/* U+7022 */ { 0, 0, 0, 0, 0 },
/* U+7023 */ { 0, 0, 0, 0, 0 },
/* U+7024 */ { 0, 0, 0, 0, 0 },
/* U+7025 */ { 0, 0, 0, 0, 0 },
/* U+7026 */ { 0, 0, 0, 0, 0 },
/* U+7027 */ { 0, 0, 0, 0, 0 },
/* U+7028 */ { 0, 0, 0, 0, 0 },
/* U+7029 */ { 0, 0, 0, 0, 0 },
/* U+702a */ { 0, 0, 0, 0, 0 },
/* U+702b */ { 0, 0, 0, 0, 0 },
/* U+702c */ { 0, 0, 0, 0, 0 },
/* U+702d */ { 0, 0, 0, 0, 0 },
/* U+702e */ { 0, 0, 0, 0, 0 },
/* U+702f */ { 0, 0, 0, 0, 0 },
/* U+7030 */ { 0, 0, 0, 0, 0 },
/* U+7031 */ { 0, 0, 0, 0, 0 },
/* U+7032 */ { 0, 0, 0, 0, 0 },
/* U+7033 */ { 0, 0, 0, 0, 0 },
/* U+7034 */ { 0, 0, 0, 0, 0 },
/* U+7035 */ { 0, 0, 0, 0, 0 },
/* U+7036 */ { 0, 0, 0, 0, 0 },
/* U+7037 */ { 0, 0, 0, 0, 0 },
/* U+7038 */ { 0, 0, 0, 0, 0 },
/* U+7039 */ { 0, 0, 0, 0, 0 },
/* U+703a */ { 0, 0, 0, 0, 0 },
/* U+703b */ { 0, 0, 0, 0, 0 },
/* U+703c */ { 0, 0, 0, 0, 0 },
/* U+703d */ { 0, 0, 0, 0, 0 },
/* U+703e */ { 0, 0, 0, 0, 0 },
/* U+703f */ { 0, 0, 0, 0, 0 },
/* U+7040 */ { 0, 0, 0, 0, 0 },
/* U+7041 */ { 0, 0, 0, 0, 0 },
/* U+7042 */ { 0, 0, 0, 0, 0 },
/* U+7043 */ { 0, 0, 0, 0, 0 },
/* U+7044 */ { 0, 0, 0, 0, 0 },
/* U+7045 */ { 0, 0, 0, 0, 0 },
/* U+7046 */ { 0, 0, 0, 0, 0 },
/* U+7047 */ { 0, 0, 0, 0, 0 },
/* U+7048 */ { 0, 0, 0, 0, 0 },
/* U+7049 */ { 0, 0, 0, 0, 0 },
/* U+704a */ { 0, 0, 0, 0, 0 },
/* U+704b */ { 0, 0, 0, 0, 0 },
/* U+704c */ { 0, 0, 0, 0, 0 },
/* U+704d */ { 0, 0, 0, 0, 0 },
/* U+704e */ { 0, 0, 0, 0, 0 },
/* U+704f */ { 0, 0, 0, 0, 0 },
/* U+7050 */ { 0, 0, 0, 0, 0 },
/* U+7051 */ { 0, 0, 0, 0, 0 },
/* U+7052 */ { 0, 0, 0, 0, 0 },
/* U+7053 */ { 0, 0, 0, 0, 0 },
/* U+7054 */ { 0, 0, 0, 0, 0 },
/* U+7055 */ { 0, 0, 0, 0, 0 },
/* U+7056 */ { 0, 0, 0, 0, 0 },
/* U+7057 */ { 0, 0, 0, 0, 0 },
/* U+7058 */ { 0, 0, 0, 0, 0 },
/* U+7059 */ { 0, 0, 0, 0, 0 },
/* U+705a */ { 0, 0, 0, 0, 0 },
/* U+705b */ { 0, 0, 0, 0, 0 },
/* U+705c */ { 0, 0, 0, 0, 0 },
/* U+705d */ { 0, 0, 0, 0, 0 },
/* U+705e */ { 0, 0, 0, 0, 0 },
/* U+705f */ { 0, 0, 0, 0, 0 },
/* U+7060 */ { 0, 0, 0, 0, 0 },
/* U+7061 */ { 0, 0, 0, 0, 0 },
/* U+7062 */ { 0, 0, 0, 0, 0 },
/* U+7063 */ { 0, 0, 0, 0, 0 },
/* U+7064 */ { 0, 0, 0, 0, 0 },
/* U+7065 */ { 0, 0, 0, 0, 0 },
/* U+7066 */ { 0, 0, 0, 0, 0 },
/* U+7067 */ { 0, 0, 0, 0, 0 },
/* U+7068 */ { 0, 0, 0, 0, 0 },
/* U+7069 */ { 0, 0, 0, 0, 0 },
/* U+706a */ { 0, 0, 0, 0, 0 },
/* U+706b */ { 0, 0, 0, 0, 0 },
/* U+706c */ { 0, 0, 0, 0, 0 },
/* U+706d */ { 0, 0, 0, 0, 0 },
/* U+706e */ { 0, 0, 0, 0, 0 },
/* U+706f */ { 0, 0, 0, 0, 0 },
/* U+7070 */ { 0, 0, 0, 0, 0 },
/* U+7071 */ { 0, 0, 0, 0, 0 },
/* U+7072 */ { 0, 0, 0, 0, 0 },
/* U+7073 */ { 0, 0, 0, 0, 0 },
/* U+7074 */ { 0, 0, 0, 0, 0 },
/* U+7075 */ { 0, 0, 0, 0, 0 },
/* U+7076 */ { 0, 0, 0, 0, 0 },
/* U+7077 */ { 0, 0, 0, 0, 0 },
/* U+7078 */ { 0, 0, 0, 0, 0 },
/* U+7079 */ { 0, 0, 0, 0, 0 },
/* U+707a */ { 0, 0, 0, 0, 0 },
/* U+707b */ { 0, 0, 0, 0, 0 },
/* U+707c */ { 0, 0, 0, 0, 0 },
/* U+707d */ { 0, 0, 0, 0, 0 },
/* U+707e */ { 0, 0, 0, 0, 0 },
/* U+707f */ { 0, 0, 0, 0, 0 },
/* U+7080 */ { 0, 0, 0, 0, 0 },
/* U+7081 */ { 0, 0, 0, 0, 0 },
/* U+7082 */ { 0, 0, 0, 0, 0 },
/* U+7083 */ { 0, 0, 0, 0, 0 },
/* U+7084 */ { 0, 0, 0, 0, 0 },
/* U+7085 */ { 0, 0, 0, 0, 0 },
/* U+7086 */ { 0, 0, 0, 0, 0 },
/* U+7087 */ { 0, 0, 0, 0, 0 },
/* U+7088 */ { 0, 0, 0, 0, 0 },
/* U+7089 */ { 0, 0, 0, 0, 0 },
/* U+708a */ { 0, 0, 0, 0, 0 },
/* U+708b */ { 0, 0, 0, 0, 0 },
/* U+708c */ { 0, 0, 0, 0, 0 },
/* U+708d */ { 0, 0, 0, 0, 0 },
/* U+708e */ { 0, 0, 0, 0, 0 },
/* U+708f */ { 0, 0, 0, 0, 0 },
/* U+7090 */ { 0, 0, 0, 0, 0 },
/* U+7091 */ { 0, 0, 0, 0, 0 },
/* U+7092 */ { 0, 0, 0, 0, 0 },
/* U+7093 */ { 0, 0, 0, 0, 0 },
/* U+7094 */ { 0, 0, 0, 0, 0 },
/* U+7095 */ { 0, 0, 0, 0, 0 },
/* U+7096 */ { 0, 0, 0, 0, 0 },
/* U+7097 */ { 0, 0, 0, 0, 0 },
/* U+7098 */ { 0, 0, 0, 0, 0 },
/* U+7099 */ { 0, 0, 0, 0, 0 },
/* U+709a */ { 0, 0, 0, 0, 0 },
/* U+709b */ { 0, 0, 0, 0, 0 },
/* U+709c */ { 0, 0, 0, 0, 0 },
/* U+709d */ { 0, 0, 0, 0, 0 },
/* U+709e */ { 0, 0, 0, 0, 0 },
/* U+709f */ { 0, 0, 0, 0, 0 },
/* U+70a0 */ { 0, 0, 0, 0, 0 },
/* U+70a1 */ { 0, 0, 0, 0, 0 },
/* U+70a2 */ { 0, 0, 0, 0, 0 },
/* U+70a3 */ { 0, 0, 0, 0, 0 },
/* U+70a4 */ { 0, 0, 0, 0, 0 },
/* U+70a5 */ { 0, 0, 0, 0, 0 },
/* U+70a6 */ { 0, 0, 0, 0, 0 },
/* U+70a7 */ { 0, 0, 0, 0, 0 },
/* U+70a8 */ { 0, 0, 0, 0, 0 },
/* U+70a9 */ { 0, 0, 0, 0, 0 },
/* U+70aa */ { 0, 0, 0, 0, 0 },
/* U+70ab */ { 0, 0, 0, 0, 0 },
/* U+70ac */ { 0, 0, 0, 0, 0 },
/* U+70ad */ { 0, 0, 0, 0, 0 },
/* U+70ae */ { 0, 0, 0, 0, 0 },
/* U+70af */ { 0, 0, 0, 0, 0 },
/* U+70b0 */ { 0, 0, 0, 0, 0 },
/* U+70b1 */ { 0, 0, 0, 0, 0 },
/* U+70b2 */ { 0, 0, 0, 0, 0 },
/* U+70b3 */ { 0, 0, 0, 0, 0 },
/* U+70b4 */ { 0, 0, 0, 0, 0 },
/* U+70b5 */ { 0, 0, 0, 0, 0 },
/* U+70b6 */ { 0, 0, 0, 0, 0 },
/* U+70b7 */ { 0, 0, 0, 0, 0 },
/* U+70b8 */ { 0, 0, 0, 0, 0 },
/* U+70b9 */ { 0, 0, 0, 0, 0 },
/* U+70ba */ { 0, 0, 0, 0, 0 },
/* U+70bb */ { 0, 0, 0, 0, 0 },
/* U+70bc */ { 0, 0, 0, 0, 0 },
/* U+70bd */ { 0, 0, 0, 0, 0 },
/* U+70be */ { 0, 0, 0, 0, 0 },
/* U+70bf */ { 0, 0, 0, 0, 0 },
/* U+70c0 */ { 0, 0, 0, 0, 0 },
/* U+70c1 */ { 0, 0, 0, 0, 0 },
/* U+70c2 */ { 0, 0, 0, 0, 0 },
/* U+70c3 */ { 0, 0, 0, 0, 0 },
/* U+70c4 */ { 0, 0, 0, 0, 0 },
/* U+70c5 */ { 0, 0, 0, 0, 0 },
/* U+70c6 */ { 0, 0, 0, 0, 0 },
/* U+70c7 */ { 0, 0, 0, 0, 0 },
/* U+70c8 */ { 0, 0, 0, 0, 0 },
/* U+70c9 */ { 0, 0, 0, 0, 0 },
/* U+70ca */ { 0, 0, 0, 0, 0 },
/* U+70cb */ { 0, 0, 0, 0, 0 },
/* U+70cc */ { 0, 0, 0, 0, 0 },
/* U+70cd */ { 0, 0, 0, 0, 0 },
/* U+70ce */ { 0, 0, 0, 0, 0 },
/* U+70cf */ { 0, 0, 0, 0, 0 },
/* U+70d0 */ { 0, 0, 0, 0, 0 },
/* U+70d1 */ { 0, 0, 0, 0, 0 },
/* U+70d2 */ { 0, 0, 0, 0, 0 },
/* U+70d3 */ { 0, 0, 0, 0, 0 },
/* U+70d4 */ { 0, 0, 0, 0, 0 },
/* U+70d5 */ { 0, 0, 0, 0, 0 },
/* U+70d6 */ { 0, 0, 0, 0, 0 },
/* U+70d7 */ { 0, 0, 0, 0, 0 },
/* U+70d8 */ { 0, 0, 0, 0, 0 },
/* U+70d9 */ { 0, 0, 0, 0, 0 },
/* U+70da */ { 0, 0, 0, 0, 0 },
/* U+70db */ { 0, 0, 0, 0, 0 },
/* U+70dc */ { 0, 0, 0, 0, 0 },
/* U+70dd */ { 0, 0, 0, 0, 0 },
/* U+70de */ { 0, 0, 0, 0, 0 },
/* U+70df */ { 0, 0, 0, 0, 0 },
/* U+70e0 */ { 0, 0, 0, 0, 0 },
/* U+70e1 */ { 0, 0, 0, 0, 0 },
/* U+70e2 */ { 0, 0, 0, 0, 0 },
/* U+70e3 */ { 0, 0, 0, 0, 0 },
/* U+70e4 */ { 0, 0, 0, 0, 0 },
/* U+70e5 */ { 0, 0, 0, 0, 0 },
/* U+70e6 */ { 0, 0, 0, 0, 0 },
/* U+70e7 */ { 0, 0, 0, 0, 0 },
/* U+70e8 */ { 0, 0, 0, 0, 0 },
/* U+70e9 */ { 0, 0, 0, 0, 0 },
/* U+70ea */ { 0, 0, 0, 0, 0 },
/* U+70eb */ { 0, 0, 0, 0, 0 },
/* U+70ec */ { 0, 0, 0, 0, 0 },
/* U+70ed */ { 0, 0, 0, 0, 0 },
/* U+70ee */ { 0, 0, 0, 0, 0 },
/* U+70ef */ { 0, 0, 0, 0, 0 },
/* U+70f0 */ { 0, 0, 0, 0, 0 },
/* U+70f1 */ { 0, 0, 0, 0, 0 },
/* U+70f2 */ { 0, 0, 0, 0, 0 },
/* U+70f3 */ { 0, 0, 0, 0, 0 },
/* U+70f4 */ { 0, 0, 0, 0, 0 },
/* U+70f5 */ { 0, 0, 0, 0, 0 },
/* U+70f6 */ { 0, 0, 0, 0, 0 },
/* U+70f7 */ { 0, 0, 0, 0, 0 },
/* U+70f8 */ { 0, 0, 0, 0, 0 },
/* U+70f9 */ { 0, 0, 0, 0, 0 },
/* U+70fa */ { 0, 0, 0, 0, 0 },
/* U+70fb */ { 0, 0, 0, 0, 0 },
/* U+70fc */ { 0, 0, 0, 0, 0 },
/* U+70fd */ { 0, 0, 0, 0, 0 },
/* U+70fe */ { 0, 0, 0, 0, 0 },
/* U+70ff */ { 0, 0, 0, 0, 0 },
/* U+7100 */ { 0, 0, 0, 0, 0 },
/* U+7101 */ { 0, 0, 0, 0, 0 },
/* U+7102 */ { 0, 0, 0, 0, 0 },
/* U+7103 */ { 0, 0, 0, 0, 0 },
/* U+7104 */ { 0, 0, 0, 0, 0 },
/* U+7105 */ { 0, 0, 0, 0, 0 },
/* U+7106 */ { 0, 0, 0, 0, 0 },
/* U+7107 */ { 0, 0, 0, 0, 0 },
/* U+7108 */ { 0, 0, 0, 0, 0 },
/* U+7109 */ { 0, 0, 0, 0, 0 },
/* U+710a */ { 0, 0, 0, 0, 0 },
/* U+710b */ { 0, 0, 0, 0, 0 },
/* U+710c */ { 0, 0, 0, 0, 0 },
/* U+710d */ { 0, 0, 0, 0, 0 },
/* U+710e */ { 0, 0, 0, 0, 0 },
/* U+710f */ { 0, 0, 0, 0, 0 },
/* U+7110 */ { 0, 0, 0, 0, 0 },
/* U+7111 */ { 0, 0, 0, 0, 0 },
/* U+7112 */ { 0, 0, 0, 0, 0 },
/* U+7113 */ { 0, 0, 0, 0, 0 },
/* U+7114 */ { 0, 0, 0, 0, 0 },
/* U+7115 */ { 0, 0, 0, 0, 0 },
/* U+7116 */ { 0, 0, 0, 0, 0 },
/* U+7117 */ { 0, 0, 0, 0, 0 },
/* U+7118 */ { 0, 0, 0, 0, 0 },
/* U+7119 */ { 0, 0, 0, 0, 0 },
/* U+711a */ { 0, 0, 0, 0, 0 },
/* U+711b */ { 0, 0, 0, 0, 0 },
/* U+711c */ { 0, 0, 0, 0, 0 },
/* U+711d */ { 0, 0, 0, 0, 0 },
/* U+711e */ { 0, 0, 0, 0, 0 },
/* U+711f */ { 0, 0, 0, 0, 0 },
/* U+7120 */ { 0, 0, 0, 0, 0 },
/* U+7121 */ { 0, 0, 0, 0, 0 },
/* U+7122 */ { 0, 0, 0, 0, 0 },
/* U+7123 */ { 0, 0, 0, 0, 0 },
/* U+7124 */ { 0, 0, 0, 0, 0 },
/* U+7125 */ { 0, 0, 0, 0, 0 },
/* U+7126 */ { 0, 0, 0, 0, 0 },
/* U+7127 */ { 0, 0, 0, 0, 0 },
/* U+7128 */ { 0, 0, 0, 0, 0 },
/* U+7129 */ { 0, 0, 0, 0, 0 },
/* U+712a */ { 0, 0, 0, 0, 0 },
/* U+712b */ { 0, 0, 0, 0, 0 },
/* U+712c */ { 0, 0, 0, 0, 0 },
/* U+712d */ { 0, 0, 0, 0, 0 },
/* U+712e */ { 0, 0, 0, 0, 0 },
/* U+712f */ { 0, 0, 0, 0, 0 },
/* U+7130 */ { 0, 0, 0, 0, 0 },
/* U+7131 */ { 0, 0, 0, 0, 0 },
/* U+7132 */ { 0, 0, 0, 0, 0 },
/* U+7133 */ { 0, 0, 0, 0, 0 },
/* U+7134 */ { 0, 0, 0, 0, 0 },
/* U+7135 */ { 0, 0, 0, 0, 0 },
/* U+7136 */ { 0, 0, 0, 0, 0 },
/* U+7137 */ { 0, 0, 0, 0, 0 },
/* U+7138 */ { 0, 0, 0, 0, 0 },
/* U+7139 */ { 0, 0, 0, 0, 0 },
/* U+713a */ { 0, 0, 0, 0, 0 },
/* U+713b */ { 0, 0, 0, 0, 0 },
/* U+713c */ { 0, 0, 0, 0, 0 },
/* U+713d */ { 0, 0, 0, 0, 0 },
/* U+713e */ { 0, 0, 0, 0, 0 },
/* U+713f */ { 0, 0, 0, 0, 0 },
/* U+7140 */ { 0, 0, 0, 0, 0 },
/* U+7141 */ { 0, 0, 0, 0, 0 },
/* U+7142 */ { 0, 0, 0, 0, 0 },
/* U+7143 */ { 0, 0, 0, 0, 0 },
/* U+7144 */ { 0, 0, 0, 0, 0 },
/* U+7145 */ { 0, 0, 0, 0, 0 },
/* U+7146 */ { 0, 0, 0, 0, 0 },
/* U+7147 */ { 0, 0, 0, 0, 0 },
/* U+7148 */ { 0, 0, 0, 0, 0 },
/* U+7149 */ { 0, 0, 0, 0, 0 },
/* U+714a */ { 0, 0, 0, 0, 0 },
/* U+714b */ { 0, 0, 0, 0, 0 },
/* U+714c */ { 0, 0, 0, 0, 0 },
/* U+714d */ { 0, 0, 0, 0, 0 },
/* U+714e */ { 0, 0, 0, 0, 0 },
/* U+714f */ { 0, 0, 0, 0, 0 },
/* U+7150 */ { 0, 0, 0, 0, 0 },
/* U+7151 */ { 0, 0, 0, 0, 0 },
/* U+7152 */ { 0, 0, 0, 0, 0 },
/* U+7153 */ { 0, 0, 0, 0, 0 },
/* U+7154 */ { 0, 0, 0, 0, 0 },
/* U+7155 */ { 0, 0, 0, 0, 0 },
/* U+7156 */ { 0, 0, 0, 0, 0 },
/* U+7157 */ { 0, 0, 0, 0, 0 },
/* U+7158 */ { 0, 0, 0, 0, 0 },
/* U+7159 */ { 0, 0, 0, 0, 0 },
/* U+715a */ { 0, 0, 0, 0, 0 },
/* U+715b */ { 0, 0, 0, 0, 0 },
/* U+715c */ { 0, 0, 0, 0, 0 },
/* U+715d */ { 0, 0, 0, 0, 0 },
/* U+715e */ { 0, 0, 0, 0, 0 },
/* U+715f */ { 0, 0, 0, 0, 0 },
/* U+7160 */ { 0, 0, 0, 0, 0 },
/* U+7161 */ { 0, 0, 0, 0, 0 },
/* U+7162 */ { 0, 0, 0, 0, 0 },
/* U+7163 */ { 0, 0, 0, 0, 0 },
/* U+7164 */ { 0, 0, 0, 0, 0 },
/* U+7165 */ { 0, 0, 0, 0, 0 },
/* U+7166 */ { 0, 0, 0, 0, 0 },
/* U+7167 */ { 0, 0, 0, 0, 0 },
/* U+7168 */ { 0, 0, 0, 0, 0 },
/* U+7169 */ { 0, 0, 0, 0, 0 },
/* U+716a */ { 0, 0, 0, 0, 0 },
/* U+716b */ { 0, 0, 0, 0, 0 },
/* U+716c */ { 0, 0, 0, 0, 0 },
/* U+716d */ { 0, 0, 0, 0, 0 },
/* U+716e */ { 0, 0, 0, 0, 0 },
/* U+716f */ { 0, 0, 0, 0, 0 },
/* U+7170 */ { 0, 0, 0, 0, 0 },
/* U+7171 */ { 0, 0, 0, 0, 0 },
/* U+7172 */ { 0, 0, 0, 0, 0 },
/* U+7173 */ { 0, 0, 0, 0, 0 },
/* U+7174 */ { 0, 0, 0, 0, 0 },
/* U+7175 */ { 0, 0, 0, 0, 0 },
/* U+7176 */ { 0, 0, 0, 0, 0 },
/* U+7177 */ { 0, 0, 0, 0, 0 },
/* U+7178 */ { 0, 0, 0, 0, 0 },
/* U+7179 */ { 0, 0, 0, 0, 0 },
/* U+717a */ { 0, 0, 0, 0, 0 },
/* U+717b */ { 0, 0, 0, 0, 0 },
/* U+717c */ { 0, 0, 0, 0, 0 },
/* U+717d */ { 0, 0, 0, 0, 0 },
/* U+717e */ { 0, 0, 0, 0, 0 },
/* U+717f */ { 0, 0, 0, 0, 0 },
/* U+7180 */ { 0, 0, 0, 0, 0 },
/* U+7181 */ { 0, 0, 0, 0, 0 },
/* U+7182 */ { 0, 0, 0, 0, 0 },
/* U+7183 */ { 0, 0, 0, 0, 0 },
/* U+7184 */ { 0, 0, 0, 0, 0 },
/* U+7185 */ { 0, 0, 0, 0, 0 },
/* U+7186 */ { 0, 0, 0, 0, 0 },
/* U+7187 */ { 0, 0, 0, 0, 0 },
/* U+7188 */ { 0, 0, 0, 0, 0 },
/* U+7189 */ { 0, 0, 0, 0, 0 },
/* U+718a */ { 0, 0, 0, 0, 0 },
/* U+718b */ { 0, 0, 0, 0, 0 },
/* U+718c */ { 0, 0, 0, 0, 0 },
/* U+718d */ { 0, 0, 0, 0, 0 },
/* U+718e */ { 0, 0, 0, 0, 0 },
/* U+718f */ { 0, 0, 0, 0, 0 },
/* U+7190 */ { 0, 0, 0, 0, 0 },
/* U+7191 */ { 0, 0, 0, 0, 0 },
/* U+7192 */ { 0, 0, 0, 0, 0 },
/* U+7193 */ { 0, 0, 0, 0, 0 },
/* U+7194 */ { 0, 0, 0, 0, 0 },
/* U+7195 */ { 0, 0, 0, 0, 0 },
/* U+7196 */ { 0, 0, 0, 0, 0 },
/* U+7197 */ { 0, 0, 0, 0, 0 },
/* U+7198 */ { 0, 0, 0, 0, 0 },
/* U+7199 */ { 0, 0, 0, 0, 0 },
/* U+719a */ { 0, 0, 0, 0, 0 },
/* U+719b */ { 0, 0, 0, 0, 0 },
/* U+719c */ { 0, 0, 0, 0, 0 },
/* U+719d */ { 0, 0, 0, 0, 0 },
/* U+719e */ { 0, 0, 0, 0, 0 },
/* U+719f */ { 0, 0, 0, 0, 0 },
/* U+71a0 */ { 0, 0, 0, 0, 0 },
/* U+71a1 */ { 0, 0, 0, 0, 0 },
/* U+71a2 */ { 0, 0, 0, 0, 0 },
/* U+71a3 */ { 0, 0, 0, 0, 0 },
/* U+71a4 */ { 0, 0, 0, 0, 0 },
/* U+71a5 */ { 0, 0, 0, 0, 0 },
/* U+71a6 */ { 0, 0, 0, 0, 0 },
/* U+71a7 */ { 0, 0, 0, 0, 0 },
/* U+71a8 */ { 0, 0, 0, 0, 0 },
/* U+71a9 */ { 0, 0, 0, 0, 0 },
/* U+71aa */ { 0, 0, 0, 0, 0 },
/* U+71ab */ { 0, 0, 0, 0, 0 },
/* U+71ac */ { 0, 0, 0, 0, 0 },
/* U+71ad */ { 0, 0, 0, 0, 0 },
/* U+71ae */ { 0, 0, 0, 0, 0 },
/* U+71af */ { 0, 0, 0, 0, 0 },
/* U+71b0 */ { 0, 0, 0, 0, 0 },
/* U+71b1 */ { 0, 0, 0, 0, 0 },
/* U+71b2 */ { 0, 0, 0, 0, 0 },
/* U+71b3 */ { 0, 0, 0, 0, 0 },
/* U+71b4 */ { 0, 0, 0, 0, 0 },
/* U+71b5 */ { 0, 0, 0, 0, 0 },
/* U+71b6 */ { 0, 0, 0, 0, 0 },
/* U+71b7 */ { 0, 0, 0, 0, 0 },
/* U+71b8 */ { 0, 0, 0, 0, 0 },
/* U+71b9 */ { 0, 0, 0, 0, 0 },
/* U+71ba */ { 0, 0, 0, 0, 0 },
/* U+71bb */ { 0, 0, 0, 0, 0 },
/* U+71bc */ { 0, 0, 0, 0, 0 },
/* U+71bd */ { 0, 0, 0, 0, 0 },
/* U+71be */ { 0, 0, 0, 0, 0 },
/* U+71bf */ { 0, 0, 0, 0, 0 },
/* U+71c0 */ { 0, 0, 0, 0, 0 },
/* U+71c1 */ { 0, 0, 0, 0, 0 },
/* U+71c2 */ { 0, 0, 0, 0, 0 },
/* U+71c3 */ { 0, 0, 0, 0, 0 },
/* U+71c4 */ { 0, 0, 0, 0, 0 },
/* U+71c5 */ { 0, 0, 0, 0, 0 },
/* U+71c6 */ { 0, 0, 0, 0, 0 },
/* U+71c7 */ { 0, 0, 0, 0, 0 },
/* U+71c8 */ { 0, 0, 0, 0, 0 },
/* U+71c9 */ { 0, 0, 0, 0, 0 },
/* U+71ca */ { 0, 0, 0, 0, 0 },
/* U+71cb */ { 0, 0, 0, 0, 0 },
/* U+71cc */ { 0, 0, 0, 0, 0 },
/* U+71cd */ { 0, 0, 0, 0, 0 },
/* U+71ce */ { 0, 0, 0, 0, 0 },
/* U+71cf */ { 0, 0, 0, 0, 0 },
/* U+71d0 */ { 0, 0, 0, 0, 0 },
/* U+71d1 */ { 0, 0, 0, 0, 0 },
/* U+71d2 */ { 0, 0, 0, 0, 0 },
/* U+71d3 */ { 0, 0, 0, 0, 0 },
/* U+71d4 */ { 0, 0, 0, 0, 0 },
/* U+71d5 */ { 0, 0, 0, 0, 0 },
/* U+71d6 */ { 0, 0, 0, 0, 0 },
/* U+71d7 */ { 0, 0, 0, 0, 0 },
/* U+71d8 */ { 0, 0, 0, 0, 0 },
/* U+71d9 */ { 0, 0, 0, 0, 0 },
/* U+71da */ { 0, 0, 0, 0, 0 },
/* U+71db */ { 0, 0, 0, 0, 0 },
/* U+71dc */ { 0, 0, 0, 0, 0 },
/* U+71dd */ { 0, 0, 0, 0, 0 },
/* U+71de */ { 0, 0, 0, 0, 0 },
/* U+71df */ { 0, 0, 0, 0, 0 },
/* U+71e0 */ { 0, 0, 0, 0, 0 },
/* U+71e1 */ { 0, 0, 0, 0, 0 },
/* U+71e2 */ { 0, 0, 0, 0, 0 },
/* U+71e3 */ { 0, 0, 0, 0, 0 },
/* U+71e4 */ { 0, 0, 0, 0, 0 },
/* U+71e5 */ { 0, 0, 0, 0, 0 },
/* U+71e6 */ { 0, 0, 0, 0, 0 },
/* U+71e7 */ { 0, 0, 0, 0, 0 },
/* U+71e8 */ { 0, 0, 0, 0, 0 },
/* U+71e9 */ { 0, 0, 0, 0, 0 },
/* U+71ea */ { 0, 0, 0, 0, 0 },
/* U+71eb */ { 0, 0, 0, 0, 0 },
/* U+71ec */ { 0, 0, 0, 0, 0 },
/* U+71ed */ { 0, 0, 0, 0, 0 },
/* U+71ee */ { 0, 0, 0, 0, 0 },
/* U+71ef */ { 0, 0, 0, 0, 0 },
/* U+71f0 */ { 0, 0, 0, 0, 0 },
/* U+71f1 */ { 0, 0, 0, 0, 0 },
/* U+71f2 */ { 0, 0, 0, 0, 0 },
/* U+71f3 */ { 0, 0, 0, 0, 0 },
/* U+71f4 */ { 0, 0, 0, 0, 0 },
/* U+71f5 */ { 0, 0, 0, 0, 0 },
/* U+71f6 */ { 0, 0, 0, 0, 0 },
/* U+71f7 */ { 0, 0, 0, 0, 0 },
/* U+71f8 */ { 0, 0, 0, 0, 0 },
/* U+71f9 */ { 0, 0, 0, 0, 0 },
/* U+71fa */ { 0, 0, 0, 0, 0 },
/* U+71fb */ { 0, 0, 0, 0, 0 },
/* U+71fc */ { 0, 0, 0, 0, 0 },
/* U+71fd */ { 0, 0, 0, 0, 0 },
/* U+71fe */ { 0, 0, 0, 0, 0 },
/* U+71ff */ { 0, 0, 0, 0, 0 },
/* U+7200 */ { 0, 0, 0, 0, 0 },
/* U+7201 */ { 0, 0, 0, 0, 0 },
/* U+7202 */ { 0, 0, 0, 0, 0 },
/* U+7203 */ { 0, 0, 0, 0, 0 },
/* U+7204 */ { 0, 0, 0, 0, 0 },
/* U+7205 */ { 0, 0, 0, 0, 0 },
/* U+7206 */ { 0, 0, 0, 0, 0 },
/* U+7207 */ { 0, 0, 0, 0, 0 },
/* U+7208 */ { 0, 0, 0, 0, 0 },
/* U+7209 */ { 0, 0, 0, 0, 0 },
/* U+720a */ { 0, 0, 0, 0, 0 },
/* U+720b */ { 0, 0, 0, 0, 0 },
/* U+720c */ { 0, 0, 0, 0, 0 },
/* U+720d */ { 0, 0, 0, 0, 0 },
/* U+720e */ { 0, 0, 0, 0, 0 },
/* U+720f */ { 0, 0, 0, 0, 0 },
/* U+7210 */ { 0, 0, 0, 0, 0 },
/* U+7211 */ { 0, 0, 0, 0, 0 },
/* U+7212 */ { 0, 0, 0, 0, 0 },
/* U+7213 */ { 0, 0, 0, 0, 0 },
/* U+7214 */ { 0, 0, 0, 0, 0 },
/* U+7215 */ { 0, 0, 0, 0, 0 },
/* U+7216 */ { 0, 0, 0, 0, 0 },
/* U+7217 */ { 0, 0, 0, 0, 0 },
/* U+7218 */ { 0, 0, 0, 0, 0 },
/* U+7219 */ { 0, 0, 0, 0, 0 },
/* U+721a */ { 0, 0, 0, 0, 0 },
/* U+721b */ { 0, 0, 0, 0, 0 },
/* U+721c */ { 0, 0, 0, 0, 0 },
/* U+721d */ { 0, 0, 0, 0, 0 },
/* U+721e */ { 0, 0, 0, 0, 0 },
/* U+721f */ { 0, 0, 0, 0, 0 },
/* U+7220 */ { 0, 0, 0, 0, 0 },
/* U+7221 */ { 0, 0, 0, 0, 0 },
/* U+7222 */ { 0, 0, 0, 0, 0 },
/* U+7223 */ { 0, 0, 0, 0, 0 },
/* U+7224 */ { 0, 0, 0, 0, 0 },
/* U+7225 */ { 0, 0, 0, 0, 0 },
/* U+7226 */ { 0, 0, 0, 0, 0 },
/* U+7227 */ { 0, 0, 0, 0, 0 },
/* U+7228 */ { 0, 0, 0, 0, 0 },
/* U+7229 */ { 0, 0, 0, 0, 0 },
/* U+722a */ { 0, 0, 0, 0, 0 },
/* U+722b */ { 0, 0, 0, 0, 0 },
/* U+722c */ { 0, 0, 0, 0, 0 },
/* U+722d */ { 0, 0, 0, 0, 0 },
/* U+722e */ { 0, 0, 0, 0, 0 },
/* U+722f */ { 0, 0, 0, 0, 0 },
/* U+7230 */ { 0, 0, 0, 0, 0 },
/* U+7231 */ { 0, 0, 0, 0, 0 },
/* U+7232 */ { 0, 0, 0, 0, 0 },
/* U+7233 */ { 0, 0, 0, 0, 0 },
/* U+7234 */ { 0, 0, 0, 0, 0 },
/* U+7235 */ { 0, 0, 0, 0, 0 },
/* U+7236 */ { 0, 0, 0, 0, 0 },
/* U+7237 */ { 0, 0, 0, 0, 0 },
/* U+7238 */ { 0, 0, 0, 0, 0 },
/* U+7239 */ { 0, 0, 0, 0, 0 },
/* U+723a */ { 0, 0, 0, 0, 0 },
/* U+723b */ { 0, 0, 0, 0, 0 },
/* U+723c */ { 0, 0, 0, 0, 0 },
/* U+723d */ { 0, 0, 0, 0, 0 },
/* U+723e */ { 0, 0, 0, 0, 0 },
/* U+723f */ { 0, 0, 0, 0, 0 },
/* U+7240 */ { 0, 0, 0, 0, 0 },
/* U+7241 */ { 0, 0, 0, 0, 0 },
/* U+7242 */ { 0, 0, 0, 0, 0 },
/* U+7243 */ { 0, 0, 0, 0, 0 },
/* U+7244 */ { 0, 0, 0, 0, 0 },
/* U+7245 */ { 0, 0, 0, 0, 0 },
/* U+7246 */ { 0, 0, 0, 0, 0 },
/* U+7247 */ { 0, 0, 0, 0, 0 },
/* U+7248 */ { 0, 0, 0, 0, 0 },
/* U+7249 */ { 0, 0, 0, 0, 0 },
/* U+724a */ { 0, 0, 0, 0, 0 },
/* U+724b */ { 0, 0, 0, 0, 0 },
/* U+724c */ { 0, 0, 0, 0, 0 },
/* U+724d */ { 0, 0, 0, 0, 0 },
/* U+724e */ { 0, 0, 0, 0, 0 },
/* U+724f */ { 0, 0, 0, 0, 0 },
/* U+7250 */ { 0, 0, 0, 0, 0 },
/* U+7251 */ { 0, 0, 0, 0, 0 },
/* U+7252 */ { 0, 0, 0, 0, 0 },
/* U+7253 */ { 0, 0, 0, 0, 0 },
/* U+7254 */ { 0, 0, 0, 0, 0 },
/* U+7255 */ { 0, 0, 0, 0, 0 },
/* U+7256 */ { 0, 0, 0, 0, 0 },
/* U+7257 */ { 0, 0, 0, 0, 0 },
/* U+7258 */ { 0, 0, 0, 0, 0 },
/* U+7259 */ { 0, 0, 0, 0, 0 },
/* U+725a */ { 0, 0, 0, 0, 0 },
/* U+725b */ { 0, 0, 0, 0, 0 },
/* U+725c */ { 0, 0, 0, 0, 0 },
/* U+725d */ { 0, 0, 0, 0, 0 },
/* U+725e */ { 0, 0, 0, 0, 0 },
/* U+725f */ { 0, 0, 0, 0, 0 },
/* U+7260 */ { 0, 0, 0, 0, 0 },
/* U+7261 */ { 0, 0, 0, 0, 0 },
/* U+7262 */ { 0, 0, 0, 0, 0 },
/* U+7263 */ { 0, 0, 0, 0, 0 },
/* U+7264 */ { 0, 0, 0, 0, 0 },
/* U+7265 */ { 0, 0, 0, 0, 0 },
/* U+7266 */ { 0, 0, 0, 0, 0 },
/* U+7267 */ { 0, 0, 0, 0, 0 },
/* U+7268 */ { 0, 0, 0, 0, 0 },
/* U+7269 */ { 0, 0, 0, 0, 0 },
/* U+726a */ { 0, 0, 0, 0, 0 },
/* U+726b */ { 0, 0, 0, 0, 0 },
/* U+726c */ { 0, 0, 0, 0, 0 },
/* U+726d */ { 0, 0, 0, 0, 0 },
/* U+726e */ { 0, 0, 0, 0, 0 },
/* U+726f */ { 0, 0, 0, 0, 0 },
/* U+7270 */ { 0, 0, 0, 0, 0 },
/* U+7271 */ { 0, 0, 0, 0, 0 },
/* U+7272 */ { 0, 0, 0, 0, 0 },
/* U+7273 */ { 0, 0, 0, 0, 0 },
/* U+7274 */ { 0, 0, 0, 0, 0 },
/* U+7275 */ { 0, 0, 0, 0, 0 },
/* U+7276 */ { 0, 0, 0, 0, 0 },
/* U+7277 */ { 0, 0, 0, 0, 0 },
/* U+7278 */ { 0, 0, 0, 0, 0 },
/* U+7279 */ { 0, 0, 0, 0, 0 },
/* U+727a */ { 0, 0, 0, 0, 0 },
/* U+727b */ { 0, 0, 0, 0, 0 },
/* U+727c */ { 0, 0, 0, 0, 0 },
/* U+727d */ { 0, 0, 0, 0, 0 },
/* U+727e */ { 0, 0, 0, 0, 0 },
/* U+727f */ { 0, 0, 0, 0, 0 },
/* U+7280 */ { 0, 0, 0, 0, 0 },
/* U+7281 */ { 0, 0, 0, 0, 0 },
/* U+7282 */ { 0, 0, 0, 0, 0 },
/* U+7283 */ { 0, 0, 0, 0, 0 },
/* U+7284 */ { 0, 0, 0, 0, 0 },
/* U+7285 */ { 0, 0, 0, 0, 0 },
/* U+7286 */ { 0, 0, 0, 0, 0 },
/* U+7287 */ { 0, 0, 0, 0, 0 },
/* U+7288 */ { 0, 0, 0, 0, 0 },
/* U+7289 */ { 0, 0, 0, 0, 0 },
/* U+728a */ { 0, 0, 0, 0, 0 },
/* U+728b */ { 0, 0, 0, 0, 0 },
/* U+728c */ { 0, 0, 0, 0, 0 },
/* U+728d */ { 0, 0, 0, 0, 0 },
/* U+728e */ { 0, 0, 0, 0, 0 },
/* U+728f */ { 0, 0, 0, 0, 0 },
/* U+7290 */ { 0, 0, 0, 0, 0 },
/* U+7291 */ { 0, 0, 0, 0, 0 },
/* U+7292 */ { 0, 0, 0, 0, 0 },
/* U+7293 */ { 0, 0, 0, 0, 0 },
/* U+7294 */ { 0, 0, 0, 0, 0 },
/* U+7295 */ { 0, 0, 0, 0, 0 },
/* U+7296 */ { 0, 0, 0, 0, 0 },
/* U+7297 */ { 0, 0, 0, 0, 0 },
/* U+7298 */ { 0, 0, 0, 0, 0 },
/* U+7299 */ { 0, 0, 0, 0, 0 },
/* U+729a */ { 0, 0, 0, 0, 0 },
/* U+729b */ { 0, 0, 0, 0, 0 },
/* U+729c */ { 0, 0, 0, 0, 0 },
/* U+729d */ { 0, 0, 0, 0, 0 },
/* U+729e */ { 0, 0, 0, 0, 0 },
/* U+729f */ { 0, 0, 0, 0, 0 },
/* U+72a0 */ { 0, 0, 0, 0, 0 },
/* U+72a1 */ { 0, 0, 0, 0, 0 },
/* U+72a2 */ { 0, 0, 0, 0, 0 },
/* U+72a3 */ { 0, 0, 0, 0, 0 },
/* U+72a4 */ { 0, 0, 0, 0, 0 },
/* U+72a5 */ { 0, 0, 0, 0, 0 },
/* U+72a6 */ { 0, 0, 0, 0, 0 },
/* U+72a7 */ { 0, 0, 0, 0, 0 },
/* U+72a8 */ { 0, 0, 0, 0, 0 },
/* U+72a9 */ { 0, 0, 0, 0, 0 },
/* U+72aa */ { 0, 0, 0, 0, 0 },
/* U+72ab */ { 0, 0, 0, 0, 0 },
/* U+72ac */ { 0, 0, 0, 0, 0 },
/* U+72ad */ { 0, 0, 0, 0, 0 },
/* U+72ae */ { 0, 0, 0, 0, 0 },
/* U+72af */ { 0, 0, 0, 0, 0 },
/* U+72b0 */ { 0, 0, 0, 0, 0 },
/* U+72b1 */ { 0, 0, 0, 0, 0 },
/* U+72b2 */ { 0, 0, 0, 0, 0 },
/* U+72b3 */ { 0, 0, 0, 0, 0 },
/* U+72b4 */ { 0, 0, 0, 0, 0 },
/* U+72b5 */ { 0, 0, 0, 0, 0 },
/* U+72b6 */ { 0, 0, 0, 0, 0 },
/* U+72b7 */ { 0, 0, 0, 0, 0 },
/* U+72b8 */ { 0, 0, 0, 0, 0 },
/* U+72b9 */ { 0, 0, 0, 0, 0 },
/* U+72ba */ { 0, 0, 0, 0, 0 },
/* U+72bb */ { 0, 0, 0, 0, 0 },
/* U+72bc */ { 0, 0, 0, 0, 0 },
/* U+72bd */ { 0, 0, 0, 0, 0 },
/* U+72be */ { 0, 0, 0, 0, 0 },
/* U+72bf */ { 0, 0, 0, 0, 0 },
/* U+72c0 */ { 0, 0, 0, 0, 0 },
/* U+72c1 */ { 0, 0, 0, 0, 0 },
/* U+72c2 */ { 0, 0, 0, 0, 0 },
/* U+72c3 */ { 0, 0, 0, 0, 0 },
/* U+72c4 */ { 0, 0, 0, 0, 0 },
/* U+72c5 */ { 0, 0, 0, 0, 0 },
/* U+72c6 */ { 0, 0, 0, 0, 0 },
/* U+72c7 */ { 0, 0, 0, 0, 0 },
/* U+72c8 */ { 0, 0, 0, 0, 0 },
/* U+72c9 */ { 0, 0, 0, 0, 0 },
/* U+72ca */ { 0, 0, 0, 0, 0 },
/* U+72cb */ { 0, 0, 0, 0, 0 },
/* U+72cc */ { 0, 0, 0, 0, 0 },
/* U+72cd */ { 0, 0, 0, 0, 0 },
/* U+72ce */ { 0, 0, 0, 0, 0 },
/* U+72cf */ { 0, 0, 0, 0, 0 },
/* U+72d0 */ { 0, 0, 0, 0, 0 },
/* U+72d1 */ { 0, 0, 0, 0, 0 },
/* U+72d2 */ { 0, 0, 0, 0, 0 },
/* U+72d3 */ { 0, 0, 0, 0, 0 },
/* U+72d4 */ { 0, 0, 0, 0, 0 },
/* U+72d5 */ { 0, 0, 0, 0, 0 },
/* U+72d6 */ { 0, 0, 0, 0, 0 },
/* U+72d7 */ { 0, 0, 0, 0, 0 },
/* U+72d8 */ { 0, 0, 0, 0, 0 },
/* U+72d9 */ { 0, 0, 0, 0, 0 },
/* U+72da */ { 0, 0, 0, 0, 0 },
/* U+72db */ { 0, 0, 0, 0, 0 },
/* U+72dc */ { 0, 0, 0, 0, 0 },
/* U+72dd */ { 0, 0, 0, 0, 0 },
/* U+72de */ { 0, 0, 0, 0, 0 },
/* U+72df */ { 0, 0, 0, 0, 0 },
/* U+72e0 */ { 0, 0, 0, 0, 0 },
/* U+72e1 */ { 0, 0, 0, 0, 0 },
/* U+72e2 */ { 0, 0, 0, 0, 0 },
/* U+72e3 */ { 0, 0, 0, 0, 0 },
/* U+72e4 */ { 0, 0, 0, 0, 0 },
/* U+72e5 */ { 0, 0, 0, 0, 0 },
/* U+72e6 */ { 0, 0, 0, 0, 0 },
/* U+72e7 */ { 0, 0, 0, 0, 0 },
/* U+72e8 */ { 0, 0, 0, 0, 0 },
/* U+72e9 */ { 0, 0, 0, 0, 0 },
/* U+72ea */ { 0, 0, 0, 0, 0 },
/* U+72eb */ { 0, 0, 0, 0, 0 },
/* U+72ec */ { 0, 0, 0, 0, 0 },
/* U+72ed */ { 0, 0, 0, 0, 0 },
/* U+72ee */ { 0, 0, 0, 0, 0 },
/* U+72ef */ { 0, 0, 0, 0, 0 },
/* U+72f0 */ { 0, 0, 0, 0, 0 },
/* U+72f1 */ { 0, 0, 0, 0, 0 },
/* U+72f2 */ { 0, 0, 0, 0, 0 },
/* U+72f3 */ { 0, 0, 0, 0, 0 },
/* U+72f4 */ { 0, 0, 0, 0, 0 },
/* U+72f5 */ { 0, 0, 0, 0, 0 },
/* U+72f6 */ { 0, 0, 0, 0, 0 },
/* U+72f7 */ { 0, 0, 0, 0, 0 },
/* U+72f8 */ { 0, 0, 0, 0, 0 },
/* U+72f9 */ { 0, 0, 0, 0, 0 },
/* U+72fa */ { 0, 0, 0, 0, 0 },
/* U+72fb */ { 0, 0, 0, 0, 0 },
/* U+72fc */ { 0, 0, 0, 0, 0 },
/* U+72fd */ { 0, 0, 0, 0, 0 },
/* U+72fe */ { 0, 0, 0, 0, 0 },
/* U+72ff */ { 0, 0, 0, 0, 0 },
/* U+7300 */ { 0, 0, 0, 0, 0 },
/* U+7301 */ { 0, 0, 0, 0, 0 },
/* U+7302 */ { 0, 0, 0, 0, 0 },
/* U+7303 */ { 0, 0, 0, 0, 0 },
/* U+7304 */ { 0, 0, 0, 0, 0 },
/* U+7305 */ { 0, 0, 0, 0, 0 },
/* U+7306 */ { 0, 0, 0, 0, 0 },
/* U+7307 */ { 0, 0, 0, 0, 0 },
/* U+7308 */ { 0, 0, 0, 0, 0 },
/* U+7309 */ { 0, 0, 0, 0, 0 },
/* U+730a */ { 0, 0, 0, 0, 0 },
/* U+730b */ { 0, 0, 0, 0, 0 },
/* U+730c */ { 0, 0, 0, 0, 0 },
/* U+730d */ { 0, 0, 0, 0, 0 },
/* U+730e */ { 0, 0, 0, 0, 0 },
/* U+730f */ { 0, 0, 0, 0, 0 },
/* U+7310 */ { 0, 0, 0, 0, 0 },
/* U+7311 */ { 0, 0, 0, 0, 0 },
/* U+7312 */ { 0, 0, 0, 0, 0 },
/* U+7313 */ { 0, 0, 0, 0, 0 },
/* U+7314 */ { 0, 0, 0, 0, 0 },
/* U+7315 */ { 0, 0, 0, 0, 0 },
/* U+7316 */ { 0, 0, 0, 0, 0 },
/* U+7317 */ { 0, 0, 0, 0, 0 },
/* U+7318 */ { 0, 0, 0, 0, 0 },
/* U+7319 */ { 0, 0, 0, 0, 0 },
/* U+731a */ { 0, 0, 0, 0, 0 },
/* U+731b */ { 0, 0, 0, 0, 0 },
/* U+731c */ { 0, 0, 0, 0, 0 },
/* U+731d */ { 0, 0, 0, 0, 0 },
/* U+731e */ { 0, 0, 0, 0, 0 },
/* U+731f */ { 0, 0, 0, 0, 0 },
/* U+7320 */ { 0, 0, 0, 0, 0 },
/* U+7321 */ { 0, 0, 0, 0, 0 },
/* U+7322 */ { 0, 0, 0, 0, 0 },
/* U+7323 */ { 0, 0, 0, 0, 0 },
/* U+7324 */ { 0, 0, 0, 0, 0 },
/* U+7325 */ { 0, 0, 0, 0, 0 },
/* U+7326 */ { 0, 0, 0, 0, 0 },
/* U+7327 */ { 0, 0, 0, 0, 0 },
/* U+7328 */ { 0, 0, 0, 0, 0 },
/* U+7329 */ { 0, 0, 0, 0, 0 },
/* U+732a */ { 0, 0, 0, 0, 0 },
/* U+732b */ { 0, 0, 0, 0, 0 },
/* U+732c */ { 0, 0, 0, 0, 0 },
/* U+732d */ { 0, 0, 0, 0, 0 },
/* U+732e */ { 0, 0, 0, 0, 0 },
/* U+732f */ { 0, 0, 0, 0, 0 },
/* U+7330 */ { 0, 0, 0, 0, 0 },
/* U+7331 */ { 0, 0, 0, 0, 0 },
/* U+7332 */ { 0, 0, 0, 0, 0 },
/* U+7333 */ { 0, 0, 0, 0, 0 },
/* U+7334 */ { 0, 0, 0, 0, 0 },
/* U+7335 */ { 0, 0, 0, 0, 0 },
/* U+7336 */ { 0, 0, 0, 0, 0 },
/* U+7337 */ { 0, 0, 0, 0, 0 },
/* U+7338 */ { 0, 0, 0, 0, 0 },
/* U+7339 */ { 0, 0, 0, 0, 0 },
/* U+733a */ { 0, 0, 0, 0, 0 },
/* U+733b */ { 0, 0, 0, 0, 0 },
/* U+733c */ { 0, 0, 0, 0, 0 },
/* U+733d */ { 0, 0, 0, 0, 0 },
/* U+733e */ { 0, 0, 0, 0, 0 },
/* U+733f */ { 0, 0, 0, 0, 0 },
/* U+7340 */ { 0, 0, 0, 0, 0 },
/* U+7341 */ { 0, 0, 0, 0, 0 },
/* U+7342 */ { 0, 0, 0, 0, 0 },
/* U+7343 */ { 0, 0, 0, 0, 0 },
/* U+7344 */ { 0, 0, 0, 0, 0 },
/* U+7345 */ { 0, 0, 0, 0, 0 },
/* U+7346 */ { 0, 0, 0, 0, 0 },
/* U+7347 */ { 0, 0, 0, 0, 0 },
/* U+7348 */ { 0, 0, 0, 0, 0 },
/* U+7349 */ { 0, 0, 0, 0, 0 },
/* U+734a */ { 0, 0, 0, 0, 0 },
/* U+734b */ { 0, 0, 0, 0, 0 },
/* U+734c */ { 0, 0, 0, 0, 0 },
/* U+734d */ { 0, 0, 0, 0, 0 },
/* U+734e */ { 0, 0, 0, 0, 0 },
/* U+734f */ { 0, 0, 0, 0, 0 },
/* U+7350 */ { 0, 0, 0, 0, 0 },
/* U+7351 */ { 0, 0, 0, 0, 0 },
/* U+7352 */ { 0, 0, 0, 0, 0 },
/* U+7353 */ { 0, 0, 0, 0, 0 },
/* U+7354 */ { 0, 0, 0, 0, 0 },
/* U+7355 */ { 0, 0, 0, 0, 0 },
/* U+7356 */ { 0, 0, 0, 0, 0 },
/* U+7357 */ { 0, 0, 0, 0, 0 },
/* U+7358 */ { 0, 0, 0, 0, 0 },
/* U+7359 */ { 0, 0, 0, 0, 0 },
/* U+735a */ { 0, 0, 0, 0, 0 },
/* U+735b */ { 0, 0, 0, 0, 0 },
/* U+735c */ { 0, 0, 0, 0, 0 },
/* U+735d */ { 0, 0, 0, 0, 0 },
/* U+735e */ { 0, 0, 0, 0, 0 },
/* U+735f */ { 0, 0, 0, 0, 0 },
/* U+7360 */ { 0, 0, 0, 0, 0 },
/* U+7361 */ { 0, 0, 0, 0, 0 },
/* U+7362 */ { 0, 0, 0, 0, 0 },
/* U+7363 */ { 0, 0, 0, 0, 0 },
/* U+7364 */ { 0, 0, 0, 0, 0 },
/* U+7365 */ { 0, 0, 0, 0, 0 },
/* U+7366 */ { 0, 0, 0, 0, 0 },
/* U+7367 */ { 0, 0, 0, 0, 0 },
/* U+7368 */ { 0, 0, 0, 0, 0 },
/* U+7369 */ { 0, 0, 0, 0, 0 },
/* U+736a */ { 0, 0, 0, 0, 0 },
/* U+736b */ { 0, 0, 0, 0, 0 },
/* U+736c */ { 0, 0, 0, 0, 0 },
/* U+736d */ { 0, 0, 0, 0, 0 },
/* U+736e */ { 0, 0, 0, 0, 0 },
/* U+736f */ { 0, 0, 0, 0, 0 },
/* U+7370 */ { 0, 0, 0, 0, 0 },
/* U+7371 */ { 0, 0, 0, 0, 0 },
/* U+7372 */ { 0, 0, 0, 0, 0 },
/* U+7373 */ { 0, 0, 0, 0, 0 },
/* U+7374 */ { 0, 0, 0, 0, 0 },
/* U+7375 */ { 0, 0, 0, 0, 0 },
/* U+7376 */ { 0, 0, 0, 0, 0 },
/* U+7377 */ { 0, 0, 0, 0, 0 },
/* U+7378 */ { 0, 0, 0, 0, 0 },
/* U+7379 */ { 0, 0, 0, 0, 0 },
/* U+737a */ { 0, 0, 0, 0, 0 },
/* U+737b */ { 0, 0, 0, 0, 0 },
/* U+737c */ { 0, 0, 0, 0, 0 },
/* U+737d */ { 0, 0, 0, 0, 0 },
/* U+737e */ { 0, 0, 0, 0, 0 },
/* U+737f */ { 0, 0, 0, 0, 0 },
/* U+7380 */ { 0, 0, 0, 0, 0 },
/* U+7381 */ { 0, 0, 0, 0, 0 },
/* U+7382 */ { 0, 0, 0, 0, 0 },
/* U+7383 */ { 0, 0, 0, 0, 0 },
/* U+7384 */ { 0, 0, 0, 0, 0 },
/* U+7385 */ { 0, 0, 0, 0, 0 },
/* U+7386 */ { 0, 0, 0, 0, 0 },
/* U+7387 */ { 0, 0, 0, 0, 0 },
/* U+7388 */ { 0, 0, 0, 0, 0 },
/* U+7389 */ { 0, 0, 0, 0, 0 },
/* U+738a */ { 0, 0, 0, 0, 0 },
/* U+738b */ { 0, 0, 0, 0, 0 },
/* U+738c */ { 0, 0, 0, 0, 0 },
/* U+738d */ { 0, 0, 0, 0, 0 },
/* U+738e */ { 0, 0, 0, 0, 0 },
/* U+738f */ { 0, 0, 0, 0, 0 },
/* U+7390 */ { 0, 0, 0, 0, 0 },
/* U+7391 */ { 0, 0, 0, 0, 0 },
/* U+7392 */ { 0, 0, 0, 0, 0 },
/* U+7393 */ { 0, 0, 0, 0, 0 },
/* U+7394 */ { 0, 0, 0, 0, 0 },
/* U+7395 */ { 0, 0, 0, 0, 0 },
/* U+7396 */ { 0, 0, 0, 0, 0 },
/* U+7397 */ { 0, 0, 0, 0, 0 },
/* U+7398 */ { 0, 0, 0, 0, 0 },
/* U+7399 */ { 0, 0, 0, 0, 0 },
/* U+739a */ { 0, 0, 0, 0, 0 },
/* U+739b */ { 0, 0, 0, 0, 0 },
/* U+739c */ { 0, 0, 0, 0, 0 },
/* U+739d */ { 0, 0, 0, 0, 0 },
/* U+739e */ { 0, 0, 0, 0, 0 },
/* U+739f */ { 0, 0, 0, 0, 0 },
/* U+73a0 */ { 0, 0, 0, 0, 0 },
/* U+73a1 */ { 0, 0, 0, 0, 0 },
/* U+73a2 */ { 0, 0, 0, 0, 0 },
/* U+73a3 */ { 0, 0, 0, 0, 0 },
/* U+73a4 */ { 0, 0, 0, 0, 0 },
/* U+73a5 */ { 0, 0, 0, 0, 0 },
/* U+73a6 */ { 0, 0, 0, 0, 0 },
/* U+73a7 */ { 0, 0, 0, 0, 0 },
/* U+73a8 */ { 0, 0, 0, 0, 0 },
/* U+73a9 */ { 0, 0, 0, 0, 0 },
/* U+73aa */ { 0, 0, 0, 0, 0 },
/* U+73ab */ { 0, 0, 0, 0, 0 },
/* U+73ac */ { 0, 0, 0, 0, 0 },
/* U+73ad */ { 0, 0, 0, 0, 0 },
/* U+73ae */ { 0, 0, 0, 0, 0 },
/* U+73af */ { 0, 0, 0, 0, 0 },
/* U+73b0 */ { 0, 0, 0, 0, 0 },
/* U+73b1 */ { 0, 0, 0, 0, 0 },
/* U+73b2 */ { 0, 0, 0, 0, 0 },
/* U+73b3 */ { 0, 0, 0, 0, 0 },
/* U+73b4 */ { 0, 0, 0, 0, 0 },
/* U+73b5 */ { 0, 0, 0, 0, 0 },
/* U+73b6 */ { 0, 0, 0, 0, 0 },
/* U+73b7 */ { 0, 0, 0, 0, 0 },
/* U+73b8 */ { 0, 0, 0, 0, 0 },
/* U+73b9 */ { 0, 0, 0, 0, 0 },
/* U+73ba */ { 0, 0, 0, 0, 0 },
/* U+73bb */ { 0, 0, 0, 0, 0 },
/* U+73bc */ { 0, 0, 0, 0, 0 },
/* U+73bd */ { 0, 0, 0, 0, 0 },
/* U+73be */ { 0, 0, 0, 0, 0 },
/* U+73bf */ { 0, 0, 0, 0, 0 },
/* U+73c0 */ { 0, 0, 0, 0, 0 },
/* U+73c1 */ { 0, 0, 0, 0, 0 },
/* U+73c2 */ { 0, 0, 0, 0, 0 },
/* U+73c3 */ { 0, 0, 0, 0, 0 },
/* U+73c4 */ { 0, 0, 0, 0, 0 },
/* U+73c5 */ { 0, 0, 0, 0, 0 },
/* U+73c6 */ { 0, 0, 0, 0, 0 },
/* U+73c7 */ { 0, 0, 0, 0, 0 },
/* U+73c8 */ { 0, 0, 0, 0, 0 },
/* U+73c9 */ { 0, 0, 0, 0, 0 },
/* U+73ca */ { 0, 0, 0, 0, 0 },
/* U+73cb */ { 0, 0, 0, 0, 0 },
/* U+73cc */ { 0, 0, 0, 0, 0 },
/* U+73cd */ { 0, 0, 0, 0, 0 },
/* U+73ce */ { 0, 0, 0, 0, 0 },
/* U+73cf */ { 0, 0, 0, 0, 0 },
/* U+73d0 */ { 0, 0, 0, 0, 0 },
/* U+73d1 */ { 0, 0, 0, 0, 0 },
/* U+73d2 */ { 0, 0, 0, 0, 0 },
/* U+73d3 */ { 0, 0, 0, 0, 0 },
/* U+73d4 */ { 0, 0, 0, 0, 0 },
/* U+73d5 */ { 0, 0, 0, 0, 0 },
/* U+73d6 */ { 0, 0, 0, 0, 0 },
/* U+73d7 */ { 0, 0, 0, 0, 0 },
/* U+73d8 */ { 0, 0, 0, 0, 0 },
/* U+73d9 */ { 0, 0, 0, 0, 0 },
/* U+73da */ { 0, 0, 0, 0, 0 },
/* U+73db */ { 0, 0, 0, 0, 0 },
/* U+73dc */ { 0, 0, 0, 0, 0 },
/* U+73dd */ { 0, 0, 0, 0, 0 },
/* U+73de */ { 0, 0, 0, 0, 0 },
/* U+73df */ { 0, 0, 0, 0, 0 },
/* U+73e0 */ { 0, 0, 0, 0, 0 },
/* U+73e1 */ { 0, 0, 0, 0, 0 },
/* U+73e2 */ { 0, 0, 0, 0, 0 },
/* U+73e3 */ { 0, 0, 0, 0, 0 },
/* U+73e4 */ { 0, 0, 0, 0, 0 },
/* U+73e5 */ { 0, 0, 0, 0, 0 },
/* U+73e6 */ { 0, 0, 0, 0, 0 },
/* U+73e7 */ { 0, 0, 0, 0, 0 },
/* U+73e8 */ { 0, 0, 0, 0, 0 },
/* U+73e9 */ { 0, 0, 0, 0, 0 },
/* U+73ea */ { 0, 0, 0, 0, 0 },
/* U+73eb */ { 0, 0, 0, 0, 0 },
/* U+73ec */ { 0, 0, 0, 0, 0 },
/* U+73ed */ { 0, 0, 0, 0, 0 },
/* U+73ee */ { 0, 0, 0, 0, 0 },
/* U+73ef */ { 0, 0, 0, 0, 0 },
/* U+73f0 */ { 0, 0, 0, 0, 0 },
/* U+73f1 */ { 0, 0, 0, 0, 0 },
/* U+73f2 */ { 0, 0, 0, 0, 0 },
/* U+73f3 */ { 0, 0, 0, 0, 0 },
/* U+73f4 */ { 0, 0, 0, 0, 0 },
/* U+73f5 */ { 0, 0, 0, 0, 0 },
/* U+73f6 */ { 0, 0, 0, 0, 0 },
/* U+73f7 */ { 0, 0, 0, 0, 0 },
/* U+73f8 */ { 0, 0, 0, 0, 0 },
/* U+73f9 */ { 0, 0, 0, 0, 0 },
/* U+73fa */ { 0, 0, 0, 0, 0 },
/* U+73fb */ { 0, 0, 0, 0, 0 },
/* U+73fc */ { 0, 0, 0, 0, 0 },
/* U+73fd */ { 0, 0, 0, 0, 0 },
/* U+73fe */ { 0, 0, 0, 0, 0 },
/* U+73ff */ { 0, 0, 0, 0, 0 },
/* U+7400 */ { 0, 0, 0, 0, 0 },
/* U+7401 */ { 0, 0, 0, 0, 0 },
/* U+7402 */ { 0, 0, 0, 0, 0 },
/* U+7403 */ { 0, 0, 0, 0, 0 },
/* U+7404 */ { 0, 0, 0, 0, 0 },
/* U+7405 */ { 0, 0, 0, 0, 0 },
/* U+7406 */ { 0, 0, 0, 0, 0 },
/* U+7407 */ { 0, 0, 0, 0, 0 },
/* U+7408 */ { 0, 0, 0, 0, 0 },
/* U+7409 */ { 0, 0, 0, 0, 0 },
/* U+740a */ { 0, 0, 0, 0, 0 },
/* U+740b */ { 0, 0, 0, 0, 0 },
/* U+740c */ { 0, 0, 0, 0, 0 },
/* U+740d */ { 0, 0, 0, 0, 0 },
/* U+740e */ { 0, 0, 0, 0, 0 },
/* U+740f */ { 0, 0, 0, 0, 0 },
/* U+7410 */ { 0, 0, 0, 0, 0 },
/* U+7411 */ { 0, 0, 0, 0, 0 },
/* U+7412 */ { 0, 0, 0, 0, 0 },
/* U+7413 */ { 0, 0, 0, 0, 0 },
/* U+7414 */ { 0, 0, 0, 0, 0 },
/* U+7415 */ { 0, 0, 0, 0, 0 },
/* U+7416 */ { 0, 0, 0, 0, 0 },
/* U+7417 */ { 0, 0, 0, 0, 0 },
/* U+7418 */ { 0, 0, 0, 0, 0 },
/* U+7419 */ { 0, 0, 0, 0, 0 },
/* U+741a */ { 0, 0, 0, 0, 0 },
/* U+741b */ { 0, 0, 0, 0, 0 },
/* U+741c */ { 0, 0, 0, 0, 0 },
/* U+741d */ { 0, 0, 0, 0, 0 },
/* U+741e */ { 0, 0, 0, 0, 0 },
/* U+741f */ { 0, 0, 0, 0, 0 },
/* U+7420 */ { 0, 0, 0, 0, 0 },
/* U+7421 */ { 0, 0, 0, 0, 0 },
/* U+7422 */ { 0, 0, 0, 0, 0 },
/* U+7423 */ { 0, 0, 0, 0, 0 },
/* U+7424 */ { 0, 0, 0, 0, 0 },
/* U+7425 */ { 0, 0, 0, 0, 0 },
/* U+7426 */ { 0, 0, 0, 0, 0 },
/* U+7427 */ { 0, 0, 0, 0, 0 },
/* U+7428 */ { 0, 0, 0, 0, 0 },
/* U+7429 */ { 0, 0, 0, 0, 0 },
/* U+742a */ { 0, 0, 0, 0, 0 },
/* U+742b */ { 0, 0, 0, 0, 0 },
/* U+742c */ { 0, 0, 0, 0, 0 },
/* U+742d */ { 0, 0, 0, 0, 0 },
/* U+742e */ { 0, 0, 0, 0, 0 },
/* U+742f */ { 0, 0, 0, 0, 0 },
/* U+7430 */ { 0, 0, 0, 0, 0 },
/* U+7431 */ { 0, 0, 0, 0, 0 },
/* U+7432 */ { 0, 0, 0, 0, 0 },
/* U+7433 */ { 0, 0, 0, 0, 0 },
/* U+7434 */ { 0, 0, 0, 0, 0 },
/* U+7435 */ { 0, 0, 0, 0, 0 },
/* U+7436 */ { 0, 0, 0, 0, 0 },
/* U+7437 */ { 0, 0, 0, 0, 0 },
/* U+7438 */ { 0, 0, 0, 0, 0 },
/* U+7439 */ { 0, 0, 0, 0, 0 },
/* U+743a */ { 0, 0, 0, 0, 0 },
/* U+743b */ { 0, 0, 0, 0, 0 },
/* U+743c */ { 0, 0, 0, 0, 0 },
/* U+743d */ { 0, 0, 0, 0, 0 },
/* U+743e */ { 0, 0, 0, 0, 0 },
/* U+743f */ { 0, 0, 0, 0, 0 },
/* U+7440 */ { 0, 0, 0, 0, 0 },
/* U+7441 */ { 0, 0, 0, 0, 0 },
/* U+7442 */ { 0, 0, 0, 0, 0 },
/* U+7443 */ { 0, 0, 0, 0, 0 },
/* U+7444 */ { 0, 0, 0, 0, 0 },
/* U+7445 */ { 0, 0, 0, 0, 0 },
/* U+7446 */ { 0, 0, 0, 0, 0 },
/* U+7447 */ { 0, 0, 0, 0, 0 },
/* U+7448 */ { 0, 0, 0, 0, 0 },
/* U+7449 */ { 0, 0, 0, 0, 0 },
/* U+744a */ { 0, 0, 0, 0, 0 },
/* U+744b */ { 0, 0, 0, 0, 0 },
/* U+744c */ { 0, 0, 0, 0, 0 },
/* U+744d */ { 0, 0, 0, 0, 0 },
/* U+744e */ { 0, 0, 0, 0, 0 },
/* U+744f */ { 0, 0, 0, 0, 0 },
/* U+7450 */ { 0, 0, 0, 0, 0 },
/* U+7451 */ { 0, 0, 0, 0, 0 },
/* U+7452 */ { 0, 0, 0, 0, 0 },
/* U+7453 */ { 0, 0, 0, 0, 0 },
/* U+7454 */ { 0, 0, 0, 0, 0 },
/* U+7455 */ { 0, 0, 0, 0, 0 },
/* U+7456 */ { 0, 0, 0, 0, 0 },
/* U+7457 */ { 0, 0, 0, 0, 0 },
/* U+7458 */ { 0, 0, 0, 0, 0 },
/* U+7459 */ { 0, 0, 0, 0, 0 },
/* U+745a */ { 0, 0, 0, 0, 0 },
/* U+745b */ { 0, 0, 0, 0, 0 },
/* U+745c */ { 0, 0, 0, 0, 0 },
/* U+745d */ { 0, 0, 0, 0, 0 },
/* U+745e */ { 0, 0, 0, 0, 0 },
/* U+745f */ { 0, 0, 0, 0, 0 },
/* U+7460 */ { 0, 0, 0, 0, 0 },
/* U+7461 */ { 0, 0, 0, 0, 0 },
/* U+7462 */ { 0, 0, 0, 0, 0 },
/* U+7463 */ { 0, 0, 0, 0, 0 },
/* U+7464 */ { 0, 0, 0, 0, 0 },
/* U+7465 */ { 0, 0, 0, 0, 0 },
/* U+7466 */ { 0, 0, 0, 0, 0 },
/* U+7467 */ { 0, 0, 0, 0, 0 },
/* U+7468 */ { 0, 0, 0, 0, 0 },
/* U+7469 */ { 0, 0, 0, 0, 0 },
/* U+746a */ { 0, 0, 0, 0, 0 },
/* U+746b */ { 0, 0, 0, 0, 0 },
/* U+746c */ { 0, 0, 0, 0, 0 },
/* U+746d */ { 0, 0, 0, 0, 0 },
/* U+746e */ { 0, 0, 0, 0, 0 },
/* U+746f */ { 0, 0, 0, 0, 0 },
/* U+7470 */ { 0, 0, 0, 0, 0 },
/* U+7471 */ { 0, 0, 0, 0, 0 },
/* U+7472 */ { 0, 0, 0, 0, 0 },
/* U+7473 */ { 0, 0, 0, 0, 0 },
/* U+7474 */ { 0, 0, 0, 0, 0 },
/* U+7475 */ { 0, 0, 0, 0, 0 },
/* U+7476 */ { 0, 0, 0, 0, 0 },
/* U+7477 */ { 0, 0, 0, 0, 0 },
/* U+7478 */ { 0, 0, 0, 0, 0 },
/* U+7479 */ { 0, 0, 0, 0, 0 },
/* U+747a */ { 0, 0, 0, 0, 0 },
/* U+747b */ { 0, 0, 0, 0, 0 },
/* U+747c */ { 0, 0, 0, 0, 0 },
/* U+747d */ { 0, 0, 0, 0, 0 },
/* U+747e */ { 0, 0, 0, 0, 0 },
/* U+747f */ { 0, 0, 0, 0, 0 },
/* U+7480 */ { 0, 0, 0, 0, 0 },
/* U+7481 */ { 0, 0, 0, 0, 0 },
/* U+7482 */ { 0, 0, 0, 0, 0 },
/* U+7483 */ { 0, 0, 0, 0, 0 },
/* U+7484 */ { 0, 0, 0, 0, 0 },
/* U+7485 */ { 0, 0, 0, 0, 0 },
/* U+7486 */ { 0, 0, 0, 0, 0 },
/* U+7487 */ { 0, 0, 0, 0, 0 },
/* U+7488 */ { 0, 0, 0, 0, 0 },
/* U+7489 */ { 0, 0, 0, 0, 0 },
/* U+748a */ { 0, 0, 0, 0, 0 },
/* U+748b */ { 0, 0, 0, 0, 0 },
/* U+748c */ { 0, 0, 0, 0, 0 },
/* U+748d */ { 0, 0, 0, 0, 0 },
/* U+748e */ { 0, 0, 0, 0, 0 },
/* U+748f */ { 0, 0, 0, 0, 0 },
/* U+7490 */ { 0, 0, 0, 0, 0 },
/* U+7491 */ { 0, 0, 0, 0, 0 },
/* U+7492 */ { 0, 0, 0, 0, 0 },
/* U+7493 */ { 0, 0, 0, 0, 0 },
/* U+7494 */ { 0, 0, 0, 0, 0 },
/* U+7495 */ { 0, 0, 0, 0, 0 },
/* U+7496 */ { 0, 0, 0, 0, 0 },
/* U+7497 */ { 0, 0, 0, 0, 0 },
/* U+7498 */ { 0, 0, 0, 0, 0 },
/* U+7499 */ { 0, 0, 0, 0, 0 },
/* U+749a */ { 0, 0, 0, 0, 0 },
/* U+749b */ { 0, 0, 0, 0, 0 },
/* U+749c */ { 0, 0, 0, 0, 0 },
/* U+749d */ { 0, 0, 0, 0, 0 },
/* U+749e */ { 0, 0, 0, 0, 0 },
/* U+749f */ { 0, 0, 0, 0, 0 },
/* U+74a0 */ { 0, 0, 0, 0, 0 },
/* U+74a1 */ { 0, 0, 0, 0, 0 },
/* U+74a2 */ { 0, 0, 0, 0, 0 },
/* U+74a3 */ { 0, 0, 0, 0, 0 },
/* U+74a4 */ { 0, 0, 0, 0, 0 },
/* U+74a5 */ { 0, 0, 0, 0, 0 },
/* U+74a6 */ { 0, 0, 0, 0, 0 },
/* U+74a7 */ { 0, 0, 0, 0, 0 },
/* U+74a8 */ { 0, 0, 0, 0, 0 },
/* U+74a9 */ { 0, 0, 0, 0, 0 },
/* U+74aa */ { 0, 0, 0, 0, 0 },
/* U+74ab */ { 0, 0, 0, 0, 0 },
/* U+74ac */ { 0, 0, 0, 0, 0 },
/* U+74ad */ { 0, 0, 0, 0, 0 },
/* U+74ae */ { 0, 0, 0, 0, 0 },
/* U+74af */ { 0, 0, 0, 0, 0 },
/* U+74b0 */ { 0, 0, 0, 0, 0 },
/* U+74b1 */ { 0, 0, 0, 0, 0 },
/* U+74b2 */ { 0, 0, 0, 0, 0 },
/* U+74b3 */ { 0, 0, 0, 0, 0 },
/* U+74b4 */ { 0, 0, 0, 0, 0 },
/* U+74b5 */ { 0, 0, 0, 0, 0 },
/* U+74b6 */ { 0, 0, 0, 0, 0 },
/* U+74b7 */ { 0, 0, 0, 0, 0 },
/* U+74b8 */ { 0, 0, 0, 0, 0 },
/* U+74b9 */ { 0, 0, 0, 0, 0 },
/* U+74ba */ { 0, 0, 0, 0, 0 },
/* U+74bb */ { 0, 0, 0, 0, 0 },
/* U+74bc */ { 0, 0, 0, 0, 0 },
/* U+74bd */ { 0, 0, 0, 0, 0 },
/* U+74be */ { 0, 0, 0, 0, 0 },
/* U+74bf */ { 0, 0, 0, 0, 0 },
/* U+74c0 */ { 0, 0, 0, 0, 0 },
/* U+74c1 */ { 0, 0, 0, 0, 0 },
/* U+74c2 */ { 0, 0, 0, 0, 0 },
/* U+74c3 */ { 0, 0, 0, 0, 0 },
/* U+74c4 */ { 0, 0, 0, 0, 0 },
/* U+74c5 */ { 0, 0, 0, 0, 0 },
/* U+74c6 */ { 0, 0, 0, 0, 0 },
/* U+74c7 */ { 0, 0, 0, 0, 0 },
/* U+74c8 */ { 0, 0, 0, 0, 0 },
/* U+74c9 */ { 0, 0, 0, 0, 0 },
/* U+74ca */ { 0, 0, 0, 0, 0 },
/* U+74cb */ { 0, 0, 0, 0, 0 },
/* U+74cc */ { 0, 0, 0, 0, 0 },
/* U+74cd */ { 0, 0, 0, 0, 0 },
/* U+74ce */ { 0, 0, 0, 0, 0 },
/* U+74cf */ { 0, 0, 0, 0, 0 },
/* U+74d0 */ { 0, 0, 0, 0, 0 },
/* U+74d1 */ { 0, 0, 0, 0, 0 },
/* U+74d2 */ { 0, 0, 0, 0, 0 },
/* U+74d3 */ { 0, 0, 0, 0, 0 },
/* U+74d4 */ { 0, 0, 0, 0, 0 },
/* U+74d5 */ { 0, 0, 0, 0, 0 },
/* U+74d6 */ { 0, 0, 0, 0, 0 },
/* U+74d7 */ { 0, 0, 0, 0, 0 },
/* U+74d8 */ { 0, 0, 0, 0, 0 },
/* U+74d9 */ { 0, 0, 0, 0, 0 },
/* U+74da */ { 0, 0, 0, 0, 0 },
/* U+74db */ { 0, 0, 0, 0, 0 },
/* U+74dc */ { 0, 0, 0, 0, 0 },
/* U+74dd */ { 0, 0, 0, 0, 0 },
/* U+74de */ { 0, 0, 0, 0, 0 },
/* U+74df */ { 0, 0, 0, 0, 0 },
/* U+74e0 */ { 0, 0, 0, 0, 0 },
/* U+74e1 */ { 0, 0, 0, 0, 0 },
/* U+74e2 */ { 0, 0, 0, 0, 0 },
/* U+74e3 */ { 0, 0, 0, 0, 0 },
/* U+74e4 */ { 0, 0, 0, 0, 0 },
/* U+74e5 */ { 0, 0, 0, 0, 0 },
/* U+74e6 */ { 0, 0, 0, 0, 0 },
/* U+74e7 */ { 0, 0, 0, 0, 0 },
/* U+74e8 */ { 0, 0, 0, 0, 0 },
/* U+74e9 */ { 0, 0, 0, 0, 0 },
/* U+74ea */ { 0, 0, 0, 0, 0 },
/* U+74eb */ { 0, 0, 0, 0, 0 },
/* U+74ec */ { 0, 0, 0, 0, 0 },
/* U+74ed */ { 0, 0, 0, 0, 0 },
/* U+74ee */ { 0, 0, 0, 0, 0 },
/* U+74ef */ { 0, 0, 0, 0, 0 },
/* U+74f0 */ { 0, 0, 0, 0, 0 },
/* U+74f1 */ { 0, 0, 0, 0, 0 },
/* U+74