//This code is copyright 1994-1997 by James C. Ahlstrom.  See the
//copyright notice in "copyrite.jim" or e-mail jim@interet.com.
// NO WARRANTIES AT ALL.  USE AT YOUR OWN RISK.

/***********************************************************

******************************************************************/

/* nspimodu.cpp -- module for interface into Netscape plugin */

#include "stdafx.h"
#include "npapi.h"
#include "npupp.h"

#define GETINST long inst;\
		if (!GetAttrLong(instance, "wpyphysInstance", &inst)) {\
			PyErr_SetString(PyExc_NameError, "self is not a valid application");\
			return NULL;\
		}

static NPStream * pWindowStream;	// Used to send data to the current window

extern "C" static PyObject * nspi_module_error;

extern "C" static PyObject *
GetURL(PyObject *self, PyObject *args)
{	// Call with window = "" to get a call with window = 0L
	PyObject * instance;
	char *url, *window;
	if (!PyArg_Parse (args, "(Oss)", &instance, &url, &window))
		return NULL;
	GETINST
	NPError ret;
	if (*window)
		ret = NPN_GetURL((NPP)inst, url, window);
	else
		ret = NPN_GetURL((NPP)inst, url, 0L);
	PyObject * pyret = Py_BuildValue("l", (long)ret);
	return pyret;
}

extern "C" static PyObject *
PostURL(PyObject *self, PyObject *args)
{
	PyObject * instance, * pybuf;
	long len, file;
	char *url, *window, *buf;
	if (!PyArg_Parse (args, "(OssOl)", &instance, &url, &window, &pybuf, &file))
		return NULL;
	len = PyString_Size(pybuf);
	buf = PyString_AsString(pybuf);
	GETINST
	NPError ret = NPN_PostURL((NPP)inst, url, window, len, buf, (NPBool)file);
	PyObject * pyret = Py_BuildValue("l", (long)ret);
	return pyret;
}

extern "C" static PyObject *
NewStream(PyObject *self, PyObject *args)
{
	PyObject * instance;
	char *type;
	if (!PyArg_Parse (args, "(Os)", &instance, &type))
		return NULL;
	GETINST
        NPError ret;
	NPStream * pWindowStream = (NPStream *)NPN_MemAlloc(sizeof(NPStream));
	if (pWindowStream){
		pWindowStream->pdata = 0;
		pWindowStream->ndata = 0;
		pWindowStream->url = 0;
		pWindowStream->end = 0;
		pWindowStream->lastmodified = 0;
		ret = NPN_NewStream((NPP)inst, type, pWindowStream);
	}
	else {
		ret = NPERR_OUT_OF_MEMORY_ERROR;
	}
	PyObject * pyret = Py_BuildValue("l", (long)ret);
	return pyret;
}

extern "C" static PyObject *
Write(PyObject *self, PyObject *args)
{
	PyObject * instance, * pybuf;
	if (!PyArg_Parse (args, "(OO)", &instance, &pybuf))
		return NULL;
	GETINST
	long len = PyString_Size(pybuf);
	char * buf = PyString_AsString(pybuf);
	long ret = NPN_Write((NPP)inst, pWindowStream, len, buf);
	PyObject * pyret = Py_BuildValue("l", ret);
	return pyret;
}

extern "C" static PyObject *
DestroyStream(PyObject *self, PyObject *args)
{
	PyObject * instance;
	long reason;
	if (!PyArg_Parse (args, "(Ol)", &instance, &reason))
		return NULL;
	GETINST
	NPError ret = NPN_DestroyStream((NPP)inst, pWindowStream, (NPError)reason);
	PyObject * pyret = Py_BuildValue("l", (long)ret);
	NPN_MemFree(pWindowStream);
	pWindowStream = 0;
	return pyret;
}

extern "C" static PyObject *
Status(PyObject *self, PyObject *args)
{
	PyObject * instance;
	char * message;
	if (!PyArg_Parse (args, "(Os)", &instance, &message))
		return NULL;
	GETINST
	NPN_Status((NPP)inst, message);
	Py_INCREF(Py_None);
	return Py_None;
}

/* List of functions exported by this module */
extern "C" static struct PyMethodDef nspi_functions[] = {
	{"NPN_GetURL",			GetURL},
	{"NPN_PostURL",			PostURL},
	//{"NPN_RequestRead",	RequestRead},
	{"NPN_NewStream",		NewStream},
	{"NPN_Write",			Write},
	{"NPN_DestroyStream",	DestroyStream},
	{"NPN_Status",			Status},
	{NULL,			NULL}		 /* Sentinel */
};


extern "C" void
initnspi(void)
{
  PyObject *dict, *module, *obj;
  module = Py_InitModule("nspi", nspi_functions);
  dict = PyModule_GetDict(module);
  nspi_module_error = PyString_FromString("nspi error");
  PyDict_SetItemString(dict, "error", nspi_module_error);
  obj = PyString_FromString("0.44");
  PyDict_SetItemString(dict, "__version__", obj);
}
