//::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
//
// npshell.cpp
//
//::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

#include "stdafx.h"
#include "app.h"
#include "view.h"

#ifndef _NPAPI_H_
#include "npapi.h"
#endif

extern "C" void initwpy_nt();
extern "C" void initnspi();

//
// Instance state information about the plugin.
//
// *Developers*: Use this struct to hold per-instance
//               information that you'll need in the
//               various functions in this file.
//

static int okWarning = 0;	// 0: give warning, put result in okWarning

typedef struct _PluginInstance
{
    NPWindow*       fWindow;			// Netscape window for this instance
	PyObject*		argDict;			// Store argn[] and argv[]
	PyObject*		pluginType;			// Store type
	PyObject*		pythonApp;			// Python app instance corresponding to instance
	CWpythonView*	pView;				// Python view class object
    NPSavedData*    pSavedInstanceData;	// Python can return a string to save
	uint32			x;					// Current window size and location
	uint32			y;
	uint32			width;
	uint32			height;
    uint16          fMode;				// mode is NP_EMBED, NP_FULL, or NP_BACKGROUND (see npapi.h)
} PluginInstance;

typedef struct _StreamInstance
{
	PyObject*		pyStream;			// Python object instance representing the stream
	int				isAppStream;			// TRUE if stream is the application file
} StreamInstance;

//----------------------------------------------------------------------------
// NPP_Initialize:
//----------------------------------------------------------------------------
NPError NPP_Initialize(void)
{
	    // do your one time initialization here, such as dynamically loading
	    // dependant DLLs
	TRACE0("NPP_Initialize\r\n");
   	return NPERR_NO_ERROR;
}


//----------------------------------------------------------------------------
// NPP_Shutdown:
//----------------------------------------------------------------------------
void NPP_Shutdown(void)
{
    // do your one time uninitialization here, such as unloading dynamically
    // loaded DLLs
	TRACE0("NPP_Shutdown\r\n");
}


//----------------------------------------------------------------------------
// NPP_New:
//----------------------------------------------------------------------------
NPError NP_LOADDS
NPP_New(NPMIMEType pluginType,
                NPP instance,
                uint16 mode,
                int16 argc,
                char* argn[],
                char* argv[],
                NPSavedData* saved)
{
	TRACE("NPP_New: type=%s\r\n", pluginType);
    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;
        
    instance->pdata = NPN_MemAlloc(sizeof(PluginInstance));
    PluginInstance* This = (PluginInstance*) instance->pdata;
    if (This == NULL)
        return NPERR_OUT_OF_MEMORY_ERROR;
    //
    // *Developers*: Initialize fields of your plugin
    // instance data here.  If the NPSavedData is non-
    // NULL, you can use that data (returned by you from
    // NPP_Destroy to set up the new plugin instance.
    //
        
    This->fWindow = NULL;
    This->fMode = mode;
	This->pluginType = PyString_FromString(pluginType);
    This->pSavedInstanceData = saved;
    This->pythonApp = NULL;
	This->x = This->y = This->width = This->height = 0;

	PyObject * dict = This->argDict = PyDict_New();
	PyObject * value;
	int16 i;
	// NP_FULL has argc == 1 and garbage in argn/argv !!!
	if (mode == NP_EMBED) for (i = 0; i < argc; i++){
		value = PyString_FromString(argv[i]);
		PyDict_SetItemString(dict, argn[i], value);
	}
		
    return NPERR_NO_ERROR;
}


//-----------------------------------------------------------------------------
// NPP_Destroy:
//-----------------------------------------------------------------------------
NPError NP_LOADDS
NPP_Destroy(NPP instance, NPSavedData** save)
{
	TRACE0("NPP_Destroy\r\n");
    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;

    PluginInstance* This = (PluginInstance*) instance->pdata;

    //
    // *Developers*: If desired, call NP_MemAlloc to create a
    // NPSavedDate structure containing any state information
    // that you want restored if this plugin instance is later
    // recreated.
    //

 	ASSERT(*save == NULL);

    if (This != NULL)
    {
		PyObject * pyobj;
		if (This->pythonApp){
			PyObject * args = Py_BuildValue("()");
			pyobj = theApp.CallPythonRet(This->pythonApp, "WpyNPP_Destroy", args);
			Py_DECREF(args);
			if (!PyString_Check(pyobj)){
				Py_DECREF(pyobj);
			}
			else {
        		// make some saved instance data
				// make a struct header for the data
            	NPSavedData * pSavedInstanceData =
               		(NPSavedData*)NPN_MemAlloc(sizeof(NPSavedData));
            	if (pSavedInstanceData == NULL) {
					ASSERT(0);
					return NPERR_OUT_OF_MEMORY_ERROR;
				}
				int len = PyString_Size(pyobj);
                char * data = PyString_AsString(pyobj);
                pSavedInstanceData->buf = NPN_MemAlloc(len);
                if(pSavedInstanceData->buf != NULL) {
                    memcpy(pSavedInstanceData->buf, data, len);
                    pSavedInstanceData->len = len;
        			*save = pSavedInstanceData;
                }
				else{
					NPN_MemFree(pSavedInstanceData);
					ASSERT(0);
					return NPERR_OUT_OF_MEMORY_ERROR;
				}
            }
        }

		Py_XDECREF(This->argDict);
		This->argDict = NULL;
		Py_XDECREF(This->pluginType);
		This->pluginType = NULL;
		Py_XDECREF(This->pythonApp);
		This->pythonApp = NULL;
        NPN_MemFree(instance->pdata);
        instance->pdata = NULL;
    }
	theApp.FlushMessages();
    return NPERR_NO_ERROR;
}


//----------------------------------------------------------------------------
// NPP_SetWindow:
//----------------------------------------------------------------------------
NPError NP_LOADDS
NPP_SetWindow(NPP instance, NPWindow* window)
{
	int call_python = 0;

    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;
    if (window == NULL)
        return NPERR_GENERIC_ERROR;

    PluginInstance* This = (PluginInstance*) instance->pdata;
	if (!This){
		ASSERT(0);
		return NPERR_NO_ERROR;
	}

    //
    // *Developers*: Before setting fWindow to point to the
    // new window, you may wish to compare the new window
    // info to the previous window (if any) to note window
    // size changes, etc.
    //

	if (!window->window){	// NULL window
		TRACE0("NPP_SetWindow with NULL window\r\n");
		if (This->pythonApp){
		 	This->pView->UnsubclassWindow();
		}
	}
	// Window available
    else if(!This->pythonApp)
    {	// No current app: Do create and subclass window later.
		TRACE0("NPP_SetWindow with initial window\r\n");
    }
	else if(!This->fWindow) {	// Should not happen
		ASSERT(0);
	}
    else if((HWND)This->fWindow->window != (HWND)window->window) {
    	// Window handle changed.  Remove the subclass for the old client window.
		TRACE0("Window handle changed.  Re-subclass.\r\n");
		This->pView->UnsubclassWindow();
		// subclass the new one
		This->pView->SubclassWindow((HWND)window->window);
		call_python = 1;
    }
	else {    // the window position/size may have changed.
		TRACE0("setwindow checking size\r\n");
		if (	window->x != This->x ||
				window->y != This->y ||
				window->width  != This->width ||
				window->height != This->height){
			TRACE0("SetWindow: size or location change\r\n");
			call_python = 1;
		}
    }
	This->fWindow = window;
	if (window->window) {
		This->x = window->x;
		This->y = window->y;
		This->width = window->width;
		This->height = window->height;
	}
	if (call_python && This->pythonApp){
		PyObject * args = Py_BuildValue("(llll)", window->x, window->y, window->width, window->height);
		PyObject * rect = theApp.CallPythonRet(This->pythonApp, "WpyReturnCRect", args);
		Py_DECREF(args);
		args = Py_BuildValue("(O)", rect);
		Py_DECREF(rect);
		theApp.CallPython(This->pythonApp, "NPP_SetWindow", args);
		Py_DECREF(args);
	}
	theApp.FlushMessages();
    return NPERR_NO_ERROR;
}


//----------------------------------------------------------------------------
// NPP_NewStream:
//----------------------------------------------------------------------------
NPError NP_LOADDS
NPP_NewStream(NPP instance,
              NPMIMEType type,
              NPStream *stream, 
              NPBool seekable,
              uint16 *stype)
{
	TRACE1("Start of newstream, type=%s\r\n", type);
    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;
    PluginInstance* This = (PluginInstance*) instance->pdata;
        
    stream->pdata = NPN_MemAlloc(sizeof(StreamInstance));
    StreamInstance* Stream = (StreamInstance*) stream->pdata;
    if (Stream == NULL)
        return NPERR_OUT_OF_MEMORY_ERROR;
	Stream->pyStream = NULL;
	Stream->isAppStream = 0;

    // if your plugin must operate file based, you may wish to do this:
    //    *stype = NP_ASFILE;
    // remember, though, that use of NP_ASFILE is strongly discouraged;
    // your plugin should attempt to work with data as it comes in on
    // the stream if at all possible

	if (!This->pythonApp) {
		*stype = NP_ASFILE;	// Get initial Python program as a file
	}
	else {
		PyObject * args = Py_BuildValue("(s)", stream->url);
		Stream->pyStream = theApp.CallPythonRet(This->pythonApp, "WpyNPP_NewStream", args);
		Py_DECREF(args);
		if (!Stream->pyStream) {
			theApp.FlushMessages();
			ASSERT(0);
			return NPERR_GENERIC_ERROR;
		}
		args = Py_BuildValue("(sl)", type, (long)seekable);
		PyObject * pyobj = theApp.CallPythonRet(Stream->pyStream, "NPP_NewStream", args);
		Py_DECREF(args);
		if (pyobj && PyInt_Check(pyobj))
			*stype = (uint16)PyInt_AsLong(pyobj);
		Py_XDECREF(pyobj);
		theApp.FlushMessages();
	}
    return NPERR_NO_ERROR;
}


//
// *Developers*: 
// These next 2 functions are directly relevant in a plug-in which handles the
// data in a streaming manner.  If you want zero bytes because no buffer space
// is YET available, return 0.  As long as the stream has not been written
// to the plugin, Navigator will continue trying to send bytes.  If the plugin
// doesn't want them, just return some large number from NPP_WriteReady(), and
// ignore them in NPP_Write().  For a NP_ASFILE stream, they are still called
// but can safely be ignored using this strategy.
//

int32 STREAMBUFSIZE = 0X0FFFFFFF;   // If we are reading from a file in
                                    // NP_ASFILE mode, we can take any size
                                    // stream in our write call (since we
                                    // ignore it)

//----------------------------------------------------------------------------
// NPP_WriteReady:
//----------------------------------------------------------------------------
int32 NP_LOADDS
NPP_WriteReady(NPP instance, NPStream *stream)
{
	TRACE0("NPP_WriteReady\r\n");
    if (instance == NULL)
		return STREAMBUFSIZE;
    PluginInstance* This = (PluginInstance*) instance->pdata;
    StreamInstance* Stream = (StreamInstance*) stream->pdata;

	int32 ret;
	if (!This->pythonApp) {
    	ret = STREAMBUFSIZE;   // Number of bytes ready to accept in NPP_Write()
	}
	else {
		PyObject * pyobj = theApp.CallPythonRet(Stream->pyStream, "NPP_WriteReady", NULL);
		if (pyobj && PyInt_Check(pyobj))
			ret = PyInt_AsLong(pyobj);
		else
			ret = 2000;
		Py_XDECREF(pyobj);
		theApp.FlushMessages();
	}
	return ret;
}


//----------------------------------------------------------------------------
// NPP_Write:
//----------------------------------------------------------------------------
int32 NP_LOADDS
NPP_Write(NPP instance, NPStream *stream,
          int32 offset, int32 len, void *buffer)
{
	TRACE0("NPP_Write\r\n");
    if (instance == NULL)
    	return -1;
    PluginInstance* This = (PluginInstance*) instance->pdata;
    StreamInstance* Stream = (StreamInstance*) stream->pdata;

	if (!This->pythonApp) {
    	return len; // The number of bytes accepted.  Return a
                    // negative number here if, e.g., there was an error
                    // during plugin operation and you want to abort the
                    // stream
	}
	else {
		PyObject * pyobj = PyString_FromStringAndSize((char *)buffer, len);
		PyObject * args = Py_BuildValue("(Ol)", pyobj, (long)offset);
		Py_DECREF(pyobj);
		pyobj = theApp.CallPythonRet(Stream->pyStream, "NPP_Write", args);
		Py_DECREF(args);
		int32 ret;
		if (pyobj && PyInt_Check(pyobj))
			ret = PyInt_AsLong(pyobj);
		else
			ret = len;
		Py_XDECREF(pyobj);
		theApp.FlushMessages();
		return ret;
	}
}


//----------------------------------------------------------------------------
// NPP_DestroyStream:
//----------------------------------------------------------------------------
NPError NP_LOADDS
NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason)
{
	TRACE0("NPP_DestroyStream\r\n");
    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;
    PluginInstance* This = (PluginInstance*) instance->pdata;
    StreamInstance* Stream = (StreamInstance*) stream->pdata;

	if (This->pythonApp && !Stream->isAppStream) {
		PyObject * args = Py_BuildValue("(l)", (long)reason);
		theApp.CallPython(Stream->pyStream, "NPP_DestroyStream", args);
		Py_DECREF(args);
		theApp.FlushMessages();
	}
	NPN_MemFree(stream->pdata);
	stream->pdata = NULL;
   	return NPERR_NO_ERROR;
}


//----------------------------------------------------------------------------
// NPP_StreamAsFile:
//----------------------------------------------------------------------------
void NP_LOADDS
NPP_StreamAsFile(NPP instance, NPStream *stream, const char* inname)
{
	TRACE1("NPP_StreamAsFile, inname=%s\r\n", inname);
    if (instance == NULL)
        return;

    PluginInstance* This = (PluginInstance*) instance->pdata;
    StreamInstance* Stream = (StreamInstance*) stream->pdata;
	NPWindow * window = This->fWindow;
	ASSERT(window);

	// Netscape bug:  fname may have "\\"
	char fname[1024];
	FILE * fp = fopen(inname, "r");
	if (fp) {
		fclose(fp);
		strcpy(fname, inname);
	}
	else {
		char * pt = strstr(inname, "\\\\");
		if (pt)
			strcpy(fname, pt + 2);
		else
			strcpy(fname, inname);
	}
	TRACE1("NPP_StreamAsFile, fname=%s\r\n", fname);

	if (!okWarning) {
		okWarning = -1;
		okWarning = MessageBox((HWND)window->window,
"Warning: This feature will run remote Python programs"
" without any protection at all.  They could damage your"
" system.  If you do not trust the source of this program"
" completely, you should select \"Cancel\"."
			, "Running Program in Insecure Environment", MB_OKCANCEL | MB_ICONSTOP | MB_DEFBUTTON2);
		TRACE1("Got okWarning %d\r\n", okWarning);
	}

	if (okWarning != IDOK)
		;
	else if (!This->pythonApp){	// We have the initial program to run
		Stream->isAppStream = 1;
		char text[256];
		strcpy(text, "fname = \"");
		const char *pts = fname;
		char *ptd = text + strlen(text);
		while (*pts){			// change single \ to two \\.
			if (*pts == '\\')
				*ptd++ = '\\';
			*ptd++ = *pts;
			pts++;
		}
		switch (*(ptd - 1)){
		case 'C':
		case 'c':		// file ends in ".pyc"
			pts = "load_compiled";
			break;
		case 'Y':
		case 'y':		// file ends in ".py"
			pts = "load_source";
			break;
		default:
			ASSERT(0);
			pts = "load_source";
		}
		*ptd++ = '"';
		*ptd = 0;
		PyRun_SimpleString(text);
		sprintf(text,
"import imp\n\
fp = open(fname, \"r\")\n\
imp.%s(\"_NsPi%lx\", fname, fp)\n\
fp.close()", pts, (long)instance);
		if (PyRun_SimpleString(text)) {
			TRACE0("Initial run of Python program failed\r\n");
			theApp.FlushMessages();
			return;
		}
		This->pythonApp = theApp.GetPythonObject(&theApp);
		Py_INCREF(This->pythonApp);
		theApp.FlushMessages();
		PyObject * v = PyInt_FromLong((long)instance);
		PyObject_SetAttrString(This->pythonApp, "wpyphysInstance", v);
		// Start sending messages to the Python app instance.
		// NPP_New(string type, int mode, dict of args, None)
		PyObject * args = Py_BuildValue("(OlOO)", This->pluginType,
			(long)This->fMode, This->argDict, Py_None);
		theApp.CallPython(This->pythonApp, "NPP_New", args);
		Py_DECREF(args);
		ASSERT(window);
		args = Py_BuildValue("(llll)", window->x, window->y, window->width, window->height);
		PyObject * rect = theApp.CallPythonRet(This->pythonApp, "WpyReturnCRect", args);
		Py_DECREF(args);
		theApp.FlushMessages();
		ASSERT(rect);
		if (rect)
			args = Py_BuildValue("(Ol)", rect, (long)window->window);
		else
			args = Py_BuildValue("(Ol)", Py_None, (long)window->window);
		Py_XDECREF(rect);
		PyObject * pyview = theApp.CallPythonRet(This->pythonApp, "WpyNPP_InitialSetWindow", args);
		This->pView = (CWpythonView *)theApp.GetCppObject(pyview);
		Py_XDECREF(pyview);
		ASSERT(This->pView);
		Py_DECREF(args);
	}
	else{
		PyObject * args = Py_BuildValue("(s)", fname);
		theApp.CallPython(Stream->pyStream, "NPP_StreamAsFile", args);
		Py_DECREF(args);
	}
	theApp.FlushMessages();
}


//----------------------------------------------------------------------------
// NPP_Print:
//----------------------------------------------------------------------------
void NP_LOADDS
NPP_Print(NPP instance, NPPrint* printInfo)
{
	TRACE0("NPP_Print\r\n");
    if(printInfo == NULL)   // trap invalid parm
        return;

    if (instance != NULL)
    {
        PluginInstance* This = (PluginInstance*) instance->pdata;
    
        if (printInfo->mode == NP_FULL)
        {
            //
            // *Developers*: If your plugin would like to take over
            // printing completely when it is in full-screen mode,
            // set printInfo->pluginPrinted to TRUE and print your
            // plugin as you see fit.  If your plugin wants Netscape
            // to handle printing in this case, set printInfo->pluginPrinted
            // to FALSE (the default) and do nothing.  If you do want
            // to handle printing yourself, printOne is true if the
            // print button (as opposed to the print menu) was clicked.
            // On the Macintosh, platformPrint is a THPrint; on Windows,
            // platformPrint is a structure (defined in npapi.h) containing
            // the printer name, port, etc.
            //
            void* platformPrint = printInfo->print.fullPrint.platformPrint;
            NPBool printOne = printInfo->print.fullPrint.printOne;
            
            printInfo->print.fullPrint.pluginPrinted = FALSE; // Do the default
        
        }
        else    // If not fullscreen, we must be embedded
        {
            //
            // *Developers*: If your plugin is embedded, or is full-screen
            // but you returned false in pluginPrinted above, NPP_Print
            // will be called with mode == NP_EMBED.  The NPWindow
            // in the printInfo gives the location and dimensions of
            // the embedded plugin on the printed page.  On the Macintosh,
            // platformPrint is the printer port; on Windows, platformPrint
            // is the handle to the printing device context.
            //
            NPWindow* printWindow = &(printInfo->print.embedPrint.window);
            void* platformPrint = printInfo->print.embedPrint.platformPrint;

            HPEN hPen, hPenOld;
#ifdef WIN32
            /* Initialize the pen's "brush" */
            LOGBRUSH lb;
            lb.lbStyle = BS_SOLID;
            lb.lbColor = RGB(128, 128, 128);
            lb.lbHatch = 0;

            hPen = ExtCreatePen(PS_COSMETIC | PS_SOLID, 1, &lb, 0, NULL);
#else
            COLORREF cref = RGB(128, 128, 128);
            hPen = CreatePen(PS_SOLID, 32, cref);
#endif
            HDC hDC = (HDC)(DWORD)platformPrint;
            hPenOld = (HPEN)SelectObject(hDC, hPen);
    
            BOOL result = Rectangle(hDC,
                                    (int)(printWindow->x),
                                    (int)(printWindow->y),
                                    (int)(printWindow->x + printWindow->width),
                                    (int)(printWindow->y + printWindow->height));
            SelectObject(hDC, hPenOld);
            DeleteObject(hPen);
        }
    }
}

