#ifndef Py_OFUNCOBJECT_H
#define Py_OFUNCOBJECT_H
#ifdef __cplusplus
extern "C" {
#endif

typedef void (VBinaryFunction) Py_FPROTO((char *, int, char *, int,
					  char *, int, int, void *));
typedef void (VUnaryFunction) Py_FPROTO((char *, int, char *, int, int, void *));

typedef void (*PyOFuncGenericFunction) Py_FPROTO((char **, int *, int *, void *));

typedef struct {
  PyObject_HEAD
    /* XXXX Add your own stuff here */
  int *ranks, *canonical_ranks;
  int nin, nout, nargs;
  int identity;
  PyOFuncGenericFunction *functions;
  void **data;
  int ntypes, nranks, attributes;
  char *name, *types;
  int check_return;
} PyOFuncObject;

extern DL_IMPORT(PyTypeObject) PyOFunc_Type;

#define PyOFunc_Unbounded 120
#define PyOFunc_One 1
#define PyOFunc_Zero 0
#define PyOFunc_None -1

PyObject *PyOFunc_FromFuncAndData(PyOFuncGenericFunction *func, void **data, char *types, int ntypes,
				  int nin, int nout, int identity, char *name, int check_return);
int PyOFunc_GenericFunction(PyOFuncObject *self, PyObject *args, PyArrayObject **mps);

extern void PyOFunc_f_f_As_d_d(char **args, int *dimensions, int *steps, void *func);
extern void PyOFunc_d_d(char **args, int *dimensions, int *steps, void *func);
extern void PyOFunc_F_F_As_D_D(char **args, int *dimensions, int *steps, void *func);
extern void PyOFunc_D_D(char **args, int *dimensions, int *steps, void *func);
extern void PyOFunc_O_O(char **args, int *dimensions, int *steps, void *func);
extern void PyOFunc_ff_f_As_dd_d(char **args, int *dimensions, int *steps, void *func);
extern void PyOFunc_dd_d(char **args, int *dimensions, int *steps, void *func);
extern void PyOFunc_FF_F_As_DD_D(char **args, int *dimensions, int *steps, void *func);
extern void PyOFunc_DD_D(char **args, int *dimensions, int *steps, void *func);
extern void PyOFunc_OO_O(char **args, int *dimensions, int *steps, void *func);
extern void PyOFunc_O_O_method(char **args, int *dimensions, int *steps, void *func);

extern PyObject *PyArray_Map(PyObject *function, PyObject *args);

#ifdef __cplusplus
}
#endif
#endif /* !Py_ARRAYOBJECT_H */
