#!/usr/local/bin/python --
## -*-python-*-
"""
##****************************************************************************
##
## File:         telnetexp.py
## RCS:          $Header: /u/testbed/CVSROOT/dldev/src/Services/telnetexp/telnetexp.py,v 1.1 1995/09/05 18:27:00 hassan Exp $
## Description:  Telnet Expect-like library
## Author:       Scott Hassan, Stanford University
## Created:      3/5/95
## Modified:     9/5/95
## Language:     python
## Package:      N/A
## Status:       Experimental
##
##*****************************************************************************
##
"""

import sys, posix, string, socket
import select
import regex, regsub, regex_syntax
import telnetlib

try:
  import dlcoslib
  import ilu
except ImportError, reason:
  dlcoslib = None

Timeout = "Timeout"
FullBuffer = "Full Buffer"
ConnectionClosed = "Connection Closed"

exact = 1
regexp = 2

class TelnetExpect(telnetlib.Telnet):
  """TelnetExpect is an object that can 'talk' to any telnet daemon using simple regular expressions and send commands.

Methods:
  SetDebug(pFlag)
  GetLogFlag() : int
  SetLogFlag(pFlag)

  Open(pAddress)
  Close()

  read_line() : string
  waitfor(pPattern) : compile_pattern
  WaitForList(pPatternList) : pattern_code
  WaitFor(pString) : pattern_code

  Send(pString)
  SendExp(pSendString, pExpString)
  SendString(pString)
  SendLF(pString)
  SendLFExp(pString)
  Interact()
"""
  def __init__(self):
    telnetlib.Telnet.__init__(self)
    self.buffer = ""
    self.log = 0
    self.timeout = 30
    self.fDebug = 0
    self.match = None

  def SetDebug(self, pFlag):
    self.fDebug = pFlag

  def GetLogFlag(self): return self.log
  def SetLogFlag(self, pFlag): self.log = pFlag

  def GetTimeout(self): return self.timeout
  def SetTimeout(self, pTimeout): 
    """set the timeout when waiting for input."""
    self.timeout = pTimeout

  def Open(self, pAddress): 
    """opens a telnet connection to pAddress (host:port)"""
    self.open(pAddress)

  def Close(self): 
    """closes the connection."""
    self.close()


  def read_line(self):
    """reads one line from the remote connection.  Raises(ConnectionClosed, Timeout)"""
    pat = regex.compile("\r\n")
    pos = pat.search(self.buffer)

    if pos != -1:
      self.m = pat.group(0)
      l = len(self.m)
      self.match = self.buffer[:pos+l]
      self.buffer = self.buffer[pos+l:]
      if self.fDebug:
	print "match: <" + `self.match` + ">"
	print "buffer: <" + `self.buffer` + ">"
      return self.match
    
    s_reply = ([self], [], [])
    s_args = s_reply

    if self.timeout is not None:
      s_args = s_args + (self.timeout,)

    while not self.eof:
      if dlcoslib:
	ret = dlcoslib.WaitInput(self, self.timeout)
	if ret == "Timeout": raise Timeout
      else:
	r = apply(select.select, s_args)
	if r != s_reply:  raise Timeout

      buf = self.read_some()
      self.buffer = self.buffer + buf
      if self.log: sys.stdout.write(buf)
      pos = pat.search(self.buffer)

      if pos != -1:
	self.m = pat.group(0)
	l = len(self.m)
	self.match = self.buffer[:pos+l]
	self.buffer = self.buffer[pos+l:]

	if self.fDebug:
	  print "match: <" + `self.match` + ">"
	  print "buffer: <" + `self.buffer` + ">"
	return self.match
    if self.eof:   raise ConnectionClosed      
    else:   raise Timeout


  def waitfor(self, pPattern):
    """reads until pPattern matches.  Raises(ConnectionClosed, Timeout)"""

    oldsyntax = regex.set_syntax(regex_syntax.RE_NO_BK_PARENS | regex_syntax.RE_NO_BK_VBAR)
    pat = regex.compile(pPattern)
    regex.set_syntax(oldsyntax)

    pos = pat.search(self.buffer)
    if pos != -1:
      self.match = pat.group(0)
      self.buffer = self.buffer[pos+len(self.match):]
      if self.fDebug:
	print "match: <" + `self.match` + ">"
	print "buffer: <" + `self.buffer` + ">"
      return pat

    s_reply = ([self], [], [])
    s_args = s_reply

    if self.timeout is not None:
      s_args = s_args + (self.timeout,)

    while not self.eof:
      if dlcoslib:
	ret = dlcoslib.WaitInput(self, self.timeout)
	if ret == "Timeout": raise Timeout
      else:
	r = apply(select.select, s_args)
	if r != s_reply:  raise Timeout

      buf = self.read_some()
      self.buffer = self.buffer + buf
      if self.log: sys.stdout.write(buf)
      pos = pat.search(self.buffer)

      if pos != -1:
	self.match = pat.group(0)
	self.buffer = self.buffer[pos+len(self.match):]
	if self.fDebug:
	  print "match: <" + `self.match` + ">"
	  print "buffer: <" + `self.buffer` + ">"
	return pat
    if self.eof:
      raise ConnectionClosed      
    else:
      raise Timeout

  def WaitForList(self, pPatternList):
    """given a list of patterns construct a single compound pattern and call self.waitfor.  Raises(ConnectionClosed, Timeout)
Patterns are in the form of:

    (type, pattern, return_code)

    where:
      type is the type of pattern.
        type == telnetexp.exact    for exact matches.
        type == telnetexp.regex    for regular expression.
      pattern is the string or regular expression.
      return_code is any value that will be returned if this pattern matches.

    If none of the patterns match, None is returned.


    Note: do not use group '()' in your regular expressions.
"""
    if self.fDebug:  print "WaitingFor: " + `pPatternList`
    pattern = ""
    for s in pPatternList:
      type, pat, ret = s

      if type == exact:
	oldsyntax = regex.set_syntax(regex_syntax.RE_NO_BK_PARENS | regex_syntax.RE_NO_BK_VBAR)
	## quote the regular expression syntax
	pat = regsub.gsub("\*", "\\*", pat)
	pat = regsub.gsub("\?", "\\?", pat)
	pat = regsub.gsub("\(", "\\(", pat)
	pat = regsub.gsub("\)", "\\)", pat)
	regex.set_syntax(oldsyntax)

      if pattern == "": pattern = "(" + pat + ")"
      else: pattern = pattern + "|(" + pat + ")"

    p = self.waitfor(pattern)

    i = 1
    for s in pPatternList:
      type, pat, ret = s
      if p.group(i): return ret
      i=i+1
    return None

  def WaitFor(self, pString):
    """Wait for an exact match of pString.  Raises(ConnectionClosed, Timeout)""" 
    return self.WaitForList([(exact, pString, 0)])

  def Send(self, pSendString):
    """Send pSendString to the remote host.  Raises(ConnectionClosed)"""
    try:
      if self.fDebug:
	print "Send: " + pSendString
      self.write(pSendString)
    except socket.error:
      raise ConnectionClosed      
    
  def SendExp(self, pSendString, pExpString):
    """Send pSendString to the remote host and then wait for pExpString.  Raises(ConnectionClosed, Timeout)""" 
    self.Send(pSendString)
    self.WaitFor(pExpString)

  def SendString(self, pString):
    """Send pSendString to the remote host and then wait for the string to be echoed back.  Raises(ConnectionClosed, Timeout)""" 
    self.SendExp(pString, pString)

  def SendLF(self, pString):
    """Send pSendString+LineFeed to the remote host.  Raises(ConnectionClosed)""" 
    self.Send(pString + "\r")

  def SendLFExp(self, pString):
    """Send pSendString+LineFeed to the remote host and then wait for the string to be echoed back.  Raises(ConnectionClosed, Timeout)""" 
    self.Send(pString + "\r")
    self.WaitFor(pString)

  def Interact(self):
    """gives control of the connection to the user, so that keystrokes from stdin are sent to the remote host, and the output is display on stdout."""
    self.interact()







