#! /usr/bin/env python
""" SpreadModule:  Python wrapper for Spread client libraries

This package contains a simple Python wrapper module for the Spread
toolkit.  The wrapper is compatible with Python 2.1, 2.2 and 2.3 (i.e.
Python as currently in CVS).

Spread (www.spread.org) is a group communications package.  You'll
need to download and install it separately.  The Python API has been
built and tested against Spread 3.16.1 and 3.16.2.  There's a bug in
version 3.16.1 that can cause disconnects under high load, so we
recommend to use Spread 3.16.2 (or later), which fixes the bug.  That
version also solves some problems with the Makefile (the 3.16.1
Makefile didn't install the include files, and uses BASEDIR instead of
PREFIX).

Copyright (c) 2001-2003 Python Software Foundation.  All rights reserved.

This code is released under the standard PSF license.
See the file LICENSE.
"""

classifiers = """\
Development Status :: 5 - Production/Stable
Intended Audience :: Developers
License :: OSI Approved :: Python Software Foundation License
Programming Language :: Python
Topic :: System :: Distributed Computing
Topic :: Software Development :: Libraries :: Python Modules
Operating System :: Microsoft :: Windows
Operating System :: Unix
"""

import sys
import os
from distutils.core import setup, Extension

if sys.version_info < (2, 3):
    _setup = setup
    def setup(**kwargs):
        if kwargs.has_key("classifiers"):
            del kwargs["classifiers"]
        _setup(**kwargs)

doclines = __doc__.split('\n')

if os.name == 'nt':
    SPREAD_DIR = r"\spread-bin-3.17.1"
    ext = Extension('spread', ['spreadmodule.c'],
                include_dirs = [SPREAD_DIR + r"\include"],
                library_dirs = [SPREAD_DIR + r"\win"],
                libraries = ['libtsp', 'wsock32'],
                extra_link_args = ['/NODEFAULTLIB:libc'],
                )
else:
    SPREAD_DIR = "/usr/local"
    ext = Extension('spread', ['spreadmodule.c'],
                include_dirs = [SPREAD_DIR + "/include"],
                library_dirs = [SPREAD_DIR + "/lib"],
                libraries = ['tspread'],
                )

setup(name = "SpreadModule",
      version = "1.4",
      maintainer = "Zope Corporation",
      maintainer_email="zodb-dev@zope.org",
      description = doclines[0],
      long_description = '\n'.join(doclines[2:]),
      license = "Python",
      platforms = ["unix", "ms-windows"],
      url = "http://www.python.org/other/spread/",
      classifiers = filter(None, classifiers.split("\n")),
      ext_modules = [ext],
      )
