.TH PYTHON "1" "5 September, 2000"
.SH NAME
python \- an interpreted, interactive, object-oriented programming language
.SH SYNOPSIS
.B python
[
.B \-d
]
[
.B \-i
]
[
.B \-O
]
[
.B \-S
]
[
.B \-t
]
[
.B \-u
]
[
.B \-v
]
[
.B \-x
]
.br
       [
.B \-c
.I command
|
.I script
|
\-
]
[
.I arguments
]
.SH DESCRIPTION
Python is an interpreted, interactive, object-oriented programming
language that combines remarkable power with very clear syntax.
For an introduction to programming in Python you are referred to the
Python Tutorial.
The Python Library Reference documents built-in and standard types,
constants, functions and modules.
Finally, the Python Reference Manual describes the syntax and
semantics of the core language in (perhaps too) much detail.
(These documents may be located via the
.B "INTERNET RESOURCES"
below; they may be installed on your system as well.)
.PP
Python's basic power can be extended with your own modules written in
C or C++.
On most systems such modules may be dynamically loaded.
Python is also adaptable as an extension language for existing
applications.
See the internal documentation for hints.
.SH COMMAND LINE OPTIONS
.TP
.B \-d
Turn on parser debugging output (for wizards only, depending on
compilation options).
.TP
.B \-i
When a script is passed as first argument or the \fB\-c\fP option is
used, enter interactive mode after executing the script or the
command.  It does not read the $PYTHONSTARTUP file.  This can be
useful to inspect global variables or a stack trace when a script
raises an exception.
.TP
.B \-O
Turn on basic optimizations.  This changes the filename extension for
compiled (bytecode) files from
.I .pyc
to \fI.pyo\fP.  Given twice, causes docstrings to be discarded.
.TP
.B \-S
Disable the import of the module
.I site
and the site-dependent manipulations of
.I sys.path
that it entails.
.TP
.B \-t
Issue a warning when a source file mixes tabs and spaces for
indentation in a way that makes it depend on the worth of a tab
expressed in spaces.  Issue an error when the option is given twice.
.TP
.B \-u
Force stdin, stdout and stderr to be totally unbuffered.
.TP
.B \-v
Print a message each time a module is initialized, showing the place
(filename or built-in module) from which it is loaded.  When given
twice, print a message for each file that is checked for when 
searching for a module.  Also provides information on module cleanup
at exit.
.TP
.B \-x
Skip the first line of the source.  This is intended for a DOS
specific hack only.  Warning: the line numbers in error messages will
be off by one!
.TP
.BI "\-c " command
Specify the command to execute (see next section).
This terminates the option list (following options are passed as
arguments to the command).
.SH INTERPRETER INTERFACE
The interpreter interface resembles that of the UNIX shell: when
called with standard input connected to a tty device, it prompts for
commands and executes them until an EOF is read; when called with a
file name argument or with a file as standard input, it reads and
executes a
.I script
from that file;
when called with
.B \-c
.I command,
it executes the Python statement(s) given as
.I command.
Here
.I command
may contain multiple statements separated by newlines.
Leading whitespace is significant in Python statements!
In non-interactive mode, the entire input is parsed befored it is
executed.
.PP
If available, the script name and additional arguments thereafter are
passed to the script in the Python variable
.I sys.argv ,
which is a list of strings (you must first
.I import sys
to be able to access it).
If no script name is given,
.I sys.argv[0]
is an empty string; if
.B \-c
is used,
.I sys.argv[0]
contains the string
.I '-c'.
Note that options interpreted by the Python interpreter itself
are not placed in
.I sys.argv.
.PP
In interactive mode, the primary prompt is `>>>'; the second prompt
(which appears when a command is not complete) is `...'.
The prompts can be changed by assignment to
.I sys.ps1
or
.I sys.ps2.
The interpreter quits when it reads an EOF at a prompt.
When an unhandled exception occurs, a stack trace is printed and
control returns to the primary prompt; in non-interactive mode, the
interpreter exits after printing the stack trace.
The interrupt signal raises the
.I Keyboard\%Interrupt
exception; other UNIX signals are not caught (except that SIGPIPE is
sometimes ignored, in favor of the
.I IOError
exception).  Error messages are written to stderr.
.SH FILES AND DIRECTORIES
These are subject to difference depending on local installation
conventions; ${prefix} and ${exec_prefix} are installation-dependent
and should be interpreted as for GNU software; they may be the same.
The default for both is \fI/usr/local\fP.
.IP \fI${exec_prefix}/bin/python\fP
Recommended location of the interpreter.
.PP
.I ${prefix}/lib/python<version>
.br
.I ${exec_prefix}/lib/python<version>
.RS
Recommended locations of the directories containing the standard
modules.
.RE
.PP
.I ${prefix}/include/python<version>
.br
.I ${exec_prefix}/include/python<version>
.RS
Recommended locations of the directories containing the include files
needed for developing Python extensions and embedding the
interpreter.
.RE
.IP \fI~/.pythonrc.py\fP
User-specific initialization file loaded by the \fIuser\fP module;
not used by default or by most applications.
.SH ENVIRONMENT VARIABLES
.IP PYTHONHOME
Change the location of the standard Python libraries.  By default, the
libraries are searched in ${prefix}/lib/python<version> and
${exec_prefix}/lib/python<version>, where ${prefix} and ${exec_prefix}
are installation-dependent directories, both defaulting to
\fI/usr/local\fP.  When $PYTHONHOME is set to a single directory, its value
replaces both ${prefix} and ${exec_prefix}.  To specify different values
for these, set $PYTHONHOME to ${prefix}:${exec_prefix}.
.IP PYTHONPATH
Augments the default search path for module files.
The format is the same as the shell's $PATH: one or more directory
pathnames separated by colons.
Non-existant directories are silently ignored.
The default search path is installation dependent, but generally
begins with ${prefix}/lib/python<version> (see PYTHONHOME above).
The default search path is always appended to $PYTHONPATH.
If a script argument is given, the directory containing the script is
inserted in the path in front of $PYTHONPATH.
The search path can be manipulated from within a Python program as the
variable
.I sys.path .
.IP PYTHONSTARTUP
If this is the name of a readable file, the Python commands in that
file are executed before the first prompt is displayed in interactive
mode.
The file is executed in the same name space where interactive commands
are executed so that objects defined or imported in it can be used
without qualification in the interactive session.
You can also change the prompts
.I sys.ps1
and
.I sys.ps2
in this file.
.IP PYTHONDEBUG
If this is set to a non-empty string it is equivalent to specifying
the \fB\-d\fP option.
.IP PYTHONINSPECT
If this is set to a non-empty string it is equivalent to specifying
the \fB\-i\fP option.
.IP PYTHONUNBUFFERED
If this is set to a non-empty string it is equivalent to specifying
the \fB\-u\fP option.
.IP PYTHONVERBOSE
If this is set to a non-empty string it is equivalent to specifying
the \fB\-v\fP option.
.SH AUTHOR
.nf
Guido van Rossum
BeOpen.com
160 Saratoga Avenue
Santa Clara, CA 95051
USA
.PP
E-mail: guido@beopen.com, guido@python.org
.fi
.PP
And a cast of thousands.
.SH INTERNET RESOURCES
Main website: http://www.python.org
.br
BeOpen development team: http://pythonlabs.com
.br
Community website: http://starship.python.net
.br
Developer resources:
.br
  http://sourceforge.net/project/?group_id=5470
.br
FTP: ftp://ftp.python.org/pub/python
.br
Module repository: http://www.vex.net/parnassus/
.br
Newsgroups: comp.lang.python, comp.lang.python.announce
.SH LICENSING
Python is distributed under an Open Source license.  See the file
"LICENSE" in the Python source distribution for information on terms &
conditions for accessing and otherwise using Python and for a
DISCLAIMER OF ALL WARRANTIES.
