/* Widget Set Xm */

#include "Python.h"
#include "modsupport.h"
#include "import.h"
#include "widgetobject.h"

#define is_optwidgetobject(x)	((x) == Py_None || is_widgetobject(x))
#define getoptwidgetvalue(x)	((x) == Py_None ? NULL : getwidgetvalue(x))

#include "event.h"
#include "Xmsupport.h"

/* Methods for widget objects */

#include <Xm/DialogS.h>

static PyObject *
widget_CreateDialogShell(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateDialogShell(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#if XmVersion >= 1001
static PyObject *
widget_IsMotifWMRunning(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmIsMotifWMRunning(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
static PyMethodDef shellwidget_methods[] = {
#if XmVersion >= 1001
	{"IsMotifWMRunning", (PyCFunction)widget_IsMotifWMRunning, 1},
#endif /* XmVersion >= 1001 */
	{0, 0} /* Sentinel */
};
PyMethodChain shellwidget_methodchain = {
	shellwidget_methods,
	&compositewidget_methodchain,
};

#if XmVersion >= 1001
#include <Xm/Protocols.h>
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_ActivateProtocol(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long arg1;
	unsigned long arg2;
	if (!PyArg_ParseTuple(args, "ll",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmActivateProtocol(self->ob_widget,
			(Atom)arg1,
			(Atom)arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_ActivateWMProtocol(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmActivateWMProtocol(self->ob_widget,
			(Atom)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_DeactivateProtocol(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long arg1;
	unsigned long arg2;
	if (!PyArg_ParseTuple(args, "ll",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmDeactivateProtocol(self->ob_widget,
			(Atom)arg1,
			(Atom)arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_DeactivateWMProtocol(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmDeactivateWMProtocol(self->ob_widget,
			(Atom)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_AddProtocols(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long arg1;
	PyObject *arg2; Atom *atoms_arg2; int natoms_arg2;
	if (!PyArg_ParseTuple(args, "lO",
			&arg1,
			&arg2))
		return NULL;
	if (!checkintlist(arg2, sizeof(Atom), &atoms_arg2, &natoms_arg2)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be Atom[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmAddProtocols(self->ob_widget,
			(Atom)arg1,
			atoms_arg2, natoms_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(atoms_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_AddWMProtocols(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1; Atom *atoms_arg1; int natoms_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!checkintlist(arg1, sizeof(Atom), &atoms_arg1, &natoms_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Atom[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmAddWMProtocols(self->ob_widget,
			atoms_arg1, natoms_arg1);
		jump_flag = 0;
	}
	PyMem_DEL(atoms_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_RemoveProtocolCallback(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long arg1;
	unsigned long arg2;
	PyObject *arg3, *cbfunc;
	PyObject *arg4, *cbarg;
	if (!PyArg_ParseTuple(args, "llOO",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	cbfunc = arg3;
	cbarg = make_closure(self, cbfunc, arg4, 1);
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmRemoveProtocolCallback(self->ob_widget,
			(Atom)arg1,
			(Atom)arg2,
			univ_callback,
			(XtPointer)cbarg);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_RemoveWMProtocolCallback(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long arg1;
	PyObject *arg2, *cbfunc;
	PyObject *arg3, *cbarg;
	if (!PyArg_ParseTuple(args, "lOO",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	cbfunc = arg2;
	cbarg = make_closure(self, cbfunc, arg3, 1);
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmRemoveWMProtocolCallback(self->ob_widget,
			(Atom)arg1,
			univ_callback,
			(XtPointer)cbarg);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_RemoveProtocols(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long arg1;
	PyObject *arg2; Atom *atoms_arg2; int natoms_arg2;
	if (!PyArg_ParseTuple(args, "lO",
			&arg1,
			&arg2))
		return NULL;
	if (!checkintlist(arg2, sizeof(Atom), &atoms_arg2, &natoms_arg2)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be Atom[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmRemoveProtocols(self->ob_widget,
			(Atom)arg1,
			atoms_arg2, natoms_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(atoms_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_RemoveWMProtocols(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1; Atom *atoms_arg1; int natoms_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!checkintlist(arg1, sizeof(Atom), &atoms_arg1, &natoms_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Atom[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmRemoveWMProtocols(self->ob_widget,
			atoms_arg1, natoms_arg1);
		jump_flag = 0;
	}
	PyMem_DEL(atoms_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
static PyMethodDef vendorshellwidget_methods[] = {
#if XmVersion >= 1001
	{"ActivateProtocol", (PyCFunction)widget_ActivateProtocol, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"ActivateWMProtocol", (PyCFunction)widget_ActivateWMProtocol, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"AddProtocolCallback", (PyCFunction)widget_AddProtocolCallback, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"AddProtocols", (PyCFunction)widget_AddProtocols, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"AddWMProtocolCallback", (PyCFunction)widget_AddWMProtocolCallback, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"AddWMProtocols", (PyCFunction)widget_AddWMProtocols, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"DeactivateProtocol", (PyCFunction)widget_DeactivateProtocol, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"DeactivateWMProtocol", (PyCFunction)widget_DeactivateWMProtocol, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"RemoveProtocolCallback", (PyCFunction)widget_RemoveProtocolCallback, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"RemoveProtocols", (PyCFunction)widget_RemoveProtocols, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"RemoveWMProtocolCallback", (PyCFunction)widget_RemoveWMProtocolCallback, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"RemoveWMProtocols", (PyCFunction)widget_RemoveWMProtocols, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"SetProtocolHooks", (PyCFunction)widget_SetProtocolHooks, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"SetWMProtocolHooks", (PyCFunction)widget_SetWMProtocolHooks, 1},
#endif /* XmVersion >= 1001 */
	{0, 0} /* Sentinel */
};
PyMethodChain vendorshellwidget_methodchain = {
	vendorshellwidget_methods,
	&shellwidget_methodchain,
};

#include <Xm/ArrowB.h>

static PyObject *
widget_CreateArrowButton(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmArrowButtonWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateArrowButton(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/ArrowBG.h>

static PyObject *
widget_CreateArrowButtonGadget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmArrowButtonGadgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateArrowButtonGadget(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/BulletinB.h>

static PyObject *
widget_CreateBulletinBoard(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmBulletinBoardWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateBulletinBoard(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateBulletinBoardDialog(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	wClist[1] = xmBulletinBoardWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateBulletinBoardDialog(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/CascadeB.h>

static PyObject *
widget_CreateCascadeButton(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmCascadeButtonWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateCascadeButton(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/CascadeBG.h>

static PyObject *
widget_CreateCascadeButtonGadget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmCascadeButtonGadgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateCascadeButtonGadget(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CascadeButtonHighlight(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmCascadeButtonHighlight(self->ob_widget,
			(Boolean)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef cascadebuttonwidget_methods[] = {
	{"CascadeButtonHighlight", (PyCFunction)widget_CascadeButtonHighlight, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain cascadebuttonwidget_methodchain = {
	cascadebuttonwidget_methods,
	&widget_methodchain,
};

#if XmVersion >= 1002
static PyObject *
widget_ChangeColor(self, args)
	widgetobject *self;
	PyObject *args;
{
	Pixel arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmChangeColor(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
#include <Xm/Command.h>

static PyObject *
widget_CreateCommand(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmCommandWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateCommand(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CommandAppendValue(self, args)
	widgetobject *self;
	PyObject *args;
{
	char *arg1; XmString tmp_arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmCommandAppendValue(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)));
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_CommandError(self, args)
	widgetobject *self;
	PyObject *args;
{
	char *arg1; XmString tmp_arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmCommandError(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)));
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_CommandGetChild(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	int arg1;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCommandGetChild(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CommandSetValue(self, args)
	widgetobject *self;
	PyObject *args;
{
	char *arg1; XmString tmp_arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmCommandSetValue(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)));
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_ConvertUnits(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	int arg1;
	int arg2;
	int arg3;
	int arg4;
	if (!PyArg_ParseTuple(args, "iiii",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmConvertUnits(self->ob_widget,
			arg1,
			arg2,
			arg3,
			arg4);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#if XmVersion >= 1002
#include <Xm/Display.h>

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_GetDisplay(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmGetDisplay(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
#include <Xm/Screen.h>

#endif /* XmVersion >= 1002 */
#include <Xm/DrawingA.h>

static PyObject *
widget_CreateDrawingArea(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDrawingAreaWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateDrawingArea(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/DrawnB.h>

static PyObject *
widget_CreateDrawnButton(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDrawnButtonWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateDrawnButton(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/FileSB.h>

static PyObject *
widget_CreateFileSelectionBox(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmFileSelectionBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateFileSelectionBox(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateFileSelectionDialog(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	wClist[1] = xmFileSelectionBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateFileSelectionDialog(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_FileSelectionDoSearch(self, args)
	widgetobject *self;
	PyObject *args;
{
	char *arg1; XmString tmp_arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmFileSelectionDoSearch(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)));
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_FileSelectionBoxGetChild(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	int arg1;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmFileSelectionBoxGetChild(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/Form.h>

static PyObject *
widget_CreateForm(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmFormWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateForm(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateFormDialog(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	wClist[1] = xmFormWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateFormDialog(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/Frame.h>

static PyObject *
widget_CreateFrame(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmFrameWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateFrame(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/Label.h>

static PyObject *
widget_CreateLabel(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmLabelWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateLabel(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/LabelG.h>

static PyObject *
widget_CreateLabelGadget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmLabelGadgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateLabelGadget(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/List.h>

static PyObject *
widget_CreateList(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmListWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateList(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/MainW.h>

static PyObject *
widget_CreateMainWindow(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmMainWindowWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateMainWindow(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_MainWindowSep1(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmMainWindowSep1(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_MainWindowSep2(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmMainWindowSep2(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_MainWindowSep3(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmMainWindowSep3(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_MainWindowSetAreas(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1;
	PyObject *arg2;
	PyObject *arg3;
	PyObject *arg4;
	PyObject *arg5;
	if (!PyArg_ParseTuple(args, "OOOOO",
			&arg1,
			&arg2,
			&arg3,
			&arg4,
			&arg5))
		return NULL;
	if (!is_optwidgetobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be optWidget");
		return NULL;
	}
	if (!is_optwidgetobject(arg2)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be optWidget");
		return NULL;
	}
	if (!is_optwidgetobject(arg3)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg3 should be optWidget");
		return NULL;
	}
	if (!is_optwidgetobject(arg4)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg4 should be optWidget");
		return NULL;
	}
	if (!is_optwidgetobject(arg5)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg5 should be optWidget");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmMainWindowSetAreas(self->ob_widget,
			getoptwidgetvalue(arg1),
			getoptwidgetvalue(arg2),
			getoptwidgetvalue(arg3),
			getoptwidgetvalue(arg4),
			getoptwidgetvalue(arg5));
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#include <Xm/MenuShell.h>

static PyObject *
widget_CreateMenuShell(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmMenuShellWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateMenuShell(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/MessageB.h>

static PyObject *
widget_CreateMessageBox(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmMessageBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateMessageBox(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_MessageBoxGetChild(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	int arg1;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmMessageBoxGetChild(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyMethodDef messageboxwidget_methods[] = {
	{"MessageBoxGetChild", (PyCFunction)widget_MessageBoxGetChild, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain messageboxwidget_methodchain = {
	messageboxwidget_methods,
	&compositewidget_methodchain,
};

static PyObject *
widget_CreateErrorDialog(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	wClist[1] = xmMessageBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateErrorDialog(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateInformationDialog(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	wClist[1] = xmMessageBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateInformationDialog(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateMessageDialog(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	wClist[1] = xmMessageBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateMessageDialog(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateQuestionDialog(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	wClist[1] = xmMessageBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateQuestionDialog(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateWarningDialog(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	wClist[1] = xmMessageBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateWarningDialog(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateWorkingDialog(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	wClist[1] = xmMessageBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateWorkingDialog(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/PanedW.h>

static PyObject *
widget_CreatePanedWindow(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmPanedWindowWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreatePanedWindow(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/PushB.h>

static PyObject *
widget_CreatePushButton(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmPushButtonWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreatePushButton(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/PushBG.h>

static PyObject *
widget_CreatePushButtonGadget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmPushButtonGadgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreatePushButtonGadget(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/RowColumn.h>

static PyObject *
widget_CreateRowColumn(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateRowColumn(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateMenuBar(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateMenuBar(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateOptionMenu(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateOptionMenu(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreatePopupMenu(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreatePopupMenu(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreatePulldownMenu(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreatePulldownMenu(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateRadioBox(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateRadioBox(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_OptionButtonGadget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmOptionButtonGadget(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_OptionLabelGadget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmOptionLabelGadget(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_MenuPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!is_XEvent(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XButtonPressedEvent*");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmMenuPosition(self->ob_widget,
			(XButtonPressedEvent*)((X_Callbackobject*)(arg1))->event);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1001
static PyObject *
widget_GetPostedFromWidget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmGetPostedFromWidget(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1002
static PyObject *
widget_GetTearOffControl(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmGetTearOffControl(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1002 */
static PyMethodDef rowcolumnwidget_methods[] = {
#if XmVersion >= 1001
	{"GetPostedFromWidget", (PyCFunction)widget_GetPostedFromWidget, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1002
	{"GetTearOffControl", (PyCFunction)widget_GetTearOffControl, 1},
#endif /* XmVersion >= 1002 */
	{"MenuPosition", (PyCFunction)widget_MenuPosition, 1},
	{"OptionButtonGadget", (PyCFunction)widget_OptionButtonGadget, 1},
	{"OptionLabelGadget", (PyCFunction)widget_OptionLabelGadget, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain rowcolumnwidget_methodchain = {
	rowcolumnwidget_methods,
	&compositewidget_methodchain,
};

#include <Xm/Scale.h>

static PyObject *
widget_CreateScale(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmScaleWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateScale(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_ScaleSetValue(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmScaleSetValue(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_ScaleGetValue(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmScaleGetValue(self->ob_widget,
			&arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)arg1);
}

static PyMethodDef scalewidget_methods[] = {
	{"ScaleGetValue", (PyCFunction)widget_ScaleGetValue, 1},
	{"ScaleSetValue", (PyCFunction)widget_ScaleSetValue, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain scalewidget_methodchain = {
	scalewidget_methods,
	&compositewidget_methodchain,
};

#include <Xm/ScrollBar.h>

static PyObject *
widget_CreateScrollBar(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmScrollBarWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateScrollBar(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_ScrollBarGetValues(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	int arg3;
	int arg4;
	PyObject *retval;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmScrollBarGetValues(self->ob_widget,
			&arg1,
			&arg2,
			&arg3,
			&arg4);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	retval = PyTuple_New(4);
	PyTuple_SetItem(retval, 0, PyInt_FromLong((long)arg1));
	PyTuple_SetItem(retval, 1, PyInt_FromLong((long)arg2));
	PyTuple_SetItem(retval, 2, PyInt_FromLong((long)arg3));
	PyTuple_SetItem(retval, 3, PyInt_FromLong((long)arg4));
	if (PyErr_Occurred()) {
		Py_XDECREF(retval);
		return NULL;
	}
	return retval;
}

static PyObject *
widget_ScrollBarSetValues(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	int arg3;
	int arg4;
	int arg5;
	if (!PyArg_ParseTuple(args, "iiiii",
			&arg1,
			&arg2,
			&arg3,
			&arg4,
			&arg5))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmScrollBarSetValues(self->ob_widget,
			arg1,
			arg2,
			arg3,
			arg4,
			(Boolean)arg5);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef scrollbarwidget_methods[] = {
	{"ScrollBarGetValues", (PyCFunction)widget_ScrollBarGetValues, 1},
	{"ScrollBarSetValues", (PyCFunction)widget_ScrollBarSetValues, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain scrollbarwidget_methodchain = {
	scrollbarwidget_methods,
	&widget_methodchain,
};

#include <Xm/ScrolledW.h>

static PyObject *
widget_CreateScrolledWindow(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmScrolledWindowWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateScrolledWindow(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#if XmVersion >= 1002
static PyObject *
widget_ScrollVisible(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1;
	Dimension arg2;
	Dimension arg3;
	if (!PyArg_ParseTuple(args, "Ohh",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!is_widgetobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Widget");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmScrollVisible(self->ob_widget,
			getwidgetvalue(arg1),
			arg2,
			arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
static PyObject *
widget_ScrolledWindowSetAreas(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1;
	PyObject *arg2;
	PyObject *arg3;
	if (!PyArg_ParseTuple(args, "OOO",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!is_widgetobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Widget");
		return NULL;
	}
	if (!is_widgetobject(arg2)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be Widget");
		return NULL;
	}
	if (!is_widgetobject(arg3)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg3 should be Widget");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmScrolledWindowSetAreas(self->ob_widget,
			getwidgetvalue(arg1),
			getwidgetvalue(arg2),
			getwidgetvalue(arg3));
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef scrolledwindowwidget_methods[] = {
#if XmVersion >= 1002
	{"ScrollVisible", (PyCFunction)widget_ScrollVisible, 1},
#endif /* XmVersion >= 1002 */
	{"ScrolledWindowSetAreas", (PyCFunction)widget_ScrolledWindowSetAreas, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain scrolledwindowwidget_methodchain = {
	scrolledwindowwidget_methods,
	&compositewidget_methodchain,
};

static PyMethodDef mainwindowwidget_methods[] = {
	{"MainWindowSep1", (PyCFunction)widget_MainWindowSep1, 1},
	{"MainWindowSep2", (PyCFunction)widget_MainWindowSep2, 1},
	{"MainWindowSep3", (PyCFunction)widget_MainWindowSep3, 1},
	{"MainWindowSetAreas", (PyCFunction)widget_MainWindowSetAreas, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain mainwindowwidget_methodchain = {
	mainwindowwidget_methods,
	&scrolledwindowwidget_methodchain,
};

static PyObject *
widget_CreateScrolledList(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmScrolledWindowWidgetClass;
	wClist[1] = xmListWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateScrolledList(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/SelectioB.h>

static PyObject *
widget_CreateSelectionBox(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmSelectionBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateSelectionBox(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_SelectionBoxGetChild(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	int arg1;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmSelectionBoxGetChild(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyMethodDef selectionboxwidget_methods[] = {
	{"SelectionBoxGetChild", (PyCFunction)widget_SelectionBoxGetChild, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain selectionboxwidget_methodchain = {
	selectionboxwidget_methods,
	&compositewidget_methodchain,
};

static PyMethodDef fileselectionwidget_methods[] = {
	{"FileSelectionBoxGetChild", (PyCFunction)widget_FileSelectionBoxGetChild, 1},
	{"FileSelectionDoSearch", (PyCFunction)widget_FileSelectionDoSearch, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain fileselectionwidget_methodchain = {
	fileselectionwidget_methods,
	&selectionboxwidget_methodchain,
};

static PyMethodDef commandwidget_methods[] = {
	{"CommandAppendValue", (PyCFunction)widget_CommandAppendValue, 1},
	{"CommandError", (PyCFunction)widget_CommandError, 1},
	{"CommandGetChild", (PyCFunction)widget_CommandGetChild, 1},
	{"CommandSetValue", (PyCFunction)widget_CommandSetValue, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain commandwidget_methodchain = {
	commandwidget_methods,
	&selectionboxwidget_methodchain,
};

static PyObject *
widget_CreatePromptDialog(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	wClist[1] = xmSelectionBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreatePromptDialog(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateSelectionDialog(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	wClist[1] = xmSelectionBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateSelectionDialog(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/Separator.h>

static PyObject *
widget_CreateSeparator(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmSeparatorWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateSeparator(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/SeparatoG.h>

static PyObject *
widget_CreateSeparatorGadget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmSeparatorGadgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateSeparatorGadget(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/Text.h>

static PyObject *
widget_CreateText(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmTextWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateText(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateScrolledText(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmScrolledWindowWidgetClass;
	wClist[1] = xmTextWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateScrolledText(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#include <Xm/ToggleB.h>

static PyObject *
widget_CreateToggleButton(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmToggleButtonWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateToggleButton(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_ToggleButtonGetState(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmToggleButtonGetState(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
widget_ToggleButtonSetState(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "ii",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmToggleButtonSetState(self->ob_widget,
			(Boolean)arg1,
			(Boolean)arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef togglebuttonwidget_methods[] = {
	{"ToggleButtonGetState", (PyCFunction)widget_ToggleButtonGetState, 1},
	{"ToggleButtonSetState", (PyCFunction)widget_ToggleButtonSetState, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain togglebuttonwidget_methodchain = {
	togglebuttonwidget_methods,
	&widget_methodchain,
};

#include <Xm/ToggleBG.h>

static PyObject *
widget_CreateToggleButtonGadget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmToggleButtonGadgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateToggleButtonGadget(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_ToggleButtonGadgetGetState(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmToggleButtonGadgetGetState(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
widget_ToggleButtonGadgetSetState(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "ii",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmToggleButtonGadgetSetState(self->ob_widget,
			(Boolean)arg1,
			(Boolean)arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef togglebuttongadget_methods[] = {
	{"ToggleButtonGadgetGetState", (PyCFunction)widget_ToggleButtonGadgetGetState, 1},
	{"ToggleButtonGadgetSetState", (PyCFunction)widget_ToggleButtonGadgetSetState, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain togglebuttongadget_methodchain = {
	togglebuttongadget_methods,
	&widget_methodchain,
};

#if XmVersion >= 1001
static PyObject *
widget_CreateSimpleCheckBox(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateSimpleCheckBox(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_CreateSimpleMenuBar(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateSimpleMenuBar(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_CreateSimpleOptionMenu(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateSimpleOptionMenu(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_CreateSimplePopupMenu(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateSimplePopupMenu(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_CreateSimplePulldownMenu(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateSimplePulldownMenu(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_CreateSimpleRadioBox(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateSimpleRadioBox(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
#include <Xm/TextF.h>

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_CreateTextField(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmTextFieldWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateTextField(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_CreateWorkArea(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmRowColumnWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateWorkArea(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1002
#include <Xm/DragDrop.h>

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
#include <Xm/DragIcon.h>

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_CreateDragIcon(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDragIconObjectClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateDragIcon(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_DragCancel(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmDragCancel(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_DropSiteConfigureStackingOrder(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1;
	Cardinal arg2;
	if (!PyArg_ParseTuple(args, "Oi",
			&arg1,
			&arg2))
		return NULL;
	if (!is_widgetobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Widget");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmDropSiteConfigureStackingOrder(self->ob_widget,
			getwidgetvalue(arg1),
			arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyMethodDef dropsitewidget_methods[] = {
#if XmVersion >= 1002
	{"DropSiteConfigureStackingOrder", (PyCFunction)widget_DropSiteConfigureStackingOrder, 1},
#endif /* XmVersion >= 1002 */
	{0, 0} /* Sentinel */
};
PyMethodChain dropsitewidget_methodchain = {
	dropsitewidget_methods,
	&widget_methodchain,
};

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_DropSiteEndUpdate(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmDropSiteEndUpdate(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_DropSiteStartUpdate(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmDropSiteStartUpdate(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_DropSiteUnregister(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmDropSiteUnregister(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_DropSiteUpdate(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg1, *dict; ArgList tmp_arg1; int nargs_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	w = self->ob_widget;
	wClist[0] = XtClass(w);
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), w, arg1, &tmp_arg1, &nargs_arg1))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmDropSiteUpdate(w,
			tmp_arg1, nargs_arg1);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyMethodDef droptransferwidget_methods[] = {
	{0, 0} /* Sentinel */
};
PyMethodChain droptransferwidget_methodchain = {
	droptransferwidget_methods,
	&widget_methodchain,
};

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyMethodDef dragwidget_methods[] = {
#if XmVersion >= 1002
	{"DragCancel", (PyCFunction)widget_DragCancel, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"DropTransferStart", (PyCFunction)widget_DropTransferStart, 1},
#endif /* XmVersion >= 1002 */
	{0, 0} /* Sentinel */
};
PyMethodChain dragwidget_methodchain = {
	dragwidget_methods,
	&widget_methodchain,
};

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_GetFocusWidget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmGetFocusWidget(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_GetVisibility(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmGetVisibility(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_IsTraversable(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmIsTraversable(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_ProcessTraversal(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmProcessTraversal(self->ob_widget,
			(XmTraversalDirection)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1002 */
#if !(XmVersion >= 1002)
static PyObject *
widget_ProcessTraversal(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmProcessTraversal(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* !(XmVersion >= 1002) */
static PyObject *
widget_AddTabGroup(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmAddTabGroup(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1002
static PyObject *
widget_GetTabGroup(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmGetTabGroup(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1001
static PyObject *
widget_RemoveTabGroup(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmRemoveTabGroup(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1002
static PyObject *
widget_CreateTemplateDialog(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	Widget w;
	WidgetClass wClist[2];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	wClist[0] = xmDialogShellWidgetClass;
	wClist[1] = xmMessageBoxWidgetClass;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmCreateTemplateDialog(w,
			arg1,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1002 */
static PyObject *
widget_TextClearSelection(self, args)
	widgetobject *self;
	PyObject *args;
{
	Time arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextClearSelection(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldClearSelection(self, args)
	widgetobject *self;
	PyObject *args;
{
	Time arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextFieldClearSelection(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextCopy(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	Time arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextCopy(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextFieldCopy(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	Time arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldCopy(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextCut(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	Time arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextCut(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextFieldCut(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	Time arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldCut(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1002
static PyObject *
widget_TextDisableRedisplay(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextDisableRedisplay(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_TextEnableRedisplay(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextEnableRedisplay(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_TextFindString(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	XmTextPosition arg1;
	char *arg2;
	XmTextDirection arg3;
	XmTextPosition arg4;
	if (!PyArg_ParseTuple(args, "lsl",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFindString(self->ob_widget,
			arg1,
			arg2,
			arg3,
			&arg4);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	if (!result) {
		Py_INCREF(Py_None);
		return Py_None;
	}
	return PyInt_FromLong((long)arg4);
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1001
static PyObject *
widget_TextGetBaseline(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextGetBaseline(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextFieldGetBaseline(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldGetBaseline(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextGetEditable(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextGetEditable(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldGetEditable(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldGetEditable(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextGetInsertionPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextGetInsertionPosition(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldGetInsertionPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldGetInsertionPosition(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextGetLastPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextGetLastPosition(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldGetLastPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldGetLastPosition(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextGetMaxLength(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextGetMaxLength(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldGetMaxLength(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldGetMaxLength(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextGetSelection(self, args)
	widgetobject *self;
	PyObject *args;
{
	String result;
	PyObject *retval;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextGetSelection(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	retval = PyString_FromString(result);
	XtFree(result);
	return retval;
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldGetSelection(self, args)
	widgetobject *self;
	PyObject *args;
{
	String result;
	PyObject *retval;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldGetSelection(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	retval = PyString_FromString(result);
	XtFree(result);
	return retval;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextGetSelectionPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	XmTextPosition arg1;
	XmTextPosition arg2;
	PyObject *retval;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextGetSelectionPosition(self->ob_widget,
			&arg1,
			&arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	retval = PyTuple_New(3);
	PyTuple_SetItem(retval, 0, PyInt_FromLong((long)result));
	PyTuple_SetItem(retval, 1, PyInt_FromLong((long)arg1));
	PyTuple_SetItem(retval, 2, PyInt_FromLong((long)arg2));
	if (PyErr_Occurred()) {
		Py_XDECREF(retval);
		return NULL;
	}
	return retval;
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldGetSelectionPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	XmTextPosition arg1;
	XmTextPosition arg2;
	PyObject *retval;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldGetSelectionPosition(self->ob_widget,
			&arg1,
			&arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	retval = PyTuple_New(3);
	PyTuple_SetItem(retval, 0, PyInt_FromLong((long)result));
	PyTuple_SetItem(retval, 1, PyInt_FromLong((long)arg1));
	PyTuple_SetItem(retval, 2, PyInt_FromLong((long)arg2));
	if (PyErr_Occurred()) {
		Py_XDECREF(retval);
		return NULL;
	}
	return retval;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextGetSource(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextSource result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextGetSource(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
widget_TextGetString(self, args)
	widgetobject *self;
	PyObject *args;
{
	String result;
	PyObject *retval;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextGetString(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	retval = PyString_FromString(result);
	XtFree(result);
	return retval;
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldGetString(self, args)
	widgetobject *self;
	PyObject *args;
{
	String result;
	PyObject *retval;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldGetString(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	retval = PyString_FromString(result);
	XtFree(result);
	return retval;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextGetTopCharacter(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextGetTopCharacter(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextInsert(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	String arg2;
	if (!PyArg_ParseTuple(args, "ls",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextInsert(self->ob_widget,
			arg1,
			arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextFieldInsert(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	String arg2;
	if (!PyArg_ParseTuple(args, "ls",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextFieldInsert(self->ob_widget,
			arg1,
			arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextPaste(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextPaste(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextFieldPaste(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldPaste(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextPosToXY(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	XmTextPosition arg1;
	Position arg2;
	Position arg3;
	PyObject *retval;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextPosToXY(self->ob_widget,
			arg1,
			&arg2,
			&arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	if (!result) {
		Py_INCREF(Py_None);
		return Py_None;
	}
	retval = PyTuple_New(2);
	PyTuple_SetItem(retval, 0, PyInt_FromLong((long)arg2));
	PyTuple_SetItem(retval, 1, PyInt_FromLong((long)arg3));
	if (PyErr_Occurred()) {
		Py_XDECREF(retval);
		return NULL;
	}
	return retval;
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldPosToXY(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	XmTextPosition arg1;
	Position arg2;
	Position arg3;
	PyObject *retval;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldPosToXY(self->ob_widget,
			arg1,
			&arg2,
			&arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	if (!result) {
		Py_INCREF(Py_None);
		return Py_None;
	}
	retval = PyTuple_New(2);
	PyTuple_SetItem(retval, 0, PyInt_FromLong((long)arg2));
	PyTuple_SetItem(retval, 1, PyInt_FromLong((long)arg3));
	if (PyErr_Occurred()) {
		Py_XDECREF(retval);
		return NULL;
	}
	return retval;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextRemove(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextRemove(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextFieldRemove(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldRemove(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextReplace(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	XmTextPosition arg2;
	String arg3;
	if (!PyArg_ParseTuple(args, "lls",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextReplace(self->ob_widget,
			arg1,
			arg2,
			arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldReplace(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	XmTextPosition arg2;
	String arg3;
	if (!PyArg_ParseTuple(args, "lls",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextFieldReplace(self->ob_widget,
			arg1,
			arg2,
			arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextScroll(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextScroll(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1001
static PyObject *
widget_TextSetAddMode(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextSetAddMode(self->ob_widget,
			(Boolean)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextFieldSetAddMode(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextFieldSetAddMode(self->ob_widget,
			(Boolean)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextSetEditable(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextSetEditable(self->ob_widget,
			(Boolean)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldSetEditable(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextFieldSetEditable(self->ob_widget,
			(Boolean)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextSetHighlight(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	XmTextPosition arg2;
	XmHighlightMode arg3;
	if (!PyArg_ParseTuple(args, "lli",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextSetHighlight(self->ob_widget,
			arg1,
			arg2,
			arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextFieldSetHighlight(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	XmTextPosition arg2;
	XmHighlightMode arg3;
	if (!PyArg_ParseTuple(args, "lli",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextFieldSetHighlight(self->ob_widget,
			arg1,
			arg2,
			arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextSetInsertionPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextSetInsertionPosition(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldSetInsertionPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextFieldSetInsertionPosition(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextSetMaxLength(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextSetMaxLength(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldSetMaxLength(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextFieldSetMaxLength(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextSetSelection(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	XmTextPosition arg2;
	Time arg3;
	if (!PyArg_ParseTuple(args, "lll",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextSetSelection(self->ob_widget,
			arg1,
			arg2,
			arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldSetSelection(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	XmTextPosition arg2;
	Time arg3;
	if (!PyArg_ParseTuple(args, "lll",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextFieldSetSelection(self->ob_widget,
			arg1,
			arg2,
			arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextSetSource(self, args)
	widgetobject *self;
	PyObject *args;
{
	long arg1;
	XmTextPosition arg2;
	XmTextPosition arg3;
	if (!PyArg_ParseTuple(args, "lll",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextSetSource(self->ob_widget,
			(XmTextSource)arg1,
			arg2,
			arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_TextSetString(self, args)
	widgetobject *self;
	PyObject *args;
{
	String arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextSetString(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldSetString(self, args)
	widgetobject *self;
	PyObject *args;
{
	String arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextFieldSetString(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
static PyObject *
widget_TextSetTopCharacter(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextSetTopCharacter(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextShowPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextShowPosition(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldShowPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmTextFieldShowPosition(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_TextXYToPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition result;
	Position arg1;
	Position arg2;
	if (!PyArg_ParseTuple(args, "hh",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextXYToPos(self->ob_widget,
			arg1,
			arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#if XmVersion >= 1001
static PyObject *
widget_TextFieldXYToPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	XmTextPosition result;
	Position arg1;
	Position arg2;
	if (!PyArg_ParseTuple(args, "hh",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTextFieldXYToPos(self->ob_widget,
			arg1,
			arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
static PyMethodDef textwidget_methods[] = {
	{"TextClearSelection", (PyCFunction)widget_TextClearSelection, 1},
#if XmVersion >= 1001
	{"TextCopy", (PyCFunction)widget_TextCopy, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextCut", (PyCFunction)widget_TextCut, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1002
	{"TextDisableRedisplay", (PyCFunction)widget_TextDisableRedisplay, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"TextEnableRedisplay", (PyCFunction)widget_TextEnableRedisplay, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"TextFindString", (PyCFunction)widget_TextFindString, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1001
	{"TextGetBaseline", (PyCFunction)widget_TextGetBaseline, 1},
#endif /* XmVersion >= 1001 */
	{"TextGetEditable", (PyCFunction)widget_TextGetEditable, 1},
	{"TextGetInsertionPosition", (PyCFunction)widget_TextGetInsertionPosition, 1},
	{"TextGetLastPosition", (PyCFunction)widget_TextGetLastPosition, 1},
	{"TextGetMaxLength", (PyCFunction)widget_TextGetMaxLength, 1},
	{"TextGetSelection", (PyCFunction)widget_TextGetSelection, 1},
	{"TextGetSelectionPosition", (PyCFunction)widget_TextGetSelectionPosition, 1},
	{"TextGetSource", (PyCFunction)widget_TextGetSource, 1},
	{"TextGetString", (PyCFunction)widget_TextGetString, 1},
#if XmVersion >= 1001
	{"TextGetTopCharacter", (PyCFunction)widget_TextGetTopCharacter, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextInsert", (PyCFunction)widget_TextInsert, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextPaste", (PyCFunction)widget_TextPaste, 1},
#endif /* XmVersion >= 1001 */
	{"TextPosToXY", (PyCFunction)widget_TextPosToXY, 1},
#if XmVersion >= 1001
	{"TextRemove", (PyCFunction)widget_TextRemove, 1},
#endif /* XmVersion >= 1001 */
	{"TextReplace", (PyCFunction)widget_TextReplace, 1},
	{"TextScroll", (PyCFunction)widget_TextScroll, 1},
#if XmVersion >= 1001
	{"TextSetAddMode", (PyCFunction)widget_TextSetAddMode, 1},
#endif /* XmVersion >= 1001 */
	{"TextSetEditable", (PyCFunction)widget_TextSetEditable, 1},
#if XmVersion >= 1001
	{"TextSetHighlight", (PyCFunction)widget_TextSetHighlight, 1},
#endif /* XmVersion >= 1001 */
	{"TextSetInsertionPosition", (PyCFunction)widget_TextSetInsertionPosition, 1},
	{"TextSetMaxLength", (PyCFunction)widget_TextSetMaxLength, 1},
	{"TextSetSelection", (PyCFunction)widget_TextSetSelection, 1},
	{"TextSetSource", (PyCFunction)widget_TextSetSource, 1},
	{"TextSetString", (PyCFunction)widget_TextSetString, 1},
#if XmVersion >= 1001
	{"TextSetTopCharacter", (PyCFunction)widget_TextSetTopCharacter, 1},
#endif /* XmVersion >= 1001 */
	{"TextShowPosition", (PyCFunction)widget_TextShowPosition, 1},
	{"TextXYToPos", (PyCFunction)widget_TextXYToPos, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain textwidget_methodchain = {
	textwidget_methods,
	&widget_methodchain,
};

static PyMethodDef textfieldwidget_methods[] = {
#if XmVersion >= 1001
	{"TextFieldClearSelection", (PyCFunction)widget_TextFieldClearSelection, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldCopy", (PyCFunction)widget_TextFieldCopy, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldCut", (PyCFunction)widget_TextFieldCut, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldGetBaseline", (PyCFunction)widget_TextFieldGetBaseline, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldGetEditable", (PyCFunction)widget_TextFieldGetEditable, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldGetInsertionPosition", (PyCFunction)widget_TextFieldGetInsertionPosition, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldGetLastPosition", (PyCFunction)widget_TextFieldGetLastPosition, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldGetMaxLength", (PyCFunction)widget_TextFieldGetMaxLength, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldGetSelection", (PyCFunction)widget_TextFieldGetSelection, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldGetSelectionPosition", (PyCFunction)widget_TextFieldGetSelectionPosition, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldGetString", (PyCFunction)widget_TextFieldGetString, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldInsert", (PyCFunction)widget_TextFieldInsert, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldPaste", (PyCFunction)widget_TextFieldPaste, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldPosToXY", (PyCFunction)widget_TextFieldPosToXY, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldRemove", (PyCFunction)widget_TextFieldRemove, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldReplace", (PyCFunction)widget_TextFieldReplace, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldSetAddMode", (PyCFunction)widget_TextFieldSetAddMode, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldSetEditable", (PyCFunction)widget_TextFieldSetEditable, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldSetHighlight", (PyCFunction)widget_TextFieldSetHighlight, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldSetInsertionPosition", (PyCFunction)widget_TextFieldSetInsertionPosition, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldSetMaxLength", (PyCFunction)widget_TextFieldSetMaxLength, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldSetSelection", (PyCFunction)widget_TextFieldSetSelection, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldSetString", (PyCFunction)widget_TextFieldSetString, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldShowPosition", (PyCFunction)widget_TextFieldShowPosition, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"TextFieldXYToPos", (PyCFunction)widget_TextFieldXYToPos, 1},
#endif /* XmVersion >= 1001 */
	{0, 0} /* Sentinel */
};
PyMethodChain textfieldwidget_methodchain = {
	textfieldwidget_methods,
	&widget_methodchain,
};

static PyObject *
widget_ListAddItem(self, args)
	widgetobject *self;
	PyObject *args;
{
	char *arg1; XmString tmp_arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "si",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListAddItem(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)),
			arg2);
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_ListAddItems(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1; XmString *tmp_arg1; int nstrs_arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "Oi",
			&arg1,
			&arg2))
		return NULL;
	if (!checkxmstringlist(arg1, &tmp_arg1, &nstrs_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XmStringList");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListAddItems(self->ob_widget,
			tmp_arg1, nstrs_arg1,
			arg2);
		jump_flag = 0;
	}
	while (--nstrs_arg1 >= 0) XmStringFree(tmp_arg1[nstrs_arg1]); PyMem_DEL(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_ListAddItemUnselected(self, args)
	widgetobject *self;
	PyObject *args;
{
	char *arg1; XmString tmp_arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "si",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListAddItemUnselected(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)),
			arg2);
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1002
static PyObject *
widget_ListAddItemsUnselected(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1; XmString *tmp_arg1; int nstrs_arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "Oi",
			&arg1,
			&arg2))
		return NULL;
	if (!checkxmstringlist(arg1, &tmp_arg1, &nstrs_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XmStringList");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListAddItemsUnselected(self->ob_widget,
			tmp_arg1, nstrs_arg1,
			arg2);
		jump_flag = 0;
	}
	while (--nstrs_arg1 >= 0) XmStringFree(tmp_arg1[nstrs_arg1]); PyMem_DEL(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1001
static PyObject *
widget_ListDeleteAllItems(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListDeleteAllItems(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_ListDeleteItem(self, args)
	widgetobject *self;
	PyObject *args;
{
	char *arg1; XmString tmp_arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListDeleteItem(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)));
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_ListDeleteItems(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1; XmString *tmp_arg1; int nstrs_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!checkxmstringlist(arg1, &tmp_arg1, &nstrs_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XmStringList");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListDeleteItems(self->ob_widget,
			tmp_arg1, nstrs_arg1);
		jump_flag = 0;
	}
	while (--nstrs_arg1 >= 0) XmStringFree(tmp_arg1[nstrs_arg1]); PyMem_DEL(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1001
static PyObject *
widget_ListDeleteItemsPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "ii",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListDeleteItemsPos(self->ob_widget,
			arg1,
			arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_ListDeletePos(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListDeletePos(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1002
static PyObject *
widget_ListDeletePositions(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1; int *ints_arg1; int nints_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!checkintlist(arg1, sizeof(int), &ints_arg1, &nints_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be intlist");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListDeletePositions(self->ob_widget,
			ints_arg1, nints_arg1);
		jump_flag = 0;
	}
	PyMem_DEL(ints_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
static PyObject *
widget_ListDeselectAllItems(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListDeselectAllItems(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_ListDeselectItem(self, args)
	widgetobject *self;
	PyObject *args;
{
	char *arg1; XmString tmp_arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListDeselectItem(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)));
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_ListDeselectPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListDeselectPos(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1002
static PyObject *
widget_ListGetKbdItemPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmListGetKbdItemPos(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1002 */
static PyObject *
widget_ListItemExists(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	char *arg1; XmString tmp_arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmListItemExists(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)));
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#if XmVersion >= 1001
static PyObject *
widget_ListItemPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	char *arg1; XmString tmp_arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmListItemPos(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)));
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1001 */
#if XmVersion >= 1002
static PyObject *
widget_ListPosSelected(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmListPosSelected(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_ListPosToBounds(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	int arg1;
	Position arg2;
	Position arg3;
	Dimension arg4;
	Dimension arg5;
	PyObject *retval;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmListPosToBounds(self->ob_widget,
			arg1,
			&arg2,
			&arg3,
			&arg4,
			&arg5);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	if (!result) {
		Py_INCREF(Py_None);
		return Py_None;
	}
	retval = PyTuple_New(4);
	PyTuple_SetItem(retval, 0, PyInt_FromLong((long)arg2));
	PyTuple_SetItem(retval, 1, PyInt_FromLong((long)arg3));
	PyTuple_SetItem(retval, 2, PyInt_FromLong((long)arg4));
	PyTuple_SetItem(retval, 3, PyInt_FromLong((long)arg5));
	if (PyErr_Occurred()) {
		Py_XDECREF(retval);
		return NULL;
	}
	return retval;
}

#endif /* XmVersion >= 1002 */
static PyObject *
widget_ListReplaceItemsPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1; XmString *tmp_arg1; int nstrs_arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "Oi",
			&arg1,
			&arg2))
		return NULL;
	if (!checkxmstringlist(arg1, &tmp_arg1, &nstrs_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XmStringList");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListReplaceItemsPos(self->ob_widget,
			tmp_arg1, nstrs_arg1,
			arg2);
		jump_flag = 0;
	}
	while (--nstrs_arg1 >= 0) XmStringFree(tmp_arg1[nstrs_arg1]); PyMem_DEL(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1002
static PyObject *
widget_ListReplaceItemsPosUnselected(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1; XmString *tmp_arg1; int nstrs_arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "Oi",
			&arg1,
			&arg2))
		return NULL;
	if (!checkxmstringlist(arg1, &tmp_arg1, &nstrs_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XmStringList");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListReplaceItemsPosUnselected(self->ob_widget,
			tmp_arg1, nstrs_arg1,
			arg2);
		jump_flag = 0;
	}
	while (--nstrs_arg1 >= 0) XmStringFree(tmp_arg1[nstrs_arg1]); PyMem_DEL(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
static PyObject *
widget_ListSelectItem(self, args)
	widgetobject *self;
	PyObject *args;
{
	char *arg1; XmString tmp_arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "si",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListSelectItem(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)),
			(Boolean)arg2);
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_ListSelectPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "ii",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListSelectPos(self->ob_widget,
			arg1,
			(Boolean)arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1001
static PyObject *
widget_ListSetAddMode(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListSetAddMode(self->ob_widget,
			(Boolean)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_ListSetBottomItem(self, args)
	widgetobject *self;
	PyObject *args;
{
	char *arg1; XmString tmp_arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListSetBottomItem(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)));
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_ListSetBottomPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListSetBottomPos(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_ListSetHorizPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListSetHorizPos(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_ListSetItem(self, args)
	widgetobject *self;
	PyObject *args;
{
	char *arg1; XmString tmp_arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListSetItem(self->ob_widget,
			(tmp_arg1 = XmStringCreateLtoR(arg1, XmSTRING_DEFAULT_CHARSET)));
		jump_flag = 0;
	}
	XmStringFree(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1002
static PyObject *
widget_ListSetKbdItemPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListSetKbdItemPos(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
static PyObject *
widget_ListSetPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListSetPos(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1002
static PyObject *
widget_ListUpdateSelectedList(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListUpdateSelectedList(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
static PyObject *
widget_ListYToPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	Position arg1;
	if (!PyArg_ParseTuple(args, "h",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmListYToPos(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

#endif /* XmVersion >= 1002 */
static PyMethodDef listwidget_methods[] = {
	{"ListAddItem", (PyCFunction)widget_ListAddItem, 1},
	{"ListAddItemUnselected", (PyCFunction)widget_ListAddItemUnselected, 1},
	{"ListAddItems", (PyCFunction)widget_ListAddItems, 1},
#if XmVersion >= 1002
	{"ListAddItemsUnselected", (PyCFunction)widget_ListAddItemsUnselected, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1001
	{"ListDeleteAllItems", (PyCFunction)widget_ListDeleteAllItems, 1},
#endif /* XmVersion >= 1001 */
	{"ListDeleteItem", (PyCFunction)widget_ListDeleteItem, 1},
	{"ListDeleteItems", (PyCFunction)widget_ListDeleteItems, 1},
#if XmVersion >= 1001
	{"ListDeleteItemsPos", (PyCFunction)widget_ListDeleteItemsPos, 1},
#endif /* XmVersion >= 1001 */
	{"ListDeletePos", (PyCFunction)widget_ListDeletePos, 1},
#if XmVersion >= 1002
	{"ListDeletePositions", (PyCFunction)widget_ListDeletePositions, 1},
#endif /* XmVersion >= 1002 */
	{"ListDeselectAllItems", (PyCFunction)widget_ListDeselectAllItems, 1},
	{"ListDeselectItem", (PyCFunction)widget_ListDeselectItem, 1},
	{"ListDeselectPos", (PyCFunction)widget_ListDeselectPos, 1},
#if XmVersion >= 1002
	{"ListGetKbdItemPos", (PyCFunction)widget_ListGetKbdItemPos, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1001
	{"ListGetSelectedPos", (PyCFunction)widget_ListGetSelectedPos, 1},
#endif /* XmVersion >= 1001 */
	{"ListItemExists", (PyCFunction)widget_ListItemExists, 1},
#if XmVersion >= 1001
	{"ListItemPos", (PyCFunction)widget_ListItemPos, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1002
	{"ListPosSelected", (PyCFunction)widget_ListPosSelected, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"ListPosToBounds", (PyCFunction)widget_ListPosToBounds, 1},
#endif /* XmVersion >= 1002 */
	{"ListReplaceItems", (PyCFunction)widget_ListReplaceItems, 1},
	{"ListReplaceItemsPos", (PyCFunction)widget_ListReplaceItemsPos, 1},
#if XmVersion >= 1002
	{"ListReplaceItemsPosUnselected", (PyCFunction)widget_ListReplaceItemsPosUnselected, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"ListReplaceItemsUnselected", (PyCFunction)widget_ListReplaceItemsUnselected, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"ListReplacePositions", (PyCFunction)widget_ListReplacePositions, 1},
#endif /* XmVersion >= 1002 */
	{"ListSelectItem", (PyCFunction)widget_ListSelectItem, 1},
	{"ListSelectPos", (PyCFunction)widget_ListSelectPos, 1},
#if XmVersion >= 1001
	{"ListSetAddMode", (PyCFunction)widget_ListSetAddMode, 1},
#endif /* XmVersion >= 1001 */
	{"ListSetBottomItem", (PyCFunction)widget_ListSetBottomItem, 1},
	{"ListSetBottomPos", (PyCFunction)widget_ListSetBottomPos, 1},
	{"ListSetHorizPos", (PyCFunction)widget_ListSetHorizPos, 1},
	{"ListSetItem", (PyCFunction)widget_ListSetItem, 1},
#if XmVersion >= 1002
	{"ListSetKbdItemPos", (PyCFunction)widget_ListSetKbdItemPos, 1},
#endif /* XmVersion >= 1002 */
	{"ListSetPos", (PyCFunction)widget_ListSetPos, 1},
#if XmVersion >= 1002
	{"ListUpdateSelectedList", (PyCFunction)widget_ListUpdateSelectedList, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"ListYToPos", (PyCFunction)widget_ListYToPos, 1},
#endif /* XmVersion >= 1002 */
	{0, 0} /* Sentinel */
};
PyMethodChain listwidget_methodchain = {
	listwidget_methods,
	&widget_methodchain,
};

#if XmVersion >= 1002
static PyObject *
widget_TrackingEvent(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	Cursor arg1;
	int arg2;
	XEvent arg3;
	PyObject *retval;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, "li",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTrackingEvent(self->ob_widget,
			arg1,
			(Boolean)arg2,
			&arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	retval = PyTuple_New(2);
	PyTuple_SetItem(retval, 0, (PyObject *)newwidgetobject(result, &widget_methodchain, dict));
	PyTuple_SetItem(retval, 1, xev_new((XtPointer)&arg3, 0, 1));
	if (PyErr_Occurred()) {
		Py_XDECREF(retval);
		return NULL;
	}
	return retval;
}

#endif /* XmVersion >= 1002 */
#if XmVersion >= 1001
static PyObject *
widget_TrackingLocate(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	Cursor arg1;
	int arg2;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, "li",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmTrackingLocate(self->ob_widget,
			arg1,
			(Boolean)arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

#endif /* XmVersion >= 1001 */
static PyObject *
widget_UpdateDisplay(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmUpdateDisplay(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef Xmw_methods[] = {
	{"AddTabGroup", (PyCFunction)widget_AddTabGroup, 1},
#if XmVersion >= 1002
	{"ChangeColor", (PyCFunction)widget_ChangeColor, 1},
#endif /* XmVersion >= 1002 */
	{"ConvertUnits", (PyCFunction)widget_ConvertUnits, 1},
	{"CreateArrowButton", (PyCFunction)widget_CreateArrowButton, 1},
	{"CreateArrowButtonGadget", (PyCFunction)widget_CreateArrowButtonGadget, 1},
	{"CreateBulletinBoard", (PyCFunction)widget_CreateBulletinBoard, 1},
	{"CreateBulletinBoardDialog", (PyCFunction)widget_CreateBulletinBoardDialog, 1},
	{"CreateCascadeButton", (PyCFunction)widget_CreateCascadeButton, 1},
	{"CreateCascadeButtonGadget", (PyCFunction)widget_CreateCascadeButtonGadget, 1},
	{"CreateCommand", (PyCFunction)widget_CreateCommand, 1},
	{"CreateDialogShell", (PyCFunction)widget_CreateDialogShell, 1},
#if XmVersion >= 1002
	{"CreateDragIcon", (PyCFunction)widget_CreateDragIcon, 1},
#endif /* XmVersion >= 1002 */
	{"CreateDrawingArea", (PyCFunction)widget_CreateDrawingArea, 1},
	{"CreateDrawnButton", (PyCFunction)widget_CreateDrawnButton, 1},
	{"CreateErrorDialog", (PyCFunction)widget_CreateErrorDialog, 1},
	{"CreateFileSelectionBox", (PyCFunction)widget_CreateFileSelectionBox, 1},
	{"CreateFileSelectionDialog", (PyCFunction)widget_CreateFileSelectionDialog, 1},
	{"CreateForm", (PyCFunction)widget_CreateForm, 1},
	{"CreateFormDialog", (PyCFunction)widget_CreateFormDialog, 1},
	{"CreateFrame", (PyCFunction)widget_CreateFrame, 1},
	{"CreateInformationDialog", (PyCFunction)widget_CreateInformationDialog, 1},
	{"CreateLabel", (PyCFunction)widget_CreateLabel, 1},
	{"CreateLabelGadget", (PyCFunction)widget_CreateLabelGadget, 1},
	{"CreateList", (PyCFunction)widget_CreateList, 1},
	{"CreateMainWindow", (PyCFunction)widget_CreateMainWindow, 1},
	{"CreateMenuBar", (PyCFunction)widget_CreateMenuBar, 1},
	{"CreateMenuShell", (PyCFunction)widget_CreateMenuShell, 1},
	{"CreateMessageBox", (PyCFunction)widget_CreateMessageBox, 1},
	{"CreateMessageDialog", (PyCFunction)widget_CreateMessageDialog, 1},
	{"CreateOptionMenu", (PyCFunction)widget_CreateOptionMenu, 1},
	{"CreatePanedWindow", (PyCFunction)widget_CreatePanedWindow, 1},
	{"CreatePopupMenu", (PyCFunction)widget_CreatePopupMenu, 1},
	{"CreatePromptDialog", (PyCFunction)widget_CreatePromptDialog, 1},
	{"CreatePulldownMenu", (PyCFunction)widget_CreatePulldownMenu, 1},
	{"CreatePushButton", (PyCFunction)widget_CreatePushButton, 1},
	{"CreatePushButtonGadget", (PyCFunction)widget_CreatePushButtonGadget, 1},
	{"CreateQuestionDialog", (PyCFunction)widget_CreateQuestionDialog, 1},
	{"CreateRadioBox", (PyCFunction)widget_CreateRadioBox, 1},
	{"CreateRowColumn", (PyCFunction)widget_CreateRowColumn, 1},
	{"CreateScale", (PyCFunction)widget_CreateScale, 1},
	{"CreateScrollBar", (PyCFunction)widget_CreateScrollBar, 1},
	{"CreateScrolledList", (PyCFunction)widget_CreateScrolledList, 1},
	{"CreateScrolledText", (PyCFunction)widget_CreateScrolledText, 1},
	{"CreateScrolledWindow", (PyCFunction)widget_CreateScrolledWindow, 1},
	{"CreateSelectionBox", (PyCFunction)widget_CreateSelectionBox, 1},
	{"CreateSelectionDialog", (PyCFunction)widget_CreateSelectionDialog, 1},
	{"CreateSeparator", (PyCFunction)widget_CreateSeparator, 1},
	{"CreateSeparatorGadget", (PyCFunction)widget_CreateSeparatorGadget, 1},
#if XmVersion >= 1001
	{"CreateSimpleCheckBox", (PyCFunction)widget_CreateSimpleCheckBox, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"CreateSimpleMenuBar", (PyCFunction)widget_CreateSimpleMenuBar, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"CreateSimpleOptionMenu", (PyCFunction)widget_CreateSimpleOptionMenu, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"CreateSimplePopupMenu", (PyCFunction)widget_CreateSimplePopupMenu, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"CreateSimplePulldownMenu", (PyCFunction)widget_CreateSimplePulldownMenu, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1001
	{"CreateSimpleRadioBox", (PyCFunction)widget_CreateSimpleRadioBox, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1002
	{"CreateTemplateDialog", (PyCFunction)widget_CreateTemplateDialog, 1},
#endif /* XmVersion >= 1002 */
	{"CreateText", (PyCFunction)widget_CreateText, 1},
#if XmVersion >= 1001
	{"CreateTextField", (PyCFunction)widget_CreateTextField, 1},
#endif /* XmVersion >= 1001 */
	{"CreateToggleButton", (PyCFunction)widget_CreateToggleButton, 1},
	{"CreateToggleButtonGadget", (PyCFunction)widget_CreateToggleButtonGadget, 1},
	{"CreateWarningDialog", (PyCFunction)widget_CreateWarningDialog, 1},
#if XmVersion >= 1001
	{"CreateWorkArea", (PyCFunction)widget_CreateWorkArea, 1},
#endif /* XmVersion >= 1001 */
	{"CreateWorkingDialog", (PyCFunction)widget_CreateWorkingDialog, 1},
#if XmVersion >= 1002
	{"DragStart", (PyCFunction)widget_DragStart, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"DropSiteEndUpdate", (PyCFunction)widget_DropSiteEndUpdate, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"DropSiteRegister", (PyCFunction)widget_DropSiteRegister, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"DropSiteStartUpdate", (PyCFunction)widget_DropSiteStartUpdate, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"DropSiteUnregister", (PyCFunction)widget_DropSiteUnregister, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"DropSiteUpdate", (PyCFunction)widget_DropSiteUpdate, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"GetDisplay", (PyCFunction)widget_GetDisplay, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"GetDragContext", (PyCFunction)widget_GetDragContext, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"GetFocusWidget", (PyCFunction)widget_GetFocusWidget, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"GetTabGroup", (PyCFunction)widget_GetTabGroup, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"GetVisibility", (PyCFunction)widget_GetVisibility, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"GetXmScreen", (PyCFunction)widget_GetXmScreen, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	{"IsTraversable", (PyCFunction)widget_IsTraversable, 1},
#endif /* XmVersion >= 1002 */
#if !(XmVersion >= 1002)
	{"ProcessTraversal", (PyCFunction)widget_ProcessTraversal, 1},
#endif /* !(XmVersion >= 1002) */
#if XmVersion >= 1002
	{"ProcessTraversal", (PyCFunction)widget_ProcessTraversal, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1001
	{"RemoveTabGroup", (PyCFunction)widget_RemoveTabGroup, 1},
#endif /* XmVersion >= 1001 */
#if XmVersion >= 1002
	{"TrackingEvent", (PyCFunction)widget_TrackingEvent, 1},
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1001
	{"TrackingLocate", (PyCFunction)widget_TrackingLocate, 1},
#endif /* XmVersion >= 1001 */
	{"UpdateDisplay", (PyCFunction)widget_UpdateDisplay, 1},
	{0, 0} /* Sentinel */
};


/* Methods for Xmwc objects */

static PyMethodDef Xmwc_methods[] = {
#if XmVersion >= 1002
	{"GetSecondaryResourceData", (PyCFunction)Xmwc_GetSecondaryResourceData, 1},
#endif /* XmVersion >= 1002 */
	{0, 0} /* Sentinel */
};


/* Methods for Xm objects */

static PyMethodDef Xm_methods[] = {
	{0, 0} /* Sentinel */
};


PyMethodChain Xmw_methodchain = {
	Xmw_methods,
	NULL,
};
PyMethodChain Xmwc_methodchain = {
	Xmwc_methods,
	&wclass_methodchain,
};

void
initXm()
{
	PyObject *m, *d;
	m = PyImport_ImportModule("Xt");
	if (m == NULL)
		Py_FatalError("can't import module Xt for Xm");
	Py_DECREF(m);
	m = Py_InitModule("Xm", Xm_methods);
	d = PyModule_GetDict(m);
	add_widget_methodchain(&Xmw_methodchain);
	PyDict_SetItemString(d, "ArrowButton",
		(PyObject*)newwclassobject(xmArrowButtonWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "ArrowButtonGadget",
		(PyObject*)newwclassobject(xmArrowButtonGadgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "BulletinBoard",
		(PyObject*)newwclassobject(xmBulletinBoardWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "CascadeButton",
		(PyObject*)newwclassobject(xmCascadeButtonWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "CascadeButtonGadget",
		(PyObject*)newwclassobject(xmCascadeButtonGadgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "Command",
		(PyObject*)newwclassobject(xmCommandWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "DialogShell",
		(PyObject*)newwclassobject(xmDialogShellWidgetClass,
			&Xmwc_methodchain));
#if XmVersion >= 1002
	PyDict_SetItemString(d, "Display",
		(PyObject*)newwclassobject(xmDisplayClass,
			&Xmwc_methodchain));
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	PyDict_SetItemString(d, "DragContext",
		(PyObject*)newwclassobject(xmDragContextClass,
			&Xmwc_methodchain));
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	PyDict_SetItemString(d, "DragIcon",
		(PyObject*)newwclassobject(xmDragIconObjectClass,
			&Xmwc_methodchain));
#endif /* XmVersion >= 1002 */
	PyDict_SetItemString(d, "DrawingArea",
		(PyObject*)newwclassobject(xmDrawingAreaWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "DrawnButton",
		(PyObject*)newwclassobject(xmDrawnButtonWidgetClass,
			&Xmwc_methodchain));
#if XmVersion >= 1002
	PyDict_SetItemString(d, "DropSite",
		(PyObject*)newwclassobject(xmDropSiteManagerObjectClass,
			&Xmwc_methodchain));
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	PyDict_SetItemString(d, "DropTransfer",
		(PyObject*)newwclassobject(xmDropTransferObjectClass,
			&Xmwc_methodchain));
#endif /* XmVersion >= 1002 */
	PyDict_SetItemString(d, "FileSelectionBox",
		(PyObject*)newwclassobject(xmFileSelectionBoxWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "Form",
		(PyObject*)newwclassobject(xmFormWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "Frame",
		(PyObject*)newwclassobject(xmFrameWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "Gadget",
		(PyObject*)newwclassobject(xmGadgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "Label",
		(PyObject*)newwclassobject(xmLabelWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "LabelGadget",
		(PyObject*)newwclassobject(xmLabelGadgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "List",
		(PyObject*)newwclassobject(xmListWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "MainWindow",
		(PyObject*)newwclassobject(xmMainWindowWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "MenuShell",
		(PyObject*)newwclassobject(xmMenuShellWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "MessageBox",
		(PyObject*)newwclassobject(xmMessageBoxWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "PanedWindow",
		(PyObject*)newwclassobject(xmPanedWindowWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "PushButton",
		(PyObject*)newwclassobject(xmPushButtonWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "PushButtonGadget",
		(PyObject*)newwclassobject(xmPushButtonGadgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "RowColumn",
		(PyObject*)newwclassobject(xmRowColumnWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "Scale",
		(PyObject*)newwclassobject(xmScaleWidgetClass,
			&Xmwc_methodchain));
#if XmVersion >= 1002
	PyDict_SetItemString(d, "Screen",
		(PyObject*)newwclassobject(xmScreenClass,
			&Xmwc_methodchain));
#endif /* XmVersion >= 1002 */
	PyDict_SetItemString(d, "ScrollBar",
		(PyObject*)newwclassobject(xmScrollBarWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "ScrolledWindow",
		(PyObject*)newwclassobject(xmScrolledWindowWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "SelectionBox",
		(PyObject*)newwclassobject(xmSelectionBoxWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "Separator",
		(PyObject*)newwclassobject(xmSeparatorWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "SeparatorGadget",
		(PyObject*)newwclassobject(xmSeparatorGadgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "Text",
		(PyObject*)newwclassobject(xmTextWidgetClass,
			&Xmwc_methodchain));
#if XmVersion >= 1001
	PyDict_SetItemString(d, "TextField",
		(PyObject*)newwclassobject(xmTextFieldWidgetClass,
			&Xmwc_methodchain));
#endif /* XmVersion >= 1001 */
	PyDict_SetItemString(d, "ToggleButton",
		(PyObject*)newwclassobject(xmToggleButtonWidgetClass,
			&Xmwc_methodchain));
	PyDict_SetItemString(d, "ToggleButtonGadget",
		(PyObject*)newwclassobject(xmToggleButtonGadgetClass,
			&Xmwc_methodchain));
	initxmsupport(d);
	widgetchainlist(shellWidgetClass, &shellwidget_methodchain);
	widgetchainlist(vendorShellWidgetClass, &vendorshellwidget_methodchain);
	widgetchainlist(xmCascadeButtonWidgetClass, &cascadebuttonwidget_methodchain);
	widgetchainlist(xmCascadeButtonGadgetClass, &cascadebuttonwidget_methodchain);
	widgetchainlist(xmMessageBoxWidgetClass, &messageboxwidget_methodchain);
	widgetchainlist(xmRowColumnWidgetClass, &rowcolumnwidget_methodchain);
	widgetchainlist(xmScaleWidgetClass, &scalewidget_methodchain);
	widgetchainlist(xmScrollBarWidgetClass, &scrollbarwidget_methodchain);
	widgetchainlist(xmScrolledWindowWidgetClass, &scrolledwindowwidget_methodchain);
	widgetchainlist(xmMainWindowWidgetClass, &mainwindowwidget_methodchain);
	widgetchainlist(xmSelectionBoxWidgetClass, &selectionboxwidget_methodchain);
	widgetchainlist(xmFileSelectionBoxWidgetClass, &fileselectionwidget_methodchain);
	widgetchainlist(xmCommandWidgetClass, &commandwidget_methodchain);
	widgetchainlist(xmToggleButtonWidgetClass, &togglebuttonwidget_methodchain);
	widgetchainlist(xmToggleButtonGadgetClass, &togglebuttongadget_methodchain);
#if XmVersion >= 1002
	widgetchainlist(xmDropSiteManagerObjectClass, &dropsitewidget_methodchain);
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	widgetchainlist(xmDropTransferObjectClass, &droptransferwidget_methodchain);
#endif /* XmVersion >= 1002 */
#if XmVersion >= 1002
	widgetchainlist(xmDragContextClass, &dragwidget_methodchain);
#endif /* XmVersion >= 1002 */
	widgetchainlist(xmTextWidgetClass, &textwidget_methodchain);
	widgetchainlist(xmTextFieldWidgetClass, &textfieldwidget_methodchain);
	widgetchainlist(xmListWidgetClass, &listwidget_methodchain);
}
