# Specifics for each type: format, declare, check, extract, create, [cleanup]

# XXX This module knows more about the width of the various types
# XXX used by Xt than it should.  You may have to tweak the format
# XXX codes on systems where the types differ!

# XXX In particular, we assume sizeof(<some enum>) == sizeof(int)!!!

# XXX '*' may only be used for Widget self, not for WidgetClass self

# XXX The handling of XmString causes memory leaks!

[FMT, DCL, CHK, EXT, CRE, CLE, RCL, SEXT] = range(8)

typedefs = {
	'*': ('', '', '', '%(arg)s->ob_widget', '???'),
	'0': ('', '', '', '', '???'),
	'char*': ('s', 'char *%(arg)s', '', '', 'PyString_FromString(%(arg)s)'),
	'char[]': ('S', 'PyObject *%(arg)s; int nchars',
		'(nchars = PyString_Size(%(arg)s), 1)',
		'PyString_AsString(%(arg)s), nchars', '???'),
	'int': ('i', 'int %(arg)s', '', '', 'PyInt_FromLong((long)%(arg)s)'),
	'intlist': ('O',
		'PyObject *%(arg)s; int *ints_%(arg)s; int nints_%(arg)s',
		'checkintlist(%(arg)s, sizeof(int), &ints_%(arg)s, &nints_%(arg)s)',
		'ints_%(arg)s, nints_%(arg)s', '', 'PyMem_DEL(ints_%(arg)s)'),
	'long': ('l', 'long %(arg)s', '', '', 'PyInt_FromLong(%(arg)s)'),
	'unsigned int': ('i', 'unsigned int %(arg)s', '', '',
		'PyInt_FromLong((long)%(arg)s)'),
	'unsigned long': ('l', 'unsigned long %(arg)s', '', '',
		'PyInt_FromLong((long)%(arg)s)'),
	'void': ('???', '???', '???', '???', ''),
	'void*int': ('i', 'int %(arg)s', '', '(void*)%(arg)s', '???'),
	'Atom': ('l', 'unsigned long %(arg)s', '', '(Atom)%(arg)s',
		'PyInt_FromLong((long)%(arg)s)'),
	'Atom[]': ('O',
		'PyObject *%(arg)s; Atom *atoms_%(arg)s; int natoms_%(arg)s',
		'checkintlist(%(arg)s, sizeof(Atom), &atoms_%(arg)s, &natoms_%(arg)s)',
		'atoms_%(arg)s, natoms_%(arg)s', '',
		'PyMem_DEL(atoms_%(arg)s)'),
	'Bool': ('i', 'int %(arg)s', '', '(Bool)%(arg)s',
		'PyInt_FromLong((long)%(arg)s)'),
	'Boolean': ('i', 'int %(arg)s', '', '(Boolean)%(arg)s',
		'PyInt_FromLong((long)%(arg)s)'),
	'Callback': ('O', 'PyObject *%(arg)s',
		'(%(arg)s == Py_None || is_X_CallbackObject(%(arg)s))',
		'(%(arg)s == Py_None ? NULL : ((X_Callbackobject*)%(arg)s)->event)',
		''),
	'Cardinal': ('i', 'Cardinal %(arg)s', '', '', 'PyInt_FromLong((long)%(arg)s)'),
	'Cursor': ('l', 'Cursor %(arg)s', '', '', 'PyInt_FromLong((long)%(arg)s)'),
	'Dimension': ('h', 'Dimension %(arg)s', '', '', 'PyInt_FromLong((long)%(arg)s)'),
	'Display': ('', '', '', 'getdisplayvalue(%(arg)s)', '', None, None, '%(arg)s->display'),
	'Event*': ('O', 'PyObject *%(arg)s', 'is_XEvent(%(arg)s)',
		'(XEvent*)((X_Callbackobject*)(%(arg)s))->event', ''),
	'Event': ('', 'XEvent %(arg)s', '', '', 'xev_new((XtPointer)&%(arg)s, 0, 1)'),
	'XButtonPressedEvent*': ('O', 'PyObject *%(arg)s',
		'is_XEvent(%(arg)s)',
		'(XButtonPressedEvent*)((X_Callbackobject*)(%(arg)s))->event', ''),
	'EventMask': ('l', 'EventMask %(arg)s', '', '', 'PyInt_FromLong((long)%(arg)s)'),
	'Font': ('O', 'PyObject *%(arg)s', 'is_fontobject(%(arg)s)',
		'getfontvalue(%(arg)s)', ''),
	'Pixel': ('l', 'Pixel %(arg)s', '', '', 'PyInt_FromLong((long)%(arg)s)'),
	'Pixmap': ('O', 'PyObject *%(arg)s', 'is_pixmapobject(%(arg)s)',
		'getpixmapvalue(%(arg)s)', ''),
	'optPixmap': ('O', 'PyObject *%(arg)s', 'is_optpixmapobject(%(arg)s)',
		'getoptpixmapvalue(%(arg)s)', ''),
	'XImage': ('O', 'PyObject *%(arg)s', 'is_imageobject(%(arg)s)',
		'getimagevalue(%(arg)s)', 'IM_new(%(arg)s)'),
	'Pointer': ('l', 'Pointer %(arg)s', '', '', 'PyInt_FromLong((long)%(arg)s)'),
	'Position': ('h', 'Position %(arg)s', '', '', 'PyInt_FromLong((long)%(arg)s)'),
	'Region': ('O', 'PyObject *%(arg)s', 'is_regionobject(%(arg)s)',
		'getregionvalue(%(arg)s)', ''),
	'String': ('s', 'String %(arg)s', '', '',
		'PyString_FromString(%(arg)s)', '', 'XtFree(%(arg)s)'),
	'Time': ('l', 'Time %(arg)s', '', '', 'PyInt_FromLong((long)%(arg)s)'),
	'Widget': ('O', 'PyObject *%(arg)s', 'is_widgetobject(%(arg)s)',
		'getwidgetvalue(%(arg)s)',
		'(PyObject *)newwidgetobject(%(arg)s, &widget_methodchain, dict)', None, None, '%(arg)s->ob_widget'),
	'optWidget': ('O', 'PyObject *%(arg)s',
		'is_optwidgetobject(%(arg)s)',
		'getoptwidgetvalue(%(arg)s)',
		'(%(arg)s == NULL ? (Py_INCREF(Py_None), Py_None) : (PyObject *)newwidgetobject(%(arg)s, &widget_methodchain, dict))'),
	'WidgetClass': ('O', 'PyObject *%(arg)s', 'is_wclassobject(%(arg)s)',
		'getwclassvalue(%(arg)s)',
		'(PyObject *)newwclassobject(%(arg)s, &wclass_methodchain)'),
	'XmString': ('s', 'char *%(arg)s; XmString tmp_%(arg)s', '',
		'(tmp_%(arg)s = XmStringCreateLtoR(%(arg)s, XmSTRING_DEFAULT_CHARSET))',
		'xmstring2pstring(%(arg)s)', 'XmStringFree(tmp_%(arg)s)'),
	'XmStringList': ('O',
		'PyObject *%(arg)s; XmString *tmp_%(arg)s; int nstrs_%(arg)s',
		'checkxmstringlist(%(arg)s, &tmp_%(arg)s, &nstrs_%(arg)s)',
		'tmp_%(arg)s, nstrs_%(arg)s', '',
		'while (--nstrs_%(arg)s >= 0) XmStringFree(tmp_%(arg)s[nstrs_%(arg)s]); PyMem_DEL(tmp_%(arg)s)'),
	'XmTextDirection': ('l', 'XmTextDirection %(arg)s', '', '',
		'PyInt_FromLong((long)%(arg)s)'),
	'XmTextPosition': ('l', 'XmTextPosition %(arg)s', '', '',
		'PyInt_FromLong((long)%(arg)s)'),
	'XmTextSource': ('l', 'long %(arg)s', '', '(XmTextSource)%(arg)s',
		'PyInt_FromLong((long)%(arg)s)'),
	'XmHighlightMode': ('i', 'XmHighlightMode %(arg)s', '', '',
		'PyInt_FromLong((long)%(arg)s)'),
	'XmTraversalDirection': ('i', 'int %(arg)s', '', '(XmTraversalDirection)%(arg)s',
		'PyInt_FromLong((long)%(arg)s)'),
	'XtGrabKind': ('i', 'XtGrabKind %(arg)s', '', '',
		'PyInt_FromLong((long)%(arg)s)'),
	'XtJustify': ('i', 'XtJustify %(arg)s', '', '', 'PyInt_FromLong((long)%(arg)s)'),
	'XtInputId': ('l', 'XtIntervalId %(arg)s', '', '',
		'PyInt_FromLong((long)%(arg)s)'),
	'XtInputMask': ('l', 'XtInputMask %(arg)s', '','',
		'PyInt_FromLong((long)%(arg)s)'),
	'XtIntervalId': ('l', 'XtIntervalId %(arg)s', '', '',
		'PyInt_FromLong((long)%(arg)s)'),
	'XtOrientation': ('i', 'XtOrientation %(arg)s', '', '',
		'PyInt_FromLong((long)%(arg)s)'),
	'XtTranslations': ('O', 'PyObject *%(arg)s',
		'is_translationobject(%(arg)s)',
		'gettranslationvalue(%(arg)s)',
		'(PyObject *) newtranslationobject(%(arg)s, NULL)'),
	'XtWorkProcId': ('l', 'XtIntervalId %(arg)s', '', '',
		'PyInt_FromLong((long)%(arg)s)'),
	'argdict': ('O',
		'PyObject *%(arg)s, *dict; ArgList tmp_%(arg)s; int nargs_%(arg)s',
		'(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), %(w)s, %(arg)s, &tmp_%(arg)s, &nargs_%(arg)s))',
		'tmp_%(arg)s, nargs_%(arg)s', '', 'PyMem_DEL(tmp_%(arg)s)'),
	'stringlist': ('O',
		 'PyObject *%(arg)s; char **tmp_%(arg)s; int nstrs_%(arg)s',
		'checkstringlist(%(arg)s, &tmp_%(arg)s, &nstrs_%(arg)s)',
		'%(arg)s, nstrs_%(arg)s', '', 'PyMem_DEL(tmp_%(arg)s)'),
	'cbfunc': ('O', 'PyObject *%(arg)s, *cbfunc', 'cbfunc = %(arg)s;',
		'univ_callback', ''),
	'cbarg': ('O', 'PyObject *%(arg)s, *cbarg',
		'cbarg = make_closure(self, cbfunc, %(arg)s, 1);',
		'(XtPointer)cbarg', ''),
	'cbeventfunc': ('O', 'PyObject *%(arg)s, *cbfunc', 'cbfunc = %(arg)s;',
		'univ_eventhandler', ''),
	'cbeventarg': ('O', 'PyObject *%(arg)s, *cbarg',
		'cbarg = make_closure(self, cbfunc, %(arg)s, 0);',
		'(XtPointer)cbarg', ''),
	'cbinputfunc': ('O', 'PyObject *%(arg)s, *cbfunc', 'cbfunc = %(arg)s;',
		'univ_inputhandler', ''),
	'cbinputarg': ('O', 'PyObject *%(arg)s, *cbarg',
		'cbarg = Py_BuildValue("(OO)", cbfunc, %(arg)s);',
		'(XtPointer)cbarg', ''),
	'cbtimeoutfunc': ('O', 'PyObject *%(arg)s, *cbfunc', 'cbfunc = %(arg)s;',
		'univ_timeouthandler', ''),
	'cbtimeoutarg': ('O', 'PyObject *%(arg)s, *cbarg',
		'cbarg = Py_BuildValue("(OO)", cbfunc, %(arg)s);',
		'(XtPointer)cbarg', ''),
	'cbworkfunc': ('O', 'PyObject *%(arg)s, *cbfunc', 'cbfunc = %(arg)s;',
		'univ_workproc', ''),
	'cbworkarg': ('O', 'PyObject *%(arg)s, *cbarg',
		'cbarg = Py_BuildValue("(OO)", cbfunc, %(arg)s);',
		'(XtPointer)cbarg', ''),
	'XPoint[]': ('O',
		'PyObject *%(arg)s; XPoint *pts_%(arg)s; int npts_%(arg)s',
		'checkshortlist(2, %(arg)s, (short**)&pts_%(arg)s, &npts_%(arg)s)',
		'pts_%(arg)s, npts_%(arg)s', '', 'PyMem_DEL(pts_%(arg)s)'),
	'XSegment[]': ('O',
		'PyObject *%(arg)s; XSegment *segs_%(arg)s; int nsegs_%(arg)s',
		'checkshortlist(4, %(arg)s, (short**)&segs_%(arg)s, &nsegs_%(arg)s)',
		'segs_%(arg)s, nsegs_%(arg)s', '', 'PyMem_DEL(segs_%(arg)s)'),
	'XRectangle[]': ('O',
		'PyObject *%(arg)s; XRectangle *rects_%(arg)s; int nrects_%(arg)s',
		'checkshortlist(4, %(arg)s, (short**)&rects_%(arg)s, &nrects_%(arg)s)',
		'rects_%(arg)s, nrects_%(arg)s', '',
		'PyMem_DEL(rects_%(arg)s)'),
	'XArc[]': ('O',
		'PyObject *%(arg)s; XArc *arcs_%(arg)s; int narcs_%(arg)s',
		'checkshortlist(6, %(arg)s, (short**)&arcs_%(arg)s, &narcs_%(arg)s)',
		'arcs_%(arg)s, narcs_%(arg)s', '', 'PyMem_DEL(arcs_%(arg)s)'),
	'XGCValues#': ('O',
		'PyObject *%(arg)s; unsigned long mask; XGCValues values',
		'PyGC_MakeValues(%(arg)s, &mask, &values)',
		'mask, &values', ''),
	}
