#! /ufs/guido/bin/sgi/python

# This is the start for a Python interface to any Xt-based toolkit,
# such as the Athena or Motif widgets.  For (almost) each function in
# the Xt library, there's a call to dofunction().  This writes out
# a suitable glue function and saves the name of the function in a
# list.  At the the this list is used to generate the "method lists".
# It is possible to have hand-written functions added to the method
# lists too.
# Passed to dofunction() are the return type, the function name, and
# the types of the arguments the function takes.  If the Python
# equivalent is to be a widget method (as opposed to a function in the
# module xt), the Widget argument representing 'self' must be written
# as '*'.

# To do:
# - add all functions that can be added without much trouble
# - add knowledge about more resource types
# - add app context functions
# - add XtNextEvent etc.
# - allow KeyboardInterrupt to jump out of blocking calls (like XtMainLoop)
# - add direct access to some struct members?
# - (eventually) add full Xlib support?
# - anything else I forgot?

import string
from mktools import *

setfile('Xtgenerated.h')

def makename(name):
	if name[:2] == 'WM':
		return 'wm' + name[2:]
	else:
		return string.lower(name[0]) + name[1:]

r6 = 'XtSpecificationRelease >= 6'

initwidgetset('Xt', 'widget', 'wclass', '<X11/%s.h>', makename, 'Xt')

setmoduleprefix()
#dowidget('Core')
dowidget('Composite')
dowidget('Constraint')
dowidget('Shell')
dowidget('OverrideShell', None)
dowidget('WMShell', None)
dowidget('VendorShell', 'Vendor')
dowidget('TopLevelShell', None)
dowidget('TransientShell', None)
dowidget('ApplicationShell', None)
myfunction('Widget', 'XtInitialize', 'String', '?list', 'stringlist')
myfunction('Widget', 'XtAppInitialize', '...')
myfunction('Widget', 'XtCreateApplicationShell',
	   'String', 'WidgetClass', 'argdict')
myfunction('XtInputId', 'XtAddInput',
	   'int', 'void*int', 'cbinputfunc', 'cbinputarg')
myfunction('void', 'XtRemoveInput', 'XtInputId')
myfunction('XtIntervalId', 'XtAddTimeOut',
	   'unsigned long', 'cbtimeoutfunc', 'cbtimeoutarg')
myfunction('void', 'XtRemoveTimeOut', 'XtIntervalId')
myfunction('XtWorkProcId', 'XtAddWorkProc', 'cbworkfunc', 'cbworkarg')
myfunction('void', 'XtRemoveWorkProc', 'XtWorkProcId')
dofunction('void', 'XtNextEvent', '>Event')
dofunction('SUCCESS', 'XtPeekEvent', '>Event')
dofunction('Boolean', 'XtDispatchEvent', 'Event*')
dofunction('XtInputMask', 'XtPending')
dofunction('void', 'XtProcessEvent', 'XtInputMask')
myfunction('void', 'XtManageChildren', 'Widget[]')
myfunction('void', 'XtToolkitInitialize')
myfunction('Display', 'XtOpenDisplay', '...')
myfunction('void', 'XtMainLoop')
# actions
myfunction('void', 'XtAddActions', 'XtActionsList[]')
myfunction('XtActionHookId', 'XtAddActionHook', 'XtActionHookProc', 'XtPointer')
myfunction('void', 'XtRemoveActionHook', 'XtActionHookId')
# translations
dofunction('XtTranslations', 'XtParseTranslationTable', 'String')
# selections
dofunction('void', 'XtSetSelectionTimeout', 'unsigned long')
dofunction('unsigned long', 'XtGetSelectionTimeout')

dolist()

setwclassprefix()
myfunction('?list', 'XtGetResourceList', '*')
myfunction('?list', 'XtGetConstraintResourceList', '*')
myfunction('void', 'XtInitializeWidgetClass', '*')
dolist()

setwidgetprefix()
dofunction('Widget', 'XtParent', '*')
dofunction('void', 'XtManageChild', '*')
dofunction('void', 'XtUnmanageChild', '*')
dofunction('Boolean', 'XtIsManaged', '*')
dofunction('void', 'XtRealizeWidget', '*')
dofunction('void', 'XtUnrealizeWidget', '*')
dofunction('Boolean', 'XtIsRealized', '*')
dofunction('void', 'XtMapWidget', '*')
dofunction('void', 'XtUnmapWidget', '*')
dofunction('void', 'XtSetMappedWhenManaged', '*', 'Boolean')
dofunction('void', 'XtSetSensitive', '*', 'Boolean')
dofunction('Boolean', 'XtIsSensitive', '*')
dofunction('char*', 'XtName', '*')
dofunction('Widget', 'XtCreateWidget',
	   'String', 'WidgetClass', '*', 'argdict')
dofunction('Widget', 'XtCreateManagedWidget',
	   'String', 'WidgetClass', '*', 'argdict')
myfunction('Widget', 'XtCreatePopupShell',
	   'String', 'WidgetClass', '*', 'argdict')
dofunction('void', 'XtDestroyWidget', '*')
dofunction('WidgetClass', 'XtClass', '*')
dofunction('WidgetClass', 'XtSuperclass', '*')
dofunction('Boolean', 'XtIsSubclass', '*', 'WidgetClass')
dofunction('Boolean', 'XtIsComposite', '*')
dofunction('Widget', 'XtNameToWidget', '*', 'String')
dofunction('void', 'XtSetValues', '*', 'argdict')
myfunction('argdict', 'XtGetValues', '*', 'stringlist')
myfunction('void', 'XtAddCallback', '*', 'String', 'cbfunc', 'cbarg')
dofunction('void', 'XtRemoveCallback', '*', 'String', 'cbfunc', 'cbarg')
dofunction('void', 'XtRemoveAllCallbacks', '*', 'String')
dofunction('void', 'XtCallCallbacks', '*', 'String', 'Callback')
dofunction('Boolean', 'XtHasCallbacks', '*', 'String')
dofunction('void', 'XtAddEventHandler',
	  '*', 'EventMask', 'Boolean', 'cbeventfunc', 'cbeventarg')
dofunction('void', 'XtRemoveEventHandler',
	   '*', 'EventMask', 'Boolean', 'cbeventfunc', 'cbeventarg')
dofunction('void', 'XtAddRawEventHandler',
	  '*', 'EventMask', 'Boolean', 'cbeventfunc', 'cbeventarg')
dofunction('void', 'XtRemoveRawEventHandler',
	   '*', 'EventMask', 'Boolean', 'cbeventfunc', 'cbeventarg')
dofunction('EventMask', 'XtBuildEventMask', '*')
dofunction('void', 'XtPopup', '*', 'XtGrabKind')
dofunction('void', 'XtPopdown', '*')
dofunction('void', 'XtInstallAccelerators', '*', 'Widget')
dofunction('void', 'XtInstallAllAccelerators', '*', 'Widget')
myfunction('PyObject*', 'XtConvert', 'PyObject*', 'String')
myfunction('void', 'XtTranslateCoords', '*', 'Position', 'Position')
myfunction('GC', 'XtGetGC', '*', 'XGCValues#')
myfunction('GC', 'XtCreateGC', '*', 'XGCValues#')
myfunction('char*[]', 'XtListFonts', 'pattern')
myfunction('Font', 'XtLoadQueryFont', 'char*')
dofunction('void', 'XtAddGrab', '*', 'Boolean', 'Boolean')
dofunction('void', 'XtRemoveGrab', '*')
# translations
dofunction('void', 'XtAugmentTranslations', '*', 'XtTranslations')
dofunction('void', 'XtOverrideTranslations', '*', 'XtTranslations')
dofunction('void', 'XtUninstallTranslations', '*')
# selections
dotaggedfunction(r6, 'void', 'XtCreateSelectionRequest', '*', 'Atom')
dotaggedfunction(r6, 'void', 'XtSendSelectionRequest', '*', 'Atom', 'Time')
dotaggedfunction(r6, 'void', 'XtCancelSelectionRequest', '*', 'Atom')
dofunction('void', 'XtDisownSelection', '*', 'Atom', 'Time')
myfunction('Boolean', 'XtOwnSelection', '*', 'Atom', 'XtRequestId')
mytaggedfunction(r6, 'void', 'XtGetSelectionParameters', '*', '...')
mytaggedfunction(r6, 'void', 'XtSetSelectionParameters', '*', '...')
myfunction('XEvent*', 'XtGetSelectionRequest', '*', 'Atom', 'XtRequestId')
myfunction('void', 'XtGetSelectionValue', '*', '...')
myfunction('void', 'XtGetSelectionValues', '*', '...')
myfunction('void', 'XtGetSelectionValueIncremental', '*', '...')
myfunction('void', 'XtGetSelectionValuesIncremental', '*', '...')

CompositeList = []
setlist(CompositeList)
myfunction('WidgetList', 'XtGetChildren', '*')
dolist('compositewidget', 'compositeWidgetClass')

dolist()

write('static void\n')
write('makewidgets(d)\n')
write('\tPyObject *d;\n')
write('{\n')
makewidgets()
write('}\n')
write('\n')
