#! /ufs/guido/bin/sgi/python

version_1_1 = 'XmVersion >= 1001'
version_1_2 = 'XmVersion >= 1002'
ifdef1 = '#if ' + version_1_1 + '\n'
endif1 = '#endif /* ' + version_1_1 + ' */\n'
ifdef2 = '#if ' + version_1_2 + '\n'
endif2 = '#endif /* ' + version_1_2 + ' */\n'

from mktools import *

createmap = {
	'ArrowButton': 'xmArrowButtonWidgetClass',
	'ArrowButtonGadget': 'xmArrowButtonGadgetClass',
	'BulletinBoard': 'xmBulletinBoardWidgetClass',
	'BulletinBoardDialog': 'xmDialogShellWidgetClass,xmBulletinBoardWidgetClass',
	'CascadeButton': 'xmCascadeButtonWidgetClass',
	'CascadeButtonGadget': 'xmCascadeButtonGadgetClass',
	'Command': 'xmCommandWidgetClass',
	'DialogShell': 'xmDialogShellWidgetClass',
	'DragIcon': 'xmDragIconObjectClass',
	'DrawingArea': 'xmDrawingAreaWidgetClass',
	'DrawnButton': 'xmDrawnButtonWidgetClass',
	'ErrorDialog': 'xmDialogShellWidgetClass,xmMessageBoxWidgetClass',
	'FileSelectionBox': 'xmFileSelectionBoxWidgetClass',
	'FileSelectionDialog': 'xmDialogShellWidgetClass,xmFileSelectionBoxWidgetClass',
	'Form': 'xmFormWidgetClass',
	'FormDialog': 'xmDialogShellWidgetClass,xmFormWidgetClass',
	'Frame': 'xmFrameWidgetClass',
	'InformationDialog': 'xmDialogShellWidgetClass,xmMessageBoxWidgetClass',
	'Label': 'xmLabelWidgetClass',
	'LabelGadget': 'xmLabelGadgetClass',
	'List': 'xmListWidgetClass',
	'MainWindow': 'xmMainWindowWidgetClass',
	'MenuBar': 'xmRowColumnWidgetClass',
	'MenuShell': 'xmMenuShellWidgetClass',
	'MessageBox': 'xmMessageBoxWidgetClass',
	'MessageDialog': 'xmDialogShellWidgetClass,xmMessageBoxWidgetClass',
	'OptionMenu': 'xmRowColumnWidgetClass',
	'PanedWindow': 'xmPanedWindowWidgetClass',
	'PopupMenu': 'xmRowColumnWidgetClass',
	'PromptDialog': 'xmDialogShellWidgetClass,xmSelectionBoxWidgetClass',
	'PulldownMenu': 'xmRowColumnWidgetClass',
	'PushButton': 'xmPushButtonWidgetClass',
	'PushButtonGadget': 'xmPushButtonGadgetClass',
	'QuestionDialog': 'xmDialogShellWidgetClass,xmMessageBoxWidgetClass',
	'RadioBox': 'xmRowColumnWidgetClass',
	'RowColumn': 'xmRowColumnWidgetClass',
	'Scale': 'xmScaleWidgetClass',
	'ScrollBar': 'xmScrollBarWidgetClass',
	'ScrolledList': 'xmScrolledWindowWidgetClass,xmListWidgetClass',
	'ScrolledText': 'xmScrolledWindowWidgetClass,xmTextWidgetClass',
	'ScrolledWindow': 'xmScrolledWindowWidgetClass',
	'SelectionBox': 'xmSelectionBoxWidgetClass',
	'SelectionDialog': 'xmDialogShellWidgetClass,xmSelectionBoxWidgetClass',
	'Separator': 'xmSeparatorWidgetClass',
	'SeparatorGadget': 'xmSeparatorGadgetClass',
	'SimpleCheckBox': 'xmRowColumnWidgetClass',
	'SimpleMenuBar': 'xmRowColumnWidgetClass',
	'SimpleOptionMenu': 'xmRowColumnWidgetClass',
	'SimplePopupMenu': 'xmRowColumnWidgetClass',
	'SimplePulldownMenu': 'xmRowColumnWidgetClass',
	'SimpleRadioBox': 'xmRowColumnWidgetClass',
	'TemplateDialog': 'xmDialogShellWidgetClass,xmMessageBoxWidgetClass',
	'Text': 'xmTextWidgetClass',
	'TextField': 'xmTextFieldWidgetClass',
	'ToggleButton': 'xmToggleButtonWidgetClass',
	'ToggleButtonGadget': 'xmToggleButtonGadgetClass',
	'WarningDialog': 'xmDialogShellWidgetClass,xmMessageBoxWidgetClass',
	'WorkArea': 'xmRowColumnWidgetClass',
	'WorkingDialog': 'xmDialogShellWidgetClass,xmMessageBoxWidgetClass',
	}

def taggedxmcreate(tag, name):
	if createmap.has_key(name):
		wC = createmap[name]
	else:
		wC = 'xm%sWidgetClass' % name
	dotaggedfunction(tag, 'Widget', 'XmCreate%s' % name,
			 '*', 'String', 'argdict:' + wC)

def xmcreate(name):
	if createmap.has_key(name):
		wC = createmap[name]
	else:
		wC = 'xm%sWidgetClass' % name
	dofunction('Widget', 'XmCreate%s' % name,
		  '*', 'String', 'argdict:' + wC)

def taggedxmwidget(tag, name, fname = '', cname = ''):
	dotaggedwidget(tag, name, fname, cname)
	taggedxmcreate(tag, name)

def xmwidget(name, fname):
	dowidget(name, fname)
	xmcreate(name)

def xmgadget(name, fname):
	if createmap.has_key(name + 'Gadget'):
		cname = createmap[name + 'Gadget']
	else:
		cname = 'xm' + name + 'GadgetClass'
	include = '<Xm/%s.h>' % fname
	write('#include ', include, '\n')
	write('\n')
	Widgets.append(name + 'Gadget', cname)
	dofunction('Widget', 'XmCreate%sGadget' % name,
		  '*', 'String', 'argdict:' + cname)

widgetset('Xm', 'widget', 'Xmwc', '<Xm/%s.h>', 'xm%s', 'Xm')

write('#include "event.h"\n')
write('#include "Xmsupport.h"\n')

setwidgetprefix()

xmwidget('DialogShell', 'DialogS')	# needed by some creation functions

ShellList = []
setlist(ShellList)
dotaggedfunction(version_1_1, 'int', 'XmIsMotifWMRunning', '*')
dolist('shellwidget', 'shellWidgetClass', 'compositewidget')

VendorShellList = []
setlist(VendorShellList)
write(ifdef1, '#include <Xm/Protocols.h>\n', endif1)
dotaggedfunction(version_1_1, 'void', 'XmActivateProtocol', '*',
		 'Atom', 'Atom')
dotaggedfunction(version_1_1, 'void', 'XmActivateWMProtocol', '*', 'Atom')
dotaggedfunction(version_1_1, 'void', 'XmDeactivateProtocol', '*',
		 'Atom', 'Atom')
dotaggedfunction(version_1_1, 'void', 'XmDeactivateWMProtocol', '*', 'Atom')
mytaggedfunction(version_1_1, 'void', 'XmAddProtocolCallback', '*',
		 'Atom', 'Atom', 'cbfunc', 'cbarg')
mytaggedfunction(version_1_1, 'void', 'XmAddWMProtocolCallback', '*',
		 'Atom', 'cbfunc', 'cbarg')
dotaggedfunction(version_1_1, 'void', 'XmAddProtocols', '*', 'Atom', 'Atom[]')
dotaggedfunction(version_1_1, 'void', 'XmAddWMProtocols', '*', 'Atom[]')
dotaggedfunction(version_1_1, 'void', 'XmRemoveProtocolCallback', '*',
		 'Atom', 'Atom', 'cbfunc', 'cbarg')
dotaggedfunction(version_1_1, 'void', 'XmRemoveWMProtocolCallback', '*',
		 'Atom', 'cbfunc', 'cbarg')
dotaggedfunction(version_1_1, 'void', 'XmRemoveProtocols', '*',
		 'Atom', 'Atom[]')
dotaggedfunction(version_1_1, 'void', 'XmRemoveWMProtocols', '*', 'Atom[]')
mytaggedfunction(version_1_1, 'void', 'XmSetProtocolHooks', '*',
		 'Atom', 'Atom', 'cbfunc', 'cbarg', 'cbfunc', 'cbarg')
mytaggedfunction(version_1_1, 'void', 'XmSetWMProtocolHooks', '*',
		 'Atom', 'cbfunc', 'cbarg', 'cbfunc', 'cbarg')
dolist('vendorshellwidget', 'vendorShellWidgetClass', 'shellwidget')

xmwidget('ArrowButton', 'ArrowB')
xmgadget('ArrowButton', 'ArrowBG')

xmwidget('BulletinBoard', 'BulletinB')
xmcreate('BulletinBoardDialog')

xmwidget('CascadeButton', 'CascadeB')
xmgadget('CascadeButton', 'CascadeBG')
CascadeButtonList = []
setlist(CascadeButtonList)
dofunction('void', 'XmCascadeButtonHighlight', '*', 'Boolean')
dolist('cascadebuttonwidget', ['xmCascadeButtonWidgetClass', 'xmCascadeButtonGadgetClass'])

dotaggedfunction(version_1_2, 'void', 'XmChangeColor', '*', 'Pixel')

xmwidget('Command', 'Command')
CommandList = []
setlist(CommandList)
dofunction('void', 'XmCommandAppendValue', '*', 'XmString')
dofunction('void', 'XmCommandError', '*', 'XmString')
dofunction('Widget', 'XmCommandGetChild', '*', 'int')
dofunction('void', 'XmCommandSetValue', '*', 'XmString')
setlist()
# dolist() after SelectionBox

dofunction('int', 'XmConvertUnits', '*', 'int', 'int', 'int', 'int')

dotaggedwidget(version_1_2, 'Display', 'Display', 'xmDisplayClass')
dotaggedfunction(version_1_2, 'Widget', 'XmGetDisplay', '*')
dotaggedwidget(version_1_2, 'Screen', 'Screen', 'xmScreenClass')
mytaggedfunction(version_1_2, 'Widget', 'XmGetXmScreen', '*')

xmwidget('DrawingArea', 'DrawingA')

xmwidget('DrawnButton', 'DrawnB')

xmwidget('FileSelectionBox', 'FileSB')
xmcreate('FileSelectionDialog')
FileSelectList = []
setlist(FileSelectList)
dofunction('void', 'XmFileSelectionDoSearch', '*', 'XmString')
dofunction('Widget', 'XmFileSelectionBoxGetChild', '*', 'int')
setlist()
# dolist() after SelectionBox

xmwidget('Form', 'Form')
xmcreate('FormDialog')

xmwidget('Frame', 'Frame')

dowidget('Gadget', None, 'xmGadgetClass')

xmwidget('Label', 'Label')
xmgadget('Label', 'LabelG')

xmwidget('List', 'List')

xmwidget('MainWindow', 'MainW')
MainList = []
setlist(MainList)
dofunction('Widget', 'XmMainWindowSep1', '*')
dofunction('Widget', 'XmMainWindowSep2', '*')
dofunction('Widget', 'XmMainWindowSep3', '*')
dofunction('void', 'XmMainWindowSetAreas', '*', 'optWidget', 'optWidget',
	   'optWidget', 'optWidget', 'optWidget')
setlist()
# dolist() after ScrolledWindow

xmwidget('MenuShell', 'MenuShell')

xmwidget('MessageBox', 'MessageB')
MessageBoxList = []
setlist(MessageBoxList)
dofunction('Widget', 'XmMessageBoxGetChild', '*', 'int')
dolist('messageboxwidget', 'xmMessageBoxWidgetClass', 'compositewidget')

xmcreate('ErrorDialog')
xmcreate('InformationDialog')
xmcreate('MessageDialog')
xmcreate('QuestionDialog')
xmcreate('WarningDialog')
xmcreate('WorkingDialog')

xmwidget('PanedWindow', 'PanedW')

xmwidget('PushButton', 'PushB')
xmgadget('PushButton', 'PushBG')

xmwidget('RowColumn', 'RowColumn')
xmcreate('MenuBar')
xmcreate('OptionMenu')
xmcreate('PopupMenu')
xmcreate('PulldownMenu')
xmcreate('RadioBox')
RowColumnList = []
setlist(RowColumnList)
dofunction('Widget', 'XmOptionButtonGadget', '*')
dofunction('Widget', 'XmOptionLabelGadget', '*')
dofunction('void', 'XmMenuPosition', '*', 'XButtonPressedEvent*')
dotaggedfunction(version_1_1, 'Widget', 'XmGetPostedFromWidget', '*')
dotaggedfunction(version_1_2, 'Widget', 'XmGetTearOffControl', '*')
dolist('rowcolumnwidget', 'xmRowColumnWidgetClass', 'compositewidget')

xmwidget('Scale', 'Scale')
ScaleList = []
setlist(ScaleList)
dofunction('void', 'XmScaleSetValue', '*', 'int')
dofunction('void', 'XmScaleGetValue', '*', '>int')
dolist('scalewidget', 'xmScaleWidgetClass', 'compositewidget')

xmwidget('ScrollBar', 'ScrollBar')
ScrollBarList = []
setlist(ScrollBarList)
dofunction('void', 'XmScrollBarGetValues', '*',
	   '>int', '>int', '>int', '>int')
dofunction('void', 'XmScrollBarSetValues', '*',
	   'int', 'int', 'int', 'int', 'Boolean')
dolist('scrollbarwidget', 'xmScrollBarWidgetClass')

xmwidget('ScrolledWindow', 'ScrolledW')
ScrollWindowList = []
setlist(ScrollWindowList)
dotaggedfunction(version_1_2, 'void', 'XmScrollVisible',
		 '*', 'Widget', 'Dimension', 'Dimension')
dofunction('void', 'XmScrolledWindowSetAreas',
	   '*', 'Widget', 'Widget', 'Widget')
dolist('scrolledwindowwidget', 'xmScrolledWindowWidgetClass', 'compositewidget')
setlist(MainList)
dolist('mainwindowwidget', 'xmMainWindowWidgetClass', 'scrolledwindowwidget')

xmcreate('ScrolledList')

xmwidget('SelectionBox', 'SelectioB')
SelectionBoxList = []
setlist(SelectionBoxList)
dofunction('Widget', 'XmSelectionBoxGetChild', '*', 'int')
dolist('selectionboxwidget', 'xmSelectionBoxWidgetClass', 'compositewidget')
setlist(FileSelectList)
dolist('fileselectionwidget', 'xmFileSelectionBoxWidgetClass', 'selectionboxwidget')
setlist(CommandList)
dolist('commandwidget', 'xmCommandWidgetClass', 'selectionboxwidget')

xmcreate('PromptDialog')
xmcreate('SelectionDialog')

xmwidget('Separator', 'Separator')
xmgadget('Separator', 'SeparatoG')

xmwidget('Text', 'Text')
xmcreate('ScrolledText')

xmwidget('ToggleButton', 'ToggleB')
ToggleButtonList = []
setlist(ToggleButtonList)
dofunction('Boolean', 'XmToggleButtonGetState', '*')
dofunction('void', 'XmToggleButtonSetState', '*', 'Boolean', 'Boolean')
dolist('togglebuttonwidget', 'xmToggleButtonWidgetClass')

xmgadget('ToggleButton', 'ToggleBG')
ToggleButtonGadgetList = []
setlist(ToggleButtonGadgetList)
dofunction('Boolean', 'XmToggleButtonGadgetGetState', '*')
dofunction('void', 'XmToggleButtonGadgetSetState', '*', 'Boolean', 'Boolean')
dolist('togglebuttongadget', 'xmToggleButtonGadgetClass')

taggedxmcreate(version_1_1, 'SimpleCheckBox')
taggedxmcreate(version_1_1, 'SimpleMenuBar')
taggedxmcreate(version_1_1, 'SimpleOptionMenu')
taggedxmcreate(version_1_1, 'SimplePopupMenu')
taggedxmcreate(version_1_1, 'SimplePulldownMenu')
taggedxmcreate(version_1_1, 'SimpleRadioBox')
taggedxmwidget(version_1_1, 'TextField', 'TextF')
taggedxmcreate(version_1_1, 'WorkArea')

# Drag and drop
dotaggedwidget(version_1_2, 'DragContext', 'DragDrop', 'xmDragContextClass')
taggedxmwidget(version_1_2, 'DragIcon', '', 'xmDragIconObjectClass')
##dotaggedwidget(version_1_2, 'DragIcon', 'DragIcon', 'xmDragIconObjectClass')
##dotaggedfunction(version_1_2, 'Widget', 'XmCreateDragIcon',
##		 '*', 'String', 'argdict')
DragList = []
setlist(DragList)
dotaggedfunction(version_1_2, 'void', 'XmDragCancel', '*')
setlist()
mytaggedfunction(version_1_2, 'Widget', 'XmDragStart',
		 '*', 'Event*', 'argdict')
mytaggedfunction(version_1_2, 'Widget', 'XmGetDragContext', '*', 'Time')
dotaggedwidget(version_1_2, 'DropSite', None, 'xmDropSiteManagerObjectClass')
DropList = []
setlist(DropList)
dotaggedfunction(version_1_2, 'void', 'XmDropSiteConfigureStackingOrder',
		 '*', 'Widget', 'Cardinal')
dotaggedlist(version_1_2, 'dropsitewidget', 'xmDropSiteManagerObjectClass')
dotaggedfunction(version_1_2, 'void', 'XmDropSiteEndUpdate', '*')
mytaggedfunction(version_1_2, 'void', 'XmDropSiteRegister', '*', 'argdict')
#dotaggedfunction(version_1_2, 'void', 'XmDropSiteRetrieve', '*', '>argdict')
dotaggedfunction(version_1_2, 'void', 'XmDropSiteStartUpdate', '*')
dotaggedfunction(version_1_2, 'void', 'XmDropSiteUnregister', '*')
dotaggedfunction(version_1_2, 'void', 'XmDropSiteUpdate', '*', 'argdict')
dotaggedwidget(version_1_2, 'DropTransfer', None, 'xmDropTransferObjectClass')
DropTransferList = []
setlist(DropTransferList)
#dotaggedfunction(version_1_2, 'void', 'XmDropTransferAdd',
#		 '*', 'XmDropTransferEntryRec[]')
dotaggedlist(version_1_2, 'droptransferwidget', 'xmDropTransferObjectClass')
setlist(DragList)
mytaggedfunction(version_1_2, 'Widget', 'XmDropTransferStart', '*', 'argdict')
dotaggedlist(version_1_2, 'dragwidget', 'xmDragContextClass')

dotaggedfunction(version_1_2, 'Widget', 'XmGetFocusWidget', '*')
dotaggedfunction(version_1_2, 'int', 'XmGetVisibility', '*')
dotaggedfunction(version_1_2, 'int', 'XmIsTraversable', '*')
dotaggedfunction(version_1_2, 'Boolean', 'XmProcessTraversal',
		 '*', 'XmTraversalDirection')
dotaggedfunction('!(' + version_1_2 + ')', 'Boolean', 'XmProcessTraversal',
		 '*', 'int')
# Tab groups
dofunction('void', 'XmAddTabGroup', '*')
dotaggedfunction(version_1_2, 'Widget', 'XmGetTabGroup', '*')
dotaggedfunction(version_1_1, 'void', 'XmRemoveTabGroup', '*')

taggedxmcreate(version_1_2, 'TemplateDialog')

# XmText and XmTextField access functions
TextList = []
TextFieldList = []
def xmtextfunc(returntype, name, *args):
	setlist(TextList)
	apply(dofunction, (returntype, 'XmText'+name)+args)
	setlist(TextFieldList)
	apply(dotaggedfunction, (version_1_1, returntype, 'XmTextField'+name)+args)
	setlist()
def xmtextfunc_1_1(returntype, name, *args):
	setlist(TextList)
	apply(dotaggedfunction, (version_1_1, returntype, 'XmText'+name)+args)
	setlist(TextFieldList)
	apply(dotaggedfunction, (version_1_1, returntype, 'XmTextField'+name)+args)
	setlist()
xmtextfunc('void', 'ClearSelection', '*', 'Time')
xmtextfunc_1_1('Boolean', 'Copy', '*', 'Time')
xmtextfunc_1_1('Boolean', 'Cut', '*', 'Time')
setlist(TextList)
dotaggedfunction(version_1_2, 'void', 'XmTextDisableRedisplay', '*')
dotaggedfunction(version_1_2, 'void', 'XmTextEnableRedisplay', '*')
dotaggedfunction(version_1_2, 'SUCCESS', 'XmTextFindString', '*',
	 'XmTextPosition', 'char*', 'XmTextDirection', '>XmTextPosition')
xmtextfunc_1_1('int', 'GetBaseline', '*')
xmtextfunc('Boolean', 'GetEditable', '*')
xmtextfunc('XmTextPosition', 'GetInsertionPosition', '*')
xmtextfunc('XmTextPosition', 'GetLastPosition', '*')
xmtextfunc('int', 'GetMaxLength', '*')
xmtextfunc('String', 'GetSelection', '*')
xmtextfunc('Boolean', 'GetSelectionPosition',
	   '*', '>XmTextPosition', '>XmTextPosition')
setlist(TextList)
dofunction('XmTextSource', 'XmTextGetSource', '*')
xmtextfunc('String', 'GetString', '*')
setlist(TextList)
dotaggedfunction(version_1_1, 'XmTextPosition', 'XmTextGetTopCharacter', '*')
xmtextfunc_1_1('void', 'Insert', '*', 'XmTextPosition', 'String')
xmtextfunc_1_1('Boolean', 'Paste', '*')
xmtextfunc('SUCCESS', 'PosToXY',
	   '*', 'XmTextPosition', '>Position', '>Position')
xmtextfunc_1_1('Boolean', 'Remove', '*')
xmtextfunc('void', 'Replace',
	   '*', 'XmTextPosition', 'XmTextPosition', 'String')
setlist(TextList)
dofunction('void', 'XmTextScroll', '*', 'int')
xmtextfunc_1_1('void', 'SetAddMode', '*', 'Boolean')
xmtextfunc('void', 'SetEditable', '*', 'Boolean')
xmtextfunc_1_1('void', 'SetHighlight',
	       '*', 'XmTextPosition', 'XmTextPosition', 'XmHighlightMode')
xmtextfunc('void', 'SetInsertionPosition', '*', 'XmTextPosition')
xmtextfunc('void', 'SetMaxLength', '*', 'int')
xmtextfunc('void', 'SetSelection',
	   '*', 'XmTextPosition', 'XmTextPosition', 'Time')
setlist(TextList)
dofunction('void', 'XmTextSetSource',
	   '*', 'XmTextSource', 'XmTextPosition', 'XmTextPosition')
xmtextfunc('void', 'SetString', '*', 'String')
setlist(TextList)
dotaggedfunction(version_1_1, 'void', 'XmTextSetTopCharacter',
		 '*', 'XmTextPosition')
xmtextfunc('void', 'ShowPosition', '*', 'XmTextPosition')
xmtextfunc('XmTextPosition', 'XYToPos',
	   '*', 'Position', 'Position')
setlist(TextList)
dolist('textwidget', 'xmTextWidgetClass')
setlist(TextFieldList)
dolist('textfieldwidget', 'xmTextFieldWidgetClass')

# XmList functions
ListList = []
setlist(ListList)
dofunction('void', 'XmListAddItem', '*', 'XmString', 'int')
dofunction('void', 'XmListAddItems', '*', 'XmStringList', 'int')
dofunction('void', 'XmListAddItemUnselected', '*', 'XmString', 'int')
dotaggedfunction(version_1_2, 'void', 'XmListAddItemsUnselected', '*',
		 'XmStringList', 'int')
dotaggedfunction(version_1_1, 'void', 'XmListDeleteAllItems', '*')
dofunction('void', 'XmListDeleteItem', '*', 'XmString')
dofunction('void', 'XmListDeleteItems', '*', 'XmStringList')
dotaggedfunction(version_1_1, 'void', 'XmListDeleteItemsPos', '*', 'int', 'int')
dofunction('void', 'XmListDeletePos', '*', 'int')
dotaggedfunction(version_1_2, 'void', 'XmListDeletePositions', '*', 'intlist')
dofunction('void', 'XmListDeselectAllItems', '*')
dofunction('void', 'XmListDeselectItem', '*', 'XmString')
dofunction('void', 'XmListDeselectPos', '*', 'int')
dotaggedfunction(version_1_2, 'int', 'XmListGetKbdItemPos', '*')
#myfunction('Boolean', 'XmListGetMatchPos',
#	   '*', 'XmString', '>intlist')
mytaggedfunction(version_1_1, 'Boolean', 'XmListGetSelectedPos', '*', '>intlist')
dofunction('Boolean', 'XmListItemExists', '*', 'XmString')
dotaggedfunction(version_1_1, 'int', 'XmListItemPos', '*', 'XmString')
dotaggedfunction(version_1_2, 'Boolean', 'XmListPosSelected', '*', 'int')
dotaggedfunction(version_1_2, 'SUCCESS', 'XmListPosToBounds', '*', 'int',
		 '>Position', '>Position', '>Dimension', '>Dimension')
myfunction('void', 'XmListReplaceItems', '*', 'XmStringList', 'XmStringList')
dofunction('void', 'XmListReplaceItemsPos', '*', 'XmStringList', 'int')
dotaggedfunction(version_1_2, 'void', 'XmListReplaceItemsPosUnselected',
		 '*', 'XmStringList', 'int')
mytaggedfunction(version_1_2, 'void', 'XmListReplaceItemsUnselected',
		 '*', 'XmStringList', 'XmStringList')
mytaggedfunction(version_1_2, 'void', 'XmListReplacePositions',
		 '*', 'intlist', 'XmStringList')
dofunction('void', 'XmListSelectItem', '*', 'XmString', 'Boolean')
dofunction('void', 'XmListSelectPos', '*', 'int', 'Boolean')
dotaggedfunction(version_1_1, 'void', 'XmListSetAddMode', '*', 'Boolean')
dofunction('void', 'XmListSetBottomItem', '*', 'XmString')
dofunction('void', 'XmListSetBottomPos', '*', 'int')
dofunction('void', 'XmListSetHorizPos', '*', 'int')
dofunction('void', 'XmListSetItem', '*', 'XmString')
dotaggedfunction(version_1_2, 'void', 'XmListSetKbdItemPos', '*', 'int')
dofunction('void', 'XmListSetPos', '*', 'int')
dotaggedfunction(version_1_2, 'void', 'XmListUpdateSelectedList', '*')
dotaggedfunction(version_1_2, 'int', 'XmListYToPos', '*', 'Position')
dolist('listwidget', 'xmListWidgetClass')

dotaggedfunction(version_1_2, 'Widget', 'XmTrackingEvent',
		 '*', 'Cursor', 'Boolean', '>Event')
dotaggedfunction(version_1_1, 'Widget', 'XmTrackingLocate',
		 '*', 'Cursor', 'Boolean')

dofunction('void', 'XmUpdateDisplay', '*')


dolist('Xmw')

setwclassprefix()
mytaggedfunction(version_1_2, 'dummy', 'XmGetSecondaryResourceData', 'dummy')
dolist()

setmoduleprefix()
dolist()

initextras.append('initxmsupport(d);')

endwidgetset('Xmw')
