# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The rctest example from D. Young's Xt/Motif book. 
#
#     Demonstrates the use of the XmRowColumn widget. 
#
# USAGE: 
#     > python rctest.py
#

import sys, os, Xt, Xm

buttons = ['button1', 'button2', 'button3', 'button4',\
           'button5', 'button6', 'button7', 'button8']

rowcol   = 0 # global variable
toplevel = 0 # global variable

# -------------------------------------------------------------------------
# Main function:

def main():	
	# Load resources from the file "Rctest.resources"

	void = os.system('xrdb -nocpp -merge Rctest.resources')

	# Initialize

	global toplevel
	toplevel = Xt.Initialize('Rctest', [], sys.argv )

	# Create the rowcolumn widget

	global rowcol
	rowcol = toplevel.CreateManagedWidget('rowcol', Xm.RowColumn, {})

	# Create 8 children of the rowcolumn widget

	for i in range(8):
		b = rowcol.CreateManagedWidget( buttons[i], Xm.PushButton, {} ) 
		b.AddCallback( 'activateCallback', buttonCB, i )

	# Realize the widget and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Callback function:

# Constants taken from the /usr/include/X11/Xm/Xm.h file

HORIZONTAL     = 2
VERTICAL       = 1
NO_PACKING     = 0
PACK_TIGHT     = 1
PACK_COLUMN    = 2
PACK_NONE      = 3


def buttonCB( w, button_number, call_data ):
	print 'Button', button_number + 1, 'called'
	global rowcol

	if button_number == 0: 
		rowcol.orientation = HORIZONTAL
		resize_window( rowcol )
	elif button_number == 1:
		rowcol.orientation = VERTICAL
		resize_window( rowcol )
	elif button_number == 2:
		rowcol.numColumns = 1
		resize_window( rowcol )
	elif button_number == 3:
		rowcol.numColumns = 2
		resize_window( rowcol )
	elif button_number == 4:
		rowcol.numColumns = 3
		resize_window( rowcol )
	elif button_number == 5:
		rowcol.packing = PACK_COLUMN
		resize_window( rowcol )
	elif button_number == 6:
		rowcol.packing = PACK_TIGHT
		resize_window( rowcol )
	elif button_number == 7:
		rowcol.packing = PACK_NONE
		resize_window( rowcol )
	else:
		pass
		
def resize_window( widget ):
	w, h = widget.width, widget.height
	print 'Width:', w, 'Height:', h
	global toplevel
	toplevel.SetValues( {'width': w, 'height': h} )
	
def remap( widget ):
	widget.UnmapWidget()
	widget.MapWidget()

main()
