# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The pushbutton example from D. Young's Xt/Motif book. Demonstrates use
#     of the XmPushButton widget.
#
# USAGE: 
#     > python pushbutton.py 
#

import sys, os, Xt, Xm

# -------------------------------------------------------------------------
# Main function:

def main():
	# Initialize

	toplevel = Xt.Initialize('Pushbutton', [], sys.argv )

	# Create the pushbutton widget

	button = toplevel.CreateManagedWidget('button', Xm.PushButton, {})

	# Add callbacks

	button.AddCallback( 'activateCallback', activateCB, 0 )
	button.AddCallback( 'armCallback', armCB, 0 )
	button.AddCallback( 'disarmCallback', disarmCB, 0 )
	
	# Realize the widget and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Callback functions:

def activateCB( w, client_data, call_data ):
	# 
	# Access to the call_data structure (XmAnyCallbackStruct) is not
	# supported by the Xm interface yet.
	#
	print 'Button activated'

def armCB( w, client_data, call_data ):
	print 'Button armed'

def disarmCB( w, client_data, call_data ):
	print 'Button disarmed'

main()
