# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The memo example from D. Young's Xt/Motif book. 
#     This version demonstrates the use of event handlers.
#
# USAGE: 
#     > python memo_eh.py <message to be displayed>
#

import sys, os, string, Xt, Xm
import X

def CreateArgvString( argv ):
	if len(argv) > 1:
		s = string.join( argv[1:len(argv)] )
	else:
		s = 'No args'
	return s

# -------------------------------------------------------------------------
# main function
	
def main():
	# Initialize & create a label widget to hold the string

	toplevel = Xt.Initialize('Memo', [], sys.argv )
	msg_widget = toplevel.CreateManagedWidget('msg', Xm.Label, {})

	# Create the string to be displayed by concatenating the command-line
	# arguments.

	message = CreateArgvString( sys.argv )
	msg_widget.labelString = message

	# Add an event handler

	msg_widget.AddEventHandler(X.ButtonPressMask, X.TRUE, quitEH, 0)

	# Realize the widgets and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Event handler function:
#
# An event handler is a procedure invoked by the Xt intrinsics when a 
# specific type of event occurs within a widget. 
	 
def quitEH(w, client_data, event):
	print 'quitEH called'
	# Xt.CloseDisplay(Xt.Display(w)) # not supported yet
	sys.exit(0)

main()
