# -------------------------------------------------------------------------
# DESCRIPTION: 
#     Demonstrates usage of the XEvent module (XKeyEvent)
#
# USAGE: 
#     > python event3.py
#

import Xt, Xm
import X, Xmd    # constants for Xt & Xm

# -------------------------------------------------------------------------
# Main function:

def main():	
	# Initialize and create a canvas widget

	toplevel = Xt.Initialize('Event2', [], [] )
	toplevel.SetValues( {'width': 300, 'height': 300} )
	bb = toplevel.CreateManagedWidget('bboard', Xm.BulletinBoard, {})

	# Add an event handler for keypress events

	bb.AddEventHandler(X.KeyPressMask, X.FALSE, KeypressEH, 0)

	# Realize the widgets and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Event handler function:
#
# XKeyEvent has the following fields:
#     type         - the type of the event (X.KeyPress or X.KeyRelease)
#     serial       - number of the last event processed by the server
#     send_event   - indicates whether this event was sent by the X server
#                    or by another client. The value will be X.TRUE in the
#                    latter case.
#     display      - the ID of the X window display
#     window       - the ID of the event window
#     root         - the ID of the root window
#     subwindow    - the ID of the immediate child of the event window that 
#                    lies between the event window and source window (hmm..)
#     time         - time in milliseconds since the last server reset
#     x            - x pos relative to event window
#     x_root       - x pos relative to root window
#     y            - y pos relative to event window
#     y_root       - y pos relative to root window
#     keycode      - a code which uniquely identifies the key that caused the
#                    event. The character represented by this code can be found
#                    with the XLookupString function (not supported yet).
#     state        - contains a mask indicating which, if any, modifier keys
#                    were depressed when this event took place
#     same_screen  - in case multiple screen are used ?
# 

def KeypressEH( w, client_data, event ):
	#
	# Print value of the key which was pressed
	#
	print 'keycode  =', event.keycode
	print 'pos      =', event.x, event.y


main()
