# -------------------------------------------------------------------------
# DESCRIPTION: 
#     Demonstrates usage of the XEvent module.
#
# USAGE: 
#     > python event1.py
#

import Xt, Xm
import X, Xmd    # constants for Xt & Xm
import Xu        # utility functions

# -------------------------------------------------------------------------
# Main function:

def main():	
	# Initialize and create a bulletinboard widget as the primary widget

	toplevel = Xt.Initialize('Menu', [], [] )
	toplevel.SetValues( {'width': 200, 'height': 100} )
	bboard   = toplevel.CreateManagedWidget('bboard', Xm.BulletinBoard, {})

	# Create 3 different popup menus

	_menu1 = [ ('Menu1', None), \
		       ('m1A', DoItCB), ('m1B', DoItCB), ('m1C', DoItCB) ]
	_menu2 = [ ('Menu2', None), \
		       ('m2A', DoItCB), ('m2B', DoItCB), ('m2C', DoItCB) ]
	_menu3 = [ ('Menu3', None), \
		       ('m3A', DoItCB), ('m3B', DoItCB), ('m3C', DoItCB) ]

	menu1 = Xu.CreateMenu( bboard, _menu1 )
	menu2 = Xu.CreateMenu( bboard, _menu2 )
	menu3 = Xu.CreateMenu( bboard, _menu3 )
	menu1.whichButton = X.Button1
	menu2.whichButton = X.Button2
	menu3.whichButton = X.Button3
	menus = [ menu1, menu2, menu3 ]

	# Add an event handler to the bulletinboard widget. This event handler
	# should decide which menu should be popped up, and where it should be
	# positioned.

	bboard.AddEventHandler(X.ButtonPressMask, X.FALSE, DisplayMenuEH, menus)

	# Realize the widgets and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Event handler/callback functions:
#
# XButtonEvent has the following fields:
#     type         - the type of the event (X.ButtonPress or X.ButtonRelease)
#     serial       - number of the last event processed by the server
#     send_event   - indicates whether this event was sent by the X server
#                    or by another client. The value will be X.TRUE in the
#                    latter case.
#     display      - the ID of the X window display
#     window       - the ID of the event window
#     root         - the ID of the root window
#     subwindow    - the ID of the immediate child of the event window that 
#                    lies between the event window and source window (hmm..)
#     time         - time in milliseconds since the last server reset
#     x            - x pos relative to event window
#     x_root       - x pos relative to root window
#     y            - y pos relative to event window
#     y_root       - y pos relative to root window
#     button       - the button which was used (X.Button1, X.Button2, or 
#                    X.Button3)
#     state        - contains a mask indicating which, if any, modifier keys
#                    were depressed when this event took place
#     same_screen  - in case multiple screen are used ?
# 

def DisplayMenuEH( w, menus, event ):
	#
	# Find out which menu should be displayed and pop it up at the mouse
	# position
	#
	if event.button == X.Button1:
		i = 0
	elif event.button == X.Button2:
		i = 1
	else:
		i = 2

	menus[i].MenuPosition( event )
	menus[i].ManageChild()
		


def DoItCB( w, client_data, call_data ):
	print client_data, 'selected'



main()
