#! /ufs/guido/src/python/xt/python

# ANP audio file player.

import sys
import os
import string
import audioop
import getopt

import Xt
import Xm
import Xmd
import Xtdefs

from AudioPlayer import AudioPlayer
import GenericAudioSource
import ULAWAudioSource

# Extend AudioPlayer with quit and search buttons
class MyAudioPlayer(AudioPlayer):

	def __init__(self, parent, args):
		AudioPlayer.__init__(self, parent, args)

	def makecontrolbuttons(self, parent):
		AudioPlayer.makecontrolbuttons(self, parent)
		self.makesearch(parent, {})
		self.makequit(parent, {})

	def makesearch(self, parent, args):
		self.search = parent.CreatePushButton('search', args)
		self.search.AddCallback('activateCallback',
			  self.cb_search, None)
		self.search.ManageChild()

	def makequit(self, parent, args):
		self.quit = parent.CreatePushButton('quit', args)
		self.quit.AddCallback('activateCallback', self.cb_quit, None)
		self.quit.ManageChild()

	def cb_search(self, *rest):
		if not self.source: return
		playing = self.is_playing()
		self.stop_player()
		CHUNKSIZE = 250
		BACKUP = 500
		NSILENT = 20
		NSOUND = 4*NSILENT
		FACTOR = 4
		lastlevels = [0]
		nsilent = 0
		if self.source.getsampformat() == 'ulaw':
			width = 2
			def converter(chunk):
				return audioop.ulaw2lin(chunk, 2)
		else:
			width = self.source.getsampwidth()
			converter = None
		while 1:
			chunk = self.source.readframes(CHUNKSIZE)
			if not chunk: break
			if converter: chunk = converter(chunk)
			l = audioop.max(chunk, width)
			if l*FACTOR < max(lastlevels):
				nsilent = nsilent + 1
			else:
				if nsilent >= NSILENT:
					break
				nsilent = 0
			lastlevels.append(l)
			while len(lastlevels) > NSOUND:
				del lastlevels[0]
		if playing:
			self.start_player()
		else:
			self.showinfo()
		
	def cb_quit(self, *rest):
		sys.exit(0)

# Check that the display host is the one whose audio hardware we are using
def checkdisplayhost():
	import string, socket
	if not os.environ.has_key('DISPLAY'):
		print 'Sorry, $DISPLAY not set'
		sys.exit(1)
	display = os.environ['DISPLAY']
	if ':' not in display:
		print 'Sorry, bad $DISPLAY variable'
		sys.exit(1)
	i = string.find(display, ':')
	dpyhost = display[:i]
	if not dpyhost: return		# OK -- default host
	if dpyhost == 'unix': return	# OK -- explicit unix socket
	runhost = socket.gethostname()
	if socket.gethostbyname(dpyhost) <> socket.gethostbyname(runhost):
		print 'Sorry, your display appears to be on another host',
		print '(' + dpyhost + ')'
		print 'than the host on which this program is running',
		print '(' + runhost + ').'
		print 'The sound would come out of the speaker on',
		print runhost + ','
		print 'and I doubt that is what you wanted.'
		print '(Use -n to override this check.)'
		sys.exit(1)

# Find a file in the Python search path
def findfile(file):
	for dir in sys.path:
		full = os.path.join(dir, file)
		if os.path.exists(full):
			return full
	return full

# Print usage message and exit
def usage():
	print 'usage: anp [-n] [-S] audiofile'
	print '-n       : allow running on a different host than $DISPLAY'
	print '-S       : start in stopped state'
	print 'audiofile: file to play'
	sys.exit(2)

def main():
	# Download resources
	resfile = findfile('Anp.resources')
	if os.path.exists(resfile):
		sts = os.system('xrdb -merge ' + resfile)
	else:
		print 'Warning: resource file', resfile, 'not found'
	# Init Xt (takes away Xt options from sys.argv)
	shell = Xt.Initialize()
	# Parse options
	try:
		opts, args = getopt.getopt(sys.argv[1:], 'nS')
	except getopt.error:
		usage()
	nocheck = 0
	startstopped = 0
	for o, a in opts:
		if o == '-n':
			nocheck = 1
		if o == '-S':
			startstopped = 1
	if len(args) > 1 or '-' in args:
		usage()
	# Check we can sensibly run on this display
	if not nocheck:
		checkdisplayhost()
	# Set default filename (and source class)
	filename = '/ufs/jack/etc/anp/news'
	SourceClass = ULAWAudioSource
	# Get optional filename argument (changes source class!)
	if args:
		filename = args[0]
		SourceClass = GenericAudioSource
	# Run
	s = SourceClass.open(filename)
	p = MyAudioPlayer(shell, {})
	p.set_source(s)
	if not startstopped:
		p.do_play()
	shell.RealizeWidget()
	Xt.MainLoop()

main()
