# A very simple read-only text browser: create a shell window
# containing the text (with scroll bars) and a "close" button.

import Xt
import Xm
import Xmd
import Xtdefs
import string

# Figure out Motif version
MOTIF_1_1 = hasattr(Xm, 'TextField')

# The class
class TextBrowser:

	# --- public interface ---

	# Initialize the instance (don't create the window yet)
	def __init__(self, name, args):
		self.name = name
		self.args = args
		self.titlestring = ''
		self.initialized = 0

	# Put some text in the window and pop it up
	def show_text(self, text, *rest):
		self.titlestring = string.join(rest)
		self.setup()
		self.text.TextSetString(text)
		self.title.labelString = self.titlestring
		self.show()

	# Change the window title without changing the text
	def set_title(self, titlestring):
		self.titlestring = titlestring
		if self.initialized:
			self.title.labelString = titlestring

	# Pop up the window (if initialized).
	# This will pop it up if the user has iconified it,
	# But it won't raise its stacking position if already visible.
	# The window geometry is remembered from the last time
	def show(self):
		if self.initialized:
			self.shell.MapWidget()

	# Pop down the window
	def hide(self):
		if self.initialized:
			self.shell.UnmapWidget()

	# --- implementation ---

	# All following methods are private

	# Do the delayed initialization
	def setup(self):
		if self.initialized:
			self.form.ManageChild()
			return
		self.makewidgets()
		self.shell.RealizeWidget()
		self.initialized = 1

	# Create the widgets
	def makewidgets(self):
		#
		args = self.args
		args['deleteResponse'] = Xmd.UNMAP
		if not MOTIF_1_1:
			args['width'] = 400
			args['height'] = 300
		self.shell = Xt.CreateApplicationShell(self.name,
			  Xt.TopLevelShell, args)
		#
		args = {}
		self.form = self.shell.CreateForm('form', args)
		self.form.ManageChild()
		#
		args = {}
		args['topAttachment'] = Xmd.ATTACH_FORM
		args['leftAttachment'] = Xmd.ATTACH_FORM
		self.close = self.form.CreatePushButton('close', args)
		self.close.AddCallback('activateCallback', self.cb_close, None)
		self.close.ManageChild()
		#
		args = {}
		args['topAttachment'] = Xmd.ATTACH_FORM
		args['leftAttachment'] = Xmd.ATTACH_WIDGET
		args['rightAttachment'] = Xmd.ATTACH_FORM
		args['leftWidget'] = self.close
		self.title = self.form.CreateLabel('title', args)
		self.title.labelString = self.titlestring
		self.title.ManageChild()
		#
		args = {}
		args['topAttachment'] = Xmd.ATTACH_WIDGET
		args['topWidget'] = self.close
		args['leftAttachment'] = Xmd.ATTACH_FORM
		args['rightAttachment'] = Xmd.ATTACH_FORM
		args['bottomAttachment'] = Xmd.ATTACH_FORM
		if not MOTIF_1_1:
			self.insert = self.form.CreateFrame('insert', args)
			self.insert.ManageChild()
			args = {}
		else:
			self.insert = self.form
		args['rows'] = 24
		args['columns'] = 72
		args['editMode'] = Xmd.MULTI_LINE_EDIT
		args['editable'] = 0
		self.text = self.insert.CreateScrolledText('text', args)
		self.text.ManageChild()

	# Close button callback
	def cb_close(self, *args):
		self.hide()


# Test program
def test():
	import sys
	if sys.argv[0] == '-c': sys.argv[0] = 'TextBrowser_test'
	t = Xt.Initialize()
	file = '/etc/passwd'
	if sys.argv[1:]: file = sys.argv[1]
	text = open(file, 'r').read()
	b = TextBrowser('demo', {})
	b.show_text(text)
	b.set_title(file)
	Xt.MainLoop()
