# A "sink" for audio -- writing frames to it plays them on the audio hardware.

import al, AL
import audioop

# XXX If the parameters are not supported by the device,
# more or less random exceptions may occur!

class SGIAudioSink:

	def __init__(self, *args):
		if args:
			if args[1:]: raise TypeErrors, 'too many args'
			self.setsourceparams(args[0])

	def __del__(self):
		self.close()

	def setsourceparams(self, params):
		fmt, bytes, bits, nch, rate, nfr = params
		width = bytes
		self.nch = nch
		if fmt == 'ulaw':
			width = 2	# After conversion to linear
			def converter(data):
				return audioop.ulaw2lin(data, 2)
			self.converter = converter
		else:
			self.converter = None
		c = al.newconfig()
		c.setchannels(nch)
		c.setwidth(width)
		qsize = max(nch * rate, 2000)
		c.setqueuesize(qsize)
		self.saveparams = [AL.OUTPUT_RATE, 0]
		al.getparams(AL.DEFAULT_DEVICE, self.saveparams)
		params = [AL.OUTPUT_RATE, rate]
		al.setparams(AL.DEFAULT_DEVICE, params)
		self.port = al.openport('AudioPlayer', 'w', c)

	def close(self):
		try:
			port = self.port
		except:
			return
		if not port:
			return
		try:
			port.closeport()
		finally:
			self.port = None
		try:
			params = self.saveparams
		except:
			return
		if params[1] == 0:
			return
		al.setparams(AL.DEFAULT_DEVICE, params)

	def reset(self):
		n = self.getfilled()	# Return nframes to back up
		self.close()
		return n

	def getfillable(self):		# Return nframes queueable
		return self.port.getfillable() / self.nch

	def getfilled(self):		# Return nframes queued
		return self.port.getfilled() / self.nch

	def writeframes(self, data):	# Write frames
		if self.converter:
			data = self.converter(data)
		self.port.writesamps(data)


def test():
	import time
	from GenericAudioSource import GenericAudioSource
	s = SGIAudioSink()
	file = '/usr/local/sounds/au/klaxon.au'
##	file = '/usr/local/sounds/aiff/1999_intro.aiff'
	x = GenericAudioSource.open(file)
	try:
		s.setsourceparams(x.getsourceparams())
		while 1:
			data = x.readframes(1000)
			if not data: break
			s.writeframes(data)
		while s.getfilled() > 0:
			time.sleep(0.1)
	finally:
		print s.reset()
