#include "Python.h"
#include "modsupport.h"

#include "widgetobject.h"
#include "event.h"
#include "regionobject.h"

#define extobject regionobject
#define ob_ptr ob_region
#define EXTPTR Region
#define EXTNAME "Region"
#define newextobject newregionobject
#define getextvalue getregionvalue
#define Exttype Regiontype
#define extdealloc(ptr)	XDestroyRegion(ptr->ob_region)
#define NO_EXTKNOWN

#include "extobject.h"

static PyObject *region_AddExposureToRegion Py_PROTO((regionobject *, PyObject *));
static PyObject *region_ClipBox Py_PROTO((regionobject *, PyObject *));
static PyObject *region_EmptyRegion Py_PROTO((regionobject *, PyObject *));
static PyObject *region_EqualRegion Py_PROTO((regionobject *, PyObject *));
static PyObject *region_PointInRegion Py_PROTO((regionobject *, PyObject *));
static PyObject *region_RectInRegion Py_PROTO((regionobject *, PyObject *));
static PyObject *region_IntersectRegion Py_PROTO((regionobject *, PyObject *));
static PyObject *region_UnionRegion Py_PROTO((regionobject *, PyObject *));
static PyObject *region_UnionRectWithRegion Py_PROTO((regionobject *, PyObject *));
static PyObject *region_SubtractRegion Py_PROTO((regionobject *, PyObject *));
static PyObject *region_XorRegion Py_PROTO((regionobject *, PyObject *));
static PyObject *region_OffsetRegion Py_PROTO((regionobject *, PyObject *));
static PyObject *region_ShrinkRegion Py_PROTO((regionobject *, PyObject *));

static PyMethodDef region_methods[] = {
	{"AddExposureToRegion", (PyCFunction)region_AddExposureToRegion, 1},
	{"ClipBox", (PyCFunction)region_ClipBox, 1},
	{"EmptyRegion", (PyCFunction)region_EmptyRegion, 1},
	{"EqualRegion", (PyCFunction)region_EqualRegion, 1},
	{"IntersectRegion", (PyCFunction)region_IntersectRegion, 1},
	{"OffsetRegion", (PyCFunction)region_OffsetRegion, 1},
	{"PointInRegion", (PyCFunction)region_PointInRegion, 1},
	{"RectInRegion", (PyCFunction)region_RectInRegion, 1},
	{"ShrinkRegion", (PyCFunction)region_ShrinkRegion, 1},
	{"SubtractRegion", (PyCFunction)region_SubtractRegion, 1},
	{"UnionRectWithRegion", (PyCFunction)region_UnionRectWithRegion, 1},
	{"UnionRegion", (PyCFunction)region_UnionRegion, 1},
	{"XorRegion", (PyCFunction)region_XorRegion, 1},
	{0, 0}			/* Sentinel */
};
static PyMethodChain regchain = {
	region_methods,
	NULL,
};

static PyObject *
region_AddExposureToRegion(self, args)
	regionobject *self;
	PyObject *args;
{
	X_Callbackobject *event;

	if (!PyArg_ParseTuple(args, "O!", &X_CallbackType, &event))
		return NULL;
	if (!event->is_XEvent) {
		PyErr_BadArgument();
		return NULL;
	}
	XtAddExposureToRegion(event->event, self->ob_region);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
region_ClipBox(self, args)
	regionobject *self;
	PyObject *args;
{
	XRectangle r;

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	XClipBox(self->ob_region, &r);
	return Py_BuildValue("(iiii)", r.x, r.y, r.width, r.height);
}

static PyObject *
region_EmptyRegion(self, args)
	regionobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	return PyInt_FromLong(XEmptyRegion(self->ob_region));
}

static PyObject *
region_EqualRegion(self, args)
	regionobject *self;
	PyObject *args;
{
	regionobject *r;
	if (!PyArg_ParseTuple(args, "O!", &Regiontype, &r))
		return NULL;
	return PyInt_FromLong(XEqualRegion(self->ob_region, r->ob_region));
}

static PyObject *
region_PointInRegion(self, args)
	regionobject *self;
	PyObject *args;
{
	int x, y;
	if (!PyArg_ParseTuple(args, "ii", &x, &y))
		return NULL;
	return PyInt_FromLong(XPointInRegion(self->ob_region, x, y));
}

static PyObject *
region_RectInRegion(self, args)
	regionobject *self;
	PyObject *args;
{
	int x, y;
	unsigned int width, height;
	if (!PyArg_ParseTuple(args, "iiii", &x, &y, &width, &height))
		return NULL;
	return PyInt_FromLong(XRectInRegion(self->ob_region, x, y, width, height));
}

static PyObject *
region_IntersectRegion(self, args)
	regionobject *self;
	PyObject *args;
{
	regionobject *r;
	if (!PyArg_ParseTuple(args, "O!", &Regiontype, &r))
		return NULL;
	XIntersectRegion(self->ob_region, r->ob_region, self->ob_region);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
region_UnionRegion(self, args)
	regionobject *self;
	PyObject *args;
{
	regionobject *r;
	if (!PyArg_ParseTuple(args, "O!", &Regiontype, &r))
		return NULL;
	XUnionRegion(self->ob_region, r->ob_region, self->ob_region);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
region_UnionRectWithRegion(self, args)
	regionobject *self;
	PyObject *args;
{
	XRectangle r;
	if (!PyArg_ParseTuple(args, "hhhh", &r.x, &r.y, &r.width, &r.height))
		return NULL;
	XUnionRectWithRegion(&r, self->ob_region, self->ob_region);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
region_SubtractRegion(self, args)
	regionobject *self;
	PyObject *args;
{
	regionobject *r;
	if (!PyArg_ParseTuple(args, "O!", &Regiontype, &r))
		return NULL;
	XSubtractRegion(self->ob_region, r->ob_region, self->ob_region);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
region_XorRegion(self, args)
	regionobject *self;
	PyObject *args;
{
	regionobject *r;
	if (!PyArg_ParseTuple(args, "O!", &Regiontype, &r))
		return NULL;
	XXorRegion(self->ob_region, r->ob_region, self->ob_region);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
region_OffsetRegion(self, args)
	regionobject *self;
	PyObject *args;
{
	int dx, dy;
	if (!PyArg_ParseTuple(args, "ii", &dx, &dy))
		return NULL;
	XOffsetRegion(self->ob_region, dx, dy);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
region_ShrinkRegion(self, args)
	regionobject *self;
	PyObject *args;
{
	int dx, dy;
	if (!PyArg_ParseTuple(args, "ii", &dx, &dy))
		return NULL;
	XShrinkRegion(self->ob_region, dx, dy);
	Py_INCREF(Py_None);
	return Py_None;
}

PyObject *
Xlib_CreateRegion(self, args)
	PyObject *self;
	PyObject *args;
{
	Region reg;

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	reg = XCreateRegion();
	if (reg == NULL)
		return PyErr_NoMemory();
	return (PyObject *) newregionobject(reg, &regchain);
}

PyObject *
Xlib_PolygonRegion(self, args)
	PyObject *self;
	PyObject *args;
{
	Region reg;
	PyObject *arg1;
	XPoint *points;
	int npoints, fill_rule;

	if (!PyArg_ParseTuple(args, "Oi", &arg1, &fill_rule))
		return NULL;
	if (!checkshortlist(2, arg1, (short**)&points, &npoints)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XPoint[]");
		return NULL;
	}
	reg = XPolygonRegion(points, npoints, fill_rule);
	if (reg == NULL)
		return PyErr_NoMemory();
	return (PyObject *) newregionobject(reg, &regchain);
}
