#include "Python.h"
#include "widgetobject.h"
#include "XColor.h"
#include "Pixmapobject.h"
#include "Xlibmodule.h"

#define PROVIDE_TYPES
#include "event.h"

#include "HTML.h"

#define STRING		30
#define STRINGLIST	31

#define ANCHORCALLBACK	30
#define FORMCALLBACK	31
#define LINKCALLBACK	32
#define UNKNOWNCALLBACK	33

#ifndef offsetof
#define offsetof(type, member) ( (int) & ((type*)0) -> member )
#endif

#define OFF(t,m)	offsetof(t,m)

static struct callback formcallback[] = {
	{"WbFormCallbackData",},
	{"event", XEVENT, OFF(WbFormCallbackData, event)},
	{"href", STRING, OFF(WbFormCallbackData, href)},
	{"method", STRING, OFF(WbFormCallbackData, method)},
	{"enctype", STRING, OFF(WbFormCallbackData, enctype)},
	{"enc_entity", STRING, OFF(WbFormCallbackData, enc_entity)},
	{"attribute_count", INT, OFF(WbFormCallbackData, attribute_count)},
	{"attribute_names", STRINGLIST, OFF(WbFormCallbackData, attribute_names)},
	{"attribute_values", STRINGLIST, OFF(WbFormCallbackData, attribute_values)},
	{0, 0, 0},
};
static struct callback anchorcallback[] = {
	{"WbAnchorCallbackData"},
	{"event", XEVENT, OFF(WbAnchorCallbackData, event)},
	{"element_id", INT, OFF(WbAnchorCallbackData, element_id)},
	{"text", STRING, OFF(WbAnchorCallbackData, text)},
	{"href", STRING, OFF(WbAnchorCallbackData, href)},
	{0, 0, 0},
};
static struct callback linkcallback[] = {
	{"LinkInfo"},
	{"href", STRING, OFF(LinkInfo, href)},
	{"role", STRING, OFF(LinkInfo, role)},
	{0, 0, 0},
};
static struct callback unknowncallback[] = {
	{"UnknownCallback"},
	{0, 0, 0},
};

#define GET(bas, off, typ)	(* (typ *) ((char *) (bas) + (off)))
#define SET(bas, off, typ, val)	(* (typ *) ((char *) (bas) + (off)) = (val))

static PyObject *
htmlev_get(self, cbp, name)
	X_Callbackobject *self;
	struct callback *cbp;
	char *name;
{
	switch (cbp->type) {
	case STRING:
		{
			char *v = GET(self->event, cbp->offset, char *);
			if (v == NULL) {
				Py_INCREF(Py_None);
				return Py_None;
			}
			return PyString_FromString(v);
		}
	case STRINGLIST:
		{
			int n;
			char **p;
			PyObject *v;
			n = ((WbFormCallbackData *) self->event)->attribute_count;
			p = GET(self->event, cbp->offset, char **);
			v = PyList_New(n);
			if (v == NULL)
				return NULL;
			while (--n >= 0) {
				if (p[n] == NULL) {
					Py_INCREF(Py_None);
					PyList_SetItem(v, n, Py_None);
				} else
					PyList_SetItem(v, n,
						PyString_FromString(p[n]));
			}
			if (PyErr_Occurred()) {
				Py_DECREF(v);
				return NULL;
			}
			return v;
		}
	default:
		return NULL;
	}
}

static int
htmlev_set(self, cbp, name, value)
	X_Callbackobject *self;
	struct callback *cbp;
	char *name;
	PyObject *value;
{
	return 1;
}

static int
htmlev_gettype(w, callback_name)
	Widget w;
	char *callback_name;
{
	WidgetClass wc = XtClass(w);

	if (wc == htmlWidgetClass) {
		if (strcmp(callback_name, WbNanchorCallback) == 0)
			return ANCHORCALLBACK;
		if (strcmp(callback_name, WbNsubmitFormCallback) == 0)
			return FORMCALLBACK;
		if (strcmp(callback_name, WbNlinkCallback) == 0)
			return LINKCALLBACK;
		return UNKNOWNCALLBACK;
	}
	return -1;
}

static struct callback *
htmlev_getcb(ptr, type)
	XtPointer ptr;
	int type;
{
	switch (type) {
	case ANCHORCALLBACK:
		return anchorcallback;
	case FORMCALLBACK:
		return formcallback;
	case LINKCALLBACK:
		return linkcallback;
	case UNKNOWNCALLBACK:
		return unknowncallback;
	default:
		return NULL;
	}
}

void
htmlev_init()
{
	xev_addfuncs(htmlev_get, htmlev_set, htmlev_gettype, htmlev_getcb);
}
