/***********************************************************
Copyright 1991-1995 by Stichting Mathematisch Centrum, Amsterdam,
The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* Template for a wrapper around any kind of external object */

#ifndef EXTNAME

/* Being used stand-alone */

#include "Python.h"
#include "modsupport.h"

typedef struct {
	PyObject_HEAD
	EXTPTR ob_ptr;
	PyMethodChain *ob_methodchain;
} extobject;

#endif

#ifndef EXTNAME
#define EXTNAME "ext"
#endif

#ifndef EXTPTR
#ifdef __STDC__
typedef void *EXTPTR;
#else
typedef char *EXTPTR;
#endif
#endif

/* Other names to redefine when used as a template:
   extobject, ob_ptr, newextobject, getextvalue, ext_forget, Exttype */

/* Possibly also redefine ext_getattr, ext_setattr */

#ifndef ext_getattr
#define ext_getattr default_ext_getattr
#endif

#ifndef ext_setattr
#define ext_setattr 0
#endif

#ifndef EXT_INIT
#define EXT_INIT(xp)
#endif

#ifndef NO_EXTKNOWN
static PyObject *extknown;
#endif

extern PyTypeObject Exttype;

#define is_extobject(xp)	((xp)->ob_type == &Exttype)

extobject *
newextobject(ptr, chain)
	EXTPTR ptr;
	PyMethodChain *chain;
{
	extobject *xp;
#ifndef NO_EXTKNOWN
	PyObject *key;
	if (extknown == NULL) {
		extknown = PyDict_New();
		if (extknown == NULL)
			return NULL;
	}
	key = PyInt_FromLong((long)ptr);
	if (key == NULL)
		return NULL;
	xp = (extobject *)PyDict_GetItem(extknown, key);
	if (xp != NULL) {
		Py_INCREF(xp);
		goto done;
	}
#endif /* NO_EXTKNOWN */
	xp = PyObject_NEW(extobject, &Exttype);
	if (xp == NULL)
		goto done;
	xp->ob_ptr = ptr;
	xp->ob_methodchain = chain;
	EXT_INIT(xp);
#ifndef NO_EXTKNOWN
	if (PyDict_SetItem(extknown, key, (PyObject *)xp) != 0) {
		Py_DECREF(xp);
		xp = NULL;
	}
#endif /* NO_EXTKNOWN */
 done:
#ifndef NO_EXTKNOWN
	Py_DECREF(key);
#endif /* NO_EXTKNOWN */
	return xp;
}

static void
ext_dealloc(xp)
	extobject *xp;
{
#ifdef extdealloc
	extdealloc(xp);
#endif
	PyMem_DEL(xp);
}

EXTPTR
getextvalue(xp)
	PyObject *xp;
{
	if (xp && is_extobject(xp))
		return ((extobject *)xp)->ob_ptr;
	PyErr_BadInternalCall();
	return NULL;
}

#ifndef NO_EXTKNOWN
static int
_ext_forget(xp)
	extobject *xp;
{
	PyObject *key = PyInt_FromLong((long)xp->ob_ptr);
	int res;
	if (key == NULL)
		return -1;
	res = PyDict_DelItem(extknown, key);
	Py_DECREF(key);
	return res;
}

int
ext_forget(xp)
	PyObject *xp;
{
	if (xp && is_extobject(xp))
		return _ext_forget((extobject *)xp);
	PyErr_BadInternalCall();
	return -1;
}

static PyObject *
ext___forget__(xp)
	extobject *xp;
{
	if (_ext_forget(xp) != 0)
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}
#endif /* NO_EXTKNOWN */

static PyMethodDef ext_methods[] = {
#ifndef NO_EXTKNOWN
	{"__forget__",	(PyCFunction)ext___forget__, 1},
#endif
	{NULL,		NULL}		/* sentinel */
};

static PyObject *
default_ext_getattr(xp, name)
	extobject *xp;
	char *name;
{
	PyObject *res;

	res = Py_FindMethodInChain(xp->ob_methodchain, (PyObject *) xp, name);
	if (res != NULL)
		return res;
	PyErr_Clear();
	return Py_FindMethod(ext_methods, (PyObject *)xp, name);
}

PyTypeObject Exttype = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,			/*ob_size*/
	EXTNAME,		/*tp_name*/
	sizeof(extobject),	/*tp_size*/
	0,			/*tp_itemsize*/
	/* methods */
	(destructor)ext_dealloc, /*tp_dealloc*/
	0,			/*tp_print*/
	(getattrfunc)ext_getattr, /*tp_getattr*/
	(setattrfunc)ext_setattr, /*tp_setattr*/
	0,			/*tp_compare*/
	0,			/*tp_repr*/
	0,			/*tp_as_number*/
	0,			/*tp_as_sequence*/
	0,			/*tp_as_mapping*/
	0,			/*tp_hash*/
};
