#include "Python.h"
#include "widgetobject.h"
#include "XColor.h"
#include "Pixmapobject.h"
#include "Xlibmodule.h"
#include "regionobject.h"

#define PROVIDE_TYPES
#include "event.h"

static struct cv_func {
	PyObject *(*func_get) Py_PROTO((X_Callbackobject *, struct callback *, char *));
	int (*func_set) Py_PROTO((X_Callbackobject *, struct callback *, char *, PyObject *));
	int (*gettype) Py_PROTO((Widget, char *));
	struct callback *(*getcb) Py_PROTO((XtPointer, int));
	struct cv_func *next;
} *cv_head;

#ifndef offsetof
#define offsetof(type, member) ( (int) & ((type*)0) -> member )
#endif

#define OFF(t,m)	offsetof(t,m)

/* X events */
static struct callback keyevent[] = {
	{"XKeyEvent",},
	{"type", INT, OFF(XKeyEvent, type)},
	{"serial", LONG, OFF(XKeyEvent, serial)},
	{"send_event", INT, OFF(XKeyEvent, send_event)},
	{"display", DISPLAY, OFF(XKeyEvent, display)},
	{"window", WINDOW, OFF(XKeyEvent, window)},
	{"root", WINDOW, OFF(XKeyEvent, root)},
	{"subwindow", WINDOW, OFF(XKeyEvent, subwindow)},
	{"time", LONG, OFF(XKeyEvent, time)},
	{"x", INT, OFF(XKeyEvent, x)},
	{"y", INT, OFF(XKeyEvent, y)},
	{"x_root", INT, OFF(XKeyEvent, x_root)},
	{"y_root", INT, OFF(XKeyEvent, y_root)},
	{"state", UINT, OFF(XKeyEvent, state)},
	{"keycode", UINT, OFF(XKeyEvent, keycode)},
	{"same_screen", INT, OFF(XKeyEvent, same_screen)},
	{0, 0, 0},
};
static struct callback buttonevent[] = {
	{"XButtonEvent",},
	{"type", INT, OFF(XButtonEvent, type)},
	{"serial", LONG, OFF(XButtonEvent, serial)},
	{"send_event", INT, OFF(XButtonEvent, send_event)},
	{"display", DISPLAY, OFF(XButtonEvent, display)},
	{"window", WINDOW, OFF(XButtonEvent, window)},
	{"root", WINDOW, OFF(XButtonEvent, root)},
	{"subwindow", WINDOW, OFF(XButtonEvent, subwindow)},
	{"time", LONG, OFF(XButtonEvent, time)},
	{"x", INT, OFF(XButtonEvent, x)},
	{"y", INT, OFF(XButtonEvent, y)},
	{"x_root", INT, OFF(XButtonEvent, x_root)},
	{"y_root", INT, OFF(XButtonEvent, y_root)},
	{"state", UINT, OFF(XButtonEvent, state)},
	{"button", UINT, OFF(XButtonEvent, button)},
	{"same_screen", INT, OFF(XButtonEvent, same_screen)},
	{0, 0, 0},
};
static struct callback motionevent[] = {
	{"XMotionEvent",},
	{"type", INT, OFF(XMotionEvent, type)},
	{"serial", LONG, OFF(XMotionEvent, serial)},
	{"send_event", INT, OFF(XMotionEvent, send_event)},
	{"display", DISPLAY, OFF(XMotionEvent, display)},
	{"window", WINDOW, OFF(XMotionEvent, window)},
	{"root", WINDOW, OFF(XMotionEvent, root)},
	{"subwindow", WINDOW, OFF(XMotionEvent, subwindow)},
	{"time", LONG, OFF(XMotionEvent, time)},
	{"x", INT, OFF(XMotionEvent, x)},
	{"y", INT, OFF(XMotionEvent, y)},
	{"x_root", INT, OFF(XMotionEvent, x_root)},
	{"y_root", INT, OFF(XMotionEvent, y_root)},
	{"state", UINT, OFF(XMotionEvent, state)},
	{"is_hint", CHAR, OFF(XMotionEvent, is_hint)},
	{"same_screen", INT, OFF(XMotionEvent, same_screen)},
	{0, 0, 0},
};
static struct callback crossingevent[] = {
	{"XCrossingEvent",},
	{"type", INT, OFF(XCrossingEvent, type)},
	{"serial", LONG, OFF(XCrossingEvent, serial)},
	{"send_event", INT, OFF(XCrossingEvent, send_event)},
	{"display", DISPLAY, OFF(XCrossingEvent, display)},
	{"window", WINDOW, OFF(XCrossingEvent, window)},
	{"root", WINDOW, OFF(XCrossingEvent, root)},
	{"subwindow", WINDOW, OFF(XCrossingEvent, subwindow)},
	{"time", LONG, OFF(XCrossingEvent, time)},
	{"x", INT, OFF(XCrossingEvent, x)},
	{"y", INT, OFF(XCrossingEvent, y)},
	{"x_root", INT, OFF(XCrossingEvent, x_root)},
	{"y_root", INT, OFF(XCrossingEvent, y_root)},
	{"mode", INT, OFF(XCrossingEvent, mode)},
	{"detail", INT, OFF(XCrossingEvent, detail)},
	{"same_screen", INT, OFF(XCrossingEvent, same_screen)},
	{"focus", INT, OFF(XCrossingEvent, focus)},
	{"state", UINT, OFF(XCrossingEvent, state)},
	{0, 0, 0},
};
static struct callback focuschangeevent[] = {
	{"XFocusChangeEvent",},
	{"type", INT, OFF(XFocusChangeEvent, type)},
	{"serial", LONG, OFF(XFocusChangeEvent, serial)},
	{"send_event", INT, OFF(XFocusChangeEvent, send_event)},
	{"display", DISPLAY, OFF(XFocusChangeEvent, display)},
	{"window", WINDOW, OFF(XFocusChangeEvent, window)},
	{"mode", INT, OFF(XFocusChangeEvent, mode)},
	{"detail", INT, OFF(XFocusChangeEvent, detail)},
	{0, 0, 0},
};
static struct callback keymapevent[] = {
	{"XKeymapEvent",},
	{"type", INT, OFF(XKeymapEvent, type)},
	{"serial", LONG, OFF(XKeymapEvent, serial)},
	{"send_event", INT, OFF(XKeymapEvent, send_event)},
	{"display", DISPLAY, OFF(XKeymapEvent, display)},
	{"window", WINDOW, OFF(XKeymapEvent, window)},
	{"key_vector", CHAR32, OFF(XKeymapEvent, key_vector[0])},
	{0, 0, 0},
};
static struct callback exposeevent[] = {
	{"XExposeEvent",},
	{"type", INT, OFF(XExposeEvent, type)},
	{"serial", LONG, OFF(XExposeEvent, serial)},
	{"send_event", INT, OFF(XExposeEvent, send_event)},
	{"display", DISPLAY, OFF(XExposeEvent, display)},
	{"window", WINDOW, OFF(XExposeEvent, window)},
	{"x", INT, OFF(XExposeEvent, x)},
	{"y", INT, OFF(XExposeEvent, y)},
	{"width", INT, OFF(XExposeEvent, width)},
	{"height", INT, OFF(XExposeEvent, height)},
	{"count", INT, OFF(XExposeEvent, count)},
	{0, 0, 0},
};
static struct callback graphicsexposeevent[] = {
	{"XGraphicsExposeEvent",},
	{"type", INT, OFF(XGraphicsExposeEvent, type)},
	{"serial", LONG, OFF(XGraphicsExposeEvent, serial)},
	{"send_event", INT, OFF(XGraphicsExposeEvent, send_event)},
	{"display", DISPLAY, OFF(XGraphicsExposeEvent, display)},
	{"drawable", DRAWABLE, OFF(XGraphicsExposeEvent, drawable)},
	{"x", INT, OFF(XGraphicsExposeEvent, x)},
	{"y", INT, OFF(XGraphicsExposeEvent, y)},
	{"width", INT, OFF(XGraphicsExposeEvent, width)},
	{"height", INT, OFF(XGraphicsExposeEvent, height)},
	{"count", INT, OFF(XGraphicsExposeEvent, count)},
	{"major_code", INT, OFF(XGraphicsExposeEvent, major_code)},
	{"minor_code", INT, OFF(XGraphicsExposeEvent, minor_code)},
	{0, 0, 0},
};
static struct callback noexposeevent[] = {
	{"XNoExposeEvent",},
	{"type", INT, OFF(XNoExposeEvent, type)},
	{"serial", LONG, OFF(XNoExposeEvent, serial)},
	{"send_event", INT, OFF(XNoExposeEvent, send_event)},
	{"display", DISPLAY, OFF(XNoExposeEvent, display)},
	{"drawable", DRAWABLE, OFF(XNoExposeEvent, drawable)},
	{"major_code", INT, OFF(XNoExposeEvent, major_code)},
	{"minor_code", INT, OFF(XNoExposeEvent, minor_code)},
	{0, 0, 0},
};
static struct callback visibilityevent[] = {
	{"XVisibilityEvent",},
	{"type", INT, OFF(XVisibilityEvent, type)},
	{"serial", LONG, OFF(XVisibilityEvent, serial)},
	{"send_event", INT, OFF(XVisibilityEvent, send_event)},
	{"display", DISPLAY, OFF(XVisibilityEvent, display)},
	{"window", WINDOW, OFF(XVisibilityEvent, window)},
	{"state", INT, OFF(XVisibilityEvent, state)},
	{0, 0, 0},
};
static struct callback createwindowevent[] = {
	{"XCreateWindowEvent",},
	{"type", INT, OFF(XCreateWindowEvent, type)},
	{"serial", LONG, OFF(XCreateWindowEvent, serial)},
	{"send_event", INT, OFF(XCreateWindowEvent, send_event)},
	{"display", DISPLAY, OFF(XCreateWindowEvent, display)},
	{"parent", WINDOW, OFF(XCreateWindowEvent, parent)},
	{"window", WINDOW, OFF(XCreateWindowEvent, window)},
	{"x", INT, OFF(XCreateWindowEvent, x)},
	{"y", INT, OFF(XCreateWindowEvent, y)},
	{"width", INT, OFF(XCreateWindowEvent, width)},
	{"height", INT, OFF(XCreateWindowEvent, height)},
	{"border_width", INT, OFF(XCreateWindowEvent, border_width)},
	{"override_redirect", INT, OFF(XCreateWindowEvent, override_redirect)},
	{0, 0, 0},
};
static struct callback destroywindowevent[] = {
	{"XDestroyWindowEvent",},
	{"type", INT, OFF(XDestroyWindowEvent, type)},
	{"serial", LONG, OFF(XDestroyWindowEvent, serial)},
	{"send_event", INT, OFF(XDestroyWindowEvent, send_event)},
	{"display", DISPLAY, OFF(XDestroyWindowEvent, display)},
	{"event", WINDOW, OFF(XDestroyWindowEvent, event)},
	{"window", WINDOW, OFF(XDestroyWindowEvent, window)},
	{0, 0, 0},
};
static struct callback unmapevent[] = {
	{"XUnmapEvent",},
	{"type", INT, OFF(XUnmapEvent, type)},
	{"serial", LONG, OFF(XUnmapEvent, serial)},
	{"send_event", INT, OFF(XUnmapEvent, send_event)},
	{"display", DISPLAY, OFF(XUnmapEvent, display)},
	{"event", WINDOW, OFF(XUnmapEvent, event)},
	{"window", WINDOW, OFF(XUnmapEvent, window)},
	{"from_configure", INT, OFF(XUnmapEvent, from_configure)},
	{0, 0, 0},
};
static struct callback mapevent[] = {
	{"XMapEvent",},
	{"type", INT, OFF(XMapEvent, type)},
	{"serial", LONG, OFF(XMapEvent, serial)},
	{"send_event", INT, OFF(XMapEvent, send_event)},
	{"display", DISPLAY, OFF(XMapEvent, display)},
	{"event", WINDOW, OFF(XMapEvent, event)},
	{"window", WINDOW, OFF(XMapEvent, window)},
	{"override_redirect", INT, OFF(XMapEvent, override_redirect)},
	{0, 0, 0},
};
static struct callback maprequestevent[] = {
	{"XMapRequestEvent",},
	{"type", INT, OFF(XMapRequestEvent, type)},
	{"serial", LONG, OFF(XMapRequestEvent, serial)},
	{"send_event", INT, OFF(XMapRequestEvent, send_event)},
	{"display", DISPLAY, OFF(XMapRequestEvent, display)},
	{"parent", WINDOW, OFF(XMapRequestEvent, parent)},
	{"window", WINDOW, OFF(XMapRequestEvent, window)},
	{0, 0, 0},
};
static struct callback reparentevent[] = {
	{"XReparentEvent",},
	{"type", INT, OFF(XReparentEvent, type)},
	{"serial", LONG, OFF(XReparentEvent, serial)},
	{"send_event", INT, OFF(XReparentEvent, send_event)},
	{"event", WINDOW, OFF(XReparentEvent, event)},
	{"window", WINDOW, OFF(XReparentEvent, window)},
	{"parent", WINDOW, OFF(XReparentEvent, parent)},
	{"x", INT, OFF(XReparentEvent, x)},
	{"y", INT, OFF(XReparentEvent, y)},
	{"override_redirect", INT, OFF(XReparentEvent, override_redirect)},
	{0, 0, 0},
};
static struct callback configureevent[] = {
	{"XConfigureEvent",},
	{"type", INT, OFF(XConfigureEvent, type)},
	{"serial", LONG, OFF(XConfigureEvent, serial)},
	{"send_event", INT, OFF(XConfigureEvent, send_event)},
	{"display", DISPLAY, OFF(XConfigureEvent, display)},
	{"event", WINDOW, OFF(XConfigureEvent, event)},
	{"window", WINDOW, OFF(XConfigureEvent, window)},
	{"x", INT, OFF(XConfigureEvent, x)},
	{"y", INT, OFF(XConfigureEvent, y)},
	{"width", INT, OFF(XConfigureEvent, width)},
	{"height", INT, OFF(XConfigureEvent, height)},
	{"border_width", INT, OFF(XConfigureEvent, border_width)},
	{"above", WINDOW, OFF(XConfigureEvent, above)},
	{"override_redirect", INT, OFF(XConfigureEvent, override_redirect)},
	{0, 0, 0},
};
static struct callback gravityevent[] = {
	{"XGravityEvent",},
	{"type", INT, OFF(XGravityEvent, type)},
	{"serial", LONG, OFF(XGravityEvent, serial)},
	{"send_event", INT, OFF(XGravityEvent, send_event)},
	{"display", DISPLAY, OFF(XGravityEvent, display)},
	{"event", WINDOW, OFF(XGravityEvent, event)},
	{"window", WINDOW, OFF(XGravityEvent, window)},
	{"x", INT, OFF(XGravityEvent, x)},
	{"y", INT, OFF(XGravityEvent, y)},
	{0, 0, 0},
};
static struct callback resizerequestevent[] = {
	{"XResizeRequestEvent",},
	{"type", INT, OFF(XResizeRequestEvent, type)},
	{"serial", LONG, OFF(XResizeRequestEvent, serial)},
	{"send_event", INT, OFF(XResizeRequestEvent, send_event)},
	{"display", DISPLAY, OFF(XResizeRequestEvent, display)},
	{"window", WINDOW, OFF(XResizeRequestEvent, window)},
	{"width", INT, OFF(XResizeRequestEvent, width)},
	{"height", INT, OFF(XResizeRequestEvent, height)},
	{0, 0, 0},
};
static struct callback configurerequestevent[] = {
	{"XConfigureRequestEvent",},
	{"type", INT, OFF(XConfigureRequestEvent, type)},
	{"serial", LONG, OFF(XConfigureRequestEvent, serial)},
	{"send_event", INT, OFF(XConfigureRequestEvent, send_event)},
	{"display", DISPLAY, OFF(XConfigureRequestEvent, display)},
	{"parent", WINDOW, OFF(XConfigureRequestEvent, parent)},
	{"window", WINDOW, OFF(XConfigureRequestEvent, window)},
	{"x", INT, OFF(XConfigureRequestEvent, x)},
	{"y", INT, OFF(XConfigureRequestEvent, y)},
	{"width", INT, OFF(XConfigureRequestEvent, width)},
	{"height", INT, OFF(XConfigureRequestEvent, height)},
	{"border_width", INT, OFF(XConfigureRequestEvent, border_width)},
	{"above", WINDOW, OFF(XConfigureRequestEvent, above)},
	{"detail", INT, OFF(XConfigureRequestEvent, detail)},
	{"value_mask", LONG, OFF(XConfigureRequestEvent, value_mask)},
	{0, 0, 0},
};
static struct callback circulateevent[] = {
	{"XCirculateEvent",},
	{"type", INT, OFF(XCirculateEvent, type)},
	{"serial", LONG, OFF(XCirculateEvent, serial)},
	{"send_event", INT, OFF(XCirculateEvent, send_event)},
	{"display", DISPLAY, OFF(XCirculateEvent, display)},
	{"event", WINDOW, OFF(XCirculateEvent, event)},
	{"window", WINDOW, OFF(XCirculateEvent, window)},
	{"place", INT, OFF(XCirculateEvent, place)},
	{0, 0, 0},
};
static struct callback circulaterequestevent[] = {
	{"XCirculateRequestEvent",},
	{"type", INT, OFF(XCirculateRequestEvent, type)},
	{"serial", LONG, OFF(XCirculateRequestEvent, serial)},
	{"send_event", INT, OFF(XCirculateRequestEvent, send_event)},
	{"display", DISPLAY, OFF(XCirculateRequestEvent, display)},
	{"parent", WINDOW, OFF(XCirculateRequestEvent, parent)},
	{"window", WINDOW, OFF(XCirculateRequestEvent, window)},
	{"place", INT, OFF(XCirculateRequestEvent, place)},
	{0, 0, 0},
};
static struct callback propertyevent[] = {
	{"XPropertyEvent",},
	{"type", INT, OFF(XPropertyEvent, type)},
	{"serial", LONG, OFF(XPropertyEvent, serial)},
	{"send_event", INT, OFF(XPropertyEvent, send_event)},
	{"display", DISPLAY, OFF(XPropertyEvent, display)},
	{"window", WINDOW, OFF(XPropertyEvent, window)},
	{"atom", LONG, OFF(XPropertyEvent, atom)},
	{"time", LONG, OFF(XPropertyEvent, time)},
	{"state", INT, OFF(XPropertyEvent, state)},
	{0, 0, 0},
};
static struct callback selectionclearevent[] = {
	{"XSelectionClearEvent",},
	{"type", INT, OFF(XSelectionClearEvent, type)},
	{"serial", LONG, OFF(XSelectionClearEvent, serial)},
	{"send_event", INT, OFF(XSelectionClearEvent, send_event)},
	{"display", DISPLAY, OFF(XSelectionClearEvent, display)},
	{"window", WINDOW, OFF(XSelectionClearEvent, window)},
	{"selection", LONG, OFF(XSelectionClearEvent, selection)},
	{"time", LONG, OFF(XSelectionClearEvent, time)},
	{0, 0, 0},
};
static struct callback selectionrequestevent[] = {
	{"XSelectionRequestEvent",},
	{"type", INT, OFF(XSelectionRequestEvent, type)},
	{"serial", LONG, OFF(XSelectionRequestEvent, serial)},
	{"send_event", INT, OFF(XSelectionRequestEvent, send_event)},
	{"display", DISPLAY, OFF(XSelectionRequestEvent, display)},
	{"owner", WINDOW, OFF(XSelectionRequestEvent, owner)},
	{"requestor", WINDOW, OFF(XSelectionRequestEvent, requestor)},
	{"selection", LONG, OFF(XSelectionRequestEvent, selection)},
	{"target", LONG, OFF(XSelectionRequestEvent, target)},
	{"property", LONG, OFF(XSelectionRequestEvent, property)},
	{"time", LONG, OFF(XSelectionRequestEvent, time)},
	{0, 0, 0},
};
static struct callback selectionevent[] = {
	{"XSelectionEvent",},
	{"type", INT, OFF(XSelectionEvent, type)},
	{"serial", LONG, OFF(XSelectionEvent, serial)},
	{"send_event", INT, OFF(XSelectionEvent, send_event)},
	{"display", DISPLAY, OFF(XSelectionEvent, display)},
	{"requestor", WINDOW, OFF(XSelectionEvent, requestor)},
	{"selection", LONG, OFF(XSelectionEvent, selection)},
	{"target", LONG, OFF(XSelectionEvent, target)},
	{"property", LONG, OFF(XSelectionEvent, property)},
	{"time", LONG, OFF(XSelectionEvent, time)},
	{0, 0, 0},
};
static struct callback colormapevent[] = {
	{"XColormapEvent",},
	{"type", INT, OFF(XColormapEvent, type)},
	{"serial", LONG, OFF(XColormapEvent, serial)},
	{"send_event", INT, OFF(XColormapEvent, send_event)},
	{"display", DISPLAY, OFF(XColormapEvent, display)},
	{"window", WINDOW, OFF(XColormapEvent, window)},
	{"colormap", COLORMAP, OFF(XColormapEvent, colormap)},
#if defined(__cplusplus) || defined(c_plusplus)
	{"new", INT, OFF(XColormapEvent, c_new)}, /* C++ */
#else
	{"new", INT, OFF(XColormapEvent, new)},
#endif
	{"state", INT, OFF(XColormapEvent, state)},
	{0, 0, 0},
};
static struct callback clientmessageevent[] = {
	{"XClientMessageEvent",},
	{"type", INT, OFF(XClientMessageEvent, type)},
	{"serial", LONG, OFF(XClientMessageEvent, serial)},
	{"send_event", INT, OFF(XClientMessageEvent, send_event)},
	{"display", DISPLAY, OFF(XClientMessageEvent, display)},
	{"window", WINDOW, OFF(XClientMessageEvent, window)},
	{"message_type", LONG, OFF(XClientMessageEvent, message_type)},
	{"format", INT, OFF(XClientMessageEvent, format)},
	{"data", CHAR20, OFF(XClientMessageEvent, data.b[0])},
	{0, 0, 0},
};
static struct callback mappingevent[] = {
	{"XMappingEvent",},
	{"type", INT, OFF(XMappingEvent, type)},
	{"serial", LONG, OFF(XMappingEvent, serial)},
	{"send_event", INT, OFF(XMappingEvent, send_event)},
	{"display", DISPLAY, OFF(XMappingEvent, display)},
	{"window", WINDOW, OFF(XMappingEvent, window)},
	{"request", INT, OFF(XMappingEvent, request)},
	{"first_keycode", INT, OFF(XMappingEvent, first_keycode)},
	{"count", INT, OFF(XMappingEvent, count)},
	{0, 0, 0},
};
static struct callback errorevent[] = {
	{"XErrorEvent",},
	{"type", INT, OFF(XErrorEvent, type)},
	{"display", DISPLAY, OFF(XErrorEvent, display)},
	{"resourceid", LONG, OFF(XErrorEvent, resourceid)},
	{"serial", LONG, OFF(XErrorEvent, serial)},
	{"error_code", UCHAR, OFF(XErrorEvent, error_code)},
	{"request_code", UCHAR, OFF(XErrorEvent, request_code)},
	{"minor_code", UCHAR, OFF(XErrorEvent, minor_code)},
	{0, 0, 0},
};
static struct callback anyevent[] = {
	{"XAnyEvent",},
	{"type", INT, OFF(XAnyEvent, type)},
	{"serial", LONG, OFF(XAnyEvent, serial)},
	{"send_event", INT, OFF(XAnyEvent, send_event)},
	{"display", DISPLAY, OFF(XAnyEvent, display)},
	{"window", WINDOW, OFF(XAnyEvent, window)},
	{0, 0, 0},
};

static PyMethodDef XEv_methods[] = {
	{NULL, NULL},		/* sentinel */
};

#define GET(bas, off, typ)	(* (typ *) ((char *) (bas) + (off)))
#define SET(bas, off, typ, val)	(* (typ *) ((char *) (bas) + (off)) = (val))

static PyObject *
xev_memberlist(self)
	X_Callbackobject *self;
{
	PyObject *v;
	int i;
	struct callback *cbp;

	for (i = 0, cbp = self->cb+1; cbp->name; cbp++)
		i++;
	v = PyList_New(i);
	if (v != NULL) {
		for (cbp = self->cb+1; --i >= 0; cbp++)
			PyList_SetItem(v, i, PyString_FromString(cbp->name));
		if (PyErr_Occurred() || PyList_Sort(v) == -1) {
			Py_DECREF(v);
			v = NULL;
		}
	}
	return v;
}

PyObject *
xev_ev(self, ev, type)
	X_Callbackobject *self;
	XtPointer ev;
	int type;
{
	PyObject *v;
	int i;

	if (ev == NULL) {
		Py_INCREF(Py_None);
		return Py_None;
	}
	for (i = 0; i < NINDIR; i++) {
		if ((v = self->indir[i]) != NULL &&
		    ((X_Callbackobject *) v)->event == ev) {
			Py_INCREF(v);
			return v;
		}
	}
	v = xev_new((XtPointer) ev, type, 0);
	for (i = 0; i < NINDIR; i++) {
		if (self->indir[i] == NULL) {
			self->indir[i] = v;
			Py_INCREF(v);
			break;
		}
	}
	return v;
}

static PyObject *
xev_getattr(self, name)
	X_Callbackobject *self;
	char *name;
{
	struct callback *cbp;
	if (name[0] == '_' && strcmp(name , "__name__") == 0)
		return PyString_FromString(self->cb[0].name);
	if (self->event == NULL) {
		PyErr_SetString(PyExc_RuntimeError,
				"Event does not exist anymore");
		return NULL;
	}
	if (name[0] == '_' && strcmp(name , "__members__") == 0)
		return xev_memberlist(self);
	for (cbp = self->cb+1; cbp->name; cbp++) {
		if (strcmp(cbp->name, name) == 0)
			goto found;
	}
	return Py_FindMethod(XEv_methods, (PyObject *) self, name);

found:
	switch (cbp->type) {
	case LONG:
		return PyInt_FromLong(GET(self->event, cbp->offset, long));
	case INT:
		return PyInt_FromLong((long) GET(self->event, cbp->offset, int));
	case UINT:
		return PyInt_FromLong((long) GET(self->event, cbp->offset, unsigned int));
	case SHORT:
		return PyInt_FromLong((long) GET(self->event, cbp->offset, short));
	case CHAR:
		return PyInt_FromLong((long) GET(self->event, cbp->offset, char));
	case UCHAR:
		return PyInt_FromLong((long) GET(self->event, cbp->offset, unsigned char));
	case WINDOW:
		return PyInt_FromLong((long) GET(self->event, cbp->offset, Window));
	case DISPLAY:
		return newdisplayobject(GET(self->event, cbp->offset, Display *),
					&display_methodchain);
	case COLORMAP:
		return CM_new(GET(self->event, cbp->offset, Colormap),
			      ((XAnyEvent *) self->event)->display, 0);
	case DRAWABLE:
		return PyPixmap_New(((XAnyEvent *) self->event)->display,
				    GET(self->event, cbp->offset, Drawable),
				    0);
	case CHAR32:
		return PyString_FromStringAndSize((char *) self->event + cbp->offset, 32);
	case CHAR20:
		return PyString_FromStringAndSize((char *) self->event + cbp->offset, 20);
	case XEVENT:
		return xev_ev(self,
			(XtPointer) GET(self->event, cbp->offset, XEvent *),
			0);
	default:
		{
			struct cv_func *cvp;
			PyObject *v;

			for (cvp = cv_head; cvp; cvp = cvp->next) {
				v = (*cvp->func_get)(self, cbp, name);
				if (v != NULL)
					return v;
			}
		}
		PyErr_SetString(PyExc_RuntimeError, "not yet implemented");
		return NULL;
	}
}

static int
xev_setattr(self, name, value)
	X_Callbackobject *self;
	char *name;
	PyObject *value;
{
	struct callback *cbp;
	if (self->event == NULL) {
		PyErr_SetString(PyExc_RuntimeError,
				"Event does not exist anymore");
		return -1;
	}
	for (cbp = self->cb+1; cbp->name; cbp++) {
		if (strcmp(cbp->name, name) == 0)
			goto found;
	}
	PyErr_SetString(PyExc_AttributeError, name);
	return -1;

found:
	switch (cbp->type) {
	case LONG:
		{
			long v = PyInt_AsLong(value);
			if (PyErr_Occurred())
				return -1;
			SET(self->event, cbp->offset, long, v);
			break;
		}
	case INT:
		{
			int v = PyInt_AsLong(value);
			if (PyErr_Occurred())
				return -1;
			SET(self->event, cbp->offset, int, v);
			break;
		}
	case UINT:
		{
			unsigned int v = PyInt_AsLong(value);
			if (PyErr_Occurred())
				return -1;
			SET(self->event, cbp->offset, unsigned int, v);
			break;
		}
	case SHORT:
		{
			short v = PyInt_AsLong(value);
			if (PyErr_Occurred())
				return -1;
			SET(self->event, cbp->offset, short, v);
			break;
		}
	case CHAR:
		{
			char v = PyInt_AsLong(value);
			if (PyErr_Occurred())
				return -1;
			SET(self->event, cbp->offset, char, v);
			break;
		}
	case UCHAR:
		{
			unsigned char v = PyInt_AsLong(value);
			if (PyErr_Occurred())
				return -1;
			SET(self->event, cbp->offset, unsigned char, v);
			break;
		}
	case WINDOW:
		{
			Window v = (Window) PyInt_AsLong(value);
			if (PyErr_Occurred())
				return -1;
			SET(self->event, cbp->offset, Window, v);
			break;
		}
	case DISPLAY:
		{
			Display * v = getdisplayvalue(value);
			if (PyErr_Occurred())
				return -1;
			SET(self->event, cbp->offset, Display *, v);
			break;
		}
	case COLORMAP:
		{
			Colormap v = getcolormapvalue(value);
			if (PyErr_Occurred())
				return -1;
			SET(self->event, cbp->offset, Colormap, v);
			break;
		}
	case DRAWABLE:
		{
			Drawable v = (Drawable) getpixmapvalue(value);
			if (PyErr_Occurred()) {
				PyErr_Clear();
				v = (Drawable) PyInt_AsLong(value);
				if (PyErr_Occurred())
					return -1;
			}
			SET(self->event, cbp->offset, Drawable, v);
			break;
		}
	case CHAR32:
	case CHAR20:
		{
			char *v = PyString_AsString(value);
			int l;
			if (PyErr_Occurred())
				return -1;
			l = PyString_Size(value);
			if (cbp->type == CHAR32) {
				memset((char *) self->event + cbp->offset, 0, 32);
				if (l > 32)
					l = 32;
			} else {
				memset((char *) self->event + cbp->offset, 0, 20);
				if (l > 20)
					l = 20;
			}
			memcpy((char *) self->event + cbp->offset, v, l);
			break;
		}
	default:
		{
			struct cv_func *cvp;
			int v;

			for (cvp = cv_head; cvp; cvp = cvp->next) {
				v = (*cvp->func_set)(self, cbp, name, value);
				if (v <= 0)
					return v;
			}
		}
		PyErr_SetString(PyExc_RuntimeError, "read-only attribute");
		return -1;
	}
	return 0;
}

static void
xev_dealloc(self)
	X_Callbackobject *self;
{
	if (self->event != NULL) {
		if (self->owner)
			PyMem_DEL(self->event);
		else
			xev_destroy((PyObject *) self);
	}
	PyMem_DEL(self);
}

PyTypeObject X_CallbackType = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,			/*ob_size*/
	"X_Callback",		/*tp_name*/
	sizeof(X_Callbackobject),	/*tp_size*/
	0,			/*tp_itemsize*/
	/* methods */
	(destructor)xev_dealloc,/*tp_dealloc*/
	0,			/*tp_print*/
	(getattrfunc)xev_getattr, /*tp_getattr*/
	(setattrfunc)xev_setattr, /*tp_setattr*/
	0,			/*tp_compare*/
	0,			/*tp_repr*/
	0,			/*tp_as_number*/
	0,			/*tp_as_sequence*/
	0,			/*tp_as_mapping*/
	0,			/*tp_hash*/
};

PyObject *
xev_new(ptr, cbtype, mkcopy)
	XtPointer ptr;
	int cbtype;
	int mkcopy;
{
	X_Callbackobject *v;
	struct callback *cb;
	int i;

	if (ptr == NULL) {
		Py_INCREF(Py_None);
		return Py_None;
	}

	if (cbtype == 0) {
		switch (((XEvent *) ptr)->type) {
		case KeyPress:
		case KeyRelease:
			cb = keyevent; break;
		case ButtonPress:
		case ButtonRelease:
			cb = buttonevent; break;
		case MotionNotify:
			cb = motionevent; break;
		case EnterNotify:
		case LeaveNotify:
			cb = crossingevent; break;
		case FocusIn:
		case FocusOut:
			cb = focuschangeevent; break;
		case KeymapNotify:
			cb = keymapevent; break;
		case Expose:
			cb = exposeevent; break;
		case GraphicsExpose:
			cb = graphicsexposeevent; break;
		case NoExpose:
			cb = noexposeevent; break;
		case VisibilityNotify:
			cb = visibilityevent; break;
		case CreateNotify:
			cb = createwindowevent; break;
		case DestroyNotify:
			cb = destroywindowevent; break;
		case UnmapNotify:
			cb = unmapevent; break;
		case MapNotify:
			cb = mapevent; break;
		case MapRequest:
			cb = maprequestevent; break;
		case ReparentNotify:
			cb = reparentevent; break;
		case ConfigureNotify:
			cb = configureevent; break;
		case ConfigureRequest:
			cb = configurerequestevent; break;
		case GravityNotify:
			cb = gravityevent; break;
		case ResizeRequest:
			cb = resizerequestevent; break;
		case CirculateNotify:
			cb = circulateevent; break;
		case CirculateRequest:
			cb = circulaterequestevent; break;
		case PropertyNotify:
			cb = propertyevent; break;
		case SelectionClear:
			cb = selectionclearevent; break;
		case SelectionRequest:
			cb = selectionrequestevent; break;
		case SelectionNotify:
			cb = selectionevent; break;
		case ColormapNotify:
			cb = colormapevent; break;
		case ClientMessage:
			cb = clientmessageevent; break;
		case MappingNotify:
			cb = mappingevent; break;
		default:
			cb = anyevent; break;
		}
	} else {
		struct cv_func *cvp;
		for (cvp = cv_head; cvp; cvp = cvp->next) {
			cb = (*cvp->getcb)(ptr, cbtype);
			if (cb != NULL)
				break;
		}
		if (cb == NULL) {
			PyErr_SetString(PyExc_RuntimeError, "internal error");
			return NULL;
		}
	}
	v = PyObject_NEW(X_Callbackobject, &X_CallbackType);
	if (v == NULL)
		return NULL;
	if (mkcopy) {
		v->event = malloc(sizeof(XEvent));
		if (v->event == NULL) {
			Py_DECREF(v);
			PyErr_NoMemory();
			return NULL;
		}
		memcpy(v->event, ptr, sizeof(XEvent));
	} else
		v->event = ptr;
	v->owner = mkcopy;
	v->cb = cb;
	for (i = 0; i < NINDIR; i++)
		v->indir[i] = NULL;
	v->is_XEvent = cbtype == 0;
	return (PyObject *) v;
}

void
xev_destroy(self)
	PyObject *self;
{
	int i;
	X_Callbackobject *v;

	if (!is_X_CallbackObject(self))
		return;

	v = (X_Callbackobject *) self;
	for (i = 0; i < NINDIR; i++) {
		if (v->indir[i] != NULL) {
			xev_destroy(v->indir[i]);
			Py_DECREF(v->indir[i]);
			v->indir[i] = NULL;
		}
	}
	v->event = NULL;
}

int
xev_gettype(w, callback_name)
	Widget w;
	char *callback_name;
{
	struct cv_func *cvp;
	int type;

	for (cvp = cv_head; cvp; cvp = cvp->next) {
		type = (*cvp->gettype)(w, callback_name);
		if (type >= 0)
			return type;
	}
	return 0;		/* assume it's an XEvent */
}

void
xev_addfuncs(get, set, gettype, getcb)
	PyObject *(*get) Py_PROTO((X_Callbackobject *, struct callback *, char *));
	int (*set) Py_PROTO((X_Callbackobject *, struct callback *, char *, PyObject *));
	int (*gettype) Py_PROTO((Widget, char *));
	struct callback *(*getcb) Py_PROTO((XtPointer, int));
{
	struct cv_func *cvp;

	cvp = PyMem_NEW(struct cv_func, 1);
	if (cvp == NULL)
		Py_FatalError("can't initialize module Xm");
	cvp->func_get = get;
	cvp->func_set = set;
	cvp->gettype = gettype;
	cvp->getcb = getcb;
	cvp->next = cv_head;
	cv_head = cvp;
}

PyObject *
Xlib_Event(self, args)
	PyObject *self, *args;
{
	XEvent e;
	PyObject *v;
	PyObject *argdict = NULL, *key, *value;
	int pos;

	memset((void *) &e, 0, sizeof(e));
	if (!PyArg_ParseTuple(args, "i|O!", &e.type, &PyDict_Type, &argdict))
		return NULL;
	v = xev_new((XtPointer) &e, 0, 1);
	if (argdict == NULL)
		return v;

	pos = 0;
	while (PyDict_Next(argdict, &pos, &key, &value)) {
		if (!PyString_Check(key)) {
			PyErr_SetString(PyExc_TypeError,
					"args dictionary keys must be strings");
			Py_DECREF(v);
			return NULL;
		}
		if (xev_setattr(v, PyString_AsString(key), value) == -1) {
			Py_DECREF(v);
			return NULL;
		}
	}
	return v;
}
