/***********************************************************
Copyright 1991, 1992, 1993 by Stichting Mathematisch Centrum,
Amsterdam, The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* Support routines for module Xm */

#include "Python.h"
#include "modsupport.h"
#include "widgetobject.h"
#include "Xttypes.h"
#include "Xmsupport.h"
#if XmVersion >= 1001
#include <Xm/Protocols.h>
#endif
#if XmVersion >= 1002
#include "event.h"
#include <Xm/DragDrop.h>
#endif /* XmVersion >= 1002 */

#if XmVersion >= 1002
static void fill_secondaryresources Py_PROTO((wclassobject *));
#endif /* XmVersion >= 1002 */

PyObject *
xmstring2pstring(s)
	XmString s;
{
	char *text;
	if (s != (XmString)(-1) &&
	    XmStringGetLtoR(s, XmSTRING_DEFAULT_CHARSET, &text))
		return PyString_FromString(text);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
xmsconverter(self, xtvalue)
	widgetobject *self;
	XrmValue *xtvalue;
{
	return xmstring2pstring(* (XmString *) xtvalue->addr);
}

static Cardinal
univ_insertPosition(w)
	Widget w;
{
	Widget parent = XtParent(w);
	widgetobject *wobj;
	PyObject *cbfunc, *cbargs;
	PyObject *result;
	Arg a[1];
	Cardinal v;

	XtSetArg(a[0], XtNnumChildren, &v);
	XtGetValues(parent, a, 1);	/* get default result */

	wobj = newwidgetobject(parent, &widget_methodchain, NULL);
	if (wobj == NULL || wobj->ob_resdict == NULL) {
		Py_XDECREF(wobj);
		return v;
	}
	cbfunc = PyDict_GetItemString(wobj->ob_resdict, XtNinsertPosition);
	Py_DECREF(wobj);
	if (cbfunc == NULL) {
		PyErr_Clear();
		return v;
	}
	wobj = newwidgetobject(w, &widget_methodchain, NULL);
	if (wobj == NULL) {
		PyErr_Clear();
		return v;
	}
	cbargs = Py_BuildValue("(O)", wobj);
	Py_DECREF(wobj);
	if (cbargs == NULL) {
		PyErr_Clear();
		return v;
	}
	result = call_object_save_jump(XtNinsertPosition, cbfunc, cbargs);
	Py_DECREF(cbargs);
	if (result == NULL)
		PyErr_Clear();
	else {
		if (PyInt_Check(result))
			v = PyInt_AsLong(result);
		Py_DECREF(result);
	}
	return v;
}

static void
univ_createPopupChildProc(w)
	Widget w;
{
	Widget parent = XtParent(w);
	widgetobject *wobj;
	PyObject *cbfunc, *cbargs;
	PyObject *result;

	wobj = newwidgetobject(parent, &widget_methodchain, NULL);
	if (wobj == NULL || wobj->ob_resdict == NULL) {
		Py_XDECREF(wobj);
		return;
	}
	cbfunc = PyDict_GetItemString(wobj->ob_resdict, XtNcreatePopupChildProc);
	Py_DECREF(wobj);
	if (cbfunc == NULL) {
		PyErr_Clear();
		return;
	}
	wobj = newwidgetobject(w, &widget_methodchain, NULL);
	if (wobj == NULL) {
		PyErr_Clear();
		return;
	}
	cbargs = Py_BuildValue("(O)", wobj);
	Py_DECREF(wobj);
	result = call_object_save_jump(XtNcreatePopupChildProc, cbfunc, cbargs);
	Py_DECREF(cbargs);
	if (result == NULL)
		PyErr_Clear();
	else
		Py_DECREF(result); /* throw away result */
}

#if XmVersion >= 1002
PyObject *
widget_DragStart(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	PyObject *arg1;
	WidgetClass wClist[1];
	PyObject *arg2, *dict; ArgList tmp_arg2; int nargs_arg2;
	if (!PyArg_ParseTuple(args, "OO",
			&arg1,
			&arg2))
		return NULL;
	wClist[0] = xmDragContextClass;
	if (!is_XEvent(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Event*");
		return NULL;
	}
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg2, &tmp_arg2, &nargs_arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmDragStart(self->ob_widget,
			(XEvent*)((X_Callbackobject*)(arg1))->event,
			tmp_arg2, nargs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg2);
	if (jump_flag) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

PyObject *
widget_DropSiteRegister(self, args)
	widgetobject *self;
	PyObject *args;
{
	WidgetClass wClist[1];
	PyObject *arg1, *dict; ArgList tmp_arg1; int nargs_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	wClist[0] = xmDropSiteManagerObjectClass;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg1, &tmp_arg1, &nargs_arg1))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmDropSiteRegister(self->ob_widget,
			tmp_arg1, nargs_arg1);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg1);
	if (jump_flag) { jump_flag = 0; Py_DECREF(dict); return NULL; }
	PyDict_SetItemString(self->ob_resdict, "*DropSiteRegister*", dict);
	Py_DECREF(dict);
	Py_INCREF(Py_None);
	return Py_None;
}

PyObject *
widget_DropTransferStart(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	WidgetClass wClist[1];
	PyObject *arg1, *dict; ArgList tmp_arg1; int nargs_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	wClist[0] = xmDropTransferObjectClass;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg1, &tmp_arg1, &nargs_arg1))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmDropTransferStart(self->ob_widget,
			tmp_arg1, nargs_arg1);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg1);
	if (jump_flag) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

PyObject *
widget_GetDragContext(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	Time arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmGetDragContext(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	if (result == NULL) {
		Py_INCREF(Py_None);
		return Py_None;
	}
	return (PyObject *) newwidgetobject(result, &widget_methodchain, NULL);
}

static void
univ_doDragDropProc(resource, w, client_data, call_data)
	char *resource;
	Widget w;
	XtPointer client_data, call_data;
{
	widgetobject *wobj = NULL;
	PyObject *cbfunc, *warg = NULL, *cbargs = NULL, *result;

	wobj = newwidgetobject(w, &widget_methodchain, NULL);
	if (wobj == NULL)
		goto error;
	cbfunc = PyDict_GetItemString(wobj->ob_resdict, "*DropSiteRegister*");
	if (cbfunc == NULL)
		goto error;
	cbfunc = PyDict_GetItemString(cbfunc, resource);
	if (cbfunc == NULL)
		goto error;
	warg = xev_new(call_data, xev_gettype(w, resource), 0);
	if (warg == NULL)
		goto error;
	cbargs = Py_BuildValue("(OOO)", wobj, Py_None, warg);
	if (cbargs == NULL)
		goto error;
	Py_DECREF(wobj); wobj = NULL;
	result = call_object_save_jump(resource, cbfunc, cbargs);
	if (result == NULL)
		goto error;
	xev_destroy(warg);
	Py_DECREF(warg);
	Py_DECREF(cbargs);
	Py_XDECREF(result);
	return;

error:
	if (!jump_flag) {
		fprintf(stderr, "--- %s failed ---\n", resource);
		PyErr_Print();
		fprintf(stderr, "---\n");
	}
	Py_XDECREF(wobj);
	if (warg != NULL) {
		xev_destroy(warg);
		Py_DECREF(warg);
	}
	Py_XDECREF(cbargs);

}

static void
univ_dropProc(w, client_data, call_data)
	Widget w;
	XtPointer client_data, call_data;
{
	univ_doDragDropProc(XmNdropProc, w, client_data, call_data);
}

static void
univ_dragProc(w, client_data, call_data)
	Widget w;
	XtPointer client_data, call_data;
{
	univ_doDragDropProc(XmNdragProc, w, client_data, call_data);
}

static void
univ_transferProc(w, client_data, selection, type, value, length, format)
	Widget w;
	XtPointer client_data;
	Atom *selection;
	Atom *type;
	XtPointer value;
	unsigned long *length;
	int *format;
{
	widgetobject *wobj = NULL;
	PyObject *vobj = NULL, *cbfunc, *cbargs = NULL, *result;
	PyObject *typename;

	wobj = newwidgetobject(w, &widget_methodchain, NULL);
	if (wobj == NULL)
		goto error;
	vobj = PyString_FromStringAndSize(value, (int) (*length * *format / 8));
	if (vobj == NULL)
		goto error;
	cbfunc = PyDict_GetItemString(wobj->ob_resdict, XmNtransferProc);
	if (cbfunc == NULL)
		goto error;
	cbargs = Py_BuildValue("(OOllOli)", wobj, client_data, *selection,
			       *type, vobj, *length, *format); /* XXX */
	if (cbargs == NULL)
		goto error;
	Py_DECREF(wobj); wobj = NULL;
	Py_DECREF(vobj); vobj = NULL;
	result = call_object_save_jump(XmNtransferProc, cbfunc, cbargs);
	if (result == NULL)
		goto error;
	Py_DECREF(cbargs);
	Py_DECREF(result);
	return;

error:
	if (!jump_flag) {
		fprintf(stderr, "--- %s failed ---\n", XmNtransferProc);
		PyErr_Print();
		fprintf(stderr, "---\n");
	}
	Py_XDECREF(wobj);
	Py_XDECREF(vobj);
	Py_XDECREF(cbargs);
}

static struct save_convert {
	PyObject *value;
	XtRequestId request_id;
	struct save_convert *next;
} *save_convert;

static Boolean
univ_convertProc(w, selection, target, type_return, value_return,
		 length_return, format_return, max_length, client_data,
		 request_id)
	Widget w;
	Atom *selection;
	Atom *target;
	Atom *type_return;
	XtPointer *value_return;
	unsigned long *length_return;
	int *format_return;
	unsigned long *max_length;
	XtPointer client_data;
	XtRequestId *request_id;
{
	widgetobject *wobj = NULL;
	PyObject *cbfunc, *cbargs = NULL, *result = NULL, *value;
	int v = 0;
	struct save_convert **p;

	for (p = &save_convert; *p; p = &(*p)->next)
		if ((*p)->request_id == *request_id) {
			Py_XDECREF((*p)->value);
			(*p)->value = NULL;
			break;
		}
	wobj = newwidgetobject(w, &widget_methodchain, NULL);
	if (wobj == NULL)
		goto error;
	cbfunc = PyDict_GetItemString(wobj->ob_resdict, XmNconvertProc);
	if (cbfunc == NULL)
		goto error;
	cbargs = Py_BuildValue("(OiiiOi)", wobj, *selection, *target,
			       *max_length, Py_None, *request_id);
	if (cbargs == NULL)
		goto error;
	Py_DECREF(wobj); wobj = NULL;
	result = call_object_save_jump(XmNconvertProc, cbfunc, cbargs);
	if (result == NULL)
		goto error;
	if (result != Py_None) {
		if (!PyArg_ParseTuple(result, "lO!li", type_return,
				      &PyString_Type, &value, length_return,
				      format_return))
			goto error;
		if (PyString_Size(value) != *length_return * *format_return / 8) {
			PyErr_SetString(PyExc_ValueError, "bad value size");
			goto error;
		}
		*value_return = PyString_AsString(value);
		if (*length_return == 0) {
			if (*p != NULL) {
				struct save_convert *q = *p;
				*p = q->next;
				PyMem_DEL(q);
			}
			*value_return = "";
		} else {
			if (*p == NULL) {
				*p = PyMem_NEW(struct save_convert, 1);
				(*p)->next = NULL;
				(*p)->request_id = *request_id;
			}
			(*p)->value = value;
			Py_INCREF(value);
		}
		v = 1;
	}
	Py_DECREF(result);
	Py_DECREF(cbargs);
	return v;

error:
	if (!jump_flag) {
		fprintf(stderr, "--- %s failed ---\n", XmNconvertProc);
		PyErr_Print();
		fprintf(stderr, "---\n");
	}
	Py_XDECREF(wobj);
	Py_XDECREF(cbargs);
	Py_XDECREF(result);
	return 0;
}

static int
dropTransferList_to_res(list, parg, ctype)
	PyObject *list;
	Arg *parg;
	const char *ctype;
{
	int len, i;
	XmDropTransferEntry rlist;
	PyObject *value, *client_data;
	Atom target;

	if (ctype == NULL || strcmp(ctype, "DropTransfers") != 0)
		return -1;
	len = PyList_Size(list);
	rlist = PyMem_NEW(XmDropTransferEntryRec, len);
	if (rlist == NULL) {
		PyErr_NoMemory();
		return 0;
	}
	for (i = 0; i < len; i++) {
		value = PyList_GetItem(list, i);
		if (!PyArg_ParseTuple(value, "Ol", &client_data, &target)) {
			PyMem_DEL(rlist);
			return 0;
		}
		rlist[i].client_data = (XtPointer) client_data;
		rlist[i].target = target;
	}
	parg->value = (XtArgVal) rlist;
	parg[1].value = len;
	parg[1].name = malloc(strlen(parg->name) + 4);
	sprintf(parg[1].name, "num%c%s", toupper(parg->name[0]), parg->name+1);
	return 2;
}
#endif /* XmVersion >= 1002 */

static PyObject *
display_GetXmDisplay(self, args)
	displayobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	return (PyObject *) newwidgetobject(XmGetXmDisplay(self->display),
					    &widget_methodchain, NULL);
}

static PyMethodDef XmDislay_methods[] = {
	{"GetXmDisplay", (PyCFunction)display_GetXmDisplay, 1},
	{NULL, NULL}		/* sentinel */
};
PyMethodChain XmDisplay_methodchain = {
	XmDislay_methods,
	NULL,
};

void
initxmsupport(d)
	PyObject *d;
{
	extern void xmev_init Py_PROTO((void));
	PyDict_SetItemString(d, "VERSION", PyInt_FromLong(XmVERSION));
	PyDict_SetItemString(d, "REVISION", PyInt_FromLong(XmREVISION));
	PyDict_SetItemString(d, "UPDATE_LEVEL", PyInt_FromLong(XmUPDATE_LEVEL));
	PyDict_SetItemString(d, "Version", PyInt_FromLong(XmVersion));
	x2pregister("XmString", xmsconverter);
#if XmVersion >= 1002
	motif_getresources = fill_secondaryresources;
#endif /* XmVersion >= 1002 */
	register_callable(XmNinsertPosition, compositeWidgetClass,
			  (XtArgVal) univ_insertPosition);
	register_callable(XmNcreatePopupChildProc, shellWidgetClass,
			  (XtArgVal) univ_createPopupChildProc);
#if XmVersion >= 1002
	register_callable(XmNdragProc, xmDropSiteManagerObjectClass,
			  (XtArgVal) univ_dragProc);
	register_callable(XmNdropProc, xmDropSiteManagerObjectClass,
			  (XtArgVal) univ_dropProc);
	register_callable(XmNtransferProc, xmDropTransferObjectClass,
			  (XtArgVal) univ_transferProc);
	register_callable(XmNconvertProc, xmDragContextClass,
			  (XtArgVal) univ_convertProc);
	list_to_res_register(dropTransferList_to_res);
#endif /* XmVersion >= 1002 */
	display_methodchain.link = &XmDisplay_methodchain;
	xmev_init();
}

int
checkxmstringlist(args, ps, pn)
	PyObject *args;
	XmString **ps;
	int *pn;
{
	int i, n;
	XmString *s;
	if (!PyList_Check(args)) {
		PyErr_SetString(PyExc_TypeError, "list of strings expected");
		return 0;
	}
	n = PyList_Size(args);
	s = PyMem_NEW(XmString, n+1);
	if (s == NULL) {
		PyErr_NoMemory();
		return 0;
	}
	for (i = 0; i < n; i++) {
		PyObject *item = PyList_GetItem(args, i);
		if (!PyString_Check(item)) {
			PyErr_SetString(PyExc_TypeError, "list of strings expected");
			while (--i >= 0)
				XmStringFree(s[i]);
			PyMem_DEL(s);
			return 0;
		}
		s[i] = XmStringCreateLtoR(PyString_AsString(item),
					  XmSTRING_DEFAULT_CHARSET);
	}
	s[n] = NULL; /* In case caller wants a NULL-terminated list */
	*ps = s;
	*pn = n;
	return 1;
}

#if XmVersion >= 1001
PyObject *
widget_ListGetSelectedPos(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	PyObject *arg1;
	int *position_list;
	int position_count;
	PyObject *list;
	int i;
	PyObject *v;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XmListGetSelectedPos(self->ob_widget,
					      &position_list,
					      &position_count);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	if (!result) {
		Py_INCREF(Py_None);
		return Py_None;
	}
	list = PyList_New(position_count);
	for (i = 0; i < position_count && list != NULL; i++) {
		v = PyInt_FromLong(position_list[i]);
		if (v == NULL) {
			Py_DECREF(list);
			list = NULL;
		}
		else
			PyList_SetItem(list, i, v); /* Eats a ref */
	}
	PyMem_DEL(position_list);
	return list;
}
#endif /* XmVersion >= 1001 */

PyObject *
widget_ListReplaceItems(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1; XmString *tmp_arg1; int nstrs_arg1;
	PyObject *arg2; XmString *tmp_arg2; int nstrs_arg2;
	if (!PyArg_ParseTuple(args, "O!O!",
			&PyList_Type, &arg1,
			&PyList_Type, &arg2))
		return NULL;
	if (PyList_Size(arg1) != PyList_Size(arg2)) {
		PyErr_SetString(PyExc_TypeError,
				"arg1 and arg2 should be the same length");
		return NULL;
	}
	if (!checkxmstringlist(arg1, &tmp_arg1, &nstrs_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XmStringList");
		return NULL;
	}
	if (!checkxmstringlist(arg2, &tmp_arg2, &nstrs_arg2)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be XmStringList");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListReplaceItems(self->ob_widget,
				   tmp_arg1, nstrs_arg1, tmp_arg2);
		jump_flag = 0;
	}
	while (--nstrs_arg1 >= 0)
		XmStringFree(tmp_arg1[nstrs_arg1]);
	PyMem_DEL(tmp_arg1);
	while (--nstrs_arg2 >= 0)
		XmStringFree(tmp_arg2[nstrs_arg2]);
	PyMem_DEL(tmp_arg2);
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XmVersion >= 1002
PyObject *
widget_ListReplaceItemsUnselected(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1; XmString *tmp_arg1; int nstrs_arg1;
	PyObject *arg2; XmString *tmp_arg2; int nstrs_arg2;
	if (!PyArg_ParseTuple(args, "O!O!",
			&PyList_Type, &arg1,
			&PyList_Type, &arg2))
		return NULL;
	if (PyList_Size(arg1) != PyList_Size(arg2)) {
		PyErr_SetString(PyExc_TypeError,
				"arg1 and arg2 should be the same length");
		return NULL;
	}
	if (!checkxmstringlist(arg1, &tmp_arg1, &nstrs_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XmStringList");
		return NULL;
	}
	if (!checkxmstringlist(arg2, &tmp_arg2, &nstrs_arg2)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be XmStringList");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListReplaceItemsUnselected(self->ob_widget, tmp_arg1,
					     nstrs_arg1, tmp_arg2);
		jump_flag = 0;
	}
	while (--nstrs_arg1 >= 0)
		XmStringFree(tmp_arg1[nstrs_arg1]);
	PyMem_DEL(tmp_arg1);
	while (--nstrs_arg2 >= 0)
		XmStringFree(tmp_arg2[nstrs_arg2]);
	PyMem_DEL(tmp_arg2);
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

PyObject *
widget_ListReplacePositions(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1; int *ints_arg1; int nints_arg1;
	PyObject *arg2; XmString *tmp_arg2; int nstrs_arg2;
	if (!PyArg_ParseTuple(args, "O!O!",
			&PyList_Type, &arg1,
			&PyList_Type, &arg2))

		return NULL;
	if (PyList_Size(arg1) != PyList_Size(arg2)) {
		PyErr_SetString(PyExc_TypeError,
				"arg1 and arg2 should be the same length");
		return NULL;
	}
	if (!checkintlist(arg1, sizeof(int), &ints_arg1, &nints_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be intlist");
		return NULL;
	}
	if (!checkxmstringlist(arg2, &tmp_arg2, &nstrs_arg2)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be XmStringList");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XmListReplacePositions(self->ob_widget, ints_arg1,
				       tmp_arg2, nstrs_arg2);
		jump_flag = 0;
	}
	PyMem_DEL(ints_arg1);
	while (--nstrs_arg2 >= 0)
		XmStringFree(tmp_arg2[nstrs_arg2]);
	PyMem_DEL(tmp_arg2);
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}
#endif /* XmVersion >= 1002 */

#if XmVersion >= 1001
PyObject *
widget_AddProtocolCallback(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long property, protocol;
	PyObject *cbfunc, *cbarg;

	if (!PyArg_ParseTuple(args, "llOO", &property, &protocol, &cbfunc, &cbarg))
		return NULL;
	cbarg = make_closure(self, cbfunc, cbarg, xev_gettype(self->ob_widget, NULL));
	if (!setjmp(jump_where)) {
		XmAddProtocolCallback(self->ob_widget, property, protocol,
				      univ_callback, (XtPointer)cbarg);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

PyObject *
widget_AddWMProtocolCallback(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long property, protocol;
	PyObject *cbfunc, *cbarg;

	if (!PyArg_ParseTuple(args, "lOO", &protocol, &cbfunc, &cbarg))
		return NULL;
	cbarg = make_closure(self, cbfunc, cbarg, xev_gettype(self->ob_widget, NULL));
	if (!setjmp(jump_where)) {
		XmAddWMProtocolCallback(self->ob_widget, protocol,
					univ_callback, (XtPointer)cbarg);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

PyObject *
widget_SetProtocolHooks(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long property, protocol;
	PyObject *prefunc, *prearg;
	PyObject *postfunc, *postarg;

	if (!PyArg_ParseTuple(args, "llOOOO", &property, &protocol,
		     &prefunc, &prearg, &postfunc, &postarg))
		return NULL;
	prearg = make_closure(self, prefunc, prearg, xev_gettype(self->ob_widget, NULL));
	postarg = make_closure(self, postfunc, postarg, xev_gettype(self->ob_widget, NULL));
	if (!setjmp(jump_where)) {
		XmSetProtocolHooks(self->ob_widget, property, protocol,
				   univ_callback, (XtPointer)prearg,
				   univ_callback, (XtPointer)postarg);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

PyObject *
widget_SetWMProtocolHooks(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long protocol;
	PyObject *prefunc, *prearg;
	PyObject *postfunc, *postarg;

	if (!PyArg_ParseTuple(args, "lOOOO", &protocol,
		     &prefunc, &prearg, &postfunc, &postarg))
		return NULL;
	prearg = make_closure(self, prefunc, prearg, xev_gettype(self->ob_widget, NULL));
	postarg = make_closure(self, postfunc, postarg, xev_gettype(self->ob_widget, NULL));
	if (!setjmp(jump_where)) {
		XmSetWMProtocolHooks(self->ob_widget, protocol,
				   univ_callback, (XtPointer)prearg,
				   univ_callback, (XtPointer)postarg);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}
#endif /* XmVersion >= 1001 */

#if XmVersion >= 1002
#include <Xm/Screen.h>

PyObject *
widget_GetXmScreen(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	return (PyObject *) newwidgetobject(
				XmGetXmScreen(XtScreen(self->ob_widget)),
				&widget_methodchain, NULL);
}

PyObject *
Xmwc_GetSecondaryResourceData(self, args)
	wclassobject *self;
	PyObject *args;
{
	XmSecondaryResourceData *block_array;
	Cardinal num_blocks;
	int i;
	PyObject *result;

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		num_blocks = XmGetSecondaryResourceData(self->ob_wclass,
							&block_array);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	result = PyList_New(num_blocks);
	for (i = 0; i < num_blocks; i++) {
		PyObject *item;
		item = createResourceList(block_array[i]->resources,
					  block_array[i]->num_resources);
		XtFree((char *) block_array[i]->resources);
		XtFree((char *) block_array[i]);
		PyList_SetItem(result, i, item);
	}
	if (num_blocks > 0)
		XtFree((char *) block_array);
	return result;
}

static void
fill_secondaryresources(wc)
	wclassobject *wc;
{
	XmSecondaryResourceData *block_array;
	Cardinal num_blocks;
	int i;

	num_blocks = XmGetSecondaryResourceData(wc->ob_wclass, &block_array);
	if (num_blocks == 0)
		return;
	PyMem_RESIZE(wc->ob_reslist, struct resources, wc->ob_nreslist + num_blocks);
	if (wc->ob_reslist == NULL) {
		/* lost them :-( */
		wc->ob_nreslist = 0;
		return;
	}
	for (i = 0; i < num_blocks; i++) {
		wc->ob_reslist[wc->ob_nreslist + i].resources =
			block_array[i]->resources;
		wc->ob_reslist[wc->ob_nreslist + i].nresources =
			block_array[i]->num_resources;
		XtFree((char *) block_array[i]);
	}
	wc->ob_nreslist += num_blocks;
	XtFree((char *) block_array);
}
#endif /* XmVersion >= 1002 */
