/* Widget Set Xaw */

#include "Python.h"
#include "modsupport.h"
#include "import.h"
#include "widgetobject.h"

#define is_optwidgetobject(x)	((x) == Py_None || is_widgetobject(x))
#define getoptwidgetvalue(x)	((x) == Py_None ? NULL : getwidgetvalue(x))


/* Methods for Xaw objects */

#include <X11/Xaw/Box.h>

#if XtSpecificationRelease < 6
#include <X11/Xaw/Clock.h>

#endif /* XtSpecificationRelease < 6 */
#include <X11/Xaw/Command.h>

#include <X11/Xaw/Dialog.h>

#include <X11/Xaw/Form.h>

#include <X11/Xaw/Grip.h>

#include <X11/Xaw/Label.h>

#include <X11/Xaw/List.h>

#if XtSpecificationRelease < 6
#include <X11/Xaw/Logo.h>

#endif /* XtSpecificationRelease < 6 */
#if XtSpecificationRelease < 6
#include <X11/Xaw/Mailbox.h>

#endif /* XtSpecificationRelease < 6 */
#include <X11/Xaw/MenuButton.h>

#include <X11/Xaw/Paned.h>

#if XtSpecificationRelease > 4
#include <X11/Xaw/Panner.h>

#endif /* XtSpecificationRelease > 4 */
#if XtSpecificationRelease > 4
#include <X11/Xaw/Porthole.h>

#endif /* XtSpecificationRelease > 4 */
#if XtSpecificationRelease > 4
#include <X11/Xaw/Repeater.h>

#endif /* XtSpecificationRelease > 4 */
#include <X11/Xaw/Scrollbar.h>

#include <X11/Xaw/Simple.h>

#include <X11/Xaw/SimpleMenu.h>

#include <X11/Xaw/StripChart.h>

#include <X11/Xaw/Text.h>

#include <X11/Xaw/Toggle.h>

#if XtSpecificationRelease > 4
#include <X11/Xaw/Tree.h>

#endif /* XtSpecificationRelease > 4 */
#include <X11/Xaw/Viewport.h>

static PyMethodDef Xaw_methods[] = {
	{0, 0} /* Sentinel */
};


/* Methods for Xawwc objects */

static PyMethodDef Xawwc_methods[] = {
	{0, 0} /* Sentinel */
};


/* Methods for Xaww objects */

static PyMethodDef Xaww_methods[] = {
	{0, 0} /* Sentinel */
};


PyMethodChain Xaww_methodchain = {
	Xaww_methods,
	NULL,
};
PyMethodChain Xawwc_methodchain = {
	Xawwc_methods,
	&wclass_methodchain,
};

void
initXaw()
{
	PyObject *m, *d;
	m = PyImport_ImportModule("Xt");
	if (m == NULL)
		Py_FatalError("can't import module Xt for Xaw");
	Py_DECREF(m);
	m = Py_InitModule("Xaw", Xaw_methods);
	d = PyModule_GetDict(m);
	add_widget_methodchain(&Xaww_methodchain);
	PyDict_SetItemString(d, "Box",
		(PyObject*)newwclassobject(boxWidgetClass,
			&Xawwc_methodchain));
#if XtSpecificationRelease < 6
	PyDict_SetItemString(d, "Clock",
		(PyObject*)newwclassobject(clockWidgetClass,
			&Xawwc_methodchain));
#endif /* XtSpecificationRelease < 6 */
	PyDict_SetItemString(d, "Command",
		(PyObject*)newwclassobject(commandWidgetClass,
			&Xawwc_methodchain));
	PyDict_SetItemString(d, "Dialog",
		(PyObject*)newwclassobject(dialogWidgetClass,
			&Xawwc_methodchain));
	PyDict_SetItemString(d, "Form",
		(PyObject*)newwclassobject(formWidgetClass,
			&Xawwc_methodchain));
	PyDict_SetItemString(d, "Grip",
		(PyObject*)newwclassobject(gripWidgetClass,
			&Xawwc_methodchain));
	PyDict_SetItemString(d, "Label",
		(PyObject*)newwclassobject(labelWidgetClass,
			&Xawwc_methodchain));
	PyDict_SetItemString(d, "List",
		(PyObject*)newwclassobject(listWidgetClass,
			&Xawwc_methodchain));
#if XtSpecificationRelease < 6
	PyDict_SetItemString(d, "Logo",
		(PyObject*)newwclassobject(logoWidgetClass,
			&Xawwc_methodchain));
#endif /* XtSpecificationRelease < 6 */
#if XtSpecificationRelease < 6
	PyDict_SetItemString(d, "Mailbox",
		(PyObject*)newwclassobject(mailboxWidgetClass,
			&Xawwc_methodchain));
#endif /* XtSpecificationRelease < 6 */
	PyDict_SetItemString(d, "MenuButton",
		(PyObject*)newwclassobject(menuButtonWidgetClass,
			&Xawwc_methodchain));
	PyDict_SetItemString(d, "Paned",
		(PyObject*)newwclassobject(panedWidgetClass,
			&Xawwc_methodchain));
#if XtSpecificationRelease > 4
	PyDict_SetItemString(d, "Panner",
		(PyObject*)newwclassobject(pannerWidgetClass,
			&Xawwc_methodchain));
#endif /* XtSpecificationRelease > 4 */
#if XtSpecificationRelease > 4
	PyDict_SetItemString(d, "Porthole",
		(PyObject*)newwclassobject(portholeWidgetClass,
			&Xawwc_methodchain));
#endif /* XtSpecificationRelease > 4 */
#if XtSpecificationRelease > 4
	PyDict_SetItemString(d, "Repeater",
		(PyObject*)newwclassobject(repeaterWidgetClass,
			&Xawwc_methodchain));
#endif /* XtSpecificationRelease > 4 */
	PyDict_SetItemString(d, "Scrollbar",
		(PyObject*)newwclassobject(scrollbarWidgetClass,
			&Xawwc_methodchain));
	PyDict_SetItemString(d, "Simple",
		(PyObject*)newwclassobject(simpleWidgetClass,
			&Xawwc_methodchain));
	PyDict_SetItemString(d, "SimpleMenu",
		(PyObject*)newwclassobject(simpleMenuWidgetClass,
			&Xawwc_methodchain));
	PyDict_SetItemString(d, "StripChart",
		(PyObject*)newwclassobject(stripChartWidgetClass,
			&Xawwc_methodchain));
	PyDict_SetItemString(d, "Text",
		(PyObject*)newwclassobject(textWidgetClass,
			&Xawwc_methodchain));
	PyDict_SetItemString(d, "Toggle",
		(PyObject*)newwclassobject(toggleWidgetClass,
			&Xawwc_methodchain));
#if XtSpecificationRelease > 4
	PyDict_SetItemString(d, "Tree",
		(PyObject*)newwclassobject(treeWidgetClass,
			&Xawwc_methodchain));
#endif /* XtSpecificationRelease > 4 */
	PyDict_SetItemString(d, "Viewport",
		(PyObject*)newwclassobject(viewportWidgetClass,
			&Xawwc_methodchain));
}
