#include "Python.h"
#include "widgetobject.h"
#include "GCobject.h"
#include "Pixmapobject.h"

extern PyTypeObject Pixmaptype;

/* this method is shared by widgets and pixmaps */
PyObject *
widget_CreateGC(self, args)
	PyObject *self;
	PyObject *args;
{
	Display *display;
	Drawable d;
	unsigned long mask;
	XGCValues values;
	GC gc;
	if (!PyArg_ParseTuple(args, "O", &args))
		return NULL;
	if (is_widgetobject(self)) {
		widgetobject *wp = (widgetobject *) self;
		if (wp->ob_widget == NULL) {
			if (!PyErr_Occurred())
				PyErr_SetString(PyExc_RuntimeError, "widget already destroyed");
			return NULL;
		}
		display = XtDisplay(wp->ob_widget);
		d = XtWindow(wp->ob_widget);
	} else {
		Pixmapobject *pp = (Pixmapobject *) self;
		display = pp->display;
		d = pp->pixmap;
	}
	if (!PyGC_MakeValues(args, &mask, &values))
		return NULL;
	gc = XCreateGC(display, d, mask, &values);
	return PyGC_New(display, d, gc, (Widget)0);
}

/* this method is shared by widgets and pixmaps */
PyObject *
widget_ReadBitmapFile(self, args)
	PyObject *self;
	PyObject *args;
{
	Display	*display;
	Drawable d;
	String	arg1;
	unsigned int width, height;
	int hotspot_x, hotspot_y, error;
	Pixmap	bitmap;
	PyObject *pixmap, *tuple;

	if (!PyArg_ParseTuple(args, "s", &arg1))
		return NULL;
	if (is_widgetobject(self)) {
		widgetobject *wp = (widgetobject *) self;
		if (wp->ob_widget == NULL) {
			if (!PyErr_Occurred())
				PyErr_SetString(PyExc_RuntimeError, "widget already destroyed");
			return NULL;
		}
		display = XtDisplay(wp->ob_widget);
		d = XtWindow(wp->ob_widget);
	} else {
		Pixmapobject *pp = (Pixmapobject *) self;
		display = pp->display;
		d = pp->pixmap;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		error = XReadBitmapFile(display, d, arg1,
					&width, &height, &bitmap,
					&hotspot_x, &hotspot_y);
		jump_flag = 0;
	} else {
		jump_flag = 0;
		return NULL;
	}
	/*
	 * Check error code, create a message to be returned
	 * as well as the error code when the exception is
	 * raised.
	 */
	tuple = NULL;
	switch (error) {
	case BitmapOpenFailed:
		PyErr_SetString(PyExc_IOError,
				"XReadBitMapFile - cannot open file");
		break;
	case BitmapFileInvalid:
		PyErr_SetString(Xt_Error,
			   "XReadBitMapFile - invalid bitmap data in file");
		break;
	case BitmapNoMemory:
		PyErr_SetString(PyExc_MemoryError,
				"XReadBitMapFile - no memory !!");
		break;
	case BitmapSuccess:
		/*
		 * Setup a tuple to be returned containing the info.
		 * returned from the call.
		 */
		pixmap = PyPixmap_New(display, bitmap, 1);
		if (pixmap != NULL) {
			tuple = Py_BuildValue("(iiOii)", width, height, pixmap,
						   hotspot_x, hotspot_y);
			Py_DECREF(pixmap);
		}
		break;
	default:
		PyErr_SetString(PyExc_SystemError,
			   "XReadBitMapFile returned strange error");
		break;
	}

	return tuple;		/* will be NULL on error */
}

static PyObject *
pixmap_WriteBitmapFile(self, args)
	Pixmapobject *self;
	PyObject *args;
{
	char *file;
	int width, height;
	int x_hot = -1, y_hot = -1;
	int error;

	if (!PyArg_ParseTuple(args, "sii|ii", &file, &width, &height,
			      &x_hot, &y_hot))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		error = XWriteBitmapFile(self->display, file, self->pixmap,
					 width, height, x_hot, y_hot);
		jump_flag = 0;
	} else {
		jump_flag = 0;
		return NULL;
	}

	switch (error) {
	case BitmapOpenFailed:
		PyErr_SetString(PyExc_IOError,
				"XWriteBitmapFile - cannot open file");
		return NULL;
	case BitmapNoMemory:
		PyErr_SetString(PyExc_MemoryError,
				"XWriteBitmapFile - no memory !!");
		return NULL;
	case BitmapSuccess:
		break;
	default:
		PyErr_SetString(PyExc_SystemError,
				"XWriteBitmapFile returned strange error");
		return NULL;
	}
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
pixmap_CopyArea(self, args)
	Pixmapobject *self;
	PyObject *args;
{
	PyObject *destobj, *gcobj;
	Drawable dest;
	GC gc;
	int src_x, src_y, dest_x, dest_y;
	unsigned int width, height;

	if (!PyArg_ParseTuple(args, "OOiiiiii", &destobj, &gcobj, &src_x,
			      &src_y, &width, &height, &dest_x, &dest_y))
		return NULL;
	if (is_widgetobject(destobj)) {
		if (((widgetobject *) destobj)->ob_widget == NULL) {
			PyErr_SetString(PyExc_RuntimeError, "widget already destroyed");
			return NULL;
		}
		dest = XtWindow(((widgetobject *) destobj)->ob_widget);
	} else if (destobj->ob_type == &Pixmaptype) {
		dest = ((Pixmapobject *) destobj)->pixmap;
	} else {
		PyErr_SetString(PyExc_RuntimeError, "bad arguments");
		return NULL;
	}
	if (gcobj == Py_None)
		gc = DefaultGCOfScreen(DefaultScreenOfDisplay(self->display));
	else {
		gc = PyGC_GetGC(gcobj);
		if (PyErr_Occurred())
			return NULL;
	}

	XCopyArea(self->display, self->pixmap, dest, gc, src_x, src_y,
		  width, height, dest_x, dest_y);

	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
pixmap_CopyPlane(self, args)
	Pixmapobject *self;
	PyObject *args;
{
	PyObject *destobj, *gcobj;
	Widget w;
	Drawable dest;
	GC gc;
	int src_x, src_y, dest_x, dest_y;
	unsigned int width, height;
	unsigned long plane;

	if (!PyArg_ParseTuple(args, "OOiiiiiii", &destobj, &gcobj, &src_x,
			      &src_y, &width, &height, &dest_x, &dest_y, &plane))
		return NULL;
	if (is_widgetobject(destobj)) {
		w = ((widgetobject *) destobj)->ob_widget;
		if (w == NULL) {
			PyErr_SetString(PyExc_RuntimeError, "widget already destroyed");
			return NULL;
		}
		dest = XtWindow(w);
	} else {
		PyErr_SetString(PyExc_RuntimeError, "bad arguments");
		return NULL;
	}
	if (gcobj == Py_None)
		gc = DefaultGCOfScreen(XtScreen(w));
	else {
		gc = PyGC_GetGC(gcobj);
		if (PyErr_Occurred())
			return NULL;
	}

	XCopyPlane(self->display, self->pixmap, dest, gc, src_x, src_y,
		  width, height, dest_x, dest_y, plane);

	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef pixmap_methods[] = {
	{"CreateGC",	(PyCFunction)widget_CreateGC,		1},
	{"CopyArea",	(PyCFunction)pixmap_CopyArea,		1},
	{"CopyPlane",	(PyCFunction)pixmap_CopyPlane,		1},
	{"ReadBitmapFile",(PyCFunction)widget_ReadBitmapFile,	1},
	{"WriteBitmapFile",(PyCFunction)pixmap_WriteBitmapFile,	1},
	{NULL,		NULL}	/* sentinel */
};

static PyObject *
pixmap_getattr(self, name)
	PyObject *self;
	char *name;
{
	return Py_FindMethod(pixmap_methods, self, name);
}

static void
pixmap_dealloc(self)
	Pixmapobject *self;
{
	if (self->owner)
		XFreePixmap(self->display, self->pixmap);
	PyMem_DEL(self);
}

PyTypeObject Pixmaptype = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,			/*ob_size*/
	"Pixmap",		/*tp_name*/
	sizeof(Pixmapobject),	/*tp_size*/
	0,			/*tp_itemsize*/
	/* methods */
	(destructor)pixmap_dealloc, /*tp_dealloc*/
	0,			/*tp_print*/
	(getattrfunc)pixmap_getattr, /*tp_getattr*/
	0,			/*tp_setattr*/
	0,			/*tp_compare*/
	0,			/*tp_repr*/
	0,			/*tp_as_number*/
	0,			/*tp_as_sequence*/
	0,			/*tp_as_mapping*/
	0,			/*tp_hash*/
};

PyObject *
PyPixmap_New(display, pixmap, owner)
	Display *display;
	Pixmap pixmap;
	int owner;
{
	Pixmapobject *p = PyObject_NEW(Pixmapobject, &Pixmaptype);
	if (p == NULL)
		return NULL;
	p->display = display;
	p->pixmap = pixmap;
	p->owner = owner;
	return (PyObject *) p;
}

Pixmap
getpixmapvalue(obj)
	PyObject *obj;
{
	if (obj && is_pixmapobject(obj))
		return ((Pixmapobject *) obj)->pixmap;
	PyErr_BadInternalCall();
	return 0;
}
