/* mrm module */

#include <string.h>

#include "Python.h"
#include "modsupport.h"
#include "import.h"
#include "mrmhierarchyobject.h"
#include "widgetobject.h"
#include "event.h"
#include "compile.h"

#include "graminit.h"
#include "node.h"

#include <Mrm/MrmPublic.h>
#include <Xm/Xm.h>

static PyObject *OpenHierarchy Py_PROTO((PyObject *self, PyObject *args));
static PyObject *FetchWidget Py_PROTO((PyObject *self, PyObject *args));
static PyObject *PyRegister Py_PROTO((PyObject *self, PyObject *args));

static void PyEval Py_PROTO((Widget widget, XtPointer client, XtPointer call));

static PyMethodDef Mrm_methods[] = {
	{"OpenHierarchy",	(PyCFunction)OpenHierarchy,	1},
	{0, 0}			/* Sentinel */
};

static PyMethodDef mrmhierarchy_methods[] = {
	{"FetchWidget",		(PyCFunction)FetchWidget,	1},
	{"PyRegister",		(PyCFunction)PyRegister,	1},
	{0, 0}			/* Sentinel */
};

static PyMethodChain mrm_methodchain = {
	mrmhierarchy_methods,
	NULL,
};


static PyObject *
OpenHierarchy(self, args)
	PyObject *self;
	PyObject *args;
{
	int i, n;
	PyObject *arg1;
	char **s;
	MrmHierarchy hid;
	Cardinal code;
	char buf[256];
	String err;
	MrmRegisterArg mrmlist = {"PyEval", (XtPointer) PyEval};

	if (!PyArg_ParseTuple(args, "O", &arg1))
		return NULL;

	/* accept either a list of file-names */
	if (PyList_Check(arg1)) {
		n = PyList_Size(arg1);
		s = PyMem_NEW(String, n+1);
		if (s == NULL) {
			PyErr_NoMemory();
			return NULL;
		}
		for (i=0; i<n; i++) {
			PyObject *item = PyList_GetItem(arg1, i);
			if (!PyString_Check(item)) {
				PyErr_SetString(PyExc_TypeError,
					"list of filenames expected (#2)");
				PyMem_DEL(s);
				return NULL;
			}
			s[i] = PyString_AsString(item);
		}
		s[n] = NULL;
	}
	/* or a single file-name */
	else if (PyString_Check(arg1)) {
		n = 1;
		s = PyMem_NEW(String, n+1);
		s[0] = PyString_AsString(arg1);
		s[1] = NULL;
	}
	else {
		PyErr_SetString(PyExc_TypeError,
				"list of filenames expected (#1)");
		return NULL;
	}

	code = MrmOpenHierarchy(n, s, NULL, &hid);
	PyMem_DEL(s);		/* XXX--is this allowed? */
	if (code != MrmSUCCESS) {
		switch (code) {
		case MrmNOT_FOUND:	err = "MrmNOT_FOUND"; break;
		case MrmFAILURE:	err = "MrmFAILURE"; break;
		default:		err = "Unknown"; break;
		}
		sprintf(buf, "MrmOpenHierarchy failed - (%d.) %s", code, err);
		PyErr_SetString(PyExc_RuntimeError, buf);
		return NULL;
	}
	MrmRegisterNamesInHierarchy(hid, &mrmlist, 1);
	return((PyObject *)newmrmhierarchyobject(hid, &mrm_methodchain));
}

static PyObject *
FetchWidget(self, args)
	PyObject *self;
	PyObject *args;
{
	String arg1;
	PyObject *arg2;
	Widget parent;
	MrmHierarchy hid;
	Widget created = NULL;
	MrmType class;
	Cardinal code;
	String err;
	char buf[256];

	if (!PyArg_ParseTuple(args, "sO!", &arg1, &Widgettype, &arg2))
		return NULL;

	/* I guess self isa mrmhierarchyobject by definition? */
	hid = getmrmhierarchyvalue(self);

	parent = getwidgetvalue(arg2);

	code = MrmFetchWidget(hid, arg1, parent, &created, &class);
	if (code != MrmSUCCESS) {
		switch (code) {
		case MrmBAD_HIERARCHY:	err = "MrmBAD_HIERARCHY"; break;
		case MrmNOT_FOUND:	err = "MrmNOT_FOUND"; break;
		case MrmFAILURE:	err = "MrmFAILURE"; break;
		default:		err = "Unknown"; break;
		}
		sprintf(buf, "MrmfetchWidgetFailed - (%d.) %s", code, err);
		PyErr_SetString(PyExc_RuntimeError, buf);
		return NULL;
	}

	return (PyObject *)newwidgetobject(created, &widget_methodchain, NULL);
}

/*
 * straight callback... client is a string to eval
 */
static void
PyEval(widget, client, call)
	Widget widget;
	XtPointer client;
	XtPointer call;
{
	/*
	 *  this works...
	 */
	PyObject *w;
	PyObject *c;
	PyObject *m;
	node *anode;
	PyObject *d;
	PyObject *v;
	PyObject *co;

	m = (PyObject *) PyImport_AddModule("__main__");
	if (m == NULL)
		return;

	d = PyModule_GetDict(m);

	/* insert __widget__ into __main__.__dict__ */
	w = (PyObject *) newwidgetobject(widget, &widget_methodchain, NULL);
	if (PyDict_SetItemString(d, "__widget__", w) != 0)
		return;

	/* insert __calldata__ into __main__.__dict__ */
	c = xev_new(call, xev_gettype(widget, NULL), 0);
	if (c == NULL || PyDict_SetItemString(d, "__calldata__", c) != 0) {
		PyDict_DelItemString(d, "__widget__");
		Py_DECREF(w);
		return;
	}

#if (0)
	PyRun_SimpleString(client);
#else

	/*  The idea is to cache the code object, hash to it off the client
	 *   pointer and only compile if you have to...rgn
	 */
	if ((co = PyDict_GetItemString(d, client)) == NULL) {
		anode = (node *) PyParser_SimpleParseString(client, file_input);    
		if (anode == NULL) goto CLEANUP;

		co = (PyObject *) PyNode_Compile(anode, "<string>");
		PyNode_Free(anode);
		if (co == NULL) goto CLEANUP;

		PyDict_SetItemString(d, client, co);
	}
	v = (PyObject *) PyEval_EvalCode(co, d, d, (PyObject *)NULL, (PyObject *)NULL);
	if (v == NULL) {
		PyErr_Print();
		goto CLEANUP;
	}
	Py_XDECREF(v);
	Py_FlushLine();
CLEANUP:
#endif

	xev_destroy(c);
	PyDict_DelItemString(d, "__widget__");
	PyDict_DelItemString(d, "__calldata__");
	Py_DECREF(w);
	Py_DECREF(c);
	return;
}

void
initMrm()
{
	PyObject *m;

	/* does this need to be done before Xt? */
	MrmInitialize();

	/* create the module and add the functions */
	(void) Py_InitModule("Mrm", Mrm_methods);

	if (PyErr_Occurred())
		Py_FatalError("can't initialize module Mrm");

	/* Xt and Xm must be imported as well */
	m = PyImport_ImportModule("Xt");
	if (m == NULL)
		Py_FatalError("can't import module Xt for Mrm");
	Py_DECREF(m);
	m = PyImport_ImportModule("Xm");
	if (m == NULL)
		Py_FatalError("can't import module Xm for Mrm");
	Py_DECREF(m);
}

static void PyGlue Py_PROTO((unsigned int, Widget, XtPointer, XtPointer));

#ifdef __STDC__
#define GlueName(N) __Py_GF##N
#else
#define GlueName(N) __Py_GF/**/N
#endif

/* stepping stone functions */
#define MakeGlueFunc(N)   \
	static void GlueName(N)(w,cl,ca) \
	Widget w; XtPointer cl; XtPointer ca; \
	{PyGlue(N,w,cl,ca);}

typedef void (*p_CBF)Py_PROTO((Widget, XtPointer, XtPointer));

typedef struct {
	p_CBF p_gluefunc; 
	PyObject *p_pyfunc;
	int argtype;
} Glue;

#define G(N) {GlueName(N), (PyObject *) NULL, 0}

#include "gluetable.h"

static void
PyGlue(N, widget, client, call)
	unsigned int N;
	Widget widget;
	XtPointer client;
	XtPointer call;
{
	PyObject *wobj;
	PyObject *clobj;
	PyObject *cbobj;
	PyObject *result;

	switch(glue[N].argtype) {
	case MrmRtypeInteger:
		clobj = (PyObject *) PyInt_FromLong(*(int *)client);
		break;
	case MrmRtypeChar8:
		clobj = (PyObject *) PyString_FromString((char *)client);
		break;
	case MrmRtypeAny:
		clobj = (PyObject *)newwidgetobject((Widget)client,
						    &widget_methodchain, NULL);
		break;
	}

	if (N < XtNumber(glue)) {
		wobj = (PyObject *)newwidgetobject(widget, &widget_methodchain,
						   NULL);
		cbobj = xev_new(call, xev_gettype(widget, NULL), 0);
		result = (PyObject *)PyEval_CallFunction(
				glue[N].p_pyfunc, "(OOO)",
				wobj, clobj, cbobj);
		if (cbobj != NULL) {
			xev_destroy(cbobj);
			Py_DECREF(cbobj);
		}
		Py_XDECREF(wobj);
		Py_XDECREF(result);
	}
	Py_XDECREF(clobj);
}

static int
alloc_slot()
{
	int i;

	for (i=0; i<XtNumber(glue); i++) {
		if (glue[i].p_pyfunc  == NULL)
			return i;
	}
	return -1;
}

static PyObject *
PyRegister(self, args)
	PyObject *self;
	PyObject *args;
{
	MrmHierarchy hid;
	MrmRegisterArg mrmlist;
	int clientargtype;
	int N;
	PyObject* obj_pyfunc;
	String str_pyfuncname;
	String str_argtype;
	PyObject *obj_name;

	str_pyfuncname = NULL;
	if (!PyArg_ParseTuple(args, "O!s|s", &PyFunction_Type, &obj_pyfunc,
			      &str_argtype, &str_pyfuncname))
		return NULL;

	if (str_pyfuncname == NULL) {
		obj_name = ((PyFunctionObject *)obj_pyfunc)->func_name;
		str_pyfuncname = PyString_AsString(obj_name);
	}

	if (strcasecmp(str_argtype, "integer") == 0) {
		/* Mrm passes a pointer to an integer */
		clientargtype = MrmRtypeInteger;
	}
	else if (strcasecmp(str_argtype, "string") == 0) {
		clientargtype = MrmRtypeChar8;
	}
	else if (strcasecmp(str_argtype, "widget") == 0) {
		clientargtype = MrmRtypeAny;
	}
	else {
		PyErr_SetString(PyExc_TypeError, "arg2 unimplemented type");
		return NULL;
	}

	N = alloc_slot();
	if (N < 0) {
		PyErr_SetString(PyExc_TypeError,
				"oops -- No More Glue Entries");
		return NULL;
	}

	hid = getmrmhierarchyvalue(self);
	mrmlist.name = str_pyfuncname;
	mrmlist.value = (XtPointer) glue[N].p_gluefunc;
	Py_INCREF(obj_pyfunc);
	glue[N].p_pyfunc = obj_pyfunc;
	glue[N].argtype = clientargtype;

	if (MrmRegisterNamesInHierarchy(hid, &mrmlist, 1) != MrmSUCCESS) {
		PyErr_SetString(PyExc_TypeError, "Not Registered");
		Py_DECREF(glue[N].p_pyfunc); /* free this slot */
		glue[N].p_pyfunc = NULL;
		return NULL;
	}
	Py_INCREF(Py_None);
	return(Py_None);
}
