# Convenience routines to create menu bars and popup menus.

import Xt
import Xm
import X
import sys
import string

def additems(menu, list):
	buttons = []
	for item in list:
		# Each item is a tuple (name, func, args).
		# Elements may be omitted at the end.
		# A non-tuple value is equivalent to a singleton.
		# Defaults:
		# - args = {}
		# - func = None (meaning it's a label, not a button)
		# - name = None (meaning it's a separator)
		name = None
		func = None
		args = {}
		if type(item) <> type(()): item = (item,)
		if item[0:]: name = item[0]
		if item[1:]: func = item[1]
		if item[2:]: args = item[2]
		if item[3:]: raise TypeError, 'at most 3 elements in tuple'
		if name is None: # Thin horizontal line
			wclass = Xm.Separator
			name = 'separator'
		elif func is None: # Menu title
			wclass = Xm.Label
		elif type(func) == type([]): # Submenu
			wclass = Xm.CascadeButton
			submenu = menu.CreatePulldownMenu(
				  name+'_submenu', {})
			subbuttons = additems(submenu, func)
			buttons = buttons + subbuttons
			args['subMenuId'] = submenu
		else: # Simple button
			wclass = Xm.PushButton
		name = splitname(name, args)
		x = menu.CreateManagedWidget(name, wclass, args)
		if wclass is Xm.PushButton:
			x.AddCallback('activateCallback', func, name)
			buttons.append(x)
	return buttons

def splitname(name, args):
	i = string.find(name, ':')
	if i >= 0:
		args['labelString'] = name[i+1:]
		name = name[:i]
	return name

def popuphandler(widget, menu, event):
	menu.MenuPosition(event)
	menu.ManageChild()

def makepopup(parent, name, list, args):
	name = splitname(name, args)
	menu = parent.CreatePopupMenu(name, args)
	parent.AddEventHandler(X.ButtonPressMask, 0, popuphandler, menu)
	buttons = additems(menu, list)
	return menu, buttons

def makebar(parent, name, barlist, args):
	name = splitname(name, args)
	bar = parent.CreateMenuBar(name, args)
	bar.ManageChild()
	buttons = []
	for name, list in barlist:
		args = {}
		name = splitname(name, args)
		menu = bar.CreatePulldownMenu(name + '_pulldown', {})
		args['subMenuId'] = menu
		button = bar.CreateManagedWidget(name, Xm.CascadeButton, args)
		subbuttons = additems(menu, list)
		buttons = buttons + subbuttons
	return bar, buttons

def makeoption(parent, name, list, args):
	name = splitname(name, args)
	menu = parent.CreatePulldownMenu(name + '_pulldown', {})
	buttons = additems(menu, list)
	args['subMenuId'] = menu
	option = parent.CreateOptionMenu(name, args)
	option.ManageChild()
	return option, buttons

def test():
	toplevel = Xt.Initialize('Test', [], sys.argv)
	pup = (len(sys.argv[1:]) == 1)
	opt = (len(sys.argv[1:]) > 1)
	#
	subsublist = ['subsubmenu:Very Long\nTitle', None,
		       ('item2c1:C1', cb), ('item2c2:C2', cb)]
	sublist = [('item2a', cb), ('item2b', cb), ('item2c', subsublist)]
	list = ['title', None, ('item1', cb), ('item2',sublist), ('item3', cb)]
	#
	if opt:
##		list = list + [('foo', cb)] * 20
		option, buttons = makeoption(toplevel, 'option', list, {})
	elif pup:
		args = {'width': 100, 'height': 100}
		form = toplevel.CreateManagedWidget('form', Xm.Form, args)
		popup, buttons = makepopup(form, 'popup', list, {})
	else:
		list = list[2:]
		bar, buttons = makebar(toplevel, 'menubar',
			  [('menu1:Menu\none', list), ('menu2', list)], {})
	#
	toplevel.RealizeWidget()
	Xt.MainLoop()

def cb(widget, name, info):
	print name
