#-----------------------------------------------------------------------
# DESCRIPTION:
#     Constant definitions for the Xm module. The definitions have been taken 
#     from the <Xm/Xm.h> file. The constants in that file have been 
#     stripped of their "Xm" prefixes.
#
# NOTE: 
#     Contains only the numerical constants defined in Xm.h. The string
#     constants (resource names) have been left out.
#
# USAGE: > import Xmd
#

# define used to denote an unspecified pixmap

UNSPECIFIED_PIXMAP     = 2

# size policy values

CHANGE_ALL             = 0
CHANGE_NONE            = 1
CHANGE_WIDTH           = 2
CHANGE_HEIGHT          = 3

#-----------------------------------------------------------------------
# unit type values 
#
PIXELS                 = 0
MILLIMETERS            = 1
INCHES                 = 2
POINTS                 = 3
FONT_UNITS             = 4

#-----------------------------------------------------------------------
# DeleteResponse values
#
DESTROY               = 0
UNMAP 	              = 1
DO_NOTHING            = 2

EXPLICIT = 0 
POINTER  = 1 

#-----------------------------------------------------------------------
# Navigation defines
#
NONE                = 0
TAB_GROUP           = 1
STICKY_TAB_GROUP    = 2
EXCLUSIVE_TAB_GROUP = 3
DYNAMIC_DEFAULT_TAB_GROUP = 255

#-----------------------------------------------------------------------
# Audible warning
#
NONE = 0
BELL = 1

#-----------------------------------------------------------------------
# Menu defines
#
NO_ORIENTATION         = 0
VERTICAL               = 1
HORIZONTAL             = 2

WORK_AREA              = 0
MENU_BAR               = 1
MENU_PULLDOWN          = 2
MENU_POPUP             = 3
MENU_OPTION            = 4

NO_PACKING             = 0
PACK_TIGHT             = 1
PACK_COLUMN            = 2
PACK_NONE              = 3

ALIGNMENT_CONTENTS_TOP    = 3
ALIGNMENT_CONTENTS_BOTTOM = 4

TEAR_OFF_ENABLED       = 0
TEAR_OFF_DISABLED      = 1

UNPOST                 = 0
UNPOST_AND_REPLAY      = 1

LAST_POSITION          = -1
FIRST_POSITION         = 0

#-----------------------------------------------------------------------
# Label/Frame defines
#
ALIGNMENT_BEGINNING    = 0
ALIGNMENT_CENTER       = 1
ALIGNMENT_END          = 2

ALIGNMENT_BASELINE_TOP    = 0
ALIGNMENT_BASELINE_BOTTOM = 2
ALIGNMENT_WIDGET_TOP      = 3
ALIGNMENT_WIDGET_BOTTOM   = 4

#-----------------------------------------------------------------------
# Frame defines
#
FRAME_GENERIC_CHILD  = 0
FRAME_WORKAREA_CHILD = 1
FRAME_TITLE_CHILD    = 2

#-----------------------------------------------------------------------
# ToggleButton  defines
#
N_OF_MANY              = 1
ONE_OF_MANY            = 2

#-----------------------------------------------------------------------
# Form defines  
#
ATTACH_NONE            = 0
ATTACH_FORM            = 1
ATTACH_OPPOSITE_FORM   = 2
ATTACH_WIDGET          = 3
ATTACH_OPPOSITE_WIDGET = 4
ATTACH_POSITION        = 5
ATTACH_SELF            = 6

RESIZE_NONE            = 0
RESIZE_GROW            = 1
RESIZE_ANY             = 2      #  for BulletinBoard, DrawingArea  

#-----------------------------------------------------------------------
# Callback reasons:
#
CR_NONE                      = 0
CR_HELP                      = 1
CR_VALUE_CHANGED             = 2
CR_INCREMENT                 = 3
CR_DECREMENT                 = 4
CR_PAGE_INCREMENT            = 5
CR_PAGE_DECREMENT            = 6
CR_TO_TOP                    = 7
CR_TO_BOTTOM                 = 8
CR_DRAG                      = 9
CR_ACTIVATE                  = 10
CR_ARM                       = 11
CR_DISARM                    = 12
CR_MAP                       = 16
CR_UNMAP                     = 17
CR_FOCUS                     = 18
CR_LOSING_FOCUS              = 19
CR_MODIFYING_TEXT_VALUE      = 20
CR_MOVING_INSERT_CURSOR      = 21
CR_EXECUTE                   = 22
CR_SINGLE_SELECT             = 23
CR_MULTIPLE_SELECT           = 24
CR_EXTENDED_SELECT           = 25
CR_BROWSE_SELECT             = 26
CR_DEFAULT_ACTION            = 27
CR_CLIPBOARD_DATA_REQUEST    = 28
CR_CLIPBOARD_DATA_DELETE     = 29
CR_CASCADING                 = 30
CR_OK                        = 31
CR_CANCEL                    = 32
CR_APPLY                     = 34
CR_NO_MATCH                  = 35
CR_COMMAND_ENTERED           = 36
CR_COMMAND_CHANGED           = 37
CR_EXPOSE                    = 38
CR_RESIZE                    = 39
CR_INPUT                     = 40
CR_GAIN_PRIMARY              = 41
CR_LOSE_PRIMARY              = 42
CR_CREATE                    = 43
CR_TEAR_OFF_ACTIVATE         = 44
CR_TEAR_OFF_DEACTIVATE       = 45
CR_OBSCURED_TRAVERSAL        = 46
CR_PROTOCOLS                 = 47

#-----------------------------------------------------------------------
# PushButton defines
#
MULTICLICK_DISCARD = 1
MULTICLICK_KEEP    = 0

#-----------------------------------------------------------------------
# DrawnButton defines
#
SHADOW_IN            = 7
SHADOW_OUT           = 8

#-----------------------------------------------------------------------
# Arrow defines
#
ARROW_UP             = 0
ARROW_DOWN           = 1
ARROW_LEFT           = 2
ARROW_RIGHT          = 3

#-----------------------------------------------------------------------
# Separator defines
#
NO_LINE                = 0
SINGLE_LINE            = 1
DOUBLE_LINE            = 2
SINGLE_DASHED_LINE     = 3
DOUBLE_DASHED_LINE     = 4
SHADOW_ETCHED_IN       = 5
SHADOW_ETCHED_OUT      = 6
INVALID_SEPARATOR_TYPE = 7

PIXMAP               = 1
STRING               = 2

#-----------------------------------------------------------------------
# Drag and Drop defines
#
WINDOW = 0
CURSOR = 2

#-----------------------------------------------------------------------
# ScrollBar defines
#
MAX_ON_TOP        = 0
MAX_ON_BOTTOM     = 1
MAX_ON_LEFT       = 2
MAX_ON_RIGHT      = 3

#-----------------------------------------------------------------------
# List Widget defines
#
SINGLE_SELECT     = 0
MULTIPLE_SELECT   = 1
EXTENDED_SELECT   = 2
BROWSE_SELECT     = 3

STATIC            = 0
DYNAMIC           = 1

#-----------------------------------------------------------------------
# Scrolled Window defines.                                             
#                                                                     
VARIABLE             = 0
CONSTANT             = 1
RESIZE_IF_POSSIBLE   = 2

AUTOMATIC            = 0
APPLICATION_DEFINED  = 1

AS_NEEDED            = 1

SW_TOP               = 1
SW_BOTTOM            = 0
SW_LEFT              = 2
SW_RIGHT             = 0

TOP_LEFT             = (SW_TOP | SW_LEFT)
BOTTOM_LEFT          = (SW_BOTTOM  | SW_LEFT)
TOP_RIGHT            = (SW_TOP | SW_RIGHT)
BOTTOM_RIGHT         = (SW_BOTTOM  | SW_RIGHT)

#-----------------------------------------------------------------------
# MainWindow Resources
#
COMMAND_ABOVE_WORKSPACE = 0
COMMAND_BELOW_WORKSPACE = 1

#-----------------------------------------------------------------------
# Text Widget defines                                                  
#
MULTI_LINE_EDIT              = 0
SINGLE_LINE_EDIT             = 1

TEXT_FORWARD  = 0
TEXT_BACKWARD = 1

SELECT_POSITION              = 0
SELECT_WHITESPACE            = 1
SELECT_WORD                  = 2
SELECT_LINE                  = 3
SELECT_ALL                   = 4
SELECT_PARAGRAPH             = 5

HIGHLIGHT_NORMAL             = 0
HIGHLIGHT_SELECTED           = 1
HIGHLIGHT_SECONDARY_SELECTED = 2

#-----------------------------------------------------------------------
# DIALOG defines..  BulletinBoard and things common to its subclasses 
#         CommandBox    MessageBox    Selection    FileSelection      
#                                                                     

# child type defines for Xm...GetChild() 

DIALOG_NONE             = 0       # a valid default button type 
DIALOG_APPLY_BUTTON     = 1
DIALOG_CANCEL_BUTTON    = 2
DIALOG_DEFAULT_BUTTON   = 3
DIALOG_OK_BUTTON        = 4
DIALOG_FILTER_LABEL     = 5
DIALOG_FILTER_TEXT      = 6
DIALOG_HELP_BUTTON      = 7
DIALOG_LIST             = 8
DIALOG_HISTORY_LIST     = DIALOG_LIST
DIALOG_LIST_LABEL       = 9
DIALOG_MESSAGE_LABEL    = 10
DIALOG_SELECTION_LABEL  = 11
DIALOG_PROMPT_LABEL     = DIALOG_SELECTION_LABEL
DIALOG_SYMBOL_LABEL     = 12
DIALOG_TEXT             = 13
DIALOG_VALUE_TEXT       = DIALOG_TEXT
DIALOG_COMMAND_TEXT     = DIALOG_TEXT
DIALOG_SEPARATOR        = 14
DIALOG_DIR_LIST         = 15
DIALOG_DIR_LIST_LABEL   = 16
DIALOG_FILE_LIST        = DIALOG_LIST
DIALOG_FILE_LIST_LABEL  = DIALOG_LIST_LABEL

# dialog style defines  

DIALOG_MODELESS                  = 0
DIALOG_PRIMARY_APPLICATION_MODAL = 1
DIALOG_FULL_APPLICATION_MODAL    = 2
DIALOG_SYSTEM_MODAL              = 3
DIALOG_APPLICATION_MODAL = DIALOG_PRIMARY_APPLICATION_MODAL

#-----------------------------------------------------------------------
# XmSelectionBox, XmFileSelectionBox and XmCommand - misc. stuff       
#

# Defines for Selection child placement

PLACE_TOP             = 0
PLACE_ABOVE_SELECTION = 1
PLACE_BELOW_SELECTION = 2

# Defines for file type mask:

FILE_DIRECTORY        = (1 << 0)
FILE_REGULAR          = (1 << 1)
FILE_ANY_TYPE         = (FILE_DIRECTORY | FILE_REGULAR)

# Defines for selection dialog type:

DIALOG_WORK_AREA      = 0
DIALOG_PROMPT         = 1
DIALOG_SELECTION      = 2
DIALOG_COMMAND        = 3
DIALOG_FILE_SELECTION = 4

#-----------------------------------------------------------------------
# XmMessageBox           stuff not common to other dialogs            
#

# defines for dialog type 

DIALOG_TEMPLATE        = 0
DIALOG_ERROR           = 1
DIALOG_INFORMATION     = 2
DIALOG_MESSAGE         = 3
DIALOG_QUESTION        = 4
DIALOG_WARNING         = 5
DIALOG_WORKING         = 6

# Traversal types

VISIBILITY_UNOBSCURED         = 0
VISIBILITY_PARTIALLY_OBSCURED = 1
VISIBILITY_FULLY_OBSCURED     = 2

TRAVERSE_CURRENT           = 0
TRAVERSE_NEXT              = 1
TRAVERSE_PREV              = 2
TRAVERSE_HOME              = 3
TRAVERSE_NEXT_TAB_GROUP    = 4
TRAVERSE_PREV_TAB_GROUP    = 5
TRAVERSE_UP                = 6
TRAVERSE_DOWN              = 7
TRAVERSE_LEFT              = 8
TRAVERSE_RIGHT             = 9

#-----------------------------------------------------------------------
# SimpleMenu declarations and definitions.
#
PUSHBUTTON            = 1
TOGGLEBUTTON          = 2
CHECKBUTTON           = TOGGLEBUTTON
RADIOBUTTON           = 3
CASCADEBUTTON         = 4
SEPARATOR             = 5
DOUBLE_SEPARATOR      = 6
TITLE                 = 7

#-----------------------------------------------------------------------
# Drag/Drop defines
#
HELP = 2
TOP_LEVEL_ENTER   = 0
TOP_LEVEL_LEAVE   = 1
DRAG_MOTION       = 2
DROP_SITE_ENTER   = 3
DROP_SITE_LEAVE   = 4
DROP_START        = 5
DROP_FINISH       = 6
DRAG_DROP_FINISH  = 7
OPERATION_CHANGED = 8
DROP           = 0
DROP_HELP      = 1
DROP_CANCEL    = 2
DROP_INTERRUPT = 3
DROP_NOOP	= 0
DROP_MOVE 	= (1 << 0)
DROP_COPY	= (1 << 1)
DROP_LINK	= (1 << 2)
BLEND_ALL          = 0
BLEND_STATE_SOURCE = 1
BLEND_JUST_SOURCE  = 2
BLEND_NONE         = 3
DROP_FAILURE = 0
DROP_SUCCESS = 1
CR_TOP_LEVEL_ENTER   = 0
CR_TOP_LEVEL_LEAVE   = 1
CR_DRAG_MOTION       = 2
CR_DROP_SITE_ENTER   = 3
CR_DROP_SITE_LEAVE   = 4
CR_DROP_START        = 5
CR_DROP_FINISH       = 6
CR_DRAG_DROP_FINISH  = 7
CR_OPERATION_CHANGED = 8
ATTACH_NORTH_WEST = 0
ATTACH_NORTH      = 1
ATTACH_NORTH_EAST = 2
ATTACH_EAST       = 3
ATTACH_SOUTH_EAST = 4
ATTACH_SOUTH      = 5
ATTACH_SOUTH_WEST = 6
ATTACH_WEST       = 7
ATTACH_CENTER     = 8
ATTACH_HOT        = 9
TRANSFER_FAILURE = 0
TRANSFER_SUCCESS = 1
CR_DROP_SITE_LEAVE_MESSAGE  = 1
CR_DROP_SITE_ENTER_MESSAGE  = 2
CR_DROP_SITE_MOTION_MESSAGE = 3
CR_DROP_MESSAGE             = 4
NO_DROP_SITE 		= 1
INVALID_DROP_SITE	= 2
VALID_DROP_SITE		= 3
DROP_SITE_INVALID = INVALID_DROP_SITE
DROP_SITE_VALID = VALID_DROP_SITE
DRAG_UNDER_NONE       = 0
DRAG_UNDER_PIXMAP     = 1
DRAG_UNDER_SHADOW_IN  = 2
DRAG_UNDER_SHADOW_OUT = 3
DRAG_UNDER_HIGHLIGHT  = 4
DROP_SITE_SIMPLE              = 0
DROP_SITE_COMPOSITE           = 1
DROP_SITE_SIMPLE_CLIP_ONLY    = 128
DROP_SITE_COMPOSITE_CLIP_ONLY = 129
ABOVE = 0
BELOW = 1
DROP_SITE_ACTIVE   = 0
DROP_SITE_INACTIVE = 1
DRAG_NONE = 0
DRAG_DROP_ONLY = 1
DRAG_PREFER_PREREGISTER = 2
DRAG_PREREGISTER = 3
DRAG_PREFER_DYNAMIC = 4
DRAG_DYNAMIC = 5
DRAG_PREFER_RECEIVER = 6
