/* Widget Set HTML */

#include "Python.h"
#include "modsupport.h"
#include "import.h"
#include "widgetobject.h"

#define is_optwidgetobject(x)	((x) == Py_None || is_widgetobject(x))
#define getoptwidgetvalue(x)	((x) == Py_None ? NULL : getwidgetvalue(x))


/* Methods for HTML objects */

#include "HTML.h"

#include "HTMLmanual.h"
static PyMethodDef HTML_methods[] = {
	{0, 0} /* Sentinel */
};


/* Methods for widget objects */

static PyObject *
widget_PositionToId(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	int arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "ii",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = HTMLPositionToId(self->ob_widget,
			arg1,
			arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
widget_IdToPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	int arg1;
	int arg2;
	int arg3;
	PyObject *retval;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = HTMLIdToPosition(self->ob_widget,
			arg1,
			&arg2,
			&arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	retval = PyTuple_New(3);
	PyTuple_SetItem(retval, 0, PyInt_FromLong((long)result));
	PyTuple_SetItem(retval, 1, PyInt_FromLong((long)arg2));
	PyTuple_SetItem(retval, 2, PyInt_FromLong((long)arg3));
	if (PyErr_Occurred()) {
		Py_XDECREF(retval);
		return NULL;
	}
	return retval;
}

static PyObject *
widget_AnchorToPosition(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	char *arg1;
	int arg2;
	int arg3;
	PyObject *retval;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = HTMLAnchorToPosition(self->ob_widget,
			arg1,
			&arg2,
			&arg3);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	retval = PyTuple_New(3);
	PyTuple_SetItem(retval, 0, PyInt_FromLong((long)result));
	PyTuple_SetItem(retval, 1, PyInt_FromLong((long)arg2));
	PyTuple_SetItem(retval, 2, PyInt_FromLong((long)arg3));
	if (PyErr_Occurred()) {
		Py_XDECREF(retval);
		return NULL;
	}
	return retval;
}

static PyObject *
widget_AnchorToId(self, args)
	widgetobject *self;
	PyObject *args;
{
	int result;
	char *arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = HTMLAnchorToId(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
widget_ClearSelection(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		HTMLClearSelection(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_FreeImageInfo(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		HTMLFreeImageInfo(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_GotoId(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		HTMLGotoId(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4
static PyObject *
widget_TraverseTabGroups(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		HTMLTraverseTabGroups(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4 */
#if MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4
static PyObject *
widget_DrawBackgroundImage(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	int arg3;
	int arg4;
	if (!PyArg_ParseTuple(args, "iiii",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		HTMLDrawBackgroundImage(self->ob_widget,
			arg1,
			arg2,
			arg3,
			arg4);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4 */
#if MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4
static PyObject *
widget_SetAppInsensitive(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		HTMLSetAppInsensitive(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4 */
#if MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4
static PyObject *
widget_SetAppSensitive(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		HTMLSetAppSensitive(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4 */
static PyMethodDef HTMLw_methods[] = {
	{"AnchorToId", (PyCFunction)widget_AnchorToId, 1},
	{"AnchorToPosition", (PyCFunction)widget_AnchorToPosition, 1},
	{"ClearSelection", (PyCFunction)widget_ClearSelection, 1},
#if MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4
	{"DrawBackgroundImage", (PyCFunction)widget_DrawBackgroundImage, 1},
#endif /* MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4 */
	{"FreeImageInfo", (PyCFunction)widget_FreeImageInfo, 1},
	{"GetActions", (PyCFunction)widget_GetActions, 1},
	{"GetHRefs", (PyCFunction)widget_GetHRefs, 1},
	{"GetImageSrcs", (PyCFunction)widget_GetImageSrcs, 1},
	{"GetLinks", (PyCFunction)widget_GetLinks, 1},
	{"GetText", (PyCFunction)widget_GetText, 1},
	{"GetTextAndSelection", (PyCFunction)widget_GetTextAndSelection, 1},
	{"GotoId", (PyCFunction)widget_GotoId, 1},
	{"IdToPosition", (PyCFunction)widget_IdToPosition, 1},
	{"PositionToId", (PyCFunction)widget_PositionToId, 1},
	{"SearchText", (PyCFunction)widget_SearchText, 1},
#if MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4
	{"SetAppInsensitive", (PyCFunction)widget_SetAppInsensitive, 1},
#endif /* MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4 */
#if MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4
	{"SetAppSensitive", (PyCFunction)widget_SetAppSensitive, 1},
#endif /* MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4 */
	{"SetSelection", (PyCFunction)widget_SetSelection, 1},
	{"SetText", (PyCFunction)widget_SetText, 1},
#if MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4
	{"TraverseTabGroups", (PyCFunction)widget_TraverseTabGroups, 1},
#endif /* MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4 */
	{0, 0} /* Sentinel */
};


/* Methods for HTMLwc objects */

static PyMethodDef HTMLwc_methods[] = {
	{0, 0} /* Sentinel */
};


PyMethodChain HTMLw_methodchain = {
	HTMLw_methods,
	NULL,
};
PyMethodChain HTMLwc_methodchain = {
	HTMLwc_methods,
	&wclass_methodchain,
};

void
initHTML()
{
	PyObject *m, *d;
	m = PyImport_ImportModule("Xt");
	if (m == NULL)
		Py_FatalError("can't import module Xt for HTML");
	Py_DECREF(m);
	m = Py_InitModule("HTML", HTML_methods);
	d = PyModule_GetDict(m);
	add_widget_methodchain(&HTMLw_methodchain);
	PyDict_SetItemString(d, "html",
		(PyObject*)newwclassobject(htmlWidgetClass,
			&HTMLwc_methodchain));
	inithtmlsupport();
}
