/* Manually written functions for HTML */

#ifndef MOSAIC_VERSION
#ifdef AT_SUBJECT
#ifdef MT_FRAME
#define MOSAIC_VERSION		27
#else
#define MOSAIC_VERSION		26
#endif
#endif
#endif

/* distinguish between beta versions */
#if MOSAIC_VERSION == 27
#ifndef MOSAIC_BETA_VERSION
#ifdef MT_FRAME
#define MOSAIC_BETA_VERSION	4
#else
#define MOSAIC_BETA_VERSION	2
#endif
#endif
#endif

#if 0
/* Template */
static PyObject *
widget_$$(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		HTML$$(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}
#endif

static PyObject *
do_get(self, args, func)
	widgetobject *self;
	PyObject *args;
	char **(*func)Py_PROTO((Widget, int *));
{
	char **harray;
	int count;
	PyObject *list;
	int i;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		harray = (*func)(self->ob_widget, &count);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	list = PyList_New(count);
	for (i = 0; i < count && list != NULL; i++) {
		PyObject *item = PyString_FromString(harray[i]);
		if (item == NULL) {
			Py_DECREF(list);
			list = NULL;
		}
		else
			PyList_SetItem(list, i, item);
	}
	return list;
}

static PyObject *
widget_GetHRefs(self, args)
	widgetobject *self;
	PyObject *args;
{
	return do_get(self, args, HTMLGetHRefs);
}

#ifdef HAVE_HTMLGETACTIONS
/* patched version of HTML widgets has this function */
static PyObject *
widget_GetActions(self, args)
	widgetobject *self;
	PyObject *args;
{
	return do_get(self, args, HTMLGetActions);
}
#endif

static PyObject *
widget_GetImageSrcs(self, args)
	widgetobject *self;
	PyObject *args;
{
	return do_get(self, args, HTMLGetImageSrcs);
}

static PyObject *
widget_GetLinks(self, args)
	widgetobject *self;
	PyObject *args;
{
	LinkInfo *larray;
	int count;
	PyObject *list;
	int i;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		larray = HTMLGetLinks(self->ob_widget, &count);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	list = PyList_New(count);
	for (i = 0; i < count && list != NULL; i++) {
		PyObject *tuple = PyTuple_New(2);
		PyObject *item;
		if (tuple == NULL) {
			Py_DECREF(list);
			list = NULL;
			break;
		}
		if (larray[i].href)
			item = PyString_FromString(larray[i].href);
		else {
			item = Py_None;
			Py_INCREF(Py_None);
		}
		PyTuple_SetItem(tuple, 0, item);
		if (larray[i].role)
			item = PyString_FromString(larray[i].role);
		else {
			item = Py_None;
			Py_INCREF(Py_None);
		}
		PyTuple_SetItem(tuple, 1, item);
		PyList_SetItem(list, i, tuple);
		if (PyErr_Occurred()) {
			Py_DECREF(list);
			list = NULL;
			break;
		}
	}
	for (i = 0; i < count; i++) {
		if (larray[i].href)
			free(larray[i].href);
		if (larray[i].role)
			free(larray[i].role);
	}
	if (larray)
		free(larray);
	return list;
}

static PyObject *
widget_SetSelection(self, args)
	widgetobject *self;
	PyObject *args;
{
	ElementRef start, end;
	if (!PyArg_ParseTuple(args, "(ii)(ii)",
		     &start.id, &start.pos, &end.id, &end.pos))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		HTMLSetSelection(self->ob_widget, &start, &end);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_SearchText(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg3;
	char *pattern;
	int backward, caseless, page;
	ElementRef start, end;
	if (!PyArg_ParseTuple(args, "sOii",
		     &pattern, &arg3, &backward, &caseless))
		return NULL;
	start.id = start.pos = end.id = end.pos = 0;
	if (arg3 != Py_None) {
		if (!PyArg_ParseTuple(arg3,
			     "ii;start position must be None or (int, int)",
			     &start.id, &start.pos))
			return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		page = HTMLSearchText(self->ob_widget,
				      pattern, &start, &end,
				      backward, caseless);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	return Py_BuildValue("(i(ii)(ii))",
		       page, start.id, start.pos, end.id, end.pos);
}

static PyObject *
widget_SetText(self, args)
	widgetobject *self;
	PyObject *args;
{
	char *arg1;
	char *arg2;
	char *arg3;
	int arg4 = 0;
	char *arg5 = NULL;
	if (!PyArg_ParseTuple(args, "zzz|iz",
			&arg1,
			&arg2,
			&arg3,
			&arg4,
			&arg5))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		HTMLSetText(self->ob_widget,
			arg1,
			arg2,
			arg3,
			arg4,
			arg5,
			0);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_GetText(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *result;
	char* ret;
	int arg1;
#if MOSAIC_VERSION >= 26
	char *arg2 = NULL;
#if MOSAIC_VERSION >= 27	/* Mosaic 2.7 or later */
	char *arg3 = NULL;
	if (!PyArg_ParseTuple(args, "i|ss", &arg1, &arg2, &arg3))
		return NULL;
#else  /* Mosaic 2.6 */
	if (!PyArg_ParseTuple(args, "i|s", &arg1, &arg2))
		return NULL;
#endif
#else  /* Mosaic 2.5 or before */
	if (!PyArg_ParseTuple(args, "i", &arg1))
		return NULL;
#endif
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		ret = HTMLGetText(self->ob_widget, arg1
#if MOSAIC_VERSION >= 26
				  , arg2
#if MOSAIC_VERSION >= 27
				  , arg3
#endif
#endif
				  );
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	result = PyString_FromString(ret);
	free(ret);
	return result;
}

static PyObject *
widget_GetTextAndSelection(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *result;
	char *ret0, *ret1, *ret2, *ret3;
	int off1, off2, off3;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		ret0 = HTMLGetTextAndSelection(self->ob_widget,
					       &ret1, &ret2, &ret3);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	if (ret0 == NULL)
		return PyErr_NoMemory();
	off1 = off2 = off3 = -1;
	if (ret1)
		off1 = ret1-ret0;
	if (ret2)
		off2 = ret2-ret0;
	if (ret3)
		off3 = ret3-ret0;
	result = Py_BuildValue("(siii)", ret0, off1, off2, off3);
	free(ret0);
	return result;
}

#include "Pixmapobject.h"

static struct htmlimage {
	ImageInfo *image;
	PyObject *object;
	Widget widget;
	struct htmlimage *next;
} *htmlimages;

static ImageInfo *
do_resolveImage(resource, w, edata, noload)
	const char *resource;
	Widget w;
	char *edata;
	int noload;
{
	widgetobject *wobj = NULL;
	PyObject *args = NULL, *func, *result = NULL;
	PyObject *obj;
	PyObject *imobj = NULL;
	ImageInfo *im = NULL;
	short *colors;
	int i;

	wobj = newwidgetobject(w, &widget_methodchain, NULL);
	if (wobj == NULL)
		goto done;
	if (strcmp(resource, WbNresolveImageFunction) == 0)
		args = Py_BuildValue("(Osi)", (PyObject *) wobj, edata, noload);
	else
		args = Py_BuildValue("(Os)", (PyObject *) wobj, edata);
	if (args == NULL)
		goto done;
	func = PyDict_GetItemString(wobj->ob_resdict, (char *) resource);
	Py_DECREF(wobj);
	wobj = NULL;
	if (func == NULL)
		goto done;
	result = call_object_save_jump(resource, func, args);
	Py_DECREF(args);
	args = NULL;
	if (result == Py_None) {
		Py_DECREF(result);
		return NULL;
	}

	if (result == NULL)
		goto done;
	im = malloc(sizeof(ImageInfo));
	if (im == NULL) {
		PyErr_NoMemory();
		goto done;
	}
	im->ismap = im->internal = im->delayed = im->fetched = 0;
	im->fptr = NULL;
	im->text = NULL;
	im->image_data = NULL;
	im->image = NULL;
	im->reds = im->greens = im->blues = NULL;
#if MOSAIC_VERSION == 27 && MOSAIC_BETA_VERSION >= 4
	im->clip_data = NULL;
	im->transparent = 0;
	im->clip = None;
	im->src = NULL;
#endif
	obj = PyDict_GetItemString(result, "width");
	im->width = PyInt_AsLong(obj);
	obj = PyDict_GetItemString(result, "height");
	im->height = PyInt_AsLong(obj);
	if (PyErr_Occurred())
		goto done;
#if 0
	obj = PyDict_GetItemString(result, "image");
	if (obj != NULL) {
		if (!is_pixmapobject(obj)) {
			PyErr_SetString(PyExc_TypeError, "image not a pixmap");
			goto done;
		}
		imobj = obj;
		im->image = getpixmapvalue(obj);
		im->internal = 1;
		goto done;
	}
#endif
	obj = PyDict_GetItemString(result, "image_data");
	if (obj == NULL) {
		PyErr_SetString(PyExc_TypeError, "no image_data specified");
		goto done;
	}
	if (!PyString_Check(obj)) {
		PyErr_SetString(PyExc_TypeError, "image_data not a string");
		goto done;
	}
	im->image_data = (unsigned char *) PyString_AsString(obj);
	imobj = obj;
	obj = PyDict_GetItemString(result, "colors");
	if (checkshortlist(3, obj, &colors, &im->num_colors) == 0)
		goto done;
	im->reds = malloc(sizeof(int) * im->num_colors);
	im->greens = malloc(sizeof(int) * im->num_colors);
	im->blues = malloc(sizeof(int) * im->num_colors);
	if (im->reds == NULL || im->greens == NULL || im->blues == NULL) {
		PyErr_NoMemory();
		goto done;
	}
	for (i = im->num_colors - 1; i >= 0; i--) {
		im->reds[i] = colors[i*3]<<8;
		im->greens[i] = colors[i*3 + 1]<<8;
		im->blues[i] = colors[i*3 + 2]<<8;
	}
	free(colors);

done:
	Py_XDECREF(wobj);
	Py_XDECREF(args);
	Py_XDECREF(result);
	if (PyErr_Occurred() || im == NULL) {
		if (im != NULL) {
			if (im->reds != NULL) free(im->reds);
			if (im->greens != NULL) free(im->greens);
			if (im->blues != NULL) free(im->blues);
			free(im);
			im = NULL;
		}
		if (!jump_flag) {
			fprintf(stderr, "--- callback failed ---\n");
			PyErr_Print();
			fprintf(stderr, "---\n");
		}
	}
	if (im != NULL) {
		struct htmlimage *hi = malloc(sizeof(struct htmlimage));
		if (hi != NULL) {
			hi->image = im;
			hi->widget = w;
			hi->next = htmlimages;
			Py_INCREF(imobj);
			hi->object = imobj;
			htmlimages = hi;
		}
	}
	return im;
}

static ImageInfo *
resolveImage(w, edata, noload)
	Widget w;
	char *edata;
	int noload;
{
	return do_resolveImage(WbNresolveImageFunction, w, edata, noload);
}

static ImageInfo *
resolveDelayedImage(w, edata)
	Widget w;
	char *edata;
{
	return do_resolveImage(WbNresolveDelayedImage, w, edata, 0);
}

static void
html_destroy(w, closure, call_data)
	Widget w;
	XtPointer closure;
	XtPointer call_data;
{
	struct htmlimage *hi, *hi2, *hiprev = NULL;
	ImageInfo *im;
	jmp_buf save_jump_where;
	int save_jump_flag;

	HTMLFreeImageInfo(w);
	/* we must save jump_flag and jump_where because __del__ methods
	   may be called from Py_XDECREF which in turn may call functions
	   in the X extensions. */
	save_jump_flag = jump_flag;
	jump_flag = 0;
	if (save_jump_flag)
		memcpy((char *)save_jump_where,
		       (char *)jump_where, sizeof(save_jump_where));

	hi = htmlimages;
	while (hi != NULL) {
		if (hi->widget == w) {
			im = hi->image;
			Py_XDECREF(hi->object);
			if (im->reds) free(im->reds);
			if (im->greens) free(im->greens);
			if (im->blues) free(im->blues);
			im->reds = im->greens = im->blues = NULL;
			im->image_data = NULL;
			im->image = NULL;
			im->width = im->height = im->num_colors = 0;
			free(im);
			hi->image = NULL;
			if (hiprev)
				hiprev->next = hi->next;
			else
				htmlimages = hi->next;
			hi2 = hi->next;
			free(hi);
			hi = hi2;
		} else {
			hiprev = hi;
			hi = hi->next;
		}
	}

	if (closure == NULL && save_jump_flag)
		memcpy((char *)jump_where,
		       (char *)save_jump_where, sizeof(jump_where));
	jump_flag = save_jump_flag;
}

static void
inithtmlsupport()
{
	htmlev_init();
	register_callable(WbNresolveImageFunction, htmlWidgetClass,
			  (XtArgVal) resolveImage);
	register_callable(WbNresolveDelayedImage, htmlWidgetClass,
			  (XtArgVal) resolveDelayedImage);
}
