/***********************************************************
Copyright 1991, 1992, 1993 by Stichting Mathematisch Centrum,
Amsterdam, The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* Support routines for module Glx */

#include "Python.h"
#include "modsupport.h"
#include "widgetobject.h"
#include "Xttypes.h"
#include "Glxsupport.h"
#include <X11/Xirisw/GlxDraw.h>

/* XXX Currently my python-to-Xt conversion code is not smart enough
   to be able to convert a list of triples of integers into a
   null-terminated array of GLXconfig structures, so for now you'll
   have to do the something like following:
   widget = parent.CreateManagedWidget('glx', Glx.Draw,
	{'glxConfig': Glx.makeconfig([
				      (GLX.NORMAL, GLX.RGB, 1),
				      (GLX.NORMAL, GLX.DOUBLE, 1),
				     ])})
   Note that the glxConfig resource can't be changed once the widget
   has been created!

   WARNING: Glx.makeconfig returns an integer that is really the
   address of a null-terminated array of GLXconfig structures.  It
   allocates space for the array on the heap and deallocates it when
   it is called again, so don't save and reuse the value!
*/

static PyObject *
glxconfig2list(conf)
	GLXconfig *conf;
{
	int i;
	PyObject *list,*item;
	list = PyList_New(0);
	if (list == NULL)
		return NULL;
	for (i = 0; ; i++) {
		if (conf[i].buffer == 0)
			break;
		item = Py_BuildValue("(iii)",
				    conf[i].buffer,
				    conf[i].mode,
				    conf[i].arg);
		if (item == NULL) {
			Py_DECREF(list);
			return NULL;
		}
		if (PyList_Append(list, item) != 0) {
			Py_DECREF(item);
			Py_DECREF(list);
			return NULL;
		}
		Py_DECREF(item);
	}
	return list;
}

PyObject *
Glx_winset(self, args)
	PyObject *self;
	PyObject *args;
{
	widgetobject *wp;
	int err;
	if (!PyArg_ParseTuple(args, "O!", &Widgettype, &wp))
		return NULL;
	if (wp->ob_widget == NULL) {
		PyErr_SetString(PyExc_RuntimeError, "widget already destroyed");
		return NULL;
	}
	if (XtClass(wp->ob_widget) != glxDrawWidgetClass) {
		/* XXX should really check for subclass */
		PyErr_SetString(PyExc_TypeError,
			   "Glx.winset arg must be Glx.Draw widget");
		return NULL;
	}
	err = GLXwinset(XtDisplay(wp->ob_widget), XtWindow(wp->ob_widget));
	if (err < 0) {
		char buf[100];
		sprintf(buf, "Glx.winset error code %d", err);
		PyErr_SetString(Xt_Error, buf);
		return NULL;
	}
	Py_INCREF(Py_None);
	return Py_None;
}

PyObject *
Glx_makeconfig(self, args)
	PyObject *self;
	PyObject *args;
{
	PyObject *list;
	static GLXconfig *conf = 0;
	int i, n;
	if (!PyArg_ParseTuple(args,
			"O!;Glx.makeconfig arg must be list of config triples",
			&PyList_Type, &list))
		return NULL;
	n = PyList_Size(list);
	if (conf != NULL)
		PyMem_DEL(conf);
	conf = PyMem_NEW(GLXconfig, n+1);
	if (conf == NULL) {
		PyErr_NoMemory();
		return NULL;
	}
	for (i = 0; i < n; i++) {
		if (!PyArg_ParseTuple(PyList_GetItem(list, i),
			     "iii;each config triple must be three integers",
			     &conf[i].buffer,
			     &conf[i].mode,
			     &conf[i].arg)) {
			PyMem_DEL(conf);
			return NULL;
		}
	}
	conf[i].buffer = conf[i].mode = conf[i].arg = 0;
	return PyInt_FromLong((long)conf);
}

static PyObject *
glxconverter(self, xtvalue)
	widgetobject *self;
	XrmValue *xtvalue;
{
	return glxconfig2list(*(GLXconfig**)xtvalue->addr);
}

void
initglxsupport()
{
	x2pregister("GlxConfig", glxconverter);
}
