
/* Methods for PyGC objects */

static PyObject *
PyGC_DrawArc(self, args)
	GCobject *self;
	PyObject *args;
{
	Position arg1;
	Position arg2;
	Dimension arg3;
	Dimension arg4;
	int arg5;
	int arg6;
	if (!PyArg_ParseTuple(args, "hhhhii",
			&arg1,
			&arg2,
			&arg3,
			&arg4,
			&arg5,
			&arg6))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XDrawArc(self->gc_display, self->gc_drawable, self->gc_gc,
			arg1,
			arg2,
			arg3,
			arg4,
			arg5,
			arg6);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_DrawArcs(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1; XArc *arcs_arg1; int narcs_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!checkshortlist(6, arg1, (short**)&arcs_arg1, &narcs_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XArc[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XDrawArcs(self->gc_display, self->gc_drawable, self->gc_gc,
			arcs_arg1, narcs_arg1);
		jump_flag = 0;
	}
	PyMem_DEL(arcs_arg1);
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_DrawImageString(self, args)
	GCobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	PyObject *arg3; int nchars;
	if (!PyArg_ParseTuple(args, "iiS",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!(nchars = PyString_Size(arg3), 1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg3 should be char[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XDrawImageString(self->gc_display, self->gc_drawable, self->gc_gc,
			arg1,
			arg2,
			PyString_AsString(arg3), nchars);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_DrawLine(self, args)
	GCobject *self;
	PyObject *args;
{
	Position arg1;
	Position arg2;
	Position arg3;
	Position arg4;
	if (!PyArg_ParseTuple(args, "hhhh",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XDrawLine(self->gc_display, self->gc_drawable, self->gc_gc,
			arg1,
			arg2,
			arg3,
			arg4);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_DrawLines(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1; XPoint *pts_arg1; int npts_arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "Oi",
			&arg1,
			&arg2))
		return NULL;
	if (!checkshortlist(2, arg1, (short**)&pts_arg1, &npts_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XPoint[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XDrawLines(self->gc_display, self->gc_drawable, self->gc_gc,
			pts_arg1, npts_arg1,
			arg2);
		jump_flag = 0;
	}
	PyMem_DEL(pts_arg1);
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_DrawPoint(self, args)
	GCobject *self;
	PyObject *args;
{
	Position arg1;
	Position arg2;
	if (!PyArg_ParseTuple(args, "hh",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XDrawPoint(self->gc_display, self->gc_drawable, self->gc_gc,
			arg1,
			arg2);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_DrawPoints(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1; XPoint *pts_arg1; int npts_arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "Oi",
			&arg1,
			&arg2))
		return NULL;
	if (!checkshortlist(2, arg1, (short**)&pts_arg1, &npts_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XPoint[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XDrawPoints(self->gc_display, self->gc_drawable, self->gc_gc,
			pts_arg1, npts_arg1,
			arg2);
		jump_flag = 0;
	}
	PyMem_DEL(pts_arg1);
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_DrawRectangle(self, args)
	GCobject *self;
	PyObject *args;
{
	Position arg1;
	Position arg2;
	Dimension arg3;
	Dimension arg4;
	if (!PyArg_ParseTuple(args, "hhhh",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XDrawRectangle(self->gc_display, self->gc_drawable, self->gc_gc,
			arg1,
			arg2,
			arg3,
			arg4);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_DrawRectangles(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1; XRectangle *rects_arg1; int nrects_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!checkshortlist(4, arg1, (short**)&rects_arg1, &nrects_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XRectangle[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XDrawRectangles(self->gc_display, self->gc_drawable, self->gc_gc,
			rects_arg1, nrects_arg1);
		jump_flag = 0;
	}
	PyMem_DEL(rects_arg1);
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_DrawSegments(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1; XSegment *segs_arg1; int nsegs_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!checkshortlist(4, arg1, (short**)&segs_arg1, &nsegs_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XSegment[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XDrawSegments(self->gc_display, self->gc_drawable, self->gc_gc,
			segs_arg1, nsegs_arg1);
		jump_flag = 0;
	}
	PyMem_DEL(segs_arg1);
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_DrawString(self, args)
	GCobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	PyObject *arg3; int nchars;
	if (!PyArg_ParseTuple(args, "iiS",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!(nchars = PyString_Size(arg3), 1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg3 should be char[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XDrawString(self->gc_display, self->gc_drawable, self->gc_gc,
			arg1,
			arg2,
			PyString_AsString(arg3), nchars);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_FillArc(self, args)
	GCobject *self;
	PyObject *args;
{
	Position arg1;
	Position arg2;
	Dimension arg3;
	Dimension arg4;
	int arg5;
	int arg6;
	if (!PyArg_ParseTuple(args, "hhhhii",
			&arg1,
			&arg2,
			&arg3,
			&arg4,
			&arg5,
			&arg6))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XFillArc(self->gc_display, self->gc_drawable, self->gc_gc,
			arg1,
			arg2,
			arg3,
			arg4,
			arg5,
			arg6);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_FillArcs(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1; XArc *arcs_arg1; int narcs_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!checkshortlist(6, arg1, (short**)&arcs_arg1, &narcs_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XArc[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XFillArcs(self->gc_display, self->gc_drawable, self->gc_gc,
			arcs_arg1, narcs_arg1);
		jump_flag = 0;
	}
	PyMem_DEL(arcs_arg1);
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_FillPolygon(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1; XPoint *pts_arg1; int npts_arg1;
	int arg2;
	int arg3;
	if (!PyArg_ParseTuple(args, "Oii",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!checkshortlist(2, arg1, (short**)&pts_arg1, &npts_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XPoint[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XFillPolygon(self->gc_display, self->gc_drawable, self->gc_gc,
			pts_arg1, npts_arg1,
			arg2,
			arg3);
		jump_flag = 0;
	}
	PyMem_DEL(pts_arg1);
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_FillRectangle(self, args)
	GCobject *self;
	PyObject *args;
{
	Position arg1;
	Position arg2;
	Dimension arg3;
	Dimension arg4;
	if (!PyArg_ParseTuple(args, "hhhh",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XFillRectangle(self->gc_display, self->gc_drawable, self->gc_gc,
			arg1,
			arg2,
			arg3,
			arg4);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_FillRectangles(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1; XRectangle *rects_arg1; int nrects_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!checkshortlist(4, arg1, (short**)&rects_arg1, &nrects_arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XRectangle[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XFillRectangles(self->gc_display, self->gc_drawable, self->gc_gc,
			rects_arg1, nrects_arg1);
		jump_flag = 0;
	}
	PyMem_DEL(rects_arg1);
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_ChangeGC(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1; unsigned long mask; XGCValues values;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!PyGC_MakeValues(arg1, &mask, &values)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XGCValues#");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XChangeGC(self->gc_display, self->gc_gc,
			mask, &values);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetArcMode(self, args)
	GCobject *self;
	PyObject *args;
{
	int arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetArcMode(self->gc_display, self->gc_gc,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetBackground(self, args)
	GCobject *self;
	PyObject *args;
{
	unsigned long arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetBackground(self->gc_display, self->gc_gc,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetClipMask(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!is_optpixmapobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be optPixmap");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetClipMask(self->gc_display, self->gc_gc,
			getoptpixmapvalue(arg1));
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetClipOrigin(self, args)
	GCobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "ii",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetClipOrigin(self->gc_display, self->gc_gc,
			arg1,
			arg2);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetClipRectangles(self, args)
	GCobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	PyObject *arg3; XRectangle *rects_arg3; int nrects_arg3;
	int arg4;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "iiOi",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	if (!checkshortlist(4, arg3, (short**)&rects_arg3, &nrects_arg3)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg3 should be XRectangle[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetClipRectangles(self->gc_display, self->gc_gc,
			arg1,
			arg2,
			rects_arg3, nrects_arg3,
			arg4);
		jump_flag = 0;
	}
	PyMem_DEL(rects_arg3);
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetDashes(self, args)
	GCobject *self;
	PyObject *args;
{
	int arg1;
	PyObject *arg2; int nchars;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "iS",
			&arg1,
			&arg2))
		return NULL;
	if (!(nchars = PyString_Size(arg2), 1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be char[]");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetDashes(self->gc_display, self->gc_gc,
			arg1,
			PyString_AsString(arg2), nchars);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetFillRule(self, args)
	GCobject *self;
	PyObject *args;
{
	int arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetFillRule(self->gc_display, self->gc_gc,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetFillStyle(self, args)
	GCobject *self;
	PyObject *args;
{
	int arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetFillStyle(self->gc_display, self->gc_gc,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetFont(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!is_fontobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Font");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetFont(self->gc_display, self->gc_gc,
			getfontvalue(arg1));
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetForeground(self, args)
	GCobject *self;
	PyObject *args;
{
	unsigned long arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetForeground(self->gc_display, self->gc_gc,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetFunction(self, args)
	GCobject *self;
	PyObject *args;
{
	int arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetFunction(self->gc_display, self->gc_gc,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetGraphicsExposures(self, args)
	GCobject *self;
	PyObject *args;
{
	int arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetGraphicsExposures(self->gc_display, self->gc_gc,
			(Bool)arg1);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetLineAttributes(self, args)
	GCobject *self;
	PyObject *args;
{
	unsigned int arg1;
	int arg2;
	int arg3;
	int arg4;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "iiii",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetLineAttributes(self->gc_display, self->gc_gc,
			arg1,
			arg2,
			arg3,
			arg4);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetPlaneMask(self, args)
	GCobject *self;
	PyObject *args;
{
	unsigned long arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetPlaneMask(self->gc_display, self->gc_gc,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetRegion(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!is_regionobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Region");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetRegion(self->gc_display, self->gc_gc,
			getregionvalue(arg1));
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetState(self, args)
	GCobject *self;
	PyObject *args;
{
	unsigned long arg1;
	unsigned long arg2;
	int arg3;
	unsigned long arg4;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "llil",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetState(self->gc_display, self->gc_gc,
			arg1,
			arg2,
			arg3,
			arg4);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetStipple(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!is_pixmapobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Pixmap");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetStipple(self->gc_display, self->gc_gc,
			getpixmapvalue(arg1));
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetSubwindowMode(self, args)
	GCobject *self;
	PyObject *args;
{
	int arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetSubwindowMode(self->gc_display, self->gc_gc,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetTSOrigin(self, args)
	GCobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "ii",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetTSOrigin(self->gc_display, self->gc_gc,
			arg1,
			arg2);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_SetTile(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!is_pixmapobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Pixmap");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XSetTile(self->gc_display, self->gc_gc,
			getpixmapvalue(arg1));
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
PyGC_PutImage(self, args)
	GCobject *self;
	PyObject *args;
{
	PyObject *arg1;
	int arg2;
	int arg3;
	int arg4;
	int arg5;
	int arg6;
	int arg7;
	if (self->gc_widget) {
		PyErr_SetString(PyExc_TypeError, "can't modify shared GC");
		return NULL;
	}
	if (!PyArg_ParseTuple(args, "Oiiiiii",
			&arg1,
			&arg2,
			&arg3,
			&arg4,
			&arg5,
			&arg6,
			&arg7))
		return NULL;
	if (!is_imageobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XImage");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XPutImage(self->gc_display, self->gc_drawable, self->gc_gc,
			getimagevalue(arg1),
			arg2,
			arg3,
			arg4,
			arg5,
			arg6,
			arg7);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef PyGC_methods[] = {
	{"ChangeGC", (PyCFunction)PyGC_ChangeGC, 1},
	{"DrawArc", (PyCFunction)PyGC_DrawArc, 1},
	{"DrawArcs", (PyCFunction)PyGC_DrawArcs, 1},
	{"DrawImageString", (PyCFunction)PyGC_DrawImageString, 1},
	{"DrawLine", (PyCFunction)PyGC_DrawLine, 1},
	{"DrawLines", (PyCFunction)PyGC_DrawLines, 1},
	{"DrawPoint", (PyCFunction)PyGC_DrawPoint, 1},
	{"DrawPoints", (PyCFunction)PyGC_DrawPoints, 1},
	{"DrawRectangle", (PyCFunction)PyGC_DrawRectangle, 1},
	{"DrawRectangles", (PyCFunction)PyGC_DrawRectangles, 1},
	{"DrawSegments", (PyCFunction)PyGC_DrawSegments, 1},
	{"DrawString", (PyCFunction)PyGC_DrawString, 1},
	{"FillArc", (PyCFunction)PyGC_FillArc, 1},
	{"FillArcs", (PyCFunction)PyGC_FillArcs, 1},
	{"FillPolygon", (PyCFunction)PyGC_FillPolygon, 1},
	{"FillRectangle", (PyCFunction)PyGC_FillRectangle, 1},
	{"FillRectangles", (PyCFunction)PyGC_FillRectangles, 1},
	{"PutImage", (PyCFunction)PyGC_PutImage, 1},
	{"SetArcMode", (PyCFunction)PyGC_SetArcMode, 1},
	{"SetBackground", (PyCFunction)PyGC_SetBackground, 1},
	{"SetClipMask", (PyCFunction)PyGC_SetClipMask, 1},
	{"SetClipOrigin", (PyCFunction)PyGC_SetClipOrigin, 1},
	{"SetClipRectangles", (PyCFunction)PyGC_SetClipRectangles, 1},
	{"SetDashes", (PyCFunction)PyGC_SetDashes, 1},
	{"SetFillRule", (PyCFunction)PyGC_SetFillRule, 1},
	{"SetFillStyle", (PyCFunction)PyGC_SetFillStyle, 1},
	{"SetFont", (PyCFunction)PyGC_SetFont, 1},
	{"SetForeground", (PyCFunction)PyGC_SetForeground, 1},
	{"SetFunction", (PyCFunction)PyGC_SetFunction, 1},
	{"SetGraphicsExposures", (PyCFunction)PyGC_SetGraphicsExposures, 1},
	{"SetLineAttributes", (PyCFunction)PyGC_SetLineAttributes, 1},
	{"SetPlaneMask", (PyCFunction)PyGC_SetPlaneMask, 1},
	{"SetRegion", (PyCFunction)PyGC_SetRegion, 1},
	{"SetState", (PyCFunction)PyGC_SetState, 1},
	{"SetStipple", (PyCFunction)PyGC_SetStipple, 1},
	{"SetSubwindowMode", (PyCFunction)PyGC_SetSubwindowMode, 1},
	{"SetTSOrigin", (PyCFunction)PyGC_SetTSOrigin, 1},
	{"SetTile", (PyCFunction)PyGC_SetTile, 1},
	{0, 0} /* Sentinel */
};

