# -------------------------------------------------------------------------
# DESCRIPTION: 
#     A modified twoshell example which uses a hidden toplevel shell, and
#     creates 2 windows as popup siblings of the toplevel shell. This means
#     that both windows are treated equal, there is no main window.
#
# USAGE: 
#     > python twoshells2.py 
#

import sys, os, Xt, Xm, X

def main():
	# Create a hidden toplevel shell

	toplevel = Xt.Initialize('Twoshells2', [], sys.argv )
	wargs = {'mappedWhenManaged': X.FALSE,
		     'x': 500, 'y': 500, 'width': 1, 'height': 1}
	toplevel.SetValues( wargs )
	
	# Create 2 windows

	window1 = toplevel.CreatePopupShell('Window1', Xt.ApplicationShell, {})
	window2 = toplevel.CreatePopupShell('Window2', Xt.ApplicationShell, {})

	window1.SetValues( {'width': 200, 'height': 300} )
	window2.SetValues( {'width': 200, 'height': 300} )

	# Create an XmMainWindow widget as a child of each shell

	void = window1.CreateManagedWidget('mainwin', Xm.MainWindow, {})
	void = window2.CreateManagedWidget('mainwin', Xm.MainWindow, {})

	# Must popup the windows to make them visible

	window1.Popup(0)
	window2.Popup(0)

	# Realize the widgets and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()


main()
