import Xt, Xm, X, Xmd, Xcursorfont, sys

class Record:
	pass

def main():
	data = Record
	data.start_x = 0
	data.start_y = 0
	data.last_x = 0
	data.last_y = 0
	data.gc = None

	toplevel = Xt.Initialize('Rubberband', [], sys.argv)
	# Create a drawing surface, and add event handlers for
	# ButtonPress, ButtonRelease and MotionNotify events.
	canvas = toplevel.CreateManagedWidget('canvas', Xm.DrawingArea, {})
	canvas.AddEventHandler(X.ButtonPressMask, X.FALSE, start_rubber_band, data)
	canvas.AddEventHandler(X.ButtonMotionMask, X.FALSE, track_rubber_band, data)
	canvas.AddEventHandler(X.ButtonReleaseMask, X.FALSE, end_rubber_band, data)
	toplevel.RealizeWidget()

	# Establish a passive grab, for any button press.
	# Force the sprite to stay within the canvas window, and
	# change the sprite to a cross_hair.
	display = canvas.Display()
	cursor = display.CreateFontCursor(Xcursorfont.crosshair)
	canvas.GrabButton(X.AnyButton, X.AnyModifier, X.TRUE,
			  X.ButtonPressMask | X.ButtonMotionMask
			  	| X.ButtonReleaseMask,
			  X.GrabModeAsync, X.GrabModeAsync, canvas, cursor)

	# Create the GC used by the rubber banding functions.
	data.gc = xs_create_xor_gc(canvas)

	Xt.MainLoop()

def xs_create_xor_gc(w):
	# Get the colors used by the widget.
	values = w.GetValues(['foreground', 'background'])
	# Set the fg to the XOR of the fg and bg, so if it is
	# XOR'ed with bg, the result will be fg and vice versa.
	# This effectively achieves inverse video for the line.
	values['foreground'] = values['foreground'] ^ values['background']
	# Set the rubber band gc to use XOR mode and draw
	# a dashed line.
	values['line_style'] = X.LineOnOffDash
	values['function'] = X.GXxor
	return w.GetGC(values)

def start_rubber_band(w, data, event):
	data.last_x = data.start_x = event.x
	data.last_y = data.start_y = event.y
	data.gc.DrawLine(data.start_x, data.start_y, data.last_x, data.last_y)

def track_rubber_band(w, data, event):
	# Draw once to clear the previous line.
	data.gc.DrawLine(data.start_x, data.start_y, data.last_x, data.last_y)
	# Update the endpoints.
	data.last_x = event.x
	data.last_y = event.y
	# Draw the new line.
	data.gc.DrawLine(data.start_x, data.start_y, data.last_x, data.last_y)

def end_rubber_band(w, data, event):
	# Clear the current line and update the endpoint info.
	data.gc.DrawLine(data.start_x, data.start_y, data.last_x, data.last_y)
	data.last_x = event.x
	data.last_y = event.y

main()
