# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The menu example from D. Young's Xt/Motif book.
#
#     Demonstrates how a popup menus and menubars can be made with the
#     Xu.CreateMenu and Xu.CreateMenuBar functions.
#
# USAGE: 
#     > python menu4.py
#

import Xt, Xm
import X, Xmd    # constants for Xt & Xm
import Xu        # utility functions

# -------------------------------------------------------------------------
# Main function:

def main():	
	# Initialize and create a bulletinboard widget as the primary widget

	toplevel = Xt.Initialize('Menu', [], [] )
	toplevel.SetValues( {'width': 200, 'height': 100} )
	bboard   = toplevel.CreateManagedWidget('bboard', Xm.BulletinBoard, {})

	# Create a cascading popup menu

	submenu  = [ ('aSubMenu', None), \
		         ('itemA', DoItCB), ('itemB', DoItCB), ('itemC', DoItCB) ]
	mainmenu = [ ('aMenu', None), \
		         ('item1', DoItCB), ('item2', submenu), ('item3', DoItCB) ] 

	menu = Xu.CreateMenu( bboard, mainmenu )

	# Add an event handler to the bulletinboard widget 
	# to pop up the menu when a mouse is pressed.

	bboard.AddEventHandler(X.ButtonPressMask, X.FALSE, DisplayMenuEH, menu)

	# Create a menubar 

	pdmenu1 = [ ('m1A', DoItCB), ('m1B', DoItCB), ('m1C', DoItCB) ]
	pdmenu2 = [ ('m2A', DoItCB), ('m2B', DoItCB), ('m2C', DoItCB) ]
	pdmenus = [ ('Menu1', pdmenu1), ('Menu2', pdmenu2) ]

	menubar = Xu.CreateMenuBar( bboard, pdmenus )

	# Realize the widgets and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Callback functions:

def DisplayMenuEH( w, menu, event ):
	#
	# Popup the menu at the mouse position
	#
	menu.MenuPosition( event )
	menu.ManageChild()


def DoItCB( w, client_data, call_data ):
	print client_data, 'selected'



main()
