# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The menu example from D. Young's Xt/Motif book. 
#
#     Demonstrates how cascading popup menu's can be made.
#
# USAGE: 
#     > python menu2.py
#

import sys, os, Xt, Xm
import X, Xmd          # constants for Xt & Xm

# -------------------------------------------------------------------------
# Main function:

def main():	
	# Initialize and create a bulletinboard widget as the primary widget

	toplevel = Xt.Initialize('Menu', [], sys.argv )
	toplevel.SetValues( {'width': 100, 'height': 100} )
	bboard   = toplevel.CreateManagedWidget('bboard', Xm.BulletinBoard, {})

	# Create a popup menu. Add an event handler to the bulletinboard widget
	# to pop up the menu when a mouse is pressed.

	menu = bboard.CreatePopupMenu('menu', {}) 
	bboard.AddEventHandler(X.ButtonPressMask, X.FALSE, DisplayMenuCB, menu)

	# Add buttons, labels, and separators to the pane. Then register 
	# callbacks to define the action associated with each menu entry.

	void    = menu.CreateManagedWidget( 'Title', Xm.Label, {} )
	void    = menu.CreateManagedWidget( 'separator', Xm.Separator, {} )
	button1 = menu.CreateManagedWidget( 'Item1', Xm.PushButton, {} )
	button1.AddCallback( 'activateCallback', DoItCB, 'Item1' )

	# Add a cascade button to support a submenu, and add a 3'rd pushbutton

	button2 = menu.CreateManagedWidget( 'Item2', Xm.CascadeButton, {} )
	button3 = menu.CreateManagedWidget( 'Item3', Xm.PushButton, {} )
	button3.AddCallback( 'activateCallback', DoItCB, 'Item3' )

	# Create the cascading menu pane and attach it to the cascade button

	submenu = menu.CreatePulldownMenu('submenu', {} )
	button2.subMenuId = submenu

	# Add buttons to the submenu

	button2a = submenu.CreateManagedWidget( 'Item2a', Xm.PushButton, {} )
	button2a.AddCallback( 'activateCallback', DoItCB, 'Item2a' )

	button2b = submenu.CreateManagedWidget( 'Item2b', Xm.PushButton, {} )
	button2b.AddCallback( 'activateCallback', DoItCB, 'Item2b' )

	# Realize the widgets and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Callback functions:

def DisplayMenuCB( w, menu, event ):
	#
	# Popup the menu at the mouse position
	#
	menu.MenuPosition( event )
	menu.ManageChild()


def DoItCB( w, client_data, call_data ):
	print 'DoItCB called'



main()
