# -------------------------------------------------------------------------
# DESCRIPTION: 
#     Demonstrates the use of the XmList widget, and shows how a "C" struct
#     returned to a callback function can be unpacked with the "struct" module.
#
# USAGE: 
#     python listtest.py 
#

import sys, os, posix, Xt, Xm

# -------------------------------------------------------------------------
# Main function:

def main():	
	# Initialize & create a list widget

	toplevel = Xt.Initialize('Listtest', [], sys.argv )
	toplevel.SetValues( {'width': 200, 'height': 300} )
	list = toplevel.CreateScrolledList( 'list', {})
	
	# Make a list (the files in the current directory)

	l = posix.listdir('.')

	for i in range(len(l)):
		list.ListAddItem(l[i], i + 1)

	# Add a browse callback and give the list as argument (makes it easier
	# to find a selected item in the callback function)

	list.AddCallback( 'browseSelectionCallback', browseCB, l)

	# Realize the widget and enter the main loop

	list.ManageChild()
	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Make a class for holding the XmListCallbackStruct items

import struct # for unpacking the XmListCallbackStruct

LCBStuple = 'illiiliii', \
	  'reason', 'event', 'item', 'item_length', \
      'item_position', 'selected_items', \
	  'selected_item_count', 'selected_item_positions', \
	  'selection_type'

class XmListCallbackStruct:
	def __init__(self, call_data):
		fmt, names = LCBStuple[0], LCBStuple[1:]
		size = struct.calcsize(fmt)
		tuple = struct.unpack(fmt, call_data[:size])

		for i in range(len(tuple)):
			setattr(self, names[i], tuple[i])
		
def mklist_cbs(call_data):
	return XmListCallbackStruct(call_data)

# -------------------------------------------------------------------------
# BrowseCallback function:
#
# The "list" argument is the list given as argument in the "list.AddCallback" 
# statement. The "call_data" argument is a reference to an 
# XmListCallbackStruct. The items of this struct can be unpacked with the
# "mklist_cbs" function defined above.
		
def browseCB( w, list, call_data ):
	print 'browseCB called'
	lcbs = mklist_cbs(call_data)
	pos  = lcbs.item_position
	print 'item_position =', pos
	print 'item =', list[pos - 1]


main()
