# -------------------------------------------------------------------------
# DESCRIPTION: 
#     The formtest example from D. Young's Xt/Motif book. 
#
#     Demonstrates the use of the constraints of the XmForm widget. 
#
# USAGE: 
#     > python formtest.py
#

import sys, os, Xt, Xm
import Xmd     # constants for Xm

buttons = ['button1', 'button2', 'button3', 'button4',\
           'button5', 'button6', 'button7', 'button8']

# -------------------------------------------------------------------------
# Main function:

def main():	
	# Load resources from the file "Formtest2.resources"

	void = os.system('xrdb -nocpp -merge Formtest2.resources')

	# Initialize, and create the form widget

	toplevel = Xt.Initialize('Formtest2', [], sys.argv )
	form = toplevel.CreateManagedWidget('form', Xm.Form, {})

	# Create 3 children of the form widget

	button = []
	for i in range(3):
		button.append( form.CreateManagedWidget(buttons[i], Xm.PushButton,{}))

	# Realize the widget and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

main()
