# -------------------------------------------------------------------------
# DESCRIPTION: 
#     Demonstrates usage of the XEvent module (XMotionEvent).
#
# USAGE: 
#     > python event2.py
#

import Xt, Xm
import X, Xmd    # constants for Xt & Xm

# -------------------------------------------------------------------------
# Main function:

def main():	
	# Initialize and create a drawing-area widget

	toplevel = Xt.Initialize('Event2', [], [] )
	toplevel.SetValues( {'width': 300, 'height': 300} )
	canvas   = toplevel.CreateManagedWidget('canvas', Xm.DrawingArea, {})

	# Add an event handler for tracking the mouse position

	canvas.AddEventHandler(X.PointerMotionMask, X.FALSE, MotionEH, 0)

	# Realize the widgets and enter the main loop

	toplevel.RealizeWidget()
	Xt.MainLoop()

# -------------------------------------------------------------------------
# Event handler function:
#
# XMotionEvent has the following fields:
#     type         - the type of the event (X.MotionNotify)
#     serial       - number of the last event processed by the server
#     send_event   - indicates whether this event was sent by the X server
#                    or by another client. The value will be X.TRUE in the
#                    latter case.
#     display      - the ID of the X window display
#     window       - the ID of the event window
#     root         - the ID of the root window
#     subwindow    - the ID of the immediate child of the event window that 
#                    lies between the event window and source window (hmm..)
#     time         - time in milliseconds since the last server reset
#     x            - x pos relative to event window
#     x_root       - x pos relative to root window
#     y            - y pos relative to event window
#     y_root       - y pos relative to root window
#     is_hint      - indicates whether this event indicates a continuous 
#                    motion or a hint (whatever that is)
#     state        - contains a mask indicating which, if any, modifier keys
#                    were depressed when this event took place
#     same_screen  - in case multiple screen are used ?
# 

def MotionEH( w, client_data, event ):
	#
	# Print the mouse position
	#
	print 'pos      =', event.x, event.y
	print 'root pos =', event.x_root, event.y_root


main()
