import Xt
import string
import sys

flush = sys.stdout.flush

def table(top, m, name, bad):
	title = 'PERIODIC TABLE OF THE %s WIDGETS' % name
	print
	print title
	print '='*len(title)
	names = dir(m)
	wclasstype = type(top.Class())
	for name in names:
		wc = getattr(m, name)
		if type(wc) <> wclasstype: continue
		print
		print name
		print '-'*len(name)
		print
		flush()
		wc.InitializeWidgetClass()
		list = wc.GetResourceList()
		if name in bad:
			values = None
		else:
			args = {'width': 100, 'height': 100}
			w = top.CreateWidget('temp', wc, args)
			names = []
			for item in list: names.append(item[0])
			values = w.GetValues(names)
			w.DestroyWidget()
			del w
		formatlist(list, values)
	print

def formatlist(list, values):
	bytype = {}
	for i in range(len(list)):
		item = list[i]
		name, cls, type, size, offset, deftype, defval = item
		if values and values.has_key(name):
			value = values[name]
		else:
			value = None
		item = value, cls, type, size, offset, deftype, defval
		if not bytype.has_key(type):
			bytype[type] = byclass = {}
		else:
			byclass = bytype[type]
		if not byclass.has_key(cls):
			byclass[cls] = byname = {}
		else:
			byname = byclass[cls]
		byname[name] = item
	types = bytype.keys()
	types.sort()
	for type in types:
		print type, '==>',
		byclass = bytype[type]
		classes = byclass.keys()
		classes.sort()
		if len(classes) == 1:
			prefix = ''
		else:
			print
			prefix = '\t'
		for cls in classes:
			print prefix + cls, '-->',
			byname = byclass[cls]
			names = byname.keys()
			names.sort()
			if len(names) == 1:
				pref = ''
			else:
				print
				pref = '\t\t'
			flush()
			for name in names:
				item = byname[name]
				value = item[0]
				deftype, defval = item[-2:]
				if value is None:
					print '%s%s(%s:%s)' % \
					  (pref, name, deftype, `defval`)
				else:
					print '%s%s(%s:%s)=%s' % \
					  (pref, name, deftype,
					   `defval`, `value`)
				flush()

if sys.argv[1:]:
	top = Xt.Initialize('Table', [], sys.argv)
	for arg in sys.argv[1:]:
		if arg == 'xm':
			import Xm
			table(top, Xm, 'MOTIF', ['DialogShell', 'Display',
						 'DragContext', 'MenuShell',
						 'Text'])
		elif arg == 'xaw':
			import Xaw
			table(top, Xaw, 'ATHENA', ['Text', 'Dialog'])
		elif arg == 'xt':
			table(top, Xt, 'XT INTRINSIC', ['ApplicationShell',
			  'OverrideShell', 'Shell', 'TopLevelShell',
			  'TransientShell', 'VendorShell', 'WMShell'])
		elif arg == 'glx':
			import Glx
			table(top, Glx, 'GLX', [])
		elif arg == 'html':
			import HTML
			table(top, HTML, 'HTML', [])
		else:
			print 'Don\'t know how to print', `arg`
