import sys
import Xt
import Xm
import os
import X
from Xtdefs import *
from socket import *

def main():
	# Load necessary resources!
	sts = os.system('xrdb -nocpp -merge Tuner.resources')
	
	toplevel = Xt.Initialize('Tuner', [], sys.argv)
	form = toplevel.CreateManagedWidget('form', Xm.Form, {})
	
	labelCurrent = l(form, 'labelCurrent')
	station = lf(form, 'station')
	
	labelCurPlaying = l(form, 'labelCurPlaying')
	playing = lf(form, 'playing')
	
	labelCurTime = l(form, 'labelCurTime')
	time = lf(form, 'time')
	
	labelPlaylist = l(form, 'labelPlaylist')
	playlist = form.CreateScrolledList('playlist', {})
	playlist.AddCallback('browseSelectionCallback', cb_playlist, 0)
	playlist.ManageChild()

	labelTuner = l(form, 'labelTuner')
	tuner = form.CreateScrolledList('tuner', {})
	tuner.AddCallback('browseSelectionCallback', cb_tuner, 0)
	tuner.ManageChild()
	
	labelVolume = l(form, 'labelVolume')
	volume = form.CreateManagedWidget('volume', Xm.ScrollBar, {})
	volume.AddCallback('valueChangedCallback', cb_volume, 0)
	volume.AddCallback('dragCallback', cb_volume, 0)
	
	mute = pb(form, 'mute', cb_mute)
	revert = pb(form, 'revert', cb_revert)
	ok = pb(form, 'OK', cb_ok)
	anp = tb(form, 'anp', cb_anp)
	radio = pb(form, 'radio', cb_radio)

	mute.AddEventHandler(X.KeyPressMask, 0, cb_key, 'Hallo wereld')
	
	if 1:
		# Play a little with colors
		labelPlaylist.foreground = labelCurrent.foreground

	global sock
	sock = socket(AF_INET, SOCK_DGRAM)
	sock.bind(('', 54317))
	id = Xt.AddInput(sock.fileno(), XtInputReadMask, cb_input, 'socket')

	toplevel.RealizeWidget()
	Xt.MainLoop()

def l(parent, name):
	return parent.CreateManagedWidget(name, Xm.Label, {})

def lf(parent, name):
	wF = parent.CreateManagedWidget(name + 'F', Xm.Frame, {})
	return wF.CreateManagedWidget(name, Xm.Label, {})

def pb(parent, name, cb):
	b = parent.CreateManagedWidget(name, Xm.PushButton, {})
	b.AddCallback('activateCallback', cb, 0)
	return b

def tb(parent, name, cb):
	b = parent.CreateManagedWidget(name, Xm.ToggleButton, {})
	b.AddCallback('valueChangedCallback', cb, 0)
	return b

def cb_input(closure, fileno, id):
	print 'cb_input' + `(closure, fileno, id)`
	print 'recv() =', `sock.recv(2000)`

def cb_key(w, closure, cbdata):
	print 'cb_key' + `(w, closure, cbdata)`

def cb_volume(w, closure, cbdata):
	print 'volume =', w.value

def cb_mute(w, closure, cbdata):
	print 'cb_mute' + `(w, closure, cbdata)`

def cb_revert(w, closure, cbdata):
	print 'cb_revert' + `(w, closure, cbdata)`

def cb_anp(w, closure, cbdata):
	print 'cb_anp' + `(w, closure, cbdata)`

def cb_radio(w, closure, cbdata):
	print 'cb_radio' + `(w, closure, cbdata)`

def cb_ok(w, closure, cbdata):
	print 'OK'
	sys.exit(0)

def cb_playlist(w, closure, cbdata):
	print 'cb_playlist' + `(w, closure, cbdata)`

def cb_tuner(w, closure, cbdata):
	print 'cb_tuner' + `(w, closure, cbdata)`

main()
