import sys
import Xt
import Xm

import X
import Xmd

import xmmenus

class ControlPanel:

	def __init__(self, parent, args):
		self.makewidgets(parent, args)
		self.makeworkspace()
		self.x = self.y = 30

	def makeworkspace(self):
		self.wshell = Xt.CreateApplicationShell('wshell',
			  Xt.TopLevelShell, {})
		self.workspace = self.wshell.CreateBulletinBoard(
			  'workspace', {'width': 200, 'height': 500})
		self.workspace.ManageChild()
		self.wshell.RealizeWidget()

	def makewidgets(self, parent, args):
		#
		self.rc = parent.CreateRowColumn('rc', {})
		self.rc.orientation = Xmd.HORIZONTAL
		self.rc.ManageChild()
		#
		self.create = self.rc.CreatePushButton('create', {})
		self.create.labelString = 'Create:'
		self.create.AddCallback('activateCallback', self.cb_create, 0)
		self.create.ManageChild()
		#
		self.makewidgetmenu(self.rc, {})

	def makewidgetmenu(self, parent, args):
		wclasstype = type(parent.Class())
		list = []
		names = dir(Xm)
		for name in names:
			if name[-6:] == 'Gadget':
				continue
			object = getattr(Xm, name)
			if type(object) is not wclasstype:
				continue
			list.append((name + 'WidgetClass',
				  self.cb_widgetmenu_select))
		self.option, self.buttons = xmmenus.makeoption(
			  parent, 'widgetMenu', list, {})
		self.cb_widgetmenu_select(None, list[0][0], None)

	def cb_widgetmenu_select(self, widget, user_data, call_data):
		self.current_type = user_data

	def cb_create(self, *rest):
		classname = self.current_type
		if classname[-11:] == 'WidgetClass':
			classname = classname[:-11]
		print 'create', classname
		wclass = getattr(Xm, classname)
		args = {'x': self.x, 'y': self.y, 'width': 100, 'height': 50,
			  'orientation': Xmd.HORIZONTAL}
		new = self.workspace.CreateManagedWidget(classname,
			  wclass, args)
		new.AddEventHandler(X.ButtonPressMask, 0, self.eh_mouse, 'ho')
		new.AddEventHandler(X.ButtonMotionMask, 0, self.eh_drag, 'ho')
		self.y = self.y + 50

	def eh_mouse(self, widget, user_data, event):
		print 'mouse'
		self.xorigin = event.x_root
		self.yorigin = event.y_root
		self.xold = widget.x
		self.yold = widget.y

	def eh_drag(self, widget, user_data, event):
		dx = event.x_root - self.xorigin
		dy = event.y_root - self.yorigin
		# (dx, dy) is movement with respect to mouse down point
		x, y = max(0, self.xold + dx), max(0, self.yold + dy)
		widget.SetValues({'x': x, 'y': y})

def main():
	toplevel = Xt.Initialize('builder', [], sys.argv)
	cpanel = ControlPanel(toplevel, {})
	toplevel.RealizeWidget()
	Xt.MainLoop()

main()
