# Abstract base class for Audio sources.

# Every method defined here is part of the public interface.
# A concrete audio source class needn't derive from this class,
# as long as it implements the same interface.  Note that the way of
# creating an audio source object is not part of the interface.

Error = 'BaseAudioSource.Error'		# Exception for anything weird

class BaseAudioSource:

	# Close the instance
	def close(self): pass

	# Values returned here are examples only!

	# Return the sample format: 'signed', 'unsigned', 'ulaw', 'alaw', ...
	def getsampformat(self): return 'unsigned'

	# Return the sample width in bytes
	def getsampwidth(self): return 1

	# Return the number of bits per sample
	def getsampbits(self): return 8

	# Return the number of channels (e.g. 1 for mono, 2 for stereo)
	def getnchannels(self): return 1

	# Return the sampling rate in frames/second
	def getframerate(self): return 8000

	# Return the number of frames in the file, or -1 if unknown
	def getnframes(self): return 0

	# Return a useful set of parameters
	def getsourceparams(self):
		return (self.getsampformat(),
			self.getsampwidth(),
			self.getsampbits(),
			self.getnchannels(),
			self.getframerate(),
			self.getnframes())

	# Return at most n frames, starting at the current position;
	# update the current position accordingly.
	# Return '' at EOF
	def readframes(self, n): return ''

	# Positions are counted in frames, the first frame is 0

	# Rewind to the beginning (same as seek(0))
	def rewind(self): self.seek(0)

	# Seek to the specified position
	def seek(self, pos): pass

	# Return the current position
	def tell(self): return 0
