# AIFF/AIFC audio source (a slight extension of Sjoerd's aifc class).

# XXX This should be fixed by changing class Aifc_read.

from aifc import Error

def open(file, *args):
	if args:
		if args[1:]: raise TypeErrpr, 'too many args'
		mode = args[0]
	else:
		mode = 'r'
	if mode == 'r':
		return AIFCAudioSource(file)
	raise Error, 'open mode must be r'

def openfp(fp, *args):
	if args:
		if args[1:]: raise TypeErrpr, 'too many args'
		mode = args[0]
	else:
		mode = 'r'
	if mode == 'r':
		return AIFCAudioSource('<nameless>', fp)
	raise Error, 'openfp mode must be r'

from aifc import Aifc_read
from BaseAudioSource import BaseAudioSource, Error

# Patch up aifc's exception
import aifc
aifc.Error = Error

class AIFCAudioSource(Aifc_read, BaseAudioSource):

	def __init__(self, file, *args):
		if args:
			if args[1:]: raise TypeError, 'too many args'
			self = self.initfp(args[0])
		else:
			Aifc_read.__init__(self, file)

	def getsampformat(self): return 'linear'

	def getsampbits(self): return 8*self.getsampwidth()

	def seek(self, pos):
		pos = max(0, min(self.getnframes(), pos))
		self.setpos(pos)
