#include "Python.h"
#include "modsupport.h"
#include "widgetobject.h"

#include <X11/StringDefs.h>

#define extobject widgetobject
#define ob_ptr ob_widget
#define EXTPTR Widget
#define EXTNAME "Widget"
#define newextobject Xnewwidgetobject
#define ext_forget Xwidget_forget
#define getextvalue getwidgetvalue
#define Exttype Widgettype
#define ext_getattr widget_getattr
#define ext_setattr widget_setattr
#define EXT_INIT(xp)	((widgetobject *) xp)->ob_resdict = NULL

static PyObject *widget_getattr Py_PROTO((PyObject *, char *));
static int widget_setattr Py_PROTO((PyObject *, char *, PyObject *));

#include "extobject.h"

static PyObject *
widget_getattr(self, name)
	PyObject *self;
	char *name;
{
	register widgetobject *wp = (widgetobject *)self;
	PyObject *res;
	PyObject *value;
	PyObject *namev;
	Arg a[1];
	XtArgVal argvalue = 0;
	if (wp->ob_widget == NULL) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_RuntimeError, "widget already destroyed");
		return NULL;
	}
	res = default_ext_getattr(wp, name);
	if (res != NULL)
		return res;
	PyErr_Clear();
	namev = PyString_FromString(name);
	if (namev == NULL)
		return NULL;
	XtSetArg(a[0], name, &argvalue);
	XtGetValues(wp->ob_widget, a, 1);
	value = res_to_python(wp, namev, argvalue);
	Py_DECREF(namev);
	return value;
}

static int
widget_setattr(self, name, value)
	PyObject *self;
	char *name;
	PyObject *value;
{
	register widgetobject *wp = (widgetobject *)self;
	PyObject *namev;
	Arg a[2];
	int ok;
	WidgetClass wC;
	if (wp->ob_widget == NULL) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_RuntimeError, "widget already destroyed");
		return -1;
	}
	namev = PyString_FromString(name);
	if (namev == NULL)
		return -1;
	wC = XtClass(wp->ob_widget);
	a[0].name = name;
	ok = python_to_res(&wC, 1, wp->ob_widget,
			   namev, value, &a[0]);
	if (ok) {
		if (wp->ob_resdict == NULL)
			wp->ob_resdict = PyDict_New();
		if (wp->ob_resdict != NULL)
			PyDict_SetItem(wp->ob_resdict, namev, value);
	}
	Py_DECREF(namev);
	if (!ok)
		return -1;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtSetValues(wp->ob_widget, a, ok);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return -1; }
	return 0;
}

void
widget_destroy_callback(w, closure, call_data)
	Widget w;
	XtPointer closure;
	XtPointer call_data;
{
	PyObject *key;
	widgetobject *xp;
	jmp_buf save_jump_where;
	int save_jump_flag;

	if (extknown == NULL)
		return;
	key = PyInt_FromLong((long)w);
	if (key == NULL)
		return;
	xp = (widgetobject *)PyDict_GetItem(extknown, key);
	Py_DECREF(key);
	if (xp == NULL)
		return;

	/* we must save jump_flag and jump_where because __del__ methods
	   may be called from widget_forget which in turn may call functions
	   in the X extensions. */
	save_jump_flag = jump_flag;
	jump_flag = 0;
	if (save_jump_flag)
		memcpy((char *)save_jump_where,
		       (char *)jump_where, sizeof(save_jump_where));

	Py_XDECREF(xp->ob_resdict);
	xp->ob_resdict = NULL;
	/* make sure there is a reference left to the object after the
	   call to widget_forget so that we can nuke the widget
	   pointer safely.  */
	Py_INCREF(xp);
	(void) widget_forget(xp);
	xp->ob_widget = NULL;
	Py_DECREF(xp);

	if (save_jump_flag)
		memcpy((char *)jump_where,
		       (char *)save_jump_where, sizeof(jump_where));
	jump_flag = save_jump_flag;
}

static struct widgetchainlist {
	WidgetClass widgetClass;
	PyMethodChain *chain;
	struct widgetchainlist *next;
} *widgetchainliststart;

void
widgetchainlist(wc, chain)
	WidgetClass wc;
	PyMethodChain *chain;
{
	struct widgetchainlist *ptr;

	ptr = malloc(sizeof(struct widgetchainlist));
	if (ptr == NULL) {
		PyErr_NoMemory();
		return;
	}
	ptr->widgetClass = wc;
	ptr->chain = chain;
	ptr->next = widgetchainliststart;
	widgetchainliststart = ptr;
}

widgetobject *
newwidgetobject(ptr, chain, dict)
	Widget ptr;
	PyMethodChain *chain;
	PyObject *dict;
{
	widgetobject *result;
	struct widgetchainlist *p;

	if (ptr == NULL) {
		Py_XDECREF(dict);
		Py_INCREF(Py_None);
		return (widgetobject *) Py_None;
	}

	for (p = widgetchainliststart; p; p = p->next) {
		if (XtIsSubclass(ptr, p->widgetClass)) {
			chain = p->chain;
			break;
		}
	}

	result = Xnewwidgetobject(ptr, chain);
	if (dict) {
		Py_XDECREF(((widgetobject *) result)->ob_resdict);
		((widgetobject *) result)->ob_resdict = dict;
	}
	XtAddCallback(ptr, XtNdestroyCallback, widget_destroy_callback, NULL);
	if (PyX_toplevel == NULL) {
		Widget w;
		while ((w = XtParent(ptr)) != NULL)
			ptr = w;
		PyX_toplevel = ptr;
	}
	return result;
}

int
widget_forget(xp)
	PyObject *xp;
{
	forget_closures(xp);
	return Xwidget_forget(xp);
}
