static PyObject *convertSelectionProcString;
static PyObject *loseSelectionProcString;
static PyObject *selectionDoneProcString;

static Boolean
univ_convertSelectionProc(w, selection, target, type_return, value_return,
			  length_return, format_return)
	Widget w;
	Atom *selection;
	Atom *target;
	Atom *type_return;
	XtPointer *value_return;
	unsigned long *length_return;
	int *format_return;
{
	widgetobject *wobj = NULL;
	PyObject *cbfunc, *cbargs = NULL, *result = NULL;
	PyObject *value;

	wobj = newwidgetobject(w, &widget_methodchain, NULL);
	if (wobj == NULL)
		goto error;
	cbfunc = PyDict_GetItem(wobj->ob_resdict, convertSelectionProcString);
	if (cbfunc == NULL)
		goto error;
	cbargs = Py_BuildValue("(Oll)", wobj, *selection, *target);
	if (cbargs == NULL)
		goto error;
	Py_DECREF(wobj); wobj = NULL;
	result = call_object_save_jump("ConvertSelectionProc", cbfunc, cbargs);
	if (result == NULL)
		goto error;
	if (result == Py_None) {
		Py_DECREF(result);
		return 0;
	}
	if (!PyArg_ParseTuple(result, "lO!li", type_return, &PyString_Type,
			      &value, length_return, format_return))
		goto error;
	PyDict_SetItem(wobj->ob_resdict, cbargs, value);
	*value_return = (XtPointer) PyString_AsString(value);
	Py_DECREF(cbargs);
	Py_DECREF(result);
	return 1;

error:
	if (!jump_flag) {
		fprintf(stderr, "--- %s failed ---\n", "ConvertSelectionProc");
		PyErr_Print();
		fprintf(stderr, "---\n");
	}
	Py_XDECREF(wobj);
	Py_XDECREF(cbargs);
	Py_XDECREF(result);
}

static void
univ_selectionDoneProc(w, selection, target)
	Widget w;
	Atom *selection;
	Atom *target;
{
	widgetobject *wobj = NULL;
	PyObject *cbfunc, *cbargs = NULL, *result = NULL;

	wobj = newwidgetobject(w, &widget_methodchain, NULL);
	if (wobj == NULL)
		goto error;
	cbfunc = PyDict_GetItem(wobj->ob_resdict, selectionDoneProcString);
	if (cbfunc == NULL)
		goto error;
	cbargs = Py_BuildValue("(Oii)", wobj, *selection, *target);
	if (cbargs == NULL)
		goto error;
	if (cbfunc != Py_None) {
		result = call_object_save_jump("SelectionDoneProc", cbfunc, cbargs);
		if (result == NULL)
			goto error;
		Py_DECREF(result);
	}
	PyDict_DelItem(wobj->ob_resdict, cbargs);
	Py_DECREF(cbargs);
	return;

error:
	if (!jump_flag) {
		fprintf(stderr, "--- %s failed ---\n", "SelectionDoneProc");
		PyErr_Print();
		fprintf(stderr, "---\n");
	}
	Py_XDECREF(wobj);
	Py_XDECREF(cbargs);
	Py_XDECREF(result);
}

static void
univ_loseSelectionProc(w, selection)
	Widget w;
	Atom *selection;
{
	widgetobject *wobj = NULL;
	PyObject *cbfunc, *cbargs = NULL, *result = NULL;

	wobj = newwidgetobject(w, &widget_methodchain, NULL);
	if (wobj == NULL)
		goto error;
	cbfunc = PyDict_GetItem(wobj->ob_resdict, loseSelectionProcString);
	if (cbfunc == NULL)
		goto error;
	if (cbfunc != Py_None) {
		cbargs = Py_BuildValue("(Oi)", wobj, *selection);
		if (cbargs == NULL)
			goto error;
		result = call_object_save_jump("LoseSelectionProc", cbfunc, cbargs);
		Py_XDECREF(result);
		Py_DECREF(cbargs);
	}
	PyDict_DelItem(wobj->ob_resdict, convertSelectionProcString);
	PyDict_DelItem(wobj->ob_resdict, loseSelectionProcString);
	PyDict_DelItem(wobj->ob_resdict, selectionDoneProcString);
	Py_DECREF(wobj);
	return;

error:
	if (!jump_flag) {
		fprintf(stderr, "--- %s failed ---\n", "LoseSelectionProc");
		PyErr_Print();
		fprintf(stderr, "---\n");
	}
	Py_XDECREF(wobj);
	Py_XDECREF(cbargs);
	Py_XDECREF(result);
}

static PyObject *
widget_OwnSelection(self, args)
	widgetobject *self;
	PyObject *args;
{
	Atom selection;
	Time time;
	PyObject *convert_proc, *lose_selection, *done_proc;
	Boolean result;

	if (!PyArg_ParseTuple(args, "llOOO", &selection, &time, &convert_proc,
			      &lose_selection, &done_proc))
		return NULL;
	if (!PyCallable_Check(convert_proc) ||
	    (lose_selection != Py_None && !PyCallable_Check(lose_selection)) ||
	    (done_proc != Py_None && !PyCallable_Check(done_proc))) {
		PyErr_SetString(PyExc_TypeError,
				"argument not callable function");
		return NULL;
	}
	if (convertSelectionProcString == NULL) {
		convertSelectionProcString = PyString_FromString("*ConvertSelectionProc*");
		loseSelectionProcString = PyString_FromString("*LoseSelectionProc*");
		selectionDoneProcString = PyString_FromString("*SelectionDoneProc*");
	}
	PyDict_SetItem(self->ob_resdict, convertSelectionProcString,
		       convert_proc);
	PyDict_SetItem(self->ob_resdict, loseSelectionProcString,
		       lose_selection);
	PyDict_SetItem(self->ob_resdict, selectionDoneProcString, done_proc);
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtOwnSelection(self->ob_widget, selection, time,
					univ_convertSelectionProc,
					univ_loseSelectionProc,
					univ_selectionDoneProc);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long) result);
}

#if XtSpecificationRelease >= 6

static PyObject *
widget_GetSelectionParameters(self, args)
	widgetobject *self;
	PyObject *args;
{
	Atom selection;
	long request_id;
	Atom type;
	XtPointer value;
	unsigned long length;
	int format;
	PyObject *vobj, *result;

	if (!PyArg_ParseTuple(args, "ll", &selection, &request_id))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtGetSelectionParameters(self->ob_widget, selection,
					 (XtRequestId) request_id, &type,
					 &value, &length, &format);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	if (value != NULL) {
		vobj = PyString_FromStringAndSize(value, length * format / 8);
	} else {
		Py_INCREF(Py_None);
		vobj = Py_None;
	}
	result = Py_BuildValue("(iOii)", type, vobj, length, format);
	Py_DECREF(vobj);
	return result;
}

static PyObject *
widget_SetSelectionParameters(self, args)
	widgetobject *self;
	PyObject *args;
{
	Atom selection;
	Atom type;
	PyObject *value;
	unsigned long length;
	int format;

	if (!PyArg_ParseTuple(args, "llO!li", &selection, &type,
			      &PyString_Type, &value, &length, &format))
		return NULL;
	if (PyString_Size(value) != length * format / 8) {
		PyErr_SetString(PyExc_TypeError, "value inconsistent size");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtSetSelectionParameters(self->ob_widget, selection, type,
					 PyString_AsString(value), length,
					 format);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XtSpecificationRelease >= 6 */

static PyObject *
widget_GetSelectionRequest(self, args)
	widgetobject *self;
	PyObject *args;
{
	Atom selection;
	long request_id = 0;
	XSelectionRequestEvent *event;

	if (!PyArg_ParseTuple(args, "l|l", &selection, &request_id))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		event = XtGetSelectionRequest(self->ob_widget, selection,
					      (XtRequestId) request_id);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	return xev_new((XtPointer) event, 0, 1);
}

void
univ_selectionCallbackProc(w, client_data, selection, type, value, length, format)
	Widget w;
	XtPointer client_data;
	Atom *selection;
	Atom *type;
	XtPointer value;
	unsigned long *length;
	int *format;
{
	PyObject *cbfunc, *cbarg, *cbargs = NULL, *vobj = NULL, *result = NULL;
	widgetobject *wobj;

	wobj = newwidgetobject(w, &widget_methodchain, NULL);
	if (wobj == NULL)
		goto out;
	if (!PyArg_ParseTuple((PyObject *) client_data, "OO", &cbfunc, &cbarg))
		goto out;
	vobj = PyString_FromStringAndSize(value, *length * *format / 8);
	if (vobj == NULL)
		goto out;
	cbargs = Py_BuildValue("(OOiiOii)", wobj, cbarg, *selection, *type,
			       vobj, *length, *format);
	if (cbargs == NULL)
		goto out;
	result = call_object_save_jump("SelectionCallbackProc", cbfunc, cbargs);
out:
	Py_XDECREF(wobj);
	Py_XDECREF(vobj);
	Py_XDECREF(result);
	Py_XDECREF(cbargs);
}

static PyObject *
do_GetSelectionValue(func, self, args)
	void (*func) Py_PROTO((Widget, Atom, Atom, XtSelectionCallbackProc, XtPointer, Time));
	widgetobject *self;
	PyObject *args;
{
	Atom selection;
	Atom target;
	PyObject *callback;
	PyObject *client_data;
	PyObject *closure;
	Time time;

	if (!PyArg_ParseTuple(args, "llOOl", &selection, &target, &callback,
			      &client_data, &time))
		return NULL;
	if (!PyCallable_Check(callback)) {
		PyErr_SetString(PyExc_TypeError,
				"argument not callable function");
		return NULL;
	}
	closure = Py_BuildValue("(OO)", callback, client_data);
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		(*func)(self->ob_widget, selection, target,
			univ_selectionCallbackProc, (XtPointer) closure, time);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_GetSelectionValue(self, args)
	widgetobject *self;
	PyObject *args;
{
	return do_GetSelectionValue(XtGetSelectionValue, self, args);
}

static PyObject *
widget_GetSelectionValueIncremental(self, args)
	widgetobject *self;
	PyObject *args;
{
	return do_GetSelectionValue(XtGetSelectionValueIncremental,
				    self, args);
}

static PyObject *
do_GetSelectionValues(func, self, args)
	void (*func) Py_PROTO((Widget, Atom, Atom *, int, XtSelectionCallbackProc, XtPointer *, Time));
	widgetobject *self;
	PyObject *args;
{
	Atom selection;
	Atom *targets;
	int count;
	int i;
	PyObject *targetslist;
	PyObject *callback;
	PyObject *client_data;
	XtPointer *closures;
	Time time;

	if (!PyArg_ParseTuple(args, "lO!OO!l", &selection, &PyList_Type,
			      &targetslist, &callback, &PyList_Type,
			      &client_data, &time))
		return NULL;
	if (!PyCallable_Check(callback)) {
		PyErr_SetString(PyExc_TypeError,
				"argument not callable function");
		return NULL;
	}
	if (!checkintlist(targetslist, sizeof(Atom), &targets, &count))
		return NULL;
	if (PyList_Size(client_data) != count) {
		PyMem_DEL(targets);
		PyErr_SetString(PyExc_TypeError,
				"target list and closure list must have equal length");
		return NULL;
	}
	closures = PyMem_NEW(XtPointer, count);
	for (i = 0; i < count; i++) {
		closures[i] = (XtPointer) Py_BuildValue("(OO)", callback,
					PyList_GetItem(client_data, i));
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		(*func)(self->ob_widget, selection, targets, count,
			univ_selectionCallbackProc, closures, time);
		jump_flag = 0;
	}
	if (jump_flag) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_GetSelectionValues(self, args)
	widgetobject *self;
	PyObject *args;
{
	return do_GetSelectionValues(XtGetSelectionValues, self, args);
}

static PyObject *
widget_GetSelectionValuesIncremental(self, args)
	widgetobject *self;
	PyObject *args;
{
	return do_GetSelectionValues(XtGetSelectionValuesIncremental,
				     self, args);
}
