struct callback {
	char *name;
	int type;
	int offset;
};

#define NINDIR		2

typedef struct {
	PyObject_HEAD
	XtPointer event;
	int owner;
	int is_XEvent;
	struct callback *cb;
	PyObject *indir[NINDIR];
} X_Callbackobject;

extern PyTypeObject X_CallbackType;

PyObject *xev_new Py_PROTO((XtPointer ptr, int cbtype, int mkcopy));
void xev_destroy Py_PROTO((PyObject *));
int xev_gettype Py_PROTO((Widget, char *));
void xev_addfuncs Py_PROTO((
			PyObject *(*get)(X_Callbackobject *self,
					 struct callback *cbp,
					 char *),
			int (*set)(X_Callbackobject *self,
				   struct callback *cbp,
				   char *,
				   PyObject *value),
			int (*gettype)(Widget w, char *callback_name),
			struct callback *(*getcb)(XtPointer ptr, int type)));
PyObject *xev_ev Py_PROTO((X_Callbackobject *, XtPointer, int));

#define is_X_CallbackObject(x)	((x)->ob_type == &X_CallbackType && ((X_Callbackobject *)(x))->event != NULL)
#define is_XEvent(x)		(is_X_CallbackObject(x) && ((X_Callbackobject *)(x))->is_XEvent)

#ifdef PROVIDE_TYPES
#define XEVENT		0
#define CHAR		1
#define UCHAR		2
#define SHORT		3
#define INT		4
#define UINT		5
#define LONG		6
#define CHAR20		7
#define CHAR32		8
#define DISPLAY		9
#define WINDOW		10
#define DRAWABLE	11
#define COLORMAP	12
#endif
