
/* Methods for Xt objects */

#include <X11/Composite.h>

#include <X11/Constraint.h>

#include <X11/Shell.h>

#include <X11/Vendor.h>

static PyObject *
Xt_NextEvent(self, args)
	PyObject *self;
	PyObject *args;
{
	XEvent arg1;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtNextEvent(&arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return xev_new((XtPointer)&arg1, 0, 1);
}

static PyObject *
Xt_PeekEvent(self, args)
	PyObject *self;
	PyObject *args;
{
	Boolean result;
	XEvent arg1;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtPeekEvent(&arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	if (!result) {
		Py_INCREF(Py_None);
		return Py_None;
	}
	return xev_new((XtPointer)&arg1, 0, 1);
}

static PyObject *
Xt_DispatchEvent(self, args)
	PyObject *self;
	PyObject *args;
{
	Boolean result;
	PyObject *arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!is_XEvent(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Event*");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtDispatchEvent((XEvent*)((X_Callbackobject*)(arg1))->event);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
Xt_Pending(self, args)
	PyObject *self;
	PyObject *args;
{
	XtInputMask result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtPending();
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
Xt_ProcessEvent(self, args)
	PyObject *self;
	PyObject *args;
{
	XtInputMask arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtProcessEvent(arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
Xt_ParseTranslationTable(self, args)
	PyObject *self;
	PyObject *args;
{
	XtTranslations result;
	String arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtParseTranslationTable(arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *) newtranslationobject(result, NULL);
}

static PyObject *
Xt_SetSelectionTimeout(self, args)
	PyObject *self;
	PyObject *args;
{
	unsigned long arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtSetSelectionTimeout(arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
Xt_GetSelectionTimeout(self, args)
	PyObject *self;
	PyObject *args;
{
	unsigned long result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtGetSelectionTimeout();
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyMethodDef Xt_methods[] = {
	{"AddActionHook", (PyCFunction)Xt_AddActionHook, 1},
	{"AddActions", (PyCFunction)Xt_AddActions, 1},
	{"AddInput", (PyCFunction)Xt_AddInput, 1},
	{"AddTimeOut", (PyCFunction)Xt_AddTimeOut, 1},
	{"AddWorkProc", (PyCFunction)Xt_AddWorkProc, 1},
	{"AppInitialize", (PyCFunction)Xt_AppInitialize, 1},
	{"CreateApplicationShell", (PyCFunction)Xt_CreateApplicationShell, 1},
	{"DispatchEvent", (PyCFunction)Xt_DispatchEvent, 1},
	{"GetSelectionTimeout", (PyCFunction)Xt_GetSelectionTimeout, 1},
	{"Initialize", (PyCFunction)Xt_Initialize, 1},
	{"MainLoop", (PyCFunction)Xt_MainLoop, 1},
	{"ManageChildren", (PyCFunction)Xt_ManageChildren, 1},
	{"NextEvent", (PyCFunction)Xt_NextEvent, 1},
	{"OpenDisplay", (PyCFunction)Xt_OpenDisplay, 1},
	{"ParseTranslationTable", (PyCFunction)Xt_ParseTranslationTable, 1},
	{"PeekEvent", (PyCFunction)Xt_PeekEvent, 1},
	{"Pending", (PyCFunction)Xt_Pending, 1},
	{"ProcessEvent", (PyCFunction)Xt_ProcessEvent, 1},
	{"RemoveActionHook", (PyCFunction)Xt_RemoveActionHook, 1},
	{"RemoveInput", (PyCFunction)Xt_RemoveInput, 1},
	{"RemoveTimeOut", (PyCFunction)Xt_RemoveTimeOut, 1},
	{"RemoveWorkProc", (PyCFunction)Xt_RemoveWorkProc, 1},
	{"SetSelectionTimeout", (PyCFunction)Xt_SetSelectionTimeout, 1},
	{"ToolkitInitialize", (PyCFunction)Xt_ToolkitInitialize, 1},
	{0, 0} /* Sentinel */
};


/* Methods for wclass objects */

static PyMethodDef wclass_methods[] = {
	{"GetConstraintResourceList", (PyCFunction)wclass_GetConstraintResourceList, 1},
	{"GetResourceList", (PyCFunction)wclass_GetResourceList, 1},
	{"InitializeWidgetClass", (PyCFunction)wclass_InitializeWidgetClass, 1},
	{0, 0} /* Sentinel */
};


/* Methods for widget objects */

static PyObject *
widget_Parent(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtParent(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_ManageChild(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtManageChild(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_UnmanageChild(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtUnmanageChild(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_IsManaged(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtIsManaged(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
widget_RealizeWidget(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtRealizeWidget(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_UnrealizeWidget(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtUnrealizeWidget(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_IsRealized(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtIsRealized(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
widget_MapWidget(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtMapWidget(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_UnmapWidget(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtUnmapWidget(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_SetMappedWhenManaged(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtSetMappedWhenManaged(self->ob_widget,
			(Boolean)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_SetSensitive(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtSetSensitive(self->ob_widget,
			(Boolean)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_IsSensitive(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtIsSensitive(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
widget_Name(self, args)
	widgetobject *self;
	PyObject *args;
{
	char* result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtName(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyString_FromString(result);
}

static PyObject *
widget_CreateWidget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	PyObject *arg2;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg3, *dict; ArgList tmp_arg3; int nargs_arg3;
	if (!PyArg_ParseTuple(args, "sOO",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!is_wclassobject(arg2)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be WidgetClass");
		return NULL;
	}
	wClist[0] = getwclassvalue(arg2);
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg3, &tmp_arg3, &nargs_arg3))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg3 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtCreateWidget(arg1,
			getwclassvalue(arg2),
			w,
			tmp_arg3, nargs_arg3);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg3);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_CreateManagedWidget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	PyObject *arg2;
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg3, *dict; ArgList tmp_arg3; int nargs_arg3;
	if (!PyArg_ParseTuple(args, "sOO",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	if (!is_wclassobject(arg2)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be WidgetClass");
		return NULL;
	}
	wClist[0] = getwclassvalue(arg2);
	w = self->ob_widget;
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), NULL, arg3, &tmp_arg3, &nargs_arg3))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg3 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtCreateManagedWidget(arg1,
			getwclassvalue(arg2),
			w,
			tmp_arg3, nargs_arg3);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg3);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_DestroyWidget(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtDestroyWidget(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_Class(self, args)
	widgetobject *self;
	PyObject *args;
{
	WidgetClass result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtClass(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwclassobject(result, &wclass_methodchain);
}

static PyObject *
widget_Superclass(self, args)
	widgetobject *self;
	PyObject *args;
{
	WidgetClass result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtSuperclass(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwclassobject(result, &wclass_methodchain);
}

static PyObject *
widget_IsSubclass(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	PyObject *arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!is_wclassobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be WidgetClass");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtIsSubclass(self->ob_widget,
			getwclassvalue(arg1));
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
widget_IsComposite(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtIsComposite(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
widget_NameToWidget(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget result;
	String arg1;
	PyObject *dict = NULL;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtNameToWidget(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return (PyObject *)newwidgetobject(result, &widget_methodchain, dict);
}

static PyObject *
widget_SetValues(self, args)
	widgetobject *self;
	PyObject *args;
{
	Widget w;
	WidgetClass wClist[1];
	PyObject *arg1, *dict; ArgList tmp_arg1; int nargs_arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	w = self->ob_widget;
	wClist[0] = XtClass(w);
	if (!(dict = checkargdict(wClist, sizeof(wClist)/sizeof(wClist[0]), w, arg1, &tmp_arg1, &nargs_arg1))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be argdict");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtSetValues(w,
			tmp_arg1, nargs_arg1);
		jump_flag = 0;
	}
	PyMem_DEL(tmp_arg1);
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_RemoveCallback(self, args)
	widgetobject *self;
	PyObject *args;
{
	String arg1;
	PyObject *arg2, *cbfunc;
	PyObject *arg3, *cbarg;
	if (!PyArg_ParseTuple(args, "sOO",
			&arg1,
			&arg2,
			&arg3))
		return NULL;
	cbfunc = arg2;
	cbarg = make_closure(self, cbfunc, arg3, 1);
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtRemoveCallback(self->ob_widget,
			arg1,
			univ_callback,
			(XtPointer)cbarg);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_RemoveAllCallbacks(self, args)
	widgetobject *self;
	PyObject *args;
{
	String arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtRemoveAllCallbacks(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_CallCallbacks(self, args)
	widgetobject *self;
	PyObject *args;
{
	String arg1;
	PyObject *arg2;
	if (!PyArg_ParseTuple(args, "sO",
			&arg1,
			&arg2))
		return NULL;
	if (!(arg2 == Py_None || is_X_CallbackObject(arg2))) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg2 should be Callback");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtCallCallbacks(self->ob_widget,
			arg1,
			(arg2 == Py_None ? NULL : ((X_Callbackobject*)arg2)->event));
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_HasCallbacks(self, args)
	widgetobject *self;
	PyObject *args;
{
	Boolean result;
	String arg1;
	if (!PyArg_ParseTuple(args, "s",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtHasCallbacks(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
widget_AddEventHandler(self, args)
	widgetobject *self;
	PyObject *args;
{
	EventMask arg1;
	int arg2;
	PyObject *arg3, *cbfunc;
	PyObject *arg4, *cbarg;
	if (!PyArg_ParseTuple(args, "liOO",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	cbfunc = arg3;
	cbarg = make_closure(self, cbfunc, arg4, 0);
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtAddEventHandler(self->ob_widget,
			arg1,
			(Boolean)arg2,
			univ_eventhandler,
			(XtPointer)cbarg);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_RemoveEventHandler(self, args)
	widgetobject *self;
	PyObject *args;
{
	EventMask arg1;
	int arg2;
	PyObject *arg3, *cbfunc;
	PyObject *arg4, *cbarg;
	if (!PyArg_ParseTuple(args, "liOO",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	cbfunc = arg3;
	cbarg = make_closure(self, cbfunc, arg4, 0);
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtRemoveEventHandler(self->ob_widget,
			arg1,
			(Boolean)arg2,
			univ_eventhandler,
			(XtPointer)cbarg);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_AddRawEventHandler(self, args)
	widgetobject *self;
	PyObject *args;
{
	EventMask arg1;
	int arg2;
	PyObject *arg3, *cbfunc;
	PyObject *arg4, *cbarg;
	if (!PyArg_ParseTuple(args, "liOO",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	cbfunc = arg3;
	cbarg = make_closure(self, cbfunc, arg4, 0);
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtAddRawEventHandler(self->ob_widget,
			arg1,
			(Boolean)arg2,
			univ_eventhandler,
			(XtPointer)cbarg);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_RemoveRawEventHandler(self, args)
	widgetobject *self;
	PyObject *args;
{
	EventMask arg1;
	int arg2;
	PyObject *arg3, *cbfunc;
	PyObject *arg4, *cbarg;
	if (!PyArg_ParseTuple(args, "liOO",
			&arg1,
			&arg2,
			&arg3,
			&arg4))
		return NULL;
	cbfunc = arg3;
	cbarg = make_closure(self, cbfunc, arg4, 0);
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtRemoveRawEventHandler(self->ob_widget,
			arg1,
			(Boolean)arg2,
			univ_eventhandler,
			(XtPointer)cbarg);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_BuildEventMask(self, args)
	widgetobject *self;
	PyObject *args;
{
	EventMask result;
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		result = XtBuildEventMask(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	return PyInt_FromLong((long)result);
}

static PyObject *
widget_Popup(self, args)
	widgetobject *self;
	PyObject *args;
{
	XtGrabKind arg1;
	if (!PyArg_ParseTuple(args, "i",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtPopup(self->ob_widget,
			arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_Popdown(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtPopdown(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_InstallAccelerators(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!is_widgetobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Widget");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtInstallAccelerators(self->ob_widget,
			getwidgetvalue(arg1));
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_InstallAllAccelerators(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!is_widgetobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be Widget");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtInstallAllAccelerators(self->ob_widget,
			getwidgetvalue(arg1));
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_AddGrab(self, args)
	widgetobject *self;
	PyObject *args;
{
	int arg1;
	int arg2;
	if (!PyArg_ParseTuple(args, "ii",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtAddGrab(self->ob_widget,
			(Boolean)arg1,
			(Boolean)arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_RemoveGrab(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtRemoveGrab(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_AugmentTranslations(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!is_translationobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XtTranslations");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtAugmentTranslations(self->ob_widget,
			gettranslationvalue(arg1));
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_OverrideTranslations(self, args)
	widgetobject *self;
	PyObject *args;
{
	PyObject *arg1;
	if (!PyArg_ParseTuple(args, "O",
			&arg1))
		return NULL;
	if (!is_translationobject(arg1)) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError, "arg1 should be XtTranslations");
		return NULL;
	}
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtOverrideTranslations(self->ob_widget,
			gettranslationvalue(arg1));
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
widget_UninstallTranslations(self, args)
	widgetobject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtUninstallTranslations(self->ob_widget);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#if XtSpecificationRelease >= 6
static PyObject *
widget_CreateSelectionRequest(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtCreateSelectionRequest(self->ob_widget,
			(Atom)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XtSpecificationRelease >= 6 */
#if XtSpecificationRelease >= 6
static PyObject *
widget_SendSelectionRequest(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long arg1;
	Time arg2;
	if (!PyArg_ParseTuple(args, "ll",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtSendSelectionRequest(self->ob_widget,
			(Atom)arg1,
			arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XtSpecificationRelease >= 6 */
#if XtSpecificationRelease >= 6
static PyObject *
widget_CancelSelectionRequest(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long arg1;
	if (!PyArg_ParseTuple(args, "l",
			&arg1))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtCancelSelectionRequest(self->ob_widget,
			(Atom)arg1);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

#endif /* XtSpecificationRelease >= 6 */
static PyObject *
widget_DisownSelection(self, args)
	widgetobject *self;
	PyObject *args;
{
	unsigned long arg1;
	Time arg2;
	if (!PyArg_ParseTuple(args, "ll",
			&arg1,
			&arg2))
		return NULL;
	if (!setjmp(jump_where)) {
		jump_flag = 1;
		XtDisownSelection(self->ob_widget,
			(Atom)arg1,
			arg2);
		jump_flag = 0;
	}
	if (jump_flag || PyErr_Occurred()) { jump_flag = 0; return NULL; }
	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef compositewidget_methods[] = {
	{"GetChildren", (PyCFunction)widget_GetChildren, 1},
	{0, 0} /* Sentinel */
};
PyMethodChain compositewidget_methodchain = {
	compositewidget_methods,
	&widget_methodchain,
};

static PyMethodDef widget_methods[] = {
	{"AddCallback", (PyCFunction)widget_AddCallback, 1},
	{"AddEventHandler", (PyCFunction)widget_AddEventHandler, 1},
	{"AddGrab", (PyCFunction)widget_AddGrab, 1},
	{"AddRawEventHandler", (PyCFunction)widget_AddRawEventHandler, 1},
	{"AugmentTranslations", (PyCFunction)widget_AugmentTranslations, 1},
	{"BuildEventMask", (PyCFunction)widget_BuildEventMask, 1},
	{"CallCallbacks", (PyCFunction)widget_CallCallbacks, 1},
#if XtSpecificationRelease >= 6
	{"CancelSelectionRequest", (PyCFunction)widget_CancelSelectionRequest, 1},
#endif /* XtSpecificationRelease >= 6 */
	{"Class", (PyCFunction)widget_Class, 1},
	{"Convert", (PyCFunction)widget_Convert, 1},
	{"CreateGC", (PyCFunction)widget_CreateGC, 1},
	{"CreateManagedWidget", (PyCFunction)widget_CreateManagedWidget, 1},
	{"CreatePopupShell", (PyCFunction)widget_CreatePopupShell, 1},
#if XtSpecificationRelease >= 6
	{"CreateSelectionRequest", (PyCFunction)widget_CreateSelectionRequest, 1},
#endif /* XtSpecificationRelease >= 6 */
	{"CreateWidget", (PyCFunction)widget_CreateWidget, 1},
	{"DestroyWidget", (PyCFunction)widget_DestroyWidget, 1},
	{"DisownSelection", (PyCFunction)widget_DisownSelection, 1},
	{"GetGC", (PyCFunction)widget_GetGC, 1},
#if XtSpecificationRelease >= 6
	{"GetSelectionParameters", (PyCFunction)widget_GetSelectionParameters, 1},
#endif /* XtSpecificationRelease >= 6 */
	{"GetSelectionRequest", (PyCFunction)widget_GetSelectionRequest, 1},
	{"GetSelectionValue", (PyCFunction)widget_GetSelectionValue, 1},
	{"GetSelectionValueIncremental", (PyCFunction)widget_GetSelectionValueIncremental, 1},
	{"GetSelectionValues", (PyCFunction)widget_GetSelectionValues, 1},
	{"GetSelectionValuesIncremental", (PyCFunction)widget_GetSelectionValuesIncremental, 1},
	{"GetValues", (PyCFunction)widget_GetValues, 1},
	{"HasCallbacks", (PyCFunction)widget_HasCallbacks, 1},
	{"InstallAccelerators", (PyCFunction)widget_InstallAccelerators, 1},
	{"InstallAllAccelerators", (PyCFunction)widget_InstallAllAccelerators, 1},
	{"IsComposite", (PyCFunction)widget_IsComposite, 1},
	{"IsManaged", (PyCFunction)widget_IsManaged, 1},
	{"IsRealized", (PyCFunction)widget_IsRealized, 1},
	{"IsSensitive", (PyCFunction)widget_IsSensitive, 1},
	{"IsSubclass", (PyCFunction)widget_IsSubclass, 1},
	{"ListFonts", (PyCFunction)widget_ListFonts, 1},
	{"LoadQueryFont", (PyCFunction)widget_LoadQueryFont, 1},
	{"ManageChild", (PyCFunction)widget_ManageChild, 1},
	{"MapWidget", (PyCFunction)widget_MapWidget, 1},
	{"Name", (PyCFunction)widget_Name, 1},
	{"NameToWidget", (PyCFunction)widget_NameToWidget, 1},
	{"OverrideTranslations", (PyCFunction)widget_OverrideTranslations, 1},
	{"OwnSelection", (PyCFunction)widget_OwnSelection, 1},
	{"Parent", (PyCFunction)widget_Parent, 1},
	{"Popdown", (PyCFunction)widget_Popdown, 1},
	{"Popup", (PyCFunction)widget_Popup, 1},
	{"RealizeWidget", (PyCFunction)widget_RealizeWidget, 1},
	{"RemoveAllCallbacks", (PyCFunction)widget_RemoveAllCallbacks, 1},
	{"RemoveCallback", (PyCFunction)widget_RemoveCallback, 1},
	{"RemoveEventHandler", (PyCFunction)widget_RemoveEventHandler, 1},
	{"RemoveGrab", (PyCFunction)widget_RemoveGrab, 1},
	{"RemoveRawEventHandler", (PyCFunction)widget_RemoveRawEventHandler, 1},
#if XtSpecificationRelease >= 6
	{"SendSelectionRequest", (PyCFunction)widget_SendSelectionRequest, 1},
#endif /* XtSpecificationRelease >= 6 */
	{"SetMappedWhenManaged", (PyCFunction)widget_SetMappedWhenManaged, 1},
#if XtSpecificationRelease >= 6
	{"SetSelectionParameters", (PyCFunction)widget_SetSelectionParameters, 1},
#endif /* XtSpecificationRelease >= 6 */
	{"SetSensitive", (PyCFunction)widget_SetSensitive, 1},
	{"SetValues", (PyCFunction)widget_SetValues, 1},
	{"Superclass", (PyCFunction)widget_Superclass, 1},
	{"TranslateCoords", (PyCFunction)widget_TranslateCoords, 1},
	{"UninstallTranslations", (PyCFunction)widget_UninstallTranslations, 1},
	{"UnmanageChild", (PyCFunction)widget_UnmanageChild, 1},
	{"UnmapWidget", (PyCFunction)widget_UnmapWidget, 1},
	{"UnrealizeWidget", (PyCFunction)widget_UnrealizeWidget, 1},
	{0, 0} /* Sentinel */
};

static void
makewidgets(d)
	PyObject *d;
{
	PyDict_SetItemString(d, "ApplicationShell",
		(PyObject*)newwclassobject(applicationShellWidgetClass,
			&wclass_methodchain));
	PyDict_SetItemString(d, "Composite",
		(PyObject*)newwclassobject(compositeWidgetClass,
			&wclass_methodchain));
	PyDict_SetItemString(d, "Constraint",
		(PyObject*)newwclassobject(constraintWidgetClass,
			&wclass_methodchain));
	PyDict_SetItemString(d, "OverrideShell",
		(PyObject*)newwclassobject(overrideShellWidgetClass,
			&wclass_methodchain));
	PyDict_SetItemString(d, "Shell",
		(PyObject*)newwclassobject(shellWidgetClass,
			&wclass_methodchain));
	PyDict_SetItemString(d, "TopLevelShell",
		(PyObject*)newwclassobject(topLevelShellWidgetClass,
			&wclass_methodchain));
	PyDict_SetItemString(d, "TransientShell",
		(PyObject*)newwclassobject(transientShellWidgetClass,
			&wclass_methodchain));
	PyDict_SetItemString(d, "VendorShell",
		(PyObject*)newwclassobject(vendorShellWidgetClass,
			&wclass_methodchain));
	PyDict_SetItemString(d, "WMShell",
		(PyObject*)newwclassobject(wmShellWidgetClass,
			&wclass_methodchain));
	widgetchainlist(compositeWidgetClass, &compositewidget_methodchain);
}

