/***********************************************************
Copyright 1991, 1992, 1993 by Stichting Mathematisch Centrum,
Amsterdam, The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* Xlib module */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Xresource.h>

#undef Py_None
#undef Py_True
#undef Py_False

#include "Python.h"
#include "modsupport.h"

#include "widgetobject.h"
#include "Xlibmodule.h"
#include "regionobject.h"
#include "event.h"

PyObject *Xlib_Error; /* Exception raised for Xt-specific errors */

static PyObject *
Xlib_LookupString(self, args)
	PyObject *self;
	PyObject *args;
{
	KeySym keysym;
	PyObject *event;
	XKeyEvent *e;
	int event_length;
	int length;
	char buffer[512];
	PyObject *bufobj, *retobj;

	if (!PyArg_ParseTuple(args, "O", &event))
		return NULL;
	if (!is_XEvent(event)) {
		PyErr_BadArgument();
		return NULL;
	}
	e = (XKeyEvent *) ((X_Callbackobject *) event)->event;
	if (e->type != KeyPress && e->type != KeyRelease) {
		PyErr_BadArgument();
		return NULL;
	}
	length = XLookupString(e, buffer, sizeof(buffer), &keysym, NULL);
	bufobj = PyString_FromStringAndSize(buffer, length);
	retobj = Py_BuildValue("(Oi)", bufobj, keysym);
	Py_XDECREF(bufobj);
	return retobj;
}

#if XlibSpecificationRelease >= 6
static PyObject *
Xlib_InitThreads(self, args)
	PyObject *self;
	PyObject *args;
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	return PyInt_FromLong((long) XInitThreads());
}
#endif

static PyMethodDef Xlib_methods[] = {
	{"CreateRegion", Xlib_CreateRegion, 1},
	{"Event", Xlib_Event, 1},
#if XlibSpecificationRelease >= 6
	{"InitThreads", Xlib_InitThreads, 1},
#endif
	{"LookupString", Xlib_LookupString, 1},
	{"PolygonRegion", Xlib_PolygonRegion, 1},
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initxx) */

void
initXlib()
{
	PyObject *m, *d;
	m = Py_InitModule("Xlib", Xlib_methods);
	d = PyModule_GetDict (m);
	PyDict_SetItemString(d, "Error",
			     Xlib_Error = PyString_FromString("Xlib.Error"));
	PyDict_SetItemString(d, "SpecificationRelease",
			     PyInt_FromLong((long) XlibSpecificationRelease));
}
